#include "stdafx.h"
#include <algorithm>		// For binary_search.
#include "DynamicDraw.h"	// For IDS_ERR_XXX.
#include "UtilMisc.h"		// For FFGetCurrentTime().
//#include "UtilMath.h"		// For _wcstoi64.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilErr.h"		// For CFCDDFileException.
#include "DynamicDb.h"		// For g_pFileServer.
#include "DbLock.h"			// For FCDbReadLock.
#include "HiProject.h"		// For FCHiProject.
//#include "FoundDoc.h"		// For g_pDoc.
#include "HiForkTable.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLessBranch::operator ()
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiCmMjBoFiPkMiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEoEiKhCiCmNiImIiJlKiCmMiPiHiCmFiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjFlGiPjBiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iDhDiDiKiDeJiDgIiBhF_xHqqkZx_._xZkqqHx_iBhGiCmFiLoGjAnIiCoHiCoKiClNiDhAiBfLiDgHiClCiCmGiCmJiNlGiCkJiCoHjEoEiKhCiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfAiBeEiDhAiBfLiDgHiCmMjFlGiOjKjHpBiCkKjCfKiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfBiBeEiDhAiBfLiDgHjFlGiOjKjHpBiCmMjBoFiPkMjEoEiKhCiCmFiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_10.3.4 > 5.2
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_5.3.4 > 5.2
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
bool FCLessBranch::operator () (const pair<flint, WString>& v0, const pair<flint, WString>& v1) const
{
	// _xZkqqHx_jFkKiKpCiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjEoEiKhCiBeC_xHqqkZx_
	if (v0.first < v1.first) return true;
	if (v0.first > v1.first) return false;
	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCpAjEoEiKhCiBeC_xHqqkZx_
	WString wstr0 = v0.second;
	WString wstr1 = v1.second;
	while (!wstr0.IsEmpty() || !wstr1.IsEmpty())
	{
		// _xZkqqHx_iDhDiDiKiDeJiDgIiCnMiCmFiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		WString wstrTop0 = FFExtractUntil(wstr0, L'.');
		WString wstrTop1 = FFExtractUntil(wstr1, L'.');
		if (wstrTop0.GetLength() < wstrTop1.GetLength()) return true;
		if (wstrTop0.GetLength() > wstrTop1.GetLength()) return false;
		const int iCompare = wstrTop0.CompareNoCase(wstrTop1);
		if (iCompare < 0) return true;
		if (iCompare > 0) return false;
	}
	return false;
} // FCLessBranch::operator.

///////////////////////////////////////////////////////////////////////////
// FCHiForkTable_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FCHiForkTable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProject		:_xZkqqHx_jFmPjAjEiCpAiPiJiKpKiJlLiClHiCoJiClNiCnPiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iPiJiKpKiJlLiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocId			:_xZkqqHx_jFmPjAjEiCpAiPiJiKpKiJlLiClHiCoJiClNiCnPiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iPiJiKpKiJlLiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			pAutoLockRead	:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiClNiCnPiCmMiDiNiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_jDmHiCnNiNjOiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCHiForkTable::FCHiForkTable (const FCProject* pProject,
//						long lDocId,
//						const FCDbReadLock* pAutoLockRead)
//
//			:m_pProject(NULL),
//			m_lDocumentId(-1),
//			m_dwLockedFileOverwritedCount(DWORD(-1)),
//			m_dwLockedFileAppendedCount(DWORD(-1)),
//			m_bUpdated(TRUE),
//			m_fliSuperCmdFilePtr(0),
//			m_fliSuperIdxFilePtr(0),	// _xZkqqHx_jAgFiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLjCiGiCmMjFkKiKpCiImKjChFiBeC_xHqqkZx_
//			m_fliSuperSessionIndex(-1),
//			m_lSuperDocumentId(-1),
//			m_lLastTempId(0)			// _xZkqqHx_iJlMjBhKjFkKiKpCjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//{
//	if (pProject != NULL)
//		SetProjectAndDid(*pProject, lDocId);
//	if (pAutoLockRead != NULL)
//		UpdateData(*pAutoLockRead);
//} // FCHiForkTable::FCHiForkTable.
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FCHiForkTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTable::FCHiForkTable ()
{
	Clear();
} // FCHiForkTable::FCHiForkTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FCHiForkTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTable::FCHiForkTable (const FCDbGroup& dbGroup)
			:	BASE_CLASS()
{
	Clear();
	Set(dbGroup.GetGroupName().PushBack(FDHI_FORK_TABLE_ID));
} // FCHiForkTable::FCHiForkTable.
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::~FCHiForkTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTable::~FCHiForkTable ()
{
	Clear();
} // FCHiForkTable::~FCHiForkTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::operator = (const FCDbGroup& dbGroup)
{
	Clear();
	Set(dbGroup.GetGroupName().PushBack(FDHI_FORK_TABLE_ID));
} // FCHiForkTable::operator.

//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::SetProjectAndDid
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmFiIlFiCkEiDhGiDiNiDfHiDeGiDeOiDgHiCmGjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiForkTable::SetProjectAndDid (const FCProject& project, long lDocId)
//{
//	m_pProject = &project;
//	m_lDocumentId = lDocId;
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_bUpdated = TRUE;
//} // FCHiForkTable::SetFilePath.
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFilePath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBeCjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiOjOiCmNiLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiForkTable::GetFilePath () const
//{
//	return m_pProject->GetDocumentPath(m_lDocumentId, L".mdfk");
//} // FCHiForkTable::GetFilePath.
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::IsRealTableReplaced
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjChFiKlHiClDiCoKiClNiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiForkTable::IsRealTableReplaced () const
//{
//	return (m_guidTableGuid != g_pFileServer->GetLockedTableGuid(GetTableName()));
//} // FCHiForkTable::IsRealTableReplaced.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::IsRealTableRecordModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
// *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiForkTable::IsRealTableRecordModified () const
//{
//	return	(m_dwLockedDeleteIdentifier !=
//			 g_pFileServer->GetLockedDeleteIdentifier(GetTableName())) ||
//			(m_dwLockedAppendIdentifier !=
//			 g_pFileServer->GetLockedAppendIdentifier(GetTableName()));
//} // FCHiForkTable::IsRealTableRecordModified.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::UpdateData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	autoLockRead:_xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCnNjHhAiOkJjDkOiDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_CFCDDFileException,CFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiForkTable::UpdateData (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	if (!BASE_CLASS::UpdateData(readLock))
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
		return FALSE;
	} else
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
		UpdateHash();
		return TRUE;
	}
} // FCHiForkTable::UpdateData.

//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::UpdateFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	autoLockWrite	:_xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCmMiPjBiCkLiPgPiClFjHhAiOkJjDkOiDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiBfLiDhFiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_CFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiForkTable::UpdateFile (const FCWriteLockVar& autoLockWrite)
//{
//	ASSERT(FFGetFileExtension(autoLockWrite.GetFilePath()) == L".mdfk");
//	ASSERT(GetFileAtom() == autoLockWrite.GetFileAtom());
//
//	if (m_pProject == NULL) return FALSE;
//	if (!m_bUpdated) return FALSE;
//
//	ASSERT(autoLockWrite.IsLocked());
//	ASSERT(autoLockWrite.GetShareKind() == FCLockVar::LOCK_EXCLUSIVE);
//
//	//----- _xZkqqHx_iPjBiCkLiNjOiCnOiCnHiCkLiDgGiBfLiDfOiCpAiOoGjDlO_xHqqkZx_ -----
//	WString wstrData;
////	WString strLine;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData += FFFormatString(L"FORM %s\r\n", FORK_FILE_KIND);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData += FFFormatString(L"VERS %s\r\n", FCHeaderInf::GetStcFileVersionString());
//	// _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpC_xHqqkZx_ID_xZkqqHx_iCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData += FFFormatString(L"TPID %ld\r\n", m_lLastTempId);
//	// _xZkqqHx_jAgFiDhEiDeAiDeDiDiLiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData += FFFormatString(	L"SUPF %I64d %I64d %I64d %ld\r\n",
//								m_fliSuperSessionIndex,
//								m_fliSuperCmdFilePtr, 
//								m_fliSuperIdxFilePtr,
//								m_lSuperDocumentId);
//	// _xZkqqHx_iOhBjFkKiKpCiDhEiDeAiDeDiDiLiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	FCIdxToForkInfoMmap::const_iterator iF;
//	for (iF = m_mmpForkList.begin(); iF != m_mmpForkList.end(); iF++)
//	{
//		wstrData += FFFormatString(	L"FORK %I64d %I64d %I64d %ld\r\n",
//									(*iF).first,
//									(*iF).second.m_fliCommandFilePtr,
//									(*iF).second.m_fliSessionIndex,
//									(*iF).second.m_lDocumentId);
//	}
//
////----- 05.08.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	FCIdxToTimeLabelInfoMmap::const_iterator iTi;
//	for (iTi = m_mmpTimeLabelList.begin(); iTi != m_mmpTimeLabelList.end(); iTi++)
//	{
//		WString wstrLabel = (*iTi).second.m_wstrLabel;
//		wstrLabel.Replace(L"\r", L"\\r");
//		wstrLabel.Replace(L"\n", L"\\n");
//		wstrData += FFFormatString(	L"TLBL %I64d %ld %lu %f %f %I64u %s %s\r\n",
//									(*iTi).first,						// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
//									(*iTi).second.m_lTimeLabelId,		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//									(*iTi).second.m_stid,				// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//									(*iTi).second.m_mmpt.x,				// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
//									(*iTi).second.m_mmpt.y,				// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
//									(*iTi).second.m_fdstCreateTime,		// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
//									FFGuidToString((*iTi).second.m_guidUserId).c_str(),	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//									wstrLabel.c_str());					// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
//	}
////----- 05.08.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	FCIdxToHiForkTagInfoMap::const_iterator iL;
//	for (iL = m_mpSessionToHiTagIndex.begin(); iL != m_mpSessionToHiTagIndex.end(); iL++)
//	{
//		WString wstrTitle = (*iL).second.m_wstrTitle;
//		wstrTitle.Replace(L"\r", L"\\r");
//		wstrTitle.Replace(L"\n", L"\\n");
//		WString wstrComment = (*iL).second.m_wstrComment;
//		wstrComment.Replace(L"\r", L"\\r");
//		wstrComment.Replace(L"\n", L"\\n");
//		WString wstrTmp;
//		FFAppendString(wstrTmp, wstrTitle);
//		FFAppendString(wstrTmp, wstrComment);
//		wstrData += FFFormatString(	L"HTAG %I64d %I64u %f %s %s\r\n",
//									(*iL).first,
//									(*iL).second.m_fdstCreateTime,
//									(*iL).second.m_dHtreeScore,
//									FFGuidToString((*iL).second.m_guidUserId).c_str(),
//									wstrTmp.c_str());
//	}
//	// _xZkqqHx_iPeJjCfLiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData += L"ENDF\r\n";
//	// CRC_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
//	const WORD wCRC = FFCalcCRC(sizeof(wchar_t) * wstrData.GetLength(), &wstrData.at(0));
//	// CRC_xZkqqHx_iCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	wstrData.insert(0, FFFormatString(L"CRCV %hu\r\n", wCRC));
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFnLjBlGiBeC_xHqqkZx_
//	FFHiSaveTextFile(wstrData.c_str(), GetFileAtom(),
//					&m_dwLockedDeleteIdentifier,
//					&m_dwLockedAppendIdentifier);
//
//	m_bUpdated = FALSE;
//	return TRUE;
//} // FCHiForkTable::UpdateFile.
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::Clear ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Clear();
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jDoAjFjEiPoOjFpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_guidTableGuid = GUID_NULL;				// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = DWORD(-1);		// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwLockedAppendIdentifier = DWORD(-1);		// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	m_dwSuperInfoIndex = DWORD(-1);				// _xZkqqHx_iPoDiImKjHjKjHpAiPoOjFpBiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mmpSessionToForkIndex.clear();			// _xZkqqHx_jFkKiKpCjHjKjHpAiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mmpSessionToTimeLabelIndex.clear();		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpSessionToHiTagIndex.clear();			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
} // FCHiForkTable::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::SetSuperInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAgFiCmMjHjKjHpAiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliCmdFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAiCkKjFkKjHkDiClFiClNiBeBjAgFiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			lSuperDocId	:_xZkqqHx_jAgFiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::SetSuperInfo (	flint fliSessionIndex,
									long lSuperDocId)
{
	// _xZkqqHx_iKpJjBlGiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (m_dwSuperInfoIndex != DWORD(-1))
		DeleteRecord(m_dwSuperInfoIndex);
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	vDataBuff << BYTE(TYPE_SUPER_INFO) << lSuperDocId;
	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::SetSuperInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetSuperInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAgFiCmMjHjKjHpAiPoOjFpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliCmdFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAiCkKjFkKjHkDiClFiClNiBeBjAgFiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			lSuperDocId	:_xZkqqHx_jAgFiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::GetSuperInfo (	flint* fliSessionIndex,
									long* lSuperDocId)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	flint fliPrimaryId;
	BYTEVector vDataBuff;
	GetRecord(fliPrimaryId, &vDataBuff, m_dwSuperInfoIndex);
	if (fliSessionIndex != NULL)
		*fliSessionIndex = fliPrimaryId;
	if (lSuperDocId != NULL)
	{
		const BYTE* pData = &vDataBuff[0];
		// _xZkqqHx_iDfOiDeDiDhGiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		FFSkipData((BYTE*)NULL, pData);
		FFReadData(*lSuperDocId, pData);
	}
} // FCHiForkTable::GetSuperInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::AppendFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCmMiPoOjFpBiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjFkKiKpCiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjFkKiKpCiDhEiDeAiDeDiDiLiOjOiKnEiBeC_xHqqkZx_
 *			fliCmdFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjFkKiKpCiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			fliIdxFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjFkKiKpCiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jFkKiKpCiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkKiKpCiDiKiDfIiDgHiCkKiBeBiDhEiDeAiDeDiDiLiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFmAiCnEiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::AppendFork (flint fliSessionIndex,
								long lDocId)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	vDataBuff << BYTE(TYPE_FORK) << lDocId;
	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::AppendFork.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveFork
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCmMiPoOjFpBiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jGjFiPmBiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNjFkKiKpCiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeCjHjKjHpAiCkKiMkJiCmCiCkJiCoHiCmIiCkJiCmBiClN_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint FCHiForkTable::RemoveFork (long lDocId)
//{
//	FCForkConstIterator iFork = FindForkByDocumentId(lDocId);
//	if (iFork.IsEnd())
//		return -1;
//	const flint fliSessionIndex = iFork.GetSessionIndex();
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	DeleteRecord(iFork.GetRecordIndex());
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//	return fliSessionIndex;
//} // FCHiForkTable::RemoveFork.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::SearchPath2
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAiDhEiDeAiDeDiDiLiCmMiImKjChFiCmMjFjEjFgJiDeDiDiBiBfLiDfHiCpAjDlOiCoJiClNiCnPiCmJiBeB_xHqqkZx_
// *			_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiCmGjHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiInKjDkOiMlDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstSessionTimeSpot:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCmM_xHqqkZx_
// *						_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
// *			fliSessionIndexSpot:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCmM_xHqqkZx_
// *						_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			fliSessionIndex:_xZkqqHx_iMjPiNpFiClHiCoJjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwDistMin	:_xZkqqHx_iMjPiNpFiCmMiKoOiPiAiCmGiCmIiCoJiBeBiDfIiDhMiDgCiDgHiCmGjGnKjDeJiCnMiCmFiCmMiLjHjHkDiCmMiNmFjCoBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiImKjChFiCkJiCoHiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_fliCmdPtrSpot = FLINT_MAX,
// *			fliSessionIndexSpot = FLINT_MAX _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	fliSessionIndex_xZkqqHx_iCmJiNmFiCoAiLnPiCkCiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCpAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiCmGiBeBiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint FCHiForkTable::SearchPath2 (	flint* fliSessionIndexSpot,
//									flint fliSessionIndex,
//									flint fliDistMin)
//{
//	//----- _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCmMiOgOjDfPiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCpAiMjPiNpF_xHqqkZx_ -----
//	FCForkConstIterator iFork;
//	for (iFork = GetFirstFork(); !iFork.IsEnd(); iFork++)
//	{
//		// _xZkqqHx_iJlMjAnNiCmMjHjKjHpAjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (iFork.GetIsTemporary()) continue;
//		// _xZkqqHx_iLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
//		flint fliDist = (iFork.GetSessionIndex() < fliSessionIndex) ?
//							fliSessionIndex - iFork.GetSessionIndex() :
//							iFork.GetSessionIndex() - fliSessionIndex;
//		// _xZkqqHx_iNmFiCoAiLnPiCkCiLjHjHkDiCmIiCoHiCmOiBeBiNfIjAfGiBeC_xHqqkZx_
//		if (fliDist < fliDistMin)
//		{
//			fliDistMin = fliDist;
//			if (fliSessionIndexSpot != NULL)
//				*fliSessionIndexSpot = iFork.GetSessionIndex();
//		}
//	}
//	return fliDistMin;
//} // FCHiForkTable::SearchPath2.
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::AppendTempFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiCmMjHjKjHpAjFkKiKpCiPoOjFpBiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjFkKiKpCiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCmM_xHqqkZx_
 *							 _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliCmdFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjFkKiKpCiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			fliIdxFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIjFkKiKpCiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiCmMiClDiCoKiClNiJlMjBhKjFkKiKpCjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iJlMjBhKjFkKiKpCjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmNiBeBjFiJiCmMjCgMiCpAiOjNiCmCiBeCjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmGiClFiCmEiCmN_xHqqkZx_
 *			_xZkqqHx_iOgHiCkGiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCHiForkTable::AppendTempFork (flint fliSessionIndex)
{
	const GUID guidTempGuid = FFCreateGuid();
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	vDataBuff << BYTE(TYPE_FORK) << long(-1) << guidTempGuid;
	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
	return guidTempGuid;
} // FCHiForkTable::AppendTempFork.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveTempFork
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCmMiPoOjFpBiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jGjFiPmBiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNjFkKiKpCiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeCjHjKjHpAiCkKiMkJiCmCiCkJiCoHiCmIiCkJiCmBiClN_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint FCHiForkTable::RemoveTempFork (const GUID& guidTempGuid)
//{
//	FCForkConstIterator iFork;
//	for (iFork = GetFirstFork(); !iFork.IsEnd(); iFork++)
//	{
//		if (iFork.GetIsTemporary() && iFork.GetTempGuid() == guidTempGuid)
//			break;
//	}
//	if (iFork.IsEnd())
//		return -1;
//	const flint fliSessionIndex = iFork.GetSessionIndex();
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	DeleteRecord(iFork.GetRecordIndex());
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//	return fliSessionIndex;
//} // FCHiForkTable::RemoveTempFork.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveAllTempFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiJlMjAnNjHjKjHpAjFkKiKpCiPoOjFpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::RemoveAllTempFork ()
{
	DWORDSet stIndex;
	FCForkConstIterator iFork;
	for (iFork = GetFirstFork(); !iFork.IsEnd(); iFork++)
	{
		if (iFork.GetIsTemporary())
			stIndex.insert(iFork.GetRecordIndex());
	}
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!stIndex.empty())
		DeleteRecords(stIndex);
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::RemoveAllTempFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetTimeLabelList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::GetTimeLabelList (FCIdxToTimeLabelInfoMmap& mmpSessionToTimeLabel)
{
	FCTimeLabelConstIterator iTimeLabel;
	for (iTimeLabel = GetFirstTimeLabel(); !iTimeLabel.IsEnd(); iTimeLabel++)
	{
		FCTimeLabelInfo timeLabelInfo;
		iTimeLabel.GetValue(&timeLabelInfo.m_lTimeLabelId,		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&timeLabelInfo.m_stid,				// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&timeLabelInfo.m_mmpt,				// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
							&timeLabelInfo.m_fdstCreateTime,	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
							&timeLabelInfo.m_guidUserId,		// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&timeLabelInfo.m_wstrLabel);		// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
		mmpSessionToTimeLabel.insert(make_pair(iTimeLabel.GetSessionIndex(), timeLabelInfo));
	}
} // FCHiForkTable::GetTimeLabelList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetHiForkTagList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::GetHiForkTagList (FCIdxToHiForkTagInfoMap& mpSessionToHiTag)
{
	FCHiForkTagConstIterator iHiTag;
	for (iHiTag = GetFirstHiForkTag(); !iHiTag.IsEnd(); iHiTag++)
	{
		FCHiForkTagInfo hiTagInfo;
		iHiTag.GetValue(&hiTagInfo.m_fdstCreateTime,
						&hiTagInfo.m_dHtreeScore,
						&hiTagInfo.m_guidUserId,
						&hiTagInfo.m_wstrTitle,
						&hiTagInfo.m_wstrComment);
		mpSessionToHiTag.insert(make_pair(iHiTag.GetSessionIndex(), hiTagInfo));
	}
} // FCHiForkTable::GetHiForkTagList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFreeTimeLabelId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiForkTable::GetFreeTimeLabelId ()
{
	// _xZkqqHx_iOgHjHhAjCiGiCmMiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	longSet stUsedId;
	FCTimeLabelConstIterator iTimeLabel;
	for (iTimeLabel = GetFirstTimeLabel(); !iTimeLabel.IsEnd(); iTimeLabel++)
		stUsedId.insert(iTimeLabel.GetTimeLabelId());
	// lFreeId_xZkqqHx_iCkKjGkCiOgHjHhAiCmMiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
	long lFreeId;
	for (lFreeId = 0; stUsedId.erase(lFreeId) == 1; lFreeId++);
	return lFreeId;
} // FCHiForkTable::GetFreeTimeLabelId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::AppendTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTimeLabelId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stid			:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt			:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpLabel		:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDfCiDjDiDgFiDjDiDgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::AppendTimeLabel (	flint fliSessionIndex,
										long lTimeLabelId,
										SheetID stid,
										const DBLPoint& mmpt,
										FDSECTIME fdstCreateTime,
										const GUID& guidUserId,
										const wchar_t* wcpLabel)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	vDataBuff << BYTE(TYPE_TIME_LABEL) << lTimeLabelId << stid << mmpt << fdstCreateTime << guidUserId << WString(wcpLabel);
	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::AppendTimeLabel.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMjDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTimeLabelId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiForkTable::RemoveTimeLabel (long lTimeLabelId)
//{
//	FCTimeLabelConstIterator iTimeLabel = FindTimeLabelById(lTimeLabelId);
//	if (iTimeLabel.IsEnd())
//		return;
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	DeleteRecord(iTimeLabel.GetRecordIndex());
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//} // FCHiForkTable::RemoveTimeLabel.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::AppendTempTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiCmMiOjOiKnEiDiJiDhIiDiLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iJlMjAnNiCmMiOjOiKnEiDiJiDhIiDiLiCmMjFkKiKpCiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiClDiCoKiClNiJlMjBhKiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iJlMjBhKiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCmNiBeBjFiJiCmMjCgMiCpAiOjNiCmCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//GUID FCHiForkTable::AppendTempTimeLabel (flint fliSessionIndex)
//{
//	const GUID guidTempGuid = FFCreateGuid();
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
//	BYTEVector vDataBuff;
//	vDataBuff << BYTE(TYPE_TIME_LABEL) << long(-1) << SheetID(0) << DBLPoint() << FDSECTIME(0) << guidTempGuid << WString();
//	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//	return guidTempGuid;
//} // FCHiForkTable::AppendTempTimeLabel.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveAllTempTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiForkTable::RemoveAllTempTimeLabel ()
//{
//	DWORDSet stIndex;
//	FCTimeLabelConstIterator iTimeLabel;
//	for (iTimeLabel = GetFirstTimeLabel(); !iTimeLabel.IsEnd(); iTimeLabel++)
//	{
//		if (iTimeLabel.GetIsTemporary())
//			stIndex.insert(iTimeLabel.GetRecordIndex());
//	}
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	if (!stIndex.empty())
//		DeleteRecords(stIndex);
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//} // FCHiForkTable::RemoveAllTempTimeLabel.
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveAfterSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiImIiNhOiCmMjHjKjHpAjFkKiKpCiPoOjFpBiCmGjHjKjHpAjFkKiKpCiDfOiDePiCmM_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndexX:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiChHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsRemoveForkOnX:_xZkqqHx_iImKjChFiChHiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCmGjFkKiKpCiDfOiDePiCpAjGjFiPmBiCmMjBmOiPnLiCmJ_xHqqkZx_
 *							 _xZkqqHx_iKnMiCnPiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsRemoveTimeLabelOnX
 *							:_xZkqqHx_iImKjChFiChHiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCpAjGjFiPmBiCmMjBmOiPnLiCmJ_xHqqkZx_
 *							 _xZkqqHx_iKnMiCnPiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::RemoveAfterSessionIndex (	flint fliSessionIndexX,
												BOOL bIsRemoveForkOnX,
												BOOL bIsRemoveTimeLabelOnX)
{
	// _xZkqqHx_iOhHjCoIiImKjChFiCpAiKnMiCnOiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	FCForkConstIterator iFork = bIsRemoveForkOnX ?	GetLowerBoundFork(fliSessionIndexX) :
													GetUpperBoundFork(fliSessionIndexX);
	FCTimeLabelConstIterator iTimeLabel = bIsRemoveTimeLabelOnX ? GetLowerBoundTimeLabel(fliSessionIndexX) :
																  GetUpperBoundTimeLabel(fliSessionIndexX);
	FCHiForkTagConstIterator iHiTag = bIsRemoveForkOnX ? GetLowerBoundHiForkTag(fliSessionIndexX) :
														 GetUpperBoundHiForkTag(fliSessionIndexX);
	DWORDSet stIndex;
	while (!iFork.IsEnd())
	{
		stIndex.insert(iFork.GetRecordIndex());
		iFork++;
	}
	while (!iTimeLabel.IsEnd())
	{
		stIndex.insert(iTimeLabel.GetRecordIndex());
		iTimeLabel++;
	}
	while (!iHiTag.IsEnd())
	{
		stIndex.insert(iHiTag.GetRecordIndex());
		iHiTag++;
	}
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!stIndex.empty())
		DeleteRecords(stIndex);
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::RemoveAfterSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::AppendHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTitle		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpComment		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::AppendHiForkTag (	flint fliSessionIndex,
										FDSECTIME fdstCreateTime,
										double dHtreeScore,
										const GUID& guidUserId,
										const wchar_t* wcpTitle,
										const wchar_t* wcpComment)
{
	// _xZkqqHx_iKpJiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (IsThereHiForkTag(fliSessionIndex)) FFThrowMiscUnknown();
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	vDataBuff << BYTE(TYPE_HI_FORK_TAG) << fdstCreateTime << dHtreeScore << guidUserId << WString(wcpTitle) << WString(wcpComment);
	AppendRecord(fliSessionIndex, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiForkTable::AppendHiForkTag.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::RemoveHiForkTag
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiImKjChFiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiForkTable::RemoveHiForkTag (flint fliSessionIndex)
//{
//	FCHiForkTagConstIterator iHiTag = FindHiForkTag(fliSessionIndex);
//	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJiDiJiDhIiDiLiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (iHiTag.IsEnd()) return;
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	DeleteRecord(iHiTag.GetRecordIndex());
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateHash();
//} // FCHiForkTable::RemoveHiForkTag.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::IsThereRegalFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiImKjChFiCmJjAlDiOkOiCmIjHjKjHpAjFkKiKpCiCkKiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiForkTable::IsThereRegalFork (	flint fliSessionIndex,
										long* lDocId)
{
	FCForkConstIterator iFork = FindFork(fliSessionIndex);
	for (iFork = FindFork(fliSessionIndex);
		 !iFork.IsEnd() && iFork.GetSessionIndex() == fliSessionIndex;
		 iFork++)
	{
		if (!iFork.GetIsTemporary())
		//----- _xZkqqHx_iJlMjHjKjHpAjFkKiKpCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (lDocId != NULL)
				*lDocId = iFork.GetDocumentId();
			return TRUE;
		}
	}
	return FALSE;
} // FCHiForkTable::IsThereRegalFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::IsThereHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjDoAjHgFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCkKiCkAiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiNoMjAkMjDpKiOjOiCpAjFnEiClHiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiNoMjAkMiOnCiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrTitle		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDfOiDeDiDgHiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrComment		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMjDoAjHgFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiForkTable::IsThereHiForkTag (	flint fliSessionIndex,
										FDSECTIME* fdstCreateTime,
										double* dHtreeScore,
										GUID* guidUserId,
										WString* wstrTitle,
										WString* wstrComment)
{
	FCHiForkTagConstIterator iHiForkTag = FindHiForkTag(fliSessionIndex);
	if (!iHiForkTag.IsEnd())
	//----- _xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (fdstCreateTime != NULL)
			*fdstCreateTime = iHiForkTag.GetCreateTime();
		if (dHtreeScore != NULL)
			*dHtreeScore = iHiForkTag.GetHtreeScore();
		if (guidUserId != NULL)
			*guidUserId = iHiForkTag.GetUserId();
		if (wstrTitle != NULL)
			*wstrTitle = iHiForkTag.GetTitle();
		if (wstrComment != NULL)
			*wstrComment = iHiForkTag.GetComment();
		return TRUE;
	}
	return FALSE;
} // FCHiForkTable::IsThereHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetSortedDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiOkOiCmIjHjKjHpAjFkKiKpCiCpAiBeBiDfMiBfLiDgHiClFiCmEjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfMiBfLiDgHiCmNiImIiJlKiCmMiPiHiCmFiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjFlGiPjBiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iDhDiDiKiDeJiDgIiBhF_xHqqkZx_._xZkqqHx_iBhGiCmFiLoGjAnIiCoHiCoKiClNiDhAiBfLiDgHiClCiCmGiCmJiNlGiCkJiCoHjEoEiKhCiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfAiBeEiDhAiBfLiDgHiCmMjFlGiOjKjHpBiCkKjCfKiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfBiBeEiDhAiBfLiDgHjFlGiOjKjHpBiCmMjBoFiPkMjEoEiKhCiCmFiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::GetSortedDocumentId (longVector& vDocId)
{
	FCHiProject project = g_pFileServer->GetTopGroup(GetTableName().GetTopDirPath());
	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	if (!project.TryLock(autoLockProjectRead))
		FFThrowMiscUnknown();

	vDocId.clear();
	multimap<pair<flint, WString>, long, FCLessBranch> mmpSessionToDocId;
	FCForkConstIterator iFork;
	for (iFork = GetFirstFork(); !iFork.IsEnd(); iFork++)
	{
		// _xZkqqHx_iJlMjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (iFork.GetIsTemporary()) continue;

		WString wstrTitle = project.GetDocumentRec(iFork.GetDocumentId()).GetDocTitle();
		// _xZkqqHx_iDhDiDiKiDeJiDgIiCmNjHfMiCnPiDgOiDeDiDhEiDjDiCmJjFmPiNfIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		wstrTitle.Replace(L'.', L'-');
		// _xZkqqHx_iDfOiDeDiDgHiDiLiCmGiDgPiBfLiDfHiDiHiDjDiCpAiDhDiDiKiDeJiDgIiCmFjAnKjBlBiBeC_xHqqkZx_
		wstrTitle += L'.';
		wstrTitle += project.GetDocumentRec(iFork.GetDocumentId()).GetVersion();
		mmpSessionToDocId.insert(make_pair(make_pair(iFork.GetSessionIndex(), wstrTitle), iFork.GetDocumentId()));
	}
	multimap<pair<flint, WString>, long, FCLessBranch>::const_iterator i;
	for (i = mmpSessionToDocId.begin(); i != mmpSessionToDocId.end(); i++)
		vDocId.push_back((*i).second);
} // FCHiForkTable::GetSortedDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::Remove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeHiDjDiDgHiDiKiBfLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iFork	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeHiDjDiDgHiDiKiBfLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCmMiDeHiDjDiDgHiDiKiBfLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiForkTable::Remove (const FCForkConstIterator& iFork)
{
	if (iFork.IsEnd())
		return -1;
	const flint fliSessionIndex = iFork.GetSessionIndex();
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteRecord(iFork.GetRecordIndex());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
	return fliSessionIndex;
} // FCHiForkTable::Remove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::Remove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeHiDjDiDgHiDiKiBfLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iTimeLabel	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeHiDjDiDgHiDiKiBfLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCmMiDeHiDjDiDgHiDiKiBfLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiForkTable::Remove (const FCTimeLabelConstIterator& iTimeLabel)
{
	if (iTimeLabel.IsEnd())
		return -1;
	const flint fliSessionIndex = iTimeLabel.GetSessionIndex();
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteRecord(iTimeLabel.GetRecordIndex());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
	return fliSessionIndex;
} // FCHiForkTable::Remove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::Remove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeHiDjDiDgHiDiKiBfLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iHiTag	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeHiDjDiDgHiDiKiBfLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCmMiDeHiDjDiDgHiDiKiBfLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiForkTable::Remove (const FCHiForkTagConstIterator& iHiTag)
{
	if (iHiTag.IsEnd())
		return -1;
	const flint fliSessionIndex = iHiTag.GetSessionIndex();
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteRecord(iHiTag.GetRecordIndex());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
	return fliSessionIndex;
} // FCHiForkTable::Remove.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::IsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UpdateData_xZkqqHx_iMoDiCmJiBeBiPoOjFpBiCkKiPeDjAlDiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiForkTable::IsModified () const
//{
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAjFnEiClHiBeC_xHqqkZx_
//	return m_bUpdated;
//} // FCHiForkTable::IsModified.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFirstFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::GetFirstFork ()
{
	return FCForkConstIterator(this, m_mmpSessionToForkIndex.begin());
} // FCHiForkTable::GetFirstFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetLowerBoundFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDjJiClFiCkCiCkJiBeBiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::GetLowerBoundFork (flint fliSessionIndex)
{
	return FCForkConstIterator(this, m_mmpSessionToForkIndex.lower_bound(fliSessionIndex));
} // FCHiForkTable::GetLowerBoundFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetUpperBoundFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmMjHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::GetUpperBoundFork (flint fliSessionIndex)
{
	return FCForkConstIterator(this, m_mmpSessionToForkIndex.upper_bound(fliSessionIndex));
} // FCHiForkTable::GetUpperBoundFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiImKjChFiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::FindFork (flint fliSessionIndex)
{
	return FCForkConstIterator(this, m_mmpSessionToForkIndex.find(fliSessionIndex));
} // FCHiForkTable::FindFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindForkByDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJiBeBiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_iMjPiNpFiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::FindForkByDocumentId (long lDocId)
{
	FCForkConstIterator iFork;
	for (iFork = GetFirstFork();
		 !iFork.IsEnd() && (iFork.GetDocumentId() != lDocId);
		 iFork++);
	return iFork;
} // FCHiForkTable::FindForkByDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindTempForkByGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJiBeBiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTempFork	:_xZkqqHx_iMjPiNpFiClHiCoJiJlMjAnNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstIterator FCHiForkTable::FindTempForkByGuid (const GUID& guidTempFork)
{
	FCForkConstIterator iFork;
	for (iFork = GetFirstFork(); !iFork.IsEnd(); iFork++)
	{
		if (iFork.GetIsTemporary() && iFork.GetTempGuid() == guidTempFork)
			break;
	}
	return iFork;
} // FCHiForkTable::FindTempForkByGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetLastFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDiKiDgPiBfLiDfIiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDiKiDgPiBfLiDfIiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCForkConstReverseIterator FCHiForkTable::GetLastFork ()
{
	return FCForkConstReverseIterator(this, ((const multimap<flint, DWORD>&)m_mmpSessionToForkIndex).rbegin());
} // FCHiForkTable::GetLastFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFirstTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelConstIterator FCHiForkTable::GetFirstTimeLabel ()
{
	return FCTimeLabelConstIterator(this, m_mmpSessionToTimeLabelIndex.begin());
} // FCHiForkTable::GetFirstTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindTimeLabelById
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmGiIoKjChGiClHiCoJiOjOiKnEiDiJiDhIiDiLiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTimeLabelId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelConstIterator FCHiForkTable::FindTimeLabelById (long lTimeLabelId)
{
	FCTimeLabelConstIterator iTimeLabel;
	for (iTimeLabel = GetFirstTimeLabel();
		 !iTimeLabel.IsEnd() && (iTimeLabel.GetTimeLabelId() != lTimeLabelId);
		 iTimeLabel++);
	return iTimeLabel;
} // FCHiForkTable::FindTimeLabelById.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindTimeLabelByIdW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmGiIoKjChGiClHiCoJiOjOiKnEiDiJiDhIiDiLiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTimeLabelId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelIterator FCHiForkTable::FindTimeLabelByIdW (long lTimeLabelId)
{
	FCTimeLabelIterator iTimeLabel;
	for (iTimeLabel = FCTimeLabelIterator(this, m_mmpSessionToTimeLabelIndex.begin());
		 !iTimeLabel.IsEnd() && (iTimeLabel.GetTimeLabelId() != lTimeLabelId);
		 iTimeLabel++);
	return iTimeLabel;
} // FCHiForkTable::FindTimeLabelByIdW.

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindTempTimeLabelByGuid
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiJlMjAnNiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_GUID_xZkqqHx_iCkJiCoHiBeBiDeDiDfOiDiMiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTempTimeLabel	:GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCTimeLabelConstIterator FCHiForkTable::FindTempTimeLabelByGuid (const GUID& guidTempTimeLabel)
//{
//	FCTimeLabelConstIterator iTimeLabel;
//	for (iTimeLabel = GetFirstTimeLabel(); !iTimeLabel.IsEnd(); iTimeLabel++)
//	{
//		if (iTimeLabel.GetIsTemporary() && iTimeLabel.GetUserId() == guidTempTimeLabel)
//			break;
//	}
//	return iTimeLabel;
//} // FCHiForkTable::FindTempTimeLabelByGuid.
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetLowerBoundTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDjJiClFiCkCiCkJiBeBiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelConstIterator FCHiForkTable::GetLowerBoundTimeLabel (flint fliSessionIndex)
{
	return FCTimeLabelConstIterator(this, m_mmpSessionToTimeLabelIndex.lower_bound(fliSessionIndex));
} // FCHiForkTable::GetLowerBoundTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetUpperBoundTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmMjHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelConstIterator FCHiForkTable::GetUpperBoundTimeLabel (flint fliSessionIndex)
{
	return FCTimeLabelConstIterator(this, m_mmpSessionToTimeLabelIndex.upper_bound(fliSessionIndex));
} // FCHiForkTable::GetUpperBoundTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFirstHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagConstIterator FCHiForkTable::GetFirstHiForkTag ()
{
	return FCHiForkTagConstIterator(this, m_mpSessionToHiTagIndex.begin());
} // FCHiForkTable::GetFirstHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::FindHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiImKjChFiCmJiCkAiCoJjHjKjHpAiDfOiDePiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagConstIterator FCHiForkTable::FindHiForkTag (flint fliSessionIndex)
{
	return FCHiForkTagConstIterator(this, m_mpSessionToHiTagIndex.find(fliSessionIndex));
} // FCHiForkTable::FindHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetLowerBoundHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDjJiClFiCkCiCkJiBeBiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagConstIterator FCHiForkTable::GetLowerBoundHiForkTag (flint fliSessionIndex)
{
	return FCHiForkTagConstIterator(this, m_mpSessionToHiTagIndex.lower_bound(fliSessionIndex));
} // FCHiForkTable::GetLowerBoundHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetUpperBoundHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmMjHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagConstIterator FCHiForkTable::GetUpperBoundHiForkTag (flint fliSessionIndex)
{
	return FCHiForkTagConstIterator(this, m_mpSessionToHiTagIndex.upper_bound(fliSessionIndex));
} // FCHiForkTable::GetUpperBoundHiForkTag.

//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetFileAtom
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
// *
//* <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiForkTable::GetFileAtom () const
//{
//	return m_pProject->GetDocumentFileAtom(m_lDocumentId, L".mdfk");
//} // FCHiForkTable::GetFileAtom.
//----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::GetLatestForkOrLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiCoAjAfGiClFiCkCjFkKiKpCiImKjChF_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeBiIlNiCkCiCmNiOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiImKjChFiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.08.27 Fukushiro M. _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
flint FCHiForkTable::GetLatestForkOrLabel () const
{
	flint fliSessionIndex = flint(-1);
	if (!m_mmpSessionToForkIndex.empty())
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmMjFkKiKpCiImKjChFiBeC_xHqqkZx_
		if (fliSessionIndex < (*m_mmpSessionToForkIndex.rbegin()).first)
			fliSessionIndex = (*m_mmpSessionToForkIndex.rbegin()).first;
	}
	if (!m_mmpSessionToTimeLabelIndex.empty())
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmMiOjOiKnEiDiJiDhIiDiLiImKjChFiBeC_xHqqkZx_
		if (fliSessionIndex < (*m_mmpSessionToTimeLabelIndex.rbegin()).first)
			fliSessionIndex = (*m_mmpSessionToTimeLabelIndex.rbegin()).first;
	}
	if (!m_mpSessionToHiTagIndex.empty())
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmMjFkKiKpCiImKjChFiBeC_xHqqkZx_
		if (fliSessionIndex < (*m_mpSessionToHiTagIndex.rbegin()).first)
			fliSessionIndex = (*m_mpSessionToHiTagIndex.rbegin()).first;
	}
	return fliSessionIndex;
} // FCHiForkTable::GetLatestForkOrLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTable::UpdateHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiForkTable::UpdateHash ()
{
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeB_xHqqkZx_ -----
	m_dwSuperInfoIndex = DWORD(-1);				// _xZkqqHx_iPoDiImKjHjKjHpAiPoOjFpBiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mmpSessionToForkIndex.clear();			// _xZkqqHx_jFkKiKpCjHjKjHpAiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mmpSessionToTimeLabelIndex.clear();		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpSessionToHiTagIndex.clear();			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const DWORD dwRecordCount = GetRecordCount();
	DWORD dwIndex;
	for (dwIndex = 0; dwIndex != dwRecordCount; dwIndex++)
	{
		// _xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		flint fliPrimaryId = GetRecordPrimaryId(dwIndex);
		// _xZkqqHx_iDfOiDeDiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTE byType;
		GetRecordData(&byType, sizeof(byType), dwIndex);
		switch (byType)
		{
		case TYPE_SUPER_INFO:		// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiPoOjFpBiBeC_xHqqkZx_
			m_dwSuperInfoIndex = dwIndex;
			break;
		case TYPE_FORK:				// _xZkqqHx_jFkKiKpCjHjKjHpAiBeC_xHqqkZx_
			m_mmpSessionToForkIndex.insert(make_pair(fliPrimaryId, dwIndex));
			break;
		case TYPE_TIME_LABEL:		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
			m_mmpSessionToTimeLabelIndex.insert(make_pair(fliPrimaryId, dwIndex));
			break;
		case TYPE_HI_FORK_TAG:		// _xZkqqHx_jHjKjHpAiDfOiDePiBeC_xHqqkZx_
			m_mpSessionToHiTagIndex.insert(make_pair(fliPrimaryId, dwIndex));
			break;
		}
	}
	// _xZkqqHx_iPeDjAlD_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	ResetVirtualTableIdentifier();

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidTableGuid = g_pFileServer->GetLockedTableGuid(GetTableName());
//	// _xZkqqHx_iNfIjAfG_xHqqkZx_ID_xZkqqHx_iCpAiNmFjAfGiCmJiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(GetTableName());
//	m_dwLockedAppendIdentifier = g_pFileServer->GetLockedAppendIdentifier(GetTableName());
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiForkTable::UpdateHash.

