#ifndef __HiForkTable_h
#define __HiForkTable_h

#include "UtilFile.h"	// For operator <<.
#include "HiTableBase.h"	// For Baseclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCHiTableBase

//
//
// _xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEjPiBgD_xHqqkZx_
// _xZkqqHx_iEkA_xHqqkZx_TYPE_xZkqqHx_iEkA_xHqqkZx_DATA1_xZkqqHx_iBgD_xHqqkZx_
// _xZkqqHx_iEkEiEjPiEjPiEkIiEjPiEjPiEjPiBgD_xHqqkZx_
//
//  TYPE = TYPE_SUPER_INFO: _xZkqqHx_iPoDiImKjHjKjHpAiPoOjFpBiBeC_xHqqkZx_
//  DATA1 = flint: _xZkqqHx_iPoDiImKjHjKjHpAiCmJiCkIiCkPiCoJjFkKiKpCiImKjChFiBeC_xHqqkZx_
//  DATA2 = long: _xZkqqHx_iPoDiImKjHjKjHpAiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//
//  TYPE = TYPE_FORK_INFO: _xZkqqHx_jFkKiKpCjHjKjHpAiPoOjFpBiBeC_xHqqkZx_
//  DATA1 = flint: _xZkqqHx_jFkKiKpCiImKjChFiBeC_xHqqkZx_
//  DATA2 = long: _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//
//  TYPE = TYPE_HI_TAG: _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiPoOjFpBiBeC_xHqqkZx_
//  DATA1 = flint: _xZkqqHx_jFkKiKpCiImKjChFiBeC_xHqqkZx_
//  DATA2 = FDSECTIME: _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
//  DATA3 = double: _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
//  DATA4 = GUID: _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
//  DATA5 = WString: _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//  DATA6 = WString: _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
//
//  TYPE = TYPE_TIME_LABEL: _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiPoOjFpBiBeC_xHqqkZx_
//  DATA1 = flint: _xZkqqHx_jFkKiKpCiImKjChFiBeC_xHqqkZx_
//  DATA2 = long: _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//  DATA3 = SheetID: _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//  DATA4 = DBLPoint: _xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
//  DATA5 = FDSECTIME: _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
//  DATA6 = GUID: _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
//  DATA7 = WString: _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
//
//


// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//class FCHiProject;
class FCDbReadLock;
class FCDbWriteLock;
class FCForkConstIterator;
class FCForkConstReverseIterator;
class FCHiForkTagConstIterator;
class FCTimeLabelConstIterator;
class FCTimeLabelIterator;
class FCDbTable;
class FCDbGroup;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCLessBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiCmMjBoFiPkMiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEoEiKhCiCmNiImIiJlKiCmMiPiHiCmFiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjFlGiPjBiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCkKiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iDhDiDiKiDeJiDgIiBhF_xHqqkZx_._xZkqqHx_iBhGiCmFiLoGjAnIiCoHiCoKiClNiDhAiBfLiDgHiClCiCmGiCmJiNlGiCkJiCoHjEoEiKhCiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfAiBeEiDhAiBfLiDgHiCmMjFlGiOjKjHpBiCkKjCfKiCkCiPiHiBeC_xHqqkZx_
 *				_xZkqqHx_iCfCiBhMiCfBiBeEiDhAiBfLiDgHjFlGiOjKjHpBiCmMjBoFiPkMjEoEiKhCiCmFiPkMiClDiCkCiPiHiBeC_xHqqkZx_
 *
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_10.3.4 > 5.2
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_5.3.4 > 5.2
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCLessBranch
{
public:
	bool operator () (const pair<flint, WString>& v0, const pair<flint, WString>& v1) const;
}; // class FCLessBranch.

//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCForkInfo
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiImKjChFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.14 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//struct FCForkInfo
//{
//	FCForkInfo (flint fliCmdPtr, flint fliIdxPtr, long lDocumentId)
//		:	m_fliCommandFilePtr(fliCmdPtr),
//			m_fliSessionIndex(fliIdxPtr),
//			m_lDocumentId(lDocumentId) {}
//	flint		m_fliCommandFilePtr;	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
//	flint		m_fliSessionIndex;		// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	long		m_lDocumentId;			// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//}; // struct FCForkInfo.
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCTimeLabelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCTimeLabelInfo
{
	FCTimeLabelInfo ()
			:	m_lTimeLabelId(-1),
				m_stid(-1),
				m_mmpt(0,0),
				m_fdstCreateTime(FDSECTIME(-1)),
				m_guidUserId(GUID_NULL) {}

	FCTimeLabelInfo (	long lTimeLabelId,
						SheetID stid,
						const DBLPoint& mmpt,
						FDSECTIME fdstCreateTime,
						const GUID& guidUserId,
						const wchar_t* wcpLabel)
			:	m_lTimeLabelId(lTimeLabelId),
				m_stid(stid),
				m_mmpt(mmpt),
				m_fdstCreateTime(fdstCreateTime),
				m_guidUserId(guidUserId),
				m_wstrLabel(wcpLabel) {}

	long		m_lTimeLabelId;		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SheetID		m_stid;				// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	DBLPoint	m_mmpt;				// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
	FDSECTIME	m_fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	GUID		m_guidUserId;		// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WString		m_wstrLabel;		// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
}; // struct FCTimeLabelInfo.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCHiForkTagInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCHiForkTagInfo
{
	FCHiForkTagInfo () :
						m_fdstCreateTime(FDSECTIME(-1)),
						m_guidUserId(GUID_NULL) {}
	FCHiForkTagInfo (	FDSECTIME fdstCreateTime,
						double dHtreeScore,
						const GUID& guidUserId,
						const wchar_t* wcpTitle,
						const wchar_t* wcpComment) :
					m_fdstCreateTime(fdstCreateTime),
					m_dHtreeScore(dHtreeScore),
					m_guidUserId(guidUserId),
					m_wstrTitle(wcpTitle),
					m_wstrComment(wcpComment) {}
	FDSECTIME	m_fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	double		m_dHtreeScore;		// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
	GUID		m_guidUserId;		// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WString		m_wstrTitle;		// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	WString		m_wstrComment;		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
}; // struct FCHiForkTagInfo.

// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//typedef multimap<flint, FCForkInfo> FCIdxToForkInfoMmap;
typedef multimap<flint, FCTimeLabelInfo> FCIdxToTimeLabelInfoMmap;
typedef map<flint, FCHiForkTagInfo> FCIdxToHiForkTagInfoMap;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHiForkTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCmMjGhLjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHiForkTable : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCHiForkTable ();
	FCHiForkTable (const FCDbGroup& dbGroup);
	virtual ~FCHiForkTable ();
	virtual void	operator = (const FCDbGroup& dbGroup);
	virtual BOOL	UpdateData (const FCDbReadLock& autoLockRead);
	virtual void	Clear ();
	virtual void	SetSuperInfo (	flint fliSessionIndex,
									long lSuperDocId);
	virtual void	GetSuperInfo (	flint* fliSessionIndex,
									long* lSuperDocId);
	virtual void	AppendFork (flint fliSessionIndex,
								long lDocId);
// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual flint	RemoveFork (long lDocId);
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual flint	SearchPath2 (	flint* fliSessionIndexSpot,
//									flint fliSessionIndex,
//									flint fliDistMin);
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual GUID	AppendTempFork (flint fliSessionIndex);
// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual flint	RemoveTempFork (const GUID& guidTempGuid);
	virtual void	RemoveAllTempFork ();

	virtual void	GetTimeLabelList (FCIdxToTimeLabelInfoMmap& mmpSessionToTimeLabel);
	virtual void	GetHiForkTagList (FCIdxToHiForkTagInfoMap& mpSessionToHiTag);

	virtual long	GetFreeTimeLabelId ();
	virtual void	AppendTimeLabel (	flint fliSessionIndex,
										long lTimeLabelId,
										SheetID stid,
										const DBLPoint& mmpt,
										FDSECTIME fdstCreateTime,
										const GUID& guidUserId,
										const wchar_t* wcpLabel);
// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	RemoveTimeLabel (long lTimeLabelId);
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual GUID	AppendTempTimeLabel (flint fliSessionIndex);
//	virtual void	RemoveAllTempTimeLabel ();
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual void	RemoveAfterSessionIndex (	flint fliSessionIndex,
												BOOL bIsRemoveForkOnX,
												BOOL bIsRemoveTimeLabelOnX);

	virtual void	AppendHiForkTag (	flint fliSessionIndex,
										FDSECTIME fdstCreateTime,
										double dHtreeScore,
										const GUID& guidUserId,
										const wchar_t* wcpTitle,
										const wchar_t* wcpComment);
// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	RemoveHiForkTag (flint fliSessionIndex);
	virtual BOOL	IsThereRegalFork (	flint fliSessionIndex,
										long* lDocId = NULL);
	virtual BOOL	IsThereHiForkTag (	flint fliSessionIndex,
										FDSECTIME* fdstCreateTime = NULL,
										double* dHtreeScore = NULL,
										GUID* guidUserId = NULL,
										WString* wstrTitle = NULL,
										WString* wstrComment = NULL);

	virtual void	GetSortedDocumentId (longVector& vDocId);

	virtual flint	Remove (const FCForkConstIterator& iFork);
	virtual flint	Remove (const FCTimeLabelConstIterator& iTimeLabel);
	virtual flint	Remove (const FCHiForkTagConstIterator& iHiTag);

	virtual FCForkConstIterator	GetFirstFork ();
	virtual FCForkConstIterator	GetLowerBoundFork (flint fliSessionIndex);
	virtual FCForkConstIterator	GetUpperBoundFork (flint fliSessionIndex);
	virtual FCForkConstIterator	FindFork (flint fliSessionIndex);
	virtual FCForkConstIterator	FindForkByDocumentId (long lDocId);
	virtual FCForkConstIterator	FindTempForkByGuid (const GUID& guidTempFork);
	virtual FCForkConstReverseIterator	GetLastFork ();

	virtual FCTimeLabelConstIterator	GetFirstTimeLabel ();
	virtual FCTimeLabelConstIterator	FindTimeLabelById (long lTimeLabelId);
	virtual FCTimeLabelIterator			FindTimeLabelByIdW (long lTimeLabelId);
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual FCTimeLabelConstIterator	FindTempTimeLabelByGuid (const GUID& guidTempTimeLabel);
	virtual FCTimeLabelConstIterator	GetLowerBoundTimeLabel (flint fliSessionIndex);
	virtual FCTimeLabelConstIterator	GetUpperBoundTimeLabel (flint fliSessionIndex);
	virtual FCHiForkTagConstIterator	GetFirstHiForkTag ();
	virtual FCHiForkTagConstIterator	FindHiForkTag (flint fliSessionIndex);
	virtual FCHiForkTagConstIterator	GetLowerBoundHiForkTag (flint fliSessionIndex);
	virtual FCHiForkTagConstIterator	GetUpperBoundHiForkTag (flint fliSessionIndex);
	virtual flint	GetLatestForkOrLabel () const;

friend class FCForkConstIterator;
friend class FCForkConstReverseIterator;
friend class FCTimeLabelConstIterator;
friend class FCTimeLabelIterator;
friend class FCHiForkTagConstIterator;

protected:
	virtual void		UpdateHash ();

public:
	enum
	{
		TYPE_SUPER_INFO = 1,	// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiPoOjFpBiBeC_xHqqkZx_
		TYPE_FORK,				// _xZkqqHx_jFkKiKpCjHjKjHpAiBeC_xHqqkZx_
		TYPE_TIME_LABEL,		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		TYPE_HI_FORK_TAG,		// _xZkqqHx_jHjKjHpAiDfOiDePiBeC_xHqqkZx_
	};

protected:
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	GUID					m_guidTableGuid;				// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	DWORD					m_dwLockedDeleteIdentifier;		// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	DWORD					m_dwLockedAppendIdentifier;		// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	DWORD					m_dwSuperInfoIndex;				// _xZkqqHx_iPoDiImKjHjKjHpAiPoOjFpBiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	multimap<flint, DWORD>	m_mmpSessionToForkIndex;		// _xZkqqHx_jFkKiKpCjHjKjHpAiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	multimap<flint, DWORD>	m_mmpSessionToTimeLabelIndex;	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	map<flint, DWORD>		m_mpSessionToHiTagIndex;		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
}; // class FCHiForkTable.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCForkConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiDeDiDfOiDiMiBfLiDfOiBeCiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiCmMiDhIiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class S, class T> class _FCForkConstIterator
{
public:
	_FCForkConstIterator (S* pHiForkTable = NULL, T iI = T()) : m_pHiForkTable(pHiForkTable), m_iI(iI) {}
	BOOL GetIsInvalid () const { return m_pHiForkTable == NULL; }
	operator ++ (int) { m_iI++; }
	flint GetSessionIndex () const { return (*m_iI).first; }
	DWORD GetRecordIndex () const { return (*m_iI).second; }
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	flint GetCommandFilePtr () const { return (*m_iI).second.m_fliCommandFilePtr; }
//	flint GetIndexFilePtr () const { return (*m_iI).second.m_fliSessionIndex; }
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	long GetDocumentId () const { return (*m_iI).second.m_lDocumentId; }
//	BOOL GetIsTemporary () const { return (GetDocumentId() < 0); }
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long GetDocumentId ()
		{
			long lDocumentId;
			GetValue(&lDocumentId, NULL);
			return lDocumentId;
		}
	GUID GetTempGuid ()
		{
			GUID guidTempGuid;
			GetValue(NULL, &guidTempGuid);
			return guidTempGuid;
		}
	BOOL GetIsTemporary ()
		{
			return (GetDocumentId() < 0);
		}
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
friend class FCHiForkTable;
protected:
	void GetValue (	long* lDocumentId,		// _xZkqqHx_jHjKjHpAjFlGiPjBiBeC_xHqqkZx_
					GUID* guidTempGuid)		// _xZkqqHx_iIoKiOjOjFlGiPjBiCmM_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
		{
			// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			flint fliPrimaryId;
			BYTEVector vBuff;
			m_pHiForkTable->GetRecord(fliPrimaryId, &vBuff, GetRecordIndex());
			const BYTE* pData = &vBuff[0];
			// _xZkqqHx_iDfOiDeDiDhGiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			FFSkipData((BYTE*)NULL, pData);
			if (lDocumentId != NULL)
				FFReadData(*lDocumentId, pData);
			else
				FFSkipData(lDocumentId, pData);
			if (guidTempGuid != NULL)
				FFReadData(*guidTempGuid, pData);
			else
				FFSkipData(guidTempGuid, pData);
		} // GetValue.

protected:
	S* m_pHiForkTable;
	T m_iI;
}; // class _FCForkConstIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCForkConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCForkConstIterator : public _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator>
{
protected:
typedef _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator> BASE_CLASS;

public:
	FCForkConstIterator (FCHiForkTable* pHiForkTable = NULL,
						multimap<flint, DWORD>::const_iterator iI = multimap<flint, DWORD>::const_iterator())
			: _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator>(pHiForkTable, iI) {}
	operator -- (int)
		{
			if (m_iI == m_pHiForkTable->m_mmpSessionToForkIndex.begin())
				m_iI = m_pHiForkTable->m_mmpSessionToForkIndex.end();
			else
				m_iI--;
		}
	BOOL IsEnd () const { return (m_iI == ((const FCHiForkTable*)m_pHiForkTable)->m_mmpSessionToForkIndex.end()); }

//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//	flint operator * ()
//		{
//			return m_iI->first;
//		}
//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

}; // class FCForkConstIterator.

//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//extern bool operator != (FCForkConstIterator i1, FCForkConstIterator i2);
//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCForkConstReverseIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDiKiDfIiDgHiCmMiDiKiDgPiBfLiDfIiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCForkConstReverseIterator : public _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_reverse_iterator>
{
protected:
typedef _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_reverse_iterator> BASE_CLASS;

public:
	FCForkConstReverseIterator (FCHiForkTable* pHiForkTable = NULL,
								multimap<flint, DWORD>::const_reverse_iterator iI = multimap<flint, DWORD>::const_reverse_iterator())
			: _FCForkConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_reverse_iterator>(pHiForkTable, iI) {}
	BOOL IsEnd () const { return (m_iI == ((const FCHiForkTable*)m_pHiForkTable)->m_mmpSessionToForkIndex.rend()); }
}; // class FCForkConstReverseIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCTimeLabelConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDeDiDfOiDiMiBfLiDfOiBeCiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiCmMiDhIiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class S, class T> class _FCTimeLabelConstIterator
{
public:
	_FCTimeLabelConstIterator (S* pHiForkTable = NULL, T iI = T())
			: m_pHiForkTable(pHiForkTable), m_iI(iI) {}
	BOOL GetIsInvalid () const { return m_pHiForkTable == NULL; }
	operator ++ (int) { m_iI++; }
	flint GetSessionIndex () const { return (*m_iI).first; }						// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	DWORD GetRecordIndex () const { return (*m_iI).second; }
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	long GetTimeLabelId () const { return (*m_iI).second.m_lTimeLabelId; }			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	SheetID GetSheetId () const { return (*m_iI).second.m_stid; }					// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	DBLPoint GetPoint () const { return (*m_iI).second.m_mmpt; }					// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
//	FDSECTIME GetCreateTime () const { return (*m_iI).second.m_fdstCreateTime; }	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
//	GUID GetUserId () const { return (*m_iI).second.m_guidUserId; }					// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	WString GetLabelText () const { return (*m_iI).second.m_wstrLabel; }			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long GetTimeLabelId ()
		{
			long lTimeLabelId;			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			GetValue(	&lTimeLabelId,	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL);			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return lTimeLabelId;
		}
	// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SheetID GetSheetId ()
		{
			SheetID stidSheetId;		// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			GetValue(	NULL,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						&stidSheetId,	// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL);			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return stidSheetId;
		}
	// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
	DBLPoint GetPoint ()
		{
			DBLPoint mmptPoint;			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
			GetValue(	NULL,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						&mmptPoint,		// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL);			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return mmptPoint;
		}
	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	FDSECTIME GetCreateTime ()
		{
			FDSECTIME fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
			GetValue(	NULL,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						&fdstCreateTime,// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL);			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return fdstCreateTime;
		}
	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	GUID GetUserId ()
		{
			GUID guidUserId;			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			GetValue(	NULL,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						&guidUserId,	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL);			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return guidUserId;
		}
	// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
	WString GetLabelText ()
		{
			WString wstrLabelText;		// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			GetValue(	NULL,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						&wstrLabelText);// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			return wstrLabelText;
		}

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	BOOL GetIsTemporary ()
//		{
//			return (GetTimeLabelId() < 0);
//		}
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

friend class FCHiForkTable;
protected:
	void GetValue (	long* lTimeLabelId,			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					SheetID* stidSheetId,		// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					DBLPoint* mmptPoint,		// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
					FDSECTIME* fdstCreateTime,	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
					GUID* guidUserId,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					WString* wstrLabelText)		// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
		{
			// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			flint fliPrimaryId;
			BYTEVector vBuff;
			m_pHiForkTable->GetRecord(fliPrimaryId, &vBuff, GetRecordIndex());
			const BYTE* pData = &vBuff[0];
			// _xZkqqHx_iDfOiDeDiDhGiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			FFSkipData((BYTE*)NULL, pData);
			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			if (lTimeLabelId != NULL)
				FFReadData(*lTimeLabelId, pData);
			else
				FFSkipData(lTimeLabelId, pData);
			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			if (stidSheetId != NULL)
				FFReadData(*stidSheetId, pData);
			else
				FFSkipData(stidSheetId, pData);
			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
			if (mmptPoint != NULL)
				FFReadData(*mmptPoint, pData);
			else
				FFSkipData(mmptPoint, pData);
			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
			if (fdstCreateTime != NULL)
				FFReadData(*fdstCreateTime, pData);
			else
				FFSkipData(fdstCreateTime, pData);
			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			if (guidUserId != NULL)
				FFReadData(*guidUserId, pData);
			else
				FFSkipData(guidUserId, pData);
			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			if (wstrLabelText != NULL)
				FFReadData(*wstrLabelText, pData);
			else
				FFSkipData(wstrLabelText, pData);
		}

protected:
	S* m_pHiForkTable;
	T m_iI;
}; // class _FCTimeLabelConstIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCTimeLabelConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCTimeLabelConstIterator : public _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator>
{
protected:
typedef _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator> BASE_CLASS;

public:
	FCTimeLabelConstIterator (	FCHiForkTable* pHiForkTable = NULL,
								multimap<flint, DWORD>::const_iterator iI = multimap<flint, DWORD>::const_iterator())
					: _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::const_iterator>(pHiForkTable, iI) {}
	BOOL IsEnd () const { return (m_iI == ((const FCHiForkTable*)m_pHiForkTable)->m_mmpSessionToTimeLabelIndex.end()); }
}; // class FCTimeLabelConstIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCTimeLabelConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCTimeLabelIterator : public _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::iterator>
{
protected:
typedef _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::iterator> BASE_CLASS;

public:
	FCTimeLabelIterator (FCHiForkTable* pHiForkTable = NULL, multimap<flint, DWORD>::iterator iI = multimap<flint, DWORD>::iterator())
			: _FCTimeLabelConstIterator<FCHiForkTable, multimap<flint, DWORD>::iterator>(pHiForkTable, iI),
			  m_dwFlag(0) {}
	BOOL IsEnd () const { return (m_iI == m_pHiForkTable->m_mmpSessionToTimeLabelIndex.end()); }
	// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
	void SetPoint (const DBLPoint& mmpt)
		{
			m_dwFlag |= FD_POINT;
			m_mmptPoint = mmpt;
		}
	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	void SetUserId (const GUID& guid)
		{
			m_dwFlag |= FD_USER_ID;
			m_guidUserId = guid;
		}
	// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
	void SetLabelText (const wchar_t* wcpText)
		{
			m_dwFlag |= FD_LABEL_TEXT;
			m_wstrLabelText = wcpText;
		}
	void Update ()
		{
			if (m_dwFlag != 0)
			//----- _xZkqqHx_jFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				BYTEVector vData;
				GetData(vData);
				m_pHiForkTable->DeleteRecord(GetRecordIndex());
				// _xZkqqHx_iOhHjCoIiCmMiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
				m_pHiForkTable->AppendRecord(m_iI->first, &vData[0], vData.size());
				// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNmEiNfMjChKiBeC_xHqqkZx_
				m_pHiForkTable->UpdateHash();
				// _xZkqqHx_iDeOiDiKiDeBiBeC_xHqqkZx_AppendRecord_xZkqqHx_iCmFiDgOiDgCiDfGiDiFiCkKiLlGiCkEiClNiCnPiBeC_xHqqkZx_
				m_dwFlag = 0;
				m_pHiForkTable = NULL;
				m_iI = multimap<flint, DWORD>::iterator();
			}
		}

	void GetData (BYTEVector& vData)
		{
			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			long lTimeLabelId = -1;
			// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			SheetID stidSheetId = SheetID(-1);
			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
			DBLPoint mmptPoint(0,0);
			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
			FDSECTIME fdstCreateTime = FDSECTIME(-1);
			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			GUID guidUserId = GUID_NULL;
			// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			WString wstrLabelText;
			if (!GetIsInvalid() && !IsEnd())
				GetValue(	&lTimeLabelId,		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&stidSheetId,		// _xZkqqHx_iDiJiDhIiDiLiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&mmptPoint,			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
							&fdstCreateTime,	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
							&guidUserId,		// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
							&wstrLabelText);	// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
			if (m_dwFlag & FD_POINT)
				mmptPoint = m_mmptPoint;
			if (m_dwFlag & FD_USER_ID)
				guidUserId = m_guidUserId;
			if (m_dwFlag & FD_LABEL_TEXT)
				wstrLabelText = m_wstrLabelText;
			vData.clear();
			vData << BYTE(FCHiForkTable::TYPE_TIME_LABEL) << lTimeLabelId << stidSheetId << mmptPoint << fdstCreateTime << guidUserId << wstrLabelText;
		}

protected:
	enum {
		FD_POINT		= (1L << 0),
		FD_USER_ID		= (1L << 1),
		FD_LABEL_TEXT	= (1L << 2),
	};

protected:
	DWORD		m_dwFlag;
	DBLPoint	m_mmptPoint;			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiBeC_xHqqkZx_
	GUID		m_guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WString		m_wstrLabelText;		// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
}; // class FCTimeLabelIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCHiForkTagConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCmMiDeDiDfOiDiMiBfLiDfOiBeCiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiCmMiDhIiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class S, class T> class _FCHiForkTagConstIterator
{
public:
	_FCHiForkTagConstIterator (S* pHiForkTable = NULL, T iI = T())
		: m_pHiForkTable(pHiForkTable), m_iI(iI) {}
	BOOL GetIsInvalid () const { return m_pHiForkTable == NULL; }
	operator ++ (int) { m_iI++; }
	flint GetSessionIndex () const { return (*m_iI).first; }
	DWORD GetRecordIndex () const { return (*m_iI).second; }

	FDSECTIME GetCreateTime ()
		{
			FDSECTIME fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
			GetValue(	&fdstCreateTime,	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
						NULL);				// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			return fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
		}
	double GetHtreeScore ()
		{
			double dHtreeScore;			// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
			GetValue(	NULL,				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						&dHtreeScore,		// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
						NULL);				// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			return dHtreeScore;			// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
		}
	GUID GetUserId ()
		{
			GUID guidUserId;			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			GetValue(	NULL,				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
						&guidUserId,		// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
						NULL);				// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			return guidUserId;			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		}
	WString GetTitle ()
		{
			WString wstrTitle;			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
			GetValue(	NULL,				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						&wstrTitle,			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
						NULL);				// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			return wstrTitle;			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
		}
	WString GetComment ()
		{
			WString wstrComment;		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			GetValue(	NULL,				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						NULL,				// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
						&wstrComment);		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			return wstrComment;		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
		}

friend class FCHiForkTable;
protected:
	void GetValue (	FDSECTIME* fdstCreateTime,	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
					double* dHtreeScore,		// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
					GUID* guidUserId,			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					WString* wstrTitle,			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
					WString* wstrComment)		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
		{
			// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			flint fliPrimaryId;
			BYTEVector vBuff;
			m_pHiForkTable->GetRecord(fliPrimaryId, &vBuff, GetRecordIndex());
			const BYTE* pData = &vBuff[0];
			// _xZkqqHx_iDfOiDeDiDhGiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			FFSkipData((BYTE*)NULL, pData);
			// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
			if (fdstCreateTime != NULL)
				FFReadData(*fdstCreateTime, pData);
			else
				FFSkipData(fdstCreateTime, pData);
			// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
			if (dHtreeScore != NULL)
				FFReadData(*dHtreeScore, pData);
			else
				FFSkipData(dHtreeScore, pData);
			// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			if (guidUserId != NULL)
				FFReadData(*guidUserId, pData);
			else
				FFSkipData(guidUserId, pData);
			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
			if (wstrTitle != NULL)
				FFReadData(*wstrTitle, pData);
			else
				FFSkipData(wstrTitle, pData);
			// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			if (wstrComment != NULL)
				FFReadData(*wstrComment, pData);
			else
				FFSkipData(wstrComment, pData);
		}

protected:
	S* m_pHiForkTable;
	T m_iI;
}; // class _FCHiForkTagConstIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHiForkTagConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCmMiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHiForkTagConstIterator : public _FCHiForkTagConstIterator<FCHiForkTable, map<flint, DWORD>::const_iterator>
{
protected:
typedef _FCHiForkTagConstIterator<FCHiForkTable, map<flint, DWORD>::const_iterator> BASE_CLASS;

public:
	FCHiForkTagConstIterator (	FCHiForkTable* pHiForkTable = NULL,
								map<flint, DWORD>::const_iterator iI = map<flint, DWORD>::const_iterator())
			: _FCHiForkTagConstIterator<FCHiForkTable, map<flint, DWORD>::const_iterator>(pHiForkTable, iI) {}
	BOOL IsEnd () const { return (m_iI == ((const FCHiForkTable*)m_pHiForkTable)->m_mpSessionToHiTagIndex.end()); }
}; // class FCHiForkTagConstIterator.

#endif//__HiForkTable_h

