#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp()
#include "UtilMisc.h"		// For FFGetCurrentTime()
#include "UtilFile.h"		// For ReadData.
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "UtilStr.h"		// For FFLoadString.
#include "UtilStdLib.h"		// For FFIntersection.
#include "DynamicDb.h"		// For g_pFileServer.
#include "HiProject.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::FCHiProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiProject::FCHiProject ()
{
	Clear();
} // FCHiProject::FCHiProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::FCHiProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiDePiDiLiBfLiDhGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dbGroup	:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiProject::FCHiProject (const FCDbGroup& dbGroup)
		:	BASE_CLASS()
{
	Clear();
	Set(dbGroup);
} // FCHiProject::FCHiProject.

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetLastUpdatedTime
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiBeCiDeJiDhFiDfHiDeGiDeOiDgHjFmPiNfIiMoDiCmJiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnN_xHqqkZx_
// *			_xZkqqHx_iClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FDTIME FCHiProject::GetLastUpdatedTime () const
//{
//	return m_fdtmLastUpdatedTime;
//} // FCHiProject::GetLastUpdatedTime.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeCiDiNiDgCiDeOiPoOjFpBiCoAiDeOiDiKiDeBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::Clear ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Clear();
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jDoAjFjEiPoOjFpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//	m_guidTableGuid = GUID_NULL;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwLockedAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpHeaderIdToIndex.clear();
	m_mpMemberUserToIndex.clear();
	m_mpLimitedUserToIndex.clear();
	m_mpDocumentIdToIndex.clear();
} // FCHiProject::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMjCgMiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dbGroup	:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::operator = (const FCDbGroup& dbGroup)
{
	Clear();
	Set(dbGroup);
} // FCHiProject::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UpdateData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_Read_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 	 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiDiNiBfLiDgIiClFiBeBiPoOjFpBiCpAiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			FCHiProject::UpdateData_xZkqqHx_iCmGiLeAjEfMiCmNjDkPjDjJiClOiCkKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJjDfPiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_HPCFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmNjDmHiCnNiCmGiCmBiClNiMoDiCmJiDeOiDiNiBfLiDfJiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::UpdateData (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	if (!BASE_CLASS::UpdateData(readLock))
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
		return FALSE;
	} else
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
		UpdateHash();
		return TRUE;
	}
} // FCHiProject::UpdateData.

//----- 06.01.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UpdateFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	writeLock	:_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_Write_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiBfLiDhFiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_HPCFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmNiPjBiCkLiNjOiCpBiClOiMoDiCmJiDeOiDiNiBfLiDfJiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCHiProject::UpdateData_xZkqqHx_iCmGiLeAjEfMiCmNjDkPjDjJiClOiCkKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiL_xHqqkZx_
// *			_xZkqqHx_iCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJjDfPiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::UpdateFile (const FCDbWriteLock& writeLock)
//{
//	ASSERT(writeLock.IsLocked());
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiCmFiCmIiCkCiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiCmMiPjBiCkLiNjOiCnNiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
//	if (!IsQualifiedToModify(FFGetApp()->GetUserId()))
//		FFThrowMiscUnknown();
//
////----- 05.12.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//---- _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCkKiCkAiCoKiCmOiBeBiNoNiPjMiClHiCoJ_xHqqkZx_ -----
////	longSet stDelDocId;
////	long lDocId;
////	for (GetFirstHidocumentRec(lDocId);
////		 lDocId != -1;
////		 GetNextHidocumentRec(lDocId))
////	{
////		if (GetIsTemporaryDocument(lDocId))
////		//----- _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiH_xHqqkZx_ -----
////		{
////			FCDbWriteLock writeLockVar(this, lDocId, FDHI_COMMAND_TABLE_ID);
////			if (writeLockVar.GetFileLockCount() == 0 && writeLockVar.TryLock(NULL, NULL))
////			//----- _xZkqqHx_iDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
////			{
////				// writeLockVar.GetFileLockCount() != 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
////				// _xZkqqHx_jDkPiClGiClBiCmMiDeBiDhGiDiKjCiGiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
////				// _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
////				stDelDocId.insert(lDocId);
////			}
////		}
////	}
////	// _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
////	longSet::const_iterator iId;
////	for (iId = stDelDocId.begin(); iId != stDelDocId.end(); iId++)
////		UnregisterDocument(*iId);
////	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
////	if (BASE_CLASS::UpdateFile())
////	{
////		return TRUE;
////	} else
////	{
////		return FALSE;
////	}
////----- 05.12.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	if (GetIsModified())
//	//----- _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iCnMiClIiBeB_xHqqkZx_WRITE_xZkqqHx_iDgFiBfLiDhFiDiLiCmGiDeJiDiKiDfHiDgJiDiLiDgFiBfLiDhFiDiLiCmMjDoAjHgFiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiInJiCmIiCoJiNmFiPiJiCmMiImKjChFiCpAjCfEiClFiPgPiClHiBeC_xHqqkZx_
//		const DWORD dwRecordCount = GetRecordCount();
//		DWORD dwIndex;
//		for (dwIndex = 0;
//			 dwIndex != dwRecordCount &&
//			 dwIndex != m_vWriteTable.size();
//			 dwIndex++)
//		{
//			// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCmMjEoEiKhCiBeC_xHqqkZx_
//			const DWORD dwDataSize = GetRecordDataSize(dwIndex);
//			if (m_vWriteTable[dwIndex].first != dwDataSize) break;
//			// _xZkqqHx_iDgGiBfLiDfOjDoAjHgFiCmMjEoEiKhCiBeC_xHqqkZx_
//			BYTEVector vData(dwDataSize);
//			GetRecordData(&vData[0], dwDataSize, dwIndex);
//			if (memcmp(m_vWriteTable[dwIndex].second, &vData[0], dwDataSize) != 0)
//				break;
//		}
//		// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjDkPiClGiImKjChFiCnMiCmFiCmMiDfEiDeDiDfJiCmJiPgLiPkMiBeC_xHqqkZx_
//		if (dwIndex != dwRecordCount)
//			ReduceRecordCount(dwIndex);
//		// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_WRITE_xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//		for (; dwIndex != m_vWriteTable.size(); dwIndex++)
//			AppendRecord(m_vWriteTable[dwIndex].second, m_vWriteTable[dwIndex].first);
//
//		// WRITE_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//		for (dwIndex = 0;
//			 dwIndex != m_vWriteTable.size();
//			 dwIndex++)
//		{
//			delete[] m_vWriteTable[dwIndex].second;
//		}
//		m_vWriteTable.clear();
//	}
//	return TRUE;
//} // FCHiProject::UpdateFile.
//----- 06.01.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetTitle ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	WString wstrTitle;
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(FDCT_ID_TITLE);
	if (i != m_mpHeaderIdToIndex.end())
	{
		// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		const BYTE* pData = GetControlData(vDataBuff, i->second);
		// _xZkqqHx_iDfOiDeDiDgHiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		FFReadData(wstrTitle, pData);
	}
	return wstrTitle;
} // FCHiProject::GetTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTitle	:_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetTitle (const wchar_t* wcpTitle)
{
	BYTEVector vDataBuff;
	vDataBuff << WString(wcpTitle);
	SetHeaderRecord(FDCT_ID_TITLE, &vDataBuff[0], vDataBuff.size());
} // FCHiProject::SetTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnMiCoKiCoJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDhEiDeAiDeDiDiLiCpAjCeOiCkKiDiNiDgCiDeOiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iIpIiCkLiPgPiClHiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCHiProject::GetUserId ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	GUID guid = GUID_NULL;
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(FDCT_ID_USER_ID);
	if (i != m_mpHeaderIdToIndex.end())
	{
		// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		const BYTE* pData = GetControlData(vDataBuff, i->second);
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		FFReadData(guid, pData);
	}
	return guid;
} // FCHiProject::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnMiCoKiCoJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDhEiDeAiDeDiDiLiCpAjCeOiCkKiDiNiDgCiDeOiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iIpIiCkLiPgPiClHiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetUserId (const GUID& guidUserId)
{
	SetHeaderRecord(FDCT_ID_USER_ID, &guidUserId, sizeof(guidUserId));
} // FCHiProject::SetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetIsAllowToJoinUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiDePiDiLiBfLiDhGiCmJiDiBiDjDiDgPiBfLjCmHiJmBiCpAiLnGiOhOiClHiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeMjIfOiCpAiLnGiOhOiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::GetIsAllowToJoinUsersGroup ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	BOOL bIsAllowToJoinUsersGroup = FALSE;
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(FDCT_ID_ARROW_TO_JOIN);
	if (i != m_mpHeaderIdToIndex.end())
	{
		// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		const BYTE* pData = GetControlData(vDataBuff, i->second);
		// _xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
		FFReadData(bIsAllowToJoinUsersGroup, pData);
	}
	return bIsAllowToJoinUsersGroup;
} // FCHiProject::GetIsAllowToJoinUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetIsAllowToJoinUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiDePiDiLiBfLiDhGiCmJiDiBiDjDiDgPiBfLjCmHiJmBiCpAiLnGiOhOiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsAllowToJoinUsersGroup	:_xZkqqHx_iLeMjIfOiCpAiLnGiOhOiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetIsAllowToJoinUsersGroup (BOOL bIsAllowToJoinUsersGroup)
{
	SetHeaderRecord(FDCT_ID_ARROW_TO_JOIN, &bIsAllowToJoinUsersGroup, sizeof(bIsAllowToJoinUsersGroup));
} // FCHiProject::SetIsAllowToJoinUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiNoMjAkMjDpKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMjDpKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCHiProject::GetDate ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	FDSECTIME fdstDate = FALSE;
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(FDCT_ID_DATE);
	if (i != m_mpHeaderIdToIndex.end())
	{
		// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		const BYTE* pData = GetControlData(vDataBuff, i->second);
		// _xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
		FFReadData(fdstDate, pData);
	}
	return fdstDate;
} // FCHiProject::GetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiNoMjAkMjDpKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	date	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetDate (FDSECTIME fdstDate)
{
	SetHeaderRecord(FDCT_ID_DATE, &fdstDate, sizeof(fdstDate));
} // FCHiProject::SetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetComment ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	WString wstrComment;
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(FDCT_ID_COMMENT);
	if (i != m_mpHeaderIdToIndex.end())
	{
		// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		const BYTE* pData = GetControlData(vDataBuff, i->second);
		// _xZkqqHx_iDfCiDiBiDjDiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		FFReadData(wstrComment, pData);
	}
	return wstrComment;
} // FCHiProject::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpComm	:_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetComment (const wchar_t* wcpComm)
{
	BYTEVector vDataBuff;
	vDataBuff << WString(wcpComm);
	SetHeaderRecord(FDCT_ID_COMMENT, &vDataBuff[0], vDataBuff.size());
} // FCHiProject::SetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetIsUnknownFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::GetIsUnknownFile () const
{
	// _xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDeAiDeDiDiLiCmFiCkAiCoKiCmOiBeBjAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmGiCnNiCmIiClHiBeC_xHqqkZx_
	const WString wstrTmpDirPath = FFGetTmpDirectory();
	return (wcsncmp(wstrTmpDirPath, GetFilePath(), wstrTmpDirPath.GetLength()) == 0);
} // FCHiProject::GetIsUnknownFile.

//----- 06.02.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetIsUnknownFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsUnknownFile	:_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiProject::SetIsUnknownFile (BOOL bIsUnknownFile)
//{
//	SetHeaderRecord(FDCT_ID_IS_UNKNOWN, &bIsUnknownFile, sizeof(bIsUnknownFile));
//} // FCHiProject::SetIsUnknownFile.
//----- 06.02.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetMemberUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpGuidToUserName	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetMemberUserList (GuidToUserNameMap& mpGuidToUserName)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	map<GUID, DWORD>::const_iterator i;
	for (i = m_mpMemberUserToIndex.begin();
		 i != m_mpMemberUserToIndex.end(); i++)
	{
		GUID guidUserId;
		WString wstrUserName;
		GetMemberUser(guidUserId, wstrUserName, i->second);
		mpGuidToUserName[guidUserId] = wstrUserName;
	}
} // FCHiProject::GetMemberUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetMemberUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpNewMemberUserList	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetMemberUserList (const GuidToUserNameMap& mpNewMemberUserList)
{
	// _xZkqqHx_iMlLiNnNiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCkJiCoHiLkEjCmKiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
	GuidToUserNameMap mpCurrentRestGuid;
	// _xZkqqHx_iMlLiNnNiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	GetMemberUserList(mpCurrentRestGuid);
	// mpNewMemberUserList_xZkqqHx_iCkJiCoHiLkEjCmKiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
	// _xZkqqHx_jAfGiClFiCkCiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	GuidToUserNameMap mpNewRestGuid = mpNewMemberUserList;
	// _xZkqqHx_iLkEjCmKiCmMiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiBeBiOgDiCoIiDiBiDjDiDgPiBfLiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	FFIntersection(GuidToUserNameMap(), mpCurrentRestGuid, mpNewRestGuid);

	// _xZkqqHx_jAfGiClFiCkCiDiBiDjDiDgPiBfLiCmJjDpMiCoKjBnGiCkGiCoJiCmJiCmNiBeB_xHqqkZx_mpCurrentRestGuid _xZkqqHx_iCpAiNoNiPjMiClFiCmE_xHqqkZx_
	// mpNewRestGuid _xZkqqHx_iCpAjCmHiJmBiClHiCoKiCmOiCoGiCkCiBeC_xHqqkZx_

	// _xZkqqHx_iNoNiPjMiClHiCnHiCkLiDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stDeleteIndex;
	GuidToUserNameMap::const_iterator iGuid;
	for (iGuid = mpCurrentRestGuid.begin();
		 iGuid != mpCurrentRestGuid.end(); iGuid++)
	{
		stDeleteIndex.insert(m_mpMemberUserToIndex.find(iGuid->first)->second);
	}

	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!stDeleteIndex.empty())
		DeleteRecords(stDeleteIndex);

	for (iGuid = mpNewRestGuid.begin();
		 iGuid != mpNewRestGuid.end(); iGuid++)
	{
		BYTEVector vDataBuff;
		vDataBuff << iGuid->first << iGuid->second;
		AppendControlRecord(FDCT_TYPE_BINARY, FDCT_ID_MEMBER_USER, &vDataBuff[0], vDataBuff.size());
	}

	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkKiJpDiCoKiCmEiCkCiCoJiCmMiCmFiDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::SetMemberUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetMemberUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeBiDiGiBfLiDfFjGlMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrUserName:_xZkqqHx_iDiGiBfLiDfFjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwIndex		:_xZkqqHx_iDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetMemberUser (GUID& guidUserId, WString& wstrUserName, DWORD dwIndex)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iKmHjHjNiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
	BYTEVector vDataBuff;
	const BYTE* pData = GetControlData(vDataBuff, dwIndex);
	FFReadData(guidUserId, pData);
	FFReadData(wstrUserName, pData);
} // FCHiProject::GetMemberUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::JoinUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCmMiDiGiBfLiDfFiPoOjFpBiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid		:_xZkqqHx_iDiGiBfLiDfFiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpUserName	:_xZkqqHx_iDiGiBfLiDfFjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiCkKiBeB_xHqqkZx_GUID_xZkqqHx_iCmMiPkMiClDiCkCiPiHiCmJjFmAiCnEiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::JoinUsersGroup (const GUID& guid, const wchar_t* wcpUserName)
{
	// _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_mpMemberUserToIndex.find(guid) != m_mpMemberUserToIndex.end())
		return;
	BYTEVector vDataBuff;
	vDataBuff << guid << WString(wcpUserName);
	AppendControlRecord(FDCT_TYPE_BINARY, FDCT_ID_MEMBER_USER, &vDataBuff[0], vDataBuff.size());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkKiJpDiCoKiCmEiCkCiCoJiCmMiCmFiDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiOjOiKnEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::JoinUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UserIdToUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_GUID_xZkqqHx_iCmMiDiGiBfLiDfFjGlMiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:_xZkqqHx_iDiGiBfLiDfFiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiLpDjFlGiOjKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::UserIdToUserName (const GUID& guid)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiGiBfLiDfFiDhEiDeAiDeDiDiLiCpAiMjPiNpF_xHqqkZx_ -----
	map<GUID, DWORD>::const_iterator iUs = m_mpMemberUserToIndex.find(guid);
	if (iUs == m_mpMemberUserToIndex.end()) return L"";
	GUID guidUserId;
	WString wstrUserName;
	GetMemberUser(guidUserId, wstrUserName, iUs->second);
	return wstrUserName;
} // FCHiProject::UserIdToUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::IsMemberOfUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_GUID_xZkqqHx_iCmMiDiGiBfLiDfFjGlMiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:_xZkqqHx_iDiGiBfLiDfFiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::IsMemberOfUsersGroup (const GUID& guid) const
{
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (!GetIsReadLocked()) FFThrowMiscUnknown();
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return (m_mpMemberUserToIndex.find(guid) != m_mpMemberUserToIndex.end());
} // FCHiProject::IsMemberOfUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetLimitedUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetLimitedUserList (set<GUID>& stUserId) const
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	map<GUID, DWORD>::const_iterator i;
	for (i = m_mpLimitedUserToIndex.begin();
		 i != m_mpLimitedUserToIndex.end(); i++)
		stUserId.insert(i->first);
} // FCHiProject::GetLimitedUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetLimitedUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiCmMiDiKiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stLimitedUserList	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetLimitedUserList (const set<GUID>& stNewLimitedUserList)
{
	// _xZkqqHx_iMlLiNnNiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCkJiCoHiLkEjCmKiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
	set<GUID> stCurrentRestGuid;
	// _xZkqqHx_iMlLiNnNiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	GetLimitedUserList(stCurrentRestGuid);
	// stNewLimitedUserList_xZkqqHx_iCkJiCoHiLkEjCmKiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
	// _xZkqqHx_jAfGiClFiCkCiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	set<GUID> stNewRestGuid = stNewLimitedUserList;
	// _xZkqqHx_iLkEjCmKiCmMiDiBiDjDiDgPiBfLiCpAiPjMiCkCiClNiBeBiOgDiCoIiDiBiDjDiDgPiBfLiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	FFIntersection(set<GUID>(), stCurrentRestGuid, stNewRestGuid);

	// _xZkqqHx_jAfGiClFiCkCiDiBiDjDiDgPiBfLiCmJjDpMiCoKjBnGiCkGiCoJiCmJiCmNiBeB_xHqqkZx_stCurrentRestGuid _xZkqqHx_iCpAiNoNiPjMiClFiCmE_xHqqkZx_
	// stNewRestGuid _xZkqqHx_iCpAjCmHiJmBiClHiCoKiCmOiCoGiCkCiBeC_xHqqkZx_

	// _xZkqqHx_iNoNiPjMiClHiCnHiCkLiDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stDeleteIndex;
	set<GUID>::const_iterator iGuid;
	for (iGuid = stCurrentRestGuid.begin();
		 iGuid != stCurrentRestGuid.end(); iGuid++)
	{
		stDeleteIndex.insert(m_mpLimitedUserToIndex.find(*iGuid)->second);
	}

	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!stDeleteIndex.empty())
		DeleteRecords(stDeleteIndex);

	for (iGuid = stNewRestGuid.begin();
		 iGuid != stNewRestGuid.end(); iGuid++)
	{
		const GUID guid = *iGuid;
		AppendControlRecord(FDCT_TYPE_BINARY, FDCT_ID_LIMITED_USER, &guid, sizeof(guid));
	}

	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkKiJpDiCoKiCmEiCkCiCoJiCmMiCmFiDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::SetLimitedUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::AddLimitedUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCpAjAkHiMmAiDiGiBfLiDfFiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:_xZkqqHx_iDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::AddLimitedUser (const GUID& guid)
{
	if (!IsMemberOfUsersGroup(guid))
		FFThrowMiscUnknown();
	// _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_mpLimitedUserToIndex.find(guid) != m_mpLimitedUserToIndex.end())
		return;
	AppendControlRecord(FDCT_TYPE_BINARY, FDCT_ID_LIMITED_USER, &guid, sizeof(guid));
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkKiJpDiCoKiCmEiCkCiCoJiCmMiCmFiDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiOjOiKnEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::AddLimitedUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::IsQualifiedToModify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCmJiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiPeDjAlDiClHiCoJiMkAiMmAiCkKiCkAiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMkAiMmAiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::IsQualifiedToModify (const GUID& guidUserId) const
{
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (!GetIsReadLocked()) FFThrowMiscUnknown();
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	switch (CheckQualification(guidUserId))
	{
	case LIMITED_USER:	// _xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	case NOT_MEMBER:	// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
		return FALSE;
	default:	// MEMBER_USER:	_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		return TRUE;
	}
} // FCHiProject::IsQualifiedToModify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::CheckQualification
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiBeFjAkHiMmAiDiGiBfLiDfFiBfLiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiCmMiOoNjHnOiBeC_xHqqkZx_
 *				NOT_MEMBER		:_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *				MEMBER_USER		:_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *				LIMITED_USER	:_xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiProject::Qualification FCHiProject::CheckQualification (const GUID& guidUserId) const
{
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClFiCmEiCkCiCmIiCkNiCmEiCoAiOoGjDlOiJmCjEfMiClOiCkKiBeBiDiNiDgCiDeOjBePjCpBiCmFiBeC_xHqqkZx_
//	if (!GetIsReadLocked()) FFThrowMiscUnknown();
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPjBiCkLiNjOiCnNiCpAjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBeI_xHqqkZx_
	if (m_mpLimitedUserToIndex.find(guidUserId) != m_mpLimitedUserToIndex.end())
		return LIMITED_USER;	// _xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsMemberOfUsersGroup(guidUserId))
		return MEMBER_USER;		// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	return NOT_MEMBER;			// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
} // FCHiProject::CheckQualification.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetDocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRec FCHiProject::GetDocumentRec (long lDocId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iOhHjCoIiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwIndex = FindEntry(FDCT_TYPE_GROUP, lDocId);
	// _xZkqqHx_iDePiDiLiBfLiDhGiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNjGlDiMpIiCmIiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
	if (dwIndex != DWORD(-1))
		return FCHiDocumentRec(this, lDocId, dwIndex);
	else
		return FCHiDocumentRec();
} // FCHiProject::GetDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFirstDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDiMiDfCiBfLiDgIiDgFiBfLiDhFiDiLiCmMiNmFiPiJiCmMiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDiMiDfCiBfLiDgIiDgFiBfLiDhFiDiLiCmMiNmFiPiJiCmMiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iBeCiDgFiBfLiDhFiDiLiCkKiLpDiCmMiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetNextDocumentId_xZkqqHx_iCmGjBgHiCnNiNiHiCoNiClJiCmEiBeBjBfDiDiMiDfCiBfLiDgIiCpAiPiHiOjPiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::GetFirstDocumentId () const
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	map<long, DWORD>::const_iterator i = m_mpDocumentIdToIndex.begin();
	if (i != m_mpDocumentIdToIndex.end())
		return long(i->first);
	return -1;
} // FCHiProject::GetFirstDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetNextDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCmMiOjPiCmMiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iBeCiDgFiBfLiDhFiDiLiCmMiPeJiCoNiCoIiCmJiOiKiCmBiClNiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::GetNextDocumentId (long lDocId) const
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	map<long, DWORD>::const_iterator i = m_mpDocumentIdToIndex.find(DWORD(lDocId));
	i++;
	if (i != m_mpDocumentIdToIndex.end())
		return long(i->first);
	return -1;
} // FCHiProject::GetNextDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::DocTitleVersionToDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBjGlMiBeBiDgPiBfLiDfHiDiHiDjDjGlMiCkJiCoHiBeBjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iIoKjChGiClHiCoJjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jFlGiPjBjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::DocTitleVersionToDocumentId (	const wchar_t* wcpDocTitle,
												const wchar_t* wcpVersion)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	long lId;
	for (lId = GetFirstDocumentId(); lId != -1; lId = GetNextDocumentId(lId))
	{
		// _xZkqqHx_jFlGiPjBjGlMiCmGiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (wcscmp(wcpDocTitle, GetDocumentRec(lId).GetDocTitle()) == 0 &&
			wcscmp(wcpVersion, GetDocumentRec(lId).GetVersion()) == 0)
			break;
	}
	return lId;
} // FCHiProject::DocTitleVersionToDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFreeDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLpDiCkCiCmEiCkCiCoJjHjKjHpAiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiClBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::GetFreeDocumentId (long lId) const
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iLpDiCkCiCmEiCkCiCoJ_xHqqkZx_Id_xZkqqHx_iCpAjCfEiClHiBeC_xHqqkZx_
	for (;;)
	{
		if (m_mpDocumentIdToIndex.find(DWORD(lId)) == m_mpDocumentIdToIndex.end())
			break;
		lId++;
	}
	return lId;
} // FCHiProject::GetFreeDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::FindDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMjFlGiPjBiCpAiMjPiNpFiClFiBeBiOhHjCoIiClDiCoKiClNiDfOiDeDiDgHiDiLiBeBiDgPiBfLiDfHiDiHiDjDiCmG_xHqqkZx_
 *			_xZkqqHx_iIoKjChGiClHiCoJjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDfOiDeDiDgHiDiLiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgPiBfLiDfHiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDocTitle = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiNmFiPiJiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeB_xHqqkZx_
 *			wcpVersion = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjFlGiPjBiDfOiDeDiDgHiDiLiCkKiIoKjChGiClHiCoJiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::FindDocumentId (const wchar_t* wcpDocTitle, const wchar_t* wcpVersion)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jDkPjGlMiBeFjDkPiDgPiBfLiDfHiDiHiDjDiCmMjHjKjHpAjFlGiPjBiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	long lDocId;
	FCHiDocumentRec hiDocRec;
	for (hiDocRec = GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 hiDocRec = GetNextHidocumentRec(lDocId))
	{
		if (wcpDocTitle != NULL &&
			wcscmp(wcpDocTitle, hiDocRec.GetDocTitle()) != 0) continue;
		if (wcpVersion != NULL &&
			wcscmp(wcpVersion, hiDocRec.GetVersion()) != 0) continue;
		break;
	}
	return lDocId;
} // FCHiProject::FindDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::RegisterDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMjHjKjHpAiDiMiDfCiBfLiDgIiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			writeLock	:_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			hiDocRecW	:_xZkqqHx_jDgPjIfOiClHiCoJiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId		:_xZkqqHx_jDgPjIfOiClHiCoJiDiMiDfCiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_-1 _xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_
 *						 _xZkqqHx_iLpDiCkCiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClFiClNiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAjAfGiClFiCkNjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCGroupRec_xZkqqHx_iBgKiCmGiKmHjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCTableRec_xZkqqHx_iBgKiCkK_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiCmNiBeBiDePiDiLiBfLiDhGiCfEiCmMiDeHiDjDiDgHiDiKiBfLiCkKjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfFiEkAiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::RegisterDocument (FCDbReadLock& readLock,
									FCDbWriteLock& writeLock,
									FCHiDocumentRecW& hiDocRecW,
									long lDocId)
{
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiBfLiDfOiMgAiOkOiCmFiOoGjDlOiBeC_xHqqkZx_
	BYTEVector vData;
	hiDocRecW.GetData(vData);
	// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCpAiNoMjAkMiBeC_xHqqkZx_
	FCDbGroup dbSubGroup = CreateSubGroup(readLock, writeLock, &vData[0], vData.size(), DWORD(lDocId));
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (dbSubGroup.GetIsInvalid())
//		FFThrowMiscUnknown();
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeCiPeDjFjMiDgDiBfLiDiLiCmFiPeDjFjMiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_"
	if (dbSubGroup.GetIsInvalid())
		FFThrowMiscException(IDS_ERR_MSG_REPAIR_DAMAGED_FILE, GetFilePath().c_str());
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
	// _xZkqqHx_jDgPjIfOiClDiCoKiClNiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	return long(dbSubGroup.GetGroupName().GetLast());
} // FCHiProject::RegisterDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UnregisterDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMjHjKjHpAiDiMiDfCiBfLiDgIiCmMjDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jDgPjIfOiCpAjGjFiPmBiClHiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::UnregisterDocument (long lDocId)
{
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteSubGroup(DWORD(lDocId));
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
} // FCHiProject::UnregisterDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::CalcUniqSubVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCmGjEoEiKhCiClFiCmEiBeBiDiGiDgKiBfLiDeOiCmI_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jHjKjHpAjFlGiPjBjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_iMlLiNnNiCmMiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpVersion_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCmJ_xHqqkZx_ ".n" _xZkqqHx_iCpAjCmHiJmBiClFiClN_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKjHpBiCpAjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCmGiClHiCoJiBeCiClBiCmMiOjOjCmHiJmBiClHiCoJjEnEiNiG_xHqqkZx_ n
 *			_xZkqqHx_iCkKiDfEiDhFiDgPiBfLiDfHiDiHiDjDiCmFiCkAiCoJiBeC_xHqqkZx_
 *			wcpDocTitle_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBjGlMiCmGjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDiCmMjBgHiCnNiNiHiCoNiClJ_xHqqkZx_
 *			_xZkqqHx_iCkKiDiGiDgKiBfLiDeOiCmFiCkAiCoKiCmOiBeB_xHqqkZx_n _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCHiProject::CalcUniqSubVersion (	const wchar_t* wcpDocTitle,
										const wchar_t* wcpVersion)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	WString wstrNewVer;	// _xZkqqHx_jAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjGlMiBeC_xHqqkZx_
	BOOL bUniq;			// _xZkqqHx_jFlGiPjBjGlMiBhLiDgPiBfLiDfHiDiHiDjDiCkKiDiGiDgKiBfLiDeOiCkJiBeI_xHqqkZx_
	int iSubVer = 0;	// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	do {
		// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAiIoKiCmCjBjNiCoCiClHiBeC_xHqqkZx_
		iSubVer++;
		bUniq = TRUE;
		// _xZkqqHx_iJlMiCmMjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
		wstrNewVer.Format(L"%s.%d", wcpVersion, iSubVer);
		long lDocId;
		FCHiDocumentRec hiDocRec;
		for (hiDocRec = GetFirstHidocumentRec(lDocId);
			 lDocId != -1 && bUniq;
			 hiDocRec = GetNextHidocumentRec(lDocId))
		{
			// _xZkqqHx_jFlGiPjBjGlMiCmGiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNiBeBiDiGiDgKiBfLiDeOiCmFiCmIiCkCiBeC_xHqqkZx_
			if (wcscmp(wcpDocTitle, hiDocRec.GetDocTitle()) == 0 &&
				wstrNewVer == hiDocRec.GetVersion())
				bUniq = FALSE;
		}
	} while (!bUniq);
	// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
	return iSubVer;
} // FCHiProject::CalcUniqSubVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::CalcUniqDocTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBjGlMiCmGjEoEiKhCiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjHjKjHpAjFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrNewTitle:_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjHjKjHpAjFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDocTitle	:_xZkqqHx_iMlDiCmMjHjKjHpAjFlGiPjBjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgPiBfLiDfHiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDocTitle_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNjHjKjHpAjFlGiPjBiCmGjDkPiClGjFlGiPjBjGlMiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmJ_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClBiCmMjFlGiPjBjGlMiCmMiMoDiCoLiCmJ_xHqqkZx_1,2,,_xZkqqHx_iCpAjCmHiJmBiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjFlGiPjBjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::CalcUniqDocTitle (	WString& wstrNewTitle,
										const wchar_t* wcpDocTitle,
										const wchar_t* wcpVersion)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	wstrNewTitle = wcpDocTitle;
	// _xZkqqHx_jDkPiClGjFlGiPjBiDfOiDeDiDgHiDiLiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDfOiDeDiDgHiDiLiCpAjFmPiNfIiClFiCmEiMjPiNpFiBeC_xHqqkZx_
	for (long lC = 0;
		 FindDocumentId(wstrNewTitle.c_str(), wcpVersion) != -1; lC++)
		wstrNewTitle.Format(L"%s%ld", wcpDocTitle, lC);
} // FCHiProject::CalcUniqDocTitle.

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::Clear
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeCiDiNiDgCiDeOiPoOjFpBiCoAiDeOiDiKiDeBiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiProject::Clear ()
//{
//	m_dwLockedDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwLockedAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Clear();
//} // FCHiProject::Clear.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetMemberUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAjFlGiOjKjHpBiCmGiClFiCmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetMemberUserListString ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	GuidToUserNameMap mpGuidToUserName;
	GetMemberUserList(mpGuidToUserName);
	WString wstrMemberUserList;
	MemberUserListToString(wstrMemberUserList, mpGuidToUserName);
	return wstrMemberUserList;
} // FCHiProject::GetMemberUserListString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetMemberUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpMemberString	:_xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAjFlGiOjKjHpBiCmGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetMemberUserListString (const wchar_t* wcpMemberString)
{
	GuidToUserNameMap mpMemberUserList;
	WString wstrMemberUserList;
	MemberStringToList(mpMemberUserList, wcpMemberString);
	SetMemberUserList(mpMemberUserList);
} // FCHiProject::SetMemberUserListString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetLimitedUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiCpAjFlGiOjKjHpBiCmGiClFiCmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetLimitedUserListString ()
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	set<GUID> stUserId;
	GetLimitedUserList(stUserId);
	WString wstrLimitedUserList;
	LimitedUserListToString(wstrLimitedUserList, stUserId);
	return wstrLimitedUserList;
} // FCHiProject::GetLimitedUserListString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetLimitedUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpLimitedString	:_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiCpAjFlGiOjKjHpBiCmGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetLimitedUserListString (const wchar_t* wcpLimitedString)
{
	set<GUID> stLimitedUserList;
	WString wstrLimitedUserList;
	LimitedStringToList(stLimitedUserList, wcpLimitedString);
	SetLimitedUserList(stLimitedUserList);
} // FCHiProject::SetLimitedUserListString.

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::IsRealTableReplaced
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjChFiKlHiClDiCoKiClNiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::IsRealTableReplaced () const
//{
//	return (m_guidTableGuid != g_pFileServer->GetLockedTableGuid(GetTableName()));
//} // FCHiProject::IsRealTableReplaced.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::IsRealTableRecordModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
// *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::IsRealTableRecordModified () const
//{
//	return	(m_dwLockedDeleteIdentifier !=
//			 g_pFileServer->GetLockedDeleteIdentifier(GetTableName())) ||
//			(m_dwLockedAppendIdentifier !=
//			 g_pFileServer->GetLockedAppendIdentifier(GetTableName()));
//} // FCHiProject::IsRealTableRecordModified.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UpdateData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	autoLockRead	:_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_Read_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *						 	 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiDiNiBfLiDgIiClFiBeBiPoOjFpBiCpAiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
// *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *			FCHiProject::UpdateData_xZkqqHx_iCmGiLeAjEfMiCmNjDkPjDjJiClOiCkKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiL_xHqqkZx_
// *			_xZkqqHx_iCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJjDfPiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_HPCFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmNjDmHiCnNiCmGiCmBiClNiMoDiCmJiDeOiDiNiBfLiDfJiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::UpdateData (const FCReadLockVar& autoLockRead)
//{
//	ASSERT(autoLockRead.IsLocked());
//	if (!IsRealTableRecordModified())
//	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiPeJiNfIjAfGiOjOiKnEiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCoKiCpAiNfIjAfGiClFiCmIiCkCiCmGiBeBiDhGiDiNiDfHiDeGiDeOiDgHiNfIjAfGiCmMiMgPiJnPiOjOiKnEiCkK_xHqqkZx_
//		// _xZkqqHx_jBoFiCkLiCkNiCmIiCmBiCmEiClFiCnMiCkCiBeB_xHqqkZx_OnFrameTimer _xZkqqHx_iCmFjFhAjEmJiCmJ_xHqqkZx_UpdateFile_xZkqqHx_iCkK_xHqqkZx_
//		// _xZkqqHx_iOmAiNhDiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//		SetIsModified(FALSE);
//		// _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
//		return FALSE;
//	}
//	if (BASE_CLASS::UpdateData())
//	{
//		return TRUE;
//	} else
//	{
//		return FALSE;
//	}
//} // FCHiProject::UpdateData.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UpdateFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	autoLockWrite	:_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_Write_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiBfLiDhFiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_HPCFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmNiPjBiCkLiNjOiCpBiClOiMoDiCmJiDeOiDiNiBfLiDfJiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCHiProject::UpdateData_xZkqqHx_iCmGiLeAjEfMiCmNjDkPjDjJiClOiCkKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiL_xHqqkZx_
// *			_xZkqqHx_iCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJjDfPiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::UpdateFile (const FCWriteLockVar& autoLockWrite)
//{
//	ASSERT(FFGetFileExtension(autoLockWrite.GetFilePath()) == L".mdpj");
//	ASSERT(GetFileAtom() == autoLockWrite.GetFileAtom());
//	ASSERT(autoLockWrite.IsLocked());
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiCmFiCmIiCkCiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiCmMiPjBiCkLiNjOiCnNiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
//	if (!IsQualifiedToModify(FFGetApp()->GetUserId()))
//		FFThrowMiscUnknown();
//	//---- _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCkKiCkAiCoKiCmOiBeBiNoNiPjMiClHiCoJ_xHqqkZx_ -----
//	longSet stDelDocId;
//	long lDocId;
//	for (GetFirstHidocumentRec(lDocId);
//		 lDocId != -1;
//		 GetNextHidocumentRec(lDocId))
//	{
//		if (GetIsTemporaryDocument(lDocId))
//		//----- _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			FCWriteLockVar writeLockVar(this, lDocId, FD_FILE_EXT_HIDOCUMENT);
//			if (writeLockVar.GetFileLockCount() == 0 && writeLockVar.TryLockExclusive(NULL, NULL))
//			//----- _xZkqqHx_iDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				// writeLockVar.GetFileLockCount() != 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
//				// _xZkqqHx_jDkPiClGiClBiCmMiDeBiDhGiDiKjCiGiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
//				// _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
//				stDelDocId.insert(lDocId);
//			}
//		}
//	}
//	// _xZkqqHx_jFhDjHhGiCmIiJlMjHjKjHpAjFlGiPjBiCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
//	longSet::const_iterator iId;
//	for (iId = stDelDocId.begin(); iId != stDelDocId.end(); iId++)
//		UnregisterDocument(*iId);
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	if (BASE_CLASS::UpdateFile())
//	{
//		return TRUE;
//	} else
//	{
//		return FALSE;
//	}
//} // FCHiProject::UpdateFile.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::LockAndUpdateData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiClFiClNiMoDiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkK_xHqqkZx_
// *			_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bUpdated		:_xZkqqHx_iDiNiBfLiDgIiBgJiNfIjAfGiBgKiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAiOpDiCkPiOoGiCoJjFmPjAjE_xHqqkZx_
// *							 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			autoLockRead	:_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_Read_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *						 	 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmJiPiIjHjNiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiDiNiBfLiDgIiClFiBeBiPoOjFpBiCpAiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
// *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jBlMiDeBiDhGiDiKjDjJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClFiClN_xHqqkZx_
// *			_xZkqqHx_iMoDiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_HPCFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmNjDmHiCnNiCmGiCmBiClNiMoDiCmJiDeOiDiNiBfLiDfJiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::LockAndUpdateData (BOOL& bUpdated, FCReadLockVar& autoLockRead)
//{
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpA_xHqqkZx_READ,SHARED_xZkqqHx_iCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	autoLockRead.SetFilePath(this, -1, NULL);
//	DWORD dwErrCode;
//	WString wstrErrMessage;
//	if (!autoLockRead.TryLockShared(&dwErrCode, &wstrErrMessage))
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiOjOiMmAiDhAiDgMiDiLiCmFjFfMiOkGiBeC_xHqqkZx_
//		FFErrorBox(wstrErrMessage);
//		return FALSE;
//	}
//	try
//	{
//		bUpdated = UpdateData(autoLockRead);
//	}
//	catch (CException* e)
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFfMiOkGiBeC_xHqqkZx_
//		e->ReportError();
//		e->Delete();
//		return FALSE;
//	}
//	return TRUE;
//} // FCHiProject::LockAndUpdateData.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::IsProjectOpened
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiProject::IsProjectOpened () const
{
	return !GetIsInvalid();
} // FCHiProject::IsProjectOpened.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SubDocumentIdToTopId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkJiCoHiBeBiClLiCmMjFlGiPjBiCkKjBkOiClHiCoJjGnIiNfMjBkCiCmMiDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_
 *			ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::SubDocumentIdToTopId (long lDocId)
{
	// _xZkqqHx_iPoDiImKjHjKjHpAiCkK_xHqqkZx_-1_xZkqqHx_iCmJiCmIiCoJiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
	for (;;)
	{
		const long lDocIdSuper = GetDocumentRec(lDocId).GetSuperDocId();
		if (lDocIdSuper == -1) break;
		lDocId = lDocIdSuper;
	}
	return lDocId;
} // FCHiProject::SubDocumentIdToTopId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetHidocumentTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Historic Draw,History Viewer_xZkqqHx_iCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *			bShort	:_xZkqqHx_jCfKiCkCiMgAiOkOiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetHidocumentTitle (long lDocId, BOOL bShort)
{
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();

	WString strTitle;
	WString wstrProjectTitle;
	if (GetIsUnknownFile())
	//----- _xZkqqHx_iIoKiOjOjDeJiCmIiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		wstrProjectTitle = FFGetApp()->GetDocString(CDocTemplate::docName);
	} else
	//----- _xZkqqHx_jAlDiOkOiCmIiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		wstrProjectTitle = GetFilePath();
//		// _xZkqqHx_jCfKiCkCiMgAiOkOiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLjGlMiCmMiCnNiBeC_xHqqkZx_
//		if (bShort)
//			wstrProjectTitle = FFGetFileName(wstrProjectTitle);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jCfKiCkCiMgAiOkOiCmMiPoKiNiHiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiCmMiCnNiBeC_xHqqkZx_
		if (bShort)
			wstrProjectTitle = GetTitle();
		else
			wstrProjectTitle = GetFilePath();
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (lDocId != -1L)
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		strTitle.Format(L"%s Ver %s %s",
						GetDocumentRec(lDocId).GetDocTitle().c_str(),
						GetDocumentRec(lDocId).GetVersion().c_str(),
						wstrProjectTitle.c_str());
	} else
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		strTitle.Format(L"%s", wstrProjectTitle.c_str());
	}
	return strTitle;
} // FCHiProject::GetHidocumentTitle.

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetDocumentPath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjAoCjBmOiDhAiDfIjGlMiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpExt	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_L".mdfk"_xZkqqHx_jDjJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiProject::GetDocumentPath (long lDocId, const wchar_t* wcpExt) const
//{
//	WString strPath = GetDirectoryPath();
//	// _xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeC_xHqqkZx_
//	if (GetDocumentRec(lDocId).GetIsInvalid())
//		FFThrowMiscException(IDS_ERR_MSG_DOC_IS_NOT_FOUND);
//	strPath += GetDocumentRec(lDocId).GetFilePath();
//	strPath += wcpExt;
//	return strPath;
//} // FCHiProject::GetDocumentPath.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetDocumentFileAtom
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiPjBiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDeBiDgHiDiAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpExt	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_L".mdfk"_xZkqqHx_jDjJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDeBiDgHiDiAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiProject::GetDocumentFileAtom (long lDocId, const wchar_t* wcpExt) const
//{
//	ASSERT(lDocId != -1);
//	if (wcsicmp(wcpExt, FD_FILE_EXT_HIDOCUMENT) == 0)
//		return g_pFileServer->QueryAtom(GetDocumentPath(lDocId, wcpExt), FD_YES, FD_YES);
//	else
//		return g_pFileServer->QueryAtom(GetDocumentPath(lDocId, wcpExt), FD_NO, FD_YES);
//} // FCHiProject::GetDocumentFileAtom.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetDocumentDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCpAiOjNiCmCjHjKjHpAjFlGiPjBiCmMiDhEiDeIiDiLiDfPiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDiLiDfPiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmJiCmNjBlGiNnNiClFiCmIiCkCjFlGiPjBiCmFiCkAiCmBiCmEiCoAiBeB_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDhEiDeIiDiLiDfPjGlMiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiProject::GetDocumentDirectory (long lDocId) const
//{
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
//	WString wstrDirPath;
//	wstrDirPath.Format(L"%s%x", GetDirectoryPath(), lDocId);
//	return wstrDirPath;
//} // FCHiProject::GetDocumentDirectory.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetIsUnknownFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsTemporary	:_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiProject::SetIsUnknownFile (BOOL bIsTemporary)
//{
//	if (bIsTemporary)
//	//----- _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmGiClFiCmEjAnNjCoIiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//// 05.08.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		m_mpHeadUnknown[FD_IS_UNKNOWN_FILE] = L"";
//		SetHeaderUnknownToken(FD_IS_UNKNOWN_FILE, L"");
//	} else
//	//----- _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCmNiCmIiCkCiCmGiClFiCmEjAnNjCoIiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//// 05.08.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		m_mpHeadUnknown.erase(FD_IS_UNKNOWN_FILE);
//		DeleteHeaderUnknownToken(FD_IS_UNKNOWN_FILE);
//	}
//} // FCHiProject::SetIsUnknownFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetIsUnknownFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::GetIsUnknownFile () const
//{
//	// _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiBeI_xHqqkZx_
//	return (GetHeaderUnknownToken(FD_IS_UNKNOWN_FILE) != NULL);
//} // FCHiProject::GetIsUnknownFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetIsTemporaryDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCkKiIoKiOjOjDeJiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiOjOjDeJiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::GetIsTemporaryDocument (long lDocId) const
//{
//	return (GetDocumentRec(lDocId).GetSuperDocId() == -2);
//} // FCHiProject::GetIsTemporaryDocument.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::RegisterDDDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiProject::RegisterDDDocument (	FCDbReadLock& readLock,
										FCDbWriteLock& writeLock,
										long lDocId,
										const wchar_t* wcpDocTitle,
										const GUID& guid,
										const wchar_t* wcpVersion,
										FDSECTIME fdstDate,
										const wchar_t* wcpComment,
										BOOL bIsLogCommandUserId,
										long lSuperDocId,
										double dHtreeScore)
{
//----- 06.01.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jAfGiClFiCkNjDgPjIfOiClHiCoJiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iBeC_xHqqkZx_
//	long lDocumentId = 0;
//	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoNiPjMiPiIjHjNiBeCiNoNiPjMiCmFiCkLiCmIiCkCiPoKiNiHiCmNiOjPiCmM_xHqqkZx_ID_xZkqqHx_iCnG_xHqqkZx_ -----
//	for (;;)
//	{
//		// _xZkqqHx_jDgPjIfOiClHiCoJiDiMiDfCiBfLiDgI_xHqqkZx_Id_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		lDocumentId = GetFreeDocumentId(lDocumentId + 1);
//		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeCjCmKiPoNiCmN_xHqqkZx_ "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_\_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ID"_xZkqqHx_iBeC_xHqqkZx_
//		WString wstrDirPath = GetDocumentDirectory(lDocumentId);
//		// _xZkqqHx_iKpJjBlGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//		FTFileKind fileKind = g_pFileServer->CheckTopGroupExist(wstrDirPath);
//		if (fileKind == FD_FILE_NOT_EXIST)
//		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			break;
//		} else
//		if (fileKind == FD_FILE_DIRECTORY)
//		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeCiNoNiPjMiCmFiCkLiClNiPoKiNiHiCmNiBeBiClBiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOgHiCkEiBeC_xHqqkZx_
//			// _xZkqqHx_iNoNiPjMiCmFiCkLiCmIiCkCiPoKiNiHiCmNiOjPiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCnGjAgJiCnOiBeC_xHqqkZx_
//			if (g_pFileServer->DeleteDirectory(wstrDirPath, NULL)) break;
//		} else
//		//----- _xZkqqHx_iClLiCmMjBlMiCmMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			FFThrowFileException(CFileException::accessDenied, -1, wstrDirPath);
//		}
//	}
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCnGjFlGiPjBjDgPjIfOiBeC_xHqqkZx_
//	const long lDtypeId = RegisterDtype(FD_HIDOCUMENT_TYPE);
//	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
//	WString wstrFileName;
//	wstrFileName.Format(L"%x\\h", lDocumentId);
//	RegisterDocument(FCHistoryDocRec(	lDtypeId,
//										lDocumentId,
//										wcpDocTitle,
//										guid,
//										wcpVersion,
//										fdstDate,
//										wcpComment,
//										wstrFileName,
//										bIsLogCommandUserId,
//										lSuperDocId,
//										dHtreeScore));
//	return lDocumentId;
//----- 06.01.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCHiDocumentRecW hiDocRecW;
	hiDocRecW.SetSuperDocId(lSuperDocId);					// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	hiDocRecW.SetDocTitle(wcpDocTitle);						// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
	hiDocRecW.SetVersion(wcpVersion);						// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	hiDocRecW.SetUserId(guid);								// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	hiDocRecW.SetDate(fdstDate);							// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	hiDocRecW.SetComment(wcpComment);						// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	hiDocRecW.SetIsLogCommandUserId(bIsLogCommandUserId);	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
	hiDocRecW.SetHtreeScore(dHtreeScore);					// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return RegisterDocument(readLock,
							writeLock,
							hiDocRecW,
							lDocId);
//----- 06.01.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiProject::RegisterDDDocument.

//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::RegisterTempDDDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiProject::RegisterTempDDDocument (	FCDbReadLock& readLock,
//											FCDbWriteLock& writeLock,
//											const wchar_t* wcpDocTitle,
//											const GUID& guid,
//											const wchar_t* wcpVersion,
//											FDSECTIME fdstDate,
//											const wchar_t* wcpComment,
//											BOOL bIsLogCommandUserId,
//											double dHtreeScore)
//{
//	return RegisterDDDocument(	readLock,
//								writeLock,
//								wcpDocTitle,
//								guid,
//								wcpVersion,
//								fdstDate,
//								wcpComment,
//								bIsLogCommandUserId,
//								-2L,
//								dHtreeScore);
//} // FCHiProject::RegisterTempDDDocument.
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFileAtom
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
// *
//* <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiProject::GetFileAtom () const
//{
//	return g_pFileServer->QueryAtom(GetFilePath(), FD_NO, FD_YES);
//} // FCHiProject::GetFileAtom.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFirstHidocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_iNmFiPiJiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *					 -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRec FCHiProject::GetFirstHidocumentRec (long& lDocId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	lDocId = GetFirstDocumentId();
	if (lDocId == -1)
		return FCHiDocumentRec();
	else
		return GetDocumentRec(lDocId);
} // FCHiProject::GetFirstHidocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetNextHidocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjPiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jBfDiKeKiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiOjPiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
					 _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRec FCHiProject::GetNextHidocumentRec (long& lDocId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	lDocId = GetNextDocumentId(lDocId);
	if (lDocId == -1)
		return FCHiDocumentRec();
	else
		return GetDocumentRec(lDocId);
} // FCHiProject::GetNextHidocumentRec.

//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetHintText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiProject::GetHintText ()
//{
//	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmMiOjOiKnEiBeC_xHqqkZx_
//	COleDateTime otmDate = FdsecToFiletime(GetDate());
//	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
//	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
//	WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
//	WString wstrFilePath = GetIsUnknownFile() ? FFGetApp()->GetDocString(CDocTemplate::docName) :
//												GetFilePath();
//	// IDS_FORM_HTREE_PROPERTY_A =
//	// _xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_
//	// _xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
//	// _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_:%s\r\n
//	// _xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
//	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
//	// _xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_:%s
//	return FormatResString(	IDS_FORM_HTREE_PROPERTY_A,
//							GetTitle().c_str(),						// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//							wstrFilePath.c_str(),					// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
//							wstrDate.c_str(),						// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
//							UserIdToUserName(GetUserId()).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
//							GetComment().c_str());					// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
//} // FCHiProject::GetHintText.
//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetHidocumentTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMjGnIiNfMjBkCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stTopId		:_xZkqqHx_jGnIiNfMjBkCiCmMiDgHiDgCiDhGiCmGiCmIiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mpIdToSubId	:_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjGnIiNfMjBkCiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iDfEiDhFjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiCmNiBeBjFkBjAjEiCmMjGnIiNfMjBkCiCkKjBlGiNnNiClFjDlOiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjBiCoAjFkBjAjEjBlGiNnNiClFjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetHidocumentTree (longSet& stTopId, map<long, longSet>& mpIdToSubId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	stTopId.clear();
	mpIdToSubId.clear();
	long lDocId;
	FCHiDocumentRec hiDocRec;
	for (hiDocRec = GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 hiDocRec = GetNextHidocumentRec(lDocId))
	{
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (hiDocRec.GetIsTemporary()) continue;
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// lDocId_xZkqqHx_iCpAjDgPjIfOiBeC_xHqqkZx_
		mpIdToSubId[lDocId];
		long lSuperId = GetDocumentRec(lDocId).GetSuperDocId();
		if (lSuperId == -1)
			stTopId.insert(lDocId);
		else
			mpIdToSubId[lSuperId].insert(lDocId);
	}
} // FCHiProject::GetHidocumentTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetSubHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiBeBiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHiDocId	:lHiDocId_xZkqqHx_iImIiJlKiCmMjHjKjHpAjFlGiPjBiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHiDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpIdToSubId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iDfEiDhFjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myGetSubHidocument (longSet& stHiDocId,
								long lHiDocId,
								const map<long, longSet>& mpIdToSubId)
{
	stHiDocId.insert(lHiDocId);
	const longSet& stSubId = (*mpIdToSubId.find(lHiDocId)).second;
	longSet::const_iterator i;
	for (i = stSubId.begin(); i != stSubId.end(); i++)
	{
		myGetSubHidocument(stHiDocId, *i, mpIdToSubId);
	}
} // myGetSubHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetLowerHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHiDocId	:lHiDocId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *						 lHiDocId _xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *			lHiDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetLowerHidocument (longSet& stHiDocId, long lHiDocId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	stHiDocId.clear();
	longSet stTopId;
	map<long, longSet> mpIdToSubId;
	GetHidocumentTree(stTopId, mpIdToSubId);
	myGetSubHidocument(stHiDocId, lHiDocId, mpIdToSubId);
} // FCHiProject::GetLowerHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetSubHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMjClMiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHiDocId	:lHiDocId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAjFlGiPjBjClMiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *						 lHiDocId _xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *			lHiDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::GetSubHidocument (longSet& stHiDocId, long lHiDocId)
{
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
	map<long, longSet> mpIdToSubId;
	GetHidocumentTree(longSet(), mpIdToSubId);
	stHiDocId = (*mpIdToSubId.find(lHiDocId)).second;
} // FCHiProject::GetSubHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetUniqSubDocumentVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFlGiPjBiCmMiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSuperDocId	:_xZkqqHx_iPoDiImKiCmMjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeCjHoBiBeG_xHqqkZx_3.4 _xZkqqHx_iBgJiPoDiImKjFlGiPjBiCkK_xHqqkZx_Ver=3_xZkqqHx_iCmMiPoKiNiHiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetUniqSubDocumentVersion (long lSuperDocId)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!GetIsReadLocked()) FFThrowMiscUnknown();
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	FCHiDocumentRec hiSuperDocRec = GetDocumentRec(lSuperDocId);
	// _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCkJiCoHiBeBiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
	int iSubVersion = CalcUniqSubVersion(	hiSuperDocRec.GetDocTitle(),
											hiSuperDocRec.GetVersion());
	return FFFormatString(L"%s.%d", hiSuperDocRec.GetVersion().c_str(), iSubVersion);
} // FCHiProject::GetUniqSubDocumentVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFilePathH
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString FCHiProject::GetFilePathH () const
{
	return GetTableName().GetTopDirPath();
} // FCHiProject::GetFilePathH.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiProject::GetFilePath () const
{
	return WString(GetFilePathH());
} // FCHiProject::GetFilePath.

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::FindHidocumentId
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiPjBiDfOiDeDiDgHiDiLiBeBiDgPiBfLiDfHiDiHiDjDiCmGiIoKjChGiClHiCoJjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDfOiDeDiDgHiDiLiCmJiIoKjChG_xHqqkZx_
// *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgPiBfLiDfHiDiHiDjDiCmJiIoKjChG_xHqqkZx_
// *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDocTitle = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiNmFiPiJiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeB_xHqqkZx_
// *			wcpVersion = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjFlGiPjBiDfOiDeDiDgHiDiLiCkKiIoKjChGiClHiCoJiNmFiPiJiCmM_xHqqkZx_
// *			_xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiProject::FindHidocumentId (const wchar_t* wcpDocTitle, const wchar_t* wcpVersion) const
//{
//	return FindDocumentId(wcpDocTitle, wcpVersion);
//} // FCHiProject::FindHidocumentId.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::MemberUserListToString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiBiDjDiDgPiBfLiCmMiDgOiDgCiDfGiDiFiCkJiCoHjEhKjHpBjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrMemberUserList	:_xZkqqHx_iDiBiDjDiDgPiBfLjEhKjHpBjFlGiOjKjHpBjFnEiClHiBeC_xHqqkZx_
 *			mpMemberUserList	:_xZkqqHx_iDiBiDjDiDgPiBfLiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::MemberUserListToString (WString& wstrMemberUserList, const GuidToUserNameMap& mpMemberUserList)
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeBiDiGiBfLiDfFjGlMiCmMjEhKjHpBjFlGiOjKjHpBiBeC_xHqqkZx_
	wstrMemberUserList.Empty();
	// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMiDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	GuidToUserNameMap::const_iterator iUm;
	for (iUm = mpMemberUserList.begin(); iUm != mpMemberUserList.end(); iUm++)
	{
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
		FFAppendString(wstrMemberUserList, FFGuidToString((*iUm).first));
		// _xZkqqHx_iDiGiBfLiDfFjGlMiCpAjCmHiJmBiBeC_xHqqkZx_
		FFAppendString(wstrMemberUserList, (*iUm).second.c_str());
	}
} // FCHiProject::MemberUserListToString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::MemberStringToList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiBiDjDiDgPiBfLiCmMjEhKjHpBjFlGiOjKjHpBiCkJiCoHiDiBiDjDiDgPiBfLiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpMemberUserList	:_xZkqqHx_iDiBiDjDiDgPiBfLiDgOiDgCiDfGiDiFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrMemberUserList	:_xZkqqHx_iDiBiDjDiDgPiBfLjEhKjHpBjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::MemberStringToList (GuidToUserNameMap& mpMemberUserList, WString wstrMemberUserList)
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	mpMemberUserList.clear();
	while (!wstrMemberUserList.IsEmpty())
	{
		// _xZkqqHx_iCmCiCmIiCkCiClOjFlGiOjKjHpBiCkJiCoHiIoKiCmCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		GUID guidUserId = FFStringToGuid(FFExtractString(wstrMemberUserList));
		// _xZkqqHx_iCmCiCmIiCkCiClOjFlGiOjKjHpBiCkJiCoHiIoKiCmCiCmMiDiGiBfLiDfFjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		WString wstrUserName = FFExtractString(wstrMemberUserList);
		// _xZkqqHx_iDgOiDgCiDfGiDiFiCmJjCmHiJmBiBeC_xHqqkZx_
		mpMemberUserList[guidUserId] = wstrUserName.c_str();
	}
} // FCHiProject::MemberStringToList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::LimitedUserListToString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjAkHiMmAiDiGiBfLiDfFiCmMiDgOiDgCiDfGiDiFiCkJiCoHjEhKjHpBjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrLimitedUserList	:_xZkqqHx_jAkHiMmAiDiGiBfLiDfFjEhKjHpBjFlGiOjKjHpBjFnEiClHiBeC_xHqqkZx_
 *			stLimitedUserList	:_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::LimitedUserListToString (WString& wstrLimitedUserList, const set<GUID>& stLimitedUserList)
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeBiDiGiBfLiDfFjGlMiCmMjEhKjHpBjFlGiOjKjHpBiBeC_xHqqkZx_
	wstrLimitedUserList.Empty();
	// _xZkqqHx_jAkHiMmAiDiGiBfLiDfFiCmMiDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	set<GUID>::const_iterator iUm;
	for (iUm = stLimitedUserList.begin(); iUm != stLimitedUserList.end(); iUm++)
	{
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
		FFAppendString(wstrLimitedUserList, FFGuidToString(*iUm));
	}
} // FCHiProject::LimitedUserListToString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::LimitedStringToList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjAkHiMmAiDiGiBfLiDfFiCmMjEhKjHpBjFlGiOjKjHpBiCkJiCoHjAkHiMmAiDiGiBfLiDfFiCmMiPfHiNiHiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stLimitedUserList	:_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrLimitedUserList	:_xZkqqHx_jAkHiMmAiDiGiBfLiDfFjEhKjHpBjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::LimitedStringToList (set<GUID>& stLimitedUserList, WString wstrLimitedUserList)
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiCmMiPfHiNiHiBeC_xHqqkZx_
	stLimitedUserList.clear();
	while (!wstrLimitedUserList.IsEmpty())
	{
		// _xZkqqHx_iCmCiCmIiCkCiClOjFlGiOjKjHpBiCkJiCoHiIoKiCmCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		GUID guidUserId = FFStringToGuid(FFExtractString(wstrLimitedUserList));
		// _xZkqqHx_iPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
		stLimitedUserList.insert(guidUserId);
	}
} // FCHiProject::LimitedStringToList.

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetIsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiProject::GetIsModified () const
//{
//	return (m_fdtmLastUpdatedTime == 0);
//} // FCHiProject::GetIsModified.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetIsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bUpdated	:_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCmJ_xHqqkZx_TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiCmGiBeB_xHqqkZx_UpdateFile _xZkqqHx_iCmFiDhEiDeAiDeDiDiLiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiProject::SetIsModified (BOOL bUpdated)
//{
//	if (bUpdated)
//		m_fdtmLastUpdatedTime = 0;
//	else
//		m_fdtmLastUpdatedTime = FFGetCurrentTime();
//} // FCHiProject::SetIsModified.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::ClearProperty
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjDoAjFjEiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmMiCkEiClPiBeBjBkOjAkLiPoOjFpBiCmMiCnNiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiProject::ClearProperty ()
//{
//	SetIsModified(TRUE);
//	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_mpHeaderIdToIndex.clear();
//	m_mpMemberUserToIndex.clear();
//	m_mpLimitedUserToIndex.clear();
//	m_mpDocumentIdToIndex.clear();
//} // FCHiProject::ClearProperty.
//----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetHeaderRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPjFjEjFkKiCmMiDiMiDfCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId		:ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_iDgGiBfLiDfOjFjEjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szDataSize	:pData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetHeaderRecord (DWORD dwId, const void* pData, size_t szDataSize)
{
	// _xZkqqHx_iKpJjBlGiDiMiDfCiBfLiDgIiCpAiMjPiNpFiBeC_xHqqkZx_
	map<DWORD, DWORD>::const_iterator i = m_mpHeaderIdToIndex.find(dwId);
	// _xZkqqHx_iKpJjBlGiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (i != m_mpHeaderIdToIndex.end())
		DeleteRecord(i->second);
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendControlRecord(FDCT_TYPE_BINARY, dwId, pData, szDataSize);
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::SetHeaderRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::SetDocumentRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPjFjEjFkKiCmMiDiMiDfCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId		:ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_iDgGiBfLiDfOjFjEjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szDataSize	:pData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::SetDocumentRecord (long lDocumentId, const void* pData, size_t szDataSize)
{
	// _xZkqqHx_iKpJjBlGiDiMiDfCiBfLiDgIiCpAiMjPiNpFiBeC_xHqqkZx_
	map<long, DWORD>::const_iterator i = m_mpDocumentIdToIndex.find(lDocumentId);
	// _xZkqqHx_iKpJjBlGiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (i != m_mpDocumentIdToIndex.end())
		DeleteRecord(i->second);
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendControlRecord(FDCT_TYPE_GROUP, DWORD(lDocumentId), pData, szDataSize);
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateHash();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	SetIsModified(TRUE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::SetDocumentRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::GetControlData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDiMiDfCiBfLiDgIiCmMiCkEiClPiBeBiDfOiDeDiDhGiCmG_xHqqkZx_ID_xZkqqHx_iCpAiPjMiCkCiClNiOgDiCoIiCmMiDgGiBfLiDfOjFjEjFkKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDataBuff	:_xZkqqHx_iDgGiBfLiDfOjFjEiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMjAoGjDkKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const BYTE* FCHiProject::GetControlData (BYTEVector& vDataBuff, DWORD dwIndex)
{
	BYTE byType;
	DWORD dwId;
	GetControlRecord(byType, dwId, &vDataBuff, dwIndex);
	return &vDataBuff[0];
} // FCHiProject::GetControlData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiProject::UpdateHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjHhAiCmJiKgHjCkDiClDiCoKiClNiKmHjHjNiDgFiBfLiDhFiDiLiCmJiCmNiBeBiDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCmMjBlMiCmJiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmJiKnGiClHiCoJiPoOjFpBiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiKnGiClHiCoJiPoOjFpBiCmNiBeBiDfOiDeDiDhGiBiB_xHqqkZx_FDCT_TYPE_BINARY_xZkqqHx_iBeB_xHqqkZx_
 *			ID_xZkqqHx_iBiB_xHqqkZx_FDCT_ID_TITLE_xZkqqHx_iBgA_xHqqkZx_FDCT_ID_LIMITED_USER _xZkqqHx_iCmJiOpLjEfLiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMiPoOjFpBiCmNiBeBjBgGjBiBiCkNiOoGiCoIiPgPiClJiCoJiCoGiCkEiDgOiDgCiDfGiDiFiCmFiKmHjHjNiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiProject::UpdateHash ()
{
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeB_xHqqkZx_ -----
	// _xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_(FDCT_ID_TITLE)_xZkqqHx_iBgAjAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_(FDCT_ID_COMMENT) _xZkqqHx_iCpAiKmHjHjNiClHiCoJiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpHeaderIdToIndex.clear();
	// _xZkqqHx_iDiBiDjDiDgPiBfLiIoKjHjH_xHqqkZx_(FDCT_ID_MEMBER_USER)_xZkqqHx_iCpAiKmHjHjNiClHiCoJiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpMemberUserToIndex.clear();
	// _xZkqqHx_jAkHiMmAiDiGiBfLiDfFiBfL_xHqqkZx_(FDCT_ID_LIMITED_USER)_xZkqqHx_iCpAiKmHjHjNiClHiCoJiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpLimitedUserToIndex.clear();
	// _xZkqqHx_jFlGiPjBiCpAiKmHjHjNiClHiCoJiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpDocumentIdToIndex.clear();
	// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const DWORD dwRecordCount = GetRecordCount();
	DWORD dwIndex;
	for (dwIndex = 0; dwIndex != dwRecordCount; dwIndex++)
	{
		// _xZkqqHx_iKmHjHjNiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCpAiNgMjHlGiClFiCmEiCkCiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		BYTE byType;
		DWORD dwId;
		BYTEVector vDataBuff;
		GetControlRecord(byType, dwId, &vDataBuff, dwIndex);
		const BYTE* pData = &vDataBuff[0];
		switch (byType)
		{
		case FDCT_TYPE_BINARY:	// _xZkqqHx_iDgPiDeDiDgJiDiKiDgGiBfLiDfOiBeC_xHqqkZx_
		  {
			GUID guid;
			switch (dwId)
			{
			case FDCT_ID_TITLE:				// 
			case FDCT_ID_USER_ID:			// 
			case FDCT_ID_ARROW_TO_JOIN:		// 
			case FDCT_ID_DATE:				// 
			case FDCT_ID_COMMENT:			// 
// 06.02.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//			case FDCT_ID_IS_UNKNOWN:		// 
				m_mpHeaderIdToIndex[dwId] = dwIndex;
				break;
			case FDCT_ID_MEMBER_USER:		// 
				FFReadData(guid, pData);
				m_mpMemberUserToIndex[guid] = dwIndex;
				break;
			case FDCT_ID_LIMITED_USER:		// 
				FFReadData(guid, pData);
				m_mpLimitedUserToIndex[guid] = dwIndex;
				break;
			}
			break;
		  }
		case FDCT_TYPE_GROUP:	// _xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_
		  {
			m_mpDocumentIdToIndex[dwId] = dwIndex;
			break;
		  }
		}
	}

	// _xZkqqHx_iPeDjAlD_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	ResetVirtualTableIdentifier();
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidTableGuid = g_pFileServer->GetLockedTableGuid(GetTableName());
//	// _xZkqqHx_iNfIjAfG_xHqqkZx_ID_xZkqqHx_iCpAiNmFjAfGiCmJiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(GetTableName());
//	m_dwLockedAppendIdentifier = g_pFileServer->GetLockedAppendIdentifier(GetTableName());
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHiProject::UpdateHash.

