#include "stdafx.h"
#include "UtilMath.h"		// For fli_abs.
#include "DynamicDb.h"		// For g_pFileServer.
#include "HiSpotTable.h"	// This header.

// 06.01.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#define SPOT_FILE_KIND L"HistoricDraw HiSpotTable"

//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiKnEiKhFiCmMiNmFiPkMiDfKiDgCiDfGiDiHiDjDjCgMiBeC_xHqqkZx_
//#define FD_MIN_SPOT_DIFF 1000
//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////
// FCHiSpotTable_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::FCHiSpotTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiSpotTable::FCHiSpotTable ()
{
	Clear();
} // FCHiSpotTable::FCHiSpotTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::FCHiSpotTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiSpotTable::FCHiSpotTable (const FCDbGroup& dbGroup)
			:	BASE_CLASS()
{
	Clear();
	Set(dbGroup.GetGroupName().PushBack(FDHI_SPOT_TABLE_ID));
} // FCHiSpotTable::FCHiSpotTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::~FCHiSpotTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiSpotTable::~FCHiSpotTable ()
{
	Clear();
} // FCHiSpotTable::~FCHiSpotTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiSpotTable::operator = (const FCDbGroup& dbGroup)
{
	Clear();
	Set(dbGroup.GetGroupName().PushBack(FDHI_SPOT_TABLE_ID));
} // FCHiSpotTable::operator.

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::IsRealTableReplaced
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjChFiKlHiClDiCoKiClNiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiSpotTable::IsRealTableReplaced () const
//{
//	return (m_guidTableGuid != g_pFileServer->GetLockedTableGuid(GetTableName()));
//} // FCHiSpotTable::IsRealTableReplaced.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::IsRealTableRecordModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
// *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiSpotTable::IsRealTableRecordModified () const
//{
//	return	(m_dwLockedDeleteIdentifier !=
//			 g_pFileServer->GetLockedDeleteIdentifier(GetTableName())) ||
//			(m_dwLockedAppendIdentifier !=
//			 g_pFileServer->GetLockedAppendIdentifier(GetTableName()));
//} // FCHiSpotTable::IsRealTableRecordModified.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::UpdateData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiPoOjFpBiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_CFCDDFileException,CFileException_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiSpotTable::UpdateData (const FCDbReadLock& readLock)
//{
//	ASSERT(readLock.IsLocked());
//	if (!IsRealTableRecordModified())
//	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
//		return FALSE;
//	} else
//	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//		m_guidTableGuid = g_pFileServer->GetLockedTableGuid(GetTableName());
//		// _xZkqqHx_iNfIjAfG_xHqqkZx_ID_xZkqqHx_iCpAiNmFjAfGiCmJiBeC_xHqqkZx_
//		m_dwLockedDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(GetTableName());
//		m_dwLockedAppendIdentifier = g_pFileServer->GetLockedAppendIdentifier(GetTableName());
//		return TRUE;
//	}
//} // FCHiSpotTable::UpdateData.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::Clear
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiSpotTable::Clear ()
//{
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Clear();
//	// _xZkqqHx_jDoAjFjEiPoOjFpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_guidTableGuid = GUID_NULL;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwLockedAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//} // FCHiSpotTable::Clear.
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::AppendSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiPoOjFpBiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
 *			fliCmdFilePtr	:_xZkqqHx_iClBiCmMjHjKjHpAjCiGiCmMiBeBiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			wcpSpotPref		:_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiBeCjAoCjBmOiDhAiDfIiCmFiOhHjCoIiBeCiKgHjCkDiOhBiCoAjHeMiCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiCkKiBeBiDhEiDeAiDeDiDiLiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFmAiCnEiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAlDiOkOiCmIiDfIiDhMiDgCiDgHiCmGiCmNiBeBiDfKiDgCiDfGiDiHiDjDiLjHjHkDiCmFiIoKjCoIiCmMiKnEiKhFiCmFjEhKjChFiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfIiDhMiDgCiDgHiBeCjAlDiOkOiCmFiCmIiCkCiDfIiDhMiDgCiDgHiCmGiCmNiBeBjHjKjHpAjFlGiPjBiCmMiPeJjCfLiCmJjHjKjHpAjFlGiPjBiCmMjFnLjBlGiOjO_xHqqkZx_
 *			_xZkqqHx_iCmJjAnNjChFiClDiCoKiCoJiDfIiDhMiDgCiDgHiBeCiOjPiCmMiNfIjAfGiOjOiCmJjDfAiLiOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiSpotTable::AppendSpot (flint fliSessionIndex,
								const void* pData,
								DWORD dwDataSize)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendRecord(fliSessionIndex, pData, dwDataSize);
//----- 06.02.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_Identifier_xZkqqHx_iCpAiLeMjIfOiClFiClNjFmPjAjEiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	ResetVirtualTableIdentifier();
//----- 06.02.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCHiSpotTable::AppendSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::DeleteSpotAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiImIiNhOiCmMiDfIiDhMiDgCiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmN_xHqqkZx_ fliSessionIndex _xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Undo_xZkqqHx_iMoDiCmMiPjBiCkLiNjOiCnNiCmJjBmOiJjOiClHiCoJiClNiCnPiBeBiDfKiDgCiDfGiDiHiDjDiImKjChFiImIiNhOiCmMiDfIiDhMiDgCiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 *                          3   4   5   6   7   8   9   10  11   _xZkqqHx_iBkJ_xHqqkZx_NextSessionIndex
 *                          _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                          _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgD_xHqqkZx_
 *            CommandTable  _xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_ 8_xZkqqHx_iEkA_xHqqkZx_ 9_xZkqqHx_iEkA_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkJ_xHqqkZx_Session Index
 *                          _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgD_xHqqkZx_
 *                          _xZkqqHx_iEkA_xHqqkZx_0   1 _xZkqqHx_iEkA_xHqqkZx_2   3 _xZkqqHx_iEkA_xHqqkZx_4   5 _xZkqqHx_iEkA_xHqqkZx_6   7 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkJ_xHqqkZx_Record Index
 *                          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                          _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgD_xHqqkZx_
 *               SpotTable  _xZkqqHx_iEkA_xHqqkZx_Spot 3_xZkqqHx_iEkA_xHqqkZx_Spot 5_xZkqqHx_iEkA_xHqqkZx_Spot 7_xZkqqHx_iEkA_xHqqkZx_Spot 9_xZkqqHx_iEkA_xHqqkZx_Spot11_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkJ_xHqqkZx_Session Index
 *                          _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgD_xHqqkZx_
 *                              0       1       2       3       4        _xZkqqHx_iBkJ_xHqqkZx_Record Index
 *
 *			_xZkqqHx_iPoDjAhNiCpAjHoBiCmJiNgMiCkGiCoJiBeC_xHqqkZx_
 *			NextSessionIndex = 6 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Session 5 _xZkqqHx_iImIiPoDiCkKiPjBiCkLiKlHiCkGiCoHiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmJiCmIiCoJiBeCiPfNiCmBiCmE_xHqqkZx_ Session 6 _xZkqqHx_iImIiPoDiCmM_xHqqkZx_Spot_xZkqqHx_iBeBjBkGiClP_xHqqkZx_ Spot 7_xZkqqHx_iBeB_xHqqkZx_Spot 9 _xZkqqHx_iBgD_xHqqkZx_
 *			_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			NextSessionIndex = 7 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Session 6 _xZkqqHx_iImIiPoDiCkKiPjBiCkLiKlHiCkGiCoHiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmJiCmIiCoJiBeCiClBiCmMiPoKiNiHiCmN_xHqqkZx_ Session 7 _xZkqqHx_iImIiPoDiCmM_xHqqkZx_Spot_xZkqqHx_iBeBjBkGiClP_xHqqkZx_
 *			Spot 7_xZkqqHx_iBeB_xHqqkZx_Spot 9 _xZkqqHx_iBgDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiSpotTable::DeleteSpotAfter (flint fliSessionIndex)
{
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCmGjDkPiClGiCkJjBoFiCkLiCkCiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOjNiCmC_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiDiMiDfCiBfLiDgIiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
	const DWORD dwIndex = PrimaryIdToLowerBoundIndex(fliSessionIndex);
	// _xZkqqHx_iOhHjCoIiDeDiDjDiDgGiDgCiDeOiDfIiImIiNhOiCmMiDiMiDfCiBfLiDgIiCkKjHeMiCoJiPoKiNiHiCmNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	if (dwIndex != DWORD(-1))
	{
		ReduceRecordCount(dwIndex);
//----- 06.02.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_Identifier_xZkqqHx_iCpAiLeMjIfOiClFiClNjFmPjAjEiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
		ResetVirtualTableIdentifier();
//----- 06.02.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // FCHiSpotTable::DeleteSpotAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::IsThereSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjDeFiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiImKjChFiCmJiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCkKiCkAiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiSpotTable::IsThereSpot (flint fliSessionIndex)
{
	return !(FindSpot(fliSessionIndex).IsEnd());
} // FCHiSpotTable::IsThereSpot.

//----- 06.01.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::SearchPath2
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAiDhEiDeAiDeDiDiLiCmMiImKjChFiCmMjFjEjFgJiDeDiDiBiBfLiDfHiCpAjDlOiCoJiClNiCnPiCmJiBeB_xHqqkZx_
// *			_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiCmGjHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiInKjDkOiMlDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndexSpot:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCmM_xHqqkZx_
// *							 _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			fdstSessionTime	:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCmM_xHqqkZx_
// *							 _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
// *			fliCmdPtrSpot	:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *			wstrSpotPath	:_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCiDhEiDeAiDeDiDiLjGlMiCmJiCmNiBeBiDhAiDfIiCmG_xHqqkZx_
// *						 _xZkqqHx_iKgHjCkDiOhBiCkKiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
// *			fliSessionIndex:_xZkqqHx_iMjPiNpFiClHiCoJjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliDistMin	:_xZkqqHx_iMjPiNpFiCmMiKoOiPiAiCmGiCmIiCoJiBeBiDfIiDhMiDgCiDgHiCmGjGnKjDeJiCnMiCmFiCmMiLjHjHkDiCmMiNmFjCoBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiImKjChFiCkJiCoHiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_fliCmdPtrSpot = FLINT_MAX,
// *			fliSessionIndexSpot = FLINT_MAX _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	fliSessionIndex_xZkqqHx_iCmJiNmFiCoAiLnPiCkCiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCpAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLjGlMiCmGiBeBiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint FCHiSpotTable::SearchPath2 (	flint* fliSessionIndexSpot,
//									flint fliSessionIndex,
//									flint fliDistMin)
//{
//	if (GetRecordCount() == 0)
//		return FLINT_MAX;
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGjDkPiClGiCkJiBeBiClLiCmMjClMiMoDiCmMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	DWORD dwIndex = PrimaryIdToLowerBoundIndex(fliSessionIndex);
//	DWORD dwIndexFrom;
//	DWORD dwIndexTo;
//	if (dwIndex == DWORD(-1))
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiNmFiMoDiCmMiDfIiDhMiDgCiDgHiImKjChFiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		dwIndexFrom = GetRecordCount() - 1;
//		dwIndexTo = dwIndexFrom;
//	} else
//	if (dwIndex == 0)
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiNmFiPiJiCmMiDfIiDhMiDgCiDgHiImKjChFiImIiJlKiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		dwIndexFrom = 0;
//		dwIndexTo = 0;
//	} else
//	{
//		dwIndexFrom = dwIndex - 1;
//		dwIndexTo = dwIndex;
//	}
//	for (dwIndex = dwIndexFrom; dwIndex <= dwIndexTo; dwIndex++)
//	{
//		// _xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		flint fliPrimaryId = GetRecordPrimaryId(dwIndex);
//		// _xZkqqHx_iLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
//		flint fliDist = (fliPrimaryId < fliSessionIndex) ?
//						fliSessionIndex - fliPrimaryId :
//						fliPrimaryId - fliSessionIndex;
//		// _xZkqqHx_iNmFiCoAiLnPiCkCiLjHjHkDiCmIiCoHiCmOiBeBiNfIjAfGiBeC_xHqqkZx_
//		if (fliDist < fliDistMin)
//		{
//			fliDistMin = fliDist;
//			// _xZkqqHx_iKgFjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
//			if (fliSessionIndexSpot != NULL)
//				*fliSessionIndexSpot = fliPrimaryId;
//		}
//	}
//	return fliDistMin;
//} // FCHiSpotTable::SearchPath2.
//----- 06.01.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::FindNearestSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJiNmFiCoAiLnPiCkCiDfIiDhMiDgCiDgHiCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliDistMin	:_xZkqqHx_iMjPiNpFiCmMiKoOiPiAiCmGiCmIiCoJiBeBiDfIiDhMiDgCiDgHiCmGjGnKjDeJiCnMiCmFiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_iNmFjCoBjCgMiCpAiOhHjCoIiBeCiMkJiCmCiCkJiCmBiClNiDfIiDhMiDgCiDgHiCmGiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *			fliSessionIndex:_xZkqqHx_iMjPiNpFiClHiCoJjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDeDiDfOiDiMiBfLiDfOiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::FindNearestSpot (flint& fliDistMin,
													flint fliSessionIndex)
{
	if (GetRecordCount() == 0)
		return FCSpotConstIterator();

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGjDkPiClGiCkJiBeBiClLiCmMjClMiMoDiCmMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORD dwIndex = PrimaryIdToLowerBoundIndex(fliSessionIndex);
	DWORD dwIndexFrom;
	DWORD dwIndexTo;
	if (dwIndex == DWORD(-1))
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiNmFiMoDiCmMiDfIiDhMiDgCiDgHiImKjChFiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_ -----
	{
		dwIndexFrom = GetRecordCount() - 1;
		dwIndexTo = dwIndexFrom;
	} else
	if (dwIndex == 0)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiNmFiPiJiCmMiDfIiDhMiDgCiDgHiImKjChFiImIiJlKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		dwIndexFrom = 0;
		dwIndexTo = 0;
	} else
	{
		dwIndexFrom = dwIndex - 1;
		dwIndexTo = dwIndex;
	}
	DWORD dwIndexMin = DWORD(-1);
	for (dwIndex = dwIndexFrom; dwIndex <= dwIndexTo; dwIndex++)
	{
		// _xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		flint fliPrimaryId = GetRecordPrimaryId(dwIndex);
		// _xZkqqHx_iLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		flint fliDist = (fliPrimaryId < fliSessionIndex) ?
//						fliSessionIndex - fliPrimaryId :
//						fliPrimaryId - fliSessionIndex;
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		flint fliDist = fli_abs(fliSessionIndex - fliPrimaryId);
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiCoAiLnPiCkCiLjHjHkDiCmIiCoHiCmOiBeBiNfIjAfGiBeC_xHqqkZx_
		if (fliDist < fliDistMin)
		{
			fliDistMin = fliDist;
			dwIndexMin = dwIndex;
		}
	}
	if (dwIndexMin != DWORD(-1))
		return FCSpotConstIterator(this, dwIndexMin);
	else
		return FCSpotConstIterator();
} // FCHiSpotTable::FindNearestSpot.
//----- 06.01.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.01.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetFirstSpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCSpotIterator FCHiSpotTable::GetFirstSpot ()
//{
//	return FCSpotIterator(this, m_mpSpotList.begin());
//} // FCHiSpotTable::GetFirstSpot.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetLowerBoundSpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDjJiClFiCkCiCkJiBeBiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmM_xHqqkZx_
// *			_xZkqqHx_jHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCSpotIterator FCHiSpotTable::GetLowerBoundSpot (flint fliSessionIndex)
//{
//	return FCSpotIterator(this, m_mpSpotList.lower_bound(fliSessionIndex));
//} // FCHiSpotTable::GetLowerBoundSpot.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetUpperBoundSpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmMjHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCSpotIterator FCHiSpotTable::GetUpperBoundSpot (flint fliSessionIndex)
//{
//	return FCSpotIterator(this, m_mpSpotList.upper_bound(fliSessionIndex));
//} // FCHiSpotTable::GetUpperBoundSpot.
//----- 06.01.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetFirstSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDiKiDfIiDgHiCmMiNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::GetFirstSpot ()
{
	return FCSpotConstIterator(this, 0);
} // FCHiSpotTable::GetFirstSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetLastSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMjAlDiOkOiDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiDfKiDgCiDfGiDiHiDjDiImKjChFiBeCjBlGiNnNiClFiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::GetLastSpot ()
{
	if (GetRecordCount() == 0)
		return FCSpotConstIterator(this, 0);
	else
		return FCSpotConstIterator(this, GetRecordCount() - 1);
} // FCHiSpotTable::GetLastSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetLowerBoundSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDjJiClFiCkCiCkJiBeBiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::GetLowerBoundSpot (flint fliSessionIndex)
{
	DWORD dwIndex = PrimaryIdToLowerBoundIndex(fliSessionIndex);
	if (dwIndex == DWORD(-1))
		dwIndex = GetRecordCount();
	return FCSpotConstIterator(this, dwIndex);
} // FCHiSpotTable::GetLowerBoundSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetUpperBoundSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCoGiCoIjBoFiCkLiCkCiNmFiPiJiCmMjHhGjBgGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::GetUpperBoundSpot (flint fliSessionIndex)
{
	DWORD dwIndex = PrimaryIdToUpperBoundIndex(fliSessionIndex);
	if (dwIndex == DWORD(-1))
		dwIndex = GetRecordCount();
	return FCSpotConstIterator(this, dwIndex);
} // FCHiSpotTable::GetUpperBoundSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::FindSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiImKjChFiCmJiCkAiCoJiDfIiDhMiDgCiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDfOiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSpotConstIterator FCHiSpotTable::FindSpot (flint fliSessionIndex)
{
	DWORD dwIndex = PrimaryIdToIndex(fliSessionIndex);
	if (dwIndex == DWORD(-1))
		dwIndex = GetRecordCount();
	return FCSpotConstIterator(this, dwIndex);
} // FCHiSpotTable::FindSpot.

//----- 06.01.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::IsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UpdateData_xZkqqHx_iMoDiCmJiBeBiPoOjFpBiCkKiPeDjAlDiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiSpotTable::IsModified () const
//{
//	// _xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAjFnEiClHiBeC_xHqqkZx_
//	return m_bUpdated;
//} // FCHiSpotTable::IsModified.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetFileAtom
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
// *
//* <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCHiSpotTable::GetFileAtom () const
//{
//	return m_pProject->GetDocumentFileAtom(m_lDocumentId, L".mdsi");
//} // FCHiSpotTable::GetFileAtom.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::GetHiSpotTablePath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiBeBiDfIiDhMiDgCiDgHiCmM_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjFnEiClHiBeCjAoCjBmOiDhAiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiSpotTable::GetHiSpotTablePath (flint fliSessionIndex) const
//{
//	return FFFormatString(L"%s\\s_%I64x.mdwk",
//						(const wchar_t*)m_pProject->GetDocumentDirectory(m_lDocumentId),
//						fliSessionIndex);
//} // FCHiSpotTable::GetHiSpotTablePath.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiSpotTable::ClearProperty
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHiSpotTable::ClearProperty ()
//{
//	m_dwLockedDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwLockedAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	// _xZkqqHx_iNfIjAfGiOjOiKnEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_bUpdated = TRUE;
//	m_mpSpotList.clear();		// _xZkqqHx_iDfIiDhMiDgCiDgHiDhEiDeAiDeDiDiLiDiKiDfIiDgHiBeC_xHqqkZx_
//} // FCHiSpotTable::ClearProperty.
//----- 06.01.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
