// LayerListCtrl.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilWin.h"		// FFInsertColumn.
#include "RegData.h"		// For FCRegData.
#include "DlgInputStr.h"	// For CFCDlgInputStr.
#include "LayerManager.h"	// For FDOZ_ON_XXXX.
#include "LayerListCtrl.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const int FDLL_VIEW_POINT_CLM	= 0;
const int FDLL_LAYER_NAME_CLM	= 1;
const int FDLL_IS_PRINT_CLM		= 2;
const int FDLL_IS_DISPLAY_CLM	= 3;
const int FDLL_CAN_SELECT_CLM	= 4;
const int FDLL_CAN_EDIT_CLM		= 5;

#define FDLL_VIEW_POINT_WIDTH	30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_LAYER_NAME_WIDTH	80		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiNmFiPkMjCgMiBeC_xHqqkZx_
#define FDLL_IS_PRINT_WIDTH		30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_IS_DISPLAY_WIDTH	30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_CAN_SELECT_WIDTH	30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_CAN_EDIT_WIDTH		30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCLayerListCtrl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::CFCLayerListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCLayerListCtrl::CFCLayerListCtrl ()
{
	m_lCurrentLayer = 0;			// _xZkqqHx_iOiLjDfPiBeC_xHqqkZx_
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_bIsMoving = FALSE;		// _xZkqqHx_iInKjDkOjCiGiBeI_xHqqkZx_
//	m_dwNewLayerId = DWORD(-1);	// _xZkqqHx_iDiMiDeDiDiEiBfLiCpAjAfGiLeLiNoMjAkMiClHiCoJiOjOiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCLayerListCtrl::CFCLayerListCtrl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::~CFCLayerListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCLayerListCtrl::~CFCLayerListCtrl ()
{
} // CFCLayerListCtrl::~CFCLayerListCtrl.

/////////////////////////////////////////////////////////////////////////////
// CFCLayerListCtrl _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::Initialize ()
{
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_imageList.Create(16, 16, ILC_MASK, 4, 4);
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CURRENT_MARK));		// Image 0.
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CHECK_UNMARKED));		// Image 1.
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CHECK_MARKED));		// Image 2.
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CHECK_HALF_MARKED));	// Image 3.

	m_imageHeadList.Create(16, 16, ILC_MASK, 6, 4);
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_LAYER_EYE));	// Image 0.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_NAME_TAG));	// Image 1.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_PRINTER));	// Image 2.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_DISPLAY));	// Image 3.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_SELECT));		// Image 4.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_EDIT));		// Image 5.

	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIjGlDiClFiPpDjBnEiCmFiCoAjBeJjBpAiDhNiBfLiDeOiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDfOiDeDiDiLjFmPiNfIiBeC_xHqqkZx_
	ModifyStyle(0, LVS_SHOWSELALWAYS);
	// _xZkqqHx_iDeBiDeDiDfCiDjDjFfMiOkGjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetImageList(&m_imageList, LVSIL_SMALL);
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	pHdrCtrl->SetImageList(&m_imageHeadList);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjBhNjDpM_xHqqkZx_ -----
	int iC;
	// _xZkqqHx_iOiLjDfP_xHqqkZx_\n_xZkqqHx_iDiMiDeDiDiEiBfLjGlM_xHqqkZx_\n_xZkqqHx_jFfMiOkG_xHqqkZx_\n_xZkqqHx_iIpDiNpM_xHqqkZx_\n_xZkqqHx_jBeJjBpA_xHqqkZx_\n_xZkqqHx_jFmPiNfIiBeC_xHqqkZx_
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_LAYER_LIST_CTRL);
	FFInsertColumn(this, FDLL_VIEW_POINT_CLM, ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_VIEW_POINT_WIDTH);
	FFInsertColumn(this, FDLL_LAYER_NAME_CLM, ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_LAYER_NAME_WIDTH);
	FFInsertColumn(this, FDLL_IS_PRINT_CLM,   ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_IS_PRINT_WIDTH);
	FFInsertColumn(this, FDLL_IS_DISPLAY_CLM, ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_IS_DISPLAY_WIDTH);
	FFInsertColumn(this, FDLL_CAN_SELECT_CLM,::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_CAN_SELECT_WIDTH);
	FFInsertColumn(this, FDLL_CAN_EDIT_CLM,  ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, FDLL_CAN_EDIT_WIDTH);
	//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	HD_ITEM curItem;
	for (iC = 0; iC < pHdrCtrl->GetItemCount(); iC++)
	{
// 01.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (_xZkqqHx_iDiKiDiKiBfLiDfIjEmFiCmFjHiOiClPiCoJ_xHqqkZx_)
//		pHdrCtrl->GetItem(iC, &curItem);
		curItem.mask= HDI_IMAGE | HDI_FORMAT;
		curItem.iImage= iC;
		curItem.fmt= HDF_CENTER | HDF_IMAGE | HDF_STRING | HDF_BITMAP;
		pHdrCtrl->SetItem(iC, &curItem);
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateColumnWidth();
} // CFCLayerListCtrl::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::ClearContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::ClearContents ()
{
	m_lCurrentLayer = 0;	// _xZkqqHx_iOiLjDfPiBeC_xHqqkZx_
	m_mpIdToRec.clear();
	// Superclass_xZkqqHx_iBeC_xHqqkZx_
	BASE_CLASS::ClearContents();
} // CFCLayerListCtrl::ClearContents.

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetItemRec
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiDiMiDeDiDiEiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			itemRec	:_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCmNiBeBiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCmNiIoBiCkEiBgJiPoDiJlKiLhEiBgK_xHqqkZx_
// *			_xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const FCLayerCtrlRec* CFCLayerListCtrl::GetItemRec (long lIdx) const
//{
//	return &m_vLayerRec[GetItemData(lIdx)];
//} // CFCLayerListCtrl::GetItemRec.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::InsertItemRec
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiDeBiDeDiDgFiDiAiBgJiDiMiDeDiDiEiBfLiBgKiCpAjBhNjDpMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			itemRec	:_xZkqqHx_jBhNjDpMiClHiCoJiDeBiDeDiDgFiDiAiBgJiDiMiDeDiDiEiBfLiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiClDiCoKiClNiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long CFCLayerListCtrl::InsertItemRec (long lIdx, const FCLayerCtrlRec& itemRec)
//{
//	int iNewIdx = CListCtrl::InsertItem(lIdx, _T(""));
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCmMiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
//	m_vLayerRec.push_back(itemRec);
//	SetItemData(iNewIdx, m_vLayerRec.size() - 1);
//	UpdateCheckMark(iNewIdx);
//	return iNewIdx;
//} // CFCLayerListCtrl::InsertItemRec.
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::UpdateColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoIiCpAiPeJiCoNiCoHiClJiCmEiCkJiCoHiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::UpdateColumnWidth ()
{
	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	GetClientRect(rect);
	// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCmMjClHiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	long lLayerNameWidth = rect.Width() -
							(FDLL_VIEW_POINT_WIDTH + FDLL_IS_PRINT_WIDTH +
							 FDLL_IS_DISPLAY_WIDTH + FDLL_CAN_SELECT_WIDTH +
							 FDLL_CAN_EDIT_WIDTH);
	// _xZkqqHx_iNmFjCoBiCmMiDiMiDeDiDiEiBfLjGlMjClHiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
	if (lLayerNameWidth < FDLL_LAYER_NAME_WIDTH)
		lLayerNameWidth = FDLL_LAYER_NAME_WIDTH;
	// _xZkqqHx_iOgDiCoIiCmMiDeKiDiJiDiAjClHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetColumnWidth(FDLL_VIEW_POINT_CLM, FDLL_VIEW_POINT_WIDTH);
	SetColumnWidth(FDLL_LAYER_NAME_CLM, lLayerNameWidth);
	SetColumnWidth(FDLL_IS_PRINT_CLM, FDLL_IS_PRINT_WIDTH);
	SetColumnWidth(FDLL_IS_DISPLAY_CLM, FDLL_IS_DISPLAY_WIDTH);
	SetColumnWidth(FDLL_CAN_SELECT_CLM, FDLL_CAN_SELECT_WIDTH);
	SetColumnWidth(FDLL_CAN_EDIT_CLM, FDLL_CAN_EDIT_WIDTH);
} // CFCLayerListCtrl::UpdateColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::SetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCurIdx	:_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::SetCurrentLayerIdx (DWORD dwCurIdx)
{
	// _xZkqqHx_jAfGiClFiCkCiOiLjDfPiCmMiMhGiOfKiBeC_xHqqkZx_
	long lNewViewPoint = GetItemCount() - 1 - dwCurIdx;
	// _xZkqqHx_jFmPiNfIjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_lCurrentLayer == lNewViewPoint) return;
	// _xZkqqHx_iMmDiCkCiOiLjDfPiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(m_lCurrentLayer, m_lCurrentLayer);
	// _xZkqqHx_iOiLjDfPiCmMjAnNjCoIiBeC_xHqqkZx_
	m_lCurrentLayer = GetItemCount() - 1 - dwCurIdx;
	// _xZkqqHx_jAfGiClFiCkCiOiLjDfPiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(m_lCurrentLayer, m_lCurrentLayer);
	// _xZkqqHx_iKePjFjEiCkJiCoHiCmMiOmAiNhDiCmIiCmMiCmFiBeBiDiMiDeDiDiEiBfLiCmMjFmPiNfIiCmNjCmKjCgNiClFiCmIiCkCiBeC_xHqqkZx_
} // CFCLayerListCtrl::SetCurrentLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCLayerListCtrl::GetCurrentLayerIdx () const
{
	return GetItemCount() - 1 - m_lCurrentLayer;
} // CFCLayerListCtrl::GetCurrentLayerIdx.

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::SetNewLayerId
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjBhNjDpMiOjOiCmMiDiMiDeDiDiEiBfL_xHqqkZx_ID_xZkqqHx_iCmMiPiJiKpKjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwNewId	:_xZkqqHx_iPiJiKpKjCgMiBeCiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iCmGiPgEiCmIiCoHiCmIiCkCiCoGiCkEiCmJiBeB_xHqqkZx_
// *					 _xZkqqHx_jBoFiCkLiCkCjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::SetNewLayerId (DWORD dwNewId)
//{
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiCpAjAfGiLeLiNoMjAkMiClHiCoJiOjOiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	m_dwNewLayerId = dwNewId;
//} // CFCLayerListCtrl::SetNewLayerId.
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::AppendRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfCiBfLiDgIiCmMiDfCiDhDiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			rec		:_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::AppendRec (DWORD dwId, const FCLayerCtrlRec& rec)
{
	m_mpIdToRec[dwId] = LayerCtrlRecAuto(new FCLayerCtrlRec(rec));
} // CFCLayerListCtrl::AppendRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::SetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdSz	:dwId_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiPiHjEnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::SetIdOrder (DWORD dwIdSz, const DWORD dwId[])
{
	// _xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCpAiNoNiPjMiBgJiDiMiDfCiBfLiDgIiCmNiNoNiPjMiClFiCmIiCkCiBgKiBeC_xHqqkZx_
	DeleteAllItems();
	for (DWORD dwC = 0; dwC != dwIdSz; dwC++)
	{
		// LastItem_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		CListCtrl::InsertItem(dwC, _T(""));
		SetItemData(dwC, dwId[dwC]);
	}
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UpdateItemSize();
	UpdateScrollSize(TRUE);
} // CFCLayerListCtrl::SetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vdwId	:scid_xZkqqHx_iCmMjFfMiOkGiPiHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::GetIdOrder (DWORDVector& vdwId) const
{
	vdwId.clear();
	for	(long lIndex = 0; lIndex != GetItemCount(); lIndex++)
	{
		vdwId.push_back(GetItemData(lIndex));
	}
} // CFCLayerListCtrl::GetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCLayerCtrlRec* CFCLayerListCtrl::GetRec (DWORD dwId) const
{
	return (*m_mpIdToRec.find(dwId)).second.get();
} // CFCLayerListCtrl::GetRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::CanDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiNoNiPjMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::CanDeleteItem () const
{
	if (!BASE_CLASS::CanDeleteItem()) return FALSE;
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCkKiIoKiCmCiCoAiOgDiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (lMidItem == lMidSelected) return FALSE;
	return TRUE;
} // CFCLayerListCtrl::CanDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::CanMergeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiDhNiBfLiDfHiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::CanMergeItem () const
{
	if (!BASE_CLASS::CanMergeItem()) return FALSE;
	long lFrom;
	long lUntil;
	for (lFrom = 0; lFrom < GetItemCount(); lFrom++)
		if (IsSelectionMark(lFrom)) break;
	for (lUntil = lFrom; lUntil < GetItemCount(); lUntil++)
		if (!IsSelectionMark(lUntil)) break;
	// lUntil _xZkqqHx_iImIiNhOiCmJiBeBjEpCiCnBiJmOiClFiClNjBeJjBpAiMmCiPiKiCkKiCkAiCoKiCmOiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	for (long lIndex = lUntil; lIndex < GetItemCount(); lIndex++)
		if (IsSelectionMark(lIndex)) return FALSE;
	lUntil--;
	// _xZkqqHx_jBeJjBpAiMmCiPiKiCkKjGlDiCkPiCoKiCmOiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	if (lFrom == GetItemCount()) return FALSE;
	// _xZkqqHx_iNmFjCoBiCmFiCoAiCfBiCmCiImIiPoDjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	if (lFrom == lUntil) return FALSE;
	// _xZkqqHx_jBeJjBpAiMmCiPiKiCkKjBePjFpLiMmFjCoIiIoGiCmJjAeIiCkCiNjOiCpBiCmFiCkCiCoKiCmOiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	if (lFrom < GetFrontFixedItemSize()) return FALSE;
	// _xZkqqHx_jBeJjBpAiMmCiPiKiCkKiMoDjFpLiMmFjCoIiIoGiCmMiNmFiPiJiImIiNhOiCmJjAeIiCkCiNjOiCpBiCmFiCkCiCoKiCmOiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	if (GetItemCount() - GetBackFixedItemSize() < lUntil) return FALSE;
	// _xZkqqHx_iDhNiBfLiDfHiMoDiCmMjCiGiKnEiIoGiDeBiDeDiDgFiDiAiCkKiNmFjCoBiIoKiCmCiCmNiOgDiCmBiCmEiCkCiCmIiCkCiCmGiDhNiBfLiDfHjFhDiJmCiBeC_xHqqkZx_
	if (GetItemCount() - GetFrontFixedItemSize() - (lUntil - lFrom) <=
		GetBackFixedItemSize()) return FALSE;
	return TRUE;
} // CFCLayerListCtrl::CanMergeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::ItemRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiDiMiDeDiDiEiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerCtrlRec& CFCLayerListCtrl::ItemRec (DWORD dwId)
{
	return *(*m_mpIdToRec.find(dwId)).second.get();
} // CFCLayerListCtrl::GetItemRec.

//----- 01.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnUpdatePopupMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeB_xHqqkZx_
// *			_xZkqqHx_jGlDiMpIiCmMiDfCiDhNiDjDiDgIiCmNiDePiDiMiBfLiBjFjGlDiMpIiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMenu	:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnUpdatePopupMenu (CMenu* pMenu) const
//{
////----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	BOOL bSelected0 = (GetItemState(0, LVIS_SELECTED) == LVIS_SELECTED);
////	BOOL bSelectedN = (GetItemState(GetItemCount() - 1, LVIS_SELECTED) == LVIS_SELECTED);
////	int iSelCount = GetSelectedCount();
////	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiCpAiInKjDkO_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv() && !bSelected0 && !bSelectedN &&
////		0 < iSelCount && 2 < GetItemCount() - iSelCount)
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_BEGIN, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_BEGIN, MF_BYCOMMAND | MF_GRAYED);
////
////	//----- _xZkqqHx_jClMjBePiCmJiDiMiDeDiDiEiBfLjBhNjDpM_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv() && iSelCount == 1 && !bSelected0)
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_INSERT_PREV, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_INSERT_PREV, MF_BYCOMMAND | MF_GRAYED);
////
////	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiCpAiNoNiPjM_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv() && !bSelected0 && !bSelectedN &&
////		0 < iSelCount && 2 < GetItemCount() - iSelCount)
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_DELETE, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_DELETE, MF_BYCOMMAND | MF_GRAYED);
////
////	//----- _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjFmPiNfI_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv() && !bSelected0 && !bSelectedN && iSelCount == 1)
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_CHANGE, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_CHANGE, MF_BYCOMMAND | MF_GRAYED);
////----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnUpdatePopupMenu(pMenu);
//
//	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
//	long lFrontSelected;
//	long lMidSelected;
//	long lBackSelected;
//	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
//	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
//	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiCpAiDhNiBfLiDfH_xHqqkZx_ -----
//	DWORD dwEnable = MF_GRAYED;
//	if (FFCanEditDocumentEnv() && lFrontSelected == 0 && 1 < lSelected && 1 < GetItemCount() - lSelected)
//	{
//		dwEnable = MF_ENABLED;
//		POSITION pos = GetFirstSelectedItemPosition();
//		int iItem = GetNextSelectedItem(pos);
//		iItem++;
//		while (pos)
//		{
//			if (GetNextSelectedItem(pos) != iItem)
//			{
//				dwEnable = MF_GRAYED;
//				break;
//			}
//			iItem++;
//		}
//	}
//	pMenu->EnableMenuItem(ID_RBTN_ITEM_MERGE, MF_BYCOMMAND | dwEnable);
////----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiInKjDkOiCpAjCiGiOhO_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv())
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_CANCEL, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_CANCEL, MF_BYCOMMAND | MF_GRAYED);
////
////	//----- _xZkqqHx_jClMjBePiCmJiDiMiDeDiDiEiBfLiInKjDkO_xHqqkZx_ -----
////	if (FFCanEditDocumentEnv() && iSelCount == 1 && !bSelected0)
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_PREV, MF_BYCOMMAND | MF_ENABLED);
////	else
////		pMenu->EnableMenuItem(ID_RBTN_ITEM_MOVE_PREV, MF_BYCOMMAND | MF_GRAYED);
////----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // CFCLayerListCtrl::OnUpdatePopupMenu.
//----- 01.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::LayerMovePrev
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiImKjChFiCmMjClMjBePiCmJiBeB_xHqqkZx_CUT_xZkqqHx_iPoOjFpBiCkKjFhEiJmBiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCpAiInKjDkOiBeC_xHqqkZx_
// *			OnRbtnItemMovePrev_xZkqqHx_iCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lItemIns	:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::LayerMovePrev (long lItemIns)
//{
//	// _xZkqqHx_iInKjDkOjCiGiDhEiDiJiDePiCpAiJpAiPjMiBeC_xHqqkZx_
//	m_bIsMoving = FALSE;
//	//----- CUT _xZkqqHx_iPoOjFpBiCkKjFhEiJmBiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCmMiPoOjFpBiCpAjFnLjBlG_xHqqkZx_ -----
//	int iC;
//	DWORDVector vLayerRec;
//	for (iC = 0; iC < GetItemCount(); iC++)
//	{
//		if (GetItemState(iC, LVIS_CUT) == LVIS_CUT)
//		{
//			vLayerRec.push_back(GetItemData(iC));
//		}
//		// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAiDhNiBfLiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
//		if (GetItemState(iC, LVIS_SELECTED) == LVIS_SELECTED)
//			SetItemState(iC, 0, LVIS_SELECTED);
//	}
//	//----- _xZkqqHx_jBhNjDpMiImKjChFiCmJiBeBjFnLjBlGiClFiCmEiCkIiCkCiClNiDeBiDeDiDgFiDiAiCpAjBhNjDpM_xHqqkZx_ -----
//	while (!vLayerRec.empty())
//	{
//		CListCtrl::InsertItem(lItemIns, _T(""));
//		SetItemData(lItemIns, vLayerRec.back());
//		vLayerRec.pop_back();
//		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
//		SetItemState(lItemIns, LVIS_SELECTED, LVIS_SELECTED);
//	}
//	//----- _xZkqqHx_iNoNiPjMiDhNiBfLiDeOiCkKjFhEiJmBiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
//	for (iC = 0; iC < GetItemCount();)
//	{
//		if (GetItemState(iC, LVIS_CUT) == LVIS_CUT)
//		{
//			DeleteItem(iC);
//		} else
//		{
//			iC++;
//		}
//	}
//	// _xZkqqHx_jBfDiCmEiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	RedrawItems(0, GetItemCount());
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//	GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//} // CFCLayerListCtrl::LayerMovePrev.
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::UpdateCheckMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDfKiDfIiLjGiJmCiDhNiBfLiDeOiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeCiPpAiMiPiCmJiCoGiCmBiCmEiDgOiBfLiDhEiDgHiBfLiDjDiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::UpdateCheckMark (long lIndex)
{
	DWORD dwId = GetItemData(lIndex);
	if (GetRec(dwId)->nEdit)
	{
		// Display_xZkqqHx_iCmG_xHqqkZx_Select_xZkqqHx_iCkKiDhNiBfLiDeOiClDiCoKiCmEiCkCiCoKiCmOjCmKiPoNiCmMiDeBiDeDiDfCiDjD_xHqqkZx_(1)_xZkqqHx_iBeB_xHqqkZx_
		// _xZkqqHx_iClLiCoKiImIiKePiCmNiDgOiBfLiDhEiDgHiBfLiDjDiDeBiDeDiDfCiDjD_xHqqkZx_(2)_xZkqqHx_iBeC_xHqqkZx_
		if (GetRec(dwId)->nDraw && GetRec(dwId)->nSelect)
			ItemRec(dwId).nEdit = 1;
		else
			ItemRec(dwId).nEdit = 2;
	}
	if (GetRec(dwId)->nSelect)
	{
		// Display_xZkqqHx_iCkKiDhNiBfLiDeOiClDiCoKiCmEiCkCiCoKiCmOjCmKiPoNiCmMiDeBiDeDiDfCiDjD_xHqqkZx_(1)_xZkqqHx_iBeB_xHqqkZx_
		// _xZkqqHx_iClLiCoKiImIiKePiCmNiDgOiBfLiDhEiDgHiBfLiDjDiDeBiDeDiDfCiDjD_xHqqkZx_(2)_xZkqqHx_iBeC_xHqqkZx_
		if (GetRec(dwId)->nDraw)
			ItemRec(dwId).nSelect = 1;
		else
			ItemRec(dwId).nSelect = 2;
	}
	RedrawItems(lIndex, lIndex);
} // CFCLayerListCtrl::UpdateCheckMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetAccessStat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiDeBiDeOiDfKiDfIiPpAiMiPiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iSubItem:_xZkqqHx_iDeBiDeOiDfKiDfIiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0	:_xZkqqHx_iDeBiDeOiDfKiDfIjFhDiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_iDeBiDeOiDfKiDfIiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
 *			2	:_xZkqqHx_jAnNjCoIiCmNiDeBiDeOiDfKiDfIiJmCiClOiCkKiBeBjBlMiPpAiMiPiCmJiCoGiCoIjFhDiJmCiCmGiCmIiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short CFCLayerListCtrl::GetAccessStat (long lIndex, int iSubItem) const
{
	DWORD dwId = GetItemData(lIndex);
	switch (iSubItem)
	{
	case FDLL_IS_PRINT_CLM:
		return GetRec(dwId)->nPrint;
	case FDLL_IS_DISPLAY_CLM:
		return GetRec(dwId)->nDraw;
	case FDLL_CAN_SELECT_CLM:
		return GetRec(dwId)->nSelect;
	default:	// case FDLL_CAN_EDIT_CLM:
		return GetRec(dwId)->nEdit;
	}
} // CFCLayerListCtrl::GetAccessStat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::SetAccessStat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiDeBiDeOiDfKiDfIiPpAiMiPiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iSubItem:_xZkqqHx_iDeBiDeOiDfKiDfIiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nStat	:_xZkqqHx_iDeBiDeOiDfKiDfIiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	nStat_xZkqqHx_iCmNiImIiJlKiCmMjCgMiCpAjAnNjCoIiCmFiCkLiCoJiBeC_xHqqkZx_
 *			0	:_xZkqqHx_iDeBiDeOiDfKiDfIjFhDiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_iDeBiDeOiDfKiDfIiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
 *			2	:_xZkqqHx_jAnNjCoIiCmNiDeBiDeOiDfKiDfIiJmCiClOiCkKiBeBjBlMiPpAiMiPiCmJiCoGiCoIjFhDiJmCiCmGiCmIiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::SetAccessStat (long lIndex, int iSubItem, short nStat)
{
	DWORD dwId = GetItemData(lIndex);
	switch (iSubItem)
	{
	case FDLL_IS_PRINT_CLM:
		ItemRec(dwId).nPrint = nStat;
		break;
	case FDLL_IS_DISPLAY_CLM:
		ItemRec(dwId).nDraw = nStat;
		break;
	case FDLL_CAN_SELECT_CLM:
		ItemRec(dwId).nSelect = nStat;
		break;
	default:	// case FDLL_CAN_EDIT_CLM:
		ItemRec(dwId).nEdit = nStat;
	}
} // CFCLayerListCtrl::SetAccessStat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetFrontFixedItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFmAiCnBiCmMjBePjFpLiCmMiCkEiClPiBeBiNoNiPjMiBeFiInKjDkOiCkKiCmFiCkLiCmIiCkCiMmFjCoIiDeBiDeDiDgFiDiA_xHqqkZx_
 *			_xZkqqHx_iCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCLayerListCtrl::GetFrontFixedItemSize () const
{
	return 1;
} // CFCLayerListCtrl::GetFrontFixedItemSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetBackFixedItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFmAiCnBiCmMiMoDjFpLiCmMiCkEiClPiBeBiNoNiPjMiBeFiInKjDkOiCkKiCmFiCkLiCmIiCkCiMmFjCoIiDeBiDeDiDgFiDiA_xHqqkZx_
 *			_xZkqqHx_iCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCLayerListCtrl::GetBackFixedItemSize () const
{
	return 1;
} // CFCLayerListCtrl::GetBackFixedItemSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiPpAiMiPiCmFiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiDiBiDgKiDiFiBfLiCmMiBeB_xHqqkZx_IDR_RBTN_MULTI_xZkqqHx_iCmMjCiGiCmJ_xHqqkZx_
 *			_xZkqqHx_iCkIiCkPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeCjCmKiPoNiOjOiCmMiDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 0_xZkqqHx_iBeBiDeBiDeDiDgFiDiAiInKjDkOjCiGiCmM_xHqqkZx_
 *				 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCLayerListCtrl::GetSubMenuIndex (long lId) const
{
	if (lId == 0) return FD_MENU_MULT_LAYER_STATIC;
	return FD_MENU_MULT_LAYER_MOVING;
} // CFCLayerListCtrl::GetSubMenuIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnInsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjBhNjDpMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jBhNjDpMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiDeBiDeDiDgFiDiAiCkKiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::OnInsertItem (long lIndex, DWORD dwId)
{
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCLayerCtrlRec rec;
//	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_n"
//	rec.strName.Format(_T("%s%d"), ::GetResWString(IDS_UNTITLED_LAYER), dwId - 1);
//	rec.SetFlag(FDOZ_ON_ALL);
//	m_mpIdToRec[dwId] = LayerCtrlRecAuto(new FCLayerCtrlRec(rec));
//	return TRUE;
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjGlMjBePiCmMiIoKjHjHiCpAiOoGjDlO_xHqqkZx_ -----
	WStringSet stNameList;
	IdToLayerCtrlRecMap::const_iterator iRc;
	for (iRc = m_mpIdToRec.begin(); iRc != m_mpIdToRec.end(); iRc++)
		stNameList.insert((const wchar_t*)(*iRc).second->strName);

	//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCjGlMjBePiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
	WString strName;
	for (long lC = 1;; lC++)
	{
		// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_n"
		strName.Format(L"%s%d", ::GetResWString(IDS_UNTITLED_LAYER), lC);
		if (stNameList.find((const wchar_t*)strName) == stNameList.end()) break;
	}

	//----- _xZkqqHx_iNoMjAkMiClFiClNjGlMjBePiCmFiDiMiDfCiBfLiDgIiCpAjDgPjIfO_xHqqkZx_ -----
	FCLayerCtrlRec rec;
	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_n"
	rec.strName = strName;
	rec.SetFlag(FDOZ_ON_ALL);
	m_mpIdToRec[dwId] = LayerCtrlRecAuto(new FCLayerCtrlRec(rec));
	return TRUE;
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCLayerListCtrl::OnInsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjFmPiNfIiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjFmPiNfIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::OnChangeItem (long lIndex, DWORD dwId)
{
	// _xZkqqHx_jGlMjBePiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiBeC_xHqqkZx_
	CFCDlgInputStr dlgStr;
	// "_xZkqqHx_jDgPjIfOjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_";
	dlgStr.m_strTitle.LoadString(IDS_MSG_INPUT_ENTRY_NAME);
	dlgStr.m_strInput = GetRec(dwId)->strName;
	if (dlgStr.DoModal() != IDOK) return FALSE;
	ItemRec(dwId).strName = TStrToWStr(dlgStr.m_strInput);
	return TRUE;
} // CFCLayerListCtrl::OnChangeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiNoNiPjMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiNoNiPjMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::OnDeleteItem (long lIndex, DWORD dwId)
{
	if (GetItemCount() - 1 == m_lCurrentLayer)
		m_lCurrentLayer--;
	m_mpIdToRec.erase(dwId);
	return TRUE;
} // CFCLayerListCtrl::OnDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnMergeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiDhNiBfLiDfHiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndexFrom	:_xZkqqHx_iDhNiBfLiDfHjBmOiPnLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexUntil	:_xZkqqHx_iDhNiBfLiDfHjBmOiPnLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDhNiBfLiDfHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lIndexUntil_xZkqqHx_iCkKiDhNiBfLiDfHjAoGiCmMiDeBiDeDiDgFiDiAiBeC_xHqqkZx_lIndexUntil - 1 _xZkqqHx_iCkJiCoH_xHqqkZx_
 *			lIndexFrom_xZkqqHx_iCnMiCmFiBgJ_xHqqkZx_lIndexFrom_xZkqqHx_iCpAiKnMiCnOiBgKiCpAiPiHiOjP_xHqqkZx_
 *			lIndexUntil_xZkqqHx_iDeBiDeDiDgFiDiAiCmJiDhNiBfLiDfHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCLayerListCtrl::OnMergeItem (long lIndexFrom, long lIndexUntil)
{
	if (lIndexUntil < m_lCurrentLayer)
		m_lCurrentLayer -= lIndexUntil - lIndexFrom;
	else
	if (lIndexFrom < m_lCurrentLayer)
		m_lCurrentLayer = lIndexFrom;
	for (long lIndex = lIndexUntil - 1; lIndexFrom <= lIndex; lIndex--)
		m_mpIdToRec.erase(GetItemData(lIndex));
	return TRUE;
} // CFCLayerListCtrl::OnMergeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseFDA.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCLayerListCtrl::TransFDA (long lState, DWORD dwMessage, DWORD dwCommand)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	long lNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNiDfPiDiBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return lNextState;
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_LBUTTONDOWN:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (PointToColumn(NULL, m_ptMsc) != FDLL_LAYER_NAME_CLM)
				lNextState = STATE_CLICK_NOT_NAME_COLUMN;		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_CLICK_NOT_NAME_COLUMN:	// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (lNextState == STATE_NONE)
		lNextState = BASE_CLASS::TransFDA(lState, dwMessage, dwCommand);
	return lNextState;
} // CFCLayerListCtrl::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::StateFDA (long lState)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_CLICK_NOT_NAME_COLUMN:		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		StateClickNotNameColumn();
		break;
	default:
		BASE_CLASS::StateFDA(lState);
	}
} // CFCLayerListCtrl::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::StateClickNotNameColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiMiDeDiDiEiBfLjGlMiImIiKePiDeOiDiKiDgCiDeOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::StateClickNotNameColumn ()
{
	TRACE(_T("CFCLayerListCtrl::StateClickNotNameColumn\r\n"));
	long lIndex;
	long lSubItem = PointToColumn(&lIndex, m_ptMsc);

	switch (lSubItem)
	{
	case FDLL_VIEW_POINT_CLM:	// _xZkqqHx_iOiLjDfPiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
		if (m_lCurrentLayer != lIndex)
		{
			RedrawItems(m_lCurrentLayer, m_lCurrentLayer);
			RedrawItems(lIndex, lIndex);
			m_lCurrentLayer = lIndex;
			// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
			GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
		}
		break;

	case FDLL_IS_PRINT_CLM:		// _xZkqqHx_iIpDiNpMiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FDLL_IS_DISPLAY_CLM:	// _xZkqqHx_jFfMiOkGiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FDLL_CAN_SELECT_CLM:	// _xZkqqHx_jBeJjBpAiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FDLL_CAN_EDIT_CLM	:	// _xZkqqHx_jFnCiPfHiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
	  {
		BOOL bChecked = (GetAccessStat(lIndex, lSubItem) == 0);
		if (GetItemState(lIndex, LVIS_SELECTED) == LVIS_SELECTED)
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMiNhDiCmMiDhNiBfLiDeOiCpAjFmPiNfIiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			POSITION pos = GetFirstSelectedItemPosition();
			while (pos)
			{
				int iSelItemIdx = GetNextSelectedItem(pos);
				if (bChecked)
				//----- _xZkqqHx_iDhNiBfLiDeOiCpAjFhEiCkPiCoJiPoKiNiH_xHqqkZx_ -----
				{
					SetAccessStat(iSelItemIdx, lSubItem, 1);
					if (lSubItem == FDLL_CAN_SELECT_CLM)
					//----- _xZkqqHx_jBeJjBpAiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
					{
						SetAccessStat(iSelItemIdx, FDLL_IS_DISPLAY_CLM, 1);
					} else
					if (lSubItem == FDLL_CAN_EDIT_CLM)
					//----- _xZkqqHx_jFnCiPfHiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjBeJjBpAiDhEiDiJiDePjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
					{
						SetAccessStat(iSelItemIdx, FDLL_CAN_SELECT_CLM, 1);
						SetAccessStat(iSelItemIdx, FDLL_IS_DISPLAY_CLM, 1);
					}
				} else
				//----- _xZkqqHx_iDhNiBfLiDeOiCpAiPmBiClHiPoKiNiH_xHqqkZx_ -----
				{
					SetAccessStat(iSelItemIdx, lSubItem, 0);
				}
				// _xZkqqHx_iClBiCmMiNhDiCmMiDhNiBfLiDeOiCpAiNfIjAfGiBeCiDgOiBfLiDhEiDgHiBfLiDjDiCnGiBeC_xHqqkZx_
				UpdateCheckMark(iSelItemIdx);
			}
		} else
		//----- _xZkqqHx_jEpBjBeJjBpAiCmMiNhDiCmMiDhNiBfLiDeOiCpAjFmPiNfIiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (bChecked)
			//----- _xZkqqHx_iDhNiBfLiDeOiCpAjFhEiCkPiCoJiPoKiNiH_xHqqkZx_ -----
			{
				SetAccessStat(lIndex, lSubItem, 1);
				if (lSubItem == FDLL_CAN_SELECT_CLM)
				//----- _xZkqqHx_jBeJjBpAiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
				{
					SetAccessStat(lIndex, FDLL_IS_DISPLAY_CLM, 1);
				} else
				if (lSubItem == FDLL_CAN_EDIT_CLM)
				//----- _xZkqqHx_jFnCiPfHiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjBeJjBpAiDhEiDiJiDePjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
				{
					SetAccessStat(lIndex, FDLL_CAN_SELECT_CLM, 1);
					SetAccessStat(lIndex, FDLL_IS_DISPLAY_CLM, 1);
				}
			} else
			//----- _xZkqqHx_iDhNiBfLiDeOiCpAiPmBiClHiPoKiNiH_xHqqkZx_ -----
			{
				SetAccessStat(lIndex, lSubItem, 0);
			}
			// _xZkqqHx_iClBiCmMiNhDiCmMiDhNiBfLiDeOiCpAiNfIjAfGiBeCiDgOiBfLiDhEiDgHiBfLiDjDiCnGiBeC_xHqqkZx_
			UpdateCheckMark(lIndex);
		}
		// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		AddChangedId(GetItemData(lIndex));
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
		break;
	  }
	}

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (PointToColumn(&lIndex, m_ptMsc) == FDLL_CURRENT_LAYER_CLM)
//	//----- _xZkqqHx_jFfMiOkGjCiGiDiMiDeDiDiEiBfLiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (0 <= lIndex && m_lCurrentLayer != lIndex)
//		{
//			RedrawItems(m_lCurrentLayer, m_lCurrentLayer);
//			RedrawItems(lIndex, lIndex);
//			m_lCurrentLayer = lIndex;
//			// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//			GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//		}
//	}
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCLayerListCtrl::StateClickNotNameColumn.

BEGIN_MESSAGE_MAP(CFCLayerListCtrl, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCLayerListCtrl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_WM_LBUTTONDOWN()
//	ON_WM_CONTEXTMENU()
//	ON_COMMAND(ID_RBTN_ITEM_MOVE_BEGIN, OnRbtnItemMoveBegin)
//	ON_WM_MOUSEMOVE()
//	ON_COMMAND(ID_RBTN_ITEM_MOVE_CANCEL, OnRbtnItemMoveCancel)
//	ON_COMMAND(ID_RBTN_ITEM_MOVE_PREV, OnRbtnItemMovePrev)
//	ON_COMMAND(ID_RBTN_ITEM_INSERT_PREV, OnRbtnItemInsertPrev)
//	ON_COMMAND(ID_RBTN_ITEM_DELETE, OnRbtnItemDelete)
//	ON_COMMAND(ID_RBTN_ITEM_CHANGE, OnRbtnItemChange)
//	ON_COMMAND(ID_RBTN_ITEM_MERGE, OnRbtnItemMerge)
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCLayerListCtrl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::DrawItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDgJiBfLjFgAiJoGiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiPoDiCmMiKePiKmPiCkKjFmPiJlLiClFiClNiCmGiCkLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDIS	:_xZkqqHx_jHhGiLiBiClDiCoKiClNjFgAiJoGiCmMiMfOiCmJiCmCiCkCiCmEiCmMiPoOjFpBiCpAiOjNiCmC_xHqqkZx_
 *					 DRAWITEMSTRUCT _xZkqqHx_iNfMjBkCjBmMiCnGiCmM_xHqqkZx_ long _xZkqqHx_iDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCLayerListCtrl::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	CImageList* pImg = GetImageList(LVSIL_SMALL);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	ASSERT(lpDIS->itemData == GetItemData(lpDIS->itemID));
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString strItem = GetRec(lpDIS->itemData)->strName;
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strItem;
	strItem.Format(	L"%ld. %s",
					GetItemCount() - (long)lpDIS->itemID - 1,
					GetRec(lpDIS->itemData)->strName.c_str());
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMiPoKiNiHiCmMjDgIiCoIjFkKiCkPiCpAiNhDiCkE_xHqqkZx_ -----
	if (lpDIS->itemID == 0)
	{
		// _xZkqqHx_iPkNiClFiImDiCkCjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDC.FillRect(&lpDIS->rcItem, FCAtBrush(::GetSysColor(COLOR_3DFACE)));
	} else
	if (lpDIS->itemID == GetItemCount() - 1)
	{
		// _xZkqqHx_iPkNiClFiImDiCkCjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDC.FillRect(&lpDIS->rcItem, FCAtBrush(::GetSysColor(COLOR_3DFACE)));
	} else
	{
		// _xZkqqHx_jCmKiPoNiCmMjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDC.FillRect(&lpDIS->rcItem, FCAtBrush(pDC->GetBkColor()));
	}

	CRect rtLabel;
	GetSubItemRect(lpDIS->itemID, 1, LVIR_LABEL, rtLabel);
	if (lpDIS->itemState & ODS_SELECTED)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.FillRect(&lpDIS->rcItem, FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjElNjDfNjAeGiBeC_xHqqkZx_
		atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_LEFT|DT_VCENTER|DT_SINGLELINE);
	} else
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_LEFT|DT_VCENTER|DT_SINGLELINE);
	}
	if (GetItemState(lpDIS->itemID, LVIS_CUT) == LVIS_CUT)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.SetTextColor(::GetSysColor(COLOR_INACTIVECAPTION));
// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
		atDCSub.DrawText(strItem, CP_ACP, rtLabel, DT_LEFT|DT_VCENTER|DT_SINGLELINE);
		atDCSub.DrawFocusRect(&lpDIS->rcItem);
	}
	if (lpDIS->itemID == m_lCurrentLayer)
	{
		// _xZkqqHx_iOiLjDfPiCmMjFgAiJoGjIgHiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtEye;
		CListCtrl::GetItemRect(lpDIS->itemID, rtEye, LVIR_BOUNDS);
		rtEye.right = rtEye.left + GetColumnWidth(0);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
		CRgn rgn;
		rgn.CreateRectRgn(rtEye.left, rtEye.top, rtEye.right, rtEye.bottom);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDiKiBfLiDfHiDiHiDjDiCmNiDfCiDhDiBfLiClDiCoKiCoJiCmMiCmFiBeBiDeJiDiKiDfHiDgJiDiLiCmNiNoNiPjMiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		atDC.SetClipRgn(&rgn);
		long lx = (rtEye.Width() - 16) / 2;
		if (lx < 0) lx = 0;
		long ly = (rtEye.Height() - 16) / 2;
		if (ly < 0) ly = 0;
		if (lpDIS->itemState & ODS_SELECTED)
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_SELECTED);
		else
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_TRANSPARENT);
	}
	for (int iC = 2; iC < 6; iC++)
	{
		CRect rtRgn;
		GetSubItemRect(lpDIS->itemID, iC, LVIR_LABEL, rtRgn);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
		CRgn rgn;
		rgn.CreateRectRgn(rtRgn.left, rtRgn.top, rtRgn.right, rtRgn.bottom);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDiKiBfLiDfHiDiHiDjDiCmNiDfCiDhDiBfLiClDiCoKiCoJiCmMiCmFiBeBiDeJiDiKiDfHiDgJiDiLiCmNiNoNiPjMiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		atDC.SetClipRgn(&rgn);
		long lx = (rtRgn.Width() - 16) / 2;
		if (lx < 0) lx = 0;
		long ly = (rtRgn.Height() - 16) / 2;
		if (ly < 0) ly = 0;
		int iIcon;
		switch (GetAccessStat(lpDIS->itemID, iC))
		{
		case 0:		// _xZkqqHx_iDeBiDeOiDfKiDfIjFhDiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
			iIcon = 1;
			break;
		case 1:		// _xZkqqHx_iDeBiDeOiDfKiDfIiJmCiCmMiPoKiNiHiBeC_xHqqkZx_
			iIcon = 2;
			break;
		case 2:		// _xZkqqHx_iDeBiDeOiDfKiDfIjFhDjCoIiCmMiPoKiNiHiBeC_xHqqkZx_
			iIcon = 3;
			break;
		}
		if (lpDIS->itemState & ODS_SELECTED)
			pImg->Draw(pDC, iIcon, CPoint(rtRgn.left + lx, rtRgn.top + ly), ILD_SELECTED);
		else
			pImg->Draw(pDC, iIcon, CPoint(rtRgn.left + lx, rtRgn.top + ly), ILD_TRANSPARENT);
	}
} // CFCLayerListCtrl::DrawItem.

//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnLButtonDown
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiCpAiOhHjCoIiBeCiBeC_xHqqkZx_
// *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnLButtonDown (UINT nFlags, CPoint point)
//{
//	LVHITTESTINFO info;
//	info.pt = point;
//	int iItem = SubItemHitTest(&info);
//	if (iItem < 0) return;
//	if (m_bIsMoving)
//	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiInKjDkOiPiIjHjNjCiGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		long lItemIns;
//		CRect rtItem;
//		GetItemRect(iItem, rtItem, LVIR_BOUNDS);
//		long lCenterY = rtItem.top + (rtItem.Height() / 2);
//		if (lCenterY < point.y)
//			lItemIns = iItem + 1;
//		else
//			lItemIns = iItem;
//		if (lItemIns == 0)
//			lItemIns = 1;
//		else if (lItemIns == GetItemCount())
//			lItemIns = GetItemCount() - 1;
//		// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//		LayerMovePrev(lItemIns);
//	} else
//	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiInKjDkOiPiIjHjNjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		switch (info.iSubItem)
//		{
//		case FDLL_VIEW_POINT_CLM:	// _xZkqqHx_iOiLjDfPiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//			if (m_lCurrentLayer != iItem)
//			{
//				RedrawItems(m_lCurrentLayer, m_lCurrentLayer);
//				RedrawItems(iItem, iItem);
//				m_lCurrentLayer = iItem;
//				// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//				GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//			}
//			break;
//
//		case FDLL_LAYER_NAME_CLM:	// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//			CListCtrl::OnLButtonDown(nFlags, point);
//			break;
//
//		case FDLL_IS_PRINT_CLM:		// _xZkqqHx_iIpDiNpMiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//		case FDLL_IS_DISPLAY_CLM:	// _xZkqqHx_jFfMiOkGiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//		case FDLL_CAN_SELECT_CLM:	// _xZkqqHx_jBeJjBpAiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//		case FDLL_CAN_EDIT_CLM	:	// _xZkqqHx_jFnCiPfHiLjGiJmCiDhEiDiJiDePiCpAiJjPiClFiClNiPoKiNiHiBeC_xHqqkZx_
//		  {
//			BOOL bChecked = (GetAccessStat(iItem, info.iSubItem) == 0);
//			if (GetItemState(iItem, LVIS_SELECTED) == LVIS_SELECTED)
//			//----- _xZkqqHx_jBeJjBpAjCiGiCmMiNhDiCmMiDhNiBfLiDeOiCpAjFmPiNfIiClHiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				POSITION pos = GetFirstSelectedItemPosition();
//				while (pos)
//				{
//					int iItem = GetNextSelectedItem(pos);
//					if (bChecked)
//					//----- _xZkqqHx_iDhNiBfLiDeOiCpAjFhEiCkPiCoJiPoKiNiH_xHqqkZx_ -----
//					{
//						SetAccessStat(iItem, info.iSubItem, 1);
//						if (info.iSubItem == FDLL_CAN_SELECT_CLM)
//						//----- _xZkqqHx_jBeJjBpAiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
//						{
//							SetAccessStat(iItem, FDLL_IS_DISPLAY_CLM, 1);
//						} else
//						if (info.iSubItem == FDLL_CAN_EDIT_CLM)
//						//----- _xZkqqHx_jFnCiPfHiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjBeJjBpAiDhEiDiJiDePjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
//						{
//							SetAccessStat(iItem, FDLL_CAN_SELECT_CLM, 1);
//							SetAccessStat(iItem, FDLL_IS_DISPLAY_CLM, 1);
//						}
//					} else
//					//----- _xZkqqHx_iDhNiBfLiDeOiCpAiPmBiClHiPoKiNiH_xHqqkZx_ -----
//					{
//						SetAccessStat(iItem, info.iSubItem, 0);
//					}
//					// _xZkqqHx_iClBiCmMiNhDiCmMiDhNiBfLiDeOiCpAiNfIjAfGiBeCiDgOiBfLiDhEiDgHiBfLiDjDiCnGiBeC_xHqqkZx_
//					UpdateCheckMark(iItem);
//				}
//			} else
//			//----- _xZkqqHx_jEpBjBeJjBpAiCmMiNhDiCmMiDhNiBfLiDeOiCpAjFmPiNfIiClHiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				if (bChecked)
//				//----- _xZkqqHx_iDhNiBfLiDeOiCpAjFhEiCkPiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					SetAccessStat(iItem, info.iSubItem, 1);
//					if (info.iSubItem == FDLL_CAN_SELECT_CLM)
//					//----- _xZkqqHx_jBeJjBpAiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
//					{
//						SetAccessStat(iItem, FDLL_IS_DISPLAY_CLM, 1);
//					} else
//					if (info.iSubItem == FDLL_CAN_EDIT_CLM)
//					//----- _xZkqqHx_jFnCiPfHiDhEiDiJiDePjAnNjCoIiCmMiPoKiNiHiCmNiBeBjBeJjBpAiDhEiDiJiDePjFfMiOkGiDhEiDiJiDePiCoAiOkJjDkOiCgOiCgN_xHqqkZx_ -----
//					{
//						SetAccessStat(iItem, FDLL_CAN_SELECT_CLM, 1);
//						SetAccessStat(iItem, FDLL_IS_DISPLAY_CLM, 1);
//					}
//				} else
//				//----- _xZkqqHx_iDhNiBfLiDeOiCpAiPmBiClHiPoKiNiH_xHqqkZx_ -----
//				{
//					SetAccessStat(iItem, info.iSubItem, 0);
//				}
//				// _xZkqqHx_iClBiCmMiNhDiCmMiDhNiBfLiDeOiCpAiNfIjAfGiBeCiDgOiBfLiDhEiDgHiBfLiDjDiCnGiBeC_xHqqkZx_
//				UpdateCheckMark(iItem);
//			}
//			// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//			GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//			break;
//		  }
//		}
//	}
//} // CFCLayerListCtrl::OnLButtonDown.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnMouseMove
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiInKjDkOiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiCpAiOhHjCoIiBeCiBeC_xHqqkZx_
// *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnMouseMove (UINT nFlags, CPoint point)
//{
//	if (m_bIsMoving)
//		FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_INSERT));
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	CListCtrl::OnMouseMove(nFlags, point);
//} // CFCLayerListCtrl::OnMouseMove.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnContextMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiBeBiIlNiCkCiCmNiDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCmBiCmEiLeOjDkOiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iJeFiDhLiDfOiDjDiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnContextMenu (CWnd* pWnd, CPoint point)
//{
//	CMenu menu;
//	if (menu.LoadMenu(IDR_RBTN_MULTI))
//	{
//		if (point.x < 0 || point.y < 0)
//		//----- _xZkqqHx_iDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCoJiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			POSITION pos = GetFirstSelectedItemPosition();
//			if (pos)
//				GetItemPosition(GetNextSelectedItem(pos), &point);
//			else
//				point = CPoint(0,0);
//			ClientToScreen(&point);
//		}
//		CMenu* pPopup;
//		if (!m_bIsMoving)
//			pPopup = menu.GetSubMenu(7);
//		else
//			pPopup = menu.GetSubMenu(8);
//		ASSERT(pPopup != NULL);
//		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//		if (g_pReg->GetIsLeftHand())
//			::RightByLeftHand(pPopup->m_hMenu, TRUE);
//		// _xZkqqHx_iDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//		OnUpdatePopupMenu(pPopup);
//		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//								point.x, point.y,
//								// route commands through main window.
//								this);
//	}
//} // CFCLayerListCtrl::OnContextMenu.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemMoveBegin
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFiDiMiDeDiDiEiBfLiCpAiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemMoveBegin ()
//{
//	m_bIsMoving = TRUE;
//	POSITION pos = GetFirstSelectedItemPosition();
//	int iItemSize = GetItemCount();
//	while (pos)
//	{
//		int iItem = GetNextSelectedItem(pos);
//		// _xZkqqHx_iNmFiPiJiCmGiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmNiBeBjBeJjBpAjFhDiJmCjEfMiBeC_xHqqkZx_
//		if (iItem != 0 && iItem != iItemSize - 1)
//		{
//			SetItemState(iItem, LVIS_CUT, LVIS_CUT);
//			RedrawItems(iItem, iItem);
//		}
//	}
//} // CFCLayerListCtrl::OnRbtnItemMoveBegin.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemDelete
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemDelete ()
//{
//	//----- SELECTED _xZkqqHx_iPoOjFpBiCkKjFhEiJmBiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
//	for (int iC = 0; iC < GetItemCount();)
//	{
//		if (GetItemState(iC, LVIS_SELECTED) == LVIS_SELECTED)
//		{
//			DeleteItem(iC);
//		} else
//		{
//			iC++;
//		}
//	}
//	if (GetItemCount() <= m_lCurrentLayer)
//		m_lCurrentLayer = GetItemCount() - 1;
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//	GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//} // CFCLayerListCtrl::OnRbtnItemDelete.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemMoveCancel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFiDiMiDeDiDiEiBfLiInKjDkOjCiGiOhOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemMoveCancel ()
//{
//	m_bIsMoving = FALSE;
//	for (int iC = 0; iC < GetItemCount(); iC++)
//	{
//		if (GetItemState(iC, LVIS_CUT) == LVIS_CUT)
//		{
//			SetItemState(iC, 0, LVIS_CUT);
//		}
//	}
//} // CFCLayerListCtrl::OnRbtnItemMoveCancel.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemMovePrev
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFjClMjBePiCmJiDiMiDeDiDiEiBfLiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemMovePrev ()
//{
//	//----- _xZkqqHx_jBhNjDpMiImKjChFiCpAiOoGjDlO_xHqqkZx_ -----
//	POSITION pos = GetFirstSelectedItemPosition();
//	int iItemIns = GetNextSelectedItem(pos);
//	LayerMovePrev(iItemIns);
//} // CFCLayerListCtrl::OnRbtnItemMovePrev.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemInsertPrev
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFjClMjBePiCmJiDiMiDeDiDiEiBfLjBhNjDpMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemInsertPrev ()
//{
//	//----- _xZkqqHx_jBhNjDpMiImKjChFiCpAiOoGjDlO_xHqqkZx_ -----
//	POSITION pos = GetFirstSelectedItemPosition();
//	int iItemIns = GetNextSelectedItem(pos);
//
//	FCLayerCtrlRec layerRec;
//	layerRec.dwId = m_dwNewLayerId;
//	layerRec.strName.Format(_T("%s%d"), ::GetResWString(IDS_UNTITLED_LAYER),
//										m_dwNewLayerId - 1);		// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_n"_xZkqqHx_iBeC_xHqqkZx_
//	layerRec.SetFlag(FDOZ_ON_ALL);
//	InsertItemRec(iItemIns, layerRec);
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiCpAjAfGiLeLiNoMjAkMiClHiCoJiOjOiCmM_xHqqkZx_ID_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
//	m_dwNewLayerId++;
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//	GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//} // CFCLayerListCtrl::OnRbtnItemInsertPrev.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemChange
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFiDiMiDeDiDiEiBfLjGlMiCpAjFmPiNfIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemChange ()
//{
//	POSITION pos = GetFirstSelectedItemPosition();
//	int iItem = GetNextSelectedItem(pos);
//	// _xZkqqHx_iDgAiDgCiDhGjGlMiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiBeC_xHqqkZx_
//	CFCDlgInputStr dlgStr;
//	// "_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_";
//	dlgStr.m_strTitle.LoadString(IDS_MSG_INPUT_ENTRY_NAME);
//	dlgStr.m_strInput = GetItemRec(iItem)->strName;
//	if (dlgStr.DoModal() == IDOK)
//	{
//		ItemRec(iItem).strName = dlgStr.m_strInput;
//		RedrawItems(iItem, iItem);
//		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
//		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//	}
//} // CFCLayerListCtrl::OnRbtnItemChange.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCLayerListCtrl::OnRbtnItemMerge
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBhFiDiMiDeDiDiEiBfLiCpAiDhNiBfLiDfHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCLayerListCtrl::OnRbtnItemMerge ()
//{
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMiDeBiDeDiDgFiDiAiCpAiPfHiCnPiCoJ_xHqqkZx_ -----
//	longVector vItem;
//	POSITION pos = GetFirstSelectedItemPosition();
//	while (pos)
//		vItem.push_back(GetNextSelectedItem(pos));
//	// _xZkqqHx_jBeJjBpAiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCLayerCtrlRec& itemRec = ItemRec(vItem.back());
//	// _xZkqqHx_jBeJjBpAiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
//	SetItemState(vItem.back(), 0, LVIS_SELECTED);
//	// _xZkqqHx_jBeJjBpAiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiBeBiJlKiCkJiCoHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiBeC_xHqqkZx_
//	int iSelRIdx = GetItemCount() - 1 - vItem.back();
//	vItem.pop_back();
//	//----- _xZkqqHx_jBeJjBpAiNmFiMoDiCmMiDeBiDeDiDgFiDiAiDiMiDfCiBfLiDgIiCmJiBeBiClLiCmMiPoDiCmMiDiMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkCiCkN_xHqqkZx_ -----
//	while (!vItem.empty())
//	{
//		itemRec.vMerge.push_back(GetItemRec(vItem.back())->dwId);
//		vItem.pop_back();
//	}
//	// _xZkqqHx_jBeJjBpAjCiGiDeBiDeDiDgFiDiAiCmMiNoNiPjMiPiIjHjNiBeC_xHqqkZx_
//	OnRbtnItemDelete();
//	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
//	SetItemState(GetItemCount() - 1 - iSelRIdx, LVIS_SELECTED, LVIS_SELECTED);
//} // CFCLayerListCtrl::OnRbtnItemMerge.
//----- 01.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
