#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDrawView.h"// For g_pView.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ObjPoly.h"		// For FCObjPoly.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilGraph.h"		// For FCEditDraw.
#include "UtilMisc.h"		// For PolyCrossLine.
#include "UtilStdLib.h"		// For m1_for.
#include "UtilBezier.h"		// For FCBezierControls.
// 06.10.17 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "LayerManager.h"	// For FDOZ_ON_SELECT.
#include "ZOrder.h"			// For FCZOrder.
#include "LinkManager.h"	// This header.

// 00.12.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//typedef set<DWORD>	DWORDSet;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//#define _LOCAL_CONV	// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBeC_xHqqkZx_

////////////////////////////////////////////////////////////////////////////
// FCLinkRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkRec::CalcNewMoving
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiCmMiInKjDkOiCmJjElKiCkEiBeBiDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiOoNjHnOiCmJiJjOiClGiCmEiBeBiDiKiDjDiDeOjAoGiCmMiNmAjFfHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiMlDiCmNiBeBiKpJiCmJiInKjDkOiClDiCoKiCmEiCkCiCoJiPpDjBnEiCmFiClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCLinkRec::CalcNewMoving () const
{
	DBLPoint mmptFrom;
	DBLRect  mmrtFrom;
	DBLPoint mmptTo;
	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjFrom = g_pDoc->ObjID2Object(m_mlpFrom.dwObjID);
	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	mmptFrom = pObjFrom->GetMolipPos(m_mlpFrom.lMolipId);
	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	mmrtFrom = pObjFrom->GetResizeFrame();
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjTo = g_pDoc->ObjID2Object(m_mlpTo.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	mmptTo = pObjTo->GetMolipPos(m_mlpTo.lMolipId);

	// _xZkqqHx_jFjNiBeFiNiCiClDiCkK_xHqqkZx_ 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiMhGiOfKiCkKiCkEiCnMiCkNiNhDiCkJiCmIiCkCiBeCiClBiCoKiCpAjEpAiCkPiCoJiClNiCnPiBeB_xHqqkZx_
	// 1.0mm_xZkqqHx_iImIiJlKiCmN_xHqqkZx_ 1.0mm_xZkqqHx_iCmJiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	mmetol mmWidth = mmrtFrom.Width();
	if (mmWidth < 1.0) mmWidth = 1.0;
	mmetol mmHeight = mmrtFrom.Height();
	if (mmHeight < 1.0) mmHeight = 1.0;

	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiBeC_xHqqkZx_
	DBLPoint mmptToNew;
	// X_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
	switch (m_wLinkKind & 0x000f)
	{
	case FDLM_LINK_ON_COORD_X:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		mmptToNew.x = mmptFrom.x + m_mmptOffset.x;
		break;
	case FDLM_LINK_ON_RATIO_X:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
		mmptToNew.x = mmptFrom.x + mmWidth * m_mmptOffset.x;
		break;
	case FDLM_LINK_ON_ANGLE_X:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
		ASSERT((m_wLinkKind & 0x00f0) == FDLM_LINK_ON_ANGLE_Y);
		return CalcNewMovingAngle();
	default:	// _xZkqqHx_iNmAjFfHjIeBiMgHiCmNjGlDiClFiBeC_xHqqkZx_
		mmptToNew.x = mmptTo.x;
	}
	// Y_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
	switch (m_wLinkKind & 0x00f0)
	{
	case FDLM_LINK_ON_COORD_Y:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		mmptToNew.y = mmptFrom.y + m_mmptOffset.y;
		break;
	case FDLM_LINK_ON_RATIO_Y:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
		mmptToNew.y = mmptFrom.y + mmHeight * m_mmptOffset.y;
		break;
	case FDLM_LINK_ON_ANGLE_Y:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
		break;
	default:	// _xZkqqHx_iNmAjFfHjIeBiMgHiCmNjGlDiClFiBeC_xHqqkZx_
		mmptToNew.y = mmptTo.y;
	}
	// _xZkqqHx_iDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
	return (mmptToNew - mmptTo);
} // FCLinkRec::CalcNewMoving.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkRec::CalcNewMovingAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiBeBiDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			CalcNewMoving _xZkqqHx_iKnGjAjEiCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiCmNiBeBiKpJiCmJiInKjDkOiClDiCoKiCmEiCkCiCoJiPpDjBnEiCmFiClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCLinkRec::CalcNewMovingAngle () const
{
	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJ_xHqqkZx_Q_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjQ = g_pDoc->ObjID2Object(m_mlpFrom.dwObjID);
	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_(A)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptA = pObjQ->GetMolipPos(m_mlpFrom.lMolipId);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJ_xHqqkZx_R_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjR = g_pDoc->ObjID2Object(m_mlpTo.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_(G)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptG = pObjR->GetMolipPos(m_mlpTo.lMolipId);

	DBLPoint mmptB = pObjR->GetAngleLinkStandardPosition(mmptA, m_mlpTo.lMolipId, this);
	double dR = m_mmptOffset.x * pObjR->GetAngleLinkStandardSign(mmptA, m_mlpTo.lMolipId, this);
	// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAiJpBjDfNjFmPiKlHiClFiCmEjDfP_xHqqkZx_N_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptN = mmptB;
	::RotateConv(mmptN, sin(dR * M_PI), cos(dR * M_PI), mmptA);

	//----- _xZkqqHx_jClMjApM_xHqqkZx_AN_xZkqqHx_iCmGjAhNiMgAiCmMiDhMiDiKiDfDiDjDiCkKiMpAiNlHiClHiCoJjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	DBLPoint mmptF = mmptA;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DBLPoint mmptC0 = mmptA;
//	DBLPoint mmptC1 = mmptA;
//	DBLPoint mmptC2 = mmptN;
//	DBLPoint mmptC3 = mmptN;
//	if (pObjQ->CalcCrossedControlPoint(mmptC0, mmptC1, mmptC2, mmptC3,
//										m_mlpFrom.lMolipId))
//		mmptF = mmptC0;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pObjQ->CalcMolipCrossedPoint(mmptF, mmptA, mmptN, m_mlpFrom.lMolipId);
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	DBLPoint mmptNewG = (mmptN - mmptA) * m_mmptOffset.y / (mmptN - mmptA).Len() + mmptF;

	// _xZkqqHx_iDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
	return (mmptNewG - mmptG);
} // FCLinkRec::CalcNewMovingAngle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkRec::ApplyNewOffset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiCkKiInKjDkOiClDiCoKiClNiMoDiCmMiBeBiDiKiDjDiDeOiMlDiCmGiCmMjAfGiClFiCkCiNmAjFfHiKnGiMfHiCpA_xHqqkZx_
 *			_xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCmJjElNiJgGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiOoNjHnOiCmJiJjOiClGiCmEiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkRec::ApplyNewOffset ()
{
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DBLPoint mmptFrom;
//	DBLRect  mmrtFrom;
//	DBLPoint mmptTo;
//	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
//	const FCObjDynabase* pObjFrom = g_pDoc->ObjID2Object(m_mlpFrom.dwObjID);
//	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//	mmptFrom = pObjFrom->GetMolipPos(m_mlpFrom.lMolipId);
//	// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//	mmrtFrom = pObjFrom->GetResizeFrame();
//	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
//	const FCObjDynabase* pObjTo = g_pDoc->ObjID2Object(m_mlpTo.dwObjID);
//	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//	mmptTo = pObjTo->GetMolipPos(m_mlpTo.lMolipId);
//
////----- 01.03.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjNiBeFiNiCiClDiCkK_xHqqkZx_ 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiMhGiOfKiCkKiCkEiCnMiCkNiNhDiCkJiCmIiCkCiBeCiClBiCoKiCpAjEpAiCkPiCoJiClNiCnPiBeB_xHqqkZx_
//	// 1.0mm_xZkqqHx_iImIiJlKiCmN_xHqqkZx_ 1.0mm_xZkqqHx_iCmJiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	mmetol mmWidth = mmrtFrom.Width();
//	if (mmWidth < 1.0) mmWidth = 1.0;
//	mmetol mmHeight = mmrtFrom.Height();
//	if (mmHeight < 1.0) mmHeight = 1.0;
////----- 01.03.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// X_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
//	switch (m_wLinkKind & 0x000f)
//	{
//	case FDLM_LINK_ON_COORD_X:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
//		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
//		m_mmptOffset.x = mmptTo.x - mmptFrom.x;
//		break;
//	case FDLM_LINK_ON_RATIO_X:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
//		ASSERT(!almost0(mmWidth));
//		m_mmptOffset.x = (mmptTo.x - mmptFrom.x) / mmWidth;
//		break;
//	case FDLM_LINK_ON_ANGLE_X:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
//		ASSERT((m_wLinkKind & 0x00f0) == FDLM_LINK_ON_ANGLE_Y);
//		ApplyNewOffsetAngle();
//		break;
//	}
//	// Y_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
//	switch (m_wLinkKind & 0x00f0)
//	{
//	case FDLM_LINK_ON_COORD_Y:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
//		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
//		m_mmptOffset.y = mmptTo.y - mmptFrom.y;
//		break;
//	case FDLM_LINK_ON_RATIO_Y:	// m_mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
//		ASSERT(!almost0(mmHeight));
//		m_mmptOffset.y = (mmptTo.y - mmptFrom.y) / mmHeight;
//		break;
//	}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_wLinkKind == FDLM_LINK_ON_ANGLE)
	//----- mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkD_xHqqkZx_ -----
	{
		ApplyNewOffsetAngle();
	} else
	{
		DBLPoint mmptFrom;
		DBLRect  mmrtFrom;
		DBLPoint mmptTo;
		// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		const FCObjDynabase* pObjFrom = g_pDoc->ObjID2Object(m_mlpFrom.dwObjID);
		// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		mmptFrom = pObjFrom->GetMolipPos(m_mlpFrom.lMolipId);
		// _xZkqqHx_iInKjDkOiClFiClNiDiKiDjDiDeOiMlDjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
		mmrtFrom = pObjFrom->GetResizeFrame();
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		const FCObjDynabase* pObjTo = g_pDoc->ObjID2Object(m_mlpTo.dwObjID);
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		mmptTo = pObjTo->GetMolipPos(m_mlpTo.lMolipId);
		m_mmptOffset = CalcNewOffset(mmptFrom, mmrtFrom, mmptTo, m_wLinkKind);
	}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCLinkRec::ApplyNewOffset.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkRec::ApplyNewOffsetAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmJiKnGiClFiCmEiBeBiDiKiDjDiDeOjAoGiCkKiInKjDkOiClDiCoKiClNiMoDiCmMiBeB_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiMlDiCmGiCmMjAfGiClFiCkCiNmAjFfHiKnGiMfHiCpAiDeJiDhEiDfKiDgCiDgHjCgMiCmJjElNiJgGiClHiCoJiBeC_xHqqkZx_
 *			ApplyNewOffset _xZkqqHx_iKnGjAjEiCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkRec::ApplyNewOffsetAngle ()
{
	// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJ_xHqqkZx_Q_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjQ = g_pDoc->ObjID2Object(m_mlpFrom.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_(A)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptA = pObjQ->GetMolipPos(m_mlpFrom.lMolipId);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJ_xHqqkZx_R_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjR = g_pDoc->ObjID2Object(m_mlpTo.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_(G)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptG = pObjR->GetMolipPos(m_mlpTo.lMolipId);

	DBLPoint mmptB = pObjR->GetAngleLinkStandardPosition(mmptA, m_mlpTo.lMolipId, this);

	if (abouteq(mmptA, mmptG))
	{
		// AB -> AG _xZkqqHx_iCmMiKhAjDhIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_mmptOffset.x = 0.0;
	} else
	{
		// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
		double dAngleAB = ::ArcTan(mmptB - mmptA);
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
		double dAngleAG = ::ArcTan(mmptG - mmptA);
		// AB -> AG _xZkqqHx_iCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
		double dR = (dAngleAG - dAngleAB) * pObjR->GetAngleLinkStandardSign(mmptA, m_mlpTo.lMolipId, this);
		m_mmptOffset.x = ::RegulateAngle(dR);
		// _xZkqqHx_iMoLiNlHiCpAjFoCjAlDiBeCjFjEjFgJiInKjDkOiCmMjDhIiCmJiNmEiMhGiOfKiClHiCoJiClNiCnPiBeBiMoLiNlHiCkKjAlGiClGiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
		if (about0(m_mmptOffset.x))
			m_mmptOffset.x = 0.0;
	}

	double dR = m_mmptOffset.x * pObjR->GetAngleLinkStandardSign(mmptA, m_mlpTo.lMolipId, this);
	// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAiJpBjDfNjFmPiKlHiClFiCmEjDfP_xHqqkZx_N_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptN = mmptB;
	::RotateConv(mmptN, sin(dR * M_PI), cos(dR * M_PI), mmptA);

	//----- _xZkqqHx_jClMjApM_xHqqkZx_AN_xZkqqHx_iCmGjAhNiMgAiCmMiDhMiDiKiDfDiDjDiCkKiMpAiNlHiClHiCoJjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	DBLPoint mmptF = mmptA;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DBLPoint mmptC0 = mmptA;
//	DBLPoint mmptC1 = mmptA;
//	DBLPoint mmptC2 = mmptN;
//	DBLPoint mmptC3 = mmptN;
//	if (pObjQ->CalcCrossedControlPoint(mmptC0, mmptC1, mmptC2, mmptC3,
//										m_mlpFrom.lMolipId))
//		mmptF = mmptC0;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pObjQ->CalcMolipCrossedPoint(mmptF, mmptA, mmptN, m_mlpFrom.lMolipId);
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//	mmptG = (mmptN - mmptA) * m_mmptOffset.y / (mmptN - mmptA).Len() + mmptF;
	//	m_mmptOffset.y = (mmptG - mmptF) * (mmptN - mmptA).Len() / (mmptN - mmptA);
	if (almosteq(mmptA.x, mmptN.x))
		m_mmptOffset.y = (mmptG.y - mmptF.y) * (mmptN - mmptA).Len() / (mmptN.y - mmptA.y);
	else
		m_mmptOffset.y = (mmptG.x - mmptF.x) * (mmptN - mmptA).Len() / (mmptN.x - mmptA.x);

		// _xZkqqHx_iMoLiNlHiCpAjFoCjAlDiBeCjFjEjFgJiInKjDkOiCmMjDhIiCmJiNmEiMhGiOfKiClHiCoJiClNiCnPiBeBiMoLiNlHiCkKjAlGiClGiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	if (about0(m_mmptOffset.y))
		m_mmptOffset.y = 0.0;
} // FCLinkRec::ApplyNewOffsetAngle.

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkRec::CalcNewOffset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiCkKiInKjDkOiClDiCoKiClNiMoDiCmMiBeBiDiKiDjDiDeOiMlDiCmGiCmMjAfGiClFiCkCiNmAjFfHiKnGiMfHiCpA_xHqqkZx_
 *			_xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCmGiClFiCmEiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	mmptMolipFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtObjFrameFrom:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMolipTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhGiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind		:_xZkqqHx_iDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_FDLM_LINK_ON_ANGLE _xZkqqHx_iCmNiOhHjCoI_xHqqkZx_
 *							 _xZkqqHx_iCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiDfOiDeDiDhGiCmN_xHqqkZx_ FDLM_LINK_ON_ANGLE _xZkqqHx_iImIiKePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiOoNjHnOiCmJiJjOiClGiCmEiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCLinkRec::CalcNewOffset (	const DBLPoint& mmptMolipFrom,
									const DBLRect& mmrtObjFrameFrom,
									const DBLPoint& mmptMolipTo,
									WORD wLinkKind)
{
	// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	DBLPoint mmptOffset(0,0);
	// _xZkqqHx_jFjNiBeFiNiCiClDiCkK_xHqqkZx_ 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiMhGiOfKiCkKiCkEiCnMiCkNiNhDiCkJiCmIiCkCiBeCiClBiCoKiCpAjEpAiCkPiCoJiClNiCnPiBeB_xHqqkZx_
	// 1.0mm_xZkqqHx_iImIiJlKiCmN_xHqqkZx_ 1.0mm_xZkqqHx_iCmJiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	mmetol mmWidth = mmrtObjFrameFrom.Width();
	if (mmWidth < 1.0) mmWidth = 1.0;
	mmetol mmHeight = mmrtObjFrameFrom.Height();
	if (mmHeight < 1.0) mmHeight = 1.0;

	// X_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
	switch (wLinkKind & 0x000f)
	{
	case FDLM_LINK_ON_COORD_X:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		mmptOffset.x = mmptMolipTo.x - mmptMolipFrom.x;
		break;
	case FDLM_LINK_ON_RATIO_X:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
		ASSERT(!almost0(mmWidth));
		mmptOffset.x = (mmptMolipTo.x - mmptMolipFrom.x) / mmWidth;
		break;
	case FDLM_LINK_ON_ANGLE_X:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
		FFThrowMiscUnknown();
		break;
	}
	// Y_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
	switch (wLinkKind & 0x00f0)
	{
	case FDLM_LINK_ON_COORD_Y:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiMoDiCmMiDiCiDiKiDhGiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		mmptOffset.y = mmptMolipTo.y - mmptMolipFrom.y;
		break;
	case FDLM_LINK_ON_RATIO_Y:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
		ASSERT(!almost0(mmHeight));
		mmptOffset.y = (mmptMolipTo.y - mmptMolipFrom.y) / mmHeight;
		break;
	case FDLM_LINK_ON_ANGLE_Y:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
		FFThrowMiscUnknown();
		break;
	}
	return mmptOffset;
} // FCLinkRec::CalcNewOffset.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////
// FCLinkManager_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::FCLinkManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLinkManager::FCLinkManager ()
{
} // FCLinkManager::FCLinkManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::~FCLinkManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLinkManager::~FCLinkManager ()
{
//----------<NOT EXPORT TO VIEWER>-----------
	ClearAll();
//----------</NOT EXPORT TO VIEWER>-----------
} // FCLinkManager::~FCLinkManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetLinkIdList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetLinkIdList (DWORDVector& vIdList) const
{
	for (DWORD dwId = m_tblLinkID.GetFirstID();
		 dwId != DWORD(-1); dwId = m_tblLinkID.GetNextID(dwId))
		vIdList.push_back(dwId);
} // FCLinkManager::GetLinkIdList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::IsLinkable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDpBiCmCiCmMiDiCiDiKiDhGiCkKiDiKiDjDiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mlpFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
 *			mlpTo	:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLinkManager::IsLinkable (const FCMolipRec& mlpFrom,
								const FCMolipRec& mlpTo) const
{
	// _xZkqqHx_jDkPiClGiDiCiDiKiDhGjDkPiOgNiCmFiCmNiDiKiDjDiDeOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (mlpFrom == mlpTo) return FALSE;
	// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjFrom = g_pDoc->ObjID2Object(mlpFrom.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiCmFiCkLiCmIiCkCiDiCiDiKiDhGiCmIiCoHiCmOiBeBiDiKiDjDiDeOjFhDiJmCiCpAjFnEiClHiBeC_xHqqkZx_
	if (!pObjFrom->IsLinkable(mlpFrom.lMolipId, TRUE)) return FALSE;
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjTo = g_pDoc->ObjID2Object(mlpTo.dwObjID);
	// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiCmFiCkLiCmIiCkCiDiCiDiKiDhGiCmIiCoHiCmOiBeBiDiKiDjDiDeOjFhDiJmCiCpAjFnEiClHiBeC_xHqqkZx_
	if (!pObjTo->IsLinkable(mlpTo.lMolipId, FALSE)) return FALSE;
	// _xZkqqHx_iDiKiDjDiDeOiMlDiCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOiCmMiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	FCLinkRecPVector vAffected;
	GetAffectedByFrom(vAffected, mlpFrom);
	// _xZkqqHx_iDiKiDjDiDeOiIoKjHjHiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
	FCLinkRecPVector::const_iterator iLt;
	for (iLt = vAffected.begin(); iLt != vAffected.end(); iLt++)
		// _xZkqqHx_iDiKiDjDiDeOjAoGiCkKiIoKjChGiClHiCoJiDiKiDjDiDeOiCkKjHeMiCoJiCmIiCoHiCmOiBeBiDiKiDjDiDeOiCmNjFhDiJmCiBeC_xHqqkZx_
		if ((*iLt)->m_mlpTo == mlpTo) return FALSE;
	// _xZkqqHx_iDiKiDjDiDeOiJmCjEfMiCpAjFnEiClHiBeC_xHqqkZx_
	return TRUE;
} // FCLinkManager::IsLinkable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::MovedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEjFjEjFgJjCiGiCmMjFkBjAjEiCmMiDiCiDiKiDhGiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMolip	:_xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			bUpdateLinkOffset	:_xZkqqHx_iDiCiDiKiDhGiInKjDkOiMoDiCmMiBeBiDiCiDiKiDhGiCmGiDiKiDjDiDeOiCmMiLjHjHkDiCmM_xHqqkZx_
 *								_xZkqqHx_jFhDjAkOiNiHiCpAiJpAiPmBiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOjAoGjFjEjFgJiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhGiCmJiInKjDkOiCpAjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKpJiCmJjBlMiCmMiDiKiDjDiDeOiMgPjHfCiCmFiInKjDkOiNmPiCnNiCmMiDiCiDiKiDhGiCmNiBeBiInKjDkOiClDiClJiCoJiClBiCmGiCmN_xHqqkZx_
 *			_xZkqqHx_iCmFiCkLiCmIiCkCiBeCiClBiCmMiOjOiCmNiBeBiDiKiDjDiDeOiCmMiDeJiDhEiDfKiDgCiDgHiPoOjFpBiCpAiMlLiPpDiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmMiDiBiDjDiDgPiCpAiInKjDkOiClFiClNiPoKiNiHiBeBiDiKiDjDiDeOiPoOjFpBiCmNiDePiDiLiBfLiDhG_xHqqkZx_
 *			_xZkqqHx_jCiGiCmMiJlMiDiKiDjDiDeOiPoOjFpBiCmIiCmMiCmFiBeBiDiKiDjDiDeOiLjHjHkDjFhDjAkOiNiHiCpAiNfIjAfGiClHiCoJiCmGiDhNiDfJiDeDiBeC_xHqqkZx_
 *			bUpdateLinkOffset _xZkqqHx_iCmNiClLiCmMiClNiCnPiCmMiIpIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiCkKiBeBiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iKnGjAjEjDoAjFjEiCmFiDiCiDiKiDhGiInKjDkOiDfCiDhNiDjDiDgIiBeFiDiKiDjDiDeOjFmPiNfIiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpA_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::MovedNotify (const FTMolipSet& stMolip, BOOL bUpdateLinkOffset)
{
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_stMovedHorz.clear();
	m_stMovedVert.clear();
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiCmMiCfAiCmCiClIiCmCiCpAiPiIjHjNiBeC_xHqqkZx_
	FTMolipSet::const_iterator iMs;
	// _xZkqqHx_iCnMiClIiBeBiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjBmOiPnLiCpAjDgPjIfOiBeC_xHqqkZx_
	for (iMs = stMolip.begin(); iMs != stMolip.end(); iMs++)
	{
		(void)IsAlreadyMovedHorz(*iMs);	// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCnGiCmMjDgPjIfOiNoMiLmGiBeC_xHqqkZx_
		(void)IsAlreadyMovedVert(*iMs);	// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCnGiCmMjDgPjIfOiNoMiLmGiBeC_xHqqkZx_
	}
	// _xZkqqHx_jAkOjHjNiNmPiCnNiCmMiInKjDkOiNmPiCnNiDiCiDiKiDhGiDiKiDfIiDgHiCpAiOoGjDlOiBeCiClBiCmMjCgJiKeLiCmFiCmN_xHqqkZx_
	// m_stMovedHorz _xZkqqHx_iCoA_xHqqkZx_m_stMovedVert_xZkqqHx_iCoAjDjJiClFiCkCiBeC_xHqqkZx_
	const FTMolipSet stMoved = m_stMovedHorz;
	// _xZkqqHx_iDiCiDiKiDhGiInKjDkOiCmJjElKiCkEiDiKiDjDiDeOjAoGjFjEjFgJiCmMiNmEiLeBjDeJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
	for (iMs = stMoved.begin(); iMs != stMoved.end(); iMs++)
		MovedNotifySub(*iMs);	// _xZkqqHx_iNmEiLeBjDeJiInKjDkOiPiIjHjNiBeC_xHqqkZx_

	//----- PointIndex(-1)_xZkqqHx_iImIiKePiCmMiInKjDkOiCmJiCoGiCmBiCmE_xHqqkZx_
	//		_xZkqqHx_iDiKiDfEiDeDiDfJiCkKjAlGiClGiClNjFjEjFgJiCmMiDiKiDjDiDeOjAoGiInKjDkOiPiIjHjN_xHqqkZx_ -----
	FTMolipSet::iterator iPs;
	for (;;)
	{
		// _xZkqqHx_iDiKiDfEiDeDiDfJiCkKjAlGiClGiClNjFjEjFgJiCmJiBeBiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCmMjCiGiCmFiBeBiKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiCnNiCpAjBeJjBpAiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiBeBiInKjDkOiClFiClNiCoAiCmMiCmG_xHqqkZx_
		// _xZkqqHx_iJlMjCoIiClFiCmEiBeBiDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhGiCmMiInKjDkOiCpAiNmEiMhGiOfKiClDiClJiCoJiBeC_xHqqkZx_
		// LinkManager.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
		DWORDSet stAffected;
		// _xZkqqHx_jAiFjFlNiBeFjAiCjClMiInKjDkOiDiCiDiKiDhGiDiKiDfIiDgHiCkJiCoHiBeB_xHqqkZx_PointIndex(-1)_xZkqqHx_iImIiKePiCmMjFkIiCpAjCiKiPgPiBeC_xHqqkZx_
		// iPs = G _xZkqqHx_iCmMiPoKiNiHiBeBiDiCiDiKiDhGiKnEiDiKiDjDiDeO_xHqqkZx_AG,CH,BI_xZkqqHx_iCkKiOoGjDlOiClDiCoKiCoJiBeC_xHqqkZx_
		for (iPs = m_stMovedHorz.begin(); iPs != m_stMovedHorz.end(); iPs++)
			if ((*iPs).lMolipId != -1)
				GetAffectedByTo(stAffected, FCMolipRec((*iPs).dwObjID, -1));
		for (iPs = m_stMovedVert.begin(); iPs != m_stMovedVert.end(); iPs++)
			if ((*iPs).lMolipId != -1)
				GetAffectedByTo(stAffected, FCMolipRec((*iPs).dwObjID, -1));
		//----- _xZkqqHx_iKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiCnNiCpAjBeJjFmKiClFiBeBiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiPfHiCnPiCoJ_xHqqkZx_ -----
		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A,B,C _xZkqqHx_iCpAiPfHiCnPiCoJiBeC_xHqqkZx_
		FTMolipSet stMovedMolip;
		DWORDSet::const_iterator iMi;
		for (iMi = stAffected.begin(); iMi != stAffected.end(); iMi++)
		{
			const FCLinkRec* pRec = LinkIDtoLinkRec(*iMi);
			if ((pRec->m_wLinkKind & 0x0f) == FDLM_LINK_ON_ANGLE_X ||
				(pRec->m_wLinkKind & 0xf0) == FDLM_LINK_ON_ANGLE_Y)
			{
				stMovedMolip.insert(pRec->m_mlpFrom);
			}
		}
		// _xZkqqHx_iKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiBeBiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCkKiInKjDkOiClFiClNiCoAiCmMiCmGiClFiCmEiPiIjHjNiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiPoKiNiHiBeBiDiKiDjDiDeOjAoGjFjEjFgJiCmMjFmPiMgAiCkKiBeBiNfIiCmJiClLiCmMiDiKiDjDiDeOjAoGjFjEjFgJiCmM_xHqqkZx_
		// _xZkqqHx_iMgAiPpDiCmJiJgFiLlPiCpAjHfOiCkGiCoJiClNiCnPiBeC_xHqqkZx_
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_Q_xZkqqHx_iCpAiInKjDkOiClFiClNiPoKiNiHiBeBjDfP_xHqqkZx_G_xZkqqHx_iClOiCkPiCmFiCmIiCkNiBeBjDfP_xHqqkZx_I_xZkqqHx_iCoAiInKjDkOiClHiCoJiBeCiClBiCmMiBeBjDfP_xHqqkZx_I_xZkqqHx_iCpA_xHqqkZx_
		// _xZkqqHx_iInKjDkOiClDiClJiCoJiPiIjHjNiBeC_xHqqkZx_
		for (iPs = stMovedMolip.begin(); iPs != stMovedMolip.end(); iPs++)
			if (!IsAlreadyMovedHorz(*iPs)) MovedNotifySub(*iPs);

		FTMolipSet stResizedHorz;
		// _xZkqqHx_iInKjDkOiDiCiDiKiDhGiDiKiDfIiDgHiCkJiCoHiBeB_xHqqkZx_PointIndex(-1)_xZkqqHx_iImIiKePiCmMjFkIiCpAjCiKiPgPiBeC_xHqqkZx_
		for (iPs = m_stMovedHorz.begin(); iPs != m_stMovedHorz.end(); iPs++)
			if ((*iPs).lMolipId != -1)
				stResizedHorz.insert(FCMolipRec((*iPs).dwObjID, -1));
		// _xZkqqHx_iDiKiDfEiDeDiDfJiCkKjAlGiClGiClNjFjEjFgJiClLiCoKiClMiCoKiCmJiBeBiDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		for (iPs = stResizedHorz.begin(); iPs != stResizedHorz.end(); iPs++)
			if (!IsAlreadyMovedHorz(*iPs)) MovedNotifySub(*iPs);

		FTMolipSet stResizedVert;
		// _xZkqqHx_iInKjDkOiDiCiDiKiDhGiDiKiDfIiDgHiCkJiCoHiBeB_xHqqkZx_PointIndex(-1)_xZkqqHx_iImIiKePiCmMjFkIiCpAjCiKiPgPiBeC_xHqqkZx_
		for (iPs = m_stMovedVert.begin(); iPs != m_stMovedVert.end(); iPs++)
			if ((*iPs).lMolipId != -1)
				stResizedVert.insert(FCMolipRec((*iPs).dwObjID, -1));
			// _xZkqqHx_iDiKiDfEiDeDiDfJiCkKjAlGiClGiClNjFjEjFgJiClLiCoKiClMiCoKiCmJiBeBiDiKiDjDiDeOjAoGjFjEjFgJiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		for (iPs = stResizedVert.begin(); iPs != stResizedVert.end(); iPs++)
			if (!IsAlreadyMovedVert(*iPs)) MovedNotifySub(*iPs);

		// _xZkqqHx_jCiKiPgPiClDiCoKiClNiPfHiNiHiCkKiLpDiCmIiCoHiCmOiBeBiDiKiDfEiDeDiDfJiCkKjAlGiClGiClNjFjEjFgJiCmNjGlDiCkCiCmMiCmFiBeBiPeJjHlJiBeC_xHqqkZx_
		if (stResizedHorz.empty() && stResizedVert.empty()) break;
	}
	if (bUpdateLinkOffset)
	{
		//----- _xZkqqHx_iInKjDkOiCmJiCoGiCmBiCmEjAlGiClGiClNiDiKiDjDiDeOiMlDiCmGiCmMiNmAjFfHiCmMiDfJiDiMiCpAiDeJiDhEiDfKiDgCiDgHjCgMiCmJjElNiJgG_xHqqkZx_ -----
		// _xZkqqHx_iDiKiDjDiDeOjAoGiInKjDkOiCmMiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORDSet stAffected;
		for (iPs = m_stMovedHorz.begin(); iPs != m_stMovedHorz.end(); iPs++)
			GetAffectedByTo(stAffected, *iPs);
		for (iPs = m_stMovedVert.begin(); iPs != m_stMovedVert.end(); iPs++)
			GetAffectedByTo(stAffected, *iPs);
		// _xZkqqHx_iDiKiDjDiDeOiIoKjHjHiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
		DWORDSet::iterator iLt;
		for (iLt = stAffected.begin(); iLt != stAffected.end(); iLt++)
		{
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//			FCLinkRec* linkRec = LinkIDtoLinkRec(*iLt);
//			// _xZkqqHx_iMmDiCkCiDeJiDhEiDfKiDgCiDgHjCgMiCpAiIoKiOjOjFnLjBlGiBeC_xHqqkZx_
//			const DBLPoint mmptBefore = linkRec->m_mmptOffset;
//			// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
//			linkRec->ApplyNewOffset();
//			// _xZkqqHx_iDiKiDjDiDeOiDeJiDhEiDfKiDgCiDgHjFmPiNfIiCpAjCmKjCgNiClHiCoJiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
//			g_pDoc->CmdModify1LinkOffset(*iLt, mmptBefore, linkRec->m_mmptOffset);
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			FCLinkRec linkRec = *LinkIDtoLinkRec(*iLt);
			// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
			linkRec.ApplyNewOffset();
			// _xZkqqHx_iDiKiDjDiDeOiDeJiDhEiDfKiDgCiDgHjFmPiNfIiCpAjCmKjCgNiClHiCoJiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdModify1LinkOffset(*iLt, linkRec.m_mmptOffset);
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
} // FCLinkManager::MovedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::MovedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::MovedNotify (const ObjDynabaseVector& vObj, BOOL bUpdateLinkOffset)
{
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	mdef_const_iterator(ObjDynabaseVector, iObj);
	m1_for (iObj, vObj)
		setMolip.insert(FCMolipRec((*iObj)->GetObjID(), -1));
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	MovedNotify(setMolip, bUpdateLinkOffset);
} // FCLinkManager::MovedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::MovedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::MovedNotify (const ObjDynabaseSet& stObj, BOOL bUpdateLinkOffset)
{
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	mdef_const_iterator(ObjDynabaseSet, iObj);
	m1_for (iObj, stObj)
		setMolip.insert(FCMolipRec((*iObj)->GetObjID(), -1));
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	MovedNotify(setMolip, bUpdateLinkOffset);
} // FCLinkManager::MovedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::MovedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::MovedNotify (const FCObjDynabase* pObj, BOOL bUpdateLinkOffset)
{
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	setMolip.insert(FCMolipRec(pObj->GetObjID(), -1));
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	MovedNotify(setMolip, bUpdateLinkOffset);
} // FCLinkManager::MovedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::AddedDeletedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCkKjCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiPoKiNiHiBeBiClLiCmMjCmHiJmBiBeFiNoNiPjMiCmMiJgFiLlPiCpAiOpDiCkPiCoJjBfDiCmEiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiNfIjAfGiClHiCoJiBeCiDfCiDhNiDjDiDgIiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	linkRec	:_xZkqqHx_jCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmJjBmOiClFiCmEjDkNiCkNiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmMiBeB_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiOgEjHgMiCmMjAhNiCmJiCkIiCkCiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCkKjCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiPoKiNiHiBeBiKpJiCmJjBlGiNnNiClHiCoJiDiKiDjDiDeO_xHqqkZx_BH_xZkqqHx_iCmNiBeBiDeJiDhEiDfKiDgCiDgHjCgM_xHqqkZx_
 *			_xZkqqHx_iCmJiJgFiLlPiCpAiOpDiCkPiCoJiBeCiCmIiClKiCmIiCoHiBeBiDiKiDjDiDeO_xHqqkZx_BH_xZkqqHx_iCmNiBeBiClLiCoKiCnMiCmFjClMjApM_xHqqkZx_GB_xZkqqHx_iCmMiKhAjDhI_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHiMhGiOfKiClDiCoKiCmEiCkCiClNiCmMiCkKiBeBjClMjApM_xHqqkZx_AB_xZkqqHx_iCmMiKhAjDhIiCmJiKoOiCmDiCkCiCmEiMhGiOfKiClDiCoKiCoJiClNiCnPiBeC_xHqqkZx_
 *
// 01.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCkKjEkNiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCmNjEkNiNhDiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::AddedDeletedNotify (const FCLinkRec& linkRec)
{
//----- 06.10.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (linkRec.m_wLinkKind == FDLM_LINK_ON_ANGLE)
//	{
//----- 06.10.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// linkRec.m_wLinkKind != FDLM_LINK_ON_ANGLE _xZkqqHx_iCmFiCkAiCmBiCmEiCoAiBeB_xHqqkZx_
	// _xZkqqHx_jElNjBmOjBkEiCmMiDiCiDiKiDhGiCmMiDiKiDjDiDeOiCkK_xHqqkZx_ FDLM_LINK_ON_ANGLE _xZkqqHx_iCmFiCkAiCoJiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_iClLiCmMiDeJiDhEiDfKiDgCiDgHiCmNiJgFiLlPiCpAiOpDiCkPiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_linkRec.m_wLinkKind == FDLM_LINK_ON_ANGLE _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iDgAiDeGiDgCiDeOiClJiClIjGlDiPpAiMiPiCmF_xHqqkZx_ApplyNewOffset_xZkqqHx_iCpAiMhGiOfKiClDiClJiCoJiBeC_xHqqkZx_

	// _xZkqqHx_jFjEjFgJiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJjBfDiCmEiCmMiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORDSet stAffected;
	GetAffectedByTo(stAffected, FCMolipRec(linkRec.m_mlpTo.dwObjID, -1));
	//----- _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCmMiCkEiClPiBeBiKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiCnNiNfIjAfG_xHqqkZx_ -----
	DWORDSet::const_iterator iMi;
	for (iMi = stAffected.begin(); iMi != stAffected.end(); iMi++)
	{
		FCLinkRec* pRec = GetLinkRec(*iMi);
		if (pRec->m_wLinkKind == FDLM_LINK_ON_ANGLE)
		//----- _xZkqqHx_iKhAjDhIiIoKjCoIiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
			pRec->ApplyNewOffset();
		}
	}

// 06.10.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	}
} // FCLinkManager::AddedDeletedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::DeleteSoonNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiNoNiPjMiClDiCoKiCoJjClMjBePiCmJiBeBiClLiCmMiJgFiLlPiCpAiDiKiDjDiDeOiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwObjID	:_xZkqqHx_iNoNiPjMiClHiCoJjFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::DeleteSoonNotify (DWORD dwObjID)
{
	// _xZkqqHx_jFjEjFgJiCkJiCoHiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiClHiCoJjBfDiCmEiCmMiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORDSet setLink;
	GetAffectedByTo(setLink, FCMolipRec(dwObjID, -1));
	GetAffectedByFrom(setLink, FCMolipRec(dwObjID, -1));

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iDiKiDjDiDeOiCpAiNoNiPjMiBeC_xHqqkZx_
	DWORDSet::iterator isIdx;
	for (isIdx = setLink.begin(); isIdx != setLink.end(); isIdx++)
	{
		g_pDoc->CmdDelete1Link(stRedrawObj, *isIdx);
	}
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!stRedrawObj.empty())
	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->AppendToLastRgn(stRedrawObj);
		g_pView->PostRgnRedraw();
	}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLinkManager::DeleteSoonNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetAffectedByFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCmMiInKjDkOiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiCmMiDiKiDfIiDgHiCpA_xHqqkZx_
 *			vAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vAffected	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiBeBiDiKiDjDiDeOiMlDjFjEjFgJiCmMjBfDiCmEiCmMiDiCiDiKiDhGiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetAffectedByFrom (FCLinkRecPVector& vAffected,
										const FCMolipRec& lkptFrom) const
{
	FTMolipLinkMmap::const_iterator iPt;
	if (lkptFrom.lMolipId == -1)
	//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCmMjBfDiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapFrom2Link.lower_bound(lkptFrom);
			 iPt != m_mmapFrom2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first.dwObjID != lkptFrom.dwObjID) break;
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			vAffected.push_back(LinkIDtoLinkRec((*iPt).second));
		}
	} else
	//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCmMiCfAiCmCiCmMiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapFrom2Link.find(lkptFrom); iPt != m_mmapFrom2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first != lkptFrom) break;
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			vAffected.push_back(LinkIDtoLinkRec((*iPt).second));
		}
	}
} // FCLinkManager::GetAffectedByFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetAffectedByFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCmMiInKjDkOiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiCmMiDiKiDfIiDgHiCpA_xHqqkZx_
 *			stAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stAffected	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgH_xHqqkZx_(ID)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiBeBiDiKiDjDiDeOiMlDjFjEjFgJiCmMjBfDiCmEiCmMiDiCiDiKiDhGiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.04.25 Fukushiro M. vector_xZkqqHx_iCkJiCoH_xHqqkZx_set_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetAffectedByFrom (DWORDSet& stAffected,
										const FCMolipRec& lkptFrom) const
{
	FTMolipLinkMmap::const_iterator iPt;
	if (lkptFrom.lMolipId == -1)
	//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCmMjBfDiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapFrom2Link.lower_bound(lkptFrom);
			 iPt != m_mmapFrom2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first.dwObjID != lkptFrom.dwObjID) break;
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			stAffected.insert((*iPt).second);
		}
	} else
	//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCmMiCfAiCmCiCmMiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapFrom2Link.find(lkptFrom); iPt != m_mmapFrom2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first != lkptFrom) break;
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			stAffected.insert((*iPt).second);
		}
	}
} // FCLinkManager::GetAffectedByFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetAffectedByTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmMiInKjDkOiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiCmMiDiKiDfIiDgHiCpA_xHqqkZx_
 *			vAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vAffected	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiBeBiDiKiDjDiDeOjAoGjFjEjFgJiCmMjBfDiCmEiCmMiDiCiDiKiDhGiCnG_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetAffectedByTo (FCLinkRecPVector& vAffected,
										const FCMolipRec& lkptTo) const
{
	FTMolipLinkMmap::const_iterator iPt;
	if (lkptTo.lMolipId == -1)
	//----- _xZkqqHx_iDiKiDjDiDeOjAoGiCmMjBfDiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapTo2Link.lower_bound(lkptTo);
			 iPt != m_mmapTo2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOjAoGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first.dwObjID != lkptTo.dwObjID) break;
			// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			vAffected.push_back(LinkIDtoLinkRec((*iPt).second));
		}
	} else
	//----- _xZkqqHx_iDiKiDjDiDeOjAoGiCmMiCfAiCmCiCmMiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapTo2Link.find(lkptTo); iPt != m_mmapTo2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOjAoGiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first != lkptTo) break;
			// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			vAffected.push_back(LinkIDtoLinkRec((*iPt).second));
		}
	}
} // FCLinkManager::GetAffectedByTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetAffectedByTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmMiInKjDkOiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiCmMiDiKiDfIiDgHiCpA_xHqqkZx_
 *			stAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stAffected	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgH_xHqqkZx_(ID)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiBeBiDiKiDjDiDeOjAoGjFjEjFgJiCmMjBfDiCmEiCmMiDiCiDiKiDhGiCnG_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.04.25 Fukushiro M. vector_xZkqqHx_iCkJiCoH_xHqqkZx_set_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetAffectedByTo (DWORDSet& stAffected,
									 const FCMolipRec& lkptTo) const
{
	FTMolipLinkMmap::const_iterator iPt;
	if (lkptTo.lMolipId == -1)
	//----- _xZkqqHx_iDiKiDjDiDeOjAoGiCmMjBfDiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapTo2Link.lower_bound(lkptTo);
			 iPt != m_mmapTo2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOjAoGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first.dwObjID != lkptTo.dwObjID) break;
			// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			stAffected.insert((*iPt).second);
		}
	} else
	//----- _xZkqqHx_iDiKiDjDiDeOjAoGiCmMiCfAiCmCiCmMiDiCiDiKiDhGiCkKiInKjDkO_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		for (iPt = m_mmapTo2Link.find(lkptTo); iPt != m_mmapTo2Link.end(); iPt++)
		{
			// _xZkqqHx_iDiKiDjDiDeOjAoGiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPt).first != lkptTo) break;
			// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			stAffected.insert((*iPt).second);
		}
	}
} // FCLinkManager::GetAffectedByTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetAffected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiPfHiNiHjBmMiCkJiCoHiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLinkIn		:_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLinkOut	:_xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLinkInside	:_xZkqqHx_iDiBiDjDiDgPiKnEiCmFiDiKiDjDiDeOiClHiCoJiDiKiDjDiDeOiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			stMolip		:_xZkqqHx_iDiCiDiKiDhGiPfHiNiHjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	stMolip _xZkqqHx_iCpAiDiCiDiKiDhGiCmMiPfHiNiHjBmMiCmGiNgMiCkGiCmEiBeBiPfHiNiHjBmMiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiPfHiNiHiCpA_xHqqkZx_ stLinkIn _xZkqqHx_iCmJiBeBiPfHiNiHjBmMiCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiPfHiNiHiCpA_xHqqkZx_ stLinkOut _xZkqqHx_iCmJiBeBiPfHiNiHjBmMiCmMiDiBiDjDiDgPiKnEiCmJiDiKiDjDiDeOiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOiPfHiNiHiCpA_xHqqkZx_ stLinkInside _xZkqqHx_iCmJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vLinkIn,vLinkOut_xZkqqHx_iCmNjDkPiClG_xHqqkZx_vector_xZkqqHx_jFmPjAjEiCmFiCoAjBoFiPoEjFhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::GetAffected (DWORDVector& vLinkIn, DWORDVector& vLinkOut,
								DWORDVector& vLinkInside, const FTMolipSet& stMolip) const
{
	//----- _xZkqqHx_iKgFjFmPjAjEiCpAiLpDiCmJ_xHqqkZx_ -----
	vLinkIn.clear();
	vLinkOut.clear();
	vLinkInside.clear();

	DWORDSet stLinkFrom;	// _xZkqqHx_iDiCiDiKiDhGiCkJiCoHjAeMiCnBiCoJiDiKiDjDiDeOiCmMiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stLinkTo;		// _xZkqqHx_iDiCiDiKiDhGiCmJjDpMiCoJiDiKiDjDiDeOiCmMiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet::const_iterator iMp;
	for (iMp = stMolip.begin(); iMp != stMolip.end(); iMp++)
	{
		// _xZkqqHx_iDiLiBfLiDhGiCmFiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClFiCmEiCkCiCkNiBeC_xHqqkZx_
		GetAffectedByFrom(stLinkFrom, *iMp);
		GetAffectedByTo(stLinkTo, *iMp);
	}

	// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiCmMiDiKiDjDiDeOiPfHiNiHiBeBiDiKiDjDiDeOiDeBiDeFiDgHiCmMiDiKiDjDiDeOiPfHiNiHiCpAjEoEiKhCiClFiBeB_xHqqkZx_
	// _xZkqqHx_jHlMjFpLiCmJiLkEjCmKiCmFiKnMiCnMiCoKiCoJiDiKiDjDiDeOiCmMiCnNiCkKiBeBiPfHiNiHjBmMiDiBiDjDiDgPiKnEiCmMiDiKiDjDiDeOiBeC_xHqqkZx_

	DWORDSet::const_iterator iFm = stLinkFrom.begin();
	DWORDSet::const_iterator iTo = stLinkTo.begin();
	while (iFm != stLinkFrom.end() || iTo != stLinkTo.end())
	{
		// _xZkqqHx_iCnMiClIiBeBiNmFiPiJiCmMjDpBiCmCiCmM_xHqqkZx_if_xZkqqHx_jFlGiCmF_xHqqkZx_ iTo_xZkqqHx_iCoA_xHqqkZx_iFm_xZkqqHx_iCoA_xHqqkZx_end_xZkqqHx_iCmFiCmIiCkCiOjGiCpAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
		if (iTo == stLinkTo.end())
		{
			vLinkOut.push_back(*iFm);
			iFm++;
		} else
		if (iFm == stLinkFrom.end())
		{
			vLinkIn.push_back(*iTo);
			iTo++;
		} else
		// _xZkqqHx_iImIiJlKiCmFiCmNiBeBjDpBiCmCiCmMiDfMiBfLiDgHiClDiCoKiClNiPfHiNiHiCpAiLkDjBiIiClDiClJiCmEiBeBjDjJiClFiCkCiPoKiNiHiCmMiCnN_xHqqkZx_Inside_xZkqqHx_iCmJjCmHiJmBiBeC_xHqqkZx_
		if (*iFm < *iTo)
		{
			vLinkOut.push_back(*iFm);
			iFm++;
		} else
		if (*iTo < *iFm)
		{
			vLinkIn.push_back(*iTo);
			iTo++;
		} else
		{
			vLinkInside.push_back(*iFm);
			iFm++, iTo++;
		}
	}
} // FCLinkManager::GetAffected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::LinkIDtoLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//FCLinkRec* FCLinkManager::LinkIDtoLinkRec (DWORD dwLinkID) const
const FCLinkRec* FCLinkManager::LinkIDtoLinkRec (DWORD dwLinkID) const
{
// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return (FCLinkRec*)m_tblLinkID.IDtoObject(dwLinkID);
	return (const FCLinkRec*)m_tblLinkID.IDtoObject(dwLinkID);
} // FCLinkManager::LinkIDtoLinkRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ClearAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiPoOjFpBiCpAiPmBiLiOiClFiBeBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ClearAll ()
{
	// _xZkqqHx_iDiKiDjDiDeOiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	for (DWORD dwID = m_tblLinkID.GetFirstID();
		 dwID != DWORD(-1); dwID = m_tblLinkID.GetNextID(dwID))
		delete (FCLinkRec*)m_tblLinkID.IDtoObject(dwID);
	// _xZkqqHx_iDiBiDeDiDjDiDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	m_tblLinkID.ClearAll();
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	m_mmapFrom2Link.clear();
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	m_mmapTo2Link.clear();
	// _xZkqqHx_iInKjDkOiNmPiDiCiDiKiDhGiDgFiBfLiDhFiDiLiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	m_stMovedHorz.clear();
	m_stMovedVert.clear();
} // FCLinkManager::ClearAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDeDiDjDiDgFiBfLiDhFiDiLiCkJiCoHiDiKiDjDiDeOiPoOjFpBiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOutObject:_xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::OutStream (FCUndoArchive& ar, BOOL bIsOutObject) const
{
	if (bIsOutObject)
	//----- _xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDeDiDjDiDgFiBfLiDhFiDiLiCmMiDiKiDjDiDeOiCfAiCmCiClIiCmCiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
		for (DWORD dwLinkID = m_tblLinkID.GetFirstID();
			 dwLinkID != DWORD(-1); dwLinkID = m_tblLinkID.GetNextID(dwLinkID))
		{
			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			FCLinkRec* linkRec = (FCLinkRec*)m_tblLinkID.IDtoObject(dwLinkID);
			// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
			ar << dwLinkID;
			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
			ar.Write(linkRec, sizeof(*linkRec));
		}
	}
	// _xZkqqHx_iPeJjHlJiDfCiBfLiDgIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << DWORD(-1);
} // FCLinkManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiPoOjFpBiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDpMjHmNiClFiBeBiDiBiDeDiDjDiDgFiBfLiDhFiDiLiCmJiNoMjAkMiBeFjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNiMlDiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::InStream (FCUndoArchive& ar)
{
	// _xZkqqHx_jBfDiCmEiCmMjDoAjFjEiPoOjFpBiCpAjGjFiPmBiBeC_xHqqkZx_
	ClearAll();
	DWORD dwLinkID;
	for (;;)
	{
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar >> dwLinkID;
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCkKiPeJjHlJiDfCiBfLiDgIiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (dwLinkID == DWORD(-1)) break;
		// _xZkqqHx_iDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
		FCLinkRec* linkRec = new FCLinkRec;
		// _xZkqqHx_iDiKiDjDiDeOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar.Read(linkRec, sizeof(*linkRec));

#ifdef _LOCAL_CONV
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
		if (g_pDoc->ObjID2Object(linkRec->m_mlpFrom.dwObjID)->Type() == FDOJ_ARC &&
			linkRec->m_mlpFrom.lMolipId != -1)
		{
			linkRec->m_mlpFrom.lMolipId = -1;
			linkRec->ApplyNewOffset();
		}
		// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDjFhDiJmCiCmMiClNiCnPiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmNjClCiCnHiCoJjFeLjHhGiCkKjGlDiCkCiBeC_xHqqkZx_
#endif// _LOCAL_CONV

		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
		m_tblLinkID.Register(linkRec, dwLinkID);
		// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
		m_mmapFrom2Link.insert(FTMolipLinkPair(linkRec->m_mlpFrom, dwLinkID));
		// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
		m_mmapTo2Link.insert(FTMolipLinkPair(linkRec->m_mlpTo, dwLinkID));
	}
} // FCLinkManager::InStream.

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::PrepareMolipInfoVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCMolipInfoVector_xZkqqHx_iCmMjEhKjHpBiCpAiPiAjEpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMolipInf	:_xZkqqHx_jIeBiMiLjDfPiCmMiDiCiDiKiDhGiPoOjFpBiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pMolipInf	:_xZkqqHx_jCiGjAfD_xHqqkZx_(-1)_xZkqqHx_iCmMiDiCiDiKiDhGiPoOjFpBiCpAjFnEiClHiBeCjFhDjHhGiCmIiCoHiCmO_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipSz	:vMolipInf_xZkqqHx_iCmJiNfMjChKiClHiCoJjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwObjID		:_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeBjIeBiMiLjDfPjAjEiCkKiCfEiCmMiDhMiDiKiDfDiDjDjFjEjFgJiCmNiBeBiCfAiCePiMmCiBgJiBhLjCiGjAfDiCmMiCfAiBgKiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhGiCpAiOjNiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCkIiCmMiCkIiCmMiCmMiDiCiDiKiDhGiCmJiCmNiBeBiDiKiDjDiDeOiCkKiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCfAiCePiCmMiDiCiDiKiDhGiPoOjFpBiBgJ_xHqqkZx_vMolipInf_xZkqqHx_iBgKiCpAiNoMjAkMiClFiBeBiDhMiDiKiDfDiDjDjFjEjFgJiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhGiCmMiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiPpDiLlFiCpAiClLiCmBiCkNiCoIiDiCiDiKiDhGiPoOjFpBiBgJ_xHqqkZx_vMolipInf_xZkqqHx_iBgK_xHqqkZx_
 *			_xZkqqHx_iCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjDpMiCoKjBnGiCkGiBeFjBhNjDpMiBeFiNoNiPjMiCmJiNiHiCoNiClJiCmEiDiCiDiKiDhGiPoOjFpBiBgJ_xHqqkZx_vMolipInf_xZkqqHx_iBgKiCmM_xHqqkZx_
 *			_xZkqqHx_jEhKjHpBiCmMiPiHjEnEiCpAjBiAiNoMiClFiClNiMoDiBeBiDiKiDjDiDeOiCmMiDfJiDiMiCpAiMjPiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::PrepareMolipInfoVector (FCMolipInfoVector& vMolipInf,
											FCMolipInfo* pMolipInf,
											long lMolipSz, DWORD dwObjID)
{
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBjEhKjHpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	vMolipInf.clear();
	vMolipInf.assign(lMolipSz);
	// dwObjID_xZkqqHx_iCmMjFjEjFgJiCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DWORDVector vFromLink;
//	GetAffectedByFrom(vFromLink, FCMolipRec(dwObjID, -1));
//	// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmFiDiLiBfLiDhGiBeC_xHqqkZx_
//	DWORDVector::iterator iIdx;
//	for (iIdx = vFromLink.begin(); iIdx != vFromLink.end(); iIdx++)
//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORDSet stFromLink;
	GetAffectedByFrom(stFromLink, FCMolipRec(dwObjID, -1));
	// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmFiDiLiBfLiDhGiBeC_xHqqkZx_
	DWORDSet::iterator iIdx;
	for (iIdx = stFromLink.begin(); iIdx != stFromLink.end(); iIdx++)
//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		const FCLinkRec* pRec = LinkIDtoLinkRec(*iIdx);
		ASSERT(pRec->m_mlpFrom.dwObjID == dwObjID);
		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iImIiKePiCmMiOjOiCmJ_xHqqkZx_ vMolipInf_xZkqqHx_iCmMiDiCiDiKiDhGiCmJiPoOjFpBjCmHiJmBiBeC_xHqqkZx_
		if (0 <= pRec->m_mlpFrom.lMolipId)
			vMolipInf[pRec->m_mlpFrom.lMolipId].vLinkFrom.push_back(*iIdx);
		else
		// -1 _xZkqqHx_iCmMiOjOiCmN_xHqqkZx_ molipInf_xZkqqHx_iCmMiDiCiDiKiDhGiCmJiPoOjFpBjCmHiJmBiBeC_xHqqkZx_
		{
			if (pMolipInf != NULL)
				pMolipInf->vLinkFrom.push_back(*iIdx);
		}
	}

//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DWORDVector vToLink;
//	// dwObjID_xZkqqHx_iCmMjFjEjFgJiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
//	GetAffectedByTo(vToLink, FCMolipRec(dwObjID, -1));
//	// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmFiDiLiBfLiDhGiBeC_xHqqkZx_
//	for (iIdx = vToLink.begin(); iIdx != vToLink.end(); iIdx++)
//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORDSet stToLink;
	// dwObjID_xZkqqHx_iCmMjFjEjFgJiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	GetAffectedByTo(stToLink, FCMolipRec(dwObjID, -1));
	// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmFiDiLiBfLiDhGiBeC_xHqqkZx_
	for (iIdx = stToLink.begin(); iIdx != stToLink.end(); iIdx++)
//----- 01.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		const FCLinkRec* pRec = LinkIDtoLinkRec(*iIdx);
		ASSERT(pRec->m_mlpTo.dwObjID == dwObjID);
		// _xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iImIiKePiCmMiOjOiCmJ_xHqqkZx_ vMolipInf_xZkqqHx_iCmMiDiCiDiKiDhGiCmJiPoOjFpBjCmHiJmBiBeC_xHqqkZx_
		if (0 <= pRec->m_mlpTo.lMolipId)
			vMolipInf[pRec->m_mlpTo.lMolipId].vLinkTo.push_back(*iIdx);
		else
		// -1 _xZkqqHx_iCmMiOjOiCmN_xHqqkZx_ molipInf_xZkqqHx_iCmMiDiCiDiKiDhGiCmJiPoOjFpBjCmHiJmBiBeC_xHqqkZx_
		{
			if (pMolipInf != NULL)
				pMolipInf->vLinkTo.push_back(*iIdx);
		}
	}
} // FCLinkManager::SetMolipInfVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::UpdateLinkConnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMjAnKjBlBiKnGiMfHiCmMiDfJiDiMiCpAiBeB_xHqqkZx_vMolipInf_xZkqqHx_iCkJiCoHiOoGiCoIiPgPiClFiCmEjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwObjID		:vMolipInf_xZkqqHx_iCmMiDiCiDiKiDhGiCpAiOjNiCmCjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vMolipInf	:_xZkqqHx_iDiCiDiKiDhGiPoOjFpBiCmMjEhKjHpBiCpAiOhHjCoIiBeCiDiKiDjDiDeOiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCmNiBeBiDiKiDjDiDeOiPoOjFpBiCkKjGjFiPmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			pMolipInf	:_xZkqqHx_jCiGjAfD_xHqqkZx_(-1)_xZkqqHx_iCmMiDiCiDiKiDhGiPoOjFpBiCpAiOhHjCoIiBeCjFhDjHhGiCmIiCoHiCmO_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::UpdateLinkConnect (	DWORD dwObjID,
										FCMolipInfoVector& vMolipInf,
										FCMolipInfo* pMolipInf)
{
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	//----- _xZkqqHx_iDiLiBfLiDhGiCmMiPiJiKpKjAnNjCoI_xHqqkZx_ -----
	long lMolipId = 0;
	FCMolipInfo* pInf = vMolipInf.begin();
	// -1_xZkqqHx_iDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiDiLiBfLiDhGiKeKiOgOiDiCiDiKiDhG_xHqqkZx_Idx_xZkqqHx_iCpA_xHqqkZx_-1_xZkqqHx_iCmJjAnNjCoIiBeC_xHqqkZx_
	if (pMolipInf != NULL)
	{
		lMolipId = -1;
		pInf = pMolipInf;
	}
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiPoOjFpBiCmMjBfDiCmEiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
	while (lMolipId != vMolipInf.size())
	{
		// _xZkqqHx_iClBiCmMiDiCiDiKiDhGiCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiDiKiDjDiDeOjBfDiCmEiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
		DWORDVector::iterator iIdx;
		for (iIdx = pInf->vLinkFrom.begin(); iIdx != pInf->vLinkFrom.end();)
		{
			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			const FCLinkRec* pRec = LinkIDtoLinkRec(*iIdx);
			if (pRec != NULL)
			//----- _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiKiDjDiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOiMlDiCmGiBeBiClBiCmMiPoOjFpBiCmMiDiKiDjDiDeOiMlDiCkKjAeIiCkCiIoBiCkEiPoKiNiHiCmNiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
				if (pRec->m_mlpFrom.dwObjID != dwObjID ||
					pRec->m_mlpFrom.lMolipId != lMolipId)
				{
					// _xZkqqHx_iDiCiDiKiDhGjFmPiNfIiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
					g_pDoc->CmdModify1LinkMolip(stRedrawObj,
												*iIdx,
												FCMolipRec(dwObjID, lMolipId),
												pRec->m_mlpTo);
				}
				iIdx++;
			} else
			//----- _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiKiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				iIdx = pInf->vLinkFrom.erase(iIdx);
			}
		}
		// _xZkqqHx_iClBiCmMiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOjBfDiCmEiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
		for (iIdx = pInf->vLinkTo.begin(); iIdx != pInf->vLinkTo.end();)
		{
			// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
			const FCLinkRec* pRec = LinkIDtoLinkRec(*iIdx);
			if (pRec != NULL)
			//----- _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiKiDjDiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOjAoGiCmGiBeBiClBiCmMiPoOjFpBiCmMiDiKiDjDiDeOiMlDiCkKjAeIiCkCiIoBiCkEiPoKiNiHiCmNiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
				if (pRec->m_mlpTo.dwObjID != dwObjID ||
					pRec->m_mlpTo.lMolipId != lMolipId)
				{
					// _xZkqqHx_iDiCiDiKiDhGjFmPiNfIiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
					g_pDoc->CmdModify1LinkMolip(stRedrawObj,
												*iIdx,
												pRec->m_mlpFrom,
												FCMolipRec(dwObjID, lMolipId));
				}
				iIdx++;
			} else
			//----- _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiKiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				iIdx = pInf->vLinkTo.erase(iIdx);
			}
		}
		// _xZkqqHx_iOjPiCmMiDiCiDiKiDhGiCnGiBeC_xHqqkZx_
		lMolipId++;
		pInf = vMolipInf.begin() + lMolipId;
	}
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!stRedrawObj.empty())
	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->AppendToLastRgn(stRedrawObj);
		g_pView->PostRgnRedraw();
	}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLinkManager::UpdateLinkConnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::DeleteLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmJjAnKjBlBiClDiCoKiCoJiDiKiDjDiDeOiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMolipInf	:_xZkqqHx_iDiCiDiKiDhGiPoOjFpBiCpAiOhHjCoIiBeCiDiKiDjDiDeOiPoOjFpBiCkKjGjFiPmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			pMolipInf	:_xZkqqHx_jCiGjAfD_xHqqkZx_(-1)_xZkqqHx_iCmMiDiCiDiKiDhGiPoOjFpBiCpAiOhHjCoIiBeCjFhDjHhGiCmIiCoHiCmO_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::DeleteLink (FCMolipInfoVector& vMolipInf,
								FCMolipInfo* pMolipInf)
{
	DWORDSet setLink;
	//----- _xZkqqHx_iDiLiBfLiDhGiCmMiPiJiKpKjAnNjCoI_xHqqkZx_ -----
	long lMolipId = 0;
	FCMolipInfo* pInf = vMolipInf.begin();
	// -1_xZkqqHx_iDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiDiLiBfLiDhGiKeKiOgOiDiCiDiKiDhG_xHqqkZx_Idx_xZkqqHx_iCpA_xHqqkZx_-1_xZkqqHx_iCmJjAnNjCoIiBeC_xHqqkZx_
	if (pMolipInf != NULL)
	{
		lMolipId = -1;
		pInf = pMolipInf;
	}
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiPoOjFpBiCmMjBfDiCmEiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
	while (lMolipId != vMolipInf.size())
	{
		setLink.insert(pInf->vLinkFrom.begin(),
				 		pInf->vLinkFrom.end());
		setLink.insert(pInf->vLinkTo.begin(),
			 			pInf->vLinkTo.end());
		pInf->vLinkFrom.clear();
		pInf->vLinkTo.clear();
		// _xZkqqHx_iOjPiCmMiDiCiDiKiDhGiCnGiBeC_xHqqkZx_
		lMolipId++;
		pInf = vMolipInf.begin() + lMolipId;
	}

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	DWORDSet::iterator isIdx;
	for (isIdx = setLink.begin(); isIdx != setLink.end(); isIdx++)
		g_pDoc->CmdDelete1Link(stRedrawObj, *isIdx);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!stRedrawObj.empty())
	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->AppendToLastRgn(stRedrawObj);
		g_pView->PostRgnRedraw();
	}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLinkManager::DeleteLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ReLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKpJjBlGiCmMiDiKiDjDiDeOiCpAjBfDiCmEiNoNiPjMiClFiClNiMoDiBeB_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiCpAjCkDiCoJiBeCiClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_B
 *			_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	molipA		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stMolipB	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkFrom	:_xZkqqHx_iDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ReLink (const FCMolipRec& molipA,
							const FTMolipSet& stMolipB, WORD wLinkKind)
{
	if (wLinkKind == 0 || wLinkKind == WORD(-1)) return;

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	FTMolipSet::const_iterator iTo;
	for (iTo = stMolipB.begin(); iTo != stMolipB.end(); iTo++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiDiKiDjDiDeOjAoGiCkKjDkPiClGiCmIiCoHiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (*iTo == molipA) continue;
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjHpBiLjDiBeC_xHqqkZx_
		DWORDSet stLinkIdx;
		g_pDoc->LinkManager()->GetAffectedByTo(stLinkIdx, *iTo);
		//----- _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOiCpAjBfDiCmEiPmBiLiO_xHqqkZx_ -----
		BOOL bSameLink = FALSE;	// _xZkqqHx_iKpJiCmJjDkPiClGiDiKiDjDiDeOiCkKjCkDiCoHiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		DWORDSet::iterator iLs;
		for (iLs = stLinkIdx.begin(); iLs != stLinkIdx.end(); iLs++)
		{
			const FCLinkRec* pLRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iLs);
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCkKjDjJiClFiCkNiBeBiDiKiDjDiDeOiOoNiCoAjDjJiClFiCkCiCmIiCoHiCmOiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
			if (pLRec->m_mlpFrom == molipA)
			{
				bSameLink = TRUE;
				if (pLRec->m_wLinkKind != wLinkKind)
					g_pDoc->CmdModify1LinkKind(*iLs, wLinkKind);
			} else
			{
				g_pDoc->CmdDelete1Link(stRedrawObj, *iLs);
			}
		}
		//----- _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCpAiNoMjAkM_xHqqkZx_ -----
		if (!bSameLink)
		{
			(void)g_pDoc->CmdAppend1Link(stRedrawObj, molipA, *iTo, wLinkKind);
		}
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!stRedrawObj.empty())
	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->AppendToLastRgn(stRedrawObj);
		g_pView->PostRgnRedraw();
	}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLinkManager::ReLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ReLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiKpJjBlGiCmMiDiKiDjDiDeOiCpAjBfDiCmEiNoNiPjMiClFiClNiMoDiBeB_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiCpAjCkDiCoJiBeCiClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_A
 *			_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMolipA	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			molipB		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkFrom	:_xZkqqHx_iDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ReLink (const FTMolipSet& stMolipA,
							const FCMolipRec& molipB, WORD wLinkKind)
{
	if (wLinkKind == 0 || wLinkKind == WORD(-1)) return;

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	FTMolipSet::const_iterator iFrom;
	for (iFrom = stMolipA.begin(); iFrom != stMolipA.end(); iFrom++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiDiKiDjDiDeOjAoGiCkKjDkPiClGiCmIiCoHiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (*iFrom == molipB) continue;
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjHpBiLjDiBeC_xHqqkZx_
		DWORDSet stLinkIdx;
		g_pDoc->LinkManager()->GetAffectedByFrom(stLinkIdx, *iFrom);
		//----- _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOiCpAjBfDiCmEiPmBiLiO_xHqqkZx_ -----
		BOOL bSameLink = FALSE;	// _xZkqqHx_iKpJiCmJjDkPiClGiDiKiDjDiDeOiCkKjCkDiCoHiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		DWORDSet::iterator iLs;
		for (iLs = stLinkIdx.begin(); iLs != stLinkIdx.end(); iLs++)
		{
			const FCLinkRec* pLRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iLs);
			// _xZkqqHx_iDiKiDjDiDeOiMlDiCkKjDjJiClFiCkNiBeBiDiKiDjDiDeOiOoNiCoAjDjJiClFiCkCiCmIiCoHiCmOiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
			if (pLRec->m_mlpTo == molipB)
			{
				bSameLink = TRUE;
				if (pLRec->m_wLinkKind != wLinkKind)
					g_pDoc->CmdModify1LinkKind(*iLs, wLinkKind);
			} else
			{
				g_pDoc->CmdDelete1Link(stRedrawObj, *iLs);
			}
		}
		//----- _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCpAiNoMjAkM_xHqqkZx_ -----
		if (!bSameLink)
		{
			DWORD dwLinkId = g_pDoc->CmdAppend1Link(stRedrawObj, *iFrom, molipB, wLinkKind);
		}
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!stRedrawObj.empty())
	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->AppendToLastRgn(stRedrawObj);
		g_pView->PostRgnRedraw();
	}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLinkManager::ReLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ConvertSubToMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiDiKiDjDiDeOiDeJiDhFiDfHiDeGiDeOiDgHiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFmPiKlHiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDiBiDeDiDjDiDgFiBfLiDhFiDiLiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmMiDiKiDjDiDeOiDeJiDhFiDfHiDeGiDeOiDgHiCmNiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pSubIdTable	:_xZkqqHx_iDfEiDhF_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FoundDoc::DoPasteNative_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			InStreamSubTable_xZkqqHx_iCmMiMoDiCmJjFeLiClIiClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.12.04 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ConvertSubToMain (const FCLinkManager* pSubMgr, FCObjIDTbl* pSubIdTable)
{
	// _xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmMiDiKiDjDiDeOiCfAiCmCiClIiCmCiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
	for (DWORD dwID = pSubMgr->m_tblLinkID.GetFirstID(); dwID != DWORD(-1);
		 dwID = pSubMgr->m_tblLinkID.GetNextID(dwID))
	{
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLinkRec linkRec = *(FCLinkRec*)pSubMgr->m_tblLinkID.IDtoObject(dwID);
		FCObjDynabase* pObj;
		//----- _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCmMiDiKiDjDiDeOiMlDiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		pObj = (FCObjDynabase*)pSubIdTable->IDtoObject(linkRec.m_mlpFrom.dwObjID);
		if (pObj == NULL) continue;
		linkRec.m_mlpFrom.dwObjID = pObj->GetObjID();
		//----- _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCmMiDiKiDjDiDeOjAoGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		pObj = (FCObjDynabase*)pSubIdTable->IDtoObject(linkRec.m_mlpTo.dwObjID);
		if (pObj == NULL) continue;
		linkRec.m_mlpTo.dwObjID = pObj->GetObjID();
		// _xZkqqHx_iDiKiDjDiDeOjCmHiJmBiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeCiMiLiJmKiBeBiDiBiDeDiDjDiDgFiBfLiDhFiDiLiCmJjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		g_pDoc->CmdAppend1Link(ObjDynabaseSet(), linkRec.m_mlpFrom, linkRec.m_mlpTo, linkRec.m_wLinkKind);
	}
} // FCLinkManager::ConvertSubToMain.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::CopyToSubTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiPfHiNiHiCmJiBeBiDiKiDjDiDeOiMlDiBeFiDiKiDjDiDeOjAoGiLkEiCmJiKnMiCnMiCoKiCoJiDiKiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmMiCnNiCpAiBeBiDiBiDeDiDjDiDgFiBfLiDhFiDiLiCkJiCoHiDfEiDhFiDgFiBfLiDhFiDiLiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_jFjEjFgJiPfHiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::CopyToSubTable (FCLinkManager* pSubMgr, const FCLinkManager* pMainMgr,
									const ObjDynabaseVector& vObj)
{
	//----- _xZkqqHx_iCnMiClIiBeBiOhHjCoIiCmMjFjEjFgJiPfHiNiHiCmMiDiCiDiKiDhGiPfHiNiHiCpAiNoMjAkM_xHqqkZx_ -----
	FTMolipSet stMolip;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
		stMolip.insert(FCMolipRec((*iObj)->GetObjID(), -1));
	//----- _xZkqqHx_iDiCiDiKiDhGiPfHiNiHjDoAiCmMiDiCiDiKiDhGiKnEiCmMiDiKiDjDiDeOiCpAiOoGjDlO_xHqqkZx_ -----
	DWORDVector vLinkOther;
	DWORDVector vLinkInside;
	pMainMgr->GetAffected(vLinkOther, vLinkOther, vLinkInside, stMolip);
	DWORDVector::const_iterator iLk;
	for (iLk = vLinkInside.begin(); iLk != vLinkInside.end(); iLk++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLinkRec* linkRec = (FCLinkRec*)pMainMgr->m_tblLinkID.IDtoObject(*iLk);
		// _xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCnGiDiKiDjDiDeOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		pSubMgr->AppendLink(*iLk, linkRec->m_mlpFrom, linkRec->m_mlpTo,
								linkRec->m_mmptOffset, linkRec->m_wLinkKind);
	}
} // FCLinkManager::CopyToSubTable.

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::Get1stAngleLinkIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCmMiOhHjCoIiCmMiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmMiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle _xZkqqHx_iCmJiCkIiCkCiCmEiBeBiDiCiDiKiDhG_xHqqkZx_G_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jBmOiClFiCmEiBeBiDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwObjId	:_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClDiCoKiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipId:_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClDiCoKiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecExcept:_xZkqqHx_iMjPiNpFiCkJiCoHiPjMiKePiClHiCoJiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjFnEiClHiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCLinkRec* FCLinkManager::Get1stAngleLinkIn (DWORD dwObjId, long lMolipId,
													const FCLinkRec* pRecExcept) const
{
	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	FCLinkRecPVector vAffected;
	GetAffectedByTo(vAffected, FCMolipRec(dwObjId, lMolipId));
	// _xZkqqHx_iClBiCoKiCoHiCmMiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmFiBeBiKhAjDhIiInLiOjNiMfOiCmMiDiKiDjDiDeOiCkKiCkAiCoKiCmOiBeBjFnEiClHiBeC_xHqqkZx_
	FCLinkRecPVector::const_iterator iLr;
	for (iLr = vAffected.begin(); iLr != vAffected.end(); iLr++)
	{
		if (((*iLr)->m_wLinkKind & 0x0f) == FDLM_LINK_ON_ANGLE_X ||
			((*iLr)->m_wLinkKind & 0xf0) == FDLM_LINK_ON_ANGLE_Y)
		{
			if (*iLr != pRecExcept) return *iLr;
		}
	}
	return NULL;
} // FCLinkManager::Get1stAngleLinkIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLinkRec* FCLinkManager::GetLinkRec (DWORD dwLinkID)
{
	return (FCLinkRec*)m_tblLinkID.IDtoObject(dwLinkID);
} // FCLinkManager::GetLinkRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::AppendLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mlpFrom		:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mlpTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind	:_xZkqqHx_iDiKiDjDiDeOiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDiKiDjDiDeOiCkKjCkDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLinkManager::AppendLink (const FCMolipRec& mlpFrom,
								const FCMolipRec& mlpTo,
								WORD wLinkKind)
{
	// _xZkqqHx_iDiKiDjDiDeOjFhDiJmCjEfMiCmIiCoHiCmOiBeBjFjMiLeBiBeC_xHqqkZx_
	if (!IsLinkable(mlpFrom, mlpTo)) return DWORD(-1);
	// _xZkqqHx_iDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
	FCLinkRec* pLink = new FCLinkRec(mlpFrom, mlpTo, DBLPoint(0,0), wLinkKind);
	// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
	pLink->ApplyNewOffset();
	// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
	DWORD dwLinkID = m_tblLinkID.Register(pLink);
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
	m_mmapFrom2Link.insert(FTMolipLinkPair(mlpFrom, dwLinkID));
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
	m_mmapTo2Link.insert(FTMolipLinkPair(mlpTo, dwLinkID));
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCmMiJgFiLlPiCpAjBlMiCmMiDiKiDjDiDeOiCnGjCmKjCgNiBeC_xHqqkZx_
	AddedDeletedNotify(*pLink);
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return dwLinkID;
} // FCLinkManager::AppendLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::AppendLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObjFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObjTo		:_xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipTo	:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind	:_xZkqqHx_iDiKiDjDiDeOiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDiKiDjDiDeOiCkKjCkDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLinkManager::AppendLink (const FCObjDynabase* pObjFrom, long lMolipFrom,
								const FCObjDynabase* pObjTo, long lMolipTo,
								WORD wLinkKind)
{
	return AppendLink(	FCMolipRec(pObjFrom->GetObjID(), lMolipFrom),
						FCMolipRec(pObjTo->GetObjID(), lMolipTo), wLinkKind);
} // FCLinkManager::AppendLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::AppendLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAiOhHjCoIiClFiClNiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iBeBiDeJiDhEiDfKiDgCiDgHjCgMiCmFiLkNjAkHjDeJiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiCkIjEeDiClJiCmMiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mlpFrom		:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mlpTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptOffset	:_xZkqqHx_iDiKiDjDiDeOiNmAjFfHiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind	:mmptOffset_xZkqqHx_iCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDiKiDjDiDeOiCkKjCkDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			06.10.13 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void FCLinkManager::AppendLink (DWORD dwLinkID,
//								const FCMolipRec& mlpFrom,
//								const FCMolipRec& mlpTo,
//								const DBLPoint& mmptOffset,
//								WORD wLinkKind)
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
DWORD FCLinkManager::AppendLink (DWORD dwLinkID,
								const FCMolipRec& mlpFrom,
								const FCMolipRec& mlpTo,
								const DBLPoint& mmptOffset,
								WORD wLinkKind)
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
{
	// _xZkqqHx_iDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
	FCLinkRec* pLink = new FCLinkRec(mlpFrom, mlpTo, mmptOffset, wLinkKind);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnG_xHqqkZx_ID_xZkqqHx_iOhHjCoIiCmFjDgPjIfOiBeC_xHqqkZx_
//	m_tblLinkID.Register(pLink, dwLinkID);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnG_xHqqkZx_ID_xZkqqHx_iOhHjCoIiCmFjDgPjIfOiBeC_xHqqkZx_
	if (dwLinkID == DWORD(-1))
		dwLinkID = m_tblLinkID.Register(pLink);
	else
		m_tblLinkID.Register(pLink, dwLinkID);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
	m_mmapFrom2Link.insert(FTMolipLinkPair(mlpFrom, dwLinkID));
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
	m_mmapTo2Link.insert(FTMolipLinkPair(mlpTo, dwLinkID));
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCmMiJgFiLlPiCpAjBlMiCmMiDiKiDjDiDeOiCnGjCmKjCgNiBeC_xHqqkZx_
	AddedDeletedNotify(*pLink);
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.10.13 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	return dwLinkID;
} // FCLinkManager::AppendLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::DeleteLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iNoNiPjMiClHiCoJiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::DeleteLink (DWORD dwLinkID)
{
	// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	FCLinkRec* linkRec = GetLinkRec(dwLinkID);
	FTMolipLinkMmap::iterator iPt;
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
	for (iPt = m_mmapFrom2Link.find(linkRec->m_mlpFrom);
		 iPt != m_mmapFrom2Link.end(); iPt++)
		if ((*iPt).second == dwLinkID) break;
	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	m_mmapFrom2Link.erase(iPt);
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
	for (iPt = m_mmapTo2Link.find(linkRec->m_mlpTo);
		 iPt != m_mmapTo2Link.end(); iPt++)
		if ((*iPt).second == dwLinkID) break;
	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	m_mmapTo2Link.erase(iPt);
	// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjDgPjIfOjGjFiPmBiBeC_xHqqkZx_
	m_tblLinkID.Unregister(dwLinkID);
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCmHiJmBiBeFiNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCmMiJgFiLlPiCpAjBlMiCmMiDiKiDjDiDeOiCnGjCmKjCgNiBeC_xHqqkZx_
	AddedDeletedNotify(*linkRec);
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
	delete linkRec;
} // FCLinkManager::DeleteLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::MovedNotifySub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCkKiInKjDkOiClFiClNiOjOiCmJiBeBiClLiCmMiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mlp	:_xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiInKjDkOiCmJiCoGiCmBiCmEiBeBiClDiCoHiCmJiClLiCmMiDiKiDjDiDeOjAoGiCoAiJgFiLlPiCpAiOpDiCkPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPiIjHjNiCpAiBeBiClBiCmMiKnGjAjEiCmNiNmEiLeBjDeJiCmJiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::MovedNotifySub (const FCMolipRec& mlp)
{
	// _xZkqqHx_iDiKiDjDiDeOiMlDiInKjDkOiCmMiJgFiLlPiCpAiOpDiCkPiCoJiDiKiDjDiDeOiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	FCLinkRecPVector vAffected;
	GetAffectedByFrom(vAffected, mlp);
	FCLinkRecPVector::iterator iLt;
	for (iLt = vAffected.begin(); iLt != vAffected.end(); iLt++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiInKjDkOiCmJjElKiCkEiDiKiDjDiDeOjAoGiCmMiInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptMove = (*iLt)->CalcNewMoving();

		if (!almost0(mmptMove.x) || !almost0(mmptMove.y))
		//----- _xZkqqHx_jAiFjFlNiBeBiIlNiCkCiCmNjAiCjClMjFpLiMpMiCmJiInKjDkOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			FCObjDynabase* pObjTo = g_pDoc->ObjID2Object((*iLt)->m_mlpTo.dwObjID);
			// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCkKiKpJiCmJiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjDgPjIfOiClDiCoKiCmEiClNiCoHiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCmMiPiIjHjNiCmFiCmNiBeBiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJiOkJjDkOjDeJiCmJjDgPjIfOiClDiCoKiCoJiInHiBeBiInKjDkOiLjHjHkDiCmM_xHqqkZx_
			// _xZkqqHx_iDgAiDeGiDgCiDeOiCpAjFeLiClIjAoGiCmJiNhDiCkEiClBiCmGiBeC_xHqqkZx_
			BOOL bMovedHorz = FALSE;
			BOOL bMovedVert = FALSE;
			if (!almost0(mmptMove.x))
				bMovedHorz = IsAlreadyMovedHorz((*iLt)->m_mlpTo);
			if (!almost0(mmptMove.y))
				bMovedVert = IsAlreadyMovedVert((*iLt)->m_mlpTo);
			if (!bMovedHorz && !bMovedVert)
			{
				// _xZkqqHx_iInKjDkOjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendToLastRgn(pObjTo);
				// _xZkqqHx_iDiKiDjDiDeOjAoGiCpAiInKjDkOiBeCiDiCiDiKiDhG_xHqqkZx_-1_xZkqqHx_iCmNiDfCiDhNiDjDiDgIiCkKiOkJjDkOjDeJiCmJjFjEjFgJiInKjDkOiCmJjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
				g_pDoc->CmdMove1Molip(pObjTo, (*iLt)->m_mlpTo.lMolipId, mmptMove);
				// _xZkqqHx_iInKjDkOiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendToLastRgn(pObjTo);
				// _xZkqqHx_jFjEjFgJiInKjDkOiCmJjElKiCkEiDiKiDjDiDeOjAoGjFjEjFgJiCmMiNmEiLeBjDeJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
				MovedNotifySub((*iLt)->m_mlpTo);
			}
		}
	}
} // FCLinkManager::MovedNotifySub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::IsAlreadyMovedHorz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKiKpJiCmJiInKjDkOiNmPiCnNiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mlp	:_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDiCiDiKiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjGoCiCkCiNiHiCoNiClJiCmEiBeBiKpJiCmJjDgPjIfOiNmPiCnNiCmMiPoKiNiHiCmNiInKjDkOiNmPiCnNiCmG_xHqqkZx_
 *			_xZkqqHx_iCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjCiNiInDiCkKjFeLjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClG_xHqqkZx_ -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCkKjDgPjIfOiNmPiCnNiCmMiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGjFjEjFgJiCmFiBeB_xHqqkZx_-1 _xZkqqHx_iImIiKePiCmMiDiCiDiKiDhGiCkKiCfAiCmCiImIiPoDjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCoHiCpAjBfDiCmEiOoGiCoIiPjMiCkLiBeB_xHqqkZx_ -1 _xZkqqHx_iCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLhEiCmJiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJ_xHqqkZx_ -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCkKjHeMiCoJiPoKiNiHiCmNiBeBiCmHiCmMiDiCiDiKiDhG_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiPmGiJoPiClDiCoKiCmEiCoAiInKjDkOiNmPiCnNiCmGiCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLinkManager::IsAlreadyMovedHorz (const FCMolipRec& mlp)
{
	// _xZkqqHx_jDkPiClGiDiCiDiKiDhGiCkKiKpJiCmJiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjDgPjIfOiClDiCoKiCmEiClNiCoHiBeBiInKjDkOiNmPiCnNiCpAjFnEiClHiBeC_xHqqkZx_
	if (m_stMovedHorz.find(mlp) != m_stMovedHorz.end()) return TRUE;

	if (mlp.lMolipId == -1)
	//----- _xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKjIeBjBlBiClHiCoJiDiKiDfIiDgHiCmMiNmFiPiJiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
		FTMolipSet::iterator iPs = m_stMovedHorz.lower_bound(mlp);
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
		if (iPs == m_stMovedHorz.end() || (*iPs).dwObjID != mlp.dwObjID)
		{
			// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			m_stMovedHorz.insert(mlp);
			// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
			return FALSE;
		}
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOjNiCmCiInKjDkOiNmPiCnNiDiCiDiKiDhGiCmMjDgPjIfOiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
		for (;;)
		{
			// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
			iPs = m_stMovedHorz.erase(iPs);
			// _xZkqqHx_jGjFiPmBiClFiClNjDgPjIfOiCkKiDiKiDfIiDgHiNmFiMoDiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (iPs == m_stMovedHorz.end()) break;
			// _xZkqqHx_iInJiCmIiCoJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPs).dwObjID != mlp.dwObjID) break;
		}
		// _xZkqqHx_jGjFiPmBiClFiClNjDgPjIfOjBfDiCmEiCmMjBoDiCoNiCoIiCmJiBeB_xHqqkZx_-1_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiCiDiKiDhGiCpAjCmHiJmBiBeC_xHqqkZx_
		m_stMovedHorz.insert(mlp);
		// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
		return FALSE;
	} else
	//----- _xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_ 0 _xZkqqHx_iImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmM_xHqqkZx_-1_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiClNiCoHiBeBiInKjDkOiNmPiCnNiCpAjFnEiClHiBeC_xHqqkZx_
		if (m_stMovedHorz.find(FCMolipRec(mlp.dwObjID, -1)) != m_stMovedHorz.end())
			return TRUE;
		// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		m_stMovedHorz.insert(mlp);
		// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
		return FALSE;
	}
} // FCLinkManager::IsAlreadyMovedHorz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::IsAlreadyMovedVert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKiKpJiCmJiInKjDkOiNmPiCnNiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mlp	:_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDiCiDiKiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjGoCiCkCiNiHiCoNiClJiCmEiBeBiKpJiCmJjDgPjIfOiNmPiCnNiCmMiPoKiNiHiCmNiInKjDkOiNmPiCnNiCmG_xHqqkZx_
 *			_xZkqqHx_iCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjCiNiInDiCkKjFeLjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClG_xHqqkZx_ -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCkKjDgPjIfOiNmPiCnNiCmMiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGjFjEjFgJiCmFiBeB_xHqqkZx_-1 _xZkqqHx_iImIiKePiCmMiDiCiDiKiDhGiCkKiCfAiCmCiImIiPoDjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCoHiCpAjBfDiCmEiOoGiCoIiPjMiCkLiBeB_xHqqkZx_ -1 _xZkqqHx_iCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLhEiCmJiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJ_xHqqkZx_ -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCkKjHeMiCoJiPoKiNiHiCmNiBeBiCmHiCmMiDiCiDiKiDhG_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiPmGiJoPiClDiCoKiCmEiCoAiInKjDkOiNmPiCnNiCmGiCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLinkManager::IsAlreadyMovedVert (const FCMolipRec& mlp)
{
	// _xZkqqHx_jDkPiClGiDiCiDiKiDhGiCkKiKpJiCmJiInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjDgPjIfOiClDiCoKiCmEiClNiCoHiBeBiInKjDkOiNmPiCnNiCpAjFnEiClHiBeC_xHqqkZx_
	if (m_stMovedVert.find(mlp) != m_stMovedVert.end()) return TRUE;

	if (mlp.lMolipId == -1)
	//----- _xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_ -1 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKjIeBjBlBiClHiCoJiDiKiDfIiDgHiCmMiNmFiPiJiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
		FTMolipSet::iterator iPs = m_stMovedVert.lower_bound(mlp);
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
		if (iPs == m_stMovedVert.end() || (*iPs).dwObjID != mlp.dwObjID)
		{
			// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			m_stMovedVert.insert(mlp);
			// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
			return FALSE;
		}
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOjNiCmCiInKjDkOiNmPiCnNiDiCiDiKiDhGiCmMjDgPjIfOiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
		for (;;)
		{
			// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
			iPs = m_stMovedVert.erase(iPs);
			// _xZkqqHx_jGjFiPmBiClFiClNjDgPjIfOiCkKiDiKiDfIiDgHiNmFiMoDiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (iPs == m_stMovedVert.end()) break;
			// _xZkqqHx_iInJiCmIiCoJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
			if ((*iPs).dwObjID != mlp.dwObjID) break;
		}
		// _xZkqqHx_jGjFiPmBiClFiClNjDgPjIfOjBfDiCmEiCmMjBoDiCoNiCoIiCmJiBeB_xHqqkZx_-1_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiCiDiKiDhGiCpAjCmHiJmBiBeC_xHqqkZx_
		m_stMovedVert.insert(mlp);
		// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
		return FALSE;
	} else
	//----- _xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_ 0 _xZkqqHx_iImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmM_xHqqkZx_-1_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiClNiCoHiBeBiInKjDkOiNmPiCnNiCpAjFnEiClHiBeC_xHqqkZx_
		if (m_stMovedVert.find(FCMolipRec(mlp.dwObjID, -1)) != m_stMovedVert.end())
			return TRUE;
		// _xZkqqHx_iInKjDkOiNmPiCnNiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		m_stMovedVert.insert(mlp);
		// _xZkqqHx_iInKjDkOjGkCiClOiCpAjFnEiClHiBeC_xHqqkZx_
		return FALSE;
	}
} // FCLinkManager::IsAlreadyMovedVert.

//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ModifyLinkFromMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDjDiDeOiDiMiDfCiBfLiDgIiCmMiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeOiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
// *			linkRec		:_xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeCjAfGiClFiCkCjCgMiCpAjFnEiClHiBeC_xHqqkZx_
// *			mlpNew		:_xZkqqHx_jAfGiClFiCkCiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCiDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCoAiNfIjAfGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCLinkManager::ModifyLinkFromMolip (DWORD dwLinkID, FCLinkRec& linkRec, FCMolipRec mlpNew)
//{
//	FTMolipLinkMmap::iterator iPt;
//	//----- _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCkJiCoHiMlLiNnNiCmMjDgPjIfOiCpAiNoNiPjM_xHqqkZx_ -----
//	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
//	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
//	for (iPt = m_mmapFrom2Link.find(linkRec.m_mlpFrom);
//		 iPt != m_mmapFrom2Link.end(); iPt++)
//		if ((*iPt).second == dwLinkID) break;
//	ASSERT(iPt != m_mmapFrom2Link.end());
//	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	m_mmapFrom2Link.erase(iPt);
//	// _xZkqqHx_jFmPiNfIjBePiCmMiDiCiDiKiDhGiCpAjFnLjBlGiBeC_xHqqkZx_
//	linkRec.m_mlpFrom = mlpNew;
//	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjAfGiClFiCkNjDgPjIfOiBeC_xHqqkZx_
//	m_mmapFrom2Link.insert(FTMolipLinkPair(linkRec.m_mlpFrom, dwLinkID));
//} // FCLinkManager::ModifyLinkFromMolip.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ModifyLinkToMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDjDiDeOiDiMiDfCiBfLiDgIiCmMiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeOiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
// *			linkRec		:_xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeCjAfGiClFiCkCjCgMiCpAjFnEiClHiBeC_xHqqkZx_
// *			mlpNew		:_xZkqqHx_jAfGiClFiCkCiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCiDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCoAiNfIjAfGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCLinkManager::ModifyLinkToMolip (DWORD dwLinkID, FCLinkRec& linkRec, FCMolipRec mlpNew)
//{
//	FTMolipLinkMmap::iterator iPt;
//	//----- _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCkJiCoHiMlLiNnNiCmMjDgPjIfOiCpAiNoNiPjM_xHqqkZx_ -----
//	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
//	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
//	for (iPt = m_mmapTo2Link.find(linkRec.m_mlpTo);
//		 iPt != m_mmapTo2Link.end(); iPt++)
//		if ((*iPt).second == dwLinkID) break;
//	ASSERT(iPt != m_mmapTo2Link.end());
//	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
//	m_mmapTo2Link.erase(iPt);
//	// _xZkqqHx_jFmPiNfIjBePiCmMiDiCiDiKiDhGiCpAjFnLjBlGiBeC_xHqqkZx_
//	linkRec.m_mlpTo = mlpNew;
//	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjAfGiClFiCkNjDgPjIfOiBeC_xHqqkZx_
//	m_mmapTo2Link.insert(FTMolipLinkPair(linkRec.m_mlpTo, dwLinkID));
//} // FCLinkManager::ModifyLinkToMolip.
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ModifyLinkFromMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDjDiDeOiCmMiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeOiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mlpFromNew	:_xZkqqHx_jAfGiClFiCkCiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCiDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCoAiNfIjAfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ModifyLinkFromMolip (DWORD dwLinkID, FCMolipRec mlpFromNew)
{
	FCLinkRec* pLinkRec = GetLinkRec(dwLinkID);
	//----- _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCkJiCoHiMlLiNnNiCmMjDgPjIfOiCpAiNoNiPjM_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
	FTMolipLinkMmap::iterator iPt;
	for (iPt = m_mmapFrom2Link.find(pLinkRec->m_mlpFrom);
		 iPt != m_mmapFrom2Link.end(); iPt++)
		if ((*iPt).second == dwLinkID) break;
	ASSERT(iPt != m_mmapFrom2Link.end());
	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	m_mmapFrom2Link.erase(iPt);
	// _xZkqqHx_iDiKiDjDiDeOiMlD_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjAfGiClFiCkNjDgPjIfOiBeC_xHqqkZx_
	m_mmapFrom2Link.insert(FTMolipLinkPair(mlpFromNew, dwLinkID));
	// _xZkqqHx_jFmPiNfIjBePiCmMiDiCiDiKiDhGiCpAjFnLjBlGiBeC_xHqqkZx_
	pLinkRec->m_mlpFrom = mlpFromNew;
} // FCLinkManager::ModifyLinkFromMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ModifyLinkToMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDjDiDeOiCmMiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLinkID	:_xZkqqHx_iDiKiDjDiDeOiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mlpToNew	:_xZkqqHx_jAfGiClFiCkCiDiCiDiKiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCiDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCoAiNfIjAfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::ModifyLinkToMolip (DWORD dwLinkID, FCMolipRec mlpToNew)
{
	FCLinkRec* pLinkRec = GetLinkRec(dwLinkID);
	//----- _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCkJiCoHiMlLiNnNiCmMjDgPjIfOiCpAiNoNiPjM_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiClFiBeBiClLiClBiCkJiCoHiMjPiNpFiDiLiBfLiDhGiBeC_xHqqkZx_
	FTMolipLinkMmap::iterator iPt;
	for (iPt = m_mmapTo2Link.find(pLinkRec->m_mlpTo);
		 iPt != m_mmapTo2Link.end(); iPt++)
		if ((*iPt).second == dwLinkID) break;
	ASSERT(iPt != m_mmapTo2Link.end());
	// _xZkqqHx_iMkJiCmCiCkJiCmBiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	m_mmapTo2Link.erase(iPt);
	// _xZkqqHx_iDiKiDjDiDeOjAoG_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjAfGiClFiCkNjDgPjIfOiBeC_xHqqkZx_
	m_mmapTo2Link.insert(FTMolipLinkPair(mlpToNew, dwLinkID));
	// _xZkqqHx_jFmPiNfIjBePiCmMiDiCiDiKiDhGiCpAjFnLjBlGiBeC_xHqqkZx_
	pLinkRec->m_mlpTo = mlpToNew;
} // FCLinkManager::ModifyLinkToMolip.
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::FindLinkByFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCpAiDiKiDjDiDeOiMlDiCmJiOjNiCmCiDiKiDjDiDeOiCmMiIoKjHjHiCpA_xHqqkZx_
 *			stAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stLinkId	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgH_xHqqkZx_(ID)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetAffectedByFrom_xZkqqHx_iCmGiIoBiCkCiBeBiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iIoKjChGiClHiCoJiCoAiCmMiCmMiCnNiCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::FindLinkByFrom (DWORDSet& stLinkId,
									const FCMolipRec& lkptFrom) const
{
	FTMolipLinkMmap::const_iterator iPt;
	// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	for (iPt = m_mmapFrom2Link.find(lkptFrom); iPt != m_mmapFrom2Link.end(); iPt++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
		if ((*iPt).first != lkptFrom) break;
		// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		stLinkId.insert((*iPt).second);
	}
} // FCLinkManager::FindLinkByFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::FindLinkByTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCpAiDiKiDjDiDeOjAoGiCmJiOjNiCmCiDiKiDjDiDeOiCmMiIoKjHjHiCpA_xHqqkZx_
 *			stAffected_xZkqqHx_iCmJ_xHqqkZx_ "_xZkqqHx_jCmHiJmB_xHqqkZx_" _xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stLinkId	:_xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgH_xHqqkZx_(ID)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lkptTo		:_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetAffectedByTo_xZkqqHx_iCmGiIoBiCkCiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkK_xHqqkZx_ -1 _xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iIoKjChGiClHiCoJiCoAiCmMiCmMiCnNiCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLinkManager::FindLinkByTo (	DWORDSet& stLinkId,
									const FCMolipRec& lkptTo) const
{
	FTMolipLinkMmap::const_iterator iPt;
	// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiCmMiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmGiCoAiIoKjChGiClHiCoJiNmFiPiJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	for (iPt = m_mmapTo2Link.find(lkptTo); iPt != m_mmapTo2Link.end(); iPt++)
	{
		// _xZkqqHx_iDiKiDjDiDeOjAoGiCmGiInJiCmIiCoJiDiKiDfIiDgHiImKjChFiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
		if ((*iPt).first != lkptTo) break;
		// _xZkqqHx_iDiKiDjDiDeOiMlDjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		stLinkId.insert((*iPt).second);
	}
} // FCLinkManager::FindLinkByTo.
//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipLine
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGjFjEjFgJiBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjFjEjFgJjBfDiCmEiCmJjBmOiClFiCmEiBeBiDhNiDeFiDfIiCmMiImKjChFiCmJ_xHqqkZx_
// *			_xZkqqHx_iDiCiDiKiDhGiBeFjApMiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptHit		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptMsc		:_xZkqqHx_iDhNiDeFiDfIiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			nFlags		:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			mmptCnv		:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpA_xHqqkZx_LimitMP_xZkqqHx_iCmFjFmPiKlHiClFiClNiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			mmlnAry		:_xZkqqHx_jAkHiMmAjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *			iLnArySz	:mmlnAry_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDPA_HIT_NOT_MOLIP		:_xZkqqHx_iDiCiDiKiDhGiBeFjApMiCmMiCkCiClIiCoKiCmMiPoDiCmJiCoAiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
// *			FDPA_HIT_POINT_MOLIP	:_xZkqqHx_iDiCiDiKiDhGiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
// *			FDPA_HIT_LINE_MOLIP		:_xZkqqHx_jApMiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiDiCiDiKiDhGiPoDiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeCiOjPiCmJjApMiPoDiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jApMiPoDiCmMiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeB_xHqqkZx_ID -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiClNiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			00.01.07 Fukushiro M. ToolArrowTmpl_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
// *************************************************************************/
//FTMolipKind FCLinkManager::GetHitOnMolipLine (	FCObjDynabase*& pHitObj,
//												long& lHitMolip,
//												DBLPoint& mmptHit,
//												const DBLPoint& mmptMsc,
//												UINT nFlags,
//												const DBLPoint& mmptCnv,
//												const DBLLine* mmlnAry,
//												int iLnArySz,
//												const FTMolipSet* stIgnore)
//{
//	const mmetol mmExt = lg2mm(10);
//	DBLPoint mmptNear;
//	long lMolipId;
//	DBLPoint mmptMolip;
//	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCZOrder zOrder;
//	g_pDoc->GetZOrder(zOrder, FDOZ_ON_SELECT, 0, g_pDoc->GetCurrentLayerIdx());
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiMoDiCoLiCmJiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCpAjFmAiCnHiCoJiBeC_xHqqkZx_
//	zOrder.PushBack(&g_pView->SelectObjVector());
//	FCZOrderReverseIterator iObj;
//	// _xZkqqHx_jBeJjBpAjCiGjFjEjFgJiBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmMiPiHiCmJiBeBiMoDiCoLiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
//	for (zOrder.Rbegin(iObj); !iObj.IsEnd(); iObj++)
//	{
//		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (stIgnore != NULL &&
//			stIgnore->find(FCMolipRec((*iObj)->GetObjID(), -1)) != stIgnore->end())
//			continue;
//		// _xZkqqHx_jFjEjFgJiCmMiBgJiKgHjCkDiBgKiKePjFjEiDhEiDiMiBfLiDiAiCmMjDoAjBkEiCmJiDhNiDeFiDfIiCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!(*iObj)->IsPtInOuterFrame(mmptMsc, mmExt)) continue;
//		// _xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCmMjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//		long lMolipCount = (*iObj)->GetMolipCount();
//		if ((*iObj)->IsKindOf(FDOJ_POLY))
//		//----- _xZkqqHx_iDhMiDiKiDfDiDjDjFjEjFgJiMgOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhMiDiKiDfDiDjDiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiKnEiCmMiDiCiDiKiDhGiCmNiPjMiCkNiBeC_xHqqkZx_
//			if (((FCObjPoly*)*iObj)->GetIsOpenPolyJoint()) lMolipCount--;
//		}
//
//		//----- _xZkqqHx_iMjPiNpFiKeKiOgOiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiMhGiOfKiBeCiDgAiDgCiDhGjFjEjFgJiCmMiPoKiNiHiCpAiNgMjHlG_xHqqkZx_ -----
//		long lMolipStart = -1;
//		// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiKiOiCmCiBeBiDiCiDiKiDhGjAjEiCkK_xHqqkZx_1_xZkqqHx_iImIiPoDiCmMiPoKiNiHiBeBjCiGjAfDjDfPiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
//		if ((*iObj)->IsKindOf(FDOJ_CHIP_MASTER) &&
//			(*iObj)->GetMolipCount() != 0)
//			lMolipStart = 0;
//
//		// _xZkqqHx_iKgFiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDhNiDeFiDfIiCkKiDiCiDiKiDhGiPoDiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDiCiDiKiDhGiCpAiPiHjFpLiMpMiCmJiDiLiBfLiDhGiClHiCoJiCmMiCmNiBeBiNmFiPiJiCmJjCiGjAfDjDfPiDiCiDiKiDhG_xHqqkZx_(-1)_xZkqqHx_iCpAjClCiCnHiCoJiClNiCnPiBeC_xHqqkZx_
//		// _xZkqqHx_iDiCiDiKiDhGiCpAiPiHjFpLiMpMiCmJiDiLiBfLiDhGiClHiCoJiCmMiCmNiBeBiOgOjDfPiBeFiPeJjDfPiKnEiDiCiDiKiDhGiCpAiNmFiMoDiCmJjClCiCnHiCoJiInHiBeC_xHqqkZx_
//		for (lMolipId = lMolipStart; lMolipId < lMolipCount; lMolipId++)
//		{
//			// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (stIgnore != NULL &&
//				stIgnore->find(FCMolipRec((*iObj)->GetObjID(), lMolipId)) != stIgnore->end())
//				continue;
//			// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//			(*iObj)->GetMolipPos(mmptMolip, lMolipId);
//			if ((mmptMolip.x - mmExt < mmptMsc.x && mmptMsc.x < mmptMolip.x + mmExt) &&
//				(mmptMolip.y - mmExt < mmptMsc.y && mmptMsc.y < mmptMolip.y + mmExt))
//			{
//				pHitObj = *iObj;
//				lHitMolip = lMolipId;
//				mmptHit = mmptMolip;
//				//----- _xZkqqHx_iDiCiDiKiDhGiPoDiCmJiCkAiCoJiClBiCmGiCpAjFnEiClH_xHqqkZx_ -----
//				if ((*iObj)->IsLineMolip(lMolipId))
//				//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiBeBiIlNiCkCiCmNiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//					// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//					if (!(*iObj)->IsKindOf(FDOJ_FIGURE) || (*iObj)->IsClosePolygon())
//						return FDPA_HIT_POL_MOLIP;
//				}
//				return FDPA_HIT_POINT_MOLIP;	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			}
//		}
//		// _xZkqqHx_iKgFiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDhNiDeFiDfIiCkKiDiJiDeDiDjDiDiCiDiKiDhGiPoDiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDiCiDiKiDhGiCpAiPiHjFpLiMpMiCmJiDiLiBfLiDhGiClHiCoJiCmMiCmNiBeBiNmFiPiJiCmJjCiGjAfDjDfPiDiCiDiKiDhG_xHqqkZx_(-1)_xZkqqHx_iCpAjClCiCnHiCoJiClNiCnPiBeC_xHqqkZx_
//		for (lMolipId = lMolipStart; lMolipId < lMolipCount; lMolipId++)
//		{
//			// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (stIgnore != NULL &&
//				stIgnore->find(FCMolipRec((*iObj)->GetObjID(), lMolipId)) != stIgnore->end())
//				continue;
//			// _xZkqqHx_iDiJiDeDiDjDiDiCiDiKiDhGiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//			if ((*iObj)->IsLineMolip(lMolipId) &&
//				(*iObj)->NearIntersect(mmptNear, lMolipId, mmptMsc, nFlags,
//										 mmptCnv, mmlnAry, iLnArySz))
//			{
//				pHitObj = *iObj;
//				lHitMolip = lMolipId;
//				mmptHit = mmptNear;
//				// _xZkqqHx_jApMiPoDiCmJiCkAiCoJiClBiCmGiCpAjFnEiClHiBeC_xHqqkZx_
//				return FDPA_HIT_LINE_MOLIP;
//			}
//		}
//	}
//	// _xZkqqHx_iDiCiDiKiDhGiBeFjApMiCmMiCkCiClIiCoKiCmMiPoDiCmJiCoAiCmIiCkCiClBiCmGiCpAjFnEiClHiBeC_xHqqkZx_
//	return FDPA_HIT_NOT_MOLIP;
//} // FCLinkManager::GetHitOnMolipLine.
//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGjFjEjFgJiBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjFjEjFgJjBfDiCmEiCmJjBmOiClFiCmEiBeBiDhNiDeFiDfIiCmMiImKjChFiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhGiBeFjApMiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHit		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_iDhNiDeFiDfIiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			nFlags		:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptCnv		:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpA_xHqqkZx_LimitMP_xZkqqHx_iCmFjFmPiKlHiClFiClNiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmlnAry		:_xZkqqHx_jAkHiMmAjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iLnArySz	:mmlnAry_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDPA_HIT_NOT_MOLIP		:_xZkqqHx_iDiCiDiKiDhGiBeFjApMiCmMiCkCiClIiCoKiCmMiPoDiCmJiCoAiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_POINT_MOLIP	:_xZkqqHx_iDiCiDiKiDhGiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_LINE_MOLIP		:_xZkqqHx_jApMiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiDiCiDiKiDhGiPoDiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeCiOjPiCmJjApMiPoDiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jApMiPoDiCmMiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeB_xHqqkZx_ID -1 _xZkqqHx_iCmMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiClNiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.01.07 Fukushiro M. ToolArrowTmpl_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolipLine (	FCObjDynabase*& pHitObj,
												long& lHitMolip,
												DBLPoint& mmptHit,
												const DBLPoint& mmptMsc,
												UINT nFlags,
												const DBLPoint& mmptCnv,
												const DBLLine* mmlnAry,
												int iLnArySz,
												const FTMolipSet* stIgnore)
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmMjFjEjFgJiCpAiLhEiPiHiCmJiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiDiCiDiKiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	FTMolipKind molipKind = GetHitOnMolipLineSub(	pHitObj,
													lHitMolip,
													mmptHit,
													g_pView->SelectObjVector(),
													mmptMsc,
													nFlags,
													mmptCnv,
													mmlnAry,
													iLnArySz,
													stIgnore);
	// _xZkqqHx_iCkCiClIiCoKiCkJiCmMjFjEjFgJiCmMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (molipKind != FDPA_HIT_NOT_MOLIP)
		return molipKind;

	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	ObjDynabaseVector vObjOrder;
	g_pDoc->GetZOrder(vObjOrder, FDOZ_ON_SELECT, 0, g_pDoc->GetCurrentLayerIdx());
	// _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiLhEiPiHiCmJiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiDiCiDiKiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	molipKind = GetHitOnMolipLineSub(	pHitObj,
										lHitMolip,
										mmptHit,
										vObjOrder,
										mmptMsc,
										nFlags,
										mmptCnv,
										mmlnAry,
										iLnArySz,
										stIgnore);
	// _xZkqqHx_iDhBiDgCiDgHiPpDiLlFiCpAjFnEiClHiBeC_xHqqkZx_
	return molipKind;
} // FCLinkManager::GetHitOnMolipLine.
//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------

//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetMolipPos
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCmMiOhHjCoIiCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiImKjChFiCpAiOoGjDlOiClHiCoJiKnGjAjEiBeC_xHqqkZx_
// *			FCLinkManager::GetHitOnMolip _xZkqqHx_iKnGjAjEiCmM_xHqqkZx_funcGetMolipPos _xZkqqHx_iCmM_xHqqkZx_
// *			_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiKnGjAjEiBeC_xHqqkZx_
// *			 FCObjDynabase::GetMolipPos _xZkqqHx_iCpAiOgHiCmBiCmEiDiCiDiKiDhGiImKjChFiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt		:_xZkqqHx_iDiCiDiKiDhGiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *			dwData		:_xZkqqHx_iClBiCmMiKnGjAjEjHhAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pObj		:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTerminalIdx:_xZkqqHx_iDiCiDiKiDhGiCmMiDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static BOOL myGetMolipPos (	DBLPoint& mmpt, DWORD dwData, const FCObjDynabase* pObj,
//							long lMolipId, long lTerminalIdx)
//{
//	if (lTerminalIdx != 0) return FALSE;
//	pObj->GetMolipPos(mmpt, lMolipId, 0);
//	return TRUE;
//} // myGetMolipPos.
//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------</NOT EXPORT TO VIEWER>-----------

//----- 05.06.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptHitPos	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptMsc		:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *			bCheckLostMolip		:_xZkqqHx_iKeKiCkCiClNiDhMiDiKiDfDiDjDiCmMiPoKiNiHiCmJiBeBiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmMiKnEiCmM_xHqqkZx_
// *						 _xZkqqHx_iDiCiDiKiDhGiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bCheckCenterMolip	:_xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiImIiKePiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmJiBeBjCiGjAfDjDfPiDiCiDiKiDhGiCoA_xHqqkZx_
// *						 _xZkqqHx_iDfEiBfLiDgAiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lgMinLen	:_xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmGiNmAjFfHiCmMiLjHjHkDiCkKiBeBiClBiCmMjCgMiImIiJlKiCmIiCoHiCmO_xHqqkZx_
// *						 _xZkqqHx_iClLiCoKiImIiNhOiCmMiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
// *			lgMaxLen	:_xZkqqHx_iDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGiCnNiCmIiClDiCoKiCoJiBeBiDiCiDiKiDhGiCmGiNmAjFfHiCmMiLjHjHkDiCmM_xHqqkZx_
// *						 _xZkqqHx_iNmFjCoBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pZOrder		:_xZkqqHx_jClCiCnHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjBeJjBpAiJmCjEfMiCmI_xHqqkZx_
// *						 _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAjClCiCnHiCoJiBeCiClBiCmMiPoKiNiHiBeBjBeJjBpAjCiGjFjEjFgJiCkKjHeEjAoGiClFiCmE_xHqqkZx_
// *						 _xZkqqHx_jClCiCnHiCoHiCoKiCoJiBeC_xHqqkZx_
// *			funcGetMolipPos	:_xZkqqHx_iDiCiDiKiDhGiImKjChFiCpAiOoGjDlOiClHiCoJiKnGjAjEiBeC_xHqqkZx_NULL _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeB_xHqqkZx_
// *						 FCObjDynabase::GetMolipPos _xZkqqHx_iCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
// *			dwData		:funcGetMolipPos _xZkqqHx_iCmMiIpIjAjEiCmJjHfOiCkGiCoHiCoKiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bMustLinkIn	:_xZkqqHx_iDiKiDjDiDeOiDeDiDjDiJmCjEfMiCkKjFeLjAhLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bMustLinkOut:_xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiJmCjEfMiCkKjFeLjAhLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmHiClBiCmJiDhBiDgCiDgHiClFiClNiCkJjFnEiClHiBeCjEhHiMgJiBeBjDfPiDiCiDiKiDhGiBeBjCiGjAfDjDfPiDiCiDiKiDhGjDjJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiNmFiCoAiLnPiCkCiDiCiDiKiDhGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_bCheckCenterMolip = FALSE
// *			_xZkqqHx_iCmFiCoAiBeBjCiGjAfDjDfPiDiCiDiKiDhGiImIiKePiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNjCiGjAfDjDfPiDiCiDiKiDhGiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTMolipKind FCLinkManager::GetHitOnMolip (	FCObjDynabase*& pHitObj,
//											long& lHitMolip,
//											DBLPoint& mmptHitPos,
//											const DBLPoint& mmptMsc,
//											const FTMolipSet* stIgnore,
//											BOOL bCheckLostMolip,
//											BOOL bCheckCenterMolip,
//											long lgMinLen,
//											long lgMaxLen,
//											const FCZOrder* pZOrder,
//											FuncGetMolipPos funcGetMolipPos,
//											DWORD dwData,
//											BOOL bMustLinkIn,
//											BOOL bMustLinkOut)
//{
//	// pZOrder == NULL _xZkqqHx_jHhAiBeC_xHqqkZx_
//	FCZOrder zOrderLocal;
//	if (pZOrder == NULL)
//	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiMfBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//		g_pDoc->GetZOrder(zOrderLocal, FDOZ_ON_SELECT, 0, g_pDoc->GetCurrentLayerIdx());
//		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiMoDiCoLiCmJiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCpAjFmAiCnHiCoJiBeC_xHqqkZx_
//		zOrderLocal.PushBack(&g_pView->SelectObjVector());
//		pZOrder = &zOrderLocal;
//	}
//	if (funcGetMolipPos == NULL)
//	//----- _xZkqqHx_iDiCiDiKiDhGiImKjChFiOoGjDlOiKnGjAjEiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		funcGetMolipPos = myGetMolipPos;
//	}
//	FTMolipKind iHitOn = FDPA_HIT_NOT_MOLIP;
//	//----- _xZkqqHx_iMjPiNpFiMiLiJmKiCpAiPiJiKpKiJlL_xHqqkZx_ -----
//	pHitObj = NULL;
//	lHitMolip = -1;
//
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiCiDiKiDhGiCmGiCmMiLjHjHkDiCkKiClBiCmMjCgMiImIiJlKiCmIiCoHiCmOiBeBjBlMiCmMjFjEjFgJiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//	const mmpwThreshold = lg2mm(lgMinLen) * lg2mm(lgMinLen);
//	// _xZkqqHx_jFjEjFgJiCmMiKePiOpMiCmGiCmMiLjHjHkDiCkK_xHqqkZx_lgMaxLen pixel_xZkqqHx_iImIiPoDiCmIiCoHiCmOiBeBiClLiCmMjFjEjFgJiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//	const mmetol mmExt = lg2mm(lgMaxLen);
//	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_-_xZkqqHx_iDhNiDeFiDfIiKnEiLjHjHkDiCmMiCfBiPoGiNmFiPkMjCgMiBeCiNmFjCoBiCmFiCoA_xHqqkZx_mmExt^2_xZkqqHx_iCkKjFeLjHhGiBeC_xHqqkZx_
//	double mmpwLenMin = mmExt * mmExt;
//
//	FCZOrderReverseIterator iObj;
//	// _xZkqqHx_jBeJjBpAjCiGjFjEjFgJiBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmMiPiHiCmJiBeBiMoDiCoLiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
//	for (pZOrder->Rbegin(iObj); !iObj.IsEnd(); iObj++)
//	{
//		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (stIgnore != NULL &&
//			stIgnore->find(FCMolipRec((*iObj)->GetObjID(), -1)) != stIgnore->end())
//			continue;
//		// _xZkqqHx_iOhHjCoIiCmMiLjHjHkDiImIjDoAiCmJjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!(*iObj)->IsPtInOuterFrame(mmptMsc, mmExt)) continue;
//		// _xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCmMjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//		long lMolipCount = (*iObj)->GetMolipCount();
//		if ((*iObj)->IsKindOf(FDOJ_POLY))
//		//----- _xZkqqHx_iDhMiDiKiDfDiDjDjFjEjFgJiMgOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhMiDiKiDfDiDjDiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiKnEiCmMiDiCiDiKiDhGiCmNiPjMiCkNiBeC_xHqqkZx_
//			if (!bCheckLostMolip && ((FCObjPoly*)*iObj)->GetIsOpenPolyJoint())
//				lMolipCount--;
//		}
//		// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDhNiDeFiDfIiCmGjDfPiDiCiDiKiDhGiCmMiLjHjHkDiCpAjClCiCnHiBeBiNmFjCfKiCmMiDiCiDiKiDhGiCpAjBeJiCnEiBeC_xHqqkZx_
//		for (long lMolipId = lMolipCount - 1; -1 <= lMolipId; lMolipId--)
//		{
//			// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (stIgnore != NULL &&
//				stIgnore->find(FCMolipRec((*iObj)->GetObjID(), lMolipId)) != stIgnore->end())
//				continue;
//			//----- _xZkqqHx_iCfAiDiCiDiKiDhGiCmJiKnGiClFiCmEjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiCpAjClCiNlI_xHqqkZx_ -----
//			for (long lTerminalIdx = 0;
//				 lTerminalIdx < (*iObj)->GetMolipTerminalCount(lMolipId);
//				 lTerminalIdx++)
//			{
//				// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeCiOoGjDlOiOlIjEhDiCmMiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
//				DBLPoint mmptMolip;
//				if (!(*funcGetMolipPos)(mmptMolip, dwData, *iObj, lMolipId, lTerminalIdx))
//					break;
//				double mmpwLen = (mmptMolip - mmptMsc).PowLen();
//				if (mmpwLen < mmpwLenMin)
//				{
//					BOOL bTest_0 = TRUE;
//					BOOL bTest_1 = TRUE;
//					if (bMustLinkIn)
//						bTest_0 = (*iObj)->IsLinkable(lMolipId, FALSE);
//					if (bMustLinkOut)
//						bTest_1 = (*iObj)->IsLinkable(lMolipId, TRUE);
//					if (bTest_0 && bTest_1)
//					{
//						mmpwLenMin = mmpwLen;
//						iHitOn = FDPA_HIT_POINT_MOLIP;
//						pHitObj = *iObj;
//						lHitMolip = lMolipId;
//						mmptHitPos = mmptMolip;
//					}
//				}
//			}
//		}
//		if (mmpwLenMin <= mmpwThreshold) break;
//	}
//	return iHitOn;
//} // FCLinkManager::GetHitOnMolip.
//----- 05.06.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptHitPos	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptMsc		:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *			lgMinLen	:_xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmGiNmAjFfHiCmMiLjHjHkDiCkKiBeBiClBiCmMjCgMiImIiJlKiCmIiCoHiCmO_xHqqkZx_
// *						 _xZkqqHx_iClLiCoKiImIiNhOiCmMiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
// *			lgMaxLen	:_xZkqqHx_iDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGiCnNiCmIiClDiCoKiCoJiBeBiDiCiDiKiDhGiCmGiNmAjFfHiCmMiLjHjHkDiCmM_xHqqkZx_
// *						 _xZkqqHx_iNmFjCoBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bIsSearchMultiTerminal
// *						:_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiImIiKePiCoAjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmHiClBiCmJiDhBiDgCiDgHiClFiClNiCkJjFnEiClHiBeCjEhHiMgJiBeBjDfPiDiCiDiKiDhGiBeBjCiGjAfDjDfPiDiCiDiKiDhGjDjJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiNmFiCoAiLnPiCkCiDiCiDiKiDhGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			05.06.07 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
// *************************************************************************/
//FTMolipKind FCLinkManager::GetHitOnMolip (	FCObjDynabase*& pHitObj,
//											long& lHitMolip,
//											DBLPoint& mmptHitPos,
//											const DBLPoint& mmptMsc,
//											const FTMolipSet* stIgnore,
//											long lgMinLen,
//											long lgMaxLen,
//											BOOL bIsSearchMultiTerminal)
//{
//	FCZOrder zOrder;
//	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//	g_pDoc->GetZOrder(zOrder, FDOZ_ON_SELECT, 0, g_pDoc->GetCurrentLayerIdx());
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiMoDiCoLiCmJiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCpAjFmAiCnHiCoJiBeC_xHqqkZx_
//	zOrder.PushBack(&g_pView->SelectObjVector());
//
//	FTMolipKind iHitOn = FDPA_HIT_NOT_MOLIP;
//	//----- _xZkqqHx_iMjPiNpFiMiLiJmKiCpAiPiJiKpKiJlL_xHqqkZx_ -----
//	pHitObj = NULL;
//	lHitMolip = -1;
//
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiCiDiKiDhGiCmGiCmMiLjHjHkDiCkKiClBiCmMjCgMiImIiJlKiCmIiCoHiCmOiBeBjBlMiCmMjFjEjFgJiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//	const double mmpwThreshold = lg2mm(lgMinLen) * lg2mm(lgMinLen);
//	// _xZkqqHx_jFjEjFgJiCmMiKePiOpMiCmGiCmMiLjHjHkDiCkK_xHqqkZx_lgMaxLen pixel_xZkqqHx_iImIiPoDiCmIiCoHiCmOiBeBiClLiCmMjFjEjFgJiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//	const mmetol mmExt = lg2mm(lgMaxLen);
//	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_-_xZkqqHx_iDhNiDeFiDfIiKnEiLjHjHkDiCmMiCfBiPoGiNmFiPkMjCgMiBeCiNmFjCoBiCmFiCoA_xHqqkZx_mmExt^2_xZkqqHx_iCkKjFeLjHhGiBeC_xHqqkZx_
//	double mmpwLenMin = mmExt * mmExt;
//
//	FCZOrderReverseIterator iObj;
//	// _xZkqqHx_jBeJjBpAjCiGjFjEjFgJiBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmMiPiHiCmJiBeBiMoDiCoLiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
//	for (zOrder.Rbegin(iObj); !iObj.IsEnd(); iObj++)
//	{
//		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (stIgnore != NULL &&
//			stIgnore->find(FCMolipRec((*iObj)->GetObjID(), -1)) != stIgnore->end())
//			continue;
//		// _xZkqqHx_iOhHjCoIiCmMiLjHjHkDiImIjDoAiCmJjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!(*iObj)->IsPtInOuterFrame(mmptMsc, mmExt)) continue;
//		// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDhNiDeFiDfIiCmGjDfPiDiCiDiKiDhGiCmMiLjHjHkDiCpAjClCiCnHiBeBiNmFjCfKiCmMiDiCiDiKiDhGiCpAjBeJiCnEiBeC_xHqqkZx_
//		for (long lMolipId = (*iObj)->GetMolipCount() - 1; lMolipId != -2; lMolipId--)
//		{
//			// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (stIgnore != NULL &&
//				stIgnore->find(FCMolipRec((*iObj)->GetObjID(), lMolipId)) != stIgnore->end())
//				continue;
//			//----- _xZkqqHx_iCfAiDiCiDiKiDhGiCmJiKnGiClFiCmEjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiCpAjClCiNlI_xHqqkZx_ -----
//			for (long lTerminalIdx = 0;
//				 lTerminalIdx != (*iObj)->GetMolipTerminalCount(lMolipId);
//				 lTerminalIdx++)
//			{
//				// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//				DBLPoint mmptMolip = (*iObj)->GetMolipPos(lMolipId, lTerminalIdx);
//				double mmpwLen = (mmptMolip - mmptMsc).PowLen();
//				if (mmpwLen < mmpwLenMin)
//				{
//					mmpwLenMin = mmpwLen;
//					iHitOn = FDPA_HIT_POINT_MOLIP;
//					pHitObj = *iObj;
//					lHitMolip = lMolipId;
//					mmptHitPos = mmptMolip;
//				}
//				// _xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiCmMiCnNjClCiNlIiOhHjCoIiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//				if (!bIsSearchMultiTerminal) break;
//			}
//		}
//		if (mmpwLenMin <= mmpwThreshold) break;
//	}
//	return iHitOn;
//} // FCLinkManager::GetHitOnMolip.
//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHitPos	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			bIsSearchMultiTerminal
 *						:_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiImIiKePiCoAjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmHiClBiCmJiDhBiDgCiDgHiClFiClNiCkJjFnEiClHiBeCjEhHiMgJiBeBjDfPiDiCiDiKiDhGiBeBjCiGjAfDjDfPiDiCiDiKiDhGjDjJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiNmFiCoAiLnPiCkCiDiCiDiKiDhGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.06.16 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolip (	FCObjDynabase*& pHitObj,
											long& lHitMolip,
											DBLPoint& mmptHitPos,
											const DBLPoint& mmptMsc,
											const FTMolipSet* stIgnore,
											BOOL bIsSearchMultiTerminal)
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmMjFjEjFgJiCpAiLhEiPiHiCmJiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiDiCiDiKiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	FTMolipKind molipKind = GetHitOnMolipSub(	pHitObj,
												lHitMolip,
												mmptHitPos,
												g_pView->SelectObjVector(),
												mmptMsc,
												stIgnore,
												bIsSearchMultiTerminal);
	// _xZkqqHx_iCkCiClIiCoKiCkJiCmMjFjEjFgJiCmMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (molipKind != FDPA_HIT_NOT_MOLIP)
		return molipKind;

	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	ObjDynabaseVector vObjOrder;
	g_pDoc->GetZOrder(vObjOrder, FDOZ_ON_SELECT, 0, g_pDoc->GetCurrentLayerIdx());
	// _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiLhEiPiHiCmJiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiDiCiDiKiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	molipKind = GetHitOnMolipSub(	pHitObj,
									lHitMolip,
									mmptHitPos,
									vObjOrder,
									mmptMsc,
									stIgnore,
									bIsSearchMultiTerminal);
	// _xZkqqHx_iDhBiDgCiDgHiPpDiLlFiCpAjFnEiClHiBeC_xHqqkZx_
	return molipKind;
} // FCLinkManager::GetHitOnMolip.
//----- 05.06.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.06.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipDetail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetHitOnMolip_xZkqqHx_iKnGjAjEiCmMiDfEiDhFiKnGjAjEiBeCiDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHitPos	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmPointMolipHitMargin
 *						:_xZkqqHx_jDfPiDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpwPointMolipHitMargin
 *						:_xZkqqHx_jDfPiDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiCmMjDpBiPoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			bIsSearchMultiTerminal
 *						:_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiImIiKePiCoAjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmHiClBiCmJiDhBiDgCiDgHiClFiClNiCkJjFnEiClHiBeCjEhHiMgJiBeBjDfPiDiCiDiKiDhGiBeBjCiGjAfDjDfPiDiCiDiKiDhGjDjJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiNmFiCoAiLnPiCkCiDiCiDiKiDhGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolipDetail (long& lHitMolip,
												DBLPoint& mmptHitPos,
												const FCObjDynabase* pObj,
												const DBLPoint& mmptMsc,
												mmetol mmPointMolipHitMargin,
												double mmpwPointMolipHitMargin,
												const FTMolipSet* stIgnore,
												BOOL bIsSearchMultiTerminal)
{
	// _xZkqqHx_iOhHjCoIiCmMiLjHjHkDiImIjDoAiCmJjGlDiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (!pObj->IsPtInOuterFrame(mmptMsc, mmPointMolipHitMargin))
		return FDPA_HIT_NOT_MOLIP;

	FTMolipKind molipKind = FDPA_HIT_NOT_MOLIP;
	// _xZkqqHx_iDiCiDiKiDhGiCmMiMjPiNpFiKeKiOgO_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long lMolipStart = -1;
	// _xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCmMjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMolipCount = pObj->GetMolipCount();

	if (pObj->IsKindOf(FDOJ_POLY))
	//----- _xZkqqHx_jBlNiKhAjApMjFjEjFgJiMgOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (((FCObjPoly*)pObj)->GetIsOpenPolyJoint())
		//----- _xZkqqHx_jBlNiKhAjApMiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBlNiKhAjApMiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBjCiGiJjLjDfPiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
			lMolipStart = 0;
			// _xZkqqHx_jBlNiKhAjApMiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiKnEiCmMiDiCiDiKiDhGiCmNiPjMiCkNiBeC_xHqqkZx_
			lMolipCount--;
		}
	} else
	if (pObj->IsKindOf(FDOJ_CHIP_MASTER))
	//----- _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiMgOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiKiOiCmCiBeBiDiCiDiKiDhGjAjEiCkK_xHqqkZx_1_xZkqqHx_iImIiPoDiCmMiPoKiNiHiBeBjCiGiJjLjDfPiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
		if (pObj->GetMolipCount() != 0)
			lMolipStart = 0;
	} else
	//----- _xZkqqHx_jBlNiKhAjApMiBeFiDgAiDgCiDhGjFjEjFgJiMgOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (!pObj->IsClosePolygon() && pObj->GetMolipCount() != 0)
		//----- _xZkqqHx_iDhMiDiKiDfDiDjDiCkKiKeKiCkCiCmEiCkCiCmEiBeBiDiCiDiKiDhGjAjEiCkKiCfAiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jClMjApMjFjEjFgJiCmIiCmHiBeC_xHqqkZx_
			// _xZkqqHx_jCiGiJjLjDfPiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
			lMolipStart = 0;
		}
	}
	// _xZkqqHx_iDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiBeC_xHqqkZx_
	double mmpwMinLen = mmpwPointMolipHitMargin;
	// _xZkqqHx_iDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDhNiDeFiDfIiCmGiDiCiDiKiDhGiCmMiLjHjHkDiCpAjClCiCnHiBeBiNmFjCfKiCmMiDiCiDiKiDhGiCpAjBeJiCnEiBeC_xHqqkZx_
	long lMolipId;
	for (lMolipId = lMolipStart; lMolipId != lMolipCount; lMolipId++)
	{
		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (stIgnore != NULL &&
			stIgnore->find(FCMolipRec(pObj->GetObjID(), lMolipId)) != stIgnore->end())
			continue;
		//----- _xZkqqHx_iCfAiDiCiDiKiDhGiCmJiKnGiClFiCmEjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiCpAjClCiNlI_xHqqkZx_ -----
		for (long lTerminalIdx = 0;
			 lTerminalIdx != pObj->GetMolipTerminalCount(lMolipId);
			 lTerminalIdx++)
		{
			// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
			DBLPoint mmptMolip = pObj->GetMolipPos(lMolipId, lTerminalIdx);
			double mmpwLen = (mmptMolip - mmptMsc).PowLen();
			if (mmpwLen < mmpwMinLen)
			{
				mmpwMinLen = mmpwLen;
				molipKind = FDPA_HIT_POINT_MOLIP;
				lHitMolip = lMolipId;
				mmptHitPos = mmptMolip;
			}
			// _xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiCmMiCnNjClCiNlIiOhHjCoIiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (!bIsSearchMultiTerminal) break;
		}
	}
	return molipKind;
} // FCLinkManager::GetHitOnMolipDetail.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::DrawCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClFiClNiNmAjFfHiCmJiOhHjCoIiClFiClNiDeKiBfLiDfMiDiLiMgAiPpDiCpAjFfMiOkGiBgJiPmBiLiOiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgpt	:_xZkqqHx_jFgAiJoGiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iCursor	:_xZkqqHx_jFfMiOkGiClHiCoJiDeKiBfLiDfMiDiLiMgAiPpDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.01.09 Fukushiro M. ToolArrowTmpl.h_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FCLinkManager::DrawCursor (CDC* pDC, const CPoint& lgpt, FTMolipKind iCursor)
{
	TRACE(_T("FCLinkManager::DrawCursor (%d, %d), %d\n"), lgpt.x, lgpt.y, iCursor);
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	const int iSelMarkSz = 2 * FCEditDraw::GetSelMarkSizeHalf();
	switch (iCursor)
	{
	case FDPA_HIT_NOT_MOLIP:	// _xZkqqHx_iDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmIiCkCiBeC_xHqqkZx_
		eDraw.SelMark(lgpt);
		break;
	case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
		eDraw.RectLine(lgpt, iSelMarkSz, iSelMarkSz);
		eDraw.Line(&CPoint(lgpt.x - 2 * iSelMarkSz, lgpt.y),
					&CPoint(lgpt.x + 2 * iSelMarkSz, lgpt.y));
		eDraw.Line(&CPoint(lgpt.x, lgpt.y - 2 * iSelMarkSz),
					&CPoint(lgpt.x, lgpt.y + 2 * iSelMarkSz));
		break;
	  }
	case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
	  {
		eDraw.UnselMark(lgpt);
		eDraw.RectLine(lgpt, iSelMarkSz, iSelMarkSz);
		break;
	  }
	case FDPA_HIT_POL_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
		eDraw.ArcLine(CRect(lgpt.x - iSelMarkSz, lgpt.y - iSelMarkSz,
							lgpt.x + iSelMarkSz, lgpt.y + iSelMarkSz),
					lgpt, lgpt);
		eDraw.ArcLine(CRect(lgpt.x - 2 * iSelMarkSz, lgpt.y - 2 * iSelMarkSz,
							lgpt.x + 2 * iSelMarkSz, lgpt.y + 2 * iSelMarkSz),
					lgpt, lgpt);
		break;
	  }
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	default:	// FDPA_HIT_NONE _xZkqqHx_jGlDiMpIjCgMiBeC_xHqqkZx_
		// _xZkqqHx_jFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
		break;
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // FCLinkManager::DrawCursor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipLineSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetHitOnMolipLine_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiPfHiNiHiCmJjBmOiClFiCmEiBeBiDhNiDeFiDfIiCmMiImKjChFiCmJiDiCiDiKiDhGiBeFjApMiCkK_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHit		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObjOrder	:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMjFjEjFgJiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_iDhNiDeFiDfIiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			nFlags		:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptCnv		:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpA_xHqqkZx_LimitMP_xZkqqHx_iCmFjFmPiKlHiClFiClNiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmlnAry		:_xZkqqHx_jAkHiMmAjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iLnArySz	:mmlnAry_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDPA_HIT_NOT_MOLIP		:_xZkqqHx_iCkCiClIiCoKiCmMiDiCiDiKiDhGiPoDiCmJiCoAiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_POINT_MOLIP	:_xZkqqHx_jDfPiDiCiDiKiDhGiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_LINE_MOLIP		:_xZkqqHx_jApMiDiCiDiKiDhGiCmMjApMiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_POL_MOLIP		:_xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolipLineSub (	FCObjDynabase*& pHitObj,
													long& lHitMolip,
													DBLPoint& mmptHit,
													const ObjDynabaseVector& vObjOrder,
													const DBLPoint& mmptMsc,
													UINT nFlags,
													const DBLPoint& mmptCnv,
													const DBLLine* mmlnAry,
													int iLnArySz,
													const FTMolipSet* stIgnore)
{
	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjApMiCmJiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiLjHjHkDiBeC_xHqqkZx_
	const double mmpwPointMolipHitMargin = POW2(lg2mm(FD_POINT_MOLIP_HIT_MARGIN));
	const mmetol mmLineMolipHitMargin = lg2mm(FD_LINE_MOLIP_HIT_MARGIN);
// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	const double mmpwLineMolipHitMargin = POW2(mmLineMolipHitMargin);
	// _xZkqqHx_jFjEjFgJiCpAiMoDiCoLiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
	ObjDynabaseVector::const_reverse_iterator rObj;
	for (rObj = vObjOrder.rbegin(); rObj != vObjOrder.rend(); rObj++)
	{
		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (stIgnore != NULL &&
			stIgnore->find(FCMolipRec((*rObj)->GetObjID(), -1)) != stIgnore->end())
			continue;
		FTMolipKind molipKind = GetHitOnMolipLineSubSub(lHitMolip,
														mmptHit,
														*rObj,
														mmptMsc,
														nFlags,
														mmpwPointMolipHitMargin,
														mmLineMolipHitMargin,
// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//														mmpwLineMolipHitMargin,
														mmptCnv,
														mmlnAry,
														iLnArySz,
														stIgnore);
		if (molipKind != FDPA_HIT_NOT_MOLIP)
		{
			pHitObj = *rObj;
			return molipKind;
		}
	}
	// _xZkqqHx_iDiCiDiKiDhGiBeFjApMiCmMiCkCiClIiCoKiCmMiPoDiCmJiCoAiCmIiCkCiClBiCmGiCpAjFnEiClHiBeC_xHqqkZx_
	return FDPA_HIT_NOT_MOLIP;
} // FCLinkManager::GetHitOnMolipLineSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipLineSubSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetHitOnMolipLineSub_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCmJjBmOiClFiCmEiBeBiDhNiDeFiDfIiCmMiImKjChFiCmJiDiCiDiKiDhGiBeFjApMiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHit		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_iDhNiDeFiDfIiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			nFlags		:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmpwPointMolipHitMargin
 *						:_xZkqqHx_jDfPiDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiCmMjDpBiPoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLineMolipHitMargin
 *						:_xZkqqHx_jApMiDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// *			mmpwLineMolipHitMargin
// *						:_xZkqqHx_jApMiDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiCmMjDpBiPoGiCpAiOhHjCoIiBeC_xHqqkZx_
//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *			mmptCnv		:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpA_xHqqkZx_LimitMP_xZkqqHx_iCmFjFmPiKlHiClFiClNiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmlnAry		:_xZkqqHx_jAkHiMmAjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iLnArySz	:mmlnAry_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDPA_HIT_NOT_MOLIP		:_xZkqqHx_iCkCiClIiCoKiCmMiDiCiDiKiDhGiPoDiCmJiCoAiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_POINT_MOLIP	:_xZkqqHx_jDfPiDiCiDiKiDhGiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_LINE_MOLIP		:_xZkqqHx_jApMiDiCiDiKiDhGiCmMjApMiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDPA_HIT_POL_MOLIP		:_xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolipLineSubSub (long& lHitMolip,
													DBLPoint& mmptHit,
													const FCObjDynabase* pObj,
													const DBLPoint& mmptMsc,
													UINT nFlags,
													double mmpwPointMolipHitMargin,
													mmetol mmLineMolipHitMargin,
// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//													double mmpwLineMolipHitMargin,
													const DBLPoint& mmptCnv,
													const DBLLine* mmlnAry,
													int iLnArySz,
													const FTMolipSet* stIgnore)
{
	// _xZkqqHx_jFjEjFgJiCmMiBgJiKgHjCkDiBgKiKePjFjEiDhEiDiMiBfLiDiAiCmMjDoAjBkEiCmJiDhNiDeFiDfIiCkKjGlDiCkCiPoKiNiHiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsPtInOuterFrame(mmptMsc, mmLineMolipHitMargin))
		return FDPA_HIT_NOT_MOLIP;
	// _xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiCmMjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMolipCount = pObj->GetMolipCount();
	if (pObj->IsKindOf(FDOJ_POLY))
	//----- _xZkqqHx_iDhMiDiKiDfDiDjDjFjEjFgJiMgOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhMiDiKiDfDiDjDiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiKnEiCmMiDiCiDiKiDhGiCmNiPjMiCkNiBeC_xHqqkZx_
		if (((FCObjPoly*)pObj)->GetIsOpenPolyJoint()) lMolipCount--;
	}

	//----- _xZkqqHx_iMjPiNpFiKeKiOgOiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiMhGiOfKiBeCiDgAiDgCiDhGjFjEjFgJiCmMiPoKiNiHiCpAiNgMjHlG_xHqqkZx_ -----
	long lMolipStart = -1;
	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiKiOiCmCiBeBiDiCiDiKiDhGjAjEiCkK_xHqqkZx_1_xZkqqHx_iImIiPoDiCmMiPoKiNiHiBeBjCiGjAfDjDfPiDiCiDiKiDhGiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
	if (pObj->IsKindOf(FDOJ_CHIP_MASTER) &&
		pObj->GetMolipCount() != 0)
		lMolipStart = 0;

	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmGjDfPiDiCiDiKiDhGiCmJjFkKjHnOiClHiCoJ_xHqqkZx_ ------
	longSet stLineMolip;
	longSet stPointMolip;
	long lMolipId;
	for (lMolipId = lMolipStart; lMolipId != lMolipCount; lMolipId++)
	{
		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (stIgnore != NULL &&
			stIgnore->find(FCMolipRec(pObj->GetObjID(), lMolipId)) != stIgnore->end())
			continue;
		if (pObj->IsLineMolip(lMolipId))
			stLineMolip.insert(lMolipId);
		else
			stPointMolip.insert(lMolipId);
	}

	// _xZkqqHx_iCkCiClIiCoKiCmMiDiCiDiKiDhGiPoDiCmJiCoAiCmIiCkCiBeC_xHqqkZx_
	FTMolipKind molipKind = FDPA_HIT_NOT_MOLIP;

	// _xZkqqHx_jBfDiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiBeC_xHqqkZx_
	double mmpwMinLen = DBL_MAX;
	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiBeC_xHqqkZx_
	double mmpwPointMinLen = mmpwPointMolipHitMargin;

	//----- _xZkqqHx_jDfPiDiCiDiKiDhGiCpAjHeEjAoGiClFiCmEjClCiCnHiCoJ_xHqqkZx_ -----
	longSet::const_iterator iId;
	for (iId = stPointMolip.begin();
		 iId != stPointMolip.end();
		 iId++)
	{
		// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		DBLPoint mmptMolip = pObj->GetMolipPos(*iId);
		// _xZkqqHx_iDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
		const double mmpwLen = (mmptMolip - mmptMsc).PowLen();
		// _xZkqqHx_iNmFiPkMjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiNmFiPkMjCgMiCmGiClFiCmEiLjHjHkDiCpAiLeMjIfOiBeC_xHqqkZx_
		if (mmpwLen < mmpwMinLen) mmpwMinLen = mmpwLen;
		if (mmpwLen < mmpwPointMinLen)
		//----- _xZkqqHx_iLjHjHkDiCkKiDhBiDgCiDgHiKoOiPiAjCgMjGkCjGjOiKiOiCmCiNmFiPkMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDfPiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiCpAiLeMjIfOiBeC_xHqqkZx_
			mmpwPointMinLen = mmpwLen;
			// _xZkqqHx_jDfPiDiCiDiKiDhGiCmMiCkEiClPiBeBiCoAiCmBiCmGiCoAiDhNiDeFiDfIiNmAjFfHiCmJiLnPiCkCiCoAiCmMiCpAjBeJjBpAiBeC_xHqqkZx_
			// _xZkqqHx_iDhBiDgCiDgHiPoOjFpBiCpAiLeMjIfOiBeC_xHqqkZx_
			lHitMolip = *iId;
			mmptHit = mmptMolip;
			// _xZkqqHx_iBhFjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBhGiCpAjFnEiClHiBeC_xHqqkZx_
			molipKind = FDPA_HIT_POINT_MOLIP;
		}
	}

	if (molipKind == FDPA_HIT_NOT_MOLIP)
	//----- _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jDfPiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiBeC_xHqqkZx_
//		double mmpwLineMinLen = POW2(pObj->GetMolipWeight(lMolipId) / 2.0 + mmLineMolipHitMargin);
//		//----- _xZkqqHx_jApMiDiCiDiKiDhGiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//		for (iId = stLineMolip.begin();
//			 iId != stLineMolip.end();
//			 iId++)
//		{
//			// _xZkqqHx_jApMiDiCiDiKiDhGiPoDiCmFiBeBiDhNiDeFiDfIiNmAjFfHiCmJiLnPiCkNjAkHiMmAiPpAiMiPiCmJiDhNiDgCiDgAiClHiCoJiNmAjFfHiBeC_xHqqkZx_
//			DBLPoint mmptNear;
//			// _xZkqqHx_jApMiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiNmFjCfKiLjHjHkDiBeC_xHqqkZx_
//			double mmpwLen = pObj->CheckHitLineMolip(mmptNear, *iId, mmptMsc, nFlags, mmptCnv, mmlnAry, iLnArySz);
//			// _xZkqqHx_iNmFiPkMjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiNmFiPkMjCgMiCmGiClFiCmEiLjHjHkDiCpAiLeMjIfOiBeC_xHqqkZx_
//			if (mmpwLen < mmpwMinLen) mmpwMinLen = mmpwLen;
//			if (mmpwLen < mmpwLineMinLen)
//			//----- _xZkqqHx_iLjHjHkDiCkKiDhBiDgCiDgHiKoOiPiAjCgMjGkCjGjOiKiOiCmCiNmFiPkMiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jApMiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiCpAiLeMjIfOiBeC_xHqqkZx_
//				mmpwLineMinLen = mmpwLen;
//				// _xZkqqHx_iDhBiDgCiDgHiPoOjFpBiCpAiLeMjIfOiBeC_xHqqkZx_
//				lHitMolip = *iId;
//				mmptHit = mmptNear;
//				// _xZkqqHx_iBhFjApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBhGiCpAjFnEiClHiBeC_xHqqkZx_
//				molipKind = FDPA_HIT_LINE_MOLIP;
//			}
//		}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGjAfDjApMiCmGiDhNiDeFiDfIiNmAjFfHiCmMiLjHjHkDiCpAiMlDiCmJiBeBiCoAiCmBiCmGiCoA_xHqqkZx_
		// _xZkqqHx_iDhNiDeFiDfIiCmJiLnPiCkCjApMiDiCiDiKiDhGiCpAjBeJiCnEiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCmMiMoDiCmJiBeBjApMiDiCiDiKiDhGiCmMjFjNiCpAiNgMjHlGiClFiCmEiBeBiDhBiDgCiDgHiKoOiPiAiLjHjHkDiCoGiCoI_xHqqkZx_
		// _xZkqqHx_jCfKiCkCiCkJiCmHiCkEiCkJiCpAjElLjCgGiBeC_xHqqkZx_

		// _xZkqqHx_jDfPiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiBeC_xHqqkZx_
		double mmpwLineMinLen = DBL_MAX;
		//----- _xZkqqHx_jApMiDiCiDiKiDhGiCpAjClCiCnHiCoJ_xHqqkZx_ -----
		for (iId = stLineMolip.begin(); iId != stLineMolip.end(); iId++)
		//----- _xZkqqHx_jBfDiCmEiCmMjApMiDiCiDiKiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			// _xZkqqHx_jApMiDiCiDiKiDhGiPoDiCmFiBeBiDhNiDeFiDfIiNmAjFfHiCmJiLnPiCkNjAkHiMmAiPpAiMiPiCmJiDhNiDgCiDgAiClHiCoJiNmAjFfHiBeC_xHqqkZx_
			DBLPoint mmptNear;
			// _xZkqqHx_jApMiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiNmFjCfKiLjHjHkDiBeC_xHqqkZx_
			double mmpwLen = pObj->CheckHitLineMolip(mmptNear, *iId, mmptMsc, nFlags, mmptCnv, mmlnAry, iLnArySz);

			// _xZkqqHx_iNmFiPkMjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiNmFiPkMjCgMiCmGiClFiCmEiLjHjHkDiCpAiLeMjIfOiBeC_xHqqkZx_
			if (mmpwLen < mmpwMinLen) mmpwMinLen = mmpwLen;
			if (mmpwLen < mmpwLineMinLen)
			//----- _xZkqqHx_iLjHjHkDiCkKiDhBiDgCiDgHiKoOiPiAjCgMjGkCjGjOiKiOiCmCiNmFiPkMiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jApMiDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCmMjDpBiPoGiCpAiLeMjIfOiBeC_xHqqkZx_
				mmpwLineMinLen = mmpwLen;
				// _xZkqqHx_iDhBiDgCiDgHiPoOjFpBiCpAiLeMjIfOiBeC_xHqqkZx_
				lHitMolip = *iId;
				mmptHit = mmptNear;
				// _xZkqqHx_iBhFjApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBhGiCpAjFnEiClHiBeC_xHqqkZx_
				molipKind = FDPA_HIT_LINE_MOLIP;
			}
		}
		if (molipKind == FDPA_HIT_LINE_MOLIP)
		//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// mmLineMolipHitMargin _xZkqqHx_iCoGiCoIjBoFiCkLiCkCiCmIiCoHiBeB_xHqqkZx_
			// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiClBiCmGiCmJiPeDjAlDiClHiCoJiBeC_xHqqkZx_

			// _xZkqqHx_jApMiDiCiDiKiDhG_xHqqkZx_(lHitMolip)_xZkqqHx_iCmGiDhNiDeFiDfIiCmMiLjHjHkDiCmMiNmFiPkMjCgMiCpAiOfKiPgPiBeC_xHqqkZx_
			// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjFjNiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
			mmetol mmLineMinLen = sqrt(mmpwLineMinLen) - (pObj->GetMolipWeight(lHitMolip) / 2.0);
			if (mmLineMolipHitMargin <= mmLineMinLen)
			//----- _xZkqqHx_iDhBiDgCiDgHiKoOiPiAiLjHjHkDiCoGiCoIjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iBhFjApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBhGiCpAiOoGiCoIiPmBiClHiBeC_xHqqkZx_
				molipKind = FDPA_HIT_NOT_MOLIP;
			}
		}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	// _xZkqqHx_jHoBiCkGjDfPiDiCiDiKiDhGiBeBjApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmEiCoAiBeBjCiGiJjLjDfPiDiCiDiKiDhGiCmMjFpLiCkK_xHqqkZx_
	// _xZkqqHx_iLnPiCkPiCoKiCmOiBeBiClLiClPiCoHiCpAjHeEjAoGiClHiCoJiBeC_xHqqkZx_

//----- 05.08.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (molipKind == FDPA_HIT_NOT_MOLIP)
//	//----- _xZkqqHx_jDfPiDiCiDiKiDhGiBeBjApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//----- 05.08.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.08.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (!pObj->IsKindOf(FDOJ_FIGURE) || pObj->IsClosePolygon())
//		//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiBeBiIlNiCkCiCmNiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//----- 05.08.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jBlNiKhAjApMjFjEjFgJiCoCiBeBjGoOiIpDiDhMiDiKiDiJiDeDiDjDiCmMjCiGjAfDjDfPiCmJiDhBiDgCiDgHiClHiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
		BOOL bCheckCenter = TRUE;
		if (pObj->IsKindOf(FDOJ_POLY))
		{
			if (((const FCObjPoly*)pObj)->GetIsOpenPolyJoint())
				bCheckCenter = FALSE;
		} else
		if (pObj->IsKindOf(FDOJ_FIGURE))
		{
			if (!pObj->IsClosePolygon())
				bCheckCenter = FALSE;
		}
		if (bCheckCenter)
		//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiBeBiIlNiCkCiCmNiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 05.08.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGjAfDiCmJjCiGiJjLjDfPiDiCiDiKiDhGiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jCiGiJjLjDfPiDiCiDiKiDhGiCmMiCkEiClPiBeBiCoAiCmBiCmGiCoAiDhNiDeFiDfIiCmJiLnPiCkCiCoAiCmMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jCeBiClFiBeBjBlMiCmMjDfPiDiCiDiKiDhGiBeFjApMiDiCiDiKiDhGiCoGiCoIiLnPiCkNiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			for (iId = stLineMolip.begin(); iId != stLineMolip.end(); iId++)
			{
				// _xZkqqHx_iDiCiDiKiDhGiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
				if (pObj->GetMolipFrame(*iId).PtInRect(mmptMsc))
				//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMiDhEiDiMiBfLiDiAjDoAiCmJiDhNiDeFiDfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDiCiDiKiDhGiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
					DBLPoint mmptMolip = pObj->GetMolipPos(*iId);
					// _xZkqqHx_iDiCiDiKiDhGiCmGiDhNiDeFiDfIiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
					const double mmpwLen = (mmptMolip - mmptMsc).PowLen();
					if (mmpwLen < mmpwMinLen)
					//----- _xZkqqHx_iLjHjHkDiCkKiNmFiPkMjCgMiCpAiJlKiJpBiCoJiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_iNmFiPkMjCgMiCmGiClFiCmEiLjHjHkDiCpAiLeMjIfOiBeC_xHqqkZx_
						mmpwMinLen = mmpwLen;
						// _xZkqqHx_iDhBiDgCiDgHiPoOjFpBiCpAiLeMjIfOiBeC_xHqqkZx_
						lHitMolip = *iId;
						mmptHit = mmptMolip;
						// _xZkqqHx_iBhFjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBhGiCpAjFnEiClHiBeC_xHqqkZx_
						molipKind = FDPA_HIT_POL_MOLIP;
					}
				}
			}
		}
// 05.08.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	}
	// _xZkqqHx_iDiCiDiKiDhGiCmMiDhBiDgCiDgHiPpDiLlFiCpAjFnEiClHiBeC_xHqqkZx_
	return molipKind;
} // FCLinkManager::GetHitOnMolipLineSubSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::GetHitOnMolipSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetHitOnMolip_xZkqqHx_iKnGjAjEiCmMiDfEiDhFiKnGjAjEiBeCiDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pHitObj		:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitMolip	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptHitPos	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiCiDiKiDhGiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObjOrder	:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMjFjEjFgJiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMsc		:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJiDiCiDiKiDhGiPfHiNiHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			bIsSearchMultiTerminal
 *						:_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCePiImIiKePiCoAjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmHiClBiCmJiDhBiDgCiDgHiClFiClNiCkJjFnEiClHiBeCjEhHiMgJiBeBjDfPiDiCiDiKiDhGiBeBjCiGjAfDjDfPiDiCiDiKiDhGjDjJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiNmFiCoAiLnPiCkCiDiCiDiKiDhGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTMolipKind FCLinkManager::GetHitOnMolipSub (	FCObjDynabase*& pHitObj,
												long& lHitMolip,
												DBLPoint& mmptHitPos,
												const ObjDynabaseVector& vObjOrder,
												const DBLPoint& mmptMsc,
												const FTMolipSet* stIgnore,
												BOOL bIsSearchMultiTerminal)
{
	const mmetol mmPointMolipHitMargin = lg2mm(FD_POINT_MOLIP_HIT_MARGIN_PUT_TOOL);
	const double mmpwPointMolipHitMargin = POW2(mmPointMolipHitMargin);
	// _xZkqqHx_jFjEjFgJiCpAiMoDiCoLiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
	ObjDynabaseVector::const_reverse_iterator rObj;
	for (rObj = vObjOrder.rbegin(); rObj != vObjOrder.rend(); rObj++)
	{
		// _xZkqqHx_iMjPiNpFjFhDjHhGjFjEjFgJiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (stIgnore != NULL &&
			stIgnore->find(FCMolipRec((*rObj)->GetObjID(), -1)) != stIgnore->end())
			continue;
		FTMolipKind molipKind = GetHitOnMolipDetail(lHitMolip,
													mmptHitPos,
													*rObj,
													mmptMsc,
													mmPointMolipHitMargin,
													mmpwPointMolipHitMargin,
													stIgnore,
													bIsSearchMultiTerminal);
		if (molipKind != FDPA_HIT_NOT_MOLIP)
		{
			pHitObj = *rObj;
			return molipKind;
		}
	}
	// _xZkqqHx_iDiCiDiKiDhGiPoDiCmJiCmIiCkCiClBiCmGiCpAjFnEiClHiBeC_xHqqkZx_
	return FDPA_HIT_NOT_MOLIP;
} // FCLinkManager::GetHitOnMolipSub.

//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLinkManager::ReLink
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJjBlGiCmMiDiKiDjDiDeOiCpAiNoNiPjMiClFiClNiMoDiBeBiDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiCpAjCkDiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	molipA		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			molipB		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wLinkKindNew:_xZkqqHx_iDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwLinkIdOld	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKpJjBlGiCmMiDiKiDjDiDeOiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *						 _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCLinkManager::ReLink (const FCMolipRec& molipA,
//							const FCMolipRec& molipB,
//							WORD wLinkKindNew,
//							DWORD dwLinkIdOld)
//{
//	if (wLinkKindNew == 0 || wLinkKindNew == WORD(-1)) return;
//	// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiDiKiDjDiDeOjAoGiCkKjDkPiClGiCmIiCoHiPeJjHlJiBeC_xHqqkZx_
//	if (molipA == molipB) return;
//
//	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
//	ObjDynabaseSet stRedrawObj;
//
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//
//	if (dwLinkIdOld != DWORD(-1))
//	{
//		const FCLinkRec* pLRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(dwLinkIdOld);
//		ASSERT(pLRec->m_mlpTo == molipB);
//		if (pLRec->m_mlpFrom == molipA)
//		//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			if (pLRec->m_wLinkKind != wLinkKindNew)
//			//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKjDjJiClFiCkNiBeBiDiKiDjDiDeOiOoNiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				g_pDoc->CmdModify1LinkKind(dwLinkIdOld, wLinkKindNew);
//			}
//			//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKjDjJiClFiCkNiBeBiDiKiDjDiDeOiOoNiCoAjDjJiClFiCkCiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkC_xHqqkZx_ -----
//		} else
//		//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			if (pLRec->m_wLinkKind != wLinkKindNew)
//			//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKiInJiCmIiCoIiBeBiDiKiDjDiDeOiOoNiCoAiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDiKiDjDiDeOiCpAiNoNiPjMiClFiCmEjAfGiClFiCkNiNoMjAkMiBeC_xHqqkZx_
//				g_pDoc->CmdDelete1Link(stRedrawObj, dwLinkIdOld);
////----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////				g_pDoc->CmdAppend1Link(stRedrawObj, molipA, molipB, wLinkKindNew);
////
////----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//				DBLPoint mmptOffset(0,0);
//				// X_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
//				switch (wLinkKindNew & 0x000f)
//				{
//				case FDLM_LINK_ON_COORD_X:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
//					break;
//				case FDLM_LINK_ON_RATIO_X:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
//					mmptOffset.x = 1.0;
//					break;
//				case FDLM_LINK_ON_ANGLE_X:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
//					break;
//				}
//				// Y_xZkqqHx_jFpLiMpMiCmMiDiKiDjDiDeOiNmAjFfHjIeBiMgHiCmMiMhGiOfKiBeC_xHqqkZx_
//				switch (wLinkKindNew & 0x00f0)
//				{
//				case FDLM_LINK_ON_COORD_Y:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
//					break;
//				case FDLM_LINK_ON_RATIO_Y:	// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
//					mmptOffset.y = 1.0;
//					break;
//				case FDLM_LINK_ON_ANGLE_Y:	// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
//					break;
//				}
//				g_pDoc->LinkManager()->AppendLink(DWORD(-1), molipA, molipB, mmptOffset, wLinkKindNew);
////----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//			} else
//			//----- _xZkqqHx_iDiKiDjDiDeOiMlDiCkKiInJiCmIiCoIiBeBiDiKiDjDiDeOiOoNiCmNjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				g_pDoc->CmdModify1LinkMolip(ObjDynabaseSet(), dwLinkIdOld, molipA, molipB);
//			}
//			// _xZkqqHx_iDiKiDjDiDeOiMlDjFmPiNfIiCpAjFjEjFgJiCmMiInKjDkOiCmGiClFiCmEiPiIjHjNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//			ObjDynabaseSet stMoveTopObj;
//			stMoveTopObj.insert(g_pDoc->ObjID2Object(molipA.dwObjID));
//			g_pDoc->LinkManager()->MovedNotify(stMoveTopObj);
//		}
//	} else
//	{
//		g_pDoc->CmdAppend1Link(stRedrawObj, molipA, molipB, wLinkKindNew);
//		// _xZkqqHx_iDiKiDjDiDeOiMlDjFmPiNfIiCpAjFjEjFgJiCmMiInKjDkOiCmGiClFiCmEiPiIjHjNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//		ObjDynabaseSet stMoveTopObj;
//		stMoveTopObj.insert(g_pDoc->ObjID2Object(molipA.dwObjID));
//		g_pDoc->LinkManager()->MovedNotify(stMoveTopObj);
//	}
//
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//
//	if (!stRedrawObj.empty())
//	//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		g_pView->AppendToLastRgn(stRedrawObj);
//	}
//	// MovedNotify_xZkqqHx_jCiGiCmFiDiKiBfLiDfHiDiHiDjDiCmNiNfIjAfGiClDiCoKiCoJiCmMiCmFiBeBjGlDiPpAiMiPiCmJiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->PostRgnRedraw();
//} // FCLinkManager::ReLink.
//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

