#ifndef LinkManager_h
#define LinkManager_h

// 03.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include <map>			// For multimap.
#include "ObjIDTbl.h"	// For FCObjIDTbl.

class FCHiCommandTable;	// For friend.
class CFCCommonDrawDoc;	// For friend.
class FCToolGroupEdit;	// For friend.
class FCToolGroupSelect;// For friend.

class FCZOrder;
class FCUndoArchive;

// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjApMiCmJiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiLjHjHkDiBeC_xHqqkZx_
#define FD_LINE_MOLIP_HIT_MARGIN	10
// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiLjHjHkDiBeC_xHqqkZx_
#define FD_POINT_MOLIP_HIT_MARGIN	10

// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClDiCoKiCoJiLjHjHkD_xHqqkZx_(_xZkqqHx_jEhKjChFiDgDiBfLiDiLiCmMiPoKiNiH_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
#define FD_POINT_MOLIP_HIT_MARGIN_PUT_TOOL	50

//----------<NOT EXPORT TO VIEWER>-----------

//;----- <EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCMolipInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PolyJoint_xZkqqHx_jEhKjHpBiCmGiDiCiDiKiDhGiBeFiDiKiDjDiDeOiCmMiKnGiMfHiCpAiLeMjIfOiClFiBeBjIeBiMiLjDfPiCmMjFmAiCnHjBnGiCkG_xHqqkZx_
 *			_xZkqqHx_iCmJiNiHiCoNiClJiCmE_xHqqkZx_FCMolipInfo_xZkqqHx_jEhKjHpBiCoAjFmAiCnHjBnGiCkGiCmEiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiPpDiLlFiCpAiOoGiCoIiPgPiClHiInHiCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCMolipInfo
{
	FCMolipInfo () {}
	DWORDVector vLinkFrom;
	DWORDVector vLinkTo;
}; // struct FCMolipInfo.

typedef vector <FCMolipInfo> FCMolipInfoVector;

//----- FCLinkRec::wLinkKind_xZkqqHx_iCmMiDfOiDeDiDhG_xHqqkZx_ -----
enum
{
	// _xZkqqHx_iChHjFpLiMpMiCmMiNmAjFfHjIeBiMgHiBeC_xHqqkZx_
	FDLM_LINK_ON_NONE_X		= 0x00,		// _xZkqqHx_iNmAjFfHjIeBiMgHiCmNjGlDiClFiBeC_xHqqkZx_
	FDLM_LINK_ON_COORD_X	= 0x01,		// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
	FDLM_LINK_ON_RATIO_X	= 0x02,		// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
// 01.10.19 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	FDLM_LINK_ON_ANGLE_X	= 0x03,		// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_

	// _xZkqqHx_iChIjFpLiMpMiCmMiNmAjFfHjIeBiMgHiBeC_xHqqkZx_
	FDLM_LINK_ON_NONE_Y		= 0x00,		// _xZkqqHx_iNmAjFfHjIeBiMgHiCmNjGlDiClFiBeC_xHqqkZx_
	FDLM_LINK_ON_COORD_Y	= 0x10,		// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
	FDLM_LINK_ON_RATIO_Y	= 0x20,		// mmptOffset_xZkqqHx_iCmNiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
// 01.10.19 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	FDLM_LINK_ON_ANGLE_Y	= 0x30,		// mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkDiBeC_xHqqkZx_
};

enum
{
	// mmptOffset_xZkqqHx_iCmNiBeBiDiCiDiKiDhGiCkJiCoHiCmMjBiKjBmOiNmAjFfHjCgMiBeC_xHqqkZx_
	FDLM_LINK_ON_COORD = FDLM_LINK_ON_COORD_X | FDLM_LINK_ON_COORD_Y,
	// mmptOffset_xZkqqHx_iCmNiBeBiDiCiDiKiDhGiCkJiCoHiCmMiDfEiDeDiDfJjEoEjHkGjCgMiBeC_xHqqkZx_
	FDLM_LINK_ON_RATIO = FDLM_LINK_ON_RATIO_X | FDLM_LINK_ON_RATIO_Y,
//----- 01.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// mmptOffset_xZkqqHx_iCmNiBeBiDiCiDiKiDhGiCkJiCoHiCmMiIoKjCoIiCmMiKhAjDhIjCgMiBeC_xHqqkZx_
	FDLM_LINK_ON_ANGLE = FDLM_LINK_ON_ANGLE_X | FDLM_LINK_ON_ANGLE_Y,
//----- 01.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
};

//----------</NOT EXPORT TO VIEWER>-----------

// GetHitOnMolipLine _xZkqqHx_iCmMjFnEjCgMiBeC_xHqqkZx_
enum FTMolipKind
{
	FDPA_HIT_NONE = 0,
	FDPA_HIT_NOT_MOLIP,		// _xZkqqHx_iDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmIiCkCiBeC_xHqqkZx_
	FDPA_HIT_POINT_MOLIP,	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
	FDPA_HIT_LINE_MOLIP,	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
	FDPA_HIT_POL_MOLIP,		// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
}; // enum FTMolipKind.

//;------ </EXPORT TO SDK> -----;

//;----- <EXPORT TO SDK> -----;
/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCLinkRec
{
	FCLinkRec () : m_mlpFrom(0,0), m_mlpTo(0,0), m_mmptOffset(0,0),
					m_wLinkKind(FDLM_LINK_ON_COORD) {}
	FCLinkRec (const FCMolipRec& pntFrom, const FCMolipRec& pntTo,
					const DBLPoint& mmpt, WORD kind)
				: m_mlpFrom(pntFrom), m_mlpTo(pntTo),
					m_mmptOffset(mmpt), m_wLinkKind(kind) {}
//;------ </EXPORT TO SDK> -----;

	DBLPoint	CalcNewMoving () const;
	DBLPoint	CalcNewMovingAngle () const;
	void		ApplyNewOffset ();
	void		ApplyNewOffsetAngle ();

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static DBLPoint	CalcNewOffset (	const DBLPoint& mmptMolipFrom,
									const DBLRect& mmrtObjFrameFrom,
									const DBLPoint& mmptMolipTo,
									WORD wLinkKind);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//;----- <EXPORT TO SDK> -----;
	FCMolipRec	m_mlpFrom;		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
	FCMolipRec	m_mlpTo;		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiBeC_xHqqkZx_
	DBLPoint	m_mmptOffset;	// _xZkqqHx_iDiKiDjDiDeOiMlDiCkJiCoHiDiKiDjDiDeOjAoGiCnGiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
	WORD		m_wLinkKind;	// mmptOffset_xZkqqHx_iCmMiOoNjHnOiBeC_xHqqkZx_FDLMLinkKind_xZkqqHx_iCmMiCfAiCmCiBeC_xHqqkZx_
}; // struct FCLinkRec.

//----------<NOT EXPORT TO VIEWER>-----------

inline bool operator == (const FCLinkRec& rec0, const FCLinkRec& rec1)
{
	return	rec0.m_mlpFrom == rec1.m_mlpFrom &&
			rec0.m_mlpTo == rec1.m_mlpTo &&
			almosteq(rec0.m_mmptOffset, rec1.m_mmptOffset) &&
			rec0.m_wLinkKind == rec1.m_wLinkKind;
} // bool operator ==.

inline bool operator != (const FCLinkRec& rec0, const FCLinkRec& rec1)
{
	return !(rec0 == rec1);
} // bool operator !=.

// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//typedef vector<FCLinkRec*>	FCLinkRecPVector;
typedef vector<const FCLinkRec*>	FCLinkRecPVector;
typedef vector<FCLinkRec>	FCLinkRecVector;
typedef set<FCMolipRec> FTMolipSet;
typedef pair<FCMolipRec, DWORD> FTMolipLinkPair;

//;------ </EXPORT TO SDK> -----;

typedef multimap<FCMolipRec, DWORD> FTMolipLinkMmap;

typedef BOOL (*FuncGetMolipPos) (DBLPoint& mmpt, DWORD dwData, const FCObjDynabase* pObj,
								long lMolipId, long lTerminalIdx);

// 03.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "../MolipSDK/FCLinkManagerExp.h"	// Superclass.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCLinkManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiKnEiCmMiDiKiDjDiDeOiPoOjFpBiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCLinkManager
{
public:
	FCLinkManager ();
	virtual ~FCLinkManager ();

	virtual void	GetLinkIdList (DWORDVector& vIdList) const;
	virtual BOOL	IsLinkable (const FCMolipRec& mlpFrom, const FCMolipRec& mlpTo) const;
	virtual void	MovedNotify (const FTMolipSet& stMolip, BOOL bUpdateLinkOffset = TRUE);
	virtual void	MovedNotify (const ObjDynabaseVector& vObj, BOOL bUpdateLinkOffset = TRUE);
	virtual void	MovedNotify (const ObjDynabaseSet& stObj, BOOL bUpdateLinkOffset = TRUE);
	virtual void	MovedNotify (const FCObjDynabase* pObj, BOOL bUpdateLinkOffset = TRUE);

//----- 01.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	AddedDeletedNotify (const FCLinkRec& linkRec);
//----- 01.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual void	DeleteSoonNotify (DWORD dwObjID);
	virtual void	GetAffectedByFrom (FCLinkRecPVector& vAffected,
										 const FCMolipRec& lkptFrom) const;
	virtual void	GetAffectedByFrom (DWORDSet& stAffected,
										 const FCMolipRec& lkptFrom) const;
	virtual void	GetAffectedByTo (FCLinkRecPVector& vAffected,
									 const FCMolipRec& lkptTo) const;
	virtual void	GetAffectedByTo (DWORDSet& stAffected,
									 const FCMolipRec& lkptTo) const;
	virtual void	GetAffected (DWORDVector& vLinkIn, DWORDVector& vLinkOut,
								DWORDVector& vLinkInside, const FTMolipSet& stMolip) const;

// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual FCLinkRec*	LinkIDtoLinkRec (DWORD dwLinkID) const;
	virtual const FCLinkRec*	LinkIDtoLinkRec (DWORD dwLinkID) const;

	virtual void	ClearAll ();
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObject) const;
	virtual void	InStream (FCUndoArchive& ar);

//;----- <start restrict> -----;

	//----- FCMolipInfo_xZkqqHx_iKnGjIeBiKnGjAjE_xHqqkZx_ _xZkqqHx_jIeBiMiLjDfPiCmGiDiCiDiKiDhGiCmMiKnGiMfHiCpAiLeMjIfO_xHqqkZx_ -----
	virtual void	PrepareMolipInfoVector (FCMolipInfoVector& vMolipInf,
											FCMolipInfo* pMolipInf,
											long lMolipSz, DWORD dwObjID);
	virtual void	UpdateLinkConnect (	DWORD dwObjID,
										FCMolipInfoVector& vMolipInf,
										FCMolipInfo* pMolipInf);
	virtual void	DeleteLink (FCMolipInfoVector& vMolipInf,
								FCMolipInfo* pMolipInf);

//;------ <end restrict> -----;

//----- 01.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	ReLink (const FCMolipRec& molipA,
//							const FTMolipSet& stMolipB, WORD wLinkKind);
//	virtual void	ReLink (const FTMolipSet& stMolipA,
//							const FCMolipRec& molipB, WORD wLinkKind);
//----- 01.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	static void	ReLink (const FCMolipRec& molipA,
							const FTMolipSet& stMolipB, WORD wLinkKind);
	static void	ReLink (const FTMolipSet& stMolipA,
							const FCMolipRec& molipB, WORD wLinkKind);
//----- 01.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	static void	ConvertSubToMain (const FCLinkManager* pSubMgr, FCObjIDTbl* pSubIdTable);
	static void	CopyToSubTable (FCLinkManager* pSubMgr, const FCLinkManager* pMainMgr,
								const ObjDynabaseVector& vObj);

	virtual const FCLinkRec*	Get1stAngleLinkIn (DWORD dwObjId, long lMolipId,
													const FCLinkRec* pRecExcept) const;

//----- 05.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
friend class FCHiCommandTable;
friend class CFCCommonDrawDoc;		// For CFCCommonDrawDoc::OnGraphicsChipCopy.
friend class FCToolGroupEdit;		// For FCToolGroupEdit::LocalObjMovedBefore.
friend class FCToolGroupSelect;		// For FCToolGroupSelect::OnCopy.
//----- 05.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual FCLinkRec*	GetLinkRec (DWORD dwLinkID);
	virtual DWORD	AppendLink (const FCMolipRec& mlpFrom, const FCMolipRec& mlpTo,
								WORD wLinkKind);
	virtual DWORD	AppendLink (const FCObjDynabase* pObjFrom, long lMolipFrom,
								const FCObjDynabase* pObjTo, long lMolipTo,
								WORD wLinkKind);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	AppendLink (DWORD dwLinkID, const FCMolipRec& mlpFrom,
//								const FCMolipRec& mlpTo, const DBLPoint& mmptOffset,
//								WORD wLinkKind);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual DWORD	AppendLink (DWORD dwLinkID, const FCMolipRec& mlpFrom,
								const FCMolipRec& mlpTo, const DBLPoint& mmptOffset,
								WORD wLinkKind);
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	DeleteLink (DWORD dwLinkID);
	virtual void	MovedNotifySub (const FCMolipRec& mlp);
	virtual BOOL	IsAlreadyMovedHorz (const FCMolipRec& mlp);
	virtual BOOL	IsAlreadyMovedVert (const FCMolipRec& mlp);
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	ModifyLinkFromMolip (DWORD dwLinkID, FCLinkRec& linkRec, FCMolipRec mlpNew);
//	virtual void	ModifyLinkToMolip (DWORD dwLinkID, FCLinkRec& linkRec, FCMolipRec mlpNew);
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual void	ModifyLinkFromMolip (DWORD dwLinkID, FCMolipRec mlpNew);
	virtual void	ModifyLinkToMolip (DWORD dwLinkID, FCMolipRec mlpNew);
//----- 05.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
public:
	virtual void	FindLinkByFrom (DWORDSet& stLinkId,
									const FCMolipRec& lkptFrom) const;
	virtual void	FindLinkByTo (	DWORDSet& stLinkId,
									const FCMolipRec& lkptTo) const;
//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

public:
	static FTMolipKind	GetHitOnMolipLine (	FCObjDynabase*& pHitObj, long& lHitMolip,
											DBLPoint& mmptHit,
											const DBLPoint& mmptMsc,
											UINT nFlags, const DBLPoint& mmptCnv,
											const DBLLine* mmlnAry, int iLnArySz,
											const FTMolipSet* stIgnore = NULL);

	static FTMolipKind GetHitOnMolip (	FCObjDynabase*& pHitObj,
										long& lHitMolip,
										DBLPoint& mmptHitPos,
										const DBLPoint& mmptMsc,
										const FTMolipSet* stIgnore = NULL,
//----- 05.06.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//										long lgMinLen = FD_POINT_MOLIP_HIT_MARGIN,
//										long lgMaxLen = 10 * FD_POINT_MOLIP_HIT_MARGIN,
//----- 05.06.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
										BOOL bIsSearchMultiTerminal = FALSE);

//----- 06.05.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static FTMolipKind GetHitOnMolipDetail (long& lHitMolip,
											DBLPoint& mmptHitPos,
											const FCObjDynabase* pObj,
											const DBLPoint& mmptMsc,
											mmetol mmPointMolipHitMargin,
											double mmpwPointMolipHitMargin,
											const FTMolipSet* stIgnore,
											BOOL bIsSearchMultiTerminal);
//----- 06.05.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


	static void	DrawCursor (CDC* pDC, const CPoint& lgpt, FTMolipKind iCursor);

protected:
	static FTMolipKind GetHitOnMolipLineSub (	FCObjDynabase*& pHitObj,
												long& lHitMolip,
												DBLPoint& mmptHit,
												const ObjDynabaseVector& vObjOrder,
												const DBLPoint& mmptMsc,
												UINT nFlags,
												const DBLPoint& mmptCnv,
												const DBLLine* mmlnAry,
												int iLnArySz,
												const FTMolipSet* stIgnore);
	static FTMolipKind GetHitOnMolipLineSubSub (long& lHitMolip,
												DBLPoint& mmptHit,
												const FCObjDynabase* pObj,
												const DBLPoint& mmptMsc,
												UINT nFlags,
												double mmpwPointMolipHitMargin,
												mmetol mmLineMolipHitMargin,
// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//												double mmpwLineMolipHitMargin,
												const DBLPoint& mmptCnv,
												const DBLLine* mmlnAry,
												int iLnArySz,
												const FTMolipSet* stIgnore);

	static FTMolipKind GetHitOnMolipSub (	FCObjDynabase*& pHitObj,
											long& lHitMolip,
											DBLPoint& mmptHitPos,
											const ObjDynabaseVector& vObjOrder,
											const DBLPoint& mmptMsc,
											const FTMolipSet* stIgnore,
											BOOL bIsSearchMultiTerminal);
//----- 06.05.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	static FTMolipKind GetHitOnMolipSubSub (long& lHitMolip,
//											DBLPoint& mmptHitPos,
//											const FCObjDynabase* pObj,
//											const DBLPoint& mmptMsc,
//											mmetol mmPointMolipHitMargin,
//											double mmpwPointMolipHitMargin,
//											const FTMolipSet* stIgnore,
//											BOOL bIsSearchMultiTerminal);
//----- 06.05.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	static void	ReLink (const FCMolipRec& molipA,
//						const FCMolipRec& molipB,
//						WORD wLinkKindNew,
//						DWORD dwLinkIdOld);
////----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
//----------<NOT EXPORT TO VIEWER>-----------
	FCObjIDTbl				m_tblLinkID;		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ _xZkqqHx_iDiBiDeDiDjDiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FTMolipLinkMmap			m_mmapFrom2Link;	// _xZkqqHx_iDiKiDjDiDeOiMlDiPoOjFpB_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FTMolipLinkMmap			m_mmapTo2Link;		// _xZkqqHx_iDiKiDjDiDeOjAoGiPoOjFpB_xHqqkZx_->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FTMolipSet				m_stMovedHorz;		// _xZkqqHx_jAiFjFlNjFpLiMpMiInKjDkOiNmPiCnNiDiCiDiKiDhGiDiKiDfIiDgHiBeC_xHqqkZx_
	FTMolipSet				m_stMovedVert;		// _xZkqqHx_jAiCjClMjFpLiMpMiInKjDkOiNmPiCnNiDiCiDiKiDhGiDiKiDfIiDgHiBeC_xHqqkZx_
//----------</NOT EXPORT TO VIEWER>-----------
}; // class FCLinkManager.

#endif//LinkManager_h
