#ifndef __MolipExport_h
#define __MolipExport_h

enum FTObjectType;
class FCObjDynabase;
class FCRichText;
class DBLRect;
class FCEnv;
class FCRegData;
class CFCFoundDoc;
class CFCDynamicDrawView;
class CFCMainFrame;
class CFCWndRichEdit;
struct FCFontCharInfo;
struct FCErrFontInfo;
class FCToolBase;
struct FCFileConvInfo;

//;----- <EXPORT TO SDK> -----;

interface IMpgMolipBase;
interface IMpgClassInstance;
interface IMpgMfcClass;
interface IMpgStdClass;
interface IMpgUtilErr;
interface IMpgUtilMath;
interface IMpgUtilFile;
interface IMpgUtilFont;
interface IMpgUtilStr;
interface IMpgUtilDlg;
interface IMpgUtilPrint;
interface IMpgUtilCoord;
interface IMpgUtilZlibPng;
interface IMpgUtilMisc;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
interface IMpgUtilDoc;
interface IMpgUtilToolbar;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

interface IMpgFileConv;

// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
interface IMpgUtilBezier;

// interface IMpgPlugInInfo _xZkqqHx_iCmM_xHqqkZx_IID_xZkqqHx_iBeC_xHqqkZx_
// {96094A29-F70F-4840-AF9A-03E4A7F8D0B3}
#define FD_IMPGPLUGININFO_CLSID	{ 0x96094a29, 0xf70f, 0x4840, { 0xaf, 0x9a, 0x3, 0xe4, 0xa7, 0xf8, 0xd0, 0xb3 } }

// interface IMpgPlugInMain _xZkqqHx_iCmM_xHqqkZx_IID_xZkqqHx_iBeC_xHqqkZx_
// {D8910582-E901-4fdd-A44E-F40E25F05B08}
#define FD_IMPGPLUGINMAIN_CLSID	{ 0xd8910582, 0xe901, 0x4fdd, { 0xa4, 0x4e, 0xf4, 0xe, 0x25, 0xf0, 0x5b, 0x8 } }

// interface IMpgPlugInFileConv _xZkqqHx_iCmM_xHqqkZx_IID_xZkqqHx_iBeC_xHqqkZx_
// {79F019A6-1346-4644-A372-08086B3DE4A7}
#define FD_IMPGPLUGINFILECONV_CLSID	{ 0x79f019a6, 0x1346, 0x4644, { 0xa3, 0x72, 0x8, 0x8, 0x6b, 0x3d, 0xe4, 0xa7 } }

#define PG_USE_PLUGIN_INTERFACE \
static const IID IID_IMpgPlugInInfo = FD_IMPGPLUGININFO_CLSID; \
static const IID IID_IMpgPlugInMain = FD_IMPGPLUGINMAIN_CLSID; \
static const IID IID_IMpgPlugInFileConv = FD_IMPGPLUGINFILECONV_CLSID; \

typedef void* (*FuncAllocate) (size_t sz);
typedef void (*FuncFree) (void* p);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
typedef HRESULT (WINAPI *FuncMolipSupportInfo)(WORD* wSupportApp, WORD* wAppVersion, const wchar_t** wcpIsUnicode, LANGID** pLangId, const wchar_t** wcpModuleName, const wchar_t** wcpSupportInfo);
typedef HRESULT (WINAPI *FuncMolipInitialize)(FuncAllocate pfnAllocate, FuncFree pfnFree, IMpgMolipBase* pI);
typedef HRESULT (WINAPI *FuncMolipTerminate)();
typedef HRESULT (WINAPI *FuncMolipGetClassObject)(int idxCompo, const IID& iid, void** ppv);
typedef HRESULT (WINAPI *FuncCanUnloadNow) ();
//----- 06.05.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_>	IMpgMolipBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkJiCoHiBeBiDhGiDiJiDePiDeDiDjDiCnGiMpGiKeKiClDiCoKiCoJiKnGjAjEiCmMjCoIiLgAiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iMpGiKeKiClDiCoKiClNiKnGjAjEiCmNiDhGiDiJiDePiDeDiDjDiCkJiCoHjDeLiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
interface IMpgMolipBase
{
	virtual WORD GetStcAppVersion () const;
	virtual const wchar_t* GetStcAppVersionString () const;
	virtual WORD GetAppMode () const;
// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual LANGID	GetAppLangId () const;
	virtual HRESULT	LockInterface ();
	virtual HRESULT	UnlockInterface ();
	virtual HRESULT	Suspend ();
	virtual HRESULT	Resume ();
	virtual BOOL	CanCommand ();
	virtual BOOL	PostMessage (UINT Msg, WPARAM wParam, LPARAM lParam);
	virtual HRESULT	SendMessage (UINT Msg, WPARAM wParam, LPARAM lParam);
	virtual FCObjDynabase*		CreateObject (FTObjectType type) const;
	virtual CFCFoundDoc*		GetDocument () const;
	virtual CFCDynamicDrawView*	GetView () const;
	virtual CFCMainFrame*		GetFrame () const;
	virtual CFCWndRichEdit*		GetTextEditor () const;
	virtual FCEnv*				GetEnv () const;
	virtual FCRegData*			GetRegData () const;
	virtual mmetol		GetDisplayPPM () const;
	virtual mmetol		GetRealDisplayPPMHorz () const;
	virtual mmetol		GetRealDisplayPPMVert () const;
	virtual double		GetZoom () const;
	virtual double		SetZoom (double dZoom);
	virtual long		GetOffsetX () const;
	virtual long		SetOffsetX (long lOffsetX);
	virtual long		GetOffsetY () const;
	virtual long		SetOffsetY (long lOffsetY);
	virtual FTDrawWhich	GetDrawWhich () const;
	virtual FTDrawWhich	SetDrawWhich (FTDrawWhich drawWhich);
	virtual CPalette*	GetPalette () const;
	virtual CPalette*	SetPalette (CPalette* pPalette);
	virtual FCToolBase*	GetTool (DWORD dwIndex) const;
	virtual HINSTANCE	ShellExecute (	HWND hwnd, const wchar_t* lpVerb,
										const wchar_t* lpFile,
										const wchar_t* lpParameters,
										const wchar_t* lpDirectory,
										INT nShowCmd) const;
	virtual HWND	GetMainWindow () const;
	virtual BOOL	SaveSelectedWMF (const wchar_t* wcpPath,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom) const;
	virtual BOOL	SaveSelectedEMF (const wchar_t* wcpPath,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom) const;

	virtual void*	Allocate (size_t sz);
	virtual void	Free (void* p);

	virtual IMpgClassInstance*	GetClassInstanceI ();
	virtual IMpgMfcClass*		GetMfcClassI ();
	virtual IMpgStdClass*		GetStdClassI ();
	virtual const IMpgUtilErr*		GetUtilErrI () const;
	virtual const IMpgUtilMath*		GetUtilMathI () const;
	virtual const IMpgUtilFile*		GetUtilFileI () const;
	virtual const IMpgUtilFont*		GetUtilFontI () const;
	virtual const IMpgUtilStr*		GetUtilStrI () const;
	virtual const IMpgUtilDlg*		GetUtilDlgI () const;
	virtual const IMpgUtilPrint*	GetUtilPrintI () const;
	virtual const IMpgUtilCoord*	GetUtilCoordI () const;
	virtual const IMpgUtilZlibPng*	GetUtilZlibPngI () const;
	virtual const IMpgUtilMisc*		GetUtilMiscI () const;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual const IMpgUtilDoc*		GetUtilDocI () const;
	virtual const IMpgUtilToolbar*	GetUtilToolbarI () const;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual IMpgFileConv*	GetFileConvI ();

// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual const IMpgUtilBezier*	GetUtilBezierI () const;
//;------ </EXPORT TO SDK> -----;
	void	Initialize ();
protected:
	CFCFoundDoc*		m_pDocument;
	CFCDynamicDrawView*	m_pView;
	CFCMainFrame*		m_pFrame;
	CFCWndRichEdit*		m_pTextEditor;
	FCEnv*				m_pEnv;
	FCRegData*			m_pRegData;
//;------ <EXPORT TO SDK> -----;
}; // interface IMpgMolipBase.

/*************************************************************************
 * <_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_>	IMpgMolipMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkJiCoHiBeBiDhGiDiJiDePiDeDiDjDiCnGiMpGiKeKiClDiCoKiCoJiKnGjAjEiCmMjCoIiLgAiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iMpGiKeKiClDiCoKiClNiKnGjAjEiCmNiDhGiDiJiDePiDeDiDjDiCkJiCoHjDeLiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
interface IMpgMolipMain : IMpgMolipBase
{
	virtual ULONG	RegisterCommand (BOOL bMenu, const wchar_t* wcpMenu, wchar_t wcShortcut) = 0;
	virtual ULONG	RegisterSelObjSaveFormat (const wchar_t* wcpName, const wchar_t* wcpExt) = 0;
	virtual HRESULT	GetProfileBinary (wchar_t* wcpEntry, BYTE* bypBuff, DWORD dwBuffSz) const = 0;
	virtual HRESULT	SetProfileBinary (wchar_t* wcpEntry, const BYTE* bypBuff, DWORD dwBuffSz) = 0;
	virtual HRESULT	GetProfileString (wchar_t* wcpEntry, WString& wstrText) const = 0;
	virtual HRESULT	SetProfileString (wchar_t* wcpEntry, const wchar_t* wcpText) = 0;
	virtual BOOL	ShowAboutDialog () const = 0;
}; // interface IMpgMolipMain.

/*************************************************************************
 * <_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_>	IMpgPlugInInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkJiCoHiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCnGiMpGiKeKiClDiCoKiCoJiKnGjAjEiCmMjCoIiLgAiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iMpGiKeKiClDiCoKiClNiKnGjAjEiCmN_xHqqkZx_DynamicDraw_xZkqqHx_iCkJiCoHjDeLiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmNiBeBiClLiCmMiLeAjEfMiCmJiNiHiCoNiClJiCmEiBeBiClBiCoKiCoHiCmMiKnGjAjEiCpAiOmAjBjFiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhGiDiJiDePiDeDiDjDiMmFjHeMiCmMiPoOjFpBiBgJjGlMiPmMiBeBiDgPiBfLiDfHiDiHiDjDjDjJiBgKiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
interface IMpgPlugInInfo : IUnknown
{
	virtual const GUID&		GetComponentCLSID () const = 0;
	virtual const wchar_t*	GetAuthorName () const = 0;
	virtual const wchar_t*	GetComponentName () const = 0;
	virtual const wchar_t*	GetVersionName () const = 0;
	virtual const wchar_t*	GetComment () const = 0;
	virtual wchar_t			GetComponentShortcut () const = 0;
}; // interface IMpgPlugInInfo.

/*************************************************************************
 * <_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_>	IMpgPlugInMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkJiCoHiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCnGiMpGiKeKiClDiCoKiCoJiKnGjAjEiCmMjCoIiLgAiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iMpGiKeKiClDiCoKiClNiKnGjAjEiCmN_xHqqkZx_DynamicDraw_xZkqqHx_iCkJiCoHjDeLiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmNiBeBiClLiCmMiLeAjEfMiCmJiNiHiCoNiClJiCmEiBeBiClBiCoKiCoHiCmMiKnGjAjEiCpAiOmAjBjFiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiOoFiLeAjEfMiCpAiOmAjBjFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
interface IMpgPlugInMain : IUnknown
{
	virtual HRESULT Initialize (IMpgMolipMain* pI) = 0;
	virtual HRESULT Terminate () = 0;
	virtual HRESULT OnCommand (UINT nCmdID) = 0;
	virtual HRESULT OnUpdateCommandUI (CCmdUI* pCmdUI) = 0;
	virtual HRESULT GetPopHint (WString& wstrHintText, UINT nCmdID) = 0;
	virtual HRESULT OnSelectedObjectSave (	UINT nFormatId, const wchar_t* wcpFileName,
											mmetol mmMarginLeft, mmetol mmMarginTop,
											mmetol mmMarginRight, mmetol mmMarginBottom) = 0;
}; // interface IMpgPlugInMain.

/*************************************************************************
 * <_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_>	IMpgPlugInFileConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkJiCoHiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCnGiMpGiKeKiClDiCoKiCoJiKnGjAjEiCmMjCoIiLgAiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iMpGiKeKiClDiCoKiClNiKnGjAjEiCmN_xHqqkZx_DynamicDraw_xZkqqHx_iCkJiCoHjDeLiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmNiBeBiClLiCmMiLeAjEfMiCmJiNiHiCoNiClJiCmEiBeBiClBiCoKiCoHiCmMiKnGjAjEiCpAiOmAjBjFiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjFmPiKlHiLeAjEfMiCpAiOmAjBjFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
interface IMpgPlugInFileConv : IUnknown
{
	virtual HRESULT GetFileConvInfo (const FCFileConvInfo** pConvInfo, long* lConvInfoSize) = 0;
// 06.05.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual const wchar_t* GetFileConverterPath () = 0;
	virtual HRESULT LoadConverter () = 0;
	virtual HRESULT FreeConverter () = 0;
	virtual HRESULT AnalyzeVersion (WString& wstrVersion, const wchar_t* wcpFilePath) = 0;
	virtual void DoConvert (const wchar_t* wcpTypeFrom,
							const wchar_t* wcpVersionFrom,
							void* pStorageFrom,
							const wchar_t* wcpTypeTo,
							const wchar_t* wcpVersionTo,
							void* pStorageTo,
							const BYTE* pImageData,
							long lImageSize,
							const CSize& szImage) = 0;
}; // interface IMpgPlugInFileConv.

//;------ </EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDjAkHiMoEiCmMiKnGjAjEiMfBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.01 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCExport
{
	static void Initialize ();
	static void Terminate ();
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	static HINSTANCE LoadPlugInModule (const wchar_t* wcpModulePath);
//	static void FreePlugInModule (HINSTANCE hModule);
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	static void LoadPlugIn ();
	static void FreePlugIn ();
	static void RegisterMenu ();
	static void SelfSuspendMolip ();
	static void OnCommand (UINT nCmdID);
	static void OnUpdateCommandUI (CCmdUI* pCmdUI);
	static void GetPopHint (WString& wstrHintText, UINT nCmdID);
	static void SaveSelectedObjectImage (	DWORD dwFormatId, const wchar_t* tcpFileName,
											mmetol mmMarginLeft, mmetol mmMarginTop,
											mmetol mmMarginRight, mmetol mmMarginBottom);
	static IMpgMolipMain* GetMolipMainI (const GUID& clsid);
	static IMpgPlugInInfo* GetPlugInInfoI (const GUID& clsid);
	static IMpgPlugInMain* GetPlugInMainI (const GUID& clsid);
	static IMpgPlugInFileConv* GetPlugInFileConvI (const GUID& clsid);
	static IMpgMolipMain* CreateMolipMainI (HINSTANCE hInstance, IMpgPlugInMain* pIMpgPlugInMain);
	static void DeleteMolipMainI (IMpgMolipMain* pMolipMainI);
}; // struct FCExport.

#endif//__MolipExport_h
