#include "stdafx.h"
#include <algorithm>		// For find template.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "NewFDObjAny.h"	// For NewFDObjAny.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "RegData.h"		// For g_pReg.
#include "FoundDoc.h"		// For g_pDoc.
#include "ObjChipMaster.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::FCObjChipMaster
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
FCObjChipMaster::FCObjChipMaster ()
{
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
//----- 01.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjChipMaster, m_lDutyLinkIndexSz));
//	memset(&m_lDutyLinkIndexSz, 0, sizeof(FCObjChipMaster) - offsetof(FCObjChipMaster, m_lDutyLinkIndexSz));
//----- 01.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjChipMaster, m_nChipKind));
	memset(&m_nChipKind, 0, sizeof(FCObjChipMaster) - offsetof(FCObjChipMaster, m_nChipKind));
//----- 01.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	m_nChipKind = FDCM_NONE;	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiBeC_xHqqkZx_
// 05.05.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_dwObjUserUlong = DWORD(-1);	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_lDutyLinkIndexSz = 0;		// _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_pDutyLinkIndex = NULL;	// _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lDutyTextIndexSz = 0;		// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_pDutyTextIndex = NULL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::FCObjChipMaster.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::~FCObjChipMaster
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjChipMaster::~FCObjChipMaster ()
{
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyLinkIndex != NULL)
	{
		delete[] m_pDutyLinkIndex;
		m_pDutyLinkIndex = NULL;
	}
	m_lDutyLinkIndexSz = 0;
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyTextIndex != NULL)
	{
		delete[] m_pDutyTextIndex;
		m_pDutyTextIndex = NULL;
	}
	m_lDutyTextIndexSz = 0;
} // FCObjChipMaster::~FCObjChipMaster.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjChipMaster::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_CHIP_MASTER) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjChipMaster::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjChipMaster::Type () const
{
	return FDOJ_CHIP_MASTER;
} // FCObjChipMaster::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjChipMaster::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjChipMaster* trgp = static_cast<const FCObjChipMaster*>(objp);

//----- 01.08.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_nChipKind != trgp->m_nChipKind) return FALSE;
// 05.05.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	if (m_dwObjUserUlong != trgp->m_dwObjUserUlong) return FALSE;
//----- 01.08.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (m_lDutyLinkIndexSz != trgp->m_lDutyLinkIndexSz) return FALSE;
	if (m_lDutyTextIndexSz != trgp->m_lDutyTextIndexSz) return FALSE;
	long lC;
	//----- _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAjEoEiKhC_xHqqkZx_ -----
	for (lC = 0; lC < m_lDutyLinkIndexSz; lC++)
		if (m_pDutyLinkIndex[lC] != trgp->m_pDutyLinkIndex[lC]) return FALSE;
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAjEoEiKhC_xHqqkZx_ -----
	for (lC = 0; lC < m_lDutyTextIndexSz; lC++)
		if (m_pDutyTextIndex[lC] != trgp->m_pDutyTextIndex[lC]) return FALSE;
	return TRUE;
} // FCObjChipMaster::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjChipMaster::OutStream (FCUndoArchive& ar)
void FCObjChipMaster::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_nChipKind;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiPgPjHmNiBeC_xHqqkZx_
//	ar << m_dwObjUserUlong;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	long lC;
	//----- _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAiPgPjHmN_xHqqkZx_ -----
	ar << (short)m_lDutyLinkIndexSz;
	for (lC = 0; lC < m_lDutyLinkIndexSz; lC++)
		ar << m_pDutyLinkIndex[lC];

	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAiPgPjHmN_xHqqkZx_ -----
	ar << (short)m_lDutyTextIndexSz;
	for (lC = 0; lC < m_lDutyTextIndexSz; lC++)
		ar << m_pDutyTextIndex[lC];
} // FCObjChipMaster::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);

	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_nChipKind;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjDpMjHmNiBeC_xHqqkZx_
//	ar >> m_dwObjUserUlong;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	short nSize;
	//----- _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyLinkIndex != NULL)
	{
		delete[] m_pDutyLinkIndex;
		m_pDutyLinkIndex = NULL;
	}
	ar >> nSize;
	m_lDutyLinkIndexSz = nSize;
	if (0 < nSize)
	{
		m_pDutyLinkIndex = new short[nSize];
		for (short nC = 0; nC < nSize; nC++)
			ar >> m_pDutyLinkIndex[nC];
	}

	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyTextIndex != NULL)
	{
		delete[] m_pDutyTextIndex;
		m_pDutyTextIndex = NULL;
	}
	ar >> nSize;
	m_lDutyTextIndexSz = nSize;
	if (0 < nSize)
	{
		m_pDutyTextIndex = new short[nSize];
		for (short nC = 0; nC < nSize; nC++)
			ar >> m_pDutyTextIndex[nC];
	}
} // FCObjChipMaster::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetMolipPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMiNmAjFfHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iOoGjDlOiClHiCoJ_xHqqkZx_MOLIP_xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			lTerminalIdx:MOLIP_xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MOLIP_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmNiBeBjFjEjFgJiCmMjCiGjAfDiNmAjFfHiCpAiOkGiClFiBeBjBfDiCmEiCmMjFjEjFgJiCkK_xHqqkZx_
 *			_xZkqqHx_iOjNiCmBiCmEiCkCiCoJiDhMiDeDiDjDiDgHiCmFiCkAiCoJiBeCiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMiDhMiDeDiDjDiDgHiCmN_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiClCiCmGiCmJiOjNiCmBiCmEiCkCiCoJjAjEiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJiBeBiKgFiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmNiBeBjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiCmCiClBiCmGiCkKiPgPjHiIiCoJiBeCiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx = 0 _xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID _xZkqqHx_iCmMjAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_ID _xZkqqHx_iCkK_xHqqkZx_ 1_xZkqqHx_iImIiPoDiCmM_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCmNiBeBiDiKiDjDiDeOiOjOiCmMjFoCiPjFjDeJiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCkK_xHqqkZx_ 0 _xZkqqHx_iClFiCkJjGlDiCkCiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCmNjGlDiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjChipMaster::GetMolipPos (long lMolipId, long lTerminalIdx) const
{
	if (lMolipId == -1)
	//----- -1_xZkqqHx_iDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return BASE_CLASS::GetMolipPos(lMolipId);
	} else
	//----- 0_xZkqqHx_iImIiPoDiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		DBLRect mmrt = GetDutyLink(lMolipId)->GetResizeFrame();
		return mmrt.CenterPoint();
	}
} // FCObjChipMaster::GetMolipPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetMolipCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmMjAjEiCmNiDeKiDeFiDjDiDgHiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjChipMaster::GetMolipCount () const
{
// 01.07.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_nvDutyLinkIndex.size();
	return m_lDutyLinkIndexSz;
} // FCObjChipMaster::GetMolipCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetMolipFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjDfPiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeBjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjApMiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeBiDhMiDiKiDfDiDjDiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCObjChipMaster::GetMolipFrame (long lMolipId) const
{
	if (lMolipId != -1)
	//----- _xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (IsLineMolip(lMolipId))
			return GetDutyLink(lMolipId)->GetResizeFrame();
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetMolipFrame(lMolipId);
} // FCObjChipMaster::GetMolipFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetMolipWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjDfPiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_0.0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjApMiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeBiDhMiDiKiDfDiDjDiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjChipMaster::GetMolipWeight (long lMolipId) const
{
	if (lMolipId != -1)
	//----- _xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (IsLineMolip(lMolipId))
			return GetDutyLink(lMolipId)->GetStdPenWeight();
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetMolipWeight(lMolipId);
} // FCObjChipMaster::GetMolipWeight.

//----- 01.10.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsThereCenterMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiCkKjHeMiMpIiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjChipMaster::IsThereCenterMolip () const
//{
//	//----- Link_xZkqqHx_jGpAiKiEjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmMiCnNjHeMiMpI_xHqqkZx_ -----
//	// Link_xZkqqHx_jGpAiKiEjFjEjFgJjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//	if (GetDutyLinkSize() == 0)
//		return TRUE;
//	else
//		return FALSE;
//} // FCObjChipMaster::IsThereCenterMolip.
//----- 01.10.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsLineMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiBeBiDiJiDeDiDjDiDiCiDiKiDhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDeDiDjDiDiCiDiKiDhGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CheckHitLineMolip _xZkqqHx_iKnGjAjEiCmGjIeBiMgHiClHiCoJiBeCiPeDjAlDiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_CheckHitLineMolip _xZkqqHx_iKnGjAjE_xHqqkZx_
 *			_xZkqqHx_iCmMiPeDjAlDiCpAjGfJiCoKiClIiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjChipMaster::IsLineMolip (long lMolipId) const
{
//----- 01.11.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (lMolipId == -1)
//	//----- -1_xZkqqHx_iDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//// 01.10.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		return BASE_CLASS::IsLineMolip(lMolipId);
//		return FALSE;
//	} else
//	//----- 0_xZkqqHx_iImIiPoDiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		return GetDutyLink(lMolipId)->IsLineMolip(-1);
//	}
//----- 01.11.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (lMolipId == -1)
	//----- -1_xZkqqHx_iDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (GetDutyLinkSize() == 0)
			return BASE_CLASS::IsLineMolip(lMolipId);
		else
			return FALSE;
	} else
	//----- 0_xZkqqHx_iImIiPoDiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return GetDutyLink(lMolipId)->IsLineMolip(-1);
	}
//----- 01.11.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::IsLineMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::NewLineMolipPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiJiDeDiDjDiDiCiDiKiDhGiCmMiBeBiDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lMolipId	:_xZkqqHx_iDiJiDeDiDjDiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::NewLineMolipPolygon (DBLPointVector& vmmptPoly,
										long lMolipId, mmetol mmElemLen,
										const DBLRect mmrtaClip[], int iClipSize) const
{
	ASSERT(IsLineMolip(lMolipId));
	if (lMolipId == -1)
	//----- -1_xZkqqHx_iDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		BASE_CLASS::NewLineMolipPolygon(vmmptPoly, lMolipId, mmElemLen,
											mmrtaClip, iClipSize);
	} else
	//----- 0_xZkqqHx_iImIiPoDiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		GetDutyLink(lMolipId)->NewLineMolipPolygon(vmmptPoly, -1, mmElemLen,
													mmrtaClip, iClipSize);
	}
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	GetDutyLink(lMolipId)->NewLineMolipPolygon(vmmptPoly, -1, mmElemLen,
//												mmrtaClip, iClipSize);
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::NewLineMolipPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsCloseLineMolipPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewLineMolipPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiJiDeDiDjDiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjChipMaster::IsCloseLineMolipPolygon (long lMolipId) const
{
	ASSERT(IsLineMolip(lMolipId));
	if (lMolipId == -1)
	//----- -1_xZkqqHx_iDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return BASE_CLASS::IsCloseLineMolipPolygon(lMolipId);
	} else
	//----- 0_xZkqqHx_iImIiPoDiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return GetDutyLink(lMolipId)->IsCloseLineMolipPolygon(-1);
	}
// 01.11.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	return GetDutyLink(lMolipId)->IsCloseLineMolipPolygon(-1);
} // FCObjChipMaster::IsCloseLineMolipPolygon.

//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsTextIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPoDiCmFiCmMiMpAiCoNiCoIiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jClCiCnHiCoJjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjChipMaster::IsTextIntersect (const DBLPoint& mmpt) const
//{
//	// Text_xZkqqHx_jGpAiKiEjFjEjFgJjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//	const short nIdxSize = GetDutyTextSize();
//	if (nIdxSize == 0)
//	//----- Text_xZkqqHx_jGpAiKiEjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		return FALSE;
//	} else
//	//----- Text_xZkqqHx_jGpAiKiEjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		for (short nIdx = 0; nIdx < nIdxSize; nIdx++)
//		{
//			if (GetDutyText(nIdx)->IsTextIntersect(mmpt)) return TRUE;
//		}
//	}
//	return FALSE;
//} // FCObjChipMaster::IsTextIntersect.
//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKiMpAiCoNiCmBiCmEiCkCiCoJjFjEjFgJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHitEditText	:_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_jEhHiMgJiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitCharIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsHitCharFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsCheckText	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiCkJiBeI_xHqqkZx_
 *			mmptMargin		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
 *							 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt			:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCpAjFnEiClHiBeCiMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmNiBeBiDgFiDeMiDfIiDgHiCpAjHeEjAoGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmNiBeBjEhHiMgJiCmJiDhBiDgCiDgHiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjChipMaster::GetIntersect (	BOOL& bIsHitEditText,
												long& lHitCharIndex,
												BOOL& bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//												BOOL bIsCheckText,
												const DBLPoint& mmptMargin,
												const DBLPoint& mmpt,
												BOOL bAsFillPaint) const
{
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Text_xZkqqHx_jGpAiKiEjFjEjFgJiBeC_xHqqkZx_
//	ObjDynabaseSet stDutyText;
//	if (bIsCheckText)
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDgAiDeGiDgCiDeOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// Text_xZkqqHx_jGpAiKiEjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
//		for (short nIdx = 0; nIdx != GetDutyTextSize(); nIdx++)
//			stDutyText.insert(GetDutyText(nIdx));
//	}
//	// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCkJiCoHjClCiCnHiCoJiClNiCnPiCmJiBeBiLhEiPiHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
//	FCObjDynabase* pObj = NULL;
//	long lObjIdx;
//	for (lObjIdx = m_lObjListSz - 1; 0 <= lObjIdx; lObjIdx--)
//	{
//		// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEiCmMjFjEjFgJiCmFiCkAiCoKiCmOiBeBiDgFiDeMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiLjGiJmCiBeC_xHqqkZx_
//		bIsCheckText = (stDutyText.find(m_pObjList[lObjIdx]) != stDutyText.end());
//		pObj = m_pObjList[lObjIdx]->GetIntersect(	bIsHitEditText,
//													lHitCharIndex,
//													bIsHitCharFront,
//													bIsCheckText,
//													mmptMargin,
//													mmpt,
//													bAsFillPaint);
//		if (pObj != NULL) break;
//	}
//	return pObj;
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Text_xZkqqHx_jGpAiKiEjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stDutyText;
	// Text_xZkqqHx_jGpAiKiEjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	for (short nIdx = 0; nIdx != GetDutyTextSize(); nIdx++)
		stDutyText.insert(GetDutyText(nIdx));
	// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCkJiCoHjClCiCnHiCoJiClNiCnPiCmJiBeBiLhEiPiHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
	FCObjDynabase* pObj = NULL;
	long lObjIdx;
	for (lObjIdx = GetMemberSize() - 1; 0 <= lObjIdx; lObjIdx--)
	{
		BOOL bIsHitTextTmp;
		pObj = GetMember(lObjIdx)->GetIntersect(bIsHitTextTmp,
												lHitCharIndex,
												bIsHitCharFront,
												mmptMargin,
												mmpt,
												bAsFillPaint);
		if (pObj != NULL)
		{
			// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEiCmMjFjEjFgJiCmFiCkAiCoKiCmOiBeBiDgFiDeMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiLjGiJmCiBeC_xHqqkZx_
			bIsHitEditText = (bIsHitTextTmp && (stDutyText.find(GetMember(lObjIdx)) != stDutyText.end()));
			break;
		}
	}
	return pObj;
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::GetIntersect.

//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetIntersectText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDeDiDjDiDgHiCkKiCmHiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitCharIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			bIsHitCharFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
// *							 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptMargin		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
// *							 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmpt			:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMargin_xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiBeBjAhNiMgAiCmMiKePiCmMiDeOiDiKiDgCiDeOiCoAiPeFiCkEiJmCjEfMjAkLiCkK_xHqqkZx_
// *			_xZkqqHx_iCkAiCoJiCmMiCmFiBeBjHfMiCnPjAhNiMgAjCiGiCmMiDeOiDiKiDgCiDeOiCkJjClCiCnHiCmEiCkJiCoHiOmAiNhDiClHiCnHiCkLiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCkCiClIiCoKiCkJiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiLnPjGfEiCmMjFlGiOjKiCpAjClCiCnHiBeBiCmHiClPiCoHiCmJ_xHqqkZx_
// *			_xZkqqHx_iCoGiCoIiLnPiCkCiCkJiCoAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCObjChipMaster::GetIntersectText (	long& lHitCharIndex,
//													BOOL& bIsHitCharFront,
//													const DBLPoint& mmptMargin,
//													const DBLPoint& mmpt) const
//{
//	// _xZkqqHx_jGhLjDjGiCmNjBePjGmKiCkJiCoHjClCiCnHiCoJiCnHiCkLiCmIiCmMiClOiCkKiBeB_xHqqkZx_GetDutyText()_xZkqqHx_iCmN_xHqqkZx_
//	// Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiNgMjHlGiClFiCmEiCkIiCoHiClIiBeBjDgPjIfOiPiHiCmJjFmAiCpBiCmFiCkCiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jBlFiCkGiCoJiCmMiCoAjGmKjDhMiCmIiCmMiCmFiBeBjDgPjIfOiPiHiCmJiMjPiNpFiClHiCoJiBeC_xHqqkZx_
//
//	// Text_xZkqqHx_jGpAiKiEjFjEjFgJjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//	const short nIdxSize = GetDutyTextSize();
//	FCObjDynabase* pObj = NULL;
//	for (short nIdx = 0; nIdx != nIdxSize; nIdx++)
//	{
//		pObj = GetDutyText(nIdx)->GetIntersectText(	lHitCharIndex,
//													bIsHitCharFront,
//													mmptMargin,
//													mmpt);
//		if (pObj != NULL) break;
//	}
//	return pObj;
//} // FCObjChipMaster::GetIntersectText.
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::IsLinkable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmJiDiKiDjDiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipID	:_xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			bLinkOut	:_xZkqqHx_iDiCiDiKiDhGiCkKiDiKiDjDiDeOiMlDiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeB_xHqqkZx_
 *						 _xZkqqHx_iDiKiDjDiDeOjAoGiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iDiKiDjDiDeOiJmCjEfM_xHqqkZx_
 *			FALSE	:_xZkqqHx_iDiKiDjDiDeOjFhDiJmCjEfM_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjChipMaster::IsLinkable (long lMolipID, BOOL bLinkOut) const
{
	if (lMolipID == -1)
	// _xZkqqHx_iBhMiCfAiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
	{
		return TRUE;
	} else
	// _xZkqqHx_iBhMiCfAiDiCiDiKiDhGiImIiKePiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
	{
		// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiCmNiDiKiDjDiDeOiJmCiBeBiDiKiDjDiDeOiDeDiDjDiCmNiDiKiDjDiDeOjFhDiJmCiBeC_xHqqkZx_
		return bLinkOut;
	}
} // FCObjChipMaster::IsLinkable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetUnlinkMarkPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGkCiDiKiDjDiDeOiCmMiDhNiBfLiDeOiCpAjFfMiOkGiClHiCoJiImKjChFiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmpt	:_xZkqqHx_iImKjChFiCpAjFnEiClHiBeCjCgMiCpAjCmHiJmBiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::GetUnlinkMarkPoint (DBLPointVector& vmmpt) const
{
	// _xZkqqHx_jGkCiDiKiDjDiDeOiDhNiBfLiDeOiCpAjFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!g_pReg->GetIsShowUnlinkMark())
		return;
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDiKiDjDiDeOiCmNjHeMiCoIjDlOiCmIiCkCiBeCiPfNiCmBiCmEjFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
	if (GetGroupParent() != NULL)
		return;
	long lMolipId;
	for (lMolipId = 0; lMolipId != GetDutyLinkSize(); lMolipId++)
	{
		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ lMolipId _xZkqqHx_iCpAiDhNiBfLiDeOiClHiCoJiCkJiBeI_xHqqkZx_
		BOOL bIsMark = FALSE;
		// _xZkqqHx_iBhFiDiKiDjDiDeOiDeDiDjDiCmMjGlDiCkCiClLiCmMjBlMiCpAiDhNiBfLiDeOiClHiCoJiCkJiBeIiBhG_xHqqkZx_
		if (GetDutyLink(lMolipId)->GetIsMarkUnlinkInTermO())
		{
			// _xZkqqHx_iClBiCmMiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJjBfDiCmEiCmMiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
			FCLinkRecPVector vAffected;
			g_pDoc->LinkManager()->GetAffectedByTo(vAffected, FCMolipRec(GetObjID(), lMolipId));
			// _xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
			if (vAffected.empty())
				bIsMark = TRUE;		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ lMolipId _xZkqqHx_iCpAiDhNiBfLiDeOiClHiCoJiCkJiBeI_xHqqkZx_
		}
		// _xZkqqHx_iBhFiDiKiDjDiDeOiDeBiDeFiDgHiCmMjGlDiCkCiClLiCmMjBlMiCpAiDhNiBfLiDeOiClHiCoJiCkJiBeIiBhG_xHqqkZx_
		if (!bIsMark && GetDutyLink(lMolipId)->GetIsMarkUnlinkOutTermO())
		{
			// _xZkqqHx_iClBiCmMiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJjBfDiCmEiCmMiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
			FCLinkRecPVector vAffected;
			g_pDoc->LinkManager()->GetAffectedByFrom(vAffected, FCMolipRec(GetObjID(), lMolipId));
			// _xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
			if (vAffected.empty())
				bIsMark = TRUE;		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ lMolipId _xZkqqHx_iCpAiDhNiBfLiDeOiClHiCoJiCkJiBeI_xHqqkZx_
		}
		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ lMolipId _xZkqqHx_iCpAiDhNiBfLiDeOiClHiCoJiCkJiBeI_xHqqkZx_
		if (bIsMark)
			vmmpt.push_back(GetMolipPos(lMolipId));
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::GetUnlinkMarkPoint(vmmpt);
} // FCObjChipMaster::GetUnlinkMarkPoint.

//----- 01.10.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::NearIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCkKjFjEjFgJiCmMiDhMiDiKiDfDiDjDiCmMiLnPjGfEiCmFiCkAiCoKiCmOiBeBiNmAjFfHjCgMiCpAiDhMiDiKiDfDiDjD_xHqqkZx_
// *			_xZkqqHx_iPoDiCmMjDeLjDjGiCmIiImKjChFiCmJjFmPiKlHiClHiCoJiBeCiClLiCkEiCmFiCmIiCkPiCoKiCmOiDfIiDgJiDgCiDhGjFmPiKlHiCpAiNhDiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_jFmPiKlHiMoDiCmMiNmAjFfHiCkKiDhMiDiKiDfDiDjDjDoAjFjEiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *			
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMov	:_xZkqqHx_iInKjDkOiNmAjFfH_xHqqkZx_._xZkqqHx_jFmPiKlHiMoDiCmMiNmAjFfHiCpAjFnEiClH_xHqqkZx_.
// *			mmptMsc	:_xZkqqHx_jFmPiKlHjBePiCmMiNmAjFfHiCpAiOhHjCoIiClHiCoJ_xHqqkZx_.
// *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiDhLiBfLiDgIiCmMiPoOjFpB_xHqqkZx_.
// *			mmptCnv	:mmptMsc_xZkqqHx_iCpA_xHqqkZx_View::LimitMP_xZkqqHx_iCmFjFmPiKlHiClFiClNiNmAjFfH_xHqqkZx_.
// *			mmlnAry	:_xZkqqHx_iInKjDkOiNmAjFfHiCkKiInKjDkOiCmFiCkLiCoJjClMjApMiCmMjEhKjHpB_xHqqkZx_.
// *			iArySz	:mmlnAry_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iInKjDkOiMoDiCmMiNmAjFfHiCkKjFjEjFgJiCmMjDoAjBkEiCmJiCkAiCoJiPoKiNiH_xHqqkZx_
// *			FALSE	:_xZkqqHx_iInKjDkOiMoDiCmMiNmAjFfHiCkKjFjEjFgJiCmMiKePjBkEiCmJiCkAiCoJiPoKiNiH_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeMiBfLiCmMiPpDjBnEiCpAjClCiCnHiBeBiDfGiDhEiDgHiDeMiBfLiBeFiDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCmMiPpDiLlFiCmJiJjOiClGiCmE_xHqqkZx_
// *			_xZkqqHx_iNmAjFfHiCmMjFmPiKlHiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
// *			FCLinkManager::GetHitOnMolip_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *			Link_xZkqqHx_jGpAiKiEiCkK_xHqqkZx_FDOJ_POINT _xZkqqHx_iCmMiPoKiNiHiBeBjDfP_xHqqkZx_Molip_xZkqqHx_iCmGiClFiCmEiDhBiDgCiDgHiClDiClJiClNiCkCiCmMiCmF_xHqqkZx_
// *			_xZkqqHx_iClBiClBiCmFiCmNiDhBiDgCiDgHiClDiClJiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjChipMaster::NearIntersect (DBLPoint& mmptMov, const DBLPoint& mmptMsc,
//									UINT nFlags, const DBLPoint& mmptCnv,
//									const DBLLine mmlnAry[], int iArySz)
//{
//	// Link_xZkqqHx_jGpAiKiEjFjEjFgJjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
//	const short nIdxSize = GetDutyLinkSize();
//	if (nIdxSize == 0)
//	//----- Link_xZkqqHx_jGpAiKiEjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		return BASE_CLASS::NearIntersect(mmptMov, mmptMsc, nFlags, mmptCnv,
//										mmlnAry, iArySz);
//	} else
//	//----- Link_xZkqqHx_jGpAiKiEjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		for (short nIdx = 0; nIdx < nIdxSize; nIdx++)
//		{
//			if (GetDutyLink(nIdx)->IsKindOf(FDOJ_POINT)) continue;
//			if (GetDutyLink(nIdx)->NearIntersect(mmptMov, mmptMsc, nFlags,
//										mmptCnv, mmlnAry, iArySz)) return TRUE;
//		}
//	}
//	return FALSE;
//} // FCObjChipMaster::NearIntersect.
//----- 01.10.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetEditableTextObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmFiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlDiClHiCoJiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmI_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMjFjEjFgJiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjChipMaster::GetEditableTextObj (const DBLPoint& mmpt) const
{
	const short nIdxSize = GetDutyTextSize();
	for (short nIdx = 0; nIdx < nIdxSize; nIdx++)
	{
// 05.06.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (GetDutyText(nIdx)->IsIntersect(mm2lg(mmpt))) return GetDutyText(nIdx);
		if (GetDutyText(nIdx)->IsIntersect(mmpt, FALSE)) return GetDutyText(nIdx);
	}
	return NULL;
} // FCObjChipMaster::GetEditableTextObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetCanBeTextObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmFiBeBiDgFiDeMiDfIiDgHiCmGiClFiCmEjHjIjHhAiJmCjEfMiCmIjFjEjFgJjBfDiCmEiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmJiCmNjFnCiPfHjFhDiJmCiBgJjGmKjAmPiCkKiCePiBgKiCmMiPoKiNiHiCoAjHeMiCoIiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::GetCanBeTextObject (ObjDynabaseVector& vObj) const
{
	for (short nIdx = 0; nIdx < GetDutyTextSize(); nIdx++)
		vObj.push_back(GetDutyText(nIdx));
} // FCObjChipMaster::GetCanBeTextObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetDutyLinkSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDiKiDjDiDeOiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAjE_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjChipMaster::GetDutyLinkSize () const
{
// 01.07.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return static_cast<short>(m_nvDutyLinkIndex.size());
	return static_cast<short>(m_lDutyLinkIndexSz);
} // FCObjChipMaster::GetDutyLinkSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetChipKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDCM_OBJECT_CHIP	= 1,	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
 *			FDCM_COMPOSITE_CHIP	= 2,	// _xZkqqHx_jFkBiNiHiDgAiDgCiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjChipMaster::GetChipKind () const
{
	return m_nChipKind;
} // FCObjChipMaster::GetChipKind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::SetChipKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nChipKind	:_xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						FDCM_OBJECT_CHIP	= 1,	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
 *						FDCM_COMPOSITE_CHIP	= 2,	// _xZkqqHx_jFkBiNiHiDgAiDgCiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::SetChipKind (short nChipKind)
{
	m_nChipKind = nChipKind;
} // FCObjChipMaster::SetChipKind.

//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetObjUserUlong
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDgAiDgCiDhGiClCiCmGiCmJiDiGiBfLiDfFiCkKiOkJjHfCiCmJjAnNjCoIiCmFiCkLiCoJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmFiDgAiDgCiDhGiCpAjBiAiNoMiClFiClNiCoIiClHiCoJjGnKjDeJiCmFiOgHjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DWORD FCObjChipMaster::GetObjUserUlong () const
//{
//	return m_dwObjUserUlong;
//} // FCObjChipMaster::GetObjUserUlong.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::SetObjUserUlong
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwObjUserUlong	:_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDgAiDgCiDhGiClCiCmGiCmJiDiGiBfLiDfFiCkKiOkJjHfCiCmJjAnNjCoIiCmFiCkLiCoJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmFiDgAiDgCiDhGiCpAjBiAiNoMiClFiClNiCoIiClHiCoJjGnKjDeJiCmFiOgHjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjChipMaster::SetObjUserUlong (DWORD dwObjUserUlong)
//{
//	m_dwObjUserUlong = dwObjUserUlong;
//} // FCObjChipMaster::SetObjUserUlong.
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetDutyLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDiKiDjDiDeOiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjChipMaster::GetDutyLink (short nIndex) const
{
	return GetMember(m_pDutyLinkIndex[nIndex]);
} // FCObjChipMaster::GetDutyLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::AppendDutyLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDiKiDjDiDeOiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::AppendDutyLink (FCObjDynabase* ojpLink)
{
	ObjDynabaseVector::iterator i;
	i = find(GetMemberArray(), GetMemberArray() + GetMemberSize(), ojpLink);
	if (i == GetMemberArray() + GetMemberSize()) return;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_nvDutyLinkIndex.push_back(static_cast<short>(i - GetMemberArray()));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	short* pNewDutyIndex = new short[m_lDutyLinkIndexSz + 1];
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmJiBeBiMmDiCkCjEhKjHpBiDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	memcpy(pNewDutyIndex, m_pDutyLinkIndex, sizeof(m_pDutyLinkIndex[0]) * m_lDutyLinkIndexSz);
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmMiNmFiMoDiCmJiBeBiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pNewDutyIndex[m_lDutyLinkIndexSz] = short(i - GetMemberArray());
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyLinkIndex != NULL)
	{
		delete[] m_pDutyLinkIndex;
		m_pDutyLinkIndex = NULL;
	}
	// _xZkqqHx_iKpJjBlGiCmMiDgGiBfLiDfOiCpAiNfIjAfGiBeC_xHqqkZx_
	m_pDutyLinkIndex = pNewDutyIndex;
	m_lDutyLinkIndexSz++;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::AppendDutyLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::ClearDutyLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDiKiDjDiDeOiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCmMiPfHiNiHiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::ClearDutyLink ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_nvDutyLinkIndex.clear();
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyLinkIndex != NULL)
	{
		delete[] m_pDutyLinkIndex;
		m_pDutyLinkIndex = NULL;
	}
	m_lDutyLinkIndexSz = 0;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::ClearDutyLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetDutyTextSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDgFiDeMiDfIiDgHiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAjE_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjChipMaster::GetDutyTextSize () const
{
// 01.07.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return static_cast<short>(m_nvDutyTextIndex.size());
	return static_cast<short>(m_lDutyTextIndexSz);
} // FCObjChipMaster::GetDutyTextSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::GetDutyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDgFiDeMiDfIiDgHiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjChipMaster::GetDutyText (short nIndex) const
{
// 01.07.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return GetMember(m_nvDutyTextIndex[nIndex]);
	return GetMember(m_pDutyTextIndex[nIndex]);
} // FCObjChipMaster::GetDutyText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::AppendDutyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDgFiDeMiDfIiDgHiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::AppendDutyText (FCObjDynabase* ojpText)
{
	ObjDynabaseVector::iterator i;
	i = find(GetMemberArray(), GetMemberArray() + GetMemberSize(), ojpText);
	if (i == GetMemberArray() + GetMemberSize()) return;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_nvDutyTextIndex.push_back(static_cast<short>(i - GetMemberArray()));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	short* pNewDutyIndex = new short[m_lDutyTextIndexSz + 1];
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmJiBeBiMmDiCkCjEhKjHpBiDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	memcpy(pNewDutyIndex, m_pDutyTextIndex, sizeof(m_pDutyTextIndex[0]) * m_lDutyTextIndexSz);
	// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmMiNmFiMoDiCmJiBeBiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pNewDutyIndex[m_lDutyTextIndexSz] = short(i - GetMemberArray());
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyTextIndex != NULL)
	{
		delete[] m_pDutyTextIndex;
		m_pDutyTextIndex = NULL;
	}
	// _xZkqqHx_iKpJjBlGiCmMiDgGiBfLiDfOiCpAiNfIjAfGiBeC_xHqqkZx_
	m_pDutyTextIndex = pNewDutyIndex;
	m_lDutyTextIndexSz++;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::AppendDutyText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::ClearDutyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGjCiGiCmFiDgFiDeMiDfIiDgHiCmMjGpAiKiEiCpAiJmKiClNiClHjFjEjFgJiCmMiPfHiNiHiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::ClearDutyText ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_nvDutyTextIndex.clear();
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (m_pDutyTextIndex != NULL)
	{
		delete[] m_pDutyTextIndex;
		m_pDutyTextIndex = NULL;
	}
	m_lDutyTextIndexSz = 0;
//----- 01.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjChipMaster::ClearDutyText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjChipMaster::CopySelf(pObj);
} // FCObjChipMaster::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjChipMaster::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjChipMaster::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjChipMaster::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	TRACE(	_T("%d %d\n"),
			sizeof(*this) - sizeof(BASE_CLASS),
			sizeof(m_nChipKind) +
			sizeof(m_lDutyLinkIndexSz) +
			sizeof(m_pDutyLinkIndex) +
			sizeof(m_lDutyTextIndexSz) +
			sizeof(m_pDutyTextIndex));

	ASSERT(	sizeof(*this) - sizeof(BASE_CLASS) ==
			sizeof(m_nChipKind) +
// 05.05.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//			sizeof(m_dwObjUserUlong) +
			sizeof(m_lDutyLinkIndexSz) +
			sizeof(m_pDutyLinkIndex) +
			sizeof(m_lDutyTextIndexSz) +
			sizeof(m_pDutyTextIndex) + 6);
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjChipMaster, m_nChipKind));

	FCObjChipMaster* pChip = reinterpret_cast<FCObjChipMaster*>(pObj);

	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	pChip->m_nChipKind = m_nChipKind;

//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	pChip->m_dwObjUserUlong = m_dwObjUserUlong;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (pChip->m_pDutyLinkIndex != NULL)
	{
		delete[] pChip->m_pDutyLinkIndex;
		pChip->m_pDutyLinkIndex = NULL;
	}
	// _xZkqqHx_jEhKjHpBjAjEiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	pChip->m_lDutyLinkIndexSz = m_lDutyLinkIndexSz;
	if (0 < m_lDutyLinkIndexSz)
	{
		pChip->m_pDutyLinkIndex = new short[m_lDutyLinkIndexSz];
		// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmJiBeBiMmDiCkCjEhKjHpBiDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		memcpy(pChip->m_pDutyLinkIndex, m_pDutyLinkIndex, sizeof(m_pDutyLinkIndex[0]) * m_lDutyLinkIndexSz);
	}

	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiDiKiDfIiDgHiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMiDiKiDfIiDgHiCpAiPmBiLiOiBeC_xHqqkZx_
	if (pChip->m_pDutyTextIndex != NULL)
	{
		delete[] pChip->m_pDutyTextIndex;
		pChip->m_pDutyTextIndex = NULL;
	}
	// _xZkqqHx_jEhKjHpBjAjEiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	pChip->m_lDutyTextIndexSz = m_lDutyTextIndexSz;
	if (0 < m_lDutyTextIndexSz)
	{
		pChip->m_pDutyTextIndex = new short[m_lDutyTextIndexSz];
		// _xZkqqHx_jAfGiClFiCkCjEhKjHpBiCmJiBeBiMmDiCkCjEhKjHpBiDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		memcpy(pChip->m_pDutyTextIndex, m_pDutyTextIndex, sizeof(m_pDutyTextIndex[0]) * m_lDutyTextIndexSz);
	}
} // FCObjChipMaster::CopySelf.
