#include "stdafx.h"
#include "resource.h"	// For ProObjRect.h.
#include "ProObjRect.h"	// For CFCProObjRect.
#include "UtilMisc.h"		// For ArcTan.
#include "UtilRect.h"	// For GetRectPolygon.
#include "UtilMath.h"	// For mmroundoff.
// 06.12.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilBezier.h"	// For FFGetStdElemLen.
#include <math.h>		// For sin,cos.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "RichText.h"	// For GetRichText().
#include "Env.h"		// For FD_S_COLOR_TRANSPARENT.
#include "ObjRect.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::FCObjRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCFoundDoc_xZkqqHx_iCmM_xHqqkZx_Stream_xZkqqHx_jDmHiCnNiNjOiCnNiOjOiCmJiBeB_xHqqkZx_FCObjRect_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjRect::FCObjRect ()
{
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjRect, m_mmrtResize));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmrtResize, 0, sizeof(FCObjRect) - offsetof(FCObjRect, m_mmrtResize));

	m_mmHAxisX	= mmroundoff(30.0);				// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	m_mmVAxisX	= mmroundoff(0.0);				// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkKiBeC_xHqqkZx_
	m_mmVAxisY	= mmroundoff(30.0);				// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkKiBeC_xHqqkZx_
	m_mmptCenter= mmroundoff(DBLPoint(30,30));	// _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
	m_dAngle	= mmroundoff(0.0);				// _xZkqqHx_jAhNiMgAiCmMiJpBjDfNiKhAjDhIiBeC_xHqqkZx_
} // FCObjRect::FCObjRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_RECT) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjRect::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjRect::Type () const
{
	return FDOJ_RECT;
} // FCObjRect::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjRect::GetResizeFrame () const
{
	return m_mmrtResize;
} // FCObjRect::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjRect* trgp = static_cast<const FCObjRect*>(objp);
	return (memcmp(&m_mmrtResize, &trgp->m_mmrtResize,
				sizeof(FCObjRect) - offsetof(FCObjRect, m_mmrtResize)) == 0);
} // FCObjRect::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjRect::OutStream (FCUndoArchive& ar)
void FCObjRect::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	ar << m_mmHAxisX;		// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmMjBoFiCkLiClD_xHqqkZx_.
	ar << m_mmVAxisX;		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkK_xHqqkZx_.
	ar << m_mmVAxisY;		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkK_xHqqkZx_.
	ar << m_mmptCenter;		// _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmMiNmAjFfH_xHqqkZx_.
	ar << m_dAngle;			// _xZkqqHx_jAhNiMgAiCmMiJpBjDfNiKhAjDhIiBeC_xHqqkZx_
} // FCObjRect::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjRect::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	ar >> m_mmHAxisX;		// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmMjBoFiCkLiClD_xHqqkZx_.
	ar >> m_mmVAxisX;		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkK_xHqqkZx_.
	ar >> m_mmVAxisY;		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkK_xHqqkZx_.
	ar >> m_mmptCenter;		// _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmMiNmAjFfH_xHqqkZx_.
	ar >> m_dAngle;			// _xZkqqHx_jAhNiMgAiCmMiJpBjDfNiKhAjDhIiBeC_xHqqkZx_
} // FCObjRect::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *************************************************************************/
void FCObjRect::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_RECT)) return;
	vPropPage.push_back(new CFCProObjRect());
} // FCObjRect::CreatePropertyPage.

//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::IsClosePolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjRect::IsClosePolygon () const
//{
//	return TRUE;
//} // FCObjRect::IsClosePolygon.
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *************************************************************************/
void FCObjRect::NewObjPolygonForDraw (DBLPointVector& vmmptPoly,
								mmetol mmElemLen,
								const DBLRect mmrtaClip[], int iClipSize) const
{
	FFGetRectPolygon(vmmptPoly,
					m_mmptCenter,
					m_mmHAxisX,
					m_mmVAxisY,
					m_mmVAxisX,
					m_dAngle,
					m_mmptCenter);
} // FCObjRect::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRect::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	FFGetRectBezier(polyBezier,
					m_mmptCenter,
					m_mmHAxisX,
					m_mmVAxisY,
					m_mmVAxisX,
					m_dAngle,
					m_mmptCenter);
} // FCObjRect::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::GetMolipPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMiNmAjFfHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iOoGjDlOiClHiCoJ_xHqqkZx_MOLIP_xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			lTerminalIdx:MOLIP_xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MOLIP_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmNiBeBjFjEjFgJiCmMjCiGjAfDiNmAjFfHiCpAiOkGiClFiBeBjBfDiCmEiCmMjFjEjFgJiCkK_xHqqkZx_
 *			_xZkqqHx_iOjNiCmBiCmEiCkCiCoJiDhMiDeDiDjDiDgHiCmFiCkAiCoJiBeCiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMiDhMiDeDiDjDiDgHiCmN_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiClCiCmGiCmJiOjNiCmBiCmEiCkCiCoJjAjEiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJiBeBiKgFiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmNiBeBjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiCmCiClBiCmGiCkKiPgPjHiIiCoJiBeCiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx = 0 _xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID _xZkqqHx_iCmMjAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_ID _xZkqqHx_iCkK_xHqqkZx_ 1_xZkqqHx_iImIiPoDiCmM_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCmNiBeBiDiKiDjDiDeOiOjOiCmMjFoCiPjFjDeJiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCkK_xHqqkZx_ 0 _xZkqqHx_iClFiCkJjGlDiCkCiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCmNjGlDiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjRect::GetMolipPos (long lMolipID, long lTerminalIdx) const
{
	DBLPoint mmpt;
	switch (lMolipID)
	{
	case 0:		// _xZkqqHx_iPoDjFjEjCiGiKnEjDfPiBeC_xHqqkZx_
	  {
		const double dSinR = sin(GetAngle() * M_PI);
		const double dCosR = cos(GetAngle() * M_PI);
		mmpt.SetPoint(GetCenterX(), GetCenterY() + GetVAxisY());
		::ShiftConv(mmpt, GetVAxisY(), GetVAxisX(), GetCenterY());
		::RotateConv(mmpt, dSinR, dCosR, GetCenterX(), GetCenterY());
		mmpt = 2 * DBLPoint(GetCenterX(), GetCenterY()) - mmpt;
		break;
	  }
	case 1:		// _xZkqqHx_iJlKjFjEjCiGiKnEjDfPiBeC_xHqqkZx_
	  {
		const double dSinR = sin(GetAngle() * M_PI);
		const double dCosR = cos(GetAngle() * M_PI);
		mmpt.SetPoint(GetCenterX(), GetCenterY() + GetVAxisY());
		::ShiftConv(mmpt, GetVAxisY(), GetVAxisX(), GetCenterY());
		::RotateConv(mmpt, dSinR, dCosR, GetCenterX(), GetCenterY());
		break;
	  }
	case 2:		// _xZkqqHx_iNlGjFjEjCiGiKnEjDfPiBeC_xHqqkZx_
	  {
		const double dSinR = sin(GetAngle() * M_PI);
		const double dCosR = cos(GetAngle() * M_PI);
		mmpt.SetPoint(GetCenterX() + GetHAxisX(), GetCenterY());
		::ShiftConv(mmpt, GetVAxisY(), GetVAxisX(), GetCenterY());
		::RotateConv(mmpt, dSinR, dCosR, GetCenterX(), GetCenterY());
		mmpt = 2 * DBLPoint(GetCenterX(), GetCenterY()) - mmpt;
		break;
	  }
	case 3:		// _xZkqqHx_iJeFjFjEjCiGiKnEjDfPiBeC_xHqqkZx_
	  {
		const double dSinR = sin(GetAngle() * M_PI);
		const double dCosR = cos(GetAngle() * M_PI);
		mmpt.SetPoint(GetCenterX() + GetHAxisX(), GetCenterY());
		::ShiftConv(mmpt, GetVAxisY(), GetVAxisX(), GetCenterY());
		::RotateConv(mmpt, dSinR, dCosR, GetCenterX(), GetCenterY());
		break;
	  }
	default:	// case -1:	_xZkqqHx_jCiGjAfDiDiCiDiKiDhGiBeC_xHqqkZx_
		mmpt = BASE_CLASS::GetMolipPos(lMolipID, lTerminalIdx);
	}
	return mmpt;
} // FCObjRect::GetMolipPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::GetMolipCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmMjAjEiCmNiDeKiDeFiDjDiDgHiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjRect::GetMolipCount () const
{
	return 4;
} // FCObjRect::GetMolipCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::IsLinkable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmJiDiKiDjDiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipID	:_xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			bLinkOut	:_xZkqqHx_iDiCiDiKiDhGiCkKiDiKiDjDiDeOiMlDiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeB_xHqqkZx_
 *						 _xZkqqHx_iDiKiDjDiDeOjAoGiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iDiKiDjDiDeOiJmCjEfM_xHqqkZx_
 *			FALSE	:_xZkqqHx_iDiKiDjDiDeOjFhDiJmCjEfM_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::IsLinkable (long lMolipID, BOOL bLinkOut) const
{
	if (lMolipID == -1)
	// _xZkqqHx_iBhMiCfAiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
	{
// 01.11.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return TRUE;
		return BASE_CLASS::IsLinkable(lMolipID, bLinkOut);
	} else
	// -1 _xZkqqHx_iImIiKePiCmMiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
	{
		// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiCmNiDiKiDjDiDeOiJmCiBeBiDiKiDjDiDeOiDeDiDjDiCmNiDiKiDjDiDeOjFhDiJmCiBeC_xHqqkZx_
		return bLinkOut;
	}
} // FCObjRect::IsLinkable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CanRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiJpBjDfNiKhAiCpAjAnNjCoIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::CanRotate () const
{
	return TRUE;
} // FCObjRect::CanRotate.

//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjRect::CalcResizeFrameSelf ()
//{
//	DBLPointVector vmmptPoint;
//	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//// 05.03.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	NewObjPolygon(vmmptPoint, FFGetStdElemLen(), NULL, 0);
//	NewObjPolygonForResize(vmmptPoint, FFGetStdElemLen(), NULL, 0);
//	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJ_xHqqkZx_.
//	::FFCalcFrame(m_mmrtResize, vmmptPoint.size(), vmmptPoint.begin());
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
////	if (GetRichText() != NULL)
////	{
////		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
////		GetRichText()->CalcTextLayout(NULL, this);
////	}
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CalcResizeFrameSelf();
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCObjRect::CalcResizeFrameSelf.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CalcResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRect::CalcResizeFrame ()
{
	TRACE(_T("FCObjRect::CalcResizeFrame\n"));

	DBLPointVector vmmptPoint;
	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	NewObjPolygonForResize(vmmptPoint, FFGetStdElemLen(), NULL, 0);
	NewObjPolygonForResize(vmmptPoint, -1, NULL, 0);
	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJ_xHqqkZx_.
	::FFCalcFrame(m_mmrtResize, vmmptPoint.size(), vmmptPoint.begin());
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CalcResizeFrame();
} // FCObjRect::CalcResizeFrame.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

angle FCObjRect::GetAngle () const
{
	return m_dAngle;
} // FCObjRect::GetAngle.

mmetol FCObjRect::GetHAxisX () const
{
	return m_mmHAxisX;
} // FCObjRect::GetHAxisX.

mmetol FCObjRect::GetVAxisX () const
{
	return m_mmVAxisX;
} // FCObjRect::GetVAxisX.

mmetol FCObjRect::GetVAxisY () const
{
	return m_mmVAxisY;
} // FCObjRect::GetVAxisY

// GetCenter_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCmMiCnNiOoGjDlOiBeC_xHqqkZx_PrpObjRect_xZkqqHx_iCmMiInHiBeC_xHqqkZx_
mmetol FCObjRect::GetCenterX () const
{
	return m_mmptCenter.x;
} // FCObjRect::GetCenterX.

// GetCenter_xZkqqHx_iCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiCmMiCnNiOoGjDlOiBeC_xHqqkZx_PrpObjRect_xZkqqHx_iCmMiInHiBeC_xHqqkZx_
mmetol FCObjRect::GetCenterY () const
{
	return m_mmptCenter.y;
} // FCObjRect::GetCenterY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CreateEMFObjRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EMF_xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDfMiCoIjFhEiCkPiCoJiClNiCnPiCmMiLoJiMgAjFjEjFgJiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrt	:_xZkqqHx_jFjEjFgJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			emid	:_xZkqqHx_iDeDiDiBiBfLiDfH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCFoundDoc::OnPasteSpec_xZkqqHx_iCmFiOgHjHhAiBeC_xHqqkZx_CFCFoundDoc_xZkqqHx_jCiGiCmFjFjEjFgJiCmM_xHqqkZx_
 *			protected_xZkqqHx_iCmIiKnGjAjEiCmMiMmEiCnBiPgPiClFiCpAjEpAiCkPiCoJiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjRect* FCObjRect::CreateEMFObjRect (const DBLRect& mmrt, EmfImageID emid)
{
	FCObjRect* pObj = new FCObjRect;
	pObj->CalcResizeFrame();
	pObj->Resize(TRUE, TRUE, mmrt, pObj->GetResizeFrame());
	// _xZkqqHx_jApMiCmNjDkHjGlOiCmJiClHiCoJiBeCjDfMiCoIjFhEiCkPiClNiDeDiDiBiBfLiDfHiCmMiCnNiMkJiCkGiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	pObj->SetPenBackSColor(FD_S_COLOR_TRANSPARENT);
	// _xZkqqHx_jEhHiMgJiCmNjEjCiCmFjDgIiCoIiCmCiCnEiClHiBeCiDhNiDeFiDfIiDeOiDiKiDgCiDeOiCmFjBeJjBpAiCmFiCkLiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	pObj->SetBrushBackSColor(FD_S_COLOR_WHITE);
	pObj->SetEmfImage(emid);
	return pObj;
} // FCObjRect::CreateEMFObjRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRect::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjRect::CopySelf(pObj);
} // FCObjRect::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRect::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjRect::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_mmetol_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjRect, m_mmrtResize));
	FCObjRect* pRect = reinterpret_cast<FCObjRect*>(pObj);
	memcpy(&pRect->m_mmrtResize, &m_mmrtResize,
			sizeof(FCObjRect) - offsetof(FCObjRect, m_mmrtResize));
} // FCObjRect::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *************************************************************************/
void FCObjRect::Move (mmetol mmDX, mmetol mmDY)
{
	m_mmptCenter.x	+= mmDX;
	m_mmptCenter.y	+= mmDY;
	m_mmrtResize += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjRect::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmNiBeBiDfEiDeDiDfJiCkKiCmIiCoJiCnHiCkNjAlDiKgNiCmJ_xHqqkZx_mmrtNew_xZkqqHx_iCmJiCmIiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P223,P224,P225
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.02 Fukushiro M. _xZkqqHx_iLkEjCmKiCmMiDiKiDfEiDeDiDfJiKnGjAjEiCpAjDlBjDpMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjRect::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	DBLPoint mmptOrig(mmrtOld.left, mmrtOld.top);
	DBLPoint dptMagnif;
	DBLPoint mmptOrigNew;	// _xZkqqHx_iDiKiDfEiDeDiDfJjEoEjHkGiBeC_xHqqkZx_
	//----- _xZkqqHx_iDiKiDfEiDeDiDfJjEoEjHkGiCpAiMhGiOfK_xHqqkZx_ -----
	if (bXPosi)
	{
		if (!almost0(mmrtOld.Width()))
			dptMagnif.x = mmrtNew.Width() / mmrtOld.Width();
		else
			dptMagnif.x = 1.0;
		mmptOrigNew.x = mmrtNew.left;
	} else
	{
		if (!almost0(mmrtOld.Width()))
			dptMagnif.x = -mmrtNew.Width() / mmrtOld.Width();
		else
			dptMagnif.x = -1.0;
		mmptOrigNew.x = mmrtNew.right;
	}
	if (bYPosi)
	{
		if (!almost0(mmrtOld.Height()))
			dptMagnif.y = mmrtNew.Height() / mmrtOld.Height();
		else
			dptMagnif.y = 1.0;
		mmptOrigNew.y = mmrtNew.top;
	} else
	{
		if (!almost0(mmrtOld.Height()))
			dptMagnif.y = -mmrtNew.Height() / mmrtOld.Height();
		else
			dptMagnif.y = -1.0;
		mmptOrigNew.y = mmrtNew.bottom;
	}
	// _xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJiImIiKePiCpAiDiKiDfEiDeDiDfJiPiIjHjNiBeC_xHqqkZx_
	ResizeNoChangeFrame(mmptOrig, dptMagnif, mmptOrigNew);
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmrtResize = mmrtNew;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
}	// FCObjRect::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		: _xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmCX	: _xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmCX	: _xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *************************************************************************/
// 05.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjRect::Rotate (double dR, mmetol mmCX, mmetol mmCY)
void FCObjRect::Rotate (double dR, const DBLPoint& mmptCenter)
{
	//----- _xZkqqHx_iJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgP_xHqqkZx_ -----
	double	dSinR = sin(dR * M_PI);
	double	dCosR = cos(dR * M_PI);

	double	dRadX	= m_mmptCenter.x - mmptCenter.x;
	double	dRadY	= m_mmptCenter.y - mmptCenter.y;

	m_mmptCenter.x = mmptCenter.x + dCosR * dRadX - dSinR * dRadY;
	m_mmptCenter.y = mmptCenter.y + dSinR * dRadX + dCosR * dRadY;

	// _xZkqqHx_iKhAjDhIiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
	m_dAngle = ::RegulateAngle(m_dAngle + dR);

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Rotate(dR, mmptCenter);
} // FCObjRect::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::ResizeNoChangeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Resize_xZkqqHx_jHhAiDfEiDhFiKnGjAjEiBeCjDpBiCmCiCmM_xHqqkZx_Resize_xZkqqHx_iKnGjAjEiCkJiCoHiLkEjCmKiCmFiOgHiCkEiClNiCnPiCmJiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiPiIjHjNiCpAiNhDiCkEiCkKiBeB_xHqqkZx_m_mmrtResize_xZkqqHx_jFmPjAjEiCmMjFmPiNfIiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptOrig	:_xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMlEjDfP_xHqqkZx_
 *			dptMagnif	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMjEoEjHkG_xHqqkZx_
 *			mmptOrigNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiMlEjDfP_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJpBjDfNiKhAiCmJiKoOiCmDiCkLiBeBjAiFjFlNiOlCiBeFjAiCjClMiOlCiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHjCgMiCpAiDiKiDfEiDeDiDfJiPiIjHjNiClFiBeBiDiKiDfEiDeDiDfJiMoDiCmMiJpBjDfNiKhAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJjAiFjFlNiOlCiBeFjAiCjClMiOlCiCmMiNmAjFfHjCgMiCpAiLhEiJpBjDfNiClHiCoJiClBiCmGiCmFiBeBiDiKiDfEiDeDiDfJiMoDiCmM_xHqqkZx_
 *			_xZkqqHx_jAiFjFlNiOlCiBeFjAiCjClMiOlCiCmMjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P223,P224,P225
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FCObjRect_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFiBeBiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRect::ResizeNoChangeFrame (const DBLPoint& mmptOrig,
									const DBLPoint& dptMagnif,
									const DBLPoint& mmptOrigNew)
{
	// _xZkqqHx_jCiGjAfDjDfPiCmMiNmAjFfHiCpAiKgHiPgLjEoEiCmJiKoOiCmDiCkCiCmEjFmPiKlHiBeC_xHqqkZx_
	m_mmptCenter = dptMagnif * (m_mmptCenter - mmptOrig) + mmptOrigNew;

	// _xZkqqHx_jHfNjFkKiCmIiMhGiOfKiCpAjEpAiCkPiCoJiInHiBeBiJpBjDfNiKhAiCkKiCePiCmMiPoKiNiHiCpAiLoGjFmKiBeC_xHqqkZx_
	if (m_dAngle == 0.0)
	//----- _xZkqqHx_iJpBjDfNiKhAiCkKiCePiCmMiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	{
		m_mmHAxisX *= dptMagnif.x;	// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkKiBeC_xHqqkZx_
		m_mmVAxisX *= dptMagnif.x;	// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkKiBeC_xHqqkZx_
		m_mmVAxisY *= dptMagnif.y;	// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkKiBeC_xHqqkZx_
		if (m_mmHAxisX < 0)
		//----- _xZkqqHx_jAiFjFlNiOlCiCkKjFiJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// 180_xZkqqHx_jDhIiJpBjDfNiClFiClNiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
			m_dAngle = 1.0;
			// _xZkqqHx_iKgFiOlCiCpA_xHqqkZx_180_xZkqqHx_jDhIiJpBjDfNiPiIjHjNiBeC_xHqqkZx_
			m_mmHAxisX = -m_mmHAxisX;
			m_mmVAxisX = -m_mmVAxisX;
			m_mmVAxisY = -m_mmVAxisY;
		}
		if (m_mmVAxisY < 0)
		//----- _xZkqqHx_jAiCjClMiOlCiCkKjFiJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jAiCjClMiOlCiCpA_xHqqkZx_180_xZkqqHx_jDhIiJpBjDfNiPiIjHjNiBeC_xHqqkZx_
			m_mmVAxisY = -m_mmVAxisY;
			m_mmVAxisX = -m_mmVAxisX;
		}
	} else
	//----- _xZkqqHx_iJpBjDfNiKhAiCkKiCePiCmFiCmNiCmIiCkCiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	{
		/*----- _xZkqqHx_iMlLiNnNiCmMiJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgP_xHqqkZx_ -----*/
		double dSinR = sin(m_dAngle * M_PI);
		double dCosR = cos(m_dAngle * M_PI);
		/*----- _xZkqqHx_iJpBjDfNiBeFiDiKiDfEiDeDiDfJiMoDiCmMjAiFjFlNiOlCiCmMjDfPiCpAiOfKiPgP_xHqqkZx_ -----*/
		mmetol mmHAxisX = dptMagnif.x * dCosR * m_mmHAxisX;
		mmetol mmHAxisY = dptMagnif.y * dSinR * m_mmHAxisX;
		/*----- _xZkqqHx_iJpBjDfNiBeFiDiKiDfEiDeDiDfJiMoDiCmMjAiCjClMiOlCiCmMjDfPiCpAiOfKiPgP_xHqqkZx_ -----*/
		mmetol mmVAxisX = dptMagnif.x * (dCosR * m_mmVAxisX - dSinR * m_mmVAxisY);
		mmetol mmVAxisY = dptMagnif.y * (dSinR * m_mmVAxisX + dCosR * m_mmVAxisY);
		// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiJpBjDfNiKhAiCpAiMhGiOfKiBeC_xHqqkZx_
		m_dAngle	= ::ArcTan(mmHAxisX, mmHAxisY);
		/*----- _xZkqqHx_jAiFjFlNiOlCiBeFjAiCjClMiOlCiCpAiBeBiLhEiJpBjDfNiClFiCmEiOfKiPgPiClHiCoJ_xHqqkZx_ -----*/
		dSinR = sin(-m_dAngle * M_PI);
		dCosR = cos(-m_dAngle * M_PI);
		m_mmHAxisX	= dCosR * mmHAxisX - dSinR * mmHAxisY;
		m_mmVAxisX	= dCosR * mmVAxisX - dSinR * mmVAxisY;
		m_mmVAxisY	= dSinR * mmVAxisX + dCosR * mmVAxisY;
		/*----- _xZkqqHx_jAiCjClMiOlCiCkKjFiJiCmMiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----*/
		if (m_mmVAxisY < 0)
		{
			m_mmVAxisY = -m_mmVAxisY;
			m_mmVAxisX = -m_mmVAxisX;
		}
	}
} // FCObjRect::ResizeNoChangeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetHAxisX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAjCiGjAfDjDfPiCpAiMlEjDfPiCmGiClFiClNiOjOiCmMjAiFjFlNiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkKiBgJjClHiClDiBgKiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmHAxisX	: _xZkqqHx_jAiFjFlNiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetHAxisX (mmetol mmHAxisX)
{
	if (m_mmHAxisX == mmHAxisX) return FALSE;
	if (mmHAxisX == 0.0) return FALSE;
	m_mmHAxisX = mmHAxisX;
	return TRUE;
} // FCObjRect::SetHAxisX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetVAxisX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAjCiGjAfDjDfPiCpAiMlEjDfPiCmGiClFiClNiOjOiCmMjAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkKiBgJjClHiClDiBgKiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmVAxisX	: _xZkqqHx_jAiCjClMiOlCiCmM_xHqqkZx_X_xZkqqHx_jAkMjFkK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetVAxisX (mmetol mmVAxisX)
{
	if (m_mmVAxisX == mmVAxisX) return FALSE;
	m_mmVAxisX = mmVAxisX;
	return TRUE;
} // FCObjRect::SetVAxisX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetVAxisY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAjCiGjAfDjDfPiCpAiMlEjDfPiCmGiClFiClNiOjOiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkKiBgJjClHiClDiBgKiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmVAxisY	: _xZkqqHx_jAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetVAxisY (mmetol mmVAxisY)
{
	if (m_mmVAxisY == mmVAxisY) return FALSE;
	if (mmVAxisY == 0.0) return FALSE;
	m_mmVAxisY = mmVAxisY;
	return TRUE;
} // FCObjRect::SetVAxisY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiJpBjDfNiKhAjDhIiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dAngle	: _xZkqqHx_jAhNiMgAiCmMiJpBjDfNiKhAjDhI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.28 Fukushiro M. RichText_xZkqqHx_iCmM_xHqqkZx_SetAngle_xZkqqHx_iCmJjBmOiJjOiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetAngle (angle dAngle)
{
	if (m_dAngle == dAngle) return FALSE;
	Rotate(dAngle - m_dAngle, m_mmptCenter);
	return TRUE;
} // FCObjRect::SetAngle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetCenterX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Center_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCmMiCnNjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX	:Center_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. BOOL_xZkqqHx_iMfOiCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetCenterX (mmetol mmX)
{
	if (m_mmptCenter.x == mmX) return FALSE;
	m_mmptCenter.x = mmX;
	return TRUE;
} // FCObjRect::SetCenterX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRect::SetCenterY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Center_xZkqqHx_iCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiCmMiCnNjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmY	:Center_xZkqqHx_iCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. BOOL_xZkqqHx_iMfOiCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjRect::SetCenterY (mmetol mmY)
{
	if (m_mmptCenter.y == mmY) return FALSE;
	m_mmptCenter.y = mmY;
	return TRUE;
} // FCObjRect::SetCenterY.

