#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "resource.h"		// For ProObjTextRect.h.
#include "UtilMisc.h"		// For ArcTan.
#include "UtilRect.h"		// For GetRectPolygon.
#include "UtilMath.h"		// For mmroundoff.
#include "UtilBezier.h"		// For FCMmPolyBezier.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "RichText.h"		// For GetRichText().
#include "Env.h"			// For FD_S_COLOR_TRANSPARENT.
#include "ObjTextRect.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::FCObjTextRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCFoundDoc_xZkqqHx_iCmM_xHqqkZx_Stream_xZkqqHx_jDmHiCnNiNjOiCnNiOjOiCmJiBeB_xHqqkZx_FCObjTextRect_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjTextRect::FCObjTextRect ()
{
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjTextRect, m_mmrtResize));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmrtResize, 0, sizeof(FCObjTextRect) - offsetof(FCObjTextRect, m_mmrtResize));
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	m_mmrtResize = mmroundoff(DBLRect(0.0, 0.0, 30.0, 30.0));

//----- 05.06.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjNiCmMiNmFiPkMjCgMiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmMinWidth = DBL_MAX;
	// _xZkqqHx_jFjNiCmMiNmFjBoFjCgMiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmMaxWidth = -DBL_MAX;
	// _xZkqqHx_iNiCiClDiCmMiNmFiPkMjCgMiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmMinHeight = DBL_MAX;
	// _xZkqqHx_iNiCiClDiCmMiNmFjBoFjCgMiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmMaxHeight = -DBL_MAX;
//----- 05.06.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


	// _xZkqqHx_jFfMjFjEjFgJiCmMiDfKiDiLiCmGiClFiCmEiOgHiCkEiCmMiCmFiBeBiPiJiKpKiJlLiOjOiCmNjHnGiKhDjApMiCpAjGlDiClFiCmJiBeC_xHqqkZx_
	m_pridPenRegister		= FD_PEN_REGISTER_UNUSE;
	m_psidPenStyle			= FD_PEN_STYLE_UNUSE;
	m_mmfPenWeight			= mmroundoff(0.0);
	m_scidPenBackSColor		= FD_S_COLOR_UNUSE;
	// _xZkqqHx_iDhFiDiJiDfGiCmNjEjCiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeC_xHqqkZx_
	m_bridBrushRegister		= FD_BRUSH_REGISTER_UNUSE;
	m_scidBrushForeSColor	= FD_S_COLOR_UNUSE;
	m_ptidBrushPattern		= FD_PATTERN_UNUSE;
	m_scidBrushBackSColor	= FD_S_COLOR_WHITE;
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiNoMjAkMiBeCjFfMjFjEjFgJiCmMiDfKiDiLiCmGiClFiCmEiOgHiCoNiCoKiCoJiClNiCnPiBeB_xHqqkZx_
//	// _xZkqqHx_iNmFiPiJiCkJiCoHiDgFiDeMiDfIiDgHiCkKjFeLjAhLiBeCiBgJiClLiCkEiClFiCmIiCkCiCmGjBkOjAkLiCkKjAnNjCoIiCmFiCkLiCmIiCkCiBgK_xHqqkZx_
//	m_pRichText = CreateRichText();
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCObjTextRect::FCObjTextRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTextRect::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_TEXT_RECT) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjTextRect::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjTextRect::Type () const
{
	return FDOJ_TEXT_RECT;
} // FCObjTextRect::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCObjTextRect::GetResizeFrame () const
{
	return m_mmrtResize;
} // FCObjTextRect::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTextRect::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjTextRect* trgp = static_cast<const FCObjTextRect*>(objp);
	return (memcmp(&m_mmrtResize, &trgp->m_mmrtResize,
				sizeof(FCObjTextRect) - offsetof(FCObjTextRect, m_mmrtResize)) == 0);
} // FCObjTextRect::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjTextRect::OutStream (FCUndoArchive& ar)
void FCObjTextRect::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
} // FCObjTextRect::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
} // FCObjTextRect::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[], int iClipSize) const
{
	vmmptPoly.resize(5);
	GetResizeFrame().Get5Polygon(vmmptPoly.begin());
} // FCObjTextRect::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	polyBezier.assign(13);
	GetResizeFrame().Get5Bezier(&polyBezier.front());
} // FCObjTextRect::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetStdPenStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)_xZkqqHx_iBhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiDhJiDjDiCmMjBkOjAkLiCpAjFnEiClHiBeCjDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjDgPjIfOiDhJiDjDiCmM_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiPoOjFpBiCpAjClCiCnHiCmEjFfMiOkGiCmJiOgHiCoNiCoKiCoJjBkOjAkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
PenStyleID FCObjTextRect::GetStdPenStyle () const
{
	// _xZkqqHx_iDhJiDjDiCmNiPoNiCmJjDkHjGlOiBeC_xHqqkZx_
	return FD_PEN_STYLE_UNUSE;
} // FCObjTextRect::GetStdPenStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetStdPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhJiDjDiCmMjFjNiBhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMjFjN_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiDhJiDjDiCmMjBkOjAkLiCpAjFnEiClHiBeCjDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjDgPjIfOiDhJiDjDiCmM_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiPoOjFpBiCpAjClCiCnHiCmEjFfMiOkGiCmJiOgHiCoNiCoKiCoJjBkOjAkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
fmmetol FCObjTextRect::GetStdPenWeight () const
{
	return 0.0;
} // FCObjTextRect::GetStdPenWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetStdPenBackSColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhJiDjDiCmMjEhHiMgJjAeGiBhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeG_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiDhJiDjDiCmMjBkOjAkLiCpAjFnEiClHiBeCjDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjDgPjIfOiDhJiDjDiCmM_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiPoOjFpBiCpAjClCiCnHiCmEjFfMiOkGiCmJiOgHiCoNiCoKiCoJjBkOjAkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SColorID FCObjTextRect::GetStdPenBackSColor () const
{
	return FD_S_COLOR_UNUSE;
} // FCObjTextRect::GetStdPenBackSColor.

//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjTextRect::CalcResizeFrameSelf ()
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//	if (GetRichText() != NULL)
//	{
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		DBLPointVector vmmptPoly;
////		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
////		NewObjPolygonForText(vmmptPoly, FFGetStdElemLen(), NULL, 0);
////		m_pRichText->CalcTextLayout(NULL, vmmptPoly.begin(), vmmptPoly.size());
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//		GetRichText()->CalcTextLayout(NULL, this);
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//} // FCObjTextRect::CalcResizeFrameSelf.
//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjTextRect::CopySelf(pObj);
} // FCObjTextRect::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjTextRect::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_mmetol_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjTextRect, m_mmrtResize));
	FCObjTextRect* pRect = reinterpret_cast<FCObjTextRect*>(pObj);
	memcpy(&pRect->m_mmrtResize, &m_mmrtResize,
			sizeof(FCObjTextRect) - offsetof(FCObjTextRect, m_mmrtResize));
} // FCObjTextRect::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetMinWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCmMiNmFiPkMjCgMiCpAjFnEiClHiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTextRect::GetMinWidth () const
{
	return m_mmMinWidth;
} // FCObjTextRect::GetMinWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetMaxWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCmMiNmFjBoFjCgMiCpAjFnEiClHiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTextRect::GetMaxWidth () const
{
	return m_mmMaxWidth;
} // FCObjTextRect::GetMaxWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetMinHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiCiClDiCmMiNmFiPkMjCgMiCpAjFnEiClHiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTextRect::GetMinHeight () const
{
	return m_mmMinHeight;
} // FCObjTextRect::GetMinHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetMaxHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiCiClDiCmMiNmFjBoFjCgMiCpAjFnEiClHiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTextRect::GetMaxHeight () const
{
	return m_mmMaxHeight;
} // FCObjTextRect::GetMaxHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::SetMinWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCmMiNmFiPkMjCgMiCpAjAnNjCoIiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::SetMinWidth (mmetol mmWidth)
{
	m_mmMinWidth = mmWidth;
} // FCObjTextRect::SetMinWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::SetMaxWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCmMiNmFjBoFjCgMiCpAjAnNjCoIiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::SetMaxWidth (mmetol mmWidth)
{
	m_mmMaxWidth = mmWidth;
} // FCObjTextRect::SetMaxWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::SetMinHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiCiClDiCmMiNmFiPkMjCgMiCpAjAnNjCoIiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::SetMinHeight (mmetol mmHeight)
{
	m_mmMinHeight = mmHeight;
} // FCObjTextRect::SetMinHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::SetMaxHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiCiClDiCmMiNmFjBoFjCgMiCpAjAnNjCoIiBeCjAkHiMmAiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-DBL_MAX_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::SetMaxHeight (mmetol mmHeight)
{
	m_mmMaxHeight = mmHeight;
} // FCObjTextRect::SetMaxHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::Move (mmetol mmDX, mmetol mmDY)
{
	m_mmrtResize += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjTextRect::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmNiBeBiDfEiDeDiDfJiCkKiCmIiCoJiCnHiCkNjAlDiKgNiCmJ_xHqqkZx_mmrtNew_xZkqqHx_iCmJiCmIiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTextRect::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmrtResize = mmrtNew;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
}	// FCObjTextRect::Resize.

//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::Rotate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		: _xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
// *			mmCX	: _xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
// *			mmCX	: _xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjTextRect::Rotate (double dR, mmetol mmCX, mmetol mmCY)
//{
//	//----- m_mmrtResize_xZkqqHx_iCmNiBeBiJpBjDfNiCmJiCkAiCoNiClJiCmEiImKjChFiCpAiInKjDkOiClHiCoJiClOiCkP_xHqqkZx_ -----
//	DBLPoint mmptNew = m_mmrtResize.CenterPoint();
//	RotateConv(mmptNew, sin(dR * M_PI), cos(dR * M_PI), mmCX, mmCY);
//	// _xZkqqHx_iInKjDkOiLjHjHkDiBeC_xHqqkZx_
//	const DBLPoint mmptMove = mmptNew - m_mmrtResize.CenterPoint();
////----- 05.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiInKjDkOiBeC_xHqqkZx_
////	m_mmrtResize += mmptMove;
////	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiJpBjDfNiCmJiCkAiCoNiClJiCmEiNmEjEhKjChF_xHqqkZx_ -----
////	if (m_pRichText != NULL)
////	{
////		m_pRichText->SetTextRect(m_pRichText->GetTextRect() + mmptMove);
////	}
////----- 05.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiInKjDkOiBeC_xHqqkZx_
//	Move(mmptMove.x, mmptMove.y);
////----- 05.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiJpBjDfNiCpAjGgIiCkOiClNiCnPiCmJiBeB_xHqqkZx_Superclass::Rotate_xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
//} // FCObjTextRect::Rotate.
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTextRect::GetStdPenStyle
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)_xZkqqHx_iBhGiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiDhJiDjDiCmMjBkOjAkLiCpAjFnEiClHiBeCjDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjDgPjIfOiDhJiDjDiCmM_xHqqkZx_
// *			_xZkqqHx_jDgPjIfOiPoOjFpBiCpAjClCiCnHiCmEjFfMiOkGiCmJiOgHiCoNiCoKiCoJjBkOjAkLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//PenStyleID FCObjTextRect::GetStdPenStyle () const
//{
//	// _xZkqqHx_iDhJiDjDiCmNiPoNiCmJjDkHjGlOiBeC_xHqqkZx_
//	return FD_PEN_STYLE_UNUSE;
//} // FCObjTextRect::GetStdPenStyle.
//----- 05.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
