#include "stdafx.h"
#include "resource.h"		// For ProObjWidePoly.h.
#include <algorithm>		// For reverse.
#include "DynamicDrawView.h"// For g_pView.
#include "FoundDoc.h"		// For g_pDoc.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For CalcBezier etc.
#include "UtilBezier.h"		// For CalcBezier2 etc.
#include "Arrow.h"			// For CalcPQR etc.
#include "UtilMath.h"		// For mmroundoff.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "DBLShortLine.h"	// For DBLShortLine.
#include "ProObjWidePoly.h"	// For CFCProObjWidePoly.
#include "RichText.h"		// For GetRichText().
#include "UtilGraph.h"		// For FCDraw.
#include "UtilLine.h"		// For FFGetLineAngle.
#include "ApproximateBezier.h"	// For FCApproximateBezier.
#include "ObjWidePoly.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiKnGiMfH_xHqqkZx_ ------
struct myObjPolyData
{
	DBLPointVector	vmmptLeft;
	DBLPointVector	vmmptRight;
	BYTEVector		vIsJointLeft;
	BYTEVector		vIsJointRight;
	mmetol			mmArrowF_P;
	mmetol			mmArrowF_Q;
	angle			dArrowF_Angle;
	mmetol			mmArrowB_P;
	mmetol			mmArrowB_Q;
	angle			dArrowB_Angle;
}; // struct myObjPolyData.

struct myMakeBezierThreadData
{
	myMakeBezierThreadData ();
	~myMakeBezierThreadData ();
	void TerminateThread ();
	static void WINAPI myMakeBezierThread (LPVOID pvoid);

	FCAutoDeleteCriticalSection	m_acsThreadVariable;			// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_

	map<FCObjWidePoly*, myObjPolyData>	m_mpWaitObjToData;		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiDgGiBfLiDfOiBeC_xHqqkZx_
	map<FCObjWidePoly*, myObjPolyData>	m_mpFinishObjToData;	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhIiDfHiDeGiNoMjAkMjHhAiDgGiBfLiDfOiBeC_xHqqkZx_
	HANDLE	m_hThreadEvent;				// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	HANDLE	m_hFlushThreadHandle;		// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	BOOL	m_bIsTerminate;				// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
}; // struct myMakeBezierThreadData.

// 06.03.15 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//static HANDLE					s_hFlushThreadHandle = INVALID_HANDLE_VALUE;	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_

// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKiCpAiOmAiNhDiClHiCoJiDfIiDiMiDgCiDgIiCmMiDgGiBfLiDfOiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
static myMakeBezierThreadData	s_MakeBezierThreadData;

//----- 06.03.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//static set<FCObjWidePoly*>		s_stWaitObjToMakeBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHjBnCiClPiCmMjFjEjFgJiBeC_xHqqkZx_
//static UINT_PTR					s_uMakeBezierTimerId = 0;
//----- 06.03.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
set<FCObjWidePoly*>	FCObjWidePoly::s_stWaitObjToMakeBezier;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMjFjEjFgJiBeC_xHqqkZx_
UINT_PTR			FCObjWidePoly::s_uMakeBezierTimerId = 0;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKiKeKiOgOiDfOiDeDiDhNiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//----- 06.03.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////
// myMakeBezierThreadData_xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMakeBezierThreadData::myMakeBezierThreadData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
myMakeBezierThreadData::myMakeBezierThreadData ()
						:	m_hThreadEvent(INVALID_HANDLE_VALUE),
							m_hFlushThreadHandle(INVALID_HANDLE_VALUE),
							m_bIsTerminate(FALSE)				// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
{
	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(m_acsThreadVariable);
	// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	m_hThreadEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
	DWORD dwFlushThreadId;
	m_hFlushThreadHandle =
		CreateThread(NULL, 0, (PTHREAD_START_ROUTINE)myMakeBezierThreadData::myMakeBezierThread,
					(LPVOID)this, 0, &dwFlushThreadId);
} // myMakeBezierThreadData::myMakeBezierThreadData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMakeBezierThreadData::~myMakeBezierThreadData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCkKjDkOiNoMjCiGiCmIiCoHiCmOiLkNjAkHiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
myMakeBezierThreadData::~myMakeBezierThreadData ()
{
	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(m_acsThreadVariable);

	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	if (m_hFlushThreadHandle != INVALID_HANDLE_VALUE)
	//----- _xZkqqHx_iDfIiDiMiDgCiDgIiCkKiOmAiNhDjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCoCiCnOiCmIiCkNiLkNjAkHiPeJjHlJiBeC_xHqqkZx_
		::TerminateThread(m_hFlushThreadHandle, 0);
		m_hFlushThreadHandle = INVALID_HANDLE_VALUE;

		// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		CloseHandle(m_hThreadEvent);
		m_hThreadEvent = INVALID_HANDLE_VALUE;
	}
} // myMakeBezierThreadData::~myMakeBezierThreadData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMakeBezierThreadData::TerminateThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCmJiDfGiDePiDgJiDiLiCpAjBjHiCmBiCmEiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiCmFiLkNjAkHiPeJjHlJiClHiCoJiCoGiCoIjGfNiCnMiClFiCkCiCkKiBeBiMhGiOfKjCiGiCmNiPeJjHlJiCnMiCmFiCmJ_xHqqkZx_
 *			_xZkqqHx_iOjOiKnEiCkKiCkJiCkJiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void myMakeBezierThreadData::TerminateThread ()
{
	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(m_acsThreadVariable);
	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	if (m_hFlushThreadHandle != INVALID_HANDLE_VALUE)
	//----- _xZkqqHx_iDfIiDiMiDgCiDgIiCkKiOmAiNhDjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
		m_bIsTerminate = TRUE;
		// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiCpAiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_PulseEvent _xZkqqHx_iClOiCmGiBeB_xHqqkZx_
		// WaitForSingleObject _xZkqqHx_iCmJjDpMiCmBiCmEiPkNiClFiOjOiKnEiCkKiMgPiClNiCmIiCkCiCmG_xHqqkZx_
		// _xZkqqHx_iCkEiCnMiCkNjDkOiNoMiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
		SetEvent(m_hThreadEvent);
	}
} // myMakeBezierThreadData::TerminateThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMakeBezierThreadData::myMakeBezierThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiLnPiOjHiMhGiOfKiCpAiOmAiNhDiClHiCoJiDfIiDiMiDgCiDgIiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pvoid	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void WINAPI myMakeBezierThreadData::myMakeBezierThread (LPVOID pvoid)
{
	myMakeBezierThreadData* pData = (myMakeBezierThreadData*)pvoid;
	for (;;)
	{
		TRACE(_T("FCObjWidePoly::myMakeBezierThread A\n"));
		// _xZkqqHx_iDeDiDhIiDjDiDgHiCkKiDfGiDePiDgJiDiLiCmJiCmIiCoJiCmMiCpAjBnCiCmCiBeC_xHqqkZx_
		WaitForSingleObject(pData->m_hThreadEvent, INFINITE);

		for (;;)
		{
			FCObjWidePoly* pObj = NULL;
			DBLPointVector vmmptLeft;
			DBLPointVector vmmptRight;
			BYTEVector vIsJointLeft;
			BYTEVector vIsJointRight;

			{
				// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
				FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
				if (!pData->m_bIsTerminate &&
					!pData->m_mpWaitObjToData.empty())
				//----- _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjGlDiCkCiBjFiDhIiDfHiDeGiMhGiOfKjBnCiClPjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFkBiOmKiBeC_xHqqkZx_
					pObj = (*pData->m_mpWaitObjToData.begin()).first;
					vmmptLeft = (*pData->m_mpWaitObjToData.begin()).second.vmmptLeft;
					vmmptRight = (*pData->m_mpWaitObjToData.begin()).second.vmmptRight;
					vIsJointLeft = (*pData->m_mpWaitObjToData.begin()).second.vIsJointLeft;
					vIsJointRight = (*pData->m_mpWaitObjToData.begin()).second.vIsJointRight;
				}
			}
			// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjHeMiCoJiPoKiNiHiBeBiIlNiCkCiCmNiDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMiDgGiBfLiDfOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
			if (pObj == NULL) break;
			// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
			DBLPointVector vmmptLeftBezier;
			FCObjWidePoly::MakeApproximateBezier(vmmptLeftBezier, vmmptLeft.begin(), vmmptLeft.size(), vIsJointLeft.begin());
			DBLPointVector vmmptRightBezier;
			FCObjWidePoly::MakeApproximateBezier(vmmptRightBezier, vmmptRight.begin(), vmmptRight.size(), vIsJointRight.begin());
			{
				// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
				FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
				map<FCObjWidePoly*, myObjPolyData>::iterator iOd = pData->m_mpWaitObjToData.find(pObj);
				if (iOd != pData->m_mpWaitObjToData.end())
				//----- _xZkqqHx_iMhGiOfKjBmOiPnLiCmMjFjEjFgJiCkKiNoNiPjMiClDiCoKiCmEiCmNiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
				{
					if (vmmptLeft == (*iOd).second.vmmptLeft &&
						vmmptRight == (*iOd).second.vmmptRight)
					//----- _xZkqqHx_iMhGiOfKiKeKiOgOiOjOiCmGiPeJjHlJiOjOiCmFiDhMiDiKiDiJiDeDiDjDiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_iMhGiOfKiNmPiCnNiCmMjFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhIiDfHiDeGiNoMjAkMjHhAiDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
						pData->m_mpFinishObjToData[pObj].vmmptLeft = vmmptLeftBezier;
						pData->m_mpFinishObjToData[pObj].vmmptRight = vmmptRightBezier;
						pData->m_mpFinishObjToData[pObj].mmArrowF_P = (*iOd).second.mmArrowF_P;
						pData->m_mpFinishObjToData[pObj].mmArrowF_Q = (*iOd).second.mmArrowF_Q;
						pData->m_mpFinishObjToData[pObj].dArrowF_Angle = (*iOd).second.dArrowF_Angle;
						pData->m_mpFinishObjToData[pObj].mmArrowB_P = (*iOd).second.mmArrowB_P;
						pData->m_mpFinishObjToData[pObj].mmArrowB_Q = (*iOd).second.mmArrowB_Q;
						pData->m_mpFinishObjToData[pObj].dArrowB_Angle = (*iOd).second.dArrowB_Angle;
					}
					// _xZkqqHx_iMhGiOfKjBnCiClPiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
					pData->m_mpWaitObjToData.erase(iOd);
				}
			}
		}
		{
			// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
			FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
			// _xZkqqHx_iDeDiDhIiDjDiDgHiCpAjEpBiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_
			ResetEvent(pData->m_hThreadEvent);
			if (pData->m_bIsTerminate)
			//----- _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
				pData->m_hFlushThreadHandle = INVALID_HANDLE_VALUE;
				// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
				CloseHandle(pData->m_hThreadEvent);
				pData->m_hThreadEvent = INVALID_HANDLE_VALUE;
				// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJiBeC_xHqqkZx_
				break;
			}
		}
		TRACE(_T("FCObjWidePoly::myMakeBezierThread C\n"));
	}
} // myMakeBezierThreadData::myMakeBezierThread.

////////////////////////////////////////////////////////////////////////////
// static MISC_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	myLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	myCalcSideLine _xZkqqHx_iCmFiOgHiCkEiDgGiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct myLine
{
	BOOL		bIsJointPa;		// _xZkqqHx_iOgOjDfPiCkKjFhDjIeBjBlBiCkJiBeI_xHqqkZx_
	BOOL		bIsJointPb;		// _xZkqqHx_iPeJjDfPiCkKjFhDjIeBjBlBiCkJiBeI_xHqqkZx_
	DBLPoint	mmptPa;			// _xZkqqHx_iOlCjApMiCmMiOgOjDfPiBeC_xHqqkZx_
	DBLPoint	mmptPb;			// _xZkqqHx_iOlCjApMiCmMiPeJjDfPiBeC_xHqqkZx_
	DBLPoint	mmptSa;			// _xZkqqHx_jBkEjApMiCmMiOgOjDfPiBeC_xHqqkZx_
	DBLPoint	mmptSb;			// _xZkqqHx_jBkEjApMiCmMiPeJjDfPiBeC_xHqqkZx_
	DBLPoint	mmptRa;			// _xZkqqHx_iOgOiMpAjDfPiBeC_xHqqkZx_
	DBLPoint	mmptRb;			// _xZkqqHx_iPeJiMpAjDfPiBeC_xHqqkZx_
}; // struct myLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCalcSideLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAgDjApMiDhMiDiKiDiJiDeDiDjDiDgGiBfLiDfOiCkJiCoHiBeBiClLiCmMjHlMiDfEiDeDiDgIiCmMjBkEjApMiDhMiDiKiDiJiDeDiDjDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptSide	:_xZkqqHx_jBkEjApMiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			bRightSide	:_xZkqqHx_iNlGiJeFiCmMiCmHiClPiCoHiCmMjBkEjApMiCpAiMhGiOfKiClHiCoJiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptaAxis	:_xZkqqHx_jAgDjApMiCmMiDhMiDiKiDiJiDeDiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			lAxisSz		:mmptaAxis_xZkqqHx_iCmMiDfEiDeDiDfJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmaW		:_xZkqqHx_jAgDjApMiCkJiCoHjBkEjApMiCnGiCmMiLjHjHkDiBgJjBnBjFjNiCmMjElMjFkKiBgKiCmMjEhKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_ P127,P154,P200,P201_xZkqqHx_iBeCiDhGiDiNiDePiDiJiDiAjCiGiCmFiOgHiCkEjDfPiBeBjApMiCmM_xHqqkZx_
 *			_xZkqqHx_jGlMiPmMiCmN_xHqqkZx_ ObjWidePoly.mdrw_xZkqqHx_iCmMjAhNiCmJiPfNiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptaAxis_xZkqqHx_iCmMiDhMiDiKiDiJiDeDiDjDiDgGiBfLiDfOiCmNiBeBiPgEiCmIiCoIiCkKjGlDiCkCiCoAiCmMiCmFiCmIiCkPiCoKiCmO_xHqqkZx_
 *			_xZkqqHx_iCmIiCoHiCmIiCkCiBeC_xHqqkZx_OmitAxisPoly_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *			static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.09 Fukushiro M. ObjArrow_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			99.06.14 Fukushiro M. P154_xZkqqHx_iCmMiDeBiDiLiDfDiDiKiDfJiDiAiCkJiCoH_xHqqkZx_P127_xZkqqHx_iCmMiDeBiDiLiDfDiDiKiDfJiDiA_xHqqkZx_
 *								_xZkqqHx_iCnGjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			99.06.15 Fukushiro M. P127 _xZkqqHx_iCmMjFpLjGeAiCmFiCmNiBeBjBkEjApMiCkKjAgDjApMiCkJiCoHjBoFiCkLiCkNiCmNiClIiCoKiClNiOjOiBeB_xHqqkZx_
 *								_xZkqqHx_iClLiCmMiCmNiClIiCoKiClNiNmAjFfHiCmFiMhGiOfKiCkKjAgJiCnPiCoHiCoKiCoJiClNiCnPiBeBiClLiCmMiOjP_xHqqkZx_
 *								_xZkqqHx_iCmMjBkEjApMiCoAiJgFiLlPiCpAiCkEiCkPiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *								_xZkqqHx_jHoBiCkGiCmOiBeBjGhLjHiIiCmNiCmLiClGiCoKiCkKjAlGiClGiCoJiDgOiDfJiCmMjBkEjApMiCkK_xHqqkZx_
 *								_xZkqqHx_iCmLiClGiCoKiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiCmGiCkJiBeFiBeF_xHqqkZx_ _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_
 *								P127_xZkqqHx_iCmMiDeBiDiLiDfDiDiKiDfJiDiAiCkJiCoHiBeB_xHqqkZx_P154 + P156 _xZkqqHx_iCmM_xHqqkZx_
 *								_xZkqqHx_iDeBiDiLiDfDiDiKiDfJiDiAiCnGjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkMiClFiCmIiCkIiClFiBeC_xHqqkZx_ObjWidePoly.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			05.04.14 Fukushiro M. _xZkqqHx_iNoMjAkMiClFiCmIiCkIiClFiBeC_xHqqkZx_ObjWidePoly.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *************************************************************************/
static void myCalcSideLine (DBLPointVector& vmmptSide,
							BYTEVector& vIsJointSide,
							BOOL bRightSide,
							const DBLPointVector& vmmptAxis,
							const BYTEVector& vIsJointAxis,
							const mmetolVector& vmmW)
{
	// _xZkqqHx_jAgDjApMjEhKjHpBjAjEiCkKiCfAiImIiJlKiCmMiPoKiNiHiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	ASSERT(1 < vmmptAxis.size());
	// _xZkqqHx_jFmPjAjEjGlMiCmN_xHqqkZx_ P259 _xZkqqHx_iCmMjAhNiCmJiPfNiCkEiBeCiNlGjBkEjApMiCmMiMhGiOfKiCmMiPoKiNiHiCoAiJeFjBkEjApMiCmMjFmPjAjEjGlMiCpAiOgHjHhAiBeC_xHqqkZx_


	// _xZkqqHx_iCmGiCmJiCkJiCkNiBeBjAgDjApMiCmGjBkEjApMiCkKiCmLiClGiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNmFiPiJiCmMjAgDjApMiBeBiNmFiMoDiCmMjAgDjApMiCmJ_xHqqkZx_
	// _xZkqqHx_iKnGiCoNiCoHiClIiClLiCmMjAgDjApMiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jAgDjApMiCmGjBkEjApMiCmMiCmLiClGiCoKiCkKjGlDiCkCjBkEjApMiCpAiNoMiCoIiPoDiClAiCmEiBeBiNmFiMoDiCmJjClHiClHiCkMiCoJjFjEjFkKiCpAiDeKiDgCiDgHiClHiCoJiBeC_xHqqkZx_

	//----- _xZkqqHx_iCnMiClIiBeBjApMjFkKiCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----

	vector<myLine> vLine;
	long lC;
	for (lC = 1; lC != vmmptAxis.size(); lC++)
	{
		vLine.push_back(myLine());
		vLine.back().bIsJointPa = vIsJointAxis[lC - 1];
		vLine.back().bIsJointPb = vIsJointAxis[lC];
		vLine.back().mmptPa = vmmptAxis[lC - 1];
		vLine.back().mmptPb = vmmptAxis[lC];
		DBLPoint mmptNab = vmmptAxis[lC] - vmmptAxis[lC - 1];
		mmetol mmNabLen = mmptNab.Len();
		ASSERT(!almost0(mmNabLen));
		// _xZkqqHx_jAlDiClFiCkCiPiIjHjNiCmFiCmNiCmIiCkCiCkKiBeBiDiKiDiKiBfLiDfIjEmFiCmFjHiOiClPiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
		if (almost0(mmNabLen)) mmNabLen = 1.0;
		if (bRightSide)
		//----- _xZkqqHx_iJeFjBkEjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			vLine.back().mmptSa.x = vmmptAxis[lC - 1].x - mmptNab.y * vmmW[lC - 1] / mmNabLen;
			vLine.back().mmptSa.y = vmmptAxis[lC - 1].y + mmptNab.x * vmmW[lC - 1] / mmNabLen;
			vLine.back().mmptSb.x = vmmptAxis[lC].x - mmptNab.y * vmmW[lC] / mmNabLen;
			vLine.back().mmptSb.y = vmmptAxis[lC].y + mmptNab.x * vmmW[lC] / mmNabLen;
		} else
		//----- _xZkqqHx_iNlGjBkEjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			vLine.back().mmptSa.x = vmmptAxis[lC - 1].x + mmptNab.y * vmmW[lC - 1] / mmNabLen;
			vLine.back().mmptSa.y = vmmptAxis[lC - 1].y - mmptNab.x * vmmW[lC - 1] / mmNabLen;
			vLine.back().mmptSb.x = vmmptAxis[lC].x + mmptNab.y * vmmW[lC] / mmNabLen;
			vLine.back().mmptSb.y = vmmptAxis[lC].y - mmptNab.x * vmmW[lC] / mmNabLen;
		}
	}
	// _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCpAiLeMjIfOiClFiCmEiCkIiCkNiBeCiNmFiMoDiCmJjHjIjHhAiClHiCoJiClNiCnPiBeBjApMjFkKiCkKiNoNiPjMiClDiCoKiCmEiCoAjBoFiPoEjFhGiCmMiCoGiCkEiCmJiBeC_xHqqkZx_
	const DBLPoint mmptS0 = vLine.front().mmptSa;
	const DBLPoint mmptSn = vLine.back().mmptSb;

	lC = 0;
	for (;;)
	{
		// _xZkqqHx_iOgOjDfPiCoGiCoIjBePiCmJjGnPiCoHiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
		if (lC == -1) lC = 0;
		// _xZkqqHx_iPeJjDfPiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
		if (lC == vLine.size()) break;

		// _xZkqqHx_iNmFiPiJiCmMjApMjFkKiCmMiPoKiNiHiCmNiBeBiOgOiMpAjDfPiCmNjBkEjApMiCmMiOgOjDfPiCmJjDjJiClFiCkCiBeC_xHqqkZx_
// 05.04.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		// _xZkqqHx_jDhCjCiGiCmMjApMjFkKiCmMiPoKiNiHiCmNiBeBiOgOiMpAjDfPiCmNiIoKiCmCjBePiCmMjApMjFkKiCmMiPeJiMpAjDfPiCmJjDjJiClFiCkCiBgJiInJiCmIiCoJiPoKiNiHiCoAiCkAiCoJiCkKiBeBiClLiCoKiCmNiMoDiCmFiPeDjAlDiBgK_xHqqkZx_
		if (lC == 0)
			vLine[lC].mmptRa = vLine[lC].mmptSa;
//----- 05.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		else
//			vLine[lC].mmptRa = vLine[lC - 1].mmptRb;
//----- 05.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		if (lC == vLine.size() - 1)
		//----- _xZkqqHx_iNmFiMoDiCmMjApMjFkKiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiMoDiCmMjApMjFkKiCmMiPeJiMpAjDfPiCmNjBkEjApMiCmMiPeJjDfPiCmJjDjJiClFiCkCiBeC_xHqqkZx_
			vLine[lC].mmptRb = vLine[lC].mmptSb;
		} else
		//----- _xZkqqHx_iNmFiMoDiCmMjApMjFkKiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBkEjApMiCmMiOkOiCpAiNoMjAkMiClFiBeBiClLiCmMiMpAjDfPiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			DBLLine lnMab(vLine[lC].mmptSa, vLine[lC].mmptSb);
			DBLLine lnMcd(vLine[lC + 1].mmptSa, vLine[lC + 1].mmptSb);
			if (lnMab && lnMcd)
			//----- Mab/Mcd_xZkqqHx_iCkKjFhDjFlNiNhDiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMpAjDfPiCpAiLiBiCnPiBeBiClLiCoKiCpAiPeJiMpAjDfPiCmJjAnNjCoIiBeC_xHqqkZx_
				vLine[lC].mmptRb = lnMab & lnMcd;
				vLine[lC + 1].mmptRa = vLine[lC].mmptRb;
			} else
			//----- Mab/Mcd_xZkqqHx_iCkKjFlNiNhDiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// Sa,Sb_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
				vLine[lC].mmptRb = vLine[lC].mmptSb;
				vLine[lC + 1].mmptRa = vLine[lC + 1].mmptSa;
			}
		}
		if (FFLineDir(vLine[lC].mmptSa, vLine[lC].mmptSb) != FFLineDir(vLine[lC].mmptRa, vLine[lC].mmptRb))
		//----- _xZkqqHx_jBkEjApMiCkKiCmLiClGiCoKiCmEiCkCiCoJiBgJjAgDjApMiCmGjBkEjApMiCmMjFpLiMpMiCkKiInJiCmIiCoJiBgKiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMjApMjFkKiCpAiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
			vLine.erase(&vLine[lC]);
			// _xZkqqHx_iIoKiCmCjBePiCmMjApMjFkKiCkJiCoHiMhGiOfKiCpAiCoCiCoIjClMiClHiBeC_xHqqkZx_
			// vLine[lC]_xZkqqHx_iCpAiNoNiPjMiClHiCoJiCmGiBeB_xHqqkZx_vLine[lC-1].mmptRb_xZkqqHx_iCkKiLlGiCkEiClNiCnPiBeC_xHqqkZx_
			lC--;
		} else
		//----- _xZkqqHx_jBkEjApMiCkKiCmLiClGiCoKiCmEiCkCiCmIiCkCiBgJjAgDjApMiCmGjBkEjApMiCmMjFpLiMpMiCkKjDkPiClGiBgKiPoKiNiH_xHqqkZx_ -----
		{
			lC++;
		}
	}
	//----- _xZkqqHx_iOgOiMpAjDfPiBeBiPeJiMpAjDfPiCkKiJjDiClHiCkMiCoJiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	for (lC = 1; lC != vLine.size(); lC++)
	{
		// _xZkqqHx_iMpAjDfP_xHqqkZx_Rbc_xZkqqHx_iCkK_xHqqkZx_Sa-Sb, Sc-Sd_xZkqqHx_iCmMiKePiCmJiCkAiCoJiPoKiNiHiCmMiCnNiBeBiLjHjHkDjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jDoAiCmJiCkAiCoJiPoKiNiHiCmNiBeBjDoAjBkEjApMiCmMjAfLiCkCiImKjChFiCmFiCmMiMpAiNlHiCmMiPoKiNiHiCmIiCmMiCmF_xHqqkZx_
		// _xZkqqHx_jAkHiMmAiCpAiCkJiCkPiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// ObjWidePoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
		if (!almosteq(vLine[lC - 1].mmptSb, vLine[lC - 1].mmptRb) &&
			!almosteq(vLine[lC].mmptSa, vLine[lC].mmptRa) &&
			FFLineDir(vLine[lC - 1].mmptSa, vLine[lC - 1].mmptSb) == FFLineDir(vLine[lC - 1].mmptSb, vLine[lC - 1].mmptRb) &&
			FFLineDir(vLine[lC].mmptSb, vLine[lC].mmptSa) == FFLineDir(vLine[lC].mmptSa, vLine[lC].mmptRa))
		//----- _xZkqqHx_iMpAjDfPiCkKiDeKiBfLiDhFiCmMiKePjBkEiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			double dPowLenPbSb = (vLine[lC - 1].mmptSb - vLine[lC - 1].mmptPb).PowLen();
			double dPowLenPcSc = (vLine[lC].mmptSa - vLine[lC].mmptPa).PowLen();
			double dPowLenSbRb = (vLine[lC - 1].mmptRb - vLine[lC - 1].mmptSb).PowLen();
			double dPowLenScRc = (vLine[lC].mmptRa - vLine[lC].mmptSa).PowLen();
			if (dPowLenPbSb < dPowLenSbRb && dPowLenPcSc < dPowLenScRc)
			//----- _xZkqqHx_iMpAjDfPiCkKjHlMjFpLiCmMjApMjFkKiCmM_xHqqkZx_Sb,Sa_xZkqqHx_iCkJiCoHiJjDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// |Sb-Rb|=|Pb-Sb|,|Sc-Rc|=|Pc-Sc|_xZkqqHx_iCmGiCmIiCoJiCoGiCkEiBeB_xHqqkZx_Rb,Rc_xZkqqHx_iCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
				mmetol mmLenPbSb = sqrt(dPowLenPbSb);
				mmetol mmLenPcSc = sqrt(dPowLenPcSc);
				mmetol mmLenSbRb = sqrt(dPowLenSbRb);
				mmetol mmLenScRc = sqrt(dPowLenScRc);
				// Rb_xZkqqHx_iCpAiInKjDkOiBeC_xHqqkZx_
				vLine[lC - 1].mmptRb = vLine[lC - 1].mmptSb + (vLine[lC - 1].mmptRb - vLine[lC - 1].mmptSb) * (mmLenPbSb / mmLenSbRb);
				// Rc_xZkqqHx_iCpAiInKjDkOiBeC_xHqqkZx_
				vLine[lC].mmptRa = vLine[lC].mmptSa + (vLine[lC].mmptRa - vLine[lC].mmptSa) * (mmLenPcSc / mmLenScRc);
				// Rb,Rc_xZkqqHx_iCmNjFhDjIeBjBlBiCmIjDfPiCmGiClHiCoJiBeC_xHqqkZx_
				vLine[lC - 1].bIsJointPb = TRUE;
				vLine[lC].bIsJointPa = TRUE;
			}
		}
	}

	//----- vLine _xZkqqHx_iCkJiCoHjBkEjApMjEhKjHpBiCpAjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
	vmmptSide.clear();
	vIsJointSide.clear();
	// _xZkqqHx_iOgOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	vmmptSide.push_back(mmptS0);
	vIsJointSide.push_back(TRUE);
	for (lC = 0; lC != vLine.size(); lC++)
	{
		// _xZkqqHx_jBePiCmMjBkEjApMjFkKiCmGiCmMiMpAjDfPiCpAjCmHiJmBiBeC_xHqqkZx_
		if (!almosteq(vmmptSide.back(), vLine[lC].mmptRa))
		{
			vmmptSide.push_back(vLine[lC].mmptRa);
			vIsJointSide.push_back(vLine[lC].bIsJointPa);
		}
		// _xZkqqHx_iMoDiCmMjBkEjApMjFkKiCmGiCmMiMpAjDfPiCpAjCmHiJmBiBeC_xHqqkZx_
		if (!almosteq(vmmptSide.back(), vLine[lC].mmptRb))
		{
			vmmptSide.push_back(vLine[lC].mmptRb);
			vIsJointSide.push_back(vLine[lC].bIsJointPb);
		}
	}
	// _xZkqqHx_iPeJjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!almosteq(vmmptSide.back(), mmptSn))
	{
		vmmptSide.push_back(mmptSn);
		vIsJointSide.push_back(TRUE);
	}
	// _xZkqqHx_iPeJjDfPiCmNjFhDjIeBjBlBiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	vIsJointSide.back() = TRUE;
} // myCalcSideLine.

////////////////////////////////////////////////////////////////////////////
// FCObjWidePoly_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::FCObjWidePoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
FCObjWidePoly::FCObjWidePoly ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjWidePoly, m_mmWidthF));
	memset(&m_mmWidthF, 0, sizeof(FCObjWidePoly) - offsetof(FCObjWidePoly, m_mmWidthF));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_mmWidthF = mmroundoff(4.0);	// _xZkqqHx_iKeKiOgOjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	m_mmWidthB = mmroundoff(4.0);	// _xZkqqHx_iPeJjHlJjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	m_nWidthSlopeF = 0;		// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	m_nWidthSlopeB = 0;		// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	m_mmArrowF_P = -1.0;
	m_mmArrowF_Q = -1.0;
	m_dArrowF_Angle = -1.0;
	m_mmArrowB_P = -1.0;
	m_mmArrowB_Q = -1.0;
	m_dArrowB_Angle = -1.0;
} // FCObjWidePoly::FCObjWidePoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_WIDE_POLY) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjWidePoly::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjWidePoly::Type () const
{
	return FDOJ_WIDE_POLY;
} // FCObjWidePoly::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCkKiCkAiCoKiCmOiClLiCmMjFjNiCoAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeCjCgMiCmJiCmNiCkAiCoJjCpGjDhIiMoLiNlHiCkKiCkAiCmBiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGoOiIpDiMhGiOfKiCmMiCgPiBeBiChAiBeBiChBiCmNjAnNiMhGiDgNiBfLiDgHiCmM_xHqqkZx_P244_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_jAgDjApMiCkJiCoHiKePjAnKiDhEiDiMiBfLiDiAiCnMiCmFiCmMiLjHjHkDiCmMiMhGiOfKiCmNjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P307_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.19 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			00.02.27 Fukushiro M. _xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P307_xZkqqHx_iCpAiNgMjHlGiBeC_xHqqkZx_
 *************************************************************************/
DBLRect FCObjWidePoly::GetOuterFrame () const
{
//----- 01.08.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_lJoint == 0) return DBLRect(0,0,1,1);
//----- 01.08.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBnBiCmMjFjNiCmMiNmFjBoFjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
	const mmetol mmPolyW = GetPolyWidthF() < GetPolyWidthB() ? GetPolyWidthB() : GetPolyWidthF();
	// ObjWidePoly.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_1.42 = Root(2.0)
	mmetol mmExt = 1.42 * mmPolyW / 2.0;
	// mmExt_xZkqqHx_iCkKiPkMiClDiClHiCkMiCoJiPoKiNiHiCmN_xHqqkZx_0.1mm_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_OuterFrame_xZkqqHx_iCmMjFjNiBeFiNiCiClDiCkKiCePiCmJ_xHqqkZx_
	// _xZkqqHx_iCmIiCoJiCmGiBeBiPoBiKfBiCkKjEkNjAlGiClHiCoJiBeC_xHqqkZx_
	if (mmExt < 0.1) mmExt = 0.1;
	DBLRect mmrt = GetResizeFrame().ExtendRect(mmExt + GetStdPenWeight() / 2.0);

	// ObjPoly::GetOuterFrame_xZkqqHx_iCmGiInJiCmIiCoIiBeB_xHqqkZx_IsClosePolygon()_xZkqqHx_iCpAiDgAiDeGiDgCiDeOiClFiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	// WidePoly_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_IsClosePolygon()_xZkqqHx_iCmNjGoOiIpDiCpAiOjNiCmBiCmEiCkCiCoGiCkEiCmGiPoNiCmJjAfOiClOiCkJiCoHiBeC_xHqqkZx_
	if (GetArrowFType() != FDUG_ARW_TYPE_FLAT || GetArrowBType() != FDUG_ARW_TYPE_FLAT)
	//----- _xZkqqHx_iKeKiOgOiBeFiPeJjHlJjGoOiIpDiCmMjBoFiCkLiClDiCpAiNgMjHlGiClHiCoJ_xHqqkZx_ -----
	{
		// GetEdgePoint_xZkqqHx_iCmMiMhGiOfKiCmJiCmNiDfCiDfIiDgHiCkKiCkJiCkJiCoJiCmMiCmFiBeBiCnMiClIiCfAiCmCiCmFiCoAjGoOiIpDiCkKiCkAiCoJiCkJiCmHiCkEiCkJjElLjCgGiBeC_xHqqkZx_
		DBLPoint mmptEdgeF;
		DBLPoint mmptEdgeB;
		GetEdgePoint(mmptEdgeF, mmptEdgeB);
		if (GetArrowFType() != FDUG_ARW_TYPE_FLAT)
		{
			DBLRect mmrtArrow;
			if (GetArrowFType() == FDUG_ARW_TYPE_PICT)
			{
				FCPictArrow arrow(GetPictArrowF(), TRUE);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrow, mmptEdgeF, GetPolyWidthF(), GetStdPenWeight());
			} else
			{
				FCStdArrow arrow(FCUGArrowParams(GetArrowFType(), GetArrowFParam0(),
									GetArrowFParam1(), GetArrowFParam2()), TRUE);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrow, mmptEdgeF, GetPolyWidthF(), GetStdPenWeight());
			}
			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
			mmrt |= mmrtArrow;
		}
		if (GetArrowBType() != FDUG_ARW_TYPE_FLAT)
		{
			DBLRect mmrtArrow;
			if (GetArrowBType() == FDUG_ARW_TYPE_PICT)
			{
				FCPictArrow arrow(GetPictArrowB(), TRUE);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrow, mmptEdgeB, GetPolyWidthB(), GetStdPenWeight());
			} else
			{
				FCStdArrow arrow(FCUGArrowParams(GetArrowBType(), GetArrowBParam0(),
									GetArrowBParam1(), GetArrowBParam2()), TRUE);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrow, mmptEdgeB, GetPolyWidthB(), GetStdPenWeight());
			}
			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
			mmrt |= mmrtArrow;
		}
	}
	// _xZkqqHx_iJgFiCmMjBoFiCkLiClDiCpAiNgMjHlGiBeC_xHqqkZx_
	if (GetShadowSColor() != FD_S_COLOR_UNUSE)
	{
		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJeFjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
		if (0 <= g_pEnv->GetShadowLen().x)
			mmrt.right += g_pEnv->GetShadowLen().x;
		else
			mmrt.left += g_pEnv->GetShadowLen().x;

		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJlKjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
		if (0 <= g_pEnv->GetShadowLen().y)
			mmrt.bottom += g_pEnv->GetShadowLen().y;
		else
			mmrt.top += g_pEnv->GetShadowLen().y;
	}
	return mmrt;
} // FCObjWidePoly::GetOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjWidePoly* pWpy = static_cast<const FCObjWidePoly*>(objp);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return (memcmp(&m_mmWidthF, &pWpy->m_mmWidthF,
//				sizeof(FCObjWidePoly) - offsetof(FCObjWidePoly, m_mmWidthF)) == 0);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return	almosteq(pWpy->m_mmWidthF, m_mmWidthF) &&
			almosteq(pWpy->m_mmWidthB, m_mmWidthB) &&
			(pWpy->m_nWidthSlopeF == m_nWidthSlopeF) &&
			(pWpy->m_nWidthSlopeB == m_nWidthSlopeB) &&
			almosteq(pWpy->m_vmmptLeftBezier, m_vmmptLeftBezier) &&
			almosteq(pWpy->m_vmmptRightBezier, m_vmmptRightBezier) &&
			almosteq(pWpy->m_mmArrowF_P, m_mmArrowF_P) &&
			almosteq(pWpy->m_mmArrowF_Q, m_mmArrowF_Q) &&
			almosteq(pWpy->m_dArrowF_Angle, m_dArrowF_Angle) &&
			almosteq(pWpy->m_mmArrowB_P, m_mmArrowB_P) &&
			almosteq(pWpy->m_mmArrowB_Q, m_mmArrowB_Q) &&
			almosteq(pWpy->m_dArrowB_Angle, m_dArrowB_Angle);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjWidePoly::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjWidePoly::OutStream (FCUndoArchive& ar)
void FCObjWidePoly::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmWidthF;		// _xZkqqHx_jGoOiIpDiCmMjFjNiBeC_xHqqkZx_
	ar << m_mmWidthB;		// _xZkqqHx_jGoOiIpDiCmMjFjNiBeC_xHqqkZx_
	ar << m_nWidthSlopeF;	// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	ar << m_nWidthSlopeB;	// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	long lC;
	ar << long(m_vmmptLeftBezier.size());	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	for (lC = 0; lC != m_vmmptLeftBezier.size(); lC++)
		ar << m_vmmptLeftBezier[lC];
	ar << long(m_vmmptRightBezier.size());	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	for (lC = 0; lC != m_vmmptRightBezier.size(); lC++)
		ar << m_vmmptRightBezier[lC];
	ar << m_mmArrowF_P;			// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	ar << m_mmArrowF_Q;			// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	ar << m_dArrowF_Angle;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiMpMiCkLiBeC_xHqqkZx_
	ar << m_mmArrowB_P;			// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	ar << m_mmArrowB_Q;			// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	ar << m_dArrowB_Angle;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiMpMiCkL_xHqqkZx_
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjWidePoly::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_mmWidthF;		// _xZkqqHx_jGoOiIpDiCmMjFjNiBeC_xHqqkZx_
	ar >> m_mmWidthB;		// _xZkqqHx_jGoOiIpDiCmMjFjNiBeC_xHqqkZx_
	ar >> m_nWidthSlopeF;	// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	ar >> m_nWidthSlopeB;	// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	long lC;
	long lSize;
	ar >> lSize;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	m_vmmptLeftBezier.assign(lSize);
	for (lC = 0; lC != lSize; lC++)
		ar >> m_vmmptLeftBezier[lC];
	ar >> lSize;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	m_vmmptRightBezier.assign(lSize);
	for (lC = 0; lC != lSize; lC++)
		ar >> m_vmmptRightBezier[lC];
	ar >> m_mmArrowF_P;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	ar >> m_mmArrowF_Q;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	ar >> m_dArrowF_Angle;  // _xZkqqHx_jBePjFpLjGoOiIpDiCmMiMpMiCkLiBeC_xHqqkZx_
	ar >> m_mmArrowB_P;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	ar >> m_mmArrowB_Q;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	ar >> m_dArrowB_Angle;  // _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiMpMiCkL_xHqqkZx_
	if (m_vmmptLeftBezier.empty())
		ResetMakeBezier();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjWidePoly::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	:PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		:_xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.19 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::CreatePropertyPage (CPropertyPageVector& vPropPage,
										const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_WIDE_POLY)) return;
	vPropPage.push_back(new CFCProObjWidePoly());
} // FCObjWidePoly::CreatePropertyPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::IsClosePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::IsClosePolygon () const
{
	return TRUE;
} // FCObjWidePoly::IsClosePolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			00.01.27 Fukushiro M. _xZkqqHx_jGoOiIpDiDfEiDeDiDfJiCpAiNgMjHlGiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
	FCBaseArrow* pArrowF = NULL;
	if (m_byArrowFType != FDUG_ARW_TYPE_FLAT)
	{
		if (m_byArrowFType == FDUG_ARW_TYPE_PICT)
			pArrowF = new FCPictArrow(GetPictArrowF(), TRUE);
		else
			pArrowF = new FCStdArrow(FCUGArrowParams(m_byArrowFType, m_byArrowFParam0,
												m_byArrowFParam1, m_byArrowFParam2), TRUE);
	}
	FCBaseArrow* pArrowB = NULL;
	if (m_byArrowBType != FDUG_ARW_TYPE_FLAT)
	{
		if (m_byArrowBType == FDUG_ARW_TYPE_PICT)
			pArrowB = new FCPictArrow(GetPictArrowB(), TRUE);
		else
			pArrowB = new FCStdArrow(FCUGArrowParams(m_byArrowBType, m_byArrowBParam0,
												m_byArrowBParam1, m_byArrowBParam2), TRUE);
	}
	NewObjPolygon(vmmptPoly, mmElemLen, mmrtaClip, iClipSize, pArrowF, pArrowB);
	if (pArrowF != NULL) delete pArrowF;
	if (pArrowB != NULL) delete pArrowB;
} // FCObjWidePoly::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	// FCObjWidePoly_xZkqqHx_iDeOiDiJiDfIiCmMiPoKiNiHiBeBjGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHjGlDiClFiCmFiDhIiDfHiDeGiLmIjApMiCpA_xHqqkZx_
	// _xZkqqHx_iMhGiOfKiClHiCoJiClBiCmGiCmNiCmFiCkLiCmIiCkCiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_NewArrowedObjBezier_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
	// _xZkqqHx_jGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHiCmGiCmGiCoAiCmJiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClFiBeBjGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHiCmNiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	BOOL bIsClose = FALSE;
	FCBaseArrow* pArrowF = NULL;
	FCBaseArrow* pArrowB = NULL;
	BOOL bIsWidePoly = FALSE;
	FCObjWidePoly::NewArrowedObjBezier(polyBezier, bIsClose, pArrowF, pArrowB, bIsWidePoly);
	if (pArrowF != NULL) delete pArrowF;
	if (pArrowB != NULL) delete pArrowB;
} // FCObjWidePoly::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewArrowedObjPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCoAiNgMjHlGiClFiClNiDhMiDiKiDfDiDjDiOoGjDlOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vlgptPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jFmCiClGiClNiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			pArrowF		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			pArrowB		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			bIsWidePoly	:WidePoly_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewArrowedObjPolygon (DBLPointVector& vmmptPoly, BOOL& bIsClose,
										FCBaseArrow*& pArrowF, FCBaseArrow*& pArrowB,
										BOOL& bIsWidePoly, mmetol mmElemLen,
										const DBLRect mmrtaClip[], int iClipSize) const
{
//----- 05.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfHiDiHiDeDiDjDiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetJointSize() == 0) return;
//----- 05.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (m_byArrowFType != FDUG_ARW_TYPE_FLAT)
	{
		if (m_byArrowFType == FDUG_ARW_TYPE_PICT)
			pArrowF = new FCPictArrow(GetPictArrowF(), TRUE);
		else
			pArrowF = new FCStdArrow(FCUGArrowParams(m_byArrowFType, m_byArrowFParam0,
												m_byArrowFParam1, m_byArrowFParam2), TRUE);
	}
	if (m_byArrowBType != FDUG_ARW_TYPE_FLAT)
	{
		if (m_byArrowBType == FDUG_ARW_TYPE_PICT)
			pArrowB = new FCPictArrow(GetPictArrowB(), TRUE);
		else
			pArrowB = new FCStdArrow(FCUGArrowParams(m_byArrowBType, m_byArrowBParam0,
												m_byArrowBParam1, m_byArrowBParam2), TRUE);
	}
	bIsClose = IsClosePolygon();
	NewObjPolygon(vmmptPoly, mmElemLen, mmrtaClip, iClipSize, pArrowF, pArrowB);
	bIsWidePoly = TRUE;
} // FCObjWidePoly::NewArrowedObjPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewArrowedObjBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCoAiNgMjHlGiClFiClNiDhIiDfHiDeGiLmIjApMiOoGjDlOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jFmCiClGiClNiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			pArrowF		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			pArrowB		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			bIsWidePoly	:WidePoly_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewArrowedObjBezier (	FCMmPolyBezier& polyBezier,
											BOOL& bIsClose,
											FCBaseArrow*& pArrowF,
											FCBaseArrow*& pArrowB,
											BOOL& bIsWidePoly) const
{
	ASSERT(pArrowF == NULL && pArrowB == NULL);
	// _xZkqqHx_iDfHiDiHiDeDiDjDiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetJointSize() == 0) return;

	/*************************************************************************
	 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	My
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkEjApMiCmGjGoOiIpDiCpAjAnKjBlBiClHiCoJiNnLiCmMiBeBjAnKjBlBjDfPiCkKjDkPiIoKiCmGiCnNiCmIiClJiCoJiCkJiCmHiCkEiCkJiCmM_xHqqkZx_
	 *			_xZkqqHx_jElLjCgGiCpAiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBkEjApMiCmMjCfLiCmGjGoOiIpDiDhIiDfHiDeGiCmMjCfLiCmNiBeBjFfHiPiAjGoOiIpDiCmFiCkAiCmBiCmEiCoA_xHqqkZx_0.1mm_xZkqqHx_iBgAjCpGjDhI_xHqqkZx_
	 *			_xZkqqHx_jHkDiCoKiCmEiCkCiCoJiBeCiClBiCoKiCmFiCmN_xHqqkZx_rougheq_xZkqqHx_iCmFiCkAiCmBiCmEiCoAjDkPiIoKiCmGiCmNiCnNiCmIiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjFjNiNeMiLmIjApMiCmMjFjNiCpAiMlDiCmJiCoEiCoJiCkCiKoOiPiAjCgMiCpAjAnNiCkPiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_jBkEjApMiCmGjGoOiIpDiCmMjAnKjBlBjFjEjFkKiCmNjFjNiNeMiLmIjApMiCmMjFjNjFjEjFkKiCmFiCoAiCkAiCoJiCmMiCmFiBeBiClBiCmM_xHqqkZx_
	 *			_xZkqqHx_iKoOiPiAjCgMiCmNjDlJjHjNiCmJiCkJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_jFjNiNeMiLmIjApMjFjEjFgJiCpAiLmIjApMjFjEjFgJiCmJjFmPiKlHiClHiCoJiNnLiBeBjBkEjApMiCmGjGoOiIpDiCmMjAnKjBlBjFjEiCmN_xHqqkZx_
	 *			_xZkqqHx_iCmIiCoJiCnHiCkNiCfAiCmCiCmMiDhMiDiKiDfDiDjDiCmJiOpLiCnPiClNiCkCiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	struct My
	{
		// _xZkqqHx_jFjNiNeMiLmIjApMiCmMjFjNiCkJiCoHiLjGjHgFiMoLiNlHiBgJiDhNiBfLiDfHiDjDiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
		My (mmetol mmWidthF, mmetol mmWidthB)
			{
				// _xZkqqHx_jFjNiCkKiCePiCmMiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBjBoFiCkLiCkCjFpLiCpAiDhNiBfLiDfHiDjDiCmGiClHiCoJiBeC_xHqqkZx_
				m_mmMargin = (mmWidthF < mmWidthB) ? mmWidthB : mmWidthF;
				m_mmMargin /= 10.0;
				m_mmMargin = m_mmMargin * m_mmMargin;
			}
		BOOL RoughEq (const DBLPoint& a, const DBLPoint& b)
			{
				return ((a - b).PowLen() < m_mmMargin);
			}
		mmetol m_mmMargin;	// _xZkqqHx_iLjGjHgFiMoLiNlH_xHqqkZx_^2_xZkqqHx_iBeC_xHqqkZx_
	} my(m_mmWidthF, m_mmWidthB);

	if (GetArrowFType() != FDUG_ARW_TYPE_FLAT)
	{
		// _xZkqqHx_jBePjFpLjGoOiIpDiCpAiNoMjAkMiBeC_xHqqkZx_
		if (GetArrowFType() == FDUG_ARW_TYPE_PICT)
			pArrowF = new FCPictArrow(GetPictArrowF(), TRUE);
		else
			pArrowF = new FCStdArrow(FCUGArrowParams(GetArrowFType(), GetArrowFParam0(),
													GetArrowFParam1(), GetArrowFParam2()),
									TRUE);
	}
	if (GetArrowBType() != FDUG_ARW_TYPE_FLAT)
	{
		// _xZkqqHx_iMoDjFpLjGoOiIpDiCpAiNoMjAkMiBeC_xHqqkZx_
		if (GetArrowBType() == FDUG_ARW_TYPE_PICT)
			pArrowB = new FCPictArrow(GetPictArrowB(), TRUE);
		else
			pArrowB = new FCStdArrow(FCUGArrowParams(GetArrowBType(), GetArrowBParam0(),
													GetArrowBParam1(), GetArrowBParam2()),
									TRUE);
	}
	bIsClose = IsClosePolygon();

//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_vmmptLeftBezier.empty())
//	//----- _xZkqqHx_iLnPiOjHiCmMiDhIiDfHiDeGiLmIjApMiCkKjGkCiClOiNoMjAkMiCmFiCkLiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiNoMjAkMjDgPjIfOiJpAiPjMiBeC_xHqqkZx_
//		UnregisterMakeBezier((FCObjWidePoly*)this);
//		// _xZkqqHx_iClBiClBiCmFiLnPiOjHiMhGiOfKiCpAiClHiCoJiBeC_xHqqkZx_
//		DBLPointVector vmmptLeftBezier;
//		DBLPointVector vmmptRightBezier;
//		mmetol mmArrowF_P;
//		mmetol mmArrowF_Q;
//		angle dArrowF_Angle;
//		mmetol mmArrowB_P;
//		mmetol mmArrowB_Q;
//		angle dArrowB_Angle;
//		// _xZkqqHx_iNlGiJeFiCmMjBkEiDhMiDiKiDiJiDeDiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
//		DBLPointVector vmmptLeft;
//		DBLPointVector vmmptRight;
//		BYTEVector vIsJointLeft;
//		BYTEVector vIsJointRight;
//		CalcSideLine(	vmmptLeft,
//						vmmptRight,
//						vIsJointLeft,
//						vIsJointRight,
//						mmArrowF_P,
//						mmArrowF_Q,
//						dArrowF_Angle,
//						mmArrowB_P,
//						mmArrowB_Q,
//						dArrowB_Angle);
//		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		MakeApproximateBezier(vmmptLeftBezier, vmmptLeft.begin(), vmmptLeft.size(), vIsJointLeft.begin());
//		MakeApproximateBezier(vmmptRightBezier, vmmptRight.begin(), vmmptRight.size(), vIsJointRight.begin());
//		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//		((FCObjWidePoly*)this)->SetApproximateBezier(	vmmptLeftBezier,
//														vmmptRightBezier,
//														mmArrowF_P,
//														mmArrowF_Q,
//														dArrowF_Angle,
//														mmArrowB_P,
//														mmArrowB_Q,
//														dArrowB_Angle);
//	}
//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBkEjApMiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
	((FCObjWidePoly*)this)->PrepareSideBezier();
//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiBeC_xHqqkZx_
	FCBezierControlsVector vControls;
	// _xZkqqHx_iJeFjBkEjApMiCmMiDhIiDfHiDeGiLmIjApMiCpAjHfMiCnPiDiKiDgPiBfLiDfIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	FCMmPolyBezier polyBezierRight(TRUE, m_vmmptRightBezier.begin(), m_vmmptRightBezier.size());
	polyBezierRight.Reverse();

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bIsArrowBezierF = FALSE;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (pArrowF != NULL)
	//----- _xZkqqHx_jBePjFpLjGoOiIpDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint mmptA;
		DBLPoint mmptB;
		GetArrowF_AB(mmptA, mmptB);
		// _xZkqqHx_jGoOiIpDiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		pArrowF->InitArrow(	GetPolyWidthF(),
							mmptA,
							mmptB,
							GetStdPenStyle(),
							GetStdPenWeight(),
							GetStdPenBackSColor(),
							GetStdBrushPattern(),
							GetStdBrushForeSColor(),
							GetStdBrushBackSColor(),
							GetShadowSColor());
		// _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
		FCMmPolyBezier polyBezierArrow;
		pArrowF->GetBezier(polyBezierArrow);

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiImIiJlKiCkKjFeLjHhGiBeC_xHqqkZx_
		if (!polyBezierArrow.empty())
		//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
			bIsArrowBezierF = TRUE;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			if (!my.RoughEq(polyBezierRight.back(), polyBezierArrow.front()))
			//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiCmGiJeFjBkEjApMiCkKiCmCiCmIiCkKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				vControls.push_back(FCBezierControls(	polyBezierRight.back(),
														polyBezierRight.back(),
														polyBezierArrow.front(),
														polyBezierArrow.front()));
			}

			// _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAjCmHiJmBiBeC_xHqqkZx_
			FCBezierControlsVector vControlsArrow;
			FFControlConv(vControlsArrow, polyBezierArrow);
			vControls.insert(vControls.end(), vControlsArrow.begin(), vControlsArrow.end());

			if (!my.RoughEq(polyBezierArrow.back(), m_vmmptLeftBezier.front()))
			//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiCmGiNlGjBkEjApMiCkKiCmCiCmIiCkKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				vControls.push_back(FCBezierControls(	polyBezierArrow.back(),
														polyBezierArrow.back(),
														m_vmmptLeftBezier.front(),
														m_vmmptLeftBezier.front()));
			}
		}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	} else
//	//----- _xZkqqHx_jBePjFpLjGoOiIpDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	}
	if (!bIsArrowBezierF)
	//----- _xZkqqHx_jBePjFpLjGoOiIpDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		vControls.push_back(FCBezierControls(polyBezierRight.back(),
											polyBezierRight.back(),
											m_vmmptLeftBezier.front(),
											m_vmmptLeftBezier.front()));
	}

	// _xZkqqHx_iNlGjBkEjApMiCpAjCmHiJmBiBeC_xHqqkZx_
	FCBezierControlsVector vControlsLeft;
	FFControlConv(vControlsLeft, FCMmPolyBezier(TRUE, m_vmmptLeftBezier.begin(), m_vmmptLeftBezier.size()));
	vControls.insert(vControls.end(), vControlsLeft.begin(), vControlsLeft.end());

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bIsArrowBezierB = FALSE;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (pArrowB != NULL)
	//----- _xZkqqHx_iMoDjFpLjGoOiIpDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint mmptA;
		DBLPoint mmptB;
		GetArrowB_AB(mmptA, mmptB);
		// _xZkqqHx_jGoOiIpDiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		pArrowB->InitArrow(	GetPolyWidthB(),
							mmptA,
							mmptB,
							GetStdPenStyle(),
							GetStdPenWeight(),
							GetStdPenBackSColor(),
							GetStdBrushPattern(),
							GetStdBrushForeSColor(),
							GetStdBrushBackSColor(),
							GetShadowSColor());
		// _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
		FCMmPolyBezier polyBezierArrow;
		pArrowB->GetBezier(polyBezierArrow);

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiImIiJlKiCkKjFeLjHhGiBeC_xHqqkZx_
		if (!polyBezierArrow.empty())
		//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
			bIsArrowBezierB = TRUE;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			if (!my.RoughEq(m_vmmptLeftBezier.back(), polyBezierArrow.front()))
			//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiCmGiNlGjBkEjApMiCkKiCmCiCmIiCkKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				vControls.push_back(FCBezierControls(	m_vmmptLeftBezier.back(),
														m_vmmptLeftBezier.back(),
														polyBezierArrow.front(),
														polyBezierArrow.front()));
			}
			// _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAjCmHiJmBiBeC_xHqqkZx_
			FCBezierControlsVector vControlsArrow;
			FFControlConv(vControlsArrow, polyBezierArrow);
			vControls.insert(vControls.end(), vControlsArrow.begin(), vControlsArrow.end());

			if (!my.RoughEq(polyBezierArrow.back(), polyBezierRight.front()))
			//----- _xZkqqHx_jGoOiIpDiCmMiDhIiDfHiDeGiCmGiJeFjBkEjApMiCkKiCmCiCmIiCkKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				vControls.push_back(FCBezierControls(	polyBezierArrow.back(),
														polyBezierArrow.back(),
														polyBezierRight.front(),
														polyBezierRight.front()));
			}
		}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	} else
//	//----- _xZkqqHx_iMoDjFpLjGoOiIpDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	}
	if (!bIsArrowBezierB)
	//----- _xZkqqHx_iMoDjFpLjGoOiIpDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		vControls.push_back(FCBezierControls(m_vmmptLeftBezier.back(),
											m_vmmptLeftBezier.back(),
											polyBezierRight.front(),
											polyBezierRight.front()));
	}

	// _xZkqqHx_iJeFjBkEjApMiCpAjCmHiJmBiBeC_xHqqkZx_
	FCBezierControlsVector vControlsRight;
	FFControlConv(vControlsRight, polyBezierRight);
	vControls.insert(vControls.end(), vControlsRight.begin(), vControlsRight.end());
	FFControlConv(polyBezier, vControls);
	bIsWidePoly = TRUE;
} // FCObjWidePoly::NewArrowedObjBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewObjPolygonForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjHhAiCmMiDhMiDiKiDiJiDeDiDjDiNoMjAkMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiDhEiDiMiBfLiDiAjFgAiJoGiCmGiBeBjFjEjFgJiDfEiDeDiDfJiMhGiOfKiOjOiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiCoGiCkEiCmJjFkBjAjEiCmMjFjEjFgJiCmMiPfHiNiHiCmMiPoKiNiHiBeB_xHqqkZx_DBL_MAX_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewObjPolygonForResize (DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAjIfPjHjNiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
//	DBLRect mmrtClient;
//	g_pView->GetClientRectMM(mmrtClient);
//	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
//	// _xZkqqHx_jFjNiNeMjAhNiMgAiCmNiDiKiDfEiDeDiDfJiCkKjAlDiKgNiCmJiCmFiCkLiCmIiCkCiClNiCnPiBeBjCmKiPoNiCmMiLoJiMgAiCmMiDhMiDiKiDiJiDeDiDjDiCpAiOgHiCkEiBeC_xHqqkZx_
//	BASE_CLASS::NewObjPolygon(vmmptPoly, CalcElementLengthForResize(),
//								&mmrtClient, 1);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjNiNeMjAhNiMgAiCmNiDiKiDfEiDeDiDfJiCkKjAlDiKgNiCmJiCmFiCkLiCmIiCkCiClNiCnPiBeBjCmKiPoNiCmMiLoJiMgAiCmMiDhMiDiKiDiJiDeDiDjDiCpAiOgHiCkEiBeC_xHqqkZx_
	BASE_CLASS::NewObjPolygonForDraw(vmmptPoly, mmElemLen, mmrtaClip, iClipSize);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjWidePoly::NewObjPolygonForResize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::OnPictArrowModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCkKjFmPiNfIiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	paid	:_xZkqqHx_jFmPiNfIiClDiCoKiClNjGoOiIpDiCmMiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::OnPictArrowModified (PictArrowID paid)
{
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKjGkCiNoMjAkMiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_vmmptLeftBezier.empty()) return;
do {
	if (GetArrowFType() == FDUG_ARW_TYPE_PICT && GetPictArrowF() == paid)
	//----- _xZkqqHx_jBePjFpLiCmJiPeDjAlDjBmOiPnLiCmMiDhDiDeOiDgAiDiDjGoOiIpDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmetol mmP = FCPictArrow(GetPictArrowF(), TRUE).GetP(GetPolyWidthF());
		if (!abouteq(m_mmArrowF_P, mmP))
		{
			// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
			ResetMakeBezier();
			break;
		}
	}
	if (GetArrowBType() == FDUG_ARW_TYPE_PICT && GetPictArrowB() == paid)
	//----- _xZkqqHx_iMoDjFpLiCmJiPeDjAlDjBmOiPnLiCmMiDhDiDeOiDgAiDiDjGoOiIpDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmetol mmP = FCPictArrow(GetPictArrowB(), TRUE).GetP(GetPolyWidthB());
		if (!abouteq(m_mmArrowB_P, mmP))
		{
			// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
			ResetMakeBezier();
			break;
		}
	}
} while (FALSE);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnPictArrowModified(paid);
} // FCObjWidePoly::OnPictArrowModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::OnArrowModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAjGoOiIpDiCkKjFmPiNfIiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::OnArrowModified ()
{
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKjGkCiNoMjAkMiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_vmmptLeftBezier.empty()) return;
do {
	mmetol mmP = -1.0;
	if (GetArrowFType() != FDUG_ARW_TYPE_FLAT)
	{
		if (GetArrowFType() == FDUG_ARW_TYPE_PICT)
			mmP = FCPictArrow(GetPictArrowF(), TRUE).GetP(GetPolyWidthF());
		else
			mmP = FCStdArrow(FCUGArrowParams(GetArrowFType(), GetArrowFParam0(),
											GetArrowFParam1(), GetArrowFParam2()),
							TRUE).GetP(GetPolyWidthF());
	}
	if (!abouteq(m_mmArrowF_P, mmP))
	{
		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
		ResetMakeBezier();
		break;
	}
	mmP = -1.0;
	if (GetArrowBType() != FDUG_ARW_TYPE_FLAT)
	{
		if (GetArrowBType() == FDUG_ARW_TYPE_PICT)
			mmP = FCPictArrow(GetPictArrowB(), TRUE).GetP(GetPolyWidthB());
		else
			mmP = FCStdArrow(FCUGArrowParams(GetArrowBType(), GetArrowBParam0(),
											GetArrowBParam1(), GetArrowBParam2()),
							TRUE).GetP(GetPolyWidthB());
	}
	if (!abouteq(m_mmArrowB_P, mmP))
	{
		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
		ResetMakeBezier();
		break;
	}
} while (FALSE);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnArrowModified();
} // FCObjWidePoly::OnArrowModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::~FCObjWidePoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjWidePoly::~FCObjWidePoly ()
{
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiNoMjAkMjDgPjIfOiJpAiPjMiBeC_xHqqkZx_
	UnregisterMakeBezier(this);
} // FCObjWidePoly::~FCObjWidePoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetPolyWidthF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCObjWidePoly::GetPolyWidthF () const
{
	return m_mmWidthF;
} // FCObjWidePoly::GetPolyWidthF.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetPolyWidthB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCObjWidePoly::GetPolyWidthB () const
{
	return m_mmWidthB;
} // FCObjWidePoly::GetPolyWidthB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetWidthSlopeF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiCpAjFnEiClHiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjWidePoly::GetWidthSlopeF () const
{
	return m_nWidthSlopeF;
} // FCObjWidePoly::GetWidthSlopeF.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetWidthSlopeB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiCpAjFnEiClHiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjWidePoly::GetWidthSlopeB () const
{
	return m_nWidthSlopeB;
} // FCObjWidePoly::GetWidthSlopeB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::PrepareSideBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkEjApMiCmMiDhIiDfHiDeGiLmIjApMiCkKjHhAiInDiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiBeBjHhAiInDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBkEjApMiCmMiDhIiDfHiDeGiLmIjApMiCmNiBeBjCmKiPoNiCmNiDfIiDiMiDgCiDgIiCmJiCoGiCmBiCmEiDgPiDgCiDeOiDePiDiJiDeFiDjDiDgIiCmF_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiBeFjAnNjCoIiClDiCoKiCoJiBeCiClBiCoKiCpAiDfIiDiMiDgCiDgIiCmFiCmNiCmIiCkNiLkNjAkHjDeJiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::PrepareSideBezier ()
{
	// _xZkqqHx_iDfHiDiHiDeDiDjDiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetJointSize() == 0) return;
	if (m_vmmptLeftBezier.empty())
	//----- _xZkqqHx_iLnPiOjHiCmMiDhIiDfHiDeGiLmIjApMiCkKjGkCiClOiNoMjAkMiCmFiCkLiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiNoMjAkMjDgPjIfOiJpAiPjMiBeC_xHqqkZx_
		UnregisterMakeBezier((FCObjWidePoly*)this);
		// _xZkqqHx_iClBiClBiCmFiLnPiOjHiMhGiOfKiCpAiClHiCoJiBeC_xHqqkZx_
		DBLPointVector vmmptLeftBezier;
		DBLPointVector vmmptRightBezier;
		mmetol mmArrowF_P;
		mmetol mmArrowF_Q;
		angle dArrowF_Angle;
		mmetol mmArrowB_P;
		mmetol mmArrowB_Q;
		angle dArrowB_Angle;
		// _xZkqqHx_iNlGiJeFiCmMjBkEiDhMiDiKiDiJiDeDiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPointVector vmmptLeft;
		DBLPointVector vmmptRight;
		BYTEVector vIsJointLeft;
		BYTEVector vIsJointRight;
		CalcSideLine(	vmmptLeft,
						vmmptRight,
						vIsJointLeft,
						vIsJointRight,
						mmArrowF_P,
						mmArrowF_Q,
						dArrowF_Angle,
						mmArrowB_P,
						mmArrowB_Q,
						dArrowB_Angle);
		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		MakeApproximateBezier(vmmptLeftBezier, vmmptLeft.begin(), vmmptLeft.size(), vIsJointLeft.begin());
		MakeApproximateBezier(vmmptRightBezier, vmmptRight.begin(), vmmptRight.size(), vIsJointRight.begin());
		// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		((FCObjWidePoly*)this)->SetApproximateBezier(	vmmptLeftBezier,
														vmmptRightBezier,
														mmArrowF_P,
														mmArrowF_Q,
														dArrowF_Angle,
														mmArrowB_P,
														mmArrowB_Q,
														dArrowB_Angle);
	}
} // FCObjWidePoly::PrepareSideBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::TerminateCalcBezierThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKiCmMiDfIiDiMiDgCiDgIiCpAiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::TerminateCalcBezierThread ()
{
	// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
	s_MakeBezierThreadData.TerminateThread();
} // FCObjWidePoly::TerminateCalcBezierThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::Move (mmetol mmDX, mmetol mmDY)
{
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	MoveApproximateBezier(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjWidePoly::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtOld	: _xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	ResizeApproximateBezier(bXPosi, bYPosi, mmrtNew, mmrtOld);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
} // FCObjWidePoly::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR			:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmptCenter	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::Rotate (double dR, const DBLPoint& mmptCenter)
{
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	RotateApproximateBezier(dR, mmptCenter);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhEiDiMiBfLiDiAiNmEiMhGiOfKiCmNiImIiJlKiCmFiBeC_xHqqkZx_
	BASE_CLASS::Rotate(dR, mmptCenter);
} // FCObjWidePoly::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::NewObjPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			00.01.27 Fukushiro M. _xZkqqHx_jGoOiIpDiDfEiDeDiDfJiCpAiNgMjHlGiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::NewObjPolygon (	DBLPointVector& vmmptPoly,
									mmetol mmElemLen,
									const DBLRect mmrtaClip[], int iClipSize,
									FCBaseArrow* pArrowF,
									FCBaseArrow* pArrowB) const
{
	DBLRectVector mmrtvClip;
	if (0 < iClipSize)
	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiCkKiCfAiCmCiImIiPoDjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//---------------------------------------------------------------------
		// _xZkqqHx_jGoOiIpDiCmMiMhGiOfKiCmNiBeBjGoOiIpDiCmMjCfLjDfPiCkJiCoHiNmFjBoFiCmF_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCmMjEmNiImNiCmM_xHqqkZx_
		// _xZkqqHx_jIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiCkKjAlDiKgNiCmJiMhGiOfKiClDiCoKiCmEiCkCiCmIiCkCiCmGiBeBjGoOiIpDiCpAiDhMiDiKiDfDiDjDiCmJ_xHqqkZx_
		// _xZkqqHx_jAnKjBlBiClHiCoJiClNiCnPiCmMiMhGiOfKiCkKjAlDiClFiCkNiNhDiCoNiCoKiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBjGoOiIpDiCmMjCfLjDfPiCpAjCiGjAfDiCmJ_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCpAiCoAiCmCiLoJiMgAiCkK_xHqqkZx_
		// _xZkqqHx_iNmEjFgAiJoGjEmNiImNiCmJjDpMiCoJiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
		// Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
		//---------------------------------------------------------------------
		const mmetol mmWidth = GetPolyWidthF() < GetPolyWidthB() ? GetPolyWidthB() : GetPolyWidthF();
		DBLPoint mmptEdgeF;
		DBLPoint mmptEdgeB;
		GetEdgePoint(mmptEdgeF, mmptEdgeB);
		// _xZkqqHx_iKeKiOgOjGoOiIpDiCmMjBoFiCkLiClDiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
		if (pArrowF != NULL)
		{
			DBLRect mmrtArrow;
			// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
			pArrowF->CalcAffectFrame(mmrtArrow, mmptEdgeF, GetPolyWidthF(), GetStdPenWeight());
			// _xZkqqHx_iNmFjBoFiJgFiLlPjEmNiImNiCmMiLoJiMgAiCkKiDiKiBfLiDfHiDiHiDjDiCmMiCkCiClIiCoKiCkJiCmGiMpAiNlHiClHiCoJiPoKiNiHiCmNiBeBiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
			for (long lC = 0; lC < iClipSize; lC++)
			{
				if (!(mmrtaClip[lC] & mmrtArrow).IsRectNull())
				{
					// _xZkqqHx_jCmHiJmBiClHiCoJiLoJiMgAiCmNiBeBjApMjFjNiCmMiNgMjHlGiCmNjFhDjHhGiBeCiImIiMoDiCmM_xHqqkZx_CalcBezier2_xZkqqHx_iCmF_xHqqkZx_
					// _xZkqqHx_iNgMjHlGiClDiCoKiCoJiInHiBeC_xHqqkZx_
					mmrtArrow.Reduce(mmWidth / 2.0);
					mmrtArrow.NormalizeRect();
					mmrtvClip.push_back(mmrtArrow);
					break;
				}
			}
		}
		// _xZkqqHx_iPeJjHlJjGoOiIpDiCmMjBoFiCkLiClDiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
		if (pArrowB != NULL)
		{
			DBLRect mmrtArrow;
			// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
			pArrowB->CalcAffectFrame(mmrtArrow, mmptEdgeB, GetPolyWidthB(), GetStdPenWeight());
			// _xZkqqHx_iNmFjBoFiJgFiLlPjEmNiImNiCmMiLoJiMgAiCkKiDiKiBfLiDfHiDiHiDjDiCmMiCkCiClIiCoKiCkJiCmGiMpAiNlHiClHiCoJiPoKiNiHiCmNiBeBiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
			for (long lC = 0; lC < iClipSize; lC++)
			{
				if (!(mmrtaClip[lC] & mmrtArrow).IsRectNull())
				{
					// _xZkqqHx_jCmHiJmBiClHiCoJiLoJiMgAiCmNiBeBjApMjFjNiCmMiNgMjHlGiCmNjFhDjHhGiBeCiImIiMoDiCmM_xHqqkZx_CalcBezier2_xZkqqHx_iCmF_xHqqkZx_
					// _xZkqqHx_iNgMjHlGiClDiCoKiCoJiInHiBeC_xHqqkZx_
					mmrtArrow.Reduce(mmWidth / 2.0);
					mmrtArrow.NormalizeRect();
					mmrtvClip.push_back(mmrtArrow);
					break;
				}
			}
		}
		mmrtvClip.insert(mmrtvClip.end(), mmrtaClip, mmrtaClip + iClipSize);
	}
	CalcOutline(vmmptPoly, mmElemLen, mmrtvClip.begin(), mmrtvClip.size(),
				pArrowF, pArrowB);
} // FCObjWidePoly::NewObjPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetPolyWidthF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmW	:_xZkqqHx_jApMiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFjNiCkKiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::SetPolyWidthF (mmetol mmW)
{
	if (m_mmWidthF == mmW) return FALSE;
	m_mmWidthF = mmW;
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	ResetMakeBezier();
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjWidePoly::SetPolyWidthF.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetPolyWidthB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCmMjFjNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmW	:_xZkqqHx_jApMiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFjNiCkKiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::SetPolyWidthB (mmetol mmW)
{
	if (m_mmWidthB == mmW) return FALSE;
	m_mmWidthB = mmW;
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	ResetMakeBezier();
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjWidePoly::SetPolyWidthB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetWidthSlopeF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiCpAiOhHjCoIiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::SetWidthSlopeF (short nWidthSlope)
{
	if (m_nWidthSlopeF == nWidthSlope) return FALSE;
	m_nWidthSlopeF = nWidthSlope;
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	ResetMakeBezier();
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjWidePoly::SetWidthSlopeF.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetWidthSlopeB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiCpAiOhHjCoIiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::SetWidthSlopeB (short nWidthSlope)
{
	if (m_nWidthSlopeB == nWidthSlope) return FALSE;
	m_nWidthSlopeB = nWidthSlope;
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	ResetMakeBezier();
//----- 05.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjWidePoly::SetWidthSlopeB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::CanSetOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCmMjAnKjBlBiPpDjBnEiCpAjFmPiNfIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ObjPoly_xZkqqHx_iCmGiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmM_xHqqkZx_ObjWidePoly_xZkqqHx_iCmFiBeB_xHqqkZx_SetIsOpenPolyJoint
 *			_xZkqqHx_iKnGjAjEiCmMiIlFiCkCiCkKjFmPiCoNiCoJiClNiCnPiBeBiClBiCmMiKnGjAjEiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::CanSetOpenPolyJoint () const
{
	return FALSE;
} // FCObjWidePoly::CanSetOpenPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetIsOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ObjPoly::GetIsOpenPolyJoint_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiInHiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::GetIsOpenPolyJoint () const
{
	return TRUE;
} // FCObjWidePoly::GetIsOpenPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetIsOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCpAiKeKiCkNiCkJjFmCiClGiCoJiCkJiCmMjAnNjCoIiCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bOpen	:_xZkqqHx_iKeKiCkNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjAnNjCoIiCmFiCkLiCmIiCkCiPoKiNiHiBeFiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ObjPoly::SetIsOpenPolyJoint_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiInHiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjWidePoly::SetIsOpenPolyJoint (BOOL bOpen)
{
	return FALSE;
} // FCObjWidePoly::SetIsOpenPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjWidePoly::CopySelf(pObj);
} // FCObjWidePoly::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjWidePoly::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjWidePoly, m_mmWidthF));
	FCObjWidePoly* pWpy = reinterpret_cast<FCObjWidePoly*>(pObj);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	memcpy(&pWpy->m_mmWidthF, &m_mmWidthF,
//				sizeof(FCObjWidePoly) - offsetof(FCObjWidePoly, m_mmWidthF));
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pWpy->m_mmWidthF = m_mmWidthF;					// _xZkqqHx_iKeKiOgOjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	pWpy->m_mmWidthB = m_mmWidthB;					// _xZkqqHx_iPeJjHlJjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	pWpy->m_nWidthSlopeF = m_nWidthSlopeF;			// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	pWpy->m_nWidthSlopeB = m_nWidthSlopeB;			// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	pWpy->m_vmmptLeftBezier = m_vmmptLeftBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	pWpy->m_vmmptRightBezier = m_vmmptRightBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBeC_xHqqkZx_
	pWpy->m_mmArrowF_P = m_mmArrowF_P;				// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	pWpy->m_mmArrowF_Q = m_mmArrowF_Q;				// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	pWpy->m_dArrowF_Angle = m_dArrowF_Angle;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiMpMiCkLiBeC_xHqqkZx_
	pWpy->m_mmArrowB_P = m_mmArrowB_P;				// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	pWpy->m_mmArrowB_Q = m_mmArrowB_Q;				// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	pWpy->m_dArrowB_Angle = m_dArrowB_Angle;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiMpMiCkL_xHqqkZx_
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjWidePoly::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::CalcOutline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeHjEhKjHpBiCkJiCoHjGoOiIpDjFjEjFgJiCmMiDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmNiBeB_xHqqkZx_CPoint_xZkqqHx_jEhKjHpBiIlNiCkCiCmN_xHqqkZx_DBLPoint_xZkqqHx_jEhKjHpBiCmMiCkCiClIiCoKiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGiCoIiPgPiClHiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmOutPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmM_xHqqkZx_DBLPoint_xZkqqHx_iMfOjClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClip		:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_ P244,P249,P300 _xZkqqHx_iCpAiOfBiPmGiBeCjFmPjAjEjGlMiCmN_xHqqkZx_ P300_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_jAgDjApMiCmMjIeBiMiLjDfPjEhKjHpB_xHqqkZx_ m_pJoint _xZkqqHx_iCkJiCoHiBeBjGoOiIpDiCmMiKePiOpMiCmMiDhMiDiKiDfDiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClHiCoJiBeCjFeLjHhGiCmJiJjOiClGiCmEiKeKiOgOjDfPiBeBiPeJjHlJjDfPiCmMjGoOiIpDiCmMiDhMiDiKiDfDiDjDiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLoPjBmMjDeJiCmJiCmNiBeBiCnMiClI_xHqqkZx_ m_pJoint _xZkqqHx_iCkJiCoHjAgDjApMiCmMiDhMiDiKiDiJiDeDiDjDiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhIiDfHiDeHiLmIjApMiCmMjHlMjBkEiCmJiBeBiLjHjHkD_xHqqkZx_ (m_mmWidth /2) X g_->dZoom _xZkqqHx_iCpAjChFiCkCiCmEiLmIjApMiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClHiCoJiBeCiNmFiMoDiCmJiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCpAiPpDjBnEiCmJiJjOiClGiCmEjGoOiIpDjGjEiCmNjCgGjApMiCmM_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDfDiDjDiCmFjAnKiNiHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.08 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::CalcOutline (DBLPointVector& vmmOutPoly, mmetol mmElemLen,
								const DBLRect* mmrtaClip, int iClip,
								FCBaseArrow* pArrowF, FCBaseArrow* pArrowB) const
{
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiBeC_xHqqkZx_
	if (mmElemLen < 0)
		mmElemLen = CalcOptimumElemLen();
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	vmmOutPoly.clear();
	mmetol mmWidthMax = GetPolyWidthF() < GetPolyWidthB() ? GetPolyWidthB() : GetPolyWidthF();
	DBLPointVector vmmptAxis;
do {
	double dMinRatio = 0.0;	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiPmIjHkKjHhAiCmMiKoOiPiAjCgMiBeC_xHqqkZx_
	// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDjFgAiJoGiCmFiCmNiBeBiClIiCoKiCkK_xHqqkZx_dMinRatio_xZkqqHx_iImIjDoAiCmMjDfPiCmNiPmIjHkKiBgJiNiCjBkMiJlLiCmMiInHiBgKiBeC_xHqqkZx_
	// _xZkqqHx_iPmIjHkKiKoOiPiAjCgMiCpAiOfKiPgPiBeCjFjEjFgJiCmMjBoFiCkLiClDiBgJjIfPjHjNiNmAjFfHiBgKiCkJiCoHjElLjCgGiBeC_xHqqkZx_
	// _xZkqqHx_jHlMjBkEiCmJiDhMiDiKiDiJiDeDiDjDiCpAiKgHjBoFiClHiCoJiInHiBeBiClIiCoKiCmMiMoLiNlHiCpA_xHqqkZx_ObjPoly_xZkqqHx_iCmMjElMjFkKiCmJiClHiCoJiBeC_xHqqkZx_
	if (g_->eDrawWhich == FDDR_DISPLAY)
		dMinRatio = ::StdMinRatio(mm2lg(m_mmrtResize)) / 2.0;

	if (!almosteq(GetPolyWidthF(), GetPolyWidthB()))
	//----- _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmMjBnBjFjNiCmJiMfIiOmOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAgDjApMiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiMhGiOfKiBeCjAgDjApMiCmMjBfDjBmMiCmMiLjHjHkDiMhGiOfKiCkKjFeLjHhGiCmJ_xHqqkZx_
		// _xZkqqHx_iCmIiCoJiClNiCnPiBeBiDiKiBfLiDfHiDiHiDjDiCmJiCoGiCoJjFjEjFkKiPmIjHkKiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		::CalcBezier2(vmmptAxis, (const FCPolyJoint*)m_pJoint, m_lJoint,
					mmWidthMax + GetStdPenWeight(), 0L,
					m_lJoint - 1L, mmElemLen, 1.0, (DBLRect*)NULL, 0,
					dMinRatio);
	} else
	//----- _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmMjBnBjFjNiCmJiMfIiOmOiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAgDjApMiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
		::CalcBezier2(vmmptAxis, (const FCPolyJoint*)m_pJoint, m_lJoint,
					mmWidthMax + GetStdPenWeight(), 0L,
					m_lJoint - 1L, mmElemLen, 1.0, mmrtaClip, iClip,
					dMinRatio);
	}
	// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjDkPiClGiNmAjFfHiCpAjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	FFRemoveSamePoint(vmmptAxis, BYTEVector(vmmptAxis.size(), FALSE));
	if (vmmptAxis.size() == 1) break;

	if (pArrowF != NULL)
	{
		pArrowF->InitByPoly(vmmptAxis,
							GetPolyWidthF(),
							mmElemLen,
							GetStdPenStyle(),
							GetStdPenWeight(),
							GetStdPenBackSColor(),
							GetStdBrushPattern(),
							GetStdBrushForeSColor(),
							GetStdBrushBackSColor(),
							GetShadowSColor());
		// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjDkPiClGiNmAjFfHiCpAjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_pArrow->Init_xZkqqHx_iCmFiCoAiCnMiCoKiCmJjEkNjAlGiBeC_xHqqkZx_
		FFRemoveSamePoint(vmmptAxis, BYTEVector(vmmptAxis.size(), FALSE));
	}
	if (pArrowB != NULL)
	{
		reverse(vmmptAxis.begin(), vmmptAxis.end());
		pArrowB->InitByPoly(vmmptAxis,
							GetPolyWidthB(),
							mmElemLen,
							GetStdPenStyle(),
							GetStdPenWeight(),
							GetStdPenBackSColor(),
							GetStdBrushPattern(),
							GetStdBrushForeSColor(),
							GetStdBrushBackSColor(),
							GetShadowSColor());
		reverse(vmmptAxis.begin(), vmmptAxis.end());
		// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjDkPiClGiNmAjFfHiCpAjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_pArrow->Init_xZkqqHx_iCmFiCoAiCnMiCoKiCmJjEkNjAlGiBeC_xHqqkZx_
		FFRemoveSamePoint(vmmptAxis, BYTEVector(vmmptAxis.size(), FALSE));
	}

	// _xZkqqHx_jAgDjApMiCmMiNlGiJeFiCmMjBkEjApMiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPointVector	vmmptLeft;
	DBLPointVector	vmmptRight;
	// _xZkqqHx_jBnBjFjNiCmMiMfIiOmOiPoOjFpBiCkJiCoHiBeB_xHqqkZx_(_xZkqqHx_jBnBjFjN_xHqqkZx_/2)_xZkqqHx_iCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	mmetolVector vmmW;
	FFCalcWideWidthArray(vmmW,
						vmmptAxis,
						BYTEVector(vmmptAxis.size(), FALSE),
						mmElemLen,
						GetPolyWidthF() / 2.0,
						GetPolyWidthB() / 2.0,
						GetWidthSlopeF(), GetWidthSlopeB());

	myCalcSideLine(vmmptRight, BYTEVector(), TRUE, vmmptAxis, BYTEVector(vmmptAxis.size(), FALSE), vmmW);
	myCalcSideLine(vmmptLeft, BYTEVector(), FALSE, vmmptAxis, BYTEVector(vmmptAxis.size(), FALSE), vmmW);
	DBLPointVector vmmptArrow_F;
	DBLPointVector vmmptArrow_B;
	if (pArrowF != NULL)
		pArrowF->GetPolygon(vmmptArrow_F, mmElemLen);
	if (pArrowB != NULL)
		pArrowB->GetPolygon(vmmptArrow_B, mmElemLen);
	reverse(vmmptRight.begin(), vmmptRight.end());
	if (!vmmptArrow_F.empty())
		vmmOutPoly.insert(vmmOutPoly.end(), vmmptArrow_F.begin() + 1, vmmptArrow_F.end() - 1);
	vmmOutPoly.insert(vmmOutPoly.end(), vmmptLeft.begin(), vmmptLeft.end());
	if (!vmmptArrow_B.empty())
		vmmOutPoly.insert(vmmOutPoly.end(), vmmptArrow_B.begin() + 1, vmmptArrow_B.end() - 1);
	vmmOutPoly.insert(vmmOutPoly.end(), vmmptRight.begin(), vmmptRight.end());
	vmmOutPoly.push_back(vmmOutPoly.front());
	return;
} while (FALSE);
	mmetol mmWidthHalfMax = mmWidthMax / 2.0;
	// _xZkqqHx_jAgDjApMiCkKiIoKiCmCiCmMjDfPiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeBiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
	vmmOutPoly.push_back(DBLPoint(vmmptAxis.front().x - mmWidthHalfMax,
								vmmptAxis.front().y - mmWidthHalfMax));
	vmmOutPoly.push_back(DBLPoint(vmmptAxis.front().x + mmWidthHalfMax,
								vmmptAxis.front().y - mmWidthHalfMax));
	vmmOutPoly.push_back(DBLPoint(vmmptAxis.front().x + mmWidthHalfMax,
								vmmptAxis.front().y + mmWidthHalfMax));
	vmmOutPoly.push_back(DBLPoint(vmmptAxis.front().x - mmWidthHalfMax,
								vmmptAxis.front().y + mmWidthHalfMax));
	vmmOutPoly.push_back(vmmOutPoly.front());
} // FCObjWidePoly::CalcOutline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetArrowF_AB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePjFpLjGoOiIpDiCmMiDhMiDeDiDjDiDgHiCgAiBeBiCgBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA	:A_xZkqqHx_iCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptB	:B_xZkqqHx_iCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::GetArrowF_AB (DBLPoint& mmptA, DBLPoint& mmptB) const
{
	const DBLPoint mmptL(FFCos(m_dArrowF_Angle), FFSin(m_dArrowF_Angle));
	const DBLPoint mmptO = GetJoint(0).m_mmptPivot;
	mmptA = mmptO + mmptL * m_mmArrowF_P;
	mmptB = mmptO + mmptL * m_mmArrowF_Q;
} // FCObjWidePoly::GetArrowF_AB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::GetArrowB_AB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDhMiDeDiDjDiDgHiCgAiBeBiCgBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA	:A_xZkqqHx_iCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptB	:B_xZkqqHx_iCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::GetArrowB_AB (DBLPoint& mmptA, DBLPoint& mmptB) const
{
	const DBLPoint mmptL(FFCos(m_dArrowB_Angle), FFSin(m_dArrowB_Angle));
	const DBLPoint mmptO = GetJoint(GetJointSize() - 1).m_mmptPivot;
	mmptA = mmptO + mmptL * m_mmArrowB_P;
	mmptB = mmptO + mmptL * m_mmArrowB_Q;
} // FCObjWidePoly::GetArrowB_AB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::JointUpdated
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJjCmKjCgNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WidePoly_xZkqqHx_iCmMiDhIiDfHiDeGiLmIjApMiLnPiOjHiCmFjHjIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::JointUpdated ()
{
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiNoMjAkMiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	ResetMakeBezier();
} // FCObjWidePoly::JointUpdated.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::CalcSideLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHlMjBkEiCmMiDhMiDiKiDiJiDeDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptLeft	:_xZkqqHx_iNlGjBkEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			vmmptRight	:_xZkqqHx_iJeFjBkEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::CalcSideLine (	DBLPointVector& vmmptLeft,
									DBLPointVector& vmmptRight,
									BYTEVector& vIsJointLeft,
									BYTEVector& vIsJointRight,
									mmetol& mmArrowF_P,
									mmetol& mmArrowF_Q,
									angle& dArrowF_Angle,
									mmetol& mmArrowB_P,
									mmetol& mmArrowB_Q,
									angle& dArrowB_Angle) const
{
	FCMmPolyBezier polyBezier;
	FCObjPoly::NewObjBezierForDraw(polyBezier);
	const DBLPoint mmptOf = polyBezier.front();
	const DBLPoint mmptOn = polyBezier.back();
	if (GetArrowFType() != FDUG_ARW_TYPE_FLAT)
	{
		FCBaseArrow* pArrowF;
		if (GetArrowFType() == FDUG_ARW_TYPE_PICT)
			pArrowF = new FCPictArrow(GetPictArrowF(), TRUE);
		else
			pArrowF = new FCStdArrow(FCUGArrowParams(GetArrowFType(), GetArrowFParam0(),
													GetArrowFParam1(), GetArrowFParam2()),
									TRUE);
		DBLPoint mmptA;
		DBLPoint mmptB;
		pArrowF->MakeFitBezier(	polyBezier,
								mmArrowF_P,
								mmArrowF_Q,
								mmptA,
								mmptB,
								GetPolyWidthF(),
								lg2mm(g_->lgdPrecision));
		delete pArrowF;
		// Angle_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
		// A=O_xZkqqHx_iCkKiCkAiCoIjDlOiCoJiClNiCnPiBeBjFeLiClI_xHqqkZx_B_xZkqqHx_iCpAiOgHiCmBiCmEiMhGiOfKiClHiCoJiClBiCmGiBeC_xHqqkZx_
		dArrowF_Angle = ArcTan(mmptB - mmptOf);
	} else
	{
		mmArrowF_P = -1.0;
		mmArrowF_Q = -1.0;
		dArrowF_Angle = -1.0;
	}
	if (GetArrowBType() != FDUG_ARW_TYPE_FLAT)
	{
		FCBaseArrow* pArrowB;
		if (GetArrowBType() == FDUG_ARW_TYPE_PICT)
			pArrowB = new FCPictArrow(GetPictArrowB(), TRUE);
		else
			pArrowB = new FCStdArrow(FCUGArrowParams(GetArrowBType(), GetArrowBParam0(),
													GetArrowBParam1(), GetArrowBParam2()),
									TRUE);
		polyBezier.Reverse();
		DBLPoint mmptA;
		DBLPoint mmptB;
		pArrowB->MakeFitBezier(	polyBezier,
								mmArrowB_P,
								mmArrowB_Q,
								mmptA,
								mmptB,
								GetPolyWidthB(),
								lg2mm(g_->lgdPrecision));
		polyBezier.Reverse();
		delete pArrowB;
		// Angle_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
		// A=O_xZkqqHx_iCkKiCkAiCoIjDlOiCoJiClNiCnPiBeBjFeLiClI_xHqqkZx_B_xZkqqHx_iCpAiOgHiCmBiCmEiMhGiOfKiClHiCoJiClBiCmGiBeC_xHqqkZx_
		dArrowB_Angle = ArcTan(mmptB - mmptOn);
	} else
	{
		mmArrowB_P = -1.0;
		mmArrowB_Q = -1.0;
		dArrowB_Angle = -1.0;
	}
	const mmetol mmWidthMax = GetPolyWidthF() < GetPolyWidthB() ? GetPolyWidthB() : GetPolyWidthF();
	const mmetol mmElemLen = lg2mm(g_->lgdPrecision);
	DBLPointVector vmmptAxis;
	BYTEVector vIsJointAxis;
	FFCalcBezier(	vmmptAxis,
					vIsJointAxis,
					polyBezier,
					mmWidthMax,
					mmElemLen,
					NULL,
					0);
	// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjDkPiClGiNmAjFfHiCpAjEhKjHpBiCkJiCoHiNoNiPjMiBeCjAgDiCmMiDhIiDfHiDeGjIeBiMiLjDfPiOjPjBoGiCmF_xHqqkZx_
	// _xZkqqHx_jDkPiClGiNmAjFfHiCkKjIeBjBlBiClHiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	FFRemoveSamePoint(vmmptAxis, vIsJointAxis);
	if (vmmptAxis.size() == 1)
	//----- _xZkqqHx_jAgDjApMiCkKiIoKiCmCiCmMjDfPiCmJiCmIiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMjApMiCmMjFjNiNeMjFjEjFgJiCmMiOgOjDfPiCmGiPeJjDfPiCpAjDkPiClGiNmAjFfHiCmJiClHiCoJiCmGiBeBiClBiClBiCmJiCkNiCoJiBeC_xHqqkZx_
		const mmetol mmWidthHalfMax = mmWidthMax / 2.0;
		// _xZkqqHx_jAgDjApMiCkKiIoKiCmCiCmMjDfPiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeBiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
		vmmptLeft.clear();
		vmmptRight.clear();
		vIsJointLeft.assign(2, TRUE);
		vIsJointRight.assign(2, TRUE);
		vmmptLeft.push_back(vmmptAxis.front() + DBLPoint(-mmWidthHalfMax, -mmWidthHalfMax));
		vmmptLeft.push_back(vmmptAxis.front() + DBLPoint(mmWidthHalfMax, -mmWidthHalfMax));
		vmmptRight.push_back(vmmptAxis.front() + DBLPoint(-mmWidthHalfMax, mmWidthHalfMax));
		vmmptRight.push_back(vmmptAxis.front() + DBLPoint(mmWidthHalfMax, mmWidthHalfMax));
	} else
	{
		// _xZkqqHx_jAgDjApMiCmMiNlGiJeFiCmMjBkEjApMiCpAiMhGiOfKiBeC_xHqqkZx_
		vmmptLeft.clear();
		vmmptRight.clear();
		vIsJointLeft.clear();
		vIsJointRight.clear();
		// _xZkqqHx_jBnBjFjNiCmMiMfIiOmOiPoOjFpBiCkJiCoHiBeB_xHqqkZx_(_xZkqqHx_jBnBjFjN_xHqqkZx_/2)_xZkqqHx_iCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		mmetolVector vmmW;
		FFCalcWideWidthArray(vmmW, vmmptAxis, vIsJointAxis,
							mmElemLen, GetPolyWidthF() / 2.0,
							GetPolyWidthB() / 2.0, GetWidthSlopeF(), GetWidthSlopeB());

		myCalcSideLine(vmmptLeft, vIsJointLeft, FALSE, vmmptAxis, vIsJointAxis, vmmW);
		myCalcSideLine(vmmptRight, vIsJointRight, TRUE, vmmptAxis, vIsJointAxis, vmmW);
	}
} // FCObjWidePoly::CalcSideLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::SetApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lBezierSize	:mmptBezier_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmptBezier _xZkqqHx_iCmNiBeB_xHqqkZx_P0,B0,C0,P1,B1,C1,P2_xZkqqHx_iBeFiBeFiBeFiCmGiCkCiCkEiLoPiNiHiCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::SetApproximateBezier (	const DBLPointVector& mmptvLeftBezier,
											const DBLPointVector& mmptvRightBezier,
											mmetol mmArrowF_P,
											mmetol mmArrowF_Q,
											angle dArrowF_Angle,
											mmetol mmArrowB_P,
											mmetol mmArrowB_Q,
											angle dArrowB_Angle)
{
	m_vmmptLeftBezier = mmptvLeftBezier;
	m_vmmptRightBezier = mmptvRightBezier;
	m_mmArrowF_P = mmArrowF_P;
	m_mmArrowF_Q = mmArrowF_Q;
	m_dArrowF_Angle = dArrowF_Angle;
	m_mmArrowB_P = mmArrowB_P;
	m_mmArrowB_Q = mmArrowB_Q;
	m_dArrowB_Angle = dArrowB_Angle;
} // FCObjWidePoly::SetApproximateBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::MoveApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiInKjDkOiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	:X_xZkqqHx_jFpLiMpMiCmMiInKjDkOiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDY	:Y_xZkqqHx_jFpLiMpMiCmMiInKjDkOiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::MoveApproximateBezier (mmetol mmDX, mmetol mmDY)
{
	if (!m_vmmptLeftBezier.empty())
	//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKiNoMjAkMiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FFMove(&m_vmmptLeftBezier[0], m_vmmptLeftBezier.size(), mmDX, mmDY);
		FFMove(&m_vmmptRightBezier[0], m_vmmptRightBezier.size(), mmDX, mmDY);
	} else
	//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKiCnMiClOiNoMjAkMiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCkCiCmBiClNiCpBjDgPjIfOiCpAjGjFiPmBiClFiCmEiCkJiCoHiNmEjDgPjIfOiBeCiCoAiClFiCoAiNkBiNoMjAkMjCiGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
		// _xZkqqHx_jDgPjIfOjGjFiPmBiCmFiNoMjAkMjCiGiCmMiPoOjFpBiCpAjEgKiKpMiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		ResetMakeBezier();
	}
} // FCObjWidePoly::MoveApproximateBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::ResizeApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCpAiOhHjCoIiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::ResizeApproximateBezier (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	// _xZkqqHx_iCkCiCmBiClNiCpBjDgPjIfOiCpAjGjFiPmBiClFiCmEiCkJiCoHiNmEjDgPjIfOiBeCiCoAiClFiCoAiNkBiNoMjAkMjCiGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGjFiPmBiCmFiNoMjAkMjCiGiCmMiPoOjFpBiCpAjEgKiKpMiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	ResetMakeBezier();
} // FCObjWidePoly::ResizeApproximateBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::RotateApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiJpBjDfNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR			:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_-2.0 < dR < 2.0_xZkqqHx_iBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::RotateApproximateBezier (double dR, const DBLPoint& mmptCenter)
{
	if (!m_vmmptLeftBezier.empty())
	//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKiNoMjAkMiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		const double dSin = FFSin(dR);
		const double dCos = FFCos(dR);
		RotateConv(	&m_vmmptLeftBezier[0], m_vmmptLeftBezier.size(),
					dSin, dCos, mmptCenter.x, mmptCenter.y);
		RotateConv(	&m_vmmptRightBezier[0], m_vmmptRightBezier.size(),
					dSin, dCos, mmptCenter.x, mmptCenter.y);
		m_dArrowF_Angle = RegulateAngle(m_dArrowF_Angle + dR);
		m_dArrowB_Angle = RegulateAngle(m_dArrowB_Angle + dR);
	} else
	//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCkKiCnMiClOiNoMjAkMiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCkCiCmBiClNiCpBjDgPjIfOiCpAjGjFiPmBiClFiCmEiCkJiCoHiNmEjDgPjIfOiBeCiCoAiClFiCoAiNkBiNoMjAkMjCiGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
		// _xZkqqHx_jDgPjIfOjGjFiPmBiCmFiNoMjAkMjCiGiCmMiPoOjFpBiCpAjEgKiKpMiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		ResetMakeBezier();
	}
} // FCObjWidePoly::RotateApproximateBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::ResetMakeBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMiDgGiBfLiDfOiCpAiNoNiPjMiClFiBeBiMhGiOfKjBnCiClPiDiKiDfIiDgHiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCmIiCmHiCmFjFjEjFgJiMgAiPpDiCmGiDhIiDfHiDeGiLmIjApMiCkKiIoKjChGiClFiCmIiCkNiCmIiCmBiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::ResetMakeBezier ()
{
	// _xZkqqHx_iCkCiCmBiClNiCpBjDgPjIfOiCpAjGjFiPmBiClFiCmEiCkJiCoHiNmEjDgPjIfOiBeCiCoAiClFiCoAiNkBiNoMjAkMjCiGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGjFiPmBiCmFiNoMjAkMjCiGiCmMiPoOjFpBiCpAjEgKiKpMiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	m_vmmptLeftBezier.clear();
	m_vmmptRightBezier.clear();
	m_mmArrowF_P = -1.0;
	m_mmArrowF_Q = -1.0;
	m_dArrowF_Angle = -1.0;
	m_mmArrowB_P = -1.0;
	m_mmArrowB_Q = -1.0;
	m_dArrowB_Angle = -1.0;
	UnregisterMakeBezier(this);
	RegisterMakeBezier(this);
} // FCObjWidePoly::ResetMakeBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::RegisterMakeBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiDiKiDfIiDgHiCmJjFjEjFgJiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::RegisterMakeBezier (FCObjWidePoly* pObj)
{
	s_stWaitObjToMakeBezier.insert(pObj);
	if (s_uMakeBezierTimerId == 0)
		s_uMakeBezierTimerId = ::SetTimer(NULL, NULL, 100, TIMERPROC(MakeBezierTimerProc));
} // FCObjWidePoly::RegisterMakeBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::UnregisterMakeBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiDiKiDfIiDgHiCkJiCoHjFjEjFgJiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::UnregisterMakeBezier (FCObjWidePoly* pObj)
{
	s_stWaitObjToMakeBezier.erase(pObj);
	// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiDfIiDiMiDgCiDgIjFmPjAjEiDeBiDeOiDfKiDfIjHhAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(s_MakeBezierThreadData.m_acsThreadVariable);
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiDgGiBfLiDfOiBeC_xHqqkZx_
	s_MakeBezierThreadData.m_mpWaitObjToData.erase(pObj);
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhIiDfHiDeGiNoMjAkMjHhAiDgGiBfLiDfOiBeC_xHqqkZx_
	s_MakeBezierThreadData.m_mpFinishObjToData.erase(pObj);
} // FCObjWidePoly::UnregisterMakeBezier.

//----- 06.03.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::myMakeBezierThread
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiLnPiOjHiMhGiOfKiCpAiOmAiNhDiClHiCoJiDfIiDiMiDgCiDgIiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pvoid	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void WINAPI FCObjWidePoly::myMakeBezierThread (LPVOID pvoid)
//{
//	myMakeBezierThreadData* pData = (myMakeBezierThreadData*)pvoid;
//	for (;;)
//	{
//		TRACE(_T("FCObjWidePoly::myMakeBezierThread A\n"));
//		// _xZkqqHx_iDeDiDhIiDjDiDgHiCkKiDfGiDePiDgJiDiLiCmJiCmIiCoJiCmMiCpAjBnCiCmCiBeC_xHqqkZx_
//		WaitForSingleObject(pData->m_hThreadEvent, INFINITE);
//
//		for (;;)
//		{
//			FCObjWidePoly* pObj = NULL;
//			DBLPointVector vmmptLeft;
//			DBLPointVector vmmptRight;
//			BYTEVector vIsJointLeft;
//			BYTEVector vIsJointRight;
//
//			{
//				FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
//				if (!pData->m_bIsTerminate &&
//					!pData->m_mpWaitObjToData.empty())
//				//----- _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjGlDiCkCiBjFiDhIiDfHiDeGiMhGiOfKjBnCiClPjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFkBiOmKiBeC_xHqqkZx_
//					pObj = (*pData->m_mpWaitObjToData.begin()).first;
//					vmmptLeft = (*pData->m_mpWaitObjToData.begin()).second.vmmptLeft;
//					vmmptRight = (*pData->m_mpWaitObjToData.begin()).second.vmmptRight;
//					vIsJointLeft = (*pData->m_mpWaitObjToData.begin()).second.vIsJointLeft;
//					vIsJointRight = (*pData->m_mpWaitObjToData.begin()).second.vIsJointRight;
//				}
//			}
//			// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjHeMiCoJiPoKiNiHiBeBiIlNiCkCiCmNiDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMiDgGiBfLiDfOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
//			if (pObj == NULL) break;
//			// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//			DBLPointVector vmmptLeftBezier;
//			MakeApproximateBezier(vmmptLeftBezier, vmmptLeft.begin(), vmmptLeft.size(), vIsJointLeft.begin());
//			DBLPointVector vmmptRightBezier;
//			MakeApproximateBezier(vmmptRightBezier, vmmptRight.begin(), vmmptRight.size(), vIsJointRight.begin());
//			{
//				FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
//				map<FCObjWidePoly*, myObjPolyData>::iterator iOd = pData->m_mpWaitObjToData.find(pObj);
//				if (iOd != pData->m_mpWaitObjToData.end())
//				//----- _xZkqqHx_iMhGiOfKjBmOiPnLiCmMjFjEjFgJiCkKiNoNiPjMiClDiCoKiCmEiCmNiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//				{
//					if (vmmptLeft == (*iOd).second.vmmptLeft &&
//						vmmptRight == (*iOd).second.vmmptRight)
//					//----- _xZkqqHx_iMhGiOfKiKeKiOgOiOjOiCmGiPeJjHlJiOjOiCmFiDhMiDiKiDiJiDeDiDjDiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iMhGiOfKiNmPiCnNiCmMjFjEjFgJ_xHqqkZx_->_xZkqqHx_iDhIiDfHiDeGiNoMjAkMjHhAiDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//						pData->m_mpFinishObjToData[pObj].vmmptLeft = vmmptLeftBezier;
//						pData->m_mpFinishObjToData[pObj].vmmptRight = vmmptRightBezier;
//						pData->m_mpFinishObjToData[pObj].mmArrowF_P = (*iOd).second.mmArrowF_P;
//						pData->m_mpFinishObjToData[pObj].mmArrowF_Q = (*iOd).second.mmArrowF_Q;
//						pData->m_mpFinishObjToData[pObj].dArrowF_Angle = (*iOd).second.dArrowF_Angle;
//						pData->m_mpFinishObjToData[pObj].mmArrowB_P = (*iOd).second.mmArrowB_P;
//						pData->m_mpFinishObjToData[pObj].mmArrowB_Q = (*iOd).second.mmArrowB_Q;
//						pData->m_mpFinishObjToData[pObj].dArrowB_Angle = (*iOd).second.dArrowB_Angle;
//					}
//					// _xZkqqHx_iMhGiOfKjBnCiClPiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//					pData->m_mpWaitObjToData.erase(iOd);
//				}
//			}
//		}
//		{
//			FCAutoLeaveCriticalSection atlcs(pData->m_acsThreadVariable);
//			// _xZkqqHx_iDeDiDhIiDjDiDgHiCpAjEpBiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_
//			ResetEvent(pData->m_hThreadEvent);
//			if (pData->m_bIsTerminate)
//			//----- _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
//				CloseHandle(pData->m_hThreadEvent);
//				pData->m_hThreadEvent = INVALID_HANDLE_VALUE;
//				// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJiBeC_xHqqkZx_
//				break;
//			}
//		}
//		TRACE(_T("FCObjWidePoly::myMakeBezierThread C\n"));
//	}
//} // FCObjWidePoly::myMakeBezierThread.
//----- 06.03.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::MakeBezierTimerProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiMhGiOfKjHhAiCmMiDfOiDeDiDhNiBfLiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::MakeBezierTimerProc (	HWND hwnd,
											UINT uMsg,
											UINT_PTR idEvent,
											DWORD dwTime)
{
	TRACE(_T("MakeBezierTimerProc\n"));
	if (FFGetCapture() == NULL)
	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDjCiGiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFjEjFgJiCmMiNoMjAkMjCiGiCmIiCmHiCpAjEpAiCkPiCoJiClNiCnPiBeBiDeMiDiDiDhGiDgAiDiDjCiGiCmNiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_

//----- 06.03.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
//		if (s_hFlushThreadHandle == INVALID_HANDLE_VALUE)
//		//----- _xZkqqHx_iCnMiClOiDfIiDiMiDgCiDgIiCpAiOmAiNhDiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfIiDiMiDgCiDgIiCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDgCiDfGiDiHiDjDiBeC_xHqqkZx_
//			FCAutoLeaveCriticalSection atlcs(s_MakeBezierThreadData.m_acsThreadVariable);
//			// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
//			s_MakeBezierThreadData.m_hThreadEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
//			// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
//			DWORD dwFlushThreadId;
//			s_hFlushThreadHandle =
//				CreateThread(NULL, 0, (PTHREAD_START_ROUTINE)FCObjWidePoly::myMakeBezierThread,
//							(LPVOID)&s_MakeBezierThreadData, 0, &dwFlushThreadId);
//		}
//----- 06.03.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_iDfIiDiMiDgCiDgIiCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDgCiDfGiDiHiDjDiBeC_xHqqkZx_
		FCAutoLeaveCriticalSection atlcs(s_MakeBezierThreadData.m_acsThreadVariable);

		//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKiNmPiCnNiCmMiDgGiBfLiDfOiCpAiPiIjHjN_xHqqkZx_ -----
		map<FCObjWidePoly*, myObjPolyData>::const_iterator iOd;
		for (iOd = s_MakeBezierThreadData.m_mpFinishObjToData.begin();
			 iOd != s_MakeBezierThreadData.m_mpFinishObjToData.end(); iOd++)
		{
			// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjAnNjCoIiBeC_xHqqkZx_
			(*iOd).first->SetApproximateBezier(	(*iOd).second.vmmptLeft,
												(*iOd).second.vmmptRight,
												(*iOd).second.mmArrowF_P,
												(*iOd).second.mmArrowF_Q,
												(*iOd).second.dArrowF_Angle,
												(*iOd).second.mmArrowB_P,
												(*iOd).second.mmArrowB_Q,
												(*iOd).second.dArrowB_Angle);
		}
		// _xZkqqHx_iMhGiOfKiNmPiCnNiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		s_MakeBezierThreadData.m_mpFinishObjToData.clear();

		if (!s_stWaitObjToMakeBezier.empty())
		//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			BOOL bNewWaitObj = FALSE;
			set<FCObjWidePoly*>::const_iterator iObj;
			for (iObj = s_stWaitObjToMakeBezier.begin();
				 iObj != s_stWaitObjToMakeBezier.end(); iObj++)
			{
				// _xZkqqHx_jFjEjFgJiCmMiDfEiDeDiDgIiDiJiDeDiDjDiCmMiDhMiDiKiDfDiDjDiCpAiMhGiOfKiClFiCmEiBeBiDfIiDiMiDgCiDgIiCmJjDgOiClHiBeC_xHqqkZx_
				// _xZkqqHx_iDfIiDiMiDgCiDgIiCmNiDfEiDeDiDgIiDiJiDeDiDjDiCpAiMlDiCmJiBeBiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_

				// _xZkqqHx_iDfHiDiHiDeDiDjDiDgHiCkKjGlDiCkCiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
				if ((*iObj)->GetJointSize() == 0) continue;
				// _xZkqqHx_iNlGiJeFiCmMjBkEiDhMiDiKiDiJiDeDiDjDiCpAiOoGjDlOiBeC_xHqqkZx_
				DBLPointVector vmmptLeftPoly;
				DBLPointVector vmmptRightPoly;
				BYTEVector vIsJointLeft;
				BYTEVector vIsJointRight;
				mmetol mmArrowF_P;
				mmetol mmArrowF_Q;
				angle dArrowF_Angle;
				mmetol mmArrowB_P;
				mmetol mmArrowB_Q;
				angle dArrowB_Angle;
				(*iObj)->CalcSideLine(	vmmptLeftPoly,
										vmmptRightPoly,
										vIsJointLeft,
										vIsJointRight,
										mmArrowF_P,
										mmArrowF_Q,
										dArrowF_Angle,
										mmArrowB_P,
										mmArrowB_Q,
										dArrowB_Angle);
				if (!vmmptLeftPoly.empty())
				//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
				{
					bNewWaitObj = TRUE;
					// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMiDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].vmmptLeft = vmmptLeftPoly;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].vmmptRight = vmmptRightPoly;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].vIsJointLeft = vIsJointLeft;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].vIsJointRight = vIsJointRight;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].mmArrowF_P = mmArrowF_P;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].mmArrowF_Q = mmArrowF_Q;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].dArrowF_Angle = dArrowF_Angle;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].mmArrowB_P = mmArrowB_P;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].mmArrowB_Q = mmArrowB_Q;
					s_MakeBezierThreadData.m_mpWaitObjToData[*iObj].dArrowB_Angle = dArrowB_Angle;
				}
			}
			s_stWaitObjToMakeBezier.clear();
			// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiCpAiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_PulseEvent _xZkqqHx_iClOiCmGiBeB_xHqqkZx_
			// WaitForSingleObject _xZkqqHx_iCmJjDpMiCmBiCmEiPkNiClFiOjOiKnEiCkKiMgPiClNiCmIiCkCiCmG_xHqqkZx_
			// _xZkqqHx_iCkEiCnMiCkNjDkOiNoMiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
			if (bNewWaitObj) SetEvent(s_MakeBezierThreadData.m_hThreadEvent);
		}

		if (s_MakeBezierThreadData.m_mpWaitObjToData.empty())
		//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMiDgGiBfLiDfOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiDeDiDhNiBfLiCpAiJpAiPjMiBeC_xHqqkZx_
			::KillTimer(NULL, s_uMakeBezierTimerId);
			s_uMakeBezierTimerId = 0;
		}
	}
} // FCObjWidePoly::MakeBezierTimerProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjWidePoly::MakeApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptBezier	:_xZkqqHx_iLnPiOjHiClFiClNiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptPoly	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPolySize	:mmptPoly_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjWidePoly::MakeApproximateBezier (DBLPointVector& vmmptBezier, const DBLPoint* mmptPoly, long lPolySize, const BYTE* pIsJoint)
{
	//----- _xZkqqHx_iDhIiDfHiDeGiNoMjAkMiCpAiOmAiNhD_xHqqkZx_ -----

	DBLPointVector vPoly(mmptPoly, mmptPoly + lPolySize);
	BYTEVector vIsJoint(pIsJoint, pIsJoint + lPolySize);
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	doubleVector vLineAngle;
	FFGetLineAngle(vLineAngle, vPoly.size(), vPoly.begin());
	// _xZkqqHx_iKhAjDhIiCkKjFmPiCoNiCoHiCmIiCkCiDhMiDeDiDjDiDgHiCpAiPmIjHkKiBeC_xHqqkZx_
	FFOmitAngle0Point(vPoly, vIsJoint, vLineAngle);
	// _xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiBeC_xHqqkZx_
	FCBezierControlsVector vControls;
	FCApproximateBezier ab;
	ab.m_dJointAngle1 = 0.1;
	ab.m_dSplitAngle0 = 0.8;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_

	ab.m_dSplitAngle1 = 0.4;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_

	ab.m_dAngleDiffLimit = 0.4;
	set<long> stJoint;
	ab.GetJoint(stJoint, vPoly.begin(), vPoly.size(), vLineAngle.begin());

	// vIsJoint_xZkqqHx_iCmMjFhDjIeBjBlBjDfPiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
	for (long lC = 0; lC != vIsJoint.size(); lC++)
	{
		if (vIsJoint[lC]) stJoint.insert(lC);
	}
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiBeC_xHqqkZx_
	ab.JointsToBezier(vControls, stJoint, vPoly.begin(), vLineAngle.begin());

	// _xZkqqHx_iDhIiDfHiDeGjAkHiMoEjDfPjEhKjHpBiCpAjFkBiOmKiBeC_xHqqkZx_
	vmmptBezier.clear();
	FCBezierControlsVector::const_iterator iBc = vControls.begin();
	vmmptBezier.push_back((*iBc).m_mmptControl[0]);
	for (; iBc != vControls.end(); iBc++)
	{
		vmmptBezier.push_back((*iBc).m_mmptControl[1]);
		vmmptBezier.push_back((*iBc).m_mmptControl[2]);
		vmmptBezier.push_back((*iBc).m_mmptControl[3]);
	}
} // FCObjWidePoly::MakeApproximateBezier.

