#include "stdafx.h"
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include <float.h>			// For DBL_MAX.
#include <algorithm>		// For sort,unique template.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For HitTest.
#include "UtilGraph.h"		// For FCEditDraw.
#include "UtilBezier.h"		// For FCMmPolyBezier.
#include "UtilErr.h"		// For FFThrowMiscUnknown().
#include "RegData.h"		// For GetOptiRegColor.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "PolyJoint.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FDPJ_PULL_LAB_X	4	// 'F','b'_xZkqqHx_iLeMiNiGiCmMiBeBjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
#define FDPJ_PULL_LAB_Y	6	// 'F','b'_xZkqqHx_iLeMiNiGiCmMiBeBjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
#define FDPJ_PULL_LAB_D	14	// _xZkqqHx_iIpIjDfPiCkJiCoH_xHqqkZx_'F','b'_xZkqqHx_iLeMiNiGiCmMjCiGjAfDjDfPiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_

//                                _xZkqqHx_iEkBiEjPiEjPiEjP_xHqqkZx_
//                                _xZkqqHx_iEkA_xHqqkZx_      
//                                _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_    _xZkqqHx_iEkG_xHqqkZx_
//                                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
//                                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
//                                          _xZkqqHx_iEkA_xHqqkZx_
//                                          _xZkqqHx_iEkA_xHqqkZx_
//                      PULL_LAB_D          _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_D
//                 _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//             _xZkqqHx_iEkBiEjPiEjPiEjP_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//             _xZkqqHx_iEkA_xHqqkZx_                    _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//             _xZkqqHx_iEkA_xHqqkZx_                    _xZkqqHx_iBkB_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkI_xHqqkZx_
//             _xZkqqHx_iEkA_xHqqkZx_                    _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iBkB_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_
//                                   _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkGiEjP_xHqqkZx_    _xZkqqHx_iBkB_xHqqkZx_             _xZkqqHx_iEkAiBfOiBfAiBfP_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkAiBfPiBfBiBfO_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//                 PULL_LAB_D_xZkqqHx_iEkA_xHqqkZx_           PULL_LAB_D
//                           _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
//                           _xZkqqHx_iEkI_xHqqkZx_   _xZkqqHx_iEkAiBfOiBfAiBfP_xHqqkZx_
//                                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
//                                _xZkqqHx_iEkAiBfPiBfBiBfO_xHqqkZx_
//
//
//
//
//                   _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEjPiEkG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_    __xZkqqHx_iBfBiBfBiBfBiBfBiBfB_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_           _xZkqqHx_iBfP_xHqqkZx_   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkAiBfO_xHqqkZx_               _xZkqqHx_iBfP_xHqqkZx_ _xZkqqHx_iBeGiEjPiEkJiEjPiEkG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                  _xZkqqHx_iEkAiBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                  _xZkqqHx_iEkAiBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                  _xZkqqHx_iEkAiBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
//                   _xZkqqHx_iBeGiEkAiBfP_xHqqkZx_               _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_  _xZkqqHx_iBfPiBfBiBfBiBfBiBfB_xHqqkZx___xZkqqHx_iBfBiBfO_xHqqkZx_   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEjPiEkI_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//                     PULL_LAB_X  PULL_LAB_X        _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_D
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                             _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                             _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEjPiEjPiEjPiEjPiEkI_xHqqkZx_
//                             _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                             _xZkqqHx_iEkBiEkJiEkC_xHqqkZx_
//                             _xZkqqHx_iEkAiEkAiEkA_xHqqkZx_
//                             _xZkqqHx_iEkEiEkJiEkD_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                               _xZkqqHx_iEkA_xHqqkZx_
//                             _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_
//                             _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEjPiEjPiEjPiEjPiEkG_xHqqkZx_
//                             _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_D
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                                                   _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEjPiEkG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_    _xZkqqHx_iBeGiEjPiEkJiEjPiEkI_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iBeGiEkA_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEjPiEkI_xHqqkZx_
//                   _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//                     PULL_LAB_X  PULL_LAB_X
//
//

//////////////////////////////////////////////////////////////////////////
////////////////////////////// FCPolyJoint /////////////////////////////////
//////////////////////////////////////////////////////////////////////////

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DrawPrevPullLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjDfPiCpAjCiGjAfDiCmJiBeBjBePiIpIjDfPiCmMiLeMiNiGiBhFiCgFiBhGiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	eDraw		:_xZkqqHx_jFgAiJoGjHhAiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgptCenter	:_xZkqqHx_jFgAiJoGiImKjChFiCmMjCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lgptCenter_xZkqqHx_iCpAjCiGjAfDiCmJiBeB_xHqqkZx_x_xZkqqHx_jFpLiMpMiCmN_xHqqkZx_[-4, +4]_xZkqqHx_iBeB_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmN_xHqqkZx_[-6, +6]_xZkqqHx_iCmMjEmNiImNiCmJ_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void DrawPrevPullLabel (FCEditDraw& eDraw, const CPoint& lgptCenter)
{
	eDraw.Line(	&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X, -FDPJ_PULL_LAB_Y)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X, -FDPJ_PULL_LAB_Y)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X, +FDPJ_PULL_LAB_Y)));
	eDraw.Line(	&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X + 1, -1)),
				&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X - 2, -1)));
} // DrawPrevPullLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DrawNextPullLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjDfPiCpAjCiGjAfDiCmJiBeBiMoDiIpIjDfPiCmMiLeMiNiGiBhFiCiCiBhGiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	eDraw		:_xZkqqHx_jFgAiJoGjHhAiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgptCenter	:_xZkqqHx_jFgAiJoGiImKjChFiCmMjCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lgptCenter_xZkqqHx_iCpAjCiGjAfDiCmJiBeB_xHqqkZx_x_xZkqqHx_jFpLiMpMiCmN_xHqqkZx_[-4, +4]_xZkqqHx_iBeB_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmN_xHqqkZx_[-6, +6]_xZkqqHx_iCmMjEmNiImNiCmJ_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void DrawNextPullLabel (FCEditDraw& eDraw, const CPoint& lgptCenter)
{
	eDraw.Line(	&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X, -FDPJ_PULL_LAB_Y)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X, +FDPJ_PULL_LAB_Y)));
	eDraw.Line(	&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X + 1,  0)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X + 3, -2)),
				&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X - 2, -2)),
				&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X,  0)),
				&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X, +FDPJ_PULL_LAB_Y - 2)),
				&(lgptCenter + CPoint(+FDPJ_PULL_LAB_X - 2, +FDPJ_PULL_LAB_Y)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X + 3, +FDPJ_PULL_LAB_Y)),
				&(lgptCenter + CPoint(-FDPJ_PULL_LAB_X + 1, +FDPJ_PULL_LAB_Y - 2)));
} // DrawNextPullLabel.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::FCPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJoint::FCPolyJoint ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(this, 0, sizeof(*this));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCPolyJoint::FCPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::FCPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiIpIjAjEiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType		:_xZkqqHx_jIeBiMiLjDfPiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPivot	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPrev,	:_xZkqqHx_jIeBiMiLjDfPiCmMjBePiIpIjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptNext	:_xZkqqHx_jIeBiMiLjDfPiCmMiMoDiIpIjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJoint::FCPolyJoint (short nType, DBLPoint mmptPivot,
					  DBLPoint mmptPrev, DBLPoint mmptNext)
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(this, 0, sizeof(*this));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	m_nType = nType;
	m_mmptPivot = mmptPivot;
	m_mmptPrev = mmptPrev;
	m_mmptNext = mmptNext;
} // FCPolyJoint::FCPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetJointType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCPolyJoint::GetJointType () const
{
	return m_nType;
} // FCPolyJoint::GetJointType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPivotPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCPolyJoint::GetPivotPoint () const
{
	return m_mmptPivot;
} // FCPolyJoint::GetPivotPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevPullPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCPolyJoint::GetPrevPullPoint () const
{
	return m_mmptPivot + m_mmptPrev;
} // FCPolyJoint::GetPrevPullPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextPullPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCPolyJoint::GetNextPullPoint () const
{
	return m_mmptPivot + m_mmptNext;
} // FCPolyJoint::GetNextPullPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPivotX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetPivotX () const
{
	return m_mmptPivot.x;
} // FCPolyJoint::GetPivotX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPivotY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetPivotY () const
{
	return m_mmptPivot.y;
} // FCPolyJoint::GetPivotY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevPullX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetPrevPullX () const
{
	return m_mmptPrev.x;
} // FCPolyJoint::GetPrevPullX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevPullY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetPrevPullY () const
{
	return m_mmptPrev.y;
} // FCPolyJoint::GetPrevPullY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextPullX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiChHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetNextPullX () const
{
	return m_mmptNext.x;
} // FCPolyJoint::GetNextPullX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextPullY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiChIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPolyJoint::GetNextPullY () const
{
	return m_mmptNext.y;
} // FCPolyJoint::GetNextPullY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevChar1Rect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfAiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfAiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmNiBeBiClLiCmMiCmGiCkLiCmMiDfJiBfLiDiAjCgMiCmMiJgFiLlPiCpAiOpDiCkPiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfJiBfLiDiAjCgMiCkKjFmPiCoNiCoKiCmOiBeBiLoJiMgAiNmAjFfHiCoAjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmM_xHqqkZx_ Char1_xZkqqHx_iBeB_xHqqkZx_Char2 _xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiOkGiClHiBeC_xHqqkZx_
 *
 *                         Char1        
 *                        _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_        
 *                        _xZkqqHx_iEkFiEjP_xHqqkZx_          
 *                        _xZkqqHx_iEkA_xHqqkZx_            
 *              Char2                   
 *             _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_                   
 *             _xZkqqHx_iEkFiEjP_xHqqkZx_                     
 *             _xZkqqHx_iEkA_xHqqkZx_           _xZkqqHx_iBkB_xHqqkZx_ PrevPull 
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBkB_xHqqkZx_ Pivot    
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPolyJoint::GetPrevChar1Rect () const
{
	const mmetol mmPullLabX = lg2mm(FDPJ_PULL_LAB_X);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabY = lg2mm(FDPJ_PULL_LAB_Y);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabD = lg2mm(FDPJ_PULL_LAB_D);	// _xZkqqHx_iIpIjDfPiCkJiCoHiDeMiDiDiDiJiDeOiDfOiCmMjCiGjAfDjDfPiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
	const DBLPoint mmptCenter(GetPrevPullPoint() - DBLPoint(0.0, mmPullLabD));
	return DBLRect(	mmptCenter.x - mmPullLabX,
					mmptCenter.y - mmPullLabY,
					mmptCenter.x + mmPullLabX,
					mmptCenter.y + mmPullLabY);
} // FCPolyJoint::GetPrevChar1Rect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevChar2Rect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfBiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfBiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmNiBeBiClLiCmMiCmGiCkLiCmMiDfJiBfLiDiAjCgMiCmMiJgFiLlPiCpAiOpDiCkPiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfJiBfLiDiAjCgMiCkKjFmPiCoNiCoKiCmOiBeBiLoJiMgAiNmAjFfHiCoAjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmM_xHqqkZx_ Char1_xZkqqHx_iBeB_xHqqkZx_Char2 _xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiOkGiClHiBeC_xHqqkZx_
 *
 *                         Char1        
 *                        _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_        
 *                        _xZkqqHx_iEkFiEjP_xHqqkZx_          
 *                        _xZkqqHx_iEkA_xHqqkZx_            
 *              Char2                   
 *             _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_                   
 *             _xZkqqHx_iEkFiEjP_xHqqkZx_                     
 *             _xZkqqHx_iEkA_xHqqkZx_           _xZkqqHx_iBkB_xHqqkZx_ PrevPull 
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBkB_xHqqkZx_ Pivot    
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPolyJoint::GetPrevChar2Rect () const
{
	const mmetol mmPullLabX = lg2mm(FDPJ_PULL_LAB_X);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabY = lg2mm(FDPJ_PULL_LAB_Y);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabD = lg2mm(FDPJ_PULL_LAB_D);	// _xZkqqHx_iIpIjDfPiCkJiCoHiDeMiDiDiDiJiDeOiDfOiCmMjCiGjAfDjDfPiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
	const DBLPoint mmptCenter(GetPrevPullPoint() - DBLPoint(mmPullLabD, 0.0));
	return DBLRect(	mmptCenter.x - mmPullLabX,
					mmptCenter.y - mmPullLabY,
					mmptCenter.x + mmPullLabX,
					mmptCenter.y + mmPullLabY);
} // FCPolyJoint::GetPrevChar2Rect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextChar1Rect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfAiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfAiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmNiBeBiClLiCmMiCmGiCkLiCmMiDfJiBfLiDiAjCgMiCmMiJgFiLlPiCpAiOpDiCkPiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfJiBfLiDiAjCgMiCkKjFmPiCoNiCoKiCmOiBeBiLoJiMgAiNmAjFfHiCoAjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmM_xHqqkZx_ Char1_xZkqqHx_iBeB_xHqqkZx_Char2 _xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiOkGiClHiBeC_xHqqkZx_
 *
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBkB_xHqqkZx_ Pivot    
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_    
 *                 NextPull _xZkqqHx_iBkB_xHqqkZx_        _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_
 *                                     Char2
 *                        _xZkqqHx_iEkA_xHqqkZx_            
 *                        _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_        
 *                        _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_        
 *                         Char1        
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPolyJoint::GetNextChar1Rect () const
{
	const mmetol mmPullLabX = lg2mm(FDPJ_PULL_LAB_X);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabY = lg2mm(FDPJ_PULL_LAB_Y);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabD = lg2mm(FDPJ_PULL_LAB_D);	// _xZkqqHx_iIpIjDfPiCkJiCoHiDeMiDiDiDiJiDeOiDfOiCmMjCiGjAfDjDfPiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
	const DBLPoint mmptCenter(GetNextPullPoint() + DBLPoint(0.0, mmPullLabD));
	return DBLRect(	mmptCenter.x - mmPullLabX,
					mmptCenter.y - mmPullLabY,
					mmptCenter.x + mmPullLabX,
					mmptCenter.y + mmPullLabY);
} // FCPolyJoint::GetNextChar1Rect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextChar2Rect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfBiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMiDeMiDiDiDiJiDeOiDfOiCfBiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmNiBeBiClLiCmMiCmGiCkLiCmMiDfJiBfLiDiAjCgMiCmMiJgFiLlPiCpAiOpDiCkPiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfJiBfLiDiAjCgMiCkKjFmPiCoNiCoKiCmOiBeBiLoJiMgAiNmAjFfHiCoAjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmM_xHqqkZx_ Char1_xZkqqHx_iBeB_xHqqkZx_Char2 _xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiOkGiClHiBeC_xHqqkZx_
 *
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iBeG_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iBkB_xHqqkZx_ Pivot    
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_          
 *                          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_    
 *                 NextPull _xZkqqHx_iBkB_xHqqkZx_        _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_
 *                                     Char2
 *                        _xZkqqHx_iEkA_xHqqkZx_            
 *                        _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_        
 *                        _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_        
 *                         Char1        
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPolyJoint::GetNextChar2Rect () const
{
	const mmetol mmPullLabX = lg2mm(FDPJ_PULL_LAB_X);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabY = lg2mm(FDPJ_PULL_LAB_Y);	// _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjCiGjAfDjDfPiCkJiCoHjCfLiCnMiCmFiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiLjHjHkDiBeC_xHqqkZx_
	const mmetol mmPullLabD = lg2mm(FDPJ_PULL_LAB_D);	// _xZkqqHx_iIpIjDfPiCkJiCoHiDeMiDiDiDiJiDeOiDfOiCmMjCiGjAfDjDfPiCnMiCmFiCmMiLjHjHkDiBeC_xHqqkZx_
	const DBLPoint mmptCenter(GetNextPullPoint() + DBLPoint(mmPullLabD, 0.0));
	return DBLRect(	mmptCenter.x - mmPullLabX,
					mmptCenter.y - mmPullLabY,
					mmptCenter.x + mmPullLabX,
					mmptCenter.y + mmPullLabY);
} // FCPolyJoint::GetNextChar2Rect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetJointType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDfOiDeDiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jIeBiMiLjDfPiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetJointType (short nType)
{
	m_nType = nType;
	if (m_nType & 0x01)
		m_mmptPrev.SetPoint(0, 0);
	if (m_nType & 0x04)
		m_mmptNext.SetPoint(0, 0);
} // FCPolyJoint::SetJointType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::MovePivot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMov	:_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::MovePivot (const DBLPoint& mmptMov)
{
	m_mmptPivot += mmptMov;
} // FCPolyJoint::MovePivot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetPivotX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetPivotX (mmetol mm)
{
	m_mmptPivot.x = mm;
} // FCPolyJoint::SetPivotX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetPivotY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetPivotY (mmetol mm)
{
	m_mmptPivot.y = mm;
} // FCPolyJoint::SetPivotY.

//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetPrevPull
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_jBePiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCPolyJoint::SetPrevPull (const DBLPoint& mmpt)
//{
//	m_mmptPrev = mmpt;
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptPrev.x != 0 || m_mmptPrev.y != 0)
//		{
//			double dR = m_mmptNext.Len() / m_mmptPrev.Len();
//			m_mmptNext = -dR * m_mmptPrev;
//		}
//	}
//} // FCPolyJoint::SetPrevPull.
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::MovePrev
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMov	:_xZkqqHx_jBePiIpIjDfPiCmMiInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::MovePrev (const DBLPoint& mmptMov)
{
	SetAutoPrevPull(m_mmptPrev + mmptMov);
} // FCPolyJoint::MovePrev.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetPrevPullX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_jBePiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetPrevPullX (mmetol mm)
{
	m_mmptPrev.x = mm;
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptPrev.x != 0 || m_mmptPrev.y != 0)
//		{
//			double dR = m_mmptNext.Len() / m_mmptPrev.Len();
//			m_mmptNext = -dR * m_mmptPrev;
//		}
//	}
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCPolyJoint::SetPrevPullX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetPrevPullY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_jBePiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetPrevPullY (mmetol mm)
{
	m_mmptPrev.y = mm;
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptPrev.x != 0 || m_mmptPrev.y != 0)
//		{
//			double dR = m_mmptNext.Len() / m_mmptPrev.Len();
//			m_mmptNext = -dR * m_mmptPrev;
//		}
//	}
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCPolyJoint::SetPrevPullY.

//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetNextPull
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_iMoDiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCPolyJoint::SetNextPull (const DBLPoint& mmpt)
//{
//	m_mmptNext = mmpt;
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptNext.x != 0 || m_mmptNext.y != 0)
//		{
//			double dR = m_mmptPrev.Len() / m_mmptNext.Len();
//			m_mmptPrev = -dR * m_mmptNext;
//		}
//	}
//} // FCPolyJoint::SetNextPull.
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::MoveNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMov	:_xZkqqHx_iMoDiIpIjDfPiCmMiInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::MoveNext (const DBLPoint& mmptMov)
{
	SetAutoNextPull(m_mmptNext + mmptMov);
} // FCPolyJoint::MoveNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetNextPullX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_iMoDiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetNextPullX (mmetol mm)
{
	m_mmptNext.x = mm;
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptNext.x != 0 || m_mmptNext.y != 0)
//		{
//			double dR = m_mmptPrev.Len() / m_mmptNext.Len();
//			m_mmptPrev = -dR * m_mmptNext;
//		}
//	}
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCPolyJoint::SetNextPullX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetNextPullX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_iMoDiIpIjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetNextPullY (mmetol mm)
{
	m_mmptNext.y = mm;
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----*/
//	if (m_nType == FDJT_ROUND)
//	{
//		if (m_mmptNext.x != 0 || m_mmptNext.y != 0)
//		{
//			double dR = m_mmptPrev.Len() / m_mmptNext.Len();
//			m_mmptPrev = -dR * m_mmptNext;
//		}
//	}
//----- 00.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCPolyJoint::SetNextPullY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetAutoPrevPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCpAjAnNjCoIiClHiCoJiBeCiMoDiIpIjDfPiCkKiOkJjDkOjDeJiCmJjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_jBePiIpIjDfPiCpAiDeKiDgJiDiBjDfPiCmGiCmMjBiKjBmOiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetAutoPrevPull (const DBLPoint& mmpt)
{
	m_mmptPrev = mmpt;
	//----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----
	if (m_nType == FDJT_ROUND)
	{
// 00.09.19 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (m_mmptPrev.x != 0 || m_mmptPrev.y != 0)
		if (!almost0(m_mmptPrev.x) || !almost0(m_mmptPrev.y))
		{
			double dR = m_mmptNext.Len() / m_mmptPrev.Len();
			m_mmptNext = -dR * m_mmptPrev;
		}
	}
} // FCPolyJoint::SetAutoPrevPull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::SetAutoNextPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCpAjAnNjCoIiClHiCoJiBeCjBePiIpIjDfPiCkKiOkJjDkOjDeJiCmJjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_iMoDiIpIjDfPiCpAiDeKiDgJiDiBjDfPiCmGiCmMjBiKjBmOiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::SetAutoNextPull (const DBLPoint& mmpt)
{
	m_mmptNext = mmpt;
	//----- _xZkqqHx_iKnLjIeBiMiLjDfPiCmMiPoKiNiHiCmNiIpIjApMiCkKjClMjApMiCmJiCmIiCoJiCoGiCkEiCmJiMoDiIpIjDfPiCpAjFmPiNfI_xHqqkZx_ -----
	if (m_nType == FDJT_ROUND)
	{
// 00.09.19 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (m_mmptNext.x != 0 || m_mmptNext.y != 0)
		if (!almost0(m_mmptNext.x) || !almost0(m_mmptNext.y))
		{
			double dR = m_mmptPrev.Len() / m_mmptNext.Len();
			m_mmptPrev = -dR * m_mmptNext;
		}
	}
} // FCPolyJoint::SetAutoNextPull.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::DrawPivotMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgJiDiBjDfPiCmMjFfMiOkGiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCPolyJoint::DrawPivotMark (CDC* pDC) const
//{
//	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiClFiBeBjEpBjBeJjBpAiPpDjBnEiCmMiDeKiDgJiDiBjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
//	FCEditDraw(pDC, 0).UnselMark(mm2lg(m_mmptPivot));
//} // FCPolyJoint::DrawPivotMark.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::DrawPullMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::DrawPullMark (CDC* pDC) const
{
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMjIfPjHjNiNmAjFfHjCgMiBeC_xHqqkZx_
	CPoint lgptPivot = mm2lg(m_mmptPivot);
	// _xZkqqHx_jBmOiPnLjIeBiMiLjDfPiCmMjBeJjBpAiLoJiMgAiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
	eDraw.SelMark(lgptPivot);
	if (!(m_nType & 0x01))
	//----- _xZkqqHx_jBePiIpIjApMiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_) -----
	{
		//----- _xZkqqHx_jBePiIpIjApMiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_) -----
		CPoint lgptPrev = mm2lg(m_mmptPivot + m_mmptPrev);
		eDraw.Line(&lgptPivot, &lgptPrev);
		// _xZkqqHx_jBePiIpIjDfPiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
		eDraw.GeneralMark(lgptPrev);
		// "F"_xZkqqHx_iLeMiNiGiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CPoint lgptBase = lgptPrev - CSize(4, 18);
//		eDraw.Line(	&CPoint(lgptBase.x + 8, lgptBase.y),
//					&CPoint(lgptBase.x, lgptBase.y),
//					&CPoint(lgptBase.x, lgptBase.y + 12));
//		eDraw.Line(	&CPoint(lgptBase.x + 1, lgptBase.y + 5),
//					&CPoint(lgptBase.x + 6, lgptBase.y + 5));
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		DrawPrevPullLabel(eDraw, lgptPrev - CSize(0, FDPJ_PULL_LAB_D));
		DrawPrevPullLabel(eDraw, lgptPrev - CSize(FDPJ_PULL_LAB_D, 0));
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (!(m_nType & 0x04))
	//----- _xZkqqHx_iMoDiIpIjApMiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_) -----
	{
		//----- _xZkqqHx_iMoDiIpIjApMiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_) -----
		CPoint lgptNext = mm2lg(m_mmptPivot + m_mmptNext);
		eDraw.Line(&lgptPivot, &lgptNext);
		// _xZkqqHx_iMoDiIpIjDfPiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
		eDraw.GeneralMark(lgptNext);
		// "b"_xZkqqHx_iLeMiNiGiCpAjFgAiJoG_xHqqkZx_(_xZkqqHx_iPmBiLiO_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CPoint lgptBase = lgptNext - CSize(4, 18);
//		eDraw.Line(	&CPoint(lgptBase.x, lgptBase.y),
//					&CPoint(lgptBase.x, lgptBase.y + 12));
//		eDraw.Line(	&CPoint(lgptBase.x + 1, lgptBase.y + 5),
//					&CPoint(lgptBase.x + 2,	lgptBase.y + 4),
//					&CPoint(lgptBase.x + 5,	lgptBase.y + 4),
//					&CPoint(lgptBase.x + 7,	lgptBase.y + 6),
//					&CPoint(lgptBase.x + 7,	lgptBase.y + 9),
//					&CPoint(lgptBase.x + 5,	lgptBase.y + 11),
//					&CPoint(lgptBase.x + 2,	lgptBase.y + 11),
//					&CPoint(lgptBase.x,		lgptBase.y + 9));
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		DrawNextPullLabel(eDraw, lgptNext + CSize(0, FDPJ_PULL_LAB_D));
		DrawNextPullLabel(eDraw, lgptNext + CSize(FDPJ_PULL_LAB_D, 0));
//----- 01.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCPolyJoint::DrawPullMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::IsHitPrevPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmFiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmNiBeBiDhNiBfLiDeOiImKjChFiCmGiBeBjDpBiCmCiCmMiBhF_xHqqkZx_F_xZkqqHx_iBhGiLeMiNiGiCmM_xHqqkZx_3_xZkqqHx_iJnDiPiKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCPolyJoint::IsHitPrevPull (const DBLPoint& mmpt) const
{
	const CPoint lgptMsc = mm2lg(mmpt);
	// _xZkqqHx_jBePiIpIjDfPiCmMiPkMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CPoint lgptPrev = mm2lg(m_mmptPivot + m_mmptPrev);
	if (::HitTest(lgptPrev, lgptMsc)) return TRUE;
	if (::HitTest(lgptPrev - CSize(0, FDPJ_PULL_LAB_D), lgptMsc,
					FDPJ_PULL_LAB_X, FDPJ_PULL_LAB_Y)) return TRUE;
	if (::HitTest(lgptPrev - CSize(FDPJ_PULL_LAB_D, 0), lgptMsc,
					FDPJ_PULL_LAB_X, FDPJ_PULL_LAB_Y)) return TRUE;
	return FALSE;
} // FCPolyJoint::IsHitPrevPull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::IsHitNextPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmFiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmNiBeBiDhNiBfLiDeOiImKjChFiCmGiBeBjDpBiCmCiCmMiBhF_xHqqkZx_b_xZkqqHx_iBhGiLeMiNiGiCmM_xHqqkZx_3_xZkqqHx_iJnDiPiKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCPolyJoint::IsHitNextPull (const DBLPoint& mmpt) const
{
	const CPoint lgptMsc = mm2lg(mmpt);
	// _xZkqqHx_jBePiIpIjDfPiCmMiPkMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CPoint lgptNext = mm2lg(m_mmptPivot + m_mmptNext);
	if (::HitTest(lgptNext, lgptMsc)) return TRUE;
	if (::HitTest(lgptNext + CSize(0, FDPJ_PULL_LAB_D), lgptMsc,
					FDPJ_PULL_LAB_X, FDPJ_PULL_LAB_Y)) return TRUE;
	if (::HitTest(lgptNext + CSize(FDPJ_PULL_LAB_D, 0), lgptMsc,
					FDPJ_PULL_LAB_X, FDPJ_PULL_LAB_Y)) return TRUE;
	return FALSE;
} // FCPolyJoint::IsHitNextPull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetPrevPullRgn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiIpIjDfPiCmMjFgAiJoGiCmJjFeLjHhGiCmIiLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEmNiImNiCpAjAhNiOkGiClHiCoJiBeC_xHqqkZx_
 *
 *          PULL_LAB_X               PULL_LAB_X
 *            _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    PULL_LAB_D    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkFiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEkH_xHqqkZx_
 *                                       
 *            _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkBiEjPiEjPiEjP_xHqqkZx_    _xZkqqHx_iEkG_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
 *            _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkJ_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_D
 *            _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkBiEjPiEjPiEjP_xHqqkZx_                   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_                         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iDeKiDgJiDiBjDfPiBkB_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkJ_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
 *            _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkAiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkI_xHqqkZx_
 *                                    _xZkqqHx_iEkA_xHqqkZx_        
 *                                    _xZkqqHx_iEkA_xHqqkZx_        
 *                              _xZkqqHx_jBePiIpIjDfPiBkB_xHqqkZx_
 *                                    _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.09.07 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
CRect FCPolyJoint::GetPrevPullRgn () const
{
	const int nMarkHalf = FCEditDraw::GetSelMarkSizeHalf();
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CPoint lgptPivot = mm2lg(m_mmptPivot);
	CRect lgrtPivot(lgptPivot.x - nMarkHalf, lgptPivot.y - nMarkHalf,
				    lgptPivot.x + nMarkHalf, lgptPivot.y + nMarkHalf);
	// _xZkqqHx_jBePiIpIjDfPiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CPoint lgptPrev = mm2lg(m_mmptPivot + m_mmptPrev);
	CRect lgrtPrev(	lgptPrev.x - FDPJ_PULL_LAB_D - FDPJ_PULL_LAB_X,
					lgptPrev.y - FDPJ_PULL_LAB_D - FDPJ_PULL_LAB_Y,
					lgptPrev.x + FDPJ_PULL_LAB_X,
					lgptPrev.y + FDPJ_PULL_LAB_Y);
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmGjBePiIpIjDfPiCmNjClMjApMiCmFjIeBiMiLiClDiCoKiCoJiInHiBeBiCfBiCmCiCmMiLoJiMgAiCpAjDoAjFoPiClHiCoJiNmFiPkMiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
	return (lgrtPivot | lgrtPrev);
} // FCPolyJoint::GetPrevPullRgn () const;.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::GetNextPullRgn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMoDiIpIjDfPiCmMjFgAiJoGiCmJjFeLjHhGiCmIiLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEmNiImNiCpAjAhNiOkGiClHiCoJiBeC_xHqqkZx_
 *
 *               _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iBkBiDeKiDgJiDiBjDfP_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEkBiBgDiEkAiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_ _xZkqqHx_iEkG_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
 *           _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBkBiMoDiIpIjDfP_xHqqkZx_       _xZkqqHx_iEkAiBfOiBfAiBfP_xHqqkZx_  _xZkqqHx_iEkJ_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                 _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                 _xZkqqHx_iEkAiBfPiBfBiBfO_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_D
 *           _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_                       _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_                       _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkAiBfOiBfAiBfP_xHqqkZx_                 _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkJ_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_PULL_LAB_Y
 *            _xZkqqHx_iEkAiBfPiBfBiBfO_xHqqkZx_                 _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_ _xZkqqHx_iEkI_xHqqkZx_
 *           _xZkqqHx_iEkFiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   PULL_LAB_D   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          PULL_LAB_X            PULL_LAB_X
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.09.07 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
CRect FCPolyJoint::GetNextPullRgn () const
{
	const int nMarkHalf = FCEditDraw::GetSelMarkSizeHalf();
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CPoint lgptPivot = mm2lg(m_mmptPivot);
	CRect lgrtPivot(lgptPivot.x - nMarkHalf,
					lgptPivot.y - nMarkHalf,
				    lgptPivot.x + nMarkHalf,
					lgptPivot.y + nMarkHalf);
	// _xZkqqHx_iMoDiIpIjDfPiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CPoint lgptNext = mm2lg(m_mmptPivot + m_mmptNext);
	CRect lgrtNext(	lgptNext.x - FDPJ_PULL_LAB_X,
					lgptNext.y - FDPJ_PULL_LAB_Y,
					lgptNext.x + FDPJ_PULL_LAB_D + FDPJ_PULL_LAB_X,
					lgptNext.y + FDPJ_PULL_LAB_D + FDPJ_PULL_LAB_Y);
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmGiMoDiIpIjDfPiCmNjClMjApMiCmFjIeBiMiLiClDiCoKiCoJiInHiBeBiCfBiCmCiCmMiLoJiMgAiCpAjDoAjFoPiClHiCoJiNmFiPkMiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
	return (lgrtPivot | lgrtNext);
} // FCPolyJoint::GetNextPullRgn () const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoG_xHqqkZx_FCUndoArchive_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::OutStream (FCUndoArchive& ar) const
{
	ar << m_nType;
	ar << m_mmptPivot;		// _xZkqqHx_iDeKiDgJiDiBjDfP_xHqqkZx_.
	ar << m_mmptPrev;		// _xZkqqHx_jBePiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
	ar << m_mmptNext;		// _xZkqqHx_iMoDiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
} // FCPolyJoint::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJoint::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNjAoG_xHqqkZx_FCUndoArchive_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJoint::InStream (FCUndoArchive& ar)
{
	ar >> m_nType;
	ar >> m_mmptPivot;		// _xZkqqHx_iDeKiDgJiDiBjDfP_xHqqkZx_.
	ar >> m_mmptPrev;		// _xZkqqHx_jBePiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
	ar >> m_mmptNext;		// _xZkqqHx_iMoDiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
} // FCPolyJoint::InStream.

//////////////////////////////////////////////////////////////////////////
/////////////////////////// FCPolyJointVector //////////////////////////////
//////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::FCPolyJointVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJointVector::FCPolyJointVector ()
{
	m_bIsOpen = TRUE;
} // FCPolyJointVector::FCPolyJointVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::FCPolyJointVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCjIeBiMiLjDfPiCmMjEhKjHpBiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSize	:pJoint_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *			pJoint	:_xZkqqHx_jIeBiMiLjDfPiCmMjEhKjHpBiBeC_xHqqkZx_
 *			bIsOpen	:_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCkKiDeJiBfLiDhGiDjDiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJointVector::FCPolyJointVector (long lSize, const FCPolyJoint *pJoint, BOOL bIsOpen)
{
	insert(end(), pJoint, pJoint + lSize);
	m_bIsOpen = bIsOpen;
} // FCPolyJointVector::FCPolyJointVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::SetOpenStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCkKiDeJiBfLiDhGiDjDiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsOpen	:_xZkqqHx_iDeJiBfLiDhGiDjDiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeOiDiNiBfLiDfJiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJointVector::SetOpenStatus (BOOL bIsOpen)
{
	m_bIsOpen = bIsOpen;
} // FCPolyJointVector::SetOpenStatus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::IsOpen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCkKiDeJiBfLiDhGiDjDiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDhGiDjDiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeOiDiNiBfLiDfJiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCPolyJointVector::IsOpen () const
{
	return m_bIsOpen;
} // FCPolyJointVector::IsOpen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::GetAffected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiCmGiCkLiJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPiCmMjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	jntSeq	:_xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *			idx		:_xZkqqHx_iInKjDkOiClHiCoJjIeBiMiLjDfPiCpAjHfOiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.23 Fukushiro M. ObjPoly.cpp_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FCPolyJointVector::GetAffected (JointSeq& jntSeq, long idx) const
{
	ASSERT(0 <= idx && idx < size());

	// _xZkqqHx_iKeKiLmIjApMiBeFjFmCiLmIjApMiCmFiJgFiLlPjEmNiImNiCkKiInJiCmIiCoJiBeC_xHqqkZx_
	if (m_bIsOpen)
	/*----- _xZkqqHx_iKeKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		if (idx == 0)
		//----- _xZkqqHx_jBiAiNoMjIeBiMiLjDfPiCkKiNmFiPiJiCmMjIeBiMiLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
		{
			jntSeq.lStart = 0;
			jntSeq.lSize = 1;
		} else if (size() - 1 == idx)
		//----- _xZkqqHx_jBiAiNoMjIeBiMiLjDfPiCkKiNmFiMoDiCmMjIeBiMiLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
		{
			jntSeq.lStart = size() - 2;
			jntSeq.lSize = 1;
		} else
		{
			jntSeq.lStart = idx - 1;
			jntSeq.lSize = 2;
		}
	} else
	/*----- _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		if (idx == 0)
		//----- _xZkqqHx_jBiAiNoMjIeBiMiLjDfPiCkKiNmFiPiJiCmMjIeBiMiLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
		{
			jntSeq.lStart = size() - 1;
		} else
		{
			jntSeq.lStart = idx - 1;
		}
		jntSeq.lSize = 2;
	}
} // FCPolyJointVector::GetAffected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::GetAffected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiCmGiCkLiJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPiCmMjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vJntSeq	:_xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPjEmNiImNiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			idx		:_xZkqqHx_iInKjDkOiClHiCoJjIeBiMiLjDfPiCmMiPfHiNiHiCpAjHfOiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.23 Fukushiro M. ObjPoly.cpp_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FCPolyJointVector::GetAffected (JointSeqVector& vJntSeq,
									const longVector &vIdx) const
{
	vJntSeq.clear();
	if (vIdx.empty()) return;

	JointSeq jntSeq;

	// _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjBfDiCmEiCmMjIeBiMiLjDfPiCmMiPfHiNiHiBeC_xHqqkZx_
	longVector vAllAfct;
	longVector::const_iterator iJ;

	// vIdx_xZkqqHx_iCmMjBfDiCmEiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiOjOiCmJiJgFiLlPiCpAiOpDiCkPiCoJjBfDiCmEiCmMjIeBiMiLjDfPiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	for (iJ = vIdx.begin(); iJ != vIdx.end(); iJ++)
	{
		// _xZkqqHx_iIoKiCmCiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiOjOiCmJiJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPiCmMiPfHiNiHiBeC_xHqqkZx_
		GetAffected(jntSeq, *iJ);
		// vAllAfct_xZkqqHx_iCmJiJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjCmHiJmBiBeC_xHqqkZx_
		while (0 < jntSeq.lSize--)
		{
			// _xZkqqHx_iIoKiOpMiClFiClNiPoKiNiHiCmNiBeBiNmFiPiJiCmMjIeBiMiLjDfPiCmJjGnPiCoJiBeC_xHqqkZx_
			if (jntSeq.lStart == size()) jntSeq.lStart = 0;
			vAllAfct.push_back(jntSeq.lStart);
			jntSeq.lStart++;
		}
	}
	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjBfDiCmEiCmMjIeBiMiLjDfPiCpAiDfMiBfLiDgHiClFiBeBiPgEiCmIiCmBiClNjDfPiCpAiPmBiLiOiClHiCoJ_xHqqkZx_ -----
	sort(vAllAfct.begin(), vAllAfct.end());
	// unique_xZkqqHx_iCmNiBeBiDiGiDgKiBfLiDeOiCmIjHpBiCpAjBePjFpLiCmJiBeBiOgDiCoIiCpAiMoDjFpLiCnGiInKjDkOiClFiCmEiBeBiClLiCmMiLkLiCpAjFnEiClHiBeC_xHqqkZx_
	vAllAfct.erase(unique(vAllAfct.begin(), vAllAfct.end()), vAllAfct.end());

	//----- _xZkqqHx_iDfMiBfLiDgHiClDiCoKiClNjIeBiMiLjDfPiCmMiPfHiNiHiCkJiCoHiBeBiKeKiOgOjDfPiCmGiDeKiDeFiDjDiDgHiCpAjElCiCkLiPgPiClFiCmEiCoEiCkN_xHqqkZx_ -----
	longVector::iterator iL = vAllAfct.begin();
	long lFirst	= *iL;	// _xZkqqHx_iKeKiOgOjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lLast	= *iL;	// _xZkqqHx_iKeKiOgOjDfPiCkJiCoHiDeDiDjDiDgGiDgCiDeOiDfIiCkKjIeBjEnEiCmMiPoKiNiHiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_

	for (iL++; iL != vAllAfct.end(); iL++)
	{
		if (*iL != lLast + 1)
		//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjIeBjEnEiCkKiCmGiCkMiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			vJntSeq.push_back(JointSeq(lFirst, lLast - lFirst + 1));
			lFirst = *iL;
		}
		lLast = *iL;
	}
	vJntSeq.push_back(JointSeq(lFirst, lLast - lFirst + 1));
} // FCPolyJointVector::GetAffected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::FindHitPivot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCkKjIeBiMiLjDfPiPoDiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeBiDhBiDgCiDgHiClFiClN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptMsc	:_xZkqqHx_iDhBiDgCiDgHiCpAjClCiCnHiCoJiNmAjFfHiBeCjIfPjHjNiNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCPolyJointVector::FindHitPivot (const CPoint& lgptMsc) const
{
	FCPolyJointVector::const_iterator iJnt;
	/*----- _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiDeKiDgJiDiBjDfPiCpAjClCiCnHiCoJ_xHqqkZx_ -----*/
	for (iJnt = begin(); iJnt != end(); iJnt++)
	{
		/*----- _xZkqqHx_jIeBiMiLjDfPiCmFiCmMiDeOiDiKiDgCiDeOiCkJjClCiCnHiCoJ_xHqqkZx_ -----*/
		if (::HitTest(mm2lg((*iJnt).m_mmptPivot), lgptMsc))
			return static_cast<long>(iJnt - begin());
	}
	// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	return -1;
} // FCPolyJointVector::FindHitPivot.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::DrawPivotMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiCmJiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCPolyJointVector::DrawPivotMark (CDC* pDC) const
//{
//	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, 0);
//	//----- _xZkqqHx_iDhNiBfLiDeOiCmMjFgAiJoG_xHqqkZx_ -----
//	FCPolyJointVector::const_iterator iJnt;
//	for (iJnt = begin(); iJnt != end(); iJnt++)
//		eDraw.UnselMark(mm2lg(iJnt->m_mmptPivot));
//} // FCPolyJointVector::DrawPivotMark.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyJointVector::DeleteJoints
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	idx	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJointVector::DeleteJoints (const longVector& vIdx)
{
	longVector vIdxCpy = vIdx;
	sort(vIdxCpy.begin(), vIdxCpy.end());
	longVector::reverse_iterator i;
	for (i = vIdxCpy.rbegin(); i != vIdxCpy.rend(); i++)
		erase(begin() + *i);
} // FCPolyJointVector::DeleteJoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJ_xHqqkZx_FCPolyJointVector_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjCgMiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPJ	:_xZkqqHx_jBoDjDpMiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCpAjFnEiClDiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyJointVector::operator = (const FCPolyJointVector& vPJ)
{
	m_bIsOpen = vPJ.m_bIsOpen;
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiBeC_xHqqkZx_
	vector<FCPolyJoint>::operator =(vPJ);
} // FCPolyJointVector::operator =.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ReversePolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_jEhKjHpBiCpAiLhEiPiHiCmJjFmAiCnHjBnGiCkGiCoJiBeCjBePiIpIjDfPiBeBiMoDiIpIjDfPiCoAjDpMjBnGiCkGiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void ReversePolyJoint (FCPolyJoint aPolyJoint[], long lSize)
{
	reverse(aPolyJoint, aPolyJoint + lSize);
	for (long lC = 0; lC < lSize; lC++)
	{
		// _xZkqqHx_iIpIjDfPiCpAiLhEjDfNiBeC_xHqqkZx_
		Exchange(aPolyJoint[lC].m_mmptNext, aPolyJoint[lC].m_mmptPrev);
		//----- Type_xZkqqHx_iCoAiLhEjDfN_xHqqkZx_ -----
		short nType = aPolyJoint[lC].m_nType & 0xf0;
		if (aPolyJoint[lC].m_nType & FDJT_PRE_PULL_0)
			nType |= FDJT_PST_PULL_0;
		if (aPolyJoint[lC].m_nType & FDJT_PST_PULL_0)
			nType |= FDJT_PRE_PULL_0;
		aPolyJoint[lC].m_nType = nType;
	}
} // ReversePolyJoint.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFControlConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpA_xHqqkZx_FCMmPolyBezier_xZkqqHx_iMfOiCmM_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:FCMmPolyBezier_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pPolyJoint	:FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lJointSize	:pPolyJoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOpenPoly	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmNiBeB_xHqqkZx_lJointSize=8_xZkqqHx_iCmMiPoKiNiHiCmMjHoBiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *			bIsOpenPoly=TRUE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *            _xZkqqHx_iEkA_xHqqkZx_               
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			[P0a,P0b,P0c,P1a,P1b,P1c,P2a,P2b,P2c,P3a,P3b,P3c,P4a,P4b,P4c,P5a,P5b,P5c,P6a,P6b,P6c,P7a]
 *
 *			bIsOpenPoly=FALSE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			[P0a,P0b,P0c,P1a,P1b,P1c,P2a,P2b,P2c,P3a,P3b,P3c,P4a,P4b,P4c,P5a,P5b,P5c,P6a,P6b,P6c,P7a,P7b,P7c,P0a]
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFControlConv (FCMmPolyBezier& polyBezier,
					const FCPolyJoint* pPolyJoint,
					long lJointSize,
					BOOL bIsOpenPoly)
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	long lC;
	for (lC = 0; lC != lJointSize - 1; lC++)
	{
		polyBezier.push_back(pPolyJoint[lC].m_mmptPivot);
		polyBezier.push_back(pPolyJoint[lC].m_mmptPivot + pPolyJoint[lC].m_mmptNext);
		polyBezier.push_back(pPolyJoint[lC + 1].m_mmptPivot + pPolyJoint[lC + 1].m_mmptPrev);
	}
	polyBezier.push_back(pPolyJoint[lJointSize - 1].m_mmptPivot);
	if (!bIsOpenPoly)
	{
		polyBezier.push_back(pPolyJoint[lJointSize - 1].m_mmptPivot + pPolyJoint[lJointSize - 1].m_mmptNext);
		polyBezier.push_back(pPolyJoint[0].m_mmptPivot + pPolyJoint[0].m_mmptPrev);
		polyBezier.push_back(pPolyJoint[0].m_mmptPivot);
	}
} // FFControlConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFControlConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpA_xHqqkZx_FCBezierControlsVector_xZkqqHx_iMfOiCmM_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:FCBezierControlsVector_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pPolyJoint	:FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lJointSize	:pPolyJoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOpenPoly	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFControlConv (FCBezierControlsVector& vControls,
					const FCPolyJoint* pPolyJoint,
					long lJointSize,
					BOOL bIsOpenPoly)
{
	FCMmPolyBezier polyBezier;
	FFControlConv(polyBezier, pPolyJoint, lJointSize, bIsOpenPoly);
	FFControlConv(vControls, polyBezier);
} // FFControlConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFControlConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpA_xHqqkZx_FCMmPolyBezier_xZkqqHx_iMfOiCmM_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPolyJoint	:FCPolyJoint_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pControls	:FCBezierControls_xZkqqHx_iMfOiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lControlSize:pControls_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOpenPoly	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FCPolyJoint::m_nType _xZkqqHx_iCmJiCmNjBfDiCmE_xHqqkZx_FDJT_SHARP_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lControlSize=7,bIsOpenPoly=TRUE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *            _xZkqqHx_iEkA_xHqqkZx_               
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			J0=[L0a,L0a,L0b], J1=[L0c,L1a,L1b], J2=[L1c,L2a,L2b], J3=[L2c,L3a,L3b],
 *			J4=[L3c,L4a,L4b], J5=[L4c,L5a,L5b], J6=[L5c,L6a,L6b], J7=[L6c,L6d,L6d]
 *
 *			lControlSize=8,bIsOpenPoly=FALSE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkAiCfG_xHqqkZx_ 
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			L0a = L7d _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			J0=[L7c,L0a,L0b], J1=[L0c,L1a,L1b], J2=[L1c,L2a,L2b], J3=[L2c,L3a,L3b],
 *			J4=[L3c,L4a,L4b], J5=[L4c,L5a,L5b], J6=[L5c,L6a,L6b], J7=[L6c,L7a,L7b]
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFControlConv (FCPolyJointVector& vPolyJoint,
					const FCBezierControls* pControls,
					long lControlSize,
					BOOL bIsOpenPoly)
{
	vPolyJoint.clear();
	if (bIsOpenPoly)
	//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ----
	{
		vPolyJoint.push_back(FCPolyJoint(FDJT_SHARP,
										pControls[0].A(),
										DBLPoint(0.0, 0.0),
										pControls[0].B() - pControls[0].A()));
		long lIndex;
		for (lIndex = 1; lIndex != lControlSize; lIndex++)
		{
			vPolyJoint.push_back(FCPolyJoint(FDJT_SHARP,
											pControls[lIndex].A(),
											pControls[lIndex - 1].C() - pControls[lIndex].A(),
											pControls[lIndex].B() - pControls[lIndex].A()));
		}
		vPolyJoint.push_back(FCPolyJoint(FDJT_SHARP,
										pControls[lControlSize - 1].D(),
										pControls[lControlSize - 1].C() - pControls[lControlSize - 1].D(),
										DBLPoint(0.0, 0.0)));
	} else
	//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ----
	{
		// pControls_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhIiDfHiDeGiLmIjApMiCmMiOgOjDfPiCmGiPeJjDfPiCmNjDkPiClGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if (!almosteq(pControls[0].A(), pControls[lControlSize - 1].D()))
			FFThrowMiscUnknown()
		vPolyJoint.push_back(FCPolyJoint(FDJT_SHARP,
										pControls[0].A(),
										pControls[lControlSize - 1].C() - pControls[0].A(),
										pControls[0].B() - pControls[0].A()));
		long lIndex;
		for (lIndex = 1; lIndex != lControlSize; lIndex++)
		{
			vPolyJoint.push_back(FCPolyJoint(FDJT_SHARP,
											pControls[lIndex].A(),
											pControls[lIndex - 1].C() - pControls[lIndex].A(),
											pControls[lIndex].B() - pControls[lIndex].A()));
		}
	}
} // FFControlConv.

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiCkJiCoHiBeBjBfDiCmEiCmMjAkHiMoEjDfPiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpA_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrt	: _xZkqqHx_iLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *			lCount	: _xZkqqHx_jAkHiMoEjDfPiNmAjFfHjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			joints	: _xZkqqHx_jAkHiMoEjDfPiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcFrame (DBLRect& mmrt, long lCount, const FCPolyJoint joints[])
{
	mmrt.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
	for (long l = 0; l != lCount; l++)
	{
		SmallerOrLarger(mmrt.left, mmrt.right, joints[l].GetPivotX());
		SmallerOrLarger(mmrt.top, mmrt.bottom, joints[l].GetPivotY());
		SmallerOrLarger(mmrt.left, mmrt.right, joints[l].GetPivotX() + joints[l].GetPrevPullX());
		SmallerOrLarger(mmrt.top, mmrt.bottom, joints[l].GetPivotY() + joints[l].GetPrevPullY());
		SmallerOrLarger(mmrt.left, mmrt.right, joints[l].GetPivotX() + joints[l].GetNextPullX());
		SmallerOrLarger(mmrt.top, mmrt.bottom, joints[l].GetPivotY() + joints[l].GetNextPullY());
	}
} // FFCalcFrame.
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
