// PreColor.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilGraph.h"		// For OptiColor.
#include "UtilStr.h"		// For GetResWString.
#include "UtilDlg.h"		// For SetUnitString.etc.
#include "UtilWin.h"		// For EnumWinTitle.etc.
#include "UtilMath.h"		// For dbpt2str.
#include "RegData.h"		// For g_pReg->GetRegColorRec.
// 06.02.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "Env.h"			// For g_pEnv.
#include "FoundDoc.h"		// For g_pDoc.
#include "PreColor.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCPreColor _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCPreColor, CFCPropertyPageBase)

CFCPreColor::CFCPreColor ()
				: BASE_CLASS(CFCPreColor::IDD)
{
	//{{AFX_DATA_INIT(CFCPreColor)
	//}}AFX_DATA_INIT
} // CFCPreColor::CFCPreColor.

CFCPreColor::~CFCPreColor ()
{
} // CFCPreColor::~CFCPreColor.

void CFCPreColor::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPreColor)
	DDX_Control(pDX, IDC_CEV_CMB_CATEGORY, m_cmbCategory);
	DDX_Control(pDX, IDC_CEV_CMB_COL_ITEM_NAME, m_cmbColItemName);
	//}}AFX_DATA_MAP
} // CFCPreColor::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCPreColor, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPreColor)
	ON_CBN_SELCHANGE(IDC_CEV_CMB_COL_ITEM_NAME, OnSelchangeCevCmbColItemName)
	ON_BN_CLICKED(IDC_CEV_RDO_COL_AUTO, OnCevRdoColAuto)
	ON_BN_CLICKED(IDC_CEV_RDO_COL_SPEC, OnCevRdoColSpec)
	ON_BN_CLICKED(IDC_CEV_BTN_COL_SET, OnCevBtnColSet)
	ON_WM_CTLCOLOR()
	ON_CBN_SELCHANGE(IDC_CEV_CMB_CATEGORY, OnSelchangeCevCmbCategory)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPreColor _xZkqqHx_iDiGiBfLiDfFiKnGjAjE_xHqqkZx_.

//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::SetGlobalColor
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiBeBiKmCiLkLjAeGiCmMiDePiDiNiBfLiDgPiDiLjFmPjAjEiCmJjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCkKiCfAiCmCiCmFiCoAjFmPiNfIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkPiCoKiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEjHhAiBeC_xHqqkZx_OnOK_xZkqqHx_iCmFiOgHjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCPreColor::SetGlobalColor () const
//{
//	BOOL bIsChanged = FALSE;
//	for (int iC = 0; iC != FDCL_END; iC++)
//	{
//		// _xZkqqHx_iKmCiLkLjHhAiDePiDiNiBfLiDgPiDiLjFmPjAjEiCnGjAnNjCoIiBeC_xHqqkZx_
//		g_pReg->SetRegColor(iC, m_tdwEnvColors[iC]);
//		// _xZkqqHx_jFmPjAjEiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//		if (m_tdwEnvColors[iC].IsChanged()) bIsChanged = TRUE;
//	}
//	return bIsChanged;
//} // CFCPreColor::SetGlobalColor.
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::UpdateModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiPeDjAlDiDhEiDiJiDePiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKgFiDiBiDjDiDgPjFmPjAjEiCpAjClCiCnHiBeBiPeDjAlDiClDiCoKiCmEiCkCiCoKiCmOiPeDjAlDiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_jDoAjFjEjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::UpdateModified ()
{
	BOOL bIsChanged = FALSE;
	int iC;
	for (iC = 0; !bIsChanged && iC != FDCL_END; iC++)
		if (m_tdwEnvColors[iC].IsChanged()) bIsChanged = TRUE;
	SetModified(bIsChanged);
} // CFCPreColor::UpdateModified.

/////////////////////////////////////////////////////////////////////////////
// CFCPreColor _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiPiJiKpKiJlLiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPreColor::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
//----- 05.09.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_cmbColItemName.ResetContent();
//----- 05.09.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iKmCiLkLjAeGiCpAiDiNiBfLiDeKiDiLjFmPjAjEiCnGjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDfGiBfLiDgHjAeGiCmMiCnNjFmKiCmJiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	m_tdwEnvColors[FDCL_SHEET].Init(g_pReg->GetSheetColor());
	int iC;
	for (iC = 1; iC != FDCL_END; iC++)
		m_tdwEnvColors[iC].Init(g_pReg->GetRegColorRec(iC).dwColor);

	//----- _xZkqqHx_iDeKiDgFiDfDiDiKiBfLiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	DWORDSet stCategoryId;
	for (iC = 0; iC != FDCL_END; iC++)
		stCategoryId.insert(g_pReg->GetRegColorRec(iC).dwCategoryId);
	DWORDSet::const_iterator iId;
	for (iId = stCategoryId.begin(); iId != stCategoryId.end(); iId++)
	{
		// _xZkqqHx_iDeKiDgFiDfDiDiKiBfLjGlMiCpAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCnGjAnNjCoIiBeC_xHqqkZx_
		int iSel = FFAddString(&m_cmbCategory, FFLoadWString(*iId));
		// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDeKiDgFiDfDiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		m_cmbCategory.SetItemData(iSel, *iId);
	}
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbCategory.SetCurSel(0);
//----- 05.09.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jAeGjGlMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlL_xHqqkZx_ -----
//	for (iC = 0; iC != FDCL_END; iC++)
//	{
//		if (g_pReg->GetRegColorRec(iC).nWhich & (g_->appMode & FD_APPMODE_MASK))
//		{
//			// _xZkqqHx_iKmCiLkLjAeGjGlMiCpAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCnGjAnNjCoIiBeC_xHqqkZx_
//			int iSel = FFAddString(&m_cmbColItemName,
//							FFLoadWString(g_pReg->GetRegColorRec(iC).dwColorNameId));
//			// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
//			m_cmbColItemName.SetItemData(iSel, DWORD(iC));
//		}
//	}
//	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_cmbColItemName.SetCurSel(0);
//----- 05.09.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDeKiDgFiDfDiDiKiBfLiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkKjFmPiNfIiClDiCoKiClNiPiIjHjNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	OnSelchangeCevCmbCategory();
	// _xZkqqHx_jEhHiMgJjAeGiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_colBackCol = FD_COLOR_REF_UNSPECIFY;
	// iColItemName_xZkqqHx_jAnNjCoIiCpAiDiJiDfHiDeJiDhLiDfOiDjDiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
	OnSelchangeCevCmbColItemName();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCPreColor::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiBeFjDeLjHhAiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnOK ()
{
	if (m_tdwEnvColors[FDCL_SHEET].IsChanged())
	//----- _xZkqqHx_iDfGiBfLiDgHjAeGiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (g_pDoc->IsReadOnly())
		//----- ReadOnly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfGiBfLiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pReg->SetSheetColor(m_tdwEnvColors[FDCL_SHEET].Get());
		} else
		//----- _xZkqqHx_iPjBiCkLiNjOiCnNiJmCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->SessionBegin();
			// _xZkqqHx_iDfGiBfLiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pDoc->CmdSetSheetColor(m_tdwEnvColors[FDCL_SHEET].Get());
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->SessionEnd();
		}
	}
	BOOL bIsChanged = FALSE;
	int iC;
	for (iC = 0; iC != FDCL_END; iC++)
	{
		// _xZkqqHx_jFmPjAjEiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_tdwEnvColors[iC].IsChanged())
		//----- _xZkqqHx_jFmPjAjEiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bIsChanged = TRUE;
			// _xZkqqHx_iKmCiLkLjHhAiDePiDiNiBfLiDgPiDiLjFmPjAjEiCnGjAnNjCoIiBeC_xHqqkZx_
			g_pReg->SetRegColor(iC, m_tdwEnvColors[iC]);
		}
	}

	// _xZkqqHx_iKmCiLkLjAeGiCmMiDePiDiNiBfLiDgPiDiLjFmPjAjEiCmJjAnNjCoIiBeC_xHqqkZx_
	if (bIsChanged)
	{
		// _xZkqqHx_jAeGiPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		g_pReg->SaveRegColor();
		// _xZkqqHx_jDkPiClGiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
		FCWinTitleRecVector vWinTtl;
		::EnumWinTitle(vWinTtl);
		FCWinTitleRecVector::iterator iWin;
		for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
		{
			// WM_USER_REGCOLOR_CHANGED_xZkqqHx_iCpAjBjHjAeNiBeCjAeGiCpAjDmHiCnNjClMiClHiBeC_xHqqkZx_
			::PostMessage((*iWin).hwndApp, WM_USER_REGCOLOR_CHANGED, 0, 0);
		}
	}
	//----- _xZkqqHx_iKgFjBkOjAkLiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	for (iC = 0; iC != FDCL_END; iC++)
		m_tdwEnvColors[iC].Init();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCPreColor::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnSelchangeCevCmbCategory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgFiDfDiDiKiBfLiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnSelchangeCevCmbCategory ()
{
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_cmbColItemName.ResetContent();
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkJiCoHiDeKiDgFiDfDiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwCategoryId = m_cmbCategory.GetItemData(m_cmbCategory.GetCurSel());
	//----- _xZkqqHx_jAeGjGlMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	for (int iC = 0; iC != FDCL_END; iC++)
	{
		if ((g_pReg->GetRegColorRec(iC).nWhich & (g_->appMode & FD_APPMODE_MASK)) &&
			g_pReg->GetRegColorRec(iC).dwCategoryId == dwCategoryId)
		{
			// _xZkqqHx_iKmCiLkLjAeGjGlMiCpAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCnGjAnNjCoIiBeC_xHqqkZx_
			int iSel = FFAddString(&m_cmbColItemName,
							FFLoadWString(g_pReg->GetRegColorRec(iC).dwColorNameId));
			// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			m_cmbColItemName.SetItemData(iSel, DWORD(iC));
		}
	}
	if (m_cmbColItemName.GetCount() != 0)
	//----- _xZkqqHx_iDeKiDgFiDfDiDiKiBfLiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCkKiIoKiCmCiImIiPoDiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAeGjGlMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAjHeMiMpIiCmJiBeC_xHqqkZx_
		m_cmbColItemName.EnableWindow(TRUE);
		// _xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAjDeLjAnIiCpAjHeMiMpIiCmJiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_RDO_COL_AUTO)->EnableWindow(TRUE);
		GetDlgItem(IDC_CEV_RDO_COL_SPEC)->EnableWindow(TRUE);
		// _xZkqqHx_jAeGjAnNjCoIiDhLiDfOiDjDiCpAjHeMiMpIiCmJiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_BTN_COL_SET)->EnableWindow(TRUE);
		// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		m_cmbColItemName.SetCurSel(0);
		// _xZkqqHx_jAnNjCoIjBmOiPnLiCmMjAeGjGlMiBgJiDfCiDjDiDhLiDhLiDgCiDeOiDfIiBgKiCkKjFmPiNfIiClDiCoKiClNiOjOiCmMiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		OnSelchangeCevCmbColItemName();
	} else
	//----- _xZkqqHx_iDeKiDgFiDfDiDiKiBfLiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAeGjGlMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAjGlDiMpIiCmJiBeC_xHqqkZx_
		m_cmbColItemName.EnableWindow(FALSE);
		// _xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAjDeLjAnIiCpAjGlDiMpIiCmJiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_RDO_COL_AUTO)->EnableWindow(FALSE);
		GetDlgItem(IDC_CEV_RDO_COL_SPEC)->EnableWindow(FALSE);
		// _xZkqqHx_jAeGjAnNjCoIiDhLiDfOiDjDiCpAjGlDiMpIiCmJiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_BTN_COL_SET)->EnableWindow(FALSE);
	}
} // CFCPreColor::OnSelchangeCevCmbCategory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnSelchangeCevCmbColItemName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIjBmOiPnLiCmMjAeGjGlMiBgJiDfCiDjDiDhLiDhLiDgCiDeOiDfIiBgKiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnSelchangeCevCmbColItemName ()
{
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	int iColItemName = int(m_cmbColItemName.GetItemData(m_cmbColItemName.GetCurSel()));
	// _xZkqqHx_iDfGiDfIiDgFiDiAjAeGjIeBjDkOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (m_tdwEnvColors[iColItemName] == static_cast<DWORD>(-1))
	//----- _xZkqqHx_iDfGiDfIiDgFiDiAjAeGjIeBjDkOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAjDeLjAnIiCmIiPpDjBnEiCmJjAnNjCoIiBeC_xHqqkZx_
		CheckDlgButton(IDC_CEV_RDO_COL_AUTO, TRUE);
		CheckDlgButton(IDC_CEV_RDO_COL_SPEC, FALSE);
		// _xZkqqHx_iDfEiDjDiDhGiDiLjAnNjCoIiCmMiInHiBeBiDiJiDfHiDeJiDhLiDfOiDjDiCmMiDeDiDhIiDjDiDgHiDgOiDjDiDgIiDiJiCpAiOmAiNhDiBeC_xHqqkZx_
		OnCevRdoColAuto();
	} else
	//----- _xZkqqHx_iOgHiCkCiClNiCkCjAeGiCpAiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAjDeLjAnIiCmIiPpDjBnEiCmJjAnNjCoIiBeC_xHqqkZx_
		CheckDlgButton(IDC_CEV_RDO_COL_AUTO, FALSE);
		CheckDlgButton(IDC_CEV_RDO_COL_SPEC, TRUE);
		// _xZkqqHx_iDfEiDjDiDhGiDiLjAnNjCoIiCmMiInHiBeBiDiJiDfHiDeJiDhLiDfOiDjDiCmMiDeDiDhIiDjDiDgHiDgOiDjDiDgIiDiJiCpAiOmAiNhDiBeC_xHqqkZx_
		OnCevRdoColSpec();
	}
} // CFCPreColor::OnSelchangeCevCmbColItemName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnCevRdoColAuto
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiBhFiDfGiDfIiDgFiDiAjEhKjAeGiCmJjIeBjDkOiBhGiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnCevRdoColAuto ()
{
	// _xZkqqHx_iBhFjAeGiCmMjAnNjCoIiBhGiDhLiDfOiDjDiCpAjGlDiMpIiPpDjBnEiCmJiBeC_xHqqkZx_
	GetDlgItem(IDC_CEV_BTN_COL_SET)->EnableWindow(FALSE);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	int iColItemName = int(m_cmbColItemName.GetItemData(m_cmbColItemName.GetCurSel()));
	// _xZkqqHx_jAeGiCmMiDiBiDjDiDgPjFmPjAjEiCmJiBeBjIeBjDkOiPpDjBnEiCpAiOkGiClHiBhMiCfAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_tdwEnvColors[iColItemName] = static_cast<DWORD>(-1);
	//----- _xZkqqHx_iDfEiDjDiDhGiDiLjEhHiMgJjAeGiCmMjFmPiNfIiPiIjHjN_xHqqkZx_ -----
	if (m_colBackCol !=
		OptiColor(GetSysColor(g_pReg->GetRegColorRec(iColItemName).iSysCol)))
	{
		// _xZkqqHx_iMmDiCkCiDhFiDiJiDfGiCpAiNoNiPjMiBeC_xHqqkZx_
		m_brsBackCol.DeleteObject();
		// _xZkqqHx_jAfGiClFiCkCjEhHiMgJjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_colBackCol =
			OptiColor(GetSysColor(g_pReg->GetRegColorRec(iColItemName).iSysCol));
		// _xZkqqHx_jAfGiClFiCkCiDhFiDiJiDfGiCpAiNoMjAkMiBeC_xHqqkZx_
		m_brsBackCol.CreateSolidBrush(m_colBackCol);
		// _xZkqqHx_iDfEiDjDiDhGiDiLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_STC_COL_SAMPLE)->RedrawWindow();
	}
	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreColor::OnCevRdoColAuto.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnCevRdoColSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiBhFiOgHiCkCiClNiCkCjAeGiCpAiOhHjCoIiBhGiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnCevRdoColSpec ()
{
	// _xZkqqHx_iBhFjAeGiCmMjAnNjCoIiBhGiDhLiDfOiDjDiCpAjHeMiMpIiPpDjBnEiCmJiBeC_xHqqkZx_
	GetDlgItem(IDC_CEV_BTN_COL_SET)->EnableWindow(TRUE);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	int iColItemName = int(m_cmbColItemName.GetItemData(m_cmbColItemName.GetCurSel()));
	// _xZkqqHx_iDfGiDfIiDgFiDiAjAeGjIeBjDkOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (m_tdwEnvColors[iColItemName] == static_cast<DWORD>(-1))
	{
		// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmJiDgGiDhEiDeIiDiLiDgHiCmMiDfGiDfIiDgFiDiAjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_tdwEnvColors[iColItemName] =
			OptiColor(GetSysColor(g_pReg->GetRegColorRec(iColItemName).iSysCol));
	}
	//----- _xZkqqHx_iDfEiDjDiDhGiDiLjEhHiMgJjAeGiCmMjFmPiNfIiPiIjHjN_xHqqkZx_ -----
	if (m_colBackCol != m_tdwEnvColors[iColItemName])
	{
		// _xZkqqHx_iMmDiCkCiDhFiDiJiDfGiCpAiNoNiPjMiBeC_xHqqkZx_
		m_brsBackCol.DeleteObject();
		// _xZkqqHx_jAfGiClFiCkCjEhHiMgJjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_colBackCol = m_tdwEnvColors[iColItemName];
		// _xZkqqHx_jAfGiClFiCkCiDhFiDiJiDfGiCpAiNoMjAkMiBeC_xHqqkZx_
		m_brsBackCol.CreateSolidBrush(m_colBackCol);
		// _xZkqqHx_iDfEiDjDiDhGiDiLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_STC_COL_SAMPLE)->RedrawWindow();
	}
	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreColor::OnCevRdoColSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnCevBtnColSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjAeGiCmMjAnNjCoIiBhGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreColor::OnCevBtnColSet ()
{
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpA_xHqqkZx_Index_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	int iColItemName = int(m_cmbColItemName.GetItemData(m_cmbColItemName.GetCurSel()));
	// _xZkqqHx_iDeKiDiJiBfLiDfPiDeDiDeBiDiNiDePiDhLiDgCiDeOiDfIiCpAjFfMiOkGiBeC_xHqqkZx_
	CColorDialog dlgCol(m_tdwEnvColors[iColItemName], CC_FULLOPEN);
	// _xZkqqHx_iDeMiDiDiDjDiDfKiDiLiDhLiDfOiDjDiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (dlgCol.DoModal() != IDOK) return;
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCkJiCoHjAeGiCpAiOoGjDlOiBeC_xHqqkZx_
	m_tdwEnvColors[iColItemName] = dlgCol.GetColor();
	//----- _xZkqqHx_iDfEiDjDiDhGiDiLjEhHiMgJjAeGiCmMjFmPiNfIiPiIjHjN_xHqqkZx_ -----
	if (m_colBackCol != m_tdwEnvColors[iColItemName])
	{
		// _xZkqqHx_iMmDiCkCiDhFiDiJiDfGiCpAiNoNiPjMiBeC_xHqqkZx_
		m_brsBackCol.DeleteObject();
		// _xZkqqHx_jAfGiClFiCkCjEhHiMgJjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_colBackCol = m_tdwEnvColors[iColItemName];
		// _xZkqqHx_jAfGiClFiCkCiDhFiDiJiDfGiCpAiNoMjAkMiBeC_xHqqkZx_
		m_brsBackCol.CreateSolidBrush(m_colBackCol);
		// _xZkqqHx_iDfEiDjDiDhGiDiLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		GetDlgItem(IDC_CEV_STC_COL_SAMPLE)->RedrawWindow();
	}
	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreColor::OnCevBtnColSet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreColor::OnCtlColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiKgFiDfCiDjDiDgHiDiNiBfLiDiLiCpAjFfMiOkGiClHiCoJiOjOiCmJiBeBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFfMiOkGjHhAiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pWnd		:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *			nCtlColor	:_xZkqqHx_jFfMiOkGiClHiCoJiDfCiDjDiDgHiDiNiBfLiDiLiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGjHhAiCmMiDhFiDiJiDfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HBRUSH CFCPreColor::OnCtlColor (CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	if (pWnd->GetDlgCtrlID() == IDC_CEV_STC_COL_SAMPLE)
		return HBRUSH(m_brsBackCol);
	return BASE_CLASS::OnCtlColor(pDC, pWnd, nCtlColor);
} // CFCPreColor::OnCtlColor.

