// PreText.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilDlg.h"	// For SetUnitString.etc.
#include "UtilStr.h"	// For FFExtractUntil.
#include "UtilWin.h"	// For FFAddString.
#include "RegData.h"	// For FCRegData.
#include "FoundDoc.h"	// For g_pDoc.
#include "PreText.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCPreText _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCPreText, CFCPropertyPageBase)

CFCPreText::CFCPreText ()
		: BASE_CLASS(CFCPreText::IDD)
{
	//{{AFX_DATA_INIT(CFCPreText)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDiBiDjDiDgPiCmMiPiJiKpKiJlLiPiIjHjNiCpAjCmHiJmBiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT

	m_bIsReady = FALSE;	// OnInitDialog_xZkqqHx_iOmAiNhDiMoDiCmJ_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
} // CFCPreText::CFCPreText.

CFCPreText::~CFCPreText ()
{
} // CFCPreText::~CFCPreText.

void CFCPreText::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPreText)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
} // CFCPreText::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCPreText, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPreText)
	ON_BN_CLICKED(IDC_ETX_CHK_WORDWRAP_J, OnEtxChkWordwrapJ)
	ON_BN_CLICKED(IDC_ETX_CHK_WORDWRAP_E, OnEtxChkWordwrapE)
	ON_COMMAND(ID_DIALOG_INIT_VALUE, OnDialogInitValue)
	ON_CBN_SELCHANGE(IDC_ETX_CMB_CHARSET, OnSelchangeEtxCmbCharset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPreText _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::IsConsistent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjAlDiClFiCkNjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jCgMiCkKjAlDiClFiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FALSE	:_xZkqqHx_jCgMiCkKjAlDiClFiCkNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPreText::IsConsistent () const
{
	if (m_tbIsTextFormJ1 == NoValue) return FALSE;
	if (m_tbIsTextFormE1 == NoValue) return FALSE;
	if (m_twStdFontCharset == NoValue) return FALSE;
	return TRUE;
} // CFCPreText::IsConsistent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::UpdateModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiBeBiIoKiCmCiCmFiCoAjFmPiNfIiCkKiCkAiCoKiCmOiPeDjAlDiDhEiDiJiDeP_xHqqkZx_
 *			_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeCiIoKiCmCiCoAjFmPiNfIiCkKiCmIiCkPiCoKiCmOiPeDjAlDiDhEiDiJiDePiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::UpdateModified ()
{
	// _xZkqqHx_iJlNiCkJiPiIjHjNjCiGiCmIiCoHiCmOjBkGiOjOjFjMiLeBiBeC_xHqqkZx_
	if (!m_bIsReady) return;
	if (!IsConsistent())
	{
		SetModified(FALSE);
		return;
	}
	BOOL bModified = FALSE;
	if (m_tbIsTextFormJ1.IsChanged()) bModified = TRUE;
	if (m_tbIsTextFormE1.IsChanged()) bModified = TRUE;
	if (m_twStdFontCharset.IsChanged()) bModified = TRUE;
	SetModified(bModified);
} // CFCPreText::UpdateModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMiPpDjBnEiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCnGjElNiJgGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCtrl	:_xZkqqHx_iClBiCmMiKnGjAjEiCmMiMmEiCnBiPgPiClFiMlDiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	dwCtrl_xZkqqHx_iCkKiDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiOjOiCmNiBeBiClLiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClHiCoJiCmGiDfCiDjDiDgHiDiNiBfLiDiLjBfDjBmMiCkKjBeJjBpAiPpDjBnEiCmJiCmIiCmBiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCnGiCmMjCgMiCmMjAnNjCoIiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::UpdateControls (DWORD dwCtrl)
{
	// _xZkqqHx_iJlNiCkJiPiIjHjNjCiGiCmIiCoHiCmOjBkGiOjOjFjMiLeBiBeC_xHqqkZx_
	if (!m_bIsReady) return;
	m_bIsReady = FALSE;

	if (dwCtrl != IDC_ETX_CHK_WORDWRAP_J)
	{
		if (m_tbIsTextFormJ1 == NoValue)
		{
			((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_J))->SetCheck(0);
		} else
		{
			((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_J))->SetCheck(m_tbIsTextFormJ1);
		}
	}
	if (dwCtrl != IDC_ETX_CHK_WORDWRAP_E)
	{
		if (m_tbIsTextFormE1 == NoValue)
		{
			((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_E))->SetCheck(0);
		} else
		{
			((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_E))->SetCheck(m_tbIsTextFormE1);
		}
	}
	if (dwCtrl != IDC_ETX_CMB_CHARSET)
	{
		CComboBox* pBox = (CComboBox*)GetDlgItem(IDC_ETX_CMB_CHARSET);
		if (m_twStdFontCharset == NoValue)
		{
			pBox->SetCurSel(CB_ERR);
		} else
		{
			for (int iIdx = 0; iIdx < pBox->GetCount(); iIdx++)
			{
				if (pBox->GetItemData(iIdx) == m_twStdFontCharset)
				{
					pBox->SetCurSel(iIdx);
					break;
				}
			}
		}
	}
	m_bIsReady = TRUE;
} // CFCPreText::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFjBkOjAkLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiBeBjHeMiMpIiPpDjBnEjFmPjAjEiCpAiNfIjAfGiClFiClNiMoD_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::UpdateActivate ()
{
} // CFCPreText::UpdateActivate.

/////////////////////////////////////////////////////////////////////////////
// CFCPreText _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnDialogInitValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ID_DIALOG_INIT_VALUE_xZkqqHx_iDfCiDhNiDjDiDgIiCmFiOmAiNhDiBeCiKgFjBkOjAkLjCgMiCmMjFmPjAjEiCpAiPiJiKpKiJlLiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::OnDialogInitValue ()
{
	//----- _xZkqqHx_iKgFjBkOjAkLiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_tbIsTextFormJ1.Init(g_pReg->GetIsTextFormJ1());
	m_tbIsTextFormE1.Init(g_pReg->GetIsTextFormE1());
	m_twStdFontCharset.Init(g_pReg->GetStdFontCharset());

	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCnGjElNiJgGiBeC_xHqqkZx_
	UpdateControls(0);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreText::OnDialogInitValue.

/////////////////////////////////////////////////////////////////////////////
// CFCPreText _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlKiLeMiDfCiDiBiDjDiDgHiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPreText::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
	// OnInitDialog_xZkqqHx_iOmAiNhDiMoDiCmJ_xHqqkZx_TRUE_xZkqqHx_iBeCiDgMiDfIiDgHjGgIiOhOjHhAiBeC_xHqqkZx_
	m_bIsReady = TRUE;

	//----- _xZkqqHx_jFlGiOjKiDfKiDgCiDgHiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDgGiBfLiDfOiCpAjAnNjCoI_xHqqkZx_ -----
	CComboBox* pBox = (CComboBox*)GetDlgItem(IDC_ETX_CMB_CHARSET);
	WString strFontCharset;
	strFontCharset.LoadString(IDS_STD_FONT_CHARSET);
	while (!strFontCharset.IsEmpty())
	{
		WORD wCharset = wcstol(::FFExtractUntil(strFontCharset, L"\n"), NULL, 10);
		int iIndex = FFAddString(pBox ,FFCharsetToName(wCharset));
		pBox->SetItemData(iIndex, wCharset);
	}

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_jBkOjAkLjFmPjAjEiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	PostMessage(WM_COMMAND, ID_DIALOG_INIT_VALUE);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCPreText::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiBeBjDeLjHhAiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::OnOK ()
{
	//-----	_xZkqqHx_jBkOjAkLiCmJjGlFiPiCiCkKiCkAiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmJjBkOjAkLiCpAjAnNjCoIiClJiClIiCmJjFjMiLeB_xHqqkZx_ -----
	if (!IsConsistent())
	{
		BASE_CLASS::OnOK();
		return;
	}
	if (g_pDoc->IsReadOnly())
	//----- ReadOnly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_tbIsTextFormJ1.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pReg->SetIsTextFormJ1(m_tbIsTextFormJ1);
		}
		if (m_tbIsTextFormE1.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pReg->SetIsTextFormE1(m_tbIsTextFormE1);
		}
		if (m_twStdFontCharset.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pReg->SetStdFontCharset(m_twStdFontCharset);
		}
	} else
	//----- _xZkqqHx_iPjBiCkLiNjOiCnNiJmCiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		if (m_tbIsTextFormJ1.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pDoc->CmdSetIsTextFormJ1(m_tbIsTextFormJ1);
		}
		if (m_tbIsTextFormE1.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pDoc->CmdSetIsTextFormE1(m_tbIsTextFormE1);
		}
		if (m_twStdFontCharset.IsChanged())
		{
			//----- _xZkqqHx_iKgFiOoNjBkOjAkLiCmMjAnNjCoI_xHqqkZx_ -----
			g_pDoc->CmdSetStdFontCharset(m_twStdFontCharset);
		}
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
	}
	// _xZkqqHx_jBkOjAkLjFmPjAjEiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	PostMessage(WM_COMMAND, ID_DIALOG_INIT_VALUE);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCPreText::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnEtxChkWordwrapJ
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKjGhLiMoKiLoFjDmHjDfPiCmMiDiLiBfLiDiLiCkKiDgAiDeGiDgCiDeOiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::OnEtxChkWordwrapJ ()
{
	m_tbIsTextFormJ1 = ((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_J))->GetCheck();
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCnGjElNiJgGiBeC_xHqqkZx_
	UpdateControls(IDC_ETX_CHK_WORDWRAP_J);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreText::OnEtxChkWordwrapJ.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnEtxChkWordwrapE
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJhAiMoKjCfAiMoKiCmMiDiLiBfLiDiLiCkKiDgAiDeGiDgCiDeOiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::OnEtxChkWordwrapE ()
{
	m_tbIsTextFormE1 = ((CButton*)GetDlgItem(IDC_ETX_CHK_WORDWRAP_E))->GetCheck();
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCnGjElNiJgGiBeC_xHqqkZx_
	UpdateControls(IDC_ETX_CHK_WORDWRAP_E);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreText::OnEtxChkWordwrapE.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreText::OnSelchangeEtxCmbCharset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePjFfHiPiAjFlGiOjKiDfKiDgCiDgHiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCkKjFmPiNfI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreText::OnSelchangeEtxCmbCharset ()
{
	int iIdx = ((CComboBox*)GetDlgItem(IDC_ETX_CMB_CHARSET))->GetCurSel();
	m_twStdFontCharset = ((CComboBox*)GetDlgItem(IDC_ETX_CMB_CHARSET))->GetItemData(iIdx);
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCnGjElNiJgGiBeC_xHqqkZx_
	UpdateControls(IDC_ETX_CMB_CHARSET);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreText::OnSelchangeEtxCmbCharset.
