// PrhHistFindDate.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "DlgHistFindResults.h"	// For CFCDlgHistFindResults.
#include "HistViewDoc.h"		// For FFHistViewDoc().
#include "HistViewFrame.h"		// For FFHistViewFrame().
#include "HiProject.h"			// For FCHiProject.
#include "PrhHistFindDate.h"	// This header.

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_PRH_HIST_FIND_DATE = L"CFCPrhHistFindDate";

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDate _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::CFCPrhHistFindDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWndResult	:_xZkqqHx_iMjPiNpFiMiLiJmKjFfMiOkGiDhAiDgMiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindDate::CFCPrhHistFindDate ()
					: BASE_CLASS()
{
	//{{AFX_DATA_INIT(CFCPrhHistFindDate)
	m_iSearchMethod = 0;
	m_otmTimeNear = COleDateTime::GetCurrentTime();
	m_lRangeDay = 0;
	m_lRangeHour = 0;
	m_lRangeMinutes = 0;
	//}}AFX_DATA_INIT

	//----- _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	m_lSearchRadioCtrl = IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE;
} // CFCPrhHistFindDate::CFCPrhHistFindDate.

void CFCPrhHistFindDate::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPrhHistFindDate)
	DDX_CBIndex(pDX, IDC_HFD_DAT_CMB_SEARCH_METHOD, m_iSearchMethod);
	DDX_DateTimeCtrl(pDX, IDC_HFD_DAT_DTM_TIME_NEAR, m_otmTimeNear);
	DDX_Text(pDX, IDC_HFD_DAT_EDT_RANGE_DAY, m_lRangeDay);
	DDX_Text(pDX, IDC_HFD_DAT_EDT_RANGE_HOUR, m_lRangeHour);
	DDX_Text(pDX, IDC_HFD_DAT_EDT_RANGE_MINUTES, m_lRangeMinutes);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCPrhHistFindDate, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPrhHistFindDate)
	ON_BN_CLICKED(IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE, OnHfdDatRdoSearchNearDate)
	ON_BN_CLICKED(IDC_HFD_DAT_RDO_SEARCH_BETWEEN_DATE, OnHfdDatRdoSearchBetweenDate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDate _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::OnSetActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::OnSetActive ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetActive();
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	g_pReg->LoadRegBinary(GetRegName(), L"m_iSearchMethod", (BYTE*)&m_iSearchMethod, sizeof(m_iSearchMethod));
	g_pReg->LoadRegBinary(GetRegName(), L"m_lRangeDay", (BYTE*)&m_lRangeDay, sizeof(m_lRangeDay));
	g_pReg->LoadRegBinary(GetRegName(), L"m_lRangeHour", (BYTE*)&m_lRangeHour, sizeof(m_lRangeHour));
	g_pReg->LoadRegBinary(GetRegName(), L"m_lRangeMinutes", (BYTE*)&m_lRangeMinutes, sizeof(m_lRangeMinutes));
	g_pReg->LoadRegBinary(GetRegName(), L"m_lSearchRadioCtrl", (BYTE*)&m_lSearchRadioCtrl, sizeof(m_lSearchRadioCtrl));
	FDSECTIME fdstTimeNear = COleDtToFdsec(m_otmTimeNear);
	g_pReg->LoadRegBinary(GetRegName(), L"fdstTimeNear", (BYTE*)&fdstTimeNear, sizeof(fdstTimeNear));
	m_otmTimeNear = FdsecToFiletime(fdstTimeNear);
} // CFCPrhHistFindDate::OnSetActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::OnKillActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmFiCmIiCkNiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::OnKillActive ()
{
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPpDiLlFiCpAjFnLjBlGiClHiCoJ_xHqqkZx_ -----
	g_pReg->SaveRegBinary(GetRegName(), L"m_iSearchMethod", (BYTE*)&m_iSearchMethod, sizeof(m_iSearchMethod));
	g_pReg->SaveRegBinary(GetRegName(), L"m_lRangeDay", (BYTE*)&m_lRangeDay, sizeof(m_lRangeDay));
	g_pReg->SaveRegBinary(GetRegName(), L"m_lRangeHour", (BYTE*)&m_lRangeHour, sizeof(m_lRangeHour));
	g_pReg->SaveRegBinary(GetRegName(), L"m_lRangeMinutes", (BYTE*)&m_lRangeMinutes, sizeof(m_lRangeMinutes));
	g_pReg->SaveRegBinary(GetRegName(), L"m_lSearchRadioCtrl", (BYTE*)&m_lSearchRadioCtrl, sizeof(m_lSearchRadioCtrl));
	FDSECTIME fdstTimeNear = COleDtToFdsec(m_otmTimeNear);
	g_pReg->SaveRegBinary(GetRegName(), L"fdstTimeNear", (BYTE*)&fdstTimeNear, sizeof(fdstTimeNear));
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnKillActive();
} // CFCPrhHistFindDate::OnKillActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::GetRegName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCPrhHistFindDate::GetRegName () const
{
	return REG_PRH_HIST_FIND_DATE;
} // CFCPrhHistFindDate::GetRegName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCmFiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::UpdateControls ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UpdateControls();
	// _xZkqqHx_iMjPiNpFiOhHjCoIiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	CheckRadioButton(IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE, IDC_HFD_DAT_RDO_SEARCH_BETWEEN_DATE, m_lSearchRadioCtrl);
} // CFCPrhHistFindDate::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::UpdateVariables
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiBeBjFmPjAjEiCmMjCgMiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::UpdateVariables ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UpdateVariables();
	// _xZkqqHx_iMjPiNpFiOhHjCoIiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lSearchRadioCtrl = GetCheckedRadioButton(IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE, IDC_HFD_DAT_RDO_SEARCH_BETWEEN_DATE);
} // CFCPrhHistFindDate::UpdateVariables.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::IsConsistent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjAnNjCoIjCgMiCmMjGlFiPiCjAkLiCmMiDgAiDeGiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindDate::IsConsistent ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::IsConsistent()) return FALSE;

	if (m_lSearchRadioCtrl == IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE)
	//----- _xZkqqHx_iOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (m_lRangeDay == 0 && m_lRangeHour == 0 && m_lRangeMinutes == 0)
		//----- _xZkqqHx_jDpKiOjOiCmMjFjNiCkKiCePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED = "_xZkqqHx_iMjPiNpFjBmOiPnLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
			FFErrorBox(IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED);
			return FALSE;
		}
	} else
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiPoKiNiH_xHqqkZx_ -----
	{
		if (!m_bTbcTimTimeFrom && !m_bTbcTimTimeUntil)
		//----- _xZkqqHx_jDpKiOjOiNgJiCoIiNjOiCnNiCkKiCmHiClPiCoHiCoAiDgAiDeGiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED = "_xZkqqHx_iMjPiNpFjBmOiPnLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
			FFErrorBox(IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED);
			return FALSE;
		}
	}
	return TRUE;
} // CFCPrhHistFindDate::IsConsistent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::UpdateActivate ()
{
	// m_bTbcLblNarrowByLabel_xZkqqHx_iBgJiDiJiDhIiDiLjFlGiOjKjHpBiCmFiNgJiCoIiNjOiCnNiBgKiCmMjCgMiCpAjFnLjBlGiClFiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiNgJiNjOiCnNiCpAiLnGiOhOiClHiCoJiClNiCnPiBeC_xHqqkZx_
	const FCAutoBackup<BOOL> backupNarrowByLabel(m_bTbcLblNarrowByLabel, FALSE);
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UpdateActivate();
	// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCmFiNgJiCoIiNjOiCnNiCmNjFhDiJmCiBeC_xHqqkZx_
	GetDlgItem(IDC_HFD_TBC_LBL_CHK_NARROW_BY_LABEL)->EnableWindow(FALSE);

	// _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiCmMjHeMiMpIiBeFjGlDiMpIiBeC_xHqqkZx_
	BOOL bIsBetween = (m_lSearchRadioCtrl == IDC_HFD_DAT_RDO_SEARCH_BETWEEN_DATE);
	if (bIsBetween)
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpF_xHqqkZx_ _xZkqqHx_iCkKjHeMiMpIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		GetDlgItem(IDC_HFD_TBC_TIM_CHK_TIME_FROM)->EnableWindow(TRUE);
		GetDlgItem(IDC_HFD_TBC_TIM_CHK_TIME_UNTIL)->EnableWindow(TRUE);
	} else
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpF_xHqqkZx_ _xZkqqHx_iCkKjGlDiMpIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		GetDlgItem(IDC_HFD_TBC_TIM_CHK_TIME_FROM)->EnableWindow(FALSE);
		GetDlgItem(IDC_HFD_TBC_TIM_STC0)->EnableWindow(FALSE);
		GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_FROM)->EnableWindow(FALSE);
		GetDlgItem(IDC_HFD_TBC_TIM_CHK_TIME_UNTIL)->EnableWindow(FALSE);
		GetDlgItem(IDC_HFD_TBC_TIM_STC1)->EnableWindow(FALSE);
		GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_UNTIL)->EnableWindow(FALSE);
	}

	// _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiBeC_xHqqkZx_
	GetDlgItem(IDC_HFD_DAT_STC0)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_STC1)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_STC2)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_STC3)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_STC4)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_DTM_TIME_NEAR)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_EDT_RANGE_DAY)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_EDT_RANGE_HOUR)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_EDT_RANGE_MINUTES)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_SPN_RANGE_DAY)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_SPN_RANGE_HOUR)->EnableWindow(!bIsBetween);
	GetDlgItem(IDC_HFD_DAT_SPN_RANGE_MINUTES)->EnableWindow(!bIsBetween);

	GetDlgItem(IDC_HFD_DAT_STC5)->EnableWindow(bIsBetween);
	GetDlgItem(IDC_HFD_DAT_STC6)->ShowWindow(bIsBetween ? SW_SHOW : SW_HIDE);
} // CFCPrhHistFindDate::UpdateActivate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::DoFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::DoFind ()
{
	// CFCDlgHistFindResults_xZkqqHx_iCkJiCoH_xHqqkZx_HistoryFind_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCHistoryFind& hf = FFHistViewFrame()->GetHtreeFindResults()->GetHistoryFind();
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeCiOmAiNnLiCmNiMmEiCmOiCoKiCmIiCkCiCmNiClIiBeC_xHqqkZx_
	if (!g_pProject->IsProjectOpened())
		FFThrowMiscUnknown();
	long lDocumentId = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetDocumentId() : -1;
	flint fliNextSessionIndex = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetNextSessionIndex() : -1;
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (m_lSearchRadioCtrl == IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE)
	//----- _xZkqqHx_iOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
		hf.FindDate(g_pProject->GetFilePathH(),
					(m_iSearchMethod == 0),		// _xZkqqHx_jBgFiCkNiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
					GetNarrowTimeFrom(),
					GetNarrowTimeUntil(),
					GetNarrowUserId(),
					m_bTbcSrhSearchAllDocument,
					m_bTbcSrhSearchBefore,
					m_bTbcSrhSearchHigher,
					m_bTbcSrhSearchBeforeBranch,
					m_bTbcSrhSearchAfter,
					m_bTbcSrhSearchAfterBranch,
					lDocumentId,
					fliNextSessionIndex,
					COleDtToFdsec(m_otmTimeNear));
	} else
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ASSERT(m_bTbcTimTimeFrom || m_bTbcTimTimeUntil);
		FDSECTIME fdstTarget;
		if (!m_bTbcTimTimeFrom)
		//----- _xZkqqHx_iKeKiOgOjDpKiOjOiCkKjAkHiMmAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmNiPeJjHlJjDpKiOjOiBeC_xHqqkZx_
			fdstTarget = GetNarrowTimeUntil();
		} else
		if (!m_bTbcTimTimeUntil)
		//----- _xZkqqHx_iPeJjHlJjDpKiOjOiCkKjAkHiMmAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmNiKeKiOgOjDpKiOjOiBeC_xHqqkZx_
			fdstTarget = GetNarrowTimeFrom();
		} else
		//----- _xZkqqHx_iKeKiOgOjDpKiOjOiBeBiPeJjHlJjDpKiOjOiCmGiCoAiCmJjAkHiMmAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmNiKeKiOgOjDpKiOjOiBeC_xHqqkZx_
			fdstTarget = GetNarrowTimeFrom();
		}
		// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
		hf.FindDate(g_pProject->GetFilePathH(),
					(m_iSearchMethod == 0),		// _xZkqqHx_jBgFiCkNiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
					GetNarrowTimeFrom(),
					GetNarrowTimeUntil(),
					GetNarrowUserId(),
					m_bTbcSrhSearchAllDocument,
					m_bTbcSrhSearchBefore,
					m_bTbcSrhSearchHigher,
					m_bTbcSrhSearchBeforeBranch,
					m_bTbcSrhSearchAfter,
					m_bTbcSrhSearchAfterBranch,
					lDocumentId,
					fliNextSessionIndex,
					fdstTarget);
	}
} // CFCPrhHistFindDate::DoFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::GetNarrowTimeFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MIN)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCPrhHistFindDate::GetNarrowTimeFrom () const
{
	if (m_lSearchRadioCtrl == IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE)
	//----- _xZkqqHx_iOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FDSECTIME fdstRange = (m_lRangeDay * 86400) + (m_lRangeHour * 3600) + (m_lRangeMinutes * 60);
		FDSECTIME fdstTarget = COleDtToFdsec(m_otmTimeNear);
		return (fdstTarget - fdstRange);
	} else
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return BASE_CLASS::GetNarrowTimeFrom();
	}
} // CFCPrhHistFindDate::GetNarrowTimeFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::GetNarrowTimeUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MAX)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCPrhHistFindDate::GetNarrowTimeUntil () const
{
	if (m_lSearchRadioCtrl == IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE)
	//----- _xZkqqHx_iOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FDSECTIME fdstRange = (m_lRangeDay * 86400) + (m_lRangeHour * 3600) + (m_lRangeMinutes * 60);
		FDSECTIME fdstTarget = COleDtToFdsec(m_otmTimeNear);
		return (fdstTarget + fdstRange);
	} else
	//----- _xZkqqHx_jDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return BASE_CLASS::GetNarrowTimeUntil();
	}
} // CFCPrhHistFindDate::GetNarrowTimeUntil.

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDate _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindDate::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	//----- _xZkqqHx_jDpKiCmJiClPjFfMiOkGiCpA_xHqqkZx_ 1999_xZkqqHx_jEeO_xHqqkZx_ 2_xZkqqHx_iMiO_xHqqkZx_ 9_xZkqqHx_jDpK_xHqqkZx_ 14_xZkqqHx_iOjO_xHqqkZx_21_xZkqqHx_jFkK_xHqqkZx_ _xZkqqHx_iCmMiMgAiOkOiCmJiPeDjAlD_xHqqkZx_ -----
	CString strForm;
	strForm.LoadString(IDS_FORM_DATE_TIME_LONG_2);
	((CDateTimeCtrl*)GetDlgItem(IDC_HFD_DAT_DTM_TIME_NEAR))->SetFormat(strForm);

	//----- _xZkqqHx_iDfIiDhDiDjDiDhLiDfOiDjDiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	((CSpinButtonCtrl*)GetDlgItem(IDC_HFD_DAT_SPN_RANGE_DAY))->SetRange(0, 10000);
	((CSpinButtonCtrl*)GetDlgItem(IDC_HFD_DAT_SPN_RANGE_HOUR))->SetRange(0, 10000);
	((CSpinButtonCtrl*)GetDlgItem(IDC_HFD_DAT_SPN_RANGE_MINUTES))->SetRange(0, 10000);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCPrhHistFindDate::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::OnHfdDatRdoSearchNearDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiBhFiOhHjCoIjDpKiOjOiCmJiLnPiCkCiImKjChFiCpAiMjPiNpFiBhGiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::OnHfdDatRdoSearchNearDate ()
{
	// _xZkqqHx_iMjPiNpFiOhHjCoIiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lSearchRadioCtrl = IDC_HFD_DAT_RDO_SEARCH_NEAR_DATE;
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindDate::OnHfdDatRdoSearchNearDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDate::OnHfdDatRdoSearchBetweenDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiBhFjDpKiOjOiCmMiPoDiMmAiBeBiJlKiMmAiCpAiOhHjCoIiClFiCmEiMjPiNpFiBhGiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDate::OnHfdDatRdoSearchBetweenDate ()
{
	// _xZkqqHx_iMjPiNpFiOhHjCoIiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lSearchRadioCtrl = IDC_HFD_DAT_RDO_SEARCH_BETWEEN_DATE;
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindDate::OnHfdDatRdoSearchBetweenDate.

