#include "stdafx.h"
#include "DynamicDraw.h"		// For FFGetApp.IDS_XXX.
#include "UtilStr.h"			// For FFLoadString.
#include "UtilFile.h"			// For FFGetTmpDirectory().
#include "HiProject.h"			// For FCHiProject.
#include "DocumentRecCopy.h"	// For FCDocumentRecCopy.
#include "ProjectCopy.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::FCProjectCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCProjectCopy::FCProjectCopy ()
			:	m_pFactory(NULL)
{
	m_guidTableGuid = GUID_NULL;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_dwLockedDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_dwLastEndIndex = DWORD(-1);		// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
	m_dwLastAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
} // FCProjectCopy::FCProjectCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::FCProjectCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCProjectCopy::FCProjectCopy (FCHiProject& project)
			:	m_pFactory(NULL)
{
	operator = (project);
} // FCProjectCopy::FCProjectCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::~FCProjectCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCProjectCopy::~FCProjectCopy ()
{
	Clear();
} // FCProjectCopy::~FCProjectCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::SetFactory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pFactory	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiNoMjAkMiCmMiDhEiDeAiDeOiDgHiDiKiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDhEiDeAiDeOiDgHiDiKiBfLiCpAjAnNjCoIiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::SetFactory (const FCDocRecCopyFactory* pFactory)
{
	m_pFactory = pFactory;
} // FCProjectCopy::SetFactory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjBoDjDpMiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmMjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::operator = (FCHiProject& project)
{
	// _xZkqqHx_jDoAjHgFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	Clear();

//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidTableGuid = g_pFileServer->GetLockedTableGuid(project.GetTableName());
//	// _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmGjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwLockedDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(project.GetTableName());
//	m_dwLastAppendIdentifier = g_pFileServer->GetLockedAppendIdentifier(project.GetTableName());
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_guidTableGuid = project.GetTableGuid();
	// _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmGjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwLastEndIndex = project.GetRecordCount();
	if (m_dwLastEndIndex != 0)
		m_dwLastAppendIdentifier = project.GetRecordAppendIdentifier(m_dwLastEndIndex - 1);
	else
		m_dwLastAppendIdentifier = DWORD(-1);
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoOjFpBiCpAiOoGjDlO_xHqqkZx_ -----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
	m_wstrFilePath = project.GetFilePath();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	m_wstrTitle = project.GetTitle();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	m_fdstDate = project.GetDate();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_guidUserId = project.GetUserId();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	m_wstrComment = project.GetComment();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmM_xHqqkZx_UserId->Name_xZkqqHx_iBeC_xHqqkZx_
	project.GetMemberUserList(m_mpUserIdToName);
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiBfLiBeC_xHqqkZx_
	project.GetLimitedUserList(m_stLimitedUser);
	// _xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDocRecCopyFactory factory;
	const FCDocRecCopyFactory* pFactory = (m_pFactory != NULL) ? m_pFactory : &factory;
	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->FCDocRecData_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	long lDocId;
	FCHiDocumentRec hiDocRec;
	for (hiDocRec = project.GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 hiDocRec = project.GetNextHidocumentRec(lDocId))
	{
		FCDocumentRecCopy* pDoc = pFactory->Create(this);
		*pDoc = hiDocRec;
		m_mpDocIdToDocRec[lDocId] = pDoc;
	}
} // FCProjectCopy::operator = (FCHiProject& project)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::IsVirtualTableRecordModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
 *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmGjEoEiKhC_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project	:_xZkqqHx_jEoEiKhCiClHiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCProjectCopy::IsVirtualTableRecordModified (FCHiProject& project) const
{
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return	(m_guidTableGuid != g_pFileServer->GetLockedTableGuid(tableName)) ||
//			(m_dwLockedDeleteIdentifier != g_pFileServer->GetLockedDeleteIdentifier(tableName)) ||
//			(m_dwLastAppendIdentifier != g_pFileServer->GetLockedAppendIdentifier(tableName));
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_guidTableGuid != project.GetTableGuid())
		return TRUE;
	if (m_dwLastEndIndex != project.GetRecordCount())
		return TRUE;
	if (m_dwLastEndIndex == 0)
		return FALSE;
	if (m_dwLastAppendIdentifier != project.GetRecordAppendIdentifier(m_dwLastEndIndex - 1))
		return TRUE;
	return FALSE;
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCProjectCopy::IsVirtualTableRecordModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjHgFiCpAiDeOiDiKiDeBiClHiCoJiBeCiDhEiDeAiDeOiDgHiDiKiBfLiCmNiInLiOjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::Clear ()
{
	m_guidTableGuid = GUID_NULL;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_dwLastEndIndex = DWORD(-1);			// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
	m_dwLastAppendIdentifier = DWORD(-1);	// _xZkqqHx_iNmFiMoDiCmMiDiMiDfCiBfLiDgIiCmMjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_

	m_wstrFilePath.Empty();					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
	m_wstrTitle.Empty();					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	m_fdstDate = FDSECTIME(0);				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	m_guidUserId = GUID_NULL;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_wstrComment.Empty();					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	m_mpUserIdToName.clear();				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmM_xHqqkZx_UserId->Name_xZkqqHx_iBeC_xHqqkZx_
	m_stLimitedUser.clear();				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAkHiMmAiDiGiBfLiDfFiBfLiBeC_xHqqkZx_

	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->FCDocRecData_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	FCDocRecCopyFactory factory;
	const FCDocRecCopyFactory* pFactory = (m_pFactory != NULL) ? m_pFactory : &factory;
	map<long, FCDocumentRecCopy*>::iterator i;
	for (i = m_mpDocIdToDocRec.begin(); i != m_mpDocIdToDocRec.end(); i++)
		pFactory->Delete(i->second);
	m_mpDocIdToDocRec.clear();
} // FCProjectCopy::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::GetFilePath () const
{
	return m_wstrFilePath;
} // FCProjectCopy::GetFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::GetTitle () const
{
	return m_wstrTitle;
} // FCProjectCopy::GetTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiNoMjAkMjDpKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMjDpKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCProjectCopy::GetDate () const
{
	return m_fdstDate;
} // FCProjectCopy::GetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetIsUnknownFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCProjectCopy::GetIsUnknownFile () const
{
	// _xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDeAiDeDiDiLiCmFiCkAiCoKiCmOiBeBjAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmGiCnNiCmIiClHiBeC_xHqqkZx_
	const WString wstrTmpDirPath = FFGetTmpDirectory();
	return (wcsncmp(wstrTmpDirPath, GetFilePath(), wstrTmpDirPath.GetLength()) == 0);
} // FCProjectCopy::GetIsUnknownFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCProjectCopy::GetUserId () const
{
	return m_guidUserId;
} // FCProjectCopy::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::GetComment () const
{
	return m_wstrComment;
} // FCProjectCopy::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoOjFpBiCpAiBeBiDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmI_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::GetHintText () const
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmMiOjOiKnEiBeC_xHqqkZx_
	COleDateTime otmDate = FdsecToFiletime(GetDate());
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	WString wstrFilePath = GetIsUnknownFile() ? FFGetApp()->GetDocString(CDocTemplate::docName) :
														GetFilePath();
	// IDS_FORM_HTREE_PROPERTY_A =
	// _xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_
	// _xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
	// _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_:%s\r\n
	// _xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	// _xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_:%s
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_A,
							GetTitle().c_str(),						// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
							wstrFilePath.c_str(),					// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
							wstrDate.c_str(),						// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
							UserIdToUserName(GetUserId()).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							GetComment().c_str());					// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
} // FCProjectCopy::GetHintText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetMemberUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpGuidToUserName	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiGiBfLiDfFiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::GetMemberUserList (GuidToUserNameMap& mpGuidToUserName) const
{
	mpGuidToUserName = m_mpUserIdToName;
} // FCProjectCopy::GetMemberUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::UserIdToUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_GUID_xZkqqHx_iCmMiDiGiBfLiDfFjGlMiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:_xZkqqHx_iDiGiBfLiDfFiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiLpDjFlGiOjKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::UserIdToUserName (const GUID& guidUserId) const
{
	//----- _xZkqqHx_iDiGiBfLiDfFiDhEiDeAiDeDiDiLiCpAiMjPiNpF_xHqqkZx_ -----
	GuidToUserNameMap::const_iterator iUs = m_mpUserIdToName.find(guidUserId);
	if (iUs == m_mpUserIdToName.end()) return L"";
	return iUs->second;
} // FCProjectCopy::UserIdToUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetDocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocumentId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiBeCjBmOiJjOiClHiCoJiDiMiDfCiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDocumentRecCopy* FCProjectCopy::GetDocumentRec (long lDocumentId)
{
	map<long, FCDocumentRecCopy*>::iterator i = m_mpDocIdToDocRec.find(lDocumentId);
	if (i != m_mpDocIdToDocRec.end())
		return i->second;
	else
		return NULL;
} // FCProjectCopy::GetDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetDocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocumentId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiBeCjBmOiJjOiClHiCoJiDiMiDfCiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCDocumentRecCopy* FCProjectCopy::GetDocumentRec (long lDocumentId) const
{
	map<long, FCDocumentRecCopy*>::const_iterator i = m_mpDocIdToDocRec.find(lDocumentId);
	if (i != m_mpDocIdToDocRec.end())
		return i->second;
	else
		return NULL;
} // FCProjectCopy::GetDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::SubDocumentIdToTopId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkJiCoHiBeBiClLiCmMjFlGiPjBiCkKjBkOiClHiCoJjGnIiNfMjBkCiCmMiDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_
 *			ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCProjectCopy::SubDocumentIdToTopId (long lDocId) const
{
	// _xZkqqHx_iPoDiImKjHjKjHpAiCkK_xHqqkZx_-1_xZkqqHx_iCmJiCmIiCoJiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
	for (;;)
	{
		const long lDocIdSuper = GetDocumentRec(lDocId)->GetSuperDocId();
		if (lDocIdSuper == -1) break;
		lDocId = lDocIdSuper;
	}
	return lDocId;
} // FCProjectCopy::SubDocumentIdToTopId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::IsMemberOfUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_GUID_xZkqqHx_iCmMiDiGiBfLiDfFjGlMiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:_xZkqqHx_iDiGiBfLiDfFiCmM_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCProjectCopy::IsMemberOfUsersGroup (const GUID& guid) const
{
	return (m_mpUserIdToName.find(guid) != m_mpUserIdToName.end());
} // FCProjectCopy::IsMemberOfUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::IsQualifiedToModify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCmJiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiPeDjAlDiClHiCoJiMkAiMmAiCkKiCkAiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMkAiMmAiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCProjectCopy::IsQualifiedToModify (const GUID& guidUserId) const
{
	switch (CheckQualification(guidUserId))
	{
	case FCHiProject::LIMITED_USER:	// _xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	case FCHiProject::NOT_MEMBER:	// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
		return FALSE;
	default:	// FCHiProject::MEMBER_USER:	_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		return TRUE;
	}
} // FCProjectCopy::IsQualifiedToModify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::CheckQualification
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiBeFjAkHiMmAiDiGiBfLiDfFiBfLiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiCmMiOoNjHnOiBeC_xHqqkZx_
 *				NOT_MEMBER		:_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *				MEMBER_USER		:_xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *				LIMITED_USER	:_xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiProject::Qualification FCProjectCopy::CheckQualification (const GUID& guidUserId) const
{
	// _xZkqqHx_iPjBiCkLiNjOiCnNiCpAjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBeI_xHqqkZx_
	if (m_stLimitedUser.find(guidUserId) != m_stLimitedUser.end())
		return FCHiProject::LIMITED_USER;	// _xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsMemberOfUsersGroup(guidUserId))
		return FCHiProject::MEMBER_USER;		// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
	return FCHiProject::NOT_MEMBER;			// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
} // FCProjectCopy::CheckQualification.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::FindDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMjFlGiPjBiCpAiMjPiNpFiClFiBeBiOhHjCoIiClDiCoKiClNiDfOiDeDiDgHiDiLiBeBiDgPiBfLiDfHiDiHiDjDiCmG_xHqqkZx_
 *			_xZkqqHx_iIoKjChGiClHiCoJjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDfOiDeDiDgHiDiLiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgPiBfLiDfHiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDocTitle = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiNmFiPiJiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeB_xHqqkZx_
 *			wcpVersion = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjFlGiPjBiDfOiDeDiDgHiDiLiCkKiIoKjChGiClHiCoJiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCProjectCopy::FindDocumentId (const wchar_t* wcpDocTitle, const wchar_t* wcpVersion) const
{
	// _xZkqqHx_jDkPjGlMiBeFjDkPiDgPiBfLiDfHiDiHiDjDiCmMjHjKjHpAjFlGiPjBiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	long lDocId;
	const FCDocumentRecCopy* pDocRec;
	for (pDocRec = GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 pDocRec = GetNextHidocumentRec(lDocId))
	{
		if (wcpDocTitle != NULL &&
			wcscmp(wcpDocTitle, pDocRec->GetDocTitle()) != 0) continue;
		if (wcpVersion != NULL &&
			wcscmp(wcpVersion, pDocRec->GetVersion()) != 0) continue;
		break;
	}
	return lDocId;
} // FCProjectCopy::FindDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::CalcUniqSubVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCmGjEoEiKhCiClFiCmEiBeBiDiGiDgKiBfLiDeOiCmI_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDocTitle	:_xZkqqHx_jHjKjHpAjFlGiPjBjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_iMlLiNnNiCmMiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpVersion_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCmJ_xHqqkZx_ ".n" _xZkqqHx_iCpAjCmHiJmBiClFiClN_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKjHpBiCpAjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCmGiClHiCoJiBeCiClBiCmMiOjOjCmHiJmBiClHiCoJjEnEiNiG_xHqqkZx_ n
 *			_xZkqqHx_iCkKiDfEiDhFiDgPiBfLiDfHiDiHiDjDiCmFiCkAiCoJiBeC_xHqqkZx_
 *			wcpDocTitle_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBjGlMiCmGjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDiCmMjBgHiCnNiNiHiCoNiClJ_xHqqkZx_
 *			_xZkqqHx_iCkKiDiGiDgKiBfLiDeOiCmFiCkAiCoKiCmOiBeB_xHqqkZx_n _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCProjectCopy::CalcUniqSubVersion (	const wchar_t* wcpDocTitle,
										const wchar_t* wcpVersion) const
{
	WString wstrNewVer;	// _xZkqqHx_jAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjGlMiBeC_xHqqkZx_
	BOOL bUniq;			// _xZkqqHx_jFlGiPjBjGlMiBhLiDgPiBfLiDfHiDiHiDjDiCkKiDiGiDgKiBfLiDeOiCkJiBeI_xHqqkZx_
	int iSubVer = 0;	// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	do {
		// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAiIoKiCmCjBjNiCoCiClHiBeC_xHqqkZx_
		iSubVer++;
		bUniq = TRUE;
		// _xZkqqHx_iJlMiCmMjAfGiClFiCkCiDgPiBfLiDfHiDiHiDjDjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
		wstrNewVer.Format(L"%s.%d", wcpVersion, iSubVer);
		long lDocId;
		const FCDocumentRecCopy* pDocRec;
		for (pDocRec = GetFirstHidocumentRec(lDocId);
			 lDocId != -1 && bUniq;
			 pDocRec = GetNextHidocumentRec(lDocId))
		{
			// _xZkqqHx_jFlGiPjBjGlMiCmGiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNiBeBiDiGiDgKiBfLiDeOiCmFiCmIiCkCiBeC_xHqqkZx_
			if (wcscmp(wcpDocTitle, pDocRec->GetDocTitle()) == 0 &&
				wstrNewVer == pDocRec->GetVersion())
				bUniq = FALSE;
		}
	} while (!bUniq);
	// _xZkqqHx_iDfEiDhFiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
	return iSubVer;
} // FCProjectCopy::CalcUniqSubVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::CalcUniqDocTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBjGlMiCmGjEoEiKhCiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjHjKjHpAjFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrNewTitle:_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjHjKjHpAjFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDocTitle	:_xZkqqHx_iMlDiCmMjHjKjHpAjFlGiPjBjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgPiBfLiDfHiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *						 _xZkqqHx_iClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDocTitle_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNjHjKjHpAjFlGiPjBiCmGjDkPiClGjFlGiPjBjGlMiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmJ_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClBiCmMjFlGiPjBjGlMiCmMiMoDiCoLiCmJ_xHqqkZx_1,2,,_xZkqqHx_iCpAjCmHiJmBiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iDiGiDgKiBfLiDeOiCmIjFlGiPjBjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::CalcUniqDocTitle (	WString& wstrNewTitle,
										const wchar_t* wcpDocTitle,
										const wchar_t* wcpVersion) const
{
	wstrNewTitle = wcpDocTitle;
	// _xZkqqHx_jDkPiClGjFlGiPjBiDfOiDeDiDgHiDiLiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDfOiDeDiDgHiDiLiCpAjFmPiNfIiClFiCmEiMjPiNpFiBeC_xHqqkZx_
	for (long lC = 0;
		 FindDocumentId(wstrNewTitle.c_str(), wcpVersion) != -1; lC++)
		wstrNewTitle.Format(L"%s%ld", wcpDocTitle, lC);
} // FCProjectCopy::CalcUniqDocTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetFirstHidocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_iNmFiPiJiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *					 -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCDocumentRecCopy* FCProjectCopy::GetFirstHidocumentRec (long& lDocId) const
{
	map<long, FCDocumentRecCopy*>::const_iterator i = m_mpDocIdToDocRec.begin();
	if (i != m_mpDocIdToDocRec.end())
	{
		lDocId = i->first;
		return i->second;
	} else
	{
		lDocId = -1;
		return NULL;
	}
} // FCProjectCopy::GetFirstHidocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetNextHidocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjPiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jBfDiKeKiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiOjPiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
					 _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCDocumentRecCopy* FCProjectCopy::GetNextHidocumentRec (long& lDocId) const
{
	map<long, FCDocumentRecCopy*>::const_iterator i = m_mpDocIdToDocRec.find(lDocId);
	ASSERT(i != m_mpDocIdToDocRec.end());
	// _xZkqqHx_iIoKiCmCjAgJiCnPiCoJiBeC_xHqqkZx_
	i++;
	if (i != m_mpDocIdToDocRec.end())
	{
		lDocId = i->first;
		return i->second;
	} else
	{
		lDocId = -1;
		return NULL;
	}
} // FCProjectCopy::GetNextHidocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetSubHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiBeBiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHiDocId	:lHiDocId_xZkqqHx_iImIiJlKiCmMjHjKjHpAjFlGiPjBiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHiDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpIdToSubId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iDfEiDhFjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myGetSubHidocument (longSet& stHiDocId,
								long lHiDocId,
								const map<long, longSet>& mpIdToSubId)
{
	stHiDocId.insert(lHiDocId);
	const longSet& stSubId = (*mpIdToSubId.find(lHiDocId)).second;
	longSet::const_iterator i;
	for (i = stSubId.begin(); i != stSubId.end(); i++)
	{
		myGetSubHidocument(stHiDocId, *i, mpIdToSubId);
	}
} // myGetSubHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetHidocumentTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjDgPjIfOiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMjGnIiNfMjBkCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stTopId		:_xZkqqHx_jGnIiNfMjBkCiCmMiDgHiDgCiDhGiCmGiCmIiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mpIdToSubId	:_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjGnIiNfMjBkCiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iDfEiDhFjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiCmNiBeBjFkBjAjEiCmMjGnIiNfMjBkCiCkKjBlGiNnNiClFjDlOiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjBiCoAjFkBjAjEjBlGiNnNiClFjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::GetHidocumentTree (longSet& stTopId, map<long, longSet>& mpIdToSubId) const
{
	stTopId.clear();
	mpIdToSubId.clear();
	long lDocId;
	const FCDocumentRecCopy* pDocRec;
	for (pDocRec = GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 pDocRec = GetNextHidocumentRec(lDocId))
	{
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (pDocRec->GetIsTemporary()) continue;
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// lDocId_xZkqqHx_iCpAjDgPjIfOiBeC_xHqqkZx_
		mpIdToSubId[lDocId];
		long lSuperId = GetDocumentRec(lDocId)->GetSuperDocId();
		if (lSuperId == -1)
			stTopId.insert(lDocId);
		else
			mpIdToSubId[lSuperId].insert(lDocId);
	}
} // FCProjectCopy::GetHidocumentTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetLowerHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHiDocId	:lHiDocId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAjFlGiPjBiImIiJlKiCmMjHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *						 lHiDocId _xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *			lHiDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCProjectCopy::GetLowerHidocument (longSet& stHiDocId, long lHiDocId) const
{
	stHiDocId.clear();
	longSet stTopId;
	map<long, longSet> mpIdToSubId;
	GetHidocumentTree(stTopId, mpIdToSubId);
	myGetSubHidocument(stHiDocId, lHiDocId, mpIdToSubId);
} // FCProjectCopy::GetLowerHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCProjectCopy::GetUniqSubDocumentVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFlGiPjBiCmMiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSuperDocId	:_xZkqqHx_iPoDiImKiCmMjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeCjHoBiBeG_xHqqkZx_3.4 _xZkqqHx_iBgJiPoDiImKjFlGiPjBiCkK_xHqqkZx_Ver=3_xZkqqHx_iCmMiPoKiNiHiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCProjectCopy::GetUniqSubDocumentVersion (long lSuperDocId) const
{
	const FCDocumentRecCopy* pSuperDocRec = GetDocumentRec(lSuperDocId);
	// _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCkJiCoHiBeBiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
	int iSubVersion = CalcUniqSubVersion(	pSuperDocRec->GetDocTitle(),
											pSuperDocRec->GetVersion());
	return FFFormatString(L"%s.%d", pSuperDocRec->GetVersion().c_str(), iSubVersion);
} // FCProjectCopy::GetUniqSubDocumentVersion.
