#include "stdafx.h"
#include "UtilStr.h"		// For StrNewCpy.
#include "UtilWin.h"		// For FFGetMenuString.
#include "RegData.h"		// For g_pReg.
#include "RecentList.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// _xZkqqHx_iLeMjIfOiClDiCoKiCoJiDiKiDfIiDgHiNmFjBoFjAjEiBeC_xHqqkZx_
#define MAX_RECENT_HIST_REC	(ID_FILE_RECENTEND - ID_FILE_RECENT1 + 1)
// _xZkqqHx_jFfMiOkGiClDiCoKiCoJiDiKiDfIiDgHiNmFjBoFjAjEiBeC_xHqqkZx_
#define MAX_RECENT_HIST_VIEW	10

// MFC_xZkqqHx_iCmM_xHqqkZx_APPINIT.CPP_xZkqqHx_iCmM_xHqqkZx_AfxGetFileName_xZkqqHx_iKnGjAjEiCoGiCoIiOnIjHhAiBeC_xHqqkZx_
static UINT myGetFileName (const wchar_t* lpszPathName, wchar_t* lpszTitle, UINT nMax)
{
	ASSERT(lpszTitle == NULL ||
		AfxIsValidAddress(lpszTitle, _MAX_FNAME));
	ASSERT(AfxIsValidString(lpszPathName));

	// always capture the complete file name including extension (if present)
	wchar_t* lpszTemp = (wchar_t*)lpszPathName;
	for (const wchar_t* lpsz = lpszPathName; *lpsz != L'\0'; lpsz++)
	{
		// remember last directory/drive separator
		if (*lpsz == L'\\' || *lpsz == L'/' || *lpsz == L':')
			lpszTemp = (wchar_t*)(lpsz + 1);
	}

	// lpszTitle can be NULL which just returns the number of bytes
	if (lpszTitle == NULL)
		return wcslen(lpszTemp)+1;

	// otherwise copy it into the buffer provided
	wcsncpy(lpszTitle, lpszTemp, nMax);
	return 0;
}

// MFC_xZkqqHx_iCmM_xHqqkZx_FILELIST.CPP_xZkqqHx_iCoGiCoIiOnIjHhAiBeC_xHqqkZx_

// lpszCanon = C:\MYAPP\DEBUGS\C\TESWIN.C
//
// cchMax   b   Result
// ------   -   ---------
//  1- 7    F   <empty>
//  1- 7    T   TESWIN.C
//  8-14    x   TESWIN.C
// 15-16    x   C:\...\TESWIN.C
// 17-23    x   C:\...\C\TESWIN.C
// 24-25    x   C:\...\DEBUGS\C\TESWIN.C
// 26+      x   C:\MYAPP\DEBUGS\C\TESWIN.C

static void AFXAPI myAbbreviateName (wchar_t* lpszCanon, int cchMax, BOOL bAtLeastName)
{
	int cchFullPath, cchFileName, cchVolName;
	const wchar_t* lpszCur;
	const wchar_t* lpszBase;
	const wchar_t* lpszFileName;

	lpszBase = lpszCanon;
	cchFullPath = wcslen(lpszCanon);

	cchFileName = myGetFileName(lpszCanon, NULL, 0) - 1;
	lpszFileName = lpszBase + (cchFullPath-cchFileName);

	// If cchMax is more than enough to hold the full path name, we're done.
	// This is probably a pretty common case, so we'll put it first.
	if (cchMax >= cchFullPath)
		return;

	// If cchMax isn't enough to hold at least the basename, we're done
	if (cchMax < cchFileName)
	{
		wcscpy(lpszCanon, (bAtLeastName) ? lpszFileName : L"");
		return;
	}

	// Calculate the length of the volume name.  Normally, this is two characters
	// (e.g., "C:", "D:", etc.), but for a UNC name, it could be more (e.g.,
	// "\\server\share").
	//
	// If cchMax isn't enough to hold at least <volume_name>\...\<base_name>, the
	// result is the base filename.

	lpszCur = lpszBase + 2;                 // Skip "C:" or leading "\\"

	if (lpszBase[0] == L'\\' && lpszBase[1] == L'\\') // UNC pathname
	{
		// First skip to the '\' between the server name and the share name,
		while (*lpszCur != L'\\')
		{
			lpszCur++;
			ASSERT(*lpszCur != L'\0');
		}
	}
	// if a UNC get the share name, if a drive get at least one directory
	ASSERT(*lpszCur == L'\\');
	// make sure there is another directory, not just c:\filename.ext
	if (cchFullPath - cchFileName > 3)
	{
		lpszCur++;
		while (*lpszCur != L'\\')
		{
			lpszCur++;
			ASSERT(*lpszCur != L'\0');
		}
	}
	ASSERT(*lpszCur == L'\\');

	cchVolName = lpszCur - lpszBase;
	if (cchMax < cchVolName + 5 + cchFileName)
	{
		wcscpy(lpszCanon, lpszFileName);
		return;
	}

	// Now loop through the remaining directory components until something
	// of the form <volume_name>\...\<one_or_more_dirs>\<base_name> fits.
	//
	// Assert that the whole filename doesn't fit -- this should have been
	// handled earlier.

	ASSERT(cchVolName + (int)wcslen(lpszCur) > cchMax);
	while (cchVolName + 4 + (int)wcslen(lpszCur) > cchMax)
	{
		do
		{
			lpszCur++;
			ASSERT(*lpszCur != L'\0');
		}
		while (*lpszCur != L'\\');
	}

	// Form the resultant string and we're done.
	lpszCanon[cchVolName] = L'\0';
	wcscat(lpszCanon, L"\\...");
	wcscat(lpszCanon, lpszCur);
} // myAbbreviateName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::AbbreviatePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfIiCpAjCfKiCkNiPmIjHkKiMgAiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPmIjHkKiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCRecentList::AbbreviatePath (const wchar_t* wcpPath)
{
	//----- _xZkqqHx_jClHiCkCiDfOiDeDiDgHiDiLiCpAiPmIjHkKiClHiCoJ_xHqqkZx_ -----
	WCharVector vBuff(wcslen(wcpPath) + 1);
	wcscpy(&vBuff[0], wcpPath);
	myAbbreviateName(&vBuff[0], 30, TRUE);
	return WString(&vBuff[0]);
} // FCRecentList::AbbreviatePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::GetCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCmM_xHqqkZx_
 *			_xZkqqHx_jAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCRecentList::GetCount ()
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiDiKiDfIiDgHiCmMjAjEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	return g_pReg->GetRecentDocList(NULL);
} // FCRecentList::GetCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::Add
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCmJiBeBjFlGiPjBiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpShortTitle:_xZkqqHx_iNmFiLnPiOgHiCmBiClNjFlGiPjBiCmMiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiDiBiDgKiDiFiBfLiCnGiCmM_xHqqkZx_
 *						 _xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			wcpLongTitle:_xZkqqHx_iNmFiLnPiOgHiCmBiClNjFlGiPjBiCmMiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiDhMiDgCiDhGiDeBiDgCiDhGiCnGiCmM_xHqqkZx_
 *						 _xZkqqHx_jFfMiOkGiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			wcpData1	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCoKiImIiNhOiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpData2	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCoKiImIiNhOiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpData3	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCoKiImIiNhOiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpData4	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCoKiImIiNhOiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.19 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCRecentList::Add (const wchar_t* wcpShortTitle,
						const wchar_t* wcpLongTitle,
						const wchar_t* wcpData1,
						const wchar_t* wcpData2,
						const wchar_t* wcpData3,
						const wchar_t* wcpData4,
						const wchar_t* wcpData5)
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClDiCoKiCoJiDgGiBfLiDfOiBeC_xHqqkZx_
	WString wstrRegData;
	FFAppendString(wstrRegData, wcpShortTitle);
	FFAppendString(wstrRegData, wcpLongTitle);
	do
	{
		if (wcpData1 == NULL) break;
		FFAppendString(wstrRegData, wcpData1);
		if (wcpData2 == NULL) break;
		FFAppendString(wstrRegData, wcpData2);
		if (wcpData3 == NULL) break;
		FFAppendString(wstrRegData, wcpData3);
		if (wcpData4 == NULL) break;
		FFAppendString(wstrRegData, wcpData4);
		if (wcpData5 == NULL) break;
		FFAppendString(wstrRegData, wcpData5);
	} while (FALSE);
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector vStrEntry;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	g_pReg->GetRecentDocList(&vStrEntry);
	//----- _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCkKiCkAiCoJiPoKiNiHiCmNiClLiCoKiCpAiNoNiPjM_xHqqkZx_ -----
	WStringVector::iterator iE;
	for (iE = vStrEntry.begin(); iE != vStrEntry.end(); iE++)
	{
		if (wcscmp(*iE, wstrRegData) == 0)
		{
			vStrEntry.erase(iE);
			break;
		}
	}
	// _xZkqqHx_iDiKiDfIiDgHiCmMjAoGjDkKiCmJjDgPjIfOiBeC_xHqqkZx_
	vStrEntry.insert(vStrEntry.begin(), wstrRegData);
	if (MAX_RECENT_HIST_REC < vStrEntry.size())
		vStrEntry.resize(MAX_RECENT_HIST_REC);
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDiKiDfIiDgHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	g_pReg->SetRecentDocList(vStrEntry);
} // FCRecentList::Add.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::Get
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCkJiCoHiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			wstrpShortTitle	:_xZkqqHx_iNmFiLnPiOgHiCmBiClNjFlGiPjBiCmMiDfOiDeDiDgHiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpLongTitle	:_xZkqqHx_iNmFiLnPiOgHiCmBiClNjFlGiPjBiCmMiDfOiDeDiDgHiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpData1	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpData2	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_2_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpData3	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_3_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpData4	:_xZkqqHx_jFhEiJmBiDgGiBfLiDfO_xHqqkZx_4_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhAiCmMiPoKiNiHiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmNiBeBiDiBiDgKiDiFiBfLiPoDiCmMiBhFiNmFiLnPiOgHiCmBiClN_xHqqkZx_XXXX_xZkqqHx_iBhGiCmMiCfAjEnEiCkKiCePiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.21 Fukushiro M. RecentHistList_xZkqqHx_iCpAiMlDiCmJiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCRecentList::Get (short nIndex,
						WString* wstrpShortTitle,
						WString* wstrpLongTitle,
						WString* wstrpData1,
						WString* wstrpData2,
						WString* wstrpData3,
						WString* wstrpData4,
						WString* wstrpData5)
{
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector vStrEntry;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	g_pReg->GetRecentDocList(&vStrEntry);
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiLeMjIfOjAjEiCpAiJhKiCkGiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (vStrEntry.size() <= nIndex) return;
	// _xZkqqHx_iDfOiDeDiDgHiDiLiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	if (wstrpShortTitle != NULL)
		*wstrpShortTitle = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);
	// _xZkqqHx_iDfOiDeDiDgHiDiLiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	if (wstrpLongTitle != NULL)
		*wstrpLongTitle = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);

	if (wstrpData1 != NULL)
		*wstrpData1 = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);

	if (wstrpData2 != NULL)
		*wstrpData2 = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);

	if (wstrpData3 != NULL)
		*wstrpData3 = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);

	if (wstrpData4 != NULL)
		*wstrpData4 = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);

	if (wstrpData5 != NULL)
		*wstrpData5 = FFExtractString(vStrEntry[nIndex]);
	else
		(void)FFExtractString(vStrEntry[nIndex]);
} // FCRecentList::Get.
//----- 03.09.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::Del
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpShortTitle:_xZkqqHx_iNoNiPjMiClHiCoJjFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *			wcpLongTitle:_xZkqqHx_iNoNiPjMiClHiCoJjFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *			wcpData1	:_xZkqqHx_iNoNiPjMiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *			wcpData2	:_xZkqqHx_iNoNiPjMiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *			wcpData3	:_xZkqqHx_iNoNiPjMiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *			wcpData4	:_xZkqqHx_iNoNiPjMiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiIpIjAjEiCkKiIoKjChGiClHiCoJiDiKiDfIiDgHjHhGjBgGiCmNiClHiCnHiCmEiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iIpIjAjEiCkKjFkBjAjEiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBfDiCmEiCkKiIoKjChGiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.09 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//void FCRecentList::Del (const wchar_t* wcpShortTitle,
//						const wchar_t* wcpLongTitle,
//						const wchar_t* wcpData1,
//						const wchar_t* wcpData2,
//						const wchar_t* wcpData3,
//						const wchar_t* wcpData4)
//{
//	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
//	WStringVector vStrEntry;
//	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	g_pReg->GetRecentDocList(&vStrEntry);
//	WStringVector::iterator i;
//	for (i = vStrEntry.begin(); i != vStrEntry.end();)
//	{
//		WString wstrItem = *i;
//		BOOL bEqual = TRUE;
//		WString wstrShortTitle = FFExtractString(wstrItem);
//		WString wstrLongTitle = FFExtractString(wstrItem);
//		WString wstrData1 = FFExtractString(wstrItem);
//		WString wstrData2 = FFExtractString(wstrItem);
//		WString wstrData3 = FFExtractString(wstrItem);
//		WString wstrData4 = FFExtractString(wstrItem);
//		if (bEqual &&
//			wcpShortTitle != NULL &&
//			wstrShortTitle.CompareNoCase(wcpShortTitle) != 0)
//			bEqual = FALSE;
//		if (bEqual &&
//			wcpLongTitle != NULL &&
//			wstrLongTitle.CompareNoCase(wcpLongTitle) != 0)
//			bEqual = FALSE;
//		if (bEqual &&
//			wcpData1 != NULL &&
//			wstrData1.CompareNoCase(wcpData1) != 0)
//			bEqual = FALSE;
//		if (bEqual &&
//			wcpData2 != NULL &&
//			wstrData2.CompareNoCase(wcpData2) != 0)
//			bEqual = FALSE;
//		if (bEqual &&
//			wcpData3 != NULL &&
//			wstrData3.CompareNoCase(wcpData3) != 0)
//			bEqual = FALSE;
//		if (bEqual &&
//			wcpData4 != NULL &&
//			wstrData4.CompareNoCase(wcpData4) != 0)
//			bEqual = FALSE;
//		if (bEqual)
//			i = vStrEntry.erase(i);
//		else
//			i++;
//	}
//	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDiKiDfIiDgHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
//	g_pReg->SetRecentDocList(vStrEntry);
//} // FCRecentList::Del.
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::Del
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	:_xZkqqHx_iNoNiPjMiClDiCoKiCoJiDeHiDjDiDgHiDiKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRecentList::Del (short nIndex)
{
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector vStrEntry;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	g_pReg->GetRecentDocList(&vStrEntry);
	// _xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCpAiNoNiPjMiBeC_xHqqkZx_
	vStrEntry.erase(vStrEntry.begin() + nIndex);
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDiKiDfIiDgHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	g_pReg->SetRecentDocList(vStrEntry);
} // FCRecentList::Del.
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::Find
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiBhFiNmFiLnPiOgHiCmBiClNjFlGiPjBiBhGiDiKiDfIiDgHiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpShortTitle:_xZkqqHx_iMjPiNpFiClHiCoJjFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpLongTitle:_xZkqqHx_iMjPiNpFiClHiCoJjFlGiPjBiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpData1	:_xZkqqHx_iMjPiNpFiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpData2	:_xZkqqHx_iMjPiNpFiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpData3	:_xZkqqHx_iMjPiNpFiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpData4	:_xZkqqHx_iMjPiNpFiClHiCoJjFhEiJmBiDgGiBfLiDfO_xHqqkZx_1_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiDeDiDjDiDgGiDgCiDeOiDfIiBeBiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiIpIjAjEiCkKiKkOjBfDiCmJiIoKjChGiClHiCoJiBeBiNmFiPiJiCmMiDiKiDfIiDgHjHhGjBgGiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJjFeLjHhGiCmMiCmIiCkCjHhGjBgGiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.09 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
short FCRecentList::Find (	const wchar_t* wcpShortTitle,
							const wchar_t* wcpLongTitle,
							const wchar_t* wcpData1,
							const wchar_t* wcpData2,
							const wchar_t* wcpData3,
							const wchar_t* wcpData4,
							const wchar_t* wcpData5)
{
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector vStrEntry;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	g_pReg->GetRecentDocList(&vStrEntry);
	short nIndex;
	for (nIndex = 0; nIndex != vStrEntry.size(); nIndex++)
	{
		WString wstrItem = vStrEntry[nIndex];
		WString wstrShortTitle = FFExtractString(wstrItem);
		WString wstrLongTitle = FFExtractString(wstrItem);
		WString wstrData1 = FFExtractString(wstrItem);
		WString wstrData2 = FFExtractString(wstrItem);
		WString wstrData3 = FFExtractString(wstrItem);
		WString wstrData4 = FFExtractString(wstrItem);
		WString wstrData5 = FFExtractString(wstrItem);
		if (wcpShortTitle != NULL &&
			wstrShortTitle.CompareNoCase(wcpShortTitle) != 0)
			continue;
		if (wcpLongTitle != NULL &&
			wstrLongTitle.CompareNoCase(wcpLongTitle) != 0)
			continue;
		if (wcpData1 != NULL &&
			wstrData1.CompareNoCase(wcpData1) != 0)
			continue;
		if (wcpData2 != NULL &&
			wstrData2.CompareNoCase(wcpData2) != 0)
			continue;
		if (wcpData3 != NULL &&
			wstrData3.CompareNoCase(wcpData3) != 0)
			continue;
		if (wcpData4 != NULL &&
			wstrData4.CompareNoCase(wcpData4) != 0)
			continue;
		if (wcpData5 != NULL &&
			wstrData5.CompareNoCase(wcpData5) != 0)
			continue;
		return nIndex;
	}
	return -1;
} // FCRecentList::Find.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRecentList::UpdateMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDeBiDgCiDhGiDgGiBfLiDgHiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_OnUpdateXXXX_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI		:_xZkqqHx_iDeBiDgCiDhGiDgGiBfLiDgHiClHiCoJiDiBiDgKiDiFiBfLiNiAjGnKiBeC_xHqqkZx_
 *			bLeftHanded	:_xZkqqHx_iNlGjHjIiCkLjHhAiCmMjAnNjCoIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDiKiDfIiDgHiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiBeBiDiKiDfIiDgHiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCpAiDiBiDgKiDiFiBfLiPoDiCmJjDgPjIfOiClFiCmEiCoEiCkNiBeC_xHqqkZx_
 *			MFC/FILELIST.CPP_xZkqqHx_iCmM_xHqqkZx_UpdateMenu_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.21 Fukushiro M. RecentHistList_xZkqqHx_iCpAiMlDiCmJiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCRecentList::UpdateMenu (CCmdUI* pCmdUI, BOOL bLeftHanded)
{
	CMenu* pMenu = pCmdUI->m_pMenu;
	// _xZkqqHx_iDiBiDgKiDiFiBfLiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pMenu == NULL) return;

	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector vStrEntry;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDiKiDfIiDgHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	g_pReg->GetRecentDocList(&vStrEntry);

	int iMRH;
	for (iMRH = ID_FILE_RECENT1; iMRH < ID_FILE_RECENTEND; iMRH++)
		if (!pMenu->DeleteMenu(iMRH, MF_BYCOMMAND)) break;
	// _xZkqqHx_iDiBiDgKiDiFiBfLiCmJ_xHqqkZx_MRH_xZkqqHx_iCpAjDgPjIfOiBeC_xHqqkZx_
	for (iMRH = 0; iMRH != vStrEntry.size()&& iMRH != MAX_RECENT_HIST_VIEW; iMRH++)
	{
		// _xZkqqHx_jFfMiOkGjHhAiCmMiDfOiDeDiDgHiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		WString strData = FFExtractString(vStrEntry[iMRH]);

		// &_xZkqqHx_iLeMiNiGiCpA_xHqqkZx_&&_xZkqqHx_iCnGjFmPiKlHiBeCiDiBiDgKiDiFiBfLjFfMiOkGjHhAiBeC_xHqqkZx_
		strData.Replace(L"&", L"&&");
		// _xZkqqHx_jAoGjDkKiCmMjAjEiOjKiCpAiNoMjAkMiBeCiJeFjHjIiCkLiCmIiCoH_xHqqkZx_1,2,,9,0,1,2.. _xZkqqHx_iNlGjHjIiCkLiCmIiCoH_xHqqkZx_0,9,8,,1,0,9..
		int iNum;	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGjFlGiOjKjHpBjAoGjDkKiCmMjAjEiOjKiBeC_xHqqkZx_
		if (!bLeftHanded)
		//----- _xZkqqHx_iJeFjHjIiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// 0 -> 1_xZkqqHx_iBeB_xHqqkZx_1 -> 2_xZkqqHx_iBeB_xHqqkZx_2 -> 3_xZkqqHx_iBeBiBgDiBeB_xHqqkZx_9 -> 0_xZkqqHx_iBeB_xHqqkZx_10 -> 1_xZkqqHx_iBeB_xHqqkZx_11 -> 2_xZkqqHx_iBeBiBgD_xHqqkZx_
			iNum = iMRH + 1;
			while (9 < iNum) iNum -= 10;
		} else
		//----- _xZkqqHx_iNlGjHjIiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// 0 -> 0_xZkqqHx_iBeB_xHqqkZx_1 -> 9_xZkqqHx_iBeB_xHqqkZx_2 -> 8_xZkqqHx_iBeBiBgDiBeB_xHqqkZx_9 -> 1_xZkqqHx_iBeB_xHqqkZx_10 -> 0_xZkqqHx_iBeB_xHqqkZx_11 -> 9_xZkqqHx_iBeBiBgD_xHqqkZx_
			iNum = -iMRH;
			while (iNum < 0) iNum += 10;
		}
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGjFlGiOjKjHpBiBeC_xHqqkZx_
		WString	strMenu;
		// _xZkqqHx_jFfMiOkGjFlGiOjKjHpBjAoGjDkKiCmJjAjEiOjKiCpAjCmHiJmBiBeC_xHqqkZx_
		strMenu.Format(L"&%d %s", iNum, strData.c_str());
		pMenu->InsertMenu(pCmdUI->m_nIndex++, MF_STRING | MF_BYPOSITION,
						pCmdUI->m_nID++, WStrToTStr(strMenu));
	}
	// update end menu count
	pCmdUI->m_nIndex--; // point to last menu added
	pCmdUI->m_nIndexMax = pMenu->GetMenuItemCount();
	pCmdUI->m_bEnableChanged = TRUE;    // all the added items are enabled
} // FCRecentList::UpdateMenu.

