#ifndef __ResizeWork_h
#define __ResizeWork_h

class FCObjDynabase;

typedef BOOL (*ResizeCheckCallback)(const FCObjDynabase* objp, BOOL bXPosi,
									BOOL bYPosi, const DBLRect& mmrtNew);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiOjOiCmMjFgAiJoGiCpAjFoCiPjFiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_Tool_xZkqqHx_iCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.05.01 Fukushiro M.	_xZkqqHx_iDiKiDfEiDeDiDfJiCmMiKoOjDfPiCpAiDhEiDiMiBfLiDiAiNlGiPoDiImIiKePiCmJiCoA_xHqqkZx_
 *									_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
class FCResizeWork
{
public:
	FCResizeWork ();
	~FCResizeWork ();
	void		OnResizeFirst (ResizeCheckCallback fncCallback,
							const FCObjDynabase* ojpTarget, CDC* pDC, short nHandle);
	BOOL		OnResizeNext (CDC* pDC, UINT nFlags, const DBLPoint& mmptCur);
	BOOL		OnResizeEnd (CDC* pDC, BOOL& bXPosi, BOOL& bYPosi,
								DBLRect& mmrtResized);
	void		DrawCurFrame (CDC* pDC) const;
	void		SetResizeCheck (ResizeCheckCallback fncCallback);
	void		AddLimitLine (const DBLLine& mmLine);
	DBLPoint	GetMovePoint () const;
	DBLPoint	GetFixPoint () const;
	void		CalcResize (DBLRect& mmrtResized, const DBLRect& mmrtFrame);
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	void		CalcResize (DBLRect& mmrtResized,
//							const DBLRect& mmrtFrame,
//							BOOL bIsResizableHorz,
//							BOOL bIsResizableVert);
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	const DBLRect&	GetResizeFrame () const;
	const DBLRect&	GetResizeFrameOrg () const;
//----- 01.11.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	mmetol		CalcElementLengthForResize (const FCObjDynabase* pObj) const;

protected:
	ResizeCheckCallback	m_fncResizeCheck;	// _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiDgAiDeGiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
	const FCObjDynabase* m_ojpTarget;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiBeC_xHqqkZx_
	DBLRect		m_mmrtFrameOrig;	// _xZkqqHx_jGhLjHiIiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	DBLRect		m_mmrtFrame;		// _xZkqqHx_iMlLiNnNiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	DBLLineVector m_vLimitLine;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCmMiInKjDkOiCpAjAkHiMmAiClHiCoJjApMiBeC_xHqqkZx_
	double		m_mmDummyX;			// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMjCiGiKnEjDfPiBeC_xHqqkZx_
	double		m_mmDummyY;			// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMjCiGiKnEjDfPiBeC_xHqqkZx_
	double*		m_mmpMoveX;			// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	double*		m_mmpMoveY;			// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_

	double*		m_mmpMoveX_;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	double*		m_mmpMoveY_;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//----- 05.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	double*		m_mmpFixX;			// _xZkqqHx_iMmFjCoIiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//	double*		m_mmpFixY;			// _xZkqqHx_iMmFjCoIiDhMiDeDiDjDiDgHiBeC_xHqqkZx_mmrtFrame_xZkqqHx_iCmMiCfAiDiBiDjDiDgPiCmJiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//----- 05.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DBLPoint	m_mmptFix;			// _xZkqqHx_iMmFjCoIiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
//----- 05.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	DBLPoint	m_mmptMoveOrig;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCmMiPiJiKpKjCgMiBeC_xHqqkZx_
	double		m_dMoveRatioX;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgH_xHqqkZx_X_xZkqqHx_jFpLiMpMiInKjDkOjHmKiCmMiBeBiLoJiMgAjFjNiCmJjBmOiClHiCoJjEoEiBeC_xHqqkZx_
	double		m_dMoveRatioY;		// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgH_xHqqkZx_Y_xZkqqHx_jFpLiMpMiInKjDkOjHmKiCmMiBeBiLoJiMgAiNiCiCmJjBmOiClHiCoJjEoEiBeC_xHqqkZx_

	DBLPointVector	m_vmmptPoly;		// _xZkqqHx_jFjEjFgJiCmMiDhMiDiKiDfDiDjDjEhKjHpBiBeC_xHqqkZx_
	CPointVector	m_vlgptPoly;		// _xZkqqHx_jFjEjFgJiCmMiDhMiDiKiDfDiDjDjEhKjHpBiBeC_xHqqkZx_
}; // class FCResizeWork.

#endif//__ResizeWork_h

