#include "stdafx.h"
#include "DynamicDraw.h"
#include <float.h>			// For DBL_MAX.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For RotateConv.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilMath.h"		// For mmroundoff.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilStr.h"		// For FormatResString.
#include "UtilStdLib.h"		// For m1_for.
// 06.12.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilBezier.h"		// For FFGetStdElemLen.
#include "TextOut.h"		// For FCTextOut.
#include "DynamicDrawView.h"	// For SetScrollWnd.
// 03.07.18 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MainFrame.h"		// For g_pFrame.
#include "FoundDoc.h"		// For ConvertSFontID.
#include "NewFDObjAny.h"	// For NewFDObjAny.
// 02.12.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "ToolRichText.h"	// For g_toolRichText.
#include "UndoArchive.h"		// For FCUndoArchive.
#include "ObjFigure.h"		// For FCObjFigure.
#include "RegData.h"		// For FCRegData.
#include "SearchParser.h"	// For FCSearchParser.
#include "WndRichEdit.h"	// For FCStatLineVector.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "RichText.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#define CH_TAB	_T(0x09)
//#define CH_SPC	_T(0x20)
//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::FCRichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.09.16 Fukushiro M. _xZkqqHx_iDhNiBfLiDfHiDjDiDgGiDhEiDeIiDiLiDgHjCgMiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
FCRichText::FCRichText ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	// memset(this, 0, ..)_xZkqqHx_iCmNiLnGiOhOiBeC_xHqqkZx_virtual_xZkqqHx_iKnGjAjEiCmMiPoKiNiHiCmNiBeBiKnGjAjEiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
	// _xZkqqHx_iJpDiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	memset(&m_mmMarginL, 0,
//			offsetof(FCRichText, m_vSelectRange) - offsetof(FCRichText, m_mmMarginL));
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	memset(&m_mmMarginL, 0,
			offsetof(FCRichText, m_vpLine) - offsetof(FCRichText, m_mmMarginL));
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_mmMarginL = mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
//	m_mmMarginT = mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
//	m_mmMarginR = mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
//	m_mmMarginB = mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiDhNiBfLiDfHiDjDiBeC_xHqqkZx_0.5mm _xZkqqHx_iCmFiCmNiPkNiCmIiCkCiBeC_xHqqkZx_1.0mm_xZkqqHx_jCpGjDhIiCmJiBeC_xHqqkZx_
	m_mmMarginL = mmroundoff(1.0);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjDiBeC_xHqqkZx_
	m_mmMarginT = mmroundoff(1.0);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjDiBeC_xHqqkZx_.
	m_mmMarginR = mmroundoff(1.0);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjDiBeC_xHqqkZx_.
	m_mmMarginB = mmroundoff(1.0);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjDiBeC_xHqqkZx_.
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	m_mmrtText.SetRect(0,0,0,0);
	m_dAngle = 0.0;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.02.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	m_byResizeHorz = FD_RPT_NONE;	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiFjFlNjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//	m_byResizeVert = FD_RPT_NONE;	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiCjClMjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//	m_bIsResizeShorten = FALSE;						// _xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiPgLiPkMiBeI_xHqqkZx_
////----- 05.02.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	m_dwVertAlign = FDRC_AL_TOP;	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	m_vpLine = new FCStatLineVector;
} // FCRichText::FCRichText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	prtx	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::IsEqual (const FCRichText* prtx) const
{
	if (memcmp(&m_mmMarginL, &prtx->m_mmMarginL,
			offsetof(FCRichText, m_vpLine) -
				offsetof(FCRichText, m_mmMarginL)) != 0) return FALSE;

	if (m_vpLine->size() != prtx->m_vpLine->size()) return FALSE;
	FCStatLineVector::const_iterator i0, i1;
	for (i0 = m_vpLine->begin(), i1 = prtx->m_vpLine->begin();
		 i0 != m_vpLine->end(); i0++, i1++)
		if (*i0 != *i1) return FALSE;
	return TRUE;
} // FCRichText::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
*************************************************************************/
void FCRichText::OutStream (FCUndoArchive& ar)
{
	ar << m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar << m_dAngle;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.02.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	ar << m_byResizeHorz;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiFjFlNjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//	ar << m_byResizeVert;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiCjClMjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//	ar << m_bIsResizeShorten;	// _xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiPgLiPkMiBeI_xHqqkZx_
////----- 05.02.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	ar << m_dwVertAlign;// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	// _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
	m_vpLine->OutStream(ar);
} // FCRichText::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::InStream (FCUndoArchive& ar)
{
	ar >> m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar >> m_dAngle;		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_

	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	ar >> m_dwVertAlign;
	// _xZkqqHx_iKpJjBlGiCmMjFlGiOjKjHpBiPoOjFpBiCpAiNoNiPjMiClFiBeBjDkPiOjOiCmJjFlGiOjKjHpBiPoOjFpBiCpAjDpMjHmNiBeC_xHqqkZx_
	m_vpLine->InStream(ar);
} // FCRichText::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ConvertEnvProp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDhJiBfLiDfIiDgHiOjOiCmJiCmNiKmCiLkLiBgJjAeGiBeFiDhAiDfOiBfLiDjDjDjJiBgKiCmMiCgIiCgDiCkKjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAjGhLjHiIiCmMiKmCiLkLiCgIiCgDiCmJjFmPiKlHiClFiBeBjFeLjHhGiCmJiJjOiClGiCmEjAfGiLeLiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 00.11.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCRichText::ConvertEnvProp ()
void FCRichText::ConvertEnvProp (FCConvEnv* pConv)
{
	FCStatLineVector::iterator iL;
	FCStatCharVector::iterator iC;
	for (iL = m_vpLine->begin(); iL != m_vpLine->end(); iL++)
	{
		for (iC = (*iL).m_vStatChar.begin();
				iC != &(*iL).m_vStatChar.back(); iC++)
		{
			switch ((*iC).m_wChar)
			{
			case FDRCH_FONT_AND_OFFSET:	// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
				pConv->ConvertSFontID((*iC).m_foidFont);
				break;
			}
		}
	}
} // FCRichText::ConvertEnvProp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::EmptyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiLpDiCmMiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptPoly:_xZkqqHx_iDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			lPolySz	:mmptPoly_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNhDiCmMjBkOjAkLiCpAiOgDiClFiClNiCnMiCnMiBeB_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCfAjFlGiOjKiCmMiDgFiDeMiDfIiDgHiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::EmptyText (const FCObjFigure* pFig)
{
	// g_pView->GetRTFEditor() _xZkqqHx_iCpAiOgHiCoNiClIiBeBiClBiClBiCmFiDeHiDgGiDeCiDfOiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiKnGjAjEiCmNiDgFiDeMiDfIiDgHiMgOjFjEjFgJiNoMjAkMiOjOiCmJiOgHjHhAiClDiCoKiCoJiCkKiBeBjFfHiPiAiCmMiDeHiDgGiDeCiDfOiCmF_xHqqkZx_
	// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiMhGiOfKjCiGiBgJ_xHqqkZx_CalcEnoughSizeRatio_xZkqqHx_iKnGjAjEiBgKiCmJiOmAiNhDiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFjFfHiPiAiCmMiDeHiDgGiDeCiDfOiCpAiOgHiCkEiCmGiBeB_xHqqkZx_CalcEnoughSizeRatio_xZkqqHx_iKnGjAjEjDhCjCiGiCmF_xHqqkZx_
	// _xZkqqHx_jFfHiPiAiDeHiDgGiDeCiDfOiCmMjDoAjHgFiCkKiDeOiDiKiDeBiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiPoBiKfBiCkKjEkNjAlGiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit edit;
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	edit.ClearAll();
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCkJiCoHiLpDiCmMiCfAiNhDiCpAiDeDiDjDiDhMiBfLiDgHiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiCfAiNhDiCkKiCkAiCoJiClBiCmGiCmFiBeBiNhDiKnEiCmMjAnNjCoIjDjJiCkKiJmCjEfMiCmJiCmIiCoJiBeC_xHqqkZx_
	ExportText(&edit);
	edit.SelectAll();
	edit.OnDelete();
	ImportText(&edit);
	CalcTextLayout(&edit, pFig);
} // FCRichText::EmptyText.

//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::IsIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKjFjEjFgJjDoAiCmJiMpAiCoNiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeCjFjEjFgJiCkKjDkHjGlOiCmM_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmNiBeBjFnDiCmGiCmMiMpAiCoNiCoIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	: _xZkqqHx_iOhHjCoIiClDiCoKiClNjDfP_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCRichText::IsIntersect (const DBLPoint& mmpt) const
//{
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	DBLPoint mmptCenter = m_mmrtText.CenterPoint();
////	//----- _xZkqqHx_iOhHjCoIjDfPiCpAiLhEiJpBjDfNiClDiClJiCoJ_xHqqkZx_ -----
////	DBLPoint	mmptRot = mmpt;
////	if (!almost0(m_dAngle))
////		::RotateConv(mmptRot, sin(-m_dAngle * M_PI), cos(-m_dAngle * M_PI),
////					mmptCenter.x, mmptCenter.y);
////	CPoint	lgptRot = mm2lg(mmptRot);
////
////	mmetol	mmX;
////	mmetol	mmBaseLine;
////	mmetol	mmTMAscent;				// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpB_xHqqkZx_.
////	mmetol	mmTMDescent;			// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpB_xHqqkZx_.
////	SFontID	foidCur = FD_S_FONT_UNSPECIFY;	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
////	WORD	wOffset = WORD(-1);		// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpB_xHqqkZx_.
////	BYTE	byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
////
////	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiPfHiNiH_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfH_xHqqkZx_.
////	CRect	lgrtChar;	// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCjIfPjHjNiNmAjFfH_xHqqkZx_.
////
////	long lLine;
////	long lChar;
////	short nAfterSpace;
////	const FCStatChar* pChar;
////	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
////		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
////	{
////		switch (pChar->m_wChar)
////		{
////		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
////		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
////			break;
////
////		case FDRCH_FONT_AND_OFFSET:		// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHjAnNjCoIiBeC_xHqqkZx_
////			foidCur = pChar->m_foidFont;
////			// _xZkqqHx_iMlLiNnNiCmMiDeJiDhEiDfKiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
////			wOffset = pChar->m_wOffset;
////			mmTMAscent = g_pEnv->GetSFontRec(foidCur)->GetAngleAscent(m_dAngle, wOffset);
////			mmTMDescent = g_pEnv->GetSFontRec(foidCur)->GetDescent(wOffset);
////			break;
////
////		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////		case FDRCH_AFTERSPACE:			// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			break;
////		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
////			byCrossStat = pChar->m_byCrossStat;
////			break;
////
////		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
////			break;
////
////		case WCH_TAB:	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
////		case WCH_SPC:	// _xZkqqHx_iLpDjEjC_xHqqkZx_.
////			break;
////
////		default:
////			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCpAjClCiCnHiCoJiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
////			if (byCrossStat == FDWR_CROSS_OUTSIDE || m_mmrtText.right < mmX) break;
////			//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoG_xHqqkZx_(_xZkqqHx_iJpBjDfNjBeP_xHqqkZx_)_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
////			lgrtChar.SetRect(mm2lg(mmX + pChar->m_mmfAbcA),
////							mm2lg(mmBaseLine - mmTMAscent),
////							mm2lg(mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC),
////							mm2lg(mmBaseLine + mmTMDescent));
////			// _xZkqqHx_jFlGiOjKiCkKiKkOjBfDiCmJjAhNiMgAjDoAjBkEiCmIiCoHiCmOiBeBjHmMiIoGiCmJjFlGiOjKiMoDiKnEiKhFiCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
////			if (byCrossStat == FDWR_CROSS_INSIDE)
////				lgrtChar |= CRect(lgrtChar.left, lgrtChar.top,
////								mm2lg(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace)),
////								lgrtChar.bottom);
////			// _xZkqqHx_jFjNiBeBiNiCiClDiCpAiNeMiClAiCoJiBeCiDeOiDiKiDgCiDeOiCmJiDhBiDgCiDgHiClFiCoCiClHiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
////			lgrtChar.InflateRect(2, 2);
////			if (lgrtChar.PtInRect(lgptRot)) return TRUE;
////			break;
////		}
////	}
////	return FALSE;
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	long lHitIndex;
//	BOOL bIsHitFront;
//	// _xZkqqHx_jFlGiOjKiCmMiNlGiJeFiPoDiJlKiCmFjClCiCnHiCoJjEmNiImNiCpAiKgHjBoFiBeC_xHqqkZx_2_xZkqqHx_iDhDiDeOiDfKiDiLjCpGjDhIiCkKjDeLjDjGiCkJiBeC_xHqqkZx_
//	const DBLPoint mmptMargin(lg2mm(2), lg2mm(2));
//	return GetIntersect(lHitIndex, bIsHitFront, mmptMargin, mmpt);
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCRichText::IsIntersect.
//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDeDiDjDiDgHiCkKiCmHiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsHitFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *						 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptMargin	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
 *						 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMargin_xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiBeBjAhNiMgAiCmMiKePiCmMiDeOiDiKiDgCiDeOiCoAiPeFiCkEiJmCjEfMjAkLiCkK_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiCmMiCmFiBeBjHfMiCnPjAhNiMgAjCiGiCmMiDeOiDiKiDgCiDeOiCkJjClCiCnHiCmEiCkJiCoHiOmAiNhDiClHiCnHiCkLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCkCiClIiCoKiCkJiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiLnPjGfEiCmMjFlGiOjKiCpAjClCiCnHiBeBiCmHiClPiCoHiCmJ_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIiLnPiCkCiCkJiCoAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::GetIntersect (	long& lHitIndex,
								BOOL& bIsHitFront,
								const DBLPoint& mmptMargin,
								const DBLPoint& mmpt) const
{
	DBLPoint mmptCenter = m_mmrtText.CenterPoint();
	//----- _xZkqqHx_iOhHjCoIjDfPiCpAiLhEiJpBjDfNiClDiClJiCoJ_xHqqkZx_ -----
	DBLPoint mmptRot = mmpt;
	if (!almost0(m_dAngle))
		::RotateConv(mmptRot, sin(-m_dAngle * M_PI), cos(-m_dAngle * M_PI),
					mmptCenter.x, mmptCenter.y);

	mmetol	mmX;
	mmetol	mmBaseLine;
	mmetol	mmTMAscent;				// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	mmetol	mmTMDescent;			// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	SFontID	foidCur = FD_S_FONT_UNSPECIFY;	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD	wOffset = WORD(-1);		// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	BYTE	byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_

	// _xZkqqHx_iNmFiPiJiCmJiDhBiDgCiDgHiClFiCmEiCkJiCoHiDgAiDeGiDgCiDeOiClFiClNjFlGiOjKjAjEiBeC_xHqqkZx_
	// _xZkqqHx_iBgJiCmHiClPiCoHiCkKiLnPiCkCiCkJiBgKjIeBjBlBiClFiClNiCfBjFlGiOjKiCpAjClCiCnHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	long lCheckCountFromFirstHit = 0;
	// _xZkqqHx_jBePiJpBiCmMiDhBiDgCiDgHjFlGiOjKjCiGjAfDiCmGiDeOiDiKiDgCiDeOiImKjChFiCmMiLjHjHkDiBeC_xHqqkZx_
	mmetol mmMinDiffX = DBL_MAX;

	long lLine;
	long lChar;
	short nAfterSpace;
	const FCStatChar* pChar;
	// _xZkqqHx_jFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lIndex = 0;
	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine);
		 pChar != NULL && lCheckCountFromFirstHit != 2;
		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
	{
		switch (pChar->m_wChar)
		{
		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
			break;

		case FDRCH_FONT_AND_OFFSET:		// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHjAnNjCoIiBeC_xHqqkZx_
			foidCur = pChar->m_foidFont;
			// _xZkqqHx_iMlLiNnNiCmMiDeJiDhEiDfKiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
			wOffset = pChar->m_wOffset;
			mmTMAscent = g_pEnv->GetSFontRec(foidCur)->GetAngleAscent(m_dAngle, wOffset);
			mmTMDescent = g_pEnv->GetSFontRec(foidCur)->GetDescent(wOffset);
			break;

		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_AFTERSPACE:			// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			break;
		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
			byCrossStat = pChar->m_byCrossStat;
			break;

		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiBeC_xHqqkZx_
			break;

//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		case FDRCH_RETURN:	// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
//		case WCH_TAB:		// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
//		case WCH_SPC:		// _xZkqqHx_iLpDjEjCiBeC_xHqqkZx_
//			// _xZkqqHx_jFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiCpAiJmBiOfKiBeC_xHqqkZx_
//			lIndex++;
//			break;
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		default:
		  {
			// _xZkqqHx_iNkBiJpBiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			BOOL bIsHitThisTime = FALSE;
			if (byCrossStat != FDWR_CROSS_OUTSIDE && mmX <= m_mmrtText.right)
			//----- _xZkqqHx_jFlGiOjKiCkKiJeFjCfLiCpAiJhKiCkGiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoG_xHqqkZx_(_xZkqqHx_iJpBjDfNjBeP_xHqqkZx_)_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
				DBLRect mmrtChar(	mmX + pChar->m_mmfAbcA,
									mmBaseLine - mmTMAscent,
									mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC,
									mmBaseLine + mmTMDescent);
				const mmetol mmCenterX = (mmrtChar.left + mmrtChar.right) / 2.0;
				// _xZkqqHx_jFlGiOjKiCkKiKkOjBfDiCmJjAhNiMgAjDoAjBkEiCmIiCoHiCmOiBeBjHmMiIoGiCmJjFlGiOjKiMoDiKnEiKhFiCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
				if (byCrossStat == FDWR_CROSS_INSIDE)
				{
					const mmetol mmNewRight = mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace);
					if (mmrtChar.right < mmNewRight)
						mmrtChar.right = mmNewRight;
				}
				// _xZkqqHx_jFjNiBeBiNiCiClDiCpAiNeMiClAiCoJiBeCiDeOiDiKiDgCiDeOiCmJiDhBiDgCiDgHiClFiCoCiClHiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
				mmrtChar.Extend(mmptMargin.x, mmptMargin.y);
				if (mmrtChar.PtInRect(mmptRot))
				//----- _xZkqqHx_iDeOiDiKiDgCiDeOiImKjChFiCkKjFlGiOjKiLoJiMgAiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFlGiOjKjCiGjAfDiImKjChFiCmGiDeOiDiKiDgCiDeOiImKjChFiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
					const mmetol mmDiffX = fabs(mmCenterX - mmptRot.x);
					if (mmDiffX < mmMinDiffX)
					//----- _xZkqqHx_jBePiJpBiCmMiDhBiDgCiDgHiImKjChFiCoGiCoIiCoAiLnPiCkCiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_iNkBiJpBiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
						bIsHitThisTime = TRUE;
						// _xZkqqHx_jBePiJpBiCmMiDhBiDgCiDgHiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
						mmMinDiffX = mmDiffX;
						bIsHitFront = (mmptRot.x < mmCenterX);
						lHitIndex = lIndex;
					}
				}
			}
			// _xZkqqHx_jFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiCpAiJmBiOfKiBeC_xHqqkZx_
			lIndex++;

			if (lCheckCountFromFirstHit == 0)
			//----- _xZkqqHx_iCnMiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNmFiPiJiCmMiDhBiDgCiDgHiCmFiCkAiCoKiCmOiCfAiCpAjAnNjCoIiBeC_xHqqkZx_
				if (bIsHitThisTime)
					lCheckCountFromFirstHit = 1;
			} else
			//----- _xZkqqHx_iKpJiCmJiDhBiDgCiDgHiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNkBiJpBiDhBiDgCiDgHiClFiCmIiCkPiCoKiCmOiCfBiCpAjAnNjCoIiBeC_xHqqkZx_
				// _xZkqqHx_iCmCiCnMiCoIiBeBjIeBjBlBiClFiCmEiDhBiDgCiDgHiClFiCmEiCkCiCoKiCmOiCfAiCmMiCnMiCnMiBeC_xHqqkZx_
				if (!bIsHitThisTime)
					lCheckCountFromFirstHit = 2;
			}
			break;
		  }
		}
	}
	return (lCheckCountFromFirstHit != 0);
} // FCRichText::GetIntersect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::IsUsedSFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SFont _xZkqqHx_iCkKiOgHiCoNiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiOgHiCoNiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::IsUsedSFont (SFontID foid) const
{
	FCStatLineVector::iterator iL;
	FCStatCharVector::iterator iC;
	for (iL = m_vpLine->begin(); iL != m_vpLine->end(); iL++)
	{
		for (iC = (*iL).m_vStatChar.begin();
				iC != &(*iL).m_vStatChar.back(); iC++)
		{
			switch ((*iC).m_wChar)
			{
			case FDRCH_FONT_AND_OFFSET:	// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
				if (foid == (*iC).m_foidFont) return TRUE;
				break;
			}
		}
	}
	return FALSE;
} // FCRichText::IsUsedSFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::~FCRichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCRichText::~FCRichText ()
{
	delete m_vpLine;
} // FCRichText::~FCRichText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::OnStartToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeHiDgGiDeCiDgCiDgHiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ojpTarget	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptCaret:_xZkqqHx_iDeKiDiMiDgCiDgHiCpAiInKjDkOiClHiCoJiImKjChFiCpAiOhHjCoIiBeCiInKjDkOiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.02.01 Fukushiro M. _xZkqqHx_jFfHiPiAiMgAiOkOiCmMiOhHjCoIiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCRichText::OnStartToEditText (const FCObjFigure* ojpTarget,
									WORD wFixResizeByText,
									BOOL bIsShortenByText,
									BOOL bIsShowWindow,
									const DBLPoint* mmptCaret)
{
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	ExportAll(repEdit, ojpTarget);
	// _xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetFixResize(wFixResizeByText);
	repEdit->SetIsShortenByText(bIsShortenByText);

//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (mmptCaret != NULL)
	//----- _xZkqqHx_iDeKiDiMiDgCiDgHiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLRect mmrtEdit;
		repEdit->GetWindowRectMM(mmrtEdit);
		if (mmrtEdit.PtInRect(*mmptCaret))
		//----- _xZkqqHx_iDeKiDiMiDgCiDgHiOhHjCoIiImKjChFiCkKiDeFiDeCiDjDiDgIiDeFjDoAiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
			CPoint lgptCaret = mm2lg(*mmptCaret);
			g_pView->LPtoDP(lgptCaret);
			g_pView->ClientToScreen(&lgptCaret);
			repEdit->ScreenToClient(&lgptCaret);
			POINTS pnt = {lgptCaret.x, lgptCaret.y};
			//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
			LPARAM lParam = *((LPARAM*)&pnt);
			repEdit->SendMessage(WM_LBUTTONDOWN, 0, lParam);
			repEdit->SendMessage(WM_LBUTTONUP, 0, lParam);
		}
	}
//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (bIsShowWindow)
	//----- _xZkqqHx_iDeHiDgGiDeCiDfOiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjDpMjHmNiCpAiLjGiJmCiClHiCoJiBeC_xHqqkZx_
		repEdit->EnableWindow(TRUE);
		repEdit->ShowWindow(SW_SHOW);
		repEdit->SetFocus();
	}
} // FCRichText::OnStartToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::OnStopToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDeHiDgGiDeCiDgCiDgHiPpDjBnEiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiMiLiJmKiCmMiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			ojpTarget	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.02.01 Fukushiro M. _xZkqqHx_jFfHiPiAiMgAiOkOiCmMiOhHjCoIiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCRichText::OnStopToEditText (	BYTEVector& byvQueue,
									double& dRatioHorz,
									double& dRatioVert,
									const FCObjFigure* ojpTarget)
{
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	if (repEdit->IsWindowVisible())
	//----- _xZkqqHx_iDeHiDgGiDeCiDfOjFfMiOkGjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDgGiDeCiDfOiDeFiDeCiDjDiDgIiDeFiCpAiPmBiLiOiBeC_xHqqkZx_
		repEdit->ShowWindow(SW_HIDE);
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjDpMjHmNiCpAiLnGiOhOiClHiCoJiBeCiClLiCoKiCpAiClFiCmIiCkCiCmG_xHqqkZx_View_xZkqqHx_iCmJiDeMiBfLiCkKiNhDiCkJiCmIiCkCiBeC_xHqqkZx_
		repEdit->EnableWindow(FALSE);
		// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJiDhEiDeIiBfLiDeKiDfIiCpAjGnPiClHiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiOkJjDkO_xHqqkZx_ALT_xZkqqHx_iOjOiCmJiDeMiBfLjDpMjHmNiCkK_xHqqkZx_
		// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjGnPiCoHiCmIiCkCiBeC_xHqqkZx_
		FFGetMainWnd()->GetWnd()->SetFocus();
	}
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCkJiCoHiDgFiDeMiDfIiDgHiCpAiDeDiDjDiDhMiBfLiDgHiBeC_xHqqkZx_
	// CalcEnoughSizeRatio _xZkqqHx_iCmNiDiMiDeDiDeBiDeFiDgHiCpAjFmPiNfIiClHiCoJiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_iClLiCmMjBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);

	// _xZkqqHx_iOkJjDkOiDiKiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
	// GetResizeHorz_xZkqqHx_iBeB_xHqqkZx_GetResizeVert _xZkqqHx_iCmNiDeHiDgGiDeCiDfOiCkJiCoHiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
	if (repEdit->GetFixResize() != FD_RPT_NONE)
	//----- _xZkqqHx_jFjEjFgJiCmMiOkJjDkOiDiKiDfEiDeDiDfJiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOpLiCnMiCoJiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
		if (!repEdit->CalcEnoughSizeRatio(dRatioHorz, dRatioVert, ojpTarget))
		//----- _xZkqqHx_iKgHjBoFjHkGiCkKiOfKiPgPiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dRatioHorz = 1.0;
			dRatioVert = 1.0;
		}
	} else
	//----- _xZkqqHx_jFjEjFgJiCmMiOkJjDkOiDiKiDfEiDeDiDfJiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dRatioHorz = 1.0;
		dRatioVert = 1.0;
	}
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMiDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	repEdit->ClearMaskPolygon();
//----- 05.07.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjDpMjHmNiCpAiLnGiOhOiClHiCoJiBeCiClLiCoKiCpAiClFiCmIiCkCiCmG_xHqqkZx_View_xZkqqHx_iCmJiDeMiBfLiCkKiNhDiCkJiCmIiCkCiBeC_xHqqkZx_
//	repEdit->EnableWindow(FALSE);
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJiDhEiDeIiBfLiDeKiDfIiCpAjGnPiClHiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiOkJjDkO_xHqqkZx_ALT_xZkqqHx_iOjOiCmJiDeMiBfLjDpMjHmNiCkK_xHqqkZx_
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjGnPiCoHiCmIiCkCiBeC_xHqqkZx_
//	FFGetMainWnd()->GetWnd()->SetFocus();
//----- 05.07.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::OnStopToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ImportText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOoGiCoIiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	repEdit	: _xZkqqHx_iOoGiCoIiNjOiCnOiMlDiCmMiDeHiDgGiDeCiDfO_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::ImportText (const CFCWndRichEdit* repEdit)
{
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
//	ClearSelection(NULL);
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiClBiCmF_xHqqkZx_ ClearSelection _xZkqqHx_iCpAiMmEiCpBiCmFiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCmMjFjEjFkKiDgFiDeMiDfIiDgHjBeJjBpAjCiGiCmJiBeB_xHqqkZx_
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAiInKjDkOiClHiCoJiCmGiBeBiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCoJiClNiCnPiBeC_xHqqkZx_
	m_vpLine->clear();
	repEdit->GetText(*m_vpLine);
	// _xZkqqHx_iDhNiBfLiDfHiDjDiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetMargin(m_mmMarginL, m_mmMarginT, m_mmMarginR, m_mmMarginB);
	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	m_dwVertAlign = repEdit->GetVertAlignment();
} // FCRichText::ImportText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ExportText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	repEdit	: _xZkqqHx_jAnNjCoIjAoGiCmMiDeHiDgGiDeCiDfO_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::ExportText (CFCWndRichEdit* repEdit) const
{
	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	repEdit->SetVertAlignment(m_dwVertAlign);
	// _xZkqqHx_iDhNiBfLiDfHiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	repEdit->SetMargin(m_mmMarginL, m_mmMarginT, m_mmMarginR, m_mmMarginB);
	repEdit->SetText(*m_vpLine);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiNoNiPjMiBeCiDhNiBfLiDfHiDjDjAnNjCoIiCmFiDeMiDiFiBfLiCmJiDgGiBfLiDfOjChOjAmPiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	repEdit->ClearAllSession();
} // FCRichText::ExportText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCkKiLpDiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::IsEmpty () const
{
	return (m_vpLine->size() <= 1) && ((*m_vpLine)[0].m_vStatChar.size() <= 1);
} // FCRichText::IsEmpty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiJpBjDfNjBePiCmMjFgAiJoGjHmMiIoGiLoJiMgAiCpAjFnEiClHiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P301_xZkqqHx_iCmM_xHqqkZx_T3_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFgAiJoGjHmMiIoGiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DBLRect& FCRichText::GetTextRect () const
{
	return m_mmrtText;
} // FCRichText::GetTextRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetTextRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiJpBjDfNjBePiCmMjFgAiJoGjHmMiIoGiLoJiMgAiCpAjAnNjCoIiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P301_xZkqqHx_iCmM_xHqqkZx_T3_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtText	:_xZkqqHx_jFgAiJoGjHmMiIoGiLoJiMgAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetTextRect (const DBLRect& mmrtText)
{
	m_mmrtText = mmrtText;
} // FCRichText::SetTextRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetMarginL
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiNlGiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiNlGiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCRichText::GetMarginL () const
{
	return m_mmMarginL;
} // FCRichText::GetMarginL.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetMarginT
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiPoDiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiPoDiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCRichText::GetMarginT () const
{
	return m_mmMarginT;
} // FCRichText::GetMarginT.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetMarginR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJeFiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJeFiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCRichText::GetMarginR () const
{
	return m_mmMarginR;
} // FCRichText::GetMarginR.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetMarginB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJlKiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJlKiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCRichText::GetMarginB () const
{
	return m_mmMarginB;
} // FCRichText::GetMarginB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
angle FCRichText::GetAngle () const
{
	return m_dAngle;
} // FCRichText::GetAngle.

//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetResizeHorz
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_H_LEFT:
// *					_xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_RIGHT:
// *					_xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BYTE FCRichText::GetResizeHorz () const
//{
//	return m_byResizeHorz;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiFjFlNjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//} // FCRichText::GetResizeHorz.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetResizeVert
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_V_TOP:
// *					_xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_BOTTOM:
// *					_xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BYTE FCRichText::GetResizeVert () const
//{
//	return m_byResizeVert;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiCjClMjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//} // FCRichText::GetResizeVert.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetIsShortenByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiCoAiPgLiPkMiClHiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgLiPkMiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCRichText::GetIsShortenByText () const
//{
//	return m_bIsShortenByText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiPgLiPkMiBeI_xHqqkZx_
//} // FCRichText::GetIsShortenByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextLeftRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjCiGjAfDiCmFiKhAjDhIiCpAiCePiCmJjFoCjAlDiClFiClNiOjOiCmMiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJ_xHqqkZx_
 *			_xZkqqHx_jHmMiIoGiCmMiNlGjCfLiCmGiJeFjCfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmLeft	:_xZkqqHx_iNlGjCfLiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmRight	:_xZkqqHx_iJeFjCfLiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiCkKjBlGiNnNiClJiClIiBeBjCgMiCkKiOoGjDlOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::GetTextLeftRight (mmetol& mmLeft, mmetol& mmRight) const
{
	if (m_vpLine->empty()) return FALSE;
	mmetol	mmMostLeft = DBL_MAX;
	mmetol	mmMostRight = -DBL_MAX;
	mmetol	mmX;
	BYTE	byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
	long lLine;
	long lChar;
	short nAfterSpace;
	const FCStatChar* pChar;
	mmetol mmBaseLine;
	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
	{
		switch (pChar->m_wChar)
		{
		case FDRCH_RETURN:				// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_CONTINUE:			// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_FONT_AND_OFFSET:		// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_AFTERSPACE:			// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			break;
		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
			byCrossStat = pChar->m_byCrossStat;
			break;

		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
			break;

		case WCH_TAB:	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
		case WCH_SPC:	// _xZkqqHx_iLpDjEjC_xHqqkZx_.
			break;

		default:
			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCpAjClCiCnHiCoJiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
			if (byCrossStat == FDWR_CROSS_OUTSIDE || m_mmrtText.right < mmX)
			{
				mmMostRight = GetTextRect().right - GetMarginR();
				break;
			}
			if (mmX + pChar->m_mmfAbcA < mmMostLeft)
				mmMostLeft = mmX + pChar->m_mmfAbcA;
			if (mmMostRight < mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC)
				mmMostRight = mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC;
			break;
		}
	}
	if (mmMostLeft == DBL_MAX || mmMostRight == -DBL_MAX) return FALSE;
	mmLeft = mmMostLeft;
	mmRight = mmMostRight;
	return TRUE;
} // FCRichText::GetTextLeftRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextTopBottom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjCiGjAfDiCmFiKhAjDhIiCpAiCePiCmJjFoCjAlDiClFiClNiOjOiCmMiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJ_xHqqkZx_
 *			_xZkqqHx_jHmMiIoGiCmMiPoDjCfLiCmGiJlKjCfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmTop	:_xZkqqHx_iPoDjCfLiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmBottom:_xZkqqHx_iJlKjCfLiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiCkKjBlGiNnNiClJiClIiBeBjCgMiCkKiOoGjDlOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::GetTextTopBottom (mmetol& mmTop, mmetol& mmBottom) const
{
	if (m_vpLine->empty()) return FALSE;
	mmTop = m_vpLine->front().m_mmY;
	mmBottom = m_vpLine->back().m_mmY +
				m_vpLine->back().m_mmfTMHeight +
				m_vpLine->back().m_mmfTMExternalLeading;
	return TRUE;
} // FCRichText::GetTextTopBottom.

//----- 05.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextTop
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjCiGjAfDiCmFiKhAjDhIiCpAiCePiCmJjFoCjAlDiClFiClNiOjOiCmMiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJ_xHqqkZx_
// *			_xZkqqHx_jHmMiIoGiCmMiPoDjCfLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDjCfLiNmAjFfHiBeCiDgFiDeMiDfIiDgHiNhDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DBL_MAX_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//mmetol FCRichText::GetTextTop () const
//{
//	if (m_vpLine->empty()) return DBL_MAX;
//	return m_vpLine->front().m_mmY;
//} // FCRichText::GetTextTop.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextBottom
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjCiGjAfDiCmFiKhAjDhIiCpAiCePiCmJjFoCjAlDiClFiClNiOjOiCmMiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJ_xHqqkZx_
// *			_xZkqqHx_jHmMiIoGiCmMiJlKjCfLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlKjCfLiNmAjFfHiBeCiDgFiDeMiDfIiDgHiNhDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DBL_MAX_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//mmetol FCRichText::GetTextBottom () const
//{
//	if (m_vpLine->empty()) return DBL_MAX;
//	return m_vpLine->back().m_mmY +
//			m_vpLine->back().m_mmfTMHeight +
//			m_vpLine->back().m_mmfTMExternalLeading;
//} // FCRichText::GetTextBottom.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextRight
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjCiGjAfDiCmFiKhAjDhIiCpAiCePiCmJjFoCjAlDiClFiClNiOjOiCmMiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJ_xHqqkZx_
// *			_xZkqqHx_jHmMiIoGiCmMiJeFjCfLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJeFjCfLiNmAjFfHiBeCiDgFiDeMiDfIiDgHiNhDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DBL_MAX_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//mmetol FCRichText::GetTextRight () const
//{
//	if (m_vpLine->empty()) return DBL_MAX;
//	mmetol	mmMostRight = -DBL_MAX;
//	mmetol	mmX;
//	BYTE	byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
//	long lLine;
//	long lChar;
//	short nAfterSpace;
//	const FCStatChar* pChar;
//	mmetol mmBaseLine;
//	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
//		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
//	{
//		switch (pChar->m_wChar)
//		{
//		case FDRCH_RETURN:				// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
//		case FDRCH_CONTINUE:			// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
//		case FDRCH_FONT_AND_OFFSET:		// FONT_xZkqqHx_iBeB_xHqqkZx_Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//		case FDRCH_AFTERSPACE:			// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			break;
//		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
//			byCrossStat = pChar->m_byCrossStat;
//			break;
//
//		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
//			break;
//
//		case WCH_TAB:	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
//		case WCH_SPC:	// _xZkqqHx_iLpDjEjC_xHqqkZx_.
//			break;
//
//		default:
//			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCpAjClCiCnHiCoJiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
//			if (byCrossStat == FDWR_CROSS_OUTSIDE || m_mmrtText.right < mmX)
//			{
//				mmMostRight = GetTextRect().right - GetMarginR();
//				break;
//			}
//			if (mmMostRight < mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC)
//				mmMostRight = mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC;
//			break;
//		}
//	}
//	return mmMostRight;
//} // FCRichText::GetTextRight.
//----- 05.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetMarginL
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiNlGiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginL	:_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiNlGiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetMarginL (mmetol mmMarginL)
{
	m_mmMarginL = mmMarginL;
} // FCRichText::SetMarginL.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetMarginT
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiPoDiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginT	:_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiPoDiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetMarginT (mmetol mmMarginT)
{
	m_mmMarginT = mmMarginT;
} // FCRichText::SetMarginT.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetMarginR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJeFiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginR	:_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJeFiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetMarginR (mmetol mmMarginR)
{
	m_mmMarginR = mmMarginR;
} // FCRichText::SetMarginR.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetMarginB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJlKiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginB	:_xZkqqHx_iDhNiBfLiDfHiDjDiBgJiJlKiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetMarginB (mmetol mmMarginB)
{
	m_mmMarginB = mmMarginB;
} // FCRichText::SetMarginB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dAngle	:_xZkqqHx_iKhAjDhIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetAngle (angle dAngle)
{
	m_dAngle = dAngle;
} // FCRichText::SetAngle.

//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetResizeHorz
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byResizeHorz:
// *			FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_H_LEFT:
// *					_xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_RIGHT:
// *					_xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::SetResizeHorz (BYTE byResizeHorz)
//{
//	m_byResizeHorz = byResizeHorz;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiFjFlNjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//} // FCRichText::SetResizeHorz.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetResizeVert
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byResizeVert:
// *			FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_V_TOP:
// *					_xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_BOTTOM:
// *					_xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::SetResizeVert (BYTE byResizeVert)
//{
//	m_byResizeVert = byResizeVert;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiCjClMjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
//} // FCRichText::SetResizeVert.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetIsShortenByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiCoAiPgLiPkMiClHiCoJiCkJiCmHiCkEiCkJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsShortenByText:	_xZkqqHx_iPgLiPkMiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::SetIsShortenByText (BOOL bIsShortenByText)
//{
//	m_bIsShortenByText = bIsShortenByText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiPgLiPkMiBeI_xHqqkZx_
//} // FCRichText::SetIsShortenByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::Redo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiMlDiCmJiBeB_xHqqkZx_Redo_xZkqqHx_iCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj		:_xZkqqHx_iClBiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiCpAiPiKjHeMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lQueueSz	:_xZkqqHx_iDeMiDiFiBfLiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypQueue	:_xZkqqHx_iDeMiDiFiBfLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::Redo (const FCObjFigure* pObj, long lQueueSz, const BYTE* bypQueue)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, pObj);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmJiDeMiDiFiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetCmdQueue(lQueueSz, bypQueue, 0);
	// _xZkqqHx_iDeMiDiFiBfLiNmFiMoDiCnMiCmF_xHqqkZx_ Redo _xZkqqHx_iClHiCoJiBeC_xHqqkZx_CalcLine _xZkqqHx_iCoAjDoAjFjEiCmFiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
	repEdit->RedoUntilBottom();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	repEdit->ClearAll();
} // FCRichText::Redo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::Undo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiMlDiCmJiBeB_xHqqkZx_Undo_xZkqqHx_iCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj		:_xZkqqHx_iClBiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiCpAiPiKjHeMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lQueueSz	:_xZkqqHx_iDeMiDiFiBfLiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypQueue	:_xZkqqHx_iDeMiDiFiBfLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::Undo (const FCObjFigure* pObj, long lQueueSz, const BYTE* bypQueue)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, pObj);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmJiDeMiDiFiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetCmdQueue(lQueueSz, bypQueue, lQueueSz);
	// _xZkqqHx_iDeMiDiFiBfLiNmFiPiJiCnMiCmF_xHqqkZx_ Undo _xZkqqHx_iClHiCoJiBeC_xHqqkZx_CalcLine _xZkqqHx_iCoAjDoAjFjEiCmFiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
	repEdit->UndoUntilTop();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	repEdit->ClearAll();
} // FCRichText::Undo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetTextData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiLeMjIfOiClFiCmEiCkCiCoJiDgGiBfLiDfOjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iNhDiCmMjEhKjHpBiDgGiBfLiDfOiCpAjFnEiClHiBeCiNhDiCmJiCmNiBeBjFlGiOjKiCmMjEhKjHpBiDgGiBfLiDfOiCkKjDpMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCStatLineVector& FCRichText::GetTextData ()
{
	return *m_vpLine;
} // FCRichText::GetTextData.

//----- 00.09.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::CanBeMaskObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDfIiDeOjFjEjFgJiCmGiClFiCmEiOgHiCkGiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMask	:_xZkqqHx_jClCiCnHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgHiCkGiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOgHiCkGiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			99.10.24 Fukushiro M. _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiCkKiKpJiCmJjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
// *								_xZkqqHx_iCmMiDgAiDeGiDgCiDeOiCmNiPmIiCkNiBeCiJjOjHhAjEmNiImNiCpAiNeMiClAiCoJiClNiCnPiBeC_xHqqkZx_
// *************************************************************************/
//BOOL FCRichText::CanBeMaskObject (const FCObjDynabase* pMask)
//{
//	// _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
//	if (!pMask->IsKindOf(FDOJ_FIGURE)) return FALSE;
//	// _xZkqqHx_jFmCiClGiClNjAhNiMgAiCmFiCmIiCkCiPoKiNiHiCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
//	if (pMask->GetIsOpenPolygon()) return FALSE;
//	return TRUE;
//} // FCRichText::CanBeMaskObject.
//----- 00.09.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTxt	:_xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::Copy (FCRichText* pTxt) const
{
	pTxt->m_vpLine->clear();
	memcpy(&pTxt->m_mmMarginL, &m_mmMarginL, offsetof(FCRichText, m_vpLine) -
										offsetof(FCRichText, m_mmMarginL));
	*pTxt->m_vpLine = *m_vpLine;
} // FCRichText::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::DrawText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:CDC*
 *			bIsMono	:TRUE	:_xZkqqHx_iDiCiDgNiDeOiDiN_xHqqkZx_
 *					 FALSE	:_xZkqqHx_iDeKiDiJiBfL_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiDgNiDeOiDiNiCmMiOjOiCmNiBeBjHfMiCnP_xHqqkZx_ pDC _xZkqqHx_iCmJ_xHqqkZx_SetTextColor_xZkqqHx_iKnGjAjEiCmFjAnNjCoIiClDiCoKiCmEiCkCiClN_xHqqkZx_
 *			_xZkqqHx_jAeGiCmFiDgFiDeMiDfIiDgHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::DrawText (CDC* pDC, SColorID scidSpec)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjFfMiOkGiClDiCoKiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_HP DeskJet970Cxi(Win98)_xZkqqHx_iCmF_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjFfMiOkGiClDiCoKiCmIiCkCjFjEjFgJiCmMiIpDiNpMiCmFiDeHiDiJiBfLiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_vpLine->empty()) return;
	if (m_mmrtText.Height() - m_mmMarginB <
			m_vpLine->front().m_mmY + m_vpLine->front().m_mmfTMHeight +
			m_vpLine->front().m_mmfTMExternalLeading) return;

	const DBLPoint mmptCenter = m_mmrtText.CenterPoint();

	mmetol	mmX;
	mmetol	mmBaseLine;

	// _xZkqqHx_iPiJiKpKiJlLiClFiCmIiCkCiCmGiBeB_xHqqkZx_Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	LOGFONT	logfont = { 0 };
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
	LOGFONT logfont;
	memset(&logfont, 0, sizeof(logfont));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
	WORD	wCodePage = CP_ACP;
	// _xZkqqHx_iDgFiDeMiDfIiDgHiIpDiNpMjHhAiDeOiDiJiDfIiBeC_xHqqkZx_
	FCTextOut textOut(m_dAngle, mmptCenter);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC);
	atDC.SetBkMode(TRANSPARENT);
	// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMjHhAiDhJiDjDiCmMjAnNjCoIiBeCiCmGiCoIiCkAiCkGiClIiDiCiDgNiDeOiDiNiCmFiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 1, FD_COLREF_BLACK);
	// _xZkqqHx_jFgAiJoGjAeGiCmJiOhHjCoIiCkKiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
	if (scidSpec != FD_S_COLOR_UNSPECIFY)
		atDC.SetTextColor(::OptiColor(g_pEnv->scid2cref(scidSpec)));

	mmetol		mmTMAscent;		// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	mmetol		mmTMDescent;	// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	SFontID		foidCur = FD_S_FONT_UNSPECIFY;	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	COLORREF	crefCur = FD_COLOR_REF_UNSPECIFY;	// S_xZkqqHx_jAeG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD		wOffset = WORD(-1);	// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	BYTE		byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
	short		nAfterSpace = short(MINSHORT);
	BYTE		byUnderline = BYTE(-1);
	BYTE		byStrikeOut = BYTE(-1);

	double	dCos = 1.0;
	double	dSin = 0.0;
	if (!almost0(m_dAngle))
	{
		dCos = cos(m_dAngle * M_PI);
		dSin = sin(m_dAngle * M_PI);
	}

	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiPfHiNiH_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfH_xHqqkZx_.
	DBLRect		mmrctChar;		// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	DBLPoint	mmptaChar[5];	// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_

	long	lLine;
	long	lChar;
	const FCStatChar* pChar;
	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
	{
		switch (pChar->m_wChar)
		{
		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
			// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//			textOut.FlushText(atDC, mmX);
			textOut.FlushText(atDC, mmX, wCodePage);
			break;

		case FDRCH_FONT_AND_OFFSET:		// FONT,Offset_xZkqqHx_jAnNjCoI_xHqqkZx_.
			// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//			textOut.FlushText(atDC, mmX);
			textOut.FlushText(atDC, mmX, wCodePage);
			// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHjAnNjCoIiBeC_xHqqkZx_
			foidCur = pChar->m_foidFont;
			// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
			wOffset = pChar->m_wOffset;
			// LOGFONT_xZkqqHx_iCpAiMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
			g_pEnv->GetSFontRec(foidCur)->ReqInit(logfont, m_dAngle, wOffset);
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
			wCodePage = CharSetToCodePage(logfont.lfCharSet);
			atDC.SetFont(&logfont);			// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
			mmTMAscent = g_pEnv->GetSFontRec(foidCur)->GetAngleAscent(m_dAngle, wOffset);
			mmTMDescent = g_pEnv->GetSFontRec(foidCur)->GetDescent(wOffset);
			break;

		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoI_xHqqkZx_.
			// _xZkqqHx_iMlLiNnNiCmMjFlGiOjKjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			crefCur = pChar->m_crColor;
			if (scidSpec == FD_S_COLOR_UNSPECIFY)
			//----- _xZkqqHx_jFgAiJoGjAeGiCmJiOhHjCoIiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//				textOut.FlushText(atDC, mmX);
				textOut.FlushText(atDC, mmX, wCodePage);
// 01.02.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				atDC.SetTextColor(::OptiColor(g_pEnv->scid2cref(crefCur)));
				atDC.SetTextColor(::OptiColor(crefCur));
			}
			break;

		case FDRCH_AFTERSPACE:		// AfterSpace_xZkqqHx_jAnNjCoI_xHqqkZx_.
			break;

		case FDRCH_LINES_AND_CROSSSTAT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//			textOut.FlushText(atDC, mmX);
			textOut.FlushText(atDC, mmX, wCodePage);
			byUnderline = pChar->m_byUnderline;
			byStrikeOut = pChar->m_byStrikeOut;
			byCrossStat = pChar->m_byCrossStat;
			break;

		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
			break;

		case WCH_TAB:	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
			// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//			textOut.FlushText(atDC, mmX);
			textOut.FlushText(atDC, mmX, wCodePage);
			break;

		default:	// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
			if (byCrossStat == FDWR_CROSS_OUTSIDE || m_mmrtText.right < mmX)
			{
				// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//				textOut.FlushText(atDC, mmX);
				textOut.FlushText(atDC, mmX, wCodePage);
				break;
			}
			//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoGiBgJiLoJiMgAiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
			mmptaChar[0].SetPoint(mmX + pChar->m_mmfAbcA, mmBaseLine - mmTMAscent);
			mmptaChar[1].SetPoint(mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC, mmBaseLine - mmTMAscent);
			mmptaChar[2].SetPoint(mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC, mmBaseLine + mmTMDescent);
			mmptaChar[3].SetPoint(mmX + pChar->m_mmfAbcA, mmBaseLine + mmTMDescent);
			//----- _xZkqqHx_jFlGiOjKiCmMjFgAiJoGiKeKiOgOiNmAjFfHiBgJiNlGiPoDiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
			mmptaChar[4].SetPoint(mmX, mmBaseLine - mmTMAscent);
			// _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJpBjDfNiPiIjHjNiBeCjFgAiJoGiKeKiOgOiNmAjFfHiCoAiCmCiCkCiCmFiCmJiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
			if (!almost0(m_dAngle))
				::RotateConv(mmptaChar, 5, dSin, dCos, mmptCenter.x, mmptCenter.y);
			// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
			::FFCalcFrame(mmrctChar, 4L, mmptaChar);

			// _xZkqqHx_iCfAjFlGiOjKiCpAjChOjAmPiBeC_xHqqkZx_
			mmetol mmY = mmBaseLine - mmTMAscent;
			mmetol mmLeft = mmX + pChar->m_mmfAbcA;
			mmetol mmRight = mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC;
			textOut.StockChar(pChar->m_wChar, mmX, mmLeft, mmRight, mmY, 
								mmTMAscent + mmTMDescent, byUnderline, byStrikeOut,
								foidCur, wOffset);
			// _xZkqqHx_jAhNiMgAjApMiPoDiCmJjFlGiOjKiCkKiPoGiCmBiCmEiCkCiCoJiPoKiNiHiCmNjChOjAmPiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
//----- 02.08.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
//			if (byCrossStat == FDWR_CROSS_ONLINE)
//				textOut.FlushText(atDC, mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC);
//----- 02.08.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
			if (byCrossStat == FDWR_CROSS_ONLINE)
				textOut.FlushText(atDC, mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC,
									wCodePage);
//----- 02.08.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
		  }
		}
	}
	// _xZkqqHx_jChOjAmPiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiIpDiNpMiBeC_xHqqkZx_
// 02.08.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//	textOut.FlushText(atDC, mmX);
	textOut.FlushText(atDC, mmX, wCodePage);

//----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiCiDgKiDfOiBfLjFgAiJoGiBeBjEmNiImNjBeJjBpAiCkKiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
//	if (g_->eDrawWhich == FDDR_DISPLAY && !m_vSelectRange.empty())
//	{
//		FCEditDraw eDraw(pDC, 0L);
//		longRangeVector::const_iterator iSr = m_vSelectRange.begin();
//		long lIndex = 0;
//		for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
//			 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
//		{
//			if ((*iSr).lTo <= lIndex) iSr++;
//			if (iSr == m_vSelectRange.end()) break;
//
//			switch (pChar->m_wChar)
//			{
//			case FDRCH_CONTINUE:				// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
//			case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_PRESPACE:				// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiOhHjCoIiBeC_xHqqkZx_
//			case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
//				break;
//
//			case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
//			case WCH_TAB:			// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
//				lIndex++;
//				break;
//
//			default:				// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
//				// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
//				if (m_mmrtText.right < mmX + pChar->m_mmfWidth)
//				{
//					lIndex++;
//					break;
//				}
//				if ((*iSr).lFrom <= lIndex && lIndex < (*iSr).lTo)
//				{
//					//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoGiBgJiLoJiMgAiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//					mmptaChar[0].SetPoint(mmX,
//										mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
//					mmptaChar[1].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
//										mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
//					mmptaChar[2].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
//										mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
//													(*m_vpLine)[lLine].m_mmfTMHeight);
//					mmptaChar[3].SetPoint(mmX,
//										mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
//													(*m_vpLine)[lLine].m_mmfTMHeight);
//					// _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJpBjDfNiPiIjHjNiBeCjFgAiJoGiKeKiOgOiNmAjFfHiCoAiCmCiCkCiCmFiCmJiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
//					if (!almost0(m_dAngle))
//						::RotateConv(mmptaChar, 4, dSin, dCos, mmptCenter.x, mmptCenter.y);
//					// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//					::FFCalcFrame(mmrctChar, 4L, mmptaChar);
//
//					if (g_pView->IsRgnOverlap(mmrctChar))
//					//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//					{
//						CPoint lgptaChar[4];
//						mm2lg(lgptaChar, mmptaChar, 4);
//						eDraw.Polygon(lgptaChar, 4);
//					}
//				}
//				lIndex++;
//			}
//		}
//	}
//----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiCiDgKiDfOiBfLjFgAiJoGiBeBjEmNiImNjBeJjBpAiCkKiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
//	if (g_->eDrawWhich == FDDR_DISPLAY)
//		DrawSelection(pDC);
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCRichText::DrawText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::CalcTextLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P301
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::CalcTextLayout (CFCWndRichEdit* repEdit, const FCObjDynabase* pFig)
{
	// mmptaPoly_xZkqqHx_iCpAiDfCiDhDiBfLiBeC_xHqqkZx_A1_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	DBLPointVector vmmptA;
	const DBLPoint mmptCenter = pFig->GetResizeFrame().CenterPoint();
	GetMaskPolygon(vmmptA, pFig, mmptCenter);
	// A1_xZkqqHx_iCpA_xHqqkZx_Fc_xZkqqHx_iCpAjCiGjAfDiCmJiLhEiJpBjDfNiBeC_xHqqkZx_A2_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	if (!almost0(m_dAngle))
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_T2_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		::FFCalcFrame(m_mmrtText, vmmptA.size(), vmmptA.begin());
		// m_mmrtText.CenterPoint()_xZkqqHx_iCpAiBeB_xHqqkZx_Fc_xZkqqHx_iCpAjCiGjAfDiCmJiPiHiJpBjDfNiBeC_xHqqkZx_T1c_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptT1c = m_mmrtText.CenterPoint();
		::RotateConv(mmptT1c, sin(m_dAngle * M_PI),
					cos(m_dAngle * M_PI), mmptCenter.x, mmptCenter.y);
		// m_mmrtText.CenterPoint()_xZkqqHx_iCpAiInKjDkOiClFiBeB_xHqqkZx_T3_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		m_mmrtText += mmptT1c - m_mmrtText.CenterPoint();
	} else
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_T2_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		::FFCalcFrame(m_mmrtText, vmmptA.size(), vmmptA.begin());
	}

	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_vpLine == NULL || m_vpLine->size() == 0) return;

	if (repEdit == NULL)
		repEdit = g_pView->GetRTFEditor();
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmJiDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAjAnNjCoIiBeCiClBiCmMiOjOiDeHiDgGiDeCiDfOiCmNiDhNiDfIiDeOiCmJiNiHiCoNiClJiCmEiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
	repEdit->SetMaskPolygon(vmmptA.begin(), vmmptA.size(), DBLPoint(0, 0));
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmJiDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiMhGiOfKiCpAiImLjHiK_xHqqkZx_ -----
	ExportText(repEdit);
//----- 06.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFlGiOjKjFjNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBgJiNmFiPiJiCmMjFlGiOjKiCmM_xHqqkZx_m_mmfAbcA _xZkqqHx_iCkK_xHqqkZx_
	// -10000.0_xZkqqHx_iCoGiCoIiPkMiClDiCkCiPoKiNiHiBgKiCmNiBeBjBfDiCmEiCmMjFlGiOjKiCmMjFjNiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDfCiDjDiDgPiBfLiDfOiCpAjCmKiClFiCmEjDmHiCnNiNjOiCnMiCoKiClNjFlGiPjBiDhEiDeAiDeDiDiLiCmJiCmNiBeB_xHqqkZx_
	// _xZkqqHx_jFlGiOjKjFjNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
	if (repEdit->GetChar(0).m_mmfAbcA < -10000.0)
		repEdit->CalcCharWidthAll();
//----- 06.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	repEdit->CalcLineAll();
	ImportText(repEdit);
	repEdit->ClearAll();
} // FCRichText::CalcTextLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetCharInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiCmMjBfDiDgFiDeMiDfIiDgHiLkEjCmKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciAnsi	:_xZkqqHx_iKpJjBlG_xHqqkZx_Ansi_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeCiLkEjCmKiDhEiDeIiBfLiDhNiDgCiDgHiCkKjFnEiCoJiBeC_xHqqkZx_
 *			fciSjis	:_xZkqqHx_iKpJjBlG_xHqqkZx_Sjis_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeCiLkEjCmKiDhEiDeIiBfLiDhNiDgCiDgHiCkKjFnEiCoJiBeC_xHqqkZx_
 *			bInit	:fciAnsi_xZkqqHx_iCpAiPiJiKpKiJlLiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeB_xHqqkZx_fciAnsi_xZkqqHx_iCmMjCgMiCmGiPgEiCmLiNiHiCoNiClJiCoJ_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiDgFiDeMiDfIiDgHjFjEjFgJiCmFiLkEjCmKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiClHiCoJiCmJiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmMjFjEjFgJiCmF_xHqqkZx_fciAnsi_xZkqqHx_iCpAiPiJiKpKiJlLiClFiBeBiMoDiCmMjFjEjFgJiCmFiCmNiPiJiKpKiJlLiClJiClIiPgEiCmLiNiHiCoNiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.01.30 Fukushiro M. CHARFORMAT_xZkqqHx_iCpA_xHqqkZx_FCFontCharInfo_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCRichText::GetCharInfo (	FCFontCharInfo& fciAnsi,
								FCFontCharInfo& fciSjis, BOOL bInit) const
{
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeHiDgGiDeCiDfOiCmJiDfCiDhDiBfLiBeC_xHqqkZx_
	ExportText(repEdit);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
// 00.07.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	repEdit->SelectAll();
	repEdit->SelectExAll();
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCkJiCoHiDhEiDeIiBfLiDhNiDgCiDgHiOoGjDlOiBeC_xHqqkZx_
	repEdit->GetCurCharInfo(fciAnsi, fciSjis, bInit);
	repEdit->ClearAll();
} // FCRichText::GetCharInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetCharInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiCmJiDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiMiLiJmKiCmMiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			fciAnsi		:Ansi_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fciSjis		:Sjis_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ojpFig		:_xZkqqHx_iClBiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiCpAiPiKjHeMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.02.01 Fukushiro M. _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *			01.01.30 Fukushiro M. CHARFORMAT_xZkqqHx_iCpA_xHqqkZx_FCFontCharInfo_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCRichText::SetCharInfo (	BYTEVector& byvQueue,
								const FCFontCharInfo& fciAnsi,
								const FCFontCharInfo& fciSjis,
								const FCObjFigure* ojpFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
	repEdit->SelectExAll();
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmJiDhEiDeIiBfLiDhNiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetCurCharInfo(fciAnsi, fciSjis);
	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
	repEdit->CalcLineAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::SetCharInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetLineInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiDgFiDeMiDfIiDgHiLkEjCmKiCmMiNhDiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tli		:_xZkqqHx_iNhDiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			bInit	:tli_xZkqqHx_iCpAiPiJiKpKiJlLiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeB_xHqqkZx_tli _xZkqqHx_iCmMjCgMiCmGiPgEiCmLiNiHiCoNiClJiCoJiPoKiNiHiCmN_xHqqkZx_
 *					 FALSE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::GetLineInfo (	FCTextLineInfo& tli,
								BOOL bInit) const
{
	if (bInit)
	{
		// _xZkqqHx_jGkCiOgHjHhAiCmMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		tli.dwMask = FDTL_FLAG_UNUSED;
	}
	FCStatLineVector::iterator iLin;
	for (iLin = m_vpLine->begin(); iLin != m_vpLine->end(); iLin++)
	{
		FCTextLineInfo tliCurrent;
		(*iLin).GetFormat(tliCurrent);
		tli &= tliCurrent;
	}
} // FCRichText::GetLineInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetLineInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiDgFiDeMiDfIiDgHiLkEjCmKiCmMiNhDiDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiMiLiJmKiCmMiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			tli			:_xZkqqHx_iNhDiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ojpFig		:_xZkqqHx_iClBiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiCpAiPiKjHeMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetLineInfo (	BYTEVector& byvQueue,
								const FCTextLineInfo& tli,
								const FCObjFigure* ojpFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
	repEdit->SelectExAll();
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmJiDhEiDeIiBfLiDhNiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetCurLineInfo(tli);
	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
	repEdit->CalcLineAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::SetLineInfo.

//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetAlignment
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiImKjChFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//int FCRichText::GetAlignment () const
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjGlDiCkCiPoKiNiHiCmNiKpBiClJjGlDiClFiCpAjFnEiClHiBeC_xHqqkZx_
//	if (m_vpLine->empty()) return FDRC_AL_NONE;
//	FCStatLineVector::iterator iLin = m_vpLine->begin();
//	int iAlign = iLin->m_byAlignment;
//	for (; iLin != m_vpLine->end(); iLin++)
//		if (iAlign != iLin->m_byAlignment) return FDRC_AL_NONE;
//	return iAlign;
//} // FCRichText::GetAlignment,
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetAlignment
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiKpBiClJiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
// *			iAlign		:_xZkqqHx_iKpBiClJiImKjChFiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			ojpFig		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::SetAlignment (BYTEVector& byvQueue, int iAlign, const FCObjFigure* ojpFig)
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
//	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
//	ExportAll(repEdit, ojpFig);
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
//	repEdit->SelectExAll();
//	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmJiDhEiDeIiBfLiDhNiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	repEdit->SetAlignment(iAlign);
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FCTextLineInfo tli;
//	tli.dwMask = FDTL_FLAG_ALIGNMENT;
//	tli.byAlignment = BYTE(iAlign);
//	repEdit->SetCurLineInfo(tli);
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
//	repEdit->CalcLineAll();
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	ImportText(repEdit);
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//	repEdit->GetCmdQueue(byvQueue);
//	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
//	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
//	repEdit->ClearAll();
//} // FCRichText::SetAlignment.
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetVertAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCRichText::GetVertAlignment () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjGlDiCkCiPoKiNiHiCmNiKpBiClJjGlDiClFiCpAjFnEiClHiBeC_xHqqkZx_
	if (m_vpLine->empty()) return FDRC_AL_NONE;
	return m_dwVertAlign;
} // FCRichText::GetVertAlignment,

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetVertAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiKpBiClJiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			iAlign		:_xZkqqHx_iKpBiClJiImKjChFiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			ojpFig		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::SetVertAlignment (BYTEVector& byvQueue, int iAlign, const FCObjFigure* ojpFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmJiDhEiDeIiBfLiDhNiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetVertAlignment(iAlign);
	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
	repEdit->CalcLineAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::SetVertAlignment.

//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetLineAfter
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNhDiKnEiBgJiNhDiJlKiBgKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNhDiKnEiBgJiNhDiJlKiBgKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCRichText::GetLineAfter (short& nLineAfter) const
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjGlDiCkCiPoKiNiHiCmNiLkEjCmKiNhDiKnEjGlDiClFiCpAjFnEiClHiBeC_xHqqkZx_
//	if (m_vpLine->empty()) return FALSE;
//	FCStatLineVector::iterator iLin = m_vpLine->begin();
//	short nLF = iLin->m_nTwipLineAfter;
//	for (; iLin != m_vpLine->end(); iLin++)
//		if (nLF != iLin->m_nTwipLineAfter) return FALSE;
//	nLineAfter = nLF;
//	return TRUE;
//} // FCRichText::GetLineAfter,
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::SetLineAfter
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiNhDiKnEiBgJiNhDiJlKiBgKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
// *			nLineAfter	:_xZkqqHx_iNhDiKnEiBgJiNhDiJlKiBgKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
// *			ojpFig		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::SetLineAfter (BYTEVector& byvQueue, short nLineAfter, const FCObjFigure* ojpFig)
//{
////----- 00.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	DBLPointVector vmmptPoly;
////	GetMaskPolygon(vmmptPoly, ojpFig);
////	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
////	repEdit->MoveWindow(m_mmrtText);
////	repEdit->SetMaskPolygon(vmmptPoly.begin(), vmmptPoly.size());
////	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmJiDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiMhGiOfKiCpAiImLjHiK_xHqqkZx_ -----
////	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeHiDgGiDeCiDfOiCmJjAnNjCoIiBeC_xHqqkZx_
////	ExportText(repEdit);
////----- 00.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
//	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
//	ExportAll(repEdit, ojpFig);
////----- 00.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
//	repEdit->SelectExAll();
//	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmJiDhEiDeIiBfLiDhNiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	repEdit->SetLineAfter(nLineAfter);
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FCTextLineInfo tli;
//	tli.dwMask = FDTL_FLAG_LINEAFTER;
//	tli.nTwipLineAfter = nLineAfter;
//	repEdit->SetCurLineInfo(tli);
////----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
//	repEdit->CalcLineAll();
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	ImportText(repEdit);
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//	repEdit->GetCmdQueue(byvQueue);
//	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
//	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
//	repEdit->ClearAll();
//} // FCRichText::SetLineAfter.
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::InflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiCmMiKgFiDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiCpAiIoKjCgJjBoFiCkLiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			ojpFig		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::InflateFontSize (BYTEVector& byvQueue, const FCObjFigure* ojpFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
	repEdit->SelectExAll();
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmMiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
	repEdit->InflateFontSize();
	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
	repEdit->CalcLineAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::InflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::DeflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiCmMiKgFiDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiCpAiIoKjCgJiPkMiClDiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvQueue	:_xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *			ojpFig		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::DeflateFontSize (BYTEVector& byvQueue, const FCObjFigure* ojpFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFlGiOjKiCpAjBfDiCmEjBeJjBpAiBeCjFlGiOjKjHpBiCkKiLpDiCmFiCoAiCgOiCgKiBeC_xHqqkZx_
	repEdit->SelectExAll();
	// _xZkqqHx_jBeJjBpAjCiGjFlGiOjKjHpBiCmMiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
	repEdit->DeflateFontSize();
	// _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
	repEdit->CalcLineAll();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::DeflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::CalcTextFitSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOpLiCnMiCoJiDfEiDeDiDfJiCnGiCmMiBeBiMlLiNnNiCmMiDfEiDeDiDfJiCkJiCoHiCmMjEoEjHkGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKiDgFiDeMiDfIiDgHiCpAiOpLiCnPiCoJiCmMiCmJiPfMjFkKjBoFiCkLiCkPiCoKiCmOiBeBjEoEjHkG_xHqqkZx_ = 1_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::CalcTextFitSize (	double& dRatioHorz,
									double& dRatioVert,
									const FCObjFigure* ojpFig,
									WORD wFixResizeByText,
									BOOL bIsTextResizeShorten) const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, ojpFig);
	// _xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	repEdit->SetFixResize(wFixResizeByText);
	repEdit->SetIsShortenByText(bIsTextResizeShorten);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOpLiCnMiCoJiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
	if (!repEdit->CalcEnoughSizeRatio(dRatioHorz, dRatioVert, ojpFig))
	//----- _xZkqqHx_iKgHjBoFjHkGiCkKiOfKiPgPiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dRatioHorz = 1.0;
		dRatioVert = 1.0;
	}
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::CalcTextFitSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ExportAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAiBeBjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	repEdit	:_xZkqqHx_iDeHiDgGiDeCiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::ExportAll (CFCWndRichEdit* repEdit, const FCObjFigure* pFig) const
{
//----- 01.02.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
//----- 01.02.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDePiDiJiDhEiDeCiDgCiDeOiDfIiPoOjFpBiCpAiDeHiDgGiDeCiDfOiCmJjAnNjCoIiBeC_xHqqkZx_
	repEdit->PenBrushInit(	pFig->GetStdPenStyle(),
							pFig->GetStdPenWeight(),
							pFig->GetStdPenBackSColor(),
							pFig->GetStdBrushBackSColor());
//----- 05.02.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeHiDgGiDeCiDfOiCpAiDiKiDfEiDeDiDfJiBjFiInKjDkOiBeC_xHqqkZx_
//	repEdit->MoveWindowMM(m_mmrtText);
//----- 05.02.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	DBLPointVector vmmptPoly;
	GetMaskPolygon(vmmptPoly, pFig, pFig->GetResizeFrame().CenterPoint());
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmJiDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAjAnNjCoIiBeCiClBiCmMiOjOiDeHiDgGiDeCiDfOiCmNiDhNiDfIiDeOiCmJiNiHiCoNiClJiCmEiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
	repEdit->SetMaskPolygon(vmmptPoly.begin(), vmmptPoly.size(), DBLPoint(m_mmrtText.left, m_mmrtText.top));

//----- 05.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
//	repEdit->SetResizeHorz(pFig->GetStdResizeHorzByText());
//	repEdit->SetResizeVert(pFig->GetStdResizeVertByText());
//	repEdit->SetIsShortenByText(GetIsShortenByText());
//----- 05.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeHiDgGiDeCiDfOiCmJjAnNjCoIiBeCiDhNiDfIiDeOjAnNjCoIiImIiMoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	ExportText(repEdit);
} // FCRichText::ExportAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::IsTextOver
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiDeJiBfLiDgPiBfLiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDgPiBfLiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRichText::IsTextOver () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (m_vpLine->empty()) return FALSE;
	// _xZkqqHx_iNmFiMoDiCmMiNhDiCkKiDeJiBfLiDgPiBfLiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (m_mmrtText.Height() - m_mmMarginB <
			m_vpLine->back().m_mmY + m_vpLine->back().m_mmfTMHeight +
			m_vpLine->back().m_mmfTMExternalLeading) return TRUE;
	return FALSE;
} // FCRichText::IsTextOver.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiCpAiPjMiCkCiClNiBeBiPiDjAiIiCmIjFlGiOjKjHpBiCmMiCnNiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIs2CR	:_xZkqqHx_iJpMiNhDiCpAiCfBjFlGiOjK_xHqqkZx_("\r\n")_xZkqqHx_iCmJiClHiCoJiCkJiCpAiOhHjCoIiBeC_xHqqkZx_FALSE _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ "\n"_xZkqqHx_iCmMiCnNiBeC_xHqqkZx_
 *			bIsCutLastCR	:_xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCpAiDeKiDgCiDgHiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjElCiCkLiPgPiClHiBeCiOoFiCmJiMjPiNpFjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmFiCmNiJpMiNhDiDfCiBfLiDgIiCmN_xHqqkZx_("\r\n")_xZkqqHx_iCmFiCmNjGlDiCkNiBeB_xHqqkZx_("\n")_xZkqqHx_iCfAjFlGiOjKiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_WndRichEdit_xZkqqHx_jCiGiCmMjFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiImKjChFiCpAiIoKjChGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCmNiOoGiCoIiPgPiClDiCmIiCkCiBeCiClBiCoKiCpAiOoGiCoIiPgPiClHiCmGiBeBiClBiCmMiJpMiNhDiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEjChFiKlHiCmMjBmOiPnLiCmGiCmIiCmBiCmEiClFiCnMiCkEiBeCiNmFiMoDiCmMiJpMiNhDiCmMjChFiKlHiCmN_xHqqkZx_
 *			_xZkqqHx_jHiOiClPiCoJiBeCiCnMiClNiBeBiNmFiMoDiCmMiJpMiNhDiCmNiBeBjGhLjHiIiClBiCmMiDgFiDeMiDfIiDgHiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCRichText::GetText (WString& str, BOOL bIs2CR) const
void FCRichText::GetText (WString& str, BOOL bIs2CR, BOOL bIsCutLastCR) const
{
	str.erase();
	FCStatLineVector::const_iterator iL;
	FCStatCharVector::const_iterator iC;
	for (iL = m_vpLine->begin(); iL != m_vpLine->end(); iL++)
	{
		for (iC = (*iL).m_vStatChar.begin();
			 iC != (*iL).m_vStatChar.end(); iC++)
		{
			switch ((*iC).m_wChar)
			{
			case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDjFlGiOjKiBeC_xHqqkZx_
				if (bIs2CR) str += L'\r';
				str += L'\n';
				break;
			case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiLeMiNiGiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			case FDRCH_FONT:		// FONT_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_OFFSET:		// OFFSET_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_AFTERSPACE:	// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_SCOLOR:		// SColor_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_UNDERLINE:	// _xZkqqHx_iJlKjApMiBeC_xHqqkZx_
//			case FDRCH_STRIKEOUT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeC_xHqqkZx_
//			case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			case FDRCH_PRESPACE:				// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiOhHjCoIiBeC_xHqqkZx_
			case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
			case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
				break;
//			case WCH_TAB:			// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
//			case WCH_SPC:			// _xZkqqHx_iLpDjEjCiBeC_xHqqkZx_
			default:
				str += (*iC).m_wChar;
			}
		}
	}
//----- 01.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
	if (bIsCutLastCR)
		str.resize(str.size() - (bIs2CR ? 2 : 1));
//----- 01.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCRichText::GetText.

//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiCpAiPjMiCkCiClNiBeBiPiDjAiIiCmIjFlGiOjKjHpBiCmMiCnNiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjElCiCkLiPgPiClHiBeCiOoFiCmJiMjPiNpFjHhAiBeCiDfCiBfLiDgIiDhJiBfLiDfHiCmJiCoGiCmBiCmEiCmNiBeB_xHqqkZx_
// *			1Byte_xZkqqHx_jFlGiOjKiCmF_xHqqkZx_0x7f_xZkqqHx_iCpAiJhKiCkGiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiBeCiClBiCkEiCkCiCmBiClNjFlGiOjKiCmNiBeB_xHqqkZx_
// *			_xZkqqHx_iDfIiDhJiBfLiDfIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCmNiBeB_xHqqkZx_("\r\n")_xZkqqHx_iCmFiCmNjGlDiCkNiBeB_xHqqkZx_("\n")_xZkqqHx_iCfAjFlGiOjKiCmJjFmPiKlHiClDiCoKiCoJ_xHqqkZx_
// *			_xZkqqHx_iClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_WndRichEdit_xZkqqHx_jCiGiCmMjFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjFlGiOjKiImKjChFiCpA_xHqqkZx_
// *			_xZkqqHx_iIoKjChGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
// *			_xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCmNiOoGiCoIiPgPiClDiCmIiCkCiBeCiClBiCoKiCpAiOoGiCoIiPgPiClHiCmGiBeBiClBiCmMiJpMiNhDiCmJ_xHqqkZx_
// *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEjChFiKlHiCmMjBmOiPnLiCmGiCmIiCmBiCmEiClFiCnMiCkEiBeCiNmFiMoDiCmMiJpMiNhDiCmMjChFiKlHiCmN_xHqqkZx_
// *			_xZkqqHx_jHiOiClPiCoJiBeCiCnMiClNiBeBiNmFiMoDiCmMiJpMiNhDiCmNiBeBjGhLjHiIiClBiCmMiDgFiDeMiDfIiDgHiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::GetText (CString& str) const
//{
//	str.Empty();
//	FCStatLineVector::const_iterator iL;
//	FCStatCharVector::const_iterator iC;
//	for (iL = m_vpLine->begin(); iL != m_vpLine->end(); iL++)
//	{
//		for (iC = (*iL).m_vStatChar.begin();
//			 iC != (*iL).m_vStatChar.end(); iC++)
//		{
//			switch ((*iC).m_wChar)
//			{
//			case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDjFlGiOjKiBeC_xHqqkZx_
//				str += _T('\n');
//				break;
//			case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiLeMiNiGiBeC_xHqqkZx_
////----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////			case FDRCH_FONT:		// FONT_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			case FDRCH_OFFSET:		// OFFSET_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			case FDRCH_AFTERSPACE:	// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			case FDRCH_SCOLOR:		// SColor_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////			case FDRCH_UNDERLINE:	// _xZkqqHx_iJlKjApMiBeC_xHqqkZx_
////			case FDRCH_STRIKEOUT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeC_xHqqkZx_
////			case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiBeC_xHqqkZx_
////----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//			case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_PRESPACE:				// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiOhHjCoIiBeC_xHqqkZx_
//			case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//			case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
////----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//				break;
////			case WCH_TAB:			// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
////			case WCH_SPC:			// _xZkqqHx_iLpDjEjCiBeC_xHqqkZx_
//			default:
//				if ((*iC).m_wChar & 0xff00)
//				{
//					str += (*iC).m_wChar >> 8;
//					str += (*iC).m_wChar & 0xff;
//				} else
//				{
//					// 1Byte_xZkqqHx_jFlGiOjKiCmFiBeB_xHqqkZx_0x7f_xZkqqHx_iCpAiJhKiCkGiCoJiPoKiNiHiCpAiNgMjHlGiBeC_xHqqkZx_
//					if (0x7f < (*iC).m_wChar)
//						str += _T(' ');
//					else
//						str += (*iC).m_wChar;
//				}
//			}
//		}
//	}
////----- 01.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
//	str.Delete(str.GetLength() - 1, 1);
////----- 01.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCRichText::GetText.
//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::FindNextStr
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiImKjChFiCkJiCoHiBeBiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClFiBeBiNmFiPiJiCmJiMkJiCmCiCkJiCmBiClNiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lFrom	:_xZkqqHx_iMkJiCmCiCkJiCmBiClNjEmNiImNiCmMiNmFiPiJiCmMiImKjChFiCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_
// *					 _xZkqqHx_iCmNjFiJiCmMjCgMiBeC_xHqqkZx_
// *			lUntil	:_xZkqqHx_iMkJiCmCiCkJiCmBiClNjEmNiImNiCmMiNmFiMoDiCmMiImKjChFiCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_
// *					 _xZkqqHx_iCmNjFiJiCmMjCgMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_"ABCD"_xZkqqHx_iCmM_xHqqkZx_"B"_xZkqqHx_iCmMiCnNiDhBiDgCiDgHiCmMiPoKiNiHiBeB_xHqqkZx_lFrom = 1,lUntil = 1_xZkqqHx_iBeC_xHqqkZx_
// *			_xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lFrom < 0, lUntil < 0_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCRichText::FindNextStr (long& lFrom, long& lUntil, const _TCHAR* tcpText, long lStart) const
//{
//	WString str;
//	GetText(str);
//
//	FCWCharStr wcText(tcpText);
//	const wchar_t* wcpText = wcText.Get();
//
//	FCSearchParser sp;
//	if (!sp.ParseSearch(wcpText, TRUE, FALSE)) return FALSE;
//	if (sp.IsMatch(str.c_str()) == 1)
//	{
//		longRangeVector vHitRange;
//		sp.GetMatchingPos(vHitRange, str.c_str());
//
//		longRangeVector::iterator i;
//		for (i = vHitRange.begin(); i != vHitRange.end(); i++)
//		{
//			TRACE("Match %d %d\r\n", (*i).lFrom, (*i).lTo);
//		}
//		return TRUE;
//	} else
//	{
//		return FALSE;
//	}
//
//
//
////----- 01.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHjAlGjAkMiBeC_xHqqkZx_
////	RegExpNFA* pRegEx = ::GenerateNFA();
////	// _xZkqqHx_iMjPiNpFiOkOiCpAjAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
////	if (!pRegEx->SetExpression(wcpText, DREX_EXP_NONE))
////	{
////		// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
////		// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
////		FFMessageBox(FormatResString(IDS_ERR_MSG_WRONG_FORMULA, tcpText));
////		::DeleteNFA(pRegEx);
////		return FALSE;
////	}
////	BOOL bIsHit = FALSE;
////	wchar_t wcCharPrev = _T('\0');
////	const wchar_t* wcpTmp;
////	const wchar_t* wcpHead = str.c_str();
////	while (!bIsHit)
////	{
////		// _xZkqqHx_iPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
////		if (*wcpHead == L'\0') break;
////		wcpTmp = wcpHead;
////		if (pRegEx->IsMatch(wcCharPrev, wcpTmp))
////			bIsHit = TRUE;
////		wcCharPrev = *wcpHead;
////		wcpHead++;
////	}
////
////	if (bIsHit)
////	{
////		long lSize = pRegEx->GetMatchStrSize();
////		for (long lC = 0; lC < lSize; lC++)
////		{
////			const wchar_t* wcpFrom;
////			const wchar_t* wcpTo;
////			pRegEx->GetMatchStr(wcpFrom, wcpTo, lC);
////		}
////	}
////
////
////	// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiNoNiPjMiBeC_xHqqkZx_
////	::DeleteNFA(pRegEx);
////	return bIsHit;
////----- 01.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // FCRichText::FindNextStr.
//----- 01.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ClearSelection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjFjEjFkKjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_iPmBiLiOjFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *				 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::ClearSelection (CDC* pDC)
//{
//	if (pDC != NULL)
//		DrawSelection(pDC);
//	// _xZkqqHx_jBeJjBpAjEmNiImNiBeC_xHqqkZx_
//	m_vSelectRange.clear();
//} // FCRichText::ClearSelection.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::AppendSelection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjFjEjFkKjBeJjBpAiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lFrom	:_xZkqqHx_jBeJjBpAjEmNiImNiCmMiNmFiPiJiCmMjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTo		:_xZkqqHx_jBeJjBpAjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCmMiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCoJjEmNiImNiCmNiBeB_xHqqkZx_[lFrom, lTo)_xZkqqHx_iCmMjFlGiOjKiCmFiCkAiCoJiBeC_xHqqkZx_
////----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// *			_xZkqqHx_jCmHiJmBiClDiCoKiClNjEmNiImNiCkKiBeBiKpJiCmJjCmHiJmBiClDiCoKiClNjEmNiImNiCmGiPgEiCmIiCoHiCmIiCkCiCoGiCkEiCmJjCiNiInDiBeC_xHqqkZx_
//// *			_xZkqqHx_jCmHiJmBiClDiCoKiCoJiPiHjEnEiCmNiBeBiDgFiDeMiDfIiDgHiCmMjBePjFpLiCkJiCoHiMoDjFpLiCmJiMpMiCkJiCmBiCmEiPiHjEnEiCmF_xHqqkZx_
//// *			_xZkqqHx_iCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
////----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::AppendSelection (long lFrom, long lTo)
//{
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_jBeJjBpAjEmNiImNiBeC_xHqqkZx_
////	m_vSelectRange.push_back(FClongRange(lFrom, lTo));
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iCnMiClIiBeBjBeJjBpAjEmNiImNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjBfDiCmE_xHqqkZx_ longSet _xZkqqHx_iCmJiOpLiCnPiCoJiBeC_xHqqkZx_
//	long lC;
//	longSet stSelIndex;
//	mdef_const_iterator(longRangeVector, iRange);
//	m1_for (iRange, m_vSelectRange)
//	{
//		for (lC = iRange->lFrom; lC != iRange->lTo; lC++)
//			stSelIndex.insert(lC);
//	}
//	for (lC = lFrom; lC != lTo; lC++)
//		stSelIndex.insert(lC);
//
//	// _xZkqqHx_jBeJjBpAjEmNiImNiCmMiLeMjIfOjFmPjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_vSelectRange.clear();
//	if (!stSelIndex.empty())
//	//----- _xZkqqHx_jBeJjBpAjEmNiImNiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// longSet_xZkqqHx_jFmPjAjE_xHqqkZx_ stSelIndex _xZkqqHx_iCpAiPiHjEnEiCmJiOoGiCoIiPgPiClFiCmEiBeB_xHqqkZx_
//		// _xZkqqHx_jIeBjBlBiClFiCmIiCkCjFjEjFkKiCkKiCkAiCoKiCmOiBeBiClLiClBiCnMiCmFiCmMjEmNiImNiCpA_xHqqkZx_
//		// m_vSelectRange_xZkqqHx_jFmPjAjEiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//		longSet::const_iterator iIdx = stSelIndex.begin();
//		long lBeginIdx = *iIdx;
//		long lPrevIdx = *iIdx;
//		for (iIdx++; iIdx != stSelIndex.end(); iIdx++)
//		{
//			if (*iIdx != lPrevIdx + 1)
//			{
//				m_vSelectRange.push_back(FClongRange(lBeginIdx, lPrevIdx + 1));
//				lBeginIdx = *iIdx;
//			}
//			lPrevIdx = *iIdx;
//		}
//		m_vSelectRange.push_back(FClongRange(lBeginIdx, lPrevIdx + 1));
//	}
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCRichText::AppendSelection.
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::DrawSelection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjFjEjFkKiCpAjFgAiJoGiBeFiPmBiLiOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_iPmBiLiOjFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *				 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::DrawSelection (CDC* pDC)
//{
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (m_vSelectRange.empty()) return;
////
////	mmetol	mmX;
////	mmetol	mmBaseLine;
////	long	lLine;
////	long	lChar;
////	const FCStatChar* pChar;
////	short	nAfterSpace = short(MINSHORT);
////	DBLRect		mmrctChar;		// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
////	DBLPoint	mmptaChar[5];	// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
////	double	dCos = 1.0;
////	double	dSin = 0.0;
////	if (!almost0(m_dAngle))
////	{
////		dCos = cos(m_dAngle * M_PI);
////		dSin = sin(m_dAngle * M_PI);
////	}
////	const DBLPoint mmptCenter = m_mmrtText.CenterPoint();
////
////	FCEditDraw eDraw(pDC, 0L);
////	longRangeVector::const_iterator iSr = m_vSelectRange.begin();
////	long lIndex = 0;
////	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
////		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
////	{
////		if ((*iSr).lTo <= lIndex) iSr++;
////		if (iSr == m_vSelectRange.end()) break;
////
////		switch (pChar->m_wChar)
////		{
////		case FDRCH_CONTINUE:				// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
////		case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////		case FDRCH_PRESPACE:				// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiOhHjCoIiBeC_xHqqkZx_
////		case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////		case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
////		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
////			break;
////
////		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
////		case WCH_TAB:			// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
////			lIndex++;
////			break;
////
////		default:				// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
////			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
////			if (m_mmrtText.right < mmX + pChar->m_mmfWidth)
////			{
////				lIndex++;
////				break;
////			}
////			if ((*iSr).lFrom <= lIndex && lIndex < (*iSr).lTo)
////			{
////				//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoGiBgJiLoJiMgAiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
////				mmptaChar[0].SetPoint(mmX,
////									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
////				mmptaChar[1].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
////									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
////				mmptaChar[2].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
////									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
////												(*m_vpLine)[lLine].m_mmfTMHeight);
////				mmptaChar[3].SetPoint(mmX,
////									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
////												(*m_vpLine)[lLine].m_mmfTMHeight);
////				// _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJpBjDfNiPiIjHjNiBeCjFgAiJoGiKeKiOgOiNmAjFfHiCoAiCmCiCkCiCmFiCmJiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
////				if (!almost0(m_dAngle))
////					::RotateConv(mmptaChar, 4, dSin, dCos, mmptCenter.x, mmptCenter.y);
////				// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
////				::FFCalcFrame(mmrctChar, 4L, mmptaChar);
////
////				if (g_pView->IsRgnOverlap(mmrctChar))
////				//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
////				{
////					CPoint lgptaChar[4];
////					mm2lg(lgptaChar, mmptaChar, 4);
////					eDraw.Polygon(lgptaChar, 4);
////				}
////			}
////			lIndex++;
////		}
////	}
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	longSet stSelIndex;
//	mdef_const_iterator(longRangeVector, iRange);
//	m1_for (iRange, m_vSelectRange)
//	{
//		long lC;
//		for (lC = iRange->lFrom; lC != iRange->lTo; lC++)
//			stSelIndex.insert(lC);
//	}
//	DrawSelection(pDC, stSelIndex);
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCRichText::DrawSelection.
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::DrawSelection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjFlGiOjKiCpAjBeJjBpAiPpDjBnEiBeFjEpBjBeJjBpAiPpDjBnEiCmFjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stSelIndex	:_xZkqqHx_jBeJjBpAjFgAiJoGiClDiClJiCoJjFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::DrawSelection (CDC* pDC, longSet stSelIndex)
{
	mmetol	mmX;
	mmetol	mmBaseLine;
	long	lLine;
	long	lChar;
	const FCStatChar* pChar;
	short	nAfterSpace = short(MINSHORT);
	DBLRect		mmrctChar;		// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	DBLPoint	mmptaChar[5];	// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	double	dCos = 1.0;
	double	dSin = 0.0;
	if (!almost0(m_dAngle))
	{
		dCos = cos(m_dAngle * M_PI);
		dSin = sin(m_dAngle * M_PI);
	}
	const DBLPoint mmptCenter = m_mmrtText.CenterPoint();

	FCEditDraw eDraw(pDC, 0L);
	long lIndex = 0;
	for (pChar = CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine); pChar != NULL;
		 pChar = CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
	{
		if (stSelIndex.empty()) break;
		switch (pChar->m_wChar)
		{
		case FDRCH_CONTINUE:				// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_PRESPACE:				// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiOhHjCoIiBeC_xHqqkZx_
		case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
			break;

		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
		case WCH_TAB:			// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
			lIndex++;
			break;

		default:				// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
			if (m_mmrtText.right < mmX + pChar->m_mmfWidth)
			{
				lIndex++;
				break;
			}
			if (stSelIndex.erase(lIndex) == 1)
			//----- lIndex _xZkqqHx_iCkKjBeJjBpAjEmNiImNiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoGiBgJiLoJiMgAiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
				mmptaChar[0].SetPoint(mmX,
									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
				mmptaChar[1].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent);
				mmptaChar[2].SetPoint(mmX + pChar->m_mmfWidth + tw2mm(nAfterSpace),
									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
												(*m_vpLine)[lLine].m_mmfTMHeight);
				mmptaChar[3].SetPoint(mmX,
									mmBaseLine - (*m_vpLine)[lLine].m_mmfTMAscent +
												(*m_vpLine)[lLine].m_mmfTMHeight);
				// _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJpBjDfNiPiIjHjNiBeCjFgAiJoGiKeKiOgOiNmAjFfHiCoAiCmCiCkCiCmFiCmJiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
				if (!almost0(m_dAngle))
					::RotateConv(mmptaChar, 4, dSin, dCos, mmptCenter.x, mmptCenter.y);
				// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
				::FFCalcFrame(mmrctChar, 4L, mmptaChar);

				if (g_pView->IsRgnOverlap(mmrctChar))
				//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					CPoint lgptaChar[4];
					mm2lg(lgptaChar, mmptaChar, 4);
					eDraw.Polygon(lgptaChar, 4);
				}
			}
			lIndex++;
		}
	}
} // FCRichText::DrawSelection.

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetSelection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjFlGiOjKiCmMjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSelectRange	:_xZkqqHx_jBeJjBpAjEmNiImNiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vSelectRange _xZkqqHx_iCmNiBeB_xHqqkZx_longRange { lFrom, lTo } _xZkqqHx_iCmMjEhKjHpBiBeC_xHqqkZx_
// *			_xZkqqHx_jBeJjBpAjEmNiImNiCmNiBeB_xHqqkZx_[lFrom, lTo) _xZkqqHx_iCmMjFlGiOjKjEmNiImNiCmGiCmIiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::GetSelection (longRangeVector& vSelectRange) const
//{
//	vSelectRange = m_vSelectRange;
//} // FCRichText::GetSelection.
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::CharFirst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiCmMiDiLiBfLiDhGiCmMiBeBiNmFiPiJiCmMjFlGiOjKiCmMjDmBjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLine		:_xZkqqHx_iNmFiPiJiCmMjFlGiOjKiCmMiNhDiCpAjFnEiClHiBeC_xHqqkZx_
 *			lChar		:_xZkqqHx_iNmFiPiJiCmMjFlGiOjKiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmX			:_xZkqqHx_iNmFiPiJiCmMjFlGiOjKiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nAfterSpace	:_xZkqqHx_jFlGiOjKiMoDiCmMiLpDjEjCiCpAjFnEiClHiBeC_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiMgOiBeC_xHqqkZx_
 *			mmBaseLine	:_xZkqqHx_iNmFiPiJiCmMjFlGiOjKiCmMiNhDiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMjFlGiOjKiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CharNext_xZkqqHx_iCmGiDfKiDgCiDgHiCmFiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCStatChar* FCRichText::CharFirst (long& lLine, long& lChar, mmetol& mmX,
										short& nAfterSpace, mmetol& mmBaseLine) const
{
// 05.02.21 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (m_vpLine->empty()) return NULL;
	lLine = 0;
	lChar = 0;
	FCStatLine* pLine = &(*m_vpLine)[lLine];
	// _xZkqqHx_iClBiCoKiImIiPoD_xHqqkZx_ _xZkqqHx_iJlKjBkEiCpAiMhGiOfKiClHiCoJiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
	if (m_mmrtText.Height() - m_mmMarginB <
		pLine->m_mmY + pLine->m_mmfTMHeight + pLine->m_mmfTMExternalLeading)
		return NULL;
	// _xZkqqHx_iDgFiDeMiDfIiDgHiNlGiNmAjFfHiCmJ_xHqqkZx_[_xZkqqHx_jFjEjFgJiNlGiNmAjFfHiBhLiNlGiDhNiBfLiDfHiDjD_xHqqkZx_]_xZkqqHx_iCpAjAnNjCoI_xHqqkZx_
	if (pLine->m_byLineType == FDRC_LT_HEAD)
		mmX = m_mmrtText.left + m_mmMarginL + pLine->m_mmStartIndent;
	else	// FDRC_LT_CONTINUE.
		mmX = m_mmrtText.left + m_mmMarginL + pLine->m_mmStartIndent + pLine->m_mmOffset;
	nAfterSpace = 0;
	mmBaseLine = m_mmrtText.top + pLine->m_mmY + pLine->m_mmfTMAscent;
	return &pLine->m_vStatChar[lChar];
} // FCRichText::CharFirst.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::CharNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiCmMiDiLiBfLiDhGiCmMiBeBiOjPiCmMjFlGiOjKiCmMjDmBjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLine		:_xZkqqHx_iOjPiCmMjFlGiOjKiCmMiNhDiCpAjFnEiClHiBeC_xHqqkZx_
 *			lChar		:_xZkqqHx_iOjPiCmMjFlGiOjKiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmX			:_xZkqqHx_iOjPiCmMjFlGiOjKiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nAfterSpace	:_xZkqqHx_jFlGiOjKiMoDiCmMiLpDjEjCiCpAjFnEiClHiBeC_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiMgOiBeC_xHqqkZx_
 *			mmBaseLine	:_xZkqqHx_iOjPiCmMjFlGiOjKiCmMiNhDiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMjFlGiOjKiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CharFirst_xZkqqHx_iCmGiDfKiDgCiDgHiCmFiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCStatChar* FCRichText::CharNext (long& lLine, long& lChar, mmetol& mmX,
										short& nAfterSpace, mmetol& mmBaseLine) const
{
	FCStatLine* pLine = &(*m_vpLine)[lLine];
	FCStatChar* pChar = &pLine->m_vStatChar[lChar];
	switch (pChar->m_wChar)
	{
	case FDRCH_RETURN:
	case FDRCH_CONTINUE:
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	case FDRCH_FONT:	// FONT_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//	case FDRCH_OFFSET:	// OFFSET_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	case FDRCH_FONT_AND_OFFSET:			// FONT,Offset_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		break;

	case FDRCH_AFTERSPACE:				// AfterSpace_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
		nAfterSpace = pChar->m_nAfterSpace;
		break;

//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	case FDRCH_UNDERLINE:	// _xZkqqHx_iJlKjApMiBeC_xHqqkZx_
//	case FDRCH_STRIKEOUT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	case FDRCH_COLORREF:				// COLORREF_xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
	case FDRCH_LINES_AND_CROSSSTAT:		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEjAnNjCoIiBeC_xHqqkZx_
//----- 01.02.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		break;
	case FDRCH_PRESPACE:// _xZkqqHx_jFlGiOjKjBePjHfNjEjCiBeC_xHqqkZx_
		mmX += pChar->m_mmfPreSpace;
		break;
	case WCH_TAB:		// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
	case WCH_SPC:		// _xZkqqHx_iLpDjEjCiBeC_xHqqkZx_
	default:
		mmX += pChar->m_mmfWidth + tw2mm(nAfterSpace);
		break;
	}
	lChar++;
	if (lChar < pLine->m_vStatChar.size())
		return &pLine->m_vStatChar[lChar];

	lChar = 0;
	lLine++;
	if (m_vpLine->size() <= lLine) return NULL;
	pLine = &(*m_vpLine)[lLine];
	// _xZkqqHx_iClBiCoKiImIiPoD_xHqqkZx_ _xZkqqHx_iJlKjBkEiCpAiMhGiOfKiClHiCoJiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
	if (m_mmrtText.Height() - m_mmMarginB <
		pLine->m_mmY + pLine->m_mmfTMHeight + pLine->m_mmfTMExternalLeading)
		return NULL;
	// _xZkqqHx_iDgFiDeMiDfIiDgHiNlGiNmAjFfHiCmJ_xHqqkZx_[_xZkqqHx_jFjEjFgJiNlGiNmAjFfHiBhLiNlGiDhNiBfLiDfHiDjD_xHqqkZx_]_xZkqqHx_iCpAjAnNjCoI_xHqqkZx_
	if (pLine->m_byLineType == FDRC_LT_HEAD)
		mmX = m_mmrtText.left + m_mmMarginL + pLine->m_mmStartIndent;
	else	// FDRC_LT_CONTINUE.
		mmX = m_mmrtText.left + m_mmMarginL + pLine->m_mmStartIndent + pLine->m_mmOffset;
	mmBaseLine = m_mmrtText.top + pLine->m_mmY + pLine->m_mmfTMAscent;
	return &pLine->m_vStatChar[lChar];
} // FCRichText::CharNext;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMkDiff
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMjFlGiOjKjHpBiCmMiNlHjFkKiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lFrom	:strBefore_xZkqqHx_jCiGiCmMiBeBjChFiKlHjFjEjFkKiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lTo		:strBefore_xZkqqHx_jCiGiCmMiBeBjChFiKlHjFjEjFkKiCmMiNmFiMoDiCmMiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			strNew	:strAfter_xZkqqHx_jCiGiCmMiBeBjChFiKlHjFjEjFkKiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			strBefore	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBiCmCiCmMjFlGiOjKjHpBiCmMiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			strAfter	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBiCmCiCmMjFlGiOjKjHpBiCmMiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	strBefore = "Hello" strAfter "Hemmmo" _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			lFrom = 2, lTo = 4, strNew = "mmm"
 *			strBefore = "AAAA" strAfter "AAAAAA" _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			lFrom = 4, lTo = 4, strNew = "AA"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myMkDiff (long& lFrom, long& lTo, WString& strNew,
						const WString& strBefore, const WString& strAfter)
{
	// _xZkqqHx_jFmPiNfIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (strBefore == strAfter) return FALSE;
	for (lFrom = 0; lFrom < strBefore.length() && lFrom < strAfter.length(); lFrom++)
	{
		if (strBefore.at(lFrom) != strAfter.at(lFrom)) break;
	}
	lTo = strBefore.length();
	long lIdxA = strAfter.length();
	for (; 0 < lTo && 0 < lIdxA && lFrom < lTo; lTo--, lIdxA--)
	{
		if (strBefore.at(lTo - 1) != strAfter.at(lIdxA - 1)) break;
	}
	strNew.erase();
	strNew.append(&strAfter.at(lFrom), &strAfter.at(lIdxA));
	return TRUE;
} // myMkDiff.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::ReplaceAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOhHjCoIiCmM_xHqqkZx_SearchParser_xZkqqHx_iCmJiKoOiCmDiCkCiCmEiBeBjBfDiCmEjChFiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_iDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			pFig		:_xZkqqHx_iMhGiOfKiCmMiMlDiCmJiCmIiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::ReplaceAll (BYTEVector& byvQueue, FCSearchParser& sp,
							 const FCObjFigure* pFig)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjBfDiCmEiDeHiDgGiDeCiDfOiCnG_xHqqkZx_Export_xZkqqHx_iBeC_xHqqkZx_
	CFCWndRichEdit* repEdit = g_pView->GetRTFEditor();
	ExportAll(repEdit, pFig);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjChFiKlHiPiIjHjNiBeC_xHqqkZx_
	repEdit->SetCurIndex(0);
	repEdit->ReplaceAll(sp);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	ImportText(repEdit);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	repEdit->GetCmdQueue(byvQueue);
	// _xZkqqHx_iDeMiDiFiBfLiCmMjDoAjHgFiCpAiNmFjDeLiJlLiClHiCoJiBeC_xHqqkZx_
	CFCWndRichEdit::OptimizeCmdQueue(byvQueue);
	// _xZkqqHx_iDeHiDgGiDeCiDfOiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	repEdit->ClearAll();
} // FCRichText::ReplaceAll.

//----- 05.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::AdjustObjectSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiBeBiClLiCmMjFjEjFgJiCmJiKnMiCnMiCoKiCoJjFjEjFgJiBgJiDiBiDjDiDgPiBfLiBgKiCmMiDgFiDeMiDfIiDgHiCmM_xHqqkZx_
// *			_xZkqqHx_iIoMiCoKiCkKjGlDiCkNiCmIiCoJiCoGiCkEiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTopObj	:_xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pText	:pTopObj_xZkqqHx_iCmMiDiBiDjDiDgPiBfL_xHqqkZx_(pTopObj_xZkqqHx_iCoAiKnMiCnO_xHqqkZx_)_xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dRatioHorz	:X_xZkqqHx_jFpLiMpMiDiKiDfEiDeDiDfJiCmMiKoOiPiAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dRatioVert	:Y_xZkqqHx_jFpLiMpMiDiKiDfEiDeDiDfJiCmMiKoOiPiAiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIjEkNiNhDiClHiCoJiClBiCmGiCmJjCiNiInDiBeCiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkIiCkN_xHqqkZx_
// *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCRichText::AdjustObjectSize (	FCObjDynabase* pTopObj,
//									FCRichText* pText,
//									double dRatioHorz,
//									double dRatioVert)
//{
////----- 05.02.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (!almosteq(dRatioHorz, 1.0) || !almosteq(dRatioVert, 1.0))
////	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDfEiDeDiDfJjFmPiNfIiCkKiOhHiOkGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
////	{
////		DBLPoint mmptCenter = pTopObj->GetResizeFrame().CenterPoint();
////		// _xZkqqHx_iJpBjDfNjHmKiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
////		double dTextR = pText->GetAngle();
////		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeCiDgFiDeMiDfIiDgHiCmMiKhAjDhIiCpAiCePiCmJiClHiCoJiBeC_xHqqkZx_
////		g_pDoc->CmdRotate1Obj(pTopObj, ::RegulateAngle(-dTextR), mmptCenter);
////
////		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhIiCePiCmMiPpDjBnEiCmFiBeBjEoEjHkGiCmJiPfNiCmBiCmEiDiKiDfEiDeDiDfJ_xHqqkZx_ -----
////		// _xZkqqHx_jFkBiOeHiCmIiMgAiPpDiCmMjAhNiMgAiClOiCmGiBeBjHfMjEpFiMhGiOfKiCmFiOfKiPgPiClFiClNiDiKiDfEiDeDiDfJjEoE_xHqqkZx_ dRatioHorz/dRatioVert _xZkqqHx_iCmF_xHqqkZx_
////		// _xZkqqHx_iOpLiCnMiCoHiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeBiOmAiNnLiCmJjFjEjFgJiCpAiDiKiDfEiDeDiDfJiClFiCmEiKgNjEeGiClFiBeB_xHqqkZx_
////		// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkCiPoKiNiHiCmNjDpMiCoJjBoFiCkLiClDiCnMiCmFiNeMiClAiCmEiCnNiCoJiBeC_xHqqkZx_
////		const DBLRect mmrtFrame = pTopObj->GetResizeFrame();
////		DBLRect mmrtNewFrame = mmrtFrame.ExtendRect(
////									mmrtFrame.Width() * (dRatioHorz - 1.0) / 2.0,
////									mmrtFrame.Height() * (dRatioVert - 1.0) / 2.0);
////		// _xZkqqHx_jFjEjFgJiCmMiNmFjBoFiDfEiDeDiDfJiCpAiJhKiCkGiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
////		if (mmrtNewFrame.Width() <= FD_OBJ_MAX_W &&
////			mmrtNewFrame.Height() <= FD_OBJ_MAX_H)
////		{
////			for (int iC = 0; iC < 10; iC++)
////			{
////				// _xZkqqHx_jFjEjFgJiCmMiNmFjBoFiDfEiDeDiDfJiCpAiJhKiCkGiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
////				if (FD_OBJ_MAX_W < mmrtNewFrame.Width() ||
////					FD_OBJ_MAX_H < mmrtNewFrame.Height()) break;
////				// _xZkqqHx_iDiKiDfEiDeDiDfJiClFiCmEiCnNiCoJiBeCiJlMiPiIjHjNiBeC_xHqqkZx_
////				pTopObj->Resize(TRUE, TRUE, mmrtNewFrame);
////				// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOpLiCnMiCmBiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
////				if (!pText->IsTextOver()) break;
////				// _xZkqqHx_jFjNiBeFiNiCiClDiCpAiCfAiKiEjBjNiClFiCmEiCnNiCoJiBeC_xHqqkZx_
////				mmrtNewFrame.Extend(mmrtNewFrame.Width() * 0.05,
////									mmrtNewFrame.Height() * 0.05);
////			}
////			// _xZkqqHx_iJlMiCmMiDiKiDfEiDeDiDfJiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
////			pTopObj->Resize(TRUE, TRUE, mmrtFrame);
////			// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
////			g_pDoc->CmdResize1Obj(pTopObj, mmrtNewFrame);
////		}
////		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeCiDgFiDeMiDfIiDgHiCmMiKhAjDhIiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
////		g_pDoc->CmdRotate1Obj(pTopObj, ::RegulateAngle(dTextR), mmptCenter);
////		// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
////		FTMolipSet stMolip;
////		// _xZkqqHx_iDiKiDfEiDeDiDfJiClFiClNjFjEjFgJiCmMiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
////		stMolip.insert(FCMolipRec(pTopObj->GetObjID(), -1));
////		// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
////		g_pDoc->LinkManager()->MovedNotify(stMolip);
////	}
////----- 05.02.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (!almosteq(dRatioHorz, 1.0) || !almosteq(dRatioVert, 1.0))
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDfEiDeDiDfJjFmPiNfIiCkKiOhHiOkGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		DBLPoint mmptCenter = pTopObj->GetResizeFrame().CenterPoint();
//		// _xZkqqHx_iJpBjDfNjHmKiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
//		double dTextR = pText->GetAngle();
//		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeCiDgFiDeMiDfIiDgHiCmMiKhAjDhIiCpAiCePiCmJiClHiCoJiBeC_xHqqkZx_
//		g_pDoc->CmdRotate1Obj(pTopObj, ::RegulateAngle(-dTextR), mmptCenter);
//
//		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhIiCePiCmMiPpDjBnEiCmFiBeBjEoEjHkGiCmJiPfNiCmBiCmEiDiKiDfEiDeDiDfJ_xHqqkZx_ -----
//
//		DBLPoint mmptFixPoint(0.0, 0.0);
//		switch (pText->GetResizeHorz())
//		{
//		case FD_RPT_H_LEFT:	// _xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.x = pText->GetTextRect().left;
//			break;
//		case FD_RPT_H_CENTER:	// _xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.x = (pText->GetTextRect().left + pText->GetTextRect().right) / 2.0;
//			break;
//		case FD_RPT_H_RIGHT:	// _xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.x = pText->GetTextRect().right;
//			break;
//		}
//		switch (pText->GetResizeVert())
//		{
//		case FD_RPT_V_TOP:		// _xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.y = pText->GetTextRect().top;
//			break;
//		case FD_RPT_V_CENTER:	// _xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.y = (pText->GetTextRect().top + pText->GetTextRect().bottom) / 2.0;
//			break;
//		case FD_RPT_V_BOTTOM:	// _xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			mmptFixPoint.y = pText->GetTextRect().bottom;
//			break;
//		}
//
//		const DBLRect mmrtFrame = pTopObj->GetResizeFrame();
//		DBLRect mmrtNewFrame;
//		// _xZkqqHx_jFkBiOeHiCmIiMgAiPpDiCmMjAhNiMgAiClOiCmGiBeBjHfMjEpFiMhGiOfKiCmFiOfKiPgPiClFiClNiDiKiDfEiDeDiDfJjEoE_xHqqkZx_ dRatioHorz/dRatioVert _xZkqqHx_iCmF_xHqqkZx_
//		// _xZkqqHx_iOpLiCnMiCoHiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeBiOmAiNnLiCmJjFjEjFgJiCpAiDiKiDfEiDeDiDfJiClFiCmEiKgNjEeGiClFiBeB_xHqqkZx_
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkCiPoKiNiHiCmNjDpMiCoJjBoFiCkLiClDiCnMiCmFiNeMiClAiCmEiCnNiCoJiBeC_xHqqkZx_
//		for (;;)
//		{
//			mmrtNewFrame = (mmrtFrame - mmptFixPoint) * DBLPoint(dRatioHorz, dRatioVert) + mmptFixPoint;
//			// _xZkqqHx_jFjEjFgJiCmMiNmFjBoFiDfEiDeDiDfJiCpAiJhKiCkGiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
//			if (FD_OBJ_MAX_W < mmrtNewFrame.Width() ||
//				FD_OBJ_MAX_H < mmrtNewFrame.Height())
//			{
//				mmrtNewFrame = mmrtFrame;
//				break;
//			}
//			// _xZkqqHx_iDiKiDfEiDeDiDfJiClFiCmEiCnNiCoJiBeCiJlMiPiIjHjNiBeC_xHqqkZx_
//			pTopObj->Resize(TRUE, TRUE, mmrtNewFrame);
//			// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOpLiCnMiCmBiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//			if (!pText->IsTextOver()) break;
//			// _xZkqqHx_jFjNiBeFiNiCiClDiCpA_xHqqkZx_5%_xZkqqHx_jBjNiClFiCmEiCnNiCoJiBeC_xHqqkZx_
//			dRatioHorz *= 1.05;
//			dRatioVert *= 1.05;
//		}
//		// _xZkqqHx_iJlMiCmMiDiKiDfEiDeDiDfJiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//		pTopObj->Resize(TRUE, TRUE, mmrtFrame);
//		// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
//		g_pDoc->CmdResize1Obj(pTopObj, mmrtNewFrame);
//
//		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeCiDgFiDeMiDfIiDgHiCmMiKhAjDhIiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//		g_pDoc->CmdRotate1Obj(pTopObj, ::RegulateAngle(dTextR), mmptCenter);
//		// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
//		FTMolipSet stMolip;
//		// _xZkqqHx_iDiKiDfEiDeDiDfJiClFiClNjFjEjFgJiCmMiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//		stMolip.insert(FCMolipRec(pTopObj->GetObjID(), -1));
//		// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//		g_pDoc->LinkManager()->MovedNotify(stMolip);
//	}
////----- 05.02.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCRichText::AdjustObjectSize.
//----- 05.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRichText::GetMaskPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiCmJjAnNjCoIiClHiCoJiDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_iDhNiDfIiDeOiDhMiDiKiDfDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			pFig		:_xZkqqHx_iMhGiOfKiCmMiMlDiCmJiCmIiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRichText::GetMaskPolygon (DBLPointVector& vmmptPoly,
								 const FCObjDynabase* pFig,
								 const DBLPoint& mmptCenter) const
{
	// _xZkqqHx_jFjEjFgJiCmMiDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	pFig->NewObjPolygonForText(vmmptPoly, FFGetStdElemLen(), NULL, 0);
	pFig->NewObjPolygonForText(vmmptPoly, -1, NULL, 0);
	//----- _xZkqqHx_iDhNiDfIiDeOjFjEjFgJiCmMiDhMiDiKiDfDiDjDiCpAiDgFiDeMiDfIiDgHjFjEjFgJiCmMiJpBjDfNjFkKiLhEjFmPiKlH_xHqqkZx_ -----
	if (!almost0(m_dAngle))
	{
		::RotateConv(vmmptPoly.begin(), vmmptPoly.size(),
					sin(-m_dAngle * M_PI), cos(-m_dAngle * M_PI), mmptCenter.x, mmptCenter.y);
	}
} // FCRichText::GetMaskPolygon.

