#ifndef __SimpleHash_h
#define __SimpleHash_h

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCSimpleValueFactory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCSimpleHash_xZkqqHx_iCmMiDgGiDhEiDeIiDiLiDgHiDhEiDeAiDeOiDgHiDiKiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	T_VALUE	:_xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCmMjCgMiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeOiDgHiDiKiDeOiDiJiDfIiCmNiBeBiImIiJlKiCmMiCfBiCmCiCmMjAmDjDeJiKnGjAjEiCpAiOjNiCmBiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			static T_VALUE Invalid ()		:T_VALUE_xZkqqHx_iCmMjGlDiMpIiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			static void Delete (T_VALUE v)	:T_VALUE_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_VALUE>
struct FCSimpleValueFactory
{
	inline static T_VALUE Invalid () { return T_VALUE(-1); }
	inline static void Delete (T_VALUE v) { }
}; // struct FCSimpleValueFactory.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCSimpleLastHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfMjAkMiClHiCoJiDgDiDiKiBfLiNfMjBkCiCmMiBeBjGjGjCfLiCmMiDgDiDiKiBfLiCpAjCfDjDjGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	T_ID	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_VALUE	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_FACT	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmJiKnGiClHiCoJiDhEiDeAiDeOiDgHiDiKiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCSimpleHash _xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template< class T_ID, class T_VALUE, class T_FACT = FCSimpleValueFactory<T_VALUE> >
class FCSimpleLastHash
{
public:
	FCSimpleLastHash ();
	T_VALUE	Get (T_ID id) const;
	short	Set (T_ID id, T_VALUE v);
	short	Unset (T_ID id);
	void	Delete ();
	BOOL	GetFreeId (T_ID& id) const;
	BOOL	GetNextId (T_ID& id) const;

private:
	T_VALUE	m_aValue[256];		// _xZkqqHx_jCgMiCmMjEhKjHpBiBeCjCgMiCkKiCmIiCkCiPoKiNiHiCmNjGlDiMpIjCgMiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
	short	m_nUsedHashCount;	// m_aValue[n]_xZkqqHx_iCmMiCkEiClPiBeBiOgHiCoNiCoKiCmEiCkCiCoJjEhKjHpBjAjEiCpAiLeMjIfOiBeC_xHqqkZx_
								// _xZkqqHx_iClHiCmIiCoNiClP_xHqqkZx_ m_aHash[i] != T_FACT::Invalid() _xZkqqHx_iCmMjAjEiCpAiDeKiDeFiDjDiDgHiClFiCmEiCkCiCoJiBeC_xHqqkZx_
}; // class FCSimpleLastHash.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCSimpleMiddleHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNfMjAkMiClHiCoJiDgDiDiKiBfLiNfMjBkCiCmMiBeBjGjGjCfLiCmMiDgDiDiKiBfLiImIiKePiCpAjCfDjDjGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	T_ID	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_VALUE	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_FACT	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmJiKnGiClHiCoJiDhEiDeAiDeOiDgHiDiKiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCSimpleHash _xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template< class T_ID, class T_VALUE, class T_FACT = FCSimpleValueFactory<T_VALUE> >
class FCSimpleMiddleHash
{
private:
	typedef FCSimpleLastHash<T_ID, T_VALUE, T_FACT> LAST_HASH;
	typedef FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT> MIDDLE_HASH;

public:
	FCSimpleMiddleHash ();
	T_VALUE	Get (T_ID id, size_t szTreeDepth) const;
	short	Set (T_ID id, T_VALUE v, size_t szTreeDepth);
	short	Unset (T_ID id, size_t szTreeDepth);
	void	Delete (size_t szTreeDepth);
	BOOL	GetFreeId (T_ID& id, size_t szTreeDepth) const;
	BOOL	GetNextId (T_ID& id, size_t szTreeDepth) const;
	short	GetUsedHashCount () const;

private:
	void*	m_aHash[256];		// _xZkqqHx_iJlKjCgJiCmMiDgOiDgCiDfGiDiFiDeJiDhFiDfHiDeGiDeOiDgHiCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
								// _xZkqqHx_iJlKjCgJiCkKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
								// _xZkqqHx_iJlKjCgJiCkKiNmFiPeJjCgJiCmMiPoKiNiHiCmN_xHqqkZx_ FCSimpleLastHash_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiBeB_xHqqkZx_
								// _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ FCSimpleMiddleHash_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
	short	m_nUsedHashCount;	// m_aHash[n]_xZkqqHx_iCmMiCkEiClPiBeBiOgHiCoNiCoKiCmEiCkCiCoJjEhKjHpBjAjEiCpAiLeMjIfOiBeC_xHqqkZx_
								// _xZkqqHx_iClHiCmIiCoNiClP_xHqqkZx_ m_aHash[i] != NULL _xZkqqHx_iCmMjAjEiCpAiDeKiDeFiDjDiDgHiClFiCmEiCkCiCoJiBeC_xHqqkZx_
}; // class FCSimpleMiddleHash.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCSimpleHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeFiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	T_ID	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_VALUE	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			T_FACT	:_xZkqqHx_iDgOiDgCiDfGiDiFiCmMjCgMiCmJiKnGiClHiCoJiDhEiDeAiDeOiDgHiDiKiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	T_ID _xZkqqHx_iCmNiBeB_xHqqkZx_1 < sizeof(T_ID) _xZkqqHx_iCmFiCkAiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			T_VALUE _xZkqqHx_iCmNiBeBjGlDiMpIiCmIjCgMiCpAiIoKiCmCiOjNiCmBiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmO_xHqqkZx_ T_VALUE = DWORD _xZkqqHx_iCmMiPoKiNiHiCmJ_xHqqkZx_ DWORD(-1) _xZkqqHx_iCmIiCmHiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeOiDgHiDiKiDeOiDiJiDfIiCmNiBeBiImIiJlKiCmMiCfBiCmCiCmMjAmDjDeJiKnGjAjEiCpAiOjNiCmBiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			static T_VALUE Invalid ()		:T_VALUE_xZkqqHx_iCmMjGlDiMpIiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			static void Delete (T_VALUE v)	:T_VALUE_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iClNiCmGiCkGiCmOiBeB_xHqqkZx_DWORD_xZkqqHx_iMfOiCmM_xHqqkZx_ID_xZkqqHx_iCmJjBmOiClFiCmEiBeB_xHqqkZx_char* _xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCkKiCkAiCoJiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiCmMiDhEiDeAiDeOiDgHiDiKiCmGiDgOiDgCiDfGiDiFiCmNiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *			----- _xZkqqHx_iDhEiDeAiDeOiDgHiDiK_xHqqkZx_ -----
 *			struct myHashFactory
 *			{
 *				inline static char* Invalid () { return NULL; }
 *				inline static void Delete (char* v) { free(v); }
 *				inline static char* New (const char* v) { return _strdup(v); }
 *			};
 *			----- _xZkqqHx_iDgOiDgCiDfGiDiF_xHqqkZx_ -----
 *			FCSimpleHash<DWORD, char*, myHashFactory> myhash;
 *			myhash.Set(10, myHashFactory::New("Hello"));
 *			myhash.Set(3, myHashFactory::New("World"));
 *			const char* cpHello = myhash.Get(10);
 *
 *			////////////////////////////////////////////////////////////////////////
 *
 *			FCSimpleHash _xZkqqHx_iCmNiBeB_xHqqkZx_T_ID_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiBeBiCfAiDgPiDeDiDgHiClIiCmCjAnIjCgGiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iKgFiDgPiDeDiDgHiCmMjCgMiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmGiClHiCoJjEhKjHpBiCmMiDgDiDiKiBfLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmO_xHqqkZx_T_ID_xZkqqHx_iCkK_xHqqkZx_DWORD_xZkqqHx_iCmMiPoKiNiHiBeBiImIiJlKiCmMiCoGiCkEiCmJiCfDjCgJiCmMiDgDiDiKiBfLiCkKiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKgFjCgJiCpAiNfMjAkMiClHiCoJiDeOiDiJiDfIiCmNiImIiJlKiBeC_xHqqkZx_
 *
 *       _xZkqqHx_iEkAiBkJ_xHqqkZx_SimpleHash_xZkqqHx_iBkIiEkAiBkJ_xHqqkZx_SimpleMiddleHash-_xZkqqHx_iBkIiEkAiBkJ_xHqqkZx_SimpleMiddleHash-_xZkqqHx_iBkIiEkAiBkJ_xHqqkZx_SimpleMiddleHash-_xZkqqHx_iBkIiEkAiBkJ_xHqqkZx_SimpleLastHash_xZkqqHx_iBkIiEkA_xHqqkZx_
 *       _xZkqqHx_iEkA_xHqqkZx_  TreeDepth=4 _xZkqqHx_iEkA_xHqqkZx_     TreeDepth=3     _xZkqqHx_iEkA_xHqqkZx_     TreeDepth=2     _xZkqqHx_iEkA_xHqqkZx_     TreeDepth=1     _xZkqqHx_iEkA_xHqqkZx_    TreeDepth=0   _xZkqqHx_iEkA_xHqqkZx_
 *
 *                 Top _xZkqqHx_iEjPiEkGiEjP_xHqqkZx_ m_aHash[0]_xZkqqHx_iEjPiEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aHash[0]_xZkqqHx_iEjPiEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aHash[0]_xZkqqHx_iEjPiEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aValue[0]
 *                       _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aHash[1]_xZkqqHx_iBgDiBgD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aValue[1]
 *                       _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                       _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                       _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aValue[255]
 *                       _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aHash[255]_xZkqqHx_iBgD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aHash[1]_xZkqqHx_iEjPiEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aValue[0]
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aValue[1]
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aValue[255]
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_               
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aHash[255]_xZkqqHx_iEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aValue[0]
 *                                              _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iEkA_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aValue[1]
 *                                              _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aValue[255]
 *                                              _xZkqqHx_iEkA_xHqqkZx_
 *                                              _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aHash[1]_xZkqqHx_iEjPiEjPiEjPiEjPiEkGiEjP_xHqqkZx_ m_aHash[0]_xZkqqHx_iEjPiEjPiEjPiEjPiEkG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iEkFiEjP_xHqqkZx_ m_aHash[1]_xZkqqHx_iEjPiEjPiEjPiEjPiEkG_xHqqkZx_
 *                                              _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkA_xHqqkZx_                     _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aHash[255]_xZkqqHx_iBgD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *                                                                     _xZkqqHx_iEkEiEjP_xHqqkZx_ m_aHash[255]_xZkqqHx_iEjPiEjPiEjPiEkG_xHqqkZx_
 *                                                                                            _xZkqqHx_iBeG_xHqqkZx_
 *
 *			_xZkqqHx_iDgDiDiKiBfLiCmMiCkEiClPiBeBjCgMiCkKjDpMiCmBiCmEiCkCiCmIiCkCiDgNiBfLiDgIiCmN_xHqqkZx_NULL_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template< class T_ID, class T_VALUE, class T_FACT = FCSimpleValueFactory<T_VALUE> >
class FCSimpleHash
{
public:
	FCSimpleHash ();
	~FCSimpleHash ();
	T_VALUE	Get (T_ID id) const;
	void	Set (T_ID id, T_VALUE v);
	BOOL	GetFreeId (T_ID& id) const;
	void	Clear ();
	BOOL	IsEmpty () const;
	BOOL	GetFirstId (T_ID& id) const;
	BOOL	GetNextId (T_ID& id) const;

private:
	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>	m_hashTop;	// _xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiNfMjBkCiCmMiDgHiDgCiDhGiBeC_xHqqkZx_
}; // class FCSimpleHash.

//////////////////////////////////////////////////////////////////////////////
// FCSimpleLastHash_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::FCSimpleLastHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::FCSimpleLastHash ()
{
	// _xZkqqHx_jEhKjHpBiClHiCnHiCmEiCmJiPiJiKpKjCgMiCmGiClFiCmEjGlDiMpIjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	for (long lC = 0; lC != 256; lC++)
		m_aValue[lC] = T_FACT::Invalid();
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_nUsedHashCount = 0;
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::FCSimpleLastHash ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCgMjEhKjHpBiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjHeMiMpIiCmIjCgMiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCpAiOgHiCmBiCmEjCgMiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
void FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Delete ()
{
	for (long lC = 0; lC != 256; lC++)
	{
		if (m_aValue[lC] != T_FACT::Invalid())
		//----- _xZkqqHx_jEhKjHpBjHhGjBgGiCmJjHeMiMpIiCmIjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCmJjCgMiCmMiNoNiPjMiCpAiImLjHiKiBeCiDiBiDiCiDiKiBfLjHmMiIoGiCmMiPoKiNiHiCmN_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiCmJjHmMiIoGiCpAiJpAiPjMiClDiClJiCoJiBeC_xHqqkZx_
			T_FACT::Delete(m_aValue[lC]);
			// _xZkqqHx_jGlDiMpIiCmIjCgMiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
			m_aValue[lC] = T_FACT::Invalid();
		}
	}
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_nUsedHashCount = 0;
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Delete ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClNiCmJjCgMiCpAiLeMjIfOiJmCjEfMiCmIiBeBiNmFiPiJiCmMjCgMjEhKjHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_jCgMjEhKjHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCpAiLeMjIfOiCmFiCkLiCoJiLpDiCkLjEhKjHpBiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEhKjHpBiCpAjBePiCkJiCoHiPiHiCmJiMjPiNpFiClFiBeBjCgMiCpAiLeMjIfOiJmCjEfMiCmIjHhGjBgGiCkKiMkJiCmCiCkJiCmBiClNiCoHiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id) const
{
	// _xZkqqHx_iLpDiCkLjEhKjHpBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (m_nUsedHashCount == 256) return FALSE;
	for (long lC = 0; lC != 256; lC++)
	{
		if (m_aValue[lC] == T_FACT::Invalid())
		//----- _xZkqqHx_jEhKjHpBjHhGjBgGiCmJjGlDiMpIiCmIjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// id_xZkqqHx_iCmJjGlDiMpIjCgMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
			id = T_ID(lC);
			return TRUE;
		}
	}
	// _xZkqqHx_iOgHjHhAiNmPiCnNiDeKiDeFiDjDiDfOiCmFiNmFiPiJiCmJiLpDiCkLiCkKiCkAiCoJiClBiCmGiCpAiKgNjEeGiClFiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmJiCkNiCoJiClBiCmGiCmNiCmIiCkCiCmNiClIiBeC_xHqqkZx_
	throw "FCSimpleHash Error. GetFreeId()";
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetNextId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHjClCiCnHiCmEiBeBiNmFiPiJiCmJjHeMiMpIiCmIjCgMiCkKiDhBiDgCiDgHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_jClCiCnHiOgOiCnPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	id_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjCgMiCkJiCoHjClCiCnHiOgOiCnPiCoJiClBiCmGiCmJjCiNiInDiBeCiCmCiCnMiCoIiBeB_xHqqkZx_id_xZkqqHx_iCmFiOhHjCoI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkKjHeMiMpIiCmFiCkAiCoKiCmOiBeBjDkPiClGjCgMiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id) const
{
	// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	for (long lC = long(BYTE(id)); lC != 256; lC++)
	{
		if (m_aValue[lC] != T_FACT::Invalid())
		//----- _xZkqqHx_jEhKjHpBjHhGjBgGiCmJjHeMiMpIiCmIjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// id_xZkqqHx_iCmJjHeMiMpIiCmIjCgMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			id = T_ID(lC);
			return TRUE;
		}
	}
	return FALSE;
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Get
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiBeCiDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			T_FACT::Invalid() _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
T_VALUE FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id) const
{
	return m_aValue[BYTE(id)];
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jCgMiCpAiOhHjCoIiBeCjCgMiCpAiDeOiDiKiDeBiClHiCoJiPoKiNiHiCmN_xHqqkZx_T_FACT::Invalid()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmFiOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClHiCmFiCmJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBePiCmMjCgMiCpAiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
short FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v)
{
	ASSERT(v != T_FACT::Invalid());
	// _xZkqqHx_iKpJjBlGiCmMjCgMiCkKiCkAiCoJiPoKiNiHiCmNiBeBiCnMiClIiNoNiPjMiBeC_xHqqkZx_
	if (m_aValue[BYTE(id)] != T_FACT::Invalid()) Unset(id);
	ASSERT(m_aValue[BYTE(id)] == T_FACT::Invalid());
	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_aValue[BYTE(id)] = v;
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiJmBiOfKiBeC_xHqqkZx_
	m_nUsedHashCount++;
	return m_nUsedHashCount;
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Unset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmFiOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmNjHeMiMpIiCmIjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
short FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Unset (T_ID id)
{
	ASSERT(m_aValue[BYTE(id)] != T_FACT::Invalid());
	T_FACT::Delete(m_aValue[BYTE(id)]);
	m_aValue[BYTE(id)] = T_FACT::Invalid();
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiMlIiOfKiBeC_xHqqkZx_
	m_nUsedHashCount--;
	return m_nUsedHashCount;
} // FCSimpleLastHash<T_ID, T_VALUE, T_FACT>::Unset (T_ID id).

//////////////////////////////////////////////////////////////////////////////
// FCSimpleMiddleHash_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::FCSimpleMiddleHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::FCSimpleMiddleHash ()
{
	memset(m_aHash, 0, sizeof(m_aHash));
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_nUsedHashCount = 0;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::FCSimpleMiddleHash ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Get
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id			:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiBeCiDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			T_FACT::Invalid() _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
T_VALUE FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id, size_t szTreeDepth) const
{
	szTreeDepth--;
	// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmJjBmOiJjOiClHiCoJiCfHiDhCiDgCiDgHjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const BYTE by = BYTE(id >> (8 * szTreeDepth));
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiDgOiDgCiDfGiDiFiCkKiLpDiCmMiPoKiNiHiCmNjGlDiMpIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	if (m_aHash[by] == NULL) return T_FACT::Invalid();
	if (szTreeDepth == 1)
		return ((const LAST_HASH*)(m_aHash[by]))->Get(id);
	else
		return ((const MIDDLE_HASH*)(m_aHash[by]))->Get(id, szTreeDepth);
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id, size_t szTreeDepth) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id			:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v			:_xZkqqHx_jCgMiCpAiOhHjCoIiBeCjCgMiCpAiDeOiDiKiDeBiClHiCoJiPoKiNiHiCmN_xHqqkZx_T_FACT::Invalid()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmFiOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClHiCmFiCmJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBePiCmMjCgMiCpAiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiDgOiDgCiDfGiDiFiDgNiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDgOiDgCiDfGiDiFiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmEiDgNiBfLiDgIiCmGiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
short FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v, size_t szTreeDepth)
{
	szTreeDepth--;
	// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmJjBmOiJjOiClHiCoJiCfHiDhCiDgCiDgHjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const BYTE by = BYTE(id >> (8 * szTreeDepth));
	if (szTreeDepth == 1)
	//----- _xZkqqHx_jAfLiClDiCfAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_aHash[by] == NULL)
		//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiDgOiDgCiDfGiDiFiCkKiLpDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgOiDgCiDfGiDiFiDgNiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			m_aHash[by] = (void*)(new LAST_HASH());
			// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiJmBiOfKiBeC_xHqqkZx_
			m_nUsedHashCount++;
		}
		// _xZkqqHx_iIoKjEnEiJlKiCmMjAfLiClDiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCpAjAnNjCoIiClDiClJiCoJiBeC_xHqqkZx_
		((LAST_HASH*)(m_aHash[by]))->Set(id, v);
	} else
	//----- _xZkqqHx_jAfLiClDiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_aHash[by] == NULL)
		//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiDgOiDgCiDfGiDiFiCkKiLpDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgOiDgCiDfGiDiFiDgNiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			m_aHash[by] = (void*)(new MIDDLE_HASH());
			// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiJmBiOfKiBeC_xHqqkZx_
			m_nUsedHashCount++;
		}
		// _xZkqqHx_iIoKiCmCiJlKiCmMjAfLiClDiCmMiDgOiDgCiDfGiDiFiCmJiNmEiLeBjDeJiCmJjCgMiCpAjAnNjCoIiClDiClJiCoJiBeC_xHqqkZx_
		((MIDDLE_HASH*)(m_aHash[by]))->Set(id, v, szTreeDepth);
	}
	return m_nUsedHashCount;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v, size_t szTreeDepth).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Unset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id			:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmFiOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmNjHeMiMpIiCmIjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iPmBiLiOiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkKjBkOiClHiCoJiDgOiDgCiDfGiDiFiDgNiBfLiDgIiCkKiLpDiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiDgOiDgCiDfGiDiFiDgNiBfLiDgIiImIiJlKiCmMiDgDiDiKiBfLiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCgMiCkKjDpMiCmBiCmEiCkCiCmIiCkCiDgOiDgCiDfGiDiFiDgNiBfLiDgIiCmNiNoNiPjMiClDiCoKiCoJiClNiCnPiBeBiDgOiDgCiDfGiDiFiDgNiBfLiDgIiCkK_xHqqkZx_
 *			_xZkqqHx_jBlGiNnNiClHiCoKiCmOiBeBiClLiCmMiJlKiCmJjFeLiClIjCgMiCkKjBlGiNnNiClHiCoJiCmGjElLjCgGiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
short FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Unset (T_ID id, size_t szTreeDepth)
{
	szTreeDepth--;
	// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmJjBmOiJjOiClHiCoJiCfHiDhCiDgCiDgHjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const BYTE by = BYTE(id >> (8 * szTreeDepth));
	ASSERT(m_aHash[by] != NULL);
	if (szTreeDepth == 1)
	//----- _xZkqqHx_jAfLiClDiCfAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iIoKjEnEiJlKiCmMjAfLiClDiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCpAjGjFiPmBiClDiClJiCoJiBeC_xHqqkZx_
		if (((LAST_HASH*)(m_aHash[by]))->Unset(id) == 0)
		//----- _xZkqqHx_jCgMiCpAjGjFiPmBiClFiClNiMiLiJmKiBeBjEhKjHpBiCkKiLpDiCmJiCmIiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiCmNiLpDiCmIiCmMiCmFiNoNiPjMiBeC_xHqqkZx_
			delete (LAST_HASH*)(m_aHash[by]);
			m_aHash[by] = NULL;
			// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiMlIiOfKiBeC_xHqqkZx_
			m_nUsedHashCount--;
		}
	} else
	//----- _xZkqqHx_jAfLiClDiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iIoKiCmCiJlKiCmMjAfLiClDiCmMiDgOiDgCiDfGiDiFiCmJiNmEiLeBjDeJiCmJjCgMiCpAjGjFiPmBiClDiClJiCoJiBeC_xHqqkZx_
		if (((MIDDLE_HASH*)(m_aHash[by]))->Unset(id, szTreeDepth) == 0)
		{
			// _xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiCmNiLpDiCmIiCmMiCmFiNoNiPjMiBeCiNfIiCmJiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmN_xHqqkZx_
			// _xZkqqHx_iClHiCmFiCmJiNoNiPjMiClDiCoKiCmEiCkCiCoJiCmNiClIiCmIiCmMiCmFiBeB_xHqqkZx_Delete_xZkqqHx_iKnGjAjEiCpAiOgHiCmBiCmE_xHqqkZx_
			// _xZkqqHx_iNmEiLeBjDeJiCmJiPmBiLiOiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
			delete (MIDDLE_HASH*)(m_aHash[by]);
			m_aHash[by] = NULL;
			// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiMlIiOfKiBeC_xHqqkZx_
			m_nUsedHashCount--;
		}
	}
	return m_nUsedHashCount;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Unset (T_ID id, T_VALUE v, size_t szTreeDepth).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiImIiJlKiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMjCgMiCmGiBeBjBfDiCmEiCmMiDgOiDgCiDfGiDiFiCpA_xHqqkZx_
 *			_xZkqqHx_jGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAfLiCkCjFpLiCnGiMpMiCkJiCmBiCmEiNmEiLeBjDeJiCmJiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
void FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Delete (size_t szTreeDepth)
{
	szTreeDepth--;
	if (szTreeDepth == 1)
	//----- _xZkqqHx_jAfLiClDiCfAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = 0; lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ----
			{
				// _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCpAiPmBiLiOiClDiClJiCoJiBeC_xHqqkZx_
				((LAST_HASH*)(m_aHash[lC]))->Delete();
				// _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
				delete (LAST_HASH*)(m_aHash[lC]);
				m_aHash[lC] = NULL;
			}
		}
	} else
	//----- _xZkqqHx_jAfLiClDiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = 0; lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ----
			{
				// _xZkqqHx_iJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJiNmEiLeBjDeJiCmJjCgMiCpAiNoNiPjMiClDiClJiCoJiBeC_xHqqkZx_
				((MIDDLE_HASH*)(m_aHash[lC]))->Delete(szTreeDepth);
				// _xZkqqHx_iJlKjBhHiCmMiDgOiDgCiDfGiDiFiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
				delete (MIDDLE_HASH*)(m_aHash[lC]);
				m_aHash[lC] = NULL;
			}
		}
	}
	// _xZkqqHx_iOgHjHhAiNmPiCnNiCmMjEhKjHpBjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_nUsedHashCount = 0;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::Delete (size_t szTreeDepth).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClNiCmJjCgMiCpAiLeMjIfOiJmCjEfMiCmIiBeBiNmFiPiJiCmMiDgOiDgCiDfGiDiFiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id			:_xZkqqHx_iDgOiDgCiDfGiDiFiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCpAiLeMjIfOiCmFiCkLiCoJiLpDiCkLjEhKjHpBiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEhKjHpBiCpAjBePiCkJiCoHiPiHiCmJiMjPiNpFiClFiBeBjCgMiCpAiLeMjIfOiJmCjEfMiCmIjHhGjBgGiCkKiMkJiCmCiCkJiCmBiClNiCoHiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			id_xZkqqHx_iCmJiCmNiBeBiMlLiNnNiCmMiImKjChFiCoGiCoIiJlKiCmMjAfLiClDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCjHoBiCkGiCmO_xHqqkZx_
 *			id_xZkqqHx_iCkK_xHqqkZx_DWORD_xZkqqHx_iMfOiCmFiCfDiDgPiDeDiDgHiCmMiPoKiNiHiCmJ_xHqqkZx_ szTreeDepth=3_xZkqqHx_iCmGiClHiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmMjAfLiClDiCmN_xHqqkZx_2_xZkqqHx_iBeCiCoGiCmBiCmE_xHqqkZx_ 2,1,0_xZkqqHx_iCmM_xHqqkZx_DWORD_xZkqqHx_iJlKiImKiCfCiDgPiDeDiDgHjFkKiCmM_xHqqkZx_ID_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClJiCmOiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id, size_t szTreeDepth) const
{
	szTreeDepth--;
	if (szTreeDepth == 1)
	//----- _xZkqqHx_jAfLiClDiCfAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = 0; lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJiLpDiCkLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiClDiClJiCoJiBeC_xHqqkZx_
				if (((const LAST_HASH*)(m_aHash[lC]))->GetFreeId(id))
				//----- _xZkqqHx_iLpDiCkLiDeDiDjDiDgGiDgCiDeOiDfIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
					id |= (T_ID(lC) << (8 * szTreeDepth));
					return TRUE;
				}
			} else
			//----- _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iLpDiCkLiDeDiDjDiDgGiDgCiDeOiDfIiCmNiNmFiPiJiCmMiCePiCmGiClHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
				id = (T_ID(lC) << (8 * szTreeDepth)) | 0x00;
				return TRUE;
			}
		}
	} else
	//----- _xZkqqHx_jAfLiClDiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = 0; lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJiLpDiCkLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiClDiClJiCoJiBeC_xHqqkZx_
				if (((const MIDDLE_HASH*)(m_aHash[lC]))->GetFreeId(id, szTreeDepth))
				{
					// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
					id |= (T_ID(lC) << (8 * szTreeDepth));
					return TRUE;
				}
			} else
			//----- _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCkKjGlDiMpIiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iLpDiCkLiDeDiDjDiDgGiDgCiDeOiDfIiCmNiNmFiPiJiCmMiCePiCmGiClHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
				id = (T_ID(lC) << (8 * szTreeDepth)) | 0x00;
				return TRUE;
			}
		}
	}
	return FALSE;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id, size_t szTreeDepth) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetNextId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHjClCiCnHiCmEiBeBiNmFiPiJiCmJjHeMiMpIiCmIjCgMiCkKiDhBiDgCiDgHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id			:_xZkqqHx_jClCiCnHiOgOiCnPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			szTreeDepth	:_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMiIoKiCmCiPoDiCmMiDgNiBfLiDgIiCmMjAfLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iIoKjEnEjAfLiCkCiDgDiDiKiBfLjGjGjCfLiCkKiCePiBeBiPoDiCmJiMpMiCkJiCmBiCmEiCfAiClIiCmCiJmBiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	id_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjCgMiCkJiCoHjClCiCnHiOgOiCnPiCoJiClBiCmGiCmJjCiNiInDiBeCiCmCiCnMiCoIiBeB_xHqqkZx_id_xZkqqHx_iCmFiOhHjCoI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkKjHeMiMpIiCmFiCkAiCoKiCmOiBeBjDkPiClGjCgMiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id, size_t szTreeDepth) const
{
	szTreeDepth--;
	if (szTreeDepth == 1)
	//----- _xZkqqHx_jAfLiClDiCfAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
		for (long lC = long(BYTE(id >> (8 * szTreeDepth))); lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJjCgMiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNmFiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMjPiNpFiClDiClJiCoJiBeC_xHqqkZx_
				if (((const LAST_HASH*)(m_aHash[lC]))->GetNextId(id))
				//----- _xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
					id |= (T_ID(lC) << (8 * szTreeDepth));
					return TRUE;
				}
			}
		}
	} else
	//----- _xZkqqHx_jAfLiClDiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
		for (long lC = long(BYTE(id >> (8 * szTreeDepth))); lC != 256; lC++)
		{
			if (m_aHash[lC] != NULL)
			//----- _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iIoKiCmCiJlKjBhHiCmMiDgOiDgCiDfGiDiFiCmJiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNmEiLeBjDeJiCmJiMjPiNpFiClDiClJiCoJiBeC_xHqqkZx_
				if (((const MIDDLE_HASH*)(m_aHash[lC]))->GetNextId(id, szTreeDepth))
				//----- _xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfDjDjGiClHiCoJiCfHiDhCiDgCiDgHjFkKiCpAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
					id |= (T_ID(lC) << (8 * szTreeDepth));
					return TRUE;
				}
			}
		}
	}
	return FALSE;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id, size_t szTreeDepth) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetUsedHashCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiDgNiBfLiDgIjClMiJlKiCmFiBeBiOgHiCoNiCoKiCmEiCkCiCoJiDgOiDgCiDfGiDiFjEhKjHpBiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCoJiDgOiDgCiDfGiDiFjEhKjHpBiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgDiDiKiBfLiCmMjAoGiCnMiCmFjAjEiCkGiCoJiCmMiCmFiCmNiCmIiCkNiBeBiClBiCmMiDgOiDgCiDfGiDiFiDgNiBfLiDgI_xHqqkZx_
 *			_xZkqqHx_iCmJjClMjAnKiCmCiCmIiCkKiCoJiDgNiBfLiDgIiCmMjAjEiClOiCkPiCpAjAjEiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
short FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetUsedHashCount () const
{
	return m_nUsedHashCount;
} // FCSimpleMiddleHash<T_ID, T_VALUE, T_FACT>::GetUsedHashCount () const.

//////////////////////////////////////////////////////////////////////////////
// FCSimpleHash_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::FCSimpleHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
FCSimpleHash<T_ID, T_VALUE, T_FACT>::FCSimpleHash ()
{
	if (sizeof(T_ID) <= 1)
		throw "FCSimpleHash Error. sizeof(Type) must be more than 1.";
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::FCSimpleHash ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::~FCSimpleHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
FCSimpleHash<T_ID, T_VALUE, T_FACT>::~FCSimpleHash ()
{
	m_hashTop.Delete(sizeof(T_ID));
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::~FCSimpleHash ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::Get
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiBeCiDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			T_FACT::Invalid() _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
T_VALUE FCSimpleHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id) const
{
	return m_hashTop.Get(id, sizeof(T_ID));
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::Get (T_ID id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jCgMiCpAiOhHjCoIiBeCjCgMiCpAiDeOiDiKiDeBiClHiCoJiPoKiNiHiCmN_xHqqkZx_T_FACT::Invalid()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClHiCmFiCmJjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBePiCmMjCgMiCpAiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
void FCSimpleHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v)
{
	if (v != T_FACT::Invalid())
		m_hashTop.Set(id, v, sizeof(T_ID));
	else
		m_hashTop.Unset(id, sizeof(T_ID));
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::Set (T_ID id, T_VALUE v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClNiCmJjCgMiCpAiLeMjIfOiJmCjEfMiCmIiBeBiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iDgOiDgCiDfGiDiFiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCpAiLeMjIfOiCmFiCkLiCoJiLpDiCkLjEhKjHpBiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEhKjHpBiCpAjBePiCkJiCoHiPiHiCmJiMjPiNpFiClFiBeBjCgMiCpAiLeMjIfOiJmCjEfMiCmIjHhGjBgGiCkKiMkJiCmCiCkJiCmBiClNiCoHiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id) const
{
	return m_hashTop.GetFreeId(id, sizeof(T_ID));
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFreeId (T_ID& id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMjCgMiCmGiBeBjBfDiCmEiCmMiDgOiDgCiDfGiDiFiCpA_xHqqkZx_
 *			_xZkqqHx_jGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAfLiCkCjFpLiCnGiMpMiCkJiCmBiCmEiNmEiLeBjDeJiCmJiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
void FCSimpleHash<T_ID, T_VALUE, T_FACT>::Clear ()
{
	m_hashTop.Delete(sizeof(T_ID));
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::Clear ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiCmJiIoKiCmCiCoAjCgMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCoAjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleHash<T_ID, T_VALUE, T_FACT>::IsEmpty () const
{
	return (m_hashTop.GetUsedHashCount() == 0);
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::IsEmpty () const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFirstId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmJjHeMiMpIiCmIjCgMiCkKiDhBiDgCiDgHiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_iNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFirstId (T_ID& id) const
{
	T_ID idFirst = 0;
	if (!m_hashTop.GetNextId(idFirst, sizeof(T_ID))) return FALSE;
	id = idFirst;
	return TRUE;
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetFirstId (T_ID& id) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetNextId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiOjPiCkJiCoHjClCiCnHiCmEiBeBiNmFiPiJiCmJjHeMiMpIiCmIjCgMiCkKiDhBiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	id	:_xZkqqHx_jClCiCnHiOgOiCnPiCoJjClMjBePiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_ID, class T_VALUE, class T_FACT>
BOOL FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id) const
{
	T_ID idNext = id + 1;
	if (!m_hashTop.GetNextId(idNext, sizeof(T_ID))) return FALSE;
	id = idNext;
	return TRUE;
} // FCSimpleHash<T_ID, T_VALUE, T_FACT>::GetNextId (T_ID& id) const.

#endif//__SimpleHash_h
