// SpnHiUnit.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMath.h"		// For hix2histr.etc.
#include "UtilWin.h"		// For FFGetWindowText.
#include "RegData.h"		// For hix2mm,mm2hix.
#include "SpnHiUnit.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFCSpnHiUnit

CFCSpnHiUnit::CFCSpnHiUnit ()
{
	m_mmDelta = 0.5;	// _xZkqqHx_jBjNiMlIjCfAiImKiBeCiDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_0.5mm_xZkqqHx_iBeC_xHqqkZx_
	m_hiLower = 0.0;
	m_hiUpper = 100.0;
} // CFCSpnHiUnit::CFCSpnHiUnit.

CFCSpnHiUnit::~CFCSpnHiUnit ()
{
} // CFCSpnHiUnit::~CFCSpnHiUnit.


BEGIN_MESSAGE_MAP(CFCSpnHiUnit, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCSpnHiUnit)
	ON_NOTIFY_REFLECT(UDN_DELTAPOS, OnDeltapos)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCSpnHiUnit _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSpnHiUnit::SetDelta
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBjNiMlIjCfAiImKiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDelta	:_xZkqqHx_jBjNiMlIjCfAiImKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSpnHiUnit::SetDelta (mmetol mmDelta)
{
	m_mmDelta = mmDelta;
} // CFCSpnHiUnit::SetDelta.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSpnHiUnit::SetRange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhDiDjDiDhLiDfOiDjDiCmMjCgMiCmMiPoDiMmAiBeFiJlKiMmAjCgMiCpAjAnNjCoIiClHiCoJiBeCjCgMiCmMjCfAiImKiCkKiOmAiNmAjFfHiCmF_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmLower	:_xZkqqHx_iJlKiMmAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmUpper	:_xZkqqHx_iPoDiMmAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSpnHiUnit::SetRange (mmetol mmLower, mmetol mmUpper)
{
	m_hiLower = mm2hi(mmLower);
	m_hiUpper = mm2hi(mmUpper);
	if (mmLower < mmUpper)	BASE_CLASS::SetRange(0, 100);
	else					BASE_CLASS::SetRange(100, 0);
} // CFCSpnHiUnit::SetRange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSpnHiUnit::GetRange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhDiDjDiDhLiDfOiDjDiCmMjCgMiCmMiPoDiMmAiBeFiJlKiMmAjCgMiCpAjFnEiClHiBeCjCgMiCmMjCfAiImKiCkKiOmAiNmAjFfHiCmF_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmLower	:_xZkqqHx_iJlKiMmAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmUpper	:_xZkqqHx_iPoDiMmAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSpnHiUnit::GetRange (mmetol &mmLower, mmetol& mmUpper) const
{
	mmLower = hi2mm(m_hiLower);
	mmUpper = hi2mm(m_hiUpper);
} // CFCSpnHiUnit::GetRange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSpnHiUnit::MovePos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhDiDjDiDhLiDfOiDjDiCkKjFhEjBkOiClHiCoJiDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiMlLiNnNjCgMiCpAjFmPiNfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nInc	:_xZkqqHx_jFmPiNfIiClHiCoJjHmKiCpAiOhHjCoIiBeCiOmAiNnLiCmNiClBiCoKiCmJjCfAiImKiMgOiCmMiMfHjAjEiCpAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSpnHiUnit::MovePos (int nInc)
{
	if (nInc == 0) return;

	CWnd* pBuddy = GetBuddy();
	if (pBuddy == NULL) return;

	wchar_t tcsBuf[100];
	FFGetWindowText(pBuddy, tcsBuf, 100);
	hic hiCurPos = wcstod(tcsBuf, NULL);
	// _xZkqqHx_jAfGiClFiCkCiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
	hixc hixUnit = hixroundoff(mm2hix(m_mmDelta));
	hic hiNewPos = hix2hi(hixUnit * (D2LL(double(hi2hix(hiCurPos)) / double(hixUnit)) + nInc));

	if (m_hiLower < m_hiUpper)
	{
		if (hiNewPos < m_hiLower)	hiNewPos = m_hiLower;
		if (m_hiUpper < hiNewPos)	hiNewPos = m_hiUpper;
	} else
	{
		if (hiNewPos < m_hiUpper)	hiNewPos = m_hiUpper;
		if (m_hiLower < hiNewPos)	hiNewPos = m_hiLower;
	}
	if (hiNewPos != hiCurPos)
	{
		hix2histr(tcsBuf, hi2hix(hiNewPos));
		FFSetWindowText(pBuddy, tcsBuf);
	}
} // CFCSpnHiUnit::MovePos.

/////////////////////////////////////////////////////////////////////////////
// CFCSpnHiUnit _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

void CFCSpnHiUnit::OnDeltapos (NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	MovePos(pNMUpDown->iDelta);

	*pResult = 0;
} // CFCSpnHiUnit::OnDeltapos.
