// StcEmfImage.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilStr.h"		// For GetResString.
#include "UtilFont.h"		// For FFGetStdFont.
#include "ObjFigure.h"		// For FDOF_EMFMAP_HORZ_SIZE.etc..
#include "StcEmfImage.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCStcEmfImage

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::CFCStcEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcEmfImage::CFCStcEmfImage ()
{
	m_hEMF = NULL;	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	m_byEmfHorzMap = FDOF_EMFMAP_HORZ_SIZE;		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
	m_byEmfVertMap = FDOF_EMFMAP_VERT_SIZE;		// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
	m_emidEmfImage = FD_EMF_IMAGE_UNSPECIFY;	// EmfImageID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_UNUSE,UNSPECIFY_xZkqqHx_jHhAiBeC_xHqqkZx_

	m_pxMarginL = 0;		// _xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiNlGjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	m_pxMarginT = 0;		// _xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiPoDjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	m_pxMarginR = 0;		// _xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJeFjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	m_pxMarginB = 0;		// _xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJlKjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
} // CFCStcEmfImage::CFCStcEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::~CFCStcEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcEmfImage::~CFCStcEmfImage ()
{
	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjEgKiKpMiBeC_xHqqkZx_
	if (m_hEMF != NULL) ::DeleteEnhMetaFile(m_hEMF);
	m_hEMF = NULL;
	m_byEmfHorzMap = FDOF_EMFMAP_HORZ_SIZE;		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
	m_byEmfVertMap = FDOF_EMFMAP_VERT_SIZE;		// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
	m_emidEmfImage = FD_EMF_IMAGE_UNSPECIFY;	// EmfImageID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_UNUSE,UNSPECIFY_xZkqqHx_jHhAiBeC_xHqqkZx_
} // CFCStcEmfImage::~CFCStcEmfImage.

/////////////////////////////////////////////////////////////////////////////
// CFCStcEmfImage_xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetEmfHorzMap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHiCmMjAiFjFlNjFpLiMpMiCmMiDhNiDgCiDhGjFpLjGeAiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byEmfHorzMap	:_xZkqqHx_iDhNiDgCiDhGjFpLjGeAiBeC_xHqqkZx_ObjFigure.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetEmfHorzMap (BYTE byEmfHorzMap)
{
	m_byEmfHorzMap = byEmfHorzMap;	// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
} // CFCStcEmfImage::SetEmfHorzMap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetEmfVertMap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHiCmMjAiCjClMjFpLiMpMiCmMiDhNiDgCiDhGjFpLjGeAiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byEmfVertMap	:_xZkqqHx_iDhNiDgCiDhGjFpLjGeAiBeC_xHqqkZx_ObjFigure.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetEmfVertMap (BYTE byEmfVertMap)
{
	m_byEmfVertMap = byEmfVertMap;	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDhNiDgCiDhGiBeC_xHqqkZx_
} // CFCStcEmfImage::SetEmfVertMap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClHiCoJiDiBiDfOiDhEiDeAiDeDiDiLiDeDiDiBiBfLiDfHiCmM_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	emidEmfImage	:ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetEmfImage (EmfImageID emidEmfImage)
{
	if (emidEmfImage != FD_EMF_IMAGE_UNUSE &&
		emidEmfImage != FD_EMF_IMAGE_UNSPECIFY)
		SetEmfImage(g_pEnv->GetEmfImageRec(emidEmfImage)->m_bypEmfBits,
					g_pEnv->GetEmfImageRec(emidEmfImage)->m_lEmfBitsSz);
	else
		SetEmfImage(NULL, 0);
	m_emidEmfImage = emidEmfImage;	// EmfImageID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_UNUSE,UNSPECIFY_xZkqqHx_jHhAiBeC_xHqqkZx_
} // CFCStcEmfImage::SetEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClHiCoJiDiBiDfOiDhEiDeAiDeDiDiLiDeDiDiBiBfLiDfHiCmMiDgGiBfLiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypData		:_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiBeC_xHqqkZx_
 *			lDataSize	:bypData_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetEmfImage (const BYTE* bypData, long lDataSize)
{
	if (m_hEMF != NULL) ::DeleteEnhMetaFile(m_hEMF);
	m_hEMF = NULL;
	if (bypData != NULL)
		m_hEMF = ::SetEnhMetaFileBits(lDataSize, bypData);
	m_emidEmfImage = FD_EMF_IMAGE_UNSPECIFY;	// EmfImageID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_UNUSE,UNSPECIFY_xZkqqHx_jHhAiBeC_xHqqkZx_
} // CFCStcEmfImage::SetEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClHiCoJiDiBiDfOiDhEiDeAiDeDiDiLiDeDiDiBiBfLiDfHiCmMiDgOiDjDiDgIiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hEMF	:_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDgOiDjDiDgIiDiLiCmNiClBiCmMiDeOiDiJiDfIjDoAjFjEiCmFiKmHjHjNiClDiCoKiCoJiCoGiCkEiCmJiCmIiCoJiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iImIiNhOiCmNiKePjFjEiBgJjAnNjCoIjBkEiBgKiCmFiOgHjHhAiClFiClNiCoIiJpAjFpKiClFiClNiCoIiClFiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetEmfImage (HENHMETAFILE hEMF)
{
	if (m_hEMF != NULL) ::DeleteEnhMetaFile(m_hEMF);
	m_hEMF = hEMF;
	m_emidEmfImage = FD_EMF_IMAGE_UNSPECIFY;	// EmfImageID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_UNUSE,UNSPECIFY_xZkqqHx_jHhAiBeC_xHqqkZx_
} // CFCStcEmfImage::SetEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::GetEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGjCiGiCmMiDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HENHMETAFILE CFCStcEmfImage::GetEmfImage () const
{
	return m_hEMF;
} // CFCStcEmfImage::GetEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::SetMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiClHiCoJiNnLiCmMiDhNiBfLiDfHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pxMarginL	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiNlGjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginT	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiPoDjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginR	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJeFjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginB	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJlKjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::SetMargin (long pxMarginL,
								long pxMarginT,
								long pxMarginR,
								long pxMarginB)
{
	m_pxMarginL = pxMarginL;
	m_pxMarginT = pxMarginT;
	m_pxMarginR = pxMarginR;
	m_pxMarginB = pxMarginB;
} // CFCStcEmfImage::SetMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::FlickerFreeDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClPiCoHiCmCiCkLjGlDiCkNjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCkJiCoHjFgAiJoGiClHiCoJiCgEiCgMiCgFiCmMiDhCiDgCiDgHiDhNiDgCiDhGiDeDiDiBiBfLiDfHiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKiCmJiCmNiDhCiDgCiDgHiDhNiDgCiDhGiDeDiDiBiBfLiDfHiCpAjDfNjBjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nEffect		:_xZkqqHx_jFgAiJoGiClHiCoJiNnLiCmMiMpIiJmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *				0	:_xZkqqHx_iJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
 *				1	:_xZkqqHx_iNlGiCkJiCoHiJeFiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::FlickerFreeDraw (short nEffect)
{
	// _xZkqqHx_iDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CClientDC dc(this);
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoMjAkMiBeC_xHqqkZx_
	CBitmap bitmap;
	MakeBitmap(&bitmap, &dc, rtClient, m_pxMarginL, m_pxMarginT, m_pxMarginR, m_pxMarginB);
	// _xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiCpAiJoGjGmKiCmJjDfNjBjHiBeC_xHqqkZx_
	CDC dcMem;
	dcMem.CreateCompatibleDC(&dc);
	CBitmap* bmppOld = dcMem.SelectObject(&bitmap);
	FCAutoDC atDC(&dc, FALSE, 0, 0);

	switch (nEffect)
	{
	case 0:	// _xZkqqHx_jCmKiPoNiCmMjFfMiOkGiBeC_xHqqkZx_
	  {
		for (long lY = rtClient.top; lY < rtClient.bottom; lY += 10)
		{
			long lBottom = (rtClient.bottom < lY + 10) ? rtClient.bottom : lY + 10;
			atDC.BitBlt(rtClient.left, lY,
						rtClient.Width(), lBottom,
						&dcMem, rtClient.left, lY, SRCCOPY);
		}
		break;
	  }
	case 1:	// _xZkqqHx_iNlGiCkJiCoHiJeFiCnGiBeC_xHqqkZx_
	  {
		for (long lX = rtClient.right; lX != rtClient.left;)
		{
			lX -= 10;
			if (lX < rtClient.left)
				lX = rtClient.left;
			atDC.BitBlt(lX, rtClient.top,
						rtClient.right - lX, rtClient.Height(),
						&dcMem, rtClient.left + 4, rtClient.top, SRCCOPY);
			Sleep(10);
		}
		atDC.BitBlt(rtClient.left, rtClient.top,
					rtClient.Width(), rtClient.Height(),
					&dcMem, rtClient.left + 4, rtClient.top, SRCCOPY);
		break;
	  }
	}
	dcMem.SelectObject(bmppOld);
	dcMem.DeleteDC();
} // CFCStcEmfImage::FlickerFreeDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::DrawImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_CDC_xZkqqHx_iCmJiBeBiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjAoGiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClient:_xZkqqHx_jFgAiJoGjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::DrawImage (CDC* pDC, CRect rtClient) const
{
//----- 06.03.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmJjBmOiJjOiClFiCmE_xHqqkZx_SaveDC_xZkqqHx_iBeC_xHqqkZx_
//	FCAutoDC atDC(pDC, TRUE, 0, 0);
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//	CRgn rgn;
//	rgn.CreateRectRgn(	rtClient.left, rtClient.top,
//						rtClient.right, rtClient.bottom);
//	atDC.SetClipRgn(&rgn);
//----- 06.03.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
//----- 06.03.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeCjEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeC_xHqqkZx_
	atDC.FillRect(rtClient, FCAtBrush(::GetSysColor(COLOR_3DFACE)));
	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_hEMF != NULL)
	{
		CRect rtImage;	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiLoJiMgAiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMjEhKjChFiCkKiDfEiDeDiDfJjFmPiNfIiCmFjGlDiCkCiPoKiNiHiCmNiBeBiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
		if (m_byEmfHorzMap != FDOF_EMFMAP_HORZ_SIZE ||
			m_byEmfVertMap != FDOF_EMFMAP_VERT_SIZE)
		{
			// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
			ENHMETAHEADER header;
			::GetEnhMetaFileHeader(m_hEMF, sizeof(ENHMETAHEADER), &header);
			// header.rclFrame_xZkqqHx_iCmN_xHqqkZx_0.01mm_xZkqqHx_jCfAiImKiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiBgJ_xHqqkZx_MSDN_xZkqqHx_iCmM_xHqqkZx_0.1mm_xZkqqHx_iCmNiMoLjAeBiBgKiBeC_xHqqkZx_
			// header.rclFrame_xZkqqHx_iCpAiDgGiDeCiDfIiDhGiDiMiDeDiDgGiDgPiDeDiDfIiCmM_xHqqkZx_pixel_xZkqqHx_jCfAiImKiCmJjFmPiKlHiBeC_xHqqkZx_
			rtImage.left = D2L((header.rclFrame.left / 100.0) * g_->dDisplayPPM);
			rtImage.top = D2L((header.rclFrame.top / 100.0) * g_->dDisplayPPM);
			rtImage.right = D2L((header.rclFrame.right / 100.0) * g_->dDisplayPPM);
			rtImage.bottom = D2L((header.rclFrame.bottom / 100.0) * g_->dDisplayPPM);
		}
		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmFiBeBjFgAiJoGjHmMiIoGjBfDjBmMiCmJiDiBiDfOiDhEiDeAiDeDiDiLjFgAiJoGiCpAiOhHjCoIiBeC_xHqqkZx_
		CRect rtMap = rtClient;
		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDfEiDeDiDfJiNiHiCoNiClJiPiIjHjNiBeC_xHqqkZx_
		switch (m_byEmfHorzMap)
		{
		case FDOF_EMFMAP_HORZ_LEFT:		// _xZkqqHx_iNlGiCmJiKpBiClJiCoJiBeC_xHqqkZx_
		case FDOF_EMFMAP_HORZ_TILE:		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDfOiDeDiDiKiDjDiDePiBeC_xHqqkZx_
			rtMap.right = rtMap.left + rtImage.Width();
			break;
		case FDOF_EMFMAP_HORZ_RIGHT:	// _xZkqqHx_iJeFiCmJiKpBiClJiCoJiBeC_xHqqkZx_
			rtMap.left = rtMap.right - rtImage.Width();
			rtMap.right = rtMap.left + rtImage.Width();
			break;
		case FDOF_EMFMAP_HORZ_CENTER:	// _xZkqqHx_jCiGiJjLiCmJjEhKjChFiBeC_xHqqkZx_
			rtMap.left += (rtMap.Width() - rtImage.Width()) / 2;
			rtMap.right = rtMap.left + rtImage.Width();
			break;
		}
		// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfEiDeDiDfJiNiHiCoNiClJiPiIjHjNiBeC_xHqqkZx_
		switch (m_byEmfVertMap)
		{
		case FDOF_EMFMAP_VERT_TOP:		// _xZkqqHx_iPoDiCmJiKpBiClJiCoJiBeC_xHqqkZx_
		case FDOF_EMFMAP_VERT_TILE:		// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfOiDeDiDiKiDjDiDePiBeC_xHqqkZx_
			rtMap.bottom = rtMap.top + rtImage.Height();
			break;
		case FDOF_EMFMAP_VERT_BOTTOM:	// _xZkqqHx_iJlKiCmJiKpBiClJiCoJiBeC_xHqqkZx_
			rtMap.top = rtMap.bottom - rtImage.Height();
			rtMap.bottom = rtMap.top + rtImage.Height();
			break;
		case FDOF_EMFMAP_VERT_CENTER:	// _xZkqqHx_jCiGiJjLiCmJjEhKjChFiBeC_xHqqkZx_
			rtMap.top += (rtMap.Height() - rtImage.Height()) / 2;
			rtMap.bottom = rtMap.top + rtImage.Height();
			break;
		}
		CRect rtTmp = rtMap;
		do
		{
			do
			{
				// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCpAjFgAiJoGiBeC_xHqqkZx_
				::PlayEnhMetaFile(pDC->m_hDC, m_hEMF, rtTmp);
				rtTmp.left += rtImage.Width();
				rtTmp.right += rtImage.Width();
			} while (m_byEmfHorzMap == FDOF_EMFMAP_HORZ_TILE &&
					 rtTmp.left < rtClient.right);
			rtTmp.left = rtMap.left;
			rtTmp.right = rtMap.right;
			rtTmp.top += rtImage.Height();
			rtTmp.bottom += rtImage.Height();
		} while (m_byEmfVertMap == FDOF_EMFMAP_VERT_TILE &&
				 rtTmp.top < rtClient.bottom);
	} else
	if (m_emidEmfImage == FD_EMF_IMAGE_UNSPECIFY)
	{
		long lSize = rtClient.Height() < rtClient.Width() ? rtClient.Height() : rtClient.Width();
		lSize /= 2;
		if (30 < lSize) lSize = 30;
		LOGFONT logFont = FFGetStdFont();
		logFont.lfHeight = -lSize;
		atDC.SetFont(&logFont);
		atDC.SetTextColor(FD_COLREF_BLACK);
		atDC.SetBkMode(TRANSPARENT);
		atDC.DrawText(GetResWString(IDS_NOT_CHANGE), CP_ACP, &rtClient, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
	} else
	if (m_emidEmfImage == FD_EMF_IMAGE_UNUSE)
	{
		long lSize = rtClient.Height() < rtClient.Width() ? rtClient.Height() : rtClient.Width();
		lSize /= 2;
		if (30 < lSize) lSize = 30;
		LOGFONT logFont = FFGetStdFont();
		logFont.lfHeight = -lSize;
		atDC.SetFont(&logFont);
		atDC.SetTextColor(FD_COLREF_BLACK);
		atDC.SetBkMode(TRANSPARENT);
		atDC.DrawText(GetResWString(IDS_NOT_USE), CP_ACP, &rtClient, DT_CENTER|DT_VCENTER|DT_SINGLELINE);
	}
} // CFCStcEmfImage::DrawImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::MakeBitmap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmFjHfOiCkGiCoHiCoKiClN_xHqqkZx_CBitmap_xZkqqHx_iCmJiClBiCmMiCgEiCgMiCgFiCmMjFgAiJoG_xHqqkZx_Bitmap_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBitmap		:Bitmap_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJ_xHqqkZx_CBitmap_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *			pDC			:Bitmap_xZkqqHx_iCpAiNoMiCoJiInHiCmM_xHqqkZx_CDC_xZkqqHx_iCpAiNoMiCoJiInHiCmMiMlEjGhLiBeC_xHqqkZx_
 *			rtClient	:_xZkqqHx_iNoMjAkMiClDiCoKiCoJiDhCiDgCiDgHiDhNiDgCiDhGjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginL	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiNlGjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginT	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiPoDjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginR	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJeFjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxMarginB	:_xZkqqHx_jFgAiJoGiClHiCoJiDeDiDiBiBfLiDfHiCmMiJlKjBkEiDhNiBfLiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::MakeBitmap (	CBitmap* pBitmap,
									CDC* pDC,
									const CRect& rtClient,
									long pxMarginL,
									long pxMarginT,
									long pxMarginR,
									long pxMarginB) const
{
	CDC dcMem;
	dcMem.CreateCompatibleDC(pDC);
	if (pBitmap->m_hObject != NULL)
		pBitmap->DeleteObject();
	// _xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoMjAkMiBeC_xHqqkZx_
	pBitmap->CreateBitmap(rtClient.Width(), rtClient.Height(), 1, g_nBitsPixel, NULL);
	(void)dcMem.SelectObject(pBitmap);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiMlEjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	dcMem.SetWindowOrg(rtClient.left, rtClient.top);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJjHmMiIoGiCpAiNoMjAkMiBeC_xHqqkZx_
	CRect rtImage = rtClient;
	rtImage.DeflateRect(pxMarginL, pxMarginT, pxMarginR, pxMarginB);
	// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawImage(&dcMem, rtImage);
	// dcMem_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	dcMem.DeleteDC();
} // CFCStcEmfImage::MakeBitmap.

BEGIN_MESSAGE_MAP(CFCStcEmfImage, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcEmfImage)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcEmfImage _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcEmfImage::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcEmfImage::OnPaint ()
{
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmJjBmOiJjOiClFiCmE_xHqqkZx_SaveDC_xZkqqHx_iBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	CRgn rgn;
	rgn.CreateRectRgn(	rtClient.left, rtClient.top,
						rtClient.right, rtClient.bottom);
	atDC.SetClipRgn(&rgn);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJjHmMiIoGiCpAiNoMjAkMiBeC_xHqqkZx_
	CRect rtImage = rtClient;
	rtImage.DeflateRect(m_pxMarginL, m_pxMarginT, m_pxMarginR, m_pxMarginB);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawImage(&dc, rtImage);
} // CFCStcEmfImage::OnPaint.
