// StcImageList.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "UtilGraph.h"		// For FCAutoDC.
#include "StcImageList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const long CFCStcImageList::SEPARATOR = -1;
const long CFCStcImageList::DROPDOWN = -2;

const DWORD CFCStcImageList::STYLE_LEFT			= (0x00000001 << 0);
const DWORD CFCStcImageList::STYLE_HORZ_CENTER	= (0x00000001 << 1);
const DWORD CFCStcImageList::STYLE_RIGHT		= (0x00000001 << 2);
const DWORD CFCStcImageList::STYLE_TOP			= (0x00000001 << 3);
const DWORD CFCStcImageList::STYLE_VERT_CENTER	= (0x00000001 << 4);
const DWORD CFCStcImageList::STYLE_BOTTOM		= (0x00000001 << 5);
const DWORD CFCStcImageList::STYLE_HALF_DROPDOWN= (0x00000001 << 6);


static const long FD_DROPDOWN_ICON_WIDTH = 32;
static const long FD_DROPDOWN_ICON_HEIGHT = 32;
static const long FD_SEPARATOR_ICON_WIDTH = 32;
static const long FD_SEPARATOR_ICON_HEIGHT = 32;

static const long FD_DRAWING_WIDTH = 28;
static const long FD_DRAWING_HEIGHT = 26;

static const long FD_DROPDOWN_DRAWING_WIDTH = 32;
static const long FD_SEPARATOR_DRAWING_WIDTH = 8;


/////////////////////////////////////////////////////////////////////////////
// CFCStcImageList

CFCStcImageList::CFCStcImageList ()
{
	m_dwStyle = STYLE_LEFT | STYLE_TOP;
	m_hIconSeparator = FFGetApp()->LoadIcon(IDI_TOOLBAR_SEPARATOR);
	m_hIconDropdownL = FFGetApp()->LoadIcon(IDI_TOOLBAR_DROPDOWN_L);
	m_hIconDropdownR = FFGetApp()->LoadIcon(IDI_TOOLBAR_DROPDOWN_R);
	// _xZkqqHx_jBeJjBpAiDeDiDiBiBfLiDfHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lCurSel = -1;
}

CFCStcImageList::~CFCStcImageList()
{
}

/////////////////////////////////////////////////////////////////////////////
// CFCStcImageList _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::SetStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::SetStyle (DWORD dwStyle)
{
	m_dwStyle = dwStyle;
} // CFCStcImageList::SetStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::SetBitmap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::SetBitmap (UINT uiBitmapId, CSize szImageSize, int iImageCount, COLORREF crMask)
{
	m_imageList.Create(uiBitmapId, szImageSize.cx, iImageCount, crMask);
	m_szImageSize = szImageSize;
} // CFCStcImageList::SetBitmap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::SetImageIndexList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::SetImageIndexList (const long* aImageList, long lListCount)
{
	m_vImageList.assign(aImageList, aImageList + lListCount);
	// _xZkqqHx_jBeJjBpAiDeDiDiBiBfLiDfHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_lCurSel = -1;
} // CFCStcImageList::SetImageIndexList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::DrawImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::DrawImage (CDC* pDC, long lImageIndex, const CRect& rtImage, BOOL bIsDrawBack, BOOL bIsDrawSel)
{
	FCAutoDC atDC(pDC, FALSE, 0, 0);
	if (bIsDrawBack)
		atDC.FillRect(rtImage, FCAtBrush(::GetSysColor(COLOR_BTNFACE)));

	if (lImageIndex == SEPARATOR)
	{
		long lGapX = (FD_SEPARATOR_DRAWING_WIDTH - FD_SEPARATOR_ICON_WIDTH) / 2;
		long lGapY = (FD_DRAWING_HEIGHT - FD_SEPARATOR_ICON_HEIGHT) / 2;
		atDC.DrawIconEx(rtImage.left + lGapX,
						rtImage.top + lGapY,
						m_hIconSeparator,
						FD_SEPARATOR_ICON_WIDTH,
						FD_SEPARATOR_ICON_HEIGHT,
						0, NULL, DI_NORMAL);
	} else
	if (lImageIndex == DROPDOWN)
	{
		if (m_dwStyle & STYLE_HALF_DROPDOWN)
		{
			long lGapX = (FD_DROPDOWN_DRAWING_WIDTH - FD_DROPDOWN_ICON_WIDTH) / 2;
			long lGapY = (FD_DRAWING_HEIGHT - FD_DROPDOWN_ICON_HEIGHT) / 2;
			atDC.DrawIconEx(rtImage.left + lGapX,
							rtImage.top + lGapY,
							m_hIconDropdownR,
							FD_DROPDOWN_ICON_WIDTH,
							FD_DROPDOWN_ICON_HEIGHT,
							0, NULL, DI_NORMAL);
		} else
		{
			long lGapX = FD_DROPDOWN_DRAWING_WIDTH - FD_DROPDOWN_ICON_WIDTH;
			long lGapY = (FD_DRAWING_HEIGHT - FD_DROPDOWN_ICON_HEIGHT) / 2;
			atDC.DrawIconEx(rtImage.left + lGapX,
							rtImage.top + lGapY,
							m_hIconDropdownL,
							FD_DROPDOWN_ICON_WIDTH,
							FD_DROPDOWN_ICON_HEIGHT,
							0, NULL, DI_NORMAL);
			atDC.DrawIconEx(rtImage.left + lGapX + FD_DROPDOWN_ICON_WIDTH,
							rtImage.top + lGapY,
							m_hIconDropdownR,
							FD_DROPDOWN_ICON_WIDTH,
							FD_DROPDOWN_ICON_HEIGHT,
							0, NULL, DI_NORMAL);
		}
	} else
	{
		long lGapX = (FD_DRAWING_WIDTH - m_szImageSize.cx) / 2;
		long lGapY = (FD_DRAWING_HEIGHT - m_szImageSize.cy) / 2;
		m_imageList.Draw(	pDC,
							lImageIndex,
							CPoint(rtImage.left + lGapX, rtImage.top + lGapY),
							ILD_NORMAL);
	}
	if (bIsDrawSel)
	{
		atDC.DrawFocusRect(rtImage);
	}
} // CFCStcImageList::DrawImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::SetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::SetCurSel (long lCurSel, BOOL bIsRedrawNow)
{
	if (bIsRedrawNow)
	{
		if (m_lCurSel != -1)
			m_stRedrawSel.insert(m_lCurSel);
		if (lCurSel != -1)
			m_stRedrawSel.insert(lCurSel);
		m_lCurSel = lCurSel;
		if (!m_stRedrawSel.empty())
			RedrawWindow();
	} else
	{
		m_lCurSel = lCurSel;
	}
} // CFCStcImageList::SetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::EnumImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCStcImageList::EnumImage (FPEnumImageProc proc, const CPoint& ptLeftTop, const CRect& rtFrame, void* pData)
{
	long lX = ptLeftTop.x;
	long lY = ptLeftTop.y;
	long lIndex;
	for (lIndex = 0; lIndex != m_vImageList.size();)
	{
		// _xZkqqHx_jFgAiJoGjHmMiIoGiCmMiJlKiCkKiDhEiDiMiBfLiDiAiCpAiCmNiCnNiPgPiClHiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (rtFrame.bottom < lY + FD_DRAWING_HEIGHT) break;

		long lWidth;
		if (m_vImageList[lIndex] == SEPARATOR)
		{
			lWidth = FD_SEPARATOR_DRAWING_WIDTH;
		} else
		if (m_vImageList[lIndex] == DROPDOWN)
		{
			if (m_dwStyle & STYLE_HALF_DROPDOWN)
				lWidth = FD_DROPDOWN_DRAWING_WIDTH;
			else
				lWidth = 2 * FD_DROPDOWN_DRAWING_WIDTH;
		} else
		{
			lWidth = FD_DRAWING_WIDTH;
		}
		// lX != ptLeftTop.x _xZkqqHx_iCmNjFeLjAhLiBeC_xHqqkZx_1_xZkqqHx_iNhDiCmJ_xHqqkZx_1_xZkqqHx_iCmCiCoAiOpLiCnMiCoHiCmIiCkCiPoKiNiHiBeB_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCkKjGlDiCkCiCmGjGlDiMmAiDiLiBfLiDhGiCmJiKnHiCoJiClNiCnPiBeC_xHqqkZx_
		if (lX != ptLeftTop.x && rtFrame.right < lX + lWidth)
		//----- _xZkqqHx_jFgAiJoGjHmMiIoGiCmMiJeFiCkKiDhEiDiMiBfLiDiAiCpAiCmNiCnNiPgPiClHiPoKiNiH_xHqqkZx_ -----
		{
			// lX_xZkqqHx_iCmNiPiJiKpKiJlLiBeC_xHqqkZx_lY_xZkqqHx_iCmNiJlKiCnGiClIiCoHiClHiBeC_xHqqkZx_
			lX = ptLeftTop.x;
			lY += FD_DRAWING_HEIGHT;
			continue;
		}
		CRect rtImage(lX, lY, lX + lWidth, lY + FD_DRAWING_HEIGHT);
		int iReturn = 0;
		if ((rtImage & rtFrame) == rtImage)
			iReturn = (*proc)(this, lIndex, m_vImageList[lIndex], CRect(lX, lY, lX + lWidth, lY + FD_DRAWING_HEIGHT), pData);
		if (iReturn != 0)
			return iReturn;
		lX += lWidth;
		lIndex++;
	}
	return 0;
} // CFCStcImageList::EnumImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::EnumImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCStcImageList::EnumImage (FPEnumImageProc proc, void* pData)
{
	struct my
	{
		my () : m_szFrame(0, 0) {}
		static int EnumImageProc (	CFCStcImageList* pStcImageList,
									long lIndex,
									long lImageIndex,
									const CRect& rtImage,
									void* pData)
		{
			my* pMy = (my*)pData;
			if (pMy->m_szFrame.cx < rtImage.right)
				pMy->m_szFrame.cx = rtImage.right;
			if (pMy->m_szFrame.cy < rtImage.bottom)
				pMy->m_szFrame.cy = rtImage.bottom;
			return 0;
		}
		CSize m_szFrame;
	} data;

	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_iDfEiDeDiDfJiMhGiOfKiBeC_xHqqkZx_
	EnumImage(my::EnumImageProc, CPoint(0, 0), CRect(0, 0, rtClient.right, LONG_MAX), &data);
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_ LEFT-TOP_xZkqqHx_iBeC_xHqqkZx_
	CPoint ptLeftTop(0, 0);
	if (m_dwStyle & STYLE_HORZ_CENTER)
	{
		ptLeftTop.x = (rtClient.Width() - data.m_szFrame.cx) / 2;
	} else
	if (m_dwStyle & STYLE_RIGHT)
	{
		ptLeftTop.x = rtClient.Width() - data.m_szFrame.cx;
	}
	if (m_dwStyle & STYLE_VERT_CENTER)
	{
		ptLeftTop.y = (rtClient.Height() - data.m_szFrame.cy) / 2;
	} else
	if (m_dwStyle & STYLE_BOTTOM)
	{
		ptLeftTop.y = rtClient.Height() - data.m_szFrame.cy;
	}
	return EnumImage(proc, ptLeftTop, rtClient, pData);
} // CFCStcImageList::EnumImage.

BEGIN_MESSAGE_MAP(CFCStcImageList, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcImageList)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcImageList _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

void CFCStcImageList::OnPaint ()
{
//----- 06.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
//	struct mySize
//	{
//		mySize () : m_szFrame(0, 0) {}
//		static int CalcSizeProc (	CFCStcImageList* pStcImageList,
//									long lIndex,
//									long lImageIndex,
//									const CRect& rtImage,
//									void* pData)
//		{
//			mySize* pMy = (mySize*)pData;
//			if (pMy->m_szFrame.cx < rtImage.right)
//				pMy->m_szFrame.cx = rtImage.right;
//			if (pMy->m_szFrame.cy < rtImage.bottom)
//				pMy->m_szFrame.cy = rtImage.bottom;
//			return 0;
//		}
//		CSize	m_szFrame;
//	} dataSize;
//
//	struct myDraw
//	{
//		myDraw (CDC* pDC, const longSet& stRedrawSel, long lCurSel) : m_pDC(pDC), m_stRedrawSel(stRedrawSel), m_lCurSel(lCurSel) {}
//		static int DrawImageProc (	CFCStcImageList* pStcImageList,
//									long lIndex,
//									long lImageIndex,
//									const CRect& rtImage,
//									void* pData)
//		{
//			myDraw* pMy = (myDraw*)pData;
//			if (pMy->m_stRedrawSel.empty())
//			{
//				pStcImageList->DrawImage(pMy->m_pDC, lImageIndex, rtImage, FALSE, pMy->m_lCurSel == lIndex);
//			} else
//			{
//				if (pMy->m_stRedrawSel.find(lIndex) != pMy->m_stRedrawSel.end())
//				{
//					pStcImageList->DrawImage(pMy->m_pDC, lImageIndex, rtImage, TRUE, pMy->m_lCurSel == lIndex);
//				}
//			}
//			return 0;
//		}
//		CDC* 	m_pDC;
//		longSet	m_stRedrawSel;
//		long	m_lCurSel;
//	} dataDraw(&dc, m_stRedrawSel, m_lCurSel);
//
//	CRect rtClient;
//	GetClientRect(rtClient);
//
//	// _xZkqqHx_jEhHiMgJjFgAiJoGiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeCjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
//	if (m_stRedrawSel.empty())
//		dc.FillRect(rtClient, &CBrush(::GetSysColor(COLOR_BTNFACE)));
//
//	// _xZkqqHx_iDfEiDeDiDfJiMhGiOfKiBeC_xHqqkZx_
//	EnumImage(mySize::CalcSizeProc, CPoint(0, 0), CRect(0, 0, rtClient.right, LONG_MAX), &dataSize);
//	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_ LEFT-TOP_xZkqqHx_iBeC_xHqqkZx_
//	CPoint ptLeftTop(0, 0);
//	if (m_dwStyle & STYLE_HORZ_CENTER)
//	{
//		ptLeftTop.x = (rtClient.Width() - dataSize.m_szFrame.cx) / 2;
//	} else
//	if (m_dwStyle & STYLE_RIGHT)
//	{
//		ptLeftTop.x = rtClient.Width() - dataSize.m_szFrame.cx;
//	}
//	if (m_dwStyle & STYLE_VERT_CENTER)
//	{
//		ptLeftTop.y = (rtClient.Height() - dataSize.m_szFrame.cy) / 2;
//	} else
//	if (m_dwStyle & STYLE_BOTTOM)
//	{
//		ptLeftTop.y = rtClient.Height() - dataSize.m_szFrame.cy;
//	}
//
//	// _xZkqqHx_iDeDiDiBiBfLiDfHjFgAiJoGiBeC_xHqqkZx_
//	EnumImage(myDraw::DrawImageProc, ptLeftTop, rtClient, &dataDraw);
//	m_stRedrawSel.clear();
//----- 06.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	struct my
	{
		my (CDC* pDC, const longSet& stRedrawSel, long lCurSel) : m_pDC(pDC), m_stRedrawSel(stRedrawSel), m_lCurSel(lCurSel) {}
		static int EnumImageProc (	CFCStcImageList* pStcImageList,
									long lIndex,
									long lImageIndex,
									const CRect& rtImage,
									void* pData)
		{
			my* pMy = (my*)pData;
			if (pMy->m_stRedrawSel.empty())
			{
				pStcImageList->DrawImage(pMy->m_pDC, lImageIndex, rtImage, FALSE, pMy->m_lCurSel == lIndex);
			} else
			{
				if (pMy->m_stRedrawSel.find(lIndex) != pMy->m_stRedrawSel.end())
				{
					pStcImageList->DrawImage(pMy->m_pDC, lImageIndex, rtImage, TRUE, pMy->m_lCurSel == lIndex);
				}
			}
			return 0;
		}
		CDC* 	m_pDC;
		longSet	m_stRedrawSel;
		long	m_lCurSel;
	} data(&dc, m_stRedrawSel, m_lCurSel);

	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jEhHiMgJjFgAiJoGiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeCjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	if (m_stRedrawSel.empty())
		dc.FillRect(rtClient, &CBrush(::GetSysColor(COLOR_BTNFACE)));
	// _xZkqqHx_iDeDiDiBiBfLiDfHjFgAiJoGiBeC_xHqqkZx_
	EnumImage(my::EnumImageProc, &data);
	m_stRedrawSel.clear();
//----- 06.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcImageList::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcImageList::OnLButtonDown (UINT nFlags, CPoint point)
{
	struct my
	{
		my (const CPoint& pt) : m_pt(pt) {}
		static int EnumImageProc (	CFCStcImageList* pStcImageList,
									long lIndex,
									long lImageIndex,
									const CRect& rtImage,
									void* pData)
		{
			my* pMy = (my*)pData;
			if (rtImage.PtInRect(pMy->m_pt))
				return (lIndex + 1);
			return 0;
		}
		CPoint	m_pt;
		
	} data(point);

	long lIndex = EnumImage(my::EnumImageProc, &data);
	if (lIndex != 0)
	{
		lIndex--;
		if (GetOwner() != NULL)
		{
			GetOwner()->SendMessage(WM_USER_IMGLST_SELCHANGED,
									(WPARAM)GetDlgCtrlID(),
									(LPARAM)lIndex);
		} else
		if (GetParent() != NULL)
		{
			GetParent()->SendMessage(WM_USER_IMGLST_SELCHANGED,
									(WPARAM)GetDlgCtrlID(),
									(LPARAM)lIndex);
		}
	}
	BASE_CLASS::OnLButtonDown(nFlags, point);
}

