// StcProgressBar.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilGraph.h"		// For OptiColor.
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "StcProgressBar.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FD_SPB_AREA_NUMBER	20

/////////////////////////////////////////////////////////////////////////////
// CFCStcProgressBar _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::CFCStcProgressBar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcProgressBar::CFCStcProgressBar ()
{
	// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_colLeft = ::OptiColor(FD_COLREF_BLACK);
	m_colRight = ::OptiColor(FD_COLREF_BLACK);
	m_dProgressValue = 0.0;
} // CFCStcProgressBar::CFCStcProgressBar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::~CFCStcProgressBar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcProgressBar::~CFCStcProgressBar ()
{
} // CFCStcProgressBar::~CFCStcProgressBar.

/////////////////////////////////////////////////////////////////////////////
// CFCStcProgressBar _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	colLeft	:_xZkqqHx_iNlGjBkEiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			colRight:_xZkqqHx_iJeFjBkEiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dValue	:_xZkqqHx_jAgJjClLjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcProgressBar::Initialize (COLORREF colLeft, COLORREF colRight, double dValue)
{
	// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_colLeft = colLeft;
	m_colRight = colRight;
	m_dProgressValue = dValue;
} // CFCStcProgressBar::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::GetProgressValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAgJjClLjCgMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAgJjClLjCgMiBeC_xHqqkZx_0_xZkqqHx_iBgA_xHqqkZx_100(%)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double CFCStcProgressBar::GetProgressValue () const
{
	return m_dProgressValue;
} // CFCStcProgressBar::GetProgressValue.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::SetProgressValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAgJjClLjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dValue	:_xZkqqHx_jAgJjClLjCgMiCpAjAnNjCoIiBeC_xHqqkZx_0_xZkqqHx_iBgA_xHqqkZx_100(%)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAgJjClLjCgMiBeC_xHqqkZx_0_xZkqqHx_iBgA_xHqqkZx_100(%)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFjFfMiOkGiOjOiCmNiBeBiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcProgressBar::SetProgressValue (double dValue)
{
	if (IsWindowVisible())
	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (dValue < m_dProgressValue)
		//----- _xZkqqHx_jCgMiCkKiPkMiClDiCkNiCmIiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBfDjBmMiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iNmEjFgAiJoGiCmMiClNiCnPiCmJiBeBjAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
			m_dProgressValue = dValue;
			// _xZkqqHx_jBkGiOjOiNmEjFgAiJoGiBeC_xHqqkZx_
			RedrawWindow();
		} else
		//----- _xZkqqHx_jCgMiCkKjBoFiCkLiCkNiCmIiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBjNiCkGiClNjFkKiClOiCkPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
			CClientDC dc(this);
			CRectVector vRect;
			vector<COLORREF> vColor;
			// _xZkqqHx_jBjNiCkGiClNjFjEjFkKiClOiCkPiOoGjDlOiBeC_xHqqkZx_
			GetFillRect(vRect, vColor, m_dProgressValue, dValue);
			// _xZkqqHx_jBjNiCkGiClNjFkKiClOiCkPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
			for (long lC = 0; lC < vRect.size(); lC++)
				dc.FillRect(vRect[lC], &CBrush(vColor[lC]));
		}
	}
	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dProgressValue = dValue;
} // CFCStcProgressBar::SetProgressValue.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::GetFillRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjAgJjClLjCgMiCmMjEmNiImNiCmMiBeBiLoJiMgAiCmGjAeGiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vRect		:_xZkqqHx_iLoJiMgAjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vColor		:_xZkqqHx_jAeGjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			dValueFrom	:_xZkqqHx_jAgJjClLiCmMiKeKiOgOjCgMiCpAiOhHjCoIiBeCjEmNiImNiCmNiClBiCmMjCgMiCpAiKnMiCnOiBeC_xHqqkZx_
 *			dValueUntil	:_xZkqqHx_jAgJjClLiCmMiPeJjHlJjCgMiCpAiOhHjCoIiBeCjEmNiImNiCmNiClBiCmMjCgMiCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_area0 = colLeft, area7 = colRight_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iBhJiCgAiBhKiCmMiPoKiNiHiBeB_xHqqkZx_dValueFrom_xZkqqHx_iCmG_xHqqkZx_dValueUntil_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iBhJiCgBiBhKiCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *         _xZkqqHx_iBhJjAgJjClLiDgPiBfLiCmMjBfDjBmMiCgAiBhK_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_area0 _xZkqqHx_iEkL_xHqqkZx_area1 _xZkqqHx_iEkL_xHqqkZx_area2 _xZkqqHx_iEkL_xHqqkZx_area3 _xZkqqHx_iEkL_xHqqkZx_area4 _xZkqqHx_iEkL_xHqqkZx_area5 _xZkqqHx_iEkL_xHqqkZx_area6 _xZkqqHx_iEkL_xHqqkZx_area7 _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkO_xHqqkZx_
 *                      _xZkqqHx_iBkK_xHqqkZx_                              _xZkqqHx_iBkK_xHqqkZx_
 *                  dValueFrom                      dValueUntil
 *
 *                     _xZkqqHx_iBhJjFnEjCgMiCgBiBhK_xHqqkZx_
 *                      _xZkqqHx_iEkMiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkKiEkKiElBiEkKiEkN_xHqqkZx_
 *                      _xZkqqHx_iEkL_xHqqkZx_0 _xZkqqHx_iEkL_xHqqkZx_  1   _xZkqqHx_iEkL_xHqqkZx_  2   _xZkqqHx_iEkL_xHqqkZx_  3   _xZkqqHx_iEkL_xHqqkZx_4 _xZkqqHx_iEkL_xHqqkZx_
 *                      _xZkqqHx_iEkPiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkKiEkKiElDiEkKiEkO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcProgressBar::GetFillRect (CRectVector& vRect, vector<COLORREF>& vColor, double dValueFrom, double dValueUntil) const
{
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jCiNiBgK_xHqqkZx_	rtClinet_xZkqqHx_iCmM_xHqqkZx_ right _xZkqqHx_iCmG_xHqqkZx_ bottom _xZkqqHx_iCmNiBeBiDeFiDeCiDjDiDgIiDeFiCmMiDhEiDiMiBfLiDiAiCmJjEoNiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
	//		FillRect _xZkqqHx_iCmNiBeB_xHqqkZx_left, top _xZkqqHx_iCmNjDgIiCoIiCmCiCnEiClHiCkKiBeB_xHqqkZx_right, bottom _xZkqqHx_iCmNjDgIiCoIiCmCiCnEiClDiCmIiCkCiBeC_xHqqkZx_
	double dAreaWidth = double(rtClient.Width()) / double(FD_SPB_AREA_NUMBER);
	long lValueFrom = D2L(double(rtClient.Width()) * dValueFrom);
	long lValueUntil = D2L(double(rtClient.Width()) * dValueUntil);
	long lArea;
	long lLeft = lValueFrom;
	long lRight;
	for (lArea = 0; lArea != FD_SPB_AREA_NUMBER; lArea++)
	{
		lRight = D2L(dAreaWidth * double(lArea + 1));
		if (lValueFrom < lRight) break;
	}
	for (; lArea != FD_SPB_AREA_NUMBER; lArea++)
	{
		lRight = D2L(dAreaWidth * double(lArea + 1));
		if (lValueUntil < lRight) break;
		vRect.push_back(CRect(	rtClient.left + lLeft,
								rtClient.top,
								rtClient.left + lRight,
								rtClient.bottom));
		vColor.push_back(FFGetMiddleColor(double(lArea) / double(FD_SPB_AREA_NUMBER - 1), m_colLeft, m_colRight));
		lLeft = lRight;
	}
	vRect.push_back(CRect(	rtClient.left + lLeft,
							rtClient.top,
							rtClient.left + lValueUntil,
							rtClient.bottom));
	vColor.push_back(FFGetMiddleColor(double(lArea) / double(FD_SPB_AREA_NUMBER - 1), m_colLeft, m_colRight));
} // CFCStcProgressBar::GetFillRect.

/////////////////////////////////////////////////////////////////////////////
// CFCStcProgressBar _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_

BEGIN_MESSAGE_MAP(CFCStcProgressBar, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcProgressBar)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcProgressBar _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcProgressBar::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcProgressBar::OnPaint ()
{
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_

	CRectVector vRect;
	vector<COLORREF> vColor;
	GetFillRect(vRect, vColor, 0.0, m_dProgressValue);
	for (long lC = 0; lC < vRect.size(); lC++)
	{
		dc.FillRect(vRect[lC], &CBrush(vColor[lC]));
	}

	// _xZkqqHx_jFgAiJoGjHhAiDiBiDgCiDfKiBfLiDfHiCmGiClFiCmE_xHqqkZx_ CStatic::OnPaint() _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiCmNiCkCiCkPiCnMiClJiCpB_xHqqkZx_
} // CFCStcProgressBar::OnPaint.
