// TolBrSheet.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "FoundDoc.h"			// For g_pDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "SheetManager.h"		// For FCSheetManager.
#include "UtilWin.h"			// For FFAddString.
#include "ToolBase.h"			// For GetCurrentTool.
#include "HiCommandTable.h"		// For FD_CMD_XXXX.
#include "TolBrSheet.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMjFjNiBeC_xHqqkZx_
static const int s_nBoxWidth = 150;
// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMjFjNiBeC_xHqqkZx_
static const int s_nDroppedWidth = 250;
// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMiNiCiClDiBeC_xHqqkZx_
static const int s_nDroppedHeight = 500;

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrSheet

CFCTolBrSheet::CFCTolBrSheet ()
{
} // CFCTolBrSheet::CFCTolBrSheet.

CFCTolBrSheet::~CFCTolBrSheet ()
{
} // CFCTolBrSheet::~CFCTolBrSheet.

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrSheet _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCTolBrSheet::Initialize ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::Initialize()) return FALSE;
	// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDfGiBfLiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	m_bIsSheetChanged = FALSE;

	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDgGiBfLiDfOiCpAiNfIjAfGiBeC_xHqqkZx_
	OnSheetUpdated();
	// _xZkqqHx_jAlDiPoNiPeJjHlJiBeC_xHqqkZx_
	return TRUE;
} // CFCTolBrSheet::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnSheetUpdated
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCkKiNfIjAfGiClDiCoKiClNiOjOiCmJiDhEiDiMiBfLiDiAiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::OnSheetUpdated ()
{
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDgGiBfLiDfOiCpAiNfIjAfGiBeC_xHqqkZx_
	m_cmbCurSheet.ResetContent();
	long lCurIdx = CB_ERR;
	for (long lC = 0; lC < g_pDoc->GetSheetManager()->GetSheetIndexSize(); lC++)
	{
		SheetID stid = g_pDoc->GetSheetManager()->SheetIndexToID(lC);
		WString wstrName;
		g_pDoc->SheetManager()->GetSheetInfo(wstrName, stid);
		WString str;
		str.Format(L"%d.%s", lC + 1, wstrName.c_str());
		int iIdx = FFAddString(&m_cmbCurSheet ,str);
		m_cmbCurSheet.SetItemData(iIdx, stid);
		if (g_pDoc->GetCurrentSheetId() == stid) lCurIdx = lC;
	}
	// _xZkqqHx_iMlLiNnNjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbCurSheet.SetCurSel(lCurIdx);
} // CFCTolBrSheet::OnSheetUpdated.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::GetCmbButtonInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiDhLiDfOiDjDiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iPoOjFpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiDhLiDfOiDjDiCmMiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCoKiImIiPoDiDhLiDfOiDjDiCmMiPoOjFpBiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_FCCmbButtonInfo::pCmb = NULL
 *			_xZkqqHx_iCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const CFCTolBrBase::FCCmbButtonInfo& CFCTolBrSheet::GetCmbButtonInfo (long lIndex)
{
	static FCCmbButtonInfo s_info[] =
	{
		{	&m_cmbCurSheet,						// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFmPjAjEiBeC_xHqqkZx_
			ID_CMB_CURRENT_SHEET,				// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			CBS_DROPDOWNLIST,					// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjCmHiJmBiDfIiDfOiDeDiDiLiBeC_xHqqkZx_WS_VISIBLE|WS_VSCROLL|WS_TABSTOP _xZkqqHx_iCmNjFfHiPiAiBeC_xHqqkZx_
			s_nBoxWidth,						// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjFjNiBeC_xHqqkZx_
			s_nDroppedWidth,					// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMjFjNiBeC_xHqqkZx_
			s_nDroppedHeight },					// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMiNiCiClDiBeC_xHqqkZx_

		{	NULL,								// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFmPjAjEiBeC_xHqqkZx_
			0,									// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			0,									// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjCmHiJmBiDfIiDfOiDeDiDiLiBeC_xHqqkZx_WS_VISIBLE|WS_VSCROLL|WS_TABSTOP _xZkqqHx_iCmNjFfHiPiAiBeC_xHqqkZx_
			0,									// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjFjNiBeC_xHqqkZx_
			0,									// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMjFjNiBeC_xHqqkZx_
			0 },								// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMiNiCiClDiBeC_xHqqkZx_
	};
	return s_info[lIndex];
} // CFCTolBrSheet::GetCmbButtonInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnCmdSessionEnded
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CommandGate_xZkqqHx_iCmMiDfKiDgCiDfGiDiHiDjDiPeJjHlJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::OnCmdSessionEnded ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnCmdSessionEnded();
	if (m_bIsSheetChanged)
	{
		OnSheetUpdated();
		// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDfGiBfLiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
		m_bIsSheetChanged = FALSE;
	}
} // CFCTolBrSheet::OnCmdSessionEnded.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnCommandCalled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CommandGate_xZkqqHx_iCmFiDfCiDhNiDjDiDgIiCkKiPiIjHjNiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	gateCmd	:_xZkqqHx_iDfCiDhNiDjDiDgIiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iDfCiDhNiDjDiDgIiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::OnCommandCalled (FTGateCmd gateCmd, LPARAM lParam)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnCommandCalled(gateCmd, lParam);
	switch (gateCmd)
	{
	case FD_CMD_INSERT1_SHEET:				// _xZkqqHx_iCfAiDfGiBfLiDgHiCpAjCmHiJmBiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_DELETE1_SHEET:				// _xZkqqHx_iCfAiDfGiBfLiDgHiCpAiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_SHEET:				// _xZkqqHx_iCfAiDfGiBfLiDgHiCpAjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_RE_ORDER_SHEET:				// _xZkqqHx_iDfGiBfLiDgHiCmMjFmAiCnHjBnGiCkGiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDfGiBfLiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
		m_bIsSheetChanged = TRUE;
		break;
	}
} // CFCTolBrSheet::OnCommandCalled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::SetPopHintTargetInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJiDfOiBfLiDfBiDgCiDgHiCmMiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmNiClLiCmMiCnMiCnMiDhMiDgCiDhGiDhBiDjDiDgHiCmJ_xHqqkZx_ID_xZkqqHx_iCpAjDgOiClJiCmOiNmPiCnOiCmMiClOiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iDfGiBfLiDgHiDgDiBfLiDiLiDgPiBfLiCmFiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFmPiNfIiClFiCmEjDgOiClFiClNiCkCiPoKiNiHiCkK_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiCmMiCmFiClBiCmMiKnGjAjEiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::SetPopHintTargetInfo (DWORD dwId) const
{
	// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiCmMiPoKiNiHiCmNiBeBiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFmPiNfIiBeC_xHqqkZx_
	if ((g_->appMode & FD_APPMODE_MASK) == FD_APPMODE_ARROWEDITOR &&
		dwId == ID_CMB_CURRENT_SHEET)
		dwId = ID_CMB_CURRENT_ARROW_SHEET;
	BASE_CLASS::SetPopHintTargetInfo(dwId);
} // CFCTolBrSheet::SetPopHintTargetInfo.

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrSheet _xZkqqHx_iDiGiBfLiDfFiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_

//----- 05.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::CalcFixedLayout
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmFjCoIiDfEiDeDiDfJiCmMiMhGiOfKiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiOoFiCmJiDgIiDgCiDeOiClDiCoKiCoJiCmGiCkLiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//CSize CFCTolBrSheet::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
//{
//	if (bHorz)
//	//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDgIiDgCiDeOiOjO_xHqqkZx_ ------
//	{
//		// _xZkqqHx_jGhLjHiIiBeBiClBiCmMiPiIjHjNiCmNjFhDjHhGiCmIiCmMiClOiCkKiBeBiPgDjFpLiMpMiCmJjAeMiCmOiClFiClNiDhEiDiNiBfLiDgHiDgDiBfLiDiLiDgPiBfL_xHqqkZx_
//		// _xZkqqHx_iCpAiDgIiDgCiDeOiClFiCoGiCkEiCmGiClHiCoJiCmGiBeBjFjEjFgJiCkKiCkEiCnMiCkN_xHqqkZx_SEPARATOR_xZkqqHx_iImKjChFiCmJiInKjDkOiClFiCmIiCkCiClNiCnPiBeC_xHqqkZx_
//		FCWndAndId wid[] =
//		{
//			{ &m_cmbCurSheet, ID_CMB_CURRENT_SHEET },
//		};
//		::FFHorznizeToolBar(this, wid, sizeof(wid) / sizeof(wid[0]));
//	}
//	return BASE_CLASS::CalcFixedLayout(bStretch, bHorz);
//} // CFCTolBrSheet::CalcFixedLayout.
//----- 05.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnUpdateCmdUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ _xZkqqHx_iDgPiBfLiCnMiClNiCmNiDfIiDgFiBfLiDfOiDfI_xHqqkZx_ _xZkqqHx_iDgPiBfLiCmMiPpDjBnEiCpAiNfIjAfGiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkKiMmEiCnBiPgPiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTarget	:_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDiBiDeDiDjD_xHqqkZx_ _xZkqqHx_iDhEiDiMiBfLiDiAiCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *			bDisableIfNoHndler :_xZkqqHx_iNfIjAfGiDgOiDjDiDgIiDiJiCpAiOjNiCmBiCmEiCkCiCmIiCkCiDfCiDjDiDgHiDiNiBfLiDiLiCpA_xHqqkZx_
 *								_xZkqqHx_iOkJjDkOjDeJiCmJiLnGiOhOiPpDjBnEiCmFjFfMiOkGiClHiCoJiCkJiCmHiCkEiCkJiCpAiOkGiClHiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::OnUpdateCmdUI (CFrameWnd* pTarget, BOOL bDisableIfNoHndler)
{
//----------<NOT EXPORT TO VIEWER>-----------
	if (::IsWindow(m_hWnd))
	{
		m_cmbCurSheet.EnableWindow(g_pView->GetCurrentTool()->CanMoveCurrentSheet());
	}
//----------</NOT EXPORT TO VIEWER>-----------
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnUpdateCmdUI(pTarget, bDisableIfNoHndler);
} // CFCTolBrSheet::OnUpdateCmdUI.

BEGIN_MESSAGE_MAP(CFCTolBrSheet, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCTolBrSheet)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(ID_CMB_CURRENT_SHEET, OnSelchangeCmbCurrentSheet)
	ON_MESSAGE(WM_USER_SHEET_CHANGED, OnUserSheetUpdated)
	ON_MESSAGE(WM_USER_CURRENT_SHEET_CHANGED, OnUserSheetUpdated)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrSheet _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnSelchangeCmbCurrentSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiBeBiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrSheet::OnSelchangeCmbCurrentSheet ()
{
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiMoDiCmJjGpAiKiE_xHqqkZx_Id_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	const int iIdx = m_cmbCurSheet.GetCurSel();
	g_pView->GetCurrentTool()->OnMoveCurrentSheet(m_cmbCurSheet.GetItemData(iIdx));
} // CFCTolBrSheet::OnSelchangeCmbCurrentSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrSheet::OnUserSheetUpdated
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCkKiNfIjAfGiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCTolBrSheet::OnUserSheetUpdated (WPARAM wParam, LPARAM lParam)
{
	OnSheetUpdated();
	return 1;
} // CFCTolBrSheet::OnUserSheetUpdated.

