#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ObjGroup.h"		// For FCObjGroup.
#include "ObjPoly.h"		// For FCPolyLinkRec.
#include "ObjArc.h"			// For FCArcRec.
#include "ObjWidePoly.h"	// For FCObjWidePoly.
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDrawView.h"// For g_pView.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilStr.h"		// For GetResString.
#include "UtilStdLib.h"		// For m1_for.
#include "UtilGraph.h"		// For FCEditDraw.
#include "UtilObj.h"		// For GetResizeFrame.
#include "UtilWin.h"		// For FFGetMenuString.
#include "TextOut.h"		// For FDRC_AL_NONE.
#include "SearchParser.h"	// For FCSearchParser.
#include "RegData.h"		// For FCRegData.
#include "PrsObjProperty.h"	// For CFCPrsObjProperty.
#include "PrsToolProperty.h"// For CFCPrsToolProperty.
#include "MainFrame.h"		// For MoveRulerMMK etc.
#include "LinkManager.h"	// For FCMolipRec.
#include "DlgTextLine.h"	// For CFCDlgTextLine.
#include "RichText.h"		// For FCRichText.
#include "DlgTextMargin.h"	// For CFCDlgTextMargin.
// 05.07.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "DlgPasteOverAs.h"	// For CFCDlgPasteOverAs.
#include "DlgCrossSheet.h"	// For CFCDLgCrossSheet.
#include "DlgLayerOrder.h"	// For CFCDlgLayerOrder.
#include "DlgSheetOrder.h"	// For CFCDlgSheetOrder.
#include "DlgFindText.h"	// For CFCDlgFindText.
#include "DlgReplaceText.h"	// For CFCDlgReplaceText.
#include "DlgFontSelect.h"	// For CFCDlgFontSelect.
#include "DlgRotate.h"		// For CFCDlgRotate.
#include "FrameWnd.h"		// For FFGetMainWnd().
// 05.09.14 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "PursuerText.h"	// For CFCPursuerText.
#include "WndRichEdit.h"	// For GetRTFEditor().
#include "HiProject.h"	// For g_pProject.
#include "ToolBase.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------<NOT EXPORT TO VIEWER>-----------

auto_ptr<CFCDlgFindText>	FCToolBase::m_atpFindDlg;	// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
auto_ptr<CFCDlgReplaceText>	FCToolBase::m_atpReplaceDlg;// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
auto_ptr<FCSearchParser>	FCToolBase::m_pSp;			// _xZkqqHx_iMjPiNpFiDeHiDjDiDfHiDjDiBeC_xHqqkZx_
BOOL		FCToolBase::m_bFirstSearch = TRUE;		// _xZkqqHx_iNmFiPiJiCmMiMjPiNpFiBeI_xHqqkZx_
WString		FCToolBase::m_strCurFindText;			// _xZkqqHx_iMjPiNpFjFlGiOjKjHpBiBeC_xHqqkZx_
WString		FCToolBase::m_strCurReplaceText;		// _xZkqqHx_jChFiKlHjFlGiOjKjHpBiBeC_xHqqkZx_
BOOL		FCToolBase::m_bCurIsRegExp = FALSE;		// _xZkqqHx_iMjPiNpFiPpAiMiPiBeCjAlDiLeLjFfMiMlLiBeC_xHqqkZx_
BOOL		FCToolBase::m_bCurIsCnvUpper = FALSE;	// _xZkqqHx_iMjPiNpFiPpAiMiPiBeCjBoFjFlGiOjKjFmPiKlHiBeC_xHqqkZx_
BOOL		FCToolBase::m_bCurIsMultiWord = FALSE;	// _xZkqqHx_iMjPiNpFiPpAiMiPiBeCjFkBjAjEjCfAiMoKiMjPiNpFiBeC_xHqqkZx_

//----------</NOT EXPORT TO VIEWER>-----------

///////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySortObjVert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiBeBjFjEjFgJiCmMiNmAjFfHiCpAiMlDiCmJiPgDjFpLiMpMiCmJiPoDiCkJiCoHiPiHiCmJjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSorted		:_xZkqqHx_jFmAiCnHjBnGiCkGiClNiMoDiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vUnsorted	:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJjBePiCmMjFjEjFgJjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPgDjCiGiJjLiCmMiImKjChF_xHqqkZx_( (top + bottom) / 2 )_xZkqqHx_iCmMjCgMiCkKiBeBiCoAiCmBiCmGiCoA_xHqqkZx_
 *			_xZkqqHx_iPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySortObjVert (ObjDynabaseVector& vSorted, const ObjDynabaseVector& vUnsorted)
{
	multimap<double, FCObjDynabase*> mmpObj;
	//------ _xZkqqHx_iCnMiClIiBeBiDhNiDiLiDgAiDhNiDgCiDhGiCpAjHjIjHhAiClFiCmEiKoOiPiAiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vUnsorted.begin(); iObj != vUnsorted.end(); iObj++)
	{
		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
		mmpObj.insert(pair<double, FCObjDynabase*>(
							(mmrtFrame.top + mmrtFrame.bottom) / 2.0, *iObj));
	}
	//----- _xZkqqHx_iDhNiDiLiDgAiDhNiDgCiDhGiCmMiDgGiBfLiDfOiCpAiDhIiDeOiDfOiBfLiCmJiOmKiClH_xHqqkZx_ -----
	vSorted.clear();
	multimap<double, FCObjDynabase*>::const_iterator iPt;
	for (iPt = mmpObj.begin(); iPt != mmpObj.end(); iPt++)
		vSorted.push_back((*iPt).second);
} // static void mySortObjVert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySortObjHorz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiBeBjFjEjFgJiCmMiNmAjFfHiCpAiMlDiCmJiJkBjFpLiMpMiCmJiPoDiCkJiCoHiPiHiCmJjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSorted		:_xZkqqHx_jFmAiCnHjBnGiCkGiClNiMoDiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vUnsorted	:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJjBePiCmMjFjEjFgJjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiJkBjCiGiJjLiCmMiImKjChF_xHqqkZx_( (left + right) / 2 )_xZkqqHx_iCmMjCgMiCkKiBeBiCoAiCmBiCmGiCoA_xHqqkZx_
 *			_xZkqqHx_iPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySortObjHorz (ObjDynabaseVector& vSorted, const ObjDynabaseVector& vUnsorted)
{
	multimap<double, FCObjDynabase*> mmpObj;
	//------ _xZkqqHx_iCnMiClIiBeBiDhNiDiLiDgAiDhNiDgCiDhGiCpAjHjIjHhAiClFiCmEiKoOiPiAiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vUnsorted.begin(); iObj != vUnsorted.end(); iObj++)
	{
		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
		mmpObj.insert(pair<double, FCObjDynabase*>(
							(mmrtFrame.left + mmrtFrame.right) / 2.0, *iObj));
	}
	//----- _xZkqqHx_iDhNiDiLiDgAiDhNiDgCiDhGiCmMiDgGiBfLiDfOiCpAiDhIiDeOiDfOiBfLiCmJiOmKiClH_xHqqkZx_ -----
	vSorted.clear();
	multimap<double, FCObjDynabase*>::const_iterator iPt;
	for (iPt = mmpObj.begin(); iPt != mmpObj.end(); iPt++)
		vSorted.push_back((*iPt).second);
} // static void mySortObjHorz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySelectTextObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiPfHiNiHjCiGiCkJiCoHiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCmMiCnNiCmMiPfHiNiHiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTextObj	:_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObj		:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySelectTextObj (ObjDynabaseVector& vTextObj, const ObjDynabaseVector& vObj)
{
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiPfHiCnPiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj1;
	for (iObj1 = vObj.begin(); iObj1 != vObj.end(); iObj1++)
	{
		if ((*iObj1)->IsKindOf(FDOJ_FIGURE))
		{
			if (((FCObjFigure*)*iObj1)->GetRichText() != NULL)
				vTextObj.push_back(*iObj1);
		} else
		if ((*iObj1)->IsKindOf(FDOJ_GROUP))
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiIoKiOoNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIiDiBiDjDiDgPiCpAiOoGjDlOiBeC_xHqqkZx_
			ObjDynabaseVector vObjGrp;
			((FCObjGroup*)*iObj1)->GetCanBeTextObject(vObjGrp);
			// _xZkqqHx_iDiBiDjDiDgPiCmMjCiGiCmFiBeBiNfIiCmJiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiPfHiCnPiCoJiBeC_xHqqkZx_
			ObjDynabaseVector::const_iterator iObj2;
			for (iObj2 = vObjGrp.begin(); iObj2 != vObjGrp.end(); iObj2++)
			{
				if (((FCObjFigure*)*iObj2)->GetRichText() != NULL)
					vTextObj.push_back(*iObj2);
			}
		}
	}
} // mySelectTextObj.

//----------</NOT EXPORT TO VIEWER>-----------

///////////////////////////////////////////////////////////////////////////
// FCToolBase_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::FCToolBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_.
 *************************************************************************/
FCToolBase::FCToolBase ()
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_dwLastObjID = DWORD(-1);		// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
	m_bIsShowFindDlg = FALSE;		// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
	m_bIsShowReplaceDlg = FALSE;	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
	m_mmptFocusBegin.SetPoint(0, 0);		// _xZkqqHx_iNmFiPiJiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	m_mmptFocusLatest.SetPoint(0, 0);	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	m_bIsLocked = FALSE;			// _xZkqqHx_iDgDiBfLiDiLiCmMiDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_
// 06.04.08 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_lNextToolId = -1;				// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// 06.12.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_bIsToolSwitching = FALSE;		// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_

//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	memset(&m_fciBothFontInfo, 0, sizeof(m_fciBothFontInfo));
//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCToolBase::FCToolBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::FCToolBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeCiKoOjCoKiDeOiDiJiDfIiCmIiCmMiCmFjFeLjAhLiBeC_xHqqkZx_
 *************************************************************************/
FCToolBase::~FCToolBase ()
{
} // FCToolBase::FCToolBase.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_jBfDiCmEiCmMiDfEiDhFiDeOiDiJiDfIiCmJjFeLjAhLiCmMiKnGjAjE_xHqqkZx_.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInDiCmMiKnGjAjE_xHqqkZx_.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOutObjectInfo:_xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiMoDiCmJiNoMiCoHiCoKiClNjFjEjFgJiCmMiDiKiDfIiDgHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OutStream (FCUndoArchive& ar, BOOL bIsOutObjectInfo)
{
} // FCToolBase::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHiDgDiBfLiDiLiCmMjBkOjAkLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::InStream (FCUndoArchive& ar)
{
//----- 05.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (GetInsideObject() != NULL)
//	{
//		// _xZkqqHx_jFjEjFgJjBkOjAkLiDfIiDgHiDiKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		GetInsideObject()->InStream(ar);
//	}
//----- 05.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCToolBase::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnViewCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDynamicDrawView::OnCreate_xZkqqHx_iCkJiCoH_xHqqkZx_Call.Tool_xZkqqHx_iCmMiPiJiKpKiJlL_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnViewCreate ()
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_dwLastObjID = DWORD(-1);	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
	m_bIsLocked = FALSE;		// _xZkqqHx_iDgDiBfLiDiLiCmMiDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_
// 06.04.08 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_lNextToolId = -1;				// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
} // FCToolBase::OnViewCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnViewDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDynamicDrawView::OnDestroy_xZkqqHx_iCkJiCoH_xHqqkZx_Call.Tool_xZkqqHx_iCmMiPeJjHlJiPiIjHjN_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnViewDestroy ()
{
} // FCToolBase::OnViewDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::InitContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmM_xHqqkZx_InitContents_xZkqqHx_iOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolBaseCreate_xZkqqHx_iCmM_xHqqkZx_GetLastCreateObj()_xZkqqHx_jHhAiCmJiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::InitContents ()
{
} // FCToolBase::InitContents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSetFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView_xZkqqHx_iCmJiDhEiDeIiBfLiDeKiDfIiCkKjHiIiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pOldWnd	: _xZkqqHx_iClBiCmMjBePiCmJiDhEiDeIiBfLiDeKiDfIiCkKiCkAiCmBiClNiDeFiDeCiDjDiDgIiDeF_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnSetFocus (CWnd* pOldWnd)
{
} // FCToolBase::OnSetFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnKillFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView_xZkqqHx_iCkJiCoHiDhEiDeIiBfLiDeKiDfIiCkKiLiOiCmBiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pNewWnd	: _xZkqqHx_iClBiCmMiMoDiCmJiDhEiDeIiBfLiDeKiDfIiCkKiInKjDkOiClHiCoJiDeFiDeCiDjDiDgIiDeF_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnKillFocus (CWnd* pNewWnd)
{
} // FCToolBase::OnKillFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnLButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnLButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMouseMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCkKiInKjDkOiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnMouseMove (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
	FFGetMainWnd()->MoveRulerMMK(1, mmptMsc);
} // FCToolBase::OnMouseMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnLButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnLButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	EndOfSession();
} // FCToolBase::OnLButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnLButtonDblClk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnLButtonDblClk (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	SetLockStatus(FALSE);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	EndOfSession();
} // FCToolBase::OnLButtonDblClk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnRButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolPoly_xZkqqHx_iCmFiBeBiJeFiDhLiDfOiDjDiCpAiDfEiDhMiBfLiDgHiClFiClNiInHiNoMjAkM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnRButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnRButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnRButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolPoly_xZkqqHx_iCmFiBeBiJeFiDhLiDfOiDjDiCpAiDfEiDhMiBfLiDgHiClFiClNiInHiNoMjAkM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnRButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnRButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnRButtonDblClk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			pPoint	: _xZkqqHx_iDhNiDeFiDfIiCmMiImKjChF_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfHiMgO_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolPoly_xZkqqHx_iCmFiBeBiJeFiDhLiDfOiDjDiCpAiDfEiDhMiBfLiDgHiClFiClNiInHiNoMjAkM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnRButtonDblClk (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnRButtonDblClk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIjCiGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC_xZkqqHx_iBeC_xHqqkZx_
 *			pPoint	:_xZkqqHx_iDhNiDeFiDfIiCmMiImKjChFiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnMButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnMButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIjCiGiDhLiDfOiDjDiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC_xZkqqHx_iBeC_xHqqkZx_
 *			pPoint	:_xZkqqHx_iDhNiDeFiDfIiCmMiImKjChFiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnMButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
} // FCToolBase::OnMButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnXButton1Up
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfI_xHqqkZx_X_xZkqqHx_iDhLiDfOiDjDiCfAiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC_xZkqqHx_iBeC_xHqqkZx_
 *			pPoint	:_xZkqqHx_iDhNiDeFiDfIiCmMiImKjChFiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnXButton1Up (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
	FFGetMainWnd()->PostMessage(WM_COMMAND, ID_VIEW_PREV_DSM, 0);
} // FCToolBase::OnXButton1Up.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnXButton2Up
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfI_xHqqkZx_X_xZkqqHx_iDhLiDfOiDjDiCfBiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC_xZkqqHx_iBeC_xHqqkZx_
 *			pPoint	:_xZkqqHx_iDhNiDeFiDfIiCmMiImKjChFiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDfGiDhEiDgHiDeMiBfLjDjJiCmMiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnXButton2Up (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags)
{
	FFGetMainWnd()->PostMessage(WM_COMMAND, ID_VIEW_NEXT_DSM, 0);
} // FCToolBase::OnXButton2Up.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnWindowMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmJjHeMiMpIiCmIiBeBiDeFiDeCiDjDiDgIiDeFiDiBiDgCiDfKiBfLiDfHiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnWindowMessage (CDC* pDC, DWORD dwMessage,
											WPARAM wParam, LPARAM lParam)
{
} // FCToolBase::OnWindowMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnKeyDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiCkKiJjPiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			nChar	: _xZkqqHx_iJjPiClDiCoKiClNiDeMiBfLiDfCiBfLiDgI_xHqqkZx_.
 *			nRepCnt	: _xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmBiCmPiCmIiClFiCmMiOjOiCmMiDiKiDhDiBfLiDgHiJpBjAjE_xHqqkZx_.
 *			nFlags	: _xZkqqHx_iDeMiBfLiCmMiPpDjBnEiBeCiDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnKeyDown (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags)
{
} // FCToolBase::OnKeyDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnKeyUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiCkKjHkDiClDiCoKiClNiOjOiOmAiNhDiClDiCoKiCoJiBeCiDeKiBfLiDfMiDiLiDeMiBfLjDjJiCoAjCmKjCgNiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			nChar	: _xZkqqHx_iJjPiClDiCoKiClNiDeMiBfLiDfCiBfLiDgI_xHqqkZx_.
 *			nRepCnt	: _xZkqqHx_iJjPiClFiCmBiCmPiCmIiClFiCmMiOjOiCmMiDiKiDhDiBfLiDgHiJpBjAjE_xHqqkZx_.
 *			nFlags	: _xZkqqHx_iDeMiBfLiCmMiPpDjBnEiBeCiDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnKeyUp (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags)
{
} // FCToolBase::OnKeyUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiBeFjAjEiOjKiDeMiBfLiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_DC.
 *			nChar	: _xZkqqHx_iJjPiClDiCoKiClNiDeMiBfLiDfCiBfLiDgI_xHqqkZx_.
 *			nRepCnt	: _xZkqqHx_iJjPiClFiCmBiCmPiCmIiClFiCmMiOjOiCmMiDiKiDhDiBfLiDgHiJpBjAjE_xHqqkZx_.
 *			nFlags	: _xZkqqHx_iDeMiBfLiCmMiPpDjBnEiBeCiDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnChar (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags)
{
} // FCToolBase::OnChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnAnyToolCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEiDfCiDhNiDjDiDgIiCmMiCkCiClIiCoKiCkJiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnAnyToolCommand (CDC* pDC, UINT dwCommand)
{
} // FCToolBase::OnAnyToolCommand.

//----- 05.09.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnPursuerTextNeedInfo
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDhBiDjDiDgHiCkKiBeBiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
// *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
// *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnPursuerTextNeedInfo ()
//{
//	if (g_pReg->GetIsPopupObjectHint())
//	//----- _xZkqqHx_jFjEjFgJiCmMiDhMiDgCiDhGiDeBiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
//		CPoint lgptMsc;
//		(void)::GetCursorPos(&lgptMsc);
//
//		if (g_pView->GetRTFEditor()->IsWindowVisible())
//		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhNiDeFiDfIiCkKiDeHiDgGiDeCiDfOjCiGiCmJiCkAiCoJiPoKiNiHiCmNjCmHjAnFiDhBiDjDiDgHiCpAjFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiCmMiOnHjGiCiCmJiCmIiCoJiClNiCnPiBeC_xHqqkZx_
//			CRect rtEdit;
//			g_pView->GetRTFEditor()->GetWindowRect(rtEdit);
//			if (rtEdit.PtInRect(lgptMsc)) return;
//		}
//
//		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiImKjChFiCpAiOmAiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
//		g_pView->ScreenToClient(&lgptMsc);
//		g_pView->DPtoLP(lgptMsc);
//		// _xZkqqHx_iMlLiNnNiCmMiDiMiDeDiDiEiBfLiCkJiCoHiJlKiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//		FCObjDynabase* pObj = g_pDoc->GetIntersectObject(lg2mm(lgptMsc), NULL, FDOZ_ON_ANY);
//		if (pObj != NULL)
//		{
//			WString wstrHint;
//			GetObjectHintText(wstrHint, pObj);
//			FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
//		}
//	}
//} // FCToolBase::OnPursuerTextNeedInfo.
//----- 05.09.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTimer
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDfOiDeDiDhNiBfLiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnTimer (CDC* pDC)
//{
//	// _xZkqqHx_iJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
//} // FCToolBase::OnTimer.
//----- 01.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiBfOiDiBiDgKiDiFiBfLiDhLiDfOiDjDiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: CDC*
 *			lgpt	: _xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiBgJjIfPjHjNiNmAjFfHiBgK_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnContextMenu (CDC* pDC, const DBLPoint& mmptMsc)
{
//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	CMenu menu;
//	if (menu.LoadMenu(IDR_RBTN_POPUP))
//	{
////----- 00.12.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
////		if (g_pReg->GetIsLeftHand())
////			::RightByLeftHand(menu.m_hMenu, TRUE);
////----- 00.12.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiBeC_xHqqkZx_
//		CPoint dvpt = lgpt;
//		// _xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiCnGjFmPiKlH_xHqqkZx_.
//		g_pView->LPtoDP(dvpt, pDC);
//		// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCnGjFmPiKlH_xHqqkZx_.
//		g_pView->ClientToScreen(&dvpt);
//
//		if(g_pView->SelectObjVector().size() != 0)
//		{
//			CMenu* pPopup = menu.GetSubMenu(0);
//			ASSERT(pPopup != NULL);
////----- 00.12.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//			if (g_pReg->GetIsLeftHand())
//				::RightByLeftHand(pPopup->m_hMenu, TRUE);
////----- 00.12.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//			pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//									dvpt.x, dvpt.y,
//									// route commands through main window.
//									AfxGetMainWnd());
//		} else
//		{
//			CMenu* pPopup = menu.GetSubMenu(1);
//			ASSERT(pPopup != NULL);
////----- 00.12.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//			if (g_pReg->GetIsLeftHand())
//				::RightByLeftHand(pPopup->m_hMenu, TRUE);
////----- 00.12.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//			pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//									dvpt.x, dvpt.y,
//									// route commands through main window
//									AfxGetMainWnd());
//		}
//	}
//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectProperties
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectProperties () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiBeB_xHqqkZx_OLE_xZkqqHx_jFnCiPfHjCiGiCmIiCoHiCmOjGlDiMpIiBeC_xHqqkZx_
// 05.10.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!FFIsSheetReady()) return FALSE;
	if (!FFCanEditReadOnlyDocumentEnv()) return FALSE;
	if (g_pView->SelectObjVector().empty()) return FALSE;
	return TRUE;
} // FCToolBase::CanObjectProperties.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectProperties
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmJiCoGiCmBiCmEjFfMiOkGiClDiCoKiCoJiDiBiDgKiDiFiBfLiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiCmCiImIiPoDjBeJjBpAiClDiCoKiClNjFjEjFgJiCkKiCkAiCoJiOjOiClOiCkPiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectProperties ()
{
	// ID_OBJECT_PROPERTIES = "_xZkqqHx_jFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_"
	CFCPrsObjProperty sheet(ID_OBJECT_PROPERTIES);
	CPropertyPageVector vPropPage;
	CPropertyPageVector::const_iterator	iPN;
	const ObjDynabaseVector& vSelect = g_pView->SelectObjVector();
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJiDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	sheet.SetTargetObject(&vSelect);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
	(*vSelect.begin())->CreatePropertyPage(vPropPage, vSelect);
	if (vPropPage.empty())	return;
	// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		sheet.AddPage(*iPN);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiJpAjFpKiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		delete *iPN;
} // FCToolBase::OnObjectProperties.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanInsideObjProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanInsideObjProperty () const
{
//----- 00.12.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BOOL bCan = TRUE;
//	if (GetInsideObject() == NULL) bCan = FALSE;
//	if (!g_pDoc->GetIsDocumentOpened() || g_pDoc->IsReadOnly()) bCan = FALSE;
//	return bCan;
//----- 00.12.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetInsideObject() == NULL) return FALSE;
	if (!FFCanEditDocumentEnv()) return FALSE;
	return TRUE;
//----- 00.12.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanInsideObjProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnInsideObjProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePjFfMiOkGiCmMiInHiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmJiCoGiCmBiCmEjFfMiOkGiClDiCoKiCoJiDiBiDgKiDiFiBfLiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnInsideObjProperty ()
{
	// ID_RBTN_TOOLOBJ_PROPERTY = "_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_"
	CFCPrsObjProperty sheet(ID_RBTN_TOOLOBJ_PROPERTY);
	CPropertyPageVector vPropPage;
	CPropertyPageVector::const_iterator iPN;
	ObjDynabaseVector vSelect;
	// _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* ojpTemp = GetInsideObject();
	if (ojpTemp == NULL) return;
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	vSelect.push_back(ojpTemp);
	sheet.SetTargetObject(&vSelect, TRUE);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
	(*vSelect.begin())->CreatePropertyPage(vPropPage, vSelect);
	if (vPropPage.empty()) return;
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJiDhJiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		sheet.AddPage(*iPN);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiJpAjFpKiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		delete *iPN;
} // FCToolBase::OnInsideObjProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanToolselfProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiOkJjAgHiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanToolselfProperty () const
{
	return FALSE;
} // FCToolBase::CanToolselfProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnToolselfProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiOkJjAgHiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnToolselfProperty ()
{
	// ID_RBTN_TOOLSELF_PROPERTY = "_xZkqqHx_iDgDiBfLiDiLiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_"
	CFCPrsToolProperty sheet(ID_RBTN_TOOLSELF_PROPERTY);
	CPropertyPageVector vPropPage;
	CPropertyPageVector::const_iterator	iPN;
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJiDfOiBfLiDfBiDgCiDgHiCmMiDgDiBfLiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	sheet.SetTargetTool(this);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
	CreatePropertyPage(vPropPage);
	// _xZkqqHx_iDhJiBfLiDfHiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (vPropPage.empty()) return;
	// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		sheet.AddPage(*iPN);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiJpAjFpKiBeC_xHqqkZx_
	for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
		delete *iPN;
} // FCToolBase::OnToolselfProperty.

//----- 99.12.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::ReqAppendSpecRgn
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCkKjFgAiJoGiClHiCoJjFnCiPfHjHhAiDhNiBfLiDeOjDjJiCmMjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmGiClFiCmE_xHqqkZx_
// *			_xZkqqHx_jCmHiJmBiClHiCoJiBeCjFjEjFgJiCmMiDiKiBfLiDfHiDiHiDjDiCmNjCmHiJmBiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_
// *			_xZkqqHx_jFjEjFgJiCmMiKePiCmJjFnCiPfHjHhAiDhNiBfLiDeOiCpAjFgAiJoGiClFiCmIiCkCiDgDiBfLiDiLiCmNiJlNiCoAiClHiCoJjFeLjHhGiCmNjGlDiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::ReqAppendSpecRgn () const
//{
//} // FCToolBase::ReqAppendSpecRgn.
//----- 99.12.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSelectObjModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmFjBeJjBpAjCiGiCmMjFjEjFgJiCkKiBeBiDgDiBfLiDiLiImIiKePiCmMiPoKiPiKiCmFiPeDjAlDiClDiCoKiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCjFnCiPfHjHhAiDhNiBfLiDeOiCmMiNmEjFgAiJoGiCmMjFeLjHhGiCmNjGlDiCkCiBgJjFmKjDhCiMmEiCmOiCoKiCoJiInHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLjCiGiCmJjFjEjFgJiCmMjBkOjAkLiCpAiOmKiClFiOjNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCmFjFjEjFgJiCmMjBkOjAkLiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnSelectObjModified ()
{
} // FCToolBase::OnSelectObjModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnZoomChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiCmMiDfJiBfLiDiAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnZoomChanged ()
{
} // FCToolBase::OnZoomChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjSelectChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjSelectChanged ()
{
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
	FFGetMainWnd()->SendMessage(WM_USER_OBJ_SELECT_CHANGED);
} // FCToolBase::OnObjSelectChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTextSelectChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMiDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnTextSelectChanged ()
{
//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	if (GetCurrentTextFont(fciExtFontInfo, fciStdFontInfo))
//	{
//		m_fciBothFontInfo = fciStdFontInfo;
//		m_fciBothFontInfo &= fciExtFontInfo;
//	} else
//	{
//		// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//		memset(&m_fciBothFontInfo, 0, sizeof(m_fciBothFontInfo));
//	}
//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
	FFGetMainWnd()->SendMessage(WM_USER_TEXT_SELECT_CHANGED);
} // FCToolBase::OnTextSelectChanged.

//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetCurrentTextBothFontName
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHjGlMiBeCiLkEjCmKiCmMjCgMiCkKjGlDiCkCiPoKiNiHiCmNiLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const wchar_t* FCToolBase::GetCurrentTextBothFontName () const
//{
//	//----- _xZkqqHx_jFfHiPiAiKePiCmMiDhEiDeIiDjDiDgHjGlMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_FACENAME) == FDFI_FLAG_FACENAME)
//		return m_fciBothFontInfo.szFaceName;
//	else
//		return L"";
//} // FCToolBase::GetCurrentTextBothFontName.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetCurrentTextBothFontSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiDfEiDeDiDfJiBeCiLkEjCmKiCmMjCgMiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ DBL_MAX _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//mmetol FCToolBase::GetCurrentTextBothFontSize () const
//{
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_HEIGHT) == FDFI_FLAG_HEIGHT)
//		return m_fciBothFontInfo.mmHeight;
//	else
//		return DBL_MAX;
//} // FCToolBase::GetCurrentTextBothFontSize.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetCurrentTextBothFontWeight
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiCmMjBlOiClDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlOiClDiBeCiLkEjCmKiCmMjCgMiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_WORD(-1);
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WORD FCToolBase::GetCurrentTextBothFontWeight () const
//{
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_WEIGHT) == FDFI_FLAG_WEIGHT)
//		return m_fciBothFontInfo.wWeight;
//	else
//		return WORD(-1);
//} // FCToolBase::GetCurrentTextBothFontWeight.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetIsCurrentTextBothFontItalic
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiOmOjBmMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmOjBmMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::GetIsCurrentTextBothFontItalic () const
//{
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_ITALIC) == FDFI_FLAG_ITALIC)
//		return m_fciBothFontInfo.byItalic;
//	else
//		return FALSE;
//} // FCToolBase::GetIsCurrentTextBothFontItalic.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetIsCurrentTextBothFontUnderline
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiOmOjBmMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmOjBmMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::GetIsCurrentTextBothFontUnderline () const
//{
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_UNDERLINE) == FDFI_FLAG_UNDERLINE)
//		return m_fciBothFontInfo.byUnderline;
//	else
//		return FALSE;
//} // FCToolBase::GetIsCurrentTextBothFontUnderline.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetCurrentTextBothFontColor
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMjFlGiOjKjAeGiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjAeGiBeCiLkEjCmKiCmMjAeGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ FD_COLOR_REF_UNSPECIFY_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//COLORREF FCToolBase::GetCurrentTextBothFontColor () const
//{
//	if ((m_fciBothFontInfo.dwMask & FDFI_FLAG_COLORREF) == FDFI_FLAG_COLORREF)
//		return m_fciBothFontInfo.crColor;
//	else
//		return FD_COLOR_REF_UNSPECIFY;
//} // FCToolBase::GetCurrentTextBothFontColor.
//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBiDhEiDeIiDjDiDgHiCmJiKnGiClHiCoJiPoOjFpBiCkKjAnNjCoIiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSetCurrentTextFont () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanSetCurrentTextFont.

//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetCurrentTextBothFontName
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFontName	:_xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetCurrentTextBothFontName (const wchar_t* wcpFontName)
//{
//	// _xZkqqHx_iDhEiDeIiDjDiDgHjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//
//	//----- _xZkqqHx_jEpBjFfHiPiAiDhEiDeIiDjDiDgHiCmJiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
//	wcscpy(fciExtFontInfo.szFaceName, wcpFontName);
//	fciExtFontInfo.dwMask |= FDFI_FLAG_FACENAME;
//
//	// _xZkqqHx_jFfHiPiAiCmMiDhEiDeIiDjDiDgHiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
//	WStringSet stStdCodeFontName;
//	FFCollectFontName(NULL, &stStdCodeFontName);
//	if (stStdCodeFontName.find(wcpFontName) != stStdCodeFontName.end())
//	//----- _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiIoKjHjHiCmJiCoAjDkPiClGiDhEiDeIiDjDiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmJiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
//		wcscpy(fciStdFontInfo.szFaceName, wcpFontName);
//		fciStdFontInfo.dwMask |= FDFI_FLAG_FACENAME;
//	}
//	// _xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetCurrentTextBothFontName.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetCurrentTextBothFontSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmFontSize	:_xZkqqHx_iDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetCurrentTextBothFontSize (mmetol mmFontSize)
//{
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//	fciStdFontInfo.mmHeight = mmFontSize;
//	fciStdFontInfo.dwMask |= FDFI_FLAG_HEIGHT;
//	fciExtFontInfo.mmHeight = mmFontSize;
//	fciExtFontInfo.dwMask |= FDFI_FLAG_HEIGHT;
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetCurrentTextBothFontSize.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetCurrentTextBothFontWeight
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiCmMjBlOiClDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wWeight	:_xZkqqHx_jBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetCurrentTextBothFontWeight (WORD wWeight)
//{
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//	fciStdFontInfo.wWeight = wWeight;
//	fciStdFontInfo.dwMask |= FDFI_FLAG_WEIGHT;
//	fciExtFontInfo.wWeight = wWeight;
//	fciExtFontInfo.dwMask |= FDFI_FLAG_WEIGHT;
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetCurrentTextBothFontWeight.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetIsCurrentTextBothFontItalic
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiOmOjBmMiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	bIsItalic	:_xZkqqHx_iOmOjBmMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetIsCurrentTextBothFontItalic (BOOL bIsItalic)
//{
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//	fciStdFontInfo.byItalic = bIsItalic;
//	fciStdFontInfo.dwMask |= FDFI_FLAG_ITALIC;
//	fciExtFontInfo.byItalic = bIsItalic;
//	fciExtFontInfo.dwMask |= FDFI_FLAG_ITALIC;
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetIsCurrentTextBothFontItalic.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetIsCurrentTextBothFontUnderline
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiOmOjBmMiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	bIsUnderline	:_xZkqqHx_iOmOjBmMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetIsCurrentTextBothFontUnderline (BOOL bIsUnderline)
//{
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//	fciStdFontInfo.byUnderline = bIsUnderline;
//	fciStdFontInfo.dwMask |= FDFI_FLAG_UNDERLINE;
//	fciExtFontInfo.byUnderline = bIsUnderline;
//	fciExtFontInfo.dwMask |= FDFI_FLAG_UNDERLINE;
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetIsCurrentTextBothFontUnderline.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetCurrentTextBothFontColor
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMjFlGiOjKjAeGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	colorRef	:_xZkqqHx_jFlGiOjKjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetCurrentTextBothFontColor (COLORREF colorRef)
//{
//	// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCFontCharInfo fciStdFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	FCFontCharInfo fciExtFontInfo;	// _xZkqqHx_iMlLiNnNiCmMjFfHiPiAiKePiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
//	memset(&fciStdFontInfo, 0, sizeof(fciStdFontInfo));
//	memset(&fciExtFontInfo, 0, sizeof(fciExtFontInfo));
//	fciStdFontInfo.crColor = colorRef;
//	fciStdFontInfo.dwMask |= FDFI_FLAG_COLORREF;
//	fciExtFontInfo.crColor = colorRef;
//	fciExtFontInfo.dwMask |= FDFI_FLAG_COLORREF;
//	SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
//} // FCToolBase::SetCurrentTextBothFontColor.
//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTextInflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpA_xHqqkZx_
 *			_xZkqqHx_iCfAjCgJjBoFiCkLiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnTextInflateFontSize ()
{
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCmJjAfGiClFiCkC_xHqqkZx_ fciAnsi _xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vTextObj.begin(); iObj != vTextObj.end(); iObj++)
	{
		FCObjFigure* pFig = (FCObjFigure*)*iObj;
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->BeforeCmdModifyAbcRichText(pFig);
		// fciAnsi,fciSjis _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		BYTEVector byvQueue;
		pFig->GetRichText()->InflateFontSize(byvQueue, pFig);
		if (!byvQueue.empty())
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyAbcRichText(pFig, byvQueue.size(), byvQueue.begin());
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(pFig);
		}
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnTextInflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTextDeflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpA_xHqqkZx_
 *			_xZkqqHx_iCfAjCgJiPkMiClDiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnTextDeflateFontSize ()
{
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCmJjAfGiClFiCkC_xHqqkZx_ fciAnsi _xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vTextObj.begin(); iObj != vTextObj.end(); iObj++)
	{
		FCObjFigure* pFig = (FCObjFigure*)*iObj;
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->BeforeCmdModifyAbcRichText(pFig);
		// fciAnsi,fciSjis _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		BYTEVector byvQueue;
		pFig->GetRichText()->DeflateFontSize(byvQueue, pFig);
		if (!byvQueue.empty())
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyAbcRichText(pFig, byvQueue.size(), byvQueue.begin());
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(pFig);
		}
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnTextDeflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjEmNiImNiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciExtFontInfo	:_xZkqqHx_jFfHiPiAiKePiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			fciStdFontInfo	:_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::GetCurrentTextFont (FCFontCharInfo& fciExtFontInfo, FCFontCharInfo& fciStdFontInfo) const
{
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	if (!vTextObj.empty() && vTextObj.size() < 10)
	{
		FCToolBase::GetFontInfoProc(fciExtFontInfo, fciStdFontInfo, (void*)&vTextObj);
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FCToolBase::GetCurrentTextFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjEmNiImNiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciExtFontInfo	:_xZkqqHx_jFfHiPiAiKePiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			fciStdFontInfo	:_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::SetCurrentTextFont (const FCFontCharInfo& fciExtFontInfo, const FCFontCharInfo& fciStdFontInfo)
{
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
// 05.06.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!vTextObj.empty() && vTextObj.size() < 10)
	if (!vTextObj.empty())
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		FCToolBase::SetFontInfoProc(fciExtFontInfo, fciStdFontInfo, (void*)&vTextObj);
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
		g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FCToolBase::SetCurrentTextFont.

//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnOleDocumentOpened
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiKeKiCkJiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CMolipDrawCntrItem4_0 _xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnOleDocumentOpened ()
//{
//} // FCToolBase::OnOleDocumentOpened.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnOleDocumentClosed
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKjFmCiClGiCoHiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CMolipDrawCntrItem4_0 _xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnOleDocumentClosed ()
//{
//} // FCToolBase::OnOleDocumentClosed.
//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnDraw (CDC* pDC)
{
	ObjDynabaseVector::const_iterator iON;
	for (iON = g_pView->SelectObjVector().begin();
		 iON != g_pView->SelectObjVector().end(); iON++)
	{
		DrawSelectMark(pDC, *iON);
	}
} // FCToolBase::OnDraw.

//----- 05.07.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *			05.07.06 Fukushiro M. _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnDraw (CDC* pDC, const DBLRect* pmmrtRgn, long lRgnSize)
//{
//	// _xZkqqHx_jFjEjFgJjAjEiCkKjBjNiCkGiClNiCmGiCkLiBeBiDiKiBfLiDfHiDiHiDjDiCpAjElLjCgGiClFiCmEiNmEjFgAiJoGiClFiCmIiCkCiCmGiPiIjHjNiCkKjChIiCkNiCmIiCoJiBeC_xHqqkZx_
//	ObjDynabaseVector::const_iterator iObj;
//	if (pmmrtRgn != NULL && lRgnSize != 0)
//	//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		long lC;
//		for (iObj = g_pView->SelectObjVector().begin();
//			 iObj != g_pView->SelectObjVector().end(); iObj++)
//		{
//			for (lC = 0; lC != lRgnSize; lC++)
//			{
//				// _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iCmMjClMjApMjDjJiCmMiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_IsRectEmpty_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_IsRectNull_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
//				if (!(pmmrtRgn[lC] & (*iObj)->GetOuterFrame()).IsRectNull())
//				{
//					DrawSelectMark(pDC, *iObj);
//					break;
//				}
//			}
//		}
//	} else
//	//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmMiPfHiNiHiCmMiKePjBkEiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
//		DBLRect mmrtRgn = g_pView->GetRgnRect();
//		if (mmrtRgn.IsRectNull())
//			g_pView->GetClientRectMM(mmrtRgn);
//		for (iObj = g_pView->SelectObjVector().begin();
//			 iObj != g_pView->SelectObjVector().end(); iObj++)
//		{
//			// _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iCmMjClMjApMjDjJiCmMiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_IsRectEmpty_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_IsRectNull_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
//			if (!(mmrtRgn & (*iObj)->GetOuterFrame()).IsRectNull())
//				DrawSelectMark(pDC, *iObj);
//		}
//	}
//} // FCToolBase::OnDraw.
//----- 05.07.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::Select (CDC* pDC)
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *************************************************************************/
void FCToolBase::Select (CDC* pDC)
{
//----------<NOT EXPORT TO VIEWER>-----------
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_lNextToolId = -1;
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.12.31 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	SetIsToolSwitching(FALSE);		// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_

	//----- _xZkqqHx_iBhFjFjEjFgJiBhGiDiBiDgKiDiFiBfLiCmMiJlKiCmJiKnGiClFiCmEiBeB_xHqqkZx_IsObjectCommandEnable _xZkqqHx_iCmIiDfCiDhNiDjDiDgIiClOiCkPiCpAjHeMiMpIiCmJiClHiCoJ_xHqqkZx_ -----
	DWORD dwMenuSz = FFGetMainWnd()->GetWnd()->GetMenu()->GetMenuItemCount();
	WString strMenu;
	DWORD dwC;
	// _xZkqqHx_jFlGiOjKjHpB_xHqqkZx_ "_xZkqqHx_jFjEjFgJ_xHqqkZx_" _xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	WString strObj;
	strObj.LoadString(IDS_OBJECT);
	for (dwC = 0; dwC < dwMenuSz; dwC++)
	{
		FFGetMenuString(FFGetMainWnd()->GetWnd()->GetMenu(), dwC, strMenu, MF_BYPOSITION);
		if (wcsncmp(strObj, strMenu, strObj.GetLength()) == 0)
		{
			OneLetterCommandEnable(FFGetMainWnd()->GetWnd()->GetMenu()->GetSubMenu(dwC));
			break;
		}
	}
//----------</NOT EXPORT TO VIEWER>-----------

	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_ -----
	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
	FFGetMainWnd()->SetRulerMMKVisible(1, TRUE);
	// _xZkqqHx_iDhCiDiFiBfLjBeJjBpAjCiGiCmMjFjEjFgJiCpAiBeBiDgDiBfLiDiLiCmJiCoAjAnNjCoIiBeC_xHqqkZx_
//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	OnAppendSelectObj(pDC, g_pView->SelectObjVector());
//
//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	ObjDynabaseVector::const_iterator i;
	for (i = g_pView->SelectObjVector().begin();
		 i != g_pView->SelectObjVector().end(); i++)
		OnAppendSelectObj(pDC, *i);
//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCiDePiDiLiBfLiDhGjFnCiPfHiDgDiBfLiDiLiCkJiCoHjFjMiLeBiOjOiCmJiBeB_xHqqkZx_
	// _xZkqqHx_iClBiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiCmIiCkCiCmGjBeJjBpAjFjEjFgJiCmMjFmPiNfIiCkKjCmKjCgNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------
	if (m_bIsShowFindDlg)
	//----- Unselect_xZkqqHx_iOjOiCmJiMjPiNpFiDfPiDeDiDeBiDiNiDePjFfMiOkGiCkKiLeMiJkPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetFindDialog(this)->ShowWindow(SW_SHOW);
		GetFindDialog(this)->SetWindowVisible(TRUE);
	} else
	//----- _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePjEpBjFfMiOkGiCkKiLeMiJkPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (IsFindDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			GetFindDialog(this)->ShowWindow(SW_HIDE);
			GetFindDialog(this)->SetWindowVisible(FALSE);
	}
	if (m_bIsShowReplaceDlg)
	//----- Unselect_xZkqqHx_iOjOiCmJjChFiKlHiDfPiDeDiDeBiDiNiDePjFfMiOkGiCkKiLeMiJkPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetReplaceDialog(this)->ShowWindow(SW_SHOW);
		GetReplaceDialog(this)->SetWindowVisible(TRUE);
	} else
	//----- _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePjEpBjFfMiOkGiCkKiLeMiJkPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (IsReplaceDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			GetReplaceDialog(this)->ShowWindow(SW_HIDE);
			GetReplaceDialog(this)->SetWindowVisible(FALSE);
	}
//----------</NOT EXPORT TO VIEWER>-----------
} // FCToolBase::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::Unselect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJpAiPjMiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_.
 *************************************************************************/
void FCToolBase::Unselect (CDC* pDC)
{
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_lNextToolId = -1;
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
// 06.04.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (CWnd::GetCapture() == g_pView) ::FFReleaseCapture();
	if (FFGetCapture() == g_pView->m_hWnd) ::FFReleaseCapture();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiBeBiDgDiBfLiDiLiCkJiCoHiJpAiPjMiBeC_xHqqkZx_
	OnClearSelectObj(pDC);
	/*----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCePiCpAjEpBjFfMiOkGiCmJiClHiCoJ_xHqqkZx_ -----*/
	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
	FFGetMainWnd()->SetRulerMMKVisible(1, FALSE);

//----------<NOT EXPORT TO VIEWER>-----------
	if (IsFindDialogVisible())
	//----- _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_bIsShowFindDlg = TRUE;	// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetFindDialog(this)->ShowWindow(SW_HIDE);
		GetFindDialog(this)->SetWindowVisible(FALSE);
	} else
	//----- _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCkKjEpBjFfMiOkGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_bIsShowFindDlg = FALSE;	// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
	}
	if (IsReplaceDialogVisible())
	//----- _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_bIsShowReplaceDlg = TRUE;	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetReplaceDialog(this)->ShowWindow(SW_HIDE);
		GetReplaceDialog(this)->SetWindowVisible(FALSE);
	} else
	//----- _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCkKjEpBjFfMiOkGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_bIsShowReplaceDlg = FALSE;	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
	}
//----------</NOT EXPORT TO VIEWER>-----------
// 06.12.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	SetIsToolSwitching(FALSE);		// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_
} // FCToolBase::Unselect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSelectTool () const
{
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
//	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmNiBeBjFlGiPjBiCkKjDmHiCnNiPjBiCkLiCgOiCgKiCmFiKeKiCkCiCmEiCkCiCoJiCmGiCkLiClOiCkP_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
//// 00.12.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	if (g_pDoc->GetIsDocumentOpened() && !g_pDoc->IsReadOnly()) return TRUE;
//	if (FFCanEditDocument()) return TRUE;
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmFiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	ASSERT(FALSE);
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	return FALSE;
} // FCToolBase::CanSelectTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
//----- 05.07.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmMiPfHiNiHiCmMiKePjBkEiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
	DBLRect mmrtRgn = g_pView->GetRgnRect();
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCkKjGlDiCkCiPoKiNiHiCmNiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_jHeMiCoJiPoKiNiHiCmNiBeBjBeJjBpAiDhNiBfLiDeOiCkKiNmEjFgAiJoGiCmFiCkLiCoJiCoGiCkEiDhNiBfLiDeOjFjNjFkKiNeMiClAiCoJiBeC_xHqqkZx_
	if (mmrtRgn.IsRectNull())
		g_pView->GetClientRectMM(mmrtRgn);
	else
		mmrtRgn.Extend(lg2mm(FCEditDraw::GetGeneralMarkSizeHalf() + 1));
	// _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iCmMjClMjApMjDjJiCmMiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_IsRectEmpty_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_IsRectNull_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
	if ((mmrtRgn & pObj->GetOuterFrame()).IsRectNull()) return;
//----- 05.07.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	DBLRect mmrtFrame = pObj->GetResizeFrame();
	const long lgXM = mm2lg((mmrtFrame.left + mmrtFrame.right) / 2);
	const long lgYM = mm2lg((mmrtFrame.top + mmrtFrame.bottom) / 2);
	const CRect lgrt = mm2lg(mmrtFrame);
	if (lgrt.left == lgrt.right && lgrt.top == lgrt.bottom)
	// _xZkqqHx_jBoFiCkLiClDiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.GeneralMark(CPoint(lgrt.left, lgrt.top));
	} else
	if (lgrt.left == lgrt.right || lgrt.top == lgrt.bottom)
	// _xZkqqHx_jAiCjClMiBeFjAiFjFlNjApMiCmMiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.GeneralMark(CPoint(lgrt.left, lgrt.top));
		eDraw.GeneralMark(CPoint(lgrt.right, lgrt.bottom));
	} else
	// _xZkqqHx_iLoJiMgAiCmMiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.GeneralMark(CPoint(lgrt.left, lgrt.top));
		eDraw.GeneralMark(CPoint(lgrt.left, lgrt.bottom));
		eDraw.GeneralMark(CPoint(lgrt.right, lgrt.top));
		eDraw.GeneralMark(CPoint(lgrt.right, lgrt.bottom));
		eDraw.GeneralMark(CPoint(lgXM, lgrt.top));
		eDraw.GeneralMark(CPoint(lgXM, lgrt.bottom));
		eDraw.GeneralMark(CPoint(lgrt.left, lgYM));
		eDraw.GeneralMark(CPoint(lgrt.right, lgYM));
	}
//----- 06.03.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMjBeJjBpAjEmNiImNiCpAjFgAiJoGiBeC_xHqqkZx_
	pObj->DrawTextSelection(pDC);
//----- 06.03.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBase::DrawSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnAppendSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pDC == NULL) return;
	// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawSelectMark(pDC, pObj);
} // FCToolBase::OnAppendSelectObj.

//----- 05.06.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnAppendSelectObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
// *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *			vObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiCmMiPfHiNiHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
// *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnAppendSelectObj (CDC* pDC, const ObjDynabaseVector& vObj)
//{
//	ObjDynabaseVector::const_iterator i;
//	for (i = vObj.begin(); i != vObj.end(); i++)
//		OnAppendSelectObj(pDC, *i);
//} // FCToolBase::OnAppendSelectObj.
//----- 05.06.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pDC == NULL) return;
	// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
	DrawSelectMark(pDC, pObj);
} // FCToolBase::OnRemoveSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnClearSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmEjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::ClearSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnClearSelectObj (CDC* pDC)
{
	const ObjDynabaseVector& vSelObj = g_pView->SelectObjVector();
	ObjDynabaseVector::const_iterator i;
	for (i = vSelObj.begin(); i != vSelObj.end(); i++)
		OnRemoveSelectObj(pDC, *i);
} // FCToolBase::OnClearSelectObj.


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetSelectLocalObjVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const ObjDynabaseVector& FCToolBase::GetSelectLocalObjVector () const
{
	return g_pView->SelectObjVector();
} // FCToolBase::GetSelectLocalObjVector.

//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::ClearSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCpAiKeKjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::ClearSelectLocalObj (CDC* pDC)
//{
//	g_pView->ClearSelectObj(pDC);
//} // FCToolBase::ClearSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::AppendSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::AppendSelectLocalObj (CDC* pDC, FCObjDynabase* pObj)
//{
//	g_pView->AppendSelectObj(pObj, pDC);
//} // FCToolBase::AppendSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::AppendSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::AppendSelectLocalObj (CDC* pDC, const ObjDynabaseVector& vObj)
//{
//	g_pView->AppendSelectObj(vObj, pDC);
//} // FCToolBase::AppendSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::RemoveSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiBeBiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::RemoveSelectLocalObj (CDC* pDC, FCObjDynabase* pObj)
//{
//	g_pView->RemoveSelectObj(pObj, pDC);
//} // FCToolBase::RemoveSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKiBeBiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCmJiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
// *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::IsSelectLocalObj (FCObjDynabase* pObj) const
//{
//	return g_pView->IsSelectObj(pObj);
//} // FCToolBase::IsSelectLocalObj.
//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetLastSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::SetLastSelectLocalObj (FCObjDynabase* pObj)
//{
//	g_pView->SetLastSelectObj(pObj);
//} // FCToolBase::SetLastSelectLocalObj.
//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlNiCkJiClFiCoHiNoNiPjMiJmCjEfMiCmIiCoAiCmMiCpAjBeJjBpAjCiGiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiDiBiDgKiDiFiBfLiCmMjHeMiMpIiBfOjGlDiMpIiCpAjAnIiCoIjBnGiCkGiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjHeMiCoJiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjGlDiCkCiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanDelete () const
{
	return FALSE;
} // FCToolBase::CanDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFkIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPiIjHjNiCpAiNoNiPjMiDfCiDhNiDjDiDgIiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnDelete (CDC* pDC)
{
} // FCToolBase::OnDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanBackspace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	BS_xZkqqHx_iDeMiBfLiCkKjHeMiMpIiBeBjGlDiMpIiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanBackspace () const
{
	return CanDelete();
} // FCToolBase::CanBackspace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnBackspace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	BS_xZkqqHx_iDeMiBfLiCmMiPiIjHjNiCpAiClHiCoJiBeCjCmKiPoNiCmNiNoNiPjMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnBackspace (CDC* pDC)
{
	OnDelete(pDC);
} // FCToolBase::OnBackspace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGiJlLiJmCjEfMiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDePiDiLiBfLiDhGiJlLiJmCjEfMiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iDePiDiLiBfLiDhGiJlLjFhDiJmCjEfMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectGroup () const
{
	return FALSE;
} // FCToolBase::CanObjectGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiJlLiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectGroup ()
{
	// _xZkqqHx_iJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
} // FCToolBase::OnObjectGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectUngroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGiJpAiPjMiJmCjEfMiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiJmCjEfMiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectUngroup () const
{
	return FALSE;
} // FCToolBase::CanObjectUngroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectUngroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectUngroup ()
{
	// _xZkqqHx_iJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
} // FCToolBase::OnObjectUngroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanUndo () const
{
	return g_pDoc->CanUndo();
} // FCToolBase::CanUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnUndo ()
{
//----- 03.12.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DWORDSet stObjID;	// _xZkqqHx_iNmFiMoDiCmJjBiAiNoMiClDiCoKiClNjFjEjFgJiDiKiDfIiDgHiBeC_xHqqkZx_
//	// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjGnPiCoJiBeC_xHqqkZx_
//	g_pDoc->Undo(stObjID);
//	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCkKiDhCiDiFiBfLiCmJiOpLiCnMiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBjFiMmFjHeMiDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
//	if (!ScrollToObject(stObjID))
//	{
//		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCkKjGlDiCkCiPoKiNiHiCmNiBeBiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmMiNmEjFgAiJoGiCmMiCnNiBeC_xHqqkZx_
//		g_pView->SendRgnRedraw();
//	}
//	// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiBeC_xHqqkZx_
//	g_pView->AppendSelectObj(stObjID, TRUE);
//----- 03.12.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_MOVE_HISTORY_BACKWARD);
//	g_pDoc->PushBackDocRequest(ID_DREQ_RGN_REDRAW);
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	g_pDoc->ProceedDocRequest(TRUE);
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	g_pDoc->OnUndo();
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 03.12.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanRedo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanRedo () const
{
	return g_pDoc->CanRedo();
} // FCToolBase::CanRedo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnRedo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnRedo ()
{
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_MOVE_HISTORY_FORWARD);
//	g_pDoc->PushBackDocRequest(ID_DREQ_RGN_REDRAW);
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	g_pDoc->ProceedDocRequest(TRUE);
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	g_pDoc->OnRedo();
//----- 04.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnRedo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSelectAll () const
{
	return FALSE;
} // FCToolBase::CanSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClHiCnHiCmEjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnSelectAll ()
{
} // FCToolBase::OnSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanClearSelect () const
{
	return FALSE;
} // FCToolBase::CanClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnClearSelect ()
{
} // FCToolBase::OnClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSelectSameKindOfObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDkPiOoNiCmMjFjEjFgJiCpAjBfDiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSelectSameKindOfObject () const
{
	return FALSE;
} // FCToolBase::CanSelectSameKindOfObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSelectSameKindOfObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDkPiOoNiCmMjFjEjFgJiCpAjBfDiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnSelectSameKindOfObject ()
{
} // FCToolBase::OnSelectSameKindOfObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSelectNext () const
{
	return FALSE;
} // FCToolBase::CanSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiOjPiCpAjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnSelectNext ()
{
} // FCToolBase::OnSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanCopy () const
{
	return !g_pView->SelectObjVector().empty();
} // FCToolBase::CanCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnCopyText_xZkqqHx_iCmMiLeAjEfMiCpAjDjNiNiHiClFiClNiCkCiCmMiClOiCkKiBeBjFjEjFgJiCmMiDfCiDhDiBfLiCmGjFjEjFgJiCmM_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjDkPiOjOiDfCiDhDiBfLiCmNjDoPiClFiCkCiBeC_xHqqkZx_RTF_xZkqqHx_iCmMiDfCiDhDiBfLiCkKiCkEiCnMiCkNiNhDiCkJiCmIiCkJiCmBiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.11 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnCopy ()
{
	g_pDoc->OnCopy(g_pView->SelectObjVector(), g_pDoc->LinkManager());
} // FCToolBase::OnCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanCopyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDfCiDhDiBfLiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanCopyText () const
{
	// _xZkqqHx_jFkBjAjEiCmMjFjEjFgJiCpAiDfCiDhDiBfLiClHiCoJiCmMiCmNjDoPiClFiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCmMiCnNiCmIiCoHiCmIiCpBiCmGiCkJiCmIiCoJiCkKiBeB_xHqqkZx_RTF_xZkqqHx_iCmNiCkLiCmCiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiIoKiCmCiCmMjFjEjFgJjBeJjBpAiOjOiCmMiCnNiJmCjEfMiCmGiClHiCoJiBeC_xHqqkZx_
	if (GetSelectLocalObjVector().size() != 1) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKiIoKiCmCiCmMiCnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	return GetSelectLocalObjVector().at(0)->CanCopyText();
} // FCToolBase::CanCopyText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnCopyText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDfCiDhDiBfLiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnCopyText ()
{
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetSelectLocalObjVector().size() == 1)
//		GetSelectLocalObjVector().at(0)->CopyText();
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetSelectLocalObjVector().size() == 1)
	{
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (::OpenClipboard(NULL))
		//----- _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCpAiKeKiCkN_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
			::EmptyClipboard();
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
			GetSelectLocalObjVector().at(0)->CopyText();
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCpAjFmCiClGiCoJiBeC_xHqqkZx_
			::CloseClipboard();
		}
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDgMiDiLiCmMjFfMiOkG_xHqqkZx_ -----
		// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDfCiDhDiBfLiClFiCnMiClFiClNiBeC_xHqqkZx_
		FFShowMsgPanel(IDS_MSG_COPY_TEXT);
	}
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnCopyText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	DynamicDrawView_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJiCkKiBeBiCmGiCoIiCkAiCkGiClIiClBiCmMiDgDiBfLiDiLiCmFiDhJiBfLiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClJiCmOiCoGiCkCiBeC_xHqqkZx_
 *			TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_jCiGiCmMiMmEiCnBiPgPiClFiMlDiCmF_xHqqkZx_
 *			FDFoundDoc_xZkqqHx_iCkKiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiNfIiCmJjClCiCnHiCmEiCkNiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanPaste () const
{
	return FALSE;
} // FCToolBase::CanPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnPaste (CDC* pDC)
{
	// _xZkqqHx_iJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
} // FCToolBase::OnPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFormat:_xZkqqHx_iDhJiBfLiDfIiDgHiClFiCoGiCkEiCmGiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeCiMgAiOkOiCpAjDmBjCoIiClFiCmIiCkC_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmNiCePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	DynamicDrawView_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJiCkKiBeBiCmGiCoIiCkAiCkGiClIiClBiCmMiDgDiBfLiDiLiCmFiDhJiBfLiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClJiCmOiCoGiCkCiBeC_xHqqkZx_
 *			TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_jCiGiCmMiMmEiCnBiPgPiClFiMlDiCmF_xHqqkZx_
 *			FDFoundDoc_xZkqqHx_iCkKiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiNfIiCmJjClCiCnHiCmEiCkNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanPasteSpec (UINT dwFormat) const
{
	return FALSE;
} // FCToolBase::CanPasteSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiDhJiBfLiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			dwFormat	:_xZkqqHx_iDhJiBfLiDfIiDgHiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnPasteSpec (CDC* pDC, UINT dwFormat)
{
	// _xZkqqHx_iJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
} // FCToolBase::OnPasteSpec.

//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetPasteOverAttr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiMfBiCmJjDfMiCoIjFhEiCkPiJmCjEfMiCmIjBkOjAkLiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_jFjEjFgJiMfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfMiCoIjFhEiCkPiJmCjEfMiCmIjBkOjAkLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCToolBase::GetPasteOverAttr (const ObjDynabaseVector& vObj) const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCkJiCoHiCnNiClNiBeBjDfMiCoIjFhEiCkPiJmCjEfMiCmIjBkOjAkLiBeC_xHqqkZx_
	DWORD dwSelectedAttr = 0;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin();
		 iObj != vObj.end() && dwSelectedAttr != FD_PASTE_ATTR_ALL;
		 iObj++)
	{
		if ((*iObj)->IsKindOf(FDOJ_FIGURE))
		//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBfDjBkOjAkLiCkKjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
			dwSelectedAttr |= FD_PASTE_ATTR_ALL;
		} else
		if ((*iObj)->IsKindOf(FDOJ_TABLE))
		//----- _xZkqqHx_jFfMiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_(_xZkqqHx_iDePiDiLiBfLiDhGiMgOiCoGiCoIjAoGiCmJjClCiCnHiCoJiClBiCmG_xHqqkZx_) -----
		{
			// _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiBeBiDhJiDjDiBeBiDhFiDiJiDfGiCmMiCnNjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
			dwSelectedAttr |= FD_PASTE_ATTR_PLAIN_TEXT;
			dwSelectedAttr |= FD_PASTE_ATTR_PEN;
			dwSelectedAttr |= FD_PASTE_ATTR_BRUSH;
		} else
		if ((*iObj)->IsKindOf(FDOJ_GROUP))
		//----- _xZkqqHx_jFfMiMgOjFjEjFgJiImIiKePiCmMiDePiDiLiBfLiDhGiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if ((dwSelectedAttr & FD_PASTE_ATTR_GRAPHICS) != FD_PASTE_ATTR_GRAPHICS)
			{
				if ((*iObj)->IsMemberKindOf(FDOJ_FIGURE))
				//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCpAiKnMiCnOiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDePiDiJiDhEiDeCiDeOiDfIjBkOjAkLiCmMjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
					dwSelectedAttr |= FD_PASTE_ATTR_GRAPHICS;
				}
			}
			if ((dwSelectedAttr & FD_PASTE_ATTR_EVERY_TEXT) != FD_PASTE_ATTR_EVERY_TEXT)
			{
				// _xZkqqHx_iDiBiDjDiDgPjCiGiCmMiDgFiDeMiDfIiDgHjFjEjFgJiBgJjAhNiMgAjFjEjFgJiBgKiCpAjCiKiPgPiBeC_xHqqkZx_
				FCObjDynabase* pObj = ((FCObjGroup*)*iObj)->GetFrontEditableTextObj();
				// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJiCkKiKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
				if (pObj != NULL)
				{
					// _xZkqqHx_iDgFiDeMiDfIiDgHjBkOjAkLiCmMjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
					dwSelectedAttr |= FD_PASTE_ATTR_EVERY_TEXT;
				}
			}
		}
		if ((dwSelectedAttr & FD_PASTE_ATTR_SIZE) != FD_PASTE_ATTR_SIZE)
		{
			if ((*iObj)->GetIsResizableHorz(1.0) ||
				(*iObj)->GetIsResizableVert(1.0))
				dwSelectedAttr |= FD_PASTE_ATTR_SIZE;
		}
	}
	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMiDgGiBfLiDfOiCkJiCoHiCnNiClNiBeBjDfMiCoIjFhEiCkPiJmCjEfMiCmIjBkOjAkLiBeC_xHqqkZx_
	DWORD dwClipboardAttr = 0;
	if (IsClipboardFormatAvailable(g_cfObjFigure))
	//----- _xZkqqHx_jAhNiMgAiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBfDjBkOjAkLiCkKjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
		dwClipboardAttr |= FD_PASTE_ATTR_ALL;
	} else
	if (IsClipboardFormatAvailable(g_cfRTF))
	//----- _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHjBkOjAkLiCmMjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
		dwClipboardAttr |= FD_PASTE_ATTR_EVERY_TEXT;
	} else
	if (IsClipboardFormatAvailable(CF_UNICODETEXT) ||
		IsClipboardFormatAvailable(CF_TEXT))
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCmMiCnNjDfMiCoIjFhEiCkPiJmCjEfMiBeC_xHqqkZx_
		dwClipboardAttr |= FD_PASTE_ATTR_PLAIN_TEXT;
	}
	// _xZkqqHx_jDfMiCoIjFhEiCkPiJmCjEfMiCmIjBkOjAkLiCmNiBeBjBeJjBpAjFjEjFgJiCmGiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMjHlMjFpLiCmMjAmPiBeC_xHqqkZx_
	DWORD dwPasteAttr = dwSelectedAttr & dwClipboardAttr;
	// _xZkqqHx_iDgFiDeMiDfIiDgHjBkOjAkLiCkKiCkAiCoKiCmOiBeBiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjBkOjAkLiCpAiKePiClHiBeC_xHqqkZx_
	if ((dwPasteAttr & FD_PASTE_ATTR_TEXT) == FD_PASTE_ATTR_TEXT)
		dwPasteAttr &= ~FD_PASTE_ATTR_PLAIN_TEXT;
	// _xZkqqHx_jBkOjAkLiCpAjFnEiClHiBeC_xHqqkZx_
	return dwPasteAttr;
//----- 06.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	BOOL bCanSelectedRichText = FALSE;	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDiKiDgCiDgAiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanSelectedPlainText = FALSE;	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanSelectedSize = FALSE;		// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDfEiDeDiDfJjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanSelectedGraphics = FALSE;	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDePiDiJiDhEiDeCiDeOiDfIjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = vObj.begin();
//		 iObj != vObj.end() &&
//		 (!bCanSelectedRichText || !bCanSelectedPlainText || !bCanSelectedSize || !bCanSelectedGraphics);
//		 iObj++)
//	{
//		if ((*iObj)->IsKindOf(FDOJ_FIGURE))
//		//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			bCanSelectedRichText = TRUE;
//			bCanSelectedPlainText = TRUE;
//			bCanSelectedSize = TRUE;
//			bCanSelectedGraphics = TRUE;
//		} else
//		if ((*iObj)->IsKindOf(FDOJ_TABLE))
//		//----- _xZkqqHx_jFfMiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_(_xZkqqHx_iDePiDiLiBfLiDhGiMgOiCoGiCoIjAoGiCmJjClCiCnHiCoJiClBiCmG_xHqqkZx_) -----
//		{
//			if (!bCanSelectedPlainText)
//				bCanSelectedPlainText = TRUE;
//		} else
//		if ((*iObj)->IsKindOf(FDOJ_GROUP))
//		//----- _xZkqqHx_jFfMiMgOjFjEjFgJiImIiKePiCmMiDePiDiLiBfLiDhGiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			if (!bCanSelectedGraphics)
//			{
//				if ((*iObj)->IsMemberKindOf(FDOJ_FIGURE))
//				//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCpAiKnMiCnOiPoKiNiH_xHqqkZx_ -----
//				{
//					bCanSelectedGraphics = TRUE;
//				}
//			}
//			if (!bCanSelectedRichText ||
//				!bCanSelectedPlainText)
//			{
//				// _xZkqqHx_iDiBiDjDiDgPjCiGiCmMiDgFiDeMiDfIiDgHjFjEjFgJiBgJjAhNiMgAjFjEjFgJiBgKiCpAjCiKiPgPiBeC_xHqqkZx_
//				ObjDynabaseVector vMembObj;
//				((FCObjGroup*)*iObj)->GetCanBeTextObject(vMembObj);
//				// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJiCkKiKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
//				if (!vMembObj.empty())
//				{
//					bCanSelectedRichText = TRUE;
//					bCanSelectedPlainText = TRUE;
//				}
//			}
//		}
//		if (!bCanSelectedSize)
//		{
//			if ((*iObj)->GetIsResizableHorz(1.0) ||
//				(*iObj)->GetIsResizableVert(1.0))
//				bCanSelectedSize = TRUE;
//		}
//	}
//
//	BOOL bCanClipRichText = FALSE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDiKiDgCiDgAiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanClipPlainText = FALSE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanClipSize = FALSE;		// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDfEiDeDiDfJjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	BOOL bCanClipGraphics = FALSE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDePiDiJiDhEiDeCiDeOiDfIjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	if (IsClipboardFormatAvailable(g_cfObjFigure))
//	//----- _xZkqqHx_jAhNiMgAiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		bCanClipRichText = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDiKiDgCiDgAiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//		bCanClipPlainText = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//		bCanClipSize = TRUE;		// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDfEiDeDiDfJjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//		bCanClipGraphics = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDePiDiJiDhEiDeCiDeOiDfIjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	} else
//	if (IsClipboardFormatAvailable(g_cfRTF))
//	//----- _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		bCanClipRichText = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDiKiDgCiDgAiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//		bCanClipPlainText = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	} else
//	if (IsClipboardFormatAvailable(CF_UNICODETEXT) ||
//		IsClipboardFormatAvailable(CF_TEXT))
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		bCanClipPlainText = TRUE;	// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	}
//	DWORD dwPasteAttr = 0;
//	if (bCanSelectedRichText && bCanClipRichText)
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDiKiDgCiDgAiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	{
//		dwPasteAttr |= FD_PASTE_ATTR_TEXT;
//	} else
//	if (bCanSelectedPlainText && bCanClipPlainText)
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	{
//		dwPasteAttr |= FD_PASTE_ATTR_PLAIN_TEXT;
//	}
//	if (bCanSelectedSize && bCanClipSize)
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDfEiDeDiDfJjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	{
//		dwPasteAttr |= FD_PASTE_ATTR_SIZE;
//	}
//	if (bCanSelectedGraphics && bCanClipGraphics)
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmNiDePiDiJiDhEiDeCiDeOiDfIjDfMiCoIjFhEiCkPiJmCjEfMiCkJiBeI_xHqqkZx_
//	{
//		dwPasteAttr |= FD_PASTE_ATTR_PEN;
//		dwPasteAttr |= FD_PASTE_ATTR_BRUSH;
//		dwPasteAttr |= FD_PASTE_ATTR_EMFIMAGE;
//		dwPasteAttr |= FD_PASTE_ATTR_ARROW;
//	}
//	return dwPasteAttr;
//----- 06.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCToolBase::GetPasteOverAttr.
//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanPasteOverAs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFjEjFgJiCmMjBkOjAkLiCpAjDfMiCoIjFhEiCkPiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanPasteOverAs () const
{
//----- 06.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return (IsClipboardFormatAvailable(g_cfObjFigure) &&
//			g_pDoc->CanPasteOverAs(GetSelectLocalObjVector()));
//----- 06.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return (GetPasteOverAttr(GetSelectLocalObjVector()) != 0);
//----- 06.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanPasteOverAs.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnPasteOverAs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFjEjFgJiCmMjBkOjAkLiCpAjDfMiCoIjFhEiCkPiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnPasteOverAs ()
{
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jHjIjHhAiJmCjEfMiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
	const DWORD dwEnableFlag = GetPasteOverAttr(GetSelectLocalObjVector());
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iBhFjFjEjFgJiCmMjBkOjAkLiCpAjDfMiCoIjFhEiCkPiBhGiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	CFCDlgPasteOverAs dlg;
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	dlg.Initialize(dwEnableFlag);
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (dlg.DoModal() == IDOK)
	//----- OK_xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.11.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		g_pDoc->OnPasteOverAs(	GetSelectLocalObjVector(),
////----- 06.11.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////								dlg.GetIsCheckText(),
////								dlg.GetIsCheckPen(),
////								dlg.GetIsCheckBrush(),
////								dlg.GetIsCheckEmfImage(),
////								dlg.GetIsCheckArrow(),
////								dlg.GetIsCheckSize());
////----- 06.11.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//								dlg.GetCheckedAttr());
////----- 06.11.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.11.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiBeBjDfMiCoIjFhEiCkPiCoJjBkOjAkLiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwPasteAttr = dlg.GetCheckedAttr();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_MakeObjRectFromClipboard_xZkqqHx_iKnGjAjEjCiGiCmFiCoA_xHqqkZx_
		// _xZkqqHx_iDfCiDhNiDjDiDgIiCkKiOmAiNhDiClDiCoKiCoJiClNiCnPiBeBiClBiClBiCmFiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkNiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
		LocalObjMovedBefore(GetSelectLocalObjVector());
		// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMjBkOjAkLiCpA_xHqqkZx_ObjRect_xZkqqHx_iCmJjDmHiCnNiOoGiCoJiBeC_xHqqkZx_
		FCObjRect objRect;
		dwPasteAttr &= g_pDoc->MakeObjRectFromClipboard(objRect, dwPasteAttr);
		// _xZkqqHx_iKgFjFjEjFgJiCmJjBkOjAkLiCpAjDfMiCoIjFhEiCkPiBeC_xHqqkZx_
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
			(*iObj)->PasteOverAs(objRect, dwPasteAttr);
		// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
		LocalObjMovedAfter();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
		if (dwPasteAttr & FD_PASTE_ATTR_TEXT)
			g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
//----- 06.11.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCToolBase::OnPasteOverAs.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFindText () const
{
	return FALSE;
} // FCToolBase::CanFindText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnFindText ()
{
	if (IsFindDialogVisible())
	{
		// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetFindDialog(this)->ShowWindow(SW_HIDE);
		GetFindDialog(this)->SetWindowVisible(FALSE);
	} else
	{
		// _xZkqqHx_iCnMiClIiBeBjChFiKlHiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
		if (IsReplaceDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			GetReplaceDialog(this)->ShowWindow(SW_HIDE);
			GetReplaceDialog(this)->SetWindowVisible(FALSE);
		// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetFindDialog(this)->ShowWindow(SW_SHOW);
		GetFindDialog(this)->SetWindowVisible(TRUE);
	}
} // FCToolBase::OnFindText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanReplaceText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanReplaceText () const
{
	return FALSE;
} // FCToolBase::CanReplaceText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplaceText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnReplaceText ()
{
	if (IsReplaceDialogVisible())
	{
		// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetReplaceDialog(this)->ShowWindow(SW_HIDE);
		GetReplaceDialog(this)->SetWindowVisible(FALSE);
	} else
	{
		// _xZkqqHx_iCnMiClIiBeBiMjPiNpFiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
		if (IsFindDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			GetFindDialog(this)->ShowWindow(SW_HIDE);
			GetFindDialog(this)->SetWindowVisible(FALSE);
		// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetReplaceDialog(this)->ShowWindow(SW_SHOW);
		GetReplaceDialog(this)->SetWindowVisible(TRUE);
	}
} // FCToolBase::OnReplaceText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFindNextText () const
{
	return FALSE;
} // FCToolBase::CanFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnFindNextText ()
{
} // FCToolBase::OnFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFindPrevText () const
{
	return FALSE;
} // FCToolBase::CanFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnFindPrevText ()
{
} // FCToolBase::OnFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFindTextAll () const
{
	return FALSE;
} // FCToolBase::CanFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClFiBeBiDhBiDgCiDgHiClFiClNjFjEjFgJiCmNjBfDiCmEjBeJjBpAiPpDjBnEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeCiCnMiClNiBeBiDhBiDgCiDgHiClFiClNjFjEjFkKiDgFiDeMiDfIiDgHiCoAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnFindTextAll ()
{
} // FCToolBase::OnFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFindTextAllInSelect () const
{
	return FALSE;
} // FCToolBase::CanFindTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClFiBeBiDhBiDgCiDgHiClFiClNjFjEjFgJiCmNjBfDiCmEjBeJjBpAiPpDjBnEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeCiCnMiClNiBeBiDhBiDgCiDgHiClFiClNjFjEjFkKiDgFiDeMiDfIiDgHiCoAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnFindTextAllInSelect ()
{
} // FCToolBase::OnFindTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanReplaceNextText () const
{
	return FALSE;
} // FCToolBase::CanReplaceNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnReplaceNextText ()
{
} // FCToolBase::OnReplaceNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanReplacePrevText () const
{
	return FALSE;
} // FCToolBase::CanReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnReplacePrevText ()
{
} // FCToolBase::OnReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanReplaceTextAll () const
{
	return FALSE;
} // FCToolBase::CanReplaceTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnReplaceTextAll ()
{
} // FCToolBase::OnReplaceTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHjBfDjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanReplaceTextAllInSelect () const
{
	return FALSE;
} // FCToolBase::CanReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnReplaceTextAllInSelect ()
{
} // FCToolBase::OnReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanLayerOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiCkKjFmPiNfIiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeCiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLjFmPiNfIiCoAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanLayerOrder () const
{
//----- 06.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return FFCanEditDocumentEnv() && FFCanBasicOperate();
//----- 06.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFlGiPjBiCkK_xHqqkZx_ReadOnly_xZkqqHx_iCmFiCkAiCmBiCmEiCoAiCgOiCgKiBeC_xHqqkZx_
	return FFCanEditReadOnlyDocumentEnv();
//----- 06.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanLayerOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnLayerOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiCpAjFmPiNfIiClHiCoJiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnLayerOrder ()
{
	// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjAnNjCoIiDfPiDeDiDeBiDiNiDePiCpAiLeOjDkOiBeC_xHqqkZx_
	CFCDlgLayerOrder dlg;
	dlg.SetSheetManager(g_pDoc->GetSheetManager());
	dlg.DoModal();
} // FCToolBase::OnLayerOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveCurrentLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jFmPiNfIjAoGiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveCurrentLayer (long lIndex)
{
	// _xZkqqHx_iDiMiDeDiDiEiBfLjFmPiNfIiBeI_xHqqkZx_
	BOOL bLayerMoved = FALSE;
	if (g_pDoc->IsReadOnly())
	//----- ReadOnly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// HistViewer_xZkqqHx_iCmFiCoAjFmPiNfIiCkKiJmCjEfMiCmIiCoGiCkEiCmJiBeB_xHqqkZx_ReadOnly_xZkqqHx_iCmMiPoKiNiHiCmMiPiIjHjNiCpAjAnNiCkPiClNiBeC_xHqqkZx_
		// ReadOnly_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfCiDhNiDjDiDgIiCpAiLeMjIfOiClJiClIiBeBiDiMiDeDiDiEiBfLjFmPiNfIiCmMiCnNiNhDiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iDiMiDeDiDiEiBfLjFmPiNfIiCmMiDfCiDhNiDjDiDgIiCmNiBeB_xHqqkZx_Redo/Undo_xZkqqHx_iOjOiCmJiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpA_xHqqkZx_
		// _xZkqqHx_iOfBiPmGiClFiClNiCoIiClFiCmIiCkCiCmMiCmFiBeBiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjFmPiNfIiClFiClNiCnMiCnM_xHqqkZx_
		// Redo/Undo_xZkqqHx_iClFiCmEiCoAjGoCjBoIiCmIiCkCiBeC_xHqqkZx_

		// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmGjDkPiClGiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
		if (lIndex != g_pDoc->CurrentSheet()->GetCurrentLayerIdx())
		{
			// _xZkqqHx_iDiMiDeDiDiEiBfLjFmPiNfIiCpAjAnNjCoIiBeC_xHqqkZx_
			bLayerMoved = TRUE;
			// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
			g_pDoc->CurrentSheet()->SetCurrentLayerIdx(lIndex);
		}
	} else
	//----- Write_xZkqqHx_iJmCiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmMjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		bLayerMoved = g_pDoc->CmdSetCurrentLayer(g_pDoc->GetCurrentSheetId(), lIndex);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
	}
	if (bLayerMoved)
	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjFmPiNfIiCpAiDhCiDiFiBfLiCmJjCmKjCgNiBeCjBeJjBpAjFjEjFgJiCmMjFmPiNfIjDjJiCpAiNhDiCkEiBeC_xHqqkZx_
		g_pView->PostMessage(WM_USER_LAYER_UPDATED);
		FFGetMainWnd()->PostMessage(WM_USER_LAYER_UPDATED);
		// _xZkqqHx_iDhCiDiFiBfLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		g_pView->PostRgnRedraw(TRUE);
	}
} // FCToolBase::OnMoveCurrentLayer.

//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanMoveInLowerLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiIoKiCmCjEhHjGmKiCnGiBhGiCkKiOmAiNhDiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanMoveInLowerLayer () const
{
	return (g_pDoc->CurrentSheet()->GetCurrentLayerIdx() != 0);
} // FCToolBase::CanMoveInLowerLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveInLowerLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiIoKiCmCjEhHjGmKiCnGiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveInLowerLayer ()
{
	if (CanMoveInLowerLayer())
	{
		OnMoveCurrentLayer(g_pDoc->CurrentSheet()->GetCurrentLayerIdx() - 1);
	}
} // FCToolBase::OnMoveInLowerLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanMoveInUpperLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiIoKiCmCjBePjGmKiCnGiBhGiCkKiOmAiNhDiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanMoveInUpperLayer () const
{
	return (g_pDoc->CurrentSheet()->GetCurrentLayerIdx() !=
			g_pDoc->CurrentSheet()->GetLayerSize() - 1);
} // FCToolBase::CanMoveInUpperLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveInUpperLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiIoKiCmCjBePjGmKiCnGiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveInUpperLayer ()
{
	if (CanMoveInUpperLayer())
	{
		OnMoveCurrentLayer(g_pDoc->CurrentSheet()->GetCurrentLayerIdx() + 1);
	}
} // FCToolBase::OnMoveInUpperLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanMoveInPrevSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBePiCmMiDfGiBfLiDgHiCnGiBhGiCkKiOmAiNhDiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanMoveInPrevSheet () const
{
	const DWORD dwIndex = g_pDoc->GetSheetManager()->SheetIDToIndex(g_pDoc->GetCurrentSheetId());
	return (FFIsSheetReady() && dwIndex != 0);
} // FCToolBase::CanMoveInPrevSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveInPrevSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBePiCmMiDfGiBfLiDgHiCnGiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveInPrevSheet ()
{
	if (CanMoveInPrevSheet())
	{
		DWORD dwIndex = g_pDoc->GetSheetManager()->SheetIDToIndex(g_pDoc->GetCurrentSheetId());
		SheetID stid = g_pDoc->GetSheetManager()->SheetIndexToID(dwIndex - 1);
		OnMoveCurrentSheet(stid);
	}
} // FCToolBase::OnMoveInPrevSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanMoveInNextSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCmMiDfGiBfLiDgHiCnGiBhGiCkKiOmAiNhDiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanMoveInNextSheet () const
{
	const DWORD dwIndex = g_pDoc->GetSheetManager()->SheetIDToIndex(g_pDoc->GetCurrentSheetId());
	return (FFIsSheetReady() &&
			dwIndex != g_pDoc->GetSheetManager()->GetSheetIndexSize() - 1);
} // FCToolBase::CanMoveInNextSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveInNextSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCmMiDfGiBfLiDgHiCnGiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveInNextSheet ()
{
	if (CanMoveInNextSheet())
	{
		DWORD dwIndex = g_pDoc->GetSheetManager()->SheetIDToIndex(g_pDoc->GetCurrentSheetId());
		SheetID stid = g_pDoc->GetSheetManager()->SheetIndexToID(dwIndex + 1);
		OnMoveCurrentSheet(stid);
	}
} // FCToolBase::OnMoveInNextSheet.
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSheetOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCkKjFmPiNfIiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeCiDeKiDiMiDjDiDgHiDfGiBfLiDgHjFmPiNfIiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSheetOrder () const
{
	return FFCanEditDocumentEnv();
} // FCToolBase::CanSheetOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnSheetOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCpAjFmPiNfIiClHiCoJiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnSheetOrder ()
{
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAnNjCoIiDfPiDeDiDeBiDiNiDePiCpAiLeOjDkOiBeC_xHqqkZx_
	CFCDlgSheetOrder dlg;
	dlg.SetSheetManager(g_pDoc->GetSheetManager());
	dlg.DoModal();
} // FCToolBase::OnSheetOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanMoveCurrentSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCkKjFmPiNfIiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanMoveCurrentSheet () const
{
	return FFIsSheetReady();
} // FCToolBase::CanMoveCurrentSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnMoveCurrentSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_SendMessage_xZkqqHx_iCpAiOgHiCkCiBeBjBkGiOjOiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_jFmPiNfIjAoGiDfGiBfLiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnMoveCurrentSheet (SheetID stid)
{
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	g_pDoc->SetCurrentSheetId(stid);
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfGiBfLiDgHjFmPiNfIiCpAiDhCiDiFiBfLiCmJjCmKjCgNiBeCjBeJjBpAjFjEjFgJiCmMjFmPiNfIjDjJiCpAiNhDiCkEiBeC_xHqqkZx_
//	g_pView->SendMessage(WM_USER_SHEET_UPDATED);
//	FFGetMainWnd()->SendMessage(WM_USER_SHEET_UPDATED);
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SetClientToRgn();
	g_pView->SendRgnRedraw();
} // FCToolBase::OnMoveCurrentSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectAlignObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAkOjHpBiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectAlignObj (FTAlignType nType) const
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	switch (nType)
//	{
//	case FDAT_ALIGN_V_LEFT:		// _xZkqqHx_iNlGjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_V_RIGHT:	// _xZkqqHx_iJeFjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_H_TOP:		// _xZkqqHx_iPoDjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_H_BOTTOM:	// _xZkqqHx_iJlKjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
//		return (2 <= g_pView->SelectObjVector().size());
//	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_DIST_V:		// _xZkqqHx_iPgDiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_DIST_H:		// _xZkqqHx_iJkBiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_3_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
//		return (3 <= g_pView->SelectObjVector().size());
//	case FDAT_SAME_SIZE_X:		// _xZkqqHx_iJkBiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_SIZE_Y:		// _xZkqqHx_iPgDiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
//		return (2 <= g_pView->SelectObjVector().size());
//	}
//	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
	switch (nType)
	{
	case FDAT_ALIGN_V_LEFT:		// _xZkqqHx_iNlGjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_V_RIGHT:	// _xZkqqHx_iJeFjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_H_TOP:		// _xZkqqHx_iPoDjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_H_BOTTOM:	// _xZkqqHx_iJlKjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
		return (2 <= GetSelectLocalObjVector().size());
	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_DIST_V:		// _xZkqqHx_iPgDiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_DIST_H:		// _xZkqqHx_iJkBiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_3_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
		return (3 <= GetSelectLocalObjVector().size());
	case FDAT_SAME_SIZE_X:		// _xZkqqHx_iJkBiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_SIZE_Y:		// _xZkqqHx_iPgDiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
		return (2 <= GetSelectLocalObjVector().size());
	}
	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanObjectAlignObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectAlignObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjAkOjHpBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectAlignObj (FTAlignType nType)
{
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAiKoOiPiAjFjEjFgJiCmGiClFiCmEiOoGjDlOiBeC_xHqqkZx_
	FCObjDynabase* pObjFix = GetLastSelectLocalObj();
	if (pObjFix == NULL) return;
	ObjDynabaseVector::const_iterator iObj;
	// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMjBoFiCkLiClDiCmGjCiGjAfDjDfPiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	DBLRect mmrtFix = pObjFix->GetResizeFrame();
	DBLPoint mmptFixC = mmrtFix.CenterPoint();

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());

	switch (nType)
	{
	case FDAT_ALIGN_V_LEFT:		// _xZkqqHx_iPgDiNlGiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmrtFix.left - mmrtMov.left;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(mmMov, 0.0));
		}
		break;
	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_iPgDjCiGiJjLiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmptFixC.x - ((mmrtMov.left + mmrtMov.right) / 2.0);
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(mmMov, 0.0));
		}
		break;
	case FDAT_ALIGN_V_RIGHT:	// _xZkqqHx_iPgDiJeFiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmrtFix.right - mmrtMov.right;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(mmMov, 0.0));
		}
		break;
	case FDAT_ALIGN_H_TOP:		// _xZkqqHx_iJkBiPoDiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmrtFix.top - mmrtMov.top;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(0.0, mmMov));
		}
		break;
	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_iJkBjCiGiJjLiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmptFixC.y - ((mmrtMov.top + mmrtMov.bottom) / 2.0);
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(0.0, mmMov));
		}
		break;
	case FDAT_ALIGN_H_BOTTOM:	// _xZkqqHx_iJkBiJlKiCmJjAkOjHpBiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiInKjDkOiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmrtFix.bottom - mmrtMov.bottom;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(*iObj, DBLPoint(0.0, mmMov));
		}
		break;
	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDjDjJiKnEiKhFiCmFjAkOjHpBiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iPgDiCmJjFmAiCnHjBnGiCkGiClNjFjEjFgJjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		ObjDynabaseVector vSorted;
		mySortObjVert(vSorted, GetSelectLocalObjVector());
		double mmHH = 0.0;
		double mmHeight = vSorted.back()->GetResizeFrame().bottom -
									vSorted.front()->GetResizeFrame().top;
		for (iObj = vSorted.begin(); iObj != vSorted.end(); iObj++)
			mmHH += (*iObj)->GetResizeFrame().Height();
		double mmGap = (mmHeight - mmHH) / (vSorted.size() - 1);

		double mmYY = vSorted.front()->GetResizeFrame().bottom + mmGap;
		for (int iCnt = 1; iCnt < vSorted.size() - 1; iCnt++)
		{
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmYY - vSorted[iCnt]->GetResizeFrame().top;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(vSorted[iCnt], DBLPoint(0.0, mmMov));
			// _xZkqqHx_iOjPiCmMiKeKiOgOiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
			mmYY += mmGap + vSorted[iCnt]->GetResizeFrame().Height();
		}
		break;
	  }
	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBjDjJiKnEiKhFiCmFjAkOjHpBiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iJkBiCmJjFmAiCnHjBnGiCkGiClNjFjEjFgJjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		ObjDynabaseVector vSorted;
		mySortObjHorz(vSorted, GetSelectLocalObjVector());
		double mmWW = 0.0;
		double mmWidth = vSorted.back()->GetResizeFrame().right -
								vSorted.front()->GetResizeFrame().left;
		for (iObj = vSorted.begin(); iObj != vSorted.end(); iObj++)
			mmWW += (*iObj)->GetResizeFrame().Width();
		double mmGap = (mmWidth - mmWW) / (vSorted.size() - 1);

		double mmYY = vSorted.front()->GetResizeFrame().right + mmGap;
		for (int iCnt = 1; iCnt < vSorted.size() - 1; iCnt++)
		{
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmYY - vSorted[iCnt]->GetResizeFrame().left;
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(vSorted[iCnt], DBLPoint(mmMov, 0.0));
			// _xZkqqHx_iOjPiCmMiKeKiOgOiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
			mmYY += mmGap + vSorted[iCnt]->GetResizeFrame().Width();
		}
		break;
	  }
	case FDAT_SAME_DIST_V:		// _xZkqqHx_iPgDjDjJiLjHjHkDiCmFjAkOjHpBiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iPgDiCmJjFmAiCnHjBnGiCkGiClNjFjEjFgJjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		ObjDynabaseVector vSorted;
		mySortObjVert(vSorted, GetSelectLocalObjVector());
		double mmTopC = (vSorted.front()->GetResizeFrame().top +
							vSorted.front()->GetResizeFrame().bottom) / 2.0;
		double mmBtmC = (vSorted.back()->GetResizeFrame().top +
							vSorted.back()->GetResizeFrame().bottom) / 2.0;
		double mmGap = (mmBtmC - mmTopC) / (vSorted.size() - 1);

		for (int iCnt = 1; iCnt < vSorted.size() - 1; iCnt++)
		{
			// _xZkqqHx_iOjPiCmMiKeKiOgOiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmYY = mmTopC + (iCnt * mmGap);
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmYY -
							((vSorted[iCnt]->GetResizeFrame().top +
								vSorted[iCnt]->GetResizeFrame().bottom) / 2.0);
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(vSorted[iCnt], DBLPoint(0.0, mmMov));
		}
		break;
	  }
	case FDAT_SAME_DIST_H:		// _xZkqqHx_iJkBjDjJiLjHjHkDiCmFjAkOjHpBiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iPgDiCmJjFmAiCnHjBnGiCkGiClNjFjEjFgJjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		ObjDynabaseVector vSorted;
		mySortObjHorz(vSorted, GetSelectLocalObjVector());
		double mmLeftC = (vSorted.front()->GetResizeFrame().left +
							vSorted.front()->GetResizeFrame().right) / 2.0;
		double mmRightC = (vSorted.back()->GetResizeFrame().left +
							vSorted.back()->GetResizeFrame().right) / 2.0;
		double mmGap = (mmRightC - mmLeftC) / (vSorted.size() - 1);

		for (int iCnt = 1; iCnt < vSorted.size() - 1; iCnt++)
		{
			// _xZkqqHx_iOjPiCmMiKeKiOgOiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmXX = mmLeftC + (iCnt * mmGap);
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			double mmMov = mmXX -
							((vSorted[iCnt]->GetResizeFrame().left +
								vSorted[iCnt]->GetResizeFrame().right) / 2.0);
			// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdMove1Obj(vSorted[iCnt], DBLPoint(mmMov, 0.0));
		}
		break;
	  }
	case FDAT_SAME_SIZE_X:		// _xZkqqHx_jDkPiClGiChHiDfEiDeDiDfJiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiDiKiDfEiDeDiDfJiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			double mmWide = (mmrtFix.Width() - mmrtMov.Width()) / 2.0;
			mmrtMov.left -= mmWide;
			mmrtMov.right += mmWide;
			// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIiCmMjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdResize1Obj(*iObj, mmrtMov);
		}
		break;
	case FDAT_SAME_SIZE_Y:		// _xZkqqHx_jDkPiClGiChIiDfEiDeDiDfJiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			// _xZkqqHx_iKoOiPiAjFjEjFgJiCmMiPoKiNiHiCmNiDiKiDfEiDeDiDfJiClJiClIiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (pObjFix == *iObj) continue;
			DBLRect mmrtMov = (*iObj)->GetResizeFrame();
			double mmWide = (mmrtFix.Height() - mmrtMov.Height()) / 2.0;
			mmrtMov.top -= mmWide;
			mmrtMov.bottom += mmWide;
			// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIiCmMjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdResize1Obj(*iObj, mmrtMov);
		}
		break;
	}

	// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

} // FCToolBase::OnObjectAlignObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectRotateObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiJpBjDfNiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectRotateObj () const
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		// _xZkqqHx_iIoKiCmCiCmFiCoAiJpBjDfNjFhDiJmCjEfMiCmIjFjEjFgJiCkKiCkAiCoKiCmOiBeBjFhDiJmCiBeC_xHqqkZx_
//		if (!(*iObj)->CanRotate()) return FALSE;
//	}
//	return TRUE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = GetSelectLocalObjVector().begin();
//		 iObj != GetSelectLocalObjVector().end(); iObj++)
//	{
//		// _xZkqqHx_iIoKiCmCiCmFiCoAiJpBjDfNjFhDiJmCjEfMiCmIjFjEjFgJiCkKiCkAiCoKiCmOiBeBjFhDiJmCiBeC_xHqqkZx_
//		if (!(*iObj)->CanRotate()) return FALSE;
//	}
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanObjectRotateObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectRotateObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiJpBjDfNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_iJpBjDfNiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectRotateObj (double dR)
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (dR == 0.0) return;
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiBeBiJpBjDfNjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
//
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		// _xZkqqHx_jFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//		const DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
//		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//		g_pDoc->CmdRotate1Obj(*iObj, dR, mmrtFrame.CenterPoint());
//	}
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiBeBiJpBjDfNiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
//
//	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(g_pView->SelectObjVector());
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (dR == 0.0) return;
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());

	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
		const DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
		// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->CmdRotate1Obj(*iObj, dR, mmrtFrame.CenterPoint());
	}

	// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnObjectRotateObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMirrorObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNlGiJeFiBeFiPoDiJlKjElNjDfNiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:FDMR_MIRROR_HORZ,	// _xZkqqHx_iNlGiJeFiLhEjDfNiBeC_xHqqkZx_
 *					 FDMR_MIRROR_VERT,	// _xZkqqHx_iPoDiJlKiLhEjDfNiBeCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMirrorObj (FTMirrorType nType) const
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	const BOOL bXPosi = (nType == FDMR_MIRROR_HORZ) ? TRUE : FALSE;
//	const BOOL bYPosi = (nType == FDMR_MIRROR_VERT) ? TRUE : FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
//		// _xZkqqHx_iIoKiCmCiCmFiCoAjElNjDfNjFhDiJmCjEfMiCmIjFjEjFgJiCkKiCkAiCoKiCmOiBeB_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
//		if (!(*iObj)->IsResizable(bXPosi, bYPosi, mmrtFrame)) return FALSE;
//	}
//	return TRUE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	const BOOL bXPosi = (nType == FDMR_MIRROR_HORZ) ? TRUE : FALSE;
//	const BOOL bYPosi = (nType == FDMR_MIRROR_VERT) ? TRUE : FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = GetSelectLocalObjVector().begin();
//		 iObj != GetSelectLocalObjVector().end(); iObj++)
//	{
//		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
//		// _xZkqqHx_iIoKiCmCiCmFiCoAjElNjDfNjFhDiJmCjEfMiCmIjFjEjFgJiCkKiCkAiCoKiCmOiBeB_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
//		if (!(*iObj)->IsResizable(bXPosi, bYPosi, mmrtFrame)) return FALSE;
//	}
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanObjectMirrorObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMirrorObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNlGiJeFiBeFiPoDiJlKjElNjDfNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:FDMR_MIRROR_HORZ,	// _xZkqqHx_iNlGiJeFiLhEjDfNiBeC_xHqqkZx_
 *					 FDMR_MIRROR_VERT,	// _xZkqqHx_iPoDiJlKiLhEjDfNiBeCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMirrorObj (FTMirrorType nType)
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	//----- _xZkqqHx_iInKjDkOjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddEmptyRgn();
//	ObjDynabaseVector::const_iterator iObj;
//	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		// _xZkqqHx_jFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
//		// _xZkqqHx_iDhOiDiJiBfLiDiKiDjDiDePiCmMiOhHiOkGiCmJiPfNiCmBiCmEiBeBiNlGiJeFiBeFiPoDiJlKiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
//		if (nType == FDMR_MIRROR_HORZ)
//			Exchange(mmrtFrame.left, mmrtFrame.right);
//		else
//			Exchange(mmrtFrame.top, mmrtFrame.bottom);
//		// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIiCmMjEkNiNhDiBeC_xHqqkZx_
//		g_pDoc->CmdResize1Obj(*iObj, mmrtFrame);
//	}
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiBeBiInKjDkOiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
//	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(g_pView->SelectObjVector());
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());

	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
		DBLRect mmrtFrame = (*iObj)->GetResizeFrame();
		// _xZkqqHx_iDhOiDiJiBfLiDiKiDjDiDePiCmMiOhHiOkGiCmJiPfNiCmBiCmEiBeBiNlGiJeFiBeFiPoDiJlKiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
		if (nType == FDMR_MIRROR_HORZ)
			Exchange(mmrtFrame.left, mmrtFrame.right);
		else
			Exchange(mmrtFrame.top, mmrtFrame.bottom);
		// _xZkqqHx_iDiKiDfEiDeDiDfJiDfCiDhNiDjDiDgIiCmMjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->CmdResize1Obj(*iObj, mmrtFrame);
	}

	// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 01.08.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnObjectMirrorObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectFrontObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiIoKiCmCjBePiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectFrontObj () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	return FFCanEditSelected();
} // FCToolBase::CanObjectFrontObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectFrontObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiIoKiCmCjBePiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectFrontObj ()
{
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMjDpMiCoKjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
	ObjDynabaseVector vMoved;
	g_pDoc->CmdMoveViewFrontObjs(vMoved, g_pView->SelectObjVector());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (!vMoved.empty())
	//----- _xZkqqHx_iCfAiCmCiCmFiCoAjFjEjFgJiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmGiNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
		g_pView->AddEmptyRgn();
		g_pView->AppendToLastRgn(vMoved);
		g_pView->SendRgnRedraw();
	}
} // FCToolBase::OnObjectFrontObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectBackObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiIoKiCmCiMoDiCoLiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectBackObj () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	return FFCanEditSelected();
} // FCToolBase::CanObjectBackObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectBackObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiIoKiCmCiMoDiCoLiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectBackObj ()
{
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMjDpMiCoKjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
	ObjDynabaseVector vMoved;
	g_pDoc->CmdMoveViewBackObjs(vMoved, g_pView->SelectObjVector());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (!vMoved.empty())
	//----- _xZkqqHx_iCfAiCmCiCmFiCoAjFjEjFgJiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmGiNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
		g_pView->AddEmptyRgn();
		g_pView->AppendToLastRgn(vMoved);
		g_pView->SendRgnRedraw();
	}
} // FCToolBase::OnObjectBackObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMostFrontObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiNmFiCoAjBePiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMostFrontObj () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	return FFCanEditSelected();
} // FCToolBase::CanObjectMostFrontObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMostFrontObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiNmFiCoAjBePiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMostFrontObj ()
{
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMjDpMiCoKjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
	BOOL bModified = g_pDoc->CmdMoveViewMostFrontObjs(g_pView->SelectObjVector());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (bModified)
	//----- _xZkqqHx_iCfAiCmCiCmFiCoAjFjEjFgJiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmGiNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
		g_pView->AddEmptyRgn();
		// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(g_pView->SelectObjVector());
		g_pView->SendRgnRedraw();
	}
} // FCToolBase::OnObjectMostFrontObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMostBackObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiNmFiCoAiMoDiCoLiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMostBackObj () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	return FFCanEditSelected();
} // FCToolBase::CanObjectMostBackObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMostBackObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiNmFiCoAiMoDiCoLiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMostBackObj ()
{
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMjDpMiCoKjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
	BOOL bModified = g_pDoc->CmdMoveViewMostBackObjs(g_pView->SelectObjVector());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
//----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (bModified)
	//----- _xZkqqHx_iCfAiCmCiCmFiCoAjFjEjFgJiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmGiNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
		g_pView->AddEmptyRgn();
		// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(g_pView->SelectObjVector());
		g_pView->SendRgnRedraw();
	}
} // FCToolBase::OnObjectMostBackObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanFormatText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanFormatText () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiIoKiCmCiCmFiCoAiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiCgOiCgK_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanFormatText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFormatText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMjAnNjCoIiOjOiCmJiMmEiCmOiCoKiCoJ_xHqqkZx_.
 *************************************************************************/
void FCToolBase::OnFormatText ()
{
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJ_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeCiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePjCiGiCmMjAeGiDgFiBfLiDhFiDiLiCmMjFnCiPfHiCmFiCoAiDfCiDhNiDjDiDgIjEkNiNhDiCmJjCiNiInDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	CFCDlgFontSelect dlg;
	dlg.SetCallback(GetFontInfoProc, SetFontInfoProc, &vTextObj);
	(void)dlg.DoModal();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
} // FCToolBase::OnFormatText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanTextLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiKnEiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanTextLine () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiIoKiCmCiCmFiCoAiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiCgOiCgK_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanTextLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTextLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiKnEiCmMjAnNjCoIiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnTextLine ()
{
	CFCDlgTextLine dlg;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJ_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	dlg.SetTextObjects(vTextObj);
	dlg.DoModal();
} // FCToolBase::OnTextLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanTextMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjHfNjEjCiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanTextMargin () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiIoKiCmCiCmFiCoAiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiCgOiCgK_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanTextMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnTextMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjHfNjEjCiCmMjAnNjCoIiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnTextMargin ()
{
	CFCDlgTextMargin dlg;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJ_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	dlg.SetTextObjects(vTextObj);
	dlg.DoModal();
} // FCToolBase::OnTextMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCoJiClBiCmGiCkKiPgPjHiIiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeDjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanAlignText () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiIoKiCmCiCmFiCoAiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiCgOiCgK_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetTextAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCkKjFhDjGlOiCmMiPoKiNiHiCmNiCePiBeDiClLiCoKiImIiKePiCmNiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolBase::GetTextAlignment () const
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmFiBeBjDkPiClGiDgFiDeMiDfIiDgHiKpBiClJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClH_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj = vTextObj.begin();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	int iAlign = ((FCObjFigure*)*iObj)->GetRichText()->GetAlignment();
//	for (; iObj != vTextObj.end(); iObj++)
//		if (iAlign != ((FCObjFigure*)*iObj)->GetRichText()->GetAlignment())
//			return FDRC_AL_NONE;
//	return iAlign;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCTextLineInfo tli;
	((FCObjFigure*)*iObj)->GetRichText()->GetLineInfo(tli, TRUE);
	for (iObj++; iObj != vTextObj.end(); iObj++)
		((FCObjFigure*)*iObj)->GetRichText()->GetLineInfo(tli, FALSE);
	if (tli.dwMask & FDTL_FLAG_ALIGNMENT)
	{
		return tli.byAlignment;		// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgK_xHqqkZx_
	} else
	{
		return FDRC_AL_NONE;
	}
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::GetTextAlignment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiKpBiClJiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iAlign	:_xZkqqHx_iKpBiClJiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnAlignText (int iAlign)
{
	// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDkPiClGiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	if (GetTextAlignment() == iAlign) return;
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmJiBeBiDgFiDeMiDfIiDgHiKpBiClJiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj;
	for (iObj = vTextObj.begin(); iObj != vTextObj.end(); iObj++)
	{
		FCObjFigure* pFig = (FCObjFigure*)*iObj;
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->BeforeCmdModifyAbcRichText(pFig);
		// _xZkqqHx_iDgFiDeMiDfIiDgHiKpBiClJ_xHqqkZx_ _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		BYTEVector byvQueue;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pRich->SetAlignment(byvQueue, iAlign, (FCObjFigure*)*iObj);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCTextLineInfo tli;
		tli.dwMask = FDTL_FLAG_ALIGNMENT;
		tli.byAlignment = BYTE(iAlign);
		pFig->GetRichText()->SetLineInfo(byvQueue, tli, pFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		if (!byvQueue.empty())
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyAbcRichText(pFig, byvQueue.size(), byvQueue.begin());
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(pFig);
		}
	}
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
} // FCToolBase::OnAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanVertAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiPoDiJlKiKpBiClJiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCoJiClBiCmGiCkKiPgPjHiIiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeDjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanVertAlignText () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiIoKiCmCiCmFiCoAiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCkKiCkAiCoKiCmOiCgOiCgK_xHqqkZx_ -----
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	return !vTextObj.empty();
} // FCToolBase::CanVertAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetTextVertAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiPoDiJlKiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCkKjFhDjGlOiCmMiPoKiNiHiCmNiCePiBeDiClLiCoKiImIiKePiCmNiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolBase::GetTextVertAlignment () const
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmFiBeBjDkPiClGiDgFiDeMiDfIiDgHiKpBiClJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClH_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj = vTextObj.begin();
	int iAlign = ((FCObjFigure*)*iObj)->GetRichText()->GetVertAlignment();
	for (; iObj != vTextObj.end(); iObj++)
		if (iAlign != ((FCObjFigure*)*iObj)->GetRichText()->GetVertAlignment())
			return FDRC_AL_NONE;
	return iAlign;
} // FCToolBase::GetTextVertAlignment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnVertAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPoDiJlKiKpBiClJiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iAlign	:_xZkqqHx_iKpBiClJiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnVertAlignText (int iAlign)
{
	// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDkPiClGiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	if (GetTextVertAlignment() == iAlign) return;
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjBfDjFjEjFgJiCpAiMjPiNlIiClFiBeBiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vTextObj;
// 02.10.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjFnCiPfHjCiGiCmJiBeBiCfAiCmCjFjEjFgJiCpAjBeJjBpAiClFiCmEiBeBiDhEiDeIiDjDiDgHjAnNjCoIiCpAiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGjFjEjFgJjBfDjBmMiCmMiDhEiDeIiDjDiDgHiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_)
//	::mySelectTextObj(vTextObj, g_pView->SelectObjVector());
	::mySelectTextObj(vTextObj, GetSelectLocalObjVector());
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmJiBeBiDgFiDeMiDfIiDgHiKpBiClJiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj;
	for (iObj = vTextObj.begin(); iObj != vTextObj.end(); iObj++)
	{
		FCRichText* pRich = ((FCObjFigure*)*iObj)->GetRichText();
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->BeforeCmdModifyAbcRichText((FCObjFigure*)*iObj);
		// _xZkqqHx_iDgFiDeMiDfIiDgHiKpBiClJ_xHqqkZx_ _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		BYTEVector byvQueue;
		pRich->SetVertAlignment(byvQueue, iAlign, (FCObjFigure*)*iObj);
		if (!byvQueue.empty())
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyAbcRichText((FCObjFigure*)*iObj,
											byvQueue.size(), byvQueue.begin());
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(*iObj);
		}
	}
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
} // FCToolBase::OnVertAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectPutRtfObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFjEjFgJiCpAjDfJjFhEiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectPutRtfObj () const
{
	if (!FFCanCreateObject()) return FALSE;
	if (g_pView->SelectObjVector().size() == 1) return TRUE;
	return FALSE;
} // FCToolBase::CanObjectPutRtfObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectPutRtfObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFjEjFgJiCpAjDfJjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.06.27 Fukushiro M. _xZkqqHx_iLoJiMgAjFjEjFgJiCmJjFmPiNfIiBeC_xHqqkZx_
 *			00.02.03 Fukushiro M. FCToolSelEdit_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectPutRtfObj ()
{
//----- 06.05.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiCmGiBeBiClLiCmMjFjEjFgJiCpAiMlDiCmJiDgFiDeMiDfIiDgHjFjEjFgJiCpAiNoMjAkMiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	// _xZkqqHx_iCmHiCkEiClJiBeBjAfGiLeLiNoMjAkMiClDiCoKiCoJiDgFiDeMiDfIiDgHjFjEjFgJiCkKjBeJjBpAiClDiCoKiCoJiCmMiClOiCkJiCoHiBeB_xHqqkZx_
//	// _xZkqqHx_iClBiClBiCmFjBeJjBpAiJpAiPjMiClFiCmEiCoAjGoCjBoIjGlDiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClFiBeBjBeJjBpAjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
//	g_pView->ClearSelectObj(TRUE);
//	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//	CPoint lgptLast = mm2lg(g_pView->GetLastPoint());
//	g_pView->LPtoDP(lgptLast);
//	POINTS pnt = {lgptLast.x, lgptLast.y};
////----- 06.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDgFiDeMiDfIiDgHjDfJjFhEiDgDiBfLiDiLiCmJjFmPiNfIiBeC_xHqqkZx_
////	g_pView->PostMessage(WM_COMMAND, ID_TOOL_TEXT_PUT, (LPARAM)0);
////----- 06.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjDfJjFhEiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
//	SetNextTool(ID_TOOL_TEXT_PUT);
//	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiDgDiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
//	SetLockStatus(FALSE);
//	EndOfSession();
////----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
//	LPARAM lParam = *((LPARAM*)&pnt);
//	FFPostSendMessage(FD_PMSG_VIEW, WM_LBUTTONDOWN, 0, lParam);
//	FFPostSendMessage(FD_PMSG_VIEW, WM_LBUTTONUP, 0, lParam);
//----- 06.05.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMjAjEiCmNiCfAiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (g_pView->SelectObjVector().size() != 1)
		FFThrowMiscUnknown();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiBeC_xHqqkZx_
	const FCObjDynabase* pObj = g_pView->SelectObjVector().front();
	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCmJiNmFiCoAiLnPiCkC_xHqqkZx_MOLIP_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jFeLiClIiOoGjDlOiCmFiCkLiCoJiCmNiClIiClOiCkKiBeBjGjMiCkKiIoKiOoGjDlOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	long lHitMolip;
	DBLPoint mmptHitPos;
	if (FCLinkManager::GetHitOnMolipDetail(	lHitMolip,
											mmptHitPos,
											pObj,
											g_pView->GetLastPoint(),
											DBL_MAX,
											DBL_MAX,
											NULL,
											FALSE) == FDPA_HIT_NOT_MOLIP)
		return;

	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiCmGiBeBiClLiCmMjFjEjFgJiCpAiMlDiCmJiDgFiDeMiDfIiDgHjFjEjFgJiCpAiNoMjAkMiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iCmHiCkEiClJiBeBjAfGiLeLiNoMjAkMiClDiCoKiCoJiDgFiDeMiDfIiDgHjFjEjFgJiCkKjBeJjBpAiClDiCoKiCoJiCmMiClOiCkJiCoHiBeB_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFjBeJjBpAiJpAiPjMiClFiCmEiCoAjGoCjBoIjGlDiCkCiBeC_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClFiBeBjBeJjBpAjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiImKjChFiCmJiNmFiCoAiLnPiCkC_xHqqkZx_MOLIP_xZkqqHx_iNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint lgptMolip = mm2lg(mmptHitPos);
	g_pView->LPtoDP(lgptMolip);
	POINTS pntMolip = {lgptMolip.x, lgptMolip.y};
	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint lgptLast = mm2lg(g_pView->GetLastPoint());
	g_pView->LPtoDP(lgptLast);
	POINTS pntLast = {lgptLast.x, lgptLast.y};

	// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjDfJjFhEiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
	SetNextTool(ID_TOOL_TEXT_PUT);
	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiDgDiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
	SetLockStatus(FALSE);
	EndOfSession();
	//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
	LPARAM lParamA = *((LPARAM*)&pntMolip);
	LPARAM lParamB = *((LPARAM*)&pntLast);
	FFPostSendMessage(FD_PMSG_VIEW, WM_LBUTTONDOWN, 0, lParamA);
	FFPostSendMessage(FD_PMSG_VIEW, WM_MOUSEMOVE, 0, lParamB);
	FFPostSendMessage(FD_PMSG_VIEW, WM_LBUTTONUP, 0, lParamB);
//----- 06.05.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnObjectPutRtfObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsEditingText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjCiGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsEditingText () const
{
	return FALSE;
} // FCToolBase::IsEditingText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnStopToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFnCiPfHiPeJjHlJiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiClBiCmJjHiIiClNiOjOiCmNiLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiNmFjCiGiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnStopToEditText ()
{
} // FCToolBase::OnStopToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectInsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCkKjBhNjDpMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectInsertJoint () const
{
	return FALSE;
} // FCToolBase::CanObjectInsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectInsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectInsertJoint ()
{
} // FCToolBase::OnObjectInsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectConnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnKjBlBiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnKjBlBiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectConnect () const
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		if ((*iObj)->Type() == FDOJ_POLY && !(*iObj)->IsClosePolygon()) return TRUE;
//		if ((*iObj)->Type() == FDOJ_ARC && !(*iObj)->IsClosePolygon()) return TRUE;
//	}
//	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->Type() == FDOJ_POLY && !(*iObj)->IsClosePolygon()) return TRUE;
		if ((*iObj)->Type() == FDOJ_ARC && !(*iObj)->IsClosePolygon()) return TRUE;
	}
	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanObjectConnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectConnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjAnKjBlBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectConnect ()
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		if ((*iObj)->Type() == FDOJ_POLY && !(*iObj)->IsClosePolygon())
//		{
//			//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiDfCiDhNiDjDiDgI_xHqqkZx_ -----
//			FCPolyLinkRec rec;
//			rec.wMask = FDFP_ISOPENPOLYJOINT;
//			rec.bIsOpenPolyJoint = FALSE;
//			g_pDoc->CmdModifyPolyLink((FCObjPoly*)*iObj, rec);
//			// _xZkqqHx_jFmPiNfIiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(*iObj);
//		} else
//		if ((*iObj)->Type() == FDOJ_ARC && !(*iObj)->IsClosePolygon())
//		{
//			// _xZkqqHx_iDfCiDhNiDjDiDgIjHhAiDiMiDfCiBfLiDgIjFmPjAjEiBeC_xHqqkZx_
//			FCArcRec rec;
//			rec.wMask = FDFP_ARCTYPE;
//			rec.nArcType = FDOA_CHORD;
//			g_pDoc->CmdModifyArc((FCObjArc*)*iObj, rec);
//			// _xZkqqHx_jFmPiNfIiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(*iObj);
//		}
//	}
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
//	g_pView->SendRgnRedraw();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());

	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->Type() == FDOJ_POLY && !(*iObj)->IsClosePolygon())
		{
			//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiDfCiDhNiDjDiDgI_xHqqkZx_ -----
			FCPolyLinkRec rec;
			rec.wMask = FDFP_ISOPENPOLYJOINT;
			rec.bIsOpenPolyJoint = FALSE;
			g_pDoc->CmdModifyPolyLink((FCObjPoly*)*iObj, rec);
		} else
		if ((*iObj)->Type() == FDOJ_ARC && !(*iObj)->IsClosePolygon())
		{
			// _xZkqqHx_iDfCiDhNiDjDiDgIjHhAiDiMiDfCiBfLiDgIjFmPjAjEiBeC_xHqqkZx_
			FCArcRec rec;
			rec.wMask = FDFP_ARCTYPE;
			rec.nArcType = FDOA_CHORD;
			g_pDoc->CmdModifyArc((FCObjArc*)*iObj, rec);
		}
	}
	// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnObjectConnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectDisconnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjDfPiCkKjAnKjBlBiJpAiPjMiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnKjBlBiJpAiPjMiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectDisconnect () const
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		if ((*iObj)->Type() == FDOJ_POLY && (*iObj)->IsClosePolygon()) return TRUE;
//		if ((*iObj)->Type() == FDOJ_ARC && (*iObj)->IsClosePolygon()) return TRUE;
//	}
//	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->Type() == FDOJ_POLY && (*iObj)->IsClosePolygon()) return TRUE;
		if ((*iObj)->Type() == FDOJ_ARC && (*iObj)->IsClosePolygon()) return TRUE;
	}
	return FALSE;
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanObjectDisconnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectDisconnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjAnKjBlBiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectDisconnect ()
{
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		if ((*iObj)->Type() == FDOJ_POLY && (*iObj)->IsClosePolygon())
//		{
//			// _xZkqqHx_jFmPiNfIjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(*iObj);
//			//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiDfCiDhNiDjDiDgI_xHqqkZx_ -----
//			FCPolyLinkRec rec;
//			rec.wMask = FDFP_ISOPENPOLYJOINT;
//			rec.bIsOpenPolyJoint = TRUE;
//			g_pDoc->CmdModifyPolyLink((FCObjPoly*)*iObj, rec);
//		} else
//		if ((*iObj)->Type() == FDOJ_ARC && (*iObj)->IsClosePolygon())
//		{
//			// _xZkqqHx_jFmPiNfIjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(*iObj);
//			// _xZkqqHx_iDfCiDhNiDjDiDgIjHhAiDiMiDfCiBfLiDgIjFmPjAjEiBeC_xHqqkZx_
//			FCArcRec rec;
//			rec.wMask = FDFP_ARCTYPE;
//			rec.nArcType = FDOA_ARC;
//			g_pDoc->CmdModifyArc((FCObjArc*)*iObj, rec);
//		}
//	}
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	OnDraw(&dc);
////----- 01.08.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
//	g_pView->SendRgnRedraw();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());

	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->Type() == FDOJ_POLY && (*iObj)->IsClosePolygon())
		{
			//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiDfCiDhNiDjDiDgI_xHqqkZx_ -----
			FCPolyLinkRec rec;
			rec.wMask = FDFP_ISOPENPOLYJOINT;
			rec.bIsOpenPolyJoint = TRUE;
			g_pDoc->CmdModifyPolyLink((FCObjPoly*)*iObj, rec);
		} else
		if ((*iObj)->Type() == FDOJ_ARC && (*iObj)->IsClosePolygon())
		{
			// _xZkqqHx_iDfCiDhNiDjDiDgIjHhAiDiMiDfCiBfLiDgIjFmPjAjEiBeC_xHqqkZx_
			FCArcRec rec;
			rec.wMask = FDFP_ARCTYPE;
			rec.nArcType = FDOA_ARC;
			g_pDoc->CmdModifyArc((FCObjArc*)*iObj, rec);
		}
	}

	// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.08.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::OnObjectDisconnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectCrossSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjBlMiDfGiBfLiDgHiCnGiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectCrossSheet () const
{
	return FFCanEditDocument() &&
			!g_pDoc->IsOleDocumentsOpened() &&
			!g_pView->GetCurrentTool()->IsEditingText() &&
			!g_pView->SelectObjVector().empty();
} // FCToolBase::CanObjectCrossSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectCrossSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjBlMiDfGiBfLiDgHiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectCrossSheet ()
{
	// _xZkqqHx_iDfGiBfLiDgHiInKjDkOiDfPiDeDiDeBiDiNiDePiCpAiLeOjDkOiBeC_xHqqkZx_
	CFCDLgCrossSheet dlg;
	dlg.DoModal();
} // FCToolBase::OnObjectCrossSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectSizeToText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDgFiDeMiDfIiDgHiCmJiDfEiDeDiDfJiNiHiCoNiClJiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectSizeToText () const
{
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeJiBfLiDgPiBfLiCmMjFjEjFgJiMjPiNpF_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJjCiGiCmMiBeB_xHqqkZx_OBJ_FIGURE_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		ObjDynabaseVector vFigObj;
		(*iObj)->GetKindOfMembers(vFigObj, FDOJ_FIGURE);
		ObjDynabaseVector::const_iterator iFig;
		for (iFig = vFigObj.begin(); iFig != vFigObj.end(); iFig++)
		{
			const FCObjFigure* pFig = (const FCObjFigure*)*iFig;
//----- 05.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (pFig->GetRichText() != NULL)
//				if (pFig->GetRichText()->IsTextOver()) return TRUE;
//----- 05.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (pFig->GetRichText() != NULL) return TRUE;
//----- 05.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	return FALSE;
} // FCToolBase::CanObjectSizeToText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectSizeToText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDgFiDeMiDfIiDgHiCmJiDfEiDeDiDfJiNiHiCoNiClJiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectSizeToText ()
{
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	OnDraw(&dc);
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_jFjEjFgJiCkKiIoKiCmCiCmFiCoAjClCjAkOiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bAdjusted = FALSE;
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeJiBfLiDgPiBfLiCmMjFjEjFgJiMjPiNpF_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		if ((*iObj)->GetMemberSize() == 0)
		//----- _xZkqqHx_jFjEjFgJiDiBiDjDiDgPiBfLiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if ((*iObj)->GetRichText() != NULL)
			//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiCmCiPoKiNiH_xHqqkZx_ -----
			{
				WORD wFixResizeByText = (*iObj)->GetStdFixResizeByText();
				BOOL bIsTextResizeShorten = (*iObj)->GetIsShortenByText();
//----- 05.08.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				if (wFixResizeByText == FD_RPT_NONE)
//				//----- _xZkqqHx_iKgHjBoFiBeFiPgLiPkMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//				{
//					wFixResizeByText = g_pReg->GetResizeFixPosition();
//					bIsTextResizeShorten = TRUE;
//				}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				// _xZkqqHx_iKgHjBoFiBeFiPgLiPkMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiOjPiCmMjFjEjFgJiCnGiBeC_xHqqkZx_
				if (wFixResizeByText == FD_RPT_NONE) continue;
//----- 05.08.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
				// _xZkqqHx_iMlLiNnNiCmMiDfEiDeDiDfJiCmJjBmOiClHiCoJjEhLjHkGiBeC_xHqqkZx_
				double dRatioX;
				double dRatioY;
				// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiIoMiCoKiCmIiCkCiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
				(*iObj)->GetRichText()->CalcTextFitSize(dRatioX, dRatioY,
														(const FCObjFigure*)(*iObj),
														wFixResizeByText,
														bIsTextResizeShorten);
				if (!almosteq(dRatioX, 1.0) || !almosteq(dRatioY, 1.0))
				//----- _xZkqqHx_iDfEiDeDiDfJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
					const DBLPoint mmptFixPoint = (*iObj)->CalcFixPointForTextResize(	wFixResizeByText,
																						(*iObj)->GetTextAngle());
					// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
					g_pView->AppendToLastRgn(*iObj);
					// _xZkqqHx_jFjEjFgJiCmJiNiHiCoNiClJiCmEiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
					(*iObj)->AdjustObjectSize(*iObj, dRatioX, dRatioY, mmptFixPoint);
					// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
					g_pView->AppendToLastRgn(*iObj);
					// _xZkqqHx_iIoKiCmCiCmFiCoAjClCjAkOiClDiCoKiClNiCkJiBeI_xHqqkZx_
					bAdjusted = TRUE;
				}
			}
		} else
		//----- _xZkqqHx_jFjEjFgJiDiBiDjDiDgPiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJjCiGiCmMiBeB_xHqqkZx_OBJ_FIGURE_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
			ObjDynabaseVector vSubObj;
			(*iObj)->GetKindOfMembers(vSubObj, FDOJ_FIGURE);
			ObjDynabaseVector::iterator iSubObj;
			for (iSubObj = vSubObj.begin(); iSubObj != vSubObj.end(); iSubObj++)
			{
				if ((*iSubObj)->GetRichText() != NULL) break;
			}
			if (iSubObj != vSubObj.end())
			//----- _xZkqqHx_iDiBiDjDiDgPiBfLiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiMhGiOfKiBeCiDgFiDeMiDfIiDgHiKhAiCmNiCePiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
				const DBLPoint mmptFixPoint = (*iObj)->CalcFixPointForTextResize(
																g_pReg->GetResizeFixPosition(),
																0.0);
				// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendToLastRgn(*iObj);
				// _xZkqqHx_jFjEjFgJiCmJiNiHiCoNiClJiCmEiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
				(*iObj)->AdjustObjectSize(NULL, 0.0, 0.0, mmptFixPoint);
				// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendToLastRgn(*iObj);
				// _xZkqqHx_iIoKiCmCiCmFiCoAjClCjAkOiClDiCoKiClNiCkJiBeI_xHqqkZx_
				bAdjusted = TRUE;
			}
		}
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

	// _xZkqqHx_jDpBiCmCiCmMjFjEjFgJiCgAiBeBiCgBiCkKiDiKiDjDiDeOiCmFiMiLiCmOiCoKiBeBiCgAiCmMiJlKjCfLiCkKiKgHjBoFiClHiCoJiCmGiCgBiCmM_xHqqkZx_
	// _xZkqqHx_iPoDjCfLiCkKiPgLiPkMiClFiBeBiCgBiCmMiPoDjCfLiCkKiKgHjBoFiClHiCoJiCmGiCgAiCmMiJlKjCfLiCkKiPgLiPkMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiCoGiCkEiCmJiCkIiMnNiCkCiCmJiDfEiDeDiDfJiCpAiPgLiCnPiCkAiCkEiPoKiNiHiBeBiDgFiDeMiDfIiDgHiIoMiCoKiCkK_xHqqkZx_
	// _xZkqqHx_iOgDiCoJiPoKiNiHiCkKiCkAiCoJiCkKiBeBiCoCiCnOiCpAjDlOiCmIiCkCiBeC_xHqqkZx_

	if (bAdjusted)
	//----- _xZkqqHx_iIoKiCmCiCmFiCoAjClCjAkOiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
		OnSelectObjModified();
		// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
		OnDraw(&dc);
		g_pView->SendRgnRedraw();
	} else
	//----- _xZkqqHx_iIoKiCmCiCoAjClCjAkOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgDiBfLiDiLiCmMjFnCiPfHjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
		OnDraw(&dc);
	}
} // FCToolBase::OnObjectSizeToText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanDeleteRichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkJiCoHiDgFiDeMiDfIiDgHiCkKiNoNiPjMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanDeleteRichText () const
{
	if (!FFCanEditSelected()) return FALSE;
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiMjPiNpF_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->IsKindOf(FDOJ_FIGURE))
		//----- _xZkqqHx_jAhNiMgAjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (((FCObjFigure*)*iObj)->GetRichText() != NULL) return TRUE;
		} else
		if ((*iObj)->IsKindOf(FDOJ_GROUP))
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiBiDjDiDgPjCiGiCmMiDgFiDeMiDfIiDgHjFjEjFgJiBgJjAhNiMgAjFjEjFgJiBgKiCpAjCiKiPgPiBeC_xHqqkZx_
			ObjDynabaseVector vMembObj;
			((FCObjGroup*)*iObj)->GetCanBeTextObject(vMembObj);
			ObjDynabaseVector::const_iterator iMeb;
			for (iMeb = vMembObj.begin(); iMeb != vMembObj.end(); iMeb++)
			{
				if (((FCObjFigure*)*iMeb)->GetRichText() != NULL) return TRUE;
			}
		}
	}
	return FALSE;
} // FCToolBase::CanDeleteRichText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnDeleteRichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkJiCoHiDgFiDeMiDfIiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnDeleteRichText ()
{
	if (!FFCanEditSelected()) return;

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiMjPiNpF_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->IsKindOf(FDOJ_FIGURE))
		//----- _xZkqqHx_jAhNiMgAjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (((FCObjFigure*)*iObj)->GetRichText() != NULL)
			{
				// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendToLastRgn(*iObj);
				// _xZkqqHx_iDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				g_pDoc->CmdDelete1RichText((FCObjFigure*)*iObj);
			}

		} else
		if ((*iObj)->IsKindOf(FDOJ_GROUP))
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiBiDjDiDgPjCiGiCmMiDgFiDeMiDfIiDgHjFjEjFgJiBgJjAhNiMgAjFjEjFgJiBgKiCpAjCiKiPgPiBeC_xHqqkZx_
			ObjDynabaseVector vMembObj;
			((FCObjGroup*)*iObj)->GetCanBeTextObject(vMembObj);
			ObjDynabaseVector::const_iterator iMeb;
			for (iMeb = vMembObj.begin(); iMeb != vMembObj.end(); iMeb++)
			{
				if (((FCObjFigure*)*iMeb)->GetRichText() != NULL)
				{
					// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
					g_pView->AppendToLastRgn(*iMeb);
					// _xZkqqHx_iDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
					g_pDoc->CmdDelete1RichText((FCObjFigure*)*iMeb);
				}
			}
		}
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolBase::OnDeleteRichText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectConvertToPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectConvertToPoly () const
{
	return FALSE;
} // FCToolBase::CanObjectConvertToPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectConvertToPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiBhGiCkJiCoHiOmAiNhDiBeCjBeJjBpAiClDiCoKiClNjFjEjFgJiCpA_xHqqkZx_
 *			_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectConvertToPoly ()
{
} // FCToolBase::OnObjectConvertToPoly.

//----- 06.03.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectExchangeEdge
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFjEjFgJiCmMiKeKiOgOjDfP_xHqqkZx_/_xZkqqHx_iPeJjHlJjDfPiCmMjBkOjAkLiCpAiMpAiKlHiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::CanObjectExchangeEdge () const
//{
//	if (!FFCanEditSelected()) return FALSE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = GetSelectLocalObjVector().begin();
//		 iObj != GetSelectLocalObjVector().end(); iObj++)
//		if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) return FALSE;
//	return TRUE;
//} // FCToolBase::CanObjectExchangeEdge.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectExchangeEdge
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFjEjFgJiCmMiKeKiOgOjDfP_xHqqkZx_/_xZkqqHx_iPeJjHlJjDfPiCmMjBkOjAkLiCpAiMpAiKlHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnObjectExchangeEdge ()
//{
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	// _xZkqqHx_jFmPiNfIjBePiCmMjAnNjCoIiBeC_xHqqkZx_
//	LocalObjMovedBefore(GetSelectLocalObjVector());
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = GetSelectLocalObjVector().begin();
//		 iObj != GetSelectLocalObjVector().end(); iObj++)
//	{
//		// _xZkqqHx_jFeLiClI_xHqqkZx_ ObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//		if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) FFThrowMiscUnknown();
//		FCObjFigure* pFig = (FCObjFigure*)(*iObj);
//		// _xZkqqHx_jGoOiIpDiCmMjHlMjCfLiCpAiMpAiKlHiClHiCoJiBeC_xHqqkZx_
//		FCArrowRec rec;
//		pFig->GetArrowRec(rec);
//		Exchange(rec.byArrowFType, rec.byArrowBType);
//		Exchange(rec.byArrowFParam0, rec.byArrowBParam0);
//		Exchange(rec.byArrowFParam1, rec.byArrowBParam1);
//		Exchange(rec.byArrowFParam2, rec.byArrowBParam2);
//		Exchange(rec.paidPictArrowF, rec.paidPictArrowB);
//		g_pDoc->CmdModifyArrow(pFig, rec);
//		if ((*iObj)->IsKindOf(FDOJ_WIDE_POLY))
//		//----- _xZkqqHx_jFjNiNeMiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jFjNiCmMjBkOjAkLiCoAiMpAiKlHiClHiCoJiBeC_xHqqkZx_
//			FCObjWidePoly* pWidePoly = (FCObjWidePoly*)(*iObj);
//			FCWidePolyRec wprec;
//			wprec.wMask = FDFP_POLYWIDTHF | FDFP_POLYWIDTHB | FDFP_WIDTHSLOPEF | FDFP_WIDTHSLOPEB;
//			wprec.mmPolyWidthF = pWidePoly->GetPolyWidthB();
//			wprec.mmPolyWidthB = pWidePoly->GetPolyWidthF();
//			wprec.nWidthSlopeF = pWidePoly->GetWidthSlopeB();
//			wprec.nWidthSlopeB = pWidePoly->GetWidthSlopeF();
//			g_pDoc->CmdModifyWidePoly(pWidePoly, wprec);
//		}
//	}
//	// _xZkqqHx_jFmPiNfIiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
//	LocalObjMovedAfter();
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//} // FCToolBase::OnObjectExchangeEdge.
//----- 06.03.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableInsertLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJiNhDiCpAjBhNjDpMiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableInsertLine () const
{
	return FALSE;
} // FCToolBase::CanObjectTableInsertLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableInsertLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJiNhDiCpAjBhNjDpMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableInsertLine ()
{
} // FCToolBase::OnObjectTableInsertLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableAddLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJiNhDiCpAjCmHiJmBiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableAddLine () const
{
	return FALSE;
} // FCToolBase::CanObjectTableAddLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableAddLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJiNhDiCpAjCmHiJmBiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableAddLine ()
{
} // FCToolBase::OnObjectTableAddLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableInsertColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJjHpBiCpAjBhNjDpMiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableInsertColumn () const
{
	return FALSE;
} // FCToolBase::CanObjectTableInsertColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableInsertColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJjHpBiCpAjBhNjDpMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableInsertColumn ()
{
} // FCToolBase::OnObjectTableInsertColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableAddColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJjHpBiCpAjCmHiJmBiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableAddColumn () const
{
	return FALSE;
} // FCToolBase::CanObjectTableAddColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableAddColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmJjHpBiCpAjCmHiJmBiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableAddColumn ()
{
} // FCToolBase::OnObjectTableAddColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableDeleteLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiNhDiCpAiNoNiPjMiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableDeleteLine () const
{
	return FALSE;
} // FCToolBase::CanObjectTableDeleteLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableDeleteLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiNhDiCpAiNoNiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableDeleteLine ()
{
} // FCToolBase::OnObjectTableDeleteLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableDeleteColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMjHpBiCpAiNoNiPjMiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableDeleteColumn () const
{
	return FALSE;
} // FCToolBase::CanObjectTableDeleteColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableDeleteColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMjHpBiCpAiNoNiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableDeleteColumn ()
{
} // FCToolBase::OnObjectTableDeleteColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableMergeCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiDfKiDiLiCpAiMiLiNiHiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableMergeCell () const
{
	return FALSE;
} // FCToolBase::CanObjectTableMergeCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableMergeCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiDfKiDiLiCpAiMiLiNiHiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableMergeCell ()
{
} // FCToolBase::OnObjectTableMergeCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTableSplitCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiDfKiDiLiCpAjFkKiKiEiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTableSplitCell () const
{
	return FALSE;
} // FCToolBase::CanObjectTableSplitCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTableSplitCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjFfMjFjEjFgJiCmMiDfKiDiLiCpAjFkKiKiEiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTableSplitCell ()
{
} // FCToolBase::OnObjectTableSplitCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMoveSnapLeft
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMoveSnapLeft () const
{
	return FALSE;
} // FCToolBase::CanObjectMoveSnapLeft.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMoveSnapLeft
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMoveSnapLeft ()
{
} // FCToolBase::OnObjectMoveSnapLeft.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMoveSnapUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMoveSnapUp () const
{
	return FALSE;
} // FCToolBase::CanObjectMoveSnapUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMoveSnapUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMoveSnapUp ()
{
} // FCToolBase::OnObjectMoveSnapUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMoveSnapRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMoveSnapRight () const
{
	return FALSE;
} // FCToolBase::CanObjectMoveSnapRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMoveSnapRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMoveSnapRight ()
{
} // FCToolBase::OnObjectMoveSnapRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectMoveSnapDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectMoveSnapDown () const
{
	return FALSE;
} // FCToolBase::CanObjectMoveSnapDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectMoveSnapDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectMoveSnapDown ()
{
} // FCToolBase::OnObjectMoveSnapDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCpAjEhKjChFiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectPutTimeLabel () const
{
	return FALSE;
} // FCToolBase::CanObjectPutTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCpAjEhKjChFiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectPutTimeLabel ()
{
} // FCToolBase::OnObjectPutTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectTimeLabelProperty () const
{
	return FALSE;
} // FCToolBase::CanObjectTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectTimeLabelProperty ()
{
} // FCToolBase::OnObjectTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanObjectRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiKhAjDhIiCpAiOhHjCoIiClFiCmEiJpBjDfNiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanObjectRotate () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanEditSelectedLocal()) return FALSE;
	return TRUE;
} // FCToolBase::CanObjectRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnObjectRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiKhAjDhIiCpAiOhHjCoIiClFiCmEiJpBjDfNiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnObjectRotate ()
{
	//----- _xZkqqHx_jBeJjBpAjCiGjFjEjFgJiCmMjCiGjAfDiNmAjFfHiCmJjAnKiClHiCoJiLoJiMgAiCpAiOfKiPgP_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj = GetSelectLocalObjVector().begin();
	// _xZkqqHx_iNmFiPiJiCmMiLoJiMgAjCiGjAfDiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	DBLPoint mmptCenter = (*iObj)->GetResizeFrame().CenterPoint();
	DBLRect mmrtOut(mmptCenter, mmptCenter);
	for (;iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMjCiGjAfDiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		mmptCenter = (*iObj)->GetResizeFrame().CenterPoint();
		::SmallerOrLarger(mmrtOut.left, mmrtOut.right, mmptCenter.x);
		::SmallerOrLarger(mmrtOut.top, mmrtOut.bottom, mmptCenter.y);
	}

	// _xZkqqHx_iKhAjDhIiCpAiOhHjCoIiClFiCmEiJpBjDfNiCmMiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
	CFCDlgRotate dlg;
	dlg.SetIsRotateEach(FALSE);
	dlg.SetRotateAngle(0.0);
	dlg.SetRotateCenter(mmrtOut.CenterPoint());
	if (dlg.DoModal() == IDOK)
	//----- OK_xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJpBjDfNiKhAiCpA_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmJjAlDiLeLiJlLiBeC_xHqqkZx_
		const angle dRotateAngle = RegulateAngle(dlg.GetRotateAngle());
		if (!almost0(dRotateAngle) &&
			!almosteq(dRotateAngle, 2.0))
		//----- _xZkqqHx_iJpBjDfNiKhAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
			g_pDoc->SessionBegin();

			// _xZkqqHx_iInKjDkOjBePiCmMjAnNjCoIiBeC_xHqqkZx_
			LocalObjMovedBefore(GetSelectLocalObjVector());

			for (iObj = GetSelectLocalObjVector().begin();
				 iObj != GetSelectLocalObjVector().end(); iObj++)
			{
				if (dlg.GetIsRotateEach())
				//----- _xZkqqHx_iMmCjFmKiCmJiJpBjDfNiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
					g_pDoc->CmdRotate1Obj(	*iObj,
											dRotateAngle,
											(*iObj)->GetResizeFrame().CenterPoint());
				} else
				//----- _xZkqqHx_iIoKiKiHiClFiCmEiJpBjDfNiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
					g_pDoc->CmdRotate1Obj(	*iObj,
											dRotateAngle,
											dlg.GetRotateCenter());
				}
			}

			// _xZkqqHx_iInKjDkOiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
			LocalObjMovedAfter();

			// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
			g_pDoc->SessionEnd();
		}
	}
} // FCToolBase::OnObjectRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanExchangeHeadTail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiOgOjDfPiCmGiPeJjDfPiCmMjBkOjAkLiCpAiMpAiKlHiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanExchangeHeadTail () const
{
	if (!FFCanEditSelected()) return FALSE;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
		if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) return FALSE;
	return TRUE;
} // FCToolBase::CanExchangeHeadTail.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnExchangeHeadTail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOgOjDfPiCmGiPeJjDfPiCmMjBkOjAkLiCpAiMpAiKlHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::OnExchangeHeadTail ()
{
	// _xZkqqHx_iClBiClBiCmFiCmNiBeBjFjEjFgJiCmMiKeKiOgOjDfPiCmGiPeJjHlJjDfPiBgJjGoOiIpDiBgKiCpAiMpAiKlHiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jFmPiNfIjBePiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedBefore(GetSelectLocalObjVector());
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin();
		 iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		// _xZkqqHx_jFeLiClI_xHqqkZx_ ObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) FFThrowMiscUnknown();
		FCObjFigure* pFig = (FCObjFigure*)(*iObj);
		// _xZkqqHx_jGoOiIpDiCmMjHlMjCfLiCpAiMpAiKlHiClHiCoJiBeC_xHqqkZx_
		FCArrowRec rec;
		pFig->GetArrowRec(rec);
		Exchange(rec.byArrowFType, rec.byArrowBType);
		Exchange(rec.byArrowFParam0, rec.byArrowBParam0);
		Exchange(rec.byArrowFParam1, rec.byArrowBParam1);
		Exchange(rec.byArrowFParam2, rec.byArrowBParam2);
		Exchange(rec.paidPictArrowF, rec.paidPictArrowB);
		g_pDoc->CmdModifyArrow(pFig, rec);
		if ((*iObj)->IsKindOf(FDOJ_WIDE_POLY))
		//----- _xZkqqHx_jFjNiNeMiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjNiCmMjBkOjAkLiCoAiMpAiKlHiClHiCoJiBeC_xHqqkZx_
			FCObjWidePoly* pWidePoly = (FCObjWidePoly*)(*iObj);
			FCWidePolyRec wprec;
			wprec.wMask = FDFP_POLYWIDTHF | FDFP_POLYWIDTHB | FDFP_WIDTHSLOPEF | FDFP_WIDTHSLOPEB;
			wprec.mmPolyWidthF = pWidePoly->GetPolyWidthB();
			wprec.mmPolyWidthB = pWidePoly->GetPolyWidthF();
			wprec.nWidthSlopeF = pWidePoly->GetWidthSlopeB();
			wprec.nWidthSlopeB = pWidePoly->GetWidthSlopeF();
			g_pDoc->CmdModifyWidePoly(pWidePoly, wprec);
		}
	}
	// _xZkqqHx_jFmPiNfIiMoDiCmMjAnNjCoIiBeC_xHqqkZx_
	LocalObjMovedAfter();
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
} // FCToolBase::OnExchangeHeadTail.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanZoomView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiCmMiDfJiBfLiDiAiDeDiDjDiBeFiDeBiDeFiDgHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanZoomView () const
{
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
//	return FFIsSheetReady();
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
	return (g_pDoc->GetIsDocumentOpened() &&
			!g_pDoc->IsOleDocumentsOpened());
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
} // FCToolBase::CanZoomView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetInsideObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAlGjAkMiCmJiOgHjHhAiClDiCoKiCoJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiDhMiDeDiDjDiDfO_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCpAiOgHiCmBiCmEiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmMjFgAiJoGiCoCjFjEjFgJiCmMjAlGjAkMiCpAiNhDiCkE_xHqqkZx_.
 *************************************************************************/
FCObjDynabase* FCToolBase::GetInsideObject () const
{
	return NULL;
} // FCToolBase::GetInsideObject.

//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanLockStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiDiNiDgCiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCoCiDgDiBfLiDiLiDgPiBfLiCmMiDiNiDgCiDeOiDfCiDhNiDjDiDgIiCmMjFfMiOkGiPoDiCmMjGoCjBoIiBeC_xHqqkZx_
 *			_xZkqqHx_jDoAjFjEjDeJiCmJiCmN_xHqqkZx_SetLockStatus_xZkqqHx_iCmFjAnNjCoIiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanLockStatus () const
{
	return FALSE;
} // FCToolBase::CanLockStatus.
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetLockStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCmMiDiNiDgCiDeOiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::GetLockStatus () const
{
	return m_bIsLocked;
} // FCToolBase::GetLockStatus.
//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetLockStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmMiDiNiDgCiDeOiPpDjBnEiCpAjFmPiNfIiClHiCoJiBeCiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiDgDiBfLiDiLiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iCfAiCmCiCmMiPiIjHjNiCkKiPeJiCoNiCoJiClCiCmGiCmJiBeBjBeJjBpAiDgDiBfLiDiLiCmJjGnPiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bLocked	: _xZkqqHx_iDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_TRUE_xZkqqHx_iCmIiCoHiCmOiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIjBePiCmMiDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmIiCkCiDgDiBfLiDiLiCmNiBeB_xHqqkZx_EndOfSession_xZkqqHx_iKnGjAjEiCkKiMmEiCmOiCoKiClNjClMiMoDiCmJ_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAiDgDiBfLiDiLiCmJjGnPiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::SetLockStatus (BOOL bLocked)
{
	BOOL bLockedOld = m_bIsLocked;
	m_bIsLocked = bLocked;
	return bLockedOld;
} // FCToolBase::SetLockStatus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetNextTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolBase::GetNextTool () const
{
	return m_lNextToolId;
} // FCToolBase::GetNextTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetNextTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiPeJjHlJiMoDiCmJiInKiNhDiClHiCoJiDgDiBfLiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lToolId	:_xZkqqHx_iDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::SetNextTool (long lToolId)
{
	m_lNextToolId = lToolId;
} // FCToolBase::SetNextTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanHandle (const FCObjDynabase* pObj) const
{
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return FALSE;
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// pObj _xZkqqHx_iCkKiBeBjBeJjBpAiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmJjBkOiClHiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	return g_pDoc->CanDoOnObject(pObj, FDOZ_ON_SELECT);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::CanHandle.

//----- 01.01.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnFindNextText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiDhAiDgMiDiLiBhFiJlKjFpLiCpAiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpText	:_xZkqqHx_iMjPiNpFiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::OnFindNextText (const _TCHAR* tcpText)
//{
//	return FALSE;
//} // FCToolBase::OnFindNextText.
//----- 01.01.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnReplaceNextText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiDhAiDgMiDiLiBhFiOjPiCpAjChFiKlHiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpBefore	:_xZkqqHx_iMjPiNpFiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			tcpAfter	:_xZkqqHx_jChFiKlHiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::OnReplaceNextText (const _TCHAR* tcpBefore, const _TCHAR* tcpAfter)
//{
//	return FALSE;
//} // FCToolBase::OnReplaceNextText.
//----- 01.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::OnCommand (DWORD dwCmdID)
//{
//	switch (dwCmdID)
//	{
//	case ID_OBJECT_PROPERTIES:
//		OnObjectProperties();
//		break;
//	}
//} // FCToolBase::OnCommand.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OnUpdateCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::OnUpdateCommand (DWORD dwCmdID) const
//{
//	switch (dwCmdID)
//	{
//	case ID_OBJECT_PROPERTIES:
//		return CanObjectProperties();
//	default:
//		return FALSE;
//	}
//} // FCToolBase::OnUpdateCommand.
//----- 01.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsFindDialogVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGjCiGiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsFindDialogVisible ()
{
	if (m_atpFindDlg.get() == NULL) return FALSE;
	if (!::IsWindow(m_atpFindDlg->m_hWnd)) return FALSE;
	return m_atpFindDlg->IsWindowVisible();
} // FCToolBase::IsFindDialogVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsReplaceDialogVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGjCiGiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsReplaceDialogVisible ()
{
	if (m_atpReplaceDlg.get() == NULL) return FALSE;
	if (!::IsWindow(m_atpReplaceDlg->m_hWnd)) return FALSE;
	return m_atpReplaceDlg->IsWindowVisible();
} // FCToolBase::IsReplaceDialogVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_ROTATE_RIGHT:
	case ID_OBJECT_ROTATE_LEFT:
	case ID_OBJECT_MIRROR_HORZ:
	case ID_OBJECT_MIRROR_VERT:
	case ID_OBJECT_FRONT_OBJ:
	case ID_OBJECT_BACK_OBJ:
	case ID_OBJECT_MOST_FRONT_OBJ:
	case ID_OBJECT_MOST_BACK_OBJ:
	case ID_OBJECT_DISCONNECT:
	case ID_OBJECT_CONNECT:
	case ID_OBJECT_SIZE_TO_TEXT:
	case ID_OBJECT_PROPERTIES:
	case ID_OBJECT_ALIGN_V_LEFT:
	case ID_OBJECT_ALIGN_V_CENTER:
	case ID_OBJECT_ALIGN_V_RIGHT:
	case ID_OBJECT_ALIGN_H_TOP:
	case ID_OBJECT_ALIGN_H_CENTER:
	case ID_OBJECT_ALIGN_H_BOTTOM:
	case ID_OBJECT_SAME_GAP_V:
	case ID_OBJECT_SAME_GAP_H:
	case ID_OBJECT_SAME_DIST_V:
	case ID_OBJECT_SAME_DIST_H:
	case ID_OBJECT_SAME_SIZE_X:
	case ID_OBJECT_SAME_SIZE_Y:
// 06.03.27 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	case ID_OBJECT_EXCHANGE_EDGE:
	case ID_OBJECT_ROTATE:
		return TRUE;
	default:
		return FALSE;
	}
} // FCToolBase::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::FocusFrameDrawBegin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_CDC.
 *			mmpt	: _xZkqqHx_iDhNiDeFiDfIiImKjChF_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnLButtonDown_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::FocusFrameDrawBegin (CDC* pDC, const DBLPoint& mmpt)
{
	m_mmptFocusBegin = m_mmptFocusLatest = mmpt;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, TRUE);
	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmGiMlLiNnNiCmMiDeKiBfLiDfMiDiLiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_.
	FFGetMainWnd()->MoveRulerMMK(m_mmptFocusBegin, m_mmptFocusLatest);
	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusLatest));
	rect.NormalizeRect();
// 00.03.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	pDC->DrawFocusRect(&rect);
	FCEditDraw(pDC, 0).RectLine(rect);
} // FCToolBase::FocusFrameDrawBegin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::FocusFrameDrawing
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiNhDiCkE_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_CDC.
 *			mmpt	: _xZkqqHx_iDhNiDeFiDfIiImKjChF_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnMouseMove_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::FocusFrameDrawing (CDC* pDC, const DBLPoint& mmpt)
{
	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusLatest));
	rect.NormalizeRect();
	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiPmBiLiOiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	eDraw.RectLine(rect);
	// _xZkqqHx_jAfGiClFiCkCiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	m_mmptFocusLatest = mmpt;
	rect = CRect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusLatest));
	rect.NormalizeRect();
	// _xZkqqHx_jAfGiClFiCkCiDhEiDiMiBfLiDiAiCpAjFgAiJoGiBeC_xHqqkZx_
	eDraw.RectLine(rect);
	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmGiMlLiNnNiCmMiDeKiBfLiDfMiDiLiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_.
	FFGetMainWnd()->MoveRulerMMK(m_mmptFocusBegin, m_mmptFocusLatest);
} // FCToolBase::FocusFrameDrawing.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::FocusFrameDrawEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhA_xHqqkZx_CDC_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnLButtonUp_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::FocusFrameDrawEnd (CDC* pDC)
{
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAjEpBiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusLatest));
	rect.NormalizeRect();
	FCEditDraw(pDC, 0).RectLine(rect);
} // FCToolBase::FocusFrameDrawEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetFocusFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_FocusFrameDrawEnd_xZkqqHx_iMoDiCmJjHeMiMpIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCToolBase::GetFocusFrame () const
{
	DBLRect mmrtFrame(m_mmptFocusBegin.x, m_mmptFocusBegin.y,
						m_mmptFocusLatest.x, m_mmptFocusLatest.y);
	mmrtFrame.NormalizeRect();
	return mmrtFrame;
} // FCToolBase::GetFocusFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::DrawCurFocusFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::DrawCurFocusFrame (CDC* pDC)
{
	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusLatest));
	rect.NormalizeRect();
	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAjFgAiJoGiBeC_xHqqkZx_
	FCEditDraw(pDC, 0).RectLine(rect);
} // FCToolBase::DrawCurFocusFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::EndOfSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmMiCfAiCmCiCmMiPiIjHjNiCkKiPeJiCoNiCmBiClNiOjOiCmJiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeBiClBiCmMiKnGjAjEiOmAiNhDiMoDiBeB_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiCmNjBeJjBpAiDgDiBfLiDiLiCmJjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::EndOfSession ()
{
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgDiBfLiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
//	if (m_bIsLocked) return;
////----- 06.03.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	g_pView->PostMessage(WM_COMMAND, ID_TOOL_SELECT, (LPARAM)0);
////----- 06.03.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// ID_TOOL_SELECT_xZkqqHx_iCpAjBjHjFhEiBeC_xHqqkZx_
//	// _xZkqqHx_jCmKiPoNiCmM_xHqqkZx_PostMessage_xZkqqHx_iCmFjBjHjFhEiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_Win98_xZkqqHx_iCmFiClNiCkNiClDiCpBiCmMjFjEjFgJiCpAiKnMiCnOiDgAiDgCiDhGiCpA_xHqqkZx_
//	// _xZkqqHx_iDgIiDiJiDgCiDePiClFiCmEjCkDiCoIjFhEiCkPiClNiPoKiNiHiBeB_xHqqkZx_PostMessage_xZkqqHx_iCkKiPmBiOlIiClFiCmEiClFiCnMiCkEiMlLiPnLiCkKjEkNjAlGiBeC_xHqqkZx_
//	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiKgNiOmAiCmJjBjHjFhEiCmFiCkLiCoJjFnLjHkPiDiBiDgCiDfKiBfLiDfHiCpAjHjIjHhAiBeC_xHqqkZx_
//	FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, ID_TOOL_SELECT, 0);
////----- 06.03.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!m_bIsLocked)
	//----- _xZkqqHx_iDgDiBfLiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// m_lNextToolId_xZkqqHx_iCpAjBjHjFhEiBeCiDgGiDhEiDeIiDiLiDgH_xHqqkZx_(-1)_xZkqqHx_iCmN_xHqqkZx_ID_TOOL_SELECT_xZkqqHx_iBeC_xHqqkZx_
		// _xZkqqHx_jCmKiPoNiCmM_xHqqkZx_PostMessage_xZkqqHx_iCmFjBjHjFhEiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_Win98_xZkqqHx_iCmFiClNiCkNiClDiCpBiCmMjFjEjFgJiCpAiKnMiCnOiDgAiDgCiDhGiCpA_xHqqkZx_
		// _xZkqqHx_iDgIiDiJiDgCiDePiClFiCmEjCkDiCoIjFhEiCkPiClNiPoKiNiHiBeB_xHqqkZx_PostMessage_xZkqqHx_iCkKiPmBiOlIiClFiCmEiClFiCnMiCkEiMlLiPnLiCkKjEkNjAlGiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBiKgNiOmAiCmJjBjHjFhEiCmFiCkLiCoJjFnLjHkPiDiBiDgCiDfKiBfLiDfHiCpAjHjIjHhAiBeC_xHqqkZx_
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (m_lNextToolId == -1)
//			FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, ID_TOOL_SELECT, 0);
//		else
//			FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, m_lNextToolId, 0);
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		g_pView->SwitchCurrentTool(m_lNextToolId, FALSE);
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::EndOfSession.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetLastSelectLocalObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCToolBase::GetLastSelectLocalObj ()
{
	return g_pView->GetLastSelectObj();
} // FCToolBase::GetLastSelectLocalObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::LocalObjMovedBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmMjBePiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iInKjDkOiClDiCoKiCoJjFjEjFgJiCpAiOhHjCoIiBeCiDePiDiLiBfLiDhGjFjEjFgJjFnCiPfHiCmMiPoKiNiHiCmN_xHqqkZx_
 *					 _xZkqqHx_iInKjDkOiClDiCoKiCoJiDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::LocalObjMovedBefore (const ObjDynabaseVector& vObj)
{
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iInKjDkOjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(vObj);
//
//	//---- _xZkqqHx_iInKjDkOjBePiCmMjFnCiPfHjApMiCpAiPmBiLiO_xHqqkZx_ -----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_iClBiClBiCmNiBeB_xHqqkZx_g_pView->SelectObjVector() _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	// vObj _xZkqqHx_iCmFiCkAiCmBiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
//	// vObj _xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeB_xHqqkZx_
//	// DrawSelectMark _xZkqqHx_iCmMjBmOiPnLiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		DrawSelectMark(&dc, *iObj);
//	}
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// vObj_xZkqqHx_iCmNiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCkKiKnMiCnMiCoKiCoJiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeBiDgHiDgCiDhGjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//	m_stMoveTopObj.clear();		// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
//	mdef_const_iterator(ObjDynabaseVector, iObj);
//	m1_for (iObj, vObj)
//		m_stMoveTopObj.insert((*iObj)->GetGroupTop());
//
//	//----- _xZkqqHx_iInKjDkOjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(m_stMoveTopObj);
//
//	//---- _xZkqqHx_iInKjDkOjBePiCmMjFnCiPfHjApMiCpAiPmBiLiO_xHqqkZx_ -----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	mdef_const_iterator(ObjDynabaseSet, iObs);
//	m1_for (iObs, m_stMoveTopObj)
//		DrawSelectMark(&dc, *iObs);
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
	m_vMovedObj = vObj;
	// vObj_xZkqqHx_iCmNiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCkKiKnMiCnMiCoKiCoJiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeBiDgHiDgCiDhGjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseSet stMoveTopObj;
	mdef_const_iterator(ObjDynabaseVector, iObj);
	m1_for (iObj, m_vMovedObj)
		stMoveTopObj.insert((*iObj)->GetGroupTop());

	//----- _xZkqqHx_iInKjDkOjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	g_pView->AddEmptyRgn();
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(stMoveTopObj);

	//---- _xZkqqHx_iInKjDkOjBePiCmMjFnCiPfHjApMiCpAiPmBiLiO_xHqqkZx_ -----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	mdef_const_iterator(ObjDynabaseSet, iObs);
	m1_for (iObs, stMoveTopObj)
		DrawSelectMark(&dc, *iObs);
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::LocalObjMovedBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::LocalObjMovedAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmMiMoDiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.02.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCToolBase::LocalObjMovedAfter (const ObjDynabaseVector& vObj)
void FCToolBase::LocalObjMovedAfter ()
{
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(vObj);
//	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(vObj);
//
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iClBiCoKiCpAjDpMiCoKiCmIiCkCiCmGiBeB_xHqqkZx_ToolPolyEdit_xZkqqHx_iCmIiCmHiBeBjDoAjFjEiCmJjFnCiPfHjHhAiDgGiBfLiDfOiCpA_xHqqkZx_
//	// _xZkqqHx_iOjNiCmCiDgDiBfLiDiLiCmMjDoAjFjEiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_iNfIjAfGiClDiCoKiCmIiCkCiPoKiNiHiBeBiImIiJlKiCmM_xHqqkZx_DrawSelectMark_xZkqqHx_iCmNiMmDiCkCiImKjChFiCmJ_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHjApMiCpAjFgAiJoGiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	OnSelectObjModified();
//
//	//---- _xZkqqHx_iInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//
//	// _xZkqqHx_iClBiClBiCmNiBeB_xHqqkZx_g_pView->SelectObjVector() _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	// vObj _xZkqqHx_iCmFiCkAiCmBiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
//	// vObj _xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeB_xHqqkZx_
//	// DrawSelectMark _xZkqqHx_iCmMjBmOiPnLiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		DrawSelectMark(&dc, *iObj);
//	}
//
//	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iInKjDkOiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(m_stMoveTopObj);
//
//	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(m_stMoveTopObj);
//
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iClBiCoKiCpAjDpMiCoKiCmIiCkCiCmGiBeB_xHqqkZx_ToolPolyEdit_xZkqqHx_iCmIiCmHiBeBjDoAjFjEiCmJjFnCiPfHjHhAiDgGiBfLiDfOiCpA_xHqqkZx_
//	// _xZkqqHx_iOjNiCmCiDgDiBfLiDiLiCmMjDoAjFjEiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_iNfIjAfGiClDiCoKiCmIiCkCiPoKiNiHiBeBiImIiJlKiCmM_xHqqkZx_DrawSelectMark_xZkqqHx_iCmNiMmDiCkCiImKjChFiCmJ_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHjApMiCpAjFgAiJoGiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	OnSelectObjModified();
//
//	//---- _xZkqqHx_iInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	mdef_const_iterator(ObjDynabaseSet, iObs);
//	m1_for (iObs, m_stMoveTopObj)
//		DrawSelectMark(&dc, *iObs);
//
//	// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
//	m_stMoveTopObj.clear();
//
//	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iInKjDkOiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	// vObj_xZkqqHx_iCmNiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCkKiKnMiCnMiCoKiCoJiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeBiDgHiDgCiDhGjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseSet stMoveTopObj;
	mdef_const_iterator(ObjDynabaseVector, iObj);
	m1_for (iObj, m_vMovedObj)
		stMoveTopObj.insert((*iObj)->GetGroupTop());

	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(stMoveTopObj);

	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(stMoveTopObj);

	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAjDpMiCoKiCmIiCkCiCmGiBeB_xHqqkZx_ToolPolyEdit_xZkqqHx_iCmIiCmHiBeBjDoAjFjEiCmJjFnCiPfHjHhAiDgGiBfLiDfOiCpA_xHqqkZx_
	// _xZkqqHx_iOjNiCmCiDgDiBfLiDiLiCmMjDoAjFjEiDgGiBfLiDfOiCkKiNfIjAfGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iNfIjAfGiClDiCoKiCmIiCkCiPoKiNiHiBeBiImIiJlKiCmM_xHqqkZx_DrawSelectMark_xZkqqHx_iCmNiMmDiCkCiImKjChFiCmJ_xHqqkZx_
	// _xZkqqHx_jFnCiPfHjApMiCpAjFgAiJoGiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	OnSelectObjModified();

	//---- _xZkqqHx_iInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoG_xHqqkZx_ -----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	mdef_const_iterator(ObjDynabaseSet, iObs);
	m1_for (iObs, stMoveTopObj)
		DrawSelectMark(&dc, *iObs);

	// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
	m_vMovedObj.clear();

	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
//----- 06.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.02.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBase::LocalObjMovedAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanEditSelectedLocal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDiNiBfLiDeKiDiLjBeJjBpAiCmMjFjEjFgJiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanEditSelectedLocal () const
{
	return FFCanEditSelected();
} // FCToolBase::CanEditSelectedLocal.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiClFiBeBjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	:_xZkqqHx_iDhJiBfLiDfHiCpAjDgPjIfOiClHiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::CreatePropertyPage (CPropertyPageVector& vPropPage)
{
} // FCToolBase::CreatePropertyPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::OneLetterCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFlGiOjKiDfCiDhNiDjDiDgIiCmMiDeBiDjDiDfPiBfLiDgPiBfLiCmMjDfJjFhEiBeFiNoNiPjMiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMenu	:_xZkqqHx_jBiAiNoMjBmOiPnLiCmMiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiDiBiDgKiDiFiBfLiImIiJlKiCmMiDeBiDeDiDgFiDiAiCkKjBfDiCmE_xHqqkZx_Disable_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::OneLetterCommandEnable (CMenu* pMenu)
{
	if (pMenu == NULL) return FALSE;
	// _xZkqqHx_iClBiCmMiDiBiDgKiDiFiBfLiCmJiIoKiCmCiCmFiCoA_xHqqkZx_Enable_xZkqqHx_iCkKiCkAiCoJiCkJiBeI_xHqqkZx_
	BOOL bEnable = FALSE;
	// _xZkqqHx_iDiBiDgKiDiFiBfLiCmMiNiAjGnKjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwMenuSz = pMenu->GetMenuItemCount();
	WString wstrMenu;
	DWORD dwC;
	for (dwC = 0; dwC < dwMenuSz; dwC++)
	{
		BOOL bEnableTmp = FALSE;
		// _xZkqqHx_iNiAjGnKiCmMjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
		FFGetMenuString(pMenu, dwC, wstrMenu, MF_BYPOSITION);
		// _xZkqqHx_iNiAjGnKiCmMiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwCmdId = pMenu->GetMenuItemID(dwC);
		if (dwCmdId != 0)
		//----- _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (dwCmdId == DWORD(-1))
			//----- _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiNmEiLeBjDeJiCmJiPiIjHjNiBeC_xHqqkZx_
				if (OneLetterCommandEnable(pMenu->GetSubMenu(dwC)))
					bEnableTmp = TRUE;
			} else
			//----- _xZkqqHx_jCmKiPoNiCmMiDfCiDhNiDjDiDgIiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iClBiCmMiDfCiDhNiDjDiDgIiCkK_xHqqkZx_Enable_xZkqqHx_iCkJjClCiCnHiCoJiBeC_xHqqkZx_
				if (IsObjectCommandEnable(dwCmdId))
					bEnableTmp = TRUE;
			}
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
			if (bEnableTmp)
			//----- _xZkqqHx_iClBiCmMiNiAjGnKiCkK_xHqqkZx_Enable_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iClBiCmMiDiBiDgKiDiFiBfLiCmJiIoKiCmCiCmFiCoA_xHqqkZx_Enable_xZkqqHx_iCkKiCkAiCoJiCkJiBeI_xHqqkZx_
				bEnable = TRUE;
				// _xZkqqHx_jFlGjDkKiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_'&'_xZkqqHx_iCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
				if (wstrMenu.at(0) != L'&')
					wstrMenu.Insert(0, L'&');
				// _xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFlGiOjKjHpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
				pMenu->ModifyMenu(dwC, MF_BYPOSITION|MF_ENABLED|MF_STRING, dwCmdId,
									WStrToTStr(wstrMenu));
			} else
			//----- _xZkqqHx_iClBiCmMiNiAjGnKiCkK_xHqqkZx_Disable_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFlGjDkKiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjHeMiCoJiPoKiNiHiCmNiBeB_xHqqkZx_'&'_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
				if (wstrMenu.at(0) == L'&')
					wstrMenu.Delete(0);
				// _xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFlGiOjKjHpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
				pMenu->ModifyMenu(dwC, MF_BYPOSITION|MF_GRAYED|MF_STRING, dwCmdId,
									WStrToTStr(wstrMenu));
			}
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
			// '('_xZkqqHx_iCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
			int iIndexL = wstrMenu.Find(L'(');
			if (bEnableTmp)
			//----- _xZkqqHx_iClBiCmMiNiAjGnKiCkK_xHqqkZx_Enable_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iClBiCmMiDiBiDgKiDiFiBfLiCmJiIoKiCmCiCmFiCoA_xHqqkZx_Enable_xZkqqHx_iCkKiCkAiCoJiCkJiBeI_xHqqkZx_
				bEnable = TRUE;
				// '('_xZkqqHx_iCmMiOjPiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_'&'_xZkqqHx_iCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
				if (0 <= iIndexL && wstrMenu.at(iIndexL + 1) != L'&')
					wstrMenu.Insert(iIndexL + 1, L'&');
				// _xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFlGiOjKjHpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
				pMenu->ModifyMenu(dwC, MF_BYPOSITION|MF_ENABLED|MF_STRING, dwCmdId,
									WStrToTStr(wstrMenu));
			} else
			//----- _xZkqqHx_iClBiCmMiNiAjGnKiCkK_xHqqkZx_Disable_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// '('_xZkqqHx_iCmMiOjPiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjHeMiCoJiPoKiNiHiCmNiBeB_xHqqkZx_'&'_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
				if (0 <= iIndexL && wstrMenu.at(iIndexL + 1) == L'&')
					wstrMenu.Delete(iIndexL + 1);
				// _xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFlGiOjKjHpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
				pMenu->ModifyMenu(dwC, MF_BYPOSITION|MF_GRAYED|MF_STRING, dwCmdId,
									WStrToTStr(wstrMenu));
			}
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		}
	}
	// _xZkqqHx_iClBiCmMiDiBiDgKiDiFiBfLiCmJiIoKiCmCiCmFiCoA_xHqqkZx_Enable_xZkqqHx_iCkKiCkAiCoJiCkJiBeI_xHqqkZx_
	return bEnable;
} // FCToolBase::OneLetterCommandEnable.

//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::ScrollToObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJiCkKiDhCiDiFiBfLiCkJiCoHiCmNiCnNiPgPiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	stObjId	:_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiClFiClNiPoKiNiHiCmNiBeBiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmMiNmEjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiClFiCmIiCkCiPoKiNiHiCmNiBeBiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolBase::ScrollToObject (const DWORDSet& stObjId)
//{
//	// _xZkqqHx_jBeJjBpAjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (stObjId.empty()) return FALSE;
//	// _xZkqqHx_jFjEjFgJiCmJiKePjAnKiClHiCoJiNmFiPkMiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
//	DBLRect mmrtFrame;
//	// _xZkqqHx_jFjEjFgJiCmJiKePjAnKiClHiCoJiNmFiPkMiCmMiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	::GetResizeFrame(mmrtFrame, stObjId);
//	//----- _xZkqqHx_jFjEjFgJiCkKjFfMiOkGjHmMiIoGiCpAiCmNiCnNiPgPiClDiCmIiCkCiPiIjHjN_xHqqkZx_ -----
//	// _xZkqqHx_iJoGjGmKiCmMjFfMiOkGjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
////----- 01.02.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	CRect lgrtClient;
////	g_pView->GetClientRectLG(lgrtClient);
////	DBLRect mmrtClient = lg2mm(lgrtClient);
////----- 01.02.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	DBLRect mmrtClient;
//	g_pView->GetClientRectMM(mmrtClient);
////----- 01.02.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iCmMjClMjApMjDjJiCmMiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_IsRectEmpty_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_IsRectNull_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
//	if ((mmrtFrame & mmrtClient).IsRectNull())
//	{
//		// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBjFiNmEjFgAiJoGiBeC_xHqqkZx_
//		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmNiBeBiDfIiDeOiDiNiBfLiDiLiKnGjAjEiCmFiCkEiCnMiCkNiPiIjHjNiClDiCoKiCoJiBeC_xHqqkZx_
//		g_pView->SetScrollCenter(mmrtFrame.CenterPoint());
//		return TRUE;
//	}
//	return FALSE;
//} // FCToolBase::ScrollToObject.
//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetObjectHintText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHint	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
// *			pObj		:_xZkqqHx_iNoMjAkMiClHiCoJiDiBiDgCiDfKiBfLiDfHiCmMjBmOiPnLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::GetObjectHintText (WString& wstrHint, const FCObjDynabase* pObj) const
//{
//	//	_xZkqqHx_jFjEjFgJ_xHqqkZx_ID: %d\r\n
//	//	_xZkqqHx_jFjEjFgJiCmMiOoNjHnO_xHqqkZx_: %s\r\n
//	//	_xZkqqHx_iNlGiPoDiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_iJeFiJlKiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_jFjN_xHqqkZx_ x _xZkqqHx_iNiCiClD_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
//	//	_xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhI_xHqqkZx_: %f\r\n
//	//	_xZkqqHx_iPiKjBkOiDiMiDeDiDiEiBfL_xHqqkZx_: %d.%s\r\n
//	//	_xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgH_xHqqkZx_:\r\n
//	//	%s\r\n
//	//	_xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgH_xHqqkZx_\r\n
//	//	%s
//	WString wstrFormat;
//	wstrFormat.LoadString(IDS_FORM_OBJ_HINT);
//
//	// _xZkqqHx_jFjEjFgJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//	DBLRect mmrtFrame = pObj->GetResizeFrame();
//
//	// _xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgHiOoGjDlOiBeC_xHqqkZx_
//	WString wstrObjLinkIn;
//	{
//		DWORDSet stObjIdLinkIn;
//		FCMolipRec rec;
//		rec.dwObjID = pObj->GetObjID();
//		rec.lMolipId = -1;
//		DWORDSet stAffected;
//		g_pDoc->LinkManager()->GetAffectedByTo(stAffected, rec);
//		DWORDSet::iterator iRec;
//		for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
//		{
//			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//			ASSERT(pRec->m_mlpTo.dwObjID == rec.dwObjID);
//			stObjIdLinkIn.insert(pRec->m_mlpFrom.dwObjID);
//		}
//		DWORDSet::iterator iId;
//		long lC;
//		for (iId = stObjIdLinkIn.begin(), lC = 0; iId != stObjIdLinkIn.end(); iId++, lC++)
//		{
//			if (lC != 0 && (lC % 5) == 0)
//				wstrObjLinkIn += L"\r\n";
//			FCObjDynabase* pObjX = g_pDoc->ObjID2Object(*iId);
//			wstrObjLinkIn += FFFormatString(L"%d.%s,", *iId, FFObjTypeToStr(pObjX->Type()));
//		}
//		if (!wstrObjLinkIn.IsEmpty()) wstrObjLinkIn.ChopLast();
//	}
//
//	// _xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgHiOoGjDlOiBeC_xHqqkZx_
//	WString wstrObjLinkOut;
//	{
//		DWORDSet stObjIdLinkOut;
//		FCMolipRec rec;
//		rec.dwObjID = pObj->GetObjID();
//		rec.lMolipId = -1;
//		DWORDSet stAffected;
//		g_pDoc->LinkManager()->GetAffectedByFrom(stAffected, rec);
//		DWORDSet::iterator iRec;
//		for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
//		{
//			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//			ASSERT(pRec->m_mlpFrom.dwObjID == rec.dwObjID);
//			stObjIdLinkOut.insert(pRec->m_mlpTo.dwObjID);
//		}
//		DWORDSet::iterator iId;
//		long lC;
//		for (iId = stObjIdLinkOut.begin(), lC = 0; iId != stObjIdLinkOut.end(); iId++, lC++)
//		{
//			if (lC != 0 && (lC % 5) == 0)
//				wstrObjLinkOut += L"\r\n";
//			FCObjDynabase* pObjX = g_pDoc->ObjID2Object(*iId);
//			wstrObjLinkOut += FFFormatString(L"%d.%s,", *iId, FFObjTypeToStr(pObjX->Type()));
//		}
//		if (!wstrObjLinkOut.IsEmpty()) wstrObjLinkOut.ChopLast();
//	}
//
//	// _xZkqqHx_iDiMiDeDiDiEiBfLiOoGjDlOiBeC_xHqqkZx_
//	DWORD dwSelLayerIdx = g_pDoc->ObjDynabaseToLZOrder(pObj).dwLayerIdx;
//	WString wstrLayerName;
//	g_pDoc->GetCurrentSheet()->GetLayerInfo(&wstrLayerName, NULL, dwSelLayerIdx);
//
//	//	_xZkqqHx_jFjEjFgJ_xHqqkZx_ID: %d\r\n
//	//	_xZkqqHx_jFjEjFgJiCmMiOoNjHnO_xHqqkZx_: %s\r\n
//	//	_xZkqqHx_iNlGiPoDiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_iJeFiJlKiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_jFjN_xHqqkZx_ x _xZkqqHx_iNiCiClD_xHqqkZx_: (%f, %f)\r\n
//	//	_xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
//	//	_xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhI_xHqqkZx_: %f\r\n
//	//	_xZkqqHx_iPiKjBkOiDiMiDeDiDiEiBfL_xHqqkZx_: %d.%s\r\n
//	//	_xZkqqHx_iDiKiDjDiDeOjAoGiDiKiDfIiDgH_xHqqkZx_:\r\n
//	//	%s\r\n
//	//	_xZkqqHx_iDiKiDjDiDeOiMlDiDiKiDfIiDgH_xHqqkZx_\r\n
//	//	%s
//	wstrHint.Format(wstrFormat.c_str(),
//					pObj->GetObjID(),
//					FFObjTypeToStr(pObj->Type()),
//					mm2hi(mmrtFrame.left), mm2hi(mmrtFrame.top),
//					mm2hi(mmrtFrame.right), mm2hi(mmrtFrame.bottom),
//					mm2hi(mmrtFrame.Width()), mm2hi(mmrtFrame.Height()),
//					pObj->GetAngle(),
//					pObj->GetTextAngle(),
//					dwSelLayerIdx, wstrLayerName.c_str(),
//					wstrObjLinkOut.c_str(),
//					wstrObjLinkIn.c_str());
//} // FCToolBase::GetObjectHintText.
//----- 05.09.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSpecifySearchChipText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiOjOiCmJiDgAiDgCiDhGjCiGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAiMjPiNpFjBmOiPnLiCmGiClFiCmEjAnNjCoIiJmCjEfMiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSpecifySearchChipText () const
{
	return TRUE;
} // FCToolBase::CanSpecifySearchChipText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::CanSpecifySearchLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiBeFjChFiKlHiOjOiCmJjDmBjCoIiCmMiDiMiDeDiDiEiBfLiCpAiMjPiNpFjBmOiPnLiCmGiClFiCmEjAnNjCoIiJmCjEfMiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::CanSpecifySearchLayer () const
{
	return TRUE;
} // FCToolBase::CanSpecifySearchLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsAvailableFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFiClHiCnHiCmEiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiBhGiCpAiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsAvailableFindTextAll () const
{
	return TRUE;
} // FCToolBase::IsAvailableFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsAvailableFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFjBeJjBpAjCiGiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiClHiCnHiCmEiMjPiNpFiBhGiCpAiDfEiDhMiBfLiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsAvailableFindTextAllInSelect () const
{
	return TRUE;
} // FCToolBase::IsAvailableFindTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsAvailableReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFjBeJjBpAjCiGiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiClHiCnHiCmEjChFiKlHiBhGiCpAiDfEiDhMiBfLiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsAvailableReplaceTextAllInSelect () const
{
	return TRUE;
} // FCToolBase::IsAvailableReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetFindDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTool	:_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgFindText* FCToolBase::GetFindDialog (const FCToolBase* pTool)
{
	if (m_atpFindDlg.get() == NULL)
	{
		m_atpFindDlg = auto_ptr<CFCDlgFindText>(new CFCDlgFindText);
		m_atpFindDlg->Create(CFCDlgFindText::IDD, AfxGetMainWnd());
//----- 05.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iMjPiNpFiDeFiDeCiDjDiDgIiDeFiCmNiBeBjBePiJpBiCmMiPpDjBnEiCmJiKnGiCoNiCoHiClIiLeOjDkOiOjOiCmNjEpBjFfMiOkGiBeC_xHqqkZx_
		m_atpFindDlg->SetWindowVisible(FALSE);
//----- 05.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iPoDiLeMiCmM_xHqqkZx_Create_xZkqqHx_iCmFiDhEiDeIiBfLiDeKiDfIiCkKiDfPiDeDiDeBiDiNiDePiCmJiInKiNhDiClFiCmEiClFiCnMiCkEiClNiCnPiBeBiDhEiDiMiBfLiDiAiCmJjGnPiClHiBeC_xHqqkZx_
		AfxGetMainWnd()->SetFocus();
	}
	if (pTool != NULL)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLjAnNjCoIjHhAiDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_atpFindDlg->SetChkChipTextVisible(pTool->CanSpecifySearchChipText());
		m_atpFindDlg->SetChkFindLayerVisible(pTool->CanSpecifySearchLayer());
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		m_atpFindDlg->SetBtnFindAllVisible(pTool->IsAvailableFindTextAll());
		m_atpFindDlg->SetBtnFindAllInSelectVisible(pTool->IsAvailableFindTextAllInSelect());
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	return m_atpFindDlg.get();
} // FCToolBase::GetFindDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetReplaceDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTool	:_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgReplaceText* FCToolBase::GetReplaceDialog (const FCToolBase* pTool)
{
	if (m_atpReplaceDlg.get() == NULL)
	{
		m_atpReplaceDlg = auto_ptr<CFCDlgReplaceText>(new CFCDlgReplaceText);
		m_atpReplaceDlg->Create(CFCDlgReplaceText::IDD, AfxGetMainWnd());
//----- 05.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jChFiKlHiDeFiDeCiDjDiDgIiDeFiCmNiBeBjBePiJpBiCmMiPpDjBnEiCmJiKnGiCoNiCoHiClIiLeOjDkOiOjOiCmNjEpBjFfMiOkGiBeC_xHqqkZx_
		m_atpReplaceDlg->SetWindowVisible(FALSE);
//----- 05.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iPoDiLeMiCmM_xHqqkZx_Create_xZkqqHx_iCmFiDhEiDeIiBfLiDeKiDfIiCkKiDfPiDeDiDeBiDiNiDePiCmJiInKiNhDiClFiCmEiClFiCnMiCkEiClNiCnPiBeBiDhEiDiMiBfLiDiAiCmJjGnPiClHiBeC_xHqqkZx_
		AfxGetMainWnd()->SetFocus();
	}
	if (pTool != NULL)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLjAnNjCoIjHhAiDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_atpReplaceDlg->SetChkChipTextVisible(pTool->CanSpecifySearchChipText());
		m_atpReplaceDlg->SetChkFindLayerVisible(pTool->CanSpecifySearchLayer());
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		m_atpReplaceDlg->SetBtnReplaceAllInSelectVisible(pTool->IsAvailableReplaceTextAllInSelect());
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	return m_atpReplaceDlg.get();
} // FCToolBase::GetReplaceDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetSearchParser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDeHiDjDiDfHiDjDiCpAjFnEiClHiBeCjAnNjCoIiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeCjBlNiPkNiOjOiKnEiCkKiCkJiCkJiCoJiCmMiCmFiBeBiDiLiBfLiDhGjCiGiCmFiMmEiCnEiCmGiCkLiCmIiCmHiCmN_xHqqkZx_
 *			_xZkqqHx_jFmPjAjEiCmJjBoDjDpMiClFiCmEiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSearchParser* FCToolBase::GetSearchParser ()
{
	// _xZkqqHx_jFfMiOkGjCiGiCmMiDfPiDeDiDeBiDiNiDePiCmMjCgMiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnMiClJiCoJiBeC_xHqqkZx_
	if (IsFindDialogVisible())
		GetFindDialog(NULL)->UpdateRegistory();
	else
	if (IsReplaceDialogVisible())
		GetReplaceDialog(NULL)->UpdateRegistory();

	if (m_pSp.get() == NULL)
		m_pSp = auto_ptr<FCSearchParser>(new FCSearchParser);

	//----- _xZkqqHx_iMjPiNpFiOkOiCmMiOoGjDlO_xHqqkZx_ -----
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString strList = g_pReg->GetRecentFindStrings();
//	if (strList.IsEmpty()) return NULL;
//	WString strFind;
//	// _xZkqqHx_iDiKiDfIiDgHiCmMiDgHiDgCiDhGiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	strFind = FFExtractString(strList);
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strFind = g_pReg->GetRecentFindString();
	if (strFind.IsEmpty()) return NULL;
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_jChFiKlHiOkOiCmMiOoGjDlO_xHqqkZx_ -----
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	strList = g_pReg->GetRecentReplaceStrings();
//	WString strReplace;
//	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjAnNjCoIiCkKiCkAiCoJiPoKiNiHiCmNiDiKiDfIiDgHiCmMiDgHiDgCiDhGiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	if (!strList.IsEmpty())
//		strReplace = FFExtractString(strList);
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strReplace = g_pReg->GetRecentReplaceString();
//----- 05.01.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iMjPiNpFiOkOiCmMjAnNjCoI_xHqqkZx_ -----
	if (m_bFirstSearch ||
		m_strCurFindText != strFind ||
		m_bCurIsRegExp != g_pReg->GetIsRegExp() ||
		m_bCurIsCnvUpper != g_pReg->GetIsCnvUpper() ||
		m_bCurIsMultiWord != g_pReg->GetIsFindMultiWord())
	//----- _xZkqqHx_jBePiJpBiMjPiNpFiDeHiDjDiDfHiDjDiCmJjAnNjCoIiClFiClNiMjPiNpFiOkOiCmGiNmFjAfGiCmMiOkOiCmJiIoBiCkCiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCiPpAiMiPiCmFiMjPiNpFiOkOiCpAjAnNjCoIiBeC_xHqqkZx_
		if (!m_pSp->ParseSearch(strFind, g_pReg->GetIsRegExp(),
								g_pReg->GetIsCnvUpper(),
								g_pReg->GetIsFindMultiWord(), FALSE)) return NULL;
		// _xZkqqHx_iNmFiPiJiCmMiMjPiNpFiDhEiDiJiDePiCpAiJpAiPjMiBeC_xHqqkZx_
		m_bFirstSearch = FALSE;
		// _xZkqqHx_jAfGiClFiCkCiPpAiMiPiCpAiLeMiJkPiClHiCoJiBeC_xHqqkZx_
		m_strCurFindText = strFind;
		m_bCurIsRegExp = g_pReg->GetIsRegExp();
		m_bCurIsCnvUpper = g_pReg->GetIsCnvUpper();
		m_bCurIsMultiWord = g_pReg->GetIsFindMultiWord();
		// _xZkqqHx_iMjPiNpFiOkOjAnNjCoIiOjOiCmNiBeBjGlDiPpAiMiPiCmFjChFiKlHiOkOiCoAjAnNjCoIiBeCiMoDjFpLjChFiKlHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
		if (!m_pSp->ParseReplace(strReplace)) return NULL;
		// _xZkqqHx_iMjPiNpFiOkOjAnNjCoIiOjOiCmNiBeBjGlDiPpAiMiPiCmFjChFiKlHiOkOiCoAjAnNjCoIiBeC_xHqqkZx_
		m_strCurReplaceText = strReplace;
	} else
	//----- _xZkqqHx_jBePiJpBiMjPiNpFiDeHiDjDiDfHiDjDiCmJjAnNjCoIiClFiClNiMjPiNpFiOkOiCmGiNmFjAfGiCmMiOkOiCmJiIoBiCkCiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_jChFiKlHiOkOiCmMjAnNjCoI_xHqqkZx_ -----
		if (m_strCurReplaceText != strReplace)
		//----- _xZkqqHx_jBePiJpBiMjPiNpFiDeHiDjDiDfHiDjDiCmJjAnNjCoIiClFiClNjChFiKlHiOkOiCmGiNmFjAfGiCmMiOkOiCmJiIoBiCkCiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (!m_pSp->ParseReplace(strReplace)) return NULL;
			m_strCurReplaceText = strReplace;
		}
	}
	return m_pSp.get();
} // FCToolBase::GetSearchParser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::GetFontInfoProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOoGjDlOiClHiCoJiClNiCnPiCmMiKnGjAjEiBeCiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciAnsi	:_xZkqqHx_iJhAiMoKiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			fciSjis	:_xZkqqHx_jDpKjGhLiMoKiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::GetFontInfoProc (	FCFontCharInfo& fciAnsi,
									FCFontCharInfo& fciSjis, void* pData)
{
	const ObjDynabaseVector* vTextObj = (const ObjDynabaseVector*)pData;
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCkJiCoHiLkEjCmKiCmM_xHqqkZx_ cf _xZkqqHx_iCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj1;
	((FCObjFigure*)vTextObj->front())->GetRichText()->GetCharInfo(fciAnsi, fciSjis, TRUE);
	for (iObj1 = vTextObj->begin() + 1; iObj1 != vTextObj->end(); iObj1++)
		((FCObjFigure*)*iObj1)->GetRichText()->GetCharInfo(fciAnsi, fciSjis, FALSE);
//----- 05.06.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jClCiCnHiClNjFjEjFgJjCiGiCmFiBeBjEpBjFfHiPiAiDhEiDeIiDjDiDgHiCmMjFlGiOjKiCkKiOgHiCoNiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
	if (fciAnsi.dwMask & FDFI_FLAG_UNUSED)
		fciAnsi.dwMask = FDFI_FLAG_UNUSED;
	// _xZkqqHx_jClCiCnHiClNjFjEjFgJjCiGiCmFiBeBjFfHiPiAiDhEiDeIiDjDiDgHiCmMjFlGiOjKiCkKiOgHiCoNiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
	if (fciSjis.dwMask & FDFI_FLAG_UNUSED)
		fciSjis.dwMask = FDFI_FLAG_UNUSED;
//----- 05.06.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBase::GetFontInfoProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetFontInfoProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAjAnNjCoIiClHiCoJiClNiCnPiCmMiKnGjAjEiBeCiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciAnsi	:_xZkqqHx_iJhAiMoKiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fciSjis	:_xZkqqHx_jDpKjGhLiMoKiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::SetFontInfoProc (	const FCFontCharInfo& fciAnsi,
									const FCFontCharInfo& fciSjis, void* pData)
{
	const ObjDynabaseVector* vTextObj = (const ObjDynabaseVector*)pData;

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiPmBiLiOiCmMiMoDiCpAjBkGiOjOiNmEjFgAiJoGiClHiCoJiBeCiMmFjHeMiDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiCmGiCmMiPgEjFkBiCpAjEpAiCkPiCoJiClNiCnPiBeC_xHqqkZx_
	g_pView->UpdateWindow();
	// _xZkqqHx_iLpDiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCmJjAfGiClFiCkC_xHqqkZx_ fciAnsi _xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj1;
	for (iObj1 = vTextObj->begin(); iObj1 != vTextObj->end(); iObj1++)
	{
		FCRichText* pRich = ((FCObjFigure*)*iObj1)->GetRichText();
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->BeforeCmdModifyAbcRichText((FCObjFigure*)*iObj1);
		// fciAnsi,fciSjis _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		BYTEVector byvQueue;
		pRich->SetCharInfo(byvQueue, fciAnsi, fciSjis, (FCObjFigure*)*iObj1);
		if (!byvQueue.empty())
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyAbcRichText((FCObjFigure*)*iObj1,
											byvQueue.size(), byvQueue.begin());
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(*iObj1);
		}
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();

//----- 06.05.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.05.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBase::SetFontInfoProc.

//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SwitchCurrentTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lToolId			:_xZkqqHx_jFmPiNfIjAoGiCmMiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bDoImmediate	:_xZkqqHx_jFmPiNfIiPiIjHjNiCpAjBkGiNmAiCmJiOmAiNhDiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 PostMessage_xZkqqHx_iCmFjChIiJiEiPiIjHjNiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SwitchCurrentTool_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiBeBiDgDiBfLiDiLjFmPiNfIiPiIjHjNiCkKiCmIiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmJiDgDiBfLiDiLiCkKjFmPiNfIiClDiCoKiCoJiCnMiCmFiCmNiBhFjFmPiNfIjCiGiBhGiCmGiCmIiCoJiBeC_xHqqkZx_
 *			PostMessage_xZkqqHx_iCmJiCoGiCoJiDfOiDeDiDiAiDeNiDiDiDgCiDhGiCkKiCkAiCoJiClNiCnPiBeBiClLiCmMiKnEiCmJiPiIjHjNiCkK_xHqqkZx_
 *			_xZkqqHx_jBjGiCoJiCmMiCpAjGgIiCkOjGnKjDeJiCmFjDlBjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::SwitchCurrentTool (long lToolId, BOOL bDoImmediate)
{
	// lToolId_xZkqqHx_iCmNiBeB_xHqqkZx_ID_TOOL_SELEDIT_xZkqqHx_iCmNiOhHjCoIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (lToolId == ID_TOOL_SELEDIT)
		FFThrowMiscUnknown();
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgH_xHqqkZx_(-1)_xZkqqHx_iCmNiBeB_xHqqkZx_ID_TOOL_SELECT_xZkqqHx_iBeC_xHqqkZx_
	if (lToolId == -1)
		lToolId = ID_TOOL_SELECT;
	// lToolId_xZkqqHx_iCpAjBjHjFhEiBeC_xHqqkZx_
	// _xZkqqHx_jCmKiPoNiCmM_xHqqkZx_PostMessage_xZkqqHx_iCmFjBjHjFhEiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_Win98_xZkqqHx_iCmFiClNiCkNiClDiCpBiCmMjFjEjFgJiCpAiKnMiCnOiDgAiDgCiDhGiCpA_xHqqkZx_
	// _xZkqqHx_iDgIiDiJiDgCiDePiClFiCmEjCkDiCoIjFhEiCkPiClNiPoKiNiHiBeB_xHqqkZx_PostMessage_xZkqqHx_iCkKiPmBiOlIiClFiCmEiClFiCnMiCkEiMlLiPnLiCkKjEkNjAlGiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiKgNiOmAiCmJjBjHjFhEiCmFiCkLiCoJjFnLjHkPiDiBiDgCiDfKiBfLiDfHiCpAjHjIjHhAiBeC_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_
	SetIsToolSwitching(TRUE);
	if (bDoImmediate)
	//----- _xZkqqHx_jBkGiOjOiPiIjHjNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FFSendPendingMessage(FD_PMSG_VIEW, WM_COMMAND, lToolId, 0);
		// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ lToolId _xZkqqHx_iCmNiOlIjEhDiClHiCoJiClBiCmGiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jFeLiClI_xHqqkZx_ m_bIsToolSwitching _xZkqqHx_iCpAiJpAiPjMiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_
		// ID_CANCEL_SWITCHING_LOCK _xZkqqHx_iCpAjBlBiCkPiCmEjBjHjFhEiClHiCoJiBeC_xHqqkZx_
		FFSendPendingMessage(FD_PMSG_VIEW, WM_COMMAND, ID_CANCEL_SWITCHING_LOCK, 0);
	} else
	//----- _xZkqqHx_jChIiJiEiPiIjHjNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, lToolId, 0);
		// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ lToolId _xZkqqHx_iCmNiOlIjEhDiClHiCoJiClBiCmGiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jFeLiClI_xHqqkZx_ m_bIsToolSwitching _xZkqqHx_iCpAiJpAiPjMiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_
		// ID_CANCEL_SWITCHING_LOCK _xZkqqHx_iCpAjBlBiCkPiCmEjBjHjFhEiClHiCoJiBeC_xHqqkZx_
		FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, ID_CANCEL_SWITCHING_LOCK, 0);
	}
} // FCToolBase::SwitchCurrentTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::IsToolSwitching
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIjCiGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SwitchCurrentTool_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiBeBiDgDiBfLiDiLjFmPiNfIiPiIjHjNiCkKiCmIiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmJiDgDiBfLiDiLiCkKjFmPiNfIiClDiCoKiCoJiCnMiCmFiCmNiBhFjFmPiNfIjCiGiBhGiCmGiCmIiCoJiBeC_xHqqkZx_
 *			PostMessage_xZkqqHx_iCmJiCoGiCoJiDfOiDeDiDiAiDeNiDiDiDgCiDhGiCkKiCkAiCoJiClNiCnPiBeBiClLiCmMiKnEiCmJiPiIjHjNiCkK_xHqqkZx_
 *			_xZkqqHx_jBjGiCoJiCmMiCpAjGgIiCkOjGnKjDeJiCmFjDlBjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBase::IsToolSwitching () const
{
	return m_bIsToolSwitching;		// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_
} // FCToolBase::IsToolSwitching.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::SetIsToolSwitching
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsToolSwitching	:_xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	07.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBase::SetIsToolSwitching (BOOL bIsToolSwitching)
{
	m_bIsToolSwitching = bIsToolSwitching;
} // FCToolBase::SetIsToolSwitching.
//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 01.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::RemoveAllLinkIn
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiBeBjBfDiCmEiCmMiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMolipB	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKnGjAjEjCiGiCmFiDfCiDhNiDjDiDgIiCpAiOmAiNhDiClHiCoJiCmMiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::RemoveAllLinkIn (const FTMolipSet& stMolipB)
//{
//	FTMolipSet::const_iterator iB;
//	for (iB = stMolipB.begin(); iB != stMolipB.end(); iB++)
//	{
//		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjHpBiLjDiBeC_xHqqkZx_
//		DWORDSet stLinkIdx;
//		g_pDoc->LinkManager()->GetAffectedByTo(stLinkIdx, *iB);
//		//----- _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOiCpAjBfDiCmEiPmBiLiO_xHqqkZx_ -----
//		DWORDSet::iterator iLs;
//		for (iLs = stLinkIdx.begin(); iLs != stLinkIdx.end(); iLs++)
//			g_pDoc->CmdDelete1Link(*iLs);
//	}
//} // FCToolBase::RemoveAllLinkIn.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::AppendAllLinkIn
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	molipA		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			stMolipB	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			wLinkKind	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiOoNjFmKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKnGjAjEjCiGiCmFiDfCiDhNiDjDiDgIiCpAiOmAiNhDiClHiCoJiCmMiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::AppendAllLinkIn (const FCMolipRec& molipA,
//							const FTMolipSet& stMolipB, WORD wLinkKind)
//{
//	FTMolipSet::const_iterator iB;
//	for (iB = stMolipB.begin(); iB != stMolipB.end(); iB++)
//	{
//		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiDiKiDjDiDeOjAoGiCkKjDkPiClGiCmIiCoHiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (*iB == molipA) continue;
//		//----- _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCpAiNoMjAkM_xHqqkZx_ -----
//		(void)g_pDoc->CmdAppend1Link(molipA, *iB, wLinkKind);
//	}
//} // FCToolBase::AppendAllLinkIn.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::RemoveAllLinkOut
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiKiDjDiDeOiDeBiDeFiDgHiClHiCoJiBeBjBfDiCmEiCmMiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMolipA	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKnGjAjEjCiGiCmFiDfCiDhNiDjDiDgIiCpAiOmAiNhDiClHiCoJiCmMiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::RemoveAllLinkOut (const FTMolipSet& stMolipA)
//{
//	FTMolipSet::const_iterator iA;
//	for (iA = stMolipA.begin(); iA != stMolipA.end(); iA++)
//	{
//		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiCiDiKiDhGiCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAjHpBiLjDiBeC_xHqqkZx_
//		DWORDSet stLinkIdx;
//		g_pDoc->LinkManager()->GetAffectedByFrom(stLinkIdx, *iA);
//		//----- _xZkqqHx_iMlLiNnNiCmMiDiKiDjDiDeOiCpAjBfDiCmEiPmBiLiO_xHqqkZx_ -----
//		DWORDSet::iterator iLs;
//		for (iLs = stLinkIdx.begin(); iLs != stLinkIdx.end(); iLs++)
//			g_pDoc->CmdDelete1Link(*iLs);
//	}
//} // FCToolBase::RemoveAllLinkOut.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBase::AppendAllLinkOut
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCmJiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiNoMiLmGiCpAjFkBjAjEiCmMiDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCmJjBmOiClFiCmEiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMolipA	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_A_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			molipB		:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_B_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			wLinkKind	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiOoNjFmKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKnGjAjEjCiGiCmFiDfCiDhNiDjDiDgIiCpAiOmAiNhDiClHiCoJiCmMiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBase::AppendAllLinkOut (const FTMolipSet& stMolipA,
//							const FCMolipRec& molipB, WORD wLinkKind)
//{
//	FTMolipSet::const_iterator iA;
//	for (iA = stMolipA.begin(); iA != stMolipA.end(); iA++)
//	{
//		// _xZkqqHx_iDiKiDjDiDeOiMlDiCmGiDiKiDjDiDeOjAoGiCkKjDkPiClGiCmIiCoHiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (*iA == molipB) continue;
//		//----- _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCpAiNoMjAkM_xHqqkZx_ -----
//		(void)g_pDoc->CmdAppend1Link(*iA, molipB, wLinkKind);
//	}
//} // FCToolBase::AppendAllLinkOut.
//----- 01.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

