#ifndef __ToolBase_h
#define __ToolBase_h

#include "UtilFont.h"			// For FCFontCharInfo.

class FCObjDynabase;
class FCObjDynabase;
class FCUndoArchive;
class CFCDlgFindText;
class CFCDlgReplaceText;
class FCSearchParser;
struct FCFontCharInfo;
struct FCMolipRec;
typedef set<FCMolipRec> FTMolipSet;

#define FDRT_ROTATE_RIGHT	(0.5)
#define FDRT_ROTATE_LEFT	(-0.5)

class FCToolBase
{
public:

//;----- <EXPORT TO SDK> -----;

	enum FTAlignType
	{
		FDAT_NONE = 0,
		FDAT_ALIGN_V_LEFT,		// _xZkqqHx_iNlGjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
		FDAT_ALIGN_V_CENTER,	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
		FDAT_ALIGN_V_RIGHT,		// _xZkqqHx_iJeFjBkEiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
		FDAT_ALIGN_H_TOP,		// _xZkqqHx_iPoDjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
		FDAT_ALIGN_H_CENTER,	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
		FDAT_ALIGN_H_BOTTOM,	// _xZkqqHx_iJlKjBkEiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
		FDAT_SAME_GAP_V,		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
		FDAT_SAME_GAP_H,		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
		FDAT_SAME_DIST_V,		// _xZkqqHx_iPgDiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
		FDAT_SAME_DIST_H,		// _xZkqqHx_iJkBiCmJiLjHjHkDiLmPjDjJiBeC_xHqqkZx_
		FDAT_SAME_SIZE_X,		// _xZkqqHx_iJkBiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
		FDAT_SAME_SIZE_Y,		// _xZkqqHx_iPgDiCmJiDfEiDeDiDfJiLmPjDjJiBeC_xHqqkZx_
	};

	enum FTMirrorType
	{
		FDMR_NONE = 0,
		FDMR_MIRROR_HORZ,	// _xZkqqHx_iNlGiJeFiLhEjDfNiBeC_xHqqkZx_
		FDMR_MIRROR_VERT,	// _xZkqqHx_iPoDiJlKiLhEjDfNiBeC_xHqqkZx_
	};

//;------ </EXPORT TO SDK> -----;

public:
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObjectInfo);
	virtual void	InStream (FCUndoArchive& ar);
	virtual void	OnViewCreate ();	// CFCDynamicDrawView::OnCreate_xZkqqHx_iCkJiCoH_xHqqkZx_Call.
	virtual void	OnViewDestroy ();	// CFCDynamicDrawView::OnDestroy_xZkqqHx_iCkJiCoH_xHqqkZx_Call.
	virtual void	InitContents ();	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_InitContents_xZkqqHx_iOjOiCmJiOmAiNhDiBeC_xHqqkZx_
	virtual void	OnSetFocus (CWnd* pOldWnd);		// CView_xZkqqHx_iCmJiDhEiDeIiBfLiDeKiDfIiCkKjHiIiClN_xHqqkZx_..
	virtual void	OnKillFocus (CWnd* pNewWnd);	// CView_xZkqqHx_iCkJiCoHiDhEiDeIiBfLiDeKiDfIiCkKiLiOiCmBiClN_xHqqkZx_.
	virtual void	OnLButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnMouseMove (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnLButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnLButtonDblClk (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnRButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnRButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnRButtonDblClk (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
//----- 01.11.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	OnMButtonDown (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnMButtonUp (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
//----- 05.08.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	OnXButton1Up (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
	virtual void	OnXButton2Up (CDC* pDC, const DBLPoint& mmptMsc, UINT nFlags);
//----- 05.08.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual void	OnWindowMessage (CDC* pDC, DWORD dwMessage,
												WPARAM wParam, LPARAM lParam);
//----- 01.11.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual void	OnKeyDown (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual void	OnKeyUp (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual void	OnChar (CDC* pDC, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual void	OnAnyToolCommand (CDC* pDC, UINT dwCommand);

// 05.09.14 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnPursuerTextNeedInfo ();

	virtual void	OnContextMenu (CDC* pDC, const DBLPoint& mmptMsc);
	virtual BOOL	CanObjectProperties () const;
	virtual void	OnObjectProperties ();
	virtual BOOL	CanInsideObjProperty () const;
	virtual void	OnInsideObjProperty ();
	virtual BOOL	CanToolselfProperty () const;
	virtual void	OnToolselfProperty ();

	virtual void	OnSelectObjModified ();
// 05.06.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnZoomChanged ();
// 05.06.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnObjSelectChanged ();

//----- 05.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	OnTextSelectChanged ();

//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual const wchar_t*	GetCurrentTextBothFontName () const;
//	virtual mmetol	GetCurrentTextBothFontSize () const;
//	virtual WORD	GetCurrentTextBothFontWeight () const;
//	virtual BOOL	GetIsCurrentTextBothFontItalic () const;
//	virtual BOOL	GetIsCurrentTextBothFontUnderline () const;
//	virtual COLORREF GetCurrentTextBothFontColor () const;
//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanSetCurrentTextFont () const;

//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	SetCurrentTextBothFontName (const wchar_t* wcpFontName);
//	virtual void	SetCurrentTextBothFontSize (mmetol mmFontSize);
//	virtual void	SetCurrentTextBothFontWeight (WORD wWeight);
//	virtual void	SetIsCurrentTextBothFontItalic (BOOL bIsItalic);
//	virtual void	SetIsCurrentTextBothFontUnderline (BOOL bIsUnderline);
//	virtual void	SetCurrentTextBothFontColor (COLORREF colorRef);
//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual void	OnTextInflateFontSize ();
	virtual void	OnTextDeflateFontSize ();
//----- 05.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	GetCurrentTextFont (FCFontCharInfo& fciExtFontInfo, FCFontCharInfo& fciStdFontInfo) const;
	virtual BOOL	SetCurrentTextFont (const FCFontCharInfo& fciExtFontInfo, const FCFontCharInfo& fciStdFontInfo);
//----- 05.06.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.06.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	virtual void	OnOleDocumentOpened ();
//	virtual void	OnOleDocumentClosed ();
////----- 05.06.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


	virtual void	OnDraw (CDC* pDC);
// 05.07.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDraw (CDC* pDC, const DBLRect* pmmrtRgn = NULL, long lRgnSize = 0);
	virtual void	Select (CDC* pDC);
	virtual void	Unselect (CDC* pDC);
	virtual BOOL	CanSelectTool () const;

	virtual void	DrawSelectMark (CDC* pDC, FCObjDynabase* pObj);
	virtual void	OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj);
	virtual void	OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj);
	virtual void	OnClearSelectObj (CDC* pDC);

//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual const ObjDynabaseVector& GetSelectLocalObjVector () const;
//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	ClearSelectLocalObj (CDC* pDC);
//	virtual void	AppendSelectLocalObj (CDC* pDC, FCObjDynabase* pObj);
//	virtual void	AppendSelectLocalObj (CDC* pDC, const ObjDynabaseVector& vObj);
//	virtual void	RemoveSelectLocalObj (CDC* pDC, FCObjDynabase* pObj);
//	virtual BOOL	IsSelectLocalObj (FCObjDynabase* pObj) const;
//	virtual FCObjDynabase*	GetLastSelectLocalObj ();
//----- 05.06.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 05.06.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	SetLastSelectLocalObj (FCObjDynabase* pObj);
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanDelete () const;
	virtual void	OnDelete (CDC* pDC);
	virtual BOOL	CanBackspace () const;
	virtual void	OnBackspace (CDC* pDC);

	virtual BOOL	CanObjectGroup () const;
	virtual void	OnObjectGroup ();
	virtual BOOL	CanObjectUngroup () const;
	virtual void	OnObjectUngroup ();

	virtual BOOL	CanUndo () const;
	virtual void	OnUndo ();
	virtual BOOL	CanRedo () const;
	virtual void	OnRedo ();

	virtual BOOL	CanSelectAll () const;
	virtual void	OnSelectAll ();
	virtual BOOL	CanClearSelect () const;
	virtual void	OnClearSelect ();
//----- 05.06.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanSelectSameKindOfObject () const;
	virtual void	OnSelectSameKindOfObject ();
//----- 05.06.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.07.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanSelectNext () const;
	virtual void	OnSelectNext ();
//----- 05.07.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanCopy () const;
	virtual void	OnCopy ();

//----- 05.07.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanCopyText () const;
	virtual void	OnCopyText ();
//----- 05.07.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanPaste () const;
	virtual void	OnPaste (CDC* pDC);
	virtual BOOL	CanPasteSpec (UINT dwFormat) const;
	virtual void	OnPasteSpec (CDC* pDC, UINT dwFormat);
// 06.11.21 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual DWORD	GetPasteOverAttr (const ObjDynabaseVector& vObj) const;
//----- 05.07.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanPasteOverAs () const;
	virtual void	OnPasteOverAs ();
//----- 05.07.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanFindText () const;
	virtual void	OnFindText ();
	virtual BOOL	CanReplaceText () const;
	virtual void	OnReplaceText ();
	virtual BOOL	CanFindNextText () const;
	virtual void	OnFindNextText ();
	virtual BOOL	CanFindPrevText () const;
	virtual void	OnFindPrevText ();
//----- 05.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanFindTextAll () const;
	virtual void	OnFindTextAll ();
//----- 05.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual BOOL	CanFindTextAllInSelect () const;
	virtual void	OnFindTextAllInSelect ();

	virtual BOOL	CanReplaceNextText () const;
	virtual void	OnReplaceNextText ();
	virtual BOOL	CanReplacePrevText () const;
	virtual void	OnReplacePrevText ();
	virtual BOOL	CanReplaceTextAll () const;
	virtual void	OnReplaceTextAll ();

	virtual BOOL	CanReplaceTextAllInSelect () const;
	virtual void	OnReplaceTextAllInSelect ();

	virtual BOOL	CanLayerOrder () const;
	virtual void	OnLayerOrder ();
	virtual void	OnMoveCurrentLayer (long lIndex);

//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanMoveInLowerLayer () const;
	virtual void	OnMoveInLowerLayer ();
	virtual BOOL	CanMoveInUpperLayer () const;
	virtual void	OnMoveInUpperLayer ();
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanSheetOrder () const;
	virtual void	OnSheetOrder ();
	virtual BOOL	CanMoveCurrentSheet () const;
	virtual void	OnMoveCurrentSheet (SheetID stid);

//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanMoveInPrevSheet () const;
	virtual void	OnMoveInPrevSheet ();
	virtual BOOL	CanMoveInNextSheet () const;
	virtual void	OnMoveInNextSheet ();
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanObjectAlignObj (FTAlignType nType) const;
	virtual void	OnObjectAlignObj (FTAlignType nType);

	virtual BOOL	CanObjectRotateObj () const;
	virtual void	OnObjectRotateObj (double dR);
	virtual BOOL	CanObjectMirrorObj (FTMirrorType nType) const;
	virtual void	OnObjectMirrorObj (FTMirrorType nType);

	virtual BOOL	CanObjectFrontObj () const;
	virtual void	OnObjectFrontObj ();
	virtual BOOL	CanObjectBackObj () const;
	virtual void	OnObjectBackObj ();
	virtual BOOL	CanObjectMostFrontObj () const;
	virtual void	OnObjectMostFrontObj ();
	virtual BOOL	CanObjectMostBackObj () const;
	virtual void	OnObjectMostBackObj ();

	virtual BOOL	CanFormatText () const;
	virtual void	OnFormatText ();
	virtual BOOL	CanTextLine () const;
	virtual void	OnTextLine ();
	virtual BOOL	CanTextMargin () const;
	virtual void	OnTextMargin ();
	virtual BOOL	CanAlignText () const;
	virtual int		GetTextAlignment () const;
	virtual void	OnAlignText (int iAlign);
	virtual BOOL	CanVertAlignText () const;
	virtual int		GetTextVertAlignment () const;
	virtual void	OnVertAlignText (int iAlign);

	virtual BOOL	CanObjectPutRtfObj () const;
	virtual void	OnObjectPutRtfObj ();

	virtual BOOL	IsEditingText () const;
	virtual void	OnStopToEditText ();

	virtual BOOL	CanObjectInsertJoint () const;
	virtual void	OnObjectInsertJoint ();
	virtual BOOL	CanObjectConnect () const;
	virtual void	OnObjectConnect ();
	virtual BOOL	CanObjectDisconnect () const;
	virtual void	OnObjectDisconnect ();

	virtual BOOL	CanObjectCrossSheet () const;
	virtual void	OnObjectCrossSheet ();

	virtual BOOL	CanObjectSizeToText () const;
	virtual void	OnObjectSizeToText ();

//----- 01.07.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanDeleteRichText () const;
	virtual void	OnDeleteRichText ();
//----- 01.07.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanObjectConvertToPoly () const;
	virtual void	OnObjectConvertToPoly ();
//----- 05.06.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.03.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	CanObjectExchangeEdge () const;
//	virtual void	OnObjectExchangeEdge ();
//----- 06.03.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanObjectTableInsertLine () const;
	virtual void	OnObjectTableInsertLine ();
	virtual BOOL	CanObjectTableAddLine () const;
	virtual void	OnObjectTableAddLine ();
	virtual BOOL	CanObjectTableInsertColumn () const;
	virtual void	OnObjectTableInsertColumn ();
	virtual BOOL	CanObjectTableAddColumn () const;
	virtual void	OnObjectTableAddColumn ();
	virtual BOOL	CanObjectTableDeleteLine () const;
	virtual void	OnObjectTableDeleteLine ();
	virtual BOOL	CanObjectTableDeleteColumn () const;
	virtual void	OnObjectTableDeleteColumn ();
	virtual BOOL	CanObjectTableMergeCell () const;
	virtual void	OnObjectTableMergeCell ();
	virtual BOOL	CanObjectTableSplitCell () const;
	virtual void	OnObjectTableSplitCell ();
	virtual BOOL	CanObjectMoveSnapLeft () const;
	virtual void	OnObjectMoveSnapLeft ();
	virtual BOOL	CanObjectMoveSnapUp () const;
	virtual void	OnObjectMoveSnapUp ();
	virtual BOOL	CanObjectMoveSnapRight () const;
	virtual void	OnObjectMoveSnapRight ();
	virtual BOOL	CanObjectMoveSnapDown () const;
	virtual void	OnObjectMoveSnapDown ();
//----- 05.09.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanObjectPutTimeLabel () const;
	virtual void	OnObjectPutTimeLabel ();
	virtual BOOL	CanObjectTimeLabelProperty () const;
	virtual void	OnObjectTimeLabelProperty ();
//----- 05.09.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.11.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanObjectRotate () const;
	virtual void	OnObjectRotate ();
//----- 05.11.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanExchangeHeadTail () const;
	virtual void	OnExchangeHeadTail ();
//----- 05.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanZoomView () const;

	virtual FCObjDynabase*	GetInsideObject () const;
// 06.11.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	CanLockStatus () const;
// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	GetLockStatus () const;			// _xZkqqHx_iDhLiDfOiDjDiCmMiDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_
	virtual BOOL	SetLockStatus (BOOL bLocked);	// _xZkqqHx_iDhLiDfOiDjDiCmMiDiNiDgCiDeOiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual long	GetNextTool () const;
	virtual void	SetNextTool (long lToolId);
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanHandle (const FCObjDynabase* pObj) const;

	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	static BOOL		IsFindDialogVisible ();
	static BOOL		IsReplaceDialogVisible ();

	virtual BOOL	IsObjectCommandEnable (DWORD dwCmdID) const;

	FCToolBase ();
	virtual ~FCToolBase ();
protected:
	virtual void	FocusFrameDrawBegin (CDC* pDC, const DBLPoint& mmpt);
	virtual void	FocusFrameDrawing (CDC* pDC, const DBLPoint& mmpt);
	virtual void	FocusFrameDrawEnd (CDC* pDC);
	virtual DBLRect GetFocusFrame () const;
	virtual void	DrawCurFocusFrame (CDC* pDC);
	virtual void	EndOfSession ();

	virtual FCObjDynabase*	GetLastSelectLocalObj ();

	virtual void	LocalObjMovedBefore (const ObjDynabaseVector& vObj);
	virtual void	LocalObjMovedAfter ();
	virtual BOOL	CanEditSelectedLocal () const;

	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void	CreatePropertyPage (CPropertyPageVector& vPropPage);
	virtual BOOL	OneLetterCommandEnable (CMenu* pMenu);

	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	virtual BOOL	CanSpecifySearchChipText () const;
	virtual BOOL	CanSpecifySearchLayer () const;
	virtual BOOL	IsAvailableFindTextAll () const;
	virtual BOOL	IsAvailableFindTextAllInSelect () const;
	virtual BOOL	IsAvailableReplaceTextAllInSelect () const;

	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	static CFCDlgFindText*		GetFindDialog (const FCToolBase* pTool);
	static CFCDlgReplaceText*	GetReplaceDialog (const FCToolBase* pTool);
	static FCSearchParser*		GetSearchParser ();

	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMjAnNjCoIiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	static void	GetFontInfoProc (FCFontCharInfo& fciAnsi,
								FCFontCharInfo& fciSjis, void* pData);
	static void	SetFontInfoProc (const FCFontCharInfo& fciAnsi,
								const FCFontCharInfo& fciSjis, void* pData);

//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// SDK_xZkqqHx_iCmMiMnNiKlHjAkLiCmMiClNiCnPiBeBiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
public:
	virtual void	SwitchCurrentTool (long lToolId, BOOL bDoImmediate);
	virtual BOOL	IsToolSwitching () const;
	virtual void	SetIsToolSwitching (BOOL bIsToolSwitching);
//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

protected:
	DWORD	m_dwLastObjID;		// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
//----- 06.06.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_jFjEjFgJiCmMjFnCiPfHjHhA_xHqqkZx_ -----
	ObjDynabaseVector	m_vMovedObj;		// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
//----- 06.06.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

private:
	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	static auto_ptr<CFCDlgFindText>		m_atpFindDlg;		// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
	static auto_ptr<CFCDlgReplaceText>	m_atpReplaceDlg;	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
	static auto_ptr<FCSearchParser>		m_pSp;				// _xZkqqHx_iMjPiNpFiDeHiDjDiDfHiDjDiBeC_xHqqkZx_
	static BOOL		m_bFirstSearch;
	static WString	m_strCurFindText;
	static WString	m_strCurReplaceText;
	static BOOL		m_bCurIsRegExp;
	static BOOL		m_bCurIsCnvUpper;
	static BOOL		m_bCurIsMultiWord;

	BOOL		m_bIsShowFindDlg;		// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_
	BOOL		m_bIsShowReplaceDlg;	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeFjEpBjFfMiOkGiCmMiLeMiJkPjHhAiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjHhA_xHqqkZx_ -----
	DBLPoint	m_mmptFocusBegin;	// _xZkqqHx_iNmFiPiJiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	DBLPoint	m_mmptFocusLatest;	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_

	BOOL		m_bIsLocked;		// _xZkqqHx_iDgDiBfLiDiLiCmMiDiNiDgCiDeOiPpDjBnEiBeC_xHqqkZx_
// 06.04.08 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	long		m_lNextToolId;		// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_

// 06.12.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	BOOL		m_bIsToolSwitching;	// _xZkqqHx_iDgDiBfLiDiLiCpAjFmPiNfIjCiGiCkJiBeI_xHqqkZx_

//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeIiDjDiDgHiPoOjFpB_xHqqkZx_ -----
//	FCFontCharInfo	m_fciBothFontInfo;	// _xZkqqHx_iMlLiNnNiCmMiLkEjCmKiDhEiDeIiDjDiDgHiPoOjFpBiBeC_xHqqkZx_
//----- 06.10.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jFjEjFgJiCmMjFnCiPfHjHhA_xHqqkZx_ -----
//	ObjDynabaseSet	m_stMoveTopObj;		// LocalObjMovedBefore,LocalObjMovedAfter_xZkqqHx_jHhAiDiPiBfLiDeOiBeC_xHqqkZx_
//----- 06.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCToolBase.

#endif//__ToolBase_h
