#include "stdafx.h"
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilMisc.h"			// For FFSetCapture.etc.
#include "UtilStr.h"			// For FFLoadWString.
#include "UtilWin.h"			// For FFPostSendMessage.
#include "DynamicDraw.h"		// For FFCanCreateObject.
#include "RegData.h"			// For g_pReg.
#include "DynamicDrawView.h"	// For g_pView.
#include "FoundDoc.h"			// For g_pDoc.
#include "ObjDynabase.h"			// For FCObjDynabase.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "PursuerText.h"		// For CFCPursuerText.
#include "ToolBaseRectCreate.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFTCResizeCheck
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOjHhAiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_OnLButtonDown_xZkqqHx_jCiGiCmF_xHqqkZx_
 *			FCResizeWork::OnResizeFirst_xZkqqHx_iCmMiIpIjAjEiCmGiClFiCmEjDgOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:OnResizeFirst_xZkqqHx_iCmFjAnNjCoIiClFiClNjFjEjFgJiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			bXPosi	:X_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			mmrtNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL FFTCResizeCheck (const FCObjDynabase* objp, BOOL bXPosi, BOOL bYPosi,
							 const DBLRect& mmrtNew)
{
// 05.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return objp->IsResizable(bXPosi, bYPosi, mmrtNew);
	return objp->GetIsResizable(mmrtNew.Width(), mmrtNew.Height());
} // FFTCResizeCheck.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBaseRectCreate::OnDraw (CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_CREATING:		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
//		m_resizeWork.DrawCurFrame(pDC);
//		break;
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolBaseRectCreate::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
//----- 05.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiDeKiBfLiDfMiDiLiPoOjFpBiBeCiClBiCoKiCmFiDhNiDeFiDfIiInKjDkOiOjOiCmJiDhNiBfLiDeOjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
//	m_iCursorNew = FDPA_HIT_NOT_MOLIP;
//----- 05.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iNoMjAkMjFjEjFgJiBeC_xHqqkZx_
	m_objpNew = NULL;
} // FCToolBaseRectCreate::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::GetRectHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMiOjOiCmMjCmHjAnFiDhBiDjDiDgHjFfMiOkGjFlGiOjKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHint	:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmrtFrame	:_xZkqqHx_iDiKiDfEiDeDiDfJjCiGiCmMiDhEiDiMiBfLiDiAiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 left < right, top < bottom _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::GetRectHintText (WString& wstrHint, const DBLRect& mmrtFrame) const
{
	//	_xZkqqHx_iNlGiPoDiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
	//	_xZkqqHx_iJeFiJlKiNmAjFfH_xHqqkZx_: (%f, %f)\r\n
	//	_xZkqqHx_jFjN_xHqqkZx_ x _xZkqqHx_iNiCiClD_xHqqkZx_: (%f, %f)\r\n
	wstrHint.Format(FFLoadWString(IDS_FORM_RECT_HINT).c_str(),
					mm2hi(mmrtFrame.left), mm2hi(mmrtFrame.top),
					mm2hi(mmrtFrame.right), mm2hi(mmrtFrame.bottom),
					mm2hi(mmrtFrame.Width()), mm2hi(mmrtFrame.Height()));
} // FCToolBaseRectCreate::GetRectHintText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::InitNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCkKiJjPiClDiCoKiClNiOjOiCmJiNoMjAkMiClFiClNjFjEjFgJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_jFjEjFgJiCmMiNlGiPoDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMjBkOjAkLiCkKiLlGiCmBiCmEiCkCiCoJiPoKiNiHiBgJiJkBjFjNiCePiCmGiCkJiBgKiBeBiClBiClBiCmF_xHqqkZx_
 *			_xZkqqHx_jFoCjAlDiClFiCmEiBeBiClLiCmMiMoDiCmMiDiKiDfEiDeDiDfJiCpAiJmCjEfMiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBaseRectCreate::InitNewObject (FCObjDynabase* pObj, const DBLPoint& mmpt) const
{
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (Shift+_xZkqqHx_iNoMjAkMiMgOiDgDiBfLiDiLiCmFiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJjDjJjEoEiCmMjFjEjFgJiCkKiNoMjAkMiClDiCoKiCmEiClFiCnMiCkEiBeCjAlDjFpLiMgAiCmMjFjEjFgJiCkKjFeLjHhG_xHqqkZx_)-----
//	DBLRect mmrtFrame = pObj->GetResizeFrame();
//	//----- _xZkqqHx_iKoOiPiAiDfEiDeDiDfJiCpAiMhGiOfK_xHqqkZx_ -----
//	DBLPoint mmptSz(mmrtFrame.Width(), mmrtFrame.Height());
//	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJjEoEjHoBiClFiClNiDfEiDeDiDfJiBeBiKiOiCmCjBoFiCkLiCkCjFnDiCkK_xHqqkZx_10_xZkqqHx_iDhMiDeDiDjDiDgHiCmJiCmIiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
//	mmetol mmStd = (mmptSz.x < mmptSz.y) ? mmptSz.y : mmptSz.x;
//	if (almost0(mmStd)) return FALSE;
//	mmptSz /= (mmStd / lg2mm(10));
//	if (almost0(mmptSz.x))	// _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
//		mmptSz.x = 0.0;	// _xZkqqHx_jAiCjClMjApMiCpAiPgDiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
//	if (almost0(mmptSz.y))	// _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiHiBeC_xHqqkZx_
//		mmptSz.y = 0.0;	// _xZkqqHx_jAiFjFlNjApMiCpAiJkBiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (Shift+_xZkqqHx_iNoMjAkMiMgOiDgDiBfLiDiLiCmFiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJjDjJjEoEiCmMjFjEjFgJiCkKiNoMjAkMiClDiCoKiCmEiClFiCnMiCkEiBeCjAlDjFpLiMgAiCmMjFjEjFgJiCkKjFeLjHhG_xHqqkZx_)-----
	// _xZkqqHx_iImIiJlKiCmFiCmNiBeB_xHqqkZx_mmptSz _xZkqqHx_iCkKiPfMjFkKiCmIjBoFiCkLiClDiCkKjFeLjHhGiBeCiCmIiClKiCmIiCoHiBeB_xHqqkZx_InitNewObject_xZkqqHx_iCmF_xHqqkZx_
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiClNjFjEjFgJiCmMiJeFiJlKiCpA_xHqqkZx_HitTest_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmJjDgOiClFiCmEiBeBiJeFiJlKiCmM_xHqqkZx_
	// _xZkqqHx_iDgOiDjDiDgIiDiLiCpAiOoGjDlOiClHiCoJiCkJiCoHiBeCiPfMjFkKiCmIjBoFiCkLiClDiCkKiCmIiCkCiCmGiBeB_xHqqkZx_HitTest_xZkqqHx_iKnGjAjEiCkK_xHqqkZx_
	// _xZkqqHx_jCiGiJlKiCmGiCkJiNlGiJlKiCmGiCkJiCpAjFnEiClHiPoKiNiHiCkKiCmFiCmEiCkNiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCmMiPoKiNiHiBeBjFjEjFgJiCpAiNoMjAkMiClFiClNiOjOiCmJiBeBjAlDiClFiCkCiDiKiDfEiDeDiDfJiCkKiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	DBLRect mmrtFrame = pObj->GetResizeFrame();
	// _xZkqqHx_jAfGiClFiCkCiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPoint mmptSz = lg2mm(CPoint(10,10));
	if (almost0(mmrtFrame.Width()))	// _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		mmptSz.x = 0.0;	// _xZkqqHx_jAiCjClMjApMiCpAiPgDiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
	if (almost0(mmrtFrame.Height()))	// _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		mmptSz.y = 0.0;	// _xZkqqHx_jAiFjFlNjApMiCpAiJkBiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (Shift+_xZkqqHx_iNoMjAkMiMgOiDgDiBfLiDiLiCmFiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJjDjJjEoEiCmMjFjEjFgJiCkKiNoMjAkMiClDiCoKiCmEiClFiCnMiCkEiBeCjAlDjFpLiMgAiCmMjFjEjFgJiCkKjFeLjHhG_xHqqkZx_)-----

	// _xZkqqHx_iDiKiDfEiDeDiDfJiMpDjFoCiDfEiDeDiDfJiBeC_xHqqkZx_
	DBLRect mmrtInit(mmpt, mmpt);
	switch (g_pReg->GetResizeFixPosition() & FD_RPT_H_MASK)
	{
	case FD_RPT_H_LEFT:	// _xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBjAiFjFlNjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.right = mmrtInit.left + mmptSz.x;
		break;
	case FD_RPT_H_CENTER:	// _xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBjAiFjFlNjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.left -= mmptSz.x / 2.0;
		mmrtInit.right = mmrtInit.left + mmptSz.x;
		break;
	case FD_RPT_H_RIGHT:	// _xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBjAiFjFlNjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.left = mmrtInit.right - mmptSz.x;
		break;
	}
	switch (g_pReg->GetResizeFixPosition() & FD_RPT_V_MASK)
	{
	case FD_RPT_V_TOP:		// _xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBjAiCjClMjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.bottom = mmrtInit.top + mmptSz.y;
		break;
	case FD_RPT_V_CENTER:	// _xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBjAiCjClMjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.top -= mmptSz.y / 2.0;
		mmrtInit.bottom = mmrtInit.top + mmptSz.y;
		break;
	case FD_RPT_V_BOTTOM:	// _xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBjAiCjClMjFpLiMpMiCmJiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		mmrtInit.top = mmrtInit.bottom - mmptSz.y;
		break;
	}
	// _xZkqqHx_iMpDjFoCiCkKiDiKiDfEiDeDiDfJiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// 05.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!pObj->IsResizable(TRUE, TRUE, mmrtInit)) return FALSE;
	if (!pObj->GetIsResizable(mmrtInit.Width(), mmrtInit.Height())) return FALSE;
	pObj->Resize(TRUE, TRUE, mmrtInit, pObj->GetResizeFrame());
	return TRUE;
} // FCToolBaseRectCreate::InitNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::GetRegisteredObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjEhKjChFiOjOiCmJiBeBjEhKjChFiClHiCoJjFjEjFgJiBgJ_xHqqkZx_ID_xZkqqHx_jDgPjIfOiNmPiCnNiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vNewObj		:_xZkqqHx_jEhKjChFiClHiCoJjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLinkRec	:vNewObj_xZkqqHx_iCmJjElKiCkEjAfGiClFiCkCiDiKiDjDiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolChip_xZkqqHx_iCmMjDmGjHkHjFjEjFgJiDgAiDgCiDhGiCmJjBmOiJjOiClHiCoJiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::GetRegisteredObject (ObjDynabaseVector& vNewObj,
												FCLinkRecVector& vLinkRec)
{
	vNewObj.clear();
	vLinkRec.clear();
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	m_objpNew->RegisterObjID();
	vNewObj.push_back(m_objpNew);
} // FCToolBaseRectCreate::GetRegisteredObject.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::OnDrawState (CDC* pDC, int iState)
{
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_CREATING:		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
		m_resizeWork.DrawCurFrame(pDC);
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolBaseRectCreate::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseCreate.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolBaseRectCreate::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
		if (FFCanCreateObject())
		//----- _xZkqqHx_jFjEjFgJiNoMjAkMiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
			switch (iEvent)
			{
			case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
				iNextState = STATE_ENTER_CREATE;	// _xZkqqHx_iNoMjAkMjDpMiMpLiBeC_xHqqkZx_
				break;
			}
// 02.06.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
		}
		break;
	case STATE_ENTER_CREATE:	// _xZkqqHx_iNoMjAkMjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_CREATE;	// _xZkqqHx_iNoMjAkMiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_CREATE;		// _xZkqqHx_iNoMjAkMiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_CREATE:	// _xZkqqHx_iNoMjAkMiKeKiOgOiBeC_xHqqkZx_
		if (m_objpNew != NULL)
			iNextState = STATE_CREATING;		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
		else
			iNextState = STATE_EXIT_CREATE;		// _xZkqqHx_iNoMjAkMiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_CREATING:		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_CREATING;		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_CREATE;		// _xZkqqHx_iNoMjAkMiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_CREATE:		// _xZkqqHx_iNoMjAkMiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_CREATE;		// _xZkqqHx_iNoMjAkMiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_CREATE:		// _xZkqqHx_iNoMjAkMiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolBaseRectCreate::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_CREATE:	// _xZkqqHx_iNoMjAkMjDpMiMpLiBeC_xHqqkZx_
		StateEnterCreate(pDC);
		break;
	case STATE_START_CREATE:	// _xZkqqHx_iNoMjAkMiKeKiOgOiBeC_xHqqkZx_
		StateStartCreate(pDC);
		break;
	case STATE_CREATING:		// _xZkqqHx_iNoMjAkMjCiGiBeC_xHqqkZx_
		StateCreating(pDC);
		break;
	case STATE_STOP_CREATE:		// _xZkqqHx_iNoMjAkMiPeJjHlJiBeC_xHqqkZx_
		StateStopCreate(pDC);
		break;
	case STATE_EXIT_CREATE:		// _xZkqqHx_iNoMjAkMiPgPiMpLiBeC_xHqqkZx_
		StateExitCreate(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolBaseRectCreate::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateEnterCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateEnterCreate (CDC* pDC)
{
	TRACE(_T("StateEnterCreate\r\n"));
	::FFSetCapture(g_pView->m_hWnd);	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	// _xZkqqHx_iNoMjAkMjFjEjFgJjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_objpNew = NULL;
	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmMiImKjChFiBgJjFmPiKlHiMoDiBgKiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmptDownCnv = m_mmptCnv;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, TRUE);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCjFjEjFgJiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiBeC_xHqqkZx_
	FFGetMainWnd()->MoveRulerMMK(m_mmptDownCnv, m_mmptDownCnv);
} // FCToolBaseRectCreate::StateEnterCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateStartCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateStartCreate (CDC* pDC)
{
	TRACE(_T("StateStartCreate\r\n"));
	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiDfCiDhDiBfLiCpAiNoMjAkMiBeC_xHqqkZx_
	const FCObjDynabase* pTmpl = GetReferenceObject();
	if (pTmpl != NULL)
	//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_objpNew = (FCObjDynabase*)pTmpl->Duplicate();
		// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
		if (InitNewObject(m_objpNew, m_mmptDownCnv))
		//----- _xZkqqHx_iPiJiKpKiJlLiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			DBLPoint mmptHit;
			short nHandle = m_objpNew->HitTest(mmptHit, DBLPoint(m_objpNew->GetResizeFrame().right,
																m_objpNew->GetResizeFrame().bottom));
			// _xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiPiAjEpFiPiIjHjNiBeC_xHqqkZx_
			m_resizeWork.OnResizeFirst(FFTCResizeCheck, m_objpNew, pDC, nHandle);
			// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
			g_pView->SetAutoScroll(TRUE);
		} else
		//----- _xZkqqHx_iPiJiKpKiJlLiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			delete m_objpNew;
			m_objpNew = NULL;	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmFiOgHiCkEiPoKiNiHiCkKiCkAiCoJiInHiBeBiLpDiCmJiClHiCoJiBeC_xHqqkZx_
		}
	} else
	//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		m_objpNew = NULL;
	}
} // FCToolBaseRectCreate::StateStartCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateCreating
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateCreating (CDC* pDC)
{
	TRACE(_T("StateCreating\r\n"));
	// _xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiPiIjHjNiBeC_xHqqkZx_
	(void)m_resizeWork.OnResizeNext(pDC, m_dwFlags, m_mmptMsc);
	//----- _xZkqqHx_jFjEjFgJiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_ -----
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FFGetMainWnd()->MoveRulerMMK(m_resizeWork.GetFixPoint(), m_resizeWork.GetMovePoint());
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCmEiBeBiDiLiBfLiDiJiBfLiCmJjFfMiOkGiBeC_xHqqkZx_
	// _xZkqqHx_iDiKiDfEiDeDiDfJiMmFjCoIjDfPiCkKjAhNiMgAjCiGjAfDiCmMiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeB_xHqqkZx_GetFixPoint/GetMovePoint_xZkqqHx_iCmN_xHqqkZx_
	// _xZkqqHx_iOgHiCkGiCmIiCkCiBeC_xHqqkZx_
	DBLRect mmrtResizeFrame = m_resizeWork.GetResizeFrame();
	mmrtResizeFrame.NormalizeRect();
	FFGetMainWnd()->MoveRulerMMK(	DBLPoint(mmrtResizeFrame.left, mmrtResizeFrame.top),
									DBLPoint(mmrtResizeFrame.right, mmrtResizeFrame.bottom));
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupResizeObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJiNoMjAkMiPoOjFpBiCpAjFfMiOkGiBeC_xHqqkZx_
		WString wstrHint;
		GetRectHintText(wstrHint,
						mmrtResizeFrame);
		FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBaseRectCreate::StateCreating.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateStopCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateStopCreate (CDC* pDC)
{
	TRACE(_T("StateStopCreate\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	BOOL bXPosi, bYPosi;
	DBLRect	mmrtResized;
	// _xZkqqHx_jFjEjFgJiNoMjAkMiCmMiNmFiPiJiCmMiDfEiDeDiDfJiCmNjDeLjDjGiCmIiCmMiCmFiBeBiDiKiDfEiDeDiDfJiCkJiCmHiCkEiCkJiCmNiLeDiCmJiClFiCmIiCkCiBeC_xHqqkZx_
	(void)m_resizeWork.OnResizeEnd(pDC, bXPosi, bYPosi, mmrtResized);
	if (mmrtResized.Width() + mmrtResized.Height() < 1)
	//----- _xZkqqHx_iDfEiDeDiDfJiCkKiPkMiClDiClHiCkMiCoJ_xHqqkZx_ -----
	{
//----- 02.05.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
//		// _xZkqqHx_jFjEjFgJiCmMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
//		m_objpNew->Terminate();
//----- 02.05.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
		// _xZkqqHx_jAfGiLeLiCmJiNoMjAkMiClFiClNjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		delete m_objpNew;
		m_objpNew = NULL;	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmFiOgHiCkEiPoKiNiHiCkKiCkAiCoJiInHiBeBiLpDiCmJiClHiCoJiBeC_xHqqkZx_
	} else
	//----- _xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCmEiCkCiCoJiBjFiDfEiDeDiDfJiCkKiPfMjFkKjBoFiCkLiCkC_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiLeLjFjEjFgJiCpAiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		m_objpNew->Resize(bXPosi, bYPosi, mmrtResized, m_objpNew->GetResizeFrame());
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeCiIoKjEnEiNmFiPiJiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiCmNjFjEjFgJjDgPjIfOiCmN_xHqqkZx_
		// _xZkqqHx_jFhDiJmCiCmIiCmMiCmF_xHqqkZx_GetRegisteredObject_xZkqqHx_iCmMjBePiCmJiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// CFCFoundDoc::RegisterObject_xZkqqHx_iCmMiJpAjAoAiOfBiPmGiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		ObjDynabaseVector vNewObject;
		FCLinkRecVector vLinkRec;
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		GetRegisteredObject(vNewObject, vLinkRec);
		ASSERT(!vNewObject.empty());
		// m_objpNew _xZkqqHx_iCmMjCgMiCpAiNfIjAfGiBeC_xHqqkZx_
		m_objpNew = vNewObject.back();
		// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = vNewObject.begin(); iObj != vNewObject.end(); iObj++)
			g_pDoc->MulticmdCreate1Obj(*iObj, g_pDoc->GetCurrentSheetId(), LAST_LAYER_ORDER);
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
		ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDiKiDjDiDeOjAlGjAkMiBeC_xHqqkZx_
		FCLinkRecVector::const_iterator iLr;
		for (iLr = vLinkRec.begin(); iLr != vLinkRec.end(); iLr++)
		{
			g_pDoc->CmdAppend1Link(stRedrawObj, (*iLr).m_mlpFrom, (*iLr).m_mlpTo, (*iLr).m_wLinkKind);
		}
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(stRedrawObj);
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
		g_pView->ClearSelectObj(pDC);
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiBeC_xHqqkZx_
		g_pView->AppendSelectObj(vNewObject);
		// _xZkqqHx_jFjEjFgJiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(vNewObject);
		g_pView->SendRgnRedraw();
		// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
		SetLastCreateObj(vNewObject.back());
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jCfAjDmGiCmMiDiJiDhIiDiLjFjEjFgJiCmMiPoKiNiHiBeBiClHiCkOjFnCiPfHiPiIjHjNiCmJjDpMiCoJiBeC_xHqqkZx_
		// DDPro_xZkqqHx_iCmFiOgHiCkEiPoKiNiHiBeBiDiJiDhIiDiLjFjEjFgJiCmNjFkBiOmKiClFiCmEjFpKjChFiClHiCoJiCmG_xHqqkZx_
		// _xZkqqHx_iDiJiDhIiDiLiCkKjFmPiNfIiClDiCoKiCmIiCkCiCnMiCnMiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiPgPiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClHiCkOjFmPiNfIiClHiCoKiCmOiBeBjAfGiClFiCkCjDoAjHgFiCmFjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
		if (vNewObject.size() == 1 &&
			vNewObject.front()->IsKindOf(FDOJ_LABEL))
		{
			// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
			SetNextTool(ID_TOOL_EDIT_RICH_TEXT);
			// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
			SetLockStatus(FALSE);
		}
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // FCToolBaseRectCreate::StateStopCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseRectCreate::StateExitCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseRectCreate::StateExitCreate (CDC* pDC)
{
	TRACE(_T("StateExitCreate\r\n"));
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAjEpBiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_
	EndOfSession();
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
	::FFReleaseCapture();
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupResizeObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCpAjEpBjFfMiOkGiCmJiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->OnHide();
	}
} // FCToolBaseRectCreate::StateExitCreate.

