#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "ObjDynabase.h"		// For FCObjDynabase.
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilStdLib.h"		// For m1_for.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilBezier.h"		// For CalcBezier2.
#include "UtilMisc.h"			// For CalcRoundy.
#include "UtilGraph.h"		// For FCEditDraw.
#include "RegData.h"		// For GetOptiRegColor.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "ApproximateBezier.h"	// For FCApproximateBezier.
#include "ToolBezier.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *************************************************************************/
void FCToolBezier::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
	// _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPjEhKjHpBiBeC_xHqqkZx_
	m_vmmptPoly.clear();
// 05.04.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_vmmptPoly1.clear();
} // FCToolBezier::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::Unselect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJpAiPjMiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: _xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_.
 *************************************************************************/
void FCToolBezier::Unselect (CDC* pDC)
{
	// _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPjEhKjHpBiBeC_xHqqkZx_
	m_vmmptPoly.clear();
// 05.04.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_vmmptPoly1.clear();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Unselect(pDC);
} // FCToolBezier::Unselect.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBezier::OnDraw (CDC* pDC)
//{
//	if (!m_vmmptPoly.empty())
//	//----- _xZkqqHx_iOkJjHfCiLmIjApMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
////----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
////		FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
////		// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
////		CPointVector vlgptPoly;
////		mm2lg(vlgptPoly, m_vmmptPoly);
////		eDraw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
////----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		FCAutoDC atDC(pDC);
//		atDC.SetPen(	PS_SOLID,
//						mm2lg(GetReferenceObject()->GetStdPenWeight()),
//						g_pReg->GetOptiRegColor(FDCL_EDIT_LINE));
//		CPointVector vlgptPoly;
//		mm2lg(vlgptPoly, m_vmmptPoly);
//		atDC.Polyline(vlgptPoly.begin(), vlgptPoly.size());
////----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolBezier::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HCURSOR FCToolBezier::GetDefaultIdleCursor () const
{
	return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_BEZILINE);
} // FCToolBezier::GetDefaultIdleCursor.

//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::CalcEditLine
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lBeginIndex	:_xZkqqHx_iJlMjApMiCpAjFgAiJoGiClHiCoJjEmNiImNiCmMiBeBiNmFiPiJiCmMjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
// *						 _xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
// *			lJointCount	:_xZkqqHx_iJlMjApMiCpAjFgAiJoGiClHiCoJjEmNiImNiCmMjIeBiMiLjDfPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBezier::CalcEditLine (long lBeginIndex, long lJointCount)
//{
////----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
////	CRect lgrtView;
////	g_pView->GetClientRectLG(lgrtView);
////	//----- _xZkqqHx_jBePjElMiJlMjApMiCmMiMhGiOfK_xHqqkZx_ -----
////	// _xZkqqHx_iJlMjApMiNmAjFfHjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
////	m_vmmptPoly.clear();
////	// _xZkqqHx_iJlMjApMiCpAiMhGiOfKiBeC_xHqqkZx_
////	::CalcBezier2(	m_vmmptPoly,
////					(const FCPolyJoint*)m_pjvJoint.begin(),
////					m_pjvJoint.size(),
////					GetReferenceObject()->GetStdPenWeight(),
////					m_pjvJoint.size() - 3L, 1L,
////					g_->lgdPrecision,
////					g_->dZoom,
////					&lgrtView, 1,
////					StdMinRatio(lgrtView));
////	//----- _xZkqqHx_iMoDjElMiJlMjApMiCmMiMhGiOfK_xHqqkZx_ -----
////	// _xZkqqHx_iJlMjApMiNmAjFfHjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
////	m_vmmptPoly1.clear();
////	// _xZkqqHx_iJlMjApMiCpAiMhGiOfKiBeC_xHqqkZx_
////	::CalcBezier2(m_vmmptPoly1, (const FCPolyJoint*)m_pjvJoint.begin(),
////				m_pjvJoint.size(), GetReferenceObject()->GetStdPenWeight(),
////				m_pjvJoint.size() - 2L, 1L, g_->lgdPrecision, g_->dZoom, &lgrtView, 1,
////				StdMinRatio(lgrtView));
////----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect lgrtView;
//	g_pView->GetClientRectLG(lgrtView);
//	//----- _xZkqqHx_iJlMjApMiCmMiMhGiOfK_xHqqkZx_ -----
//	// _xZkqqHx_iJlMjApMiNmAjFfHjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_vmmptPoly.clear();
//	// _xZkqqHx_iJlMjApMiCpAiMhGiOfKiBeC_xHqqkZx_
//	::CalcBezier2(	m_vmmptPoly,
//					(const FCPolyJoint*)m_pjvJoint.begin(),
//					m_pjvJoint.size(),
//					GetReferenceObject()->GetStdPenWeight(),
//					lBeginIndex,
//					lJointCount,
//					g_->lgdPrecision,
//					g_->dZoom,
//					&lgrtView, 1,
//					StdMinRatio(lgrtView));
////----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolBezier::CalcEditLine.
//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::DrawEditLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiMhGiOfKiClFiClNiJlMjApMiCpAjFgAiJoGiBgJiPmBiLiOiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGiBgJiPmBiLiOiBgKjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCount	:_xZkqqHx_iCkCiCkNiCmCjBePiCmMiDhIiDfHiDeGiCnMiCmFjFgAiJoGiBgJiPmBiLiOiBgKiClHiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::DrawEditLine (CDC* pDC, long lCount)
{
//----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBePjElMiJlMjApMiBeBiMoDjElMiJlMjApMiLkEiCmJjFgAiJoGiCmMjFeLjHhGiCkKjGlDiCkCiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (m_vmmptPoly.empty() && m_vmmptPoly1.empty()) return;
//	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
//
//	// _xZkqqHx_jBePjElMiJlMjApMiCmMjFgAiJoGiCmMiPoKiNiHiBeC_xHqqkZx_
//	if (!m_vmmptPoly.empty())
//		eDraw.Polyline(m_vmmptPoly.begin(), m_vmmptPoly.size());
//	// _xZkqqHx_iMoDjElMiJlMjApMiCmMjFgAiJoGiCmMiPoKiNiHiBeC_xHqqkZx_
//	if (!m_vmmptPoly1.empty())
//		eDraw.Polyline(m_vmmptPoly1.begin(), m_vmmptPoly1.size());
//----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiJlMjApMiNmAjFfHiBeC_xHqqkZx_
	CPointVector vlgptPoly;
	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect lgrtView;
	g_pView->GetClientRectLG(lgrtView);
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
	//----- _xZkqqHx_iJlMjApMiCmMiMhGiOfK_xHqqkZx_ -----
	while (lCount != 0)
	{
		// 1 < lCount _xZkqqHx_iCmMiPoKiNiHiCmFiCoAiBeBiDhIiDfHiDeGiCpAjIeBjBlBiClDiClJiClI_xHqqkZx_
		// _xZkqqHx_iCfAiDfKiDePiDiBiDjDiDgHiClCiCmGiCmJjFgAiJoGiClHiCoJiBeCiDfDiDhOiCpAiOgDiClDiCmIiCkCiClNiCnPiBeC_xHqqkZx_
		// _xZkqqHx_iJlMjApMiCpAiMhGiOfKiBeC_xHqqkZx_
		::CalcBezier2(	vlgptPoly,
						(const FCPolyJoint*)m_pjvJoint.begin(),
						m_pjvJoint.size(),
						GetReferenceObject()->GetStdPenWeight(),
						m_pjvJoint.size() - 1 - lCount,
						1,
						g_->lgdPrecision,
						g_->dZoom,
						&lgrtView, 1,
						StdMinRatio(lgrtView));
		// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
		eDraw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
		lCount--;
	}
//----- 05.04.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBezier::DrawEditLine.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::OnDrawState (CDC* pDC, int iState)
{
	if (!m_vmmptPoly.empty())
	//----- _xZkqqHx_iOkJjHfCiLmIjApMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
//		// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
//		CPointVector vlgptPoly;
//		mm2lg(vlgptPoly, m_vmmptPoly);
//		eDraw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCAutoDC atDC(pDC);
		atDC.SetPen(	PS_SOLID,
						mm2lg(GetReferenceObject()->GetStdPenWeight()),
						g_pReg->GetOptiRegColor(FDCL_EDIT_LINE));
		CPointVector vlgptPoly;
		mm2lg(vlgptPoly, m_vmmptPoly);
		atDC.Polyline(vlgptPoly.begin(), vlgptPoly.size());
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolBezier::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolBezier::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:	// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		if (FFCanCreateObject())	// _xZkqqHx_iClBiCoKiCpAjDpMiCoKiCmIiCkCiCmGiBeBiDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJiBeC_xHqqkZx_
		//----- _xZkqqHx_jFjEjFgJiNoMjAkMiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			switch (iEvent)
			{
			case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
				iNextState = STATE_BEFORE_START;	// _xZkqqHx_iKeKiOgOjBePiPiIjHjNiBeC_xHqqkZx_
				break;
			}
		}
		break;
	case STATE_BEFORE_START:	// _xZkqqHx_iKeKiOgOjBePiPiIjHjNiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
		  {
				// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiOjOiCmMiPkNjHmKiCmMiDhNiDeFiDfIiInKjDkOiCmNjGlDiOiLiBeC_xHqqkZx_
				// _xZkqqHx_iDhEiDiKiBfLiDgOiDjDiDgIiClFiClNiCkNiCmIiCkCiCmMiCmJiBeBiDhNiDeFiDfIiCkKiCnEiCoKiCmE_xHqqkZx_
				// _xZkqqHx_iDhEiDiKiBfLiDgOiDjDiDgIiCmJiCmIiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
				CPoint lgptMove = mm2lg(m_mmptMsc - m_mmptMscStart);
				if (5 < labs(lgptMove.x) || 5 < labs(lgptMove.y))
					iNextState = STATE_START_FREEHAND;	// _xZkqqHx_iOkJjHfCiLmIjApMiKeKiOgOiBeC_xHqqkZx_
			break;
		  }
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_START_JOINT;		// _xZkqqHx_jIeBiMiLjDfPjAnNjCoIiKeKiOgOiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_DRAW_FREEHAND;		// _xZkqqHx_iOkJjHfCiLmIjApMjFgAiJoGiBeC_xHqqkZx_
		break;
	case STATE_DRAW_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMjFgAiJoGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_DRAW_FREEHAND;	// _xZkqqHx_iOkJjHfCiLmIjApMjFgAiJoGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_CREATE_FREEHAND;	// _xZkqqHx_iOkJjHfCiLmIjApMiNoMjAkMiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_CREATE_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMiNoMjAkMiBeC_xHqqkZx_
		iNextState = STATE_TERMINATE_FREEHAND;	// _xZkqqHx_iOkJjHfCiLmIjApMiPeJjHlJiBeC_xHqqkZx_
		break;
	case STATE_TERMINATE_FREEHAND:	// _xZkqqHx_iOkJjHfCiLmIjApMiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_IDLE;	// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolBezier::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_BEFORE_START:		// _xZkqqHx_iKeKiOgOjBePiPiIjHjNiBeC_xHqqkZx_
		StateBeforeStart(pDC);
		break;
	case STATE_START_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMiKeKiOgOiBeC_xHqqkZx_
		StateStartFreehand(pDC);
		break;
	case STATE_DRAW_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMjFgAiJoGiBeC_xHqqkZx_
		StateDrawFreehand(pDC);
		break;
	case STATE_CREATE_FREEHAND:		// _xZkqqHx_iOkJjHfCiLmIjApMiNoMjAkMiBeC_xHqqkZx_
		StateCreateFreehand(pDC);
		break;
	case STATE_TERMINATE_FREEHAND:	// _xZkqqHx_iOkJjHfCiLmIjApMiPeJjHlJiBeC_xHqqkZx_
		StateTerminateFreehand(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolBezier::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateBeforeStart
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjBePiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateBeforeStart (CDC* pDC)
{
	m_mmptMscStart = m_mmptMsc;
} // FCToolBezier::StateBeforeStart.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateStartJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateStartJoint (CDC* pDC)
{
	TRACE(_T("StateStartJoint\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	m_pjvJoint.clear();
	// _xZkqqHx_iDfPiDhOiBfLjDfPiCmGiNmFiPiJiCmMjDfPiCmGiJlMjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
	m_pjvJoint.push_back(FCPolyJoint(FDJT_ROUND, m_mmptCnv,
									DBLPoint(0,0), DBLPoint(0,0)));
	m_pjvJoint.push_back(FCPolyJoint(FDJT_ROUND, m_mmptCnv,
									DBLPoint(0,0), DBLPoint(0,0)));
	m_pjvJoint.push_back(FCPolyJoint(FDJT_ROUND, m_mmptCnv,
									DBLPoint(0,0), DBLPoint(0,0)));
	//----- _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	m_mmptFix = m_mmptCnv;
	m_mmlnvAry.clear();
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 0)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, -1)));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
} // FCToolBezier::StateStartJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateSetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateSetJoint (CDC* pDC)
{
	TRACE(_T("StateSetJoint\r\n"));
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawMark(pDC, TRUE);
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_pjvJoint[m_pjvJoint.size() - 1].m_mmptPivot !=
//		m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot)
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiClBiCmFiCmN_xHqqkZx_ rougheq _xZkqqHx_iCpAiOgHiCkEiBeCiCoNiClIiCkJiCmIiIoBiCkCiCmFiClHiCoIjElCiCkPiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	if (!rougheq(m_pjvJoint[m_pjvJoint.size() - 1].m_mmptPivot,
				m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot))
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_jBePiJpBiCfBjDfPiCkKiIoBiCkEiImKjChFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiJpBiCmMiJlMjApMiCpAiMhGiOfKiBjFiPmBiLiOiBeCiCfBjGhLiCmMiDhIiDfHiDeGiCmMiCkEiClPiCmMiMoDjElMiCmMiCnNiPmBiLiOiClHiCoJiBeC_xHqqkZx_
		DrawEditLine(pDC, 1);
		// _xZkqqHx_jAfGiClFiCkCiJlMjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		m_pjvJoint.push_back(FCPolyJoint(FDJT_ROUND,
										m_pjvJoint.back().m_mmptPivot,
										DBLPoint(0,0), DBLPoint(0,0)));
		//----- _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
		m_mmptFix = m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot;
		m_mmlnvAry.clear();
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0, 1)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 0)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 1)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, -1)));
	} else
	//----- _xZkqqHx_jBePiJpBiCfBjDfPiCkKjDkPiClGiImKjChFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiJpBiCmMiJlMjApMiCpAiMhGiOfKiBjFiPmBiLiOiBeC_xHqqkZx_
		DrawEditLine(pDC, 2);
	}
} // FCToolBezier::StateSetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateUnsetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateUnsetJoint (CDC* pDC)
{
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawMark(pDC, TRUE);
	if (m_pjvJoint.size() != 3)
	//----- _xZkqqHx_iOgOjDfPiCmMiCnNiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiBfIiJpBiCnMiCmFiCmMiJlMjApMiCpAiMhGiOfKiBjFiPmBiLiOiBeC_xHqqkZx_
		DrawEditLine(pDC, 3);
		// _xZkqqHx_iJlMjDfPiCpAiIoKiCmCiNoNiPjMiBeC_xHqqkZx_
		m_pjvJoint.pop_back();
		// _xZkqqHx_iNmFiMoDiCmMiJlMjDfPiCmMiIpIjDfPiCpAiCePiCmJjGnPiClHiBeC_xHqqkZx_
		m_pjvJoint.back().m_mmptPrev.SetPoint(0.0, 0.0);
		m_pjvJoint.back().m_mmptNext.SetPoint(0.0, 0.0);
		//----- _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
		m_mmptFix = m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot;
		m_mmlnvAry.clear();
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0, 1)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 0)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 1)));
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, -1)));
	} else
	//----- _xZkqqHx_iOgOjDfPiCmMiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiJpBiCmMiJlMjApMiCpAiMhGiOfKiBjFiPmBiLiOiBeC_xHqqkZx_
		DrawEditLine(pDC, 2);
	}
} // FCToolBezier::StateUnsetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateEraseJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLiPmBiLiOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateEraseJoint (CDC* pDC)
{
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawMark(pDC, TRUE);
	// _xZkqqHx_jBePiJpBiCmMiJlMjApMiCpAiMhGiOfKiBjFiPmBiLiOiBeC_xHqqkZx_
	DrawEditLine(pDC, 2);
} // FCToolBezier::StateEraseJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateDrawJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateDrawJoint (CDC* pDC)
{
	TRACE(_T("StateDrawJoint\r\n"));
	// _xZkqqHx_jAfGiClFiCkCiNmAjFfHjAnNjCoIiBeC_xHqqkZx_
	m_mmptMarkNew = m_mmptCnv;
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawMark(pDC, FALSE);
	// _xZkqqHx_jAfGiClFiCkCiOlCjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pjvJoint.back().m_mmptPivot = m_mmptCnv;
	if ((m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot - m_mmptCnv).PowLen() < 1.0)
	//----- _xZkqqHx_jBePiJpBiCmMjDfPiCmGiCmMiLjHjHkDiCkKiCfAiCiNiCiNjGkCjGjOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiJpBiCmMjDfPiCmGiCmMiLjHjHkDiCkKiCfAiCiNiCiNjGkCjGjOiCmMiPoKiNiHiCmNiKnLiCnNiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
		// CalcRoundy_xZkqqHx_iKnGjAjEiCmNiBeBiCfBjDfPiCmMiLjHjHkDiCkKiLnPiClHiCkMiCoJiCmGiInJiPoNiCmIjCgMiCpAjAnNjCoIiClHiCoJiClNiCnPiBeC_xHqqkZx_
		m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPrev.SetPoint(0.0, 0.0);
		m_pjvJoint[m_pjvJoint.size() - 2].m_mmptNext.SetPoint(0.0, 0.0);
	} else
	//----- _xZkqqHx_jBePiJpBiCmMjDfPiCmGiCmMiLjHjHkDiCkKiCfAiCiNiCiNiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePiIpIjDfPiBeFiMoDiIpIjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
		::CalcRoundy(m_pjvJoint[m_pjvJoint.size() - 2],
					 m_pjvJoint[m_pjvJoint.size() - 3].m_mmptPivot,
					 m_pjvJoint[m_pjvJoint.size() - 1].m_mmptPivot, 50);
	}
	// _xZkqqHx_jAfGiClFiCkCiJlMjApMiCpAiMhGiOfKiBjFjFgAiJoGiBeC_xHqqkZx_
	DrawEditLine(pDC, 2);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiDhNiBfLiDeOiImKjChFiCmJjFfMiOkGiBeC_xHqqkZx_
	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMarkNew);
} // FCToolBezier::StateDrawJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateCreateObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateCreateObject (CDC* pDC)
{
	TRACE(_T("StateCreateObject\r\n"));
//----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiJlMjApMiCpAiPmBiLiOiBeCjFjEjFgJiCkKiNoMjAkMiCmFiCkLiCmIiCkJiCmBiClNiOjOiCmJiBeBiJlMjApMiCpAiOgDiClDiCmIiCkCiInHiBeC_xHqqkZx_
//	OnDraw(pDC);
//	// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCmNiNmEjFfMiOkGiBeC_xHqqkZx_
//	FCToolBase::OnDraw(pDC);
//----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiJlMjApMiCpAiPmBiLiOiBeCjFjEjFgJiCkKiNoMjAkMiCmFiCkLiCmIiCkJiCmBiClNiOjOiCmJiBeBiJlMjApMiCpAiOgDiClDiCmIiCkCiInHiBeC_xHqqkZx_
	OnDrawState(pDC, GetCurrentState());
//----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBePiJpBiCfBjDfPiCkKjDkPiClGiImKjChFiCmIiCoHiCmOiNmFiMoDiCmMjDfPiCpAjGjFiPmBiBeC_xHqqkZx_
	if (m_pjvJoint[m_pjvJoint.size() - 1].m_mmptPivot ==
		m_pjvJoint[m_pjvJoint.size() - 2].m_mmptPivot) m_pjvJoint.pop_back();
	// _xZkqqHx_iNmFiPiJiCmMjDfPiBgJiDfPiDhOiBfLiBgKiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	m_pjvJoint.erase(m_pjvJoint.begin());

	if (1 < m_pjvJoint.size())
	//----- _xZkqqHx_jIeBiMiLjDfPiCkKjDpBiCmCiImIiPoDiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		// _xZkqqHx_jAfGiLeLjFjEjFgJiCmMiNoMjAkMiBeFiPiJiKpKiJlLiBeFjDgPjIfOiBeC_xHqqkZx_
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FCObjDynabase* pObj = CreateNewObject();
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		ObjDynabaseVector vNewObj;
		CreateNewObject(vNewObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (pObj != NULL)
		if (!vNewObj.empty())
		{
			// _xZkqqHx_iCnMiClIiMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAiPjMiBeCiDhNiBfLiDeOiCpAiPmBiClHiBeC_xHqqkZx_
			g_pView->ClearSelectObj(pDC);
			// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiBeCiDhNiBfLiDeOiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_RgnDraw_xZkqqHx_iCmFjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			g_pView->AppendSelectObj(pObj);
//			g_pView->AddRgn(pObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			g_pView->AppendSelectObj(vNewObj);
			mdef_const_iterator(ObjDynabaseVector, iObj);
			m1_for (iObj, vNewObj)
				g_pView->AddRgn(*iObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
//----- 01.11.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLiCpAjFgAiJoGiBeC_xHqqkZx_STATE_TERMINATE_JOINT _xZkqqHx_iMoDiCmJiBeBiDeKiBfLiDfMiDiLiCkK_xHqqkZx_
	// _xZkqqHx_jFgAiJoGiClDiCoKiClNiPpDjBnEiCmJiClHiCoJiClNiCnPiBeC_xHqqkZx_
	DrawMark(pDC, FALSE);
//----- 01.11.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBezier::StateCreateObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateTerminateJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateTerminateJoint (CDC* pDC)
{
	TRACE(_T("StateTerminateJoint\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiJlMjApMiNmAjFfHiBeC_xHqqkZx_RgnRedraw_xZkqqHx_jBePiCmJjAnNjCoIiClFiCmIiCkCiCmGiBeBiClBiCmM_xHqqkZx_OnDraw_xZkqqHx_iCmFiMoLjDkOiNoMiBeC_xHqqkZx_
//	m_vmmptPoly.clear();
//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 05.04.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_vmmptPoly1.clear();
	m_pjvJoint.clear();
//----- 02.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiKiDjDiDeOjBlNiKhAjApMiDgDiBfLiDiLiCpA_xHqqkZx_DBL_xZkqqHx_iDeOiDiKiDgCiDeOiCmFiDiNiDgCiDeOiClFiCmEjIeBjBlBiNoMjAkMiClHiCoJiCmGiCkLiBeB_xHqqkZx_Shift_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoH_xHqqkZx_StateIdle_xZkqqHx_iCmNjDkOiNoMiCkKjFmP_xHqqkZx_)-----
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	m_mmlnvAry.clear();
//----- 02.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiKiDjDiDeOjBlNiKhAjApMiDgDiBfLiDiLiCpA_xHqqkZx_DBL_xZkqqHx_iDeOiDiKiDgCiDeOiCmFiDiNiDgCiDeOiClFiCmEjIeBjBlBiNoMjAkMiClHiCoJiCmGiCkLiBeB_xHqqkZx_Shift_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoH_xHqqkZx_StateIdle_xZkqqHx_iCmNjDkOiNoMiCkKjFmP_xHqqkZx_)-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDgDiBfLiDiLiDfKiDgCiDfGiDiHiDjDiPeJjHlJiBeC_xHqqkZx_
	EndOfSession();
	::FFReleaseCapture();	// _xZkqqHx_iDhNiDeFiDfIiCmMiDgIiDiJiDgCiDePiCmMiKeKiOgOiCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolBezier::StateTerminateJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateAbortJointByButton
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIjCiGiOhOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateAbortJointByButton (CDC* pDC)
{
	TRACE(_T("StateAbortJointByButton\r\n"));
//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiJlMjApMiNmAjFfHiBeC_xHqqkZx_
//	m_vmmptPoly.clear();
//----- 05.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 05.04.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_vmmptPoly1.clear();
	m_pjvJoint.clear();
	::FFReleaseCapture();	// _xZkqqHx_iDhNiDeFiDfIiCmMiDgIiDiJiDgCiDePiCmMiKeKiOgOiCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolBezier::StateAbortJointByButton.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateStartFreehand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOkJjHfCiLmIjApMiKeKiOgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateStartFreehand (CDC* pDC)
{
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawMark(pDC, TRUE);
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiBeC_xHqqkZx_
	m_pjvJoint.clear();
	// _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPjEhKjHpBiBeC_xHqqkZx_
	m_vmmptPoly.clear();
	m_vmmptPoly.push_back(m_mmptMscStart);
	m_vmmptPoly.push_back(m_mmptMsc);
	FCAutoDC atDC(pDC);
	atDC.SetPen(	PS_SOLID,
					mm2lg(GetReferenceObject()->GetStdPenWeight()),
					g_pReg->GetOptiRegColor(FDCL_EDIT_LINE));
	// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
	atDC.MoveTo(mm2lg(m_vmmptPoly[0]));
	atDC.LineTo(mm2lg(m_vmmptPoly[1]));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
} // FCToolBezier::StateStartFreehand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateDrawFreehand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOkJjHfCiLmIjApMjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateDrawFreehand (CDC* pDC)
{
	// _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPjEhKjHpBiBeC_xHqqkZx_
	if (!almosteq(m_vmmptPoly.back(), m_mmptMsc))
	{
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
//		// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
//		eDraw.Line(&mm2lg(m_vmmptPoly.back()), &mm2lg(m_mmptMsc));
//		m_vmmptPoly.push_back(m_mmptMsc);
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCAutoDC atDC(pDC);
		atDC.SetPen(	PS_SOLID,
						mm2lg(GetReferenceObject()->GetStdPenWeight()),
						g_pReg->GetOptiRegColor(FDCL_EDIT_LINE));
		// _xZkqqHx_iJlMjApMiCmMjFgAiJoGiBeC_xHqqkZx_
		atDC.MoveTo(mm2lg(m_vmmptPoly.back()));
		atDC.LineTo(mm2lg(m_mmptMsc));
		m_vmmptPoly.push_back(m_mmptMsc);
//----- 05.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCToolBezier::StateDrawFreehand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateCreateFreehand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOkJjHfCiLmIjApMiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateCreateFreehand (CDC* pDC)
{
	if (1 < m_vmmptPoly.size())
	//----- _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPiCkKiCfBiMmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOkJjHfCiLmIjApMiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiBeC_xHqqkZx_
		FCApproximateBezier apxBezier;
		FCBezierControlsVector vControls;

		apxBezier.m_mmSlimDistance1 = 3.0 * lg2mm(1);	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
		apxBezier.m_mmSlimDistance2 = 4.16 * lg2mm(1);	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
		apxBezier.m_mmJointDistance = 11.0 * lg2mm(1);	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiBeC_xHqqkZx_m_dJointAngle2_xZkqqHx_iCmG_xHqqkZx_m_dJointDistance_xZkqqHx_iCmM_xHqqkZx_
														// _xZkqqHx_jHlMjFpLiCpAjClEiCkGiClNiCmGiCkLiBeBjFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGiClFiCmEjElLjCgGiClDiCoKiCoJiBeC_xHqqkZx_

		apxBezier.m_dLengthScore = 0.5;		// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiClLiCmMiLjHjHkDiCmMiNlHiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
											// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_
		apxBezier.m_dMilestoneScore = 0.5;	// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiDhNiDeDiDiLiDfIiDgHiDjDiCmMiLjHjHkDiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
											// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_
		apxBezier.m_dPlayOfAngle = 0.4;		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjDhCjCiGiCmMjDfPiCgPiCpAiOgHiCmBiCmEiDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmJiBeBjDfPiCgPiCmJiCkIiCkPiCoJiDhMiDiKiDiJiDeDiDjDiKhAjDhI_xHqqkZx_R1_xZkqqHx_iCmG_xHqqkZx_
											// _xZkqqHx_iLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJjDfPiCgPiCmJiCkIiCkPiCoJiKhAjDhI_xHqqkZx_R2_xZkqqHx_iCmMiNlHjFkKiCmMiLjGjHgFjEmNiImNiBeC_xHqqkZx_

	#if 0
		// _xZkqqHx_iDgFiDfIiDgHiBeCiDgGiDgPiDgCiDePjHhAiCmMjFfMiOkGiBeC_xHqqkZx_

		// _xZkqqHx_iDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPointVector vPointSlim = m_vmmptPoly;
		apxBezier.SlimLine(vPointSlim);
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw eDraw(pDC, mm2lg(GetReferenceObject()->GetStdPenWeight()));
		for (long lC = 0; lC != vPointSlim.size(); lC++)
		{
			eDraw.SelMark(mm2lg(vPointSlim[lC]));
		}
	#endif//0

		apxBezier.PolylineToBezier(vControls, m_vmmptPoly.begin(), m_vmmptPoly.size());
		// FCBezierControls_xZkqqHx_jEhKjHpBiCpA_xHqqkZx_FCPolyJoint_xZkqqHx_jEhKjHpBiCmJjFmPiKlHiBeC_xHqqkZx_
		FFControlConv(m_pjvJoint, vControls.begin(), vControls.size(), TRUE);
		if (1 < m_pjvJoint.size())
		//----- _xZkqqHx_jIeBiMiLjDfPiCkKjDpBiCmCiImIiPoDiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
			g_pDoc->SessionBegin();
			// _xZkqqHx_jAfGiLeLjFjEjFgJiCmMiNoMjAkMiBeFiPiJiKpKiJlLiBeFjDgPjIfOiBeC_xHqqkZx_
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			FCObjDynabase* pObj = CreateNewObject();
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			ObjDynabaseVector vNewObj;
			CreateNewObject(vNewObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
			g_pDoc->SessionEnd();
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			if (pObj != NULL)
			if (!vNewObj.empty())
			{
				// _xZkqqHx_iCnMiClIiMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAiPjMiBeCiDhNiBfLiDeOiCpAiPmBiClHiBeC_xHqqkZx_
				g_pView->ClearSelectObj(pDC);
				// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiBeCiDhNiBfLiDeOiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_RgnDraw_xZkqqHx_iCmFjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				g_pView->AppendSelectObj(pObj);
//				g_pView->AddRgn(pObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				g_pView->AppendSelectObj(vNewObj);
				mdef_const_iterator(ObjDynabaseVector, iObj);
				m1_for (iObj, vNewObj)
					g_pView->AddRgn(*iObj);
//----- 06.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
				// _xZkqqHx_iOkJjHfCiLmIjApMiCmMiJlMjApMiCpAiPmBiLiOiClHiCoJiClNiCnPiBeBiDiKiBfLiDfHiDiHiDjDiCpAjCmHiJmBiBeC_xHqqkZx_
				DBLRect mmrtFree;
				FFCalcFrame(mmrtFree, m_vmmptPoly.size(), m_vmmptPoly.begin());
				mmrtFree.Extend(GetReferenceObject()->GetStdPenWeight());
				g_pView->AppendToLastRgn(mmrtFree);
			}
		}
	}
} // FCToolBezier::StateCreateFreehand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBezier::StateTerminateFreehand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOkJjHfCiLmIjApMiPeJjHlJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBezier::StateTerminateFreehand (CDC* pDC)
{
	// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLiCpAjFgAiJoGiBeCiDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiCmMjBePiCmJiBeBiDeKiBfLiDfMiDiLiCkK_xHqqkZx_
	// _xZkqqHx_jFgAiJoGiClDiCoKiClNiPpDjBnEiCmJjGnPiClHiClNiCnPiBeC_xHqqkZx_
	DrawMark(pDC, FALSE);
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	// _xZkqqHx_iOkJjHfCiLmIjApMiCmMjClIjDfPjEhKjHpBiBeC_xHqqkZx_
	m_vmmptPoly.clear();
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiBeC_xHqqkZx_
	m_pjvJoint.clear();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDgDiBfLiDiLiDfKiDgCiDfGiDiHiDjDiPeJjHlJiBeC_xHqqkZx_
	EndOfSession();
	::FFReleaseCapture();	// _xZkqqHx_iDhNiDeFiDfIiCmMiDgIiDiJiDgCiDePiCmMiKeKiOgOiCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolBezier::StateTerminateFreehand.

