#ifndef __ToolBoxArrowTmpl_h
#define __ToolBoxArrowTmpl_h

#include "stdafx.h"
// 06.11.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include <float.h>				// For DBL_MAX.
#include "DynamicDraw.h"		// For ID_TLCMD_XXXX.
#include "CommonDrawFrame.h"	// For FFCommonDrawFrame.
#include "ObjChipMaster.h"		// For FCObjChipMaster.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS SUPER

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	class FCToolBoxArrowTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjFjEjFgJiBjFiDhLiDgCiDeOiDfIjFjEjFgJiNoMjAkMiDgDiBfLiDiLiCmMiInHiCmM_xHqqkZx_template_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER> class FCToolBoxArrowTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	FCToolBoxArrowTmpl ();
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual FCObjDynabase*	CreateInsideObject ();

protected:
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	//----- ToolBaseCreate_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual const FCObjDynabase*	GetReferenceObject ();
	virtual BOOL	IsValidReference (const FCObjDynabase* pObj) const;

	//----- SUPER_xZkqqHx_iDeOiDiJiDfIiCmMiDfEiDhFiKnGjAjE_xHqqkZx_ -----
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual HCURSOR	GetDefaultIdleCursor () const;
	virtual void	CreateNewObject (ObjDynabaseVector& vNewObj);
// 06.11.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	InitNewObject (FCObjDynabase* pObj) const;
	virtual int		TransFDA (int iState, int iEvent);

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeM_xHqqkZx_ -----
	virtual void	GetReferencePolyBoxObject (const FCObjDynabase*& pRefObjPoly, const FCObjDynabase*& pRefObjBox);
	virtual BOOL	IsValidReferenceBox (const FCObjDynabase* pObj) const;

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjN_xHqqkZx_ -----

	virtual void	StateSearchEndMolip (CDC* pDC);

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
protected:
// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMjCoIiLgAiBeC_xHqqkZx_
enum
{
	STATE_BEGIN = BASE_CLASS::STATE_END,	// _xZkqqHx_iPpDjBnEiKeKiOgOiBeC_xHqqkZx_
	STATE_END,				// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

}; // class FCToolBoxArrowTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::FCToolBoxArrowTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bInvert	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCmMiNoMjHhAiCpAiLhEjDfNiClHiCoJiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCToolBoxArrowTmpl<SUPER>::FCToolBoxArrowTmpl ()
						:SUPER(	TRUE,	// bInvert.
								NULL,	// pFront.
								NULL)	// pBack.
{
} // FCToolBoxArrowTmpl<SUPER>::FCToolBoxArrowTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::CreateInsideObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEjFjEjFgJiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDoAjFjEjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCObjDynabase* FCToolBoxArrowTmpl<SUPER>::CreateInsideObject ()
{
	// _xZkqqHx_jDoAjFjEjFjEjFgJiCkKiNoMjAkMiClDiCoKiCmIiCkCiCoGiCkEiBeB_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return NULL;
} // FCToolBoxArrowTmpl<SUPER>::CreateInsideObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::GetReferenceObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMjHhAiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const FCObjDynabase* FCToolBoxArrowTmpl<SUPER>::GetReferenceObject ()
{
//----- 06.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const FCObjDynabase* pObj = BASE_CLASS::GetReferenceObject();
//	if (pObj != NULL)
//	{
//		return pObj;
//	} else
//	{
//		FCToolBase* pTool = g_pToolManager->CommandID2Tool(ID_TOOL_POLY_ARROW);
//		return pTool->GetInsideObject();
//	}
//----- 06.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjDynabase* pRefObjPoly = NULL;
	const FCObjDynabase* pRefObjBox = NULL;
	GetReferencePolyBoxObject(pRefObjPoly, pRefObjBox);
	return pRefObjPoly;
//----- 06.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBoxArrowTmpl<SUPER>::GetReferenceObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::IsValidReference
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiBeBiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjAlDiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMpDjFoCjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKnEiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolBoxArrowTmpl<SUPER>::IsValidReference (const FCObjDynabase* pObj) const
{
	if (pObj == NULL) return FALSE;
	return pObj->IsKindOf(FDOJ_POLY);
} // FCToolBoxArrowTmpl<SUPER>::IsValidReference.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
HCURSOR FCToolBoxArrowTmpl<SUPER>::GetDefaultIdleCursor () const
{
	return NULL;
} // FCToolBoxArrowTmpl<SUPER>::GetDefaultIdleCursor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::CreateNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmMjFjEjFgJiCmMiNoMjAkMiBeFiPiJiKpKiJlLiBeFjDgPjIfOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolBoxArrowTmpl<SUPER>::CreateNewObject (ObjDynabaseVector& vNewObj)
{
//----- 06.10.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiBeBiDeNiDiDiDgCiDhGiCpAiOoGjDlOiClFiCmEiClLiCoKiCpAiOgHiCkEiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
//	DBLPoint mmptQ;
//	double dT;
//	if (CalcMolipCrossedPoint(mmptQ, dT, bc, lMolipId))
//	//----- _xZkqqHx_iMpAjDfPiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//	{
//----- 06.10.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjFjEiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiBeC_xHqqkZx_
	const FCObjDynabase* pRefObjPoly = NULL;
	// _xZkqqHx_iDhLiDgCiDeOiDfIjFjEiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiBeC_xHqqkZx_
	const FCObjDynabase* pRefObjBox = NULL;
	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	GetReferencePolyBoxObject(pRefObjPoly, pRefObjBox);
	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pRefObjPoly == NULL) return;
	if (pRefObjBox == NULL) return;

//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCObjDynabase* pBox = pRefObjBox->Duplicate();
//	long lMolipId;
//	for (lMolipId = pBox->GetMolipCount() - 1;; lMolipId--)
//	{
//		if (lMolipId == -1 || pBox->IsLineMolip(lMolipId))
//			break;
//	}
//	const DBLPoint mmptBoxMove = m_pjvJoint.back().GetPivotPoint() - pBox->GetMolipPos(lMolipId);
//	pBox->Move(mmptBoxMove.x, mmptBoxMove.y);
//
//	if (pBox->IsLineMolip(lMolipId))
//	{
//		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
//		m_iEndHitOn = FDPA_HIT_POL_MOLIP;	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//		m_dwEndLinkKind = FDLM_LINK_ON_ANGLE;
//	} else
//	{
//		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
//		m_iEndHitOn = FDPA_HIT_POINT_MOLIP;	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//		m_dwEndLinkKind = FDLM_LINK_ON_COORD;
//	}
//	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
//	m_pEndHitObj = pBox;
//	m_lEndHitMolip = lMolipId;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
//	m_mmptEndHitPos = m_pjvJoint.back().GetPivotPoint();	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhLiDgCiDeOiDfIjFjEjFgJiCmNiBeBiKoOjGhLjDeJiCmJiCmNjCiGjAfDiCkKiDhNiDeFiDfIiImKjChFiCmJjHiIiCoJiCoGiCkEiCmJjClCjAkOiClDiCoKiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jCeBiClFiBeBiDfIiDgJiDgCiDhGiCkKjHeMiMpIiCmMiPoKiNiHiCmNiBeBiNmFiCoAiLnPiCkCiDfIiDgJiDgCiDhGiImKjChFiCmJjFoCjAlDiClDiCoKiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjAnKjBlBiClDiCoKiCoJiDhLiDgCiDeOiDfIiPoDiCmMiDiCiDiKiDhGiCmNiBeBiDhMiDiKiDiJiDeDiDjDiCmMjBoGiIoKiKnGjAnPiCmJ_xHqqkZx_
//	// _xZkqqHx_iNmFiCoAiLnPiCkCiDiCiDiKiDhGiCkKjBeJjBpAiClDiCoKiCoJiBeCiClBiCmMiPoKiNiHiBeBjApMiDiCiDiKiDhGiCkKjHeEjAoGiClDiCoKiCoJiBeC_xHqqkZx_
//
//	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkJiCoHiBeBiDhLiDgCiDeOiDfIjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCObjDynabase* pBox = pRefObjBox->Duplicate();
//	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiBeBjCiGjAfDiImKjChFiCkKiDhNiDeFiDfIiImKjChFiCmJjHiIiCoJiCoGiCkEiInKjDkOiBeC_xHqqkZx_
//	DBLRect mmrtFrame = pBox->GetResizeFrame();
//	mmrtFrame += (m_pjvJoint.back().GetPivotPoint() - mmrtFrame.CenterPoint());
//
//	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmMiDfIiDgJiDgCiDhGiClHiCoJiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//	const DBLPoint mmptSnapOrig = FFGetFramePoint(mmrtFrame, g_pReg->GetSnapPosition());
//	DBLPoint mmptSnapNew = mmptSnapOrig;
//	// _xZkqqHx_iDfIiDgJiDgCiDhGiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
//	FFSnapMP(mmptSnapNew);
//	// _xZkqqHx_iDfIiDgJiDgCiDhGiCmJiCoGiCmBiCmEiInKjDkOiClHiCoJiLjHjHkDiClOiCkPiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiInKjDkOiBeC_xHqqkZx_
//	mmrtFrame += (mmptSnapNew - mmptSnapOrig);
//	// _xZkqqHx_iInKjDkOiLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
//	const DBLPoint mmptMove = mmrtFrame.GetLeftTop() - pBox->GetResizeFrame().GetLeftTop();
//	// _xZkqqHx_iDhLiDgCiDeOiDfIjFjEjFgJiCpAiInKjDkOiBeC_xHqqkZx_
//	pBox->Move(mmptMove.x, mmptMove.y);
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhLiDgCiDeOiDfIjFjEjFgJiCmNiBeBjCiGjAfDiCkKiDhNiDeFiDfIiImKjChFiCmJjHiIiCoJiCoGiCkEiCmJjClCjAkOiClDiCoKiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjAnKjBlBiClDiCoKiCoJiDhLiDgCiDeOiDfIiPoDiCmMiDiCiDiKiDhGiCmNiBeBiDhMiDiKiDiJiDeDiDjDiCmMjBoGiIoKiKnGjAnPiCmJ_xHqqkZx_
	// _xZkqqHx_iNmFiCoAiLnPiCkCiDiCiDiKiDhGiCkKjBeJjBpAiClDiCoKiCoJiBeCiClBiCmMiPoKiNiHiBeBjApMiDiCiDiKiDhGiCkKjHeEjAoGiClDiCoKiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkJiCoHiBeBiDhLiDgCiDeOiDfIjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
	FCObjDynabase* pBox = pRefObjBox->Duplicate();
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiBeBjCiGjAfDiImKjChFiCkKiDhNiDeFiDfIiImKjChFiCmJjHiIiCoJiCoGiCkEiInKjDkOiBeC_xHqqkZx_
	DBLRect mmrtFrame = pBox->GetResizeFrame();
	const DBLPoint mmptMove = m_pjvJoint.back().GetPivotPoint() - pBox->GetResizeFrame().CenterPoint();
	// _xZkqqHx_iDhLiDgCiDeOiDfIjFjEjFgJiCpAiInKjDkOiBeC_xHqqkZx_
	pBox->Move(mmptMove.x, mmptMove.y);
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiBeBiDhLiDgCiDeOiDfIiCmJjAnKjBlBiClHiCoJiImKjChFiCkJiCoHjAjEiCkGiCmEjBoGiIoKiKnGjAnPjFjEjFkKiCmMiNmAjFfHiBeC_xHqqkZx_
	const DBLPoint mmptPolyPivot = m_pjvJoint.at(m_pjvJoint.size() - 2).GetPivotPoint();

	// _xZkqqHx_jBoGiIoKiKnGjAnPiCkJiCoHiDiCiDiKiDhGiCnMiCmFiCmMiLjHjHkDiCmMiNmFjCfKiBeC_xHqqkZx_
	mmetol mmDistanceMin = DBL_MAX;
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmGiCmIiCoJiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long lTargetMolip = -2;
	long lMolipId;
	for (lMolipId = pBox->GetMolipCount() - 1;
		 lMolipId != -2; lMolipId--)
	{
		if (pBox->IsLineMolip(lMolipId))
		//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBoGiIoKiKnGjAnPiCkJiCoHiDiCiDiKiDhGiCnMiCmFiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
			const mmetol mmDistance =
				(mmptPolyPivot - pBox->GetMolipPos(lMolipId)).Len();
			if (mmDistance < mmDistanceMin)
			//----- _xZkqqHx_iNmFiCoAjBoGiIoKiKnGjAnPiCmJiLnPiCkCiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				mmDistanceMin = mmDistance;
				lTargetMolip = lMolipId;
			}
		}
	}
	if (lTargetMolip == -2)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		for (lMolipId = pBox->GetMolipCount() - 1;
			 lMolipId != -2; lMolipId--)
		{
			if (!pBox->IsLineMolip(lMolipId))
			//----- _xZkqqHx_jDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jBoGiIoKiKnGjAnPiCkJiCoHiDiCiDiKiDhGiCnMiCmFiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
				const mmetol mmDistance =
					(mmptPolyPivot - pBox->GetMolipPos(lMolipId)).Len();
				if (mmDistance < mmDistanceMin)
				//----- _xZkqqHx_iNmFiCoAjBoGiIoKiKnGjAnPiCmJiLnPiCkCiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
				{
					mmDistanceMin = mmDistance;
					lTargetMolip = lMolipId;
				}
			}
		}
	}
	if (pBox->IsLineMolip(lTargetMolip))
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKjApMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
		m_iEndHitOn = FDPA_HIT_POL_MOLIP;	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwEndLinkKind = FDLM_LINK_ON_ANGLE;
	} else
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKjDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
		m_iEndHitOn = FDPA_HIT_POINT_MOLIP;	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwEndLinkKind = FDLM_LINK_ON_COORD;
	}
	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_pEndHitObj = pBox;
	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_lEndHitMolip = lTargetMolip;
	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	m_mmptEndHitPos = m_pjvJoint.back().GetPivotPoint();
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	pBox->RegisterObjID();
	// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
	g_pDoc->MulticmdCreate1Obj(pBox, g_pDoc->GetCurrentSheetId(), LAST_LAYER_ORDER);

	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCjGoOiIpDiDhMiDiKiDiJiDeDiDjDiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	BASE_CLASS::CreateNewObject(vNewObj);

	// _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
	vNewObj.push_back(pBox);
	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_BASE_CLASS::CreateNewObject_xZkqqHx_iCmJ_xHqqkZx_
	// _xZkqqHx_iJgFiLlPiCpAjHfOiCkGiCoJiCmMiCmFiBeBiClLiCmMiMoDiCmJiOmAiNhDiBeC_xHqqkZx_
	SetLastCreateObj(pBox);
} // FCToolBoxArrowTmpl<SUPER>::CreateNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::InitNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolBoxArrowTmpl<SUPER>::InitNewObject (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_jBkOjAkLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	BASE_CLASS::InitNewObject(pObj);
	if (m_iEndHitOn == FDPA_HIT_POINT_MOLIP)
	//----- _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiCkKjDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhLiDgCiDeOiDfIiCkKjApMiDiCiDiKiDhGiCpAiOjNiClNiCmIiCkCiPoKiNiHiBgJiDgAiDgCiDhGiCmIiCmHiBgKiBeB_xHqqkZx_
		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAjDfPiDiCiDiKiDhGiCmMiImKjChFiCmJiInKjDkOiClFiCmEiCoCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_

		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiPeJjDfPiCpAiDiCiDiKiDhGiImKjChFiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
		FCObjPoly* pPoly = (FCObjPoly*)pObj;
		pPoly->GetJoint(pPoly->GetJointSize() - 1).m_mmptPivot = m_pEndHitObj->GetMolipPos(m_lEndHitMolip);
	}
} // FCToolBoxArrowTmpl<SUPER>::InitNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPolyArrow.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolBoxArrowTmpl<SUPER>::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_DRAW_JOINT:	// _xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		// _xZkqqHx_iPeJjHlJjDfPiCmFiDiKiDjDiDeOiClDiClJiCmIiCkCiClNiCnPiBeB_xHqqkZx_FCToolArrowTmpl_xZkqqHx_iCmMiPiIjHjNiCpAiOeFiClHiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			iNextState = STATE_SET_JOINT;		// _xZkqqHx_jIeBiMiLjDfPjAnNjCoIiBeC_xHqqkZx_
			break;
		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			iNextState = STATE_UNSET_JOINT;		// _xZkqqHx_jIeBiMiLjDfPiJpAiPjMiBeC_xHqqkZx_
			break;
		}
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolBoxArrowTmpl<SUPER>::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::GetReferencePolyBoxObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDgCiDeOiDfIjFjEjFgJiNoMjAkMjHhAiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pRefObjPoly:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjFjEiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			pRefObjBox	:_xZkqqHx_iDhLiDgCiDeOiDfIjFjEiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolBoxArrowTmpl<SUPER>::GetReferencePolyBoxObject (	const FCObjDynabase*& pRefObjPoly,
															const FCObjDynabase*& pRefObjBox)
{
	pRefObjPoly = NULL;
	pRefObjBox = NULL;
	shortVector::const_iterator iT;
	for (iT = m_vReferenceOrder.begin();
		 (pRefObjPoly == NULL || pRefObjBox == NULL) && iT != m_vReferenceOrder.end(); iT++)
	{
		switch (*iT)
		{
		case FDBC_REFO_SELECT_OBJ:	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjClCiCnHiCoJiCnHiCkLjFjEjFgJiCmMjEhKjHpBiBeC_xHqqkZx_
			ObjDynabaseVector vObj = g_pView->SelectObjVector();
			if (vObj.size() == 1)
			//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKiIoKiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
			{
				const DWORD dwObjId = vObj.front()->GetObjID();
				// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCkJiCoHiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiClHiCoJjBfDiCmEiCmMiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
				DWORDSet setLink;
				g_pDoc->LinkManager()->GetAffectedByTo(setLink, FCMolipRec(dwObjId, -1));
				g_pDoc->LinkManager()->GetAffectedByFrom(setLink, FCMolipRec(dwObjId, -1));
				DWORDSet::iterator isIdx;
				ObjDynabaseSet stObj;
				for (isIdx = setLink.begin(); isIdx != setLink.end(); isIdx++)
				{
					const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*isIdx);
					stObj.insert(g_pDoc->ObjID2Object(pRec->m_mlpFrom.dwObjID));	// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
					stObj.insert(g_pDoc->ObjID2Object(pRec->m_mlpTo.dwObjID));		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiBeC_xHqqkZx_
				}
				stObj.erase(vObj.front());
				FFPushBack(vObj, stObj);
			}
			ObjDynabaseVector::const_iterator iObj;
			for (iObj = vObj.begin();
				 (pRefObjPoly == NULL || pRefObjBox == NULL) && iObj != vObj.end();
				 iObj++)
			{
				//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
				if (pRefObjPoly == NULL && IsValidReference(*iObj))
					pRefObjPoly = *iObj;
				else
				//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIiDhLiDgCiDeOiDfIjFjEjFgJiCmGiClFiCmEjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
				if (pRefObjBox == NULL && IsValidReferenceBox(*iObj))
					pRefObjBox = *iObj;
			}
			break;
		  }
		case FDBC_REFO_CHIP_OBJ:	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
			if (FFCommonDrawFrame() != NULL && FFCommonDrawFrame()->GetCurChipId() != FD_CHIP_UNSPECIFY)
			{
				FCObjChipMaster* pChip = (FCObjChipMaster*)g_pEnv->GetChipRec(FFCommonDrawFrame()->GetCurChipId())->m_objpChipMaster;
				if (pChip->GetChipKind() == FDCM_OBJECT_CHIP)
				//----- _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhG_xHqqkZx_ -----
				{
					// _xZkqqHx_iDgAiDgCiDhGjCiGiCmMiDiBiDjDiDgPiBfLiCpAiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJiOgHiCkGiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
					for (long lIdx = 0;
						 (pRefObjPoly == NULL || pRefObjBox == NULL) && lIdx != pChip->GetMemberSize();
						 lIdx++)
					{
						if (pRefObjPoly == NULL && IsValidReference(pChip->GetMember(lIdx)))
							pRefObjPoly = pChip->GetMember(lIdx);
						else
						if (pRefObjBox == NULL && IsValidReferenceBox(pChip->GetMember(lIdx)))
							pRefObjBox = pChip->GetMember(lIdx);
					}
				} else
				//----- _xZkqqHx_jFkBiNiHjFjEjFgJiDgAiDgCiDhG_xHqqkZx_ -----
				{
					if (pRefObjBox == NULL && IsValidReferenceBox(pChip))
						pRefObjBox = pChip;
				}
			}
			break;
		case FDBC_REFO_LAST_OBJ:	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
		  {
			const FCObjDynabase* pObjTmp = NULL;
			while (pRefObjPoly == NULL || pRefObjBox == NULL)
			{
				// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
				pObjTmp = GetLastCreateObj(pObjTmp);
				// _xZkqqHx_jFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
				if (pObjTmp == NULL) break;
				if (pRefObjPoly == NULL && IsValidReference(pObjTmp))
					pRefObjPoly = pObjTmp;
				else
				if (pRefObjBox == NULL && IsValidReferenceBox(pObjTmp))
					pRefObjBox = pObjTmp;
			}
			break;
		  }
		case FDBC_REFO_INSIDE_OBJ:	// _xZkqqHx_jDoAjFjEjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
			if (pRefObjPoly == NULL)
			{
				FCToolBase* pTool = g_pToolManager->CommandID2Tool(ID_TOOL_POLY_ARROW);
				pRefObjPoly = pTool->GetInsideObject();
			}
			if (pRefObjBox == NULL)
			{
				FCToolBase* pTool = g_pToolManager->CommandID2Tool(ID_TOOL_TEXT_PUT);
				pRefObjBox = pTool->GetInsideObject();
			}
			break;
		}
	}
} // FCToolBoxArrowTmpl<SUPER>::GetReferencePolyBoxObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::IsValidReferenceBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiBeBiDiKiDhEiDeAiDiMiDjDiDfIiDhLiDgCiDeOiDfIjFjEjFgJiCmGiClFiCmEjAlDiClFiCkCiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMpDjFoCjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKnEiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolBoxArrowTmpl<SUPER>::IsValidReferenceBox (const FCObjDynabase* pObj) const
{
	if (pObj == NULL) return FALSE;
	if (pObj->IsKindOf(FDOJ_POLY))
	{
		if (((const FCObjPoly*)pObj)->GetIsOpenPolyJoint())
			return FALSE;
	} else
	if (pObj->IsKindOf(FDOJ_FIGURE))
	{
		if (!((const FCObjPoly*)pObj)->IsClosePolygon())
			return FALSE;
	}
	const DBLRect mmrtFrame = pObj->GetResizeFrame();
	return (!almost0(mmrtFrame.Width()) &&
			!almost0(mmrtFrame.Height()));
} // FCToolBoxArrowTmpl<SUPER>::IsValidReferenceBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBoxArrowTmpl<SUPER>::StateSearchEndMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolBoxArrowTmpl<SUPER>::StateSearchEndMolip (CDC* pDC)
{
	TRACE(_T("StateSearchEndMolip\r\n"));
	// _xZkqqHx_iPeJjHlJjDfPiCmFiDiKiDjDiDeOiClDiClJiCmIiCkCiClNiCnPiBeB_xHqqkZx_FCToolArrowTmpl_xZkqqHx_iCmMiPiIjHjNiCpAiOeFiClHiBeC_xHqqkZx_
} // FCToolBoxArrowTmpl<SUPER>::StateSearchEndMolip.

#endif//__ToolBoxArrowTmpl_h
