#ifndef __ToolPolyEdit_h
#define __ToolPolyEdit_h

#include "ToolBasePolyEdit.h"	// Super class.
#include "PolyJoint.h"			// For FCPolyJoint, FCPolyJointVector.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCToolBasePolyEdit


class FCObjDynabase;
class FCObjPoly;

enum FTMolipKind;	// LinkManager.h_xZkqqHx_iCmFjCoIiLgAiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	JointSelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ObjPoly_xZkqqHx_iCmMjIeBiMiLjDfP_xHqqkZx_ FCPolyJoint _xZkqqHx_iCmMiPfHiNiHiCpAjFfMiClHiClNiCnPiCmMiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class JointSelInfo : public FCPolyJointVector
{
protected:
typedef FCPolyJointVector BASE_CLASS;

public:
	JointSelInfo ();
	JointSelInfo (long lSize, const FCPolyJoint *pJoint, BOOL bIsOpen,
					FCObjPoly* pObj);
	~JointSelInfo ();

	BOOL	UpdateJoint ();
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpA_xHqqkZx_mmptMove_xZkqqHx_iClOiCkPiInKjDkOiBeC_xHqqkZx_
//	void	MovePivot (const DBLPoint& mmptMove);
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 05.09.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	BOOL	IsSelectedJoint (long idx) const;
	BOOL	SelectJoint (long idx);
	BOOL	UnselectJoint (long idx);
	void	ClearSelectJoint ();
// 05.09.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	DrawPivotMark (CDC* pDC) const;
	void	DrawPullMark (CDC* pDC) const;
	void	GetAffected (JointSeqVector& vJntSeq) const;

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long	FindHitPrevPull (const DBLPoint& mmptMsc) const;
//	long	FindHitNextPull (const DBLPoint& mmptMsc) const;
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	const longVector& GetSelJointVector () const;
	FCObjPoly* GetObject () const;

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	FCPolyJoint*	GetPtr ();
	const FCPolyJoint*	GetPtr () const;
	long	GetSize () const;
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
protected:
	FCObjPoly*	m_pObj;
	longVector	m_vSelJointIdx;
}; // class JointSelInfo.

// FFAddToLZSorted_xZkqqHx_jHhAiKnGjAjEiBeC_xHqqkZx_
inline FCObjDynabase* GetObject (JointSelInfo& info) { return info.GetObject(); }

typedef vector<JointSelInfo> JointSelInfoVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCToolPolyEdit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCObjPoly_xZkqqHx_iCpAjFnCiPfHiClHiCoJiClNiCnPiCmMiDgDiBfLiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.22 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCToolPolyEdit : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDraw (CDC* pDC);
	virtual void	OnObjectProperties ();

	virtual void	OnSelectObjModified ();

	virtual void	Select (CDC* pDC);

// 05.09.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	DrawSelectMark (CDC* pDC, FCObjDynabase* pObj);
	virtual void	OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj);
	virtual void	OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj);

	virtual BOOL	CanDelete () const;
	virtual void	OnDelete (CDC* pDC);

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	CanObjectAlignObj (FTAlignType nType) const;
//	virtual void	OnObjectAlignObj (FTAlignType nType);
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanObjectInsertJoint () const;
	virtual void	OnObjectInsertJoint ();

	virtual BOOL	CanObjectConnect () const;
	virtual void	OnObjectConnect ();
	virtual BOOL	CanObjectDisconnect () const;
	virtual void	OnObjectDisconnect ();

//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	CanObjectMoveSnapLeft () const;
//	virtual void	OnObjectMoveSnapLeft ();
//	virtual BOOL	CanObjectMoveSnapUp () const;
//	virtual void	OnObjectMoveSnapUp ();
//	virtual BOOL	CanObjectMoveSnapRight () const;
//	virtual void	OnObjectMoveSnapRight ();
//	virtual BOOL	CanObjectMoveSnapDown () const;
//	virtual void	OnObjectMoveSnapDown ();
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual BOOL	CanHandle (const FCObjDynabase* pObj) const;
	virtual BOOL	IsObjectCommandEnable (DWORD dwCmdID) const;

protected:
//----- 05.09.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjFeLjAhL_xHqqkZx_ -----
	virtual long	GetLineCount () const;
	virtual BOOL	IsOpenLine (long lLineIndex) const;
	virtual long	GetJointCount (long lLineIndex) const;
	virtual void	GetBezierControls (	FCBezierControls& bc,
										long lLineIndex,
										long lJointIndex,
										BOOL bIsForward) const;
	virtual FCObjFigure*	GetLineObject (long lLineIndex) const;
	virtual void	SetJointPoint (longPair index, DBLPoint mmpt);
	virtual void	DrawJointSelectMark (CDC* pDC, longPair index) const;
	virtual long	JointIDtoMolipID (long lJointId) const;
//----- 05.09.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	DrawSelectedBezier (CDC* pDC) const;

	virtual JointSelInfo&	GetHitPolyline ();
	virtual FCPolyJoint&	GetHitJoint (long lOffset = 0);

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeM_xHqqkZx_ -----
// 05.09.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	MoveJointSnap (long lHorzDirection, long lVertDirection);

	virtual BOOL	CheckHitPull ();

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnDrawState (CDC* pDC, int iState);
	virtual int			TransFDA (int iState, int iEvent);
	virtual void		StateFDA (int iState, CDC* pDC);

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjNiBgJiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBgK_xHqqkZx_ -----
	virtual void	StateIdle (CDC* pDC);
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	StateClrselSelXXX (XXX_Joint, CDC* pDC);
	virtual void	StateStartMoveXXX (XXX_Joint, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjN_xHqqkZx_ -----
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	StateStartMoveJoint (CDC* pDC);
//	virtual void	StateMovingJoint (CDC* pDC);
//	virtual void	StateStopMoveJoint (CDC* pDC);
//	virtual void	StateContextMenuJoint (CDC* pDC);
//	virtual void	StateJointLinkCommand (CDC* pDC);
//	virtual void	StateReLink (CDC* pDC);
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual void	StateEnterMovePull (CDC* pDC);
	virtual void	StateStartMovePull (CDC* pDC);
	virtual void	StateMovingPull (CDC* pDC);
	virtual void	StateStopMovePull (CDC* pDC);
	virtual void	StateExitMovePull (CDC* pDC);
// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	StateDoMoveJointSnap (CDC* pDC);

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
	virtual int		GetSubMenuIndex () const;
	virtual BOOL	CanLinkToSelection () const;	// Idle_xZkqqHx_iCmF_xHqqkZx_CTRL+MSMOVE_xZkqqHx_iCmFiDiKiDjDiDeOiCkKjCkDiCoKiCoJiCkJiBeI_xHqqkZx_
	virtual void	GetSelectionForLink (FTMolipSet& stMolip) const;	// _xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiClNiCnPiCmMiDiCiDiKiDhGiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_

	//----- FCToolBaseEdit_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjAhL_xHqqkZx_ -----
	virtual void	ResetEditHandleList ();

	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjAhL_xHqqkZx_ -----
	virtual long	GetSelectedXXX (XXX_Joint, vector<longPair>* vXxx = NULL, set<longPair>* stXxx = NULL) const;
	virtual long	GetSelectableXXX (XXX_Joint, vector<longPair>* vXxx = NULL) const;
	virtual void	SelectXXX (XXX_Joint, longPair xxx, CDC* pDC);
	virtual void	UnselectXXX (XXX_Joint, longPair xxx, CDC* pDC);
	virtual DBLRect	GetFrameRectXXX (XXX_Joint, longPair xxx) const;

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CheckHitNextXXX (XXX_Joint, longPair* hitXxx, longPair lastXxx);
	virtual BOOL	CheckHitPolyline ();
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.09.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFiBeB_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiPoKiNiHiCmNjFeLjAhL_xHqqkZx_ -----
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	DrawFirstImageXXX (XXX_Joint, CDC* pDC);
//	virtual void	RedrawMovingImageXXX (XXX_Joint, const DBLPoint& mmptMove, CDC* pDC);
//// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	virtual void	OnDrawMovingImageXXX (XXX_Joint, CDC* pDC);
//	virtual void	DrawLastImageXXX (XXX_Joint, CDC* pDC);
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual void	MoveXXX (XXX_Joint, const vector<longPair>& vXxx, const DBLPointVector& vmmptMove);
//----- 05.09.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual longPair	InsertJoint (	long lTargetPoly,
										long lTargetBezier,
										double dTargetT,
										const DBLPoint& mmptTargetQ);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual DBLPoint	CalcLinkOffsetWhenMoveJoint (	const FCObjDynabase* pObjH,
														long lMolipIdH,
														const FCObjDynabase* pObjK,
														long lMolipIdK,
														const DBLPoint& mmptH,
														WORD wLinkKind) const;
	virtual void	AppendJointMovedRgn (long lLineIndex, const longSet& stJointIndex);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

private:
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	DrawSelectedBezier (CDC* pDC) const;
	virtual void	DrawPolyline (	CDC* pDC, const CPoint lgptaPoly[],
									long lPolySize, long lgPenW,
									const CRect& lgrtClient) const;

protected:
// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMjCoIiLgAiBeC_xHqqkZx_
enum
{
	STATE_BEGIN = BASE_CLASS::STATE_END,	// _xZkqqHx_iPpDjBnEiKeKiOgOiBeC_xHqqkZx_
	STATE_ENTER_MOVE_PULL,		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
	STATE_START_MOVE_PULL,		// _xZkqqHx_iIpIjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
	STATE_MOVING_PULL,			// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
	STATE_STOP_MOVE_PULL,		// _xZkqqHx_iIpIjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
	STATE_EXIT_MOVE_PULL,		// _xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_

	STATE_END,				// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

// _xZkqqHx_iIpIjDfPiCmMiOoNjHnOiCpAjCoIiLgAiBeC_xHqqkZx_
enum FTJointPntKind
{
	FDPK_NONE,
	FDPK_PIVOT,
	FDPK_PREV_PULL,
	FDPK_NEXT_PULL,
};

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_jIeBiMiLjDfPiKnEiDhBiDgCiDgH_xHqqkZx_ -----
	longPair		m_hitJoint2;	// _xZkqqHx_jIeBiMiLjDfPiKnEiCmJiDhBiDgCiDgHiCmMiPoKiNiHiCmNiCfBjEnEjGnKiBeC_xHqqkZx_
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jIeBiMiLjDfPiMjPiNpFiMiLiJmK_xHqqkZx_ -----
	FTJointPntKind	m_iHitJointKnd;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjDfPiOoNjHnOiBeC_xHqqkZx_

	//----- _xZkqqHx_jIeBiMiLjDfPiInKjDkOiOjOiCmMiDiPiBfLiDeO_xHqqkZx_ -----
// 05.09.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLPoint		m_mmptFirst;		// _xZkqqHx_iInKjDkOjDfPiCmMiNmFiPiJiCmMjCgMiBeBjBkGiClPiInKjDkOjBePiCmMiNmAjFfHiBeC_xHqqkZx_
// 05.09.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DWORD			m_dwJointLinkKind;	// _xZkqqHx_jIeBiMiLjDfPiCmJiDiKiDjDiDeOiCpAjCkDiCoJiPoKiNiHiCmMiDiKiDjDiDeOiOoNiBeC_xHqqkZx_

	//----- _xZkqqHx_jIeBiMiLjDfPiBeFiIpIjDfPiInKjDkOiOjOiCmMiDiPiBfLiDeO_xHqqkZx_ -----
// 05.09.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLRect			m_mmrtPreRegion;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiCmMiNmEjFgAiJoGjHmMiIoGiBeC_xHqqkZx_
	DBLPoint		m_mmptMovPull;		// _xZkqqHx_iIpIjDfPiCmMiInKjDkOjDfPiBeC_xHqqkZx_

	// g_pView_xZkqqHx_iCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCmNjBfDiCmE_xHqqkZx_m_vPolyLine_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
	JointSelInfoVector	m_vPolyLine;

	//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiBeC_xHqqkZx_Alignment_xZkqqHx_jHhA_xHqqkZx_ -----
	long			m_lLastPolygonIdx;	// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long			m_lLastJointIdx;	// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_

	//----- _xZkqqHx_iIpIjDfPiInKjDkOiOjOiCmMiBeBiPeDjAlDjApMiCmMiLeMjIfOjHhAjEhKjHpB_xHqqkZx_ -----
	CPointVector	m_vlgptPoint;
}; // class FCToolPolyEdit.


#endif//__ToolPolyEdit_h
