#include "stdafx.h"
#include "DynamicDraw.h"
// 03.07.18 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MainFrame.h"			// For g_pFrame.
#include "FoundDoc.h"			// For g_pDoc.
#include "DynamicDrawView.h"		// For g_pView.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"				// For M_PI.
#include "UtilRect.h"			// For GetRoundRectPolygon.
#include "UtilGraph.h"			// For FCEditDraw.
#include "RegData.h"			// For hix2mm,mm2hix.
#include "ObjRoundRect.h"		// For FCObjRoundRect.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "LinkManager.h"		// For FDPA_HIT_NONE.

#include "ToolRoundRectEdit.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// 02.12.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//FCToolRoundRectEdit	g_toolRoundRectEdit;

/////////////////////////////////////////////////////////////////////////
// FCToolRoundRectEdit_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	View_xZkqqHx_iCmFjBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmE_xHqqkZx_m_vSelInfo_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeCiLmIjApMjFjEjFgJiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiCkKiCkAiCoJiClNiCnPiBeBjCfAiCmIiCoJ_xHqqkZx_ ObjDynabaseVector _xZkqqHx_iCmFiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjDmBiOoKiCmIiDhIiDeOiDfOiBfL_xHqqkZx_ JointSelInfoVector _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);

	m_pHitObj	= NULL;				// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
	m_iHitLine	= FDRE_HIT_NONE;	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiPeDjAlDjApMiBeC_xHqqkZx_
	m_mmptRound.SetPoint(0,0);		// _xZkqqHx_iMlLiNnNiCmMiKhAiCmMiKnLiClDiCpAiLeMjIfOiBeC_xHqqkZx_
	m_vlgptPoly.clear();			// _xZkqqHx_iJlMjApMiCmMiDhMiDiKiDfDiDjDjEhKjHpBiBeC_xHqqkZx_
} // FCToolRoundRectEdit::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
	// RoundRect_xZkqqHx_jFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNjFgAiJoGiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FDOJ_ROUND_RECT)) return;
	FCObjRoundRect* pRRect = (FCObjRoundRect*)pObj;
	DrawEditLine(pDC, pRRect, DBLPoint(pRRect->GetRoundX(), pRRect->GetRoundY()));
} // FCToolRoundRectEdit::DrawSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRoundRectEdit::CanHandle (const FCObjDynabase* pObj) const
{
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return pObj->IsKindOf(FDOJ_ROUND_RECT);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!pObj->IsKindOf(FDOJ_ROUND_RECT)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRoundRectEdit::CanHandle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::Calc8Points
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAiLoJiMgAiCmMiCfDjGhLiCmMiPeDjAlDjApMiCpAiIpIiCkNiClNiCnPiCmMiBeBiCfHiCmCiCmMjDfPiCmMiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt		:_xZkqqHx_iCfHiCmCiCmMjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			pRRect		:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiKnLiKhAiLoJiMgAjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRound	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiKhAiCmMiKnLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::Calc8Points (	DBLPoint mmpt[],
										const FCObjRoundRect* pRRect,
										const DBLPoint& mmptRound) const
{
	// _xZkqqHx_iDhJiDjDiCmMjFjNiBeC_xHqqkZx_
	const mmetol mmWeightHalf = pRRect->GetStdPenWeight() / 2.0;

	DBLPoint mmptCenter(pRRect->GetCenterX(), pRRect->GetCenterY());
	mmetol mmHAxisX = pRRect->GetHAxisX();
	mmetol mmVAxisY = pRRect->GetVAxisY();
	mmetol mmVertLeft   = mmptCenter.x - mmHAxisX + mmptRound.x;
	mmetol mmVertTop    = mmptCenter.y - mmVAxisY - (mmWeightHalf + lg2mm(10));
	mmetol mmVertRight  = mmptCenter.x + mmHAxisX - mmptRound.x;
	mmetol mmVertBottom = mmptCenter.y + mmVAxisY + (mmWeightHalf + lg2mm(10));
	mmetol mmHorzLeft   = mmptCenter.x - mmHAxisX - (mmWeightHalf + lg2mm(10));
	mmetol mmHorzTop    = mmptCenter.y - mmVAxisY + mmptRound.y;
	mmetol mmHorzRight  = mmptCenter.x + mmHAxisX + (mmWeightHalf + lg2mm(10));
	mmetol mmHorzBottom = mmptCenter.y + mmVAxisY - mmptRound.y;
	mmpt[0].SetPoint(mmVertLeft, mmVertTop);
	mmpt[1].SetPoint(mmVertLeft, mmVertBottom);
	mmpt[2].SetPoint(mmVertRight, mmVertTop);
	mmpt[3].SetPoint(mmVertRight, mmVertBottom);
	mmpt[4].SetPoint(mmHorzLeft, mmHorzTop);
	mmpt[5].SetPoint(mmHorzRight, mmHorzTop);
	mmpt[6].SetPoint(mmHorzLeft, mmHorzBottom);
	mmpt[7].SetPoint(mmHorzRight, mmHorzBottom);
} // FCToolRoundRectEdit::Calc8Points.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::BackConvert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCpAiBeBiOhHjCoIiClDiCoKiClNjFjEjFgJiCmMiDfGiDhEiDgHiBeFiJpBjDfNjFmPiKlHiCmJiKoOiCmDiCkCiCmE_xHqqkZx_
 *			_xZkqqHx_iLhEjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiClFiClNiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pRRect	:_xZkqqHx_iKnLiKhAiLoJiMgAiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::BackConvert (	DBLPoint& mmpt,
										const FCObjRoundRect* pRRect) const
{
	if (pRRect->GetAngle() != 0)
	{
		// _xZkqqHx_iLhEiJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		const double dSinR = sin(-pRRect->GetAngle() * M_PI);
		const double dCosR = cos(-pRRect->GetAngle() * M_PI);
		RotateConv(	mmpt, dSinR, dCosR,
					pRRect->GetCenterX(), pRRect->GetCenterY());
	}
	if (pRRect->GetVAxisX() != 0)
		ShiftConv(mmpt, pRRect->GetVAxisY(), -pRRect->GetVAxisX(),
					pRRect->GetCenterY());
} // FCToolRoundRectEdit::BackConvert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::CheckHitLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiPpDjBnEiCpAiBeBiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_pHitObj, m_iHitLine _xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRoundRectEdit::CheckHitLine ()
{
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pHitObj = NULL;				// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	m_iHitLine = FDRE_HIT_NONE;		// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiPeDjAlDjApMiBeC_xHqqkZx_
//	ObjDynabaseVector::const_reverse_iterator rObj;
//	for (rObj = g_pView->SelectObjVector().rbegin();
//		 rObj != g_pView->SelectObjVector().rend(); rObj++)
//	{
//		if (!(*rObj)->IsKindOf(FDOJ_ROUND_RECT)) continue;
//		FCObjRoundRect* pRRect = (FCObjRoundRect*)(*rObj);
//
//		DBLRect mmrtFrame = pRRect->GetResizeFrame();
//		if (!mmrtFrame.ExtendRect(lg2mm(15)).PtInRect(m_mmptMsc)) continue;
//		//----- _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAjFjEjFgJiCmJiNiHiCoNiClJiCmEiLhEjFmPiKlHiClHiCoJ_xHqqkZx_ -----
//		DBLPoint mmptCnv = m_mmptMsc;
//		BackConvert(mmptCnv, pRRect);
//		//----- _xZkqqHx_iLhEjFmPiKlHiMoDiCmMiDhNiDeFiDfIiNmAjFfHiCkKiDeHiDgGiDeCiDgCiDgHjApMiPoDiCmJiCkAiCoJiCkJiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//		DBLPoint mmptaPoint[8];
//		Calc8Points(mmptaPoint, pRRect, DBLPoint(pRRect->GetRoundX(), pRRect->GetRoundY()));
//		if (DBLRect(mmptaPoint[0], mmptaPoint[1]).ExtendRect(lg2mm(5)).PtInRect(mmptCnv))
//			m_iHitLine |= FDRE_HIT_VERT_LEFT;
//		else
//		if (DBLRect(mmptaPoint[2], mmptaPoint[3]).ExtendRect(lg2mm(5)).PtInRect(mmptCnv))
//			m_iHitLine |= FDRE_HIT_VERT_RIGHT;
//
//		if (DBLRect(mmptaPoint[4], mmptaPoint[5]).ExtendRect(lg2mm(5)).PtInRect(mmptCnv))
//			m_iHitLine |= FDRE_HIT_HORZ_TOP;
//		else
//		if (DBLRect(mmptaPoint[6], mmptaPoint[7]).ExtendRect(lg2mm(5)).PtInRect(mmptCnv))
//			m_iHitLine |= FDRE_HIT_HORZ_BOTTOM;
//
//		if (m_iHitLine != FDRE_HIT_NONE)
//		{
//			m_pHitObj = pRRect;
//			return TRUE;
//		}
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
//	return FALSE;
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_pHitObj = NULL;				// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
	m_iHitLine = FDRE_HIT_NONE;		// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiPeDjAlDjApMiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);
	ObjDynabaseVector::const_reverse_iterator rObj;
	for (rObj = g_pView->SelectObjVector().rbegin();
		 rObj != g_pView->SelectObjVector().rend(); rObj++)
	{
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), 0, 0, 0)) != stIds.end())
			m_iHitLine |= FDRE_HIT_VERT_LEFT;
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), 1, 0, 0)) != stIds.end())
			m_iHitLine |= FDRE_HIT_VERT_RIGHT;
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), 2, 0, 0)) != stIds.end())
			m_iHitLine |= FDRE_HIT_HORZ_TOP;
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), 3, 0, 0)) != stIds.end())
			m_iHitLine |= FDRE_HIT_HORZ_BOTTOM;
		if (m_iHitLine != FDRE_HIT_NONE)
		{
			m_pHitObj = (FCObjRoundRect*)(*rObj);
			return TRUE;
		}
	}
	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
	return FALSE;
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRoundRectEdit::CheckHitLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::CalcPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFjEjFgJiCmMiMlLiNnNiCmMiKhAiCmMjBoFiCkLiClDiCmFiBeBiJlMiCmMiDhMiDiKiDfDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_mmptRound_xZkqqHx_iCpAiCoAiCmGiCmJiMhGiOfKiClFiClNiMiLiJmKiCpA_xHqqkZx_m_vlgptPoly_xZkqqHx_iCmJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::CalcPolygon ()
{
//----- 00.03.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DBLPointVector vmmptPoly;
//	::GetRoundRectPolygon(vmmptPoly,
//						m_pHitObj->GetCenterX(), m_pHitObj->GetCenterY(),
//						m_pHitObj->GetHAxisX(), m_pHitObj->GetVAxisY(),
//						m_mmptRound.x, m_mmptRound.y, m_pHitObj->GetVAxisX(),
//						m_pHitObj->GetAngle(),
//						m_pHitObj->GetCenterX(), m_pHitObj->GetCenterY());
//	mm2lg(m_vlgptPoly, vmmptPoly);
//----- 00.03.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	::GetRoundRectPolygon(m_vlgptPoly,
						m_pHitObj->GetCenterX() * g_->dZoom,
						m_pHitObj->GetCenterY() * g_->dZoom,
						m_pHitObj->GetHAxisX() * g_->dZoom,
						m_pHitObj->GetVAxisY() * g_->dZoom,
						m_mmptRound.x * g_->dZoom,
						m_mmptRound.y * g_->dZoom,
						m_pHitObj->GetVAxisX() * g_->dZoom,
						m_pHitObj->GetAngle(),
						m_pHitObj->GetCenterX() * g_->dZoom,
						m_pHitObj->GetCenterY() * g_->dZoom,
						g_->lgdPrecision);
//----- 00.03.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRoundRectEdit::CalcPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::DrawEditLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRRect		:_xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRound	:_xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJjBmOiPnLiCmMiKhAiCmMiKnLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::DrawEditLine (CDC* pDC, const FCObjRoundRect* pRRect,
										const DBLPoint& mmptRound) const
{
	DBLPoint mmptaPoint[8];
	Calc8Points(mmptaPoint, pRRect, mmptRound);
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (pRRect->GetVAxisX() != 0)
//		::ShiftConv(mmptaPoint, 8, pRRect->GetVAxisY(), pRRect->GetVAxisX(),
//					pRRect->GetCenterY());
//	if (pRRect->GetAngle() != 0.0)
//	{
//		// _xZkqqHx_iJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
//		const double dSinR = sin(pRRect->GetAngle() * M_PI);
//		const double dCosR = cos(pRRect->GetAngle() * M_PI);
//		::RotateConv(mmptaPoint, 8, dSinR, dCosR,
//					 pRRect->GetCenterX(), pRRect->GetCenterY());
//	}
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CoordConv(	mmptaPoint, 8,
				pRRect->GetVAxisY(),
				pRRect->GetVAxisX(),
				pRRect->GetCenterY(),
				sin(pRRect->GetAngle() * M_PI),
				cos(pRRect->GetAngle() * M_PI),
				pRRect->GetCenterX(),
				pRRect->GetCenterY());
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	// _xZkqqHx_iPeDjAlDjApMjHhAiCfHiDhMiDeDiDjDiDgHiCpAjIfPjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	CPoint	lgptaPoint[8];
// 00.01.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	for (int iC = 0; iC < 8; iC++) lgptaPoint[iC] = mm2lg(mmptaPoint[iC]);
	mm2lg(lgptaPoint, mmptaPoint, 8);
	eDraw.Line(&lgptaPoint[0], &lgptaPoint[1]);
	if (lgptaPoint[0] != lgptaPoint[2] && lgptaPoint[1] != lgptaPoint[3])
	{
		eDraw.Line(&lgptaPoint[2], &lgptaPoint[3]);
	}
	eDraw.Line(&lgptaPoint[4], &lgptaPoint[5]);
	if (lgptaPoint[4] != lgptaPoint[6] && lgptaPoint[5] != lgptaPoint[7])
	{
		eDraw.Line(&lgptaPoint[6], &lgptaPoint[7]);
	}
} // FCToolRoundRectEdit::DrawEditLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolArcEdit.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolRoundRectEdit::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
		if (FFCanEditObject())
		//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
			switch (iEvent)
			{
			case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
				if (CheckHitLine())
					iNextState = STATE_ENTER_EDIT_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHjDpMiMpLiBeC_xHqqkZx_
				break;
			}
// 02.06.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
		}
		break;
	case STATE_ENTER_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_EDIT_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_EDIT_ROUND;		// _xZkqqHx_iKnLiKhAjFnCiPfHiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_EDITING_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHjCiGiBeC_xHqqkZx_
		break;
	case STATE_EDITING_ROUND:				// _xZkqqHx_iKnLiKhAjFnCiPfHjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_EDITING_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_EDIT_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_EDIT_ROUND;	// _xZkqqHx_iKnLiKhAjFnCiPfHiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolRoundRectEdit::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHjDpMiMpLiBeC_xHqqkZx_
		StateEnterEditRound(pDC);
		break;
	case STATE_START_EDIT_ROUND:	// _xZkqqHx_iKnLiKhAjFnCiPfHiKeKiOgOiBeC_xHqqkZx_
		StateStartEditRound(pDC);
		break;
	case STATE_EDITING_ROUND:		// _xZkqqHx_iKnLiKhAjFnCiPfHjCiGiBeC_xHqqkZx_
		StateEditingRound(pDC);
		break;
	case STATE_STOP_EDIT_ROUND:		// _xZkqqHx_iKnLiKhAjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
		StateStopEditRound(pDC);
		break;
	case STATE_EXIT_EDIT_ROUND:		// _xZkqqHx_iKnLiKhAjFnCiPfHiPgPiMpLiBeC_xHqqkZx_
		StateExitEditRound(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolRoundRectEdit::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateIdle (CDC* pDC)
{
	// _xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmNiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	if (CheckHitLine())
	{
		//----- _xZkqqHx_jAiCjClMiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		BOOL bHitV = (m_iHitLine & FDRE_HIT_VERT_LEFT ||
						m_iHitLine & FDRE_HIT_VERT_RIGHT);
		//----- _xZkqqHx_jAiFjFlNiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		BOOL bHitH = (m_iHitLine & FDRE_HIT_HORZ_TOP ||
						m_iHitLine & FDRE_HIT_HORZ_BOTTOM);
		if (bHitV && bHitH)
			SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
		else if (bHitV)
			SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEWE));
		else if (bHitH)
			SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZENS));
	}
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolRoundRectEdit::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateEnterEditRound
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAjFnCiPfHjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateEnterEditRound (CDC* pDC)
{
	TRACE(_T("StateEnterEditRound\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
} // FCToolRoundRectEdit::StateEnterEditRound.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateStartEditRound
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAjFnCiPfHiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateStartEditRound (CDC* pDC)
{
	TRACE(_T("StateStartEditRound\r\n"));
	// _xZkqqHx_iMlLiNnNiCmMiKhAiCmMiKnLiClDiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmptRound.SetPoint(m_pHitObj->GetRoundX(), m_pHitObj->GetRoundY());
	// _xZkqqHx_iJlMjApMiCpAiMhGiOfKiBeCiMiLiJmKiCmN_xHqqkZx_m_vlgptPoly_xZkqqHx_iCmJiBeC_xHqqkZx_
	CalcPolygon();
	// _xZkqqHx_iJlMjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
	// _xZkqqHx_iJlMjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
} // FCToolRoundRectEdit::StateStartEditRound.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateEditingRound
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAjFnCiPfHjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateEditingRound (CDC* pDC)
{
	TRACE(_T("StateEditingRound\r\n"));

	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiLhEjFmPiKlHiBeC_xHqqkZx_
	DBLPoint mmptCur = m_mmptCnv;
	BackConvert(mmptCur, m_pHitObj);
	//----- _xZkqqHx_jAfGiClFiCkCiKhAiCmMiKnLiClDiCpAiMhGiOfKiClHiCoJ_xHqqkZx_ -----
	DBLPoint mmptRound = m_mmptRound;
	DBLPoint mmptCenter(m_pHitObj->GetCenterX(), m_pHitObj->GetCenterY());
	mmetol mmHAxisX = m_pHitObj->GetHAxisX();
	mmetol mmVAxisY = m_pHitObj->GetVAxisY();
	if (m_iHitLine & FDRE_HIT_VERT_LEFT)
	//----- _xZkqqHx_jAiCjClMiNlGiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		mmptRound.x = mmptCur.x - mmptCenter.x + mmHAxisX;
		if (mmptRound.x < 0.0) mmptRound.x = 0.0;
		else if (mmHAxisX < mmptRound.x) mmptRound.x = mmHAxisX;
	} else
	if (m_iHitLine & FDRE_HIT_VERT_RIGHT)
	//----- _xZkqqHx_jAiCjClMiJeFiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		mmptRound.x = mmptCenter.x + mmHAxisX - mmptCur.x;
		if (mmptRound.x < 0.0) mmptRound.x = 0.0;
		else if (mmHAxisX < mmptRound.x) mmptRound.x = mmHAxisX;
	}
	if (m_iHitLine & FDRE_HIT_HORZ_TOP)
	//----- _xZkqqHx_jAiFjFlNiPoDiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		mmptRound.y = mmptCur.y - mmptCenter.y + mmVAxisY;
		if (mmptRound.y < 0.0) mmptRound.y = 0.0;
		else if (mmVAxisY < mmptRound.y) mmptRound.y = mmVAxisY;
	} else
	if (m_iHitLine & FDRE_HIT_HORZ_BOTTOM)
	//----- _xZkqqHx_jAiFjFlNiJlKiCmMiPeDjAlDjApMiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		mmptRound.y = mmptCenter.y + mmVAxisY - mmptCur.y;
		if (mmptRound.y < 0.0) mmptRound.y = 0.0;
		else if (mmVAxisY < mmptRound.y) mmptRound.y = mmVAxisY;
	}
	// _xZkqqHx_iKhAiCmMiKnLiClDiCmJjFmPiJlLiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_mmptRound == mmptRound) return;
	// _xZkqqHx_iPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawEditLine(pDC, m_pHitObj, m_mmptRound);
	// _xZkqqHx_iJlMjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
	// _xZkqqHx_iJlMjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmptRound = mmptRound;
	// _xZkqqHx_jAfGiClFiCkCiJlMjApMiCpAiMhGiOfKiBeCiMiLiJmKiCmN_xHqqkZx_m_vlgptPoly_xZkqqHx_iCmJiBeC_xHqqkZx_
	CalcPolygon();
	// _xZkqqHx_jAfGiClFiCkCiJlMjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
	// _xZkqqHx_jAfGiClFiCkCiPeDjAlDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawEditLine(pDC, m_pHitObj, m_mmptRound);
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCnGiCmMjFfMiOkGiPiIjHjN_xHqqkZx_ -----
	WString strMsg;
	strMsg.Format(L"R-X:%f R-Y:%f", mm2hi(m_mmptRound.x), mm2hi(m_mmptRound.y));
	FFGetMainWnd()->SetStatusBarText(strMsg);
} // FCToolRoundRectEdit::StateEditingRound.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateStopEditRound
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAjFnCiPfHiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateStopEditRound (CDC* pDC)
{
	TRACE(_T("StateStopEditRound\r\n"));
//----- 00.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iKhAiCmMjFmPiNfIjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
//	DBLPoint mmptDif = m_mmptRound -
//						DBLPoint(m_pHitObj->GetRoundX(), m_pHitObj->GetRoundY());
//----- 00.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFmPiMgAjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(m_pHitObj);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
//----- 00.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iCfAiKnLiKhAjFjEjFgJiCmMiKhAjFmPiNfIiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->CmdModify1RoundRectObj(m_pHitObj, mmptDif);
//----- 00.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iCfAiKnLiKhAjFjEjFgJiCmMiKhAjFmPiNfIiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	FCRoundRectRec rrRec;
	rrRec.wMask = FDFP_ROUNDX | FDFP_ROUNDY;
	rrRec.mmRoundX = m_mmptRound.x;
	rrRec.mmRoundY = m_mmptRound.y;
	g_pDoc->CmdModifyRoundRect(m_pHitObj, rrRec);
//----- 00.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 05.06.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmPiNfIiCpAiClBiCmMiDgDiBfLiDiLiCmJjCmKjCgNiBeC_xHqqkZx_
	OnSelectObjModified();
//----- 05.06.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFmPiMgAiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(m_pHitObj);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNjFhDjHhGiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeCiDhEiDiMiBfLiDiAiCmJ_xHqqkZx_
	// _xZkqqHx_iKhAiCmMiKnLiCnNiCmNiNgMjHlGiClDiCoKiCmIiCkCiClNiCnPiBeC_xHqqkZx_
	// _xZkqqHx_jDkPjHgMiCmJiDiCiDiKiDhGiNmEiMhGiOfKiCoAjFhDjHhGiBeC_xHqqkZx_
} // FCToolRoundRectEdit::StateStopEditRound.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::StateExitEditRound
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKnLiKhAjFnCiPfHiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::StateExitEditRound (CDC* pDC)
{
	TRACE(_T("StateExitEditRound\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
	::FFReleaseCapture();
} // FCToolRoundRectEdit::StateExitEditRound.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRoundRectEdit::ResetEditHandleList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRoundRectEdit::ResetEditHandleList ()
{
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearEditHandleList();

	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		if (!(*iObj)->IsKindOf(FDOJ_ROUND_RECT)) continue;
		FCObjRoundRect* pRRect = (FCObjRoundRect*)(*iObj);
		DBLPoint mmptaPoint[8];
		Calc8Points(mmptaPoint, pRRect, DBLPoint(pRRect->GetRoundX(), pRRect->GetRoundY()));
		CoordConv(	mmptaPoint, 8,
					pRRect->GetVAxisY(),
					pRRect->GetVAxisX(),
					pRRect->GetCenterY(),
					sin(pRRect->GetAngle() * M_PI),
					cos(pRRect->GetAngle() * M_PI),
					pRRect->GetCenterX(),
					pRRect->GetCenterY());
		// _xZkqqHx_jApMjFkKiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, 0, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(	DBLShortLine(mmptaPoint[0], mmptaPoint[1]),
						FCHandleId(long(pRRect->GetObjID()), 0, 0, 0));
		// _xZkqqHx_jApMjFkKiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, 1, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(	DBLShortLine(mmptaPoint[2], mmptaPoint[3]),
						FCHandleId(long(pRRect->GetObjID()), 1, 0, 0));
		// _xZkqqHx_jApMjFkKiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, 2, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(	DBLShortLine(mmptaPoint[4], mmptaPoint[5]),
						FCHandleId(long(pRRect->GetObjID()), 2, 0, 0));
		// _xZkqqHx_jApMjFkKiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, 3, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(	DBLShortLine(mmptaPoint[6], mmptaPoint[7]),
						FCHandleId(long(pRRect->GetObjID()), 3, 0, 0));
	}
} // FCToolRoundRectEdit::ResetEditHandleList.

