#include "stdafx.h"
#include "DynamicDraw.h"
#include "RegData.h"		// For GetSnapInterval.
#include "FoundDoc.h"		// For g_pDoc.
#include "SheetManager.h"	// For FCSheetManager.
#include "DynamicDrawView.h"// For g_pView.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ObjFigure.h"		// For FCObjFigure.
#include "ObjGroup.h"		// For FCObjGroup.
#include "ObjLabel.h"		// For FCObjLabel.
#include "RichText.h"		// For FCRichText.
#include "LinkManager.h"	// For g_pDoc->LinkManager().
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"		// For FFGetCurrentTime.
#include "UtilObj.h"		// For GetResizeFrame.
#include "UtilGraph.h"		// For FCEditDraw.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilFont.h"		// For FCFontCharInfo.
#include "UtilStr.h"		// For GetResString.
#include "TextOut.h"		// For FDRC_AL_XXX.
#include "UtilDlg.h"		// For FFPopupSubmenu.
#include "DlgTextMargin.h"	// For CFCDlgTextMargin.
#include "DlgTextLine.h"	// For CFCDlgTextLine.
#include "DlgReplaceContinueA.h" // For CFCDlgReplaceContinueA.
#include "DlgReplaceContinueB.h" // For CFCDlgReplaceContinueB.
#include "SearchParser.h"	// For FCSearchParser.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "ToolSelEdit.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIjDfMiCoIjFhEiCkPiNmPiCnNiCmMiDhNiBfLiDeOjHhAiBeC_xHqqkZx_
static CLIPFORMAT s_cfPasted = NULL;

//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMiDfCiDhDiBfLiBjFiDhJiBfLiDfIiDgHiCmFiBeBiNmFjCoBiMmAiInKjDkOiClDiCoKiCoJiLjHjHkDiBeC_xHqqkZx_
static DBLPoint s_mmptObjLabelMove(5.0, 5.0);
//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

///////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

///////////////////////////////////////////////////////////////////////////
// FCToolSelEdit_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::FCToolSelEdit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.15 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCToolSelEdit::FCToolSelEdit ()
{
	// _xZkqqHx_jBiAiNoMiJmCjEfMiCmIjFjEjFgJiCmMiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	SetOperationFlag(XXX_OBJ_BASE, FDOZ_ON_SELECT);

	m_lPasteCount = 0;					// _xZkqqHx_jDkPiClGiDgGiBfLiDfOiCmMiDhJiBfLiDfIiDgHiJpBjAjEiBeC_xHqqkZx_
	m_mmptPasteOffset.SetPoint(0,0);	// _xZkqqHx_iDhJiBfLiDfIiDgHiOjOiCmMiDeJiDhEiDfKiDgCiDgHjHmKiBeC_xHqqkZx_
	m_pLastPasteObj = NULL;				// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiBeC_xHqqkZx_
	m_dwLastPasteObj = DWORD(-1);		// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_

	//----- Molip Draw_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMiDhNiBfLiDeOjHhA_xHqqkZx_ _xZkqqHx_iMgAiOkOjGlMiCpAjDgPjIfO_xHqqkZx_ -----
	if (s_cfPasted == NULL)
	{
		WString strForm;
		strForm.Format(L"Dynamic Draw %s Pasted",
						FCHeaderInf::GetStcFileVersionString());
		s_cfPasted = (CLIPFORMAT)::RegisterClipboardFormat(WStrToTStr(strForm));
	}
} // FCToolSelEdit::FCToolSelEdit.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolSelEdit::OnDraw (CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiClFiCmIiCkCiCmGiBeBiJeFiDhLiDfOiDjDiCmFiInKjDkOiBeFiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmJ_xHqqkZx_
//	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKjFfMiOkGiBeBiInKjDkOjCiGiCmMiDeDiDiBiBfLiDfHiCpAiJeCiClFiClNiPoKiNiHiBeB_xHqqkZx_
//	// _xZkqqHx_iPiIjHjNiDeMiDiDiDjDiDfKiDiLiMoDiCmJiDfDiDhOiCkKiOgDiCoJiBeC_xHqqkZx_
//	case STATE_STOP_MOVE_OBJ_2:		// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
//	case STATE_CONTEXT_MENU_3:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
//		OnDrawMovingImageXXX(XXX_OBJ_BASE, pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//		break;
//	default:
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//	}
//} // FCToolSelEdit::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanSelectTool () const
{
	// _xZkqqHx_jFlGiPjBiCkKjFnCiPfHiJmCjEfMiCmFiCmNjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeCiBeC_xHqqkZx_
	if (!FFCanEditObject()) return FALSE;
	return TRUE;
} // FCToolSelEdit::CanSelectTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlNiCkJiClFiCoHiNoNiPjMiJmCjEfMiCmIiCoAiCmMiCpAjBeJjBpAjCiGiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiDiBiDgKiDiFiBfLiCmMjHeMiMpIiBfOjGlDiMpIiCpAjAnIiCoIjBnGiCkGiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjHeMiCoJiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjGlDiCkCiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanDelete () const
{
	// _xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeC_xHqqkZx_
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return GetCurrentState() == STATE_IDLE && FFCanEditSelected();
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return (GetCurrentState() == STATE_IDLE ||
			GetCurrentState() == STATE_CONTEXT_MENU ||
			GetCurrentState() == STATE_CONTEXT_MENU_LINK) &&
			FFCanEditSelected();
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::CanDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFkIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPiIjHjNiCpAiNoNiPjMiDfCiDhNiDjDiDgIiCmJjFmPiNfIiBeC_xHqqkZx_
 *			00.09.06 Fukushiro M. OLE_xZkqqHx_jFjEjFgJiNoNiPjMiDgAiDeGiDgCiDeOiCpAjBhNjDpMiBeC_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnDelete (CDC* pDC)
{
	// Delete_xZkqqHx_iDeMiBfLiCpA_xHqqkZx_IDLE_xZkqqHx_iImIiKePiCmFiLnGiOhOiClHiCoJiBeCiClBiCoKiCpAiClFiCmIiCkCiCmG_xHqqkZx_
	// _xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJiBeC_xHqqkZx_
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetCurrentState() != STATE_IDLE ||
//		GetSelectLocalObjVector().empty()) return;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!CanDelete()) return;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	const ObjDynabaseVector vSelObj = g_pView->SelectObjVector();
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClFiBeBjBeJjBpAjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(pDC);
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
	{
		// _xZkqqHx_iKnGiMfHiClHiCoJiDiKiDjDiDeOiCpAiNoNiPjMiBeCjDoAjFjEiCmFiDiKiDjDiDeOiNoNiPjMiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->LinkManager()->DeleteSoonNotify((*iObj)->GetObjID());
		// _xZkqqHx_iNmEjFgAiJoGjHhAiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjHmMiIoGiCpAjCmHiJmBiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(*iObj);
		// _xZkqqHx_jFjEjFgJiCmMiNoNiPjMiDfCiDhNiDjDiDgIiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->MulticmdDelete1Obj(*iObj, g_pDoc->GetCurrentSheetId());
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolSelEdit::OnDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanObjectGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGiJlLiJmCjEfMiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDePiDiLiBfLiDhGiJlLiJmCjEfMiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iDePiDiLiBfLiDhGiJlLjFhDiJmCjEfMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanObjectGroup () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	return 1 < g_pView->SelectObjVector().size() ? TRUE : FALSE;
} // FCToolSelEdit::CanObjectGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnObjectGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.27 Fukushiro M. _xZkqqHx_iDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiCnGiCmMjBmOiJjOiCmGiBeBiDePiDiLiBfLiDhGiJlL_xHqqkZx_
 *								_xZkqqHx_iOjOiCmMiDiKiDjDiDeOiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnObjectGroup ()
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiDfCiDhDiBfLiClHiCoJiBeCjBeJjBpAjFjEjFgJiCpAiDeOiDiKiDeBiClHiCoJiInHiBeC_xHqqkZx_
	const ObjDynabaseVector vSelObj = g_pView->SelectObjVector();
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClFiBeBjBeJjBpAjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
	//----- _xZkqqHx_jFjEjFgJiCmMiDePiDiLiBfLiDhGiJlLiCmJjElKiCkEiBeBiDiKiDjDiDeOiCmMiNoNiPjMiPiIjHjN_xHqqkZx_ -----
	FTMolipSet stMolip;
	g_pView->AddEmptyRgn();
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
	{
		g_pView->AppendToLastRgn(*iObj);
		stMolip.insert(FCMolipRec((*iObj)->GetObjID(), -1));
	}
	//----- _xZkqqHx_jFjEjFgJiPfHiNiHiKePiCmGiCmMiDiKiDjDiDeOiBeBjFjEjFgJiPfHiNiHjDoAiCmMiDiCiDiKiDhGiKnEiCmMiDiKiDjDiDeOiCpAiOoGjDlO_xHqqkZx_ -----
	DWORDVector vLinkOther;
	DWORDVector vLinkInside;
	g_pDoc->LinkManager()->GetAffected(vLinkOther, vLinkOther, vLinkInside, stMolip);

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	//----- _xZkqqHx_jFjEjFgJiPfHiNiHiKePiCmGiCmMiDiKiDjDiDeOiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
	DWORDVector::const_iterator iLk;
	for (iLk = vLinkOther.begin(); iLk != vLinkOther.end(); iLk++)
	{
		g_pDoc->CmdDelete1Link(stRedrawObj, *iLk);
	}
	// _xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiJlLiClHiCoJiBeC_xHqqkZx_
	FCObjDynabase* pGrpObj = g_pDoc->CmdGroup(vSelObj, vLinkInside);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(stRedrawObj);
//----- 05.05.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjAfGiClFiCkCjBeJjBpAiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendSelectObj(pGrpObj, TRUE);
} // FCToolSelEdit::OnObjectGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanObjectUngroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGiJpAiPjMiJmCjEfMiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiJmCjEfMiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanObjectUngroup () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!FFCanEditSelected()) return FALSE;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCkJiCmHiCkEiCkJiDgAiDeGiDgCiDeOiBeCiDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCoAiBhOiBeC_xHqqkZx_
		// _xZkqqHx_iDfEiDhFiDeOiDiJiDfIjFjEjFgJiClOiCmGiBeBiDfCiDhNiDjDiDgIjEkNiNhDiCmFiBeBiChEiCiOiCiEiCiPiCkKjFhDiJmCjEfMiClOiCkJiCoHiBeC_xHqqkZx_
		if ((*iObj)->Type() != FDOJ_GROUP) return FALSE;
	}
	return TRUE;
} // FCToolSelEdit::CanObjectUngroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnObjectUngroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnObjectUngroup ()
{
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiDfCiDhDiBfLiClHiCoJiBeCjBeJjBpAjFjEjFgJiCpAiDeOiDiKiDeBiClHiCoJiInHiBeC_xHqqkZx_
	const ObjDynabaseVector vSelObj = g_pView->SelectObjVector();
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClFiBeBjBeJjBpAjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
	//----- _xZkqqHx_jFjEjFgJiCmMiDeBiDjDiDePiDiLiBfLiDhGiJlLiPiIjHjN_xHqqkZx_ -----
	ObjDynabaseVector vNewObj;	// _xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiCmFjAlGiClGiCoJjAfGiClFiCkCjFjEjFgJiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
	{
		// _xZkqqHx_iNmEjFgAiJoGjHhAiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjHmMiIoGiCpAjCmHiJmBiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(*iObj);
		// _xZkqqHx_iKnGiMfHiClHiCoJiDiKiDjDiDeOiCpAiNoNiPjMiBeCjDoAjFjEiCmFiDiKiDjDiDeOiNoNiPjMiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->LinkManager()->DeleteSoonNotify((*iObj)->GetObjID());
		// _xZkqqHx_jFjEjFgJiCpAiDeBiDjDiDePiDiLiBfLiDhGiJlLiClHiCoJiBeC_xHqqkZx_
		ObjDynabaseVector vMmbObj;
		g_pDoc->CmdUngroup(vMmbObj, (FCObjGroup*)*iObj);
		// _xZkqqHx_jAfGiLeLiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
		vNewObj.insert(vNewObj.end(), vMmbObj.begin(), vMmbObj.end());
	}
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiCmFjAlGiClGiClNjFjEjFgJiCpAjAfGiClFiCkCjBeJjBpAiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendSelectObj(vNewObj, TRUE);
} // FCToolSelEdit::OnObjectUngroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DynamicDrawView_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJiBeCiClBiCmMiDgDiBfLiDiLiCmFiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanPaste () const
{
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!FFCanCreateObject()) return FALSE;
//	return g_pDoc->CanPaste();
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return CanPasteSpec(0);
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::CanPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	1. _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiCmMjFjEjFgJiCmMiNoMjAkMiPiIjHjNiBeC_xHqqkZx_
 *			2. _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiCmMiInKjDkOjHmKiMhGiOfKiBeC_xHqqkZx_
 *			3. _xZkqqHx_iKgHjCkDiDfGiBfLiDgHiCmMiDhEiDiMiBfLiDiAiCpAiNgMjHlGiClFiCmEiInKjDkOjHmKiCpAjFoCjAlDiBeC_xHqqkZx_
 *			4. _xZkqqHx_jFjEjFgJiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
 *			5. _xZkqqHx_iOjPiJpBiDhJiBfLiDfIiDgHiCmJjEpFiCkGiCmEiPiAjEpFiBeC_xHqqkZx_
 *			6. _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmMjBeJjBpAiLhJiCnBiNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.02 Fukushiro M. _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCkJiCoHiMeKiCoIjFnEiClFiDhJiBfLiDfIiDgHiLeAjEfMiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnPaste (CDC* pDC)
{
	OnPasteSpec(pDC, 0);
} // FCToolSelEdit::OnPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFormat	:_xZkqqHx_iDhJiBfLiDfIiDgHiClFiCoGiCkEiCmGiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeCiMgAiOkOiCpAjDmBjCoIiClFiCmIiCkC_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCmNiCePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	DynamicDrawView_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJiCkKiBeBiCmGiCoIiCkAiCkGiClIiClBiCmMiDgDiBfLiDiLiCmFiDhJiBfLiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClJiCmOiCoGiCkCiBeC_xHqqkZx_
 *			TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_jCiGiCmMiMmEiCnBiPgPiClFiMlDiCmF_xHqqkZx_
 *			FDFoundDoc_xZkqqHx_iCkKiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiNfIiCmJjClCiCnHiCmEiCkNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanPasteSpec (UINT dwFormat) const
{
	if (!FFCanCreateObject()) return FALSE;
	return g_pDoc->CanPasteSpec(dwFormat);
} // FCToolSelEdit::CanPasteSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiDhJiBfLiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			dwFormat	:_xZkqqHx_iDhJiBfLiDfIiDgHiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeC_xHqqkZx_0_xZkqqHx_iCmIiCoHiCmOiOkJjDkOjElLjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	1. _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiCmMjFjEjFgJiCmMiNoMjAkMiPiIjHjNiBeC_xHqqkZx_
 *			2. _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiCmMiInKjDkOjHmKiMhGiOfKiBeC_xHqqkZx_
 *			3. _xZkqqHx_iKgHjCkDiDfGiBfLiDgHiCmMiDhEiDiMiBfLiDiAiCpAiNgMjHlGiClFiCmEiInKjDkOjHmKiCpAjFoCjAlDiBeC_xHqqkZx_
 *			4. _xZkqqHx_jFjEjFgJiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
 *			5. _xZkqqHx_iOjPiJpBiDhJiBfLiDfIiDgHiCmJjEpFiCkGiCmEiPiAjEpFiBeC_xHqqkZx_
 *			6. _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmMjBeJjBpAiLhJiCnBiNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnPasteSpec (CDC* pDC, UINT dwFormat)
{
	// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjCfAjDmGiCmMiPoKiNiHiBeC_xHqqkZx_
	BOOL bIsOneLabelObj = FALSE;
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
do {
	// _xZkqqHx_jAfGiClFiCkNiNoMjAkMiClDiCoKiCoJjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseVector vNewObj;
	//////////// 1. _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiCmMjFjEjFgJiCmMiNoMjAkMiPiIjHjN_xHqqkZx_ ///////////
	// _xZkqqHx_iDhJiBfLiDfIiDgHiPiIjHjNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_
	g_pDoc->OnPasteSpec(dwFormat, vNewObj);

	// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmNiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
	if (vNewObj.empty()) break;

//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCfAjDmGiCmMiDiJiDhIiDiLjFjEjFgJiCmNjDmBjFmKiBeC_xHqqkZx_
	bIsOneLabelObj = (	vNewObj.size() == 1 &&
						vNewObj.front()->IsKindOf(FDOJ_LABEL));
//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//////////// 2. _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiCmMiInKjDkOjHmKiMhGiOfK_xHqqkZx_ /////////////////
	// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJjBfDiCmEiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLRect mmrtAllFrame;
	::GetResizeFrame(mmrtAllFrame, vNewObj.begin(), vNewObj.size());
	// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCmMiInKjDkOjHmKiBeC_xHqqkZx_
	DBLPoint mmptMove;
	if (m_lPasteCount == 0 ||
		!IsClipboardFormatAvailable(s_cfPasted) ||
		m_pLastPasteObj != g_pDoc->ObjID2Object(m_dwLastPasteObj))
	//----- _xZkqqHx_iPiJiCnPiCmEiCmMiDhJiBfLiDfIiDgHiCmMiPoKiNiHiBeBiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMjDoAjHgFiCkKiNfIjAfGiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	//----- _xZkqqHx_jBePiJpBiCmMiDhJiBfLiDfIiDgHjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiBgJiDhJiBfLiDfIiDgHiOjOiCmGiIoBiCkEiBgKiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDhJiBfLiDfIiDgHiNmPiCnNiCmMiDhNiBfLiDeOiCpAjAnNjCoI_xHqqkZx_ -----
		if (::OpenClipboard(NULL))
		{
			SetClipboardData(s_cfPasted, NULL);
			::CloseClipboard();
		}
		// _xZkqqHx_jDkPiClGiDgGiBfLiDfOiCmMiDhJiBfLiDfIiDgHiJpBjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
		m_lPasteCount = 0;
		// _xZkqqHx_iDhJiBfLiDfIiDgHiOjOiCmMiDeJiDhEiDfKiDgCiDgHjHmKiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
		m_mmptPasteOffset.SetPoint(0,0);
		// _xZkqqHx_iJoGjGmKiCmMjFfMiOkGjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		DBLRect mmrtClient;
		g_pView->GetClientRectMM(mmrtClient);

		if ((mmrtAllFrame & mmrtClient).IsRectNull())
		//----- _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmGiJoGjGmKiCmJiPgEiCmIiCoIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCkKiJoGjGmKjCiGiJjLiCmJjHiIiCoJiCoGiCkEiCmJiInKjDkOjHmKiCpAjClCjAkOiBeC_xHqqkZx_
			mmptMove = mmrtClient.CenterPoint() - mmrtAllFrame.CenterPoint();
		} else
		//----- _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmGiJoGjGmKiCmJiPgEiCmIiCoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
//			mmptMove.SetPoint(0,0);
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (bIsOneLabelObj)
			//----- _xZkqqHx_jCfAjDmGiCmMiDiJiDhIiDiLjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jCfAjDmGiCmMiDiJiDhIiDiLjFjEjFgJiCmNiBeBjFeLiClIiPkNiClFiInKjDkOiClDiClJiCoJiClBiCmGiBeC_xHqqkZx_
				// _xZkqqHx_iDfIiDgJiDgCiDhGiLjHjHkDiCpAiMlDiCmJiBeBiNmFjCoBiMmAiInKjDkOiClDiClJiCoJiLjHjHkDiImIiPoDiCpAiInKjDkOiBeC_xHqqkZx_
				DBLPoint mmptSnapInterval = g_pReg->GetSnapInterval();
				if (rough0(mmptSnapInterval.x))
					mmptSnapInterval.x = s_mmptObjLabelMove.x;
				if (rough0(mmptSnapInterval.y))
					mmptSnapInterval.y = s_mmptObjLabelMove.y;
				long lHorzBy = D2L(s_mmptObjLabelMove.x / mmptSnapInterval.x);
				if (lHorzBy == 0) lHorzBy = 1;
				long lVertBy = D2L(s_mmptObjLabelMove.y / mmptSnapInterval.y);
				if (lVertBy == 0) lVertBy = 1;
				mmptMove.x = mmptSnapInterval.x * lHorzBy;
				mmptMove.y = mmptSnapInterval.y * lVertBy;
			}
			else
			{
				// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
				mmptMove.SetPoint(0,0);
			}
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	} else
	{
		// _xZkqqHx_jBePiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCmMiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const DBLRect mmrtLastFrame = m_pLastPasteObj->GetResizeFrame();
		const DBLPoint mmptLastObj(mmrtLastFrame.left, mmrtLastFrame.top);
		// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCmMiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const DBLRect mmrtCurFrame = vNewObj.front()->GetResizeFrame();
		const DBLPoint mmptCurObj(mmrtCurFrame.left, mmrtCurFrame.top);
		// _xZkqqHx_iCfBiJpBjGnKiCmMiDhJiBfLiDfIiDgHiCmMiPoKiNiHiCmNiBeBiNmFiPiJiCmMiDhJiBfLiDfIiDgHjFjEjFgJiCmMiInKjDkOjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
		if (m_lPasteCount == 1)
		{
			// _xZkqqHx_iDhJiBfLiDfIiDgHiOjOiCmMjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCmMiNmAjFfHiCmMiInKjDkOiLjHjHkDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			m_mmptPasteOffset = mmptLastObj - m_mmptLastPasteObj;
		}
		// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCkKiCkAiCoJiCnHiCkLiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const DBLPoint mmptNewObj = mmptLastObj + m_mmptPasteOffset;
		// _xZkqqHx_iNkBiJpBiDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiCmMiInKjDkOjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
		mmptMove = mmptNewObj - mmptCurObj;
	}

	/////////// 3. _xZkqqHx_iKgHjCkDiDfGiBfLiDgHiCmMiDhEiDiMiBfLiDiAiCpAiNgMjHlGiClFiCmEiInKjDkOjHmKiCpAjFoCjAlD_xHqqkZx_ //////////
	mmptMove += g_pEnv->CheckFrameInSheetEx(mmrtAllFrame + mmptMove);

	///////////////// 4. _xZkqqHx_jFjEjFgJiCmMiInKjDkOiPiIjHjN_xHqqkZx_ ///////////////////
	// _xZkqqHx_jFjEjFgJiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	ObjDynabaseVector::iterator iObj;
	for (iObj = vNewObj.begin(); iObj != vNewObj.end(); iObj++)
		g_pDoc->CmdMove1Obj(*iObj, mmptMove);

	//////////// 5. _xZkqqHx_iOjPiJpBiDhJiBfLiDfIiDgHiCmJjEpFiCkGiCmEiPiAjEpF_xHqqkZx_ ////////////////
	// _xZkqqHx_iDhJiBfLiDfIiDgHiDeKiDeFiDjDiDfOiCpAiDeBiDgCiDhGiBeC_xHqqkZx_
	m_lPasteCount++;
	// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pLastPasteObj = vNewObj.front();
	// _xZkqqHx_iDhJiBfLiDfIiDgHiClFiClNjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwLastPasteObj = m_pLastPasteObj->GetObjID();
	// _xZkqqHx_iDhJiBfLiDfIiDgHiOjOiCmMjFjEjFgJiPfHiNmFiPiJiCmMjFjEjFgJiCmMiNmAjFfHiBeC_xHqqkZx_
	const DBLRect mmrtFrame = m_pLastPasteObj->GetResizeFrame();
	m_mmptLastPasteObj.SetPoint(mmrtFrame.left, mmrtFrame.top);

	////////////// 6. _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmMjBeJjBpAiLhJiCnBiNmEjFgAiJoGiPiIjHjN_xHqqkZx_ /////////////
	// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(pDC);
	// _xZkqqHx_jAfGiClFiCkNiDhJiBfLiDfIiDgHiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
	g_pView->AppendSelectObj(vNewObj);
	// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} while (FALSE);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCfAjDmGiCmMiDiJiDhIiDiLjFjEjFgJiCmMiPoKiNiHiBeBiClHiCkOjFnCiPfHiPiIjHjNiCmJjDpMiCoJiBeC_xHqqkZx_
	// DDPro_xZkqqHx_iCmFiOgHiCkEiPoKiNiHiBeBiDiJiDhIiDiLjFjEjFgJiCmNjFkBiOmKiClFiCmEjFpKjChFiClHiCoJiCmG_xHqqkZx_
	// _xZkqqHx_iDiJiDhIiDiLiCkKjFmPiNfIiClDiCoKiCmIiCkCiCnMiCnMiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiPgPiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iClHiCkOjFmPiNfIiClHiCoKiCmOiBeBjAfGiClFiCkCjDoAjHgFiCmFjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
	if (bIsOneLabelObj)
	{
		// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
		SetNextTool(ID_TOOL_EDIT_RICH_TEXT);
		// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		SetLockStatus(FALSE);
		// _xZkqqHx_iDgDiBfLiDiLjFmPiNfIiBeC_xHqqkZx_
		EndOfSession();
	}
//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::OnPasteSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanReplaceText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanReplaceText () const
{
	return FFCanEditDocument();
} // FCToolSelEdit::CanReplaceText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanReplaceNextText () const
{
	return FFCanEditDocument();
} // FCToolSelEdit::CanReplaceNextText.

//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myReplaceAllText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHiCpAjBfDiCmEjChFiKlHiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pSP		:_xZkqqHx_jChFiKlHjHhAiMjPiNpFiDeHiDjDiDfHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeCiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmNjAnNjCoIiClHiCoJiCkKiBeBiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static myReplaceAllText (FCObjFigure* pObj, FCSearchParser* pSP)
//{
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjChFiKlHiClHiCoJ_xHqqkZx_ -----
//	FCRichText* pRich = pObj->GetRichText();
//	// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
//	g_pDoc->BeforeCmdModifyAbcRichText(pObj);
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiBeC_xHqqkZx_
//	BYTEVector byvQueue;
//	pRich->ReplaceAll(byvQueue, *pSP, pObj);
//	if (!byvQueue.empty())
//	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiBgJjChFiKlHiClDiCoKiClNjFlGiOjKiCkKiCkAiCoJiBgKiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//		g_pDoc->CmdModifyAbcRichText(pObj, byvQueue.size(), byvQueue.begin());
//		if (pObj->IsKindOf(FDOJ_LABEL))
//		{
//			// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjFmPiNfIiOjOiKnEiCmMiLeMjIfOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			g_pDoc->CmdModifyLabel((FCObjLabel*)pObj,
//									FCLabelRec(FDFP_LABELMTIME, FFGetCurrentTime(), 0));
//		}
//		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(pObj);
//	}
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//} // myReplaceAllText.
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnReplaceNextText ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (m_pLastHitTextObj != NULL)
	//----- _xZkqqHx_iMjPiNpFiDhBiDgCiDgHjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FCRichText* pTxt = m_pLastHitTextObj->GetRichText();
//		if (pTxt != NULL)
//		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//			WString strTarget;
//			pTxt->GetText(strTarget);
//			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//			if (pSP->IsMatch(strTarget.c_str()) == 1)
//			{
//				myReplaceAllText(m_pLastHitTextObj, pSP);
//				// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
//				g_pView->SendRgnRedraw();
//			}
//		}
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (m_pLastHitTextObj->GetRichText() != NULL)
		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
//			CClientDC dc(g_pView);
//			g_pView->OnPrepareDC(&dc, NULL);
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFkKjBeJjBpAiCpAiJpAiPjMiBeCiClBiClBiCmFiJpAiPjMiClFiCmIiCkCiCmGiBeBjChFiKlHiMoDiCmM_xHqqkZx_
//			// _xZkqqHx_iInJiCmIiCoJiDgFiDeMiDfIiDgHiCmJiMmDiCkCjFjEjFkKjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//			FCObjFigure* pLastHitTextObj = m_pLastHitTextObj;
//			ClearTextSelection(&dc, m_pLastHitTextObj->GetGroupTop());
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
			CClientDC dc(g_pView);
			g_pView->OnPrepareDC(&dc, NULL);
			// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFkKjBeJjBpAiCpAiJpAiPjMiBeCiClBiClBiCmFiJpAiPjMiClFiCmIiCkCiCmGiBeBjChFiKlHiMoDiCmM_xHqqkZx_
			// _xZkqqHx_iInJiCmIiCoJiDgFiDeMiDfIiDgHiCmJiMmDiCkCjFjEjFkKjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_pLastHitTextObj->GetRichText()->ClearSelection(&dc);
			m_pLastHitTextObj->ClearTextSelection(&dc);
			// _xZkqqHx_jChFiKlHiPiIjHjNiBeC_xHqqkZx_
			ReplaceAllCallback(*pSP, m_pLastHitTextObj, NULL);
			// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
			g_pView->SendRgnRedraw();
		}
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_NEXT_TEXT);
} // FCToolSelEdit::OnReplaceNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanReplacePrevText () const
{
	return FFCanEditDocument();
} // FCToolSelEdit::CanReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnReplacePrevText ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (m_pLastHitTextObj != NULL)
	//----- _xZkqqHx_iMjPiNpFiDhBiDgCiDgHjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FCRichText* pTxt = m_pLastHitTextObj->GetRichText();
//		if (pTxt != NULL)
//		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//			WString strTarget;
//			pTxt->GetText(strTarget);
//			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//			if (pSP->IsMatch(strTarget.c_str()) == 1)
//			{
//				myReplaceAllText(m_pLastHitTextObj, pSP);
//				// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
//				g_pView->SendRgnRedraw();
//			}
//		}
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (m_pLastHitTextObj->GetRichText() != NULL)
		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
//			CClientDC dc(g_pView);
//			g_pView->OnPrepareDC(&dc, NULL);
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFkKjBeJjBpAiCpAiJpAiPjMiBeCiClBiClBiCmFiJpAiPjMiClFiCmIiCkCiCmGiBeBjChFiKlHiMoDiCmM_xHqqkZx_
//			// _xZkqqHx_iInJiCmIiCoJiDgFiDeMiDfIiDgHiCmJiMmDiCkCjFjEjFkKjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//			FCObjFigure* pLastHitTextObj = m_pLastHitTextObj;
//			ClearTextSelection(&dc, m_pLastHitTextObj->GetGroupTop());
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
			CClientDC dc(g_pView);
			g_pView->OnPrepareDC(&dc, NULL);
			// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFkKjBeJjBpAiCpAiJpAiPjMiBeCiClBiClBiCmFiJpAiPjMiClFiCmIiCkCiCmGiBeBjChFiKlHiMoDiCmM_xHqqkZx_
			// _xZkqqHx_iInJiCmIiCoJiDgFiDeMiDfIiDgHiCmJiMmDiCkCjFjEjFkKjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_pLastHitTextObj->GetRichText()->ClearSelection(&dc);
			m_pLastHitTextObj->ClearTextSelection(&dc);
			// _xZkqqHx_jChFiKlHiPiIjHjNiBeC_xHqqkZx_
			ReplaceAllCallback(*pSP, m_pLastHitTextObj, NULL);
			// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
			g_pView->SendRgnRedraw();
		}
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_PREV_TEXT);
} // FCToolSelEdit::OnReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanReplaceTextAll () const
{
	return FFCanEditDocument();
} // FCToolSelEdit::CanReplaceTextAll.

//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnReplaceTextAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolSelEdit::OnReplaceTextAll ()
//{
//	FCSearchParser* pSP = GetSearchParser();
//	if (pSP == NULL) return;
//
//	//---------------------------------------------------------
//	// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiHiCmGiBeBjGlDiCkCiPoKiNiHiCmJiPiIjHjNiCpAjFkKiCkPiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iNfIiCmJiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiHiBeBiDePiDiLiBfLiDhGjCiGiCmMiCfAjFjEjFgJiCkJiBeB_xHqqkZx_
//	// _xZkqqHx_jDmGjHkHiClFiClNiCfAiCmCiCmMjFjEjFgJiCmFiCkAiCoJiCkJiCpAiLoGjFmKiClHiCoJiBeC_xHqqkZx_
//	// 1._xZkqqHx_jBeJjBpAjCiGjFjEjFgJiCkKiBeBiDePiDiLiBfLiDhGjCiGiCmMiCfAjFjEjFgJiCmMiPoKiNiHiBeC_xHqqkZx_
//	//  _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGjCiGiCmMjBeJjBpAjFjEjFgJiImIiNhOiCpAjChFiKlHiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//	//  _xZkqqHx_iClLiCmMiMoDiCmNiBeB_xHqqkZx_2._xZkqqHx_iCmGjDkPiClGiBeC_xHqqkZx_
//	// 2._xZkqqHx_jBeJjBpAjCiGjFjEjFgJiCkKiBeBjDmGjHkHiClFiClNiCfAiCmCiCmMjFjEjFgJiCmMiPoKiNiHiBeC_xHqqkZx_
//	//  _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBjBeJjBpAjFjEjFgJiCpAjChFiKlHiPiIjHjNiCmMiKeKiOgOiImKjChFiCmGiClFiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	//  _xZkqqHx_iClLiCmMiMoDiCmNiBeBiNmFiMoDiCnMiCmFiDiLiBfLiDhGiClFiCmEjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//	// 3._xZkqqHx_jBeJjBpAjCiGjFjEjFgJiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
//	//  _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiIoKjEnEiPoDiCmMjFjEjFgJiCpAjChFiKlHiPiIjHjNiCmMiKeKiOgOiImKjChFiCmGiClFiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	//  _xZkqqHx_iClLiCmMiMoDiCmNiBeBiNmFiMoDiCnMiCmFiDiLiBfLiDhGiClFiCmEjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//	// _xZkqqHx_iNmFiMoDiCmJiBeBjChFiKlHiCmMiMhAjBlBiCpAjGoCiCkCiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//	//---------------------------------------------------------
//
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (m_pLastHitTextObj != m_pSearchedObj)
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (m_pLastHitTextObj != NULL &&
//		m_pLastHitTextObj->GetGroupParent() != NULL)
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiCfAjFjEjFgJiCkKjBeJjBpAjCiGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// ObjGroup_xZkqqHx_jCiGiCmMiBeBjBfDiCmEiCmMjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//		ObjDynabaseVector vObj;
//		//----- _xZkqqHx_iDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAjBmOiPnLiCmJiJmBiCkGiCoJiCkJiBeI_xHqqkZx_ -----
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		if (g_pReg->GetIsFindChipText())
////			((FCObjGroup*)m_pSearchedObj)->FCObjGroup::GetCanBeTextObject(vObj);
////		else
////			((FCObjGroup*)m_pSearchedObj)->GetCanBeTextObject(vObj);
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		if (g_pReg->GetIsFindChipText())
//			m_pLastHitTextObj->GetGroupTop()->GetKindOfMembers(vObj, FDOJ_FIGURE);
//		else
//			((FCObjGroup*)m_pLastHitTextObj->GetGroupTop())->GetCanBeTextObject(vObj);
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		ObjDynabaseVector::reverse_iterator rObj;
//		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
//		for (rObj = vObj.rbegin();
//			 rObj != vObj.rend() && *rObj != m_pLastHitTextObj; rObj++);
//		//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiImIiNhOiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//		for (; rObj != vObj.rend(); rObj++)
//		{
//			FCRichText* pTxt = ((FCObjFigure*)*rObj)->GetRichText();
//			if (pTxt != NULL)
//			//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//				WString strTarget;
//				pTxt->GetText(strTarget);
//				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//				if (pSP->IsMatch(strTarget.c_str()) == 1)
//					myReplaceAllText((FCObjFigure*)*rObj, pSP);
//			}
//		}
//	}
//
//	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDiMiDeDiDiEiBfLiCmMiOhHjCoI_xHqqkZx_ -----
//	WORD wLayerOption = FDOZ_ON_EDIT;
//	if (g_pReg->GetIsReplaceNoDisplayLayer())	// _xZkqqHx_jFfMiOkGjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//		wLayerOption = FDOZ_ON_ANY;
//	else
//	if (g_pReg->GetIsReplaceNoSelectLayer())		// _xZkqqHx_jBeJjBpAjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//		wLayerOption = FDOZ_ON_DRAW;
//	else
//	if (g_pReg->GetIsFindNoEditLayer())			// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//		wLayerOption = FDOZ_ON_SELECT;
//
//	const FCLayerManager* pSheet = g_pDoc->GetCurrentSheet();
//	FCLayerZOrder lzorder;
//	if (g_pView->SelectObjVector().empty())
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIiIoKjEnEiPoDiCmMjFjEjFgJiCmM_xHqqkZx_LZOrder_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		pSheet->FirstFrontLZOrder(lzorder, wLayerOption);
//	} else
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiIoKjEnEiPoDiCmM_xHqqkZx_LZOrder_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		lzorder = g_pDoc->ObjDynabaseToLZOrder(g_pView->SelectObjVector().back());
//	}
//	//----- _xZkqqHx_jBfDiMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	for (; lzorder.dwLayerIdx != DWORD(-1);
//			pSheet->NextBackLZOrder(lzorder, wLayerOption))
//	{
//		FCObjDynabase* pObj = pSheet->LZOrderToObjDynabase(lzorder);
//		if (pObj->IsKindOf(FDOJ_FIGURE))
//		//----- _xZkqqHx_jFjEjFgJiCkK_xHqqkZx_ObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			FCRichText* pTxt = ((FCObjFigure*)pObj)->GetRichText();
//			if (pTxt != NULL)
//			//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//				WString strTarget;
//				pTxt->GetText(strTarget);
//				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//				if (pSP->IsMatch(strTarget.c_str()) == 1)
//					myReplaceAllText((FCObjFigure*)pObj, pSP);
//			}
//		} else
//		if (pObj->IsKindOf(FDOJ_GROUP))
//		//----- _xZkqqHx_jFjEjFgJiCkK_xHqqkZx_ObjGroup_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// ObjGroup_xZkqqHx_jCiGiCmMiBeBjBfDiCmEiCmMjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//			ObjDynabaseVector vObj;
//			//----- _xZkqqHx_iDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAjBmOiPnLiCmJiJmBiCkGiCoJiCkJiBeI_xHqqkZx_ -----
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////			if (g_pReg->GetIsFindChipText())
////				((FCObjGroup*)pObj)->FCObjGroup::GetCanBeTextObject(vObj);
////			else
////				((FCObjGroup*)pObj)->GetCanBeTextObject(vObj);
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//			if (g_pReg->GetIsFindChipText())
//				pObj->GetKindOfMembers(vObj, FDOJ_FIGURE);
//			else
//				((FCObjGroup*)pObj)->GetCanBeTextObject(vObj);
////----- 05.06.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//			// ObjGroup_xZkqqHx_jCiGiCmMiBeBjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiDiLiBfLiDhGiBeC_xHqqkZx_
//			ObjDynabaseVector::reverse_iterator rObj;
//			for (rObj = vObj.rbegin(); rObj != vObj.rend(); rObj++)
//			{
//				FCRichText* pTxt = ((FCObjFigure*)*rObj)->GetRichText();
//				if (pTxt != NULL)
//				//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//					WString strTarget;
//					pTxt->GetText(strTarget);
//					// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBjChFiKlHiPiIjHjNiBeC_xHqqkZx_
//					if (pSP->IsMatch(strTarget.c_str()) == 1)
//						myReplaceAllText((FCObjFigure*)*rObj, pSP);
//				}
//			}
//		}
//	}
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//
//	//----- _xZkqqHx_iMhAjBlBiDfPiDeDiDeBiDiNiDePiCmMiPiIjHjN_xHqqkZx_ -----
//	DWORD dwContinueId;
//	if (!g_pView->SelectObjVector().empty())
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKiCkAiCoJiPoKiNiHiBeBjBkGiClPjDhCjCiGiCkJiCoHjChFiKlHiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
//		g_pView->ClearSelectObj(TRUE);
//		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
//		dwContinueId = CFCDlgReplaceContinueA().DoModal();
//	} else
//	if (1 < g_pDoc->GetSheetManager()->GetSheetIndexSize())
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKjGlDiCkCiPoKiNiHiBeBjBkGiClPiIoKjEnEiPoDiCkJiCoHjChFiKlHiCmMiPoKiNiHiBjFiOjPiDfGiBfLiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
//		dwContinueId = CFCDlgReplaceContinueB().DoModal();
//	} else
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKjGlDiCkCiPoKiNiHiBeBjBkGiClPiIoKjEnEiPoDiCkJiCoHjChFiKlHiCmMiPoKiNiHiBjFiOjPiDfGiBfLiDgHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iBhFjBfDiCmEiCpAjChFiKlHiClFiCnMiClFiClNiBhGiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
//		::FFErrorBox(IDS_MSG_REPLACED_ALL);
//		dwContinueId = 0;
//	}
//	switch (dwContinueId)
//	{
//	case IDC_RLC_BTN_FROM_TOP:		// _xZkqqHx_iBhFiNmEiCnBiPoDiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
//		g_pView->PostMessage(WM_COMMAND, ID_EDIT_REPLACE_TEXT_ALL);
//		break;
//	case IDC_RLC_BTN_NEXT_SHEET:	// _xZkqqHx_iBhFiOjPiDfGiBfLiDgHiBhGiCmMiPoKiNiHiBeC_xHqqkZx_
//	  {
//		SheetID stid = g_pDoc->GetCurrentSheetId();
//		DWORD dwIdx = g_pDoc->GetSheetManager()->SheetIDToIndex(stid);
//		dwIdx++;
//		if (g_pDoc->GetSheetManager()->GetSheetIndexSize() <= dwIdx)
//			dwIdx = 0;
//		// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiBeC_xHqqkZx_
//		OnMoveCurrentSheet(g_pDoc->GetSheetManager()->SheetIndexToID(dwIdx));
//		// _xZkqqHx_jBfDjChFiKlHiMhAjBlBiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiBeC_xHqqkZx_
//		g_pView->PostMessage(WM_COMMAND, ID_EDIT_REPLACE_TEXT_ALL);
//		break;
//	  }
//	}
//} // FCToolSelEdit::OnReplaceTextAll.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnReplaceTextAll ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;

	// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCjFjEjFkKiDgFiDeMiDfIiDgHjBeJjBpAiCkKiOgDiCmBiClNiCnMiCnMjChFiKlHiClHiCoJiCmGiBeB_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDgFiDeMiDfIiDgHiCmFiBeBjChFiKlHjBePiCmMjFjEjFkKiDgFiDeMiDfIiDgHjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	ClearTextSelectionAll(&dc);

	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDiMiDeDiDiEiBfLiCmMiOhHjCoI_xHqqkZx_ -----
	WORD wLayerOption = FDOZ_ON_EDIT;
	if (g_pReg->GetIsReplaceNoDisplayLayer())	// _xZkqqHx_jFfMiOkGjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		wLayerOption = FDOZ_ON_ANY;
	else
	if (g_pReg->GetIsReplaceNoSelectLayer())	// _xZkqqHx_jBeJjBpAjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		wLayerOption = FDOZ_ON_DRAW;
	else
	if (g_pReg->GetIsFindNoEditLayer())			// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCoAjChFiKlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		wLayerOption = FDOZ_ON_SELECT;
	// _xZkqqHx_iMlLiNnNiCmMiDfGiBfLiDgHiCkJiCoHiBeBiMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	g_pDoc->GetCurrentSheet()->GetZOrder(vObj, wLayerOption);
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhGiClFiCmEiBeB_xHqqkZx_ReplaceAllCallback_xZkqqHx_iCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
	// SelectAllCallback_xZkqqHx_iCmFiCmNiBeBiMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjBfDiCmEjBeJjBpAiClHiCoJiBeC_xHqqkZx_
	LoopTextSearch(TRUE, *pSP, vObj, NULL, 0, NULL, ReplaceAllCallback);

	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();

	//----- _xZkqqHx_iMhAjBlBiDfPiDeDiDeBiDiNiDePiCmMiPiIjHjN_xHqqkZx_ -----
	DWORD dwContinueId;
	if (1 < g_pDoc->GetSheetManager()->GetSheetIndexSize())
	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKjGlDiCkCiPoKiNiHiBeBjBkGiClPiIoKjEnEiPoDiCkJiCoHjChFiKlHiCmMiPoKiNiHiBjFiOjPiDfGiBfLiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		dwContinueId = CFCDlgReplaceContinueB().DoModal();
	} else
	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkKjGlDiCkCiPoKiNiHiBeBjBkGiClPiIoKjEnEiPoDiCkJiCoHjChFiKlHiCmMiPoKiNiHiBjFiOjPiDfGiBfLiDgHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFjBfDiCmEiCpAjChFiKlHiClFiCnMiClFiClNiBhGiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
		::FFErrorBox(IDS_MSG_REPLACED_ALL);
		dwContinueId = 0;
	}
	switch (dwContinueId)
	{
	case IDC_RLC_BTN_NEXT_SHEET:	// _xZkqqHx_iBhFiOjPiDfGiBfLiDgHiBhGiCmMiPoKiNiHiBeC_xHqqkZx_
	  {
		SheetID stid = g_pDoc->GetCurrentSheetId();
		DWORD dwIdx = g_pDoc->GetSheetManager()->SheetIDToIndex(stid);
		dwIdx++;
		if (g_pDoc->GetSheetManager()->GetSheetIndexSize() <= dwIdx)
			dwIdx = 0;
		// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiBeC_xHqqkZx_
		OnMoveCurrentSheet(g_pDoc->GetSheetManager()->SheetIndexToID(dwIdx));
		// _xZkqqHx_jBfDjChFiKlHiMhAjBlBiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiBeC_xHqqkZx_
		g_pView->PostMessage(WM_COMMAND, ID_EDIT_REPLACE_TEXT_ALL);
		break;
	  }
	}
} // FCToolSelEdit::OnReplaceTextAll.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHjBfDjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanReplaceTextAllInSelect () const
{
	// FFCanEditSelected_xZkqqHx_iKnGjAjEiCmFiCmNjElLjCgGiClFiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiCmFiCmNiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCmMiDiMiDeDiDiEiBfLiCkKjFnCiPfHjFhDiJmCiCmF_xHqqkZx_
	// _xZkqqHx_iCkAiCmBiCmEiCoAiBeBjChFiKlHiDfPiDeDiDeBiDiNiDePiCmMiDeJiDhGiDfGiDiHiDjDiCpAiOhHjCoIiClHiCoKiCmO_xHqqkZx_
	// _xZkqqHx_jFnCiPfHiJmCjEfMiCmGiCmIiCoJiClNiCnPiBeC_xHqqkZx_

// 05.10.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return !g_pView->SelectObjVector().empty();
	return FFCanEditDocument() && (!g_pView->SelectObjVector().empty());
} // FCToolSelEdit::CanReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnReplaceTextAllInSelect ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;

	// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCjFjEjFkKiDgFiDeMiDfIiDgHjBeJjBpAiCkKiOgDiCmBiClNiCnMiCnMjChFiKlHiClHiCoJiCmGiBeB_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDgFiDeMiDfIiDgHiCmFiBeBjChFiKlHjBePiCmMjFjEjFkKiDgFiDeMiDfIiDgHjBeJjBpAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	ClearTextSelectionAll(&dc);

	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	ObjDynabaseVector vObj = g_pView->SelectObjVector();
	if (!g_pReg->GetIsFindNoEditLayer())
	//----- _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCmNiMjPiNpFiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ObjDynabaseVector::iterator iObj;
		for (iObj = vObj.begin(); iObj != vObj.end();)
		{
			WORD wLayerFlag;
			g_pDoc->GetCurrentSheet()->GetLayerInfo(NULL, &wLayerFlag, g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx);
			// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCmNiMpDjFoCiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
			if (wLayerFlag & FDOZ_ON_EDIT)
				iObj++;
			else
				iObj = vObj.erase(iObj);
		}
	}

	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhGiClFiCmEiBeB_xHqqkZx_ReplaceAllCallback_xZkqqHx_iCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
	// SelectAllCallback_xZkqqHx_iCmFiCmNiBeBiMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjBfDiCmEjBeJjBpAiClHiCoJiBeC_xHqqkZx_
	LoopTextSearch(TRUE, *pSP, vObj, NULL, 0, NULL, ReplaceAllCallback);

	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();

	// _xZkqqHx_iBhFjBfDiCmEiCpAjChFiKlHiClFiCnMiClFiClNiBhGiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
	::FFErrorBox(IDS_MSG_REPLACED_ALL);
} // FCToolSelEdit::OnReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanObjectConvertToPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanObjectConvertToPoly () const
{
	if (!FFCanEditSelected()) return FALSE;
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmFiIoKiCmCiCmFiCoAjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiCmFiCkLiCmIiCkCiCoAiCmMiCkKiCkAiCoKiCmO_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
		if (!(*iObj)->CanDuplicateAs(FDOJ_POLY)) return FALSE;
	return TRUE;
} // FCToolSelEdit::CanObjectConvertToPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnObjectConvertToPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiBhGiCkJiCoHiOmAiNhDiBeCjBeJjBpAiClDiCoKiClNjFjEjFgJiCpA_xHqqkZx_
 *			_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnObjectConvertToPoly ()
{
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jBeJjBpAiCpAiJpAiPjMiBeCjFjEjFgJiCpAjFmPiKlHiClHiCoJiPoKiNiHiBeBiMlDiCmMiDeDiDjDiDfIiDfOiDjDiDfIiCmN_xHqqkZx_
	// _xZkqqHx_iOlIiCoNiCoKiCoJiClNiCnPiBeBjFjEjFgJiDeDiDjDiDfIiDfOiDjDiDfIiCpAjClMjAnKiLeMjIfOiClFiCmEiCkCiCoJ_xHqqkZx_
	// _xZkqqHx_jBeJjBpAjFmPjAjEiCmNiDeOiDiKiDeBiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	const ObjDynabaseVector vSelected = g_pView->SelectObjVector();
	g_pView->ClearSelectObj();
	ObjDynabaseVector vNewSelected;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vSelected.begin();
		 iObj != vSelected.end(); iObj++)
	{
		if ((*iObj)->CanDuplicateAs(FDOJ_POLY))
		//----- _xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiCmFiCkLiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiLeMjIfOiClFiCmEiCkIiCkNiBeCjFmPiKlHiDfCiDhNiDjDiDgIiMoDiCmN_xHqqkZx_ *iObj _xZkqqHx_iCmNjGlDiMpIiCmGiCmIiCoJiClNiCnPiBeC_xHqqkZx_
			DWORD dwObjId = (*iObj)->GetObjID();
			// _xZkqqHx_jFmPiKlHjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(*iObj);
			// _xZkqqHx_jFmPiKlHiDfCiDhNiDjDiDgIiOmAiNhDiBeC_xHqqkZx_
			vNewSelected.push_back(g_pDoc->CmdConvert1Obj(*iObj, FDOJ_POLY));
			// _xZkqqHx_jFmPiKlHiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeCjFmPiKlHjBePiCmGiMgAiPpDiCkKjEpHjGkNiCmJiInJiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
			g_pView->AppendToLastRgn(vNewSelected.back());

			// _xZkqqHx_jFjEjFgJiCkKjBlNiKhAjApMjFjEjFgJiCmJjFmPiKlHiClDiCoKiClNiClNiCnPiBeBiDiCiDiKiDhGiCoAjFmPiCoNiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
			// _xZkqqHx_jCiGiJjLjDfPiDiCiDiKiDhGiImIiKePiCmMiDiCiDiKiDhGiCnGiCmMiDiKiDjDiDeOiCmNiBeBjCiGiJjLjDfPiDiCiDiKiDhGiCnGiCmM_xHqqkZx_
			// _xZkqqHx_iDiKiDjDiDeOiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_

			// _xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkJiCoHiJiEiCnBiCoJiDiKiDjDiDeOiCmMiPfHiNiHiCpAiOoGjDlOiBeC_xHqqkZx_
			DWORDSet stAffected;
			g_pDoc->LinkManager()->GetAffectedByFrom(stAffected,
													 FCMolipRec(dwObjId, -1));
			g_pDoc->LinkManager()->GetAffectedByTo(	stAffected,
													FCMolipRec(dwObjId, -1));
			DWORDSet::iterator iLt;
			for (iLt = stAffected.begin(); iLt != stAffected.end(); iLt++)
			{
				FCLinkRec linkRec = *g_pDoc->LinkManager()->LinkIDtoLinkRec(*iLt);
				BOOL bIsMolipUpdated = FALSE;
				BOOL bIsKindUpdated = FALSE;
				// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiCkKiBeB_xHqqkZx_-1 _xZkqqHx_iImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
				if (linkRec.m_mlpFrom.dwObjID == dwObjId &&
					linkRec.m_mlpFrom.lMolipId != -1)
				{
					bIsMolipUpdated = TRUE;
					linkRec.m_mlpFrom.lMolipId = -1;
				}
				// _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkKiBeB_xHqqkZx_-1 _xZkqqHx_iImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
				if (linkRec.m_mlpTo.dwObjID == dwObjId &&
					linkRec.m_mlpTo.lMolipId != -1)
				{
					bIsMolipUpdated = TRUE;
					linkRec.m_mlpTo.lMolipId = -1;
				}
//----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				// _xZkqqHx_iKhAjDhIiIoKjCoIiCmMiDiKiDjDiDeOiCmNiDiKiDjDiDeOiMlDiBeFiDiKiDjDiDeOjAoGiCkKjCiGjAfDiNmAjFfHiCmJiInKjDkOiClHiCoJiCmG_xHqqkZx_
				// _xZkqqHx_iCkEiCnMiCkNjDkOiNoMiClFiCmIiCkNiCmIiCoJiBeCiClBiCmMiClNiCnPiBeBiLjHjHkDiIoKjCoIiCmJjFmPiNfIiBeC_xHqqkZx_
				if (linkRec.m_wLinkKind == (FDLM_LINK_ON_ANGLE_X|FDLM_LINK_ON_ANGLE_Y))
				{
					bIsKindUpdated = TRUE;
					linkRec.m_wLinkKind = (FDLM_LINK_ON_COORD_X|FDLM_LINK_ON_COORD_Y);
				}
//----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
				// _xZkqqHx_iDiKiDjDiDeOiMlDiBeBiDiKiDjDiDeOjAoGiCmMjFmPiNfIiCpAiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
				if (bIsMolipUpdated)
					g_pDoc->CmdModify1LinkMolip(ObjDynabaseSet(), *iLt, linkRec.m_mlpFrom, linkRec.m_mlpTo);
				if (bIsKindUpdated)
					g_pDoc->CmdModify1LinkKind(*iLt, linkRec.m_wLinkKind);
				// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
				linkRec.ApplyNewOffset();
				// _xZkqqHx_iDiKiDjDiDeOiDeJiDhEiDfKiDgCiDgHjFmPiNfIiCpAjCmKjCgNiClHiCoJiDfCiDhNiDjDiDgIjEkNiNhDiBeC_xHqqkZx_
				g_pDoc->CmdModify1LinkOffset(*iLt, linkRec.m_mmptOffset);
			}
		}
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jAfGiClFiCkCjBeJjBpAjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendSelectObj(vNewSelected);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolSelEdit::OnObjectConvertToPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_GROUP:
	case ID_OBJECT_UNGROUP:
	case ID_OBJECT_PUT_RTF_OBJ:
	case ID_OBJECT_CROSS_SHEET:
	case ID_CHIPEDIT_SET_DUTY:
	case ID_ARROWEDIT_SET_DUTY:
// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	case ID_OBJECT_CONVERT_TO_POLY:
		return TRUE;
	default:
		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
	}
} // FCToolSelEdit::IsObjectCommandEnable.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::OnDrawState (CDC* pDC, int iState)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (iState)
//	{
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiClFiCmIiCkCiCmGiBeBiJeFiDhLiDfOiDjDiCmFiInKjDkOiBeFiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmJ_xHqqkZx_
//	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKjFfMiOkGiBeBiInKjDkOjCiGiCmMiDeDiDiBiBfLiDfHiCpAiJeCiClFiClNiPoKiNiHiBeB_xHqqkZx_
//	// _xZkqqHx_iPiIjHjNiDeMiDiDiDjDiDfKiDiLiMoDiCmJiDfDiDhOiCkKiOgDiCoJiBeC_xHqqkZx_
//	case STATE_STOP_MOVE_OBJ_2:		// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
//	case STATE_CONTEXT_MENU_3:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
//		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
//// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		OnDrawMovingImageXXX(XXX_OBJ_BASE, pDC);
//		RedrawMovingImageXXX(XXX_OBJ_BASE, DBLPoint(0,0), pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//		break;
//	default:
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiClFiCmIiCkCiCmGiBeBiJeFiDhLiDfOiDjDiCmFiInKjDkOiBeFiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmJ_xHqqkZx_
	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKjFfMiOkGiBeBiInKjDkOjCiGiCmMiDeDiDiBiBfLiDfHiCpAiJeCiClFiClNiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_iPiIjHjNiDeMiDiDiDjDiDfKiDiLiMoDiCmJiDfDiDhOiCkKiOgDiCoJiBeC_xHqqkZx_
	case STATE_STOP_MOVE_OBJ_2:		// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	case STATE_CONTEXT_MENU_3:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
		RedrawMovingImageXXX(XXX_OBJ_BASE, DBLPoint(0,0), pDC);
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolSelEdit::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	case STATE_MOVING_OBJ:			// _xZkqqHx_jFjEjFgJiInKjDkOjCiGiBeC_xHqqkZx_
	case FCToolSelectTmpl<FCToolBaseFDA, FCObjDynabase*, FCToolSelectObjTmplId>::STATE_MOVING_XXX:			// _xZkqqHx_jFjEjFgJiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_RBUTTONUP:		// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_MOVE_OBJ_2;	// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MOVE_OBJ_2:		// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_CONTEXTMENU:	// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			iNextState = STATE_CONTEXT_MENU_3;		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_CONTEXT_MENU_3:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_COMMAND:	// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			iNextState = STATE_MOVE_DUP_COMMAND;	// _xZkqqHx_iInKjDkOjFkBjAlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_MOVE_DUP_COMMAND:	// _xZkqqHx_iInKjDkOjFkBjAlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolSelEdit::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_STOP_MOVE_OBJ_2:		// _xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateStopMoveObj2(pDC);
		break;
	case STATE_CONTEXT_MENU_3:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
		StateContextMenu3(pDC);
		break;
	case STATE_MOVE_DUP_COMMAND:	// _xZkqqHx_iInKjDkOjFkBjAlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		StateMoveDupCommand(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolSelEdit::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::StateExitToolByButton
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::StateExitToolByButton (CDC* pDC)
{
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	TRACE(_T("FCToolSelEdit::StateExitToolByButton\r\n"));
//	// _xZkqqHx_iDhLiDfOiDjDiCmMiDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
//	SetLockStatus(FALSE);
//	//----- _xZkqqHx_jFlGiOjKiPoDiCmFiCmMiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCkJiBeBiClLiCmMjBlMiCmMiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCkJiBeI_xHqqkZx_ -----
//	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiDgFiDeMiDfIiDgHiPoDiCmF_xHqqkZx_DBL_xZkqqHx_iDeOiDiKiDgCiDeOiCmIiCoHiCmOiDgFiDeMiDfIiDgHjFnCiPfHiDiCiBfLiDgIiBeC_xHqqkZx_
//	if (g_pView->GetLastSelectObj() != NULL &&
//		g_pView->GetLastSelectObj()->IsTextIntersect(g_pView->GetLastPoint()))
//	{
//		// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCnGjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
//		g_pView->PostMessage(WM_COMMAND, ID_TOOL_EDIT_RICH_TEXT, 0L);
//		return;
//	}
//	// _xZkqqHx_jFjEjFgJjFnCiPfHiDgDiBfLiDiLiCnGjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
//	g_pView->PostMessage(WM_COMMAND, ID_TOOL_ANY_EDIT, 0L);
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	TRACE(_T("FCToolSelEdit::StateExitToolByButton\r\n"));
	//----- _xZkqqHx_jFlGiOjKiPoDiCmFiCmMiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCkJiBeBiClLiCmMjBlMiCmMiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCkJiBeI_xHqqkZx_ -----
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiDgFiDeMiDfIiDgHiPoDiCmF_xHqqkZx_DBL_xZkqqHx_iDeOiDiKiDgCiDeOiCmIiCoHiCmOiDgFiDeMiDfIiDgHjFnCiPfHiDiCiBfLiDgIiBeC_xHqqkZx_
	if (g_pView->GetLastSelectObj() != NULL &&
		g_pView->GetLastSelectObj()->IsTextIntersect(g_pView->GetLastPoint()))
	{
		// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
		SetNextTool(ID_TOOL_EDIT_RICH_TEXT);
	} else
	{
		// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJjFjEjFgJjFnCiPfHiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
		SetNextTool(ID_TOOL_ANY_EDIT);
	}
	// _xZkqqHx_iDhLiDfOiDjDiCmMiDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	SetLockStatus(FALSE);
	// _xZkqqHx_iDgDiBfLiDiLjFmPiNfIiBeC_xHqqkZx_
	EndOfSession();
//----- 06.04.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::StateExitToolByButton.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::StateStopMoveObj2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiInKjDkOiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::StateStopMoveObj2 (CDC* pDC)
{
	TRACE(_T("FCToolSelEdit::StateStopMoveObj2\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	// _xZkqqHx_jFjEjFgJjBeJjBpAiPgPiMpLiKnGjAjEiCpAiOmAiNhDiBeCiDeMiDiDiDhGiDgAiDiDiDiKiDiKiBfLiDfIiCmGiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjEpBjFfMiOkGiCmMiPiIjHjNiBeC_xHqqkZx_
	StateExitSelectXXX(XXX_OBJ_BASE, pDC);
} // FCToolSelEdit::StateStopMoveObj2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::StateContextMenu3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__3_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::StateContextMenu3 (CDC* pDC)
{
	TRACE(_T("FCToolSelEdit::StateContextMenu3\r\n"));
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
// 06.02.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFPopupSubmenu(m_mmptMsc, IDR_RBTN_TOOL, FD_MENU_TOOL_SEL_EDIT_MOVE_OBJ, AfxGetMainWnd());
	FFPopupSubmenu(m_mmptMsc, IDR_RBTN_TOOL, FD_MENU_TOOL_SEL_EDIT_MOVE_OBJ, FFGetMainWnd()->GetWnd());
	// _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeBiDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCmM_xHqqkZx_
	// _xZkqqHx_iCkCiClIiCoKiCoAjBeJiCmOiCoKiCmIiCkJiCmBiClNiOjOiCmJiPpDjBnEjBeKiInKiCmFiCkLiClIiDiNiDgCiDeOiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	AfxGetMainWnd()->PostMessage(WM_COMMAND, ID_TLCMD_POPUPMENU_ENDED, 0);
} // FCToolSelEdit::StateContextMenu3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::StateMoveDupCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjFkBjAlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelEdit::StateMoveDupCommand (CDC* pDC)
{
	TRACE(_T("FCToolSelEdit::StateMoveDupCommand\r\n"));
	//----- _xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGjHhA_xHqqkZx_CDC_xZkqqHx_iNoMjAkM_xHqqkZx_ -----
	CDC	dcMem;
	dcMem.CreateCompatibleDC(pDC);
	CBitmap* pbmOld = dcMem.SelectObject(&m_coMoveBit);
	//----- _xZkqqHx_jBePiJpBiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCpAiPmBiClH_xHqqkZx_ -----
	FCAutoDC(pDC).BitBlt(mm2lg(m_mmptBitLT.x), mm2lg(m_mmptBitLT.y),
						mm2lg(m_mmBitWidth), mm2lg(m_mmBitHeight), &dcMem, 0, 0, SRCINVERT);
	//----- _xZkqqHx_iMlDiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCmJjGnPiClFiCmEiBeBiPeJjHlJ_xHqqkZx_ -----
	dcMem.SelectObject(pbmOld);
	dcMem.DeleteDC();
	// _xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
	m_coMoveBit.DeleteObject();

	//----- _xZkqqHx_iDfCiDhNiDjDiDgIjFmKiCmMiPiIjHjN_xHqqkZx_ -----
	WORD wLinkKind = WORD(-1);
	switch (m_dwCommand)
	{
	case ID_TLCMD_MOVE_OBJECT:
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiInKjDkOiBeC_xHqqkZx_
// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		StateDoMoveObj(pDC);
		StateDoMoveXXX(XXX_OBJ_BASE, pDC);
		break;
	case ID_TLCMD_DUPLICATE_OBJECT:
	  {
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->SessionBegin();
		// _xZkqqHx_iDiKiDjDiDeOiCmMjFkBjAlLjHhAiDiKiDjDiDeOiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
		FCLinkManager lnkMgr;
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmJiKnGiCoNiCoJiDiKiDjDiDeOiCpAjFkBjAlLiClHiCoJiBeC_xHqqkZx_
		FCLinkManager::CopyToSubTable(&lnkMgr, g_pDoc->LinkManager(),
										g_pView->SelectObjVector());
		// _xZkqqHx_jFkBjAlLiDiKiDjDiDeOjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_jFmPiKlHiCmJiOgHjHhAiClHiCoJjFjEjFgJiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		FCObjIDTbl idtable;
		ObjDynabaseVector vObj;
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = g_pView->SelectObjVector().begin();
			 iObj != g_pView->SelectObjVector().end(); iObj++)
		{
			FCObjDynabase* pObj = (FCObjDynabase*)(*iObj)->Duplicate();
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			pObj->RegisterObjID();
			// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
			g_pDoc->MulticmdCreate1Obj(pObj, g_pDoc->GetCurrentSheetId(), LAST_LAYER_ORDER);
			vObj.push_back(pObj);
			// _xZkqqHx_jFjEjFgJiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmJjFjEjFgJjDgPjIfOiBeCjFkBjAlLjBeP_xHqqkZx_ID_xZkqqHx_iCmFjDgPjIfOiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
			idtable.Register(pObj, (*iObj)->GetObjID());
		}
		// _xZkqqHx_iDiKiDjDiDeOiDhNiDgMiBfLiDfHiDiDiCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmMiDiKiDjDiDeOjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFmPiKlHiClFiBeB_xHqqkZx_
		// _xZkqqHx_iDiBiDeDiDjDiDgFiBfLiDhFiDiLiCnGjCmHiJmBiBeCjFjEjFgJjAlGjAkMiDfCiDhNiDjDiDgIjEkNiNhDiMoDiCmFiCmIiCkCiCmGjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
		FCLinkManager::ConvertSubToMain(&lnkMgr, &idtable);
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
		g_pView->ClearSelectObj(pDC);
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiBeC_xHqqkZx_
		g_pView->AppendSelectObj(vObj);
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiInKjDkOiBeC_xHqqkZx_
		StateDoMoveXXX(XXX_OBJ_BASE, pDC);
		// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMiPoKiNiHiBeBiClHiCkOjFnCiPfHiPiIjHjNiCmJjDpMiCoJiBeC_xHqqkZx_
		// DDPro_xZkqqHx_iCmFiOgHiCkEiPoKiNiHiBeBiDiJiDhIiDiLjFjEjFgJiCmNjFkBiOmKiClFiCmEjFpKjChFiClHiCoJiCmG_xHqqkZx_
		// _xZkqqHx_iDiJiDhIiDiLiCkKjFmPiNfIiClDiCoKiCmIiCkCiCnMiCnMiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiPgPiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClHiCkOjFmPiNfIiClHiCoKiCmOiBeBjAfGiClFiCkCjDoAjHgFiCmFjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
		if (vObj.size() == 1 &&
			vObj.front()->IsKindOf(FDOJ_LABEL))
		{
			// _xZkqqHx_iOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
			SetNextTool(ID_TOOL_EDIT_RICH_TEXT);
			// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
			SetLockStatus(FALSE);
			// _xZkqqHx_iDgDiBfLiDiLjFmPiNfIiBeC_xHqqkZx_
			EndOfSession();
		}
//----- 06.04.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		break;
	  }
	}
} // FCToolSelEdit::StateMoveDupCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::CanLinkToSelection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Idle_xZkqqHx_iCmF_xHqqkZx_CTRL+MSMOVE_xZkqqHx_iCmFiDiKiDjDiDeOiCkKjCkDiCoKiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::CanLinkToSelection () const
{
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetCurrentState() == STATE_IDLE &&
//		!g_pView->SelectObjVector().empty()) return TRUE;
//	return FALSE;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return (GetCurrentState() == STATE_IDLE ||
			GetCurrentState() == STATE_CONTEXT_MENU ||
			GetCurrentState() == STATE_CONTEXT_MENU_LINK) &&
			!g_pView->SelectObjVector().empty();
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelEdit::CanLinkToSelection.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelEdit::ReplaceAllCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FTCallbackLoopTextSearch_xZkqqHx_iMfOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeCiDgFiDeMiDfIiDgHjBfDjChFiKlH_xHqqkZx_
 *			_xZkqqHx_iCmJiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp		:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTextObj:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDiLiBfLiDhGiCpAiMhAjBlBiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiDfCiBfLiDiLiDgPiDgCiDeOjClMiMoDiCmJiPeJjHlJiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pTextObj_xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCmMiPoKiNiHiCoAiCkAiCoJiBeCjFeLiClIiDgFiDeMiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOjNiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelEdit::ReplaceAllCallback (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC)
{
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjChFiKlHiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->BeforeCmdModifyAbcRichText(pTextObj);
	// _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiBeC_xHqqkZx_
	BYTEVector byvQueue;
	pTextObj->GetRichText()->ReplaceAll(byvQueue, sp, pTextObj);
	if (!byvQueue.empty())
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiBgJjChFiKlHiClDiCoKiClNjFlGiOjKiCkKiCkAiCoJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		g_pDoc->CmdModifyAbcRichText(pTextObj, byvQueue.size(), byvQueue.begin());
		if (pTextObj->IsKindOf(FDOJ_LABEL))
		{
			// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjFmPiNfIiOjOiKnEiCmMiLeMjIfOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyLabel((FCObjLabel*)pTextObj,
									FCLabelRec(FDFP_LABELMTIME, FFGetCurrentTime(), 0));
		}
		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pTextObj);
	}
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_iOjPiCmMiMjPiNpFiCpAjBlBiCkPiCoJiBeC_xHqqkZx_
	return TRUE;
} // FCToolSelEdit::ReplaceAllCallback.
