#ifndef __ToolSelectObjTmpl_h
#define __ToolSelectObjTmpl_h

#include "stdafx.h"
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ObjFigure.h"			// For FCObjFigure.
#include "UtilStdLib.h"			// For FFInsert.
// 06.12.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "FoundDoc.h"			// For g_pDoc.
#include "ToolSelectTmpl.h"		// For Superclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCToolSelectTmpl<SUPER, FCObjDynabase*, T_IDENTIFY>

// FCToolSelectTmpl _xZkqqHx_iCmMiDgFiDjDiDhGiDiMiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAjCoIiLgAiBeC_xHqqkZx_
typedef struct FCToolSelectObjTmplId {} *XXX_ObjDynabase;
#define XXX_OBJ_BASE		XXX_ObjDynabase(NULL)

template<class SUPER, class T_IDENTIFY> class FCToolSelectObjTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCToolSelectObjTmpl (WORD wOperation = FDOZ_ON_SELECT);
	//----- FCToolBase_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void		OnSelectNext ();

protected:
	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjAhL_xHqqkZx_ -----
	virtual FCObjDynabase*	InvalidValueXXX (T_IDENTIFY*) const;
	virtual long		GetSelectedXXX (T_IDENTIFY*, vector<FCObjDynabase*>* vXxx = NULL, set<FCObjDynabase*>* stXxx = NULL) const;
	virtual long		GetSelectableXXX (T_IDENTIFY*, vector<FCObjDynabase*>* vXxx = NULL) const;
	virtual void		SelectXXX (T_IDENTIFY*, FCObjDynabase* pObj, CDC* pDC);
	virtual void		UnselectXXX (T_IDENTIFY*, FCObjDynabase* pObj, CDC* pDC);
	virtual DBLRect		GetFrameRectXXX (T_IDENTIFY*, FCObjDynabase* pObj) const;
	virtual FCObjDynabase*	GetLastSelectedXXX (T_IDENTIFY*);
	virtual void		SetLastSelectedXXX (T_IDENTIFY*, FCObjDynabase* xxx);
	virtual BOOL		IsIntersectXXX (T_IDENTIFY*, FCObjDynabase* pObj, const DBLPoint& mmpt) const;

	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual bool		IsLessKindOfXXX (T_IDENTIFY*, FCObjDynabase* v0, FCObjDynabase* v1) const;

	//----- FCToolSelectObjTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void		SetOperationFlag (T_IDENTIFY*, WORD wOperation);
	virtual FCObjDynabase*	GetLastSelectLocalObj ();

protected:
	WORD		m_wOperation;	// _xZkqqHx_jFjEjFgJiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiBeCiDfEiDhFiDeOiDiJiDfIjHhAiBeC_xHqqkZx_
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	BOOL		m_bIsOnSelectNext;	// OnSelectNext_xZkqqHx_iCpAiOmAiNhDjCiGiCkJiBeI_xHqqkZx_
}; // class FCToolSelectObjTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::FCToolSelectObjTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wOperation	:_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjFjEjFgJiCmJiNhDiCkEjBiAiNoMiCmMiDhEiDiJiDePiBeC_xHqqkZx_
 *						 Subclass(ToolRotate)_xZkqqHx_iCmFiBeBiIoBiCkEjBiAiNoMjBmOiPnLiCpAjBeJjBpAiClHiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::FCToolSelectObjTmpl (WORD wOperation)
							:BASE_CLASS(),
							m_wOperation(wOperation),
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
							m_bIsOnSelectNext(FALSE)	// OnSelectNext_xZkqqHx_iCpAiOmAiNhDjCiGiCkJiBeI_xHqqkZx_
{
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::FCToolSelectObjTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::OnSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiOjPiCpAjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
void FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::OnSelectNext ()
{
	// OnSelectNext_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_bIsOnSelectNext = TRUE;

	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSelectNext();

	// OnSelectNext_xZkqqHx_iCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_bIsOnSelectNext = FALSE;
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::OnSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::InvalidValueXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
FCObjDynabase* FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::InvalidValueXXX (T_IDENTIFY*) const
{
	return NULL;
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::InvalidValueXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector/set _xZkqqHx_iCmMiCkCiClIiCoKiCmMiMgAiOkOiCmFiCoAjCgMiCpAjFnEiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
long FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectedXXX (T_IDENTIFY*, vector<FCObjDynabase*>* vXxx, set<FCObjDynabase*>* stXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		*vXxx = g_pView->SelectObjVector();
	}
	if (stXxx != NULL)
	//----- stXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		stXxx->clear();
		FFInsert(*stXxx, g_pView->SelectObjVector());
	}
	return g_pView->SelectObjVector().size();
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectableXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
long FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectableXXX (T_IDENTIFY*, vector<FCObjDynabase*>* vXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		g_pDoc->GetZOrder(*vXxx, m_wOperation, 0, g_pDoc->GetCurrentLayerIdx());
		return vXxx->size();
	} else
	//----- vXxx _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return g_pDoc->GetZOrderSize(m_wOperation, 0, g_pDoc->GetCurrentLayerIdx());
	}
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetSelectableXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
void FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SelectXXX (T_IDENTIFY*, FCObjDynabase* pObj, CDC* pDC)
{
	g_pView->AppendSelectObj(pObj, pDC);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SelectXXX((T_IDENTIFY*)NULL, pObj, pDC);
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
void FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::UnselectXXX (T_IDENTIFY*, FCObjDynabase* pObj, CDC* pDC)
{
	if (pObj == InvalidValueXXX((T_IDENTIFY*)NULL))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->ClearSelectObj(pDC);
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		g_pView->RemoveSelectObj(pObj, pDC);
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnselectXXX((T_IDENTIFY*)NULL, pObj, pDC);
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetFrameRectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
DBLRect FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetFrameRectXXX (T_IDENTIFY*, FCObjDynabase* pObj) const
{
	return pObj->GetResizeFrame();
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetFrameRectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
FCObjDynabase* FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectedXXX (T_IDENTIFY*)
{
	return g_pView->GetLastSelectObj();
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
void FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetLastSelectedXXX (T_IDENTIFY*, FCObjDynabase* xxx)
{
	g_pView->SetLastSelectObj(xxx);
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsIntersectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlHiClHiCoJiCkJjClCiNlIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
BOOL FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsIntersectXXX (T_IDENTIFY*, FCObjDynabase* pObj, const DBLPoint& mmpt) const
{
	// OnSelectNext_xZkqqHx_iCpAiOmAiNhDjCiGiCmIiCoHiCmOiBeBjDgIiCoIiCmCiCnEiClFjAhNiMgAiCmGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
	return pObj->IsIntersect(mmpt, m_bIsOnSelectNext);
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsIntersectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsLessKindOfXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCObjDynabase*_xZkqqHx_iMfOiCmMiCfBjCgMiCpAiBeBjCgMiCmMiOoNjFmKiCmGiClFiCmEjEoEiKhCiClFiBeB_xHqqkZx_v0 < v1 _xZkqqHx_iCmMiPoKiNiHiCmMiCnN_xHqqkZx_
 *			ture_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	v0	:_xZkqqHx_jEoEiKhCjBmOiPmGiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v1	:_xZkqqHx_jEoEiKhCjBmOiPmGiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	v0 < v1 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ture_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_false_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnSelectSameKindOfObject_xZkqqHx_iKnGjAjEiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
bool FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsLessKindOfXXX (T_IDENTIFY*, FCObjDynabase* v0, FCObjDynabase* v1) const
{
	// _xZkqqHx_jDkPiClGjFjEjFgJiCmMiPoKiNiHiCmN_xHqqkZx_false_xZkqqHx_iBeC_xHqqkZx_v0,v1_xZkqqHx_iCmJ_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBjFeLiClIiClBiCmMiPiIjHjNiCpAjDpMiCoKiCoJiBeC_xHqqkZx_
	if (v0 == v1) return false;
	if (long(v0->Type()) < long(v1->Type())) return true;
	if (long(v0->Type()) > long(v1->Type())) return false;
	if (!v0->IsKindOf(FDOJ_FIGURE)) return false;
	const FCObjFigure* fig0 = (const FCObjFigure*)v0;
	const FCObjFigure* fig1 = (const FCObjFigure*)v1;
	if (long(fig0->IsClosePolygon()) < long(fig1->IsClosePolygon())) return true;
	if (long(fig0->IsClosePolygon()) > long(fig1->IsClosePolygon())) return false;
	if (long(fig0->GetPenRegister()) < long(fig1->GetPenRegister())) return true;
	if (long(fig0->GetPenRegister()) > long(fig1->GetPenRegister())) return false;
	if (long(fig0->GetPenStyle()) < long(fig1->GetPenStyle())) return true;
	if (long(fig0->GetPenStyle()) > long(fig1->GetPenStyle())) return false;
	if (long(fig0->GetPenWeight()) < long(fig1->GetPenWeight())) return true;
	if (long(fig0->GetPenWeight()) > long(fig1->GetPenWeight())) return false;
	if (long(fig0->GetPenBackSColor()) < long(fig1->GetPenBackSColor())) return true;
	if (long(fig0->GetPenBackSColor()) > long(fig1->GetPenBackSColor())) return false;
	if (long(fig0->GetBrushRegister()) < long(fig1->GetBrushRegister())) return true;
	if (long(fig0->GetBrushRegister()) > long(fig1->GetBrushRegister())) return false;
	if (long(fig0->GetBrushForeSColor()) < long(fig1->GetBrushForeSColor())) return true;
	if (long(fig0->GetBrushForeSColor()) > long(fig1->GetBrushForeSColor())) return false;
	if (long(fig0->GetBrushPattern()) < long(fig1->GetBrushPattern())) return true;
	if (long(fig0->GetBrushPattern()) > long(fig1->GetBrushPattern())) return false;
	if (long(fig0->GetBrushBackSColor()) < long(fig1->GetBrushBackSColor())) return true;
	if (long(fig0->GetBrushBackSColor()) > long(fig1->GetBrushBackSColor())) return false;
	if (long(fig0->GetShadowSColor()) < long(fig1->GetShadowSColor())) return true;
	if (long(fig0->GetShadowSColor()) > long(fig1->GetShadowSColor())) return false;
	if (long(fig0->GetEmfHorzMap()) < long(fig1->GetEmfHorzMap())) return true;
	if (long(fig0->GetEmfHorzMap()) > long(fig1->GetEmfHorzMap())) return false;
	if (long(fig0->GetEmfVertMap()) < long(fig1->GetEmfVertMap())) return true;
	if (long(fig0->GetEmfVertMap()) > long(fig1->GetEmfVertMap())) return false;
	if (long(fig0->GetEmfImage()) < long(fig1->GetEmfImage())) return true;
	if (long(fig0->GetEmfImage()) > long(fig1->GetEmfImage())) return false;
	if (long(fig0->GetArrowFType()) < long(fig1->GetArrowFType())) return true;
	if (long(fig0->GetArrowFType()) > long(fig1->GetArrowFType())) return false;
	if (long(fig0->GetArrowFParam0()) < long(fig1->GetArrowFParam0())) return true;
	if (long(fig0->GetArrowFParam0()) > long(fig1->GetArrowFParam0())) return false;
	if (long(fig0->GetArrowFParam1()) < long(fig1->GetArrowFParam1())) return true;
	if (long(fig0->GetArrowFParam1()) > long(fig1->GetArrowFParam1())) return false;
	if (long(fig0->GetArrowFParam2()) < long(fig1->GetArrowFParam2())) return true;
	if (long(fig0->GetArrowFParam2()) > long(fig1->GetArrowFParam2())) return false;
	if (long(fig0->GetPictArrowF()) < long(fig1->GetPictArrowF())) return true;
	if (long(fig0->GetPictArrowF()) > long(fig1->GetPictArrowF())) return false;
	if (long(fig0->GetArrowBType()) < long(fig1->GetArrowBType())) return true;
	if (long(fig0->GetArrowBType()) > long(fig1->GetArrowBType())) return false;
	if (long(fig0->GetArrowBParam0()) < long(fig1->GetArrowBParam0())) return true;
	if (long(fig0->GetArrowBParam0()) > long(fig1->GetArrowBParam0())) return false;
	if (long(fig0->GetArrowBParam1()) < long(fig1->GetArrowBParam1())) return true;
	if (long(fig0->GetArrowBParam1()) > long(fig1->GetArrowBParam1())) return false;
	if (long(fig0->GetArrowBParam2()) < long(fig1->GetArrowBParam2())) return true;
	if (long(fig0->GetArrowBParam2()) > long(fig1->GetArrowBParam2())) return false;
	if (long(fig0->GetPictArrowB()) < long(fig1->GetPictArrowB())) return true;
	return false;
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::IsLessKindOfXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetOperationFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBiAiNoMiJmCjEfMiCmIjFjEjFgJiCmMiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wOperation	:_xZkqqHx_iDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeOiDfKiDfIiLjGiJmCiCpAiOjNiCmCiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCmMiCnNiCkKiBeBjBiAiNoMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
void FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetOperationFlag (T_IDENTIFY*, WORD wOperation)
{
	m_wOperation = wOperation;
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::SetOperationFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectLocalObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_IDENTIFY>
FCObjDynabase* FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectLocalObj ()
{
	return GetLastSelectedXXX((T_IDENTIFY*)NULL);
} // FCToolSelectObjTmpl<SUPER, T_IDENTIFY>::GetLastSelectLocalObj.

#endif//__ToolSelectObjTmpl_h
