#ifndef __ToolSelectTmpl_h
#define __ToolSelectTmpl_h

#include "stdafx.h"
#include <algorithm>			// For sort template.
#include "DynamicDrawView.h"	// For g_pView.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "RegData.h"			// For g_pReg.
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilMisc.h"			// For FFSetCapture.etc.
#include "UtilDlg.h"			// For FFPopupSubmenu.
#include "UtilStdLib.h"			// For FFInsert.
#include "UtilObj.h"			// For FFGetFramePoint.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS SUPER

// FCToolSelectTmpl _xZkqqHx_iCmMiDgFiDjDiDhGiDiMiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAjCoIiLgAiBeC_xHqqkZx_
struct FCToolSelectTmplId_0 {};

template<class T_OWNER, class T_TYPE, class T_IDENTIFY> class myLessKindOf;

template<class SUPER, class T_TYPE, class T_IDENTIFY = FCToolSelectTmplId_0> class FCToolSelectTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	FCToolSelectTmpl ();

	//----- FCToolBase_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDraw (CDC* pDC);
	virtual void	Select (CDC* pDC);
// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	IsObjectCommandEnable (DWORD dwCmdID) const;
	virtual BOOL	CanSelectAll () const;
	virtual void	OnSelectAll ();
	virtual BOOL	CanClearSelect () const;
	virtual void	OnClearSelect ();
	virtual BOOL	CanSelectSameKindOfObject () const;
	virtual void	OnSelectSameKindOfObject ();
	virtual BOOL	CanSelectNext () const;
	virtual void	OnSelectNext ();

//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanObjectMoveSnapLeft () const;
	virtual void	OnObjectMoveSnapLeft ();
	virtual BOOL	CanObjectMoveSnapUp () const;
	virtual void	OnObjectMoveSnapUp ();
	virtual BOOL	CanObjectMoveSnapRight () const;
	virtual void	OnObjectMoveSnapRight ();
	virtual BOOL	CanObjectMoveSnapDown () const;
	virtual void	OnObjectMoveSnapDown ();
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

friend class myLessKindOf<FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>, T_TYPE, T_IDENTIFY>;
protected:
	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjAhL_xHqqkZx_ -----
	virtual T_TYPE	InvalidValueXXX (T_IDENTIFY*) const = NULL;
	virtual long	GetSelectedXXX (T_IDENTIFY*, vector<T_TYPE>* vXxx = NULL, set<T_TYPE>* stXxx = NULL) const = NULL;
	virtual long	GetSelectableXXX (T_IDENTIFY*, vector<T_TYPE>* vXxx = NULL) const = NULL;
	virtual void	SelectXXX (T_IDENTIFY*, T_TYPE xxx, CDC* pDC);
	virtual void	UnselectXXX (T_IDENTIFY*, T_TYPE xxx, CDC* pDC);
	virtual DBLRect	GetFrameRectXXX (T_IDENTIFY*, T_TYPE xxx) const = NULL;

//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFiBeB_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiPoKiNiHiCmNjFeLjAhL_xHqqkZx_ -----
	virtual BOOL	CanMoveXXX (T_IDENTIFY*) const;
	virtual void	DrawFirstImageXXX (T_IDENTIFY*, CDC* pDC);
	virtual void	RedrawMovingImageXXX (T_IDENTIFY*, const DBLPoint& mmptMove, CDC* pDC);
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDrawMovingImageXXX (T_IDENTIFY*, CDC* pDC);
	virtual void	DrawLastImageXXX (T_IDENTIFY*, CDC* pDC);
	virtual void	MoveXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, const DBLPointVector& vmmptMove);
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- FCToolSelectTmpl_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void	SelectXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, CDC* pDC);
	virtual void	SelectAllXXX (T_IDENTIFY*, CDC* pDC);
	virtual BOOL	IsSelectedXXX (T_IDENTIFY*, T_TYPE xxx) const;
	virtual T_TYPE	GetLastSelectedXXX (T_IDENTIFY*);
	virtual void	SetLastSelectedXXX (T_IDENTIFY*, T_TYPE xxx);
	virtual BOOL	IsIntersectXXX (T_IDENTIFY*, T_TYPE xxx, const DBLPoint& mmpt) const;
	virtual void	GetRectInXXX (T_IDENTIFY*, vector<T_TYPE>& vXxx, const DBLRect& mmrt) const;
	virtual BOOL	CheckHitXXX (T_IDENTIFY*, T_TYPE* hitXxx = NULL);
	virtual BOOL	CheckHitNextXXX (T_IDENTIFY*, T_TYPE* hitXxx, T_TYPE lastXxx);
	virtual bool	IsLessKindOfXXX (T_IDENTIFY*, T_TYPE v0, T_TYPE v1) const;

	virtual T_TYPE	GetHitXXX (T_IDENTIFY*) const;
	virtual void	SetHitXXX (T_IDENTIFY*, T_TYPE xxx);

// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	MoveXXXSnap (T_IDENTIFY*, long lHorzDirection, long lVertDirection);
// 05.09.06 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	MoveXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, const DBLPoint& mmptMove);

protected:
	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnDrawState (CDC* pDC, int iState);
	virtual int		TransFDA (int iState, int iEvent);
	virtual void	StateFDA (int iState, CDC* pDC);

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjN_xHqqkZx_ -----
	virtual void	StateEnterSelectXXX (T_IDENTIFY*, CDC* pDC);		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
	virtual void	StatePreUnselXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
	virtual void	StateSetLastXXX (T_IDENTIFY*, CDC* pDC);			// _xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
	virtual void	StateUnselXXX (T_IDENTIFY*, CDC* pDC);				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiBeC_xHqqkZx_
	virtual void	StateClrselSelXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
	virtual void	StateExitSelectXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_

	virtual void	StateStartEncloseXXX (T_IDENTIFY*, CDC* pDC);		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
	virtual void	StateEnclosingXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
	virtual void	StateStopEncloseXXX (T_IDENTIFY*, CDC* pDC);		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
	virtual void	StateWaitMenuEncloseXXX (T_IDENTIFY*, CDC* pDC);	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiBeC_xHqqkZx_
	virtual void	StatePopupMenuEncloseXXX (T_IDENTIFY*, CDC* pDC);	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
	virtual void	StateStopMenuEncloseXXX (T_IDENTIFY*, CDC* pDC);	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiBeC_xHqqkZx_

//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	StateStartMoveXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
	virtual void	StateMovingXXX (T_IDENTIFY*, CDC* pDC);				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
	virtual void	StateStopMoveXXX (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
	virtual void	StateDoMoveXXX (T_IDENTIFY*, CDC* pDC);				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
	virtual void	StateDoMoveXXXSnap (T_IDENTIFY*, CDC* pDC);			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

protected:
// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMjCoIiLgAiBeC_xHqqkZx_
enum
{
	STATE_BEGIN = BASE_CLASS::STATE_END,	// _xZkqqHx_iPpDjBnEiKeKiOgOiBeC_xHqqkZx_
	STATE_ENTER_SELECT_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
	STATE_PRE_UNSEL_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
	STATE_SET_LAST_XXX,				// _xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
	STATE_UNSEL_XXX,				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiBeC_xHqqkZx_
	STATE_CLRSEL_SEL_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
	STATE_EXIT_SELECT_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_

	STATE_BEFORE_ENCLOSE_XXX,		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
	STATE_CANCEL_ENCLOSE_XXX,		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
	STATE_START_ENCLOSE_XXX,		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
	STATE_ENCLOSING_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
	STATE_STOP_ENCLOSE_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
	STATE_WAIT_MENU_ENCLOSE_XXX,	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiBeC_xHqqkZx_
	STATE_POPUP_MENU_ENCLOSE_XXX,	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
	STATE_STOP_MENU_ENCLOSE_XXX,	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiBeC_xHqqkZx_

//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	STATE_START_MOVE_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
	STATE_MOVING_XXX,				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
	STATE_STOP_MOVE_XXX,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
	STATE_DO_MOVE_XXX,				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
	STATE_DO_MOVE_XXX_SNAP,			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	STATE_END,						// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

private:
	T_TYPE	m_hitXxx;				// _xZkqqHx_iDhNiDeFiDfIiDhBiDgCiDgHiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	T_TYPE	m_lastSelectedXxx;		// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_

protected:
	//----- XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjHhAiCmMiNmAjFfHjFmPjAjE_xHqqkZx_ -----
	DBLPoint	m_mmptButtonDownFirst;	// _xZkqqHx_iNmFiPiJiCmJiDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmMiNmAjFfHiBeC_xHqqkZx_
	DBLRect		m_mmrtFirstFrame;		// _xZkqqHx_iNmFiPiJiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiImKjChFiCmMiDhEiDiMiBfLiDiAiNmAjFfHiBeC_xHqqkZx_

// 05.09.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DBLPoint	m_mmptLastLT;		// _xZkqqHx_jBePiJpBiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiImKjChFiCmMiNlGiPoDiNmAjFfHiBeC_xHqqkZx_
	DBLRect		m_mmrtLastFrame;		// _xZkqqHx_jBePiJpBiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiImKjChFiCmMiDhEiDiMiBfLiDiAiNmAjFfHiBeC_xHqqkZx_
}; // class FCToolSelectTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FCToolSelectTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wOperation	:_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkK_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJiNhDiCkEjBiAiNoMiCmMiDhEiDiJiDePiBeC_xHqqkZx_
 *						 Subclass(ToolRotate)_xZkqqHx_iCmFiBeBiIoBiCkEjBiAiNoMjBmOiPnLiCpAjBeJjBpAiClHiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FCToolSelectTmpl ()
{
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FCToolSelectTmpl.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDraw (CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_ENCLOSING_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
//		// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjFgAiJoGiBeC_xHqqkZx_
//		DrawCurFocusFrame(pDC);
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//		break;
////----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		OnDrawMovingImageXXX((T_IDENTIFY*)NULL, pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//		RedrawMovingImageXXX((T_IDENTIFY*)NULL, DBLPoint(0,0), pDC);
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		break;
////----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	default:
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//	}
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	View_xZkqqHx_iCmFjBeJjBpAjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmE_xHqqkZx_m_vSelInfo_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeCiLmIjApM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiCkKiCkAiCoJiClNiCnPiBeBjCfAiCmIiCoJ_xHqqkZx_ vector<T_TYPE> _xZkqqHx_iCmFiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjDmBiOoKiCmIiDhIiDeOiDfOiBfL_xHqqkZx_ JointSelInfoVector _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
	m_hitXxx = InvalidValueXXX((T_IDENTIFY*)NULL);			// _xZkqqHx_iDhBiDgCiDgHiClFiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_lastSelectedXxx = InvalidValueXXX((T_IDENTIFY*)NULL);	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_MOVE_SNAP_LEFT:
	case ID_OBJECT_MOVE_SNAP_UP:
	case ID_OBJECT_MOVE_SNAP_RIGHT:
	case ID_OBJECT_MOVE_SNAP_DOWN:
		return TRUE;
	default:
		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectAll () const
{
	return (GetSelectableXXX((T_IDENTIFY*)NULL) != 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClHiCnHiCmEjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectAll ()
{
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	SelectAllXXX((T_IDENTIFY*)NULL, &dc);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanClearSelect () const
{
	return (GetSelectedXXX((T_IDENTIFY*)NULL) != 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnClearSelect ()
{
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
// 05.07.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UnselectAllXXX((T_IDENTIFY*)NULL, &dc);
	UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), &dc);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectSameKindOfObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDkPiOoNiCmMjFjEjFgJiCpAjBfDiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectSameKindOfObject () const
{
	const T_TYPE v = InvalidValueXXX((T_IDENTIFY*)NULL);
	if (IsLessKindOfXXX((T_IDENTIFY*)NULL, v, v) == true) return FALSE;
	if (GetSelectedXXX((T_IDENTIFY*)NULL) != 0) return TRUE;
	return BASE_CLASS::CanSelectSameKindOfObject();
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectSameKindOfObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectSameKindOfObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDkPiOoNiCmMjFjEjFgJiCpAjBfDiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectSameKindOfObject ()
{
	vector<T_TYPE> vSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, &vSelected);
	sort(vSelected.begin(), vSelected.end(), myLessKindOf<FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>, T_TYPE, T_IDENTIFY>(this));
	vector<T_TYPE> vSelectable;
	GetSelectableXXX((T_IDENTIFY*)NULL, &vSelectable);
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
// 05.07.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UnselectAllXXX((T_IDENTIFY*)NULL, &dc);
	UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), &dc);
	vector<T_TYPE>::iterator iObj;
	for (iObj = vSelectable.begin(); iObj != vSelectable.end(); iObj++)
	{
		if (binary_search(vSelected.begin(), vSelected.end(), *iObj, myLessKindOf<FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>, T_TYPE, T_IDENTIFY>(this)))
			SelectXXX((T_IDENTIFY*)NULL, *iObj, &dc);
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectSameKindOfObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectNext () const
{
	return (GetSelectableXXX((T_IDENTIFY*)NULL) != 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiOjPiCpAjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectNext ()
{
	T_TYPE xxxHit;
//----- 06.12.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (CheckHitNextXXX((T_IDENTIFY*)NULL, &xxxHit, GetLastSelectedXXX((T_IDENTIFY*)NULL)))
//	{
//		CClientDC dc(g_pView);
//		g_pView->OnPrepareDC(&dc, NULL);
//		UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), &dc);
//		SelectXXX((T_IDENTIFY*)NULL, xxxHit, &dc);
//	}
//----- 06.12.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBePiJpBiCmJjBeJjBpAiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	const T_TYPE xxx = GetLastSelectedXXX((T_IDENTIFY*)NULL);
	// _xZkqqHx_jBePiJpBiCmJjBeJjBpAiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmMiOjPiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
	BOOL bIsHit = CheckHitNextXXX((T_IDENTIFY*)NULL, &xxxHit, xxx);
	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeBiNmFiPiJiCkJiCoHiMjPiNpFiBeC_xHqqkZx_
	if (!bIsHit && xxx != InvalidValueXXX((T_IDENTIFY*)NULL))
		bIsHit = CheckHitNextXXX((T_IDENTIFY*)NULL, &xxxHit, InvalidValueXXX((T_IDENTIFY*)NULL));
	if (bIsHit)
	{
		CClientDC dc(g_pView);
		g_pView->OnPrepareDC(&dc, NULL);
		UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), &dc);
		SelectXXX((T_IDENTIFY*)NULL, xxxHit, &dc);
	}
//----- 06.12.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapLeft
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapLeft () const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	if (GetSelectedXXX((T_IDENTIFY*)NULL) == 0) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanMoveXXX((T_IDENTIFY*)NULL)) return FALSE;
	return TRUE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapLeft.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapLeft
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapLeft ()
{
	MoveXXXSnap((T_IDENTIFY*)NULL, -1, 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapLeft.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapUp () const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	if (GetSelectedXXX((T_IDENTIFY*)NULL) == 0) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanMoveXXX((T_IDENTIFY*)NULL)) return FALSE;
	return TRUE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapUp ()
{
	MoveXXXSnap((T_IDENTIFY*)NULL, 0, -1);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapRight () const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	if (GetSelectedXXX((T_IDENTIFY*)NULL) == 0) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanMoveXXX((T_IDENTIFY*)NULL)) return FALSE;
	return TRUE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapRight ()
{
	MoveXXXSnap((T_IDENTIFY*)NULL, 1, 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapDown () const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	if (GetSelectedXXX((T_IDENTIFY*)NULL) == 0) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
	if (!CanMoveXXX((T_IDENTIFY*)NULL)) return FALSE;
	return TRUE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanObjectMoveSnapDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapDown ()
{
	MoveXXXSnap((T_IDENTIFY*)NULL, 0, 1);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnObjectMoveSnapDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX (T_IDENTIFY*, T_TYPE xxx, CDC* pDC)
{
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetLastSelectedXXX((T_IDENTIFY*)NULL, xxx);
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectXXX (T_IDENTIFY*, T_TYPE xxx, CDC* pDC)
{
	if (xxx == InvalidValueXXX((T_IDENTIFY*)NULL))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAiPjMiBeC_xHqqkZx_
		SetLastSelectedXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL));
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAiPjMiBeC_xHqqkZx_
		if (GetLastSelectedXXX((T_IDENTIFY*)NULL) == xxx)
			SetLastSelectedXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL));
	}
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanMoveXXX (T_IDENTIFY*) const
{
	return FALSE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CanMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawFirstImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawFirstImageXXX (T_IDENTIFY*, CDC* pDC)
{
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawFirstImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::RedrawMovingImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMove=(0,0)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjFfMiOkGjFgAiJoGiCmMiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
 *			Tool::OnDraw _xZkqqHx_iCmFiCmMjFgAiJoGiPiIjHjNjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::RedrawMovingImageXXX (T_IDENTIFY*, const DBLPoint& mmptMove, CDC* pDC)
{
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::RedrawMovingImageXXX.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawMovingImageXXX (T_IDENTIFY*, CDC* pDC)
//{
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawLastImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawLastImageXXX (T_IDENTIFY*, CDC* pDC)
{
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawLastImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx		:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vmmptMove	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, const DBLPointVector& vmmptMove)
{
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, CDC* pDC)
{
	vector<T_TYPE>::const_iterator i;
	for (i = vXxx.begin(); i != vXxx.end(); i++)
		SelectXXX((T_IDENTIFY*)NULL, *i, pDC);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectAllXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectAllXXX (T_IDENTIFY*, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	vector<T_TYPE> vSelectable;
	GetSelectableXXX((T_IDENTIFY*)NULL, &vSelectable);
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	set<T_TYPE> stSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, NULL, &stSelected);
	// _xZkqqHx_jGkCjBeJjBpAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEjBeJjBpAiBeC_xHqqkZx_
	vector<T_TYPE>::iterator iXx;
	for (iXx = vSelectable.begin(); iXx != vSelectable.end(); iXx++)
	{
		if (stSelected.find(*iXx) == stSelected.end())
			SelectXXX((T_IDENTIFY*)NULL, *iXx, pDC);
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SelectAllXXX.

//----- 05.07.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectAllXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiKeKjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectAllXXX (T_IDENTIFY*, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
//	vector<T_TYPE> vXxx;
//	GetSelectedXXX((T_IDENTIFY*)NULL, &vXxx);
//	// _xZkqqHx_jBeJjBpAiCpAjBfDiCmEiJpAiPjMiBeC_xHqqkZx_
//	vector<T_TYPE>::iterator iXx;
//	for (iXx = vXxx.begin(); iXx != vXxx.end(); iXx++)
//		UnselectXXX((T_IDENTIFY*)NULL, *iXx, pDC);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::UnselectAllXXX.
//----- 05.07.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBeJjBpAiNmPiCnNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx:	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsSelectedXXX (T_IDENTIFY*, T_TYPE xxx) const
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	set<T_TYPE> stSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, NULL, &stSelected);
	return (stSelected.find(xxx) != stSelected.end());
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
T_TYPE FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetLastSelectedXXX (T_IDENTIFY*)
{
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	return m_lastSelectedXxx;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx	:_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetLastSelectedXXX (T_IDENTIFY*, T_TYPE xxx)
{
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_lastSelectedXxx = xxx;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsIntersectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlHiClHiCoJiCkJjClCiNlIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsIntersectXXX (T_IDENTIFY*, T_TYPE xxx, const DBLPoint& mmpt) const
{
	DBLRect mmrtFrame = GetFrameRectXXX((T_IDENTIFY*)NULL, xxx);
	const mmetol mmMargin = lg2mm(FD_HIT_TEST_MARGIN);
	if (mmrtFrame.left == mmrtFrame.right)
	{
		mmrtFrame.left -= mmMargin;
		mmrtFrame.right += mmMargin;
	}
	if (mmrtFrame.top == mmrtFrame.bottom)
	{
		mmrtFrame.top -= mmMargin;
		mmrtFrame.bottom += mmMargin;
	}
	return mmrtFrame.PtInRect(mmpt);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsIntersectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetRectInXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiLoJiMgAiCmMjDoAjBkEiCmJiBeBjBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmFjBlGiNnNiClHiCoJiCoAiCmMiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmrt:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetRectInXXX (T_IDENTIFY*, vector<T_TYPE>& vXxx, const DBLRect& mmrt) const
{
	vXxx.clear();
	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	vector<T_TYPE> vSelectable;
	GetSelectableXXX((T_IDENTIFY*)NULL, &vSelectable);
	vector<T_TYPE>::iterator iXx;
	for (iXx = vSelectable.begin(); iXx != vSelectable.end(); iXx++)
	{
		if (mmrt.RectInRect(GetFrameRectXXX((T_IDENTIFY*)NULL, *iXx)))
			vXxx.push_back(*iXx);
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetRectInXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFjBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmFiBeBiDhNiDeFiDfIiImKjChFiCmJiDhBiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hitXxx	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *					 NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_m_hitXxx_xZkqqHx_iCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitXXX (T_IDENTIFY*, T_TYPE* hitXxx)
{
	return CheckHitNextXXX((T_IDENTIFY*)NULL, hitXxx, InvalidValueXXX((T_IDENTIFY*)NULL));
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitNextXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFjBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmFiBeBiDhNiDeFiDfIiImKjChFiCmJiDhBiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJ_xHqqkZx_ lastXxx_xZkqqHx_iCmMiOjPiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hitXxx	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *					 NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_m_hitXxx_xZkqqHx_iCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			lastXxx	:_xZkqqHx_jBePiJpBiDhBiDgCiDgHiClFiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 _xZkqqHx_iOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ InvalidValueXXX_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
BOOL FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitNextXXX (T_IDENTIFY*, T_TYPE* hitXxx, T_TYPE lastXxx)
{
	// hitXxx_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_m_hitXxx_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	if (hitXxx == NULL) hitXxx = &m_hitXxx;
	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	vector<T_TYPE> vSelectable;
	GetSelectableXXX((T_IDENTIFY*)NULL, &vSelectable);
	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiLhEiPiHiCmJjClCiNlIiBeC_xHqqkZx_
	vector<T_TYPE>::reverse_iterator rXx = vSelectable.rbegin();
	if (lastXxx != InvalidValueXXX((T_IDENTIFY*)NULL))
	//----- lastXxx_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// lastXxx_xZkqqHx_iCmMiOjPiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
		for (; rXx != vSelectable.rend(); rXx++)
		{
			if (*rXx == lastXxx)
			{
				rXx++;
				break;
			}
		}
	}
	for (; rXx != vSelectable.rend(); rXx++)
	{
		if (IsIntersectXXX((T_IDENTIFY*)NULL, *rXx, m_mmptMsc))
		//----- _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			*hitXxx = *rXx;
			return TRUE;
		}
	}
	return FALSE;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::CheckHitNextXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsLessKindOfXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	T_TYPE_xZkqqHx_iMfOiCmMiCfBjCgMiCpAiBeBjCgMiCmMiOoNjFmKiCmGiClFiCmEjEoEiKhCiClFiBeB_xHqqkZx_v0 < v1 _xZkqqHx_iCmMiPoKiNiHiCmMiCnN_xHqqkZx_
 *			ture_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	v0	:_xZkqqHx_jEoEiKhCjBmOiPmGiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v1	:_xZkqqHx_jEoEiKhCjBmOiPmGiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	v0 < v1 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ture_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_false_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnSelectSameKindOfObject_xZkqqHx_iKnGjAjEiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
bool FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsLessKindOfXXX (T_IDENTIFY*, T_TYPE v0, T_TYPE v1) const
{
	return true;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::IsLessKindOfXXX.

//----- 05.06.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawBegin
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmpt:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmN_xHqqkZx_OnLButtonDown_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawBegin (T_IDENTIFY*, CDC* pDC, const DBLPoint& mmpt)
//{
//	m_mmptFocusBegin = m_mmptFocusRecent = mmpt;
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
//	FFGetMainWnd()->SetRulerMMKVisible(0, TRUE);
//	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmGiMlLiNnNiCmMiDeKiBfLiDfMiDiLiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_.
//	FFGetMainWnd()->MoveRulerMMK(m_mmptFocusBegin, m_mmptFocusRecent);
//	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusRecent));
//	rect.NormalizeRect();
//	FCEditDraw(pDC, 0).RectLine(rect);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawBegin.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawing
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiNhDiCkE_xHqqkZx_.
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmpt:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmN_xHqqkZx_OnMouseMove_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawing (T_IDENTIFY*, CDC* pDC, const DBLPoint& mmpt)
//{
//	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusRecent));
//	rect.NormalizeRect();
//	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiPmBiLiOiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, 0);
//	eDraw.RectLine(rect);
//	// _xZkqqHx_jAfGiClFiCkCiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	m_mmptFocusRecent = mmpt;
//	rect = CRect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusRecent));
//	rect.NormalizeRect();
//	// _xZkqqHx_jAfGiClFiCkCiDhEiDiMiBfLiDiAiCpAjFgAiJoGiBeC_xHqqkZx_
//	eDraw.RectLine(rect);
//	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmGiMlLiNnNiCmMiDeKiBfLiDfMiDiLiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_.
//	FFGetMainWnd()->MoveRulerMMK(m_mmptFocusBegin, m_mmptFocusRecent);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawing.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawEnd
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCmMjFgAiJoGiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmN_xHqqkZx_OnLButtonUp_xZkqqHx_iCkJiCoHiMmEiCnBiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawEnd (T_IDENTIFY*, CDC* pDC)
//{
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAjEpBiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
//	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
//	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusRecent));
//	rect.NormalizeRect();
//	FCEditDraw(pDC, 0).RectLine(rect);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::FocusFrameDrawEnd.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetFocusFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FocusFrameDrawEnd_xZkqqHx_iMoDiCmJjHeMiMpIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//DBLRect FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetFocusFrame (T_IDENTIFY*) const
//{
//	DBLRect mmrtFrame(	m_mmptFocusBegin.x, m_mmptFocusBegin.y,
//						m_mmptFocusRecent.x, m_mmptFocusRecent.y);
//	mmrtFrame.NormalizeRect();
//	return mmrtFrame;
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetFocusFrame.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawCurFocusFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class T_TYPE, class T_IDENTIFY>
//void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawCurFocusFrame (T_IDENTIFY*, CDC* pDC)
//{
//	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	CRect rect(mm2lg(m_mmptFocusBegin), mm2lg(m_mmptFocusRecent));
//	rect.NormalizeRect();
//	// _xZkqqHx_jBePiJpBiCmMiDhEiDiMiBfLiDiAiCpAjFgAiJoGiBeC_xHqqkZx_
//	FCEditDraw(pDC, 0).RectLine(rect);
//} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::DrawCurFocusFrame.
//----- 05.06.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetHitXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgIiDiLiPpDjBnEiCkJiCoHiInKiNhDiClHiCoJiNnLiCmJiDhNiDeFiDfIiDhBiDgCiDgHiClFiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
T_TYPE FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetHitXXX (T_IDENTIFY*) const
{
	return m_hitXxx;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::GetHitXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetHitXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiDhBiDgCiDgHiClFiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	xxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetHitXXX (T_IDENTIFY*, T_TYPE xxx)
{
	m_hitXxx = xxx;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::SetHitXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXXSnap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFpLiMpMiCmJiBeB_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDfIiDgJiDgCiDhGjCfAiImKiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHorzDirection	:_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *			lVertDirection	:_xZkqqHx_jAiCjClMjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ALT_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiInKjDkOiClHiCoJiPoKiNiHiCmNiInKjDkOjHmKiCkKjAjEjFkKiCmMiCfAiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXXSnap (T_IDENTIFY*, long lHorzDirection, long lVertDirection)
{
	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiKoOiPiA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiClFiCmEiOoGjDlOiBeC_xHqqkZx_
	T_TYPE xxxLastSelected = GetLastSelectedXXX((T_IDENTIFY*)NULL);
	if (xxxLastSelected == InvalidValueXXX((T_IDENTIFY*)NULL)) return;
	// _xZkqqHx_iKoOiPiA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjBoFiCkLiClDiCpAiOoGjDlOiBeC_xHqqkZx_
	const DBLRect mmrtFrame = GetFrameRectXXX((T_IDENTIFY*)NULL, xxxLastSelected);
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgH_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfIiDgJiDgCiDhGiClHiCoJiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	const DBLPoint mmptSnapPosition = FFGetFramePoint(mmrtFrame, g_pReg->GetSnapPosition());
	// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiImKjChFiCpAiJlMiMiIiCnPiBeC_xHqqkZx_
	DBLPoint mmptNew = mmptSnapPosition;
	FFSnapMoveMP(mmptNew, lHorzDirection, lVertDirection);
	// _xZkqqHx_jGhLjDjGiCmMiInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPoint mmptDiff = mmptNew - mmptSnapPosition;
	// _xZkqqHx_iInKjDkOiLjHjHkDiCePiCmMiPoKiNiHiCmNjFjMiLeBiBeCiCkAiCoIiCkGiCmIiCkCiCkKiBeBjEePiCmMiClNiCnPiBeC_xHqqkZx_
	if (almost0(mmptDiff)) return;
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<T_TYPE> vSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, &vSelected);
	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiBeC_xHqqkZx_
	MoveXXX((T_IDENTIFY*)NULL, vSelected, mmptDiff);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXXSnap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX (T_IDENTIFY*, const vector<T_TYPE>& vXxx, const DBLPoint& mmptMove)
{
	MoveXXX((T_IDENTIFY*)NULL, vXxx, DBLPointVector(vXxx.size(), mmptMove));
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::MoveXXX.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawState (CDC* pDC, int iState)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (iState)
//	{
//	case STATE_ENCLOSING_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
//		// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjFgAiJoGiBeC_xHqqkZx_
//		DrawCurFocusFrame(pDC);
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//		break;
////----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		OnDrawMovingImageXXX((T_IDENTIFY*)NULL, pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//		RedrawMovingImageXXX((T_IDENTIFY*)NULL, DBLPoint(0,0), pDC);
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		break;
////----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	default:
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENCLOSING_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjFgAiJoGiBeC_xHqqkZx_
		DrawCurFocusFrame(pDC);
		break;
	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		RedrawMovingImageXXX((T_IDENTIFY*)NULL, DBLPoint(0,0), pDC);
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
int FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmNiBeBiPoKiNiHiCmJiCoGiCmBiCmEiCmNiOjOiKnEiCkKiCkJiCkJiCoJiCmMiCmF_xHqqkZx_
			// _xZkqqHx_iMmCiBfIiCmM_xHqqkZx_case_xZkqqHx_jFlGiCmMjDoAjBkEiCmJiOjNiCmBiCmEiCkNiCoJiClBiCmGiBeC_xHqqkZx_
			// _xZkqqHx_iKePjBkEiCmJiPgPiClHiCmGiBeB_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJiCoAiDhBiDgCiDgHiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmFjAkHiMmAiClFiCmIiCkCiCmGiBeBjFnCiPfHiDgDiBfLiDiLiCpAjAoGiCmJjAnNjCoIiClF_xHqqkZx_
			// _xZkqqHx_iMoDiCkJiCoHjFjEjFgJiCpAjBeJjBpAiClFiClNiPoKiNiHiBeBjFjEjFgJjFnCiPfHiDiCiBfLiDgIiCmJjDpMiCoHiCmIiCkCiBeC_xHqqkZx_
			if (GetSelectableXXX((T_IDENTIFY*)NULL) != 0)
			//----- _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// Control_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmEiCkCiCoJiCmGiCkLiCmNjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_jFjEjFgJjBeJjBpAjCiGiCmJ_xHqqkZx_ Control_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHjAfGiClFiCkCjFjEjFgJiCpA_xHqqkZx_
				// _xZkqqHx_iJeFiDhLiDfOiDjDiCmFjBeJjBpAiClHiCoJiCmGiBeBiDiKiDjDiDeOiCpAjCkDiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iClBiClBiCmFiJeFiDhLiDfOiDjDiDeDiDhIiDjDiDgHiCpAjCeEiCkEiCmGiClBiCoKiCkKiPgPjHiIiCmIiCkNiCmIiCoJiBeC_xHqqkZx_

				// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
				if (CheckHitXXX((T_IDENTIFY*)NULL))
					iNextState = STATE_ENTER_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
				else
					iNextState = STATE_BEFORE_ENCLOSE_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
			}
			break;
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmNiBeBiPoKiNiHiCmJiCoGiCmBiCmEiCmNiOjOiKnEiCkKiCkJiCkJiCoJiCmMiCmF_xHqqkZx_
//			// _xZkqqHx_iMmCiBfIiCmM_xHqqkZx_case_xZkqqHx_jFlGiCmMjDoAjBkEiCmJiOjNiCmBiCmEiCkNiCoJiClBiCmGiBeC_xHqqkZx_
//			// _xZkqqHx_iKePjBkEiCmJiPgPiClHiCmGiBeB_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJiCoAiDhBiDgCiDgHiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmFjAkHiMmAiClFiCmIiCkCiCmGiBeBjFnCiPfHiDgDiBfLiDiLiCpAjAoGiCmJjAnNjCoIiClF_xHqqkZx_
//			// _xZkqqHx_iMoDiCkJiCoHjFjEjFgJiCpAjBeJjBpAiClFiClNiPoKiNiHiBeBjFjEjFgJjFnCiPfHiDiCiBfLiDgIiCmJjDpMiCoHiCmIiCkCiBeC_xHqqkZx_
//			if (!IsControl() && GetSelectableXXX((T_IDENTIFY*)NULL) != 0)
//			//----- _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// Control_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmEiCkCiCoJiCmGiCkLiCmNjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
//				// _xZkqqHx_jFjEjFgJjBeJjBpAjCiGiCmJ_xHqqkZx_ Control_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHjAfGiClFiCkCjFjEjFgJiCpA_xHqqkZx_
//				// _xZkqqHx_iJeFiDhLiDfOiDjDiCmFjBeJjBpAiClHiCoJiCmGiBeBiDiKiDjDiDeOiCpAjCkDiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
//				// _xZkqqHx_iClBiClBiCmFiJeFiDhLiDfOiDjDiDeDiDhIiDjDiDgHiCpAjCeEiCkEiCmGiClBiCoKiCkKiPgPjHiIiCmIiCkNiCmIiCoJiBeC_xHqqkZx_
//
//				// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//				if (CheckHitXXX((T_IDENTIFY*)NULL))
//					iNextState = STATE_ENTER_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
//				else
//					iNextState = STATE_BEFORE_ENCLOSE_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
//			}
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmNiBeBiPoKiNiHiCmJiCoGiCmBiCmEiCmNiOjOiKnEiCkKiCkJiCkJiCoJiCmMiCmF_xHqqkZx_
			// _xZkqqHx_iMmCiBfIiCmM_xHqqkZx_case_xZkqqHx_jFlGiCmMjDoAjBkEiCmJiOjNiCmBiCmEiCkNiCoJiClBiCmGiBeC_xHqqkZx_
			// _xZkqqHx_iKePjBkEiCmJiPgPiClHiCmGiBeB_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJiCoAiDhBiDgCiDgHiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
			// GetSelectableXXX_xZkqqHx_iKnGjAjEiCmFjAkHiMmAiClFiCmIiCkCiCmGiBeBjFnCiPfHiDgDiBfLiDiLiCpAjAoGiCmJjAnNjCoIiClF_xHqqkZx_
			// _xZkqqHx_iMoDiCkJiCoHjFjEjFgJiCpAjBeJjBpAiClFiClNiPoKiNiHiBeBjFjEjFgJjFnCiPfHiDiCiBfLiDgIiCmJjDpMiCoHiCmIiCkCiBeC_xHqqkZx_
			if (GetSelectableXXX((T_IDENTIFY*)NULL) != 0)
			//----- _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFjEjFgJjBeJjBpAjCiGiCmM_xHqqkZx_CTRL+_xZkqqHx_iJeFiDhLiDfOiDjDiCmFiCmNiBeBiDiKiDjDiDeOiCpAjCkDiCoJiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iClBiClBiCmFiClLiCmMiDeDiDhIiDjDiDgHiCpAjCeEiCoNiCmIiCkCiCoGiCkEiBeBiMlFjGkHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_jBeJjBpAiJmCjEfMiCmFiCkAiCoJiCkJiBeI_xHqqkZx_
				BOOL bSelectable = TRUE;
				// _xZkqqHx_iDhNiDeFiDfIiDeOiDiKiDgCiDeOiCkKiDeJiDhFiDfHiDeGiDeOiDgHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
				const BOOL bIsHit = CheckHitXXX((T_IDENTIFY*)NULL);
				// _xZkqqHx_iImIiJlKiCmMiPpAiMiPiCpAjGjOiClNiClHiPoKiNiHiCmMiCnNiBeBiDiKiDjDiDeOiPiIjHjNjHhAiCmJiDeDiDhIiDjDiDgHiCpAiDfIiDiLiBfLiBeC_xHqqkZx_
				// 1.CTRL_xZkqqHx_iBhLiJeFiDhLiDfOiDjD_xHqqkZx_
				// 2._xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJ_xHqqkZx_
				// 3._xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiPoDiCmFiDhNiDeFiDfIiDeOiDiKiDgCiDeOiCmFiCkAiCoJ_xHqqkZx_
				// 4._xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmNjGkCjBeJjBpAiCmFiCkAiCoJ_xHqqkZx_
				if (IsControl() &&
					GetSelectedXXX((T_IDENTIFY*)NULL) != 0 &&
					bIsHit &&
					!IsSelectedXXX((T_IDENTIFY*)NULL, GetHitXXX((T_IDENTIFY*)NULL)))
				{
					bSelectable = FALSE;
				}
				if (bSelectable)
				{
					// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
					if (bIsHit)
						iNextState = STATE_ENTER_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
					else
						iNextState = STATE_BEFORE_ENCLOSE_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
				}
			}
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case WM_KEYDOWN:		// _xZkqqHx_iDeMiBfLiDfPiDeFiDjDiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAjCiGjFjEjFgJiCmMjFnCiPfHiJmCiBjFiDeKiBfLiDfMiDiLiDeMiBfLiCmIiCoHiCmOiBeB_xHqqkZx_
			// _xZkqqHx_iDfIiDgJiDgCiDhGiInKjDkOiBeCiBgJiJlMjBhKiDeMiBfLiCmFiCoAjBoFiPoEjFhGiBgK_xHqqkZx_
			if (GetSelectedXXX((T_IDENTIFY*)NULL) != 0 &&
				CanMoveXXX((T_IDENTIFY*)NULL) &&
				(m_dwChar == VK_LEFT || m_dwChar == VK_UP ||
				 m_dwChar == VK_RIGHT || m_dwChar == VK_DOWN))
				iNextState = STATE_DO_MOVE_XXX_SNAP;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
		break;
	case STATE_ENTER_SELECT_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
		if (IsSelectedXXX((T_IDENTIFY*)NULL, m_hitXxx))
			iNextState = STATE_PRE_UNSEL_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
		else
			iNextState = STATE_CLRSEL_SEL_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
		break;
	case STATE_PRE_UNSEL_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			if (IsShift())
				iNextState = STATE_UNSEL_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiBeC_xHqqkZx_
			else
				iNextState = STATE_SET_LAST_XXX;	// _xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAjFjEjFgJjFnCiPfHiJmCjEfMiCmIiCoHiCmOiBeBiOjPiCnGiBeC_xHqqkZx_
			if (GetSelectedXXX((T_IDENTIFY*)NULL) != 0 && CanMoveXXX((T_IDENTIFY*)NULL))
				iNextState = STATE_START_MOVE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
		break;
	case STATE_SET_LAST_XXX:	// _xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
		iNextState = STATE_EXIT_SELECT_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_UNSEL_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		iNextState = STATE_EXIT_SELECT_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_CLRSEL_SEL_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_SELECT_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAjFjEjFgJjFnCiPfHiJmCjEfMiCmIiCoHiCmOiBeBiOjPiCnGiBeC_xHqqkZx_
			if (GetSelectedXXX((T_IDENTIFY*)NULL) != 0 && CanMoveXXX((T_IDENTIFY*)NULL))
				iNextState = STATE_START_MOVE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
		break;
	case STATE_EXIT_SELECT_XXX:				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_BEFORE_ENCLOSE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
		// GetSelectedXXX_xZkqqHx_iKnGjAjEiCmFjAkHiMmAiClHiCoJiClBiCmGiCmJiCoGiCmBiCmEiBeBiDhMiDiKiDiJiDeDiDjDjFnCiPfHiCmIiCmHiCmF_xHqqkZx_
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCkKiClHiCoJiPoKiNiHiCmJiBeBiCfAiJpBiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiCmJiCoGiCmBiCmE_xHqqkZx_
		// _xZkqqHx_iClHiCkOiCmJjFnCiPfHiDiCiBfLiDgIiCkJiCoHjElCiCkPiCmEiClFiCnMiCkEiClBiCmGiCpAjGgIiCkOiBeC_xHqqkZx_
		if (GetSelectedXXX((T_IDENTIFY*)NULL) != 0)
		//----- _xZkqqHx_jBeJjBpAiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			iNextState = STATE_START_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
		} else
		//----- _xZkqqHx_jBeJjBpAiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			switch (iEvent)
			{
			case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
				iNextState = STATE_START_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
				break;
			case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
				iNextState = STATE_CANCEL_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
				break;
			}
		}
		break;
	case STATE_CANCEL_ENCLOSE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiDfIiDgFiBfLiDgHiCmNiBeBjFoPiImNiDeMiDiDiDjDiDfKiDiLiOjOiCmJjBlMiCmMiPiIjHjNiBgJiDgDiBfLiDiLiPeJjHlJjDjJiBgKiCpA_xHqqkZx_
		// _xZkqqHx_iMmEiCnBiPgPiClJiCoJiCoGiCkEiCmJiPeDjAlDiClHiCoJiClBiCmGiCkKjHgFiInFiCmGiCmIiCoJiCoGiCkEiCmJjAnNjCoIiClFiCmEiCkAiCoJiBeC_xHqqkZx_
		iNextState = STATE_IDLE;				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	case STATE_START_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_ENCLOSING_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
		break;
	case STATE_ENCLOSING_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_ENCLOSING_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
			break;
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			if (IsShift())
				iNextState = STATE_WAIT_MENU_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiBeC_xHqqkZx_
			else
				iNextState = STATE_STOP_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_IDLE;	// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	case STATE_WAIT_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_CONTEXTMENU:	// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			iNextState = STATE_POPUP_MENU_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_POPUP_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_COMMAND:	// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			iNextState = STATE_STOP_MENU_ENCLOSE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_IDLE;	// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_START_MOVE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_MOVING_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
		break;
	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_MOVING_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:		// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_MOVE_XXX;	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MOVE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_DO_MOVE_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		break;
	case STATE_DO_MOVE_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		iNextState = STATE_EXIT_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_DO_MOVE_XXX_SNAP:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_SELECT_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
		StateEnterSelectXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_PRE_UNSEL_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
		StatePreUnselXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_SET_LAST_XXX:		// _xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
		StateSetLastXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_UNSEL_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		StateUnselXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_CLRSEL_SEL_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
		StateClrselSelXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_EXIT_SELECT_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		StateExitSelectXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_BEFORE_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPiAjEpFiBeC_xHqqkZx_
		TRACE(_T("STATE_BEFORE_ENCLOSE_XXX\n"));
		break;
	case STATE_CANCEL_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
		TRACE(_T("STATE_CANCEL_ENCLOSE_XXX\n"));
		break;
	case STATE_START_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiBeC_xHqqkZx_
		StateStartEncloseXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_ENCLOSING_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiBeC_xHqqkZx_
		StateEnclosingXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_STOP_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiBeC_xHqqkZx_
		StateStopEncloseXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_WAIT_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiBeC_xHqqkZx_
		StateWaitMenuEncloseXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_POPUP_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
		StatePopupMenuEncloseXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_STOP_MENU_ENCLOSE_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiBeC_xHqqkZx_
		StateStopMenuEncloseXXX((T_IDENTIFY*)NULL, pDC);
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_START_MOVE_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		StateStartMoveXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_MOVING_XXX:				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
		StateMovingXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_STOP_MOVE_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		StateStopMoveXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_DO_MOVE_XXX:				// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		StateDoMoveXXX((T_IDENTIFY*)NULL, pDC);
		break;
	case STATE_DO_MOVE_XXX_SNAP:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
		StateDoMoveXXXSnap((T_IDENTIFY*)NULL, pDC);
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnterSelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnterSelectXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateEnterSelectXXX\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);

	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, TRUE);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiInKjDkO_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiBeC_xHqqkZx_
	const DBLRect mmrtFrame = GetFrameRectXXX((T_IDENTIFY*)NULL, m_hitXxx);
	FFGetMainWnd()->MoveRulerMMK(DBLPoint(mmrtFrame.left, mmrtFrame.top),
						DBLPoint(mmrtFrame.right, mmrtFrame.bottom));
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnterSelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePreUnselXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePreUnselXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StatePreUnselXXX\r\n"));
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePreUnselXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateSetLastXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPeJjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateSetLastXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateSetLastXXX\r\n"));
	SetLastSelectedXXX((T_IDENTIFY*)NULL, m_hitXxx);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateSetLastXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateUnselXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateUnselXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateUnselXXX\r\n"));
	UnselectXXX((T_IDENTIFY*)NULL, m_hitXxx, pDC);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateUnselXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateClrselSelXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateClrselSelXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateClrselSelXXX\r\n"));
	// Shift_xZkqqHx_iCkKiJjPiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
// 05.07.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!IsShift()) UnselectAllXXX((T_IDENTIFY*)NULL, pDC);
	if (!IsShift()) UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), pDC);
	// _xZkqqHx_jBeJjBpAiCmJjCmHiJmBiBeC_xHqqkZx_
	SelectXXX((T_IDENTIFY*)NULL, m_hitXxx, pDC);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateClrselSelXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateExitSelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateExitSelectXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateExitSelectXXX\r\n"));
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfL_xHqqkZx_0_xZkqqHx_iCpAjEpBiJmCiOiLiCmJiClHiCoJ_xHqqkZx_.
	FFGetMainWnd()->SetRulerMMKVisible(0, FALSE);
	::FFReleaseCapture();	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateExitSelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartEncloseXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartEncloseXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateStartEncloseXXX\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjFgAiJoGiKeKiOgOiBeC_xHqqkZx_
// 05.06.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FocusFrameDrawBegin((T_IDENTIFY*)NULL, pDC, m_mmptMsc);
	FocusFrameDrawBegin(pDC, m_mmptMsc);
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartEncloseXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnclosingXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnclosingXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateEnclosingXXX\r\n"));
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAjFgAiJoGiBeC_xHqqkZx_
// 05.06.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FocusFrameDrawing((T_IDENTIFY*)NULL, pDC, m_mmptMsc);
	FocusFrameDrawing(pDC, m_mmptMsc);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateEnclosingXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopEncloseXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopEncloseXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("StateStopEncloseXXX\r\n"));

	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	FocusFrameDrawEnd(pDC);
	// _xZkqqHx_iDhEiDiMiBfLiDiAjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjCiKiPgPiBeC_xHqqkZx_
	vector<T_TYPE> vXxx;
	GetRectInXXX((T_IDENTIFY*)NULL, vXxx, GetFocusFrame());
	if (IsShift())
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLoJiMgAjDoAiCmJiCkAiCoJjBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJjBmOiClFiCmEiBeBjBeJjBpAiBeFjGkCjBeJjBpAiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
		vector<T_TYPE>::const_iterator iXxx;
		for (iXxx = vXxx.begin(); iXxx != vXxx.end(); iXxx++)
		{
			if (IsSelectedXXX((T_IDENTIFY*)NULL, *iXxx))
				UnselectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
			else
				SelectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
		}
	} else
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiBeBiNkBiCmMjBeJjBpA_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAiPjMiBeC_xHqqkZx_
// 05.07.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		UnselectAllXXX((T_IDENTIFY*)NULL, pDC);
		UnselectXXX((T_IDENTIFY*)NULL, InvalidValueXXX((T_IDENTIFY*)NULL), pDC);
		SelectXXX((T_IDENTIFY*)NULL, vXxx, pDC);
	}
	::FFReleaseCapture();	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopEncloseXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateWaitMenuEncloseXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateWaitMenuEncloseXXX (T_IDENTIFY*, CDC* pDC)
{
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	FocusFrameDrawEnd(pDC);
	::FFReleaseCapture();	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateWaitMenuEncloseXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePopupMenuEncloseXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLjFfMiOkGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePopupMenuEncloseXXX (T_IDENTIFY*, CDC* pDC)
{
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfL_xHqqkZx_(EncloseXXX)_xZkqqHx_iCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
// 06.02.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFPopupSubmenu(m_mmptMsc, IDR_RBTN_TOOL, FD_MENU_TOOL_SELECT_ENCLOSE, AfxGetMainWnd());
	FFPopupSubmenu(m_mmptMsc, IDR_RBTN_TOOL, FD_MENU_TOOL_SELECT_ENCLOSE, FFGetMainWnd()->GetWnd());
	// _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeBiDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCmM_xHqqkZx_
	// _xZkqqHx_iCkCiClIiCoKiCoAjBeJiCmOiCoKiCmIiCkJiCmBiClNiOjOiCmJiPpDjBnEjBeKiInKiCmFiCkLiClIiDiNiDgCiDeOiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	AfxGetMainWnd()->PostMessage(WM_COMMAND, ID_TLCMD_POPUPMENU_ENDED, 0);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StatePopupMenuEncloseXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMenuEncloseXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDiBiDgKiDiFiBfLiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMenuEncloseXXX (T_IDENTIFY*, CDC* pDC)
{
	// _xZkqqHx_iDhEiDiMiBfLiDiAjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjCiKiPgPiBeC_xHqqkZx_
	vector<T_TYPE> vXxx;
	GetRectInXXX((T_IDENTIFY*)NULL, vXxx, GetFocusFrame());
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	set<T_TYPE> stSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, NULL, &stSelected);
	switch (m_dwCommand)
	{
	case ID_TLCMD_ENCLOSE_AND:	// AND_xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
	  {
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiCkEiClPiBeBiLoJiMgAjDoAiCmJiCkAiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiCnNiCpAjBeJjBpAiPpDjBnEiCmJiOgDiClHiBeC_xHqqkZx_
		set<T_TYPE> stXxx;
		FFInsert(stXxx, vXxx);
		set<T_TYPE>::const_iterator iXxx;
		for (iXxx = stSelected.begin(); iXxx != stSelected.end(); iXxx++)
		{
			if (stXxx.find(*iXxx) == stXxx.end())
				UnselectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
		}
		break;
	  }
	case ID_TLCMD_ENCLOSE_OR:	// OR_xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iLoJiMgAjDoAiCmJiCkAiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiPpDjBnEiCmGiClFiCmEjCmHiJmBiClHiCoJiBeC_xHqqkZx_
		vector<T_TYPE>::const_iterator iXxx;
		for (iXxx = vXxx.begin(); iXxx != vXxx.end(); iXxx++)
		{
			// _xZkqqHx_jGkCjBeJjBpAiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiCnNjBeJjBpAiClHiCoJiBeC_xHqqkZx_
			if (stSelected.find(*iXxx) == stSelected.end())
				SelectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
		}
		break;
	  }
	case ID_TLCMD_ENCLOSE_XOR:	// XOR_xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iLoJiMgAjDoAiCmJiCkAiCoJjBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJjBmOiClFiCmEiBeBjBeJjBpAiBeFjGkCjBeJjBpAiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
		vector<T_TYPE>::const_iterator iXxx;
		for (iXxx = vXxx.begin(); iXxx != vXxx.end(); iXxx++)
		{
			if (stSelected.find(*iXxx) == stSelected.end())
				SelectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
			else
				UnselectXXX((T_IDENTIFY*)NULL, *iXxx, pDC);
		}
		break;
	  }
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMenuEncloseXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartMoveXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartMoveXXX\r\n"));
	//----- _xZkqqHx_iInKjDkOjApMjAnNjCoIiPiIjHjN_xHqqkZx_ -----
	const DBLRect mmrtFrame = GetFrameRectXXX((T_IDENTIFY*)NULL, GetHitXXX((T_IDENTIFY*)NULL));
	// _xZkqqHx_iMmFjCoIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmptFix = FFGetFramePoint(mmrtFrame, g_pReg->GetSnapPosition());

	//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMjApMiCpAiInKjDkOjApMiCmJjAnNjCoI_xHqqkZx_ -----
	m_mmlnvAry.clear();
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(10,0)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0,10)));
	// _xZkqqHx_iJeFiBeFiNlGiDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCmMiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmptButtonDownFirst = m_mmptLRButtonDown;

	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgH_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiCmMiNmAjFfHiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	// m_mmrtLastFrame_xZkqqHx_iCmJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmrtFirstFrame = mmrtFrame;
	m_mmrtLastFrame = mmrtFrame;

	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);

	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawFirstImageXXX((T_IDENTIFY*)NULL, pDC);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStartMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateMovingXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateMovingXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateMovingXXX\r\n"));

	//----- _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiOjOiCkJiCoHiCmMiDhNiDeFiDfIiCmMiInKjDkOiLjHjHkDiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	DBLPoint mmptDiff = m_mmptMsc - m_mmptButtonDownFirst;

	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgH_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOiMoDiNmAjFfHiBgJ_xHqqkZx_mmptNewLT_xZkqqHx_iBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgH_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfIiDgJiDgCiDhGiClHiCoJiImKjChFiCpAiOoGjDlOiBgJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmNiCnMiClOjDkOiCkCiCmEiCkCiCmIiCkCiBgK_xHqqkZx_
	const DBLPoint mmptSnapPosition = FFGetFramePoint(m_mmrtFirstFrame, g_pReg->GetSnapPosition());
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCnMiCmFiInKjDkOiClFiClNiPoKiNiHiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfIiDgJiDgCiDhGiImKjChFiBeC_xHqqkZx_
	mmptDiff += mmptSnapPosition;
	// _xZkqqHx_iClBiCmMiNmAjFfHiCmJiInKjDkOjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	FFLimitMP(mmptDiff, m_dwFlags, m_mmptFix, m_mmlnvAry.begin(), m_mmlnvAry.size());
	// _xZkqqHx_iDfIiDgJiDgCiDhGiPiIjHjNiClFiClNiMoDiCmMiBeBiInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
	mmptDiff -= mmptSnapPosition;
	// _xZkqqHx_jAfGiClFiCkCiNlGiPoDiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	const DBLRect mmrtNewFrame = m_mmrtFirstFrame + mmptDiff;

	if (!almosteq(m_mmrtLastFrame, mmrtNewFrame))
	//----- _xZkqqHx_jBePiJpBiCmG_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmAjFfHiCkKjFmPiJlLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
		const DBLPoint mmptMove = mmrtNewFrame.GetLeftTop() - m_mmrtLastFrame.GetLeftTop();
		// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		RedrawMovingImageXXX((T_IDENTIFY*)NULL, mmptMove, pDC);
		// m_mmrtLastFrame_xZkqqHx_iCmJiInKjDkOiMoDiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
		m_mmrtLastFrame = mmrtNewFrame;

//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iInKjDkO_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_ -----
//		FFGetMainWnd()->MoveRulerMMK(mmrtNewFrame.GetLeftTop(),
//									mmrtNewFrame.GetRightBottom());
//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		//----- _xZkqqHx_iInKjDkO_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiBgJiCfAiJnDiPiKiBgKiCpAjFfMiOkG_xHqqkZx_ -----
		if (almosteq(m_mmrtLastFrame.GetLeftTop(), m_mmrtLastFrame.GetRightBottom()))
		//----- _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBoFiCkLiClDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiPiJiCmMiImKjChFiBeBiInKjDkOiMoDiCmMiImKjChFiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->MoveRulerMMK(m_mmrtFirstFrame.GetLeftTop(),
										 m_mmrtLastFrame.GetLeftTop());
		} else
		//----- _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBoFiCkLiClDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNlGiPoDiBeBiJeFiJlKiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->MoveRulerMMK(m_mmrtLastFrame.GetLeftTop(),
										 m_mmrtLastFrame.GetRightBottom());
		}
//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateMovingXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPeJjHlJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMoveXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMoveXXX\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
	DrawLastImageXXX((T_IDENTIFY*)NULL, pDC);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateStopMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXX (T_IDENTIFY*, CDC* pDC)
{
	TRACE(_T("FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXX\r\n"));
	//----- XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOiLjHjHkDiCpAiLiBiCnPiCoJ_xHqqkZx_.m_mmrtLastFrame_xZkqqHx_iCmN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiNmAjFfH_xHqqkZx_ -----
	const DBLPoint mmptDiff = m_mmrtLastFrame.GetLeftTop() - m_mmrtFirstFrame.GetLeftTop();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<T_TYPE> vSelected;
	GetSelectedXXX((T_IDENTIFY*)NULL, &vSelected);
	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiBeC_xHqqkZx_
	MoveXXX((T_IDENTIFY*)NULL, vSelected, mmptDiff);
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXXSnap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class T_TYPE, class T_IDENTIFY>
void FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXXSnap (T_IDENTIFY*, CDC* pDC)
{
	// _xZkqqHx_iDeKiBfLiDfMiDiLiDeMiBfLiCmIiCoHiCmOiBeBiDfIiDgJiDgCiDhGiInKjDkOiBeCiBgJiJlMjBhKiDeMiBfLiCmFiCoAjBoFiPoEjFhGiBgK_xHqqkZx_
	switch (m_dwChar)
	{
	case VK_LEFT:	// _xZkqqHx_iNlGiDeMiBfLiBeC_xHqqkZx_
		g_pView->PostMessage(WM_COMMAND, ID_OBJECT_MOVE_SNAP_LEFT);
		break;
	case VK_UP:		// _xZkqqHx_iPoDiDeMiBfLiBeC_xHqqkZx_
		g_pView->PostMessage(WM_COMMAND, ID_OBJECT_MOVE_SNAP_UP);
		break;
	case VK_RIGHT:	// _xZkqqHx_iJeFiDeMiBfLiBeC_xHqqkZx_
		g_pView->PostMessage(WM_COMMAND, ID_OBJECT_MOVE_SNAP_RIGHT);
		break;
	case VK_DOWN:	// _xZkqqHx_iJlKiDeMiBfLiBeC_xHqqkZx_
		g_pView->PostMessage(WM_COMMAND, ID_OBJECT_MOVE_SNAP_DOWN);
		break;
	}
} // FCToolSelectTmpl<SUPER, T_TYPE, T_IDENTIFY>::StateDoMoveXXXSnap.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	myLessKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiOoNjHnOiCmMiBeBjBoFiPkMiKnGiMfHiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBiClLiCmMiOoNjHnOiCmFjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjDkPiOoNiCmMjFjEjFgJiCpAjBeJjBpAiBhGiCmJiCkIiCkCiCmEiBeBjDkPiOoNiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCmM_xHqqkZx_
 *			_xZkqqHx_jElLjCgGiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T_OWNER, class T_TYPE, class T_IDENTIFY> class myLessKindOf
{
public:
	myLessKindOf (const T_OWNER* pOwner) : m_pOwner(pOwner) {}
	bool operator () (const T_TYPE& v0, const T_TYPE& v1) const
	{ return m_pOwner->IsLessKindOfXXX((T_IDENTIFY*)NULL, v0, v1); }
	const T_OWNER* m_pOwner;
}; // class myLessKindOf.

#endif//__ToolSelectTmpl_h
