#ifndef __ToolTextFindTmpl_h
#define __ToolTextFindTmpl_h

#include "stdafx.h"
#include <algorithm>		// For find.
#include "RegData.h"		// For g_pReg.
#include "FoundDoc.h"		// For g_pDoc.
#include "SheetManager.h"	// For FCSheetManager.
#include "DynamicDrawView.h"// For g_pView.
#include "MainFrame.h"		// For MoveRulerMMK,etc..
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ObjFigure.h"		// For FCObjFigure.
#include "RichText.h"		// For FCRichText.
#include "ObjGroup.h"		// For FCObjGroup.
#include "LayerManager.h"	// For FDOZ_ON_SELECT.
#include "SearchParser.h"	// For FCSearchParser.
//#include "DlgFindText.h"	// For CFCDlgFindText.
#include "DlgFindNextContinue.h" // For CFCDlgFindNextContinue.
#include "DlgFindPrevContinue.h" // For CFCDlgFindPrevContinue.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS SUPER

// LoopTextSearch_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
typedef BOOL (*FTCallbackLoopTextSearch) (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC);

template<class SUPER> class FCToolTextFindTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	FCToolTextFindTmpl ();

	//----- FCToolBase_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void	Select (CDC* pDC);
	virtual void	Unselect (CDC* pDC);

	virtual void	OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj);

	virtual BOOL	CanFindText () const;
	virtual BOOL	CanFindNextText () const;
	virtual void	OnFindNextText ();
	virtual BOOL	CanFindPrevText () const;
	virtual void	OnFindPrevText ();

//----- 05.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanFindTextAll () const;
	virtual void	OnFindTextAll ();
//----- 05.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual BOOL	CanFindTextAllInSelect () const;
	virtual void	OnFindTextAllInSelect ();

protected:
	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeM_xHqqkZx_ -----
// 06.05.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	ClearTextSelection (CDC* pDC, FCObjDynabase* pObj);
	virtual void	ClearTextSelectionAll (CDC* pDC);

	virtual BOOL	SearchText (BOOL bForward, FCSearchParser& sp);

	// _my_xZkqqHx_iCmFjBePjFpLiBeBiMoDjFpLiCmMiMjPiNpFiCpAiOmAiMlLiClHiCoJiBeC_xHqqkZx_
	struct _my {
		_my (const ObjDynabaseVector& v, BOOL b) : vObj(v), bForward(b) {}
		long begin () { return bForward ? 0 : vObj.size() - 1; }
		long end () { return bForward ? vObj.size() : -1; }
		void inc (long& lIndex) { if (bForward) lIndex++; else lIndex--; }
		long find (FCObjDynabase* p)
			{
				ObjDynabaseVector::const_iterator i = std::find(vObj.begin(), vObj.end(), p);
				if (i == vObj.end()) return end();
				return long(i - vObj.begin());
			}
		const ObjDynabaseVector& vObj;
		BOOL bForward;
	};
	virtual FCObjFigure*	LoopTextSearch (BOOL bForward,
											FCSearchParser& sp,
											const ObjDynabaseVector& vObj,
											FCObjDynabase* pCurrentObj,
											long lSkipCount,
											CDC* pDC,
											FTCallbackLoopTextSearch callback);
	virtual FCObjFigure*	LoopTextSearch (BOOL bForward,
											FCSearchParser& sp,
											FCObjGroup* pGroupObj,
											FCObjDynabase* pCurrentObj,
											long lSkipCount,
											CDC* pDC,
											FTCallbackLoopTextSearch callback);

	static BOOL			SelectAllCallback (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC);
	static BOOL			FindNextCallback (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC);

protected:
	//----- _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFmPjAjE_xHqqkZx_ -----
	FCObjFigure*	m_pLastHitTextObj;	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJjCiGjFjEjFgJiCpAiKnMiCnOiBeC_xHqqkZx_
}; // class FCToolTextFindTmpl.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::FCToolTextFindTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wOperation	:_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjFjEjFgJiCmJiNhDiCkEjBiAiNoMiCmMiDhEiDiJiDePiBeC_xHqqkZx_
 *						 Subclass(ToolRotate)_xZkqqHx_iCmFiBeBiIoBiCkEjBiAiNoMjBmOiPnLiCpAjBeJjBpAiClHiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCToolTextFindTmpl<SUPER>::FCToolTextFindTmpl ()
{
//----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJiCoAiKnMiCnOiBeC_xHqqkZx_
//	m_pSearchedObj = NULL;
//----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJjCiGjFjEjFgJiCpAiKnMiCnOiBeC_xHqqkZx_
	m_pLastHitTextObj = NULL;
} // FCToolTextFindTmpl<SUPER>::FCToolTextFindTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);

//----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJiCoAiKnMiCnOiBeC_xHqqkZx_
//	m_pSearchedObj = NULL;
//----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJjCiGjFjEjFgJiCpAiKnMiCnOiBeC_xHqqkZx_
	m_pLastHitTextObj = NULL;
} // FCToolTextFindTmpl<SUPER>::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::Unselect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJpAiPjMiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::Unselect (CDC* pDC)
{
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHiCmMiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
//	ClearTextSelectionAll(pDC);
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Unselect(pDC);
} // FCToolTextFindTmpl<SUPER>::Unselect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHiCmMiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
//	ClearTextSelection(pDC, pObj);
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiMoDiCmJiMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	if (m_pLastHitTextObj != NULL && m_pLastHitTextObj->GetGroupTop() == pObj)
		m_pLastHitTextObj = NULL;
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRemoveSelectObj(pDC, pObj);
} // FCToolTextFindTmpl<SUPER>::OnRemoveSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::CanFindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::CanFindText () const
{
	return TRUE;
} // FCToolTextFindTmpl<SUPER>::CanFindText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::CanFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::CanFindNextText () const
{
	return TRUE;
} // FCToolTextFindTmpl<SUPER>::CanFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::OnFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::OnFindNextText ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (!SearchText(TRUE, *pSP))
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		switch (CFCDlgFindNextContinue().DoModal())
		{
		case IDC_FNC_BTN_FROM_TOP:		// _xZkqqHx_iBhFiNmEiCnBiPoDiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
			g_pView->ClearSelectObj(TRUE);
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_NEXT_TEXT);
			break;
		case IDC_FNC_BTN_NEXT_SHEET:	// _xZkqqHx_iBhFiOjPiDfGiBfLiDgHiBhGiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			SheetID stid = g_pDoc->GetCurrentSheetId();
			DWORD dwIdx = g_pDoc->GetSheetManager()->SheetIDToIndex(stid);
			dwIdx++;
			if (g_pDoc->GetSheetManager()->GetSheetIndexSize() <= dwIdx)
				dwIdx = 0;
			// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiBeC_xHqqkZx_
			OnMoveCurrentSheet(g_pDoc->GetSheetManager()->SheetIndexToID(dwIdx));
			// _xZkqqHx_iMjPiNpFiMhAjBlBiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiBeC_xHqqkZx_
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_NEXT_TEXT);
			break;
		  }
		}
	}
} // FCToolTextFindTmpl<SUPER>::OnFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::CanFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::CanFindPrevText () const
{
	return TRUE;
} // FCToolTextFindTmpl<SUPER>::CanFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::OnFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::OnFindPrevText ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (!SearchText(FALSE, *pSP))
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		switch (CFCDlgFindPrevContinue().DoModal())
		{
		case IDC_FPC_BTN_FROM_BOTTOM:	// _xZkqqHx_iBhFiNmEiCnBiJlKiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
			g_pView->ClearSelectObj(TRUE);
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_PREV_TEXT);
			break;
		case IDC_FPC_BTN_PREV_SHEET:	// _xZkqqHx_iBhFjBePiDfGiBfLiDgHiBhGiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			SheetID stid = g_pDoc->GetCurrentSheetId();
			DWORD dwIdx = g_pDoc->GetSheetManager()->SheetIDToIndex(stid);
			dwIdx--;
			if (dwIdx == DWORD(-1))
				dwIdx = g_pDoc->GetSheetManager()->GetSheetIndexSize() - 1;
			// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiBeC_xHqqkZx_
			OnMoveCurrentSheet(g_pDoc->GetSheetManager()->SheetIndexToID(dwIdx));
			// _xZkqqHx_iMjPiNpFiMhAjBlBiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiBeC_xHqqkZx_
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_PREV_TEXT);
			break;
		  }
		}
	}
} // FCToolTextFindTmpl<SUPER>::OnFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::CanFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::CanFindTextAll () const
{
	return TRUE;
} // FCToolTextFindTmpl<SUPER>::CanFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::OnFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClFiBeBiDhBiDgCiDgHiClFiClNjFjEjFgJiCmNjBfDiCmEjBeJjBpAiPpDjBnEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeCiCnMiClNiBeBiDhBiDgCiDgHiClFiClNjFjEjFkKiDgFiDeMiDfIiDgHiCoAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::OnFindTextAll ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;

	// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
	g_pView->ClearSelectObj(&dc);

	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDiMiDeDiDiEiBfLiCmMiOhHjCoI_xHqqkZx_ -----
	WORD wLayerOption = FDOZ_ON_EDIT;
	// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCoAiMjPiNpFiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	if (g_pReg->GetIsFindNoEditLayer())
		wLayerOption = FDOZ_ON_SELECT;
	// _xZkqqHx_iMlLiNnNiCmMiDfGiBfLiDgHiCkJiCoHiBeBiMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	g_pDoc->GetCurrentSheet()->GetZOrder(vObj, wLayerOption);
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhGiClFiCmEiBeB_xHqqkZx_SelectAllCallback_xZkqqHx_iCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
	// SelectAllCallback_xZkqqHx_iCmFiCmNiBeBiMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjBfDiCmEjBeJjBpAiClHiCoJiBeC_xHqqkZx_
	LoopTextSearch(TRUE, *pSP, vObj, NULL, 0, &dc, SelectAllCallback);

//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!g_pView->SelectObjVector().empty())
//	{
//		if (g_pView->SelectObjVector().size() < 10)
//			g_pView->AppendToLastRgn(g_pView->SelectObjVector());
//		else
//			g_pView->SetClientToRgn();
//		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmMiNmEjFgAiJoGiBeC_xHqqkZx_
//		g_pView->SendRgnRedraw();
//	}
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCToolTextFindTmpl<SUPER>::OnFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::CanFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::CanFindTextAllInSelect () const
{
	return !g_pView->SelectObjVector().empty();
} // FCToolTextFindTmpl<SUPER>::CanFindTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::OnFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClFiBeBiDhBiDgCiDgHiClFiClNjFjEjFgJiCmNjBfDiCmEjBeJjBpAiPpDjBnEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeCiCnMiClNiBeBiDhBiDgCiDgHiClFiClNjFjEjFkKiDgFiDeMiDfIiDgHiCoAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::OnFindTextAllInSelect ()
{
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	ObjDynabaseVector vObj = g_pView->SelectObjVector();
	if (!g_pReg->GetIsFindNoEditLayer())
	//----- _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCmNiMjPiNpFiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ObjDynabaseVector::iterator iObj;
		for (iObj = vObj.begin(); iObj != vObj.end();)
		{
			WORD wLayerFlag;
			g_pDoc->GetCurrentSheet()->GetLayerInfo(NULL, &wLayerFlag, g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx);
			// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCmNiMpDjFoCiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
			if (wLayerFlag & FDOZ_ON_EDIT)
				iObj++;
			else
				iObj = vObj.erase(iObj);
		}
	}
	// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
	g_pView->ClearSelectObj(&dc);
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhGiClFiCmEiBeB_xHqqkZx_SelectAllCallback_xZkqqHx_iCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
	// SelectAllCallback_xZkqqHx_iCmFiCmNiBeBiMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjBfDiCmEjBeJjBpAiClHiCoJiBeC_xHqqkZx_
	LoopTextSearch(TRUE, *pSP, vObj, NULL, 0, &dc, SelectAllCallback);
} // FCToolTextFindTmpl<SUPER>::OnFindTextAllInSelect.

//----- 06.05.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::ClearTextSelection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiImKjChFiCpAjFfMiOkGiClHiCoJiDgFiDeMiDfIiDgHiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iJpAiPjMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeCiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmNiOhHjCoIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
// *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
// *					 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiCmNiBeBiClLiCmMjBfDiCmEiCmMiDiBiDjDiDgPiBfLiCmJjBmOiClFiCmEjBeJjBpAiCkKiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolTextFindTmpl<SUPER>::ClearTextSelection (CDC* pDC, FCObjDynabase* pObj)
//{
////----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHiCmMiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
////	if (m_pLastHitTextObj != NULL)
////	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjBeJjBpAjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCmMiJpAiPjMiBeC_xHqqkZx_
////		m_pLastHitTextObj->GetRichText()->ClearSelection(NULL);
////		// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHiCmMiNmEjFgAiJoGiBeC_xHqqkZx_
////		g_pView->AppendToLastRgn(m_pLastHitTextObj);
//////----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//////		// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJiCoAiKnMiCnOiBeC_xHqqkZx_
//////		m_pSearchedObj = NULL;
//////----- 05.06.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////		// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJjCiGjFjEjFgJiCpAiKnMiCnOiBeC_xHqqkZx_
////		m_pLastHitTextObj = NULL;
////		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
////		g_pView->SendRgnRedraw();
////	}
////----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	ASSERT(pObj->GetGroupParent() == NULL);
////	ObjDynabaseVector vObj;
////	pObj->GetKindOfMembers(vObj, FDOJ_FIGURE);
////	ObjDynabaseVector::iterator iObj;
////	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
////	{
////		if (((FCObjFigure*)*iObj)->GetRichText() != NULL)
////		{
////			((FCObjFigure*)*iObj)->GetRichText()->ClearSelection(pDC);
////		}
////	}
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	pObj->ClearTextSelection(pDC);
////----- 06.03.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHjFjEjFgJiCmMiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
//	if (m_pLastHitTextObj != NULL && m_pLastHitTextObj->GetGroupTop() == pObj)
//		m_pLastHitTextObj = NULL;
////----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolTextFindTmpl<SUPER>::ClearTextSelection.
//----- 06.05.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::ClearTextSelectionAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBeJjBpAjFjEjFgJiCmMiBeBiDgFiDeMiDfIiDgHjFjEjFkKjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *					 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiCmNiBeBiClLiCmMjBfDiCmEiCmMiDiBiDjDiDgPiBfLiCmJjBmOiClFiCmEjBeJjBpAiCkKiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolTextFindTmpl<SUPER>::ClearTextSelectionAll (CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiDgFiDeMiDfIiDgHiCmMiJpAiPjMiPiIjHjNiBeC_xHqqkZx_
	ObjDynabaseVector::const_iterator iObj;
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//		ClearTextSelection(pDC, *iObj);
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
		(*iObj)->ClearTextSelection(pDC);
	// _xZkqqHx_iNmFiMoDiCmJiMjPiNpFiDhBiDgCiDgHiClFiClNjFjEjFgJiCoAiJpAiPjMiBeC_xHqqkZx_
	m_pLastHitTextObj = NULL;
//----- 06.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolTextFindTmpl<SUPER>::ClearTextSelectionAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::SearchText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCpAiMjPiNpFiClHiCoJiBeCiMjPiNpFiClFiCmEiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAjBeJjBpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bForward	:_xZkqqHx_jBePjFpLiCkJiCoHiMoDjFpLiCnGiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiMoDjFpLiCkJiCoHjBePjFpLiCnG_xHqqkZx_
 *						 _xZkqqHx_iMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			sp			:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::SearchText (BOOL bForward, FCSearchParser& sp)
{
	// DC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);

	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDiMiDeDiDiEiBfLiCmMiOhHjCoI_xHqqkZx_ -----
	WORD wLayerOption = FDOZ_ON_EDIT;
	// _xZkqqHx_jFnCiPfHjFhDiJmCiDiMiDeDiDiEiBfLiCoAiMjPiNpFiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	if (g_pReg->GetIsFindNoEditLayer())
		wLayerOption = FDOZ_ON_SELECT;
	// _xZkqqHx_iMlLiNnNiCmMiDfGiBfLiDgHiCkJiCoHiBeBiMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	g_pDoc->GetCurrentSheet()->GetZOrder(vObj, wLayerOption);
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhGiClFiCmEiBeB_xHqqkZx_SelectAllCallback_xZkqqHx_iCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_

	FCObjFigure* pNextHitText;
	if (m_pLastHitTextObj != NULL)
		pNextHitText = LoopTextSearch(bForward, sp, vObj, m_pLastHitTextObj, 1, &dc, FindNextCallback);
	else
	if (!g_pView->SelectObjVector().empty())
		pNextHitText = LoopTextSearch(bForward, sp, vObj, g_pView->SelectObjVector().back(), 0, &dc, FindNextCallback);
	else
		pNextHitText = LoopTextSearch(bForward, sp, vObj, NULL, 0, &dc, FindNextCallback);
	if (pNextHitText != NULL)
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiDhBiDgCiDgHiClFiClNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCmMiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_
		m_pLastHitTextObj = pNextHitText;
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCkKiDhCiDiFiBfLiCmJiOpLiCnMiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBjFiMmFjHeMiDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiBeC_xHqqkZx_
		DWORDSet stObjId;
		stObjId.insert(pNextHitText->GetObjID());
		g_pView->ScrollToObject(stObjId);
		return TRUE;
	}
	return FALSE;
} // FCToolTextFindTmpl<SUPER>::SearchText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::LoopTextSearch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCpAiMjPiNpFiClHiCoJiBeCiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiIpIjAjEiCmGiClFiCmE_xHqqkZx_
 *			callback_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bForward	:_xZkqqHx_jBePjFpLiCkJiCoHiMoDjFpLiCnGiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiMoDjFpLiCkJiCoHjBePjFpLiCnG_xHqqkZx_
 *						 _xZkqqHx_iMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			sp			:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			vObj		:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCurrentObj	:_xZkqqHx_iMlLiNnNiCmMjFjEjFgJiCpAiOhHjCoIiBeCiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCpAiOhHjCoI_xHqqkZx_
 *						 _xZkqqHx_iClHiCoJiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_vObj_xZkqqHx_iCmMiNmFiPiJiCkJiCoHiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *						 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSkipCount	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmMiDeJiDhEiDfKiDgCiDgHiDeKiDeFiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 0_xZkqqHx_iImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_pCurrentObj _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
 *						 _xZkqqHx_iCkCiCoJiPoKiNiHiCmN_xHqqkZx_ pCurrentObj + lSkipCount _xZkqqHx_iCkJiCoHiMjPiNpFiKeKiOgOiBeC_xHqqkZx_
 *						 pCurrentObj = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
 *						 vObj.begin() + lSkipCount _xZkqqHx_iCkJiCoHiMjPiNpFiKeKiOgOiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			callback	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCObjFigure* FCToolTextFindTmpl<SUPER>::LoopTextSearch (BOOL bForward,
														FCSearchParser& sp,
														const ObjDynabaseVector& vObj,
														FCObjDynabase* pCurrentObj,
														long lSkipCount,
														CDC* pDC,
														FTCallbackLoopTextSearch callback)
{
	// _my_xZkqqHx_iCmFjBePjFpLiBeBiMoDjFpLiCmMiMjPiNpFiCpAiOmAiMlLiClHiCoJiBeC_xHqqkZx_
	_my my(vObj, bForward);

	long lIndex = my.begin();
	if (pCurrentObj != NULL)
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjBeJjBpAjCiGiCmMjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (pCurrentObj->GetGroupParent() != NULL)
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiCfAjFjEjFgJiCkKjBeJjBpAjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOjPiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
			FCObjFigure* pLastObj = LoopTextSearch(bForward, sp, (FCObjGroup*)pCurrentObj->GetGroupTop(), pCurrentObj, lSkipCount, pDC, callback);
			// _xZkqqHx_iPeJjHlJiOjOiCmMjFjEjFgJiCkKjFnEiClDiCoKiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (pLastObj != NULL) return pLastObj;
			// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiOjPiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
			lIndex = my.find(pCurrentObj->GetGroupTop());
			if (lIndex != my.end())
				my.inc(lIndex);
		} else
		//----- _xZkqqHx_jCmKiPoNiCmMjFjEjFgJiCkKjBeJjBpAjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
			lIndex = my.find(pCurrentObj->GetGroupTop());
			// lSkipCount_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFkKiBeB_xHqqkZx_lIndex_xZkqqHx_iCpAjAoGiCmJjBjHiCoJiBeC_xHqqkZx_
			for (; lIndex != my.end() && lSkipCount != 0; lSkipCount--, my.inc(lIndex));
		}
	}

	//----- _xZkqqHx_jBfDiMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	for (; lIndex != my.end(); my.inc(lIndex))
	{
		if (vObj[lIndex]->IsKindOf(FDOJ_FIGURE))
		//----- _xZkqqHx_jFjEjFgJiCkK_xHqqkZx_ObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FCRichText* pText = ((FCObjFigure*)vObj[lIndex])->GetRichText();
			if (pText != NULL)
			//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
				// _xZkqqHx_iMjPiNpFjCoCiOhOiCkKiOhHiOkGiClDiCoKiClNiPoKiNiHiCmNiBeBiMlLiNnNiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
				if (!(*callback)(sp, (FCObjFigure*)vObj[lIndex], pDC))
					return (FCObjFigure*)vObj[lIndex];
			}
		} else
		if (vObj[lIndex]->IsKindOf(FDOJ_GROUP))
		//----- _xZkqqHx_jFjEjFgJiCkK_xHqqkZx_ObjGroup_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOjPiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
			FCObjFigure* pLastObj = LoopTextSearch(bForward, sp, (FCObjGroup*)vObj[lIndex], NULL, 0, pDC, callback);
			// _xZkqqHx_iPeJjHlJiOjOiCmMjFjEjFgJiCkKjFnEiClDiCoKiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (pLastObj != NULL)
				return pLastObj;
		}
	}
	return NULL;
} // FCToolTextFindTmpl<SUPER>::LoopTextSearch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::LoopTextSearch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLjCiGiCmFiBeBiDgFiDeMiDfIiDgHjFjEjFgJiCpAjBePjFpLiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iMoDjFpLiCnGiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiBeCiDgFiDeMiDfIiDgHiCpAiOjNiCmCjFjEjFgJiCpAiIpIjAjEiCmGiClFiCmE_xHqqkZx_
 *			callback_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp			:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pGroupObj	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDePiDiLiBfLiDhGjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCurrentObj	:_xZkqqHx_iMlLiNnNiCmMjFjEjFgJiCpAiOhHjCoIiBeCiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDiBiDjDiDgPiBfLiCmMiNmFiPiJiCkJiCoHiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSkipCount	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmMiDeJiDhEiDfKiDgCiDgHiDeKiDeFiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 0_xZkqqHx_iImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_pCurrentObj _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
 *						 _xZkqqHx_iCkCiCoJiPoKiNiHiCmN_xHqqkZx_ pCurrentObj + lSkipCount _xZkqqHx_iCkJiCoHiMjPiNpFiKeKiOgOiBeC_xHqqkZx_
 *						 pCurrentObj = NULL _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
 *						 _xZkqqHx_iDiBiDjDiDgPiBfLjAoGjDkK_xHqqkZx_ + lSkipCount _xZkqqHx_iCkJiCoHiMjPiNpFiKeKiOgOiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			callback	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCObjFigure* FCToolTextFindTmpl<SUPER>::LoopTextSearch (BOOL bForward,
														FCSearchParser& sp,
														FCObjGroup* pGroupObj,
														FCObjDynabase* pCurrentObj,
														long lSkipCount,
														CDC* pDC,
														FTCallbackLoopTextSearch callback)
{
	// ObjGroup_xZkqqHx_jCiGiCmMiBeBjBfDiCmEiCmMjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	// _xZkqqHx_iDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAjBmOiPnLiCmJiJmBiCkGiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// FCObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
	if (g_pReg->GetIsFindChipText())
		pGroupObj->GetKindOfMembers(vObj, FDOJ_FIGURE);
	else
		pGroupObj->GetCanBeTextObject(vObj);

	// _my_xZkqqHx_iCmFjBePjFpLiBeBiMoDjFpLiCmMiMjPiNpFiCpAiOmAiMlLiClHiCoJiBeC_xHqqkZx_
	_my my(vObj, bForward);

	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoKiCmOiBeBiClLiCmMjFjEjFgJiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
	long lIndex = my.begin();
	if (pCurrentObj != NULL)
	//----- _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (; lIndex != my.end() && vObj[lIndex] != pCurrentObj; my.inc(lIndex));
		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjFmPiNfIiClFiClNiPoKiNiHiBgJiDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCpAiMjPiNpFjBmOiPnLiCkJiCoHiKePiClHiCmIiCmHiBgKiBeB_xHqqkZx_
		// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_lIndex = end() _xZkqqHx_iCmGiCmIiCoJiCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	}
	// lSkipCount_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFkKiBeB_xHqqkZx_lIndex_xZkqqHx_iCpAjAoGiCmJjBjHiCoJiBeC_xHqqkZx_
	for (; lIndex != my.end() && lSkipCount != 0; lSkipCount--, my.inc(lIndex));
	for (; lIndex != my.end(); my.inc(lIndex))
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjPiCmMjFjEjFgJiImIiNhOiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		ASSERT(vObj[lIndex]->IsKindOf(FDOJ_FIGURE));
		FCRichText* pText = ((FCObjFigure*)vObj[lIndex])->GetRichText();
		if (pText != NULL)
		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
			// _xZkqqHx_iMjPiNpFjCoCiOhOiCkKiOhHiOkGiClDiCoKiClNiPoKiNiHiCmNiBeBiMlLiNnNiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
			if (!(*callback)(sp, (FCObjFigure*)vObj[lIndex], pDC))
				return (FCObjFigure*)vObj[lIndex];
		}
	}
	return NULL;
} // FCToolTextFindTmpl<SUPER>::LoopTextSearch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::SelectAllCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FTCallbackLoopTextSearch_xZkqqHx_iMfOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeCiDgFiDeMiDfIiDgHiMjPiNpFjBfDjBeJjBpA_xHqqkZx_
 *			_xZkqqHx_iCmJiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp		:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTextObj:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDiLiBfLiDhGiCpAiMhAjBlBiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiDfCiBfLiDiLiDgPiDgCiDeOjClMiMoDiCmJiPeJjHlJiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pTextObj_xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCmMiPoKiNiHiCoAiCkAiCoJiBeCjFeLiClIiDgFiDeMiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOjNiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::SelectAllCallback (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC)
{
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// UNICODE_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	WString strTarget;
//	pTextObj->GetRichText()->GetText(strTarget, FALSE, TRUE);
//	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFlGiOjKiImKjChFiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
//	longRangeVector vHitRange;
//	sp.GetMatchingPos(vHitRange, strTarget.c_str());
//	if (!vHitRange.empty())
//	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiJnDiPiKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		longRangeVector::iterator iRg;
//		for (iRg = vHitRange.begin(); iRg != vHitRange.end(); iRg++)
//		{
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCmMjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendTextSelection(pTextObj->GetObjID(), (*iRg).lFrom, (*iRg).lTo);
//		}
//		// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAjAnNjCoIiBeCiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
//		// GetGroupTop_xZkqqHx_iKnGjAjEiCmMiMiLiJmKiCpAjDgPjIfOiBeC_xHqqkZx_
//		g_pView->AppendSelectObj(pTextObj->GetGroupTop(), pDC);
//	}
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// UNICODE_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	WString wstrTarget;
	pTextObj->GetRichText()->GetText(wstrTarget, FALSE, TRUE);
	// _xZkqqHx_iCnMiClI_xHqqkZx_ IsMatch _xZkqqHx_iCmFjClCiCnHiCoJiBeCjFkBjAjEjCfAiMoKjDjJiCmMiOhHjCoIiCkKiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
	// GetMatchingPos _xZkqqHx_iCmMiCnNiCmFjClCiCnHiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	if (sp.IsMatch(wstrTarget.c_str()) == 1)
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFlGiOjKiImKjChFiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
		longRangeVector vHitRange;
		sp.GetMatchingPos(vHitRange, wstrTarget.c_str());
		if (!vHitRange.empty())
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiJnDiPiKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			longRangeVector::iterator iRg;
			for (iRg = vHitRange.begin(); iRg != vHitRange.end(); iRg++)
			{
				// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCmMjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendTextSelection(pTextObj->GetObjID(), (*iRg).lFrom, (*iRg).lTo);
			}
		}
		// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAjAnNjCoIiBeCiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
		// GetGroupTop_xZkqqHx_iKnGjAjEiCmMiMiLiJmKiCpAjDgPjIfOiBeC_xHqqkZx_
		// _xZkqqHx_iBhF_xHqqkZx_not /xxx/ and not /yyy/_xZkqqHx_iBhGiCmMiCoGiCkEiCmJiBeBiDgFiDeMiDfIiDgHjBeJjBpAiCkKjGlDiCkNiCmEiCoA_xHqqkZx_
		// _xZkqqHx_jFjEjFgJjBeJjBpAiCkKjAlGiClGiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		g_pView->AppendSelectObj(pTextObj->GetGroupTop(), pDC);
	}
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iOjPiCmMiMjPiNpFiCpAjBlBiCkPiCoJiBeC_xHqqkZx_
	return TRUE;
} // FCToolTextFindTmpl<SUPER>::SelectAllCallback.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTextFindTmpl<SUPER>::FindNextCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FTCallbackLoopTextSearch_xZkqqHx_iMfOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeCiDgFiDeMiDfIiDgHiMjPiNpFiCmJiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp		:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTextObj:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDiLiBfLiDhGiCpAiMhAjBlBiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiDfCiBfLiDiLiDgPiDgCiDeOjClMiMoDiCmJiPeJjHlJiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pTextObj_xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCmMiPoKiNiHiCoAiCkAiCoJiBeCjFeLiClIiDgFiDeMiDfIiDgH_xHqqkZx_
 *			_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOjNiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolTextFindTmpl<SUPER>::FindNextCallback (FCSearchParser& sp, FCObjFigure* pTextObj, CDC* pDC)
{
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// UNICODE_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	WString wstrTarget;
//	pTextObj->GetRichText()->GetText(wstrTarget, FALSE, TRUE);
//	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFlGiOjKiImKjChFiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
//	longRangeVector vHitRange;
//	sp.GetMatchingPos(vHitRange, wstrTarget.c_str());
//	if (!vHitRange.empty())
//	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiJnDiPiKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
//		g_pView->ClearSelectObj(TRUE);
//		longRangeVector::iterator iRg;
//		for (iRg = vHitRange.begin(); iRg != vHitRange.end(); iRg++)
//		{
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCmMjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendTextSelection(pTextObj->GetObjID(), (*iRg).lFrom, (*iRg).lTo);
//		}
//		// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAjAnNjCoIiBeCiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
//		// GetGroupTop_xZkqqHx_iKnGjAjEiCmMiMiLiJmKiCpAjDgPjIfOiBeC_xHqqkZx_
//		g_pView->AppendSelectObj(pTextObj->GetGroupTop(), pDC);
//		// _xZkqqHx_iIoKiCmCiDhBiDgCiDgHiClHiCoKiCmOiBeBiOjPiCmMiMjPiNpFiCmNiClFiCmIiCkCiBeC_xHqqkZx_
//		return FALSE;
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeBiOjPiCmMiMjPiNpFiCpAjBlBiCkPiCoJiBeC_xHqqkZx_
//	return TRUE;
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// UNICODE_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	WString wstrTarget;
	pTextObj->GetRichText()->GetText(wstrTarget, FALSE, TRUE);
	// _xZkqqHx_iCnMiClI_xHqqkZx_ IsMatch _xZkqqHx_iCmFjClCiCnHiCoJiBeCjFkBjAjEjCfAiMoKjDjJiCmMiOhHjCoIiCkKiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
	// GetMatchingPos _xZkqqHx_iCmMiCnNiCmFjClCiCnHiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	if (sp.IsMatch(wstrTarget.c_str()) == 1)
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeCiMiLiJmKiBeB_xHqqkZx_m_pLastHitTextObj _xZkqqHx_iCoAiJpAiPjMiClDiCoKiCoJiBeC_xHqqkZx_
		g_pView->ClearSelectObj(TRUE);

		// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFlGiOjKiImKjChFiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
		longRangeVector vHitRange;
		sp.GetMatchingPos(vHitRange, wstrTarget.c_str());
		if (!vHitRange.empty())
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiJnDiPiKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			longRangeVector::iterator iRg;
			for (iRg = vHitRange.begin(); iRg != vHitRange.end(); iRg++)
			{
				// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjEmNiImNiCmMjAnNjCoIiBeC_xHqqkZx_
				g_pView->AppendTextSelection(pTextObj->GetObjID(), (*iRg).lFrom, (*iRg).lTo);
			}
		}
		// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAjAnNjCoIiBeCiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
		// GetGroupTop_xZkqqHx_iKnGjAjEiCmMiMiLiJmKiCpAjDgPjIfOiBeC_xHqqkZx_
		// _xZkqqHx_iBhF_xHqqkZx_not /xxx/ and not /yyy/_xZkqqHx_iBhGiCmMiCoGiCkEiCmJiBeBiDgFiDeMiDfIiDgHjBeJjBpAiCkKjGlDiCkNiCmEiCoA_xHqqkZx_
		// _xZkqqHx_jFjEjFgJjBeJjBpAiCkKjAlGiClGiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		g_pView->AppendSelectObj(pTextObj->GetGroupTop(), pDC);
		// _xZkqqHx_iIoKiCmCiDhBiDgCiDgHiClHiCoKiCmOiBeBiOjPiCmMiMjPiNpFiCmNiClFiCmIiCkCiBeC_xHqqkZx_
		return FALSE;
	}
	// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeBiOjPiCmMiMjPiNpFiCpAjBlBiCkPiCoJiBeC_xHqqkZx_
	return TRUE;
//----- 06.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolTextFindTmpl<SUPER>::FindNextCallback.

#endif//__ToolTextFindTmpl_h
