#include "stdafx.h"

#ifdef _DD_PRO

#include "DynamicDraw.h"		// For FFGetApp.
#include "UtilGraph.h"			// For FCEditDraw.
#include "UtilObj.h"			// For FFGetFramePoint.
#include "FoundDoc.h"			// For g_pDoc.
#include "HistViewDoc.h"		// For FFHistViewDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "TimeLabel.h"			// For FCTimeLabel.
#include "ToolTimeLabel.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::CanSelectTool () const
{
	// _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkPiCoKiCmOiClBiCmMiDgDiBfLiDiLiCmMjBeJjBpAiCmNjFhDiJmCiBeC_xHqqkZx_
	// _xZkqqHx_iClNiClOiClFiBeB_xHqqkZx_ReadOnly_xZkqqHx_iCmFiCoAiDgDiBfLiDiLjBeJjBpAiCmNiJmCjEfMiBeC_xHqqkZx_
	if (!g_pDoc->GetIsDocumentOpened()) return FALSE;
	return TRUE;
} // FCToolTimeLabel::CanSelectTool.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolTimeLabel::OnDraw (CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//	longVector vSelectedLabelId;
//	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
//	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
//	longVector::const_iterator iId;
//	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
//		DrawSelectMark(pDC, *iId);
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolTimeLabel::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::Select (CDC* pDC)
{
	// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	// BASE_CLASS::Unselect_xZkqqHx_iBgA_xHqqkZx_BASE_CLASS::Select_xZkqqHx_iCmMiKnEiCmN_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCkKiPmBiLiOiClDiCoKiCmEiCkCiCoJiCmMiCmFiBeBiNmEjFgAiJoGiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
	g_pView->ClearSelectObj();

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
} // FCToolTimeLabel::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::Unselect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJpAiPjMiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::Unselect (CDC* pDC)
{
	// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	UnselectXXX(XXX_TIME_LABEL, InvalidValueXXX(XXX_TIME_LABEL), pDC);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Unselect(pDC);
} // FCToolTimeLabel::Unselect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::CanDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlNiCkJiClFiCoHiNoNiPjMiJmCjEfMiCmIiCoAiCmMiCpAjBeJjBpAjCiGiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiDiBiDgKiDiFiBfLiCmMjHeMiMpIiBfOjGlDiMpIiCpAjAnIiCoIjBnGiCkGiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjHeMiCoJiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjGlDiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::CanDelete () const
{
	// _xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeC_xHqqkZx_
	return	g_pDoc->GetIsDocumentOpened() &&
			(GetCurrentState() == STATE_IDLE ||
			 GetCurrentState() == STATE_CONTEXT_MENU ||
			 GetCurrentState() == STATE_CONTEXT_MENU_LINK) &&
			GetSelectedXXX(XXX_TIME_LABEL) != 0 &&
			FFCanBasicOperate();
} // FCToolTimeLabel::CanDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFkIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::OnDelete (CDC* pDC)
{
	// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
	if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		longVector vSelectedLabelId;
		GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
		WStringVector vLabelText;
		DBLPointVector vLabelPoint;
		longVector::const_iterator iId;
		for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
		{
			vLabelText.push_back(FFHistViewDoc()->GetTimeLabel(*iId)->GetLabelText());
			vLabelPoint.push_back(FFHistViewDoc()->GetTimeLabel(*iId)->GetCenterPoint());
		}
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
		// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjM_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DELETE_TIME_LABELS,
									FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
									FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
// 06.02.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//									FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndex(),
									FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndexAbout(),
									FCReqBase::TIME_LABEL_ID_VECTOR, &vSelectedLabelId,
									FCReqBase::TIME_LABEL_TEXT_VECTOR, &vLabelText,
									FCReqBase::MM_POINT_VECTOR, &vLabelPoint,
									FCReqBase::NONE);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
} // FCToolTimeLabel::OnDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::CanObjectPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCpAjEhKjChFiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::CanObjectPutTimeLabel () const
{
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiCmIiCmMiCmFiBeBjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCoAjClCiCnHiCoJiBeC_xHqqkZx_
	return g_pDoc->GetIsDocumentOpened() &&
			(GetCurrentState() == STATE_IDLE ||
			 GetCurrentState() == STATE_CONTEXT_MENU ||
			 GetCurrentState() == STATE_CONTEXT_MENU_LINK) &&
			FFCanEditProject();
} // FCToolTimeLabel::CanObjectPutTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnObjectPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCpAjEhKjChFiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::OnObjectPutTimeLabel ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// [_xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLjAnNjCoI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(	ID_DREQ_REGISTER_TEMP_TIME_LABEL,
//								FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
//								FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
//								FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndex(),
//								FCReqBase::SHEET_ID, g_pDoc->GetCurrentSheetId(),
//								FCReqBase::MM_X, g_pView->GetLastPoint().x,
//								FCReqBase::MM_Y, g_pView->GetLastPoint().y,
//								FCReqBase::NONE);
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjAnNjCoIiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_PUT_TIME_LABEL,
								FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
								FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
// 06.02.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndex(),
								FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndexAbout(),
								FCReqBase::SHEET_ID, g_pDoc->GetCurrentSheetId(),
								FCReqBase::MM_X, g_pView->GetLastPoint().x,
								FCReqBase::MM_Y, g_pView->GetLastPoint().y,
								FCReqBase::NONE);

	// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
								FCReqBase::RETURN, IDOK,
								FCReqBase::NONE);

		// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjAnNjCoIiClHiCoJ_xHqqkZx_]_xZkqqHx_iCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_PUT_TIME_LABEL);
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);

	// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // FCToolTimeLabel::OnObjectPutTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::CanObjectTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::CanObjectTimeLabelProperty () const
{
	return	g_pDoc->GetIsDocumentOpened() &&
			(GetCurrentState() == STATE_IDLE ||
			 GetCurrentState() == STATE_CONTEXT_MENU ||
			 GetCurrentState() == STATE_CONTEXT_MENU_LINK) &&
			GetSelectedXXX(XXX_TIME_LABEL) == 1 &&
			FFCanBasicOperate();
} // FCToolTimeLabel::CanObjectTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnObjectTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::OnObjectTimeLabelProperty ()
{
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	longVector vSelectedLabelId;
//	if (GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId) != 1)
//		return;
//	const FCTimeLabel* pTimeLabel = FFHistViewDoc()->GetTimeLabel(vSelectedLabelId[0]);
//	//----- _xZkqqHx_jDpMjHmNjHhAiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_ -----
//	CFCDlgTimeLabel dlg(FALSE);
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	dlg.Initialize(	*g_pProject,
//					FFHistViewDoc()->GetDocumentId(),
//					FFHistViewDoc()->GetNextSessionIndex(),
//					pTimeLabel->GetLabelText(),
//					pTimeLabel->GetCreateTime(),
//					pTimeLabel->GetUserId());
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//	if (dlg.DoModal() == IDOK)
//	{
//		WStringVector vLabelTextOld;
//		WStringVector vLabelText;
//		DBLPointVector vLabelPoint;
//		vLabelTextOld.push_back(pTimeLabel->GetLabelText());
//		vLabelText.push_back(TStrToWStr(dlg.m_strLabel));
//		vLabelPoint.push_back(pTimeLabel->GetCenterPoint());
//
//		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//		// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFmPiNfI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_TIME_LABEL,
//									FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
//									FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
//									FCReqBase::TIME_LABEL_ID_VECTOR, &vSelectedLabelId,
//									FCReqBase::MM_POINT_VECTOR_OLD, &vLabelPoint,
//									FCReqBase::MM_POINT_VECTOR, &vLabelPoint,
//									FCReqBase::TIME_LABEL_TEXT_VECTOR_OLD, &vLabelTextOld,
//									FCReqBase::TIME_LABEL_TEXT_VECTOR, &vLabelText,
//									FCReqBase::NONE);
//		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END);
//		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//		g_pDoc->ProceedDocRequest();
//	}
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	longVector vSelectedLabelId;
	if (GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId) != 1)
		return;
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);

	// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_TIME_LABEL_PROPERTY,
								FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
								FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
// 06.02.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndex(),
								FCReqBase::SESSION_INDEX, FFHistViewDoc()->GetNextSessionIndexAbout(),
								FCReqBase::TIME_LABEL_ID, vSelectedLabelId[0],
								FCReqBase::NONE);
	// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
								FCReqBase::RETURN, IDOK,
								FCReqBase::NONE);

		// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFmPiNfI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_CHANGE_TIME_LABEL);
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);

	// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolTimeLabel::OnObjectTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_PUT_TIME_LABEL:
	case ID_OBJECT_TIME_LABEL_PROPERTY:
		return TRUE;
	default:
		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
	}
} // FCToolTimeLabel::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_/_xZkqqHx_iPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::DrawSelectMark (CDC* pDC, long lId) const
{
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	const CRect lgrt = mm2lg(FFHistViewDoc()->GetTimeLabel(lId)->GetFrame());
	eDraw.GeneralMark(CPoint(lgrt.left, lgrt.top));
	eDraw.GeneralMark(CPoint(lgrt.left, lgrt.bottom));
	eDraw.GeneralMark(CPoint(lgrt.right, lgrt.top));
	eDraw.GeneralMark(CPoint(lgrt.right, lgrt.bottom));
} // FCToolTimeLabel::DrawSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::InvalidValueXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolTimeLabel::InvalidValueXXX (XXX_TimeLabel) const
{
	return -1;
} // FCToolTimeLabel::InvalidValueXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::GetSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector/set _xZkqqHx_iCmMiCkCiClIiCoKiCmMiMgAiOkOiCmFiCoAjCgMiCpAjFnEiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolTimeLabel::GetSelectedXXX (XXX_TimeLabel, vector<long>* vXxx, set<long>* stXxx) const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	longSet stId;
	FFHistViewDoc()->GetSelectedTimeLabelId(stId);
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		FFPushBack(*vXxx, stId);
	}
	if (stXxx != NULL)
	//----- stXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		stXxx->clear();
		*stXxx = stId;
	}
	return stId.size();
} // FCToolTimeLabel::GetSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::GetSelectableXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolTimeLabel::GetSelectableXXX (XXX_TimeLabel, vector<long>* vXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		// _xZkqqHx_jBfDiCmEiCmMiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		longSet stId;
		FFHistViewDoc()->GetAllTimeLabelId(stId);
		FFPushBack(*vXxx, stId);
		return stId.size();
	} else
	//----- vXxx _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return FFHistViewDoc()->GetTimeLabelCount();
	}
} // FCToolTimeLabel::GetSelectableXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::SelectXXX (XXX_TimeLabel, long xxx, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmMiOjOiKnEiDiJiDhIiDiLiCmFiCkAiCoKiCmOiBeBiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (FFHistViewDoc()->IsSelectedTimeLabel(xxx)) return;
	// _xZkqqHx_jBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	FFHistViewDoc()->SelectTimeLabel(xxx);
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
	if (pDC != NULL) DrawSelectMark(pDC, xxx);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SelectXXX(XXX_TIME_LABEL, xxx, pDC);
} // FCToolTimeLabel::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeCjBfDiCmEiJpAiPjMiClHiCoJiPoKiNiHiCmN_xHqqkZx_InvalidValueXXX()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::UnselectXXX (XXX_TimeLabel, long xxx, CDC* pDC)
{
	if (xxx == InvalidValueXXX(XXX_TIME_LABEL))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjBfDiCmEiPmBiLiOiBeC_xHqqkZx_
		if (pDC != NULL)
		{
			// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
			longSet stId;
			FFHistViewDoc()->GetSelectedTimeLabelId(stId);
			longSet::const_iterator iId;
			for (iId = stId.begin(); iId != stId.end(); iId++)
				DrawSelectMark(pDC, *iId);
		}
		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		FFHistViewDoc()->UnselectAllTimeLabel();
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jGkCjBeJjBpAiCmMiOjOiKnEiDiJiDhIiDiLiCmFiCkAiCoKiCmOiBeBiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
		if (!FFHistViewDoc()->IsSelectedTimeLabel(xxx)) return;
		// _xZkqqHx_jBeJjBpAiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		FFHistViewDoc()->UnselectTimeLabel(xxx);
		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
		if (pDC != NULL) DrawSelectMark(pDC, xxx);
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnselectXXX(XXX_TIME_LABEL, xxx, pDC);
} // FCToolTimeLabel::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::GetFrameRectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCToolTimeLabel::GetFrameRectXXX (XXX_TimeLabel, long xxx) const
{
	return FFHistViewDoc()->GetTimeLabel(xxx)->GetFrame();
} // FCToolTimeLabel::GetFrameRectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::CanMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolTimeLabel::CanMoveXXX (XXX_TimeLabel) const
{
	// _xZkqqHx_iDeJiDhJiDiMiBfLiDgHiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	return FFCanBasicOperate();
} // FCToolTimeLabel::CanMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::DrawFirstImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::DrawFirstImageXXX (XXX_TimeLabel, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	longVector vSelectedLabelId;
	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
	longVector::const_iterator iId;
	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
	{
		// _xZkqqHx_iInKjDkOjCiGiCmMiOjOiKnEiDiJiDhIiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
		FCEditDraw(pDC, 0).RectLine(mm2lg(GetFrameRectXXX(XXX_TIME_LABEL, *iId)));
	}
} // FCToolTimeLabel::DrawFirstImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::RedrawMovingImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMove=(0,0)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjFfMiOkGjFgAiJoGiCmMiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
 *			Tool::OnDraw _xZkqqHx_iCmFiCmMjFgAiJoGiPiIjHjNjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::RedrawMovingImageXXX (XXX_TimeLabel, const DBLPoint& mmptMove, CDC* pDC)
{
	const DBLPoint mmptOffset = m_mmrtLastFrame.GetLeftTop() - m_mmrtFirstFrame.GetLeftTop();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	longVector vSelectedLabelId;
	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
	longVector::const_iterator iId;

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!mmptMove.IsNull())
	//----- _xZkqqHx_iInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOjBePiCmMjEpBjFfMiOkGjFgAiJoGiBeC_xHqqkZx_
		for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
			FCEditDraw(pDC, 0).RectLine(mm2lg(GetFrameRectXXX(XXX_TIME_LABEL, *iId) + mmptOffset));

// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	}
	// _xZkqqHx_iInKjDkOiMoDiCmMjFfMiOkGjFgAiJoGiBeC_xHqqkZx_
	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
		FCEditDraw(pDC, 0).RectLine(mm2lg(GetFrameRectXXX(XXX_TIME_LABEL, *iId) + mmptOffset + mmptMove));
} // FCToolTimeLabel::RedrawMovingImageXXX.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnDrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolTimeLabel::OnDrawMovingImageXXX (XXX_TimeLabel, CDC* pDC)
//{
//	const DBLPoint mmptOffset = m_mmrtLastFrame.GetLeftTop() - m_mmrtFirstFrame.GetLeftTop();
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	longVector vSelectedLabelId;
//	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
//	longVector::const_iterator iId;
//	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
//		FCEditDraw(pDC, 0).RectLine(mm2lg(GetFrameRectXXX(XXX_TIME_LABEL, *iId) + mmptOffset));
//} // FCToolTimeLabel::OnDrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::DrawLastImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::DrawLastImageXXX (XXX_TimeLabel, CDC* pDC)
{
	const DBLPoint mmptOffset = m_mmrtLastFrame.GetLeftTop() - m_mmrtFirstFrame.GetLeftTop();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	longVector vSelectedLabelId;
	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
	longVector::const_iterator iId;
	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
		FCEditDraw(pDC, 0).RectLine(mm2lg(GetFrameRectXXX(XXX_TIME_LABEL, *iId) + mmptOffset));
} // FCToolTimeLabel::DrawLastImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::MoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx		:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vmmptMove	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::MoveXXX (XXX_TimeLabel, const longVector& vXxx, const DBLPointVector& vmmptMove)
{
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WStringVector vLabelText;
	DBLPointVector vLabelPoint;
	DBLPointVector vLabelPointNew;
	long lC;
	for (lC = 0; lC != vXxx.size(); lC++)
	{
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		vLabelText.push_back(FFHistViewDoc()->GetTimeLabel(vXxx[lC])->GetLabelText());
		vLabelPoint.push_back(FFHistViewDoc()->GetTimeLabel(vXxx[lC])->GetCenterPoint());
		vLabelPointNew.push_back(vLabelPoint.back() + vmmptMove[lC]);
	}

	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFmPiNfI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_TIME_LABEL,
//								FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
//								FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
//								FCReqBase::TIME_LABEL_ID_VECTOR, &vXxx,
//								FCReqBase::MM_POINT_VECTOR_OLD, &vLabelPoint,
//								FCReqBase::MM_POINT_VECTOR, &vLabelPointNew,
//								FCReqBase::TIME_LABEL_TEXT_VECTOR_OLD, &vLabelText,
//								FCReqBase::TIME_LABEL_TEXT_VECTOR, &vLabelText,
//								FCReqBase::NONE);
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	g_pDoc->PushBackDocRequest(	ID_DREQ_MOVE_TIME_LABELS,
								FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
								FCReqBase::HIDOCUMENT_ID, FFHistViewDoc()->GetDocumentId(),
								FCReqBase::TIME_LABEL_ID_VECTOR, &vXxx,
								FCReqBase::MM_POINT_VECTOR_OLD, &vLabelPoint,
								FCReqBase::MM_POINT_VECTOR, &vLabelPointNew,
								FCReqBase::NONE);
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // FCToolTimeLabel::MoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HCURSOR FCToolTimeLabel::GetDefaultIdleCursor () const
{
	return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_TIME_LABEL);
} // FCToolTimeLabel::GetDefaultIdleCursor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCToolBaseFDA::StateContextMenu _xZkqqHx_iCmFjFfMiOkGiClHiCoJiDfEiDhFiDiBiDgKiDiFiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolTimeLabel::GetSubMenuIndex () const
{
	if (GetSelectedXXX(XXX_TIME_LABEL) != 0)
		return FD_MENU_TOOL_TIME_LABEL_ON_OBJECT;
	else
		return FD_MENU_TOOL_TIME_LABEL_ON_BACKGROUND;
} // FCToolTimeLabel::GetSubMenuIndex.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolTimeLabel::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolTimeLabel::OnDrawState (CDC* pDC, int iState)
{
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmNjFjEjFgJiCmFiCmNiCmIiCkCiClNiCnPiBeB_xHqqkZx_ToolBase::OnDraw _xZkqqHx_iCkJiCoH_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCmMjFgAiJoGiPiIjHjNiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCmMiClNiCnPiBeBiClBiClBiCmFjFgAiJoGiClFiCmEiCoCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_

	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	longVector vSelectedLabelId;
	GetSelectedXXX(XXX_TIME_LABEL, &vSelectedLabelId);
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
	longVector::const_iterator iId;
	for (iId = vSelectedLabelId.begin(); iId != vSelectedLabelId.end(); iId++)
		DrawSelectMark(pDC, *iId);

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolTimeLabel::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#endif//_DD_PRO
