// DynamicDb.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "UtilErr.h"				// For FFThrowMiscUnknown.
#include "UtilFile.h"				// For FFReadData.
#include "VirtualTableManager.h"	// For FCVirtualTableManager.
#include "VirtualTable.h"			// For FCVirtualTable.
#include "DynamicDb.h"				// For g_pFileServer.
#include "TopGroupRec.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FCTopGroupRec

FCTopGroupRec::FCTopGroupRec (const HString& hstrTopDirPath)
			:BASE_CLASS(hstrTopDirPath)
{
} // FCTopGroupRec::FCTopGroupRec.

FCTopGroupRec::~FCTopGroupRec ()
{
} // FCTopGroupRec::~FCTopGroupRec.

//----- 06.02.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//FCVirtualTable* FCTopGroupRec::QueryTable (const FCTableIds& vTableIds)
//{
//	FCTableRec* pTableRec = UpdateVirtualTable(vTableIds);
//	return (FCVirtualTable*)pTableRec->m_pVirtualTable;
//} // FCTopGroupRec::QueryTable.
//----- 06.02.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTopGroupRec::DoTransCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byCommand	:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTransaction:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAiOhHjCoIiBeCiPiIjHjNiMoDiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTopGroupRec::DoTransCommand (BYTE byCommand, const BYTE*& pTransaction)
{
	switch (byCommand)
	{
	case CMD_COPY_RECORD:		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCpAjFkBiOmKiBeC_xHqqkZx_
	  {
		// _xZkqqHx_jFkBiOmKjAoGiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCTableIds vTableIds;
		FFReadData(vTableIds, pTransaction);
		// _xZkqqHx_jFkBiOmKiMlDiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCTableName tableNameFrom;
		FFReadData(tableNameFrom, pTransaction);
		// _xZkqqHx_jFkBiOmKiDiMiDfCiBfLiDgIiCmMiKeKiOgOiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwIndexBegin;
		FFReadData(dwIndexBegin, pTransaction);
		// _xZkqqHx_jFkBiOmKiDiMiDfCiBfLiDgIiCmMiPeJjHlJiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwIndexEnd;
		FFReadData(dwIndexEnd, pTransaction);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
		FCTableRec* pTableRec = UpdateVirtualTable(vTableIds);
		// _xZkqqHx_jGlDiMpIiCmIiDiMiDfCiBfLiDgIiCpAiCfAiCmCjCmHiJmBiBeCiClBiCkEiClHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
		// FCVirtualTableManager::CalcRecordOperationTable _xZkqqHx_iCmJiCkIiCkCiCmE_xHqqkZx_
		// _xZkqqHx_iDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJjBiAiNoMiCmFiBhFiDiMiDfCiBfLiDgIjCmHiJmBiBhGiCkKjAlDiClFiCkNjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		pTableRec->m_pVirtualTable->AppendWriteRecordTermination();
		break;
	  }
	default:
		BASE_CLASS::DoTransCommand(byCommand, pTransaction);
	}
} // FCTopGroupRec::DoTransCommand.

FCVirtualWriteTable* FCTopGroupRec::CreateVirtualTable ()
{
	return new FCVirtualTable();
} // FCTopGroupRec::CreateVirtualTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTopGroupRec::UpdateVirtualTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiJlMjBhKiDgFiBfLiDhFiDiLiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjAfGiLeLiNoMjAkMiOjOiCmFiCmIiCkPiCoKiCmOiBeBiKpJjBlGiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCmN_xHqqkZx_
 *			_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMjFkIjHjNiDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCmGiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiNmFiPiJiCmJjHhAiInDiClHiCoJiPoKiNiHiBeBiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJjFkBiOmKiClFiCmEiJlMjBhKiDgFiBfLiDhFiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKpJiCmJiJlMjBhKiDgFiBfLiDhFiDiLiCkKiCkAiCoJiPoKiNiHiBeBiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiPoOjFpBiCpAiJlMjBhKiDgFiBfLiDhFiDiLiCmG_xHqqkZx_
 *			_xZkqqHx_iPmGiCoHiClFiNiHiCoNiClJiCmEiBeBjFmPiNfIiCkKiCkAiCoKiCmOiJlMjBhKiDgFiBfLiDhFiDiLiCmJjElNiJgGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCTopGroupRec::UpdateVirtualTable (const FCTableIds& vTableIds)
{
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	FCTableRec* pTableRec = QueryTableRec(vTableIds);
	// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiNoMjAkMiCkJiBeI_xHqqkZx_
	BOOL bIsCreateVirtualTable = FALSE;
	if (pTableRec->m_pVirtualTable == NULL)
	{
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiNoMjAkMiCkJiBeI_xHqqkZx_
		bIsCreateVirtualTable = TRUE;
		pTableRec->m_pVirtualTable = CreateVirtualTable();
	}

	// _xZkqqHx_iPiIjHjNiCpAjBkMiCnPiCoJiClNiCnPiBeB_xHqqkZx_GetReadLockInfo_xZkqqHx_iKnGjAjEiCmNiKePiCmJiPgPiClDiCmIiCkCiBeC_xHqqkZx_

// 05.12.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FCVirtualTableEx* pVirtualTableEx = (FCVirtualTableEx*)pTableRec->m_pVirtualTable;
	FCVirtualTable* pVirtualTable = (FCVirtualTable*)pTableRec->m_pVirtualTable;
	if (pTableRec->m_tableOperation == FD_TABLE_OPE_NONE)
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjAfGiLeLiNoMjAkMjDjJiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		//--------------------------------------------------
		//       _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJjFmPiNfIiCmIiCkCiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                                      _xZkqqHx_iBkK_xHqqkZx_
		//                    _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfLiBjFjFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAjChFiCkLiKlHiCkGiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iBkK_xHqqkZx_                                _xZkqqHx_iBkK_xHqqkZx_
		//        _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_                  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_                _xZkqqHx_iBkK_xHqqkZx_
		//                     _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
		//                _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeD_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_
		//                    _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfLiBjFjFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeE_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                                      _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//                          _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//--------------------------------------------------

//----- 06.02.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		enum
//		{
//			FD_RECORD_OPE_NOT_CHANGE,		// _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//			FD_RECORD_OPE_REPLACE,			// _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAjChFiCkLiKlHiCkGiCmMiPoKiNiHiBeC_xHqqkZx_
//			FD_RECORD_OPE_DEL_AND_ADD,		// _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiHiBeC_xHqqkZx_
//			FD_RECORD_OPE_DEL,				// _xZkqqHx_iHeD_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
//			FD_RECORD_OPE_ADD,				// _xZkqqHx_iHeE_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
//		};
//----- 06.02.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		GUID guidTable;
		DWORD dwDeleteIdentifier;
		DWORD dwAppendIdentifier;
		GetReadLockInfo(guidTable,
						dwDeleteIdentifier,
						dwAppendIdentifier,
						vTableIds);

		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkJiCoHiMkJiClNiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCmJjBmOiClFiCmEiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
		// _xZkqqHx_iCmCiCnMiCoIiBeBiDiNiDgCiDeOiCpAiJpAiPjMiClFiCmEiCkCiClNiKnEiCmMjFkIjHjNiDgFiBfLiDhFiDiLiCmMjFmPiNfIiBeC_xHqqkZx_
		FTRecordOperation iRecordOperation;

		// pTableRec_xZkqqHx_iCkKjAfGiLeLiNoMjAkMiCmMiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDeMiDiDiDgCiDfGiDiFiCpAjDmHiCnNiNjOiCnMiCmIiCkCiBeC_xHqqkZx_
		if (guidTable != pVirtualTable->GetTableGuid())
		//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmM_xHqqkZx_GUID_xZkqqHx_iCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			iRecordOperation = FD_RECORD_OPE_REPLACE;			// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCpAjChFiCkLiKlHiCkGiCmMiPoKiNiHiBeC_xHqqkZx_
		} else
		if (dwDeleteIdentifier != pVirtualTable->GetRealDeleteIdentifier())
		//----- _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (dwAppendIdentifier != pVirtualTable->GetRealAppendIdentifier())
			//----- _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iBeBjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmGiCoAiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
			{
				iRecordOperation = FD_RECORD_OPE_DEL_AND_ADD;		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiHiBeC_xHqqkZx_
			} else
			//----- _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmMiCnNiInJiCmIiCoIiBeBjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmNiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				iRecordOperation = FD_RECORD_OPE_DEL;				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
			}
		} else
		//----- _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (dwAppendIdentifier != pVirtualTable->GetRealAppendIdentifier())
			//----- _xZkqqHx_jCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmMiCnNiInJiCmIiCoIiBeBiNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmNiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				iRecordOperation = FD_RECORD_OPE_ADD;				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
			} else
			//----- _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iBeBjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmGiCoAiCmJiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				iRecordOperation = FD_RECORD_OPE_NOT_CHANGE;		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
			}
		}
//----- 06.02.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (iRecordOperation != FD_RECORD_OPE_NOT_CHANGE)
		//----- _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// Write_xZkqqHx_iDgPiDgCiDhEiDeAiCkKjHeMiCoJiPoKiNiHiCmNiBeBiDiNiDgCiDeOiCkKiJpAiPjMiClDiCoKiCoJiCmNiClIiCkKiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_
			// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCmMiKnEiCmJiIoBiCkCiCkKjAlGiClGiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_iPfNiCmBiCmEiBeB_xHqqkZx_Write_xZkqqHx_iDgPiDgCiDhEiDeAiCmNiLpDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			if (pVirtualTable->GetWriteRecordBegin() != pVirtualTable->GetWriteRecordEnd())
				FFThrowMiscUnknown();
		}
//----- 06.02.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


		switch (iRecordOperation)
		{
		case FD_RECORD_OPE_NOT_CHANGE:		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iCmIiCmJiCoAiClHiCoJjFeLjHhGiCmNjGlDiCkCiBeC_xHqqkZx_
			break;
		case FD_RECORD_OPE_REPLACE:			// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCpAjChFiCkLiKlHiCkGiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgFiBfLiDhFiDiLiOkJjBmMiCkKiInJiCmIiCoJiCmMiCmFiBeBiDeMiDiDiDgCiDfGiDiFiCmNjBfDiCmEjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
			DsArray<BYTE> vTableIndex;
			g_pFileServer->ServerLoadTableIndex(vTableIndex,
										FCTableName(m_hstrTopDirPath, vTableIds),
										0,
										DWORD(-1));
			FCTableIndex tableIndex(vTableIndex.Get(), vTableIndex.GetSize(), 0);
			// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
			pVirtualTable->ClearAllRealRecords();
			// _xZkqqHx_iDgGiBfLiDfOiCkKiLpDiCmMiDiMiDfCiBfLiDgIiCpAiBeBiDeDiDjDiDgGiDgCiDeOiDfIjFkKiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			DWORD dwIndex;
			for (dwIndex = 0; dwIndex != tableIndex.GetEndIndex(); dwIndex++)
			{
				pVirtualTable->AppendEmptyRealRecord(	tableIndex.GetPrimaryId(dwIndex),
													tableIndex.GetAppendIdentifier(dwIndex),
													tableIndex.GetRecordSize(dwIndex));
			}
			break;
		  }
		case FD_RECORD_OPE_DEL_AND_ADD:		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			//--------------------------------------------------
			//       _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiH_xHqqkZx_
			//
			//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
			//                                      _xZkqqHx_iBkL_xHqqkZx_
			//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
			//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
			//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
			//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
			//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
			//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
			//                            _xZkqqHx_iBkK_xHqqkZx_                _xZkqqHx_iBkK_xHqqkZx_
			//                     _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
			//
			//
			//                                 _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
			//                                      _xZkqqHx_iBkL_xHqqkZx_
			//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
			//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
			//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
			//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
			//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiEkA_xHqqkZx_
			//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_
			//                            _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
			//                _xZkqqHx_jFkIjHjNiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
			//
			//--------------------------------------------------
			// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiNoNiPjMiClDiCoKjCmHiJmBiClDiCoKiClNiClBiCmGiCpAiInDjGkBiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iCmHiClBiCnMiCmFiCmMiDiMiDfCiBfLiDgIiCkKiIoKjChGiClFiCmEiCkIiCoIiBeBiCmHiClBiCkJiCoHiCkKjAfGiClFiCkCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_

			DWORD dwRealRecordCount = g_pFileServer->ServerGetRecordCount(FCTableName(m_hstrTopDirPath, vTableIds));
			DWORD dwVirtualRecordCount = pVirtualTable->GetRealRecordEnd();
			// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAjFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCmJjBlFiCkGiCoJiBeC_xHqqkZx_
			pVirtualTable->ResizeRealRecordCount(dwRealRecordCount);

			DWORD dwEndIndex = dwRealRecordCount;
			BOOL bSame = FALSE;
			while (dwEndIndex != 0 && !bSame)
			{
				// _xZkqqHx_jBoFiCoGiClL_xHqqkZx_100K Byte_xZkqqHx_iClIiCmCiDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
				DWORD dwBeginIndex = (dwEndIndex > (100000 / FD_INDEX_RECORD_SIZE)) ?
									dwEndIndex - (100000 / FD_INDEX_RECORD_SIZE) : 0;
				// _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
				DsArray<BYTE> vTableIndex;
				g_pFileServer->ServerLoadTableIndex(vTableIndex,
											FCTableName(m_hstrTopDirPath, vTableIds),
											dwBeginIndex,
											dwEndIndex);
				FCTableIndex tableIndex(vTableIndex.Get(), vTableIndex.GetSize(), dwBeginIndex);
				for (DWORD dwIndex = dwEndIndex - 1;
					 dwIndex != dwBeginIndex - 1 && !bSame;
					 dwIndex--)
				{
					if (pVirtualTable->GetRealRecordAppendIdentifier(dwIndex) ==
						tableIndex.GetAppendIdentifier(dwIndex))
					{
						bSame = TRUE;
						break;
					}
					// _xZkqqHx_iKpJiCmJjBlGiNnNiClHiCoJiDiMiDfCiBfLiDgIiCmJiBeBiDgGiBfLiDfOiCkKiLpDiCmMiDiMiDfCiBfLiDgIiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
					// _xZkqqHx_iKpJjBlGiDgGiBfLiDfOiCkKjHeMiCoJiPoKiNiHiCmNiDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
					pVirtualTable->SetRealRecord(	dwIndex,
													tableIndex.GetPrimaryId(dwIndex),
													tableIndex.GetAppendIdentifier(dwIndex),
													tableIndex.GetRecordSize(dwIndex),
													DWORD(-1));
				}
			}
			break;
		  }
		case FD_RECORD_OPE_DEL:				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiNoNiPjMiCmMiCnNiClDiCoKiClNiClBiCmGiCpAiInDjGkBiClHiCoJiBeCiDiMiDfCiBfLiDgIiCmMjCmHiJmBiCmNiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_iCmHiClBiCnMiCmFiCmMiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
			DWORD dwRealRecordCount = g_pFileServer->ServerGetRecordCount(FCTableName(m_hstrTopDirPath, vTableIds));
			pVirtualTable->ResizeRealRecordCount(dwRealRecordCount);
			break;
		  }
		case FD_RECORD_OPE_ADD:				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjCmHiJmBiCmMiCnNiClDiCoKiClNiClBiCmGiCpAiInDjGkBiClHiCoJiBeCiDiMiDfCiBfLiDgIiCmMiNoNiPjMiCmNiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			DsArray<BYTE> vTableIndex;
			g_pFileServer->ServerLoadTableIndex(vTableIndex,
												FCTableName(m_hstrTopDirPath, vTableIds),
												pVirtualTable->GetRealRecordEnd(),
												DWORD(-1));
			FCTableIndex tableIndex(vTableIndex.Get(), vTableIndex.GetSize(), pVirtualTable->GetRealRecordEnd());
			// _xZkqqHx_iDgGiBfLiDfOiCkKiLpDiCmMiDiMiDfCiBfLiDgIiCpAiBeBiDeDiDjDiDgGiDgCiDeOiDfIjFkKiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			DWORD dwIndex;
			for (dwIndex = pVirtualTable->GetRealRecordEnd();
				 dwIndex != tableIndex.GetEndIndex();
				 dwIndex++)
			{
				pVirtualTable->AppendEmptyRealRecord(	tableIndex.GetPrimaryId(dwIndex),
														tableIndex.GetAppendIdentifier(dwIndex),
														tableIndex.GetRecordSize(dwIndex));
			}
			break;
		  }
		}
		pVirtualTable->SetTableGuid(guidTable);
		pVirtualTable->SetRealDeleteIdentifier(dwDeleteIdentifier);
		pVirtualTable->SetRealAppendIdentifier(dwAppendIdentifier);

		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiNmFiPiJiCmJiNoMiCmBiClNiCmGiCkLiBeBiIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmJiPeDjAlDiCkKjDpMiCmBiCmE_xHqqkZx_
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmGjAeIiCkCiIoBiCkCiCkKjAlGiClGiClNiCmGiCkLiCmJiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ Write_xZkqqHx_iDgPiDgCiDhEiDeAiCpA_xHqqkZx_
		// _xZkqqHx_iDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
		if (bIsCreateVirtualTable || iRecordOperation != FD_RECORD_OPE_NOT_CHANGE)
		{
			// _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			pVirtualTable->ResetWriteRecordCache(pVirtualTable->GetRealRecordEnd(),
												dwDeleteIdentifier,
												dwAppendIdentifier);
		}
	}
	return pTableRec;
} // FCTopGroupRec::UpdateVirtualTable.

void FCTopGroupRec::GetReadLockInfo (GUID& guidTable,
									DWORD& dwDeleteIdentifier,
									DWORD& dwAppendIdentifier,
									const FCTableIds& vTableIds) const
{
	const FCLockRec* pLockRec = g_pFileServer->GetLockRec(FCTableName(m_hstrTopDirPath, vTableIds));
	if (pLockRec->m_lReadLockCounter == 0)
		FFThrowMiscUnknown();
	guidTable = pLockRec->m_guidTable;
	dwDeleteIdentifier = pLockRec->m_dwDeleteIdentifier;
	dwAppendIdentifier = pLockRec->m_dwAppendIdentifier;
} // FCTopGroupRec::GetReadLockInfo.

//----- 05.12.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FCTopGroupRec::LoadTableIndex (BYTEVector& vTableIndex,
//									const FCTableIds& vTableIds,
//									DWORD dwBeginIndex,
//									DWORD dwEndIndex)
//{
//	g_pFileServer->ServerLoadTableIndex(vTableIndex,
//								FCTableName(m_hstrTopDirPath, vTableIds),
//								dwBeginIndex,
//								dwEndIndex);
//} // FCTopGroupRec::LoadTableIndex.
//----- 05.12.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void FCTopGroupRec::SetLockGuidAndIdentifier (	const FCTableIds& vTableIds,
												const GUID& guidTable,
												DWORD dwDeleteIdentifier,
												DWORD dwAppendIdentifier)
{
	FCLockRec* pLockRec = g_pFileServer->GetLockRec(FCTableName(m_hstrTopDirPath, vTableIds));
	pLockRec->m_guidTable = guidTable;
	pLockRec->m_dwDeleteIdentifier = dwDeleteIdentifier;
	pLockRec->m_dwAppendIdentifier = dwAppendIdentifier;

	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	FCTableRec* pTableRec = GetTableRec(vTableIds);
	FCVirtualTable* pVirtualTable = (FCVirtualTable*)pTableRec->m_pVirtualTable;
	pVirtualTable->SetTableGuid(guidTable);
	pVirtualTable->SetRealDeleteIdentifier(dwDeleteIdentifier);
	pVirtualTable->SetRealAppendIdentifier(dwAppendIdentifier);
} // FCTopGroupRec::SetLockGuidAndIdentifier.

//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void FCTopGroupRec::IncrementLockGuidAndIdentifier (const FCTableIds& vTableIds,
//													BOOL bIsIncDeleteId,
//													BOOL bIsIncAppendId)
//{
//	FCLockRec* pLockRec = g_pFileServer->GetLockRec(FCTableName(m_hstrTopDirPath, vTableIds));
//	if (bIsIncDeleteId)
//	{
//		pLockRec->m_dwDeleteIdentifier++;
//		// _xZkqqHx_jGlDiMpIjCgMiCmMiPoKiNiHiCmNiCePiCmJjGnPiClHiBeC_xHqqkZx_
//		if (pLockRec->m_dwDeleteIdentifier == DWORD(-1))
//			pLockRec->m_dwDeleteIdentifier = 0;
//	}
//	if (bIsIncAppendId)
//	{
//		pLockRec->m_dwAppendIdentifier++;
//		// _xZkqqHx_jGlDiMpIjCgMiCmMiPoKiNiHiCmNiCePiCmJjGnPiClHiBeC_xHqqkZx_
//		if (pLockRec->m_dwAppendIdentifier == DWORD(-1))
//			pLockRec->m_dwAppendIdentifier = 0;
//	}
//
//	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//	FCTableRec* pTableRec = GetTableRec(vTableIds);
//	FCVirtualTable* pVirtualTable = (FCVirtualTable*)pTableRec->m_pVirtualTable;
//	pVirtualTable->SetRealDeleteIdentifier(pLockRec->m_dwDeleteIdentifier);
//	pVirtualTable->SetRealAppendIdentifier(pLockRec->m_dwAppendIdentifier);
//} // FCTopGroupRec::IncrementLockGuidAndIdentifier.
//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FCTopGroupRec::SetLockIdentifier (	const FCTableIds& vTableIds,
										DWORD dwDeleteIdentifier,
										DWORD dwAppendIdentifier)
{
	FCLockRec* pLockRec = g_pFileServer->GetLockRec(FCTableName(m_hstrTopDirPath, vTableIds));
	pLockRec->m_dwDeleteIdentifier = dwDeleteIdentifier;
	pLockRec->m_dwAppendIdentifier = dwAppendIdentifier;

	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	FCTableRec* pTableRec = GetTableRec(vTableIds);
	FCVirtualTable* pVirtualTable = (FCVirtualTable*)pTableRec->m_pVirtualTable;
	pVirtualTable->SetRealDeleteIdentifier(dwDeleteIdentifier);
	pVirtualTable->SetRealAppendIdentifier(dwAppendIdentifier);
} // FCTopGroupRec::SetLockIdentifier.
//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTopGroupRec::MoveWriteRecordToReal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmJiCkAiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeB_xHqqkZx_
 *			WRITE_xZkqqHx_iDiMiDfCiBfLiDgIiDeMiDiDiDgCiDfGiDiFiCpA_xHqqkZx_READ_xZkqqHx_iDiMiDfCiBfLiDgIiDeMiDiDiDgCiDfGiDiFiCnGiInKjDkOiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiOjOiCmJiBeBiNoNiPjMiDhEiDiJiDePiCkKjHkHiCmBiCmEiCkCiCoJiDePiDiLiBfLiDhGiBeFiDgFiBfLiDhFiDiLiCmNjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiBeFiDgFiBfLiDhFiDiLiCmMjBiAiNoMiDhEiDiJiDePiBeBiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmMjBiAiNoMiDhEiDiJiDeP_xHqqkZx_
 *			_xZkqqHx_iCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pGroupRec	:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTopGroupRec::MoveWriteRecordToReal (FCGroupRec* pGroupRec)
{
	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjBiAiNoMiDhEiDiJiDePiCpAiDeOiDiKiDeBiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	pGroupRec->SetOperationFlag(FD_GROUP_OPE_NONE);

	map<DWORD, FCTableRec*>::iterator iTrec;
	for (iTrec = pGroupRec->m_mpTableIdToRec.begin();
		 iTrec != pGroupRec->m_mpTableIdToRec.end();)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjClMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (iTrec->second->GetOperationFlag() == FD_TABLE_OPE_DELETE)
		//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNoNiPjMjBiAiNoMiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeCjDgPjIfOiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
			delete iTrec->second;
			iTrec = pGroupRec->m_mpTableIdToRec.erase(iTrec);
		} else
		//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNoNiPjMjBiAiNoMiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			FCVirtualTable* pVirtualTable = (FCVirtualTable*)iTrec->second->m_pVirtualTable;
			if (pVirtualTable != NULL)
			//----- _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJjBiAiNoMiLeMjIfOiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
				// _xZkqqHx_iJlKiCmF_xHqqkZx_ pVirtualTable _xZkqqHx_iCkKiNoNiPjMiClDiCoKiCoJiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeBjAoGjDkKiCmFjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
				pVirtualTable->m_recordOperation = FD_RECORD_OPE_NOT_CHANGE; // _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
				if (pVirtualTable->GetIsWriteRecordTerminated())
				//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCmMiPjBiCkLiNjOiCnNiCkKjFmCiClGiCoHiCoKiCmEiCkCiCoJiPoKiNiHiBgJiDfEiBfLiDgPiBfLiDfEiDeDiDgIiDfCiDhNiDjDiDgIiPiIjHjNiCmMiPoKiNiHiBgK_xHqqkZx_------
				{
					// _xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiDfCiDhNiDjDiDgIiBgJ_xHqqkZx_CMD_COPY_RECORD_xZkqqHx_iCmIiCmHiBgKiCpAiPiIjHjNiClFiClNiPoKiNiHiBeB_xHqqkZx_
					// _xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiJlMjBhKiDgFiBfLiDhFiDiLiCmNiDiMiDfCiBfLiDgIiCkKjAlDiClFiCkNjElNiJgGiClDiCoKiCmEiCkCiCoJiCkK_xHqqkZx_
					// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiCmNiJlMjBhKiDgFiBfLiDhFiDiLiCmNjBiAiNoMiClDiCoKiClIiBeBjBoDiCoNiCoIiCmJ_xHqqkZx_
					// _xZkqqHx_iPjBiCkLiNjOiCnNiDiMiDfCiBfLiDgIiCmMiNmFiMoDiCmJiPeJjCfLiCpAjAnNjCoIiClFiCmEjFmCiClGiCmEiCkIiCkNiBeC_xHqqkZx_
					// _xZkqqHx_iDiMiDfCiBfLiDgIiCmMjBoFjHmKjDfNjBjHiCmMiPoKiNiHiCmIiCmHiCmJiBeBjAkLjEfMiCpAiPgPiClHiCmMiCmJjHeMiMpIiBeC_xHqqkZx_
					// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiCmNiBeBjFmCiClGiCoHiCoKiClNiDgFiBfLiDhFiDiLiCmN_xHqqkZx_
					// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjClMiMoDiCmJiDeMiDiDiDgCiDfGiDiFiCkJiCoHiNoNiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_

					// _xZkqqHx_iPjBiCkLiNjOiCnNiDiMiDfCiBfLiDgIiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
					pVirtualTable->ResetWriteRecordCache(0, DWORD(-1), DWORD(-1));
					// _xZkqqHx_jDmHiCnNiPgPiClFiDiMiDfCiBfLiDgIiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
					pVirtualTable->ClearAllRealRecords();
					// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
					delete pVirtualTable;
					pVirtualTable = NULL;
					iTrec->second->m_pVirtualTable = NULL;
				} else
				//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCmMiPjBiCkLiNjOiCnNiCkKjFmCiClGiCoHiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ ------
				{
					// _xZkqqHx_iPjBiCkLiNjOiCnNiDgFiBfLiDhFiDiLiCkJiCoHjDmHiCnNiPgPiClFiDgFiBfLiDhFiDiLiCnGiDeMiDiDiDgCiDfGiDiFiCpAiInKjDkOiBeC_xHqqkZx_
					pVirtualTable->MoveWriteRecordToReal();
				}
			}
			// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjBiAiNoMiDhEiDiJiDePiCpAiDeOiDiKiDeBiClFiCmEiCkIiCkNiBeC_xHqqkZx_
			iTrec->second->SetOperationFlag(FD_TABLE_OPE_NONE);
			iTrec++;
		}
	}

	map<DWORD, FCGroupRec*>::iterator iGrec;
	for (iGrec = pGroupRec->m_mpGroupIdToRec.begin();
		 iGrec != pGroupRec->m_mpGroupIdToRec.end();)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjClMiJlKiCmMiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (iGrec->second->GetOperationFlag() == FD_GROUP_OPE_DELETE)
		//----- _xZkqqHx_iDePiDiLiBfLiDhGiCkKiNoNiPjMjBiAiNoMiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeCjDgPjIfOiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
			delete iGrec->second;
			iGrec = pGroupRec->m_mpGroupIdToRec.erase(iGrec);
		} else
		//----- _xZkqqHx_iDePiDiLiBfLiDhGiCkKiNoNiPjMjBiAiNoMiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJiPiIjHjNiClHiCoJiBeC_xHqqkZx_
			MoveWriteRecordToReal(iGrec->second);
			iGrec++;
		}
	}
} // FCTopGroupRec::MoveWriteRecordToReal.

