#ifndef __Archive_h
#define __Archive_h

#include "UtilErr.h"	// For FFThrowMiscUnknown.

class FCUndoArchive;

//;----- <EXPORT TO SDK> -----;

enum
{
	FD_ARCHIVE_STORE,
	FD_ARCHIVE_LOAD,
};

typedef void (*FTCallbackUndoArchive) (FCUndoArchive* pArchive, DWORD dwCallbackData);

//;------ </EXPORT TO SDK> -----;

class FCUndoArchive
{
public:
//----- 05.05.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCUndoArchive (	const wchar_t* wcpFilePath,
//					int iMode,
//					CDocument* pDoc = NULL,
//					BOOL bIsForceFlat = TRUE,
//					long lUndoBuffSizeMin = 0,
//					long lUndoBuffSizeMax = 0,
//					WORDVector* vpLog = NULL);
//	FCUndoArchive (	CFile* filep,
//					int iMode,
//					CDocument* pDoc = NULL,
//					BOOL bIsForceFlat = TRUE,
//					long lUndoBuffSizeMin = 0,
//					long lUndoBuffSizeMax = 0,
//					WORDVector* vpLog = NULL);
//	FCUndoArchive (	CArchive& arc,
//					long lUndoBuffSizeMin = 0,
//					long lUndoBuffSizeMax = 0,
//					WORDVector* vpLog = NULL);
//----- 05.05.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCUndoArchive (	const wchar_t* wcpFilePath,
					int iMode,
					CDocument* pDoc = NULL,
					long lUndoBuffSizeMin = 0,
					long lUndoBuffSizeMax = 0);
	FCUndoArchive (	CFile* filep,
					int iMode,
					CDocument* pDoc = NULL,
					long lUndoBuffSizeMin = 0,
					long lUndoBuffSizeMax = 0);
	FCUndoArchive (	CArchive& arc,
					long lUndoBuffSizeMin = 0,
					long lUndoBuffSizeMax = 0);
//----- 05.05.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	FCUndoArchive ();

//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	Initialize (const wchar_t* wcpFilePath,
//								int iMode,
//								CDocument* pDoc = NULL,
//								BOOL bIsForceFlat = TRUE,
//								long lUndoBuffSizeMin = 0,
//								long lUndoBuffSizeMax = 0,
//								WORDVector* vpLog = NULL);
//	virtual void	Initialize (CFile* filep,
//								int iMode,
//								CDocument* pDoc = NULL,
//								BOOL bIsForceFlat = TRUE,
//								long lUndoBuffSizeMin = 0,
//								long lUndoBuffSizeMax = 0,
//								WORDVector* vpLog = NULL);
//	virtual void	Initialize (CArchive& arc,
//								long lUndoBuffSizeMin = 0,
//								long lUndoBuffSizeMax = 0,
//								WORDVector* vpLog = NULL);
//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual void	Initialize (const wchar_t* wcpFilePath,
								int iMode,
								CDocument* pDoc = NULL,
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								BOOL bIsForceFlat = TRUE,
								long lUndoBuffSizeMin = 0,
								long lUndoBuffSizeMax = 0);
	virtual void	Initialize (CFile* filep,
								int iMode,
								CDocument* pDoc = NULL,
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								BOOL bIsForceFlat = TRUE,
								long lUndoBuffSizeMin = 0,
								long lUndoBuffSizeMax = 0);
	virtual void	Initialize (CArchive& arc,
								long lUndoBuffSizeMin = 0,
								long lUndoBuffSizeMax = 0);
//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	Terminate ();

	virtual ~FCUndoArchive ();
	virtual void	Close ();

	virtual void	ResetUndoBuffer (long lUndoBuffSizeMin,
									long lUndoBuffSizeMax);
	virtual void	GetUndoBufferSize (long& lUndoBuffSizeMin,
										long& lUndoBuffSizeMax) const;

	virtual long	GetPosition () const;

	virtual CDocument*	GetDocument ();
	virtual void	SetDocument (CDocument* pDoc);
	virtual BOOL	GetIsForceFlat () const;
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	SetIsForceFlat (BOOL bForceFlat);
	virtual BOOL	IsOpened () const;
	virtual void	Flush ();

	virtual void	Write (const void* pData, long lSize);
// 03.07.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual DWORD	Read (void* pData, long lSize);
	virtual DWORD	Read (void* pData, long lSize, CException** pError = NULL);
	virtual DWORD	Skip (long lSize, CException** pError = NULL);
	virtual void	WriteString (const WString& str);
// 03.07.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	ReadString (WString& str);
	virtual void	ReadString (WString& str, CException** pError = NULL);

	virtual BOOL	Undo (long lSize);
	virtual void	Undo (const void* pData, long lSize);
	virtual long	GetUndoCount () const;
	virtual long	GetRedoCount () const;
	virtual long	GetBufferCount () const;

	virtual CArchive*	GetArchive ();

	virtual void	SetCallback (FTCallbackUndoArchive callback, DWORD dwCallbackData);

	virtual void	ReadObject (CDocItem*& pObj);
	virtual void	WriteObject (const CDocItem* pObj);

//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	GetIsInterupt ();
//	virtual void	SetIsInterupt (BOOL bIsInterupt);
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
protected:
	virtual void	WriteToArchive (const BYTE* pData, long lSize);
	virtual DWORD	ReadFromArchive (BYTE* pData, long lSize);

protected:
	BOOL		m_bIsOwnFile;			// CFile _xZkqqHx_iCpAiPiKjHeMiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	BOOL		m_bIsOwnArchive;		// CArchive _xZkqqHx_iCpAiPiKjHeMiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	CFile*		m_pFile;				// CFile _xZkqqHx_iCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	CArchive*	m_pArchive;				// CArchive _xZkqqHx_iCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	long		m_lPosition;			// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_

	BYTEVector	m_vUndoBuff;			// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	long		m_lUndoBuffSizeMin;		// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFiPkMjCgMiBeCiClBiCoKiCpAiJlKiJpBiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	long		m_lUndoBuffSizeMax;		// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFjBoFjCgMiBeCiClBiCoKiCpAiPoDiJpBiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	long		m_lUndoBuffCurPos;		// Undo_xZkqqHx_iDgPiDgCiDhEiDeAjCiGiCmJiCkIiCkPiCoJiBeBiMlLiNnNiCmMiImKjChFiBeC_xHqqkZx_

	FTCallbackUndoArchive	m_callback;	// _xZkqqHx_jDmHiCnNiPgPiClFjCiGiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
	DWORD		m_dwCallbackData;		// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCnGjDgOiClHiIpIjAjEiBeC_xHqqkZx_

// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WORDVector*	m_vpLog;
}; // class FCUndoArchive.

//;----- <EXPORT TO SDK> -----;

template<class T> FCUndoArchive& operator << (FCUndoArchive& ar, T v)
{
	ar.Write(&v, sizeof(v));
	return ar;
};

template<class T> FCUndoArchive& operator >> (FCUndoArchive& ar, T& v)
{
	ar.Read(&v, sizeof(v));
	return ar;
};

//----- 05.05.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// 05.05.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////template<class T> FCUndoArchive& operator << (FCUndoArchive& ar, const CObject* pObj)
//inline FCUndoArchive& operator << (FCUndoArchive& ar, const CDocItem* pObj)
//{
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	ASSERT(FALSE);
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (ar.GetBufferCount() != 0) FFThrowMiscUnknown();
//	*ar.GetArchive() << pObj;
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	return ar;
//};
//
//// 05.05.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////template<class T> FCUndoArchive& operator >> (FCUndoArchive& ar, CObject*& pObj)
//inline FCUndoArchive& operator >> (FCUndoArchive& ar, CDocItem*& pObj)
//{
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	ASSERT(FALSE);
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	long lUndoBuffSizeMin;
//	long lUndoBuffSizeMax;
//	ar.GetUndoBufferSize(lUndoBuffSizeMin, lUndoBuffSizeMax);
//	// ar _xZkqqHx_iCkJiCoH_xHqqkZx_ CArchive _xZkqqHx_iCpAiOoGiCoIiPgPiClFiCmEiOgHiCkEiClNiCnPiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
//	ar.ResetUndoBuffer(0, 0);
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCmNiLpDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	if (ar.GetBufferCount() != 0) FFThrowMiscUnknown();
//	*ar.GetArchive() >> pObj;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//	ar.ResetUndoBuffer(lUndoBuffSizeMin, lUndoBuffSizeMax);
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	return ar;
//};
//----- 05.05.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// 05.05.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////template<class T> FCUndoArchive& operator >> (FCUndoArchive& ar, const CObject*& pObj)
//inline FCUndoArchive& operator >> (FCUndoArchive& ar, const CDocItem*& pObj)
//{
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	ASSERT(FALSE);
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	long lUndoBuffSizeMin;
//	long lUndoBuffSizeMax;
//	ar.GetUndoBufferSize(lUndoBuffSizeMin, lUndoBuffSizeMax);
//	// ar _xZkqqHx_iCkJiCoH_xHqqkZx_ CArchive _xZkqqHx_iCpAiOoGiCoIiPgPiClFiCmEiOgHiCkEiClNiCnPiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
//	ar.ResetUndoBuffer(0, 0);
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCmNiLpDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	if (ar.GetBufferCount() != 0) FFThrowMiscUnknown();
//	*ar.GetArchive() >> pObj;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//	ar.ResetUndoBuffer(lUndoBuffSizeMin, lUndoBuffSizeMax);
////----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	return ar;
//};
//----- 05.05.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//;------ </EXPORT TO SDK> -----;

#endif//__Archive_h
