#include "stdafx.h"
#include <io.h>				// For _tsopen.
#include <fcntl.h>			// For _O_RDWR.
#include <share.h>			// For _O_RDONLY.
#include <direct.h>			// For _trmdir.
#include "resource.h"		// For IDS_ERR_ENV_NO_ENVVAR.
#include "UtilErr.h"		// For CFCDDFileException.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilMisc.h"		// For FFVersionInfo.
#include "File32.h"			// For FCFile32.
#include "UtilFile.h"		// This header.

//;----- <EXPORT TO SERVER> -----;

/////////////////////////////////////////////////////////////////////////////
// FCWorkDir_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCWorkDir::FCWorkDir
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCWorkDir::FCWorkDir (const wchar_t* wcpExt)
		:m_hFile(INVALID_HANDLE_VALUE)
{
	for (int i = 0;i != 10; i++)
	{
		WString wstrUniqPath;
		FFMakeUniqTmpFileName(wstrUniqPath, L"_Dyn", wcpExt);
		if (FFRecursiveCreateDirectory(NULL, wstrUniqPath))
		{
			m_wstrWorkDir = wstrUniqPath;
			break;
		}
	}
	if (m_wstrWorkDir.IsEmpty())
		FFThrowMiscUnknown();

	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iNoMjAkMiClDiCoKiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiBeC_xHqqkZx_
		// FILE_SHARE_DELETE _xZkqqHx_iCpAjAnNjCoIiClFiCmIiCkCiCmMiCmFiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoNiPjMiCkKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		m_hFile = ::CreateFile(	WStrToTStr(m_wstrWorkDir),
								FILE_LIST_DIRECTORY,					// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
								FILE_SHARE_READ|FILE_SHARE_WRITE,		// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
								NULL,									// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
								OPEN_EXISTING,							// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
								FILE_FLAG_BACKUP_SEMANTICS,				// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
								NULL);									// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
		if (m_hFile == INVALID_HANDLE_VALUE)
			FFThrowMiscUnknown();
	} else
	//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// 95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmFiCmNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jBoDiCoNiCoIiCmJ_xHqqkZx_ .lock _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiCmEjEpBiLkEjHeMiCmFiKeKiCkNiBeC_xHqqkZx_
		m_hFile = ::CreateFile(	WStrToTStr(m_wstrWorkDir + L"\\.lock"),
								GENERIC_READ|GENERIC_WRITE,				// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
								0,										// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
								NULL,									// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
								CREATE_NEW,								// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
								FILE_ATTRIBUTE_NORMAL,					// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
								NULL);									// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
		if (m_hFile == INVALID_HANDLE_VALUE)
			FFThrowMiscUnknown();
	}
} // FCWorkDir::FCWorkDir.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCWorkDir::~FCWorkDir
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCWorkDir::~FCWorkDir ()
{
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	::CloseHandle(m_hFile);
	m_hFile = INVALID_HANDLE_VALUE;
	FFRecursiveRemoveDirectory(m_wstrWorkDir);
} // FCWorkDir::~FCWorkDir.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCWorkDir::GetWorkDir
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeB_xHqqkZx_TMP_xZkqqHx_iKmCiLkLjFmPjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmJ_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const WString& FCWorkDir::GetWorkDir () const
{
	return m_wstrWorkDir;
} // FCWorkDir::GetWorkDir.

//;----- </EXPORT TO SERVER> -----;

/////////////////////////////////////////////////////////////////////////////
// FCWorkFile_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_

FCWorkFile::FCWorkFile ()
{
	for (long lC = 0; lC != 10; lC++)
	{
		// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
		WString wstrTmpPath;
		FFMakeUniqTmpFileName(wstrTmpPath, L"work", L".tmp");
		// _xZkqqHx_iIoKiOjOiDhEiDeAiDeDiDiLiCpAjAlGjAkMiBeC_xHqqkZx_
		if (file.Open(	WStrToTStr(wstrTmpPath),
						CFile::modeCreate | CFile::modeReadWrite | CFile::shareExclusive))
			break;
	}
	if (file.m_hFile == CFile::hFileNull)
		FFThrowMiscException(IDS_ERR_FILE_NOT_UNIQ_NAME);
} // FCWorkFile::FCWorkFile.

FCWorkFile::~FCWorkFile ()
{
	if (file.m_hFile != CFile::hFileNull)
	{
		// _xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		WString wstrTmpPath = TStrToWStr(file.GetFilePath());
		file.Close();
		FFDeleteFile(wstrTmpPath);
	}
} // FCWorkFile::~FCWorkFile.

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WriteVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_iLeMjIfOjAoGiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *			ddwVSizeU:VSizeU_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CFileException_xZkqqHx_jHoBiKePiCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.04 Fukushiro M. HistoryIndex_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void WriteVSizeU (CFile& file, ULONGLONG ddwVSizeU)
{
	BYTE bySize;
	if (ddwVSizeU < 0x80)
	{
		//----- VSizeU_xZkqqHx_iCmNiCfAiDgPiDeDiDgHiCmFiPjBiCkLiNjOiCnO_xHqqkZx_ -----
		bySize = ddwVSizeU;
		file.Write(&bySize, sizeof(bySize));
	} else
	{
		//----- VSizeU_xZkqqHx_iCmNiCiOiDgPiDeDiDgHiCmFiPjBiCkLiNjOiCnO_xHqqkZx_ -----
		//---- B_0_xZkqqHx_iCmMiLeMjIfO_xHqqkZx_ ----
		bySize = ddwVSizeU % 0x80;
		// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjHkHiCmEiCoJiBeC_xHqqkZx_
		bySize |= 0x80;
		file.Write(&bySize, sizeof(bySize));
		ddwVSizeU /= 0x80;
		while (0x80 <= ddwVSizeU)
		{
			bySize = ddwVSizeU % 0x80;
			file.Write(&bySize, sizeof(bySize));
			ddwVSizeU /= 0x80;
		}
		//---- B_n_xZkqqHx_iCmMiLeMjIfO_xHqqkZx_ ----
		// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjHkHiCmEiCoJiBeC_xHqqkZx_
		bySize = ddwVSizeU | 0x80;
		file.Write(&bySize, sizeof(bySize));
	}
} // WriteVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ReadVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoH_xHqqkZx_VSizeU_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC_xZkqqHx_iBhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONGLONG ReadVSizeU (CFile& file)
{
	ULONGLONG ddwVSizeU;
	BYTE bySize;
	// B_0_xZkqqHx_iCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	file.Read(&bySize, sizeof(bySize));
	if (bySize & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
// 01.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		long lBase = 1;		// _xZkqqHx_iMiFiPoDiCkKiCoIiCmMiMhGiOfKiCmMiKoOjAjEiBeC_xHqqkZx_
		ULONGLONG ddwBase = 1;		// _xZkqqHx_iMiFiPoDiCkKiCoIiCmMiMhGiOfKiCmMiKoOjAjEiBeC_xHqqkZx_
		// B_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		ddwVSizeU = ddwBase * (bySize & 0x7f);
		for (;;)
		{
			// _xZkqqHx_iKoOjAjEiCmMiMiFiCpAiPoDiClAiCoJiBeC_xHqqkZx_
			ddwBase *= 0x80;
			// B_i_xZkqqHx_iCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
			file.Read(&bySize, sizeof(bySize));
			// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiCmIiCoH_xHqqkZx_B_n_xZkqqHx_iCmIiCmMiCmFiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (bySize & 0x80) break;
			ddwVSizeU += ddwBase * bySize;
		}
		// B_n_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		ddwVSizeU += ddwBase * (bySize & 0x7f);
	} else
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ddwVSizeU = bySize;
	}
	return ddwVSizeU;
} // ReadVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RReadVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAiLhEjFpLiMpMiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC_xZkqqHx_iBhGjCiGiCmMiBeB_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_1.2.1. VSizeU _xZkqqHx_iBiE_xHqqkZx_ 0x7f _xZkqqHx_iCmMiPoKiNiHiBhGiCmMiBjGiCgBjCgOjDfPiCkJiCoH_xHqqkZx_VSizeU_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiNjOiCnNiBeBiBjGiCgAjCgOjDfPiCmFjDmHiCnNiPeJiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CFileException_xZkqqHx_jHoBiKePiCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.04 Fukushiro M. HistoryIndex_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
ULONGLONG RReadVSizeU (CFile& file)
{
	ULONGLONG ddwVSizeU;
	//---- B_n_xZkqqHx_iCmMjDmHiCnNiNjOiCnN_xHqqkZx_ ----
	BYTE bySize;
	file.Seek(-long(sizeof(bySize)), CFile::current);
	file.Read(&bySize, sizeof(bySize));

	// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (bySize & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// B_n_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		ddwVSizeU = bySize & 0x7f;
		for (;;)
		{
			// _xZkqqHx_iCfBiDgPiDeDiDgHiCnJiCmHiDhEiDeAiDeDiDiLiImKjChFiCpAjGnPiClHiBeC_xHqqkZx_
			file.Seek(-(2 * sizeof(bySize)), CFile::current);
			// _xZkqqHx_iDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
			file.Read(&bySize, sizeof(bySize));
			// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiCmIiCoH_xHqqkZx_B_0_xZkqqHx_iCmIiCmMiCmFiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (bySize & 0x80) break;
			ddwVSizeU = (ddwVSizeU * 0x80) + bySize;
		}
		// B_0_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		ddwVSizeU = (ddwVSizeU * 0x80) + (bySize & 0x7f);
	} else
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ddwVSizeU = bySize;
	}
	// _xZkqqHx_iCfAiDgPiDeDiDgHjGnPiClHiBeC_xHqqkZx_
	file.Seek(-long(sizeof(bySize)), CFile::current);
	return ddwVSizeU;
} // RReadVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SkipVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_jFkKiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC_xZkqqHx_iBhGjCiGiCmMiBeB_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_1.2.1. VSizeU _xZkqqHx_iBiE_xHqqkZx_ 0x7f _xZkqqHx_iCmMiPoKiNiHiBhGiCmMiBjGiCgAjCgOjDfPiCkJiCoHiBjGiCgBjCgOjDfPiCnG_xHqqkZx_
 *			VSizeU_xZkqqHx_iCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CFileException_xZkqqHx_jHoBiKePiCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.04 Fukushiro M. HistoryIndex_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void SkipVSizeU (CFile& file)
{
	//---- B_0_xZkqqHx_iCmMjDmHiCnNiNjOiCnN_xHqqkZx_ ----
	BYTE bySize;
	file.Read(&bySize, sizeof(bySize));
	// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (bySize & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjPiCmMiNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiDgPiDeDiDgHiCnMiCmFiDiLiBfLiDhGiBeC_xHqqkZx_
		do {
			file.Read(&bySize, sizeof(bySize));
		} while (!(bySize & 0x80));
	}
} // SkipVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RSkipVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAiLhEjFpLiMpMiCmJiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void RSkipVSizeU (CFile& file)
{
	//---- B_n_xZkqqHx_iCmMjDmHiCnNiNjOiCnN_xHqqkZx_ ----
	BYTE bySize;
	file.Seek(-long(sizeof(bySize)), CFile::current);
	file.Read(&bySize, sizeof(bySize));
	// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (bySize & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		do
		{
			// _xZkqqHx_iCfBiDgPiDeDiDgHiCnJiCmHiDhEiDeAiDeDiDiLiImKjChFiCpAjGnPiClHiBeC_xHqqkZx_
			file.Seek(-(2 * sizeof(bySize)), CFile::current);
			// _xZkqqHx_iDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
			file.Read(&bySize, sizeof(bySize));
			// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiCmIiCoH_xHqqkZx_B_0_xZkqqHx_iCmIiCmMiCmFiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		} while (!(bySize & 0x80));
	}
	// _xZkqqHx_iCfAiDgPiDeDiDgHjGnPiClHiBeC_xHqqkZx_
	file.Seek(-long(sizeof(bySize)), CFile::current);
} // RSkipVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WriteVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDeOiDfOiBfLiDgPiDgCiDhEiDeAiCmJ_xHqqkZx_VSizeU_xZkqqHx_iCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vBuff	:_xZkqqHx_iLeMjIfOjAoGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *			ddwVSizeU	:VSizeU_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CMemoryException_xZkqqHx_jHoBiKePiCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void WriteVSizeU (BYTEVector& vBuff, ULONGLONG ddwVSizeU)

{
	BYTE bySize;
	if (ddwVSizeU < 0x80)
	{
		//----- VSizeU_xZkqqHx_iCmNiCfAiDgPiDeDiDgHiCmFiPjBiCkLiNjOiCnO_xHqqkZx_ -----
		bySize = ddwVSizeU;
		vBuff.push_back(bySize);
	} else
	{
		//----- VSizeU_xZkqqHx_iCmNiCiOiDgPiDeDiDgHiCmFiPjBiCkLiNjOiCnO_xHqqkZx_ -----
		//---- B_0_xZkqqHx_iCmMiLeMjIfO_xHqqkZx_ ----
		bySize = ddwVSizeU % 0x80;
		// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjHkHiCmEiCoJiBeC_xHqqkZx_
		bySize |= 0x80;
		vBuff.push_back(bySize);
		ddwVSizeU /= 0x80;
		while (0x80 <= ddwVSizeU)
		{
			bySize = ddwVSizeU % 0x80;
			vBuff.push_back(bySize);
			ddwVSizeU /= 0x80;
		}
		//---- B_n_xZkqqHx_iCmMiLeMjIfO_xHqqkZx_ ----
		// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjHkHiCmEiCoJiBeC_xHqqkZx_
		bySize = ddwVSizeU | 0x80;
		vBuff.push_back(bySize);
	}
} // WriteVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	InsertVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDeOiDfOiBfLiDgPiDgCiDhEiDeAiCmMiOhHjCoIiClDiCoKiClNiImKjChFiCmJ_xHqqkZx_VSizeU_xZkqqHx_iCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vBuff		:_xZkqqHx_iLeMjIfOjAoGiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPos		:_xZkqqHx_iLeMjIfOiClHiCoJiDgPiDgCiDhEiDeAiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ddwVSizeU	:VSizeU_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void InsertVSizeU (BYTEVector& vBuff, long lPos, ULONGLONG ddwVSizeU)
{
	BYTEVector vTmp;
	::WriteVSizeU(vTmp, ddwVSizeU);
	vBuff.insert(vBuff.begin() + lPos, vTmp.begin(), vTmp.end());
} // InsertVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ReadVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCkJiCoH_xHqqkZx_VSizeU_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypBuff	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDgPiDgCiDhEiDeAiBeCiDgPiDgCiDhEiDeAiCkKjAgJiCpBiClOjFkKiCoAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC_xZkqqHx_iBhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONGLONG ReadVSizeU (const BYTE*& bypBuff)
{
	ULONGLONG ddwVSizeU;
	if (*bypBuff & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
// 01.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		long lBase = 1;		// _xZkqqHx_iMiFiPoDiCkKiCoIiCmMiMhGiOfKiCmMiKoOjAjEiBeC_xHqqkZx_
		ULONGLONG ddwBase = 1;		// _xZkqqHx_iMiFiPoDiCkKiCoIiCmMiMhGiOfKiCmMiKoOjAjEiBeC_xHqqkZx_
		// B_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		ddwVSizeU = ddwBase * (*bypBuff & 0x7f);
		for (;;)
		{
			// _xZkqqHx_iKoOjAjEiCmMiMiFiCpAiPoDiClAiCoJiBeC_xHqqkZx_
			ddwBase *= 0x80;
			// _xZkqqHx_iDgPiDgCiDhEiDeAiCmMiImKjChFiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
			bypBuff++;
			// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiCmIiCoH_xHqqkZx_B_n_xZkqqHx_iCmIiCmMiCmFiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (*bypBuff & 0x80) break;
			ddwVSizeU += ddwBase * *bypBuff;
		}
		// B_n_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		ddwVSizeU += ddwBase * (*bypBuff & 0x7f);
	} else
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ddwVSizeU = *bypBuff;
	}
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCmMiImKjChFiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	bypBuff++;
	return ddwVSizeU;
} // ReadVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RReadVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAiLhEjFpLiMpMiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypBuff	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDgPiDgCiDhEiDeAiBeCiDgPiDgCiDhEiDeAiCkKjAgJiCpBiClOjFkKiCoAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	VSizeU_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.DOC_xZkqqHx_iBhGjCiGiCmMiBeB_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_1.2.1. VSizeU _xZkqqHx_iBiE_xHqqkZx_ 0x7f _xZkqqHx_iCmMiPoKiNiHiBhGiCmMiBjGiCgBjCgOjDfPiCkJiCoH_xHqqkZx_VSizeU_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiNjOiCnNiBeBiBjGiCgAjCgOjDfPiCmFjDmHiCnNiPeJiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONGLONG RReadVSizeU (const BYTE*& bypBuff)
{
	ULONGLONG ddwVSizeU;
	//---- B_n_xZkqqHx_iCmMjDmHiCnNiNjOiCnN_xHqqkZx_ ----
	bypBuff--;
	// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (*bypBuff & 0x80)
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// B_n_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		ddwVSizeU = *bypBuff & 0x7f;
		for (;;)
		{
			// _xZkqqHx_iCfAiDgPiDeDiDgHiCnJiCmHiDhMiDeDiDjDiDfOiCpAjGnPiClHiBeC_xHqqkZx_
			bypBuff--;
			// _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCoJiCmIiCoH_xHqqkZx_B_0_xZkqqHx_iCmIiCmMiCmFiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (*bypBuff & 0x80) break;
			ddwVSizeU = (ddwVSizeU * 0x80) + *bypBuff;
		}
		// B_0_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		ddwVSizeU = (ddwVSizeU * 0x80) + (*bypBuff & 0x7f);
	} else
	//----- _xZkqqHx_iNmFiPoDiImKiDhCiDgCiDgHiCkKjHkHiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ddwVSizeU = *bypBuff;
	}
	return ddwVSizeU;
} // RReadVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LongToVSizeU
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	long_xZkqqHx_iMfOjAjEjCgMiCpA_xHqqkZx_VSizeU_xZkqqHx_iMfOiCmMjAjEjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBhFiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLjFjEjFgJjBiAiNoM_xHqqkZx_.doc_xZkqqHx_iBhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lVal	:long_xZkqqHx_iMfOjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	VSizeU_xZkqqHx_iCmMjAjEjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONGLONG LongToVSizeU (long lVal)
{
	// _xZkqqHx_jFiJiDhCiDgCiDgHiBgJiCePiDhCiDgCiDgHjGnKiBgKiCpAiMiIjCoIiBeC_xHqqkZx_
	const ULONGLONG ddwNegaBit = (lVal < 0) ? 1 : 0;
// 01.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return ULONGLONG(labs(lVal) << 1) | ddwNegaBit;
	return (ULONGLONG(labs(lVal)) << 1) | ddwNegaBit;
} // LongToVSizeU.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	VSizeUToLong
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	VSizeU_xZkqqHx_iMfOiCmMjAjEjCgMiCpA_xHqqkZx_long_xZkqqHx_iMfOjAjEjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBhFiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLjFjEjFgJjBiAiNoM_xHqqkZx_.doc_xZkqqHx_iBhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ddwVSizeU	:VSizeU_xZkqqHx_iCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	long_xZkqqHx_iMfOjAjEjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long VSizeUToLong (ULONGLONG ddwVSizeU)
{
	// _xZkqqHx_jCgMiCmMjAoCjBmOjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	long lVal = long(ddwVSizeU >> 1);
	// _xZkqqHx_jFiJiDhCiDgCiDgHiBgJiCePiDhCiDgCiDgHjGnKiBgKiCpAjClCiCnHiBeBjFiEiNiGiCpAjFhEiCkPiCmEjFnEiClHiBeC_xHqqkZx_
	return ((ddwVSizeU & 1) ? -lVal : lVal);
} // VSizeUToLong.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWriteStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vStream_xZkqqHx_iCmMiNmFiMoDiCmJ_xHqqkZx_pData_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iDgGiBfLiDfOiCpAjCmHiJmBiClHiCoJiDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_jCmHiJmBiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCount	:pData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFWriteStream (BYTEVector& vStream, const void* pData, DWORD dwCount)
{
	vStream.insert(vStream.end(),
					(const BYTE*)pData, (const BYTE*)pData + dwCount);
} // WriteStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReadStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	pData_xZkqqHx_iCmJ_xHqqkZx_bypBuff_xZkqqHx_iCkJiCoHiDgGiBfLiDfOiCpA_xHqqkZx_dwCount_xZkqqHx_iClOiCkPiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypBuff	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiDgPiDgCiDhEiDeAiBeCiDgPiDgCiDhEiDeAiCkKjAgJiCpBiClOjFkKiCoAjFnEiClHiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCount	:_xZkqqHx_jDmHiCnNiNjOiCnOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReadStream (const BYTE*& bypBuff, void* pData, DWORD dwCount)
{
	memcpy(pData, bypBuff, dwCount);
	bypBuff += dwCount;
} // FFReadStream.

//----- 99.04.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	<<
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vStream_xZkqqHx_iCmMiNmFiMoDiCmJ_xHqqkZx_lData_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iDgGiBfLiDfOiCpAjCmHiJmBiClHiCoJiDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiBeC_xHqqkZx_
// *			lData	:_xZkqqHx_jCmHiJmBiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void operator << (BYTEVector& vStream, long lData)
//{
//	FFWriteStream(vStream, &lData, sizeof(lData));
//} // operator << (BYTEVector& vStream, long lData).
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	<<
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vStream_xZkqqHx_iCmMiNmFiMoDiCmJ_xHqqkZx_byData_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iDgGiBfLiDfOiCpAjCmHiJmBiClHiCoJiDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiBeC_xHqqkZx_
// *			byData	:_xZkqqHx_jCmHiJmBiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void operator << (BYTEVector& vStream, BYTE byData)
//{
//	FFWriteStream(vStream, &byData, sizeof(byData));
//} // operator << (BYTEVector& vStream, long lData).
//----- 99.04.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SplitFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJjAoCjBmOiDhAiDfIiBgKiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFjEjFkKiCmGiDhEiDeAiDeDiDiLjFjEjFkKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			strFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			strExtension:_xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpFileFull	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjAoCjBmOiDhAiDfIiCmFiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiNmFiMoDiCmJiCmNiBeB_xHqqkZx_\ _xZkqqHx_iCkKjFhEiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSplitFileName (WString* strDirPath, WString* strFile, WString* strExtension, const wchar_t* wcpFileFull)
{
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	wchar_t szDrive[_MAX_DRIVE];
//	wchar_t szDir[_MAX_DIR];
//	wchar_t szFName[_MAX_FNAME];
//	wchar_t szExt[_MAX_EXT];
//	_wsplitpath(wcpFileFull, szDrive, szDir, szFName, szExt);
//	if (strDirPath != NULL)
//	{
//		*strDirPath = szDrive;
//		*strDirPath += szDir;
//	}
//	if (strFile != NULL)
//	{
//		*strFile = szFName;
//	}
//	if (strExtension != NULL)
//	{
//		*strExtension = szExt;
//	}
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const int iLen = wcslen(wcpFileFull);
	WCharVector vDrive(iLen + 1);
	WCharVector vDir(iLen + 1);
	WCharVector vFName(iLen + 1);
	WCharVector vExt(iLen + 1);
	_wsplitpath(wcpFileFull, &vDrive.at(0), &vDir.at(0), &vFName.at(0), &vExt.at(0));
	if (strDirPath != NULL)
	{
		*strDirPath = &vDrive.at(0);
		*strDirPath += &vDir.at(0);
	}
	if (strFile != NULL)
	{
		*strFile = &vFName.at(0);
	}
	if (strExtension != NULL)
	{
		*strExtension = &vExt.at(0);
	}
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFSplitFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SplitFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJjBiKjBmOiBeFjAoCjBmOiDhAiDfIiBgKiCmMiDhEiDeAiDeDiDiLjFjEjFkKiBgJiDhAiDfIjFhEiCkLiBgKiCmG_xHqqkZx_
 *			_xZkqqHx_iKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			strExtension:_xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpFilePath _xZkqqHx_iCkK_xHqqkZx_ "hello\world.txt" _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			strFile : "hello\world"
 *			strExtension : ".txt"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSplitFileName (WString* strFile, WString* strExtension, const wchar_t* wcpFilePath)
{
	WString strPath(wcpFilePath);
	// _xZkqqHx_iNmFiMoDiCmM_xHqqkZx_'.'_xZkqqHx_iCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const int iIdx = strPath.ReverseFind(L'.');
	if (strFile != NULL)
	{
		if (iIdx < 0)
			*strFile = strPath;
		else
			*strFile = strPath.Left(iIdx);
	}
	if (strExtension != NULL)
	{
		if (iIdx < 0)
			strExtension->Empty();
		else
			*strExtension = strPath.Right(strPath.GetLength() - iIdx);
	}
} // FFSplitFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFileExtension
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCmMiKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKgHjCkDiOhBiBeCjFlGiOjKjHpBiCmMjAoGjDkKiCmJ_xHqqkZx_"."_xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetFileExtension (const wchar_t* wcpFilePath)
{
	WString wstrExtension;
	FFSplitFileName(NULL, NULL, &wstrExtension, wcpFilePath);
	return wstrExtension;
} // FFGetFileExtension.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFileDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBgKiDhAiDfIjGlMiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			bChopLast	:_xZkqqHx_iNmFiMoDiCmM_xHqqkZx_'\\'_xZkqqHx_iCpAiNoNiPjMiClHiCoJiCkJiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhAiDfIiBeCiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiNmFiMoDiCmJiCmNiBeB_xHqqkZx_\ _xZkqqHx_iCkKjFhEiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetFileDirectory (const wchar_t* wcpFilePath, BOOL bChopLast)
{
	WString wstrDirPath;
	FFSplitFileName(&wstrDirPath, NULL, NULL, wcpFilePath);
	if (bChopLast)
	//----- _xZkqqHx_iNmFiMoDiCmM_xHqqkZx_'\\'_xZkqqHx_iCpAiNoNiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!wstrDirPath.IsEmpty())
			wstrDirPath.ChopLast();
	}
	return wstrDirPath;
} // FFGetFileDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBeCiKgHjCkDiOhBjFhEiCkLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetFileName (const wchar_t* wcpFilePath)
{
	WString wstrFile;
	WString wstrExtension;
	FFSplitFileName(NULL, &wstrFile, &wstrExtension, wcpFilePath);
	return wstrFile + wstrExtension;
} // FFGetFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFullPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMiDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFFullPath (const wchar_t* wcpFileName)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiDgAiDeGiDgCiDeOiCmMiInHiBeBjAoCjBmOiDhAiDfIiCmJjFmPiKlHiBeC_xHqqkZx_
	_TCHAR tcsFull[_MAX_PATH];
	if (_tfullpath(tcsFull, WStrToTStr(wcpFileName), _MAX_PATH) == NULL)
// 06.01.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		FFThrowFileException(CFileException::badPath, -1, wcpFileName);
		FFThrowMiscUnknown();
	return TStrToWStr(tcsFull);
} // FFFullPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCommonPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpFilePath1_xZkqqHx_iCmG_xHqqkZx_wcpFilePath2_xZkqqHx_iCmMiLkEjCmKiCmMiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath1	:_xZkqqHx_iDhAiDfIiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePath2	:_xZkqqHx_iDhAiDfIiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLkEjCmKiCmMiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetCommonPath (const wchar_t* wcpFilePath1,
						 const wchar_t* wcpFilePath2)
{
	long lCommonLen = 0;
	for (long lC = 0;
		 wcpFilePath1[lC] != L'\0' && wcpFilePath2[lC] != L'\0';
		 lC++)
	{
		if (_wcsnicmp(&wcpFilePath1[lC], &wcpFilePath2[lC], 1) == 0)
		//----- _xZkqqHx_jDkPiClGjFlGiOjKiBgJjBoFjFlGiOjKiPkMjFlGiOjKjGlDiClFiCmFjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (wcpFilePath1[lC] == L'\\')
				lCommonLen = lC + 1;
		} else
		//----- _xZkqqHx_iIoBiCkEjFlGiOjKiBgJjBoFjFlGiOjKiPkMjFlGiOjKjGlDiClFiCmFjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			break;
		}
	}
	return WString(wcpFilePath1).Left(lCommonLen);
} // FFGetCommonPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetRelativePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpFilePathBase_xZkqqHx_iCkJiCoHiCmM_xHqqkZx_wcpFilePathTarg_xZkqqHx_iCmMjBiKjBmOiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPathBase	:_xZkqqHx_iKoOiPiAiCmGiCmIiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMjAoCjBmOiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePathTarg	:_xZkqqHx_iLiBiCnPiCoJjBiKjBmOiDhAiDfIiDhEiDeAiDeDiDiLiCmMjAoCjBmOiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBiKjBmOiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetRelativePath (	const wchar_t* wcpDirPathBase,
							const wchar_t* wcpFilePathTarg)
{
	// _xZkqqHx_jHoBiBeG_xHqqkZx_
	// wstrFilePathTarg = "C:\doc\bunsyo\keiri\abc.txt"
	// wstrDirPathBase = "C:\doc\bunsyo\shigoto\shiyousyo\"

	WString wstrFilePathTarg = wcpFilePathTarg;
	WString wstrDirPathBase = wcpDirPathBase;
	// _xZkqqHx_iKoOiPiAiDgGiDeCiDiMiDeOiDgHiDiKiCmMiNmFiMoDiCmNiBeBjFeLiClI_xHqqkZx_'\\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	if (wstrDirPathBase.GetLast() != L'\\') wstrDirPathBase += L'\\';
	// _xZkqqHx_iLkEjCmKiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrCommonPath = FFGetCommonPath(wstrFilePathTarg, wstrDirPathBase);

	// wstrCommonPath = "C:\doc\bunsyo\"
	// wstrFilePathTarg = "keiri\abc.txt"
	// wstrDirPathBase = "shigoto\shiyousyo\"

	wstrFilePathTarg = wstrFilePathTarg.Right(wstrFilePathTarg.GetLength() - wstrCommonPath.GetLength());
	wstrDirPathBase = wstrDirPathBase.Right(wstrDirPathBase.GetLength() - wstrCommonPath.GetLength());
	// wstrDirPathBase_xZkqqHx_jCiGiCmM_xHqqkZx_'\\'_xZkqqHx_iCmMjAjEiCpAjAjEiCkGiCoJiBeC_xHqqkZx_
	const long lCharCount = wstrDirPathBase.CharCount(L'\\');
	// _xZkqqHx_jBiKjBmOiDhAiDfIiBeC_xHqqkZx_
	WString wstrRelativePath;
	// _xZkqqHx_jBiKjBmOiDhAiDfIiNmFiPiJiCmM_xHqqkZx_ "..\\" _xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_
	for (long lC = 0; lC < lCharCount; lC++)
		wstrRelativePath += L"..\\";
	// _xZkqqHx_jBiKjBmOiDhAiDfIiOgDiCoIiCmMjFjEjFkKiCpAjCmHiJmBiBeC_xHqqkZx_
	wstrRelativePath += wstrFilePathTarg;
	return wstrRelativePath;
} // FFGetRelativePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetAbsolutePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpFilePathBase_xZkqqHx_iCpAiKoOjDfPiCmGiClHiCoJjBiKjBmOiDhAiDfI_xHqqkZx_wcpFilePathTarg_xZkqqHx_iCmMiBeB_xHqqkZx_
 *			_xZkqqHx_jAoCjBmOiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPathBase	:_xZkqqHx_iKoOiPiAiCmGiCmIiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMjAoCjBmOiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePathTarg	:_xZkqqHx_iLiBiCnPiCoJjBiKjBmOiDhAiDfIiDhEiDeAiDeDiDiLiCmMjAoCjBmOiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoCjBmOiDhAiDfIiBeC_xHqqkZx_
 *
* <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetAbsolutePath (	const wchar_t* wcpDirPathBase,
							const wchar_t* wcpFilePathTarg)
{
	WString wstrFilePath = wcpDirPathBase;
	wstrFilePath.ChopLast(L'\\');
	wstrFilePath += L'\\';
	wstrFilePath += wcpFilePathTarg;

	WStringVector vPath;
	while (!wstrFilePath.IsEmpty())
	{
		WString wstr1Path = FFExtractUntil(wstrFilePath, L'\\');
		if (wstr1Path == L"..")
		{
			if (vPath.empty())
				FFThrowMiscUnknown();
			vPath.pop_back();
		} else
		if (wstr1Path == L".")
		{
		} else
		{
			vPath.push_back(wstr1Path);
		}
	}
	wstrFilePath.Empty();
	WStringVector::const_iterator iSt;
	for (iSt = vPath.begin(); iSt != vPath.end(); iSt++)
	{
		wstrFilePath += *iSt;
		wstrFilePath += L'\\';
	}
	wstrFilePath.ChopLast(L'\\');
	return wstrFilePath;
} // FFGetAbsolutePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeUniqFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiIpIjAjEiCpAiMlDiCmJiBeBiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCiDhEiDiLiDhAiDfIiBeC_xHqqkZx_
 *			wcpFile		:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiClHiCoJiBeCiDhEiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpFile _xZkqqHx_iCpA_xHqqkZx_ _xZkqqHx_iDhAiDfIiBeBiDhEiDeAiDeDiDiLjGlM_xHqqkZx_ _xZkqqHx_iCmJjFkKiJpAiBeCiDhEiDeAiDeDiDiLjGlMiCmMjBePiCmJ_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKjHpBiCpAjCmHiJmBiClFiCmEjAfGiClFiCkCiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhEiDeAiDeDiDiLjGlMiCkKjBlGiNnNiClHiCoJiCkJiDgAiDeGiDgCiDeOiClFiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNjCmHiJmBjFlGiOjKjHpB_xHqqkZx_
 *			_xZkqqHx_iCpAjFmPiNfIiClFiNmEjDhIiDgAiDeGiDgCiDeOiClHiCoJiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiClLiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBjFlGiOjKjHpBiCmNiBeBiNmFjBoFiCmFiCfAiCePiCePiCePiCePiOoNjHnOiCnMiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_wcpFile = "C:\TMP\HELLO\ABC.TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				wstrName = "C:\TMP\HELLO\~1f_ABC.TXT"
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmN_xHqqkZx_ _xZkqqHx_jHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFMakeUniqFileName (WString& wstrName, const wchar_t* wcpFile)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiDgAiDeGiDgCiDeOiCmMiInHiBeBjAoCjBmOiDhAiDfIiCmJjFmPiKlHiBeC_xHqqkZx_
	WString wstrFullPath = FFFullPath(wcpFile);
	WString wstrDirPath;
	WString wstrFile;
	WString wstrExtension;
	FFSplitFileName(&wstrDirPath, &wstrFile, &wstrExtension, wstrFullPath);

	for (int iCount = 0; iCount < 10000; iCount++)
	{
		wstrName.Format(L"%s~%x_%s%s", (const wchar_t*)wstrDirPath, iCount,
										(const wchar_t*)wstrFile,
										(const wchar_t*)wstrExtension);
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (_MAX_PATH <= wstrName.GetLength())
// 06.01.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			FFThrowFileException(CFileException::badPath, -1, wstrName);
			FFThrowMiscUnknown();
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
// 03.11.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (!FFIsFileExist(wstrName)) return;
		if (FFIsThereFile(wstrName) == FD_FILE_NOT_EXIST) return;
	}
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CException* e = new CFCDDFileException(IDS_ERR_FILE_NOT_UNIQ_NAME, wstrFullPath);
//	e->ReportError();
//	throw e;
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FFThrowMiscUnknown();
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFMakeUniqFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeUniqFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiIpIjAjEiCpAiMlDiCmJiBeBiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpPath	:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAiPjMiCkCiClNjFjEjFkKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpExt	:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiBhF_xHqqkZx_wcpPath + wcpExt_xZkqqHx_iBhGiCpAiDgAiDeGiDgCiDeOiClFiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_wcpPath + "_" + _xZkqqHx_jCmHiJmBjFlGiOjKjHpB_xHqqkZx_ + wcpExt_xZkqqHx_iBhGiCmFjAfGiClFiCkCiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhEiDeAiDeDiDiLjGlMiCkKjBlGiNnNiClHiCoJiCkJiDgAiDeGiDgCiDeOiClFiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNjCmHiJmBjFlGiOjKjHpB_xHqqkZx_
 *			_xZkqqHx_iCpAjFmPiNfIiClFiNmEjDhIiDgAiDeGiDgCiDeOiClHiCoJiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiClLiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBjFlGiOjKjHpBiCmNiBeBiNmFjBoFiCmFiCfAiCePiCePiCePiCePiOoNjHnOiCnMiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_wcpPath = "C:\TMP\HELLO", wcpExt = ".TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				strName = "C:\TMP\HELLO_1f.TXT"
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmN_xHqqkZx_ _xZkqqHx_jHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFMakeUniqFileName (WString& strName, const wchar_t* wcpPath, const wchar_t* wcpExt)
{
	const WString wstrFullPath = FFFullPath(wcpPath);
	strName.Format(L"%s%s", wcpPath, wcpExt);
	WString wstrFilePath;
	wstrFilePath.Format(L"%s%s", wstrFullPath.c_str(), wcpExt);
	int iCount;
	for (iCount = 0; iCount < 10000; iCount++)
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (_MAX_PATH <= wstrFilePath.GetLength())
// 06.01.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			FFThrowFileException(CFileException::badPath, -1, wstrFilePath);
			FFThrowMiscUnknown();
		if (FFIsThereFile(wstrFilePath) == FD_FILE_NOT_EXIST)
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			return;
		}
		strName.Format(L"%s_%x%s", wcpPath, iCount, wcpExt);
		wstrFilePath.Format(L"%s_%x%s", wstrFullPath.c_str(), iCount, wcpExt);
	}
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CException* e = new CFCDDFileException(IDS_ERR_FILE_NOT_UNIQ_NAME, wstrFullPath);
//	e->ReportError();
//	throw e;
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FFThrowMiscUnknown();
//----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFMakeUniqFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeUniqTmpFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'TMP'_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClFiBeBiClLiCmMiJlKiCmJiDiGiDgKiBfLiDeOiCmI_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strName		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpPreName	:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAiPjMiCkCiClNjFjEjFkKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpExt		:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFMakeUniqFileName_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_TMP_xZkqqHx_jFmPjAjE_xHqqkZx_ = "C:\TMP", wcpPreName = "HELLO", wcpExt = ".TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				strName = "C:\TMP\HELLO_1f.TXT"
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmN_xHqqkZx_ _xZkqqHx_jHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.01.25 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
void FFMakeUniqTmpFileName (WString& strName, const wchar_t* wcpPreName, const wchar_t* wcpExt)
{
//----- 06.02.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	_TCHAR szTmpDir[_MAX_PATH + 1];
//	// _xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TEMP'_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
//	DWORD dwSize = GetEnvironmentVariable(_T("MOLIPTMP"), szTmpDir, sizeof(szTmpDir));
//	if (dwSize == 0)
//		dwSize = GetEnvironmentVariable(_T("TMP"), szTmpDir, sizeof(szTmpDir));
//	if (dwSize == 0)
//		dwSize = GetEnvironmentVariable(_T("TEMP"), szTmpDir, sizeof(szTmpDir));
//	if (dwSize == 0)
//	//----- _xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'TMP'/'TEMP'_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		CException* e = new CFCMiscException(IDS_ERR_ENV_NO_ENVVAR);
////		e->ReportError();
////		throw e;
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		FFThrowMiscUnknown();
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//	WString strPath = TStrToWStr(szTmpDir);
//----- 06.02.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strPath = FFGetTmpDirectory();
//----- 06.02.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// TMP=C:\_xZkqqHx_iCmMiPoKiNiHiCmIiCmHiBeBiNmFiMoDiCmJ_xHqqkZx_\_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmJjBmOiPiIiBeC_xHqqkZx_
	strPath.TrimRight(L'\\');
	strPath += L'\\';
	strPath += wcpPreName;
	FFMakeUniqFileName(strName, strPath, wcpExt);
} // FFMakeUniqTmpFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetTmpDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TEMP'_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetTmpDirectory ()
{
	_TCHAR szTmpDir[_MAX_PATH + 1];
	// _xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TMP'_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_'TEMP'_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwSize = GetEnvironmentVariable(_T("MOLIPTMP"), szTmpDir, sizeof(szTmpDir));
	if (dwSize == 0)
		dwSize = GetEnvironmentVariable(_T("TMP"), szTmpDir, sizeof(szTmpDir));
	if (dwSize == 0)
		dwSize = GetEnvironmentVariable(_T("TEMP"), szTmpDir, sizeof(szTmpDir));
	if (dwSize == 0)
	//----- _xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'TMP'/'TEMP'_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		FFThrowMiscUnknown();
	}
	WString wstrTmpDir = TStrToWStr(szTmpDir);
	wstrTmpDir.ChopLast(L'\\');
//----- 06.02.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// GUID_xZkqqHx_iCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClFiBeBiClLiClBiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
	wstrTmpDir += L'\\';
	wstrTmpDir += DYNAMIC_DRAW_CLSID_WSTR;
//----- 06.02.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return wstrTmpDir;
} // FFGetTmpDirectory ()

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyToUniqTmpFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCmFiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrDestName:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCiDfCiDhDiBfLiCmJiOlIjEhDiClFiClNiPoKiNiHiCoAjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			wcpOrgName	:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiMlDiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpPreName	:_xZkqqHx_jAfGiClFiCkCiDhEiDeAiDeDiDiLjGlMiCmMiBeBjAnKjDkKjFlGiOjKjHpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmNiBeBiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *			-----------------------------------------
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_TMP_xZkqqHx_jFmPjAjE_xHqqkZx_ = "C:\TMP",
 *				wcpOrgName = "C:\DOC\ABC.TXT",
 *				wcpPreName = "HELLO" _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			-----------------------------------------
 *				wstrDestName = "C:\TMP\HELLO_1f.TXT"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCopyToUniqTmpFile (WString& wstrDestName,
						const wchar_t* wcpOrigName,
						const wchar_t* wcpPreName)
{
	// wcpOrigName_xZkqqHx_iCmMiKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	wchar_t wszExt[_MAX_EXT];
//	_wsplitpath(wcpOrigName, NULL, NULL, NULL, wszExt);
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const int iLen = wcslen(wcpOrigName);
	WCharVector vExt(iLen + 1);
	_wsplitpath(wcpOrigName, NULL, NULL, NULL, &vExt.at(0));
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	for (;;)
	{
		// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiJlKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
// 06.10.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		FFMakeUniqTmpFileName(wstrDestName, wcpPreName, wszExt);
		FFMakeUniqTmpFileName(wstrDestName, wcpPreName, &vExt.at(0));
		// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCmJiBeBiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iPoDiCmMiKnGjAjEiCkJiCoHiClBiCmMiKnGjAjEiCnMiCmFiCmMiIoKiPhFiCmMiKnEiCmJiBeBjDkPiClGiDhEiDeAiDeDiDiLjGlMiCkK_xHqqkZx_
		// _xZkqqHx_jFmKiDhGiDiNiDfKiDfIiCmFiNoMjAkMiClDiCoKiCoJiJmCjEfMjAkLiCkKiBeBiCoNiClIiCkJiCmIiCkKiCoHjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		if (::CopyFile(WStrToTStr(wcpOrigName), WStrToTStr(wstrDestName), TRUE)) break;
		if (GetLastError() != ERROR_FILE_EXISTS)
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJ_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			LPTSTR lpMsgBuf;
			::FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | 
							FORMAT_MESSAGE_FROM_SYSTEM | 
							FORMAT_MESSAGE_IGNORE_INSERTS,
							NULL,
							GetLastError(),
							MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
							(LPTSTR)&lpMsgBuf,
							0,
							NULL);
			// Display the string.
			FFMessageBox(TStrToWStr(lpMsgBuf));
			// Free the buffer.
			LocalFree(lpMsgBuf);
			return FALSE;
		}
	}
	return TRUE;
} // FFCopyToUniqTmpFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFileNameRegal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjCiGiCmMiBeBiDhEiDeAiDeDiDiLjGlMiCmJiOgHiCkGiCmIiCkCjFlGiOjKiLhJiCnB_xHqqkZx_'.'_xZkqqHx_iCpAiOhHjCoIjFlGiOjKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_L'_'_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strName	:_xZkqqHx_jFlGiOjKjHpBiBeCjDpMiPgPjHmNiBeC_xHqqkZx_
 *			tch		:_xZkqqHx_jFmPiKlHjFlGiOjKiBeCiDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_L'_'_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFFileNameRegal (WString& strName, wchar_t tch)
{
	strName.Replace(L'"', tch);
	strName.Replace(L'*', tch);
	strName.Replace(L'/', tch);
	strName.Replace(L':', tch);
	strName.Replace(L'<', tch);
	strName.Replace(L'>', tch);
	strName.Replace(L'?', tch);
	strName.Replace(L'\\',tch);
	strName.Replace(L'|', tch);
	strName.Replace(L'.', tch);
} // FFFileNameRegal.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsFilePathRegal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCkKjHeMiMpIiCmIiDhEiDiLiDhAiDfIiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiDhEiDiLiDhAiDfIiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsFilePathRegal (const wchar_t* wcpFilePath)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const long lLen = wcslen(wcpFilePath);
//	if (_MAX_PATH <= lLen) return FALSE;
//	if (lLen == 0) return FALSE;
//	if (wcpFilePath[lLen - 1] == L'\\') return FALSE;
//	WString wstrDirPath;
//	WString wstrFile;
//	WString wstrExtension;
//	FFSplitFileName(&wstrDirPath, &wstrFile, &wstrExtension, wcpFilePath);
//	wstrFile += wstrExtension;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmGiClFiCmEiOgHiCkGiCmIiCkCjFlGiOjKiCpAiKnMiCnOiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (wstrFile.Find(L'"') != -1 ||
//		wstrFile.Find(L'*') != -1 ||
//		wstrFile.Find(L'/') != -1 ||
//		wstrFile.Find(L':') != -1 ||
//		wstrFile.Find(L'<') != -1 ||
//		wstrFile.Find(L'>') != -1 ||
//		wstrFile.Find(L'?') != -1 ||
//		wstrFile.Find(L'\\') != -1 ||
//		wstrFile.Find(L'|') != -1)
//		return FALSE;
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMjHeMiMpIjAkLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	return FFIsDirectoryPathRegal(strDirPath);
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrFilePath = wcpFilePath;
	if (_MAX_PATH <= wstrFilePath.GetLength())
		return FALSE;
	if (wstrFilePath.GetLength() == 0)
		return FALSE;
	if (wstrFilePath.GetLast() == L'\\')
		return FALSE;

	// _xZkqqHx_iDhAiDfIjAoGjDkKiCmJ_xHqqkZx_ _xZkqqHx_iDgIiDiJiDeDiDhFjGlM_xHqqkZx_("X:")_xZkqqHx_iCkKiCkAiCoJiPoKiNiHiCmNiPjMiCkNiBeC_xHqqkZx_
	if (2 < wstrFilePath.GetLength() &&
		wstrFilePath.GetAt(1) == L':')
		wstrFilePath = wstrFilePath.Mid(2);

	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmGiClFiCmEiOgHiCkGiCmIiCkCjFlGiOjKiCpAiKnMiCnOiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (wstrFilePath.Find(L'"') != -1 ||
		wstrFilePath.Find(L'*') != -1 ||
		wstrFilePath.Find(L'/') != -1 ||
		wstrFilePath.Find(L':') != -1 ||
		wstrFilePath.Find(L'<') != -1 ||
		wstrFilePath.Find(L'>') != -1 ||
		wstrFilePath.Find(L'?') != -1 ||
		wstrFilePath.Find(L'|') != -1)
		return FALSE;
	return TRUE;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFIsFilePathRegal.

//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsDirectoryPathRegal
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCkKjHeMiMpIiCmIiDhEiDiLiDhAiDfIiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiDhEiDiLiDhAiDfIiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFIsDirectoryPathRegal (const wchar_t* wcpDirPath)
//{
//	WString wstrDirPath(wcpDirPath);
//	if (_MAX_PATH <= wstrDirPath.GetLength()) return FALSE;
//	wstrDirPath.ChopLast(L'\\');
//	if (wstrDirPath.IsEmpty()) return TRUE;
//	if (wstrDirPath == L"\\") return TRUE;
//	if (wstrDirPath.GetLength() == 2 &&  wstrDirPath.GetAt(1) == L':') return TRUE;
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiNmFiMoDiCmM_xHqqkZx_'\\'_xZkqqHx_iCpAiNoNiPjMiClFiCmEiBeBiDhEiDeAiDeDiDiLjGlMiCmGiClFiCmEiCmMjHeMiMpIjAkLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	return FFIsFilePathRegal(wstrDirPath);
//} // FFIsDirectoryPathRegal.
//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFEnumDirectoryFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKjClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmGiDhEiDeAiDeDiDiLiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDirName	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiIoKjHjHiCpAjFnEiClHiBeCiDhAiDfIiCmFiCmNiCmIiCkNiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
 *			vFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMiIoKjHjHiCpAjFnEiClHiBeCiDhAiDfIiCmFiCmNiCmIiCkNiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
 *			wcpDirPath	:_xZkqqHx_iMjPiNpFiKeKiOgOiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCkK_xHqqkZx_
 *						 _xZkqqHx_jFhEiCkCiCmEiCkCiCmEiCoAiBeBiCkCiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	"." ".." _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmNiDfCiBfLiDiLiDgPiDgCiDeOiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFEnumDirectoryFile (	WStringVector& vDirName,
							WStringVector& vFileName,
							const wchar_t* wcpDirPath)
{
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString wstrDirPath = wcpDirPath;
//	wstrDirPath.ChopLast(L'\\');
//	wstrDirPath += L"\\*";
//	WIN32_FIND_DATA findData;
//	HANDLE hHandle = FindFirstFile(WStrToTStr(wstrDirPath), &findData);
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WIN32_FIND_DATA findData;
	HANDLE hHandle = FindFirstFile(WStrToTStr(wcpDirPath), &findData);
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (hHandle == INVALID_HANDLE_VALUE) return;
	do
	{
		// _xZkqqHx_iBhF_xHqqkZx_._xZkqqHx_iBhGiBhF_xHqqkZx_.._xZkqqHx_iBhGiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (_tcscmp(findData.cFileName, _T(".")) == 0) continue;
		if (_tcscmp(findData.cFileName, _T("..")) == 0) continue;
		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiIoKjHjHiBeC_xHqqkZx_
			vDirName.push_back(TStrToWStr(findData.cFileName));
		} else
		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKjCmKiPoNiCmMiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDhEiDeAiDeDiDiLjGlMiIoKjHjHiBeC_xHqqkZx_
			vFileName.push_back(TStrToWStr(findData.cFileName));
		}
	} while (FindNextFile(hHandle, &findData));
	FindClose(hHandle);
} // FFEnumDirectoryFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFEnumDirectoryFileNest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiImIiJlKiCpAjBfDiCmEjHpBiLjDiClFiBeBiCfAiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
 *			_xZkqqHx_iCfAiDgGiDeCiDiMiDeOiDgHiDiKiClCiCmGiCmJiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	proc		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDirPath	:_xZkqqHx_iMjPiNpFiKeKiOgOiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCkK_xHqqkZx_
 *						 _xZkqqHx_jFhEiCkCiCmEiCkCiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmJjDgOiClDiCoKiCoJiDiGiBfLiDfFiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHpBiLjDiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	"." ".." _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmNiDfCiBfLiDiLiDgPiDgCiDeOiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmNiBeBiImIiJlKjAhNiCmMiPiHjEnEiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiMmEiCnBiPgPiClFiCmMiPiHiPjIiBeC_xHqqkZx_
 *			()_xZkqqHx_iCmNiDgGiDeCiDiMiDeOiDgHiDiKiBeB_xHqqkZx_[]_xZkqqHx_iCmNiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 *            _xZkqqHx_iEkBiEjP_xHqqkZx_(1)_xZkqqHx_iEjPiEkGiEjP_xHqqkZx_(2)_xZkqqHx_iEjPiEkGiEjP_xHqqkZx_(3)_xZkqqHx_iEjPiEkGiEjP_xHqqkZx_[4]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_[5]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkEiEjP_xHqqkZx_[6]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_         
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_(7)_xZkqqHx_iEjPiEkGiEjP_xHqqkZx_[8] 
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_[10] _xZkqqHx_iEkEiEjP_xHqqkZx_[9]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkEiEjP_xHqqkZx_[11]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_                  
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_(12)-_xZkqqHx_iEkGiEjP_xHqqkZx_[13]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkEiEjP_xHqqkZx_[14]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_[15]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkFiEjP_xHqqkZx_[16]
 *            _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkFiEjP_xHqqkZx_(17)-_xZkqqHx_iEjP_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFEnumDirectoryFileNest (	FPEnumDirectoryFileProc proc,
								const wchar_t* wcpDirPath,
								void* pData)
{
	WStringVector vDirName;		// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiIoKjHjHiBeC_xHqqkZx_
	WStringVector vFileName;	// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDhEiDeAiDeDiDiLjGlMiIoKjHjHiBeC_xHqqkZx_
	// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmGiDhEiDeAiDeDiDiLiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
// 06.03.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFEnumDirectoryFile(vDirName, vFileName, wcpDirPath);
	FFEnumDirectoryFile(vDirName, vFileName, WString(wcpDirPath) + L"\\*");
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	const WString wstrDirPath = WString(wcpDirPath) + L"\\*";
//	WIN32_FIND_DATA findData;
//	HANDLE hHandle = FindFirstFile(WStrToTStr(wstrDirPath), &findData);
//	if (hHandle == INVALID_HANDLE_VALUE) return FALSE;
//
//	do
//	{
//		// _xZkqqHx_iBhF_xHqqkZx_._xZkqqHx_iBhGiBhF_xHqqkZx_.._xZkqqHx_iBhGiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (_tcscmp(findData.cFileName, _T(".")) == 0) continue;
//		if (_tcscmp(findData.cFileName, _T("..")) == 0) continue;
//		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
//		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiIoKjHjHiBeC_xHqqkZx_
//			vDirName.push_back(TStrToWStr(findData.cFileName));
//		} else
//		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKjCmKiPoNiCmMiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDhEiDeAiDeDiDiLjGlMiIoKjHjHiBeC_xHqqkZx_
//			vFileName.push_back(TStrToWStr(findData.cFileName));
//		}
//	} while (FindNextFile(hHandle, &findData));
//	FindClose(hHandle);
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	WStringVector::const_iterator iName;
	for (iName = vDirName.begin(); iName != vDirName.end(); iName++)
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJjBmOiClFiCmEiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
		if (!(*proc)(pData, FD_FILE_DIRECTORY, wcpDirPath, *iName))
			return FALSE;
		// _xZkqqHx_iClBiCmMiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiKnGiClFiCmEjHpBiLjDiCpAiNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
		if (!FFEnumDirectoryFileNest(proc, WString(wcpDirPath) + L'\\' + *iName, pData))
			return FALSE;
	}
	for (iName = vFileName.begin(); iName != vFileName.end(); iName++)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCmJjBmOiClFiCmEiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
		if (!(*proc)(pData, FD_FILE_32, wcpDirPath, *iName))
			return FALSE;
	}
	return TRUE;
} // FFEnumDirectoryFileNest.

//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindFirstFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiCmJiIoKjChGiClHiCoJiDhEiDeAiDeDiDiLiDiKiDfIiDgHiCmMiNmFiPiJiCmM_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fileFindData:_xZkqqHx_iDhEiDeAiDeDiDiLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FindFirstFile_xZkqqHx_iKnGjAjEiCmGjDkPjHgMiClOiCkKiBeB_xHqqkZx_FTFileKind_xZkqqHx_iCmM_xHqqkZx_
// *			FD_FILE_32_xZkqqHx_iBeB_xHqqkZx_FD_FILE_64_xZkqqHx_iBeB_xHqqkZx_FD_FILE_DIRECTORY _xZkqqHx_iCmJiIoKjChGiClHiCoJ_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiCnNiMjPiNpFjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFFindFirstFile (	const wchar_t* wcpFileName,
//						FCHiFileFindData* fileFindData,
//						FTFileKind fileKindSearch0,
//						FTFileKind fileKindSearch1,
//						FTFileKind fileKindSearch2,
//						FTFileKind fileKindSearch3)
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////						FTFileKind fileKindSearch4)
//{
//	WString wstrDirectoryPath = FFGetFileDirectory(wcpFileName);
//	WIN32_FIND_DATA findData;
//	HANDLE hHandle = ::FindFirstFile(WStrToTStr(wcpFileName), &findData);
//	while (hHandle != INVALID_HANDLE_VALUE)
//	{
//		FTFileKind fileKind = FFCheckFileExist(wstrDirectoryPath + (const wchar_t*)TStrToWStr(findData.cFileName));
//		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		// 64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		if (fileKind == fileKindSearch0 ||
//			fileKind == fileKindSearch1 ||
//			fileKind == fileKindSearch2 ||
//			fileKind == fileKindSearch3)
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////			fileKind == fileKindSearch4)
//		{
//			fileFindData->m_wstrFileName = TStrToWStr(findData.cFileName);
//			fileFindData->m_fileKind = fileKind;
//			fileFindData->m_wstrDirectoryPath = wstrDirectoryPath;
//			fileFindData->m_hFindFile = hHandle;
//			fileFindData->m_fileKindSearch[0] = fileKindSearch0;
//			fileFindData->m_fileKindSearch[1] = fileKindSearch1;
//			fileFindData->m_fileKindSearch[2] = fileKindSearch2;
//			fileFindData->m_fileKindSearch[3] = fileKindSearch3;
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////			fileFindData->m_fileKindSearch[4] = fileKindSearch4;
//			break;
//		}
//		if (!::FindNextFile(hHandle, &findData))
//		{
//			FindClose(hHandle);
//			hHandle = INVALID_HANDLE_VALUE;
//			break;
//		}
//	}
//	return (hHandle != INVALID_HANDLE_VALUE);
//} // FFFindFirstFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindNextFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FFFindFirstFile_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiCmJiIoKjChGiClHiCoJ_xHqqkZx_
//			_xZkqqHx_iDhEiDeAiDeDiDiLiDiKiDfIiDgHiCmMiBeBiOjPiCmMiDhEiDeAiDeDiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileFindData:_xZkqqHx_iDhEiDeAiDeDiDiLiPoOjFpBiCpAiOhHjCoIiBjFjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FindNextFile_xZkqqHx_iKnGjAjEiCmGjDkPjHgMiClOiCkKiBeB_xHqqkZx_FTFileKind_xZkqqHx_iCmM_xHqqkZx_
// *			FD_FILE_32_xZkqqHx_iBeB_xHqqkZx_FD_FILE_64_xZkqqHx_iBeB_xHqqkZx_FD_FILE_DIRECTORY _xZkqqHx_iCmJiIoKjChGiClHiCoJ_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiCnNiMjPiNpFjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFFindNextFile (FCHiFileFindData* fileFindData)
//{
//	WIN32_FIND_DATA findData;
//	while (::FindNextFile(fileFindData->m_hFindFile, &findData))
//	{
//		FTFileKind fileKind = FFCheckFileExist(fileFindData->m_wstrDirectoryPath + (const wchar_t*)TStrToWStr(findData.cFileName));
//		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		// 64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		if (fileKind == fileFindData->m_fileKindSearch[0] ||
//			fileKind == fileFindData->m_fileKindSearch[1] ||
//			fileKind == fileFindData->m_fileKindSearch[2] ||
//			fileKind == fileFindData->m_fileKindSearch[3])
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////			fileKind == fileFindData->m_fileKindSearch[4])
//		{
//			fileFindData->m_wstrFileName = TStrToWStr(findData.cFileName);
//			fileFindData->m_fileKind = fileKind;
//			return TRUE;
//		}
//	}
//	return FALSE;
//} // FFFindNextFile.
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindClose
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FFFindFirstFile_xZkqqHx_iCmFiOoGjDlOiClFiClNiDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileFindData:_xZkqqHx_iDhEiDeAiDeDiDiLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFFindClose (FCHiFileFindData* fileFindData)
{
	return ::FindClose(fileFindData->m_hFindFile);
} // FFFindClose.

//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mywstat
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_wstat_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//int mywstat (const wchar_t* path, struct_stat* buffer)
//{
//	// _tstat_xZkqqHx_iCmNiDgMiDgCiDgHiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCmJjBmOiJjOiClFiCmIiCkCiClNiCnPiBeBiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
//	// GetFileAttributes_xZkqqHx_iCpAiOgHiCkEiClBiCmGiBeC_xHqqkZx_
//	FFThrowMiscUnknown();
//	return 0;
//} // mywstat.
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mywremove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_wremove_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int mywremove (const wchar_t* path)
{
	return _tremove(WStrToTStr(path));
} // mywremove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mywrename
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_wrename_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int mywrename (const wchar_t* oldname, const wchar_t* newname)
{
	return _trename(WStrToTStr(oldname), WStrToTStr(newname));
} // mywrename.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mywsopen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_wsopen_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int mywsopen (const wchar_t* wcpPath, int oflag, int shflag, int pmode)
{
	return _tsopen(WStrToTStr(wcpPath), oflag, shflag, pmode);
} // mywsopen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetCurrentDirectory_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFSetCurrentDirectory (const wchar_t* path)
{
	return SetCurrentDirectory(WStrToTStr(path));
} // FFSetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDeleteFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DeleteFile_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFDeleteFile (const wchar_t* wcpFileName)
{
	BOOL bReturn = DeleteFile(WStrToTStr(wcpFileName));
//	ASSERT(bReturn);
	return bReturn;
} // FFDeleteFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsThereFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmMjBlGiNnNiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	path	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmMjHeMjGlDiCmGiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *				FD_FILE_NOT_EXIST	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
 *				FD_FILE_32			32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
 *				FD_FILE_DIRECTORY	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFCheckFileExist_xZkqqHx_iCmGiInJiCmIiCoIiBeBiDhEiDeAiDeDiDiLiCkJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDgAiDeGiDgCiDeO_xHqqkZx_
 *			_xZkqqHx_iClFiCkJiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTFileKind FFIsThereFile (const wchar_t* path)
{
//----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	struct_stat buffer;
//	if (mywstat(path, &buffer) == 0)
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (buffer.st_mode & _S_IFDIR)
//		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//			return FD_FILE_DIRECTORY;
//		} else
//		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			return FD_FILE_32;		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
//		}
//	} else
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		return FD_FILE_NOT_EXIST;
//	}
//----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#ifndef INVALID_FILE_ATTRIBUTES
// SDK/WinBase.h _xZkqqHx_iCoGiCoIiBeC_xHqqkZx_
#define INVALID_FILE_ATTRIBUTES ((DWORD)-1)
#endif//INVALID_FILE_ATTRIBUTES
	const DWORD dwFileAttrib = GetFileAttributes(WStrToTStr(path));
	if (dwFileAttrib == INVALID_FILE_ATTRIBUTES)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDeBiDeOiDfKiDfIiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		switch (GetLastError())
		{
		case ERROR_FILE_NOT_FOUND:	// The system cannot find the file specified.
		case ERROR_PATH_NOT_FOUND:	// The system cannot find the path specified.
			return FD_FILE_NOT_EXIST;
		default:
			FFThrowMiscLastError();
		}
	}
	if (dwFileAttrib & FILE_ATTRIBUTE_DIRECTORY)
		return FD_FILE_DIRECTORY;	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
	return FD_FILE_32;				// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
//----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFIsThereFile.

//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCheckFileExist
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmMjBlGiNnNiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	path	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmMjHeMjGlDiCmGiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
// *				FD_FILE_NOT_EXIST	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
// *				FD_FILE_32	32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
// *				FD_FILE_64	64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
// *				FD_FILE_DIRECTORY	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
// *				FD_FILE_LOCK		_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
// *				FD_FILE_DIFF		_xZkqqHx_iNlHjFkKiDiNiDePiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCmGiCmNiBeB_xHqqkZx_path_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClFiBeB_xHqqkZx_
// *			_xZkqqHx_iNfIiCmJ_xHqqkZx_ path _xZkqqHx_iCmMiJkBiCmJ_xHqqkZx_.control_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjCmKiPoNiDhEiDeAiDeDiDiLiCmGiClFiCmEjBlGiNnN_xHqqkZx_
// *			_xZkqqHx_iClHiCoJiPoKiNiHiCmJiBeB_xHqqkZx_64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCmGjEeGiCnPiCoJiBeC_xHqqkZx_
// *			64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCmNiBeB_xHqqkZx_FCFile64 _xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCmFiDeBiDeOiDfKiDfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTFileKind FFCheckFileExist (const wchar_t* path)
//{
//	switch (FFIsThereFile(path))
//	{
//	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		if (FFIsThereFile(WString(path) + L"\\.control") == FD_FILE_32)
////		//----- _xZkqqHx_iKmHjHjNiDhEiDeAiDeDiDiLiCkKjCmKiPoNiDhEiDeAiDeDiDiLiCmGiClFiCmEjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
////		{
////			// 64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
////			return FD_FILE_64;
////		} else
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		if (FFGetFileExtension(path) == L".lock" &&
//			FFIsThereFile(WString(path) + L"\\own.lc") == FD_FILE_32)
//		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiKgHjCkDiOhBiCkK_xHqqkZx_.lock_xZkqqHx_iKiOiCmC_xHqqkZx_own.lc_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnN_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//			return FD_FILE_LOCK;
//		} else
//		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//			return FD_FILE_DIRECTORY;
//		}
//	case FD_FILE_32:		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		if (FFGetFileName(path) == L"_~.diff~")
//			return FD_FILE_DIFF;	// _xZkqqHx_iNlHjFkKiDiNiDePiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
//		else
//			return FD_FILE_32;		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
//	default:				// FD_FILE_NOT_EXIST _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
//		return FD_FILE_NOT_EXIST;
//	}
//} // FFIsFileExist.
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bAddSlash	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCpAjCmHiJmBiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetCurrentDirectory (BOOL bAddSlash)
{
	WString wstrCurDir;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiBeC_xHqqkZx_
	_TCHAR tcsDir[_MAX_PATH];
	if (0 < ::GetCurrentDirectory(sizeof(tcsDir) / sizeof(_TCHAR), tcsDir))
	{
		wstrCurDir = TStrToWStr(tcsDir);
		if (bAddSlash)
		{
			// TMP=C:\_xZkqqHx_iCmMiPoKiNiHiCmIiCmHiBeBiNmFiMoDiCmJ_xHqqkZx_\_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmJjBmOiPiIiBeC_xHqqkZx_
			wstrCurDir.TrimRight(L'\\');
			wstrCurDir += L'\\';
		}
	}
	return wstrCurDir;
} // FFGetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDesktopDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiLpDjFlGiOjKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmMiNmFiMoDiCmJ_xHqqkZx_ '\' _xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetDesktopDirectory ()
{
	//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCpAiOoGjDlO_xHqqkZx_ -----
	LPITEMIDLIST pidl;
	if(!SUCCEEDED(SHGetSpecialFolderLocation(NULL, CSIDL_DESKTOPDIRECTORY, &pidl)))
		return WString();
	_TCHAR szDesktop[_MAX_PATH + 1];
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	SHGetPathFromIDList(pidl, szDesktop);
	// Get the shell's allocator to free PIDLs
	//----- _xZkqqHx_iDiPiBfLiDeOjHmMiIoGiCpAiKeKjFpK_xHqqkZx_ -----
	LPMALLOC lpMalloc;
	if (!SHGetMalloc(&lpMalloc) && (lpMalloc != NULL))
	{
		lpMalloc->Free(pidl);
		lpMalloc->Release();
	}
	return TStrToWStr(szDesktop);
} // FFGetDesktopDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCopyFile (const wchar_t* wcpExistingFile, const wchar_t* wcpNewFile, BOOL bFailIfExists)
{
	return ::CopyFile(WStrToTStr(wcpExistingFile), WStrToTStr(wcpNewFile), bFailIfExists);
} // FFCopyFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFileNameToFormat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJ_xHqqkZx_URL_xZkqqHx_jGlMiBgKiCpAiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHjCgMiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJ_xHqqkZx_URL_xZkqqHx_jGlMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMiPoKiNiHiBeBjAoCjBmOiDhAiDfIiBeFjBiKjBmOiDhAiDfIiCmHiClPiCoHiCmFiCoA_xHqqkZx_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHjCgMiBeCiIoKjChGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FD_DTP_NONE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCmJiCmNiBeBjCmKiPoNiCmMiDhAiDfIiOhHjCoIiImIiKePiCmJiBeBiImIiJlKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCmF_xHqqkZx_
 *			_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiCkKiOhHjCoIiPgPjHiIiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDiLiDhAiDfI_xHqqkZx_?_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiOhHjCoI_xHqqkZx_&_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiOhHjCoI_xHqqkZx_&_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiOhHjCoIiBeFiBeFiBeF_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_c:\doc\world.xxx?bit=32&lock=yes&delay=no
 *				hidp://abc.co.jp/hello/world.xxx?bit=32&lock=yes&delay=no
 *			hidp_xZkqqHx_iCmNiBeB_xHqqkZx_HI_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDeBiDeOiDfKiDfIiDhGiDiNiDgHiDfCiDiLiBeC_xHqqkZx_
 *			_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiCmMiOoNjHnOiBeC_xHqqkZx_
 *			lock=yes/no	:_xZkqqHx_iDiNiDgCiDeOjFhEiCkLiDhEiDeAiDeDiDiLiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bit=32/64	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDfEiDeDiDfJiCmMiOoNjHnOiBeC_xHqqkZx_32bit_xZkqqHx_iCmMiPoKiNiHiCmNiBeBjCmKiPoNiCmM_xHqqkZx_
 *						 _xZkqqHx_iDhEiDeAiDeDiDiLiBeC_xHqqkZx_64bit_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx___int64_xZkqqHx_iCmMiDfEiDeDiDfJiCnMiCmFiBeC_xHqqkZx_
 *			later=yes/no:_xZkqqHx_jChIiJiEiDeJiBfLiDhGiDjDiDhEiDeAiDeDiDiLiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocumentFormat FFFileNameToFormat (const wchar_t* wcpFileName)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCkJiCoHiKgHjCkDiOhBiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrExtension;	// _xZkqqHx_iKgHjCkDiOhBiBeCjHoBiBhF_xHqqkZx_.mdrw_xZkqqHx_iBhG_xHqqkZx_
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	WString wstr = wcpFileName;
	WString wstrFileName = FFExtractUntil(wstr, L'?');
	// _xZkqqHx_iNmFiMoDiCmMiDhDiDiKiDeJiDgIiCpAjCfEiClFiPgPiClHiBeC_xHqqkZx_
	long lPos = wstrFileName.find_last_of(L'.');
	if (lPos != WString::npos)
	{
		wstrExtension = wstrFileName.substr(lPos).c_str();
	}
	//----- _xZkqqHx_iKgHjCkDiOhBiCpAiKgFiDhEiDeIiBfLiDhNiDgCiDgHiCmMiKgHjCkDiOhBiCmGjEoEiKhC_xHqqkZx_ -----
	if (wstrExtension.CompareNoCase(FD_FILE_EXT_STANDARD_FORMAT) == 0)
		return FD_DTP_STANDARD_FORMAT;	// _xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
	if (wstrExtension.CompareNoCase(FD_FILE_EXT_PORTABLE_FORMAT) == 0)
		return FD_DTP_PORTABLE_FORMAT;	// _xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//----- 05.05.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (wstrExtension.CompareNoCase(L".mdvf") == 0)
//		return FD_DTP_VIEWER_FORMAT;	// _xZkqqHx_iDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//----- 05.05.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (wstrExtension.CompareNoCase(FD_FILE_EXT_TEMPLATE_FORMAT) == 0)
		return FD_DTP_TEMPLATE_FORMAT;	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
	if (wstrExtension.CompareNoCase(FD_FILE_EXT_WORK_FORMAT) == 0)
		return FD_DTP_WORK_FORMAT;	// _xZkqqHx_iDiPiBfLiDeOiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//----- 06.02.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (wstrExtension.CompareNoCase(FD_FILE_EXT_TOP_GROUP) == 0)
		return FD_DTP_PROJECT_FORMAT;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
	if (wstrExtension.CompareNoCase(FDTBL_DATA_FILE_EXT) == 0)
		return FD_DTP_TABLE_DATA_FORMAT;	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddtb)
	if (wstrExtension.CompareNoCase(FDTBL_INDEX_FILE_EXT) == 0)
		return FD_DTP_TABLE_INDEX_FORMAT;	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddix)
//----- 06.02.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return FD_DTP_NONE;				// _xZkqqHx_iMfOjGlDiClFiBeC_xHqqkZx_
//----- 03.07.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFFileNameToFormat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiClCiCmGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathFrom	:_xZkqqHx_iDfCiDhDiBfLiMlDiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPathTo	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiImIiJlKiCmMiDhEiDeAiDeDiDiLiBeBiDfEiDhFiDgGiDeCiDiMiDeOiDgHiDiKiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCopyDirectory (const wchar_t* wcpPathFrom, const wchar_t* wcpPathTo)
{
	// _xZkqqHx_iCnMiClIiBeBiDfCiDhDiBfLjAoGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
	WString wstrCreatedPath;
	if (!FFRecursiveCreateDirectory(&wstrCreatedPath, wcpPathTo))
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!wstrCreatedPath.IsEmpty())
			FFRecursiveRemoveDirectory(wstrCreatedPath);
		return FALSE;
	}

	WString wstrPathFrom = wcpPathFrom;
	if (wstrPathFrom.GetLast() != L'\\') wstrPathFrom += L'\\';
	WString wstrPathTo = wcpPathTo;
	if (wstrPathTo.GetLast() != L'\\') wstrPathTo += L'\\';

	WIN32_FIND_DATA findData;
	HANDLE hDir = FindFirstFile(WStrToTStr(wstrPathFrom + L'*'), &findData);
	if (hDir == INVALID_HANDLE_VALUE) return FALSE;
	BOOL bSucceed = TRUE;
	do
	{
		// _xZkqqHx_iBhF_xHqqkZx_._xZkqqHx_iBhGiBhF_xHqqkZx_.._xZkqqHx_iBhGiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (_tcscmp(findData.cFileName, _T(".")) == 0) continue;
		if (_tcscmp(findData.cFileName, _T("..")) == 0) continue;
		// _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
		const WString wstrFileName = TStrToWStr(findData.cFileName);
		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			bSucceed = FFCopyDirectory(	wstrPathFrom + wstrFileName,
											wstrPathTo + wstrFileName);
		} else
		//----- _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLiCkKjCmKiPoNiCmMiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			bSucceed = ::CopyFile(	WStrToTStr(wstrPathFrom + wstrFileName),
									WStrToTStr(wstrPathTo + wstrFileName), FALSE);

		}
	} while (bSucceed && FindNextFile(hDir, &findData));
	FindClose(hDir);
	return bSucceed;
} // FFCopyDirectory.

//----- 06.01.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiClCiCmGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathFrom	:_xZkqqHx_iDfCiDhDiBfLiMlDiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpPathTo	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiImIiJlKiCmMiDhEiDeAiDeDiDiLiBeBiDfEiDhFiDgGiDeCiDiMiDeOiDgHiDiKiCpA_xHqqkZx_
// *			_xZkqqHx_jBfDiCmEiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDfCiDhDiBfLiClDiCoKiCoJiDhEiDeAiDeDiDiLiCmNiBeB_xHqqkZx_FTFileKind_xZkqqHx_iCmM_xHqqkZx_
// *			FD_FILE_32_xZkqqHx_iBeB_xHqqkZx_FD_FILE_64_xZkqqHx_iBeB_xHqqkZx_FD_FILE_DIRECTORY _xZkqqHx_iCmMiCnNiCmFiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFCopyDirectory (const wchar_t* wcpPathFrom, const wchar_t* wcpPathTo)
//{
//	// _xZkqqHx_iCnMiClIiBeBiDfCiDhDiBfLjAoGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	if (!FFRecursiveCreateDirectory(NULL, wcpPathTo)) return FALSE;
//
//	WString wstrPathFrom = wcpPathFrom;
//	if (wstrPathFrom.GetLast() != L'\\') wstrPathFrom += '\\';
//	WString wstrPathTo = wcpPathTo;
//	if (wstrPathTo.GetLast() != L'\\') wstrPathTo += '\\';
//
//	FCHiFileFindData fileFindData;
//	if (!FFFindFirstFile(wstrPathFrom + L'*', &fileFindData)) return FALSE;
//	BOOL bSucceed = TRUE;
//	do
//	{
//		// _xZkqqHx_iBhF_xHqqkZx_._xZkqqHx_iBhGiBhF_xHqqkZx_.._xZkqqHx_iBhGiCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (wcscmp(fileFindData.m_wstrFileName, L".") == 0) continue;
//		if (wcscmp(fileFindData.m_wstrFileName, L"..") == 0) continue;
//		switch (fileFindData.m_fileKind)
//		{
//		case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
//			bSucceed = FFCopyDirectory(wstrPathFrom + fileFindData.m_wstrFileName,
//										wstrPathTo + fileFindData.m_wstrFileName);
//			break;
//		case FD_FILE_32:	// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//			bSucceed = FCFile32::Copy(wstrPathFrom + fileFindData.m_wstrFileName,
//										wstrPathTo + fileFindData.m_wstrFileName);
//			break;
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		case FD_FILE_64:	// 64_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
////			bSucceed = FCFile64::Copy(wstrPathFrom + fileFindData.m_wstrFileName,
////										wstrPathTo + fileFindData.m_wstrFileName);
////			break;
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		}
//	} while (bSucceed && FFFindNextFile(&fileFindData));
//	FFFindClose(&fileFindData);
//	return bSucceed;
//} // FFCopyDirectory.
//----- 06.01.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFRecursiveCreateDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrCreatedPath	:_xZkqqHx_iNoMjAkMiClDiCoKiClNiNmFiCoAiPoDiImKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmIiCoH_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDirPath	:_xZkqqHx_iNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhAiDfIiCpAiDhEiDiLiDhAiDfIiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_
 *					 '\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCmEiCoAiCkCiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjBlGiNnNiClHiCoJiPoKiNiHiBeBiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhAiDfIiCkKiBeBiMlLiNnNjBlGiNnNiClHiCoJiDhAiDfIiCkJiCoHiCfBjCgJiKeLiImIiPoDjAfLiCkNiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpDirPath = "c:\abc1\abc2\abc3\abc4" _xZkqqHx_iCpAiNoMjAkMiClHiCoJiPoKiNiHiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKpJiCmJ_xHqqkZx_ "c:\abc1\abc2" _xZkqqHx_iCkKiNnNiCoJiPoKiNiHiBeB_xHqqkZx_wstrCreatedPath _xZkqqHx_iCmJjFnEiClDiCoKiCoJiCmMiCmN_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiCoJiCmMiCmN_xHqqkZx_ "c:\abc1\abc2\abc3" _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFRecursiveCreateDirectory (WString* wstrCreatedPath,
									const wchar_t* wcpDirPath)
{
//----- 06.02.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	WString wstrPath = wcpDirPath;
//	// _xZkqqHx_iDhAiDfIjGlMiCmMiNmFiMoDiCmJiBhF_xHqqkZx_\_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//	wstrPath.ChopLast(L'\\');
//	// _xZkqqHx_iDhAiDfIjGlMiCmMiNmFiMoDiCmJiBhF_xHqqkZx_:_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (wstrPath.GetLast() == L':') return TRUE;
//
//	switch (FFIsThereFile(wstrPath))
//	{
//	case FD_FILE_32:		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
//		if (wstrCreatedPath != NULL)
//			wstrCreatedPath->Empty();
//		return FALSE;
//	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiHiBeC_xHqqkZx_
//		return TRUE;
//	default:				// _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//		if (wstrCreatedPath != NULL)
//			*wstrCreatedPath = wstrPath;
//	}
//	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLjGlMiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
//	WString wstrParentDirPath = FFGetFileDirectory(wstrPath);
//	// _xZkqqHx_iNmFiMoDiCmMiBhF_xHqqkZx_\_xZkqqHx_iBhGiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//	wstrParentDirPath.ChopLast(L'\\');
//	// _xZkqqHx_iIoKiCmCiPoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	if (!FFRecursiveCreateDirectory(wstrCreatedPath, wstrParentDirPath))
//		return FALSE;
//	// _xZkqqHx_iNmFiMoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	return FFCreateDirectory(wstrPath, NULL);
//----- 06.02.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	WString wstrDirPath = wcpDirPath;
	// _xZkqqHx_iDhAiDfIjGlMiCmMiNmFiMoDiCmJiBhF_xHqqkZx_\_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	wstrDirPath.ChopLast(L'\\');
	// _xZkqqHx_iDhAiDfIjGlMiCmMiNmFiMoDiCmJiBhF_xHqqkZx_:_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (wstrDirPath.GetLast() == L':') return TRUE;

	switch (FFIsThereFile(wstrDirPath))
	{
	case FD_FILE_32:		// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		if (wstrCreatedPath != NULL)
			wstrCreatedPath->Empty();
		return FALSE;
	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		if (wstrCreatedPath != NULL)
			wstrCreatedPath->Empty();
		return TRUE;
	default:		// _xZkqqHx_iDhEiDeAiDeDiDiLiCoAiDgGiDeCiDiMiDeOiDgHiDiKiCoAjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiBeBiClLiCmMiIoKiCmCiPoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
		WString wstrParentDirPath = FFGetFileDirectory(wstrDirPath);
		// _xZkqqHx_iNmFiMoDiCmMiBhF_xHqqkZx_\_xZkqqHx_iBhGiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		wstrParentDirPath.ChopLast(L'\\');
		// _xZkqqHx_iIoKiCmCiPoDiBeBiNfIiCmJiPoDiBeBiCmGiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNmEiLeBjDeJiCmJiNoMjAkMiBeC_xHqqkZx_
		if (!FFRecursiveCreateDirectory(wstrCreatedPath, wstrParentDirPath))
			return FALSE;
		// _xZkqqHx_iNmFiMoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
		if (FFCreateDirectory(wstrDirPath, NULL))
		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmMiNmFiPoDiImKiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			if (wstrCreatedPath != NULL && wstrCreatedPath->IsEmpty())
				*wstrCreatedPath = wstrDirPath;
			return TRUE;
		} else
		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			return FALSE;
		}
	  }
	}
//----- 06.02.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFRecursiveCreateDirectory.

//----- 06.02.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFRecursiveCreateDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrCreatedPath	:_xZkqqHx_iNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *							 _xZkqqHx_jFhDjHhGiCmIiCoH_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpDirPath	:_xZkqqHx_iNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhAiDfIiCpAiDhEiDiLiDhAiDfIiOhHjCoIiBeC_xHqqkZx_
// *					 _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCmEiCoAiCkCiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjBlGiNnNiClHiCoJiPoKiNiHiBeBiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhAiDfIiCkKiBeBiMlLiNnNjBlGiNnNiClHiCoJiDhAiDfIiCkJiCoHiCfBjCgJiKeLiImIiPoDjAfLiCkNiCmEiCoA_xHqqkZx_
// *			_xZkqqHx_iNmEiLeBjDeJiCmJiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *			FD_FILE_DIRECTORY_xZkqqHx_iCmMiDgGiDeCiDiMiDeOiDgHiDiKiClOiCkPiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *			wstrCreatedPath _xZkqqHx_iCmJiCmNiBeBiNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmMiCkEiClPiBeB_xHqqkZx_
// *			_xZkqqHx_iNmFiCoAiPoDiImKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_jHoBiCkGiCmOiKpJjBlGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiBhF_xHqqkZx_C:\TMP_xZkqqHx_iBhGiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
// *			_xZkqqHx_iBhF_xHqqkZx_C:\TMP\ABC\XYZ_xZkqqHx_iBhGiCpAiNoMjAkMiClHiCoJiCmGiBeBiBhF_xHqqkZx_C:\TMP\ABC_xZkqqHx_iBhGiCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFRecursiveCreateDirectory (WString* wstrCreatedPath,
//								 const wchar_t* wcpDirPath)
//{
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	WString wstrPath = wcpDirPath;
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCkKiLpDiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (wstrPath.IsEmpty()) return FALSE;
//	// _xZkqqHx_iDhAiDfIjGlMiCmMiNmFiMoDiCmJiBhF_xHqqkZx_\_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//	wstrPath.ChopLast(L'\\');
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCkKiLpDiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
//	if (wstrPath.IsEmpty()) return TRUE;
//	// _xZkqqHx_iBhF_xHqqkZx_\_xZkqqHx_iBhGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
//	if (wstrPath == L"\\") return TRUE;
//	// _xZkqqHx_iBhF_xHqqkZx_X:_xZkqqHx_iBhGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
//	if (wstrPath.GetLength() == 2 && wstrPath.GetAt(1) == L':') return TRUE;
//	// _xZkqqHx_iKpJjBlGiCmMiDhEiDeAiDeDiDiLiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	switch (FFIsThereFile(wstrPath))
//	{
//	case FD_FILE_NOT_EXIST:	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
//		if (wstrCreatedPath != NULL)
//			*wstrCreatedPath = wstrPath;
//		break;
//	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		return TRUE;
//	default:
//		// case FD_FILE_32:		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		if (wstrCreatedPath != NULL)
//			wstrCreatedPath->Empty();
//		return FALSE;
//	}
//	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLjGlMiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
//	WString wstrParentDirPath = FFGetFileDirectory(wstrPath);
//	// _xZkqqHx_iIoKiCmCiPoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	if (!FFRecursiveCreateDirectory(wstrCreatedPath, wstrParentDirPath))
//		return FALSE;
//	// _xZkqqHx_iNmFiMoDiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	return FFCreateDirectory(wstrPath, NULL);
//} // FFRecursiveCreateDirectory.
//----- 06.02.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.05.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFileFrom	:_xZkqqHx_iDfCiDhDiBfLiMlDiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
// *			wcpFileTo	:_xZkqqHx_iDfCiDhDiBfLjAoGiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CopyFile_xZkqqHx_iKnGjAjEiCkKiOgHiCkGiCoJiCmMiClOiCkKiBeBiJlNiMmMiCkJ_xHqqkZx_CopyFile_xZkqqHx_iKnGjAjEiCmFiDfCiDhDiBfLiClFiClN_xHqqkZx_
// *			_xZkqqHx_iMoDiCmJiBeBiDfCiDhDiBfLiDhEiDeAiDeDiDiLiCpA_xHqqkZx_CDocument::OnOpenDocument_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
// *			_xZkqqHx_iKeKiCkNiClBiCmGiCkKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iClLiCmMjBoDjHhAiCmGiClFiCmEiClBiCmMiKnGjAjEiCpAiNoMjAkMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkLjDjJiCmNiDfCiDhDiBfLiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFCopyFile (const wchar_t* wcpFileFrom, const wchar_t* wcpFileTo)
//{
//	int iRF = mywsopen(wcpFileFrom, _O_BINARY|_O_RDONLY, _SH_DENYNO);
//	if (iRF == -1) return FALSE;
//	int iWF = mywsopen(wcpFileTo, _O_BINARY|_O_CREAT|_O_TRUNC|_O_WRONLY, _SH_DENYWR, _S_IREAD|_S_IWRITE);
//	if (iWF == -1)
//	{
//		_close(iRF);
//		return FALSE;
//	}
//	BYTE byaBuff[0x1000];
//	int iSZ = sizeof(byaBuff);
//	for (;;)
//	{
//		const int iCount = _read(iRF, byaBuff, sizeof(byaBuff));
//		_write(iWF, byaBuff, iCount);
//		if (iCount != sizeof(byaBuff)) break;
//	}
//	_close(iWF);
//	_close(iRF);
//	return TRUE;
//} // FFCopyFile.
//----- 03.05.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//////////////////////////////////////////////////////////////////////////////////

//----- 03.05.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FFWriteData (BYTEVector& vStream, const void* pData, long lSize)
//{
//	vStream.insert(vStream.end(), (const BYTE*)pData,
//								(const BYTE*)pData + lSize);
//} // FFWriteData.
//----- 03.05.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

BOOL FFRemoveDirectory (const wchar_t* wcpPath)
{
	return RemoveDirectory(WStrToTStr(wcpPath));
} // FFRemoveDirectory.

//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFRemoveDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCkJiCoHiImIiJlKiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFRemoveDirectory (const wchar_t* wcpPath)
//{
//	// _xZkqqHx_iDhAiDfIiCkKjFhDjAlDiBeBiIlNiCkCiCmNjCfKiClHiCkMiCoJiBgJjHoBiBeG_xHqqkZx_C:\ _xZkqqHx_iCmIiCmHiBgKiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
//	if (wcpPath == NULL || wcpPath[0] == L'\0' || wcslen(wcpPath) < 4)
//// 06.01.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		FFThrowFileException(CFileException::ErrnoToException(errno), -1, wcpPath);
//		FFThrowMiscUnknown();
//
//	WString strPath = WString(wcpPath) + L"\\*";
//	WIN32_FIND_DATA findData;
//	HANDLE hDir = FindFirstFile(WStrToTStr(strPath), &findData);
//	if (hDir != INVALID_HANDLE_VALUE)
//	{
//		do
//		{
//			if (_tcscmp(findData.cFileName, _T(".")) == 0) continue;
//			if (_tcscmp(findData.cFileName, _T("..")) == 0) continue;
//			WString wstrMsg = WString(wcpPath) + L"\\" + (const wchar_t*)TStrToWStr(findData.cFileName);
//			if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
//			{
//				FFRemoveDirectory(wstrMsg);
//			} else
//			{
//				if (mywremove(wstrMsg) != 0)
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////					FFThrowFileException(CFileException::ErrnoToException(errno), -1,
////										wstrMsg);
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//					FFThrowMiscUnknown();
////----- 06.01.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//			}
//		} while (FindNextFile(hDir, &findData));
//		FindClose(hDir);
//	}
//	if (_trmdir(WStrToTStr(wcpPath)) != 0)
//// 06.01.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		FFThrowFileException(CFileException::ErrnoToException(errno), -1, wcpPath);
//		FFThrowMiscUnknown();
//} // FFRemoveDirectory.
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFRecursiveRemoveDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCkJiCoHiImIiJlKiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmFiCoAiMlLiPpDiCmMiJpBjFjMiCmNiClFiCmIiCkCiBeCiOhHjCoIiCmMiDhAiDfIiCkKiKnEiIoBiCmBiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_GetLastError_xZkqqHx_iCmFiDeHiDiJiBfLiCpAiOoGjDlOiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFRecursiveRemoveDirectory (const wchar_t* wcpPath)
{
	// _xZkqqHx_iDhAiDfIiCkKjFhDjAlDiBeBiIlNiCkCiCmNjCfKiClHiCkMiCoJiBgJjHoBiBeG_xHqqkZx_C:\ _xZkqqHx_iCmIiCmHiBgKiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (wcpPath == NULL || wcpPath[0] == L'\0' || wcslen(wcpPath) < 4)
		FFThrowMiscUnknown();

	WString strPath = WString(wcpPath) + L"\\*";
	WIN32_FIND_DATA findData;
	HANDLE hDir = FindFirstFile(WStrToTStr(strPath), &findData);
	if (hDir != INVALID_HANDLE_VALUE)
	{
		do
		{
			if (_tcscmp(findData.cFileName, _T(".")) == 0) continue;
			if (_tcscmp(findData.cFileName, _T("..")) == 0) continue;
			WString wstrMsg = WString(wcpPath) + L"\\" + (const wchar_t*)TStrToWStr(findData.cFileName);
			if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNmEiLeBiMmEiCnBiPgPiClFiBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
				if (!FFRecursiveRemoveDirectory(wstrMsg))
					return FALSE;
			} else
			//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				if (mywremove(wstrMsg) != 0)
//					FFThrowMiscUnknown();
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				if (!FFDeleteFile(wstrMsg)) return FALSE;
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			}
		} while (FindNextFile(hDir, &findData));
		FindClose(hDir);
	}
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (_trmdir(WStrToTStr(wcpPath)) != 0)
//		FFThrowMiscUnknown();
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return RemoveDirectory(WStrToTStr(wcpPath));
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFRecursiveRemoveDirectory.
//----- 06.01.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCreateDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpSecurityAttributes	:_xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiPoOjFpBiCpAjAnNjCoIiBeCiOgHiCoNiCmIiCkC_xHqqkZx_
 *									 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCreateDirectory (const wchar_t* wcpDirPath,
						LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	return CreateDirectory(WStrToTStr(wcpDirPath),
							lpSecurityAttributes);
} // FFCreateDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanAllAccessDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBfDiCmEiCmMiDeBiDeOiDfKiDfIiJmCjEfMiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCmEiCmN_xHqqkZx_
 *						 _xZkqqHx_iCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDeBiDeOiDfKiDfIiCkKiJmCjEfMiCmIiPoKiNiHiCmMiCnN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmJiBeBiOmAiNnLiCmJiDgGiDeCiDiMiDeOiDgHiDiKiCmGiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClFiCmEiBeBiNoMjAkMiCmFiCkLiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeBiDgHiDiKiDhCiDiFiBfLiDgHiCpAjClCiCnHiCmEiCoAiCkCiCkCiCkKiBeBiPeDjFjMiDgDiBfLiDiLiCmFiOgHiCkEiCmMiCmFiKgNiOmAiCmIjFpLjGeAiCmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanAllAccessDirectory (const wchar_t* wcpDirPath)
{
	// _xZkqqHx_iOiOiClFiCmJiNoMiCoJiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
	WString wstrCheckPath = WString(wcpDirPath) + L"\\.~~check~~access~~";
	switch (FFIsThereFile(wstrCheckPath))
	{
	case FD_FILE_32:		// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!FFDeleteFile(wstrCheckPath))
			return FALSE;
		break;
	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!FFRecursiveRemoveDirectory(wstrCheckPath))
			return FALSE;
		break;
	}
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiNoMjAkMiCmFiCkLiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	FCFile32 file;
	if (!file.Open(wstrCheckPath, GENERIC_READ|GENERIC_WRITE, 0, CREATE_NEW))
		return FALSE;
	file.Close();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!FFDeleteFile(wstrCheckPath))
		return FALSE;

	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKiNoMjAkMiCmFiCkLiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (!FFCreateDirectory(wstrCheckPath, NULL))
		return FALSE;
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!FFRemoveDirectory(wstrCheckPath))
		return FALSE;
	return TRUE;
} // FFCanAllAccessDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadTextFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrBuff	:_xZkqqHx_jDmHiCnNiPgPiClHiDgGiBfLiDfOiCpAiOpLjEfLiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFLoadTextFile (WString& wstrBuff, const wchar_t* wcpFile)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_Open_xZkqqHx_iBeC_xHqqkZx_
	FCFile32 file(wcpFile, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	wstrBuff.resize(file.GetLength64() / sizeof(wchar_t));
	int iCount = file.Read64(wstrBuff.begin(), wstrBuff.size() * sizeof(wchar_t));
	file.Close();
	wstrBuff.resize(iCount / sizeof(wchar_t));
	// UNICODE_xZkqqHx_iOkPjFmKjFlGiOjKiCpAiNoNiPjMiBeC_xHqqkZx_
	ASSERT(wstrBuff.GetAt(0) == 0xfeff);
	wstrBuff.ChopFirst();
	return wstrBuff.size();
} // FFLoadTextFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSaveTextFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCmJiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpBuff		:_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnLjBlGiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiPiJiCmMiOkPjFmKiDfCiBfLiDgI_xHqqkZx_ 0xfeff _xZkqqHx_iCpAjFhEiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFSaveTextFile (const wchar_t* wcpBuff, const wchar_t* wcpFile)
{
	// UNICODE_xZkqqHx_iOkPjFmKjFlGiOjKiBeC_xHqqkZx_
	const wchar_t wcHead = 0xfeff;
	FCFile32 file;
	if (file.Open(wcpFile, GENERIC_READ|GENERIC_WRITE, 0, CREATE_NEW))
	{
		// UNICODE_xZkqqHx_iOkPjFmKjFlGiOjKiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
		file.Write64(&wcHead, sizeof(wcHead));
		file.Write64(wcpBuff, sizeof(wchar_t) * wcslen(wcpBuff));
		file.Close();
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FFSaveTextFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadTextFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strBuff	:_xZkqqHx_jDmHiCnNiPgPiClHiDgGiBfLiDfOiCpAiOpLjEfLiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFLoadTextFile (astring& strBuff, const wchar_t* wcpFile)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_Open_xZkqqHx_iBeC_xHqqkZx_
	FCFile32 file(wcpFile, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	strBuff.resize(file.GetLength64());
	int iCount = file.Read64(strBuff.begin(), strBuff.size());
	file.Close();
	strBuff.resize(iCount);
	return strBuff.size();
} // FFLoadTextFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSaveTextFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCmJiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpBuff		:_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFile		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnLjBlGiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFSaveTextFile (const char* cpBuff, const wchar_t* wcpFile)
{
	FCFile32 file;
	if (file.Open(wcpFile, GENERIC_READ|GENERIC_WRITE, 0, CREATE_NEW))
	{
		file.Write64(cpBuff, strlen(cpBuff));
		file.Close();
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FFSaveTextFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	file1_xZkqqHx_iCmMiMlLiNnNiImKjChFiCkJiCoHiBeB_xHqqkZx_file0_xZkqqHx_iCmMiMlLiNnNiImKjChFiCnGiBeB_xHqqkZx_fliSize_xZkqqHx_jFkKiCmMiDgGiBfLiDfOiCpA_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file0	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			file1	:_xZkqqHx_iDfCiDhDiBfLiMlDiCmMiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSize	:_xZkqqHx_iDfCiDhDiBfLiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiClDiCoKiClNiDgGiBfLiDfOiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FFCopy (FCFileBase& file0, FCFileBase& file1, flint fliSize)
{
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	flint fliReadSize;
//	BYTE buff[1000];
//	flint fliRemain = fliSize;
//	for (;;)
//	{
//		fliReadSize = (sizeof(buff) < fliRemain) ? sizeof(buff) : fliRemain;
//		fliReadSize = file1.Read64(buff, fliReadSize);
//		file0.Write64(buff, fliReadSize);
//		fliRemain -= fliReadSize;
//		if (sizeof(buff) != fliReadSize) break;
//	}
//	return (fliSize - fliRemain);
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	flint fliReadSize;
	BYTEVector vBuff(1000);
	flint fliRemain = fliSize;
	for (;;)
	{
		fliReadSize = (vBuff.size() < fliRemain) ? vBuff.size() : fliRemain;
		fliReadSize = file1.Read64(&vBuff.front(), fliReadSize);
		file0.Write64(&vBuff.front(), fliReadSize);
		fliRemain -= fliReadSize;
		if (vBuff.size() != fliReadSize) break;
	}
	return (fliSize - fliRemain);
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFTableToTopDirPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDhAiDfI_xHqqkZx_(.ddtb/.ddix)_xZkqqHx_iCkJiCoHiBeBiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfI_xHqqkZx_(.mdpj)
 *			_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTablePath	:_xZkqqHx_iDgFiBfLiDhFiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeCiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCkKiMkJiCmCiCkJiCoHiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiLpDjFlGiOjKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmNiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCkAiCoJiCoAiCmMiCmFiCkAiCoKiCmOiCmHiCoKiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFTableToTopDirPath (const wchar_t* wcpTablePath)
{
	WString wstrPath = wcpTablePath;
	wstrPath.ChopLast(L'\\');
	for (;;)
	{
		if (wstrPath.IsEmpty()) break;
		if (wstrPath == L"\\") break;
		if (wstrPath.GetLength() == 2 && wstrPath.GetAt(1) == L':') break;

		// _xZkqqHx_iDhEiDeAiDeDiDiLjAoCjBmOiDhAiDfIjGlMiCpAiDhAiDfIjFjEjFkKiCmGiDhEiDeAiDeDiDiLjGlMjFjEjFkKiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
		WString wstrDirPath;
		WString wstrExtension;
		FFSplitFileName(&wstrDirPath, NULL, &wstrExtension, wstrPath);
		if (wstrExtension == FD_FILE_EXT_TOP_GROUP)
			return wstrPath;
		wstrPath = wstrDirPath;
		wstrPath.ChopLast(L'\\');
	}
	return WString();
} // FFTableToTopDirPath.

//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAbnormalizePath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfIiCpAiDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDgNiBfLiDhNiDiLiMgAiOkOiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmMiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmNiBeBiPkLjHiIiBeBiDhEiDeAiDeDiDiLiCpA_xHqqkZx_IP_xZkqqHx_iMgPjHfCiCmMiDfEiBfLiDgPiCmFiKmHjHjNiClHiCoJ_xHqqkZx_
// *			_xZkqqHx_iCoGiCkEiCmJiCmIiCmBiClNiPoKiNiHiCmJjEpFiCkGiBeBiDhEiDeAiDeDiDiLiCmJjBmOiClFiCmEjClMjAnKjBiAiNoMiCpAiClHiCoJiClBiCmGiCkK_xHqqkZx_
// *			_xZkqqHx_iCmIiCkCiCoGiCkEiCmJiBeBjFfMiLeMiMgAiOkOiCpAjFmPiNfIiClFiCmEiCkIiCkNiCoAiCmMiCmFiCkAiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jBfDiCmEiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCmNiDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmFiIlFiCoNiCoKiCoJiClNiCnPiBeB_xHqqkZx_
// *			_xZkqqHx_jFfHiPiAjDeJiCmIiDhEiDeAiDeDiDiLjBiAiNoM_xHqqkZx_API_xZkqqHx_iCkKiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmNiBeBjCmKiPoNiCmMiDgIiDiJiDeDiDhFiDhAiDfIiCkKiBhF_xHqqkZx_\drv\_xZkqqHx_iBhGiBeBiDgMiDgCiDgHiDiPiBfLiDeO_xHqqkZx_
// *			_xZkqqHx_iDgIiDiJiDeDiDhFiCkKiBhF_xHqqkZx_\net\_xZkqqHx_iBhGiCmFiKeKiOgOiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jHoBiBeGiBhF_xHqqkZx_C:\TMP\ABC.TXT_xZkqqHx_iBhGiBkIiBhF_xHqqkZx_\drv\C\TMP\ABC.TXT_xZkqqHx_iBhG_xHqqkZx_
// *			_xZkqqHx_jHoBiBeGiBhF_xHqqkZx_\\SVRX\TMP\ABC.TXT_xZkqqHx_iBhGiBkIiBhF_xHqqkZx_\net\SVRX\TMP\ABC.TXT_xZkqqHx_iBhG_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FFAbnormalizePath (const wchar_t* wcpPath)
//{
//	if (wcpPath == NULL || wcpPath[0] == L'\0') return L"";
//	WString wstrPath = wcpPath;
//	if (wcsncmp(wcpPath, L"\\\\", 2) == 0)
//	//----- _xZkqqHx_iNmFiPiJiCkK_xHqqkZx_"\\"_xZkqqHx_iCmFiOgOiCnMiCoJiBgJiDgMiDgCiDgHiDiPiBfLiDeOiDgIiDiJiDeDiDhFiBgKiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiPiJiCmMiBhF_xHqqkZx_\\_xZkqqHx_iBhGiCpAiNoNiPjMiBeC_xHqqkZx_
//		wstrPath.erase(0, 2);
//		// _xZkqqHx_jDkKiCmJiBhF_xHqqkZx_\net\_xZkqqHx_iBhGiCpAjBhNjDpMiBeC_xHqqkZx_
//		wstrPath.insert(0, L"\\net\\");
//	} else
//	if (wcpPath[1] == L':')
//	//----- _xZkqqHx_iCfBjEnEjGnKiCkK_xHqqkZx_":"_xZkqqHx_iCmMiBgJiDiNiBfLiDeKiDiLiDgIiDiJiDeDiDhFiBgKiPoKiNiH_xHqqkZx_ -----
//	{
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		// _xZkqqHx_iDgIiDiJiDeDiDhFiCmMiLoGjAnIiCoIiBhF_xHqqkZx_:_xZkqqHx_iBhGiCpAiBhF_xHqqkZx_\_xZkqqHx_iBhGiCmJjFmPiNfIiBeC_xHqqkZx_
////		wstrPath.at(1) = L'\\';
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgIiDiJiDeDiDhFiCmMiLoGjAnIiCoIiBhF_xHqqkZx_:_xZkqqHx_iBhGiCpAiNoNiPjMiBeC_xHqqkZx_
//		wstrPath.erase(1, 1);
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_jDkKiCmJiBhF_xHqqkZx_\drv\_xZkqqHx_iBhGiCpAjBhNjDpMiBeC_xHqqkZx_
//		wstrPath.insert(0, L"\\drv\\");
//	} else
//	{
//		FFThrowMiscUnknown();
//	}
//	return wstrPath;
//} // FFAbnormalizePath.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFNormalizePath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfIiCpAiDgNiBfLiDhNiDiLiMgAiOkOiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgNiBfLiDhNiDiLiMgAiOkOiCmMiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_AbnormalizePath_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FFNormalizePath (const wchar_t* wcpPath)
//{
//	if (wcpPath == NULL || wcpPath[0] == L'\0') return L"";
//	WString wstrPath = wcpPath;
//	if (wcsncmp(wcpPath, L"\\net\\", 5) == 0)
//	//----- _xZkqqHx_iDgMiDgCiDgHiDiPiBfLiDeOiDgIiDiJiDeDiDhFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jDkKiCmMiBhF_xHqqkZx_\net\_xZkqqHx_iBhGiCpAiNoNiPjMiBeC_xHqqkZx_
//		wstrPath.erase(0, 5);
//		// _xZkqqHx_jDkKiCmJiBhF_xHqqkZx_\\_xZkqqHx_iBhGiCpAjBhNjDpMiBeC_xHqqkZx_
//		wstrPath.insert(0, L"\\\\");
//	} else
//	//----- _xZkqqHx_iDiNiBfLiDeKiDiLiDgIiDiJiDeDiDhFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jDkKiCmMiBhF_xHqqkZx_\drv\_xZkqqHx_iBhGiCpAiNoNiPjMiBeC_xHqqkZx_
//		wstrPath.erase(0, 5);
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		// _xZkqqHx_iDgIiDiJiDeDiDhFiCmMiLoGjAnIiCoIiBhF_xHqqkZx_:_xZkqqHx_iBhGiCpAjAnNjCoIiBeC_xHqqkZx_
////		wstrPath.at(1) = L':';
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgIiDiJiDeDiDhFiCmMiLoGjAnIiCoIiBhF_xHqqkZx_:_xZkqqHx_iBhGiCpAjBhNjDpMiBeC_xHqqkZx_
//		wstrPath.insert(1, L":");
////----- 05.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//	return wstrPath;
//} // FFNormalizePath.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCheckAbnormalPath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiDhAiDfIiCkKiDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDhFiDgNiBfLiDhNiDiLiMgAiOkOiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_AbnormalizePath_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFCheckAbnormalPath (const wchar_t* wcpPath)
//{
//	return (wcsncmp(wcpPath, L"\\drv\\", 5) == 0) || (wcsncmp(wcpPath, L"\\net\\", 5) == 0);
//} // FFCheckAbnormalPath.
//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	<<
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiCmJiDgPiDeDiDgHjEhKjHpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iLeMjIfOjAoGiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			data	:_xZkqqHx_iLeMjIfOiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DWORD_xZkqqHx_iCmFjEhKjHpBiDfEiDeDiDfJiCpAiLeMjIfOiClFiClNiMoDiBeBjEhKjHpBiCmMiDgGiBfLiDfOiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEiCmMjDmBiOoKiJlLiCmMiClNiCnPiBeB_xHqqkZx_const BYTEVector& _xZkqqHx_iMfOiCmG_xHqqkZx_
 *			BYTEVector& _xZkqqHx_iMfO_xHqqkZx_ _xZkqqHx_iCmMjHlMjFpLiCkKjFeLjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_jHlMjFpLiCpAjHhAiInDiClFiCmIiCkCiCmGiBeB_xHqqkZx_operator << (BYTEVector& vStream, const T data)
 *			_xZkqqHx_iCkKjDeLjHhAiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTEVector& operator << (BYTEVector& vStream, BYTEVector& data)
{
	FFWriteData(&data[0], data.size(), vStream);
	return vStream;
} // operator << (BYTEVector& vStream, BYTEVector& data);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	<<
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiCmJiDgPiDeDiDgHjEhKjHpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iLeMjIfOjAoGiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			data	:_xZkqqHx_iLeMjIfOiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DWORD_xZkqqHx_iCmFjEhKjHpBiDfEiDeDiDfJiCpAiLeMjIfOiClFiClNiMoDiBeBjEhKjHpBiCmMiDgGiBfLiDfOiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEiCmMjDmBiOoKiJlLiCmMiClNiCnPiBeB_xHqqkZx_const BYTEVector& _xZkqqHx_iMfOiCmG_xHqqkZx_
 *			BYTEVector& _xZkqqHx_iMfO_xHqqkZx_ _xZkqqHx_iCmMjHlMjFpLiCkKjFeLjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_jHlMjFpLiCpAjHhAiInDiClFiCmIiCkCiCmGiBeB_xHqqkZx_operator << (BYTEVector& vStream, const T data)
 *			_xZkqqHx_iCkKjDeLjHhAiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTEVector& operator << (BYTEVector& vStream, const BYTEVector& data)
{
	FFWriteData(&data[0], data.size(), vStream);
	return vStream;
} // operator << (BYTEVector& vStream, const BYTEVector& data);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWriteData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiCmJiDgPiDeDiDgHjEhKjHpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_iLeMjIfOiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCount	:_xZkqqHx_iLeMjIfOiClHiCoJiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vStream	:_xZkqqHx_iLeMjIfOjAoGiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DWORD_xZkqqHx_iCmFjEhKjHpBiDfEiDeDiDfJiCpAiLeMjIfOiClFiClNiMoDiBeBjEhKjHpBiCmMiDgGiBfLiDfOiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFWriteData (const void* pData, DWORD dwCount, BYTEVector& vStream)
{
	vStream << DWORD(dwCount);
	FFWriteStream(vStream, pData, dwCount);
} // void FFWriteData (const void* pData, DWORD dwCount, BYTEVector& vStream);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReadData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiCkJiCoHiBeBiDgPiDeDiDgHjEhKjHpBiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	data	:_xZkqqHx_jDmHiCnNiPgPiClFiClNiDgGiBfLiDfOiCpAiLeMjIfOiClHiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pStream	:_xZkqqHx_jDmHiCnNiPgPiClHiMlDiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DWORD_xZkqqHx_iMfOiCmMjEhKjHpBiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClFiClNiMoDiBeBiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReadData (BYTEVector& data, const BYTE*& pStream)
{
	DWORD dwDataSize;
	FFReadStream(pStream, &dwDataSize, sizeof(dwDataSize));
	data.resize(dwDataSize);
	FFReadStream(pStream, &data[0], data.size());
} // void FFReadData (const BYTE*& pStream, BYTEVector& data);

