#ifndef __UtilLine_h
#define __UtilLine_h

#include <float.h>			// For DBL_MAX.
#include "DBLShortLine.h"	// For DBLShortLine.
#include "UtilMisc.h"			// For M_PI.

extern BOOL FFGetIntersectLine (DBLShortLine& mmslIntersect, const DBLShortLine& mmsl, const DBLRect& mmrt);

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCPolyHashRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiBeBiDhNiDgHiDiKiDgCiDeOiDfIiPpDiCmMiDgOiDgCiDfGiDiFiCmJjAfFiCoIjFkKiCkPiCmE_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmGiDhMiDiKiDiJiDeDiDjDiCmMiMpAiNlHiCpAiNiCjBkMiCmJiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIiCmNiBeBiDePiDiKiDgCiDgIjClHiClCiCmGiCmJiPgDiJkBiCmJjFkKiKiEiClDiCoKiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiIoKiCmCiCmMiDhEiDiMiBfLiDiAiCpAiDiGiDgKiDgCiDgHiCmGiMmEiCnEiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiJlKjAhNiCmJiCkIiCkCiCmEiBeBjApMjFkKiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCmNiBeB_xHqqkZx_
 *			(x1,y1)(x2,y1)(x2,y2)(x2,y3)(x3,y3)(x3,y4)_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *          x0    x1    x2    x3    x4    x5
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBfPiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiBfPiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiBfP_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiBfPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y4_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiBfPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y5_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *
 *			_xZkqqHx_iDePiDiKiDgCiDgIjClHiCmN_xHqqkZx_ 10^n_xZkqqHx_iBgJ_xHqqkZx_n_xZkqqHx_iCmNjAkOjAjEiBgKiCmFiCkAiCoIiBeB_xHqqkZx_FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iCfAiDeJiDhFiDfHiDeGiDeOiDgHiClCiCmGiCmJiCfAiCmCiCmMiDePiDiKiDgCiDgIjClHiCpAiOjNiCmCiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_10^3 _xZkqqHx_iCmMiDePiDiKiDgCiDgIjClHiCpAiOjNiCmC_xHqqkZx_FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCmNiBeB_xHqqkZx_
 *			10^3 _xZkqqHx_iCmMiDePiDiKiDgCiDgIjClHiCmFiLoGjAnIiCoHiCoKiClNiDiGiDgKiDgCiDgHiCpAiDgOiDgCiDfGiDiFiCmGiClFiCmEiLeMjIfOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iDiGiDgKiDgCiDgHiCmNiBeBiJlKjAhNiCmMiCoGiCkEiCmJiDePiDiKiDgCiDgIjClHiCmFiKeLjBhHiNfMjBkCiCpAiOjNiCmCiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeBiDgHiDgCiDhGiCmM_xHqqkZx_FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkK_xHqqkZx_10mm_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiKiDgCiDgIjClHiDgOiDgCiDfGiDiFiCpAiKmHjHjNiClFiCmEiCkIiCoIiBeB_xHqqkZx_(10,30)_xZkqqHx_iDiGiDgKiDgCiDgHiCmJiCmNiBeB_xHqqkZx_1mm_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiKiDgCiDgIjClHiCmM_xHqqkZx_FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkKiJlKjBhHiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iCnEiCoHiJlKiCkKiCoIiBeBiNfIiCmJ_xHqqkZx_(11,31)_xZkqqHx_iDiGiDgKiDgCiDgHiCmJiCmNiBeB_xHqqkZx_0.1mm_xZkqqHx_iDePiDiKiDgCiDgIjClHiCmM_xHqqkZx_
 *			_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiCnEiCoHiJlKiCkKiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBoFiCkLiCmIiDhMiDiKiDiJiDeDiDjDjAhNiMgAiCkKiBeB_xHqqkZx_RECT(11,31,12,32)_xZkqqHx_jFjEjFkKiClOiCkPiNnHiCkJiCkNiNfMjBkCiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiCmCiPoKiNiHiCmIiCmHiCmJiClBiCmMiCoGiCkEiCmIiNfMjBkCiCpAiCmGiCoJiBeC_xHqqkZx_
 *
 *			FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCmMiKeLjBhHiNfMjBkCiCmFiCmNiBeBiJlKiImKiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiPoDiImKiDeJiDhFiDfHiDeGiDeOiDgHiCmMiCfAiDiGiDgKiDgCiDgHjFkKiCmMjHmMiIoGiCmMiCnNiKmHjHjNiClHiCoJiCmMiCmJjBmOiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmNjBfDjHmMiIoGiCpAiKmHjHjNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiJlKjAhNiCmMiPoKiNiHiBeB_xHqqkZx_0.1mm_xZkqqHx_jClHiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmN_xHqqkZx_RECT(11,31,12,32)_xZkqqHx_iCmMjEmNiImNiClOiCkP_xHqqkZx_
 *			_xZkqqHx_iCpAiKmHjHjNiClFiBeB_xHqqkZx_1mm_xZkqqHx_jClHiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkK_xHqqkZx_RECT(10,30,20,40)_xZkqqHx_iCmMjEmNiImNiClOiCkPiKmHjHjNiClHiCoJiCkKiBeB_xHqqkZx_
 *			10mm_xZkqqHx_jClHiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmNjBfDjHmMiIoGiCpAiKmHjHjNiClHiCoJiCmGiCkCiCkEiClBiCmGiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *           0                                         10                                        20                                        30
 *         20_xZkqqHx_iElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElE_xHqqkZx_
 *           _xZkqqHx_iEkLiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                L=10                    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            11            12            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *         30_xZkqqHx_iElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElE_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_    L=1     _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkLiBkJiEjPiEjPiEjPiEjPiBkIiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 11.2       _xZkqqHx_iEkL_xHqqkZx_    ( (     _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_     ) )    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                    31_xZkqqHx_iEjPiElAiEkKiEkKiEkKiEkKiEkKiEkKiElEiElBiElBiElBiElBiElBiElBiElEiEkKiEkK_xHqqkZx_( ( _xZkqqHx_iEkKiEkKiElC_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_     ) )    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_    ( (     _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_     ) )    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_    ( (     _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_     ) )    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                    32_xZkqqHx_iEjPiElAiEkKiEkKiEkKiEkKiEkKiEkKiElEiElDiElIiElDiElDiElDiElDiElEiEkKiEkK_xHqqkZx_( ( _xZkqqHx_iEkKiEkKiElC_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkIiEkJiEkJiBkJ_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_     ) )    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_    L=0.1   _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgA_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgAiBgA_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *         40_xZkqqHx_iElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElE_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_                                        _xZkqqHx_iEkL_xHqqkZx_
 *         50_xZkqqHx_iElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElE_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCPolyHashRec
{
public:
	static FCPolyHashRec*	Create (const DBLRect& mmrtFrame,
									mmetol mmGridWidth,
									const longSet& stIndex,
									long lPointSize,
									const DBLPoint* mmptPoint);
	static void	GetBelongUnitFrameX (mmetol& mmUnitX, mmetol mmGridWidth, const mmetol mmX);
	static void	GetBelongUnitFrameY (mmetol& mmUnitY, mmetol mmGridWidth, const mmetol mmY);
	static void	GetBelongUnitFrame (DBLPoint& mmptUnitFrame, mmetol mmGridWidth, const DBLPoint& mmptP);
	static void	GetIntersectUnitFrame (	set<DBLPoint>& stUnitFrame,
										mmetol mmGridWidth,
										const DBLShortLine& mmsl,
										DBLPoint mmptUnitFirst,
										DBLPoint mmptUnitLast);
	static void	GetWillIntersectPolySet (	set< pair<long, long> >& stIndexIndex,
											FCPolyHashRec* pHashRec0,
											FCPolyHashRec* pHashRec1,
											long lPointSize0,
											const DBLPoint* mmptPoint0,
											long lPointSize1,
											const DBLPoint* mmptPoint1);

	~FCPolyHashRec ();
	FCPolyHashRec*	CreateSubHash (	const DBLPoint& mmptUnit,
									long lPointSize,
									const DBLPoint* mmptPoint);

public:
	mmetol							m_mmGridWidth;			// _xZkqqHx_iDePiDiKiDgCiDgIjClHiBeC_xHqqkZx_
	map<DBLPoint, longSet>			m_mpUnitToLineIndex;	// [_xZkqqHx_iDiGiDgKiDgCiDgH_xHqqkZx_->_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_]_xZkqqHx_iDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	map<DBLPoint, FCPolyHashRec*>	m_mpSubHash;			// [_xZkqqHx_iDiGiDgKiDgCiDgH_xHqqkZx_->_xZkqqHx_iJlKiImKiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_]_xZkqqHx_iDgOiDgCiDfGiDiF_xHqqkZx_
}; // class FCPolyHashRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCPolyHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDhMiDiKiDiJiDeDiDjDiCmJiKnGiClHiCoJiDgOiDgCiDfGiDiFiCpAiCnMiCmGiCnPiCmEiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCmMiKeLjBhHiNfMjBkCiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiDgGiBfLiDfOiCkJiCoH_xHqqkZx_FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iKeLjBhHiNfMjBkCiCpAiNoMjAkMiClFiBeBiDgOiDgCiDfGiDiFiCpAiOgHiCmBiClNiDhMiDiKiDiJiDeDiDjDiCmMiMpAiNlHiMhGiOfKiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCPolyHash
{
public:
	FCPolyHash ();
	FCPolyHash (long lPointSize, const DBLPoint* mmptPoint,
				const DBLRect& mmrtFrameMax = DBLRect(-DBL_MAX, -DBL_MAX, DBL_MAX, DBL_MAX));
	virtual ~FCPolyHash ();
	virtual void	Initialize (long lPointSize, const DBLPoint* mmptPoint,
								const DBLRect& mmrtFrameMax = DBLRect(-DBL_MAX, -DBL_MAX, DBL_MAX, DBL_MAX));

	static BOOL		GetIntersectPoint (DBLPointVector& vIntersectPoint, FCPolyHash& polyHash0, FCPolyHash& polyHash1);
	static void		GetWillIntersectPolySet (set< pair<long, long> >& stIndexIndex, FCPolyHash& polyHash0, FCPolyHash& polyHash1);

protected:
	virtual void	CreateSuperHashRec ();

protected:
	DBLPointVector	m_vPoint;
	DBLRect			m_mmrtFrame;
	FCPolyHashRec*	m_pTopHash;
}; // class FCPolyHash.


extern double FFGetLineLength (doubleVector& vLineLength, long lPointSize, const DBLPoint* mmptPoint);
extern void FFGetLineAngle (doubleVector& vLineAngle, long lPointSize, const DBLPoint* mmptPoint);
extern void FFGetMilestonePoint (	DBLPointVector& vMilestone,
									long lPointSize,
									const DBLPoint* mmptPoint,
									const double* pLineLength,
									long lDivSize);
extern void FFSlimLine (DBLPointVector& vmmptPoint,
						mmetol mmSlimDistance1,
						mmetol mmSlimDistance2,
						double dRoundA);
extern void FFOmitClosePoint (DBLPointVector& vmmptPoint, BYTEVector& vIsJoint, mmetol mmSlimDistance2);
extern void FFOmitAngle0Point (	DBLPointVector& vmmptPoint,
								BYTEVector& vIsJoint,
								doubleVector& vLineAngle,
								double dAnglePlay = 0.0001 * M_PI);

#endif//__UtilLine_h
