#include "stdafx.h"

//----------<NOT EXPORT TO VIEWER>-----------

// 03.07.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//#include "DynamicDraw.h"	// For IDS_OBJECT_XXX.
#include "resource.h"	// For IDS_OBJECT_XXX.
#include "ObjDynabase.h"	// For FCObjDynabase.
#include "FoundDoc.h"	// For g_pDoc.
#include "UtilErr.h"	// For FFThrowMiscUnknown().
#include "UtilStr.h"	// For GetResString.

//----------</NOT EXPORT TO VIEWER>-----------

#include "UtilObj.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmJiKePjAnKiClHiCoJiNmFiPkMiCmMiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			pObjs		:_xZkqqHx_jFjEjFgJiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lObjs		:pObjs_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void GetResizeFrame (DBLRect& mmrtFrame, FCObjDynabase* const * pObjs, long lObjs)
{
	mmrtFrame = pObjs[0]->GetResizeFrame();
	for (long lCount = 1; lCount < lObjs; lCount++)
		mmrtFrame |= pObjs[lCount]->GetResizeFrame();
} // GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmJiKePjAnKiClHiCoJiNmFiPkMiCmMiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			stObjId		:_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void GetResizeFrame (DBLRect& mmrtFrame, const DWORDSet& stObjId)
{
	mmrtFrame.SetRect(0,0,0,0);
	DWORDSet::const_iterator iId;
	for (iId = stObjId.begin(); iId != stObjId.end(); iId++)
		mmrtFrame |= g_pDoc->ObjID2Object(*iId)->GetResizeFrame();
} // GetResizeFrame.

//----- 00.01.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetIntersectObjectR
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiMoDjFpLiCkJiCoHiMjPiNpFiClFiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlH_xHqqkZx_
// *			_xZkqqHx_iClFiClNiNmFiPiJiCmMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObjs	:_xZkqqHx_jFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lObjs	:_xZkqqHx_jFjEjFgJiCmMiPfHiNiHiCmMjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lgpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiMpAiNlHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long GetIntersectObjectR (FCObjDynabase* const * pObjs, long lObjs, const CPoint& lgpt)
//{
//	for (long lIdx = lObjs - 1; 0 <= lIdx; lIdx--)
//		if (pObjs[lIdx]->IsIntersect(lgpt)) return lIdx;
//	return -1;
//} // GetIntersectObjectR.
//----- 00.01.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFObjTypeToStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDfOiDeDiDhGiCkJiCoHjFjEjFgJjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjGlMjFlGiOjKjHpBiCpAjFnEiClHiBeCjBmOiJjOiClHiCoJjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmNiLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FFObjTypeToStr (FTObjectType nType)
{
	switch (nType)
	{
	case FDOJ_LINE:
		return GetResWString(IDS_OBJECT_LINE);
	case FDOJ_RECT:
		return GetResWString(IDS_OBJECT_RECT);
	case FDOJ_ROUND_RECT:
		return GetResWString(IDS_OBJECT_ROUND_RECT);
	case FDOJ_ARC:
		return GetResWString(IDS_OBJECT_ARC);
	case FDOJ_POLY:
		return GetResWString(IDS_OBJECT_POLY);
	case FDOJ_GROUP:
		return GetResWString(IDS_OBJECT_GROUP);
	case FDOJ_WIDE_POLY:
		return GetResWString(IDS_OBJECT_WIDE_POLY);
	case FDOJ_OLE:
		return GetResWString(IDS_OBJECT_OLE);
	case FDOJ_CHIP_MASTER:
		return GetResWString(IDS_OBJECT_CHIP_MASTER);
	case FDOJ_PICT_ARROW:
		return GetResWString(IDS_OBJECT_PICT_ARROW);
	case FDOJ_POINT:
		return GetResWString(IDS_OBJECT_POINT);
	case FDOJ_LABEL:
		return GetResWString(IDS_OBJECT_LABEL);
	case FDOJ_TABLE:
		return GetResWString(IDS_OBJECT_TABLE);
	case FDOJ_TEXT_RECT:
		return GetResWString(IDS_OBJECT_TEXT_RECT);
	default:
		return L"";
	}
} // FFObjTypeToStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFramePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDiMiBfLiDiAiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPosition	:_xZkqqHx_iImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_FD_RPT_V_XX | FD_RPT_H_XX _xZkqqHx_iCmMiMgAiOkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FFGetFramePoint (const DBLRect& mmrtFrame, WORD wPosition)
{
	DBLPoint mmpt;
	switch (wPosition & FD_RPT_V_MASK)
	{
	case FD_RPT_V_TOP:
		mmpt.y = mmrtFrame.top;
		break;
	case FD_RPT_V_BOTTOM:
		mmpt.y = mmrtFrame.bottom;
		break;
	case FD_RPT_V_CENTER:
		mmpt.y = (mmrtFrame.top + mmrtFrame.bottom) / 2.0;
		break;
	default:
		FFThrowMiscUnknown();
	}
	switch (wPosition & FD_RPT_H_MASK)
	{
	case FD_RPT_H_LEFT:
		mmpt.x = mmrtFrame.left;
		break;
	case FD_RPT_H_RIGHT:
		mmpt.x = mmrtFrame.right;
		break;
	case FD_RPT_H_CENTER:
		mmpt.x = (mmrtFrame.left + mmrtFrame.right) / 2.0;
		break;
	default:
		FFThrowMiscUnknown();
	}
	return mmpt;
} // FFGetFramePoint.

//----------</NOT EXPORT TO VIEWER>-----------
