#ifndef __UtilStdLib_h
#define __UtilStdLib_h

//;----- <EXPORT TO SERVER> -----;

template<class T1, class T2>
void FFInsert (T1& a, const T2& b)
{
	T2::const_iterator iId;
	for (iId = b.begin(); iId != b.end(); iId++)
		a.insert(*iId);
} // FFInsert.

template<class T1, class T2>
void FFErase (T1& a, const T2& b)
{
	T2::const_iterator iId;
	for (iId = b.begin(); iId != b.end(); iId++)
		a.erase(*iId);
} // FFErase.

template<class T1, class T2>
void FFPushBack (T1& a, const T2& b)
{
	T2::const_iterator iId;
	for (iId = b.begin(); iId != b.end(); iId++)
		a.push_back(*iId);
} // FFPushBack.

//----- 05.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIntersection
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPfHiNiH_xHqqkZx_ b_xZkqqHx_iCmG_xHqqkZx_c _xZkqqHx_iCmMjAmPiPfHiNiH_xHqqkZx_ a _xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_jAmPiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
// *			b	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoI_xHqqkZx_
// *			c	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoI_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class T>
//void FFIntersection (T& a, const T& b, const T& c)
//{
//	a.clear();
//	if (b.size() < c.size())
//	{
//		T::const_iterator i;
//		for (i = b.begin(); i != b.end(); i++)
//			if (c.find(*i) != c.end()) a.insert(*i);
//	} else
//	{
//		T::const_iterator i;
//		for (i = c.begin(); i != c.end(); i++)
//			if (b.find(*i) != b.end()) a.insert(*i);
//	}
//} // FFIntersection.
//----- 05.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIntersection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPfHiNiH_xHqqkZx_ a_xZkqqHx_iCmG_xHqqkZx_b _xZkqqHx_iCmMjAmPiPfHiNiH_xHqqkZx_ x _xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jAmPiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			a	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_x_xZkqqHx_iCpAiPjMiCkCiClNiOgDiCoIiCpAjFnEiClHiBeC_xHqqkZx_
 *			b	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_x_xZkqqHx_iCpAiPjMiCkCiClNiOgDiCoIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmJiLoPjBmMjHoBiCmFiDeBiDiLiDfDiDiKiDfJiDiAiCpAiJpAjAoAiBeC_xHqqkZx_
 *        _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfAiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfBiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfCiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 5    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 5    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 3    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 5    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iBiE_xHqqkZx_ 3    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2 _xZkqqHx_iBiE_xHqqkZx_ 1    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     2 _xZkqqHx_iBiD_xHqqkZx_ 3    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     2    1             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_          1             _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfDiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfEiBeEjDkPiClGjCgMiBeCjCgMiCpAiLeMjIfOiBeCiEkL_xHqqkZx_  _xZkqqHx_iCfFiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iCiBiBeBiCiCiCpAiNoNiPjMiBeC_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iBiD_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_5 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iBiD_xHqqkZx_ 5    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iBiB_xHqqkZx_ 5    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     4    3             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     2    1             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2    3             _xZkqqHx_iEkL_xHqqkZx_     4    3             _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_          1             _xZkqqHx_iEkL_xHqqkZx_     2    1             _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfGiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfHiBeEjDkPiClGjCgMiBeCjCgMiCpAiLeMjIfOiClFiEkL_xHqqkZx_  _xZkqqHx_iCfIiBeEiCiCiCkKiLpDiCmJiCmIiCoIiPeJjHlJiBeCiEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iCiBiBeBiCiCiCpAiNoNiPjMiBeC_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_8 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iBiE_xHqqkZx_ 7    _xZkqqHx_iEkA_xHqqkZx_5 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_5 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iBiB_xHqqkZx_ 8    _xZkqqHx_iEkA_xHqqkZx_5 _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6    3             _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6    7             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4    1             _xZkqqHx_iEkL_xHqqkZx_     6    7             _xZkqqHx_iEkL_xHqqkZx_     4    3             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2                  _xZkqqHx_iEkL_xHqqkZx_     4    3             _xZkqqHx_iEkL_xHqqkZx_     2    1             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_     2    1             _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void FFIntersection (set<T>& x, set<T>& a, set<T>& b)
{
	x.clear();
	set<T>::iterator iA = a.begin();
	set<T>::iterator iB = b.begin();
	while (iA != a.end() && iB != b.end())
	{
		if (*iA < *iB)
		{
			iA++;
		} else
		if (*iB < *iA)
		{
			iB++;
		} else
		{
			x.insert(*iA);
			iA = a.erase(iA);
			iB = b.erase(iB);
		}
	}
} // FFIntersection.
//----- 05.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIntersection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPfHiNiH_xHqqkZx_ a_xZkqqHx_iCmG_xHqqkZx_b _xZkqqHx_iCmMjAmPiPfHiNiH_xHqqkZx_ x _xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeCjAmPiCmN_xHqqkZx_ first,second_xZkqqHx_iCmGiCoAiIoKjChGiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jAmPiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			a	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_x_xZkqqHx_iCpAiPjMiCkCiClNiOgDiCoIiCpAjFnEiClHiBeC_xHqqkZx_
 *			b	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_x_xZkqqHx_iCpAiPjMiCkCiClNiOgDiCoIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmJiLoPjBmMjHoBiCmFiDeBiDiLiDfDiDiKiDfJiDiAiCpAiJpAjAoAiBeC_xHqqkZx_
 *        _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfAiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfBiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfCiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iEkA_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iEkA_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5J_xZkqqHx_iEkA_xHqqkZx_5K    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5J_xZkqqHx_iEkA_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5J_xZkqqHx_iEkA_xHqqkZx_5K    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4J_xZkqqHx_iEkA_xHqqkZx_3J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     4J_xZkqqHx_iEkA_xHqqkZx_5K    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     4J_xZkqqHx_iBiE_xHqqkZx_3J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2J_xZkqqHx_iBiE_xHqqkZx_1J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     2J_xZkqqHx_iBiD_xHqqkZx_3J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     2J  1J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_         1J             _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfDiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfEiBeE_xHqqkZx_first_xZkqqHx_iCmNjDkPiClGiClOiCkK_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfFiBeEiPkMiClDiCkCiCiBiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     second_xZkqqHx_iCmNiInJiCmIiCoJiBeC_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5J_xZkqqHx_iEkA_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iEkA_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     6J_xZkqqHx_iBiD_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4J_xZkqqHx_iBiD_xHqqkZx_5K    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5J_xZkqqHx_iBiC_xHqqkZx_5K    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     5J  5K             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2J  3J             _xZkqqHx_iEkL_xHqqkZx_     4J  3J             _xZkqqHx_iEkL_xHqqkZx_     4J  3J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_         1J             _xZkqqHx_iEkL_xHqqkZx_     2J  1J             _xZkqqHx_iEkL_xHqqkZx_     2J  1J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfGiBeEiPkMiClDiCkCiCiCiCpAiNoNiPjMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfHiBeEjDkPiClGjCgMiBeCjCgMiCpAiLeMjIfOiBeCiEkL_xHqqkZx_  _xZkqqHx_iCfIiBeEiCiCiCkKiLpDiCmJiCmIiCoIiPeJjHlJiBeCiEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_      _xZkqqHx_iCjI_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkJiEjPiEkJ_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iBiE_xHqqkZx_7J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     8J_xZkqqHx_iBiB_xHqqkZx_8J    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     9J_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_8J_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_  _xZkqqHx_iEkIiEjPiEkI_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6J  5K             _xZkqqHx_iEkL_xHqqkZx_     6J  7J             _xZkqqHx_iEkL_xHqqkZx_     6J  7J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5J  3J             _xZkqqHx_iEkL_xHqqkZx_     5J  5K             _xZkqqHx_iEkL_xHqqkZx_     5J  5K             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4J  1J             _xZkqqHx_iEkL_xHqqkZx_     4J  3J             _xZkqqHx_iEkL_xHqqkZx_     4J  3J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2J                 _xZkqqHx_iEkL_xHqqkZx_     2J  1J             _xZkqqHx_iEkL_xHqqkZx_     2J  1J             _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T1, class T2>
void FFIntersection (map<T1, T2>& x, map<T1, T2>& a, map<T1, T2>& b)
{
	x.clear();
	map<T1, T2>::iterator iA = a.begin();
	map<T1, T2>::iterator iB = b.begin();
	while (iA != a.end() && iB != b.end())
	{
		if (iA->first < iB->first)
		//----- a _xZkqqHx_iCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			iA++;
		} else
		if (iB->first < iA->first)
		//----- b _xZkqqHx_iCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			iB++;
		} else
		//----- a,b _xZkqqHx_iCkKjDkPiClGiPoKiNiH_xHqqkZx_ -----
		{
			if (iA->second != iB->second)
			//----- second _xZkqqHx_iCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ ----
			{
				iA++;
				iB++;
			} else
			//----- second _xZkqqHx_iCkKjDkPiClGiPoKiNiH_xHqqkZx_ ----
			{
				x[iA->first] = iA->second;
				iA = a.erase(iA);
				iB = b.erase(iB);
			}
		}
	}
} // FFIntersection.


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPfHiNiH_xHqqkZx_ a_xZkqqHx_iCmG_xHqqkZx_b _xZkqqHx_iCmJiIoKiCmCiCmFiCoAiLkEjCmKiCmMjHhGjBgGiCkKiCkAiCoKiCmOjAfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoI_xHqqkZx_
 *			b	:_xZkqqHx_iPfHiNiHiCpAiOhHjCoI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	a_xZkqqHx_iCmG_xHqqkZx_b _xZkqqHx_iCmJiIoKiCmCiCmFiCoAiLkEjCmKiCmMjHhGjBgGiCkKiCkAiCoKiCmO_xHqqkZx_TRU_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmJiLoPjBmMjHoBiCmFiDeBiDiLiDfDiDiKiDfJiDiAiCpAiJpAjAoAiBeC_xHqqkZx_
 *        _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfAiBeEiPkMiClDiCkCiCiC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfBiBeEiPkMiClDiCkCiCiB_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfCiBeEiPkMiClDiCkCiCiC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCpAiNoNiPjM_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCpAiNoNiPjM_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCpAiNoNiPjM_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8     _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7     _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 8     _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 5     _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 7     _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 5     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 3     _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 5     _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 3     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     2 _xZkqqHx_iEkA_xHqqkZx_ 1     _xZkqqHx_iEkL_xHqqkZx_     2 _xZkqqHx_iEkA_xHqqkZx_ 3     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiBiEiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiBiEiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiBiDiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_                _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfDiBeEiPkMiClDiCkCiCiB_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCfEiBeEjDkPiClGjCgMiBeC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCpAiNoNiPjM_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_jAfOiCpAjFnEiClH_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iCiBiBeBiCiCiCpA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiEkAiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_     10_xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 8     _xZkqqHx_iEkL_xHqqkZx_     8 _xZkqqHx_iEkA_xHqqkZx_ 8     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 7     _xZkqqHx_iEkL_xHqqkZx_     6 _xZkqqHx_iEkA_xHqqkZx_ 7     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     4 _xZkqqHx_iEkA_xHqqkZx_ 5     _xZkqqHx_iEkL_xHqqkZx_     5 _xZkqqHx_iEkA_xHqqkZx_ 5     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiBiDiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iCiBiBiBiCiC_xHqqkZx_     _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL FFIsIntersect (const set<T>& a, const set<T>& b)
{
	set<T>::const_iterator iA = a.begin();
	set<T>::const_iterator iB = b.begin();
	while (iA != a.end() && iB != b.end())
	{
		if (*iA < *iB)
		{
			iA++;
		} else
		if (*iB < *iA)
		{
			iB++;
		} else
		{
			return TRUE;
		}
	}
	return FALSE;
} // FFIsIntersect.

//----- 05.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//template<class T>
//void FFNext (vector<T>::iterator& i, vector<T>* arry0, vector<T>* arry1 = NULL, vector<T>* arry2 = NULL, vector<T>* arry3 = NULL, vector<T>* arry4 = NULL, vector<T>* arry5 = NULL, vector<T>* arry6 = NULL)
//{
//	i++;
//	vector<T>* arry[8] = {
//		arry0,
//		arry1,
//		arry2,
//		arry3,
//		arry4,
//		arry5,
//		arry6,
//		NULL
//	};
//	long lC;
//	for (lC=0;;lC++)
//	{
//		if (arry[lC] == NULL)
//		{
//			i = NULL;
//			return;
//		}
//		if (arry[lC]->begin() <= i && i <= arry[lC]->end()) break;
//	}
//	if (i == arry[lC]->end())
//	{
//		for (lC++;;lC++)
//		{
//			if (arry[lC] == NULL)
//			{
//				i = NULL;
//				return;
//			}
//			if (!arry[lC]->empty())
//			{
//				i = arry[lC]->begin();
//				break;
//			}
//		}
//	}
//} // FFNext.
//
//template<class T>
//void FFNext (vector<T>::const_iterator& i, const vector<T>* arry0, const vector<T>* arry1 = NULL, const vector<T>* arry2 = NULL, const vector<T>* arry3 = NULL, const vector<T>* arry4 = NULL, const vector<T>* arry5 = NULL, const vector<T>* arry6 = NULL)
//{
//	i++;
//	const vector<T>* arry[8] = {
//		arry0,
//		arry1,
//		arry2,
//		arry3,
//		arry4,
//		arry5,
//		arry6,
//		NULL
//	};
//	long lC;
//	for (lC=0;;lC++)
//	{
//		if (arry[lC] == NULL)
//		{
//			i = NULL;
//			return;
//		}
//		if (arry[lC]->begin() <= i && i <= arry[lC]->end()) break;
//	}
//	if (i == arry[lC]->end())
//	{
//		for (lC++;;lC++)
//		{
//			if (arry[lC] == NULL)
//			{
//				i = NULL;
//				return;
//			}
//			if (!arry[lC]->empty())
//			{
//				i = arry[lC]->begin();
//				break;
//			}
//		}
//	}
//} // FFNext.
//----- 05.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#define __XXXX_ a
//#define __XXXX_X_ __XXXX_#a
//----- 05.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#define mdef_iterator(t, i) t::iterator i; long __m_for_c_##i
#define mdef_const_iterator(t, i) t::const_iterator i; long __m_for_c_##i
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define mdef_reverse_iterator(t, i) t::reverse_iterator i; long __m_rfor_c_##i
#define mdef_const_reverse_iterator(t, i) t::const_reverse_iterator i; long __m_rfor_c_##i
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#define m1_for(i, v0) for(__m_for_c_##i = FFBegin(i, &v0); __m_for_c_##i != -1; FFNext(i, __m_for_c_##i, &v0))
#define m2_for(i, v0, v1) for(__m_for_c_##i = FFBegin(i, &v0, &v1); __m_for_c_##i != -1; FFNext(i, __m_for_c_##i, &v0, &v1))
#define m3_for(i, v0, v1, v2) for(__m_for_c_##i = FFBegin(i, &v0, &v1, &v2); __m_for_c_##i != -1; FFNext(i, __m_for_c_##i, &v0, &v1, &v2))
#define m4_for(i, v0, v1, v2, v3) for(__m_for_c_##i = FFBegin(i, &v0, &v1, &v2, &v3); __m_for_c_##i != -1; FFNext(i, __m_for_c_##i, &v0, &v1, &v2, &v3))
#define m5_for(i, v0, v1, v2, v3, v4) for(__m_for_c_##i = FFBegin(i, &v0, &v1, &v2, &v3, &v4); __m_for_c_##i != -1; FFNext(i, __m_for_c_##i, &v0, &v1, &v2, &v3, &v4))

//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define m1_rfor(i, v0) for(__m_rfor_c_##i = FFRBegin(i, &v0); __m_rfor_c_##i != -1; FFRNext(i, __m_rfor_c_##i, &v0))
#define m2_rfor(i, v0, v1) for(__m_rfor_c_##i = FFRBegin(i, &v0, &v1); __m_rfor_c_##i != -1; FFRNext(i, __m_rfor_c_##i, &v0, &v1))
#define m3_rfor(i, v0, v1, v2) for(__m_rfor_c_##i = FFRBegin(i, &v0, &v1, &v2); __m_rfor_c_##i != -1; FFRNext(i, __m_rfor_c_##i, &v0, &v1, &v2))
#define m4_rfor(i, v0, v1, v2, v3) for(__m_rfor_c_##i = FFRBegin(i, &v0, &v1, &v2, &v3); __m_rfor_c_##i != -1; FFRNext(i, __m_rfor_c_##i, &v0, &v1, &v2, &v3))
#define m5_rfor(i, v0, v1, v2, v3, v4) for(__m_rfor_c_##i = FFRBegin(i, &v0, &v1, &v2, &v3, &v4); __m_rfor_c_##i != -1; FFRNext(i, __m_rfor_c_##i, &v0, &v1, &v2, &v3, &v4))
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

template<class T>
long FFBegin (	T::iterator& i,
				T* arry0,
				T* arry1 = NULL,
				T* arry2 = NULL,
				T* arry3 = NULL,
				T* arry4 = NULL,
				T* arry5 = NULL,
				T* arry6 = NULL)
{
	T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	long lIndex;
	for (lIndex = 0;;lIndex++)
	{
		if (arry[lIndex] == NULL)
		{
			lIndex = -1;
			break;
		}
		if (!arry[lIndex]->empty())
		{
			i = arry[lIndex]->begin();
			break;
		}
	}
	return lIndex;
} // FFBegin.

template<class T>
long FFBegin (	T::const_iterator& i,
				const T* arry0,
				const T* arry1 = NULL,
				const T* arry2 = NULL,
				const T* arry3 = NULL,
				const T* arry4 = NULL,
				const T* arry5 = NULL,
				const T* arry6 = NULL)
{
	const T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	long lIndex;
	for (lIndex = 0;;lIndex++)
	{
		if (arry[lIndex] == NULL)
		{
			lIndex = -1;
			break;
		}
		if (!arry[lIndex]->empty())
		{
			i = arry[lIndex]->begin();
			break;
		}
	}
	return lIndex;
} // FFBegin.

template<class T>
void FFNext (	T::iterator& i,
				long& lIndex,
				T* arry0,
				T* arry1 = NULL,
				T* arry2 = NULL,
				T* arry3 = NULL,
				T* arry4 = NULL,
				T* arry5 = NULL,
				T* arry6 = NULL)
{
	T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	i++;
	if (i == arry[lIndex]->end())
	{
		for (lIndex++;;lIndex++)
		{
			if (arry[lIndex] == NULL)
			{
				lIndex = -1;
				break;
			}
			if (!arry[lIndex]->empty())
			{
				i = arry[lIndex]->begin();
				break;
			}
		}
	}
} // FFNext.

template<class T>
void FFNext (	T::const_iterator& i,
				long& lIndex,
				const T* arry0,
				const T* arry1 = NULL,
				const T* arry2 = NULL,
				const T* arry3 = NULL,
				const T* arry4 = NULL,
				const T* arry5 = NULL,
				const T* arry6 = NULL)
{
	const T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	i++;
	if (i == arry[lIndex]->end())
	{
		for (lIndex++;;lIndex++)
		{
			if (arry[lIndex] == NULL)
			{
				lIndex = -1;
				break;
			}
			if (!arry[lIndex]->empty())
			{
				i = arry[lIndex]->begin();
				break;
			}
		}
	}
} // FFNext.

//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
template<class T>
long FFRBegin (	T::reverse_iterator& i,
				T* arry0,
				T* arry1 = NULL,
				T* arry2 = NULL,
				T* arry3 = NULL,
				T* arry4 = NULL,
				T* arry5 = NULL,
				T* arry6 = NULL)
{
	T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	long lIndex;
	for (lIndex = 0;;lIndex++)
	{
		if (arry[lIndex] == NULL)
		{
			lIndex = -1;
			break;
		}
		if (!arry[lIndex]->empty())
		{
			i = arry[lIndex]->rbegin();
			break;
		}
	}
	return lIndex;
} // FFRBegin.

template<class T>
long FFRBegin (	T::const_reverse_iterator& i,
				const T* arry0,
				const T* arry1 = NULL,
				const T* arry2 = NULL,
				const T* arry3 = NULL,
				const T* arry4 = NULL,
				const T* arry5 = NULL,
				const T* arry6 = NULL)
{
	const T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	long lIndex;
	for (lIndex = 0;;lIndex++)
	{
		if (arry[lIndex] == NULL)
		{
			lIndex = -1;
			break;
		}
		if (!arry[lIndex]->empty())
		{
			i = arry[lIndex]->rbegin();
			break;
		}
	}
	return lIndex;
} // FFRBegin.

template<class T>
void FFRNext (	T::reverse_iterator& i,
				long& lIndex,
				T* arry0,
				T* arry1 = NULL,
				T* arry2 = NULL,
				T* arry3 = NULL,
				T* arry4 = NULL,
				T* arry5 = NULL,
				T* arry6 = NULL)
{
	T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	i++;
	if (i == arry[lIndex]->rend())
	{
		for (lIndex++;;lIndex++)
		{
			if (arry[lIndex] == NULL)
			{
				lIndex = -1;
				break;
			}
			if (!arry[lIndex]->empty())
			{
				i = arry[lIndex]->rbegin();
				break;
			}
		}
	}
} // FFRNext.

template<class T>
void FFRNext (	T::const_reverse_iterator& i,
				long& lIndex,
				const T* arry0,
				const T* arry1 = NULL,
				const T* arry2 = NULL,
				const T* arry3 = NULL,
				const T* arry4 = NULL,
				const T* arry5 = NULL,
				const T* arry6 = NULL)
{
	const T* arry[8] = {
		arry0,
		arry1,
		arry2,
		arry3,
		arry4,
		arry5,
		arry6,
		NULL
	};
	i++;
	if (i == arry[lIndex]->rend())
	{
		for (lIndex++;;lIndex++)
		{
			if (arry[lIndex] == NULL)
			{
				lIndex = -1;
				break;
			}
			if (!arry[lIndex]->empty())
			{
				i = arry[lIndex]->rbegin();
				break;
			}
		}
	}
} // FFRNext.
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//;----- </EXPORT TO SERVER> -----;

#endif //__UtilStdLib_h

