#ifndef __UtilZlibPng_h
#define __UtilZlibPng_h

//;----- <EXPORT TO SDK> -----;

class FCUndoArchive;
enum FTDocumentPropertyId;
struct png_struct_def;
typedef struct png_struct_def png_struct;

// MDRW_xZkqqHx_iMgAiOkOiDgAiDiDiDjDiDeOiCmMjGlMjBePiBeC_xHqqkZx_
#define FD_MDRW_CHUNK_NAME ((const BYTE*)"mdRw")
// MDVF_xZkqqHx_iMgAiOkOiDgAiDiDiDjDiDeOiCmMjGlMjBePiBeC_xHqqkZx_
#define FD_MDVF_CHUNK_NAME ((const BYTE*)"mdVf")

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCPngReadStruct
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmM_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PNG_xZkqqHx_iCpAjDmHiCnNiNjOiCpBiClOiNnLiCmJiPoOjFpBiCkKiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCPngReadStruct
{
	CSize*		m_szImage32;				// PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	BYTEVector*	m_vImage32;					// PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiBeC_xHqqkZx_
	WString*	m_wstraDocumentProperty;	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiBeC_xHqqkZx_
	long		m_lDocumentPropertySize;	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiDfEiDeDiDfJiBeC_xHqqkZx_
	void*		m_png_ptr;					// _xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeC_xHqqkZx_
	void*		m_info_ptr;					// _xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeC_xHqqkZx_
}; // struct FCPngReadStruct.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCPngWriteStruct
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmM_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PNG_xZkqqHx_iCpAjDmHiCnNiNjOiCpBiClOiNnLiCmJiPoOjFpBiCkKiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCPngWriteStruct
{
	const CSize*	m_szImage32;				// PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	const BYTE*		m_pImage32;					// PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiBeC_xHqqkZx_
	const WString*	m_wstraDocumentProperty;	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiBeC_xHqqkZx_
	long			m_lDocumentPropertySize;	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiDfEiDeDiDfJiBeC_xHqqkZx_
	void*			m_png_ptr;					// _xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeC_xHqqkZx_
	void*			m_info_ptr;					// _xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeC_xHqqkZx_
}; // struct FCPngWriteStruct.

typedef void (*FuncDrawImage) (CDC* pDC, DWORD dwData, const CSize& szImage);

//----- 06.05.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
typedef void (*FuncPngRead) (png_struct* pPngPtr, BYTE* pData, size_t szLength);
typedef void (*FuncPngError) (png_struct* pPngPtr, const char* pErrorMessage);
typedef void (*FuncPngWarning) (png_struct* pPngPtr, const char* pWarningMessage);
typedef void (*FuncPngWrite) (png_struct* pPngPtr, BYTE* pData, size_t szLength);
typedef void (*FuncPngFlush) (png_struct* pPngPtr);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//;------ </EXPORT TO SDK> -----;

extern WString FFItxtToWStr (const char* cpItxt);
extern astring FFWStrToItxt (const wchar_t* wcp);

// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
extern void* FFPngGetIoPtr (png_struct* pPngPtr);

extern DWORD FFPngGetUint32 (const BYTE* pBuff);
extern void FFPngGetUintByte32 (BYTE* pBuff, DWORD dw);

extern void FFMakePngImage32 (BYTEVector& byvBitBuff, const CSize& szImage,
								FuncDrawImage func, DWORD dwData);
extern void FFPngImageToDIB32 (BYTE* bypData, const CSize& szImage);
extern void FFDIBToPngImage32 (BYTE* bypData, const CSize& szImage);

extern void FFPngRead32BitImageAndText (FCUndoArchive& ar,
										CSize* szp32Image,
										BYTEVector* vp32Image,
										WString* wstraDocProperty,
										long lDocPropertySize,
										BOOL bSkipUntilEnd);
extern void FFPngRead32BitImageAndText (void* pIo,
										FuncPngRead funcPngRead,
										FuncPngError funcPngError,
										FuncPngWarning funcPngWarning,
										CSize* szp32Image,
										BYTEVector* vp32Image,
										WString* wstraDocProperty,
										long lDocPropertySize,
										BOOL bSkipUntilEnd);
extern FCPngReadStruct* FFPngRead32Begin (	FCUndoArchive& ar,
											CSize* szp32Image,
											BYTEVector* vp32Image,
											WString* wstraDocProperty,
											long lDocPropertySize);
extern FCPngReadStruct* FFPngRead32Begin (	void* pIo,
											FuncPngRead funcPngRead,
											FuncPngError funcPngError,
											FuncPngWarning funcPngWarning,
											CSize* szp32Image,
											BYTEVector* vp32Image,
											WString* wstraDocProperty,
											long lDocPropertySize);
extern FCPngReadStruct* FFPngRead32MdrwChunk (	FCPngReadStruct* ps,
												BYTEVector& vMdrwChunkData);

extern FCPngWriteStruct* FFPngWrite32Begin (FCUndoArchive& ar,
											const CSize* szp32Image,
											const BYTE* p32Image,
											const WString* wstraDocProperty,
											long lDocPropertySize);
extern FCPngWriteStruct* FFPngWrite32Begin (void* pIo,
											FuncPngWrite funcPngWrite,
											FuncPngFlush funcPngFlush,
											FuncPngError funcPngError,
											FuncPngWarning funcPngWarning,
											const CSize* szp32Image,
											const BYTE* p32Image,
											const WString* wstraDocProperty,
											long lDocPropertySize);
extern void FFPngWrite32MdrwChunk (	FCPngWriteStruct* ps,
									const BYTE* pMdrwChunkData,
									DWORD dwMdrwChunkDataSize);
extern void FFPngWrite32End (FCPngWriteStruct* ps);

//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//extern FCPngReadStruct* FFPngReadInitialize (FCUndoArchive& ar);
//extern FCPngWriteStruct* FFPngWriteInitialize (FCUndoArchive& ar);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
extern FCPngReadStruct* FFPngReadInitialize (	void* pIo,
												FuncPngRead funcPngRead,
												FuncPngError funcPngError,
												FuncPngWarning funcPngWarning);
extern FCPngWriteStruct* FFPngWriteInitialize (	void* pIo,
												FuncPngWrite funcPngWrite,
												FuncPngFlush funcPngFlush,
												FuncPngError funcPngError,
												FuncPngWarning funcPngWarning);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

extern void FFPngTerminate (FCPngReadStruct* ps);
extern void FFPngTerminate (FCPngWriteStruct* ps);
extern BOOL FFPngReadUntilMdrwChunk (FCPngReadStruct* ps);

extern void FFPngReadChunk (FCPngReadStruct* ps, BYTEVector& vDataBuff);
extern void FFPngSkipChunk (FCPngReadStruct* ps);
extern BOOL FFPngSkipUntilSpecChunk (FCPngReadStruct* ps,
									const BYTE* bypChunkName);

extern void FFPngReadUntilEnd (FCPngReadStruct* ps);

extern void FFPngWriteUntilMdrwChunk (FCPngWriteStruct* ps);
extern void FFPngWriteChunk (FCPngWriteStruct* ps,
							const BYTE* bypChunkName,
							const BYTE* pChunkData,
							DWORD dwChunkDataSize);

extern void FFPngWriteUntilEnd (FCPngWriteStruct* ps);

extern const char* FFDocumentPropertyIdToAKey (FTDocumentPropertyId dpid);
extern const wchar_t* FFDocumentPropertyIdToIKey (FTDocumentPropertyId dpid);
extern FTDocumentPropertyId FFAKeyToDocumentPropertyId (const char* cpKey);

extern BOOL FFZlibCompress (BYTEVector& vCompressBuff, const BYTE* pSrcData, DWORD dwSrcDataSize);
extern int FFZlibCompress2 (BYTEVector& vCompressBuff, const BYTE* pSrcData, DWORD dwSrcDataSize, int iLevel);
extern BOOL FFZlibUncompress (BYTEVector& vDataBuff, const BYTE* pCompressData, DWORD dwCompressDataSize);

#endif//__UtilZlibPng_h
