#ifndef __VirtualTableManager_h
#define __VirtualTableManager_h

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// VirtualTableManager.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "HString.h"	// For HString.

class FCVirtualTableManager;
class FCVirtualWriteTable;
class FCTableIds;
struct FCTableName;

//----- _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiIoKjHjH_xHqqkZx_ -----

// _xZkqqHx_iDePiDiLiBfLiDhGiCpAiNoMjAkMiBeC_xHqqkZx_
#define CMD_CREATE_GROUP		BYTE(2)

// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
#define CMD_CREATE_TABLE		BYTE(3)

// _xZkqqHx_iDgFiBfLiDhFiDiLiCmJiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
#define CMD_APPEND_RECORD		BYTE(4)

// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAiNoNiPjMiBeC_xHqqkZx_
#define CMD_REDUCE_RECORD_COUNT	BYTE(5)

// _xZkqqHx_iDePiDiLiBfLiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
#define CMD_DELETE_GROUP		BYTE(6)

// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
#define CMD_DELETE_TABLE		BYTE(7)

// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCpAjFkBiOmKiBeC_xHqqkZx_
#define CMD_COPY_RECORD			BYTE(8)

/////////////////////////////////////////////////////////////////////////////
// FCTableRec_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

enum FTTableOperationFlag
{
	FD_TABLE_OPE_NONE = 0,
	FD_TABLE_OPE_CREATE,
	FD_TABLE_OPE_DELETE,
	FD_TABLE_OPE_DELETE_AND_CREATE,
}; // enum FTTableOperationFlag.

enum FTGroupOperationFlag
{
	FD_GROUP_OPE_NONE = 10,
	FD_GROUP_OPE_CREATE,
	FD_GROUP_OPE_DELETE,
// 06.02.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	FD_GROUP_OPE_DELETE_AND_CREATE,
}; // enum FTGroupOperationFlag.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDgFiBfLiDhFiDiLiCpAjFfMiClHiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjDoAjHgFiOkJjBmMiCmN_xHqqkZx_m_pVirtualTable_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCoNiClEiCoNiClE_xHqqkZx_ m_pVirtualTable _xZkqqHx_iCmGjFkKiCkPiClNiCmMiCmNiBeBjHoBiCkGiCmOiDgFiBfLiDhFiDiLiCpAiNoNiPjM_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiPoKiNiHiBeBiDgFiBfLiDhFiDiLiCmMjDoAjHgFiCpA_xHqqkZx_ m_pVirtualTable _xZkqqHx_iCmJiOoGiCoIiNjOiCnMiCmIiCkNiCmEiCoA_xHqqkZx_
 *			m_tableOperation _xZkqqHx_iCmJiDhEiDiJiDePiCpAjHkHiCmEiCoJiClOiCkPiCmFiNmPiCnOiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCTableRec
{
	FCTableRec ();
	virtual ~FCTableRec ();
	virtual FTTableOperationFlag	SetCreateFlag ();
	virtual FTTableOperationFlag	SetDeleteFlag ();
	virtual FTTableOperationFlag	GetOperationFlag () const;
	virtual void					SetOperationFlag (FTTableOperationFlag creationStat);

	FCVirtualWriteTable*	m_pVirtualTable;
	FTTableOperationFlag	m_tableOperation;
}; // struct FCTableRec.

/////////////////////////////////////////////////////////////////////////////
// FCGroupRec_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDePiDiLiBfLiDhGiCpAjFfMiClHiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiJlKiCmJiMhBiCkKiCoJiDfEiDhFiDePiDiLiBfLiDhGiCmGiDgFiBfLiDhFiDiLiCmMiNfMjBkCiCpAiLeMiJkPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiBeBiJlMjBhKiDePiDiLiBfLiDhGiCmJjBmOiClHiCoJjBiAiNoMjDoAjHgFiCoAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCGroupRec
{
	FCGroupRec ();
	virtual ~FCGroupRec ();

	virtual FTGroupOperationFlag	SetCreateFlag ();
	virtual FTGroupOperationFlag	SetDeleteFlag ();
	virtual FTGroupOperationFlag	GetOperationFlag () const;
	virtual void					SetOperationFlag (FTGroupOperationFlag creationStat);

	virtual FCGroupRec*			GetGroupRec (const FCTableIds& vGroupIds);
	virtual const FCGroupRec*	GetGroupRec (const FCTableIds& vGroupIds) const;
	virtual FCGroupRec*			QueryGroupRec (const FCTableIds& vGroupIds);
	virtual FCTableRec*			GetTableRec (const FCTableIds& vTableIds);
	virtual const FCTableRec*	GetTableRec (const FCTableIds& vTableIds) const;
	virtual FCTableRec*			QueryTableRec (const FCTableIds& vTableIds);

	map<DWORD, FCTableRec*>		m_mpTableIdToRec;
	map<DWORD, FCGroupRec*>		m_mpGroupIdToRec;
	FTGroupOperationFlag		m_groupOperation;
}; // struct FCGroupRec.

/////////////////////////////////////////////////////////////////////////////
// FCVirtualTableManager_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCVirtualTableManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiJlKiCmJiCkAiCoJiBeBiJlMjBhKiDePiDiLiBfLiDhGiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMiKfEjEePiCmNiBeBiClBiCmMiDeOiDiJiDfIiCmJiCmNjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmNiBeBiDgHiDgCiDhGiDePiDiLiBfLiDhGiClCiCmGiCmJjFmKiBfIiCmJiKmHjHjNiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmNiBeBiCfAiCmCiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmJiMhBiCkKiCoJiJlMjBhKiDePiDiLiBfLiDhGiCmG_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCVirtualTableManager
{
public:
	FCVirtualTableManager (const HString& hstrTopDirPath);
	virtual ~FCVirtualTableManager ();
	virtual void				Clear ();

	virtual FCGroupRec*			GetGroupRec (const FCTableIds& vGroupIds);
	virtual const FCGroupRec*	GetGroupRec (const FCTableIds& vGroupIds) const;
	virtual FCGroupRec*			QueryGroupRec (const FCTableIds& vGroupIds);

	virtual FCTableRec*			GetTableRec (const FCTableIds& vTableIds);
	virtual const FCTableRec*	GetTableRec (const FCTableIds& vTableIds) const;
	virtual FCTableRec*			QueryTableRec (const FCTableIds& vTableIds);
	virtual void				AddTransaction (const BYTE* pTransaction, size_t szTransaction);

friend struct FCGroupRec;
protected:
	virtual void	DoTransCommand (BYTE byCommand, const BYTE*& pTransaction);

	virtual FCVirtualWriteTable*	CreateVirtualTable () = NULL;
	virtual FCTableRec*	UpdateVirtualTable (const FCTableIds& vTableIds) = NULL;

	virtual void	GetReadLockInfo (	GUID& guidTable,
										DWORD& dwDeleteIdentifier,
										DWORD& dwAppendIdentifier,
										const FCTableIds& vTableIds) const = NULL;

	virtual void CalcRecordOperationGroup (FCGroupRec* pGroupRec);
	virtual void CalcRecordOperationTable (FCTableRec* pTableRec);
	virtual void GetModifiedTable (	vector<FCTableName>& vDeletedTableName,
									vector<FCTableName>& vModifiedTableName,
									FCGroupRec* pGroupRec,
									const FCTableIds& vGroupIds) const;
	virtual void UpdateGroupLockIdentifier (FCGroupRec* pGroupRec, const FCTableIds& vGroupIds);
	virtual void UpdateTableLockIdentifier (FCTableRec* pTableRec, const FCTableIds& vTableIds);
	virtual void SetLockGuidAndIdentifier (	const FCTableIds& vTableIds,
											const GUID& guidTable,
											DWORD dwDeleteIdentifier,
											DWORD dwAppendIdentifier) = NULL;
//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void IncrementLockGuidAndIdentifier (	const FCTableIds& vTableIds,
//													BOOL bIsIncDeleteId,
//													BOOL bIsIncAppendId) = NULL;
//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual void SetLockIdentifier (const FCTableIds& vTableIds,
									DWORD dwDeleteIdentifier,
									DWORD dwAppendIdentifier) = NULL;
//----- 06.02.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

protected:
	HString		m_hstrTopDirPath;
	FCGroupRec*	m_pGroupRecTop;
}; // class FCVirtualTableManager.

/////////////////////////////////////////////////////////////////////////////

#endif //__VirtualTableManager_h
