#if !defined(AFX_VIRTUALWRITETABLE_H__8C4FBC2F_D54A_4395_AD92_82898F05F0E9__INCLUDED_)
#define AFX_VIRTUALWRITETABLE_H__8C4FBC2F_D54A_4395_AD92_82898F05F0E9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// VirtualWriteTable.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "Heap.h"		// For FCHeap.

class FCVirtualTableManager;

struct FCVirtualRecord
{
	flint	m_fliPrimaryId;
	DWORD	m_dwAppendIdentifier;
	DWORD	m_dwSize;
	DWORD	m_dwDataId;
}; // struct FCVirtualRecord.

/*************************************************************************
 * <_xZkqqHx_jHpBiLjD_xHqqkZx_>	FTRecordOperation
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmJiCkIiCkPiCoJiBeBiDiMiDfCiBfLiDgIjBiAiNoMiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmJiCkIiCkPiCoJiDiMiDfCiBfLiDgIiCmMjCmHiJmBiCoCiNoNiPjMiCmMiOoNjHnOiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmNiBeB_xHqqkZx_FD_RECORD_OPE_DEL_AND_ADD _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
 *                                               _xZkqqHx_iBkL_xHqqkZx_
 *                       _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *           _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *                       _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *           _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
 *                       _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *                                     _xZkqqHx_iBkK_xHqqkZx_                _xZkqqHx_iBkK_xHqqkZx_
 *                              _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
 *
 *			_xZkqqHx_iImIiJlKiCmMjHlMjFpLiCmFiOgHiCoNiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCnGiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiCmMjBiAiNoMiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCnGiCmMjBlMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiCmMjBiAiNoMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
enum FTRecordOperation
{
	FD_RECORD_OPE_NOT_CHANGE,		// _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	FD_RECORD_OPE_ADD,				// _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
	FD_RECORD_OPE_DEL,				// _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
	FD_RECORD_OPE_DEL_AND_ADD,		// _xZkqqHx_iHeD_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiHiBeC_xHqqkZx_
	FD_RECORD_OPE_REPLACE,			// _xZkqqHx_iHeE_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCpAjChFiCkLiKlHiCkGiCmMiPoKiNiHiBeC_xHqqkZx_
}; // enum FTRecordOperation.

/////////////////////////////////////////////////////////////////////////////
// FCVirtualWriteTable _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCVirtualWriteTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiBeBiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMjHlMjFpLiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmNiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmMiKoOjCoKiDeOiDiJiDfIiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiCmNiBeBiClBiCmMiDeOiDiJiDfIiCmMiPoDiCmJ_xHqqkZx_ READ_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCpA_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiClHiCoJ_xHqqkZx_ FCVirtualRealTable_xZkqqHx_iBeBiClDiCoHiCmJiPoDiCmJ_xHqqkZx_ READ_xZkqqHx_iBeF_xHqqkZx_WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCpA_xHqqkZx_
 *			_xZkqqHx_iCnMiCmGiCnPiClN_xHqqkZx_ FCVirtualTable _xZkqqHx_iCkKiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiCmNiBeBiDhEiDiJiDgCiDfGiDiFjHhAiCmMiDiPiBfLiDeOjFmPjAjEiCpAjCmHiJmBiClFiClN_xHqqkZx_
 *			FCVirtualWriteTableForFlush _xZkqqHx_iCkKiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCVirtualWriteTable
{
public:
	FCVirtualWriteTable ();
	virtual ~FCVirtualWriteTable ();
	virtual DWORD	GetWriteRecordBegin () const;
	virtual DWORD	GetWriteRecordEnd () const;
	virtual DWORD	GetRealRecordEnd () const = NULL;
	virtual DWORD	GetWriteRecordDataSize (DWORD dwIndex) const;
	virtual DWORD	GetWriteRecordData (void* pDataBuff, DWORD dwBuffSize, DWORD dwIndex) const;
	virtual void	GetWriteRecordData (BYTEVector& vDataBuff, DWORD dwIndex) const;

	virtual void	GetWriteRecord (DWORD& dwAppendIdentifier, flint& fliPrimaryId, BYTEVector& vRecordData, DWORD dwIndex) const;
	virtual GUID	GetTableGuid () const;
	virtual void	SetTableGuid (GUID guidTable);
	virtual DWORD	GetWriteDeleteIdentifier () const;
	virtual DWORD	GetWriteAppendIdentifier () const;
	virtual void	ResetWriteRecordCache (	DWORD dwRecordSize,
											DWORD dwDeleteIdentifier,
											DWORD dwAppendIdentifier);
	virtual DWORD	AppendWriteRecord (BOOL bIsFirstOfMulti, flint fliPrimaryId, const void* pRecordData, size_t szRecordData);
	virtual void	ReduceWriteRecordCount (DWORD dwRecordSize);

	virtual void	AppendWriteRecordTermination ();
	virtual BOOL	GetIsWriteRecordTerminated () const;

friend class FCVirtualTableManager;
protected:
	virtual FCVirtualRecord&		GetTableWriteRecord (DWORD dwIndex);
	virtual const FCVirtualRecord&	GetTableWriteRecord (DWORD dwIndex) const;
	virtual BOOL					IsWriteRecordInside (DWORD dwIndex) const;

protected:
	DWORD	m_dwWriteRecordBeginIndex;			// WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiKeKiOgOiImKjChFiBeC_xHqqkZx_
	vector<FCVirtualRecord>	m_vVirtualWriteTable;	// WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCmMiDiMiDfCiBfLiDgIiDgGiBfLiDfOiBeC_xHqqkZx_
	FCHeap	m_heap;								// WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmMjDoAjHgFiCpAjFnLiOjNiClHiCoJiDhBiBfLiDhGiBeC_xHqqkZx_
	GUID	m_guidTable;						// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	DWORD	m_dwWriteDeleteIdentifier;			// WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFjAoKjHhAiCmMiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
	DWORD	m_dwWriteAppendIdentifier;			// WRITE_xZkqqHx_iDeMiDiDiDgCiDfGiDiFjAoKjHhAiCmMjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_

	FTRecordOperation		m_recordOperation;	// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
												// _xZkqqHx_iClBiClBiCmMjFmPjAjEiCmNiBeB_xHqqkZx_MakeRecoveryTable _xZkqqHx_iCmJiCoGiCmBiCmEjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
												// WriteTable _xZkqqHx_iCmFiNmEiMhGiOfKiClHiCoJiOoIiKnEiCpAiPmIiCkNiClNiCnPiBeBiClBiClBiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
}; // class FCVirtualWriteTable.

/////////////////////////////////////////////////////////////////////////////

#endif // !defined(AFX_VIRTUALWRITETABLE_H__8C4FBC2F_D54A_4395_AD92_82898F05F0E9__INCLUDED_)
