// WndChipView.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilDlg.h"			// For FFPopupSubmenu.
#include "UtilWin.h"			// For FFSetWindowText.
#include "DynamicDrawView.h"	// For g_pView.
#include "RegData.h"			// For FCRegData.
#include "Env.h"				// For FD_CHIP_GROUP_UNSPECIFY,etc.
#include "SimpleMtrxChip.h"		// For CFCSimpleMtrxChip.
#include "HiCommandTable.h"		// For FD_CMD_XXXX.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "PursuerText.h"		// For CFCPursuerText.
#include "WndChipView.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFCWndChipView

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::CFCWndChipView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndChipView::CFCWndChipView ()
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	m_bIsChipStoreRedraw = FALSE;		// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiNmEjFgAiJoGiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bIsChipChanged = FALSE;			// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	m_bIsChipGroupChanged = FALSE;		// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_

	m_mtxpChipView = NULL;
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_cgidCurrent = FD_CHIP_GROUP_UNSPECIFY;
	// _xZkqqHx_iDgHiDgCiDhGiDgPiBfLiCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	SetTopBarControlId(	ID_VIEW_CHIP_STORE_SIDE_CHANGE,
						ID_VIEW_CHIP_STORE_DOCK_OR_FLOAT,
						ID_VIEW_CHIP_STORE_VISIBLE);
} // CFCWndChipView::CFCWndChipView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::~CFCWndChipView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndChipView::~CFCWndChipView ()
{
} // CFCWndChipView::~CFCWndChipView.

BEGIN_MESSAGE_MAP(CFCWndChipView, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCWndChipView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(ID_WND_CMB_STORE_CHIP_GROUP, OnSelchangeCmbStoreChipGroup)
	ON_MESSAGE(WM_USER_MTRX_SELCHANGED, OnUserMtrxSelchanged)
	ON_MESSAGE(WM_USER_MTRX_LBTN_DBLCLKED, OnUserMtrxLbtnDblclked)
	ON_MESSAGE(WM_USER_CMD_SESSION_ENDED, OnUserCmdSessionEnded)
	ON_MESSAGE(WM_USER_COMMAND_CALLED, OnUserCommandCalled)
	ON_MESSAGE(WM_USER_UPDATE_CHIP_STORE, OnUserUpdateChipStore)
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCWndChipView _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::GetCurChipId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDgAiDgCiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ChipID CFCWndChipView::GetCurChipId () const
{
	if (0 <= m_mtxpChipView->GetCurSel())
		return m_mtxpChipView->GetItemData(m_mtxpChipView->GetCurSel());
	return FD_CHIP_UNSPECIFY;
} // CFCWndChipView::GetCurChipId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::UnselectCurChip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiCmMjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJpAiPjMiOjOiCmJiBeBjBeJjBpAjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiCmNjCmKjCgNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::UnselectCurChip ()
{
	m_mtxpChipView->SetCurSel(-1);
} // CFCWndChipView::UnselectCurChip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::GetCurChipGroupId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ChipGroupID CFCWndChipView::GetCurChipGroupId () const
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return m_cgidCurrent;
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORD dwCurrentUniqId = DWORD(-1);
	if (m_cmbChipGroup.GetCurSel() != CB_ERR)
		dwCurrentUniqId = m_cmbChipGroup.GetItemData(m_cmbChipGroup.GetCurSel());
	return g_pEnv->UniqIDToChipGroupID(dwCurrentUniqId);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::GetCurChipGroupId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::SetCurChipGroupId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::SetCurChipGroupId (ChipGroupID cgid)
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_cgidCurrent = cgid;
//	DWORD dwIndex = g_pEnv->ChipGroupIDToIndex(cgid);
//	if (dwIndex != DWORD(-1))
//		m_cmbChipGroup.SetCurSel(dwIndex);
//	else
//	if (0 < m_cmbChipGroup.GetCount())
//		m_cmbChipGroup.SetCurSel(0);
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFmPiNfIiCmMiPiIjHjNiBeC_xHqqkZx_
//	OnSelchangeCmbStoreChipGroup();
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORD dwIndex = g_pEnv->ChipGroupIDToIndex(cgid);
	if (dwIndex != DWORD(-1))
		m_cmbChipGroup.SetCurSel(dwIndex);
	else
	if (0 < m_cmbChipGroup.GetCount())
		m_cmbChipGroup.SetCurSel(0);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::SetCurChipGroupId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnChipGroupChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnChipGroupChanged ()
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_cmbChipGroup.ResetContent();
//	//------ _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJjAfGiClFiCkCiDePiDiLiBfLiDhGiCpAjAnNjCoI_xHqqkZx_ -----
//	FDChipGroupIDVector::const_iterator iCg;
//	for (iCg = g_pEnv->GetFreqChipGroupVector().begin();
//		 iCg != g_pEnv->GetFreqChipGroupVector().end(); iCg++)
//	{
//		int iIndex = FFAddString(&m_cmbChipGroup ,g_pEnv->cgid2name(*iCg));
//		m_cmbChipGroup.SetItemData(iIndex, *iCg);
//	}
//	// _xZkqqHx_iMlLiNnNiCmMjAnNjCoIiCpAjGnPiClHiBeC_xHqqkZx_
//	SetCurChipGroupId(m_cgidCurrent);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORD dwCurrentUniqId = DWORD(-1);
	if (m_cmbChipGroup.GetCurSel() != CB_ERR)
		dwCurrentUniqId = m_cmbChipGroup.GetItemData(m_cmbChipGroup.GetCurSel());
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_cmbChipGroup.ResetContent();
	//------ _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJjAfGiClFiCkCiDePiDiLiBfLiDhGiCpAjAnNjCoI_xHqqkZx_ -----
	FDChipGroupIDVector::const_iterator iCg;
	for (iCg = g_pEnv->GetFreqChipGroupVector().begin();
		 iCg != g_pEnv->GetFreqChipGroupVector().end(); iCg++)
	{
		int iIndex = FFAddString(&m_cmbChipGroup ,g_pEnv->cgid2name(*iCg));
		m_cmbChipGroup.SetItemData(
							iIndex,
							g_pEnv->GetChipGroupRec(*iCg)->GetUniqID());
	}
	// _xZkqqHx_iDgAiDgCiDhGiDhCiDiFiBfLiCpAiNmFjAfGiCmMiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiCmMiDgAiDgCiDhGiCmMjBeJjBpAiCmNiDeOiDiKiDeBiClDiCoKiCoJiBeC_xHqqkZx_
	m_mtxpChipView->UpdateGroupContents();
	// _xZkqqHx_iMlLiNnNiCmMjAnNjCoIiCpAjGnPiClHiBeC_xHqqkZx_
	SetCurChipGroupId(g_pEnv->UniqIDToChipGroupID(dwCurrentUniqId));
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::OnChipGroupChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnChipChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiCmMiPiHiPjIjFmPiNfIiBeBjCmHiJmBiBeBiNoNiPjMiCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnChipChanged ()
{
	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDgAiDgCiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
	const ChipID cpidCurrent = GetCurChipId();
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFmPiNfIiCmMiPiIjHjNiBeC_xHqqkZx_
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	OnSelchangeCmbStoreChipGroup();
	m_mtxpChipView->UpdateGroupContents();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiClNiDgAiDgCiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lIdxCurrent = -1;
	if (cpidCurrent != FD_CHIP_UNSPECIFY)
		lIdxCurrent = m_mtxpChipView->ItemDataToIndex(cpidCurrent);
	// _xZkqqHx_jBeJjBpAiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	if (0 <= lIdxCurrent)
		m_mtxpChipView->SetCurSel(lIdxCurrent, TRUE, TRUE);
} // CFCWndChipView::OnChipChanged.

/////////////////////////////////////////////////////////////////////////////
// CFCWndChipView _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMoveItemProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiOjOiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwData		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmMiDiGiBfLiDfFiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pWnd		:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCurState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptMsc		:pWnd_xZkqqHx_jCiGiCmFiCmMiDhNiDeFiDfIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFlags		:_xZkqqHx_iDeMiBfLiDhLiBfLiDgIiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myMoveItemProc (DWORD dwData, CWnd* pWnd, long lCurState,
							const CPoint& ptMsc, DWORD dwFlags)
{
//----- 05.07.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	TRACE(_T("myMoveItemProc %d %d\r\n"), ptMsc.x, ptMsc.y);
//	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiPoDiDhNiDeFiDfIiNmAjFfHiCpAiDhCiDiFiBfLiPoDiDhNiDeFiDfIiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//	CPoint lgptMsc = ptMsc;
//	::MapWindowPoints(pWnd->m_hWnd, g_pView->m_hWnd, &lgptMsc, 1);
//	CRect lgrtViewFrame;
//	g_pView->GetClientRect(lgrtViewFrame);
//	if (lgrtViewFrame.PtInRect(lgptMsc))
//	{
//		TRACE(_T("myMoveItemProc %d %d\r\n"), lgptMsc.x, lgptMsc.y);
//		//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
//		LPARAM lParam = *((LPARAM*)&ptMsc);
//		pWnd->SendMessage(WM_LBUTTONUP, 0, lParam);
//		// _xZkqqHx_iDgAiDgCiDhGjDfJjFhEiDgDiBfLiDiLiCmJjFmPiNfIiBeC_xHqqkZx_
//		g_pView->PostMessage(WM_COMMAND, ID_TOOL_CHIP_PUT, (LPARAM)0);
//		//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
//		lParam = *((LPARAM*)&lgptMsc);
//		g_pView->PostMessage(WM_LBUTTONDOWN, 0, lParam);
//	}
//----- 05.07.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	TRACE(_T("myMoveItemProc %d %d\r\n"), ptMsc.x, ptMsc.y);
	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiPoDiDhNiDeFiDfIiNmAjFfHiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	CPoint ptMscOnScreen = ptMsc;
	pWnd->ClientToScreen(&ptMscOnScreen);
	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiCmMjHmMiIoGiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	CFCWndChipView* pWndChip = (CFCWndChipView*)dwData;
	CRect rtWndChip;
	pWndChip->GetClientRect(rtWndChip);
	pWndChip->ClientToScreen(&rtWndChip);
	// _xZkqqHx_iDhCiDiFiBfLiCmMjHmMiIoGiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	CRect rtView;
	g_pView->GetClientRect(rtView);
	g_pView->ClientToScreen(&rtView);

	if (rtView.PtInRect(ptMscOnScreen) && !rtWndChip.PtInRect(ptMscOnScreen))
	{
//		TRACE(_T("myMoveItemProc %d %d\r\n"), lgptMsc.x, lgptMsc.y);
		//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
		LPARAM lParam = *((LPARAM*)&ptMsc);
		pWnd->SendMessage(WM_LBUTTONUP, 0, lParam);
		// _xZkqqHx_iDgAiDgCiDhGjDfJjFhEiDgDiBfLiDiLiCmJjFmPiNfIiBeC_xHqqkZx_
// 06.06.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		g_pView->PostMessage(WM_COMMAND, ID_TOOL_CHIP_PUT, (LPARAM)0);
		FFPostSendMessage(FD_PMSG_VIEW, WM_COMMAND, ID_TOOL_CHIP_PUT, (LPARAM)0);
		//----- _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiCpAiDhAiDiJiDiBiBfLiDfOiCmJiBeB_xHqqkZx_BtnDown/BtnUp_xZkqqHx_iCpAjBjHjFhE_xHqqkZx_ -----
		CPoint ptMscOnView = ptMscOnScreen;
		g_pView->ScreenToClient(&ptMscOnView);
		lParam = *((LPARAM*)&ptMscOnView);
// 06.03.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		g_pView->PostMessage(WM_LBUTTONDOWN, 0, lParam);
		FFPostSendMessage(FD_PMSG_VIEW, WM_LBUTTONDOWN, 0, lParam);
	}
//----- 05.07.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // myMoveItemProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoMjAkMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCWndChipView::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
		return -1;

	//----- _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNoMjAkM_xHqqkZx_ -----
	if (!m_cmbChipGroup.Create(CBS_DROPDOWNLIST|WS_VISIBLE|WS_TABSTOP|WS_VSCROLL,
								CRect(0,0,10,10), this, ID_WND_CMB_STORE_CHIP_GROUP))
	{
		TRACE(_T("Failed to create combo-box\n"));
		return FALSE;
	}
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbChipGroup.SetFont(g_pReg->GetRegFontStatic(FDFT_TOOLBAR));
	m_cmbChipGroup.SetDroppedWidth(250);
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiPiJiKpKjBeJjBpAiCmGiClFiCmEiBhF_xHqqkZx_-1_xZkqqHx_iBhGiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbChipGroup.SetCurSel(-1);
	//----- _xZkqqHx_iDgAiDgCiDhGjGlMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNoMjAkM_xHqqkZx_ -----
	m_edtChipName.Create(ES_READONLY|ES_AUTOHSCROLL|WS_VISIBLE|WS_CHILD,
						 CRect(0,0,10,10), this, ID_WND_EDT_STORE_CHIP_NAME);
	m_edtChipName.ModifyStyleEx(0, WS_EX_CLIENTEDGE);
	m_edtChipName.SetFont(g_pReg->GetRegFontStatic(FDFT_TOOLBAR));
	// _xZkqqHx_iDgAiDgCiDhGjGlMiDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(m_edtChipName.m_hWnd);
	//----- _xZkqqHx_iDgAiDgCiDhGiDhCiDiFiBfLiDeBiCmMjAlGjAkM_xHqqkZx_ -----
	m_mtxpChipView = new CFCSimpleMtrxChip;
	m_mtxpChipView->Create(	WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE,
// 06.03.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//							WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL,
							WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL|WS_HSCROLL,
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
							FDGMC_STYLE_GROUP|FDGMC_STYLE_FIXED_ITEM_SIZE,	// _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
							CRect(0,0,100,100),
							this,
							ID_WND_MTX_STORE_CHIP_VIEW);
	// _xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiOjOiCmMiDfCiBfLiDiLiDgPiDgCiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mtxpChipView->SetMoveItemCallback(myMoveItemProc, DWORD(this));
	// _xZkqqHx_jCfAiIoKjBeJjBpAiDiCiBfLiDgIiCmJjAnNjCoIiBeC_xHqqkZx_
	m_mtxpChipView->SetSingleSelect(TRUE);
	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(m_mtxpChipView->m_hWnd);
//----- 06.03.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDiBiDgCiDfKiBfLiDfHiOpDiCkPiOoGiCoIiDeFiDeCiDjDiDgIiDeFiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
	FFGetMainWnd()->RegisterScrollWindow(m_mtxpChipView->m_hWnd);
//----- 06.03.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return 0;
} // CFCWndChipView::OnCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFjEgKiKpMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnDestroy ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
	//----- _xZkqqHx_iDgAiDgCiDhGiDhCiDiFiBfLiDeBiCpAjEgKiJpD_xHqqkZx_ -----
	m_mtxpChipView->DestroyWindow();
	delete m_mtxpChipView;
	m_mtxpChipView = NULL;

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCkJiCoHiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->DeleteAutoAltWindow(m_cmbChipGroup.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_edtChipName.m_hWnd);

} // CFCWndChipView::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMiOoNjHnOiBeC_xHqqkZx_
 *			cx,cy	:_xZkqqHx_jAfGiClFiCkCiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmMiDgAiDgCiDhGiDhCiDiFiBfLiDeBiBgJ_xHqqkZx_m_mtxpChipView_xZkqqHx_iBgKiCmMiDiKiDfEiDeDiDfJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 *                     _xZkqqHx_iDfIiDeDiDgCiDgAiDgPiBfL_xHqqkZx_     _xZkqqHx_iDeOiDiNiBfLiDfJiDhLiDfOiDjD_xHqqkZx_
 *                         _xZkqqHx_iBkL_xHqqkZx_              _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiEkA_xHqqkZx_ _xZkqqHx_iBhO_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEkGiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiDgAiDgCiDhGiDePiDiLiBfLiDhGiDfCiDjDiDhLiDhLiDgCiDeOiDfIiEkAiBkFiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iDgAiDgCiDhGiDfOiDeDiDgHiDiL_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEkD_xHqqkZx_
 *         -------------------------------------------------------------------------------------------
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnSize (UINT nType, int cx, int cy)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSize(nType, cx, cy);

	// Create_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_BASE_CLASS::Create_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiInHiBeBiImIiJlKiCmMiPiIjHjNiCkKjFeLjHhGiBeC_xHqqkZx_
	if (m_mtxpChipView == NULL) return;

	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMiDfEiDeDiDfJiCmGiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbChipGroup.MoveWindow(CRect(0, GetTopBarHeight(), cx, 250));
	m_cmbChipGroup.SetDroppedWidth(250);
	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMiDfEiDeDiDfJiCpAiDgAiDgCiDhGjGlMiCmJjAnNjCoIiBeC_xHqqkZx_
	CRect rt;
	m_cmbChipGroup.GetWindowRect(rt);
	ScreenToClient(rt);
	rt.SetRect(0, rt.bottom, cx, rt.bottom + rt.Height());
	m_edtChipName.MoveWindow(rt);
//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgAiDgCiDhGiDhCiDiFiBfLiDeBiCpAiDiKiDfEiDeDiDfJiBeCiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCmMjFjNiClOiCkPiJeFiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
//	m_mtxpChipView->MoveWindow(CRect(0, rt.bottom, rt.right, cy));
//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMjFjNiBeCiDgGiDhEiDeIiDiLiDgHjCgMiCmN_xHqqkZx_20_xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
	int iScrollBarWidth = 20;
	if (g_pView != NULL && ::IsWindow(g_pView->m_hWnd))
	{
		// m_mtxpChipView_xZkqqHx_iCmMiDfIiDeOiDiNiBfLiDiLiDgPiBfLjFjNiCpAiOoGjDlOiClFiClNiCkCiCmMiClOiCkKiBeB_xHqqkZx_
		// m_mtxpChipView_xZkqqHx_iCmNiDfEiDeDiDfJiCkKiImAjCoIiClFiCmIiCkCiCmMiCmFiBgJjFjNiBeBiNiCiClDiCkK_xHqqkZx_
		// _xZkqqHx_iPkMiClDiJnPiCkMiCmEiLlGiCmBiClNjCgMiCpAjFnEiClHiPoKiNiHiCkKiCkAiCoJiBgKiBeBjBoDiCoNiCoIiCmJ_xHqqkZx_
		// g_pView _xZkqqHx_iCmMjFjNiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		SCROLLBARINFO sbi;
		memset(&sbi, 0, sizeof(sbi));
		sbi.cbSize = sizeof(sbi);
		if (::GetScrollBarInfo(g_pView->m_hWnd, OBJID_HSCROLL, &sbi))
			iScrollBarWidth = sbi.rcScrollBar.bottom - sbi.rcScrollBar.top;
	}
	// _xZkqqHx_iDgAiDgCiDhGiDhCiDiFiBfLiDeBiCpAiDiKiDfEiDeDiDfJiBeCiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCmMjFjNiClOiCkPiJeFiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCoNiClEiCoNiClEjAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiNoMjAkMiClFiCmEiBeBiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiJeCiCoKiCoJiCoGiCkEiCmJ_xHqqkZx_
	// _xZkqqHx_iDiKiDfEiDeDiDfJiClHiCoJiCmMiCmNiBeBiDhNiDeFiDfIiDhKiDeDiBfLiDiLiCmMiJkBiDfIiDeOiDiNiBfLiDiLiDeDiDhIiDjDiDgHiCpAiOoGjDlOiClHiCoJiClNiCnPiBeC_xHqqkZx_
	// _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAjFfMiOkGiClFiCmIiCkCiCmGiDeDiDhIiDjDiDgHiCkKiOoGjDlOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	m_mtxpChipView->MoveWindow(CRect(0, rt.bottom, rt.right, cy + iScrollBarWidth + 2));
//----- 06.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiBeBiIlNiCkCiCmNiDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCmBiCmEiLeOjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iJeFiDhLiDfOiDjDiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnContextMenu (CWnd* pWnd, CPoint point)
{
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	FFPopupSubmenu(point, IDR_RBTN_MISC, FD_MENU_WND_CHIP_STORE, FFGetMainWnd()->GetWnd());
} // CFCWndChipView::OnContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnSelchangeCmbStoreChipGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjFfMiOkGiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAjFmPiNfIiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndChipView::OnSelchangeCmbStoreChipGroup ()
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_cgidCurrent = FD_CHIP_GROUP_UNSPECIFY;
//	if (m_cmbChipGroup.GetCurSel() != CB_ERR)
//		m_cgidCurrent = m_cmbChipGroup.GetItemData(m_cmbChipGroup.GetCurSel());
//	if (m_cgidCurrent != FD_CHIP_GROUP_UNSPECIFY)
//	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		const FDChipIDVector& vId = g_pEnv->GetChipGroupRec(m_cgidCurrent)->m_vFreqChip;
//		// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
//		m_mtxpChipView->SetIdOrder(vId.size(), vId.begin());
//	} else
//	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiDePiDiLiBfLiDhGiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
//		m_mtxpChipView->SetIdOrder(0, NULL);
//	}
//	// _xZkqqHx_iDgAiDgCiDhGiDhNiDgHiDiKiDgCiDeOiDfIjBeJjBpAiJpAiPjMiCmMiPiIjHjNiBeC_xHqqkZx_
//	OnUserMtrxSelchanged(0, -1);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAfGiClFiCkCiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORD dwNewUniqId = DWORD(-1);
	if (m_cmbChipGroup.GetCurSel() != CB_ERR)
		dwNewUniqId = m_cmbChipGroup.GetItemData(m_cmbChipGroup.GetCurSel());
	ChipGroupID cgidNew = g_pEnv->UniqIDToChipGroupID(dwNewUniqId);
	// _xZkqqHx_jAfGiClFiCkCiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	long lNewGroupIndex = m_mtxpChipView->GroupDataToIndex(cgidNew);
	if (lNewGroupIndex != -1)
	//----- _xZkqqHx_jAfGiClFiCkCiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!m_mtxpChipView->GetIsGroupExpanded(lNewGroupIndex))
		//----- _xZkqqHx_iOhHjCoIiCmMiDePiDiLiBfLiDhGiCkKjGkCjDfHiKeKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOhHjCoIiCmMiDePiDiLiBfLiDhGiCpAjDfHiKeKiClHiCoJiBeC_xHqqkZx_
			m_mtxpChipView->SetIsGroupExpanded(lNewGroupIndex, TRUE);
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_mtxpChipView->UpdateItemSize(FALSE);
			m_mtxpChipView->UpdateScrollSize(FALSE);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtGroup = m_mtxpChipView->GetGroupRect(lNewGroupIndex);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCkKiDgHiDgCiDhGiCmJiCkNiCoJiCoGiCkEiDfIiDeOiDiNiBfLiDiLiBeCiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
			m_mtxpChipView->OffsetScroll(-rtGroup.top / m_mtxpChipView->GetPixelOf1Scroll(), FALSE);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			long lIndexBegin;
			long lIndexEnd;
			m_mtxpChipView->GetGroupItemIndex(lIndexBegin, lIndexEnd, lNewGroupIndex);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmMiDgHiDgCiDhGiDeBiDeDiDgFiDiAiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
			if (lIndexBegin != lIndexEnd)
				m_mtxpChipView->SetCurSel(lIndexBegin, FALSE, FALSE);
			// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
			m_mtxpChipView->Invalidate();
		} else
		//----- _xZkqqHx_iOhHjCoIiCmMiDePiDiLiBfLiDhGiCkKjDfHiKeKiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtGroup = m_mtxpChipView->GetGroupRect(lNewGroupIndex);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCkKiDgHiDgCiDhGiCmJiCkNiCoJiCoGiCkEiDfIiDeOiDiNiBfLiDiLiBeCiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
			m_mtxpChipView->OffsetScroll(-rtGroup.top / m_mtxpChipView->GetPixelOf1Scroll(), TRUE);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			long lIndexBegin;
			long lIndexEnd;
			m_mtxpChipView->GetGroupItemIndex(lIndexBegin, lIndexEnd, lNewGroupIndex);
			// _xZkqqHx_iOhHjCoIiDePiDiLiBfLiDhGiCmMiDgHiDgCiDhGiDeBiDeDiDgFiDiAiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
			if (lIndexBegin != lIndexEnd)
				m_mtxpChipView->SetCurSel(lIndexBegin, FALSE, FALSE);
		}
	}
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::OnSelchangeCmbStoreChipGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserMtrxSelchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIjFjEjFgJiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jAfGiClNiCmJjBeJjBpAiClDiCoKiClNjHhGjBgGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT	CFCWndChipView::OnUserMtrxSelchanged (WPARAM wParam, LPARAM lParam)
{
	//-----	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDeMiDiFiBfLiCkJiCoHiBeBjDkPiClGiDiBiDgCiDfKiBfLiDfHiCmMiNmFiMoDiCpAiOoGjDlO_xHqqkZx_ -----
	// PostMessage_xZkqqHx_iCmIiCmMiCmFiBeBiKpJiCmJiNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
	// _xZkqqHx_jBjHiCmBiCmEiCkNiCoJiPoKiNiHiCkKiCoGiCkNiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	long lIndex	= long(lParam);
	MSG	msg;
	while (::PeekMessage(&msg, m_hWnd, WM_USER_MTRX_SELCHANGED,
							WM_USER_MTRX_SELCHANGED, PM_REMOVE))
		lIndex = long(msg.lParam);
	if (lIndex == -1)
	{
		FFSetWindowText(&m_edtChipName, L"");
	} else
	{
		FFSetWindowText(&m_edtChipName,
				g_pEnv->cpid2name(m_mtxpChipView->GetItemData(lIndex)));
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDePiDiLiBfLiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
		long lGroupIndex = m_mtxpChipView->ItemIndexToGroupIndex(lIndex);
		ChipGroupID cgid = (ChipGroupID)m_mtxpChipView->GetGroupData(lGroupIndex);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		SetCurChipGroupId(cgid);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	return 0;
} // CFCWndChipView::OnUserMtrxSelchanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserMtrxLbtnDblclked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIjFjEjFgJiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jAfGiClNiCmJjBeJjBpAiClDiCoKiClNjHhGjBgGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT	CFCWndChipView::OnUserMtrxLbtnDblclked (WPARAM wParam, LPARAM lParam)
{
	//-----	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDeMiDiFiBfLiCkJiCoHiBeBjDkPiClGiDiBiDgCiDfKiBfLiDfHiCmMiNmFiMoDiCpAiOoGjDlO_xHqqkZx_ -----
	// PostMessage_xZkqqHx_iCmIiCmMiCmFiBeBiKpJiCmJiNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
	// _xZkqqHx_jBjHiCmBiCmEiCkNiCoJiPoKiNiHiCkKiCoGiCkNiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	MSG	msg;
	while (::PeekMessage(&msg, m_hWnd, WM_USER_MTRX_LBTN_DBLCLKED,
							WM_USER_MTRX_LBTN_DBLCLKED, PM_REMOVE))
	{
		wParam = msg.wParam;
		lParam = msg.lParam;
	}
	// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiBgJjBkGiClPiDhEiDiMiBfLiDiAiBgKiCmJjDkPiClGiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
	GetParent()->PostMessage(WM_USER_MTRX_LBTN_DBLCLKED, wParam, lParam);
	return 0;
} // CFCWndChipView::OnUserMtrxLbtnDblclked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserCmdSessionEnded
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiPeJjHlJiKnGjAjEiCkKiOmAiNhDiClDiCoKiClNiOjOiBeB_xHqqkZx_
 *			CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndChipView::OnUserCmdSessionEnded (WPARAM, LPARAM)
{
	// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	if (m_bIsChipGroupChanged)
		OnChipGroupChanged();
	// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	if (m_bIsChipChanged)
		OnChipChanged();
	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBgJiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiBgKiNmEjFgAiJoGiBeC_xHqqkZx_
	if (m_bIsChipStoreRedraw)
		Invalidate();
	// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiNmEjFgAiJoGiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bIsChipStoreRedraw = FALSE;
	// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	m_bIsChipChanged = FALSE;
	// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
	m_bIsChipGroupChanged = FALSE;
	return 1;
} // CFCWndChipView::OnUserCmdSessionEnded.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserCommandCalled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCkKiOmAiNhDiClDiCoKiClNiOjOiBeB_xHqqkZx_CommandGate_xZkqqHx_iCkJiCoH_xHqqkZx_ SendMessage_xZkqqHx_iCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDfCiDhNiDjDiDgIiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iDfCiDhNiDjDiDgIiClCiCmGiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndChipView::OnUserCommandCalled (WPARAM wParam, LPARAM lParam)
{
	//----- _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiCmMiNfIjAfG_xHqqkZx_ -----
	switch (wParam)
	{
	case FD_CMD_MODIFY1_S_COLOR:				// _xZkqqHx_jAeGjFmPiNfIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_EMF_IMAGE:				// _xZkqqHx_iDeDiDiBiBfLiDfHjFmPiNfIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_PEN_REGISTER:			// _xZkqqHx_jDgPjIfOiDhJiDjDjFmPiNfIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_BRUSH_REGISTER:			// _xZkqqHx_jDgPjIfOiDhFiDiJiDfGjFmPiNfIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_PEN_STYLE:				// _xZkqqHx_iCfAiDhJiDjDiDfIiDfOiDeDiDiLiPeDjAlDiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_MODIFY_SHADOW_LENGTH:			// _xZkqqHx_iJgFjClHjFmPiNfIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_CHIP:					// _xZkqqHx_iCfAiDgAiDgCiDhGiPeDjAlDiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_PICT_ARROW:				// _xZkqqHx_iCfAiDeBiDiNiBfLiPeDjAlDiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiNmEjFgAiJoGiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		m_bIsChipStoreRedraw = TRUE;
		// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
		g_pEnv->ClearChipBitmap();
		// _xZkqqHx_iDeBiDiNiBfLiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
		g_pEnv->ClearPictArrowBitmap();
		break;
	case FD_CMD_INSERT1_CHIP:			// _xZkqqHx_iCfAiDgAiDgCiDhGjCmHiJmBiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_DELETE1_CHIP:			// _xZkqqHx_iCfAiDgAiDgCiDhGiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_RE_ORDER_CHIP:			// _xZkqqHx_iDgAiDgCiDhGjFmAiCnHjBnGiCkGiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
		m_bIsChipChanged = TRUE;
		// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiNmEjFgAiJoGiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		m_bIsChipStoreRedraw = TRUE;
		break;
	case FD_CMD_INSERT1_CHIP_GROUP:		// _xZkqqHx_iCfAiDgAiDgCiDhGiDePiDiLiBfLiDhGjCmHiJmBiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_DELETE1_CHIP_GROUP:		// _xZkqqHx_iCfAiDgAiDgCiDhGiDePiDiLiBfLiDhGiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_MODIFY1_CHIP_GROUP:		// _xZkqqHx_iCfAiDgAiDgCiDhGiDePiDiLiBfLiDhGiPeDjAlDiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_RE_ORDER_CHIP_GROUP:	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjFmAiCnHjBnGiCkGiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_jBePiJpBiCmMiNmEjFfMiOkGiImIiNhOiCmJiDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKjFmPiNfIiClDiCoKiClNiCkJiBeI_xHqqkZx_
		m_bIsChipGroupChanged = TRUE;
		break;
	}
	return 1;
} // CFCWndChipView::OnUserCommandCalled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserUpdateChipStore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFDWndMatrix_xZkqqHx_iCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeBiDeDiDgFiDiAjAjEiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jAfGiClFiCkNjBeJjBpAiClDiCoKiClNiDgAiDgCiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkC_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndChipView::OnUserUpdateChipStore (WPARAM wParam, LPARAM lParam)
{
	OnChipGroupChanged();
	OnChipChanged();
	if (lParam != -1)
	{
		SetCurChipGroupId(lParam);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFmPiNfIiCmMiPiIjHjNiBeC_xHqqkZx_
		OnSelchangeCmbStoreChipGroup();
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	Invalidate();
	return 1;
} // CFCWndChipView::OnUserUpdateChipStore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndChipView::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndChipView::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (g_pReg->GetIsPopupToolbarHint())
//	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		HWND hwndPoint = HWND(wParam);
//		int id = ::GetDlgCtrlID(hwndPoint);
//		if (id != 0)
//			FFGetApp()->GetPopHint()->SetTargetInfo(id);
//	}
//	return 1;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	struct My
	{
		static BOOL IsTargetId (DWORD dwId)
		{
			static DWORD s_aCtrls[] = { ID_WND_CMB_STORE_CHIP_GROUP, ID_WND_EDT_STORE_CHIP_NAME };
			if (dwId != 0)
			{
				for (long lIndex = 0; lIndex != sizeof(s_aCtrls) / sizeof(s_aCtrls[0]); lIndex++)
					if (s_aCtrls[lIndex] == dwId)
						return TRUE;
			}
			return FALSE;
		}

		static DWORD GetTargetId (HWND hwnd)
		{
			// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCkKiDfOiBfLiDfBiDgCiDgHiCkJjClCiCnHiBeB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
			// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiCmIiCmHiBeBjFkBjAjEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCkKjAgFiOhBiKnGiMfHiCmJiCkAiCoJiPoKiNiHiCpA_xHqqkZx_
			// _xZkqqHx_iNgMjHlGiClFiCmEiBeBjAgFiDeFiDeCiDjDiDgIiDeFiCoAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
			DWORD dwId = (DWORD)GetDlgCtrlID(hwnd);
			if (IsTargetId(dwId))
				return dwId;
			if (GetParent(hwnd) != NULL)
			{
				DWORD dwIdParent = (DWORD)GetDlgCtrlID(GetParent(hwnd));
				if (IsTargetId(dwIdParent))
					return dwIdParent;
			}
			return dwId;
		}
	};
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupToolbarHint())
	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DWORD dwId = My::GetTargetId(HWND(wParam));
		if (dwId != 0)
			FFGetApp()->GetPopHint()->SetTargetInfo(dwId);
	}
	return 1;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndChipView::OnUserPursuerTextNeedInfo.
