// WndHtreeView.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>				// For find template.
#include "DynamicDraw.h"
#include "RegData.h"				// For g_pReg.
#include "WndHistoryTree.h"			// For m_pHistTree.
#include "FrameWnd.h"				// For FFGetMainWnd().
#include "HiFrameWnd.h"				// For FFGetHiMainWnd().
#include "HTreeManager.h"			// For FDHT_VMODE_TREE.
#include "HistViewDoc.h"			// For FFHistViewDoc().
#include "PursuerText.h"			// For CFCPursuerText.
#include "DlgHistoryMoveOpeList.h"	// For CFCDlgHistoryMoveOpeList.
#include "WndHtreeView.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

// _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDfEiDeDiDfJjCoIiLgAiBeC_xHqqkZx_
// _xZkqqHx_jFjNiBeFiNiCiClDiCmMjCfAiImKiCmNiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNiCiClDiCpAiCfAiCmGiClFiClNiPoKiNiHiBeC_xHqqkZx_
static struct
{
	BOOL	bIsShowOnDraw;
	long	lCtrlId;
	double	dCtrlWidth;
	double	dCtrlHeight;
	double	dDroppedWidth;
} s_aCtrls[] =
{
	// HistDraw_xZkqqHx_iCmFjFfMiOkGiBeI_xHqqkZx_	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID				_xZkqqHx_jFjN_xHqqkZx_		_xZkqqHx_iNiCiClD_xHqqkZx_	_xZkqqHx_iDiKiDfIiDgHjFjNiBeC_xHqqkZx_
	{ FALSE,			ID_HTREE_CMB_UP_DOWN_KIND,	6.0,	20.0,	 12.0 },
	{ FALSE,			0,							0.0,	0.0,	 0.0 },
	{ FALSE,			ID_HTREE_MOVE_OPERATION_BEFORE,		1.2,	1.0,	 0.0 },
	{ FALSE,			ID_HTREE_MOVE_OPERATION_AFTER,		1.2,	1.0,	 0.0 },
	{ FALSE,			0,							0.0,	0.0,	 0.0 },
	{ FALSE,			ID_HTREE_MOVE_HIGHER,		1.2,	1.0,	 0.0 },
	{ FALSE,			ID_HTREE_MOVE_LOWER,		1.2,	1.0,	 0.0 },
	{ FALSE,			0,							0.0,	0.0,	 0.0 },
	{ TRUE,				ID_HTREE_CMB_ZOOM,			3.0,	10.0,	 3.0 },
	{ TRUE,				0,							0.0,	0.0,	 0.0 },
	{ TRUE,				ID_HTREE_FONT_SMALL,		1.2,	1.0,	 0.0 },
	{ TRUE,				ID_HTREE_FONT_MEDIUM,		1.2,	1.0,	 0.0 },
	{ TRUE,				ID_HTREE_FONT_LARGE,		1.2,	1.0,	 0.0 },
	{ TRUE,				0,							0.0,	0.0,	 0.0 },
	{ TRUE,				ID_HTREE_PROJECT_VIEW,		1.2,	1.0,	 0.0 },
	{ TRUE,				ID_HTREE_TREE_VIEW,			1.2,	1.0,	 0.0 },
	{ TRUE,				ID_HTREE_BRANCH_VIEW,		1.2,	1.0,	 0.0 },
	{ TRUE,				0,							0.0,	0.0,	 0.0 },
};

// CComboBox_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmFjCoBiNiCiBeC_xHqqkZx_
static const long s_lMinCmbItemHeight = 20;
// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDePiDiLiBfLiDhGiKnEiCmMiDeNiDiDiDgCiDhGiBgJiDhLiBfLiDfPiBfLjFjNiBgK_xHqqkZx_
static const long s_lCtrlGroupGap = 5;
// _xZkqqHx_iDhLiBfLiDfPiBfLiCmMiPoDiJlKiCpAjAnIiCoJjClHiClDiBeC_xHqqkZx_
static const long s_lBorderChop = 2;
// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiNhDiKnEiBeC_xHqqkZx_
static const long s_lCtrlLineGap = 2;

BEGIN_MESSAGE_MAP(CFCWndHtreeView, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCWndHtreeView)
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(ID_HTREE_CMB_UP_DOWN_KIND, OnSelchangeHtreeCmbUpDownKind)
	ON_MESSAGE(WM_USER_ON_IDLE, OnUserOnIdle)
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////
// CFCWndHtreeView _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjDiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::CFCWndHtreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHtreeView::CFCWndHtreeView ()
{
	m_pHistTree = NULL;
	// _xZkqqHx_iDgHiDgCiDhGiDgPiBfLiCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	SetTopBarControlId(	ID_VIEW_HTREE_SIDE_CHANGE,
						ID_VIEW_HTREE_DOCK_OR_FLOAT,
						ID_VIEW_HTREE_VISIBLE);
	m_lHiMoveOpeType = 0;
	m_lHiMoveOpeValue = 0;
} // CFCWndHtreeView::CFCWndHtreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::~CFCWndHtreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHtreeView::~CFCWndHtreeView ()
{
} // CFCWndHtreeView::~CFCWndHtreeView.

///////////////////////////////////////////////////////////////////////////
// CFCWndHtreeView _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::InitUpDownKindComboBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiInKjDkOjFpLjGeAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgFiDjDiDgDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::InitUpDownKindComboBox ()
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiMlLiNnNiCmMiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vIdAndValue;
	CFCDlgHistoryMoveOpeList::GetHiMoveOpeList(vIdAndValue);
	WStringVector vTitle;
	CFCDlgHistoryMoveOpeList::HiMoveOpeListToTitle(vTitle, vIdAndValue);
	// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbUpDownKind.ResetContent();
	WStringVector::const_iterator iTt;
	for (iTt = vTitle.begin(); iTt != vTitle.end(); iTt++)
		m_cmbUpDownKind.AddString(WStrToTStr(*iTt));
} // CFCWndHtreeView::InitUpDownKindComboBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::UseTimeIndexChangedNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiCmHiCkEiCkJiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsUseTimeIndex	:_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::UseTimeIndexChangedNotify (BOOL bIsUseTimeIndex)
{
	if (bIsUseTimeIndex)
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----
	{
		m_btnMoveBefore.SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_MOVE_OPERATION_BEFORE_IDX));
		m_btnMoveAfter.SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_MOVE_OPERATION_AFTER_IDX));
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		m_btnMoveBefore.SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_MOVE_OPERATION_BEFORE));
		m_btnMoveAfter.SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_MOVE_OPERATION_AFTER));
	}
} // CFCWndHtreeView::UseTimeIndexChangedNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnUpdateControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjHeMiMpIiPpDjBnEiBeBiDfJiBfLiDiAjCgMiCmMjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::OnUpdateControl ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnUpdateControl();

	if (FFHistViewDoc() != NULL)
	{
		// _xZkqqHx_jDkPiClGiCmIiCoHjAnNjCoIiClFiCmIiCkCiBeCiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmNiBeBjDkPiClGjBeJjBpAiCpAjAnNjCoIiClHiCoJiCmGjFgAiJoGiCpA_xHqqkZx_
		// _xZkqqHx_iNmEiPiIjHjNiClFiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
		long lOpeValue;
		long lOpeType = FFGetHiMainWnd()->GetHiMoveOperation(lOpeValue);
		if (m_lHiMoveOpeType != lOpeType ||
			m_lHiMoveOpeValue != lOpeValue)
		{
			m_lHiMoveOpeType = lOpeType;
			m_lHiMoveOpeValue = lOpeValue;
			// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiMlLiNnNiCmMiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
			vector<longPair> vIdAndValue;
			CFCDlgHistoryMoveOpeList::GetHiMoveOpeList(vIdAndValue);
			vector<longPair>::const_iterator iFind = std::find(	vIdAndValue.begin(),
															vIdAndValue.end(),
															longPair(lOpeType, lOpeValue));
			if (iFind == vIdAndValue.end())
				FFThrowMiscUnknown();
			int iNewSel = long(iFind - vIdAndValue.begin());
			m_cmbUpDownKind.SetCurSel(iNewSel);
		}

		m_cmbUpDownKind.EnableWindow(FFHistViewDoc()->CanHtreeMoveBefore() || FFHistViewDoc()->CanHtreeMoveAfter());
		// _xZkqqHx_iImIjBePiBeBiImIiMoDiCnGiInKjDkOiCmMiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		m_btnMoveBefore.EnableWindow(FFHistViewDoc()->CanHtreeMoveBefore());
		m_btnMoveAfter.EnableWindow(FFHistViewDoc()->CanHtreeMoveAfter());
		m_btnMoveHigher.EnableWindow(FFHistViewDoc()->CanHtreeMoveHigher());
		m_btnMoveLower.EnableWindow(FFHistViewDoc()->CanHtreeMoveLower());
	}
	// _xZkqqHx_iDhEiDeIiDjDiDgHiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_btnFontSmall.EnableWindow(FFCanBasicOperate() && m_pHistTree->IsWindowVisible() && m_pHistTree->IsSelectedProjectOpened());
	m_btnFontMedium.EnableWindow(FFCanBasicOperate() && m_pHistTree->IsWindowVisible() && m_pHistTree->IsSelectedProjectOpened());
	m_btnFontLarge.EnableWindow(FFCanBasicOperate() && m_pHistTree->IsWindowVisible() && m_pHistTree->IsSelectedProjectOpened());
	m_btnFontSmall.SetCheck(rougheq(m_pHistTree->GetFontZoom(), 0.5) ? BST_CHECKED : BST_UNCHECKED);
	m_btnFontMedium.SetCheck(rougheq(m_pHistTree->GetFontZoom(), 0.75) ? BST_CHECKED : BST_UNCHECKED);
	m_btnFontLarge.SetCheck(rougheq(m_pHistTree->GetFontZoom(), 1.0) ? BST_CHECKED : BST_UNCHECKED);

	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiJiDfHiDeJiDhLiDfOiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_btnProjectView.EnableWindow(	FFCanBasicOperate() &&
									m_pHistTree->IsWindowVisible() &&
									m_pHistTree->CanChangeViewMode(FDHT_VMODE_PROJECT));
	m_btnTreeView.EnableWindow(	FFCanBasicOperate() &&
								m_pHistTree->IsWindowVisible() &&
								m_pHistTree->CanChangeViewMode(FDHT_VMODE_TREE));
	m_btnBranchView.EnableWindow(	FFCanBasicOperate() &&
									m_pHistTree->IsWindowVisible() &&
									m_pHistTree->CanChangeViewMode(FDHT_VMODE_BRANCH));
	m_btnProjectView.SetCheck((m_pHistTree->GetViewMode() == FDHT_VMODE_PROJECT) ? BST_CHECKED : BST_UNCHECKED);
	m_btnTreeView.SetCheck((m_pHistTree->GetViewMode() == FDHT_VMODE_TREE) ? BST_CHECKED : BST_UNCHECKED);
	m_btnBranchView.SetCheck((m_pHistTree->GetViewMode() == FDHT_VMODE_BRANCH) ? BST_CHECKED : BST_UNCHECKED);
} // CFCWndHtreeView::OnUpdateControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::CreateZoomComboBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHtreeView::CreateZoomComboBox ()
{
	m_cmbZoom.Create(	CBS_DROPDOWN|WS_VISIBLE|WS_TABSTOP|WS_VSCROLL,
						CRect(0,0,10,10), this, m_dwZoomCtrlId);
	m_cmbZoom.SetFont(g_pReg->GetRegFontStatic(FDFT_TOOLBAR));
	return TRUE;
} // CFCWndHtreeView::CreateZoomComboBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::IsViewZoomEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLjBkEiCmFiDfJiBfLiDiAiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHtreeView::IsViewZoomEnable () const
{
	return m_pHistTree->CanZoom();
} // CFCWndHtreeView::IsViewZoomEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::GetViewZoom256
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLjBkEiCmMiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiBeCiCfBiCfEiCfFiBiBiCfAiCePiCePiBjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHtreeView::GetViewZoom256 () const
{
	return D2L(256.0 * m_pHistTree->GetZoom());
} // CFCWndHtreeView::GetViewZoom256.

/////////////////////////////////////////////////////////////////////////////
// CFCWndHtreeView _xZkqqHx_iDeJiBfLiDgPiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCWndHtreeView _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::myInitButton
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmMiDhGiDgCiDfGiDiFiDhLiDfOiDjDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ctrl	:_xZkqqHx_iDhLiDfOiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCtrlId	:_xZkqqHx_iDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIconId	:_xZkqqHx_iDhLiDfOiDjDiCmJjDfMiCoJiDeBiDeDiDfCiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCpAiNoMjAkMiClFiBeBiDeBiDeDiDfCiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::myInitButton (CButton& ctrl, long lCtrlId, long lIconId)
{
	ctrl.Create(_T(""),
				BS_PUSHBUTTON |
				BS_ICON |
				BS_CENTER |
				BS_VCENTER |
				WS_VISIBLE |
				WS_TABSTOP |
				WS_CHILD,
			 	CRect(0,0,10,10),
				this,
				lCtrlId);
	ctrl.SetIcon(FFGetApp()->LoadIcon(lIconId));
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(ctrl.m_hWnd);
} // CFCWndHtreeView::myInitButton.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::myInitRadio
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ctrl	:_xZkqqHx_iDiJiDfHiDeJiDhLiDfOiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCtrlId	:_xZkqqHx_iDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIconId	:_xZkqqHx_iDhLiDfOiDjDiCmJjDfMiCoJiDeBiDeDiDfCiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsTop	:_xZkqqHx_jIeBjBlBiClHiCoJiDiJiDfHiDeJiDhLiDfOiDjDiCmMjAoGjDkKiCmMiDhLiDfOiDjDiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCpAiNoMjAkMiClFiBeBiDeBiDeDiDfCiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::myInitRadio (CButton& ctrl, long lCtrlId, long lIconId, BOOL bIsTop)
{
	if (bIsTop)
		ctrl.Create(_T(""),
					BS_AUTORADIOBUTTON |
					BS_ICON |
					BS_CENTER |
					BS_VCENTER |
	                BS_PUSHLIKE |
					WS_GROUP |
					WS_VISIBLE |
					WS_CHILD,
				 	CRect(0,0,10,10),
					this,
					lCtrlId);
	else
		ctrl.Create(_T(""),
					BS_AUTORADIOBUTTON |
					BS_ICON |
					BS_CENTER |
					BS_VCENTER |
	                BS_PUSHLIKE |
					WS_VISIBLE |
					WS_CHILD,
				 	CRect(0,0,10,10),
					this,
					lCtrlId);
	// _xZkqqHx_iDeBiDeDiDfCiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	ctrl.SetIcon(FFGetApp()->LoadIcon(lIconId));
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(ctrl.m_hWnd);
} // CFCWndHtreeView::myInitRadio.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::myInitCombo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ctrl	:_xZkqqHx_iDhLiDfOiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCtrlId	:_xZkqqHx_iDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCpAiNoMjAkMiClFiBeBiDeBiDeDiDfCiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::myInitCombo (CComboBox& ctrl, long lCtrlId)
{
	// _xZkqqHx_iInKjDkOiCmMiOoNjHnOiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	ctrl.Create(CBS_DROPDOWNLIST|
				WS_VISIBLE|
				WS_TABSTOP,
				CRect(0,0,10,10),
				this,
				lCtrlId);
	ctrl.SetFont(g_pReg->GetRegFontStatic(FDFT_TOOLBAR));
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiPiJiKpKjBeJjBpAiCmGiClFiCmEiBhF_xHqqkZx_0_xZkqqHx_iBhGiCpAjAnNjCoIiBeC_xHqqkZx_
	ctrl.SetCurSel(0);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(ctrl.m_hWnd);
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmJiKoOiPiAiCmGiClFiCmEiOgHiCoNiCoKiCoJiClNiCnPiBeBiClBiClBiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	long lCmbItemHeight = ctrl.GetItemHeight(-1);
	if (lCmbItemHeight < s_lMinCmbItemHeight)
		lCmbItemHeight = s_lMinCmbItemHeight;
	ctrl.SetItemHeight(-1, lCmbItemHeight);
} // CFCWndHtreeView::myInitCombo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::myInitBorder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiBfLiDfPiBfLiDiJiDeDiDjDiDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ctrl	:_xZkqqHx_iDhLiBfLiDfPiBfLiDiJiDeDiDjDiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::myInitBorder (CFCStcBorder& ctrl)
{
	ctrl.Create(_T(""),
				SS_WHITERECT |
				WS_VISIBLE |
				WS_TABSTOP |
				WS_CHILD,
			 	CRect(0,0,10,10),
				this,
				IDC_STATIC);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->AddAutoAltWindow(ctrl.m_hWnd);
} // CFCWndHtreeView::myInitBorder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoMjAkMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCWndHtreeView::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
		return -1;

	myInitCombo(m_cmbUpDownKind, ID_HTREE_CMB_UP_DOWN_KIND);
	// _xZkqqHx_jHjKjHpAiInKjDkOjFpLjGeAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgFiDjDiDgDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	InitUpDownKindComboBox();

//----- 05.10.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_cmbUpDownKind.AddString(FFLoadString(IDS_BY_SESSION));			// "_xZkqqHx_jBiAiNoM_xHqqkZx_"
//	m_cmbUpDownKind.AddString(FFLoadString(IDS_BY_INTERVAL));			// "_xZkqqHx_jClHiNgM_xHqqkZx_"
//	m_cmbUpDownKind.AddString(FFLoadString(IDS_BY_TIME_PASS));			// "_xZkqqHx_iOjOiKnE_xHqqkZx_"
//----- 05.10.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	myInitBorder(m_stcBorder[0]);

	myInitButton(m_btnMoveBefore, ID_HTREE_MOVE_OPERATION_BEFORE, IDI_HTREE_MOVE_OPERATION_BEFORE);
	myInitButton(m_btnMoveAfter, ID_HTREE_MOVE_OPERATION_AFTER, IDI_HTREE_MOVE_OPERATION_AFTER);

	myInitBorder(m_stcBorder[1]);

	myInitButton(m_btnMoveHigher, ID_HTREE_MOVE_HIGHER, IDI_HTREE_MOVE_HIGHER);
	myInitButton(m_btnMoveLower, ID_HTREE_MOVE_LOWER, IDI_HTREE_MOVE_LOWER);

	myInitBorder(m_stcBorder[2]);

	// _xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	if (!Initialize(ID_HTREE_CMB_ZOOM,
					FFGetMainWnd()->GetWnd(), 
					WM_USER_SET_HIVIEW_ZOOM256)) return FALSE;

	myInitBorder(m_stcBorder[3]);

	myInitRadio(m_btnFontSmall, ID_HTREE_FONT_SMALL, IDI_HTREE_FONT_SMALL, TRUE);
	myInitRadio(m_btnFontMedium, ID_HTREE_FONT_MEDIUM, IDI_HTREE_FONT_MEDIUM, FALSE);
	myInitRadio(m_btnFontLarge, ID_HTREE_FONT_LARGE, IDI_HTREE_FONT_LARGE, FALSE);
	myInitBorder(m_stcBorder[4]);
	myInitRadio(m_btnProjectView, ID_HTREE_PROJECT_VIEW, IDI_HTREE_PROJECT_VIEW, TRUE);
	myInitRadio(m_btnTreeView, ID_HTREE_TREE_VIEW, IDI_HTREE_TREE_VIEW, FALSE);
	myInitRadio(m_btnBranchView, ID_HTREE_BRANCH_VIEW, IDI_HTREE_BRANCH_VIEW, FALSE);

	//----- _xZkqqHx_iDhCiDiFiBfLiDeBiCmMjAlGjAkM_xHqqkZx_ -----
	DWORDVector vActionList;
	DWORDVector vMenuIdList;
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeC_xHqqkZx_
//	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT|FD_WHT_ON_SUB_DOCUMENT|FD_WHT_ON_LABEL|FD_WHT_ON_HI_TAG|FD_WHT_ON_TIME_LABEL|FD_WHT_ON_TIME | FD_WHT_MS_LBDOWN | FD_WHT_AC_MESSAGE);
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBjFlGiPjBiPoDiCmFiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_DOCUMENT|FD_WHT_ON_SUB_DOCUMENT|FD_WHT_ON_LABEL|FD_WHT_ON_HI_TAG|FD_WHT_ON_TIME_LABEL|FD_WHT_ON_TIME | FD_WHT_MS_LBDOWN | FD_WHT_AC_MESSAGE);
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiPoDiCmFiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBjBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_PROJECT | FD_WHT_ON_PROJECT| FD_WHT_MS_LBDOWN | FD_WHT_AC_SELECT);
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiJlKiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT | FD_WHT_MS_LBDOWN | FD_WHT_KY_SHIFT | FD_WHT_AC_LOWER);
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBjEhHiMgJiCmFiBeBiDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiPoDiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_BACKGROUND | FD_WHT_MS_LBDOWN | FD_WHT_KY_SHIFT | FD_WHT_AC_UPPER);
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBjBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
// 05.09.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT | FD_WHT_MS_LBDOWN | FD_WHT_KY_CTRL | FD_WHT_AC_SELECT);
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_ALL | FD_WHT_MS_LBDOWN | FD_WHT_KY_CTRL | FD_WHT_AC_SELECT);

	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBjBfDiImKjChFiCmFiDeOiDiKiDgCiDeOiCmMiPoKiNiHiCmNiBeBiDiBiDgKiDiFiBfL_xHqqkZx_ID=FD_MENU_WND_HTREE_VIEW_xZkqqHx_iBeC_xHqqkZx_
	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT | FD_MENU_WND_HTREE_VIEW_ON_PROJECT);
	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_DOCUMENT | FD_MENU_WND_HTREE_VIEW_ON_DOCUMENT);
	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_SUB_DOCUMENT | FD_MENU_WND_HTREE_VIEW_ON_SUB_DOCUMENT);
	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_HI_TAG | FD_MENU_WND_HTREE_VIEW_ON_TAG);
// 06.03.27 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_LABEL | FD_MENU_WND_HTREE_VIEW_ON_LABEL);
	vMenuIdList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_TIME_LABEL | FD_MENU_WND_HTREE_VIEW_ON_TIME_LABEL);
	m_pHistTree = new CFCWndHistoryTree();
	m_pHistTree->Create(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE,
// 06.03.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//						WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL,
						WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL|WS_HSCROLL,
						CRect(0,0,10,10),			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiLoJiMgAiBeC_xHqqkZx_
						this,						// _xZkqqHx_jAgFiDeFiDeDiDjDiDgIiDeFiBeC_xHqqkZx_
						ID_WND_HTREE_VIEW,			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						FFGetMainWnd()->GetWnd(),	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiBeC_xHqqkZx_
						TRUE,						// _xZkqqHx_iOkJjDkO_xHqqkZx_ALT_xZkqqHx_iBeC_xHqqkZx_
						&vActionList[0],			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiDiKiDfIiDgHiBeC_xHqqkZx_
						vActionList.size(),
						&vMenuIdList[0],			// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iDiKiDfIiDgHiBeC_xHqqkZx_
						vMenuIdList.size(),
						NULL);
//----- 06.03.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDiBiDgCiDfKiBfLiDfHiOpDiCkPiOoGiCoIiDeFiDeCiDjDiDgIiDeFiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
	FFGetMainWnd()->RegisterScrollWindow(m_pHistTree->m_hWnd);
//----- 06.03.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// OnIdle_xZkqqHx_iOjOiCmJjCmKjCgNiCkKjHiIiCoJiCoGiCkEiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
	FFGetApp()->AddOnIdleWindow(GetSafeHwnd());
	return 0;
} // CFCWndHtreeView::OnCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::OnDestroy ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
	//----- _xZkqqHx_iDhCiDiFiBfLiDeBiCpAjEgKiJpD_xHqqkZx_ -----
	m_pHistTree->DestroyWindow();
	delete m_pHistTree;
	m_pHistTree = NULL;

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCkJiCoHiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	FFGetMainWnd()->DeleteAutoAltWindow(m_cmbUpDownKind.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnMoveBefore.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnMoveAfter.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnMoveHigher.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnMoveLower.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnFontSmall.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnFontMedium.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnFontLarge.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnProjectView.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnTreeView.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_btnBranchView.m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_stcBorder[0].m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_stcBorder[1].m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_stcBorder[2].m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_stcBorder[3].m_hWnd);
	FFGetMainWnd()->DeleteAutoAltWindow(m_stcBorder[4].m_hWnd);

	// OnIdle_xZkqqHx_iOjOiCmMjCmKjCgNjDgPjIfOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	FFGetApp()->DelOnIdleWindow(GetSafeHwnd());
} // CFCWndHtreeView::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiClDiCoKiClNiCmGiCkLiMmEiCmOiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMiOoNjHnOiBeC_xHqqkZx_
 *			cx,cy	:_xZkqqHx_jAfGiClFiCkCiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiBgJ_xHqqkZx_m_pHistTree_xZkqqHx_iBgKiCmMiDiKiDfEiDeDiDfJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iJlKjAhNiCmJiCkIiCkPiCoJiDhLiDfOiDjDiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 *			CmbBx1	:_xZkqqHx_jHjKjHpAiInKjDkOiCmMjCfAiImKiCmMiOoNjHnOiBeCjBiAiNoM_xHqqkZx_/_xZkqqHx_jClHiNgM_xHqqkZx_/_xZkqqHx_iOjOiKnE_xHqqkZx_/_xZkqqHx_jDjJiBeC_xHqqkZx_
 *			Btn1	:_xZkqqHx_jHjKjHpAiInKjDkOiCpAiImIjBePiCmJiInKjDkOiBeC_xHqqkZx_
 *			Btn2	:_xZkqqHx_jHjKjHpAiInKjDkOiCpAiImIiMoDiCmJiInKjDkOiBeC_xHqqkZx_
 *			Btn3	:_xZkqqHx_jHjKjHpAiInKjDkOiCpAiPoDiImKiCmJiInKjDkOiBeC_xHqqkZx_
 *			Btn4	:_xZkqqHx_jHjKjHpAiInKjDkOiCpAiJlKiImKiCmJiInKjDkOiBeC_xHqqkZx_
 *			CmbBx2	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGiDfJiBfLiDiAiBeC_xHqqkZx_
 *			Rdo1	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCpAiPkMiCmJjAnNjCoIiBeC_xHqqkZx_
 *			Rdo2	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCpAjCiGiCmJjAnNjCoIiBeC_xHqqkZx_
 *			Rdo3	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCpAjBoFiCmJjAnNjCoIiBeC_xHqqkZx_
 *			Rdo4	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjAnNjCoIiBeC_xHqqkZx_
 *			Rdo5	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjAnNjCoIiBeC_xHqqkZx_
 *			Rdo6	:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjAnNjCoIiBeC_xHqqkZx_
 *
 *			A_xZkqqHx_iBgA_xHqqkZx_E _xZkqqHx_iCmNiBeBiClLiCoKiClMiCoKjFkKiKiEiClDiCoKiCmIiCkCjCfAiImKiCpAiOkGiClHiBeCjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFjNiCkK_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClDiCoKiCoJiNnLiCmNiBeBiClBiCmMjCfAiImKiCmFiJlKiNhDiBeBiPoDiNhDiCnGiInKjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *         --------------------------_xZkqqHx_iBhJjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFjNiCkKiNeMiCkCiPoKiNiHiBhK_xHqqkZx_---------------------------------
 *
 *                    A                 B           C              D                   E
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEkFiEjPiEjPiEjPiEjPiEjPiEkHiEkFiEjPiEjPiEjPiEkHiEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEkGiEjPiEjPiEjPiEkGiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_CmbBx1_xZkqqHx_iEkA_xHqqkZx_Btn1_xZkqqHx_iEkA_xHqqkZx_Btn2_xZkqqHx_iEkAiEkA_xHqqkZx_Btn3_xZkqqHx_iEkA_xHqqkZx_Btn4_xZkqqHx_iEkAiEkA_xHqqkZx_CmbBx2_xZkqqHx_iEkAiEkA_xHqqkZx_Rdo1_xZkqqHx_iEkA_xHqqkZx_Rdo2_xZkqqHx_iEkA_xHqqkZx_Rdo3_xZkqqHx_iEkAiEkA_xHqqkZx_Rdo4_xZkqqHx_iEkA_xHqqkZx_Rdo5_xZkqqHx_iEkA_xHqqkZx_Rdo6_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEkIiEjPiEjPiEjPiEkIiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                                                                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                                                                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_                                                                              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                                                                              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkGiEjPiEjP_xHqqkZx_                                                                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_                                                                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                                                                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_                                                                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *         --------------------------_xZkqqHx_iBhJjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFjNiCkKiLlHiCkCiPoKiNiHiBhK_xHqqkZx_---------------------------------
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_CmbBx1_xZkqqHx_iEkA_xHqqkZx_Btn1_xZkqqHx_iEkA_xHqqkZx_Btn2_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Btn3_xZkqqHx_iEkA_xHqqkZx_Btn4_xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_CmbBx2_xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkD_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Rdo1_xZkqqHx_iEkA_xHqqkZx_Rdo2_xZkqqHx_iEkA_xHqqkZx_Rdo3_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Rdo4_xZkqqHx_iEkA_xHqqkZx_Rdo5_xZkqqHx_iEkA_xHqqkZx_Rdo6_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkGiEjPiEjP_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *         -------------------------_xZkqqHx_iBhJiDfIiDeDiDgCiDgAiDgPiBfLiCmGiDeOiDiNiBfLiDfJiDhLiDfOiDjDiCmMjEhKjChFiBhK_xHqqkZx_----------------------------
 *
 *                     _xZkqqHx_iDfIiDeDiDgCiDgAiDgPiBfL_xHqqkZx_     _xZkqqHx_iDeOiDiNiBfLiDfJiDhLiDfOiDjD_xHqqkZx_
 *                         _xZkqqHx_iBkL_xHqqkZx_                _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiBkMiEkA_xHqqkZx_ _xZkqqHx_iBhO_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEkGiEjPiEjPiEkGiEkIiEjPiEkGiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_CmbBx1_xZkqqHx_iEkA_xHqqkZx_Btn1_xZkqqHx_iEkA_xHqqkZx_Btn2_xZkqqHx_iEkAiEkA_xHqqkZx_Btn3_xZkqqHx_iEkA_xHqqkZx_Btn4_xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEkIiEjPiEjPiEkIiEjPiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkGiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_CmbBx2_xZkqqHx_iEkAiEkA_xHqqkZx_Rdo1_xZkqqHx_iEkA_xHqqkZx_Rdo2_xZkqqHx_iEkA_xHqqkZx_Rdo3_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkIiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Rdo4_xZkqqHx_iEkA_xHqqkZx_Rdo5_xZkqqHx_iEkA_xHqqkZx_Rdo6_xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkGiEjPiEjP_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEkAiEkBiEkIiEjPiEkC_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkEiEkGiEjPiEkD_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *         -------------------------------------------------------------------------------------------
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::OnSize (UINT nType, int cx, int cy)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnSize(nType, cx, cy);

	// Create_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_CWnd::Create_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiInHiBeBiImIiJlKiCmMiPiIjHjNiCkKjFeLjHhG_xHqqkZx_.
	if (m_pHistTree == NULL) return;

	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	CRect rt;
	m_cmbUpDownKind.GetWindowRect(rt);
	long lCtrlHeight = rt.Height();
	long lCmbItemHeight = m_cmbUpDownKind.GetItemHeight(-1);

	long lIndex = 0;
	long x = 0;
	long y = GetTopBarHeight();
	long lBorderIndex = 0;

	for (lIndex = 0; lIndex != sizeof(s_aCtrls) / sizeof(s_aCtrls[0]); lIndex++)
	{
		// HistDraw_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_HistDraw_xZkqqHx_iCmFjFfMiOkGiDhEiDiJiDePiCkKiDeJiDhEiCmIiCoHiCmOiDfCiDjDiDgHiDiNiBfLiDiLiCpAiJeCiClHiBeC_xHqqkZx_
		if (FFHistViewDoc() == NULL && !s_aCtrls[lIndex].bIsShowOnDraw)
		{
			if (s_aCtrls[lIndex].lCtrlId != 0)
				GetDlgItem(s_aCtrls[lIndex].lCtrlId)->ShowWindow(SW_HIDE);
			continue;
		}

		if (x != 0)
		//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjEhKjChFiCkKiNlGjCfLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDePiDiLiBfLiDhGiCmMjFjNiCpAiMhGiOfKiBeC_xHqqkZx_
			long lGroupWidth = 0;
			for (long lC = 0; s_aCtrls[lIndex + lC].lCtrlId != 0; lC++)
				lGroupWidth += D2L(s_aCtrls[lIndex + lC].dCtrlWidth * lCtrlHeight);
			if (s_lCtrlGroupGap + x + lGroupWidth < cx)
			//----- _xZkqqHx_iOjPiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDePiDiLiBfLiDhGiCkKiDeFiDeCiDjDiDgIiDeFjFjNiCpAjClEiCkGiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhLiBfLiDfPiBfLiDiJiDeDiDjDiCpAjEhKjChFiBeC_xHqqkZx_
				m_stcBorder[lBorderIndex].MoveWindow(	x,
														y + s_lBorderChop,
														s_lCtrlGroupGap,
														lCtrlHeight - 2 * s_lBorderChop);
				lBorderIndex++;
				// _xZkqqHx_iDePiDiLiBfLiDhGiKnEiDeNiDiDiDgCiDhGjFkKiLpDiCkPiCoJiBeC_xHqqkZx_
				x += s_lCtrlGroupGap;
			} else
			//----- _xZkqqHx_iOjPiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDePiDiLiBfLiDhGiCkKiDeFiDeCiDjDiDgIiDeFjFjNiCpAjClEiCkGiCmEiClFiCnMiCkEiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOjPiCmMiNhDiCmMjAoGjDkKiCnGiInKjDkOiBeC_xHqqkZx_
				y += lCtrlHeight + s_lCtrlLineGap;
				x = 0;
			}
		}
		// _xZkqqHx_iOjPiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDePiDiLiBfLiDhGiCpAjEhKjChFiBeC_xHqqkZx_
		for (; s_aCtrls[lIndex].lCtrlId != 0; lIndex++)
		{
			long lWidth = D2L(s_aCtrls[lIndex].dCtrlWidth * lCtrlHeight);
			long lHeight = D2L(s_aCtrls[lIndex].dCtrlHeight * lCtrlHeight);
			GetDlgItem(s_aCtrls[lIndex].lCtrlId)->MoveWindow(CRect(x, y, x + lWidth, y + lHeight));
//----- 05.10.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			if (GetDlgItem(s_aCtrls[lIndex].lCtrlId)->IsKindOf(RUNTIME_CLASS(CComboBox)))
			//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkKiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHiCmMjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
				CComboBox* pBox = (CComboBox*)GetDlgItem(s_aCtrls[lIndex].lCtrlId);
				pBox->SetDroppedWidth(s_aCtrls[lIndex].dDroppedWidth * lCtrlHeight);
			}
//----- 05.10.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			x += lWidth;
		}
	}
	// _xZkqqHx_iOgDiCmBiClNiDhLiBfLiDfPiBfLiDiJiDeDiDjDiCpAiJeCiClHiBeC_xHqqkZx_
	for (;lBorderIndex < sizeof(m_stcBorder) / sizeof(m_stcBorder[0]); lBorderIndex++)
		m_stcBorder[lBorderIndex].MoveWindow(-10, -10, 1, 1);

	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDeBiDeDiDgFiDiAiNiCiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
	// MoveWindow_xZkqqHx_iCmFiDeBiDeDiDgFiDiAiNiCiCkKiDiKiDfKiDgCiDgHiClDiCoKiCoJiClNiCnPiBeC_xHqqkZx_
	m_cmbUpDownKind.SetItemHeight(-1, lCmbItemHeight);
	m_cmbZoom.SetItemHeight(-1, lCmbItemHeight);

	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLjGhLjBmMiCpAiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
	m_pHistTree->MoveWindow(CRect(0, y + lCtrlHeight, cx, cy));
} // CFCWndHtreeView::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnSelchangeHtreeCmbUpDownKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHtreeView::OnSelchangeHtreeCmbUpDownKind ()
{
	// m_cmbUpDownKind_xZkqqHx_iCkKjGlDiMpIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!::IsWindow(m_cmbUpDownKind.m_hWnd)) return;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiMlLiNnNiCmMiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vIdAndValue;
	CFCDlgHistoryMoveOpeList::GetHiMoveOpeList(vIdAndValue);
	// _xZkqqHx_iMlLiNnNiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIjAnNjCoIiCpAjCmKjCgNiBeC_xHqqkZx_
	FFGetMainWnd()->SendMessage(WM_USER_SET_HI_MOVE_OPERATION,
								(WPARAM)vIdAndValue[m_cmbUpDownKind.GetCurSel()].first,
								(LPARAM)vIdAndValue[m_cmbUpDownKind.GetCurSel()].second);
} // CFCWndHtreeView::OnSelchangeHtreeCmbUpDownKind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnUserOnIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnIdle_xZkqqHx_iCpAjCmKjCgNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJ_xHqqkZx_1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndHtreeView::OnUserOnIdle (WPARAM, LPARAM)
{
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjHeMiMpIiPpDjBnEiBeBiDfJiBfLiDiAjCgMiCmMjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	OnUpdateControl();
	return 1;
} // CFCWndHtreeView::OnUserOnIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHtreeView::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndHtreeView::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	struct My
	{
		static BOOL IsTargetId (DWORD dwId)
		{
			if (dwId != 0)
			{
				for (long lIndex = 0; lIndex != sizeof(s_aCtrls) / sizeof(s_aCtrls[0]); lIndex++)
					if (s_aCtrls[lIndex].lCtrlId == dwId)
						return TRUE;
			}
			return FALSE;
		}

		static DWORD GetTargetId (HWND hwnd)
		{
			// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCkKiDfOiBfLiDfBiDgCiDgHiCkJjClCiCnHiBeB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
			// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiCmIiCmHiBeBjFkBjAjEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCkKjAgFiOhBiKnGiMfHiCmJiCkAiCoJiPoKiNiHiCpA_xHqqkZx_
			// _xZkqqHx_iNgMjHlGiClFiCmEiBeBjAgFiDeFiDeCiDjDiDgIiDeFiCoAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
			DWORD dwId = (DWORD)GetDlgCtrlID(hwnd);
			if (IsTargetId(dwId))
				return dwId;
			if (GetParent(hwnd) != NULL)
			{
				DWORD dwIdParent = (DWORD)GetDlgCtrlID(GetParent(hwnd));
				if (IsTargetId(dwIdParent))
					return dwIdParent;
			}
			return dwId;
		}
	};
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupToolbarHint())
	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DWORD dwId = My::GetTargetId(HWND(wParam));
		if (dwId != 0)
			FFGetApp()->GetPopHint()->SetTargetInfo(dwId);
	}
	return 1;
} // CFCWndHtreeView::OnUserPursuerTextNeedInfo.
