#ifndef __ZoomCmbBoxTmpl_h
#define __ZoomCmbBoxTmpl_h

// ZoomCmbBoxTmpl.h : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_

#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetZoomListValue.
//#include "RegData.h"		// For GetRegFontStatic.
#include "UtilWin.h"		// For CloseImeStatus.
#include "FrameWnd.h"		// For FFGetMainWnd().
// 06.11.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "RegData.h"		// For g_pReg.
#include "CmbBoxOnKey.h"	// For CFCCmbBoxOnKey.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	CFCZoomCmbBoxTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiCfAiCmCiOjNiCmCiDeOiDiJiDfIiCpAiNoMjAkMiClHiCoJiClNiCnPiCmMiDgFiDjDiDhGiDiMiBfLiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER> class CFCZoomCmbBoxTmpl : public SUPER
{
// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjD_xHqqkZx_
public:
	CFCZoomCmbBoxTmpl ();
	virtual ~CFCZoomCmbBoxTmpl ();

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_
public:
	virtual BOOL	Initialize (DWORD dwZoomCtrlId,
								CWnd* pWndMessage,
								DWORD dwZoomMessage);
	virtual CFCCmbBoxOnKey*	GetZoomComboBox ();

protected:
	virtual void	OnUpdateControl ();
	virtual BOOL	CreateZoomComboBox () = 0;
// 06.11.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	InitZoomComboBox ();
	virtual BOOL	IsViewZoomEnable () const;
	virtual long	GetViewZoom256 () const;

// _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_
protected:
	virtual BOOL OnWndMsg (UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual BOOL OnCommand (WPARAM wParam, LPARAM lParam);

// _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDhNiDgCiDhGiKnGjAjE_xHqqkZx_
protected:
	virtual void OnSelchangeCmbZoom ();
	virtual void OnSetfocusCmbZoom ();
	virtual void OnKillfocusCmbZoom ();
	virtual LRESULT OnUserCmbBoxOnKey (WPARAM wParam, LPARAM lParam);

// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiBeC_xHqqkZx_
protected:
	CFCCmbBoxOnKey	m_cmbZoom;			// _xZkqqHx_iDfJiBfLiDiAjCgMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiBeC_xHqqkZx_
	long			m_lZoom256;			// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	DWORD			m_dwZoomCtrlId;		// _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	CWnd*			m_pWndMessage;		// _xZkqqHx_iDfJiBfLiDiAjCgMjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	DWORD			m_dwZoomMessage;	// _xZkqqHx_iDfJiBfLiDiAjCgMjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
// 06.11.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	BOOL			m_bIsZoomReverseCtrlWheel;	// _xZkqqHx_iDhKiDeDiBfLiDiLiDfJiBfLiDiAiCkKiLhEjDfNiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
}; // class CFCZoomCmbBoxTmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCZoomCmbBoxTmpl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::CFCZoomCmbBoxTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCZoomCmbBoxTmpl<SUPER>::CFCZoomCmbBoxTmpl ()
{
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	m_lZoom256 = 0;
} // CFCZoomCmbBoxTmpl<SUPER>::CFCZoomCmbBoxTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::~CFCZoomCmbBoxTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCZoomCmbBoxTmpl<SUPER>::~CFCZoomCmbBoxTmpl ()
{
} // CFCZoomCmbBoxTmpl<SUPER>::~CFCZoomCmbBoxTmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCZoomCmbBoxTmpl _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiPiIjHjNiCpAiNhDiCkEiBeCiDgDiBfLiDiLiDgPiBfLiCmJjBgHiCnNiNjOiCnMiCoKiClNiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwZoomCtrlId	:_xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pWndMessage		:_xZkqqHx_iDfJiBfLiDiAjCgMjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCZoomCmbBoxTmpl<SUPER>::Initialize (	DWORD dwZoomCtrlId,
											CWnd* pWndMessage,
											DWORD dwZoomMessage)
{
	// _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_dwZoomCtrlId = dwZoomCtrlId;
	// _xZkqqHx_iDfJiBfLiDiAjCgMjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	m_pWndMessage = pWndMessage;
	// _xZkqqHx_iDfJiBfLiDiAjCgMjFmPiNfIiCmMiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
	m_dwZoomMessage = dwZoomMessage;

	// _xZkqqHx_iJpMiNhDiDeMiBfLiCmG_xHqqkZx_ESC_xZkqqHx_iDeMiBfLiCpAiOoGjDlOiCmFiCkLiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
	m_cmbZoom.AddKey(VK_RETURN);
	m_cmbZoom.AddKey(VK_ESCAPE);
	// _xZkqqHx_jAjEjCgMiCpAiIlFiCkEiOhHjCoIiCmJiClHiCoJiBeC_xHqqkZx_
	m_cmbZoom.SetIsNumber(TRUE);

	// _xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	if (!CreateZoomComboBox()) return FALSE;

//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (int iC = 0; FFGetZoomListValue(m_dwZoomCtrlId, iC) != -1; iC++)
//	{
//		WString str;
//		str.Format(L"%d%%", FFGetZoomListValue(m_dwZoomCtrlId, iC));
//		FFAddString(&m_cmbZoom ,str);
//	}
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiPiJiKpKjBeJjBpAiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_cmbZoom.SetCurSel(-1);
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_lZoom256 = 0;
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfJiBfLiDiAjHhAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgFiDjDiDgDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	InitZoomComboBox();
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jAlDiPoNiPeJjHlJiBeC_xHqqkZx_
	return TRUE;
} // CFCZoomCmbBoxTmpl<SUPER>::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::GetZoomComboBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCCmbBoxOnKey* CFCZoomCmbBoxTmpl<SUPER>::GetZoomComboBox ()
{
	return &m_cmbZoom;
} // CFCZoomCmbBoxTmpl<SUPER>::GetZoomComboBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnUpdateControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjHeMiMpIiPpDjBnEiBeBiDfJiBfLiDiAjCgMiCmMjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCZoomCmbBoxTmpl<SUPER>::OnUpdateControl ()
{
	// _xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	m_cmbZoom.EnableWindow(IsViewZoomEnable());

//----- 06.11.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhKiDeDiBfLiDiLiDfJiBfLiDiAiCmMjFpLiMpMiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmNiDfJiBfLiDiAiDfCiDjDiDhLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	if (m_bIsZoomReverseCtrlWheel != g_pReg->GetIsZoomReverseCtrlWheel())
		InitZoomComboBox();
//----- 06.11.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFfMiOkGiCmMiDfJiBfLiDiAjCgMiCkKiBeBiOmAiNnLiCmGiInJiCmIiCoJiPoKiNiHiCmNiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiPeDjAlDiBeC_xHqqkZx_
	if (m_lZoom256 != GetViewZoom256())
	{
		m_lZoom256 = GetViewZoom256();
		long lZoom = D2L(double(m_lZoom256) / 2.56);
		//----- _xZkqqHx_jAnNjCoIiClDiCoKiCoJiDfJiBfLiDiAjCgMiCmJiIoKjEnEiLnPiCkCiDeBiDeDiDgFiDiAiCpAjAnNjCoIiClFiCmEiCkIiCkN_xHqqkZx_ -----
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		int iC;
//		for (iC = 0; FFGetZoomListValue(m_dwZoomCtrlId, iC) != -1; iC++)
//		{
//			if (lZoom <= FFGetZoomListValue(m_dwZoomCtrlId, iC)) break;
//		}
//		if (FFGetZoomListValue(m_dwZoomCtrlId, iC) == -1) iC--;
//		m_cmbZoom.SetCurSel(iC);
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		long lC;
		for (lC = 0; lC != FFGetZoomListCount(m_dwZoomCtrlId); lC++)
		{
			if (lZoom <= FFGetZoomListValue(m_dwZoomCtrlId, lC)) break;
		}
		if (lC == FFGetZoomListCount(m_dwZoomCtrlId)) lC--;
		if (!m_bIsZoomReverseCtrlWheel)
		//----- _xZkqqHx_iDhKiDeDiBfLiDiLiPiHjDfNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			lC = (FFGetZoomListCount(m_dwZoomCtrlId) - 1) - lC;
		}
		m_cmbZoom.SetCurSel(lC);
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
		WString str;
		str.Format(L"%d%%", lZoom);
		FFSetWindowText(&m_cmbZoom, str);
	}
} // CFCZoomCmbBoxTmpl<SUPER>::OnUpdateControl.

///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::CreateZoomComboBox
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCZoomCmbBoxTmpl<SUPER>::CreateZoomComboBox ()
//{
//	// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMiNiCiClDiBeC_xHqqkZx_
//	const int nDropHeight = 500;
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
//	SetButtonInfo(CommandToIndex(m_dwZoomCtrlId), m_dwZoomCtrlId, TBBS_SEPARATOR, 80);
//	//----- _xZkqqHx_iDfJiBfLiDiAjCgMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiNoMjAkM_xHqqkZx_ -----
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//	CRect rect;
//	GetItemRect(CommandToIndex(m_dwZoomCtrlId), &rect);
//	const int iHeight = rect.Height();
//	rect.top = 0;
//	rect.bottom = rect.top + nDropHeight;
//	if (!m_cmbZoom.Create(	CBS_DROPDOWN|WS_VISIBLE|WS_TABSTOP|CBS_AUTOHSCROLL,
//							rect, this, m_dwZoomCtrlId))
//	{
//		TRACE(_T("Failed to create combo-box\n"));
//		return FALSE;
//	}
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_cmbZoom.SetFont(g_pReg->GetRegFontStatic(FDFT_TOOLBAR));
//	m_cmbZoom.SetItemHeight(-1, iHeight - 6);
//	return TRUE;
//} // CFCZoomCmbBoxTmpl<SUPER>::CreateZoomComboBox.

//----- 06.11.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::InitZoomComboBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjHhAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgFiDjDiDgDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCZoomCmbBoxTmpl<SUPER>::InitZoomComboBox ()
{
	// _xZkqqHx_iDhKiDeDiBfLiDiLiDfJiBfLiDiAiCkKiLhEjDfNiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiCpAiDeMiDiDiDgCiDgAiClHiCoJiClNiCnPiBeBiDiBiDjDiDgPiBfLjFmPjAjEiCmJiLeMiJkPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	m_bIsZoomReverseCtrlWheel = g_pReg->GetIsZoomReverseCtrlWheel();
	// _xZkqqHx_iMlLiNnNiCmMiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_cmbZoom.ResetContent();
	if (!m_bIsZoomReverseCtrlWheel)
	//----- _xZkqqHx_iDhKiDeDiBfLiDiLiPiHjDfNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = FFGetZoomListCount(m_dwZoomCtrlId) - 1;
			 lC != -1; lC--)
		{
			WString str;
			str.Format(L"%d%%", FFGetZoomListValue(m_dwZoomCtrlId, lC));
			FFAddString(&m_cmbZoom ,str);
		}
	} else
	//----- _xZkqqHx_iDhKiDeDiBfLiDiLiLhEjDfNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (long lC = 0; lC != FFGetZoomListCount(m_dwZoomCtrlId); lC++)
		{
			WString str;
			str.Format(L"%d%%", FFGetZoomListValue(m_dwZoomCtrlId, lC));
			FFAddString(&m_cmbZoom ,str);
		}
	}
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiPiJiKpKjBeJjBpAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_cmbZoom.SetCurSel(-1);
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lZoom256 = 0;
} // CFCZoomCmbBoxTmpl<SUPER>::InitZoomComboBox.
//----- 06.11.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::IsViewZoomEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLjBkEiCmFiDfJiBfLiDiAiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiCkKiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCZoomCmbBoxTmpl<SUPER>::IsViewZoomEnable () const
{
	return TRUE;
} // CFCZoomCmbBoxTmpl<SUPER>::IsViewZoomEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::GetViewZoom256
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLjBkEiCmMiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiBeCiCfBiCfEiCfFiBiBiCfAiCePiCePiBjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCZoomCmbBoxTmpl<SUPER>::GetViewZoom256 () const
{
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	return m_lZoom256;
} // CFCZoomCmbBoxTmpl<SUPER>::GetViewZoom256.

/////////////////////////////////////////////////////////////////////////////
// CFCZoomCmbBoxTmpl _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnWndMsg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDiBiDgCiDfKiBfLiDfHiCpAjDlBiCkLiDgGiDeCiDfIiDhAiDgCiDgAiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	message	:_xZkqqHx_jBjHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			wParam	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiImLjBlGiCmMjCmHiJmBiPoOjFpBiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiImLjBlGiCmMjCmHiJmBiPoOjFpBiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_ 
 *			pResult	:WindowProc _xZkqqHx_iCmMjGnPiCoIjCgMiBeCiDiBiDgCiDfKiBfLiDfHiCmJiImLjBlGiClFiCnMiClHiBeC_xHqqkZx_
 *					 NULL _xZkqqHx_iCmMiPoKiNiHiCoAiCkAiCoIiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiClDiCoKiClNiCmGiCkLiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiBeCiClLiCoKiImIiKePiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiCmIiCkCiCmGiBeBiDiBiDgCiDfKiBfLiDfHiCkK_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjDmNiCkPiCoHiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
BOOL CFCZoomCmbBoxTmpl<SUPER>::OnWndMsg (UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BOOL bReturn = SUPER::OnWndMsg(message, wParam, lParam, pResult);

	switch (message)
	{
	case WM_USER_CMB_BOX_ON_KEY:	// _xZkqqHx_iDfJiBfLiDiAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmFiOpDjFhEiCpAiLjGiJmCiClDiCoKiClNiDeMiBfLiCkKiJjPiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
		if (wParam == m_dwZoomCtrlId)
			OnUserCmbBoxOnKey(wParam, lParam);
		return TRUE;
	}
	return bReturn;
} // CFCZoomCmbBoxTmpl<SUPER>::OnWndMsg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WM_COMMAND_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:WPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:LPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCkKiPiIjHjNiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCZoomCmbBoxTmpl<SUPER>::OnCommand (WPARAM wParam, LPARAM lParam)
{
	TRACE(_T("OnCommand %x %x\n"), HIWORD(wParam), LOWORD(wParam));
	switch (HIWORD(wParam))
	{
	case CBN_SELCHANGE:
		if (LOWORD(wParam) == m_dwZoomCtrlId)
		{
			OnSelchangeCmbZoom();
			return TRUE;
		}
		break;
	case CBN_SETFOCUS:
		if (LOWORD(wParam) == m_dwZoomCtrlId)
		{
			OnSetfocusCmbZoom();
			return TRUE;
		}
		break;
	case CBN_KILLFOCUS:
		if (LOWORD(wParam) == m_dwZoomCtrlId)
		{
			OnKillfocusCmbZoom();
			return TRUE;
		}
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	return SUPER::OnCommand(wParam, lParam);
} // CFCZoomCmbBoxTmpl<SUPER>::OnCommand.

/////////////////////////////////////////////////////////////////////////////
// CFCZoomCmbBoxTmpl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnSelchangeCmbZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiCmMiDiKiDfIiDgHiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCZoomCmbBoxTmpl<SUPER>::OnSelchangeCmbZoom ()
{
	// _xZkqqHx_iDfJiBfLiDiAjCgMiCpA_xHqqkZx_0_xZkqqHx_iCmJiBeCiMoDiCmF_xHqqkZx_OnUpdateControl_xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiCmJiNfIjAfGiCpAiLkNjAkHiClHiCoJiClNiCnPiBeC_xHqqkZx_
	m_lZoom256 = 0;
	WString str;
	int iSel = m_cmbZoom.GetCurSel();
	if (iSel == CB_ERR) return;
	FFGetLBText(&m_cmbZoom, iSel, str);
	DWORD dwZoom = wcstoul(str, NULL, 10);
	if (dwZoom != ULONG_MAX)
	{
		long lZoom = D2L(double(dwZoom) * 2.56);
		m_pWndMessage->PostMessage(m_dwZoomMessage, MAKEWPARAM(TRUE, TRUE), lZoom);
	}
} // CFCZoomCmbBoxTmpl<SUPER>::OnSelchangeCmbZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnSetfocusCmbZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDhEiDeIiBfLiDeKiDfIiCkKiCkAiClNiCmBiClNiCmGiCkLiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCZoomCmbBoxTmpl<SUPER>::OnSetfocusCmbZoom ()
{
	// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCpAjGlDiMpIiCmJiClHiCoJiBeCiClBiCkEiClFiCmIiCkCiCmGiBeB_xHqqkZx_BS/DEL_xZkqqHx_iCkKjHiIiCmIiCkCiBeC_xHqqkZx_
	FFGetMainWnd()->SetIgnoreAccelTable(TRUE);
} // CFCZoomCmbBoxTmpl<SUPER>::OnSetfocusCmbZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnKillfocusCmbZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkJiCoHiDhEiDeIiBfLiDeKiDfIiCkKjDkGiClAiClNiCmGiCkLiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCZoomCmbBoxTmpl<SUPER>::OnKillfocusCmbZoom ()
{
	// IME_xZkqqHx_iCkK_xHqqkZx_ON_xZkqqHx_iCmJiCmIiCmBiCmEiCkCiClNiPoKiNiHiCmNjFmCiClGiCoJiBeC_xHqqkZx_
	::CloseImeStatus(m_cmbZoom.m_hWnd);
	// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCpAjHeMiMpIiCmJjGnPiClHiBeC_xHqqkZx_
	FFGetMainWnd()->SetIgnoreAccelTable(FALSE);
} // CFCZoomCmbBoxTmpl<SUPER>::OnKillfocusCmbZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCZoomCmbBoxTmpl<SUPER>::OnUserCmbBoxOnKey
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCCmbBoxOnKey _xZkqqHx_iCmJjDgPjIfOiClDiCoKiClNiDeMiBfLiCkKjDpMjHmNiClDiCoKiClNiPoKiNiHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:CFCCmbBoxOnKey_xZkqqHx_iCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jDpMjHmNiClDiCoKiClNiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJ_xHqqkZx_1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
LRESULT CFCZoomCmbBoxTmpl<SUPER>::OnUserCmbBoxOnKey (WPARAM wParam, LPARAM lParam)
{
	ASSERT(wParam == m_dwZoomCtrlId);
	if (lParam == VK_RETURN)
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJ_xHqqkZx_EMTER_xZkqqHx_iDeMiBfLiCkKjDpMjHmNiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfJiBfLiDiAjCgMiCpA_xHqqkZx_0_xZkqqHx_iCmJiBeCiMoDiCmF_xHqqkZx_OnUpdateControl_xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiCmJiNfIjAfGiCpAiLkNjAkHiClHiCoJiClNiCnPiBeC_xHqqkZx_
		m_lZoom256 = 0;
		WString str;
		FFGetWindowText(&m_cmbZoom, str);
		DWORD dwZoom = wcstoul(str, NULL, 10);
		if (dwZoom != ULONG_MAX)
		{
			long lZoom = D2L(double(dwZoom) * 2.56);
			m_pWndMessage->PostMessage(m_dwZoomMessage, TRUE, lZoom);
		}
// 05.06.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		FFGetMainWnd()->GetWnd()->SetFocus();
	} else
	if (lParam == VK_ESCAPE)
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJ_xHqqkZx_ESC_xZkqqHx_iDeMiBfLiCkKjDpMjHmNiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		m_lZoom256 = 0;
		FFGetMainWnd()->GetWnd()->SetFocus();
	}
	return 1;
} // CFCZoomCmbBoxTmpl<SUPER>::OnUserCmbBoxOnKey.

#endif//__ZoomCmbBoxTmpl_h
